<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $AcessoComObj;
if(!$AcessoComObj) {
	class AcessoCom extends QueryCom {
		function get_item_acesso_corrente($arguments=array()) {
			$query = 
			'select item_acesso_id,
				   item_acesso_pai,
				   item_acesso_cod,
				   descricao,
				   dll_name,
				   cod_portal,
				   exported_function,
				   act_caption,
				   act_enabled,
				   act_visible,
				   act_hint,
				   act_image,
				   act_shortcut,
				   act_tag,
				   web_url,
				   web_url_image,
				   web_target,
				   ordem,
				   separar,
				   publico,
				   ajuda_id
			  from acesso.v$item_acesso_corrente_web
			 where 1=1 
			   and nvl(decode(cod_portal,\'KMM\',\'-1\',cod_portal),\'-1\') in (nvl(\''.$arguments['cod_portal'].'\',\'-1\'),\'-1\')';
			if(strlen(trim($arguments["ITEM_ACESSO_PAI"])))
				$query .= ' and item_acesso_pai = '.$arguments["ITEM_ACESSO_PAI"];
			if(strlen(trim($arguments["item_acesso_pai"])))
				$query .= ' and item_acesso_pai = '.$arguments["item_acesso_pai"];
			$query .= " order by ordem ";
			
			//print($query);
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		
		function get_usuario_acesso($arguments=array()) {
			$query = 
			'select u.email,
				   u.usuario,
				   u.date_insert,
				   u.user_insert,
				   u.date_update,
				   u.user_update,
				   u.site,
				   u.apelido,
				   u.nome,
				   u.sexo,
				   u.telefone_ddd,
				   u.telefone,
				   u.celular_ddd,
				   u.celular,
				   u.data_nascimento,
				   u.pais_id,
				   u.cep,
				   u.logradouro,
				   u.numero,
				   u.complemento,
				   u.bairro,
				   u.cidade,
				   u.uf,
				   u.leitor_impresso,
				   u.escolaridade,
				   u.faixa_salarial,
				   u.administrador,
				   u.newsletter, 
				   u.recebe_promocoes, 
				   u.noticias_destaque,
				   u.interesse,
				   u.produto,
				   u.sobrenome
			  from acesso.v$usuario u
			 inner join site.v$portal p
			         on p.grupo_id = u.grupo_id
			 where 1=1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and p.cod_portal = \''.$arguments[cod_portal].'\'';
			if(strlen(trim($arguments['email'])))
				$query .= ' and upper(u.email) = upper(\''.$arguments[email].'\')';
			 if(strlen(trim($arguments[usuario])))
			   	$query .= ' and u.usuario like \''.$arguments[usuario].'\'';
			 $query .= ' order by u.email ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		
		function get_total_usuarios($arguments=array(),$resulttype='array') {
			$query = 
			'select count(*) as total 
			  from acesso.v$usuario u
			 inner join site.v$portal p
			         on p.cod_portal = u.cod_portal
			 where 1=1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and u.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['grupo_id'])))
				$query .= ' and p.grupo_id = '.$arguments['grupo_id'].'';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query,$resulttype);
		}		
		
		function get_nivel_acesso($arguments=array(),$resulttype='array') {
			$query = 
			'select n.nivel_acesso,
				   n.descricao,
				   n.date_insert,
				   n.user_insert,
				   n.date_update,
				   n.user_update,
				   n.site
			  from acesso.v$nivel_acesso n
			 where 1=1 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query,$resulttype);
		}
		
		function get_usuario($arguments=array(),$resulttype='array') {
			
			$query = 
			'select u.email,
				   u.cod_portal,
				   pr.descricao portal,
				   u.usuario,
				   to_char(u.date_insert,\'dd/mm/yyyy hh24:mi:ss\') date_insert,
				   u.user_insert,
				   to_char(u.date_update,\'dd/mm/yyyy hh24:mi:ss\') date_update,
				   u.user_update,
				   u.site,
				   u.apelido,
				   u.nome,
				   u.sexo,
                   case 
                      when u.sexo = 1 then \'Feminino\'
                      else \'Masculino\'
                   end sexo_descricao,
				   u.telefone_ddd,
				   u.telefone,
				   u.celular_ddd,
				   u.celular,
				   to_char(u.data_nascimento,\'dd/mm/yyyy hh24:mi:ss\') data_nascimento,
                   floor((sysdate-u.data_nascimento)/365) idade,
				   u.pais_id,
				   u.cep,
				   u.logradouro,
				   u.numero,
				   u.complemento,
				   u.bairro,
				   u.cidade,
				   u.uf,
				   u.leitor_impresso,
				   u.escolaridade,
				   u.faixa_salarial,
				   u.administrador,
				   u.account_status,
				   u.bloqueado,
                   p.descricao pais,
                   u.data_nascimento,
				   u.cpfcnpj,
				   u.rg,
				   u.inscricao_estadual,
				   u.comercial_ddd,
				   u.comercial,
				   u.fax_ddd,
				   u.fax,
				   u.responsavel,
				   u.newsletter,
				   u.profissao,
				   u.interesse,
				   u.produto,
				   u.sobrenome,
				   u.matricula,
				   u.localidade_id,
				   u.cod_funcionario
				   
			  from acesso.v$usuario u
		 	 inner join site.v$portal pr
			         on pr.cod_portal = u.cod_portal
             left join cep.pais p
                     on u.pais_id = p.pais_id
		     left join acesso.v$usuario_escolaridade ue 
               		 on ue.escolaridade_id = u.escolaridade			 
			 where 1=1 ';
			 if(strlen(trim($arguments['grupo_id']))) 
			   $query .= ' and u.grupo_id = '.$arguments['grupo_id'];
			 if(strlen(trim($arguments['cod_portal']))) 
			   $query .= ' and upper(u.cod_portal) like upper(\''.$arguments['cod_portal'].'%\') ';
			 if(strlen(trim($arguments['email']))) 
			   $query .= ' and upper(u.email) like upper(\''.$arguments['email'].'%\') ';
		     if(strlen(trim($arguments['email_exato']))) 
			   $query .= ' and upper(u.email) = upper(\''.$arguments['email_exato'].'\') ';
			 if(strlen(trim($arguments['administrador'])))
			   $query .= ' and u.administrador = '.$arguments['administrador'];
			 if(strlen(trim($arguments['bloqueado'])))
			   $query .= ' and u.bloqueado = '.$arguments['bloqueado'];
			 if(strlen(trim($arguments['usuario'])))
			   $query .= ' and upper(u.usuario) like upper(\''.$arguments['usuario'].'\') ';
			 if(strlen(trim($arguments['data_inicial'])))
			   $query .= ' and trunc(u.date_insert) >= \''.$arguments['data_inicial'].'\' ';
			 if(strlen(trim($arguments['data_final'])))
			   $query .= ' and trunc(u.date_insert) <= \''.$arguments['data_final'].'\' ';
             if(strlen(trim($arguments['nome'])))
			   $query .= ' and upper(u.nome) like upper(\'%'.$arguments['nome'].'%\') ';
             if(strlen(trim($arguments['apelido'])))
			   $query .= ' and upper(u.apelido) like upper(\'%'.$arguments['apelido'].'%\') ';
             if(strlen(trim($arguments['data_nasc'])))
			   $query .= ' and to_char(u.data_nascimento,\'dd/mm\') = \''.$arguments['data_nasc'].'\'';
             if(strlen(trim($arguments['data_aniversario'])))
			   $query .= ' and to_char(u.data_nascimento,\'dd/mm\') = \''.$arguments['data_aniversario'].'\'';
			 if(strlen(trim($arguments['ativo']))) 
			   $query .= ' and u.ativo = '.$arguments['ativo'];
  		     if(strlen(trim($arguments['cod_ativacao'])))
			   $query .= ' and u.cod_ativacao = \''.$arguments['cod_ativacao'].'\' ';
			 if(strlen(trim($arguments['cpfcnpj'])))
			   $query .= ' and u.cpfcnpj = \''.$arguments['cpfcnpj'].'\' ';
			 if(strlen(trim($arguments['pessoa']))){
			  	if($arguments['pessoa'] == 'Fisica' )
			   	   $query .= ' and length(u.cpfcnpj) <= 11 ';
				else
					$query .= ' and length(u.cpfcnpj) > 11 ';
			 }
			 if(is_null($arguments['cod_portal']))
			  	$query .= ' and 1 = null';
								
			 $query .= ' order by u.email ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);		
				
			
			//print($query);
			return $this->getResult($query,$resulttype);
		
		}
		
		
		/* Busca os paises cadastrados */
		function get_pessoa($arguments=array(),$resulttype='array') {
			$query = '
				select cod_pessoa,
					   tipo_pessoa,
					   cnpj_cpf,
					   identificador,
					   inscricao_estadual,
					   razao_social,
					   cliente
					   cdo_atividade_fiscal
				from kss.v$pessoa p
				 where 1=1';
			if(strlen(trim($arguments['cnpj'])))
			   $query .= ' and p.cnpj_cpf = \''.$arguments['cnpj'].'\'';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca os paises cadastrados */
		function get_pais($arguments=array(),$resulttype='array') {
			$query = '
				select pais_id,
					   descricao
				  from cep.pais
				 where 1=1		
				 order by descricao
			 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Retorna as escolaridades cadastradas */
		function get_escolaridade($arguments=array()){
			$query = '
					select ue.escolaridade_id,
						   ue.descricao
					from acesso.v$usuario_escolaridade ue
					where 1=1';
			 if(strlen(trim($arguments['escolaridade_id'])))
			 	$query .= ' and escolaridade_id = '.$arguments['escolaridade_id'];
			
			 $query .= ' order by ue.escolaridade_id';

			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
		    return $this->getResult($query);
		}
		
		/* Retorna as escolaridades cadastradas */
		function get_faixa_salarial($arguments=array()){
			$query = '
					select fs.faixa_salarial_id,
						   fs.descricao
					from acesso.v$usuario_faixa_salarial fs
					where 1=1
					
					order by fs.faixa_salarial_id
			';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query);
		}
		
		
		/**
		 * Efetua o login no site 
		 */
		function login($arguments=array(),$resulttype='array') {
			//$this->autoconnect(array(manter_cookies => true));

			$qrAcesso = $this->get_usuario_acesso(array(email => $arguments[email], cod_portal => $_SESSION['cod_portal']));

			$retorno = array(sucesso => "0");
			
			if(count($qrAcesso) != 1) {
				$retorno['mensagem'] = 'Login ou senha invlidos.';
			} elseif(count($qrAcesso) == 1) {

				$arguments['usuario'] = $qrAcesso[0]['USUARIO'];

				$conn = CreateObject("portal._class.consulta.site");

				$arguments['ativo'] = $conn->get_portal_parametro(array(cod_portal => $_SESSION['cod_portal'],
																		cod_parametro => 'USUARIO_ATIVO'
																	  ));

				//verifica se  necessrio o usurio estar ativo para logar
				if(strlen(trim($arguments['ativo']))){

					$qrUsuario = $this->get_usuario(array(usuario => $qrAcesso[0]['USUARIO'],
														  ativo => 1,
														  cod_portal => $_SESSION['cod_portal']
														));

					if(!count($qrUsuario)){//se o usurio no estiver ativo
						$retorno['mensagem'] = 'O usurio no existe ou ainda no est ativo!';
					}else//se o usuario esta ativo ento verifica senha
						$retorno = $this->valida_acesso($arguments);
						
				}else{ //se no  necessrio o usuario estar ativo entao apenas verifique a senha

					$retorno = $this->valida_acesso($arguments);
				}
				
			}
			
			if($retorno['sucesso'] == 1 && $arguments['salvar_senha'] == 1) {
				@setcookie("site_email_login",$arguments['email'],time()+60*60*24*365*5,'/');
				@setcookie("site_senha_login",$arguments['senha'],time()+60*60*24*365*5,'/');
			} else {
				@setcookie("site_email_login","",time()+60*60*24*365*5,'/');
				@setcookie("site_senha_login","",time()+60*60*24*365*5,'/');
			}
			return $this->toWddx($retorno);
		}
		
		
		/**
		 * Efetua o login no site 
		 */
		function login_sistema($arguments=array(),$resulttype='array') {
			//$this->autoconnect(array(manter_cookies => true));
			
			if( strpos($arguments['email'],'@') === false ){
				$usuario_sistema = 1;	
			}else{
				$usuario_sistema = 0;
				$qrAcesso = $this->get_usuario_acesso(array(email => $arguments[email], cod_portal => $_SESSION['cod_portal']));
			}

			$retorno = array(sucesso => "0");
			
			/* se nao tiver um registro de usuario na tabela de usuarios
			 * do portal e se no for um usuario de sistema, ex: kmm_auditoria
			 * ento retorna login invlido
			 */
			if(count($qrAcesso) != 1 && $usuario_sistema == 0) { 
				$retorno['mensagem'] = 'Login ou senha invlidos.';
			} elseif(count($qrAcesso) == 1) { 
			   /* se a contagem de usuarios na tabela do portal for igual a 1 
			    * prossegue com o login normal do sisgoon, caso contrario
			    * entrar no proximo else pois o usuario  de sistema e no do sisgoon
			    */

				$arguments['usuario'] = $qrAcesso[0]['USUARIO'];

				$conn = CreateObject("portal._class.consulta.site");

				$arguments['ativo'] = $conn->get_portal_parametro(array(cod_portal => $_SESSION['cod_portal'],
																		cod_parametro => 'USUARIO_ATIVO'
																	  ));

				//verifica se  necessrio o usurio estar ativo para logar
				if(strlen(trim($arguments['ativo']))){

					$qrUsuario = $this->get_usuario(array(usuario => $qrAcesso[0]['USUARIO'],
														  ativo => 1,
														  cod_portal => $_SESSION['cod_portal']
														));

					if(!count($qrUsuario)){//se o usurio no estiver ativo
						$retorno['mensagem'] = 'O usurio no existe ou ainda no est ativo!';
					}else//se o usuario esta ativo ento verifica senha
						$retorno = $this->valida_acesso($arguments);
						
				}else{ //se no  necessrio o usuario estar ativo entao apenas verifique a senha
					$retorno = $this->valida_acesso($arguments);
				}
				/* se for usuario de sistema procede com um
				 * login diferenciado sem buscar os dados na tabela de
				 * usuarios do sisgoon, fazendo o login diretamente
				 */
			}else{ 
				$arguments['usuario_sistema'] = 1;
				$arguments['usuario'] = $arguments['email'];
				$retorno = $this->valida_acesso($arguments);
			}
			
			if($retorno['sucesso'] == 1 && $arguments['salvar_senha'] == 1) {
				@setcookie("site_email_login",$arguments['email'],time()+60*60*24*365*5,'/');
				@setcookie("site_senha_login",$arguments['senha'],time()+60*60*24*365*5,'/');
			} else {
				@setcookie("site_email_login","",time()+60*60*24*365*5,'/');
				@setcookie("site_senha_login","",time()+60*60*24*365*5,'/');
			}
			return $this->toWddx($retorno);
		}
		
		/**
		 * Efetua o login no portal 
		 */
		function login_portal($arguments=array(),$resulttype='array') {
			
			$retorno = array(sucesso => "0");
			
			$arguments['usuario_sistema'] = 1;
			$retorno = $this->valida_acesso($arguments);
	
			
			if($retorno['sucesso'] == 1 && $arguments['salvar_senha'] == 1) {
				@setcookie("site_email_login",$arguments['email'],time()+60*60*24*365*5,'/');
				@setcookie("site_senha_login",$arguments['senha'],time()+60*60*24*365*5,'/');
			} else {
				@setcookie("site_email_login","",time()+60*60*24*365*5,'/');
				@setcookie("site_senha_login","",time()+60*60*24*365*5,'/');
			}
			
			return $this->toWddx($retorno);
		}
		
		
		
		/**
		 * Efetua o login no site 
		 */
		function login_usuario($arguments=array()) {
//			$this->autoconnect(array(manter_cookies => true));
			$retorno = array(sucesso => 0);
			if(count($qrAcesso) != 1) {
				$retorno['mensagem'] = 'Login ou senha invalidos!';
			} elseif(count($qrAcesso) == 1) {
				list($teste,$message) = $this->testa_senha(array(
										usuario => $arguments['usuario'],
										senha	=> $arguments['senha']));
				switch($teste) {
					case 1:
						$retorno['sucesso'] = 1;
						$retorno['mensagem'] = 'Login efetuado com sucesso!';
						$_SESSION['usuario'] = $arguments['usuario'];
						$_SESSION['senha'] = $arguments['senha'];
						$this->reconnect();
						break;
					case 3:
						$retorno['mensagem'] = 'Usurio bloqueado, entre em contato com os administradores do sistema!';
						break;
					case 2:
						$retorno['mensagem'] = 'Login ou senha invlidos.';
						break;
					case 4:
						$retorno['mensagem'] = $message;
						break;
					default:
						$retorno['mensagem'] = 'No foi possvel conectar-se, entre em contato com os administradores do sistema!';
						break;
				}			
			}
			return $retorno;
		}
		
		/**
		 * Valida o usuario e senha, e se OK faz o login do usurio
		 */
		function valida_acesso($arguments=array()){
						
			
			list($teste,$message) = $this->testa_senha(array(
										usuario => $arguments['usuario'],
										senha	=> $arguments['senha'],
										dsn		=> $arguments['dsn']));

			
				switch($teste) {
					case 1:
						$retorno['sucesso'] = 1;
						$retorno['mensagem'] = 'Login efetuado com sucesso!';

						if($arguments['usuario_sistema'] != 1){
							$qrAcesso = $this->get_usuario_acesso(array(email => $arguments['email'], cod_portal => $_SESSION['cod_portal']));
							$_SESSION['usuario'] = $qrAcesso[0]['USUARIO'];
							$_SESSION['apelido'] = $qrAcesso[0]['APELIDO'];
							$_SESSION['administrador'] = $qrAcesso[0]['ADMINISTRADOR'];
							$_SESSION['dados'] = $qrAcesso;
						}else{
							$_SESSION['administrador'] = 1;
							$_SESSION['usuario'] = strtoupper($arguments['usuario']);
							$_SESSION['apelido'] = strtoupper($arguments['usuario']);
						}
						
						$_SESSION['email'] = $arguments['email'];
						$_SESSION['senha'] = $arguments['senha'];
						
						$this->reconnect();
						break;
					case 3:
						$retorno["sucesso"] = 0;
						$retorno['mensagem'] = 'Usurio bloqueado, entre em contato com os administradores do sistema!';
						break;
					case 2:
						$retorno["sucesso"] = 0;
						$retorno['mensagem'] = 'Login ou senha invlidos.';
						break;
					case 4:
						$retorno["sucesso"] = 0;
						$retorno['mensagem'] = $message;
						break;
					default:
						$retorno["sucesso"] = 0;
						$retorno['mensagem'] = 'No foi possvel conectar-se, entre em contato com os administradores do sistema!';
						break;
				}
				
				//print($retorno);
				return $retorno;
		}
		
		/**
		 * Testa se a senha fornecida  valida para o usuario
		 */
		function testa_senha($arguments) {
			/*
				1 - Login OK
				2 - Usuario ou senha invalidos
				3 - Usuario Bloqueado
				4 - Erro Desconhecido
			*/

			$dsn = strlen(trim($arguments['dsn'])) ? $arguments['dsn'] : $_SESSION['dsn'];

			$conexao = @connect($dsn,$arguments['usuario'],$arguments['senha']);
			
			if($conexao["CONNECTED"] === false) {
				switch($conexao["ERROR"]["code"]) {
					case 28000:
						return array(3,"Usuario bloqueado, entre em contato com nossa equipe para a liberao!");
						break;
					case 1017:
						return array(2,"Usuario ou senha invalidos!");
						break;
					default:
						return array(4,$conexao["ERROR"]["message"]);
						break;
						
				}
			} else {
				return array(1,"Login OK");
			}
		}
		/**
		 * Efetua Logoff do sistema
		 */
		function logoff($arguments=array()) {
			
			switch($_SESSION['dsn']){
				case 'JMNEWS01.JMNEWS.COM.BR':   $senha = 'kmm2007';break;
				case 'KMM.KMM.COM.BR':           $senha = 'kmm2006';break;
				case 'COOP.COOPAGRICOLA.COM.BR': $senha = 'kmm2006';break;
				default :                        $senha = 'kmm2007';
			}
			
			$_SESSION['usuario'] = 'PUBLICO';
			$_SESSION['senha'] = $senha;
			$_SESSION['email'] = '';
			$_SESSION['apelido'] = '';
			$_SESSION['administrador'] = 0;
			if(!$arguments['manter_cookies']) {
				setcookie("site_email_login","",time()+60*60*24*365*5,'/');
				setcookie("site_senha_login","",time()+60*60*24*365*5,'/');
			}

			$this->reconnect();

//			new dBug(debug_backtrace());
			return array();
		}

		/**
		 * Efetua Logoff do sistema
		 */
		function autoconnect($arguments=array()) {
			
			switch($_SESSION['dsn']){
				case 'JMNEWS01.JMNEWS.COM.BR':  $senha = 'kmm2007';break;
				case 'KMM.KMM.COM.BR':          $senha = 'kmm2006';break;
				default :                       $senha = 'kmm2007';
			}


			if(!strlen(trim($_SESSION['usuario']))) {
				$_SESSION['usuario'] = 'PUBLICO';
				$_SESSION['senha'] = $senha;
				$_SESSION['email'] = '';
				$_SESSION['apelido'] = '';
				$_SESSION['administrador'] = 0;
			}
			if(!$arguments['manter_cookies']) {
				setcookie("site_email_login","",time()+60*60*24*365*5,'/');
				setcookie("site_senha_login","",time()+60*60*24*365*5,'/');
			}
			$this->reconnect();
//			new dBug($_SESSION['conexao']);
			return array();
		}
		
		function reconnect() {
			$_SESSION['conexao'] = @connect($_SESSION['dsn'],$_SESSION['usuario'],$_SESSION['senha']);
			$this->setConexao($_SESSION['conexao']);
		}

		/* Busca os modulos de acesso */
		function get_modulo($arguments=array(),$resulttype='array') {
			$query = '
				select m.modulo_id,
					   m.descricao,
					   m.role,
					   to_char(m.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   m.user_insert,
					   to_char(m.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   m.user_update,
					   m.site
				  from acesso.v$modulo_web m
				 where 1=1
			 ';
			if(strlen(trim($arguments['modulo_id'])))
				$query .= ' and m.modulo_id = '.$arguments['modulo_id'];
			if(strlen(trim($arguments['descricao'])))
			 	$query .= ' and m.descricao like \'%'.$arguments['descricao'].'%\'';
			 
			$query .= ' order by m.descricao ';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);	
				
			//print($query);				
		    return $this->getResult($query,$resulttype);
		}

		/* Busca os modulos cadastrados para o usuario */
		function get_modulo_usuario($arguments=array(),$resulttype='array') {
			$query = '
				select mu.modulo_id,
					   mu.usuario,
					   mu.nivel_acesso,
					   to_char(mu.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   mu.user_insert,
					   to_char(mu.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   mu.user_update,
					   mu.site
				  from acesso.v$modulo_usuario mu
				 where 1=1
			 ';
			if(strlen(trim($arguments['usuario'])))
				$query .= ' and mu.usuario = \''.$arguments['usuario'].'\'';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and mu.cod_portal = \''.$arguments['cod_portal'].'\'';
			$query .= ' order by mu.modulo_id';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}		



		/* Retorna os usurios atualmente conectados */
		function get_usuarios_conectados($arguments=array(),$resulttype='array') {
			$query = '
				select ap.acesso_id,
					   max(a.profundidade) paginas_acessadas,
					   nvl(ap.usuario,\'No cadastrado\') usuario,
					   nvl(u.nome,\'No cadastrado\') as nome, a.ip,
					   max(ap.data) ultimo_acesso,
					   count(*) over () total_sessoes,
					   sum(count(*)) over () total,
					   round((max(ap.data)  - min(a.primeiro_acesso))*1440) as tempo_conectado
					from acesso.v$acesso_profundidade ap
				   inner join acesso.v$acesso a
					   on a.acesso_id = ap.acesso_id
				   left join acesso.v$usuario u
						   on u.email = ap.usuario    
				   where data >= sysdate - '.$arguments['minutos'].'/1440
					 and ap.cod_portal = \''.$arguments['cod_portal'].'\'
				   group by ap.usuario, u.nome, ap.acesso_id, a.ip
				   order by (max(ap.data)  - min(a.primeiro_acesso)) desc
			 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}

		/* Busca as profundidades de acesso */
		function get_acesso_profundidade($arguments=array(),$resulttype='array') {
			$query = '
				select ap.profundidade_id,
					   to_char(ap.data,\'dd/mm/yyyy hh24:mi:ss\') as data,
					   ap.url,
					   ap.usuario,
					   ap.hits,
					   ap.tempo_processamento,
					   ap.cod_setor,
					   ps.descricao as setor
				  from acesso.v$acesso_profundidade ap
				 inner join site.v$portal_setor ps
				         on ap.cod_setor = ps.cod_setor
						and ap.cod_portal = ps.cod_portal
				 where 1=1
			 ';
			if(strlen(trim($arguments['acesso_id'])))
				$query .= ' and ap.acesso_id = '.$arguments['acesso_id'];
			$query .= ' order by ap.acesso_id,ap.data ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca o numero de acessos do portal */
		function get_acessos_dia($arguments=array(),$resulttype='array') {
			$query = '
				select count(a.acesso_id) acessos,
				       nvl(sum(a.profundidade),0) paginas,
					   to_char(trunc(hr.data),\'dd/mm/yyyy hh24:mi:ss\') as  data,
					   to_char(hr.data,\'dd/mm/yyyy\') data_char
				from (select to_date(\''.$arguments['data_inicial'].'\',\'dd/mm/yyyy\')+level-1 data
							 from dual
							connect by to_date(\''.$arguments['data_inicial'].'\',\'dd/mm/yyyy\')+level-1 <= trunc(to_date(\''.$arguments['data_final'].'\',\'dd/mm/yyyy\'))
				
				) hr
				left join acesso.v$acesso a
				   on hr.data = trunc(a.primeiro_acesso)
			      and a.cod_portal = \''.$arguments['cod_portal'].'\'
			   group by trunc(hr.data),to_char(hr.data,\'dd/mm/yyyy\')
			   order by trunc(hr.data)

			 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca grupo de modulos administrativos e de objetos	*/
		function get_modulo_acesso($arguments=array(),$resulttype='array') {
			$query = 'select modulo_id,
						   modulo_objeto_id,
						   modulo_item_acesso_id,
						   nome,
						   descricao,
						   date_insert,
						   user_insert,
						   date_update,
						   user_update,
						   site
					  from acesso.v$modulo_acesso
				     where 1=1';
			
			if(strlen(trim($arguments['modulo_id'])))
  			    $query .= ' and modulo_id = '.$arguments['modulo_id'];
			if(strlen(trim($arguments['modulo_objeto_id'])))
				$query .= ' and modulo_objeto_id = '.$arguments['modulo_objeto_id'];
			if(strlen(trim($arguments['modulo_item_acesso_id'])))
  			    $query .= ' and modulo_item_acesso_id = '.$arguments['modulo_item_acesso_id'];
			
			$query .= ' order by nome';
					  
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca itens de acesso do mdulo	*/
		function get_item_acesso_modulo($arguments=array(),$resulttype='array') {
			$query = 'select iam.item_acesso_id,
						     iam.modulo_id,
						     iam.nivel_minimo,
						     ia.descricao,
							 ia.item_acesso_pai,
							 m.descricao as modulo
									 
					 from acesso.v$item_acesso_modulo iam
					 inner join acesso.v$item_acesso ia on ia.item_acesso_id = iam.item_acesso_id
					 inner join acesso.v$modulo_web m on m.modulo_id = iam.modulo_id
				     where 1=1';
			
			if(strlen(trim($arguments['modulo_id'])))
  			    $query .= ' and iam.modulo_id = '.$arguments['modulo_id'];
			if(strlen(trim($arguments['item_acesso_id'])))
				$query .= ' and iam.item_acesso_id = '.$arguments['item_acesso_id'];
					  
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca itens de acesso	*/
		function get_item_acesso($arguments=array(),$resulttype='array') {
			$query = 'select item_acesso_id,
							   item_acesso_pai,
							   item_acesso_cod,
							   descricao,
							   dll_name,
							   exported_function,
							   act_hint,
							   web_url,
							   web_url_image,
							   web_target,
							   ordem,
							   separar,
							   publico
						  from acesso.v$item_acesso
				     where 1=1';
			
			if(strlen(trim($arguments['item_acesso_id'])))
  			    $query .= ' and item_acesso_id = '.$arguments['item_acesso_id'];
			if(strlen(trim($arguments['item_acesso_pai'])))
				$query .= ' and item_acesso_pai = '.$arguments['item_acesso_pai'];
			if(strlen(trim($arguments['descricao'])))
				$query .= ' and upper(descricao) like upper(\'%'.$arguments['descricao'].'%\')';
				
			$query .= ' order by descricao';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca itens de acesso level	*/
		function get_item_acesso_level($arguments=array(),$resulttype='array') {
			$query = 'select i.item_acesso_id,
						     i.item_acesso_pai,
						     i.descricao,
							 (select count(*)
								 from acesso.v$item_acesso ia
								where ia.item_acesso_pai = i.item_acesso_id) as filhos,
						     level
					
				  	  from acesso.v$item_acesso i
					  start with i.item_acesso_pai = 1
					  connect by i.item_acesso_pai = prior i.item_acesso_id';
			
			if(strlen(trim($arguments['item_acesso_id'])))
  			    $query .= ' and item_acesso_id = '.$arguments['item_acesso_id'];
			if(strlen(trim($arguments['item_acesso_pai'])))
				$query .= ' and item_acesso_pai = '.$arguments['item_acesso_pai'];
			if(strlen(trim($arguments['descricao'])))
				$query .= ' and upper(descricao) like upper(\'%'.$arguments['descricao'].'%\')';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca mdulos de acesso do portal	*/
		function get_portal_modulo_acesso($arguments=array(),$resulttype='array') {
			$query = 'select modulo_id,
						     cod_portal,
						     date_insert,
						     user_insert,
					 	     date_update,
						     user_update,
						     site
					     from acesso.v$portal_modulo_acesso
					   where 1=1
					    and cod_portal = \''.$arguments['cod_portal'].'\'';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca mdulos de acesso do portal	*/
		function get_portal_modulo_acesso_detalhes($arguments=array(),$resulttype='array') {
			$query = 'select   m.modulo_id,
							   m.descricao
						
						from acesso.v$portal_modulo_acesso pma
						inner join acesso.v$modulo_acesso ma on ma.modulo_id = pma.modulo_id
						inner join acesso.v$modulo_web m on m.modulo_id = ma.modulo_item_acesso_id
						
						where 1=1
						  and pma.cod_portal = \''.$arguments['cod_portal'].'\'
						 order by m.descricao ';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca itens de acesso level	*/
		function get_portais_liberados($arguments=array(),$resulttype='array') {
			$query = 'select cod_portal					
				  	  from acesso.v$portais_liberados
					  where 1=1
					    and cod_portal = \''.$arguments['cod_portal'].'\'';
			
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca itens de acesso level	*/
		function get_acesso_coopagricola($arguments=array(),$resulttype='array') {
			$query = 'select acesso.sqe_cont_aces_coop.nextval as acessos
						from dual ';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca grupos de usurio */
		function get_grupo($arguments=array(),$resulttype='array') {
			$query = 'select grupo_id,
							   descricao,
							   cod_portal,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site
						  from acesso.v$grupo 
					    where 1=1
					      and cod_portal = \''.$arguments['cod_portal'].'\'';
						  
			if(strlen(trim($arguments['grupo_id'])))
  			    $query .= ' and grupo_id = '.$arguments['grupo_id'];
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca posies de menu dos grupos de usurios */
		function get_grupo_menu_posicao($arguments=array(),$resulttype='array') {
			$query = 'select grupo_menu_id,
							   grupo_id,
							   posicao_id,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site
						  from acesso.v$grupo_menu
					    where 1=1 ';
			
			if(strlen(trim($arguments['grupo_menu_id'])))
  			    $query .= ' and grupo_menu_id = '.$arguments['grupo_menu_id'];
			if(strlen(trim($arguments['grupo_id'])))
  			    $query .= ' and grupo_id = '.$arguments['grupo_id'];
			if(strlen(trim($arguments['posicao_id'])))
  			    $query .= ' and posicao_id = '.$arguments['posicao_id'];
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca posies de menu dos grupos de usurios */
		function get_grupo_usuario($arguments=array(),$resulttype='array') {
				$query = 'select grupo_usuario_id,
												   usuario,
												   grupo_id,
												   cod_portal,
												   date_insert,
												   user_insert,
												   date_update,
												   user_update,
												   site
										  from acesso.v$grupo_usuario
										 where 1=1 ';

				if(strlen(trim($arguments['grupo_usuario_id'])))
					$query .= ' and grupo_usuario_id = '.$arguments['grupo_usuario_id'];
				if(strlen(trim($arguments['grupo_id'])))
					$query .= ' and grupo_id = '.$arguments['grupo_id'];
				if(strlen(trim($arguments['usuario'])))
					$query .= ' and usuario = \''.$arguments['usuario'].'\'';

				if($this->dbtype == "postgresql")
						$query = str_replace('v$','',$query);

				//print($query);

			return $this->getResult($query,$resulttype);
		}

		
		/* Busca posies de menu dos grupos de usurios */
		function get_usuarios_transporte($arguments=array(),$resulttype='array') {

			$query = 'select *
						 from (SELECT distinct u.nome, 
									  u.usuario, 
									  u.ativo, 
									  u.cod_pessoa 
								 FROM kss.kss_usuarios u ';
			if(strlen(trim($arguments['usuarios_com_modulos'])))
				$query .= 'inner join acesso.v$modulo_usuario mu on mu.usuario = u.usuario
		                   inner join acesso.v$modulo_web m on m.modulo_id = mu.modulo_id ';
						 
			$query .= ' )
					  where 1=1
					    and ativo = 1
					 ';

			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			$query .= ' order by usuario ';
			
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca posies de menu dos grupos de usurios */
		function get_pessoa_usuario($arguments=array(),$resulttype='array') {

			$query = 'select   u.usuario,
							   u.cod_pessoa,
							   f.funcionario_id,
							   u.nome, 
							   u.descricao
						  from kss.kss_usuarios u
						 inner join folha.v$funcionario f on f.cod_pessoa = u.cod_pessoa
					  where 1=1 ';

			if(strlen(trim($arguments['usuario'])))
				$query .= ' and upper(usuario) = upper(\''.$arguments['usuario'].'\')';

			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);

		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca posies de menu dos grupos de usurios */
		function get_arquivo_ftp_dir($arguments=array(),$resulttype='array') {

			$query = 'select distinct ac.dir
						from site.v$arquivo ac
					   where 1=1 
					     and cod_portal = \''.$arguments['cod_portal'].'\'';

			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);

		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca posies de menu dos grupos de usurios */
		function get_usuario_liberacao($arguments=array(),$resulttype='array') {

			$query = 'select liberacao_id,
							   usuario_liberado,
							   usuario_concessor,
							   data_liberacao,
							   tempo,
							   categoria_id,
							   (select descricao
							      from site.arquivo_categoria ac
								 where ac.categoria_id = ul.categoria_id) as descricao,
							   cod_portal,
							   data_remocao,
							   to_char(data_previsao_liberacao,\'dd/mm/yyyy hh24:mi:ss\') as data_previsao_liberacao,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site
						  from acesso.v$usuario_liberacao ul
					   where 1=1 
					     and cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['usuario'])))
				$query .= ' and usuario_liberado = \''.$arguments['usuario'].'\'';
			if($arguments['ativo'] == 1)
				$query .= ' and data_remocao is null ';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);

		    return $this->getResult($query,$resulttype);
		}
		
		

		
		
	}
	global $conexao_banco;
	$AcessoComObj = new AcessoCom($conexao_banco);
}

global $createdObject;
$createdObject = $AcessoComObj;
if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}

?>