<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $PubManObj;
if(!$PubManObj) {
	class PubComMan extends QueryCom {
	

//************************************************************** CADASTRO DE POSIES DE PUBLICIDADES *****************************************************************

		/*
		 * Criado em Fri May 2 15:54:50 UTC-0300 2008
		 * Cadastra posio para publicidade
		 */
		function ins_publicidade_posicao($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_ins_publicidade_posicao(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA	       	   =>  :P_ALTURA,';
			$sql .= '					   P_POSICAO_ID	       =>  :P_POSICAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_POSICAO_ID',$arguments['posicao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Posio cadastrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
	
		
		/*
		 * Criado em Fri May 2 17:59:13 UTC-0300 2008
		 * Exclui uma posio de publicidade
		 */
		function del_publicidade_posicao($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_del_publicidade_posicao(P_POSICAO_ID   =>  :P_POSICAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_POSICAO_ID',$arguments['posicao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Posio excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 2 18:05:09 UTC-0300 2008
		 * Altera dados de uma posio de publicidade
		 */
		function upd_publicidade_posicao($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_alt_publicidade_posicao(P_POSICAO_ID   =>  :P_POSICAO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_POSICAO_ID',$arguments['posicao_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Posio alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
//************************************************************** CADASTRO DE FORMATORS DE PUBLICIDADES ***************************************************************
		
		/*
		 * Criado em Mon May 5 14:04:34 UTC-0300 2008
		 * Insere um formato de publicidade
		 */
		function ins_publicidade_formato($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_ins_publicidade_formato(P_DESCRICAO   =>  :P_DESCRICAO,';
			$sql .= '					   P_LARGURA_BASE	       =>  :P_LARGURA_BASE,';
			$sql .= '					   P_ALTURA_BASE	       =>  :P_ALTURA_BASE,';
			$sql .= '					   P_EXPANSIVEL	       =>  :P_EXPANSIVEL,';
			$sql .= '					   P_TOPO_EXPANSIVEL	       =>  :P_TOPO_EXPANSIVEL,';
			$sql .= '					   P_ESQUERDA_EXPANSIVEL	       =>  :P_ESQUERDA_EXPANSIVEL,';
			$sql .= '					   P_LARGURA_EXPANSIVEL	       =>  :P_LARGURA_EXPANSIVEL,';
			$sql .= '					   P_ALTURA_EXPANSIVEL	       =>  :P_ALTURA_EXPANSIVEL,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_FORMATO_ID	       =>  :P_FORMATO_ID);';
			$sql .= 'END;';
		
			if(!isset($arguments['expansivel']))
				$arguments['expansivel'] = '0';	
				
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_LARGURA_BASE',$arguments['largura_base'],4000);
			oci_bind_by_name($stmt,':P_ALTURA_BASE',$arguments['altura_base'],4000);
			oci_bind_by_name($stmt,':P_EXPANSIVEL',$arguments['expansivel'],4000);
			oci_bind_by_name($stmt,':P_TOPO_EXPANSIVEL',$arguments['topo_expansivel'],4000);
			oci_bind_by_name($stmt,':P_ESQUERDA_EXPANSIVEL',$arguments['esquerda_expansivel'],4000);
			oci_bind_by_name($stmt,':P_LARGURA_EXPANSIVEL',$arguments['largura_expansivel'],4000);
			oci_bind_by_name($stmt,':P_ALTURA_EXPANSIVEL',$arguments['altura_expansivel'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_FORMATO_ID',$arguments['formato_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Formato cadastrado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 5 14:05:38 UTC-0300 2008
		 * Altera um formato de publicidade
		 */
		function upd_publicidade_formato($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_alt_publicidade_formato(P_FORMATO_ID   =>  :P_FORMATO_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_LARGURA_BASE	       =>  :P_LARGURA_BASE,';
			$sql .= '					   P_ALTURA_BASE	       =>  :P_ALTURA_BASE,';
			$sql .= '					   P_EXPANSIVEL	       =>  :P_EXPANSIVEL,';
			$sql .= '					   P_TOPO_EXPANSIVEL	       =>  :P_TOPO_EXPANSIVEL,';
			$sql .= '					   P_ESQUERDA_EXPANSIVEL	       =>  :P_ESQUERDA_EXPANSIVEL,';
			$sql .= '					   P_LARGURA_EXPANSIVEL	       =>  :P_LARGURA_EXPANSIVEL,';
			$sql .= '					   P_ALTURA_EXPANSIVEL	       =>  :P_ALTURA_EXPANSIVEL,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL);';
			$sql .= 'END;';
			
			
			if(!isset($arguments['expansivel']))
				$arguments['expansivel'] = '0';	
			
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FORMATO_ID',$arguments['formato_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_LARGURA_BASE',$arguments['largura_base'],4000);
			oci_bind_by_name($stmt,':P_ALTURA_BASE',$arguments['altura_base'],4000);
			oci_bind_by_name($stmt,':P_EXPANSIVEL',$arguments['expansivel'],4000);
			oci_bind_by_name($stmt,':P_TOPO_EXPANSIVEL',$arguments['topo_expansivel'],4000);
			oci_bind_by_name($stmt,':P_ESQUERDA_EXPANSIVEL',$arguments['esquerda_expansivel'],4000);
			oci_bind_by_name($stmt,':P_LARGURA_EXPANSIVEL',$arguments['largura_expansivel'],4000);
			oci_bind_by_name($stmt,':P_ALTURA_EXPANSIVEL',$arguments['altura_expansivel'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Formato alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 5 14:06:21 UTC-0300 2008
		 * Exclui um formato de publicidade
		 */
		function del_publicidade_formato($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_del_publicidade_formato(P_FORMATO_ID   =>  :P_FORMATO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FORMATO_ID',$arguments['formato_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Formato excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
	
//************************************************************** CADASTRO DE PUBLICIDADES ******************************************************************
		/*
		 * Criado em Tue May 13 14:59:59 UTC-0300 2008
		 * Insere uma publicidade
		 */
		function ins_publicidade($arguments=array()){
			$conn = CreateObject("portal._class.consulta.publicidade");
			
			$qrMA = $conn->get_cod_tipo( array(mime_types => $arguments['arquivo_tipo']) );
					
			if(count($qrMA) == 0){
				$arguments["erro"] = "true";
				$arguments["mensagem"] = "O tipo de arquivo '" . $arguments['arquivo_tipo'] . "' no  aceito";			
				return false;
			}
			
			//Copia arquivo temporario para pasta permanente
			$parts = array_reverse(explode(".",$arguments['arquivo']));
			$extensao = strtolower($parts[0]);
			@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/arquivo/',0775,true);
			$count = 0;
			
			while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/arquivo/'.$extensao."_arquivo".$count.".".$extensao)) {
				$count++;
			}
			copy($_SERVER['DOCUMENT_ROOT'].$arguments['arquivo'],$_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/arquivo/'.$extensao.'_arquivo'.$count.".".$extensao);
			$arguments['arquivo'] = str_replace('//','/',str_replace('//','/','/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/arquivo/'.$extensao.'_arquivo'.$count.".".$extensao));
		
		
			//Copia fonte temporaria para pasta permanente
			$parts = array_reverse(explode(".",$arguments['fonte']));
			$extensao = strtolower($parts[0]);
			@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/fonte/',0775,true);
			$count = 0;
			while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/fonte/'.$extensao."_arquivo".$count.".".$extensao)) {
				$count++;
			}
			copy($_SERVER['DOCUMENT_ROOT'].$arguments['fonte'],$_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/fonte/'.$extensao.'_arquivo'.$count.".".$extensao);
			$arguments['fonte'] = str_replace('//','/',str_replace('//','/','/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/fonte/_arquivo'.$count.".".$extensao));
			
			
			
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_ins_publicidade(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_COD_TIPO	       =>  :P_COD_TIPO,';
			$sql .= '					   P_FORMATO_ID	       =>  :P_FORMATO_ID,';
			$sql .= '					   P_URL_ARQUIVO	       =>  :P_URL_ARQUIVO,';
			$sql .= '					   P_URL_ACESSO	       =>  :P_URL_ACESSO,';
			$sql .= '					   P_URL_FONTE	       =>  :P_URL_FONTE,';
			$sql .= '					   P_BACKGROUND_COLOR	       =>  :P_BACKGROUND_COLOR,';
			$sql .= '					   P_PUBLICIDADE_ID	       =>  :P_PUBLICIDADE_ID);';
			$sql .= 'END;';
			
			
			$arguments['cod_tipo'] = $qrMA[0]['COD_TIPO'];
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_COD_TIPO',$arguments['cod_tipo'],4000);
			oci_bind_by_name($stmt,':P_FORMATO_ID',$arguments['formato_id'],4000);
			oci_bind_by_name($stmt,':P_URL_ARQUIVO',$arguments['arquivo'],4000);
			oci_bind_by_name($stmt,':P_URL_ACESSO',$arguments['url_acesso'],4000);
			oci_bind_by_name($stmt,':P_URL_FONTE',$arguments['fonte'],4000);
			oci_bind_by_name($stmt,':P_BACKGROUND_COLOR',$arguments['background_color'],4000);
			oci_bind_by_name($stmt,':P_PUBLICIDADE_ID',$arguments['publicidade_id'],4000);
				
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);				
			
			
			if($sucesso){				
				$ret = $this->ins_publicidade_criterio( array( publicidade_id => $arguments['publicidade_id'],
																posicao_id => $arguments['posicao_id'],
																data_inicio => $arguments['data_inicio'],
																data_termino => $arguments['data_termino'],
																limite_exibicao => $arguments['limite_exibicao'],
																limite_clicks => $arguments['limite_clicks'],
																criterio_id => $arguments['criterio_id'],
																no_commit    => '1'
															   ));
				if($ret["erro"] == "true") {
					return $ret;
				}
				
								
				$arguments['criterio_id'] = $ret['criterio_id'];
				
				$v_hinicio = listatoarray($arguments,'horario_inicial_horarios');
				$v_htermino = listatoarray($arguments,'horario_final_horarios');
				$v_dia_semana = listatoarray($arguments,'horario_dia_semana_horarios');				
				
				
				for($i=0;$i<count($v_dia_semana); $i++){
					$ret2 = $this->ins_criterio_horario( array( hora_inicio  => $v_hinicio[$i],
																hora_termino => $v_htermino[$i],
																dia_semana   => $v_dia_semana[$i],
																criterio_id  => $arguments['criterio_id'],
																horario_id   => $arguments['horario_id'],
																no_commit    => '1'
															  ));
					if($ret2['erro'] == "true"){
						return $ret2;
						break;
					}
				}
				
			}										
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Publicidade cadastrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue May 13 15:01:10 UTC-0300 2008
		 * Altera uma publicidade
		 */
		function upd_publicidade($arguments=array()){
			new dBug($arguments);
			$conn = CreateObject("portal._class.consulta.publicidade");
			
			if($arguments['temporario'] != '0'){
				$qrMA = $conn->get_cod_tipo( array(mime_types => $arguments['arquivo_tipo']) );
				print(count($qrMA));
				if(count($qrMA) == 0){
					$arguments["erro"] = "true";
					$arguments["mensagem"] = "O tipo de arquivo '" . $arguments['arquivo_tipo'] . "' no  aceito";
					return false;
				}
				
				//Copia arquivo temporario para pasta permanente
				$parts = array_reverse(explode(".",$arguments['arquivo']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/arquivo/',0775,true);
				$count = 0;
				
				while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/arquivo/'.$extensao."_arquivo".$count.".".$extensao)) {
					$count++;
				}
				
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['arquivo'],$_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/arquivo/'.$extensao.'_arquivo'.$count.".".$extensao);
				$arguments['arquivo'] = str_replace('//','/',str_replace('//','/','/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/arquivo/'.$extensao.'_arquivo'.$count.".".$extensao));				
				$arguments['url_arquivo'] = $arguments['arquivo'];
			}else{
				//$arguments['cod_tipo'] = $arguments['arquivo_tipo'];
				$arguments['url_arquivo'] = $arguments['arquivo'];
			}
			
			$arguments['url_arquivo'] = str_replace('/tmp/',"//",$arguments['arquivo']);
			
			if($arguments['url_fonte']['type'] != ''){		
				//Copia fonte temporaria para pasta permanente
				$parts = array_reverse(explode(".",$arguments['fonte']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/fonte/',0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/fonte/'.$extensao."_arquivo".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['fonte'],$_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/fonte/'.$extensao.'_arquivo'.$count.".".$extensao);
				$arguments['fonte'] = str_replace('//','/',str_replace('//','/','/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/fonte/_arquivo'.$count.".".$extensao));							
			}else{
				$arguments['url_fonte'] = $arguments['fonte'];
			}
			new dBug($arguments);
			print('2');
			if(($arguments['criterio_id'] != '') && ($arguments['editar'] == 0)){
				$this->del_publicidade_criterio( array(criterio_id => $arguments['criterio_id'], no_commit => '1'));
				$arguments['ins_criterio'] = 1;
			}
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_alt_publicidade(P_PUBLICIDADE_ID   =>  :P_PUBLICIDADE_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_COD_TIPO	       =>  :P_COD_TIPO,';
			$sql .= '					   P_FORMATO_ID	       =>  :P_FORMATO_ID,';
			$sql .= '					   P_URL_ARQUIVO	       =>  :P_URL_ARQUIVO,';
			$sql .= '					   P_URL_ACESSO	       =>  :P_URL_ACESSO,';
			$sql .= '					   P_URL_FONTE	       =>  :P_URL_FONTE,';
			$sql .= '					   P_BACKGROUND_COLOR	       =>  :P_BACKGROUND_COLOR);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PUBLICIDADE_ID',$arguments['publicidade_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_COD_TIPO',$arguments['cod_tipo'],4000);
			oci_bind_by_name($stmt,':P_FORMATO_ID',$arguments['formato_id'],4000);
			oci_bind_by_name($stmt,':P_URL_ARQUIVO',$arguments['arquivo'],4000);
			oci_bind_by_name($stmt,':P_URL_ACESSO',$arguments['url_acesso'],4000);
			oci_bind_by_name($stmt,':P_URL_FONTE',$arguments['url_fonte'],4000);
			oci_bind_by_name($stmt,':P_BACKGROUND_COLOR',$arguments['background_color'],4000);			
				
		
				
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);				
			

			print('3');
			if($sucesso){
				if($arguments['editar'] == 0){ // Se no estiver editando somente a publicidade entao edite os critrios
					
					//CADASTRA CRITRIO DE PUBLICIDADE
					$ret = $this->ins_publicidade_criterio( array( publicidade_id => $arguments['publicidade_id'],
																	posicao_id => $arguments['posicao_id'],
																	data_inicio => $arguments['data_inicio'],
																	data_termino => $arguments['data_termino'],
																	limite_exibicao => $arguments['limite_exibicao'],
																	limite_clicks => $arguments['limite_clicks'],
																	criterio_id => $arguments['criterio_id'],
																	no_commit => '1'
																   ));
					if($ret["erro"] == "true") {
						return $ret;
					}
					$arguments['criterio_id'] = $ret['criterio_id'];
					
					$v_hinicio = listatoarray($arguments,'horario_inicial_horarios');
					$v_htermino = listatoarray($arguments,'horario_final_horarios');
					$v_dia_semana = listatoarray($arguments,'horario_dia_semana_horarios');				
					
					print('4');
					for($i=0;$i<count($v_dia_semana); $i++){
						$ret2 = $this->ins_criterio_horario( array( hora_inicio  => $v_hinicio[$i],
																	hora_termino => $v_htermino[$i],
																	dia_semana   => $v_dia_semana[$i],
																	criterio_id  => $arguments['criterio_id'],
																	horario_id   => $arguments['horario_id'],
																	no_commit    => '1'
																  ));
						if($ret2['erro'] == "true"){
							return $ret2;
							break;
						}
					}	
				}														
			}										
			print('5');
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   if($arguments['editar'] == 1){
			   		$arguments["mensagem"] = "Publicidade alterada com sucesso!";
			   }else{
			   		$arguments["mensagem"] = "Critrio adicionado com sucesso!";
			   }
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;	
		}
		
		
		/*
		
		 * Criado em Tue May 13 15:02:00 UTC-0300 2008
		 * Exlui uma publicidade
		 */
		function del_publicidade($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_del_publicidade(P_PUBLICIDADE_ID   =>  :P_PUBLICIDADE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PUBLICIDADE_ID',$arguments['publicidade_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Publicidade excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
  //******************************************** PUBLICIDADE - CRITRIO *************************************************
  
		/*
		 * Criado em Thu May 15 11:19:35 UTC-0300 2008
		 * Insere um critirio de publicidade
		 */
		function ins_publicidade_criterio($arguments=array()){			
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_ins_publicidade_criterio(P_PUBLICIDADE_ID   =>  :P_PUBLICIDADE_ID,';
			$sql .= '					   P_POSICAO_ID	       =>  :P_POSICAO_ID,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO,';
			$sql .= '					   P_DATA_TERMINO	       =>  :P_DATA_TERMINO,';
			$sql .= '					   P_LIMITE_EXIBICAO	       =>  :P_LIMITE_EXIBICAO,';
			$sql .= '					   P_LIMITE_CLICKS	       =>  :P_LIMITE_CLICKS,';
			$sql .= '					   P_CRITERIO_ID	       =>  :P_CRITERIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PUBLICIDADE_ID',$arguments['publicidade_id'],4000);
			oci_bind_by_name($stmt,':P_POSICAO_ID',$arguments['posicao_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
			oci_bind_by_name($stmt,':P_DATA_TERMINO',$arguments['data_termino'],4000);
			oci_bind_by_name($stmt,':P_LIMITE_EXIBICAO',$arguments['limite_exibicao'],4000);
			oci_bind_by_name($stmt,':P_LIMITE_CLICKS',$arguments['limite_clicks'],4000);
			oci_bind_by_name($stmt,':P_CRITERIO_ID',$arguments['criterio_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);			
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Critrio inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu May 15 11:21:42 UTC-0300 2008
		 * Altera um critirio de publicidade
		 */
		function upd_publicidade_criterio($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_alt_publicidade_criterio(P_CRITERIO_ID   =>  :P_CRITERIO_ID,';
			$sql .= '					   P_PUBLICIDADE_ID	       =>  :P_PUBLICIDADE_ID,';
			$sql .= '					   P_POSICAO_ID	       =>  :P_POSICAO_ID,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO,';
			$sql .= '					   P_DATA_TERMINO	       =>  :P_DATA_TERMINO,';
			$sql .= '					   P_LIMITE_EXIBICAO	       =>  :P_LIMITE_EXIBICAO,';
			$sql .= '					   P_LIMITE_CLICKS	       =>  :P_LIMITE_CLICKS,';
			$sql .= '					   P_SITUACAO_ID			=> :P_SITUACAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CRITERIO_ID',$arguments['criterio_id'],4000);
			oci_bind_by_name($stmt,':P_PUBLICIDADE_ID',$arguments['publicidade_id'],4000);
			oci_bind_by_name($stmt,':P_POSICAO_ID',$arguments['posicao_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
			oci_bind_by_name($stmt,':P_DATA_TERMINO',$arguments['data_termino'],4000);
			oci_bind_by_name($stmt,':P_LIMITE_EXIBICAO',$arguments['limite_exibicao'],4000);
			oci_bind_by_name($stmt,':P_LIMITE_CLICKS',$arguments['limite_clicks'],4000);
			oci_bind_by_name($stmt,':P_SITUACAO_ID',$arguments['situacao_id'],4000);
			
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
						
			if($sucesso && (isset($arguments['no_commit']) || $this->commit())){				
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Critrio alterado com sucesso!";
			}else{
			   
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu May 15 11:22:57 UTC-0300 2008
		 * Exclui um critirio de publicidade
		 */
		function del_publicidade_criterio($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_del_publicidade_criterio(P_CRITERIO_ID   =>  :P_CRITERIO_ID);';
			$sql .= 'END;';
			
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CRITERIO_ID',$arguments['criterio_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
			
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Critrio excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			
			return $arguments;
		}
		
		
	//************************************************* CRITRIO HORARIO ***********************************************
	
		/*
		 * Criado em Fri May 16 17:37:41 UTC-0300 2008
		 * Insere um horario de critrio
		 */
		function ins_criterio_horario($arguments=array()){		
			
			if(!isset($arguments['no_commit']))
				$this-> start();
		
			$sql  = 'BEGIN';						 
			$sql .= '	publicitario.pkg_publicidade.prc_ins_criterio_horario(P_CRITERIO_ID   =>  :P_CRITERIO_ID,';
			$sql .= '					   P_DIA_SEMANA	       =>  :P_DIA_SEMANA,';
			$sql .= '					   P_HORA_INICIO	       =>  :P_HORA_INICIO,';
			$sql .= '					   P_HORA_TERMINO	       =>  :P_HORA_TERMINO,';
			$sql .= '					   P_HORARIO_ID	       =>  :P_HORARIO_ID);';
			$sql .= 'END;';
			
			$arguments['tam_inicio'] = strlen($arguments['hora_inicio']);
			$arguments['tam_termino'] = strlen($arguments['hora_termino']);	
					
			
			if((strlen($arguments['hora_inicio']) >= 5) && (strlen($arguments['hora_inicio']) < 8)){
				$arguments['hora_inicio'] = substr($arguments['hora_inicio'],0,5);
				$arguments['hora_inicio'] = $arguments['hora_inicio'] . ':00';
			}
				
			if((strlen($arguments['hora_termino']) >= 5) && (strlen($arguments['hora_termino']) < 8)){
				$arguments['hora_termino'] = substr($arguments['hora_termino'],0,5);				
				$arguments['hora_termino'] = $arguments['hora_termino'] . ':00';
			}
			
			$arguments['hora_termino'] = '0 ' . $arguments['hora_termino'];
			$arguments['hora_inicio'] = '0 ' . $arguments['hora_inicio'];			
			
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CRITERIO_ID',$arguments['criterio_id'],4000);
			oci_bind_by_name($stmt,':P_DIA_SEMANA',$arguments['dia_semana'],4000);
			oci_bind_by_name($stmt,':P_HORA_INICIO',$arguments['hora_inicio'],4000);
			oci_bind_by_name($stmt,':P_HORA_TERMINO',$arguments['hora_termino'],4000);
			oci_bind_by_name($stmt,':P_HORARIO_ID',$arguments['horario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Critrio de horario inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 16 17:39:00 UTC-0300 2008
		 * Altera um horario de critrio
		 */
		function upd_criterio_horario($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_alt_criterio_horario(P_HORARIO_ID   =>  :P_HORARIO_ID,';
			$sql .= '					   P_CRITERIO_ID	       =>  :P_CRITERIO_ID,';
			$sql .= '					   P_DIA_SEMANA	       =>  :P_DIA_SEMANA,';
			$sql .= '					   P_HORA_INICIO	       =>  :P_HORA_INICIO,';
			$sql .= '					   P_HORA_TERMINO	       =>  :P_HORA_TERMINO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_HORARIO_ID',$arguments['horario_id'],4000);
			oci_bind_by_name($stmt,':P_CRITERIO_ID',$arguments['criterio_id'],4000);
			oci_bind_by_name($stmt,':P_DIA_SEMANA',$arguments['dia_semana'],4000);
			oci_bind_by_name($stmt,':P_HORA_INICIO',$arguments['hora_inicio'],4000);
			oci_bind_by_name($stmt,':P_HORA_TERMINO',$arguments['hora_termino'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
		if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Critrio alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Fri May 16 17:39:41 UTC-0300 2008
		 * Exclui um horario de critrio
		 */
		function del_criterio_horario($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_del_criterio_horario(P_HORARIO_ID   =>  :P_HORARIO_ID,';
			$sql .= '					   P_CRITERIO_ID	       =>  :P_CRITERIO_ID,';
			$sql .= '					   P_DIA_SEMANA	       =>  :P_DIA_SEMANA,';
			$sql .= '					   P_HORA_INICIO	       =>  :P_HORA_INICIO,';
			$sql .= '					   P_HORA_TERMINO	       =>  :P_HORA_TERMINO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_HORARIO_ID',$arguments['horario_id'],4000);
			oci_bind_by_name($stmt,':P_CRITERIO_ID',$arguments['criterio_id'],4000);
			oci_bind_by_name($stmt,':P_DIA_SEMANA',$arguments['dia_semana'],4000);
			oci_bind_by_name($stmt,':P_HORA_INICIO',$arguments['hora_inicio'],4000);
			oci_bind_by_name($stmt,':P_HORA_TERMINO',$arguments['hora_termino'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Critrio excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jun 4 12:06:29 UTC-0300 2008
		 * Insere um acesso da publicidade
		 */
		function ins_publicidade_acesso($arguments=array()){
						
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	publicitario.pkg_publicidade.prc_ins_publicidade_acesso(P_ACESSO_ID   =>  :P_ACESSO_ID,';
			$sql .= '					   P_CRITERIO_ID	       =>  :P_CRITERIO_ID,';
			$sql .= '					   P_PUBLICIDADE_ID	       =>  :P_PUBLICIDADE_ID,';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID,';
			$sql .= '					   P_HORARIO_ID	       =>  :P_HORARIO_ID,';			
			$sql .= '					   P_PUBLICIDADE_ACESSO_ID	       =>  :P_PUBLICIDADE_ACESSO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ACESSO_ID',$arguments['acesso_id'],4000);
			oci_bind_by_name($stmt,':P_CRITERIO_ID',$arguments['criterio_id'],4000);
			oci_bind_by_name($stmt,':P_PUBLICIDADE_ID',$arguments['publicidade_id'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_HORARIO_ID',$arguments['horario_id'],4000);			
			oci_bind_by_name($stmt,':P_PUBLICIDADE_ACESSO_ID',$arguments['publicidade_acesso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
			
			
			
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acesso inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
   			   
			   $this->rollback();
			}
			return $arguments;
		}
		
		
	}
	global $conexao_banco;
	$PubManObj = new PubComMan($conexao_banco);
}

global $createdObject;
$createdObject = $PubManObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>