<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $LayoutManObj;
if(!$LayoutManObj) {
	class LayoutComMan extends QueryCom {
		function ins_layout_tabela($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();

			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_ins_layout_tabela(p_layout_id 				=> :p_layout_id, ';
					$sql .= '										  p_tipo_id 				=> :p_tipo_id, ';
					$sql .= '										  p_colunas 				=> :p_colunas, ';
					$sql .= '										  p_ordem 					=> :p_ordem, ';
					$sql .= '										  p_layout_coluna_id_pai 	=> :p_layout_coluna_id_pai, ';
					$sql .= '										  p_layout_tabela_id		=> :p_layout_tabela_id); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_layout_id',$arguments['layout_id'],4000);
					oci_bind_by_name($stmt,':p_tipo_id',$arguments['tipo_id'],4000);
					oci_bind_by_name($stmt,':p_colunas',$arguments['colunas'],4000);
					oci_bind_by_name($stmt,':p_ordem',$arguments['ordem'],4000);
					oci_bind_by_name($stmt,':p_layout_coluna_id_pai',$arguments['layout_coluna_id_pai'],4000);
					oci_bind_by_name($stmt,':p_layout_tabela_id',$arguments['layout_tabela_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_layout_tabela('.$arguments['layout_id'];
					$sql .= '                             ,'.nvl($arguments['tabela_id'],'null');
					$sql .= '                             ,'.nvl($arguments['ordem'],'null');
					$sql .= '                             ,'.nvl($arguments['layout_coluna_id_pai'],'null');
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Grupo inserido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
	
		function upd_layout_tabela_ordem($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_alt_layout_tabela_ordem(p_layout_tabela_id	=> :p_layout_tabela_id, ';
					$sql .= '												p_ordem 			=> :p_ordem); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_layout_tabela_id',$arguments['layout_tabela_id'],4000);
					oci_bind_by_name($stmt,':p_ordem',$arguments['ordem'],4000);
					$sucesso = @oci_execute($stmt,OCI_DEFAULT);
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_alt_layout_tabela_ordem('.$arguments['layout_tabela_id'];
					$sql .= '                                   ,'.nvl($arguments['ordem'],'null');
					$sql .= '                                   );';
					$sucesso = ($arguments = $this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Grupo alterado com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
	
		function upd_layout_tabela_colunas($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_alt_layout_tabela_colunas(p_layout_tabela_id	=> :p_layout_tabela_id, ';
					$sql .= '												  p_colunas				=> :p_colunas); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_layout_tabela_id',$arguments['layout_tabela_id'],4000);
					oci_bind_by_name($stmt,':p_colunas',$arguments['colunas'],4000);
					$sucesso = @oci_execute($stmt,OCI_DEFAULT);
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_alt_layout_tabela_ordem('.$arguments['layout_tabela_id'];
					$sql .= '                                   ,'.nvl($arguments['ordem'],'null');
					$sql .= '                                   );';
					$sucesso = ($arguments = $this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Grupo alterado com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
	
		function upd_layout_tabela($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_alt_layout_tabela(p_layout_tabela_id	 => :p_layout_tabela_id, ';
					$sql .= '			 							  p_layout_coluna_id_pai => :p_layout_coluna_id_pai, ';
					$sql .= '										  p_ordem 			     => :p_ordem); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_layout_tabela_id',$arguments['layout_tabela_id'],4000);
					oci_bind_by_name($stmt,':p_layout_coluna_id_pai',$arguments['layout_coluna_id_pai'],4000);
					oci_bind_by_name($stmt,':p_ordem',$arguments['ordem'],4000);
					$sucesso = @oci_execute($stmt,OCI_DEFAULT);
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_alt_layout_tabela_ordem('.$arguments['layout_tabela_id'];
					$sql .= '                                   ,'.nvl($arguments['ordem'],'null');
					$sql .= '                                   );';
					$sucesso = ($arguments = $this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Grupo alterado com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
	
		function del_layout_tabela($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_del_layout_tabela(p_layout_tabela_id => :p_layout_tabela_id); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_layout_tabela_id',$arguments['layout_tabela_id'],4000);
					$sucesso = @oci_execute($stmt,OCI_DEFAULT);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_del_layout_tabela('.$arguments['layout_tabela_id'];
					$sql .= '                                   );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Grupo excluido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $this->getErrors();
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
	
	
		function ins_layout_objeto($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_ins_layout_objeto(p_objeto_id => :p_objeto_id';
					$sql .= ' 										 ,p_layout_id => :p_layout_id';
					$sql .= ' 										 ,p_layout_objeto_id => :p_layout_objeto_id); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_objeto_id',$arguments['objeto_id'],4000);
					oci_bind_by_name($stmt,':p_layout_id',$arguments['layout_id'],4000);
					oci_bind_by_name($stmt,':p_layout_objeto_id',$arguments['LAYOUT_OBJETO_ID'],4000);
					$sucesso = @oci_execute($stmt,OCI_DEFAULT);
					break;
				case "postgresql":
					$sql  = 'select a.*, a.p_layout_objeto_id as layout_objeto_id from ';
					$sql .= '   site.prc_ins_layout_objeto('.$arguments['objeto_id'];
					$sql .= '                             ,'.nvl($arguments['layout_id'],'null');
					$sql .= '                             ) as a;';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Objeto criado com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $this->getErrors();
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
	
		function upd_layout_objeto($arguments,$resulttype="array") {
			try {
				if(!isset($arguments['no_commit']))
					$this-> start();
				switch($this->dbtype) {
					case "oracle":
						$sql  = 'BEGIN ';
						$sql .= '	site.pkg_layout.prc_alt_layout_objeto(p_layout_objeto_id => :p_layout_objeto_id';
						$sql .= ' 										 ,p_layout_coluna_id => :p_layout_coluna_id';
						$sql .= ' 										 ,p_ordem => :p_ordem); ';
						$sql .= 'END; ';
						$stmt = oci_parse($this->conexao,$sql);
						oci_bind_by_name($stmt,':p_layout_objeto_id',$arguments['layout_objeto_id'],4000);
						oci_bind_by_name($stmt,':p_layout_coluna_id',$arguments['layout_coluna_id'],4000);
						oci_bind_by_name($stmt,':p_ordem',$arguments['ordem'],4000);
						$sucesso = @oci_execute($stmt,OCI_DEFAULT);
						break;
					case "postgresql":
						$sql  = 'select * from ';
						$sql .= '   site.prc_alt_layout_objeto('.$arguments['layout_objeto_id'];
						$sql .= '                             ,'.nvl($arguments['layout_coluna_id'],'null');
						$sql .= '                             ,'.nvl($arguments['ordem'],'null');
						$sql .= '                             );';
						$sucesso = ($arguments = $this->getResult($sql,'0'));
						break;
				}
				if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
					$arguments["erro"] = "false";
					$arguments["mensagem"] = "Objeto alterado com sucesso!";
				} else {
					$arguments["erro"] = "true";
					$arguments["mensagem"] = $this->getErrors();
					$this->rollback();
				}
			} catch(Exception $e) {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
	
		function config_layout_objeto($arguments,$resulttype="array") {
			try {
				if(!isset($arguments['no_commit']))
					$this-> start();
				switch($this->dbtype) {
					case "oracle":
						$sql  = 'BEGIN ';
						$sql .= '	site.pkg_layout.prc_config_layout_objeto(p_layout_objeto_id => :p_layout_objeto_id';
						$sql .= ' 										    ,p_configuracoes    => :p_configuracoes); ';
						$sql .= 'END; ';
						$stmt = oci_parse($this->conexao,$sql);
						oci_bind_by_name($stmt,':p_layout_objeto_id',$arguments['layout_objeto_id'],4000);
						oci_bind_by_name($stmt,':p_configuracoes',$arguments['configuracoes'],4000);
						$sucesso = @oci_execute($stmt,OCI_DEFAULT);
						break;
					case "postgresql":
						$sql  = 'select * from ';
						$sql .= '   site.prc_config_layout_objeto('.$arguments['layout_objeto_id'];
						$sql .= "                             ,'".nvl($arguments['configuracoes'],'null')."'";
						$sql .= '                             );';
						$sucesso = ($arguments = $this->getResult($sql,'0'));
						break;
				}
				if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
					$arguments["erro"] = "false";
					$arguments["mensagem"] = "Objeto alterado com sucesso!";
				} else {
					$arguments["erro"] = "true";
					$arguments["mensagem"] = $this->getErrors();
					$this->rollback();
				}
			} catch(Exception $e) {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}	
	
		function del_layout_objeto($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_del_layout_objeto(p_layout_objeto_id => :p_layout_objeto_id); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_layout_objeto_id',$arguments['layout_objeto_id'],4000);
					$sucesso = @oci_execute($stmt,OCI_DEFAULT);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_del_layout_objeto('.$arguments['layout_objeto_id'];
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Objeto excluido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $this->getErrors();
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
	
		}
	
		function ins_objeto($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_ins_objeto(p_titulo 				=> :p_titulo, ';
					$sql .= '								   p_categoria_id			=> :p_categoria_id, ';
					$sql .= '								   p_url_corpo 				=> :p_url_corpo, ';
					$sql .= '								   p_url_icone 				=> :p_url_icone, ';
					$sql .= '								   p_possui_configuracao	=> :p_possui_configuracao, ';
					$sql .= '								   p_objeto_id 				=> :p_objeto_id); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_titulo',$arguments['titulo'],4000);
					oci_bind_by_name($stmt,':p_categoria_id',$arguments['categoria_id'],4000);
					oci_bind_by_name($stmt,':p_url_corpo',$arguments['url_corpo'],4000);
					oci_bind_by_name($stmt,':p_url_icone',$arguments['url_icone'],4000);
					oci_bind_by_name($stmt,':p_possui_configuracao',$arguments['possui_configuracao'],4000);
					oci_bind_by_name($stmt,':p_objeto_id',$arguments['objeto_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_objeto(\''.$arguments['titulo'].'\'';
					$sql .= '                      ,\''.$arguments['url_corpo'].'\'';
					$sql .= '                      ,\''.$arguments['url_icone'].'\'';
					$sql .= '                      ,'.$arguments['possui_configuracao'];
					$sql .= '                      );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso) {
				$v_modulo_id = listatoarray($arguments,'modulo_id_modulos');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_modulos'])),implode(',',$v_modulo_id)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_objeto_modulo(array(
													modulo_id => $v_excluir[$i],
													objeto_id => $arguments['objeto_id'],
													no_commit	=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_modulo_id);$i++) {
					$ret = $this->ins_objeto_modulo(array(
											modulo_id		=> $v_modulo_id[$i],
											objeto_id		=> $arguments['objeto_id'],
											no_commit		=> 1
											));
					if($ret['erro'] == 'true') 
						return $ret;
				}		
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Objeto inserido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
	
		function upd_objeto($arguments,$resulttype="array") {
			try {
				if(!isset($arguments['no_commit']))
					$this-> start();
				switch($this->dbtype) {
					case "oracle":
						$sql  = 'BEGIN ';
						$sql .= '	site.pkg_layout.prc_alt_objeto(p_objeto_id 				=> :p_objeto_id, ';
						$sql .= '								   p_titulo 				=> :p_titulo, ';
						$sql .= '								   p_categoria_id			=> :p_categoria_id, ';
						$sql .= '								   p_url_corpo 				=> :p_url_corpo, ';
						$sql .= '								   p_url_icone 				=> :p_url_icone, ';
						$sql .= '								   p_possui_configuracao	=> :p_possui_configuracao); ';
						$sql .= 'END; ';
						$stmt = oci_parse($this->conexao,$sql);
						oci_bind_by_name($stmt,':p_titulo',$arguments['titulo'],4000);
						oci_bind_by_name($stmt,':p_categoria_id',$arguments['categoria_id'],4000);
						oci_bind_by_name($stmt,':p_url_corpo',$arguments['url_corpo'],4000);
						oci_bind_by_name($stmt,':p_url_icone',$arguments['url_icone'],4000);
						oci_bind_by_name($stmt,':p_possui_configuracao',$arguments['possui_configuracao'],4000);
						oci_bind_by_name($stmt,':p_objeto_id',$arguments['objeto_id'],4000);
						$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
						$_SESSION['last_error'] = oci_error($stmt);
						break;
					case "postgresql":
						$sql  = 'select * from ';
						$sql .= '   site.prc_alt_objeto('.$arguments['objeto_id'].'';
						$sql .= '                      ,\''.$arguments['titulo'].'\'';
						$sql .= '                      ,\''.$arguments['url_corpo'].'\'';
						$sql .= '                      ,\''.$arguments['url_icone'].'\'';
						$sql .= '                      ,'.$arguments['possui_configuracao'];
						$sql .= '                      );';
						$sucesso = ($arguments = @$this->getResult($sql,'0'));
						break;
				}
				if($sucesso) {
					$v_modulo_id = listatoarray($arguments,'modulo_id_modulos');
					$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_modulos'])),implode(',',$v_modulo_id)));
					
					for($i=0;$i<count($v_excluir);$i++) {
						if(strlen(trim($v_excluir[$i]))) {
							$ret = $this->del_objeto_modulo(array(
														modulo_id => $v_excluir[$i],
														objeto_id => $arguments['objeto_id'],
														no_commit	=> 1
														));
							if($ret['erro'] == 'true')
								return $ret;
						}
					}
					
					for($i=0;$i<count($v_modulo_id);$i++) {
						$ret = $this->ins_objeto_modulo(array(
												modulo_id		=> $v_modulo_id[$i],
												objeto_id		=> $arguments['objeto_id'],
												no_commit		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
					}		
				}
				if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
					$arguments["erro"] = "false";
					$arguments["mensagem"] = "Objeto alterado com sucesso!";
				} else {
					$arguments["erro"] = "true";
					$arguments["mensagem"] = $_SESSION['last_error'];
					$this->rollback();
				}
			} catch(Exception $e) {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
	
		function del_objeto($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_del_objeto(p_objeto_id 				=> :p_objeto_id); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_objeto_id',$arguments['objeto_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_del_objeto('.$arguments['objeto_id'].'';
					$sql .= '                      );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Objeto excluido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $this->getErrors();
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/**
		 * Insere um novo layout
		 */
		function ins_layout($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();

			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_ins_layout(p_descricao => :p_descricao ';
					$sql .= '                                 ,p_largura   => :p_largura ';
					$sql .= '                                 ,p_layout_id => :p_layout_id ';
					$sql .= '                                 ); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_descricao',$arguments['descricao'],4000);
					oci_bind_by_name($stmt,':p_largura',$arguments['largura'],4000);
					oci_bind_by_name($stmt,':p_layout_id',$arguments['layout_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = Oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_del_objeto('.$arguments['objeto_id'].'';
					$sql .= '                      );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Layout inserido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/**
		 * Altera um layout
		 */
		function upd_layout($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();

			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_layout.prc_alt_layout(p_layout_id => :p_layout_id ';
					$sql .= '                                 ,p_descricao => :p_descricao ';
					$sql .= '                                 ,p_largura => :p_largura ';
					$sql .= '                                 ); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_layout_id',$arguments['layout_id'],4000);
					oci_bind_by_name($stmt,':p_descricao',$arguments['descricao'],4000);
					oci_bind_by_name($stmt,':p_largura',$arguments['largura'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_del_objeto('.$arguments['objeto_id'].'';
					$sql .= '                      );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Layout alterado com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/*
		 * Criado em Thu Jul 17 16:17:16 UTC-0300 2008
		 * Efetua a copia de um layout
		 */
		function copiar_layout($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_layout.prc_copiar_layout(P_LAYOUT_ID_ORIGEM   =>  :P_LAYOUT_ID_ORIGEM,';
			$sql .= '					   P_LAYOUT_ID_DESTINO	       =>  :P_LAYOUT_ID_DESTINO,';
			$sql .= '					   P_EXCLUIR_CONTEUDO	       =>  :P_EXCLUIR_CONTEUDO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LAYOUT_ID_ORIGEM',$arguments['layout_id_origem'],4000);
			oci_bind_by_name($stmt,':P_LAYOUT_ID_DESTINO',$arguments['layout_id_destino'],4000);
			oci_bind_by_name($stmt,':P_EXCLUIR_CONTEUDO',$arguments['excluir_conteudo'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Layout copiado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/**
		 * Habilita as funes de edio do site
		 */
		function habilitar_edicao($arguments,$resulttype="array") {
			global $_SESSION;
			$_SESSION['editar_edicao'] = !$_SESSION['editar_edicao'];
			$arguments = array("erro" => "false", "mensagem" => "");
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
				
		/*
		 * Criado em Mon Jun 2 10:41:13 UTC-0300 2008
		 * Insere uma categoria de Objetos
		 */
		function ins_objeto_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_layout.prc_ins_objeto_categoria(P_CATEGORIA_PAI_ID   =>  :P_CATEGORIA_PAI_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_PAI_ID',$arguments['categoria_pai_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 10:43:07 UTC-0300 2008
		 * Altera uma categoria de Objetos
		 */
		function upd_objeto_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_layout.prc_alt_objeto_categoria(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_CATEGORIA_PAI_ID	       =>  :P_CATEGORIA_PAI_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_PAI_ID',$arguments['categoria_pai_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 10:43:35 UTC-0300 2008
		 * Exclui uma categoria de Objetos
		 */
		function del_objeto_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_layout.prc_del_objeto_categoria(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
				
		/*
		 * Criado em Mon Jun 2 16:22:13 UTC-0300 2008
		 * Insere uma posicao de menu
		 */
		function ins_menu_posicao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_menu.prc_ins_menu_posicao(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_POSICAO_ID	       =>  :P_POSICAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_POSICAO_ID',$arguments['posicao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Posio de menu inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 16:22:48 UTC-0300 2008
		 * Altera uma posicao de menu
		 */
		function upd_menu_posicao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_menu.prc_alt_menu_posicao(P_POSICAO_ID   =>  :P_POSICAO_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_POSICAO_ID',$arguments['posicao_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Posio de menu alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 16:24:43 UTC-0300 2008
		 * Exclui uma posicao de menu
		 */
		function del_menu_posicao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_menu.prc_del_menu_posicao(P_POSICAO_ID   =>  :P_POSICAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_POSICAO_ID',$arguments['posicao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Posio de menu excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 16:25:34 UTC-0300 2008
		 * Insere um menu
		 */
		function ins_menu($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_menu.prc_ins_menu(P_POSICAO_ID   =>  :P_POSICAO_ID,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO,';
			$sql .= '					   P_MENU_ID	       =>  :P_MENU_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_POSICAO_ID',$arguments['posicao_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
			oci_bind_by_name($stmt,':P_MENU_ID',$arguments['menu_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$conn = CreateObject("portal._class.consulta.layout");
				$v_item_pai_id = listatoarray($arguments,'items_item_pai_id_item');
				$v_tipo_id = listatoarray($arguments,'items_tipo_id_item');
				$v_label = listatoarray($arguments,'items_label_item');
				$v_ordem = listatoarray($arguments,'items_ordem_item');
				$v_url = listatoarray($arguments,'items_url_item');
				$v_target = listatoarray($arguments,'items_target_item');
				$v_tipo_url = listatoarray($arguments,'items_tipo_url');
				$v_administrativo = listatoarray($arguments,'items_administrativo_item');
				$v_setor_id = listatoarray($arguments,'items_setor_id_item');
				$v_item_id = listatoarray($arguments,'items_item_id_item');
				$v_item_id_base_dados = array();
				$v_item_id_base_dados[0] = '';
				
				// Exclui todos os itens vinculados ao menu
				$conn = CreateObject("portal._class.consulta.layout");
				$qrItem = $conn->get_menu_item(array(menu_id => $arguments['menu_id']));
				for($i=0;$i<count($qrItem);$i++) {
					$ret = $this->del_menu_item(array(
										item_id 	=> $qrItem['ITEM_ID'],
										no_commit		=> 1
										));
				}			
				// Insere todos os itens novamente
				for($i=0;$i<count($v_item_id);$i++) {
					print($v_label[$i]."<br>");
					$ret = $this->ins_menu_item(array(
										menu_id			=> $arguments['menu_id'],
										item_pai_id		=> $v_item_id_base_dados[$v_item_pai_id[$i]],
										tipo_id			=> $v_tipo_id[$i],
										label			=> $v_label[$i],
										ordem			=> $v_ordem[$i],
										url				=> $v_url[$i],
										target			=> $v_target[$i],
										tipo_url		=> $v_tipo_url[$i],
										administrativo	=> $v_administrativo[$i],
										setor_id		=> $v_setor_id[$i],
										no_commit		=> 1
										));
					if($ret['erro'] == "erro")
						return $ret;
					else
						$v_item_id_base_dados[$v_item_id[$i]] = $ret['item_id'];
				}
				
					
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Menu inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 16:26:15 UTC-0300 2008
		 * Altera um menu
		 */
		function upd_menu($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_menu.prc_alt_menu(P_MENU_ID   =>  :P_MENU_ID,';
			$sql .= '					   P_POSICAO_ID	       =>  :P_POSICAO_ID,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MENU_ID',$arguments['menu_id'],4000);
			oci_bind_by_name($stmt,':P_POSICAO_ID',$arguments['posicao_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$conn = CreateObject("portal._class.consulta.layout");
				$v_item_pai_id = listatoarray($arguments,'items_item_pai_id_item');
				$v_tipo_id = listatoarray($arguments,'items_tipo_id_item');
				$v_label = listatoarray($arguments,'items_label_item');
				$v_ordem = listatoarray($arguments,'items_ordem_item');
				$v_url = listatoarray($arguments,'items_url_item');
				$v_target = listatoarray($arguments,'items_target_item');
				$v_tipo_url = listatoarray($arguments,'items_tipo_url');
				$v_administrativo = listatoarray($arguments,'items_administrativo_item');
				$v_setor_id = listatoarray($arguments,'items_setor_id_item');
				$v_item_id = listatoarray($arguments,'items_item_id_item');
				$v_item_id_base_dados = array();
				$v_item_id_base_dados[0] = '';
				
				// Exclui todos os itens vinculados ao menu
				$conn = CreateObject("portal._class.consulta.layout");
				$qrItem = $conn->get_menu_item(array(menu_id => $arguments['menu_id']));
				new dBug($qrItem);
				for($i=0;$i<count($qrItem);$i++) {
					$ret = $this->del_menu_item(array(
										item_id 	=> $qrItem[$i]['ITEM_ID'],
										no_commit		=> 1
										));
					if($ret['erro'] == 'true')
						return $ret;
				}			
				// Insere todos os itens novamente
				for($i=0;$i<count($v_item_id);$i++) {
					print($v_label[$i]."<br>");
					$ret = $this->ins_menu_item(array(
										menu_id			=> $arguments['menu_id'],
										item_pai_id		=> $v_item_id_base_dados[$v_item_pai_id[$i]],
										tipo_id			=> $v_tipo_id[$i],
										label			=> $v_label[$i],
										ordem			=> $v_ordem[$i],
										url				=> $v_url[$i],
										target			=> $v_target[$i],
										tipo_url		=> $v_tipo_url[$i],
										administrativo	=> $v_administrativo[$i],
										setor_id		=> $v_setor_id[$i],
										no_commit		=> 1
										));
					if($ret['erro'] == "erro")
						return $ret;
					else
						$v_item_id_base_dados[$v_item_id[$i]] = $ret['item_id'];
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Menu alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 16:26:46 UTC-0300 2008
		 * Exclui um menu
		 */
		function del_menu($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_menu.prc_del_menu(P_MENU_ID   =>  :P_MENU_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MENU_ID',$arguments['menu_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Menu excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 16:27:38 UTC-0300 2008
		 * Copia um menu
		 */
		function copia_menu($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_menu.prc_copia_menu(P_MENU_ID   =>  :P_MENU_ID,';
			$sql .= '					   P_MENU_ID_DESTINO	       =>  :P_MENU_ID_DESTINO,';
			$sql .= '					   P_ITEM_PAI_ID	       =>  :P_ITEM_PAI_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MENU_ID',$arguments['menu_id'],4000);
			oci_bind_by_name($stmt,':P_MENU_ID_DESTINO',$arguments['menu_id_destino'],4000);
			oci_bind_by_name($stmt,':P_ITEM_PAI_ID',$arguments['item_pai_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Menu copiado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 16:28:46 UTC-0300 2008
		 * Insere um item de menu
		 */
		function ins_menu_item($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_menu.prc_ins_menu_item(P_MENU_ID   =>  :P_MENU_ID,';
			$sql .= '					   P_ITEM_PAI_ID	       =>  :P_ITEM_PAI_ID,';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID,';
			$sql .= '					   P_LABEL	       =>  :P_LABEL,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_URL	       =>  :P_URL,';
			$sql .= '					   P_TARGET	       =>  :P_TARGET,';
			$sql .= '					   P_TIPO_URL	       =>  :P_TIPO_URL,';
			$sql .= '					   P_ADMINISTRATIVO	       =>  :P_ADMINISTRATIVO,';
			$sql .= '					   P_SETOR_ID	       =>  :P_SETOR_ID,';
			$sql .= '					   P_ITEM_ID	       =>  :P_ITEM_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MENU_ID',$arguments['menu_id'],4000);
			oci_bind_by_name($stmt,':P_ITEM_PAI_ID',$arguments['item_pai_id'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_LABEL',$arguments['label'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_URL',$arguments['url'],4000);
			oci_bind_by_name($stmt,':P_TARGET',$arguments['target'],4000);
			oci_bind_by_name($stmt,':P_TIPO_URL',$arguments['tipo_url'],4000);
			oci_bind_by_name($stmt,':P_ADMINISTRATIVO',$arguments['administrativo'],4000);
			oci_bind_by_name($stmt,':P_SETOR_ID',$arguments['setor_id'],4000);
			oci_bind_by_name($stmt,':P_ITEM_ID',$arguments['item_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Item inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 16:31:31 UTC-0300 2008
		 * Altera um item de menu
		 */
		function upd_menu_item($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_menu.prc_alt_menu_item(P_ITEM_ID   =>  :P_ITEM_ID,';
			$sql .= '					   P_MENU_ID	       =>  :P_MENU_ID,';
			$sql .= '					   P_ITEM_PAI_ID	       =>  :P_ITEM_PAI_ID,';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID,';
			$sql .= '					   P_LABEL	       =>  :P_LABEL,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_URL	       =>  :P_URL,';
			$sql .= '					   P_TARGET	       =>  :P_TARGET,';
			$sql .= '					   P_TIPO_URL	       =>  :P_TIPO_URL,';
			$sql .= '					   P_ADMINISTRATIVO	       =>  :P_ADMINISTRATIVO,';
			$sql .= '					   P_SETOR_ID	       =>  :P_SETOR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ITEM_ID',$arguments['item_id'],4000);
			oci_bind_by_name($stmt,':P_MENU_ID',$arguments['menu_id'],4000);
			oci_bind_by_name($stmt,':P_ITEM_PAI_ID',$arguments['item_pai_id'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_LABEL',$arguments['label'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_URL',$arguments['url'],4000);
			oci_bind_by_name($stmt,':P_TARGET',$arguments['target'],4000);
			oci_bind_by_name($stmt,':P_TIPO_URL',$arguments['tipo_url'],4000);
			oci_bind_by_name($stmt,':P_ADMINISTRATIVO',$arguments['administrativo'],4000);
			oci_bind_by_name($stmt,':P_SETOR_ID',$arguments['setor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Item alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 16:32:28 UTC-0300 2008
		 * Exclui um item de menu
		 */
		function del_menu_item($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_menu.prc_del_menu_item(P_ITEM_ID   =>  :P_ITEM_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ITEM_ID',$arguments['item_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Item excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Mon Jun 16 16:23:59 UTC-0300 2008
		 * Insere um modulo
		 */
		function ins_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_layout.prc_ins_modulo(P_DESCRICAO   =>  :P_DESCRICAO,';
			$sql .= '					   P_MODULO_ID	       =>  :P_MODULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Modulo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 16 16:24:55 UTC-0300 2008
		 * Altera um modulo
		 */
		function upd_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_layout.prc_alt_modulo(P_MODULO_ID   =>  :P_MODULO_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Modulo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 16 16:25:36 UTC-0300 2008
		 * Exclui um modulo
		 */
		function del_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_layout.prc_alt_modulo(P_MODULO_ID   =>  :P_MODULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Modulo excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 16 16:26:31 UTC-0300 2008
		 * Vincula um objeto ao modulo
		 */
		function ins_objeto_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_layout.prc_ins_objeto_modulo(P_OBJETO_ID   =>  :P_OBJETO_ID,';
			$sql .= '					   P_MODULO_ID	       =>  :P_MODULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_OBJETO_ID',$arguments['objeto_id'],4000);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Objeto vinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 16 16:26:52 UTC-0300 2008
		 * Desvincula um objeto ao modulo
		 */
		function del_objeto_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_layout.prc_del_objeto_modulo(P_OBJETO_ID   =>  :P_OBJETO_ID,';
			$sql .= '					   P_MODULO_ID	       =>  :P_MODULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_OBJETO_ID',$arguments['objeto_id'],4000);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Objeto desvinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}

	}
	global $conexao_banco;
	$LayoutManObj = new LayoutComMan($conexao_banco);
}	

global $createdObject;
$createdObject = $LayoutManObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>