<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $ImpressoManipulacaoObj;
if(!$ImpressoManipulacaoObj) {
	class ImpressoManipulacao extends QueryCom {
		/*
		 * Criado em Fri Jun 27 09:51:25 UTC-0300 2008
		 * Insere um caderno
		 */
		function ins_impresso_caderno($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_ins_impresso_caderno(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_PREFIXO	       =>  :P_PREFIXO,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_CADERNO_ID	       =>  :P_CADERNO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_PREFIXO',$arguments['prefixo'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Caderno inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jun 27 09:52:59 UTC-0300 2008
		 * Altera um caderno
		 */
		function upd_impresso_caderno($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_alt_impresso_caderno(P_CADERNO_ID   =>  :P_CADERNO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_PREFIXO	       =>  :P_PREFIXO,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_PREFIXO',$arguments['prefixo'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Caderno alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jun 27 09:54:07 UTC-0300 2008
		 * Exclui um caderno
		 */
		function del_impresso_caderno($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_del_impresso_caderno(P_CADERNO_ID   =>  :P_CADERNO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Caderno excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}

		/*
		 * Criado em Fri Jun 27 11:45:26 UTC-0300 2008
		 * Insere um impresso
		 */
		function ins_impresso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_ins_impresso(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_DATA_PUBLICACAO	       =>  :P_DATA_PUBLICACAO,';
			$sql .= '					   P_ANO	       =>  :P_ANO,';
			$sql .= '					   P_COD_EDICAO	       =>  :P_COD_EDICAO,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_IMPRESSO_ID	       =>  :P_IMPRESSO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DATA_PUBLICACAO',$arguments['data_publicacao'],4000);
			oci_bind_by_name($stmt,':P_ANO',$arguments['ano'],4000);
			oci_bind_by_name($stmt,':P_COD_EDICAO',$arguments['cod_edicao'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_IMPRESSO_ID',$arguments['impresso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jun 27 11:54:51 UTC-0300 2008
		 * Altera um impresso
		 */
		function upd_impresso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_alt_impresso(P_IMPRESSO_ID   =>  :P_IMPRESSO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_DATA_PUBLICACAO	       =>  :P_DATA_PUBLICACAO,';
			$sql .= '					   P_ANO	       =>  :P_ANO,';
			$sql .= '					   P_COD_EDICAO	       =>  :P_COD_EDICAO,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMPRESSO_ID',$arguments['impresso_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DATA_PUBLICACAO',$arguments['data_publicacao'],4000);
			oci_bind_by_name($stmt,':P_ANO',$arguments['ano'],4000);
			oci_bind_by_name($stmt,':P_COD_EDICAO',$arguments['cod_edicao'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jun 27 11:55:22 UTC-0300 2008
		 * Exclui um impresso
		 */
		function del_impresso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_del_impresso(P_IMPRESSO_ID   =>  :P_IMPRESSO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMPRESSO_ID',$arguments['impresso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jul 1 18:11:23 UTC-0300 2008
		 * Insere uma pagina no impresso
		 */
		function ins_impresso_pagina($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			
			if($arguments['temporario_pdf'] == "1") {
				$parts = array_reverse(explode(".",$arguments['url_pdf']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_pdf'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_pdf'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));
			}

			if($arguments['temporario_imagem'] == "1") {
				$parts = array_reverse(explode(".",$arguments['url_imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_imagem'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));
			}
			
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_ins_impresso_pagina(P_CADERNO_ID   =>  :P_CADERNO_ID,';
			$sql .= '					   P_IMPRESSO_ID	       =>  :P_IMPRESSO_ID,';
			$sql .= '					   P_NUM_PAGINA	       =>  :P_NUM_PAGINA,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_URL_PDF	       =>  :P_URL_PDF,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA  	       =>  :P_ALTURA,';
			$sql .= '					   P_PAGINA_ID	       =>  :P_PAGINA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
			oci_bind_by_name($stmt,':P_IMPRESSO_ID',$arguments['impresso_id'],4000);
			oci_bind_by_name($stmt,':P_NUM_PAGINA',$arguments['num_pagina'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_URL_PDF',$arguments['url_pdf'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura_imagem'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura_imagem'],4000);
			oci_bind_by_name($stmt,':P_PAGINA_ID',$arguments['pagina_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pagina inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jul 1 18:12:10 UTC-0300 2008
		 * Altera uma pagina no impresso
		 */
		function upd_impresso_pagina($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['temporario_pdf'] == "1") {
				$parts = array_reverse(explode(".",$arguments['url_pdf']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_pdf'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_pdf'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));
			}

			if($arguments['temporario_imagem'] == "1") {
				$parts = array_reverse(explode(".",$arguments['url_imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_imagem'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));
			}
			
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_alt_impresso_pagina(P_PAGINA_ID   =>  :P_PAGINA_ID,';
			$sql .= '					   P_CADERNO_ID	       =>  :P_CADERNO_ID,';
			$sql .= '					   P_IMPRESSO_ID	       =>  :P_IMPRESSO_ID,';
			$sql .= '					   P_NUM_PAGINA	       =>  :P_NUM_PAGINA,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_URL_PDF	       =>  :P_URL_PDF,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA  	       =>  :P_ALTURA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PAGINA_ID',$arguments['pagina_id'],4000);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
			oci_bind_by_name($stmt,':P_IMPRESSO_ID',$arguments['impresso_id'],4000);
			oci_bind_by_name($stmt,':P_NUM_PAGINA',$arguments['num_pagina'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_URL_PDF',$arguments['url_pdf'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura_imagem'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura_imagem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pagina alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jul 1 18:12:10 UTC-0300 2008
		 * Altera uma pagina no impresso
		 */
		function del_impresso_pagina($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_del_impresso_pagina(P_PAGINA_ID   =>  :P_PAGINA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PAGINA_ID',$arguments['pagina_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pagina excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
	}
	global $conexao_banco;
	$ImpressoManipulacaoObj = new ImpressoManipulacao($conexao_banco);
}

global $createdObject;
$createdObject = $ImpressoManipulacaoObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>