<?php
    require_once 'define.php';
    require_once 'configuracao.php';
	
    ini_set("soap.wsdl_cache_enabled", "0");
    $server = new SoapServer("integrador.wsdl", array('encoding'=>'ISO-8859-1'));
    
    function posicionamento($data){
        
		if(EM_MANUTENCAO == 1){
			return new SoapFault('-1', "Sistema em manuteno. Aguarde alguns instantes e tente novamente.");
		}
		
        $operacoes = new Operacoes();
        if(!$operacoes->connect($data->usuario, $data->senha)){
            //verificar o tipo de erro - banco, usuario, conta bloqueada ou no catalogado
            return new SoapFault('-3', "Usurio/senha incorreta.");
        }
		
		$gestao = $operacoes->setGestao();
		
		if ($gestao === false){
			return new SoapFault('-1', $operacoes->getErrors());
		}
		
        $param = array();
        $param['posicao_id'] = $data->id_msg;
        $ret = $operacoes->processaRequisicao($param);
        
        if($ret === false){
            return new SoapFault('-1', $operacoes->getErrors());
        }else{
            $arrayOfPosicao = new ArrayOfPosicao();
            $output = new SoapResponse();
            while($resp = $operacoes->fetchResultQuery($ret)){
				$output->addResult($resp);
                $posicao = $output->getObjectResult($resp);
                $arrayOfPosicao->add($posicao);
            }
            return $arrayOfPosicao->soapResponse();
        }
    }
    
    $server->addFunction(array("posicionamento"));
    $server->handle();

?>
