<?php
/* According to specific of organization process of SOAP class in PHP5, we must wrap up complex objects in SoapVar class. Otherwise objects would not be encoded properly and could not be loaded on remote SOAP handler.
Function "getAsSoap" call for encoding object for transmission. After encoding it can be properly transmitted.*/
abstract class SoapAble {

    public function getAsSOAP() {
		$xmlns['posicionamentoResponse'] = 'http://tempurl.org';
		$xmlns['ArrayOfPosicao'] = 'http://www.w3.org/2001/XMLSchema';
		
		$this->prepareSOAPrecursive($this->arrayOfResult, $xmlns, 'http://tempurl.org');
		return $this;
    }
    
    private function prepareSOAPrecursive(&$element, $xmlnsArray, $xmlns = '') {
        if(is_array($element)) {
            foreach($element as $key=>&$val) {
                $this->prepareSOAPrecursive($val, $xmlnsArray, $xmlnsArray[$key]);
            }
            $element = new SoapVar($element, SOAP_ENC_OBJECT, $xmlns);
            //$element = new SoapVar($element, SOAP_ENC_OBJECT);
        }elseif(is_object($element)) {
            if($element instanceof SOAPable) {
                $element->getAsSOAP();
            }
            //seta os tipos para os elementos
            foreach($element as $key=>&$value) {
                if($key == 'ID_MENSAGEM'){
                    $value = new SoapVar($value, XSD_INTEGER, 'int');
                }elseif($key=='LATITUDE' || $key == 'LONGITUDE'){
                    $value = new SoapVar($value, XSD_FLOAT, 'float');
                }elseif($key=='DATA_HORA_POSICAO'){
                    $value = new SoapVar($value, XSD_DATETIME, 'dateTime');
                }else{
                    $value = new SoapVar($value, XSD_STRING, 'string');
                }
            }
            $Posicao = $element;
            $element = new SoapVar($Posicao, SOAP_ENC_OBJECT, null, null, 'Posicao');
        }
    }
    
    public function getAsSOAPObject($object){
        foreach($object as $key=>&$value) {
            $this->prepareSOAPrecursive($this->$key);
        }
        return $object;
    }
}
