<?php
class Operacoes extends Conexao{
    
    public function consultaDataPosicao($params){
        $sql = 'select data
                  from integrador.v$integracao_posicao_sliic
                 where posicao_id = :posicao_id';
        $qrParam['posicao_id'] = $params['posicao_id'];
        $stmt = $this->query($sql, $qrParam);
        return $stmt;
    }
    
    public function consultaGrupoLogistico(){
        $sql = 'select grupo_id
                     , somente_veiculos_lista
                  from integrador.v$grupo_logistico_sliic
                 where usuario = user';
        $stmt = $this->query($sql, array());
        return $stmt;
    }
	
	public function setGestao(){
		$sql = 'begin 
				   delete from kss.pessoa_usuario_acesso_cur;

                   insert into kss.pessoa_usuario_acesso_cur(cod_pessoa, usuario)
                        select cod_pessoa, user
                          from kss.pessoa_unidade_negocio
                         where cod_gestao = (select min(g.cod_gestao)
                          from kss.pessoa_aplicacao_gestao g
                         inner join kss.pessoa_unidade_negocio u
                            on u.cod_gestao = g.cod_gestao);
					 
				   commit;
			    end;';
        $stmt = $this->query($sql, array());
        return $stmt;
	}
    
    public function consultaPosicoesVeiculosGrupo($params){
        $grupo_id = $params['grupo_id'];
        $data = $params['data'];
        $posicao = $params['posicao_id'];
        
        $sql  = 'select posicao_id
                      , placa
                      , to_char(data, \'yyyy-mm-dd"T"hh24:mi:ss\') as data
                      , num_rastreador
                      , latitude
                      , longitude
                      , estado
                      , cidade
                      , logradouro
                   from (select posicao_id
                              , data
                              , placa
                              , num_rastreador
                              , latitude
                              , longitude
                              , estado
                              , cidade
                              , logradouro 
                           from integrador.v$integracao_posicao_sliic_vei ipsv
                          where data > to_date(\''.$data.'\', \'dd/mm/yyyy hh24:mi:ss\') - 1
                            and posicao_id > '.$posicao.'
                            and placa in (select placa
                                            from integrador.v$grupo_log_veiculo_sliic glvs
                                           where glvs.grupo_id = '.$grupo_id.')
                          order by posicao_id)
                  where rownum <= 1000';
        
        $stmt = $this->query($sql, array());
        
        return $stmt;
    }
    
    public function consultaPosicoes($params){
        
        $grupo_id = $params['grupo_id'];
        $data = $params['data'];
        $posicao = $params['posicao_id'];
        
        $sql  = 'select posicao_id
                      , placa
                      , to_char(data, \'yyyy-mm-dd"T"hh24:mi:ss\') as data
                      , num_rastreador
                      , latitude
                      , longitude
                      , estado
                      , cidade
                      , logradouro
                   from (select posicao_id
                              , data
                              , placa
                              , num_rastreador
                              , latitude
                              , longitude
                              , estado
                              , cidade
                              , logradouro 
                           from integrador.v$integracao_posicao_sliic
                          where (cod_remetente in (select glc.cod_pessoa_carga
                                                     from integrador.v$grupo_log_carga_sliic glc 
                                                    where glc.grupo_id = '.$grupo_id.') 
                             or cod_destinatario in (select gld.cod_pessoa_descarga
                                                       from integrador.v$grupo_log_descarga_sliic gld 
                                                      where gld.grupo_id = '.$grupo_id.'))
                            and data > to_date(\''.$data.'\', \'dd/mm/yyyy hh24:mi:ss\') - 1
                            and posicao_id > '.$posicao.'
                          order by posicao_id)
                  where rownum <= 1000';
        
        $stmt = $this->query($sql, array());
        
        return $stmt;
    }
    
    public function processaRequisicao($params){
        /* GRUPO LOGISTICO */
        //obtem o grupo ID
        $grupoLogisiticoSt = $this->consultaGrupoLogistico();
        if($grupoLogisiticoSt === false){
            return false;
        }else{
            //obtem o id do grupo logisitico
            $grupo = $this->fetchResultQuery($grupoLogisiticoSt);
            if($grupo !== false){
                $grupo_id = $grupo->GRUPO_ID;
                $somenteVeiculosLista = $grupo->SOMENTE_VEICULOS_LISTA;
            }else{
                $this->setErrors('No foi possvel determinar o grupo logstico para este usurio.');
                return false;
            }
        }
        
        /* POSICAO E DATA */
        //caso o ID da posio seja ZERO ou no seja informado, seta o default para os parametros de data e posicao_id
        $posicao_id = 0;
        $data = date('d/m/Y H:i:s', mktime(0, 0, 0, date("m"), date("d")-1, date("Y")));
        
        //verifica se foi solicitada a posio
        if(!empty($params['posicao_id'])){
            $posicao_id = $params['posicao_id'];
            $posicaoSt = $this->consultaDataPosicao(array("posicao_id" => $posicao_id));
            if($posicaoSt !== false){
                $posicao = $this->fetchResultQuery($posicaoSt);
                if($posicao!==false){
                    $data = $posicao->DATA;
                }
            }
        }
        
        /* POSICOES */
        //consulta as posies baseado nos parametros obtidos
        $qrParam = array();
        $qrParam['posicao_id'] = $posicao_id;
        $qrParam['grupo_id'] = $grupo_id;
        $qrParam['data'] = $data;
        if(empty($somenteVeiculosLista)){
            $posicoesSt = $this->consultaPosicoes($qrParam);
        }else{
            $posicoesSt = $this->consultaPosicoesVeiculosGrupo($qrParam);
        }
        
        if($posicoesSt === false){
            return false;
        }
        return $posicoesSt;
    }
}
?>