<cfcomponent displayname="Controle e manipulao de veculos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca FROTA
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_placa" returntype="string" access="remote">
		<cfargument name="cod_veiculo" required="no">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.fnc_get_placa('#arguments.cod_veiculo#') as placa
			  from dual
 		</cfquery>		
		<cfreturn qr_result.placa>
	</cffunction>
	
	<!--- 
    -- PROPSITO
    -- Insere veculo (ESTRUTURA NOVA)
    -- guto 17/07/2007 16:31:08 - CRIADO
    --->
    <cffunction name='ins_veiculo' displayname='Insere veculo (ESTRUTURA NOVA)' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MARCA_ID' required='yes'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='UF' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='CHASSIS' required='yes'>
        <cfargument name='RENAVAN' required='yes'>
        <cfargument name='COR_PREDOMINANTE' required='yes'>
        <cfargument name='CAPACIDADE_TANQUE' required='no' default="">
        <cfargument name='TAG_SEM_PARAR' required='no' default="">
        <cfargument name='DATA_INICIO_SEM_PARAR' required='no' default="">
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='RASTREADOR_ID' required='no' default="">
        <cfargument name='DATA_INICIO_RASTREADOR' required='no' default="">
        <cfargument name='NUM_NOTA_ID' required='no' default="">
        <cfargument name='NUM_CONTRATO' required='no' default="">
        <cfargument name='DATA_COMPRA' required='no' default="">
        <cfargument name='TIPO_COMPRA' required='no' default="">
        <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#UCase(REReplace(arguments.PLACA,'-',''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#UCase(REReplace(arguments.PLACA,'-',''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHASSIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RENAVAN#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COR_PREDOMINANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_SEM_PARAR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RASTREADOR_ID#' variable='retorno.RASTREADOR_ID'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_RASTREADOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONTRATO#'  null='#iif(len(trim(arguments.NUM_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TIPO_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null='yes'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   variable='retorno.VEICULO_ID'  null="yes" >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   null="yes" variable='retorno.ROWID' >
                </cfstoredproc>

				<cfscript>
					conn = CreateObject("component", "_transportes.manipulacao.cfc_pessoa");
				</cfscript>
				<cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO
													,num_modalidade = 3);
						
						this.ins_veiculo_proprietario(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                              cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO,
													  data_inicio = LSDateFormat(Now()));
					</cfscript>
				</cfif>

				<cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO
													,num_modalidade = 3);
						
						this.ins_veiculo_proprietario_doc(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                                 cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO,
													     data_inicio = LSDateFormat(Now()));
					</cfscript>
                </cfif>

				<cfif len(trim(arguments.COD_PESSOA_MOTORISTA))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_MOTORISTA
													,num_modalidade = 8);
					</cfscript>
					<!---Insere novo registro--->
                    <cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
                        insert into oper.v$veiculo_motorista
                          (placa, cod_pessoa, km_inicio, data_inicio, evo_id_recebimento)
                        values
                          ('#UCase(REReplace(arguments.PLACA,'-',''))#', #arguments.COD_PESSOA_MOTORISTA#, 1, sysdate, null)
                    </cfquery>		
				</cfif>

				<cfif len(trim(arguments.COD_PESSOA_PERMISSIONARIO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO
													,num_modalidade = 20);
					   
					    this.ins_veiculo_permissionario(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                                cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO,
							   						    data_inicio = LSDateFormat(Now()));
					</cfscript>
				</cfif>
                
                <!---Insere situao--->
                <cfscript>
					this.ins_veiculo_situacao(placa = UCase(REReplace(arguments.PLACA,'-','')),
					                          situacao_id = 1,
											  data = LSDateFormat(Now()));
				</cfscript>
                
				<cfscript>
                   this.ins_veiculo_modalidade(placa = #UCase(REReplace(arguments.PLACA,'-',''))#,
                                               modalidade = 'TERCEIRO',
                                               data = LSDateFormat(Now()));
                </cfscript>    
                
                <cfstoredproc procedure="oper.pkg_frota_dml.prc_atualiza_atributo_terceiro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
     					<cfprocparam  type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
  				</cfstoredproc>            

                <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="MODALIDADE">
                        <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="TERCEIRO">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                
                <cfif len(trim(arguments.TARA))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="TARA">
                        <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TARA#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>

                <cfif len(trim(arguments.TAG_CTF))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="TAG_CTF">
                        <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TAG_CTF#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>
                
                <cfif len(trim(arguments.CAPACIDADE_TRACAO))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="CAPACIDADE_TRACAO">
                        <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.CAPACIDADE_TRACAO#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>
                
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
	<!--- 
    -- PROPSITO
    -- Altera veculo (ESTRUTURA NOVA)
    -- guto 17/07/2007 16:31:52 - CRIADO
    --->
    <cffunction name='upd_veiculo' displayname='Altera veculo (ESTRUTURA NOVA)' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MARCA_ID' required='yes'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='UF' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='CHASSIS' required='yes'>
        <cfargument name='RENAVAN' required='yes'>
        <cfargument name='COR_PREDOMINANTE' required='yes'>
        <cfargument name='CAPACIDADE_TANQUE' required='no' default="">
        <cfargument name='TAG_SEM_PARAR' required='no' default="">
        <cfargument name='DATA_INICIO_SEM_PARAR' required='no' default="">
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='RASTREADOR_ID' required='no' default="">
        <cfargument name='RASTREADOR_COM_PROBLEMAS' required='no' default="">
        <cfargument name='DATA_TROCA_RASTREADOR' required='no' default="">
        <cfargument name='NUM_NOTA_ID' required='no' default="">
        <cfargument name='NUM_CONTRATO' required='no' default="">
        <cfargument name='DATA_COMPRA' required='no' default="">
        <cfargument name='TIPO_COMPRA' required='no' default="">
        <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_VEICULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHASSIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RENAVAN#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COR_PREDOMINANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_SEM_PARAR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RASTREADOR_ID#' variable='retorno.RASTREADOR_ID'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RASTREADOR_COM_PROBLEMAS#'  null='#iif(len(trim(arguments.RASTREADOR_COM_PROBLEMAS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TROCA_RASTREADOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONTRATO#'  null='#iif(len(trim(arguments.NUM_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TIPO_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>


				<cfscript>
					conn = CreateObject("component", "_transportes.manipulacao.cfc_pessoa");
				</cfscript>

				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_proprietario
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#' 
				</cfquery>					
				<cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO
													,num_modalidade = 3);
						
						this.ins_veiculo_proprietario(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                              cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO,
													  data_inicio = LSDateFormat(Now()));
					</cfscript>
				</cfif>

				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_proprietario_doc
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>			
				<cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO
													,num_modalidade = 3);
						
						this.ins_veiculo_proprietario_doc(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                              	  cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO,
													      data_inicio = LSDateFormat(Now()));
					</cfscript>
                </cfif>

				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_motorista
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>			
				<cfif len(trim(arguments.COD_PESSOA_MOTORISTA))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_MOTORISTA
													,num_modalidade = 8);
					</cfscript>

					<!---Insere novo registro--->
                    <cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
                        insert into oper.v$veiculo_motorista
                          (placa, cod_pessoa, km_inicio, data_inicio, evo_id_recebimento)
                        values
                          ('#UCase(REReplace(arguments.PLACA,'-',''))#', #arguments.COD_PESSOA_MOTORISTA#, 1, sysdate, null)
                    </cfquery>		
				</cfif>

				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_permissionario
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>			
				<cfif len(trim(arguments.COD_PESSOA_PERMISSIONARIO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO
													,num_modalidade = 20);
					   
					    this.ins_veiculo_permissionario(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                                cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO,
							   						    data_inicio = LSDateFormat(Now()));
					</cfscript>
				</cfif>
                
				<!---Busca Modaliade Atual--->
                <cfquery name="qrModalidade" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
                     select max(modalidade) keep(dense_rank last order by data) modalidade
                       from oper.v$veiculo_modalidade
                      where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'                       
                </cfquery>			

                <cfscript>
                   if (qrModalidade.MODALIDADE neq 'TERCEIRO') {
                       this.ins_veiculo_modalidade(placa = #UCase(REReplace(arguments.PLACA,'-',''))#,
                                                   modalidade = 'TERCEIRO',
                                                   data = LSDateFormat(Now()) );
                    }
                </cfscript>
                                    
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_hist_situacao
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>	  
                              
                <!---Insere situao--->
				<cfscript>
					this.ins_veiculo_situacao(placa = UCase(REReplace(arguments.PLACA,'-','')),
					                          situacao_id = 1,
											  data = LSDateFormat(Now()));
				</cfscript>
                
                <cfstoredproc procedure="oper.pkg_frota_dml.prc_atualiza_atributo_terceiro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
     					<cfprocparam  type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
  				</cfstoredproc>

                <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="MODALIDADE">
                        <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="TERCEIRO">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>

                <cfif len(trim(arguments.TAG_CTF))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="TAG_CTF">
                        <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TAG_CTF#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>
                                
                <cfif len(trim(arguments.TARA))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="TARA">
                        <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TARA#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>
                
                <cfif len(trim(arguments.CAPACIDADE_TRACAO))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="CAPACIDADE_TRACAO">
                        <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.CAPACIDADE_TRACAO#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>
                                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>   

	<!--- 
    -- PROPSITO
    -- Exclui ndice de fumaa preta do veculo (ESTRUTURA NOVA)
    -- Marcelo
    --->
    <cffunction name='cancela_fumaca_preta' displayname='Exclui ndice de fumaa preta do veculo (ESTRUTURA NOVA)' access='remote' returntype='Struct' output='true'>
        <cfargument name='FUMACA_PRETA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_cancela_fumaca_preta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FUMACA_PRETA_ID#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 

	<!--- 
    -- PROPSITO
    -- Exclui veculo (ESTRUTURA NOVA)
    -- guto 17/07/2007 16:32:44 - CRIADO
    --->
    <cffunction name='del_veiculo' displayname='Exclui veculo (ESTRUTURA NOVA)' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_VEICULO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 

	<!--- 
	-- PROPSITO
	-- Insere marca
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 19/12/2005 - criado
	--->
	<cffunction name="ins_marca" displayname="Insere marca" access="remote" returntype="struct" output="true">
		<cfargument name="marca" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				insert into oper.v$veiculo_marca
				  (marca_id, marca)
				values
				  (-1, '#arguments.marca#')
			</cfquery>

			<cfset retorno.mensagem = 'Marca inserida com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera dados da marca
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 02/12/2005 - criado
	--->
	<cffunction name="upd_marca" displayname="Altera dados da Marca" access="remote" returntype="struct" output="true">
		<cfargument name="marca_id" required="yes">
		<cfargument name="marca" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				update oper.v$veiculo_marca
				   set marca    = '#arguments.marca#'
				 where marca_id = #arguments.marca_id#
			</cfquery>

			<cfset retorno.mensagem = 'Marca alterada com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui marca
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->
	<cffunction name="del_marca" displayname="Exclui marca" access="remote" returntype="struct" output="true">
		<cfargument name="marca_id" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				delete oper.v$veiculo_marca
				 where marca_id = #arguments.marca_id#
			</cfquery>

			<cfset retorno.mensagem = 'Marca excluda com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>	

	<!--- 
    -- PROPSITO
    -- Vincula situao ao veculo 
    -- guto 17/07/2007 17:10:43 - CRIADO
    --->
    <cffunction name='ins_veiculo_situacao' displayname='Vincula situao ao veculo ' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='DATA' required='yes'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_hist_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   null="yes" variable='retorno.VEICULO_SITUACAO_ID'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>  

    <!--- 
    -- PROPSITO
    -- Insere um veculo
    -- ANDERSONC 18/03/2009 17:27:12 - CRIADO
    --->
    <cffunction name='ins_veiculo_geral' displayname='Insere um veculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MARCA_ID' required='yes'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='UF' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='CHASSIS' required='yes'>
        <cfargument name='RENAVAN' required='yes'>
        <cfargument name='COR_PREDOMINANTE' required='yes'>
        <cfargument name='CAPACIDADE_TANQUE' required='yes'>
        <cfargument name='TAG_SEM_PARAR' required='no' default='0'>
        <cfargument name='DATA_INICIO_SEM_PARAR' required='no' default=''>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='RASTREADOR_ID' required='no' default=''>
        <cfargument name='DATA_INICIO_RASTREADOR' required='no' default=''>
        <cfargument name='NUM_NOTA_ID' required='no' default=''>
        <cfargument name='NUM_CONTRATO' required='no' default=''>
        <cfargument name='DATA_COMPRA' required='no' default=''>
        <cfargument name='TIPO_COMPRA' required='no' default=''>
        <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
        <cfargument name='ROWID' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#UCase(REReplace(arguments.COD_VEICULO, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#UCase(REReplace(arguments.PLACA, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHASSIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RENAVAN#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COR_PREDOMINANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_SEM_PARAR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RASTREADOR_ID#' variable='retorno.RASTREADOR_ID'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_RASTREADOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONTRATO#'  null='#iif(len(trim(arguments.NUM_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TIPO_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null='yes'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   variable='retorno.VEICULO_ID'  null="yes" >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ROWID#' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <!--- Insere as situaes --->
                <cfscript>
					v_historicos_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_SITUACAO_SITUACAO');
					v_historicos_data_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_DATA_SITUACAO_SITUACAO');
					v_historicos_horario_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_HORARIO_SITUACAO_SITUACAO');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_historicos_situacao)#" index="count">
					<cfscript>
						ret = this.ins_veiculo_situacao(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
														SITUACAO_ID = v_historicos_situacao[count],
														DATA        = v_historicos_data_situacao[count] & ' ' & v_historicos_horario_situacao[count]);
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Insere as modalidades --->
                <cfscript>
					v_historicos_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_MODALIDADE_MODALIDADE');
					v_historicos_data_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_DATA_MODALIDADE_MODALIDADE');
					v_historicos_horario_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_HORARIO_MODALIDADE_MODALIDADE');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_historicos_modalidade)#" index="count">
					<cfscript>
						ret = this.ins_veiculo_modalidade(PLACA      = UCase(REReplace(arguments.PLACA, '-', '')),
														  MODALIDADE = v_historicos_modalidade[count],
														  DATA       = v_historicos_data_modalidade[count] & ' ' & v_historicos_horario_modalidade[count]);
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Insere os proprietrios --->
                <cfscript>
					v_proprietario_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_COD_PESSOA_PROPRIETARIO');
					v_proprietario_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DATA_INICIO_PROPRIETARIO');
					v_proprietario_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_HORARIO_INICIO_PROPRIETARIO');
					v_proprietario_data_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DATA_TERMINO_PROPRIETARIO');
					v_proprietario_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_HORARIO_TERMINO_PROPRIETARIO');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_proprietario_cod_pessoa)#" index="count">
					<cfscript>
						ret = this.ins_veiculo_proprietario(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
															COD_PESSOA  = v_proprietario_cod_pessoa[count],
															DATA_INICIO = v_proprietario_data_inicio[count] & ' ' & v_proprietario_horario_inicio[count],
															DATA_FIM    = v_proprietario_data_termino[count] & ' ' & v_proprietario_horario_termino[count]);
                    </cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Insere os laudos --->
				<cfscript>
					v_laudos_liberados_verificacao = ListToArray(arguments.LAUDOS_LIBERADOS_VERIFICACAO, ';');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_laudos_liberados_verificacao)#" index="count">
                	<cfscript>
                        ret = this.ins_veiculo_laudo_excecao(PLACA    = UCase(REReplace(arguments.PLACA, '-', '')),
                                                             LAUDO_ID = v_laudos_liberados_verificacao[count]);
					</cfscript>
                </cfloop>
                <!--- Fim --->
                
                <!--- Insere as classificaes ---> 
                <cfscript>
					v_classificacao_atributo = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_ATRIBUTO_CLASSIFICACAO');
					v_classificacao_valor = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_VALOR_CLASSIFICACAO');
					v_classificacao_tipo_dado = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_TIPO_DADO_CLASSIFICACAO');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_classificacao_atributo)#" index="count">
					<cfscript>
						if(v_classificacao_tipo_dado[count] eq 'FLAG') {
							if(v_classificacao_valor[count] eq 'Sim') {
								v_classificacao_valor[count] = '1';
							}
							else if(v_classificacao_valor[count] eq 'No') {
								v_classificacao_valor[count] = '0';
							}
						}
						
						ret = this.upd_veiculo_atributo(PLACA        = UCase(REReplace(arguments.PLACA, '-', '')),
														COD_ATRIBUTO = v_classificacao_atributo[count],
														VALOR        = v_classificacao_valor[count]);
                    </cfscript>
                </cfloop>                              
                <!--- Fim --->
                
                <!--- Insere os permissionrios --->
                <cfscript>
					v_permissionario_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_COD_PESSOA_PERMISSIONARIO');
					v_permissionario_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_DATA_INICIO_PERMISSIONARIO');
					v_permissionario_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_HORARIO_INICIO_PERMISSIONARIO');
					v_permissionario_data_termino = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_DATA_TERMINO_PERMISSIONARIO');
					v_permissionario_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_HORARIO_TERMINO_PERMISSIONARIO');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_permissionario_cod_pessoa)#" index="count">
					<cfscript>
						ret = this.ins_veiculo_permissionario(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
															  COD_PESSOA  = v_permissionario_cod_pessoa[count],
															  DATA_INICIO = v_permissionario_data_inicio[count] & ' ' & v_permissionario_horario_inicio[count],
															  DATA_FIM    = v_permissionario_data_termino[count] & ' ' & v_permissionario_horario_termino[count]);
                    </cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Insere os proprietrios de documentos --->
                <cfscript>
					v_proprietario_doc_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_COD_PESSOA_PROPRIETARIO_DOC');
					v_proprietario_doc_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_DATA_INICIO_PROPRIETARIO_DOC');
					v_proprietario_doc_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_HORARIO_INICIO_PROPRIETARIO_DOC');
					v_proprietario_doc_data_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_DATA_TERMINO_PROPRIETARIO_DOC');
					v_proprietario_doc_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_HORARIO_TERMINO_PROPRIETARIO_DOC');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_proprietario_doc_cod_pessoa)#" index="count">
					<cfscript>
						ret = this.ins_veiculo_proprietario_doc(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
															    COD_PESSOA  = v_proprietario_doc_cod_pessoa[count],
															    DATA_INICIO = v_proprietario_doc_data_inicio[count] & ' ' & v_proprietario_doc_horario_inicio[count],
															    DATA_FIM    = v_proprietario_doc_data_termino[count] & ' ' & v_proprietario_doc_horario_termino[count]);
                    </cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Processa os dados do veculo --->
				<cfscript>
                    ret = this.processa_dados_veiculo(PLACA         = UCase(REReplace(arguments.PLACA, '-', '')),
													  TIPO_OPERACAO = 'I');
                </cfscript>
                <!--- Fim --->
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!--- 
    -- PROPSITO
    -- Altera um veculo
    -- ANDERSONC 19/03/2009 16:08:54 - CRIADO
    --->
    <cffunction name='upd_veiculo_geral' displayname='Altera um veculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MARCA_ID' required='yes'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='UF' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='CHASSIS' required='yes'>
        <cfargument name='RENAVAN' required='yes'>
        <cfargument name='COR_PREDOMINANTE' required='yes'>
        <cfargument name='CAPACIDADE_TANQUE' required='yes'>
        <cfargument name='TAG_SEM_PARAR' required='no' default='0'>
        <cfargument name='DATA_INICIO_SEM_PARAR' required='no' default=''>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='RASTREADOR_ID' required='no' default=''>
        <cfargument name='RASTREADOR_COM_PROBLEMAS' required='no' default=''>
        <cfargument name='DATA_TROCA_RASTREADOR' required='no' default=''>
        <cfargument name='NUM_NOTA_ID' required='no' default=''>
        <cfargument name='NUM_CONTRATO' required='no' default=''>
        <cfargument name='DATA_COMPRA' required='no' default=''>
        <cfargument name='TIPO_COMPRA' required='no' default=''>
        <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#UCase(REReplace(arguments.COD_VEICULO, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#UCase(REReplace(arguments.PLACA, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHASSIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RENAVAN#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COR_PREDOMINANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_SEM_PARAR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RASTREADOR_ID#' variable='retorno.RASTREADOR_ID'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RASTREADOR_COM_PROBLEMAS#'  null='#iif(len(trim(arguments.RASTREADOR_COM_PROBLEMAS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TROCA_RASTREADOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONTRATO#'  null='#iif(len(trim(arguments.NUM_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TIPO_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <cfscript>
					conn = CreateComponent("_transportes.consulta.cfc_veiculo");
				</cfscript>
                
                <!--- Altera as situaes --->
                <cfscript>
					v_historicos_veiculo_situacao_id = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_VEICULO_SITUACAO_ID_SITUACAO');
					v_historicos_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_SITUACAO_SITUACAO');
					v_historicos_data_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_DATA_SITUACAO_SITUACAO');
					v_historicos_horario_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_HORARIO_SITUACAO_SITUACAO');
					
					qrSituacao = conn.get_veiculo_hist_situacao(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrSituacao">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_historicos_situacao)#" index="count">
                    	<cfscript>
							if(qrSituacao.VEICULO_SITUACAO_ID eq v_historicos_veiculo_situacao_id[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_situacao(VEICULO_SITUACAO_ID = qrSituacao.VEICULO_SITUACAO_ID);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_historicos_situacao)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_historicos_veiculo_situacao_id[count]))) {
							ret = this.ins_veiculo_situacao(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
															SITUACAO_ID = v_historicos_situacao[count],
															DATA        = v_historicos_data_situacao[count] & ' ' & v_historicos_horario_situacao[count]);
						}
						else {
							ret = this.upd_veiculo_situacao(VEICULO_SITUACAO_ID = v_historicos_veiculo_situacao_id[count],
															PLACA               = UCase(REReplace(arguments.PLACA, '-', '')),
															SITUACAO_ID         = v_historicos_situacao[count],
															DATA                = v_historicos_data_situacao[count] & ' ' & v_historicos_horario_situacao[count]);
						}
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Altera as modalidades --->
                <cfscript>
					v_historicos_veiculo_modalidade_id = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_VEICULO_MODALIDADE_ID_MODALIDADE');
					v_historicos_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_MODALIDADE_MODALIDADE');
					v_historicos_data_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_DATA_MODALIDADE_MODALIDADE');
					v_historicos_horario_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_HORARIO_MODALIDADE_MODALIDADE');
					
					qrModalidade = conn.get_veiculo_modalidade(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrModalidade">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_historicos_modalidade)#" index="count">
                    	<cfscript>
							if(qrModalidade.VEICULO_MODALIDADE_ID eq v_historicos_veiculo_modalidade_id[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_modalidade(VEICULO_MODALIDADE_ID = qrModalidade.VEICULO_MODALIDADE_ID);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_historicos_modalidade)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_historicos_veiculo_modalidade_id[count]))) {
							ret = this.ins_veiculo_modalidade(PLACA      = UCase(REReplace(arguments.PLACA, '-', '')),
														      MODALIDADE = v_historicos_modalidade[count],
														      DATA       = v_historicos_data_modalidade[count] & ' ' & v_historicos_horario_modalidade[count]);
						}
						else {
							ret = this.upd_veiculo_modalidade(VEICULO_MODALIDADE_ID = v_historicos_veiculo_modalidade_id[count],
															  PLACA                 = UCase(REReplace(arguments.PLACA, '-', '')),
														      MODALIDADE            = v_historicos_modalidade[count],
														      DATA                  = v_historicos_data_modalidade[count] & ' ' & v_historicos_horario_modalidade[count]);
						}
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Altera os proprietrios --->
                <cfscript>
					v_proprietario_data_inicio_old = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DATA_INICIO_OLD_PROPRIETARIO');
					v_proprietario_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_COD_PESSOA_PROPRIETARIO');
					v_proprietario_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DATA_INICIO_PROPRIETARIO');
					v_proprietario_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_HORARIO_INICIO_PROPRIETARIO');
					v_proprietario_data_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DATA_TERMINO_PROPRIETARIO');
					v_proprietario_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_HORARIO_TERMINO_PROPRIETARIO');
					
					qrProprietario = conn.get_veiculo_proprietario_geral(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrProprietario">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_proprietario_cod_pessoa)#" index="count">
                    	<cfscript>
							if(qrProprietario.OLD_DATA_INICIO eq v_proprietario_data_inicio_old[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_proprietario(PLACA       = qrProprietario.PLACA,
																COD_PESSOA  = qrProprietario.COD_PESSOA,
																DATA_INICIO = qrProprietario.DATA_INICIO);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_proprietario_cod_pessoa)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_proprietario_data_inicio_old[count]))) {
							ret = this.ins_veiculo_proprietario(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
																COD_PESSOA  = v_proprietario_cod_pessoa[count],
																DATA_INICIO = v_proprietario_data_inicio[count] & ' ' & v_proprietario_horario_inicio[count],
																DATA_FIM    = v_proprietario_data_termino[count] & ' ' & v_proprietario_horario_termino[count]);
						}
						else {
							ret = this.upd_veiculo_proprietario(PLACA           = UCase(REReplace(arguments.PLACA, '-', '')),
																COD_PESSOA      = v_proprietario_cod_pessoa[count],
																DATA_INICIO     = v_proprietario_data_inicio[count] & ' ' & v_proprietario_horario_inicio[count],
																DATA_FIM        = v_proprietario_data_termino[count] & ' ' & v_proprietario_horario_termino[count],
																OLD_DATA_INICIO = v_proprietario_data_inicio_old[count]);
						}
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Altera os laudos --->
                <cfscript>
					v_laudos_liberados_verificacao = ListToArray(arguments.LAUDOS_LIBERADOS_VERIFICACAO, ';');
					
					qrLaudoLiberado = conn.get_laudos_liberados(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrLaudoLiberado">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_laudos_liberados_verificacao)#" index="count">
                    	<cfscript>
							if(qrLaudoLiberado.LAUDO_ID eq v_laudos_liberados_verificacao[count]) {
								v_flag = 1;
								break;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_laudo_excecao(PLACA    = qrLaudoLiberado.PLACA,
                                                             	 LAUDO_ID = qrLaudoLiberado.LAUDO_ID);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_laudos_liberados_verificacao)#" index="count">
                	<cfscript>
						v_flag = 0;
					</cfscript>
					
					<cfloop query="qrLaudoLiberado">
						<cfscript>
							if(v_laudos_liberados_verificacao[count] eq qrLaudoLiberado.LAUDO_ID) {
								v_flag = 1;
								break;
							}
						</cfscript>
					</cfloop>
					
					<cfscript>
						if(v_flag eq 0) {
							ret = this.ins_veiculo_laudo_excecao(PLACA    = UCase(REReplace(arguments.PLACA, '-', '')),
																 LAUDO_ID = v_laudos_liberados_verificacao[count]);
						}
					</cfscript>
                </cfloop>
                <!--- Fim --->
                
                <!--- Altera as classificaes --->
                <cfscript>
					v_classificacao_flag = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_FLAG_CLASSIFICACAO');
					v_classificacao_atributo = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_ATRIBUTO_CLASSIFICACAO');
					v_classificacao_valor = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_VALOR_CLASSIFICACAO');
					v_classificacao_tipo_dado = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_TIPO_DADO_CLASSIFICACAO');
					
					qrClassificacao = conn.get_veiculo_atributo(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrClassificacao">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_classificacao_atributo)#" index="count">
                    	<cfscript>
							if(qrClassificacao.COD_ATRIBUTO eq v_classificacao_atributo[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_atributo(PLACA        = qrClassificacao.PLACA,
                                                            COD_ATRIBUTO = qrClassificacao.COD_ATRIBUTO);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_classificacao_atributo)#" index="count">
					<cfscript>
						if(v_classificacao_tipo_dado[count] eq 'FLAG') {
							if(v_classificacao_valor[count] eq 'Sim') {
								v_classificacao_valor[count] = '1';
							}
							else if(v_classificacao_valor[count] eq 'No') {
								v_classificacao_valor[count] = '0';
							}
						}
						
						ret = this.upd_veiculo_atributo(PLACA        = UCase(REReplace(arguments.PLACA, '-', '')),
														COD_ATRIBUTO = v_classificacao_atributo[count],
														VALOR        = v_classificacao_valor[count]);
                    </cfscript>
                </cfloop>
                <!--- Fim --->
                
                <!--- Altera os permissionrios --->
                <cfscript>
					v_permissionario_data_inicio_old = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_DATA_INICIO_OLD_PERMISSIONARIO');
					v_permissionario_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_COD_PESSOA_PERMISSIONARIO');
					v_permissionario_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_DATA_INICIO_PERMISSIONARIO');
					v_permissionario_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_HORARIO_INICIO_PERMISSIONARIO');
					v_permissionario_data_termino = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_DATA_TERMINO_PERMISSIONARIO');
					v_permissionario_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_HORARIO_TERMINO_PERMISSIONARIO');
					
					qrPermissionario = conn.get_veiculo_permissionario_geral(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrPermissionario">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_permissionario_cod_pessoa)#" index="count">
                    	<cfscript>
							if(qrPermissionario.OLD_DATA_INICIO eq v_permissionario_data_inicio_old[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_permissionario(PLACA       = qrPermissionario.PLACA,
																  COD_PESSOA  = qrPermissionario.COD_PESSOA,
																  DATA_INICIO = qrPermissionario.DATA_INICIO);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_permissionario_cod_pessoa)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_permissionario_data_inicio_old[count]))) {
							ret = this.ins_veiculo_permissionario(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
																  COD_PESSOA  = v_permissionario_cod_pessoa[count],
																  DATA_INICIO = v_permissionario_data_inicio[count] & ' ' & v_permissionario_horario_inicio[count],
																  DATA_FIM    = v_permissionario_data_termino[count] & ' ' & v_permissionario_horario_termino[count]);
						}
						else {
							ret = this.upd_veiculo_permissionario(PLACA       	  = UCase(REReplace(arguments.PLACA, '-', '')),
																  COD_PESSOA  	  = v_permissionario_cod_pessoa[count],
																  DATA_INICIO 	  = v_permissionario_data_inicio[count] & ' ' & v_permissionario_horario_inicio[count],
																  DATA_FIM        = v_permissionario_data_termino[count] & ' ' & v_permissionario_horario_termino[count],
																  OLD_DATA_INICIO = v_permissionario_data_inicio_old[count]);
						}
					</cfscript>
                </cfloop>
                <!--- Fim --->
                
                <!--- Altera os proprietrios de documentos --->
                <cfscript>
					v_proprietario_doc_data_inicio_old = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_DATA_INICIO_OLD_PROPRIETARIO_DOC');
					v_proprietario_doc_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_COD_PESSOA_PROPRIETARIO_DOC');
					v_proprietario_doc_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_DATA_INICIO_PROPRIETARIO_DOC');
					v_proprietario_doc_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_HORARIO_INICIO_PROPRIETARIO_DOC');
					v_proprietario_doc_data_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_DATA_TERMINO_PROPRIETARIO_DOC');
					v_proprietario_doc_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_HORARIO_TERMINO_PROPRIETARIO_DOC');
					
					qrProprietarioDoc = conn.get_veiculo_proprietario_doc_geral(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrProprietarioDoc">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_proprietario_doc_cod_pessoa)#" index="count">
                    	<cfscript>
							if(qrProprietarioDoc.OLD_DATA_INICIO eq v_proprietario_doc_data_inicio_old[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_proprietario_doc(PLACA       = qrProprietarioDoc.PLACA,
																    COD_PESSOA  = qrProprietarioDoc.COD_PESSOA,
																    DATA_INICIO = qrProprietarioDoc.DATA_INICIO);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_proprietario_doc_cod_pessoa)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_proprietario_doc_data_inicio_old[count]))) {
							ret = this.ins_veiculo_proprietario_doc(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
																	COD_PESSOA  = v_proprietario_doc_cod_pessoa[count],
																	DATA_INICIO = v_proprietario_doc_data_inicio[count] & ' ' & v_proprietario_doc_horario_inicio[count],
																	DATA_FIM    = v_proprietario_doc_data_termino[count] & ' ' & v_proprietario_doc_horario_termino[count]);
						}
						else {
							ret = this.upd_veiculo_proprietario_doc(PLACA           = UCase(REReplace(arguments.PLACA, '-', '')),
																	COD_PESSOA      = v_proprietario_doc_cod_pessoa[count],
																	DATA_INICIO 	= v_proprietario_doc_data_inicio[count] & ' ' & v_proprietario_doc_horario_inicio[count],
																	DATA_FIM    	= v_proprietario_doc_data_termino[count] & ' ' & v_proprietario_doc_horario_termino[count],
																	OLD_DATA_INICIO = v_proprietario_doc_data_inicio_old[count]);
						}
					</cfscript>
                </cfloop>
                <!--- Fim --->
                
                <!--- Processa os dados do veculo --->
				<cfscript>
                    ret = this.processa_dados_veiculo(PLACA         = UCase(REReplace(arguments.PLACA, '-', '')),
													  TIPO_OPERACAO = 'U');
                </cfscript>
                <!--- Fim --->
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!--- 
    -- PROPSITO
    -- Altera uma situao
    -- ANDERSONC 23/03/2009 15:26:28 - CRIADO
    --->
    <cffunction name='upd_veiculo_situacao' displayname='Altera uma situao' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_SITUACAO_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='DATA' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_hist_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEICULO_SITUACAO_ID#'  null='#iif(len(trim(arguments.VEICULO_SITUACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
 
    <!--- 
    -- PROPSITO
    -- Altera uma modalidade
    -- ANDERSONC 23/03/2009 15:25:00 - CRIADO
    --->
    <cffunction name='upd_veiculo_modalidade' displayname='Altera uma modalidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_MODALIDADE_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MODALIDADE' required='yes'>
        <cfargument name='DATA' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_modalidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEICULO_MODALIDADE_ID#'  null='#iif(len(trim(arguments.VEICULO_MODALIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODALIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>

    <!--- 
	-- PROPSITO
	-- Altera um proprietrio
	-- ANDERSONC 23/03/2009 15:31:38 - CRIADO
	--->
	<cffunction name='upd_veiculo_proprietario' displayname='Altera um proprietrio' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FIM' required='yes'>
		<cfargument name='OLD_DATA_INICIO' required='yes'>
	    <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_proprietario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
		<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
		<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
		<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
		<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' >
		<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OLD_DATA_INICIO#' >
	    </cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

    <!--- 
    -- PROPSITO
    -- Altera um proprietrio de documentos
    -- ANDERSONC 23/03/2009 16:00:11 - CRIADO
    --->
    <cffunction name='upd_veiculo_proprietario_doc' displayname='Altera um proprietrio de documentos' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='yes'>
        <cfargument name='OLD_DATA_INICIO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_prop_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OLD_DATA_INICIO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>

    <!--- 
    -- PROPSITO
    -- Exclui uma situao
    -- ANDERSONC 23/03/2009 16:17:28 - CRIADO
    --->
    <cffunction name='del_veiculo_situacao' displayname='Exclui uma situao' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_SITUACAO_ID' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_hist_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEICULO_SITUACAO_ID#'  null='#iif(len(trim(arguments.VEICULO_SITUACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui uma modalidade
    -- ANDERSONC 23/03/2009 16:39:43 - CRIADO
    --->
    <cffunction name='del_veiculo_modalidade' displayname='Exclui uma modalidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_MODALIDADE_ID' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_modalidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEICULO_MODALIDADE_ID#'  null='#iif(len(trim(arguments.VEICULO_MODALIDADE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um proprietrio
    -- ANDERSONC 24/03/2009 10:25:37 - CRIADO
    --->
    <cffunction name='del_veiculo_proprietario' displayname='Exclui um proprietrio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_proprietario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um permissionrio
    -- ANDERSONC 24/03/2009 10:59:28 - CRIADO
    --->
    <cffunction name='del_veiculo_permissionario' displayname='Exclui um permissionrio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_permissionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um proprietrio de documentos
    -- ANDERSONC 24/03/2009 11:01:02 - CRIADO
    --->
    <cffunction name='del_veiculo_proprietario_doc' displayname='Exclui um proprietrio de documentos' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_prop_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um laudo
    -- ANDERSONC 24/03/2009 17:49:34 - CRIADO
    --->
    <cffunction name='del_veiculo_laudo_excecao' displayname='Exclui um laudo' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='LAUDO_ID' required='yes'>
            <cfstoredproc procedure='oper.pkg_veiculo_laudos.prc_del_veiculo_laudo_excecao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um atributo
    -- ANDERSONC 24/03/2009 17:55:34 - CRIADO
    --->
    <cffunction name='del_veiculo_atributo' displayname='Exclui um atributo' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_ATRIBUTO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ATRIBUTO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>

    <!--- 
    -- PROPSITO
    -- Altera um permissionrio
    -- ANDERSONC 23/03/2009 15:49:03 - CRIADO
    --->
    <cffunction name='upd_veiculo_permissionario' displayname='Altera um permissionrio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='yes'>
        <cfargument name='OLD_DATA_INICIO' required='yes'>
        <cfargument name='PAIS_AUTORIZADO_TRIC' required='no' default="">
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_permissionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OLD_DATA_INICIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAIS_AUTORIZADO_TRIC#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>

    <!--- 
    -- PROPSITO
    -- Altera um atributo
    -- ANDERSONC 20/03/2009 11:28:39 - CRIADO
    --->
    <cffunction name='upd_veiculo_atributo' displayname='Altera um atributo' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_ATRIBUTO' required='yes'>
        <cfargument name='VALOR' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ATRIBUTO#' >
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' variable='retorno.VALOR' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            </cfstoredproc>
		<cfreturn structnew() />
    </cffunction>

    <!--- 
    -- PROPSITO
    -- Processa os dados de um veculo inserido ou alterado
    -- ANDERSONC 19/03/2009 09:37:47 - CRIADO
    --->
    <cffunction name='processa_dados_veiculo' displayname='Processa os dados de um veculo inserido ou alterado' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='TIPO_OPERACAO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_processa_dados_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TIPO_OPERACAO#' >
            </cfstoredproc>
		<cfreturn structnew() />
    </cffunction>

    <!--- 
    -- PROPSITO
    -- Insere um laudo
    -- ANDERSONC 20/03/2009 14:54:38 - CRIADO
    --->
    <cffunction name='ins_veiculo_laudo_excecao' displayname='Insere um laudo' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='LAUDO_ID' required='yes'>
            <cfstoredproc procedure='oper.pkg_veiculo_laudos.prc_ins_veiculo_laudo_excecao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            </cfstoredproc>
		<cfreturn structnew() />
    </cffunction>

	<!--- 
	-- PROPSITO
	-- Altera local da prxima reviso
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->
	<cffunction name="upd_proxima_revisao" displayname="Altera local da prxima reviso" access="remote" returntype="struct" output="true">
		<cfargument name="controle_id" required="yes">
		<cfargument name="matriz" required="yes">
		<cfargument name="motivo" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				update oper.v$veiculo_revisao
				   set matriz = #arguments.matriz#,
				       motivo = '#arguments.motivo#'
				 where controle_id = #arguments.controle_id#
			</cfquery>

			<cfset retorno.mensagem = 'Local da prxima reviso alterado com sucesso!'>				
			<cfset retorno.erro = false>						
 	  	<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   	</cfcatch>
	   	</cftry>
	   <cfreturn retorno>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere Composio de Veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- Wagner 18/10/2006 - criado
	--->
	
	<cffunction name="set_engate" displayname="Insere composio de veiculo" access="remote" returntype="struct" output="true">
		<cfargument name="placa_1" displayname="Placa do veiculo" required="true">
		<cfargument name="placa_2" displayname="Placa do veiculo" required="true">
		<cfargument name="data" displayname="Placa do veiculo" required="yes">
 	    <cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_veiculo_dml.prc_engate_veiculo" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.placa_1#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.placa_2#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric"  null="yes">
				<cfprocparam type="out" cfsqltype="cf_sql_numeric"  variable="retorno.num_romaneio">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric"  value="0">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.data#:00">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  null="yes">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric"  null="yes">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric"  null="yes">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric"  null="yes">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric"  null="yes">
			</cfstoredproc>
			<cfset retorno.mensagem = 'Composio montada com sucesso.'>				
			<cfset retorno.erro = false>						
 	  	<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   	</cfcatch>
	   	</cftry>
	   	<cfreturn retorno>
	</cffunction>
	
	<!--- 
    -- PROPSITO
    -- Desengata veculo terceiro
    -- guto 31/10/2007 10:34:59 - CRIADO
    --->
    <cffunction name='set_desengate_terceiro' displayname='Desengata veculo terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA_1' required='yes'>
        <cfargument name='PLACA_2' required='yes'>
        <cfargument name='DATA_HORA_ENGATE' required='yes'>
        <cfargument name='DATA_HORA_DESENGATE' required='yes'>
        <cfargument name='KM_DESENGATE' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_veiculo_dml.prc_desengate_veiculo_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_1#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_2#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_HORA_ENGATE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_HORA_DESENGATE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_DESENGATE#'  null='#iif(len(trim(arguments.KM_DESENGATE)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo desengatado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>  	
    <!--- 
	-- PROPSITO
	-- Inserir verificao de laudo.
	-- LEOPOLDOS 25/06/2010 15:05:23 - CRIADO
	--->
	<cffunction name='ins_laudo_verificacao' displayname='Inserir verificao de laudo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='LAUDO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_veiculo_laudos.prc_ins_laudo_verificacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC'   variable='retorno.VERIFICACAO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Verificao inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!--- 
	-- PROPSITO
	-- Inserir um item da verificao de laudo.
	-- LEOPOLDOS 25/06/2010 15:06:36 - CRIADO
	--->
	<cffunction name='ins_laudo_verificacao_item' displayname='Inserir um item da verificao de laudo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='VERIFICACAO_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_veiculo_laudos.prc_ins_laudo_verificacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VERIFICACAO_ID#'  null='#iif(len(trim(arguments.VERIFICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item da verificao inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!--- 
	-- PROPSITO
	-- Insere exceo de Laudo
	-- LEOPOLDOS 21/07/2010 10:28:04 - CRIADO
	--->
	<cffunction name='ins_laudo_excecao' displayname='Insere exceo de Laudo' access='remote' returntype='Struct' output='true'>
		<cfargument name='LAUDO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cftry>
   			<cfset arguments.placa = this.get_placa(arguments.placa)>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_veiculo_laudos.prc_ins_laudo_excecao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Exceo inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    

<!--- 
-- PROPSITO
-- Cadastro do Veculo
-- 07/12/2005 - criado
--->
<cffunction name="ins_veiculo_completo" displayname="Cadastro do Veculo com proprietario e composicao" access="remote" returntype="Struct" output="true">
  <cfargument name="VEICULO_ID" required="no">
  <cfargument name="COD_VEICULO" required="no">
  <cfargument name='PLACA' required='yes'>
  <cfargument name='AGRUPAMENTO_ID' required='yes'>
  <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
  <cfargument name='MARCA_ID' required='yes'>
  <cfargument name='MODELO_ID' required='yes'>
  <cfargument name='UF' required='yes'>
  <cfargument name='ANO' required='yes'>
  <cfargument name='CHASSIS' required='yes'>
  <cfargument name='RENAVAN' required='yes'>
  <cfargument name='COR_PREDOMINANTE' required='yes'>
  <cfargument name='CAPACIDADE_TANQUE' required='no' default="">
  <cfargument name='MUNICIPIO_ID' required='yes'>
  <cfargument name='TAG_SEM_PARAR' required='no'>
  <cfargument name='DATA_INICIO_SEM_PARAR' required='no'>
  <cfargument name='SITUACAO_ID' required='no'>
  <cfargument name='OBSERVACAO' required='no' default="">
  <cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
  <cfargument name='DATA_INICIO_PROPRIETARIO' required='no'>
  <cfargument name='RASTREADOR_ID' required='no'>
  <cfargument name='DATA_INICIO_RASTREADOR' required='no'>
  <cfargument name='NUMERO_EIXOS' required="no">
  <cfargument name='TARA' required="no">
  <cfargument name='COD_PESSOA_MOTORISTA' required="no">
  <cfargument name='DATA_INICIO_MOTORISTA' required='no'>
  <cfargument name='COD_PESSOA_PERMISSIONARIO' required="no">
  <cfargument name='COD_PESSOA_PROPRIETARIO_DOCTO' required="no">
  <cftry>
    <cftransaction action="begin">
      <cfscript>
     			conn = CreateComponent("_transportes.manipulacao.cfc_pessoa");
				connV = CreateComponent("modulos.veiculos._componentes.consulta.cfc_veiculo");
				v_recurso 					= connV.get_recurso_numerico('M201-REC00004');
	     </cfscript>
      <cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
        <cfscript>
		         conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO,num_modalidade = 7);
        </cfscript>
      </cfif>
      <cfif len(trim(arguments.COD_PESSOA_MOTORISTA))>
        <cfscript>
			conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_MOTORISTA,num_modalidade = 8);
		</cfscript>
      </cfif>
		<cfscript>
            if (not len(trim(arguments.VEICULO_ID))){
                  this.ins_veiculos(COD_VEICULO = '#arguments.PLACA#',
                                    PLACA = '#arguments.PLACA#',
                                    MARCA_ID = '#arguments.MARCA_ID#',
                                    MODELO_ID = '#arguments.MODELO_ID#',
                                    UF = '#arguments.UF#',
                                    ANO = '#arguments.ANO#',
                                    CHASSIS = '#arguments.CHASSIS#',
                                    RENAVAN = '#arguments.RENAVAN#',
                                    COR_PREDOMINANTE = '#arguments.COR_PREDOMINANTE#',
                                    MUNICIPIO_ID = '#arguments.MUNICIPIO_ID#',
                                    TAG_SEM_PARAR = '#arguments.TAG_SEM_PARAR#',
                                    DATA_INICIO_SEM_PARAR = '#arguments.DATA_INICIO_SEM_PARAR#',
                                    OBSERVACAO = '#arguments.OBSERVACAO#',
                                    COD_PESSOA_PROPRIETARIO_DOCTO = '#arguments.COD_PESSOA_PROPRIETARIO_DOCTO#',
                                    COD_PESSOA_PROPRIETARIO = '#arguments.COD_PESSOA_PROPRIETARIO#',
                                    DATA_INICIO_PROPRIETARIO = '#arguments.DATA_INICIO_PROPRIETARIO#',
                                    RASTREADOR_ID = '#arguments.RASTREADOR_ID#',
                                    DATA_INICIO_RASTREADOR = '#arguments.DATA_INICIO_RASTREADOR#',
                                    NUMERO_EIXOS = '#arguments.NUMERO_EIXOS#',
                                    TARA = '#arguments.TARA#',
                                    TIPO_CARROCERIA_ID = '#arguments.TIPO_CARROCERIA_ID#',
                                    COD_PESSOA_MOTORISTA = '#arguments.COD_PESSOA_MOTORISTA#',
                                    DATA_INICIO_MOTORISTA = '#arguments.DATA_INICIO_MOTORISTA#',
                                    COD_PESSOA_PERMISSIONARIO = '#arguments.COD_PESSOA_PERMISSIONARIO#');		   
                                }
            else {
                  this.upd_veiculos(VEICULO_ID = '#arguments.VEICULO_ID#',
                                    PLACA = '#arguments.PLACA#',
                                    COD_VEICULO = '#arguments.PLACA#',
                                    MARCA_ID = '#arguments.MARCA_ID#',
                                    MODELO_ID = '#arguments.MODELO_ID#',
                                    UF = '#arguments.UF#',
                                    ANO = '#arguments.ANO#',
                                    CHASSIS = '#arguments.CHASSIS#',
                                    RENAVAN = '#arguments.RENAVAN#',
                                    COR_PREDOMINANTE = '#arguments.COR_PREDOMINANTE#',
                                    CAPACIDADE_TANQUE = '#arguments.CAPACIDADE_TANQUE#',
                                    MUNICIPIO_ID = '#arguments.MUNICIPIO_ID#',
                                    TAG_SEM_PARAR = '#arguments.TAG_SEM_PARAR#',
                                    DATA_INICIO_SEM_PARAR = '#arguments.DATA_INICIO_SEM_PARAR#',
                                    COD_PESSOA_PROPRIETARIO_DOCTO = '#arguments.COD_PESSOA_PROPRIETARIO_DOCTO#',
                                    OBSERVACAO = '#arguments.OBSERVACAO#',
                                    COD_PESSOA_PROPRIETARIO = '#arguments.COD_PESSOA_PROPRIETARIO#',
                                    DATA_INICIO_PROPRIETARIO = '#arguments.DATA_INICIO_PROPRIETARIO#',
                                    RASTREADOR_ID = '#arguments.RASTREADOR_ID#',
                                    DATA_INICIO_RASTREADOR = '#arguments.DATA_INICIO_RASTREADOR#',
                                    NUMERO_EIXOS = '#arguments.NUMERO_EIXOS#',
                                    TARA = '#arguments.TARA#',
                                    TIPO_CARROCERIA_ID = '#arguments.TIPO_CARROCERIA_ID#',
                                    COD_PESSOA_MOTORISTA = '#arguments.COD_PESSOA_MOTORISTA#',
                                    DATA_INICIO_MOTORISTA = '#arguments.DATA_INICIO_MOTORISTA#',
                                    COD_PESSOA_PERMISSIONARIO = '#arguments.COD_PESSOA_PERMISSIONARIO#');		   
            }
                    
        </cfscript>
        
      <cfif v_recurso eq 1>
        
        <cfscript>
			v_fumaca_preta_id = this.ListaToArray (lista = arguments, variavel = "FUMACA_PRETA_ID_MEDICOES");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_MEDICOES, lista2 = ArrayToList(v_fumaca_preta_id, ','));
		</cfscript>
        
		<!--- Excluir os ndices de fumaa preta --->
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				ret = this.cancela_fumaca_preta (fumaca_preta_id = l_id);
			</cfscript>
			<cfif ret.erro>
				<cfthrow object="#ret.mensagem#">
			</cfif>
		</cfloop>
        
		<!--- Insere ITENS --->
        <cfscript>
         	v_fumaca_preta_id	  = this.ListaToArray (lista = arguments, variavel = "FUMACA_PRETA_ID_MEDICOES");
         	v_data       		  = this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_MEDICOES");
           	v_indice        	  = this.ListaToArray (lista = arguments, variavel = "INDICE_MEDICOES");
            v_cod_pessoa_filial	  = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_FILIAL_MEDICOES");
            v_cod_departamento 	  = this.ListaToArray (lista = arguments, variavel = "DEPARTAMENTO_MEDICOES");
            v_cod_setor 		  = this.ListaToArray (lista = arguments, variavel = "SETOR_MEDICOES");
            v_cod_centro_custo 	  = this.ListaToArray (lista = arguments, variavel = "CENTRO_CUSTO_MEDICOES");
            v_cod_organograma 	  = this.ListaToArray (lista = arguments, variavel = "COD_ORGANOGRAMA_MEDICOES");
            v_municipio_id_filial = this.ListaToArray (lista = arguments, variavel = "MUNICIPIO_FUMACA_ID_MEDICOES");
        </cfscript>
		
        
        <cfloop from="1" to="#ArrayLen(v_indice)#" index="count">
			<cfif Len(Trim(v_fumaca_preta_id[count])) lt 1>
            	<cfscript>
					v_indice_fumaca_preta = this.ins_veiculo_fumaca_preta(placa				  = '#arguments.PLACA#'
																		, data 				  = v_data[count]
																		, indice  			  = v_indice[count]
																		, cod_pessoa_filial	  = v_cod_pessoa_filial[count]
																		, cod_departamento    = v_cod_departamento[count]
																		, cod_setor	    	  = v_cod_setor[count]
																		, cod_centro_custo 	  = v_cod_centro_custo[count]
																		, cod_organograma  	  = v_cod_organograma[count]
																		, municipio_id_filial = v_municipio_id_filial[count]
																		 );
            	</cfscript>
			</cfif>
        </cfloop>
      </cfif>
      
      
      <!---Inseres de Carretas--->
      <cfscript>                        
          	v_sr_placa = this.ListaToArray (lista = arguments, variavel = "SR_PLACA_CARRETA");
											v_sr_veiculo_id = this.ListaToArray (lista = arguments, variavel = "SR_VEICULO_ID_CARRETA");
											v_sr_marca_id = this.ListaToArray (lista = arguments, variavel = "SR_MARCA_ID_CARRETA");
											v_sr_modelo_id = this.ListaToArray (lista = arguments, variavel = "SR_MODELO_ID_CARRETA"); 
											v_sr_uf = this.ListaToArray (lista = arguments, variavel = "SR_UF_CARRETA");                           
											v_sr_ano = this.ListaToArray (lista = arguments, variavel = "SR_ANO_CARRETA");
											v_sr_chassis = this.ListaToArray (lista = arguments, variavel = "SR_CHASSIS_CARRETA");
											v_sr_renavan = this.ListaToArray (lista = arguments, variavel = "SR_RENAVAN_CARRETA");
											v_sr_capacidade_tanque = '#arguments.CAPACIDADE_TANQUE#';
											v_sr_cor_predominante =this.ListaToArray (lista = arguments, variavel = "SR_COR_PREDOMINANTE_CARRETA");                            
											v_sr_municipio_id = this.ListaToArray (lista = arguments, variavel = "SR_MUNICIPIO_ID_CARRETA");
											v_sr_tipo_carroceria_id = this.ListaToArray (lista = arguments, variavel = "SR_TIPO_CARROCERIA_ID_CARRETA");
											v_sr_cod_veiculo = this.ListaToArray (lista = arguments, variavel = "SR_COD_VEICULO_CARRETA");				
											v_sr_tag_sem_parar = '#arguments.TAG_SEM_PARAR#';
											v_sr_data_inicio_sem_parar = '#arguments.DATA_INICIO_SEM_PARAR#';
											v_sr_situacao_id = '#arguments.SITUACAO_ID#';
											v_sr_observacao =  '#arguments.OBSERVACAO#';					
											v_sr_cod_pessoa_proprietario_docto = this.ListaToArray (lista = arguments, variavel = "SR_COD_PESSOA_PROPRIETARIO_DOCTO_CARRETA");
											v_sr_cod_pessoa_proprietario = this.ListaToArray (lista = arguments, variavel = "SR_COD_PESSOA_PROPRIETARIO_CARRETA");
											v_sr_data_inicio_proprietario = this.ListaToArray (lista = arguments, variavel = "SR_DATA_INICIO_PROPRIETARIO_CARRETA");
											v_sr_rastreador_id = '#arguments.RASTREADOR_ID#';
											v_sr_rastreador_com_problemas = '#arguments.RASTREADOR_COM_PROBLEMAS#';
											v_sr_data_troca_rastreador =  '#arguments.DATA_TROCA_RASTREADOR#';
											v_sr_data_inicio_rastreador = '#arguments.DATA_INICIO_RASTREADOR#';							
											v_sr_numero_eixos = this.ListaToArray (lista = arguments, variavel = "SR_NUMERO_EIXOS_CARRETA");
											v_sr_tara = this.ListaToArray (lista = arguments, variavel = "SR_TARA_CARRETA");
											v_cod_pessoa_motorista = '#arguments.COD_PESSOA_MOTORISTA#';
											v_cod_pessoa_permissionario = '#arguments.COD_PESSOA_PERMISSIONARIO#';
											v_modalidade = '#arguments.MODALIDADE#';
											v_veiculo_excluir = this.ListDiff(lista1 = arguments.lista_deleted_carreta, lista2 = ArrayToList(v_sr_veiculo_ID, ','));
      </cfscript>
      
      <cfloop list="#v_veiculo_excluir#" delimiters="," index="l_vei_id">
        <cfscript>
/*				this.del_veiculos(
								  VEICULO_ID  = l_vei_id
								 );
*/           </cfscript>
      </cfloop>
      <cfloop from="1" to="#ArrayLen(v_sr_placa)#" index="count">
        <cfscript>
			if(not len(trim(v_sr_veiculo_id[count]))) {
				   this.ins_veiculos(COD_VEICULO = v_sr_cod_veiculo[count],
									 PLACA = v_sr_placa[count],
									 MARCA_ID = v_sr_marca_id[count],
									 MODELO_ID = v_sr_modelo_id[count],
									 UF = v_sr_uf[count],
									 ANO = v_sr_ano[count], 
									 CHASSIS = v_sr_chassis[count],
									 RENAVAN = v_sr_renavan[count],
									 CAPACIDADE_TANQUE = v_sr_capacidade_tanque,
									 COR_PREDOMINANTE = v_sr_cor_predominante[count],
									 MUNICIPIO_ID = v_sr_municipio_id[count],
									 TAG_SEM_PARAR = v_sr_tag_sem_parar,
									 DATA_INICIO_SEM_PARAR = v_sr_data_inicio_sem_parar,													 
									 OBSERVACAO = v_sr_observacao,
									 COD_PESSOA_PROPRIETARIO_DOCTO = v_sr_cod_pessoa_proprietario_docto[count],
									 COD_PESSOA_PROPRIETARIO = v_sr_cod_pessoa_proprietario[count],
									 DATA_INICIO_PROPRIETARIO = v_sr_data_inicio_proprietario[count],
									 RASTREADOR_ID = v_sr_rastreador_id,
									 DATA_INICIO_RASTREADOR = v_sr_data_inicio_rastreador,
									 NUMERO_EIXOS = v_sr_numero_eixos[count],
									 TARA = v_sr_tara[count],
									 COD_PESSOA_MOTORISTA = '',
									 COD_PESSOA_PERMISSIONARIO = v_cod_pessoa_permissionario,
									 TIPO_CARROCERIA_ID = v_sr_tipo_carroceria_id[count]);
			   }else {
					this.upd_veiculos(  VEICULO_ID = v_sr_veiculo_id[count],
										PLACA = v_sr_placa[count],
										COD_VEICULO = v_sr_placa[count],
										MARCA_ID = v_sr_marca_id[count],
										MODELO_ID = v_sr_modelo_id[count],
										UF = v_sr_uf[count],
										ANO = v_sr_ano[count], 
										CHASSIS = v_sr_chassis[count],
										RENAVAN = v_sr_renavan[count],
										CAPACIDADE_TANQUE = v_sr_capacidade_tanque,
										COR_PREDOMINANTE = v_sr_cor_predominante[count],
										MUNICIPIO_ID = v_sr_municipio_id[count],
										TAG_SEM_PARAR = v_sr_tag_sem_parar,
										DATA_INICIO_SEM_PARAR = v_sr_data_inicio_sem_parar,
										OBSERVACAO = v_sr_observacao,
										
										
										
									    COD_PESSOA_PROPRIETARIO_DOCTO =v_sr_cod_pessoa_proprietario_docto[count],
										COD_PESSOA_PROPRIETARIO = v_sr_cod_pessoa_proprietario[count],
										DATA_INICIO_PROPRIETARIO = v_sr_data_inicio_proprietario[count],
										
										
										RASTREADOR_ID = v_sr_rastreador_id,
										RASTREADOR_COM_PROBLEMAS = v_sr_rastreador_com_problemas,
										DATA_TROCA_RASTREADOR =  v_sr_data_troca_rastreador,
										DATA_INICIO_RASTREADOR = v_sr_data_inicio_rastreador,
										NUMERO_EIXOS = v_sr_numero_eixos[count],
										TARA = v_sr_tara[count],
										COD_PESSOA_MOTORISTA = '',
										COD_PESSOA_PERMISSIONARIO = v_cod_pessoa_permissionario,
										MODALIDADE = v_modalidade,
										TIPO_CARROCERIA_ID = v_sr_tipo_carroceria_id[count]);
						}
        </cfscript>
      </cfloop>
      <cfscript>
		retEngate = engata_composicao_terceiro(composicao = arguments.placa&","&arraytoList(v_sr_placa,','), data_engate = LSDateFormat(now())&' '&timeformat(now(),'HH:MM:SS'));
	  </cfscript>
		<cfif isDefined("retEngate") and retEngate.erro >
	        <cfthrow object="#retEngate.mensagem#">
        </cfif><!---
      <cfscript>
			conn = CreateComponent("_transportes.consulta.cfc_veiculo");
			qrVeiculo = conn.get_composicao(cod_veiculo = arguments.placa);
	  </cfscript>
        
      <cfloop from="1" to="#ArrayLen(v_sr_placa)#" index="count">
        <cfscript>
				conn = CreateComponent("_transportes.consulta.cfc_veiculo");
				qrEngate = conn.get_desengate(placa = arguments.COD_VEICULO, somente_engatados = 1);
        </cfscript>
        <cfif len(Trim('#qrEngate.data_hora_engate#'))>
			<cfscript>
				if(count eq 1){	
					retD = this.set_desengate_terceiro(
												PLACA_1 = '#arguments.PLACA#',
												PLACA_2 = v_sr_placa[count],
												DATA_HORA_ENGATE= '#qrEngate.data_hora_engate#', 
												DATA_HORA_DESENGATE= LSDateFormat(Now(), 'dd/mm/yyyy') & ' ' & LSTimeFormat(Now(), 'HH:mm:ss'),
												KM_DESENGATE = '#qrEngate.km_engate#'
												);
				}
        	</cfscript>
            <cfif isDefined("retD") and retD.erro >
            	<cfthrow object="#retD.mensagem#">
            </cfif> 
        </cfif>
      </cfloop>
      
      <cfloop from="2" to="#ArrayLen(v_sr_placa)#" index="count">
        <cfscript> 
			conn = CreateComponent("_transportes.consulta.cfc_veiculo");
			qrEngate = conn.get_desengate(placa = v_sr_placa[count - 1], somente_engatados = 1);
        </cfscript>
        <cfif len(Trim('#qrEngate.data_hora_engate#'))>
			<cfscript>
				if(count eq 2){
					retD2 = this.set_desengate_terceiro(
												PLACA_1 =  v_sr_placa[count - 1],
												PLACA_2 = v_sr_placa[count],
												DATA_HORA_ENGATE= '#qrEngate.data_hora_engate#', 
												DATA_HORA_DESENGATE= LSDateFormat(Now(), 'dd/mm/yyyy') & ' ' & LSTimeFormat(Now(), 'HH:mm:ss'),
												KM_DESENGATE = '#qrEngate.km_engate#'
											   );
				}
			</cfscript>
            <cfif isDefined("retD2") and retD2.erro >
            	<cfthrow object="#retD2.mensagem#">
            </cfif> 
        </cfif>
      </cfloop>
      
      <cfloop from="1" to="#ArrayLen(v_sr_placa)#" index="count">
        <cfscript>
			if(count eq 1){
				
				retE = this.set_engates(
								PLACA_1 = '#arguments.PLACA#',
								PLACA_2 = v_sr_placa[count],
								DATA = LSDateFormat(Now(), 'dd/mm/yyyy') & ' ' & LSTimeFormat(Now(), 'HH:mm:ss'),
								COD_PESSOA_MOTORISTA = v_cod_pessoa_motorista
							);
					}
			if(count eq 2){
				retE = this.set_engates(PLACA_1 = v_sr_placa[count - 1],
							     PLACA_2 = v_sr_placa[count],
							     DATA = LSDateFormat(Now(), 'dd/mm/yyyy') & ' ' & LSTimeFormat(Now(), 'HH:mm:ss'),
							     COD_PESSOA_MOTORISTA = v_cod_pessoa_motorista);
			}
		  </cfscript>
          <cfif isDefined("retE.erro") and retE.erro >
          	<cfthrow object="#retE#" >
          </cfif>
      </cfloop>--->
      
      <cfset retorno.erro = false>
      <cfset retorno.mensagem = JSStringFormat("Veculo cadastrado com sucesso!")>
    </cftransaction>
    <cfcatch>
      <cftransaction action="rollback"/>
	  <cfset retorno.erro = true>
      <cfset retorno.mensagem = cfcatch>
      <cfset request.erro = cfcatch>
    </cfcatch>
  </cftry>
  <cfreturn retorno />
</cffunction>    

<cffunction name="ins_veiculo_fumaca_preta" displayname="Cadastro de fumaa preta do veculo" access="remote" returntype="Struct" output="true">
	<cfargument name="PLACA" required="yes">
	<cfargument name="DATA" required="yes">
	<cfargument name="INDICE" required="yes">
	<cfargument name="COD_PESSOA_FILIAL" required="yes">
	<cfargument name="COD_DEPARTAMENTO" required="yes">
	<cfargument name="COD_SETOR" required="yes">
	<cfargument name="COD_CENTRO_CUSTO" required="yes">
	<cfargument name="COD_ORGANOGRAMA" required="yes">
	<cfargument name="MUNICIPIO_ID_FILIAL" required="yes">
	<cfargument name="FUMACA_PRETA_ID" required="no">
    <cfargument name="ROWID" required="no">
		<cftry>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_fumaca_preta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INDICE#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FILIAL#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DEPARTAMENTO#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_SETOR#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_ORGANOGRAMA#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MUNICIPIO_ID_FILIAL#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   variable='retorno.FUMACA_PRETA_ID'  null="yes" >
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   variable='retorno.ROWID' null="yes" >
            </cfstoredproc> 
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
    	</cftry>
    <cfreturn retorno />
    
</cffunction>

<!---
Propsito: 
Insere dados da lista em veiculos
--->
<cffunction name="ins_veiculos" displayname="Cadastro do Veculo" access="remote" returntype="Struct" output="true">
  <cfargument name="COD_VEICULO" required="no">
  <cfargument name='PLACA' required='yes'>
  <cfargument name='MARCA_ID' required='yes'>
  <cfargument name='MODELO_ID' required='yes'>
  <cfargument name='UF' required='yes'>
  <cfargument name='ANO' required='yes'>
  <cfargument name='CHASSIS' required='yes'>
  <cfargument name='RENAVAN' required='yes'>
  <cfargument name='COR_PREDOMINANTE' required='yes'>
  <cfargument name='CAPACIDADE_TANQUE' required='no' default="">
  <cfargument name='MUNICIPIO_ID' required='yes'>
  <cfargument name='TAG_SEM_PARAR' required='no'>
  <cfargument name='DATA_INICIO_SEM_PARAR' required='no'>
  <cfargument name='SITUACAO_ID' required='no'>
  <cfargument name='OBSERVACAO' required='no'>
  <cfargument name='COD_PESSOA_PROPRIETARIO_DOCTO' required='yes'>
  <cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
  <cfargument name='DATA_INICIO_PROPRIETARIO' required='no'>
  <cfargument name='RASTREADOR_ID' required='no'>
  <cfargument name='DATA_INICIO_RASTREADOR' required='no'>
  <cfargument name="NUMERO_EIXOS" required="yes">
  <cfargument name="COD_PESSOA_MOTORISTA" required="no">
  <cfargument name='DATA_INICIO_MOTORISTA' required='no'>
  <cfargument name="COD_PESSOA_PERMISSIONARIO" required="no">
  <cfargument name="MODALIDADE" required="no">
  <cfargument name="TIPO_CARROCERIA_ID" required="no">  
  <cfset arguments.COD_VEICULO = arguments.PLACA >
  
  <cfscript>
			conn = CreateComponent("_transportes.manipulacao.cfc_pessoa");
	</cfscript>
  <cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
    <cfscript>
             conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO,num_modalidade = 7);
       </cfscript>
  </cfif>
  <cfif len(trim(arguments.COD_PESSOA_MOTORISTA))>
    <cfscript>
            conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_MOTORISTA,num_modalidade = 8);
        </cfscript>
  </cfif>
  <cfif len(trim(arguments.cod_pessoa_permissionario))>
    <cfscript>
              conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO,num_modalidade = 20);
       </cfscript>
  </cfif>

  <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.COD_VEICULO#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHASSIS#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RENAVAN#' > 
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COR_PREDOMINANTE#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_SEM_PARAR#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RASTREADOR_ID#'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#' variable="RETORNO.RASTREADOR_ID">
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_RASTREADOR#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   variable='retorno.VEICULO_ID'  null="yes" >
    <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   variable='retorno.ROWID' null="yes" >
  </cfstoredproc> 
  
  <cfif Len(Trim(arguments.COD_PESSOA_MOTORISTA))>
    <cfscript>
		 set_motorista = this.ins_motorista_veiculo_terc(placa = UCase(REReplace(arguments.PLACA,'-','')),
		 												   cod_pessoa_motorista = arguments.COD_PESSOA_MOTORISTA,
														   km_inicio = 1,
														   data_inicio = arguments.DATA_INICIO_MOTORISTA,
														   data_fim = '');														   
	</cfscript>

    <cfif IsDefined("set_motorista.erro") and set_motorista.erro >
       <cfthrow object="#set_motorista.mensagem#">
    </cfif>
  </cfif>
  
  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
	  <cfscript>	
        set_proprietario = this.ins_veiculo_proprietario(placa = UCase(REReplace(arguments.PLACA,'-','')),
		                                                cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO,
														data_inicio = arguments.DATA_INICIO_PROPRIETARIO);
  	  </cfscript> 
	  <cfif IsDefined("set_proprietario.erro") and set_proprietario.erro >
           <cfthrow object="#set_proprietario.mensagem#">
      </cfif>
  </cfif>

  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO_DOCTO))>
	  <cfscript>	
        set_proprietario_docto = this.ins_veiculo_prop_doc(placa = UCase(REReplace(arguments.PLACA,'-','')),
													       cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO_DOCTO,
													       data_inicio = arguments.DATA_INICIO_PROPRIETARIO);
  	  </cfscript> 
	  <cfif IsDefined("set_proprietario_docto.erro") and set_proprietario_docto.erro >
           <cfthrow object="#set_proprietario_docto.mensagem#">
      </cfif>
  </cfif>
    
  <cfif Len(Trim(arguments.COD_PESSOA_PERMISSIONARIO))>
	  <cfscript>	
        set_permissionario = this.ins_veiculo_permissionario(placa = UCase(REReplace(arguments.PLACA,'-','')),
		                                                     cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO,
														     data_inicio = arguments.DATA_INICIO_PROPRIETARIO);
  	  </cfscript> 
	  <cfif IsDefined("set_permissionario.erro") and set_permissionario.erro >
	       <cfthrow object="#set_situacao.mensagem#">
      </cfif>
  </cfif>  
  
  <cfscript>
     set_modalidade = this.ins_veiculo_modalidade(placa = UCase(REReplace(arguments.PLACA,'-','')),
	                                               modalidade = 'TERCEIRO',
												   data = arguments.DATA_INICIO_PROPRIETARIO,
												   VEICULO_MODALIDADE_ID = '');
  </cfscript>  
  <cfif IsDefined("set_modalidade.erro") and set_modalidade.erro >
       <cfthrow object="#set_situacao.mensagem#">
  </cfif>
  
  <cfscript>
     set_situacao = this.ins_veiculo_hist_situacao(placa = UCase(REReplace(arguments.PLACA,'-','')),
	                                               situacao_id = 1,
												   data = arguments.DATA_INICIO_PROPRIETARIO);
  </cfscript>  
  
  <cfif IsDefined("set_situacao.erro") and  set_situacao.erro >
       <cfthrow object="#set_situacao.mensagem#">
  </cfif>  
  
  <cfif len(trim(arguments.TARA))>
    <cfstoredproc procedure="oper.pkg_frota_dml.PRC_ALT_VEICULO_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
      <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="TARA">
      <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TARA#">
	  <cfprocparam cfsqltype='CF_SQL_VARCHAR' type='OUT'   variable='retorno.ROWID' >
    </cfstoredproc>
  </cfif>
  <cfif len(trim(arguments.NUMERO_EIXOS))>
    <cfstoredproc procedure="oper.pkg_frota_dml.PRC_ALT_VEICULO_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
      <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="NUMERO_EIXOS">
      <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.NUMERO_EIXOS#">
	  <cfprocparam cfsqltype='CF_SQL_VARCHAR' type='OUT'  variable='retorno.ROWID' >
    </cfstoredproc>
  </cfif>

  <cfstoredproc procedure="oper.pkg_frota_dml.prc_atualiza_atributo_terceiro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
     <cfprocparam  type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
  </cfstoredproc>
  <cfreturn structnew() />
</cffunction>

<!---altera dados  da lista em veiculos--->
<cffunction name="upd_veiculos" displayname="Altera dados do Veculo" access="remote" returntype="Struct" output="true">
  <cfargument name="VEICULO_ID" required="no">
  <cfargument name="COD_VEICULO" required="no">
  <cfargument name='PLACA' required='yes'>
  <cfargument name='MARCA_ID' required='yes'>
  <cfargument name='MODELO_ID' required='yes'>
  <cfargument name='UF' required='yes'>
  <cfargument name='ANO' required='yes'>
  <cfargument name='CHASSIS' required='yes'>
  <cfargument name='RENAVAN' required='yes'>
  <cfargument name='COR_PREDOMINANTE' required='yes'>
  <cfargument name='CAPACIDADE_TANQUE' required='no' default="">
  <cfargument name='MUNICIPIO_ID' required='yes'>
  <cfargument name='TAG_SEM_PARAR' required='no'>
  <cfargument name='DATA_INICIO_SEM_PARAR' required='no'>
  <cfargument name='SITUACAO_ID' required='no'>
  <cfargument name='OBSERVACAO' required='no' default="">
  <cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
  <cfargument name='DATA_INICIO_PROPRIETARIO' required='no'>
  <cfargument name='RASTREADOR_ID' required='no'>
  <cfargument name='RASTREADOR_COM_PROBLEMAS' required="no" default="">
  <cfargument name='DATA_TROCA_RASTREADOR' required="no" default="">
  <cfargument name='DATA_INICIO_RASTREADOR' required='no'>
  <cfargument name="NUMERO_EIXOS" required="yes">
  <cfargument name="COD_PESSOA_MOTORISTA" required="no">
  <cfargument name="COD_PESSOA_PERMISSIONARIO" required="no">
  <cfstoredproc procedure="oper.pkg_frota_dml.PRC_ALT_VEICULO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_VEICULO#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHASSIS#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RENAVAN#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COR_PREDOMINANTE#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_SEM_PARAR#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RASTREADOR_ID#'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RASTREADOR_COM_PROBLEMAS#'  null='#iif(len(trim(arguments.RASTREADOR_COM_PROBLEMAS)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TROCA_RASTREADOR#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
  </cfstoredproc>
  
  <cfif Len(Trim(arguments.COD_PESSOA_MOTORISTA))>
    <cfscript>
		 set_motorista = this.ins_motorista_veiculo_terc(placa = UCase(REReplace(arguments.PLACA,'-','')),
		 												   cod_pessoa_motorista = arguments.COD_PESSOA_MOTORISTA,
														   km_inicio = 1,
														   data_inicio = arguments.DATA_INICIO_MOTORISTA,
														   data_fim = '');														   
	</cfscript>

    <cfif IsDefined("set_motorista.erro") and set_motorista.erro >
       <cfthrow object="#set_motorista.mensagem#">
    </cfif>
  <cfelse>
    <cfscript>
		 set_motorista = this.remove_motorista_veiculo_terc(cod_pessoa_motorista = arguments.COD_PESSOA_MOTORISTA,
															data_fim = '',
															placa = UCase(REReplace(arguments.PLACA,'-',''))
														   );														   
	</cfscript>
	<cfif IsDefined("set_motorista.erro") and set_motorista.erro >
       <cfthrow object="#set_motorista.mensagem#">
    </cfif>
  </cfif>
  
  <!---Atualiza proprietrio--->
  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
     <cfscript>
        ret = this.prc_atualiza_veiculo_prop(placa = UCase(REReplace(arguments.PLACA,'-',''))
										    ,COD_PESSOA_PROPRIETARIO = arguments.COD_PESSOA_PROPRIETARIO
										    ,proprietario_desde = arguments.DATA_INICIO_PROPRIETARIO);
     </cfscript>
	 <cfif ret.erro>
        <cfthrow object="#ret.mensagem#">
     </cfif>	 
  </cfif>
  
  <!---Atualiza proprietrio--->
  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO_DOCTO))>
     <cfscript>
        ret = this.prc_atualiza_veiculo_prop_doc(placa = UCase(REReplace(arguments.PLACA,'-',''))
												,COD_PESSOA_PROPRIETARIO = arguments.COD_PESSOA_PROPRIETARIO_DOCTO
												,proprietario_desde = arguments.DATA_INICIO_PROPRIETARIO);
     </cfscript>
	 <cfif ret.erro>
        <cfthrow object="#ret.mensagem#">
     </cfif>	 
  </cfif>
  
  <!---Atualiza Permissionrio--->
  <cfif Len(Trim(arguments.COD_PESSOA_PERMISSIONARIO))>
     <cfscript>
        ret = this.prc_atualiza_veiculo_permis(placa = UCase(REReplace(arguments.PLACA,'-',''))
											  ,COD_PESSOA_PROPRIETARIO = arguments.COD_PESSOA_PERMISSIONARIO
											  ,proprietario_desde = arguments.DATA_INICIO_PROPRIETARIO);
     </cfscript>
	 <cfif ret.erro>
        <cfthrow object="#ret.mensagem#">
     </cfif>	 
  </cfif>  
  
  <!---Atualiza Modaliade Atual--->
  <cfquery name="qrModalidade" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
     select max(modalidade) keep(dense_rank last order by data) modalidade
       from oper.v$veiculo_modalidade
      where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'                       
  </cfquery>			
  
  <cfif qrModalidade.MODALIDADE neq 'TERCEIRO'>
	  <cfscript>
         set_modalidade = this.ins_veiculo_modalidade(placa = UCase(REReplace(arguments.PLACA,'-','')),
                                                      modalidade = 'TERCEIRO',
                                                      data = DateFormat(now(),'dd/mm/yyyy hh:mm:ss'),
                                                      VEICULO_MODALIDADE_ID = '');
      </cfscript>  
      <cfif IsDefined("set_modalidade.erro") and set_modalidade.erro >
           <cfthrow object="#set_modalidade.mensagem#">
      </cfif>
  </cfif>
  
  <!---Atualiza situao--->
  <cfscript>
	 set_situacao = this.prc_atualiza_veiculo_situacao(placa = UCase(REReplace(arguments.PLACA,'-','')),
												       situacao_id = 1);
  </cfscript>  
  <cfif IsDefined("set_situacao.erro") and set_situacao.erro >
	   <cfthrow object="#set_situacao.mensagem#">
  </cfif>
    
  <cfif len(trim(arguments.TARA))>
    <cfstoredproc procedure="oper.pkg_frota_dml.PRC_ALT_VEICULO_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
      <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="TARA">
      <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TARA#">
	  <cfprocparam cfsqltype='CF_SQL_VARCHAR' type='OUT'   variable='retorno.ROWID' >
    </cfstoredproc>
  </cfif>
  <cfif len(trim(arguments.NUMERO_EIXOS))>
    <cfstoredproc procedure="oper.pkg_frota_dml.PRC_ALT_VEICULO_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      <cfprocparam  	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
      <cfprocparam 	type="in"	cfsqltype="cf_sql_varchar" value="NUMERO_EIXOS">
      <cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.NUMERO_EIXOS#">
	  <cfprocparam cfsqltype='CF_SQL_VARCHAR' type='OUT'  variable='retorno.ROWID' >
    </cfstoredproc>
  </cfif>  
  <cfreturn structnew() />  
</cffunction>

<!--- 
-- PROPSITO
-- Insere motorista a veiculo terceiro
-- GUTO 24/06/2011 09:13:51 - CRIADO
--->
<cffunction name='ins_motorista_veiculo_terc' displayname='Insere motorista a veiculo terceiro' access='remote' returntype='Struct' output='true'>
	<cfargument name='PLACA' required='yes'>
	<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
	<cfargument name='KM_INICIO' required='yes'>
	<cfargument name='DATA_INICIO' required='yes'>
	<cftry>
		<!---<cftransaction action='begin'>--->
			<cfstoredproc procedure='oper.pkg_motorista.prc_ins_motorista_veiculo_terc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_INICIO#'  null='#iif(len(trim(arguments.KM_INICIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Recebimento de veiculo executado com sucesso!')>
		<!---</cftransaction>--->
		<cfcatch>
			<!---<cftransaction action='rollback'/>--->
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui motorista a veiculo terceiro atual
-- GUTO 24/06/2011 09:16:19 - CRIADO
--->
<cffunction name='del_motorista_veiculo_terc' displayname='Exclui motorista a veiculo terceiro atual' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='oper.pkg_motorista.prc_del_motorista_veiculo_terc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Recebimento de veiculo excludo com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Insere Composio de Veculo
-- NOTAS EXPLICATIVAS
--  
-- Wagner 18/10/2006 - criado
--->
<cffunction name="set_engates" displayname="Insere composio de veiculo" access="remote" returntype="struct" output="true">
  <cfargument name="placa_1"  required="true">
  <cfargument name="placa_2"  required="true">
  <cfargument name="data" required="no" default="">
  <cfargument name="cod_pessoa_motorista" required="no" default="">
  <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_frota_dml.prc_engate_veiculo" username="#session.usuario#" password="#session.senha#">
    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.placa_1#">
    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.placa_2#">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric"  value='#arguments.cod_pessoa_motorista#'  null='#iif(len(trim(arguments.cod_pessoa_motorista)), de('no'), de('yes'))#'> 
    <cfprocparam type="out" cfsqltype="cf_sql_numeric"  variable="retorno.num_romaneio">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric"  value="0">
    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.data#">
    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  null="yes">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric"  null="yes">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric"  null="yes">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric"  null="yes">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric"  null="yes">
  </cfstoredproc>
  <cfreturn structnew() />
</cffunction>

<!--- 
    -- PROPSITO
    -- Insere nova modalidade
    -- guto 09/04/2008 09:24:21 - CRIADO
    --->
    <cffunction name='ins_veiculo_modalidade' displayname='Insere nova modalidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MODALIDADE' required='yes'>
        <cfargument name='DATA' required='yes'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_modalidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODALIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   variable='retorno.VEICULO_MODALIDADE_ID'  null='yes'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Vincula proprietrio ao veculo 
    -- guto 17/07/2007 16:34:43 - CRIADO
    --->
    <cffunction name='ins_veiculo_proprietario' displayname='Vincula proprietrio ao veculo ' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='no' default="">
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_proprietario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction> 

	<!--- 
    -- PROPSITO
    -- Vincula permissionrio ao veculo 
    -- guto 17/07/2007 16:46:28 - CRIADO
    --->
    <cffunction name='ins_veiculo_permissionario' displayname='Vincula permissionrio ao veculo ' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='no' default="">
        <cfargument name='PAIS_AUTORIZADO_TRIC' required='no' default="">
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_permissionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAIS_AUTORIZADO_TRIC#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>   

<!--- 
-- PROPSITO
-- Insere proprietario documentacao do veiculo
-- GUTO 24/06/2011 15:16:36 - CRIADO
--->
<cffunction name='ins_veiculo_prop_doc' displayname='Insere proprietario documentacao do veiculo' access='remote' returntype='Struct' output='true'>
	<cfargument name='PLACA' required='yes'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='DATA_INICIO' required='yes'>
	<cfargument name='DATA_FIM' required='no' default="">
	<cftry>
			<cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_prop_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Proprietrio inserido com sucesso!')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
    -- PROPSITO
    -- Vincula proprietrio ao veculo docto
    -- guto 17/07/2007 16:34:43 - CRIADO
    --->
    <cffunction name='ins_veiculo_proprietario_doc' displayname='Vincula proprietrio ao veculo ' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='no' default="">
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_prop_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>    

<!--- 
-- PROPSITO
-- Insere situao ao veiculo
-- GUTO 24/06/2011 15:33:06 - CRIADO
--->
<cffunction name='ins_veiculo_hist_situacao' displayname='Insere situao ao veiculo' access='remote' returntype='Struct' output='no'>
	<cfargument name='PLACA' required='yes'>
	<cfargument name='SITUACAO_ID' required='yes'>
	<cfargument name='DATA' required='yes'>
	<cfargument name='VEICULO_SITUACAO_ID' required='no' default="">
	<cftry>
			<cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_hist_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEICULO_SITUACAO_ID#' variable='retorno.VEICULO_SITUACAO_ID'  null='#iif(len(trim(arguments.VEICULO_SITUACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Situao inserido com sucesso!')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!--- 
	-- PROPSITO
	-- Atualiza o Proprietrio de um Veculo Terceiro
	-- RAFAEL 16/10/2009 15:40:53 - CRIADO
	--->
	<cffunction name='prc_atualiza_veiculo_prop' displayname='Atualiza o Proprietrio de um Veculo Terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='PROPRIETARIO_DESDE' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_frota_dml.prc_atualiza_veiculo_prop' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PROPRIETARIO_DESDE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Proprietrio alterado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza o Proprietrio de um Veculo Terceiro
	-- RAFAEL 16/10/2009 15:40:53 - CRIADO
	--->
	<cffunction name='prc_atualiza_veiculo_prop_doc' displayname='Atualiza o Proprietrio de um Veculo Terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='PROPRIETARIO_DESDE' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_frota_dml.prc_atualiza_veiculo_prop_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PROPRIETARIO_DESDE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Proprietrio alterado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza o Permissionrio de um Veculo Terceiro
	-- RAFAEL 16/10/2009 15:40:53 - CRIADO
	--->
	<cffunction name='prc_atualiza_veiculo_permis' displayname='Atualiza o Permissionrio de um Veculo Terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='PROPRIETARIO_DESDE' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_frota_dml.prc_atualiza_veiculo_permis' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PROPRIETARIO_DESDE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Permissionrio alterado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Atualizar Situao de um Veculo
	-- RAFAEL 24/10/2011 10:27:38 - CRIADO
	--->
	<cffunction name='prc_atualiza_veiculo_situacao' displayname='Atualizar Situao de um Veculo' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_frota_dml.prc_atualiza_veiculo_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere KM inicial para o veiculo
    -- GUTO 06/06/2012 09:36:34 - CRIADO
    --->
    <cffunction name='ins_veiculo_km_inicializacao' displayname='Insere KM inicial para o veiculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_ID' required='yes'>
        <cfargument name='DATA_INICIALIZACAO' required='yes'>
        <cfargument name='KM' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_km_inicializacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEICULO_ID#'  null='#iif(len(trim(arguments.VEICULO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIALIZACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM#'  null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('KM inicial registrado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui KM inicial para o veiculo
    -- GUTO 06/06/2012 09:37:59 - CRIADO
    --->
    <cffunction name='del_veiculo_km_inicializacao' displayname='Exclui KM inicial para o veiculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_km_inicializacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEICULO_ID#'  null='#iif(len(trim(arguments.VEICULO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('KM inicial excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


	<!--- 
    -- PROPSITO
    -- Exclui KM inicial para o veiculo
    -- GUTO 06/06/2012 09:37:59 - CRIADO
    --->
    <cffunction name='engata_composicao_terceiro' displayname='Exclui KM inicial para o veiculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='COMPOSICAO' required='yes'>
        <cfargument name='DATA_ENGATE' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_engata_composicao_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.COMPOSICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.DATA_ENGATE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' SCALE='5'   value='1' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Composicao engatada com sucesso')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Alterar Placa
    -- GUTO - CRIADO
    --->
    <cffunction name='alterar_placa' displayname='Altera Placa' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA_ATUAL' required='yes'>
        <cfargument name='PLACA_NOVA' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_altera_placa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.PLACA_ATUAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.PLACA_NOVA#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Placa alterada com sucesso')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
-- PROPSITO
-- Remove motorista de veiculo terceiro
-- WELLINGTON 30/05/2019 10:17 - CRIADO
--->
<cffunction name='remove_motorista_veiculo_terc' displayname='Remove motorista de veiculo terceiro' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
	<cfargument name='DATA_FIM' required='yes'>
	<cfargument name='PLACA' required='yes'>
	<cftry>
		<!---<cftransaction action='begin'>--->
			<cfstoredproc procedure='oper.pkg_motorista.prc_remove_mot_veic_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.DATA_FIM#'  null='#iif(len(trim(arguments.DATA_FIM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' null='#iif(len(trim(arguments.PLACA)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Motorista removido com sucesso!')>
		<!---</cftransaction>--->
		<cfcatch>
			<!---<cftransaction action='rollback'/>--->
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<cffunction name='gerar_relatorio_motorista' displayname='Gerar Relatorio de Motorista' access='remote' returntype='Struct' output='true'>
	<cfargument name='PLACA' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='oper.pkg_veiculo.prc_gera_relatorio_composicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.PLACA#'  null='#iif(len(trim(arguments.PLACA)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
			</cfstoredproc>
            <cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Relatorio gerado com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
</cfcomponent>
