<html>
<cfinclude template="/_scripts/scripts.cfm" />
<cfinclude template="/_include/carregando.cfm" />

<cfscript>
    v_possui_acao_quitar_contr = 0;
    v_possui_acao_debito = 0;
    v_possui_acao_credito = 0;

    if(!IsDefined("vars.web_url")){
	   vars.web_url = '/modulos/valecard/lista_contratos/filtro.cfm';
	}

    conn = CreateComponent("modulos.valecard._componentes.consulta.cfc_acesso");
    qrAcaoUsuario = conn.get_acao_usuario(web_url = vars.web_url);
</cfscript>

<cfloop query="qrAcaoUsuario">
	<cfscript>
		if(qrAcaoUsuario.COD_ACAO eq 'M353_VALECARD_QUITAR_CONTRATO' and v_possui_acao_quitar_contr eq 0) {
			v_possui_acao_quitar_contr = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'M353_VALECARD_DEBITO_CONTRATO' and v_possui_acao_debito eq 0) {
			v_possui_acao_debito = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'M353_VALECARD_CREDITO_CONTRATO' and v_possui_acao_credito eq 0) {
			v_possui_acao_credito = 1;
		}

	</cfscript>
</cfloop>


<cfscript>
	conn       = CreateComponent("modulos.valecard._componentes.consulta.cfc_valecard");
	qrContrato = conn.get_contrato(argumentCollection = vars);

	if(v_possui_acao_quitar_contr eq 1) {
		conn          = CreateComponent("modulos.valecard._componentes.consulta.cfc_funcionario");
		qrOrganograma = conn.get_organograma();
	}
</cfscript>

<script src="/_scripts/dragdrop/drag.js" type="text/javascript"></script>
<script type="text/javascript">
	// Configura botoes //
	parent.f_set_texto('titulo_aplicacao', 'Valecard');
	parent.f_set_texto('titulo_pagina', 'Lista de Contratos');

	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); }

	parent.f_hidden('btn_incluir');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	parent.f_hidden('btn_confirmar');

	f_cria_botao('filtro','Filtro',"window.location = 'filtro.cfm';", parent.document.getElementById('barra_botoes_top'));

	// -------------------- //

	<cfif v_possui_acao_quitar_contr eq 1>
		var v_departamento = [];
		var v_setor		   = [];
		var v_centro_custo = [];

		<cfoutput query="qrOrganograma">
			v_departamento.push( {
				cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
				cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
				departamento: 	  '#JSStringFormat(qrOrganograma.DEPARTAMENTO)#'
			} );
		</cfoutput>

		<cfoutput query="qrOrganograma">

			v_setor.push( {
				cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
				cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
				cod_setor:		  '#JSStringFormat(qrOrganograma.COD_SETOR)#',
				setor:			  '#JSStringFormat(qrOrganograma.SETOR)#'
			} );

		</cfoutput>

		<cfoutput query="qrOrganograma">
			v_centro_custo.push( {
				cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
				cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
				cod_setor:		  '#JSStringFormat(qrOrganograma.COD_SETOR)#',
				cod_centro_custo: '#JSStringFormat(qrOrganograma.COD_CENTRO_CUSTO)#',
				centro_custo: 	  '#JSStringFormat(qrOrganograma.CENTRO_CUSTO)#',
				cod_organograma:  '#JSStringFormat(qrOrganograma.COD_ORGANOGRAMA)#'
			} );
		</cfoutput>
	</cfif>

	var setObrigatorio  = [];
	var setLimparCampos = [];

	setObrigatorio['quitar_contrato'] = function(p_valor, p_quitacao_quebra_peso) {
		with(document.forms[0]) {
			<cfif v_possui_acao_quitar_contr eq 1>
				if(p_valor == 1 && p_quitacao_quebra_peso == 1) {
					PESO_ENTREGA.setAttribute('obrigatorio', p_valor);
				}
				else {
					PESO_ENTREGA.setAttribute('obrigatorio', 0);
				}
			</cfif>
		}
	}

	setLimparCampos['quitar_contrato'] = function() {
		with(document.forms[0]) {
			<cfif v_possui_acao_quitar_contr eq 1>
				PESO_ENTREGA.value = '';
			</cfif>
		}
	}

		var p = new PopupMenu('pop');
	p.addItem('imn_atualizar', 					 'Atualizar...', 					  '/_imagens/botoes/16x16/atualizar.gif', 				  function() { f_atualizar(); });
	p.addSeparator('ims_1');
	p.addItem('imn_reintegrar_contrato',         'Reintegrar Contrato...',            '/_imagens/botoes/16x16/engrenagem.gif', 				  function() { f_reintegrar_contrato(); });
	p.addItem('imn_cancelar_contrato', 			 'Cancelar Contrato...', 			  '/_imagens/botoes/16x16/cancelar.gif', 				  function() { f_cancelar_contrato(); });
	p.addItem('imn_consultar_dados_viagem', 	 'Consultar Dados da Viagem...', 	  '/_imagens/botoes/16x16/lista_veiculos.gif', 			  function() { f_consultar_dados_viagem(); });
	p.addItem('imn_reimprimir_contrato', 		 'Reimprimir Contrato...', 			  '/_imagens/botoes/16x16/imprimir.gif', 				  function() { f_reimprimir_contrato(); });
	p.addItem('imn_consultar_dados_contrato', 	 'Consultar Dados do Contrato...', 	  '/_imagens/botoes/16x16/consultar_contrato_pagbem.gif',  function() { f_consultar_dados_contrato(); });

	<cfif v_possui_acao_debito eq 1>
	   p.addItem('imn_inserir_debito_contrato', 	 'Inserir Dbito no Contrato(Operao no suportada pela Valecard)', 	  '/_imagens/botoes/16x16/nota_debito.gif', 			  function() { f_inserir_debito_contrato(); });
	</cfif>

	<cfif v_possui_acao_credito eq 1>
	   p.addItem('imn_inserir_credito_contrato', 	 'Inserir Crdito no Contrato(Operao no suportada pela Valecard)', 	  '/_imagens/botoes/16x16/nota_credito.gif', 			  function() { f_inserir_credito_contrato(); });
	</cfif>

	<cfif v_possui_acao_quitar_contr eq 1>
	   p.addItem('imn_quitar_contrato', 			 'Quitar Contrato...', 				  '/_imagens/botoes/16x16/quitar_contrato_pagbem.gif', 	  function() { f_mostrar_div_quitar(); });
	</cfif>

	function f_context(event, p_contrato_id, p_lancto_id, p_tipo_contrato, p_situacao_id, p_contrato_quitado, p_data_autorizacao, p_quitacao_quebra_peso, p_data_cancelamento) {
		with(document.forms[0]) {
			CONTRATO_ID.value          = p_contrato_id;
			LANCTO_ID.value            = p_lancto_id;
			QUITACAO_QUEBRA_PESO.value = p_quitacao_quebra_peso;

			if(Number(p_situacao_id) != 2) {
				p.itemIds['imn_reintegrar_contrato'].setVisible(true);
			}
			else {
				p.itemIds['imn_reintegrar_contrato'].setVisible(false);
			}

			p.itemIds['imn_cancelar_contrato'].setVisible(true);
			p.itemIds['imn_consultar_dados_viagem'].setVisible(true);

			if(p_data_cancelamento.trim() == '') {
				p.itemIds['imn_reimprimir_contrato'].setVisible(true);
			}else{
				p.itemIds['imn_reimprimir_contrato'].setVisible(false);
			}


			p.itemIds['imn_consultar_dados_contrato'].setVisible(true);

			<cfif v_possui_acao_quitar_contr eq 1>
				if(Number(p_contrato_quitado) == 0) {
					p.itemIds['imn_quitar_contrato'].setVisible(true);
				}
				else {
					p.itemIds['imn_quitar_contrato'].setVisible(false);
				}
			<cfelse>
				p.itemIds['imn_quitar_contrato'].setVisible(false);
			</cfif>

			<cfif v_possui_acao_debito eq 1>
				p.itemIds['imn_inserir_debito_contrato'].setVisible(true);
			<cfelse>
				p.itemIds['imn_inserir_debito_contrato'].setVisible(false);
			</cfif>

			<cfif v_possui_acao_credito eq 1>
				p.itemIds['imn_inserir_credito_contrato'].setVisible(true);
			<cfelse>
				p.itemIds['imn_inserir_credito_contrato'].setVisible(false);
			</cfif>

			return p.contextMenu(event);
		}
	}

	function f_reintegrar_contrato() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/modulos/valecard/lista_contratos/integrar_contrato.cfm</cf_url>?contrato_id=' + CONTRATO_ID.value, 'IntegrarContrato', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_cancelar_contrato() {
		with(document.forms[0]) {
			if(LANCTO_ID.value != '') {
				f_abrir_janela('/modulos/contratotransp/emitir/cancelar.cfm?lancto_id='+LANCTO_ID.value + '&tipo_pagto_id=8', 'f_atualizar()','600', '200');
			}
			else {
				if(confirm('Tem certeza que deseja cancelar este Contrato Valecard?')) {
					OPERACAO.value = 2;

					target = 'consultas';
					action = 'confirma.cfm';
					method = 'post';
					submit();
					method = 'get';
				}
			}
		}
	}

	function f_consultar_dados_viagem() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/modulos/valecard/lista_contratos/dados_viagem.cfm</cf_url>?contrato_id=' + CONTRATO_ID.value, 'DadosViagem', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_reimprimir_contrato() {
		with(document.forms[0]) {
			CONSULTA.value = 1;

			target = 'consultas';
			action = 'consultas.cfm';
			submit();
		}
	}

	function f_consultar_dados_contrato() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/modulos/valecard/lista_contratos/dados_contrato.cfm</cf_url>?contrato_id=' + CONTRATO_ID.value, 'DadosContrato', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_inserir_debito_contrato() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/modulos/valecard/lista_contratos/movimentos_contrato.cfm</cf_url>?contrato_id=' + CONTRATO_ID.value + '&debito_credito=1', 'DebitoCredito', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_inserir_credito_contrato() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/modulos/valecard/lista_contratos/movimentos_contrato.cfm</cf_url>?contrato_id=' + CONTRATO_ID.value + '&debito_credito=2', 'DebitoCredito', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_ocultar_divs() {
		setLimparCampos['quitar_contrato']();

		<cfif v_possui_acao_quitar_contr eq 1>
			f_ocultar_div_quitar();
		</cfif>
	}

	<cfif v_possui_acao_quitar_contr eq 1>
		function f_mostrar_div_quitar() {
			f_ocultar_divs();
			setObrigatorio['quitar_contrato'](1);

			obj = document.getElementById('div_quitar');
			f_get_scroll();

			if(obj.style.display == 'none') {
				setTimeout("document.getElementById('div_quitar').style.display = '';", 100);
				obj.style.top = window.event.clientY + scrOfY;
				obj.style.left = 20 + scrOfX;
			}
		}

		function f_ocultar_div_quitar() {
			document.getElementById('div_quitar').style.display = 'none';
		}

		function f_quitar_contrato() {
			with(document.forms[0]) {
				OPERACAO.value = 4;

				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}

		function f_reimprimir_recibo_pagamento() {
			with(document.forms[0]) {
				CONSULTA.value = 2;

				target = 'consultas';
				action = 'consultas.cfm';
				submit();
			}
		}
	</cfif>

		function f_executar_operacao(p_contrato_id, p_lancto_id, p_quitacao_quebra_peso, p_operacao, p_processo_transporte_codigo, p_placa_cavalo) {
		with(document.forms[0]) {
			CONTRATO_ID.value             = p_contrato_id;
			LANCTO_ID.value               = p_lancto_id;
			QUITACAO_QUEBRA_PESO.value    = p_quitacao_quebra_peso;
			PROCESSO_TRANSPORTE_CODIGO.value = p_processo_transporte_codigo;
			PLACA_CAVALO.value            = p_placa_cavalo;

			switch(p_operacao) {
				case 'REINTEGRAR':
				    f_reintegrar_contrato();
					break;
				case 'CANCELAR':
				    f_cancelar_contrato();
					break;
				case 'CONSULTAR_DADOS_VIAGEM':
					f_consultar_dados_viagem();
					break;
				case 'REIMPRIMIR':
					f_reimprimir_contrato();
					break;
				case 'CONSULTAR_VALECARD':
					f_consultar_dados_contrato();
					break;
				<cfif v_possui_acao_quitar_contr eq 1>
					case 'QUITAR':
						f_mostrar_div_quitar();
						break;
				</cfif>

				<cfif v_possui_acao_credito eq 1>
					case 'INSERIR_CREDITO':
						f_inserir_credito_contrato();
						break;
				</cfif>

				<cfif v_possui_acao_debito eq 1>
					case 'INSERIR_DEBITO':
						f_inserir_debito_contrato();
						break;
				</cfif>

				default:
					alert('Operao no programada.');
					break;
			}
		}
	}

	<cfif v_possui_acao_quitar_contr eq 1>
		function f_busca_departamento() {
			with(document.forms[0]) {
				var v_inserir;

				f_limpa_select(COD_DEPARTAMENTO);
				f_limpa_select(COD_SETOR);
				f_limpa_select(COD_CENTRO_CUSTO);

				f_cria_option('', '-- Selecione um Departamento --', COD_SETOR);
				f_cria_option('', '-- Selecione um Setor --', COD_CENTRO_CUSTO);

				if(!COD_PESSOA_FILIAL.value) {
					f_cria_option('', '-- Selecione uma Filial --', COD_DEPARTAMENTO);

					return;
				}

				f_cria_option('', '-- Selecione --', COD_DEPARTAMENTO);

				for(var i = 0; i < v_departamento.length; i++) {
					if(Number(v_departamento[i].cod_pessoa) == Number(COD_PESSOA_FILIAL.value)) {
						v_inserir = true;

						for(var j = 0; j < COD_DEPARTAMENTO.options.length; j++) {
							if(Number(COD_DEPARTAMENTO.options[j].value) == Number(v_departamento[i].cod_departamento)) {
								v_inserir = false;
							}
						}

						if(v_inserir) {
							f_cria_option(v_departamento[i].cod_departamento, v_departamento[i].cod_departamento + ' - ' + v_departamento[i].departamento, COD_DEPARTAMENTO);
						}
					}
				}

				if(COD_DEPARTAMENTO.options.length == 0) {
					f_cria_option('', '-- Esta Filial no possui nenhum Departamento --', COD_DEPARTAMENTO);
				}
				else if(COD_DEPARTAMENTO.options.length == 2) {
					COD_DEPARTAMENTO.options[0] = null;
					COD_DEPARTAMENTO.options[0].selected = true;
					COD_DEPARTAMENTO.onchange();
				}
			}
		}

		function f_busca_setor() {
			with(document.forms[0]) {
				var v_inserir;

				f_limpa_select(COD_SETOR);
				f_limpa_select(COD_CENTRO_CUSTO);

				f_cria_option('', '-- Selecione um Setor --', COD_CENTRO_CUSTO);

				if(!COD_DEPARTAMENTO.value) {
					f_cria_option('', '-- Selecione um Departamento --', COD_SETOR);

					return;
				}

				f_cria_option('', '-- Selecione --', COD_SETOR);

				for(var i = 0; i < v_setor.length; i++) {
					if((Number(v_setor[i].cod_pessoa) == Number(COD_PESSOA_FILIAL.value)) && (Number(v_setor[i].cod_departamento) == Number(COD_DEPARTAMENTO.value))) {
						v_inserir = true;

						for(var j = 0; j < COD_SETOR.options.length; j++) {
							if(Number(COD_SETOR.options[j].value) == Number(v_setor[i].cod_setor)) {
								v_inserir = false;
							}
						}

						if(v_inserir) {
							f_cria_option(v_setor[i].cod_setor, v_setor[i].cod_setor + ' - ' + v_setor[i].setor, COD_SETOR);
						}
					}
				}

				if(COD_SETOR.options.length == 0) {
					f_cria_option('', '-- Este Departamento no possui nenhum Setor --', COD_SETOR);
				}
				else if(COD_SETOR.options.length == 2) {
					COD_SETOR.options[0] = null;
					COD_SETOR.options[0].selected = true;
					COD_SETOR.onchange();
				}
			}
		}

		function f_busca_centro_custo() {
			with(document.forms[0]) {
				var v_option;

				f_limpa_select(COD_CENTRO_CUSTO);

				if(!COD_SETOR.value) {
					f_cria_option('', '-- Selecione um Setor --', COD_CENTRO_CUSTO);

					return;
				}

				f_cria_option('', '-- Selecione --', COD_CENTRO_CUSTO);

				for(var i = 0; i < v_centro_custo.length; i++) {
					if((Number(v_centro_custo[i].cod_pessoa) == Number(COD_PESSOA_FILIAL.value)) && (Number(v_centro_custo[i].cod_departamento) == Number(COD_DEPARTAMENTO.value)) && (Number(v_centro_custo[i].cod_setor) == Number(COD_SETOR.value))) {
						v_option = f_cria_option(v_centro_custo[i].cod_centro_custo, v_centro_custo[i].cod_centro_custo + ' - ' + v_centro_custo[i].centro_custo, COD_CENTRO_CUSTO);
						v_option.setAttribute('cod_organograma', v_centro_custo[i].cod_organograma);
					}
				}

				if(COD_CENTRO_CUSTO.options.length == 0) {
					f_cria_option('', '-- Este Setor no possui nenhum Centro de Custo --', COD_CENTRO_CUSTO);
				}
				else if(COD_CENTRO_CUSTO.options.length == 2) {
					COD_CENTRO_CUSTO.options[0] = null;
					COD_CENTRO_CUSTO.options[0].selected = true;
					COD_CENTRO_CUSTO.onchange();
				}
			}
		}

		function f_muda_centro_custo() {
			with(document.forms[0]) {
				COD_ORGANOGRAMA.value = COD_CENTRO_CUSTO.options[COD_CENTRO_CUSTO.selectedIndex].getAttribute('cod_organograma');
			}
		}
	</cfif>
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/status.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height: 100%;">
<script src="/_scripts/dragdrop.js" type="text/javascript"></script>
<form id="form_transportes" name="form_transportes" method="get" action="" onSubmit="return f_confirmar()">
    <input type="hidden" name="OPERACAO" id="OPERACAO" value="" sempre_ativo="1" />
    <input type="hidden" name="CONSULTA" id="CONSULTA" value="" sempre_ativo="1" />
    <input type="hidden" name="CONTRATO_ID" id="CONTRATO_ID" value="" sempre_ativo="1" />
    <input type="hidden" name="PROCESSO_TRANSPORTE_CODIGO" id="PROCESSO_TRANSPORTE_CODIGO" value="" sempre_ativo="1" />
    <input type="hidden" name="PLACA_CAVALO" id="PLACA_CAVALO" value="" sempre_ativo="1" />
    <input type="hidden" name="LANCTO_ID" id="LANCTO_ID" value="" sempre_ativo="1" />
    <input type="hidden" name="QUITACAO_QUEBRA_PESO" id="QUITACAO_QUEBRA_PESO" value="" sempre_ativo="1" />
    <input type="hidden" name="COD_ORGANOGRAMA" id="COD_ORGANOGRAMA" value="" sempre_ativo="1" />
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
		<cfset grid_cod = 'VALECARD_LISTA_CONTRATOS_#v_possui_acao_quitar_contr#_#v_possui_acao_debito#_#v_possui_acao_credito#'>

        <cfif qrContrato.RecordCount gt 0>
      	<tr>
        	<td>

				<cfset grid_query = 'qrContrato'>
                <cfset grid_field_list    = ''>
                <cfset grid_field_caption = ''>
                <cfset grid_field_align   = ''>
                <cfset grid_field_type    = ''>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'REINTEGRAR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Reintegrar Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CANCELAR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cancelar Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CONSULTAR_DADOS_VIAGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Consultar Dados da Viagem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'REIMPRIMIR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Reimprimir Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CONSULTAR_VALECARD')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Consultar Dados do Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>

				<cfif v_possui_acao_debito eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'INSERIR_DEBITO')>
	                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserir Dbito no Contrato(Operao no suportada pela Valecard)</nobr>')>
	                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
	                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
				</cfif>
				<cfif v_possui_acao_credito eq 1>
	                <cfset grid_field_list 	  = ListAppend(grid_field_list,'INSERIR_CREDITO')>
	                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserir Crdito no Contrato(Operao no suportada pela Valecard)</nobr>')>
	                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
	                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
				</cfif>

                <cfif v_possui_acao_quitar_contr eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'QUITAR')>
                    <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Quitar Contrato</nobr>')>
                    <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                    <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                </cfif>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TIPO_CONTRATO_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tipo Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'INTERNACIONAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Internacional</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_ROMANEIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Romaneio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'LANCTO_ID')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Contrato Transporte</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PROCESSO_TRANSPORTE_CODIGO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'MODALIDADE_VEICULO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Modalidade</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_UNIDADE_NEGOCIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>C&oacute;d. Unidade Neg&oacute;cio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'FILIAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Filial</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_CENTRO_CUSTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>C&oacute;d. Centro Custo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CENTRO_CUSTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Centro Custo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_EMISSAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data Emiss&atilde;o Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SITUACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Situa&ccedil;&atilde;o Integra&ccedil;&atilde;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CARTAO_NUMERO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cart&atilde;o N&uacute;mero</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CNPJ_CPF_PROPRIETARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>CNPJ/CPF Propriet&aacute;rio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PROPRIETARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Propriet&aacute;rio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CPF_MOTORISTA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>CPF Motorista</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'MOTORISTA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Motorista</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_CAVALO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Frota Cavalo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PLACA_CAVALO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Placa Cavalo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_CARRETA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Frota Carreta</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PLACA_CARRETA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Placa Carreta</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ROTA_ID')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>C&oacute;d. Rota</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ROTA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Rota</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_INICIAL_ADIANTAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Inicial Adto.</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_INICIAL_FRETE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Inicial Frete</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_FRETE_BRUTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Bruto Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PERCENTUAL_RECEITA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>% Atual Custo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USER_INSERT')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserido Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATE_INSERT')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserido Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USUARIO_CANCELAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cancelado Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_CANCELAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cancelado Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CONTRATO_QUITADO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Local Quita&ccedil;&atilde;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USUARIO_QUITACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Quitado Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_QUITACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Quitado Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'OBSERVACAO_APROVACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Obs. Aprova&ccedil;&atilde;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>

                <cfset grid_td_context_eval 		  = 'fnc_grid_td_context_eval'>
				<cfset grid_tr_class_function 		  = 'fnc_grid_tr_class'>
                <cfset grid_tr_onclick_function 	  = 'fnc_grid_tr_onclick'>
                <cfset grid_td_inline_function 		  = 'fnc_grid_td_inline'>
                <cfset grid_td_class_function 		  = 'fnc_grid_td_class'>
                <cfset grid_td_style_function		  = 'fnc_grid_td_style'>
                <cfset grid_tr_oncontextmenu_function = 'fnc_grid_tr_oncontext_menu'>
                <cfset grid_td_title_function         = 'fnc_grid_td_title_function'>

                <cfscript>
                    function fnc_grid_td_context_eval(field) {
                        switch(ucase(field)) {
							case "REINTEGRAR":
								if(qrContrato.SITUACAO_ID neq 2 and not Len(Trim(qrContrato.DATA_CANCELAMENTO))) {
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#REINTEGRAR#chr(39)#)"><img src="/_imagens/botoes/16x16/engrenagem.gif" alt="Reintegrar Contrato" title="Reintegrar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/engrenagem_disable.gif" alt="Reintegrar Contrato" title="Reintegrar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}


								break;
							case "CANCELAR":
							    if (qrContrato.CONTRATO_QUITADO eq 0 and not Len(Trim(qrContrato.DATA_CANCELAMENTO))){
								    return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#CANCELAR#chr(39)#)"><img src="/_imagens/botoes/16x16/cancelar.gif" alt="Cancelar Contrato" title="Cancelar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/cancelar_disable.gif" alt="Cancelar Contrato" title="Cancelar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "CONSULTAR_DADOS_VIAGEM":
								return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#CONSULTAR_DADOS_VIAGEM#chr(39)#)"><img src="/_imagens/botoes/16x16/lista_veiculos.gif" alt="Consultar Dados da Viagem" title="Consultar Dados da Viagem" width="16" height="16" align="absmiddle" /></button>';
								break;
							case "REIMPRIMIR":
								if( not Len(Trim(qrContrato.DATA_CANCELAMENTO)) and qrContrato.SITUACAO_ID eq 2 ){
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#REIMPRIMIR#chr(39)#,  #chr(39)##qrContrato.PROCESSO_TRANSPORTE_CODIGO##chr(39)#,  #chr(39)##qrContrato.PLACA_CAVALO##chr(39)#)"><img src="/_imagens/botoes/16x16/imprimir.gif" alt="Reimprimir Contrato" title="Reimprimir Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
								   return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/imprimir_disable.gif" alt="No  possvel reimprimir o contrato pois o mesmo est cancelado" title="No  possvel reimprimir o contrato pois o mesmo est cancelado" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "CONSULTAR_VALECARD":
							    if (qrContrato.SITUACAO_ID eq 2) {
								return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#CONSULTAR_VALECARD#chr(39)#)"><img src="/_imagens/botoes/16x16/consultar_contrato_pagbem.gif" alt="Consultar Dados do Contrato" title="Consultar Dados do Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/consultar_contrato_pagbem_disable.gif" alt="S  possvel consultar dados de contratos integrados" title="S  possvel consultar dados de contratos integrados" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "QUITAR":
								if(qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )) {
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#QUITAR#chr(39)#)"><img src="/_imagens/botoes/16x16/quitar_contrato_pagbem.gif" alt="Quitar Contrato" title="Quitar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/quitar_contrato_pagbem_disable.gif" alt="Quitar Contrato" title="Quitar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
							case "INSERIR_DEBITO":
								return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/nota_debito_disable.gif" alt="Inserir Dbito no Contrato(Operao no suportada pela Valecard)" title="Inserir Dbito no Contrato(Operao no suportada pela Valecard)" width="16" height="16" align="absmiddle" /></button>';

								break;
							case "INSERIR_CREDITO":
								return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/nota_credito_disable.gif" alt="Inserir Crdito no Contrato(Operao no suportada pela Valecard)" title="Inserir Crdito no Contrato(Operao no suportada pela Valecard)" width="16" height="16" align="absmiddle" /></button>';

								break;
							case "VALOR_INICIAL_ADIANTAMENTO":
								return LSNumberFormat(qrContrato.VALOR_INICIAL_ADIANTAMENTO, ',.__');
								break;
							case "VALOR_INICIAL_FRETE":
								return LSNumberFormat(qrContrato.VALOR_INICIAL_FRETE, ',.__');
								break;
							case "VALOR_FRETE_BRUTO":
								return LSNumberFormat(qrContrato.VALOR_FRETE_BRUTO, ',.__');
								break;
							case "PERCENTUAL_RECEITA":
								return LSNumberFormat(qrContrato.PERCENTUAL_RECEITA, ',.__');
								break;
							case "CONTRATO_QUITADO":
								if(qrContrato.CONTRATO_QUITADO eq 1) {
									return 'Filial';
								}
								else if(qrContrato.CONTRATO_QUITADO eq 2) {
									return 'Posto';
								}
								else {
									return '';
								}

								break;
							default:
								return Evaluate("#grid_query#.#field#");
								break;
						}
                    }

                    function fnc_grid_tr_class() {
						return "linha_branca";
					}

					function fnc_grid_tr_onclick() {
						return "this.className = (this.className == 'linha_azul_escura' ? 'linha_branca' : 'linha_azul_escura');";
					}

					function fnc_grid_td_inline(field) {
						return " nowrap";
					}

					function fnc_grid_td_class(field) {
						switch(ucase(field)) {
							case "SITUACAO":
								if(qrContrato.SITUACAO_ID eq 1) {
									return "linha_amarela";
								}
								else if(qrContrato.SITUACAO_ID eq 2) {
									return "linha_verde";
								}
								else if(qrContrato.SITUACAO_ID eq 3) {
									return "linha_vermelha";
								}

								break;
							default:
								return "";
								break;
						}
					}

					function fnc_grid_td_style(field) {
						switch(ucase(field)) {
							case "REINTEGRAR":
								return "width: 22px;";
								break;
							case "CANCELAR":
								return "width: 22px;";
								break;
							case "CONSULTAR_DADOS_VIAGEM":
								return "width: 22px;";
								break;
							case "REIMPRIMIR":
								return "width: 22px;";
								break;
							case "CONSULTAR_VALECARD":
								return "width: 22px;";
								break;
							case "QUITAR":
								return "width: 22px;";
								break;
							case "INSERIR_DEBITO":
								return "width: 22px;";
								break;
							case "INSERIR_CREDITO":
								return "width: 22px;";
								break;
							default:
								return "";
								break;
						}
					}

					function fnc_grid_tr_oncontext_menu() {
						return "";
					}

					function fnc_grid_td_title_function(field){
                    	switch(ucase(field)) {
                        	case "QUITAR":
								return "Quitar Contrato";
							case "INSERIR_DEBITO":
								return "Inserir Dbito no Contrato(Operao no suportada pela Valecard)";
							case "INSERIR_CREDITO":
								return "Inserir Crdito no Contrato(Operao no suportada pela Valecard)";
							case "REINTEGRAR":
							    return "Reintegrar Contrato";
							case "CANCELAR":
								return "Cancelar Contrato";
							case "CONSULTAR_DADOS_VIAGEM":
								return "Consultar Dados da Viagem";
							case "REIMPRIMIR":
								return "Reimprimir Contrato";
							case "CONSULTAR_VALECARD":
								return "Consultar Dados do Contrato";
							case "TIPO_CONTRATO_DESC":
								return "Tipo Contrato";
							case "INTERNACIONAL":
								return "Internacional";
							case "NUM_ROMANEIO":
								return "N&ordm; Romaneio";
							case "LANCTO_ID":
								return "N&ordm; Contrato Transporte";
							case "PROCESSO_CLIENTE_CODIGO":
								return "Processo Cliente C&oacute;digo";
							case "PROCESSO_TRANSPORTE_CODIGO":
								return "N&ordm; Contrato";
							case "COD_UNIDADE_NEGOCIO":
								return "C&oacute;d. Unidade Neg&oacute;cio";
							case "FILIAL":
								return "Filial";
							case "COD_CENTRO_CUSTO":
								return "C&oacute;d. Centro Custo";
							case "CENTRO_CUSTO":
								return "Centro Custo";
							case "DATA_EMISSAO":
								return "Data Emiss&atilde;o Contrato";
							case "SITUACAO":
								return "Situa&ccedil;&atilde;o Integra&ccedil;&atilde;o";
							case "CARTAO_NUMERO":
								return "Cart&atilde;o N&uacute;mero";
							case "CNPJ_CPF_PROPRIETARIO":
								return "CNPJ/CPF Propriet&aacute;rio";
							case "PROPRIETARIO":
								return "Propriet&aacute;rio";
							case "CPF_MOTORISTA":
								return "CPF Motorista";
							case "MOTORISTA":
								return "Motorista";
							case "COD_VEICULO_CAVALO":
								return "Frota Cavalo";
							case "PLACA_CAVALO":
								return "Placa Cavalo";
							case "COD_VEICULO_CARRETA":
								return "Frota Carreta";
							case "PLACA_CARRETA":
								return "Placa Carreta";
							case "ROTA_ID":
								return "C&oacute;d. Rota";
							case "ROTA":
								return "Rota";
							case "VALOR_INICIAL_ADIANTAMENTO":
								return "Valor Inicial Adto.";
							case "VALOR_INICIAL_FRETE":
								return "Valor Inicial Frete";
							case "VALOR_FRETE_BRUTO":
								return "Valor Bruto Contrato";
							case "PERCENTUAL_RECEITA":
								return "% Atual Custo";
							case "USER_INSERT":
								return "Inserido Por";
							case "DATE_INSERT":
								return "Inserido Em";
							case "USUARIO_CANCELAMENTO":
								return "Cancelado Por";
							case "DATA_CANCELAMENTO":
								return "Cancelado Em";
							case "CONTRATO_QUITADO":
								return "Local Quita&ccedil;&atilde;o";
							case "USUARIO_QUITACAO":
								return "Quitado Por";
							case "DATA_QUITACAO":
								return "Quitado Em";
							case "USUARIO_AUTORIZACAO":
								return "Autorizado Por";
							case "DATA_PREVISTA_PAGAMENTO":
								return "Previso Pagamento";
							case "OBSERVACAO_APROVACAO":
								return "Obs. Aprova&ccedil;o";
                    	}
					}
                </cfscript>

                <cfset grid_fixed_header = 0 />
                <cfinclude template="/_include/grid/grid.cfm" />
            </td>
        </tr>
        <cfelse>
        <tr>
            <td align="center" valign="middle" class="obrigatorio" style="padding-top: 10px;">Nenhum contrato foi encontrado.</td>
        </tr>
        </cfif>
	</table>
	<cfif v_possui_acao_quitar_contr eq 1>
    <div id="div_quitar" style="position: absolute; width: 400px; height: 100px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_quitar">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito" style="padding-right: 10px;"><nobr><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Quitar Contrato</label></nobr></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
                        <tr>
                            <td nowrap class="texto" style="height: 21px;">Peso de Entrega:</td>
                            <td class="texto"><input type="text" name="PESO_ENTREGA" id="PESO_ENTREGA" maxlength="15" obrigatorio="0" tipo="numerico" display="PESO DE ENTREGA" onChange="this.value = Number(this.value).toFixed(2);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 100px;" /></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right"><button type="button" class="botao" onClick="f_ocultar_div_quitar()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                    <button type="button" class="botao" onClick="f_quitar_contrato()"><nobr><img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr></button></td>
            </tr>
        </table>
    </div>
    </cfif>
</form>
</body>
<script type="text/javascript">
	f_hide_carregando();
	<cfoutput>
		try { document.getElementById("td_#grid_cod#_REINTEGRAR").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_CANCELAR").innerHTML = '';               } catch (e) {}
		try { document.getElementById("td_#grid_cod#_CONSULTAR_DADOS_VIAGEM").innerHTML = ''; } catch (e) {}
		try { document.getElementById("td_#grid_cod#_REIMPRIMIR").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_CONSULTAR_VALECARD").innerHTML = '';       } catch (e) {}
		try { document.getElementById("td_#grid_cod#_QUITAR").innerHTML = '';                 } catch (e) {}
		try { document.getElementById("td_#grid_cod#_INSERIR_DEBITO").innerHTML = '';         } catch (e) {}
		try { document.getElementById("td_#grid_cod#_INSERIR_CREDITO").innerHTML = '';        } catch (e) {}
	</cfoutput>
</script>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style=" display: none;"></iframe>
<cfset RequestEnd = 0 />
