<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init" output="yes">

    <!--- 
	-- PROPSITO 
	-- Busca o organograma
	-- NOTAS EXPLICATIVAS
	-- Alex - 05/10/2017
	--->	
	<cffunction name="get_organograma" displayname="Busca o organograma" access="remote" returntype="query" output="true">
		<cfargument name="COD_PESSOA" 		   required="no" default="">
        <cfargument name="COD_UNIDADE_NEGOCIO" required="no" default="">
        <cfargument name="COD_CENTRO_CUSTO"    required="no" default="">
		<cfargument name="COD_DEPARTAMENTO"    required="no" default="">
        <cfargument name="COD_SETOR"           required="no" default="">
        <cfargument name="CENTRO_CUSTO"        required="no" default="">
        <cfargument name="SETOR"               required="no" default="">
		<cfargument name="NOME_FANTASIA"       required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
			select /*+FIRST_ROWS*/ distinct rownum
                 , u.cod_unidade_negocio
                 , p.cod_pessoa
                 , p.cliente nome_fantasia
                 , d.cod_departamento
                 , d.descricao as departamento
                 , s.cod_setor
                 , s.descricao as setor
                 , c.cod_centro_custo
                 , c.centro_custo
                 , sysdate as data
                 , o.cod_organograma
			  from kss.v$organograma o 
			 inner join kss.v$unidade_negocio u
			    on o.cod_unidade_negocio = u.cod_unidade_negocio
			 inner join kss.v$pessoa p
			    on u.cod_pessoa = p.cod_pessoa
			 inner join kss.v$departamento d
			    on o.cod_departamento = d.cod_departamento
			 inner join kss.v$setor s
				on o.cod_setor = s.cod_setor				
			 inner join kss.v$centro_custo c
			    on o.cod_centro_custo = c.cod_centro_custo
			 where 1=1
			<cfif len(trim(arguments.COD_PESSOA))>
			   and u.cod_pessoa = #arguments.COD_PESSOA#
			</cfif>
            <cfif len(trim(arguments.COD_UNIDADE_NEGOCIO))>
			   and u.cod_unidade_negocio = #arguments.COD_UNIDADE_NEGOCIO#
			</cfif>
            <cfif len(trim(arguments.COD_CENTRO_CUSTO))>
               and o.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
            </cfif>
			<cfif len(trim(arguments.COD_DEPARTAMENTO))>
			   and o.cod_departamento = #arguments.COD_DEPARTAMENTO#
			</cfif>
			<cfif len(trim(arguments.COD_SETOR))>
			   and o.cod_setor = #arguments.COD_SETOR#
			</cfif>
            <cfif len(trim(arguments.NOME_FANTASIA))>
			   and upper(p.cliente) like upper('%#arguments.NOME_FANTASIA#%')
			</cfif>
            <cfif len(trim(arguments.CENTRO_CUSTO))>
			   and upper(c.centro_custo) like upper('%#arguments.CENTRO_CUSTO#%')
			</cfif>
            <cfif len(trim(arguments.SETOR))>
               and upper(s.descricao) like upper('%#arguments.setor#%')	
            </cfif>
			 order by nome_fantasia
                    , departamento
                    , setor
                    , c.centro_custo
		</cfquery>
		<cfreturn qr_organograma>
	</cffunction>	

 </cfcomponent>
