<cfswitch expression="#vars.CONSULTA#">
	<cfcase value="1">
        <cfscript>
            conn = CreateComponent("modulos.transporte_internacional._componentes.consulta.cfc_transp_internacional");
            qrConhecimento = conn.get_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrItens 	   = conn.get_item_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrCustos 	   = conn.get_custo_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrAnexos 	   = conn.get_anexo_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrFronteiras   = conn.get_fronteira_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrAduanas      = conn.get_aduana_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrComplemento  = conn.get_intc_conhecimento_complemento(conhecimento_id = vars.CONHECIMENTO_ID);
            qrDivisao      = conn.get_intc_crt_divisao(conhecimento_id = vars.CONHECIMENTO_ID);
			qrUltimaVersao = conn.get_crt_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID, ultima_versao = 1);
			qrItinerario   = conn.get_itinerario(conhecimento_id = vars.CONHECIMENTO_ID);
        </cfscript>
        <cfif qrConhecimento.RecordCount gt 0>
			<script type="text/javascript">
                    parent.f_limpar_MERCADORIAS();
                    parent.f_limpar_CUSTOS();
                    parent.f_limpar_ANEXOS();
                    parent.f_limpar_FRONTEIRAS();
                    parent.f_limpar_ADUANAS();
                    parent.v_editando_aduana = 0;
				    parent.v_ordem_aduana = 1;
                    parent.f_limpar_DIVISAO();
                    parent.f_limpar_COMPLEMENTO();
					
                    with(parent.document.form_crt) {
                        OPERACAO_ID_CRT.value = '';
                        OPERACAO_ID_CRT_HIDDEN.value = '';
                        OPERACAO_CRT.value = '';
                        OPERACAO_CRT_HIDDEN.value = '';
						CONTROLE_COTACAO.value = '';
                    }
            </script>       
        
            <cfoutput query="qrFronteiras">
				<script type="text/javascript">
                    with (parent.document.form_crt) {
                        parent.f_incluir_FRONTEIRAS();
                        CONTROLE_ID.value = '#JSStringFormat(qrFronteiras.CONTROLE_ID)#';
                        FRONTEIRA_ID.value = '#JSStringFormat(qrFronteiras.FRONTEIRA_ID)#';
                        parent.f_salvar_FRONTEIRAS();
                    }
                    parent.parent.f_habilitar_botao('pdf', 'iconteudo.f_pdf()');
                </script>
            </cfoutput>

            <cfoutput query="qrAduanas">
				<script type="text/javascript">
                    with (parent.document.form_crt) {
                        parent.f_incluir_ADUANAS();
                        CONHECIMENTO_ADUANA_ID.value = '#JSStringFormat(qrAduanas.CONHECIMENTO_ADUANA_ID)#';
                        ADUANA_ID.value = '#JSStringFormat(qrAduanas.ADUANA_ID)#';
                        ADUANA_FRONTEIRA_ID.value = '#JSStringFormat(qrAduanas.FRONTEIRA_ID)#';
                        ADUANA_FRONTEIRA.value = '#JSStringFormat(qrAduanas.FRONTEIRA)#';
                        ADUANA_MUNICIPIO_ID.value = '#JSStringFormat(qrAduanas.MUNICIPIO_ID)#';
                        ADUANA_MUNICIPIO.value = '#JSStringFormat(qrAduanas.MUNICIPIO)#';
                        ADUANA_ORDEM.value = '#JSStringFormat(qrAduanas.ORDEM)#';
                        parent.f_salvar_ADUANAS();
                    }
                </script>
            </cfoutput>
          
            <script>
                with(parent.document.forms[0]) {		
                <cfif qrComplemento.recordcount>
                    parent.f_aba_complemento(true);
                    <cfoutput query="qrComplemento">
						parent.f_incluir_COMPLEMENTO();
						TIPO_COMPLEMENTO.value = '#JSStringFormat(qrComplemento.tipo_id)#';
						CONHECIMENTO_COMPLEMENTO_ID.value = '#JSStringFormat(qrComplemento.conhecimento_id_complemento)#';
						CRT_COMPLEMENTO.value = '#JSStringFormat(qrComplemento.numero_crt_complemento)#';
						parent.f_salvar_COMPLEMENTO();
                    </cfoutput>
					parent.document.getElementById('tr_aba_itinerario').style.display = 'none';			
					parent.document.getElementById('tr_itinerario').style.display = 'none';
					parent.document.getElementById('lista_min_ok_ITINERARIO').setAttribute('obrigatorio','0');
					parent.document.getElementById('tr_aba_programacao').style.display = 'none';			
					parent.document.getElementById('tr_programacao').style.display = 'none';
						document.getElementById('tbl_abas').rows[0].cells[1].onclick();					
                <cfelse>
                    parent.f_aba_complemento(false);
					parent.document.getElementById('tr_aba_itinerario').style.display = '';			
					parent.document.getElementById('tr_itinerario').style.display = '';
					parent.document.getElementById('lista_min_ok_ITINERARIO').setAttribute('obrigatorio','1');
					parent.document.getElementById('tr_aba_programacao').style.display = '';			
					parent.document.getElementById('tr_programacao').style.display = '';
					document.getElementById('tbl_abas').rows[0].cells[0].onclick();
                </cfif>
                }
            </script>
           
            <script>
				parent.f_limpar_MERCADORIAS();
			</script>
            
            <cfoutput query="qrItens">
				<script type="text/javascript">
                    with (parent.document.form_crt) {
                        parent.f_incluir_MERCADORIAS();
                        MERC_ITEM_ID.value = '#JSStringFormat(qrItens.ITEM_ID)#';
                        MERC_PRODUTO_ID.value = '#JSStringFormat(qrItens.PRODUTO_ID)#';
                        MERC_QUANTIDADE.value = '#JSStringFormat(qrItens.QUANTIDADE)#';
                        MERC_UNIDADE_ID.value = '#JSStringFormat(qrItens.UNIDADE_ID)#';
                        MERC_DESCRICAO.value = '#JSStringFormat(qrItens.DESCRICAO)#';
                        MERC_NUM_ESPECIE.value = '#JSStringFormat(qrItens.NUM_ESPECIE)#';
                        MERC_PESO_BRUTO.value = '#JSStringFormat(qrItens.PESO_BRUTO)#';
                        MERC_PESO_LIQUIDO.value = '#JSStringFormat(qrItens.PESO_LIQUIDO)#';
                        MERC_VOLUME.value = '#JSStringFormat(qrItens.m3)#';
                        parent.f_salvar_MERCADORIAS();
                    }
                </script>	
            </cfoutput>            
            
            <script>
				parent.f_limpar_ANEXOS();
			</script>            
            
            <cfoutput query="qrAnexos">
				<script type="text/javascript">
                    with (parent.document.form_crt) {
                        parent.f_incluir_ANEXOS();
                        ANEXO_ID.value = '#JSStringFormat(qrAnexos.ANEXO_ID)#';
                        ANEXO_DESCRICAO.value = '#JSStringFormat(qrAnexos.DESCRICAO)#';
                        parent.f_salvar_ANEXOS();
                    }
                    parent.parent.f_habilitar_botao('pdf', 'iconteudo.f_pdf()');
                </script>
            </cfoutput>	            
            
            <cfif qrCustos.recordcount gt 0>
            	<script type="text/javascript">
					with (parent.document.form_crt) {
						parent.f_limpar_CUSTOS();
					}
				</script>
            </cfif>
            
            <cfoutput query="qrCustos">
				<script type="text/javascript">
                    with (parent.document.form_crt) {
                        parent.f_incluir_CUSTOS();
                        CUST_ITEM_ID.value = '#JSStringFormat(qrCustos.ITEM_ID)#';
                        CUST_DESCRICAO.value = '#JSStringFormat(qrCustos.DESCRICAO)#';
                        CUST_VALOR_ORIGEM.value = '#JSStringFormat(qrCustos.VALOR_ORIGEM)#';
                        CUST_VALOR_ORIGEM_COD_MOEDA.value = '#JSStringFormat(qrCustos.VALOR_ORIGEM_COD_MOEDA)#';
                        CUST_VALOR_DESTINO.value = '#JSStringFormat(qrCustos.VALOR_DESTINO)#';
                        CUST_VALOR_DESTINO_COD_MOEDA.value = '#JSStringFormat(qrCustos.VALOR_DESTINO_COD_MOEDA)#';
                        parent.f_salvar_CUSTOS();
                            
                    }
                </script>
            </cfoutput>
             
            <cfoutput query="qrConhecimento" maxrows="1"> 
                <script type="text/javascript">
                    with (parent.document.form_crt) {
                    <cfloop list="#qrConhecimento.columnlist#" index="v_index">
                        try {
                            if(#v_index#.type != 'checkbox' && #v_index#.type != 'radio')
                                #v_index#.value = '#JsstringFormat(qrConhecimento[v_index][1])#';
                        } catch(e) {}
                    </cfloop>						
					parent.document.getElementById('sp_origem_crt').innerHTML = RESP_LOCAL.value;
					parent.v_origem_crt = RESP_MUNICIPIO_ID.value;
					parent.document.getElementById('sp_destino_crt').innerHTML = ENTREGA_LOCAL.value;
					parent.v_destino_crt = ENTREGA_MUNICIPIO_ID.value;	
					parent.f_validar_itinerario();		
					parent.f_altera_limite(<cfoutput>#qrConhecimento.LIMITE_PROG_CARGA#</cfoutput>);
					PRE_CONHECIMENTO.checked = ('#qrConhecimento["PRE_CONHECIMENTO"][1]#'=='1');		
					COD_ORGANOGRAMA.value = '#qrConhecimento["COD_ORGANOGRAMA"][1]#';
					PEDIDO_SHIPMENT.value = '#qrConhecimento["PEDIDO_SHIPMENT"][1]#';
					OPERACAO_ID_CRT.removeAttribute('disabled');					
					OPERACAO_ID_CRT.value =  '#JsstringFormat(qrConhecimento["OPERACAO_ID"][1])#';
					parent.f_busca_operacao();

					EMISSAO_DATA.value =  '#JsstringFormat(qrConhecimento["EMISSAO_DATA_CHAR"][1])#';
					PERMISSO.value = '#qrConhecimento["NUMERO_COD_PAIS"][1]#|#qrConhecimento["NUMERO_CERTIFICADO"][1]#|#qrConhecimento["SERIE"][1]#';
                     
					parent.f_separa_numero_crt();
					parent.f_seleciona_filial();
					parent.f_seleciona_centro_custo();
					
					COD_CENTRO_CUSTO.removeAttribute('disabled');						
					var v_opt = parent.f_cria_option('#qrConhecimento["COD_CENTRO_CUSTO"][1]#','#qrConhecimento["CENTRO_CUSTO"][1]#',COD_CENTRO_CUSTO); 
					v_opt.setAttribute('cod_organograma','#qrConhecimento["COD_ORGANOGRAMA"][1]#');
					COD_CENTRO_CUSTO.value = '#qrConhecimento["COD_CENTRO_CUSTO"][1]#';					

					parent.f_busca_operacao('#qrConhecimento["ORGANIZACIONAL_ID_GERENCIAL"][1]#');				

					TIPO_SERVICO_COMERCIAL.value = '#qrConhecimento["TIPO_SERVICO_COMERCIAL"][1]#'
					COTACAO.value =  Number(COTACAO.value);

					parent.document.getElementById('date_update').innerHTML = '#qrConhecimento["DATE_UPDATE_STRING"][1]# por #qrConhecimento["USER_UPDATE"][1]# verso: #qrConhecimento["VERSAO"][1]#';
                    
					parent.document.getElementById('duplicidade').innerHTML = '';
					REM_CNPJ_CPF.value   = '#JsstringFormat(qrConhecimento["REMETENTE_CNPJ_CPF"][1])#';
					REM_MUNICIPIO.value  = '#JsstringFormat(qrConhecimento["REM_CIDADE"][1])#';
					DEST_MUNICIPIO.value = '#JsstringFormat(qrConhecimento["DEST_CIDADE"][1])#';
					CONS_MUNICIPIO.value = '#JsstringFormat(qrConhecimento["CONS_CIDADE"][1])#';
					NOT_MUNICIPIO.value  = '#JsstringFormat(qrConhecimento["NOT_CIDADE"][1])#';
					
					parent.f_preenche_cb_enderecos_REM('#JsstringFormat(qrConhecimento["cod_remetente"][1])#', '#JsstringFormat(qrConhecimento["cod_end_remetente"][1])#');
					parent.f_preenche_cb_enderecos_DEST('#JsstringFormat(qrConhecimento["cod_destinatario"][1])#', '#JsstringFormat(qrConhecimento["cod_end_destinatario"][1])#');
					parent.f_preenche_cb_enderecos_CONS('#JsstringFormat(qrConhecimento["cod_consignatario"][1])#','#JsstringFormat(qrConhecimento["cod_end_consignatario"][1])#');
					parent.f_preenche_cb_enderecos_NOT('#JsstringFormat(qrConhecimento["cod_notificar"][1])#', '#JsstringFormat(qrConhecimento["cod_end_notificar"][1])#');
					parent.f_preenche_cb_enderecos_NEG('#JsstringFormat(qrConhecimento["cod_negociador"][1])#', '#JsstringFormat(qrConhecimento["cod_end_negociador"][1])#');
					parent.f_preenche_cb_enderecos_PAG_ORIGEM('#JsstringFormat(qrConhecimento["cod_pagador_origem"][1])#', '#JsstringFormat(qrConhecimento["cod_end_pagador_origem"][1])#');
					parent.f_preenche_cb_enderecos_PAG_DESTINO('#JsstringFormat(qrConhecimento["cod_pagador_destino"][1])#', '#JsstringFormat(qrConhecimento["cod_end_pagador_destino"][1])#');
					
					NUM_LOTE_CLIENTE.value = '#qrConhecimento.NUM_LOTE_CLIENTE#';
					parent.f_busca_dacte();
					parent.f_km_rota_crt();
        
					parent.f_limpa_select(NUM_EMBARQUE); 
					   for (var i=1;i<=QTDE_VEICULOS.value;i++) { 
					      parent.f_cria_option(i,i,NUM_EMBARQUE); 
					   }                    
					}
				parent.f_km_rota_crt();
                </script>
            </cfoutput>

            <script type="text/javascript">
                parent.parent.f_habilitar_botao('pdf', 'f_pdf()');
                parent.parent.f_habilitar_botao('copiar_crt', 'f_copiar_crt()');
                parent.parent.f_habilitar_botao('complementar_crt', 'f_complementar_crt()');
                
                <cfif qrConhecimento.CANCELADO eq 1>
                    parent.document.getElementById('SITUACAO').innerHTML = 'CANCELADO';
                    parent.parent.f_desabilitar_botao('editar');
                    parent.parent.f_desabilitar_botao('cancelar_doc');
					parent.parent.f_desabilitar_botao('complementar_crt');
                <cfelse>
                    parent.parent.f_habilitar_botao('cancelar_doc', 'f_cancelar_doc()');
					parent.parent.f_habilitar_botao('complementar_crt', 'f_complementar_crt()');
                    parent.document.getElementById('SITUACAO').innerHTML = '';
                </cfif>
                
                parent.parent.f_habilitar_botao('copiar_crt', 'f_copiar_crt()');
            </script>	
           
            <cfset v_num_embarque = 0>
            <cfset v_embarque_id = 0>
            <cfoutput query="qrDivisao">
                <script type="text/javascript">
                    with (parent.document.form_crt) {
                        PLACA_CONTROLE.obrigatorio = 0;
                        DIVISAO_COD_MOTORISTA.obrigatorio = 0;
                        DIVISAO_ROTA_ID.obrigatorio = 0;
                        parent.f_incluir_DIVISAO();
                        <cfif qrDivisao.EMBARQUE_ID neq v_embarque_id>
                            <cfset v_num_embarque = v_num_embarque + 1>
                            <cfset v_embarque_id = qrDivisao.EMBARQUE_ID>
                        </cfif>
                        parent.f_cria_option(#v_num_embarque#,#v_num_embarque#,NUM_EMBARQUE);
                        NUM_EMBARQUE.value = '#v_num_embarque#';
                        DATE_INSERT.value = '#JSStringFormat(qrDivisao.DATE_INSERT)#';
                        USER_INSERT.value = '#JSStringFormat(qrDivisao.USER_INSERT)#';
                        DATA_CANCELAMENTO.value = '#JSStringFormat(qrDivisao.DATA_CANCELAMENTO)#';
                        DIVISAO_CONTROLE_ID.value = '';
                        EMBARQUE_ID.value = '#qrDivisao.EMBARQUE_ID#';
                        VINCULO_SOL.value = '#qrDivisao.VINCULO_SOL#';						
                        DIVISAO_ID.value = '#qrDivisao.DIVISAO_ID#';
                        EMBARQUE_DATA.value = '#qrDivisao.DATA_EMBARQUE#';
                        DIVISAO_DATA.value = '#qrDivisao.DATA_DIVISAO#';
                        PLACA_CONTROLE.value = '#qrDivisao.PLACA_CONTROLE#';
                        PLACA_REFERENCIA_COMPOSICAO.value = '#qrDivisao.PLACA_REFERENCIA_COMPOSICAO#';
						NUM_ROMANEIO.value = '#qrDivisao.NUM_ROMANEIO#';
						NUM_CTE.value = '#qrDivisao.NUM_CTE#';
						CTE_PESO.value = '#qrDivisao.CTE_PESO#';
						NUM_CONTRATO.value = '#qrDivisao.NUM_FORMULARIO#';
                        parent.f_limpar_engates();
                        
                        <cfloop list="#qrDivisao.PLACA_REFERENCIA_COMPOSICAO#" index="placas">
                            parent.v_obj = parent.f_engata();
                            parent.v_obj.setValue('#placas#');
                        </cfloop>
                        KM_ROTA_CRT.value = '#qrDivisao.KM_CRT#';
                        DIVISAO_COD_MOTORISTA.value = '#qrDivisao.COD_PESSOA_MOTORISTA#';
                        DIVISAO_MOTORISTA.value = '#JSStringFormat(qrDivisao.MOTORISTA)#';
                        DIVISAO_COD_PESSOA_MOTORISTA.value = '#qrDivisao.COD_PESSOA_MOTORISTA#';
                        DIVISAO_ROTA_ABREVIATURA.value = '#qrDivisao.ABREVIATURA#';
                        parent.f_cria_option('#qrDivisao.ROTA_ID#','#qrDivisao.DESCRICAO_ROTA#',DIVISAO_ROTA_ID);
                        DIVISAO_ROTA_ID.value = "#qrDivisao.ROTA_ID#";
                        DIVISAO_KM.value = '#qrDivisao.DISTANCIA_PADRAO#';
                        DIVISAO_PERCENTUAL.value = '#qrDivisao.PERCENTUAL_CRT#';
                        DIVISAO_COD_MOEDA.value = '#qrDivisao.COD_MOEDA#';
                        DIVISAO_VALOR.value = '#qrDivisao.VALOR#';
                        parent.f_salvar_DIVISAO();
                        parent.f_limpa_select(DIVISAO_ROTA_ID);
                        PLACA_CONTROLE.obrigatorio = 1;
                        DIVISAO_COD_MOTORISTA.obrigatorio = 1;
                        DIVISAO_ROTA_ID.obrigatorio = 1;
                    }
                </script>	
            </cfoutput>
            <cfif qrUltimaVersao.RecordCount gt 0>
            	<script type="text/javascript">
					with(parent.document.forms[0]) {
						parent.v_emite_tabela_frete = 1;
						
						<cfoutput>
							CLASSIFICACAO_NATUREZA_ID.value  = '#JSStringFormat(qrUltimaVersao.CLASSIFICACAO_NATUREZA_ID)#';
							CLASSIFICACAO_COMERCIAL_ID.value = '#JSStringFormat(qrUltimaVersao.CLASSIFICACAO_COMERCIAL_ID)#';
						</cfoutput>
						
						parent.f_utiliza_tabela_frete(3);
						parent.f_atualiza_filtros_indicativos();
						parent.f_busca_versoes();
					}
				</script>
            <cfelse>
            	<script type="text/javascript">
					with(parent.document.forms[0]) {
						parent.v_emite_tabela_frete = 0;
						
						CLASSIFICACAO_NATUREZA_ID.value  = '';
						CLASSIFICACAO_COMERCIAL_ID.value = '';
						
						parent.f_utiliza_tabela_frete(1);
					}
				</script>
            </cfif>
                         
            <script>
				parent.f_limpar_ITINERARIO();
				parent.v_editando = 0;
				parent.v_ordem = 1;
			</script>            
            <cfoutput query="qrItinerario">
				<script type="text/javascript">
                    with (parent.document.form_crt) {
                        parent.f_incluir_ITINERARIO();
                        ITINERARIO_ORDEM.value = '#JSStringFormat(qrItinerario.ORDEM)#';
                        ITINERARIO_ID.value = '#JSStringFormat(qrItinerario.ITINERARIO_ID)#';
                        ITINERARIO_ROTA.value = '#JSStringFormat(qrItinerario.ABREVIATURA)#';
						parent.f_limpa_select(ITINERARIO_ROTA_ID);
						novo = document.createElement("option") ;
						novo.value = '#qrItinerario.ROTA_ID#';
						novo.text = '#JSStringFormat(qrItinerario.DESCRICAO_ROTA)#';
						novo.abreviatura = '#JSStringFormat(qrItinerario.ABREVIATURA)#';
						novo.setAttribute('origem','#qrItinerario.ORIGEM_MUNICIPIO_ID#');
						novo.setAttribute('destino','#qrItinerario.DESTINO_MUNICIPIO_ID#');
						ITINERARIO_ROTA_ID.add(novo);		
                        parent.f_salvar_ITINERARIO();
                    }
                </script>	
            </cfoutput>   
        <cfelse>
            <script type="text/javascript">
                alert('No foi possvel localizar o C.R.T.!');			
            </script>
        </cfif>
	</cfcase>
    
    <cfcase value="2">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            qrAlfandega = conn.get_alfandega();
        </cfscript>
		<script type="text/javascript">
            var novo;
            with (parent.document.form_crt) {

                novo = document.createElement("option") ;
                novo.value = '';
                novo.text = '-- Selecione --';
                ALFANDEGA_ORIGEM_ID.add(novo);

                for (var q=ALFANDEGA_ORIGEM_ID.options.length; q>=0; q--) 
                    ALFANDEGA_ORIGEM_ID.options[q]=null;

                novo = document.createElement("option") ;
                novo.value = '';
                novo.text = '-- Selecione --';
                ALFANDEGA_DESTINO_ID.add(novo);

                for (var q=ALFANDEGA_DESTINO_ID.options.length; q>=0; q--) 
                    ALFANDEGA_DESTINO_ID.options[q]=null;
        
                <cfoutput query="qrAlfandega">
                    novo = document.createElement("option") ;
                    novo.value = '#qrAlfandega.ALFANDEGA_ID#';
                    novo.text = '#JSStringFormat(qrAlfandega.DESCRICAO)#';
                    ALFANDEGA_ORIGEM_ID.add(novo);						
                </cfoutput>
                
                <cfoutput query="qrAlfandega">
                    novo = document.createElement("option") ;
                    novo.value = '#qrAlfandega.ALFANDEGA_ID#';
                    novo.text = '#JSStringFormat(qrAlfandega.DESCRICAO)#';
                    ALFANDEGA_DESTINO_ID.add(novo);						
                </cfoutput>
            }		
        </script>	
    </cfcase>
    
    <cfcase value="3">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            qrProdutos = conn.get_produtos();
        </cfscript>
		<script type="text/javascript">
            var novo;
            with (parent.document.form_crt) {
                for (var q=MERC_PRODUTO_ID.options.length; q>=0; q--) 
                    MERC_PRODUTO_ID.options[q]=null;

                novo = document.createElement("option") ;
                novo.value = '';
                novo.text = '-- Selecione --';
                MERC_PRODUTO_ID.add(novo);

                <cfoutput query="qrProdutos">
                    novo = document.createElement("option") ;
                    novo.value = '#qrProdutos.PRODUTO_ID#';
                    novo.text = '#JSStringFormat(qrProdutos.DESCRICAO)#';
                    MERC_PRODUTO_ID.add(novo);						
                </cfoutput>
            }		
        </script>
    </cfcase>
    
    <cfcase value="4">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            qrEspecies = conn.get_especies();
        </cfscript>
		<script type="text/javascript">
            var novo;
            with (parent.document.form_crt) {
                for (var q=MERC_NUM_ESPECIE.options.length; q>=0; q--) 
                    MERC_NUM_ESPECIE.options[q]=null;

                novo = document.createElement("option") ;
                novo.value = '';
                novo.text = '-- Selecione --';
                MERC_NUM_ESPECIE.add(novo);

                <cfoutput query="qrEspecies">
                    novo = document.createElement("option") ;
                    novo.value = '#qrEspecies.NUM_ESPECIE#';
                    novo.text = '#JSStringFormat(qrEspecies.ABREVIATURA)#';
                    MERC_NUM_ESPECIE.add(novo);						
                </cfoutput>
            }		
        </script>
    </cfcase>
    
    <cfcase value="5">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            qrFronteira = conn.get_fronteira();
        </cfscript>
		<script type="text/javascript">
            var novo;
            with (parent.document.form_crt) {
                parent.f_limpa_select(FRONTEIRA_ID);
                parent.f_cria_option('','-- Selecione --',FRONTEIRA_ID);
                <cfoutput query="qrFronteira">
                parent.f_cria_option('#qrFronteira.FRONTEIRA_ID#','#JSStringFormat(qrFronteira.DESCRICAO)#',FRONTEIRA_ID);						
                parent.v_cidade_1['#qrFronteira.fronteira_id#'] = '#JSStringFormat(qrFronteira.MUNICIPIO_1)#';
                parent.v_cidade_2['#qrFronteira.fronteira_id#'] = '#JSStringFormat(qrFronteira.MUNICIPIO_2)#';
                parent.v_pais_1['#qrFronteira.fronteira_id#'] = '#JSStringFormat(qrFronteira.PAIS_01)#';
                parent.v_pais_2['#qrFronteira.fronteira_id#'] = '#JSStringFormat(qrFronteira.PAIS_02)#';
                </cfoutput>
            }		
        </script>
    </cfcase>
    
    <cfcase value="6">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            if(not len(trim(vars.numero))) {
                vars.numero = -1;
            }
            qrConhecimento = conn.get_crt(num_crt_completo = vars.numero);
        </cfscript>
        <cfif qrConhecimento.RecordCount gt 0>
            <script>
                alert('Nmero do CRT j cadastrado, verifique!');
                parent.document.getElementById('duplicidade').innerHTML = 'Nmero do CRT j cadastrado!';
            </script>
        <cfelse>
            <script>
                parent.document.getElementById('duplicidade').innerHTML = '';
            </script>
        </cfif>
    </cfcase>
    
    <cfcase value="7">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.logistica.cfc_operacao");
            qrOperacao= conn.get_operacao(argumentCollection = vars, cod_organograma = session.cod_organograma, internacional = 1);
        </cfscript>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td class="texto">
                    <table width="100%" border="0" cellspacing="1" cellpadding="1">
                        <tr class="titulo_2">
                            <td nowrap align="left">C&oacute;d. Opera&ccedil;&atilde;o</td>
                            <td nowrap align="left">Descri&ccedil;&atilde;o</td>                  
                        </tr>
                        <cfoutput query="qrOperacao">
                        <tr class="linha_#(qrOperacao.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrOperacao.CurrentRow Mod 2) + 1#';" onClick="f_retorna_valor('#JSStringFormat(qrOperacao.OPERACAO_ID)#', '#JSStringFormat(qrOperacao.DESCRICAO)#','#JSStringFormat(qrOperacao.TIPO_SERVICO_ID)#')">
                            <td nowrap align="left">#qrOperacao.OPERACAO_ID#</td>
                            <td nowrap align="left">#qrOperacao.operacao_completa#</td>
                        </tr>
                        </cfoutput>
                        <cfif qrOperacao.RecordCount eq 0>
                        <tr>
                            <td colspan="2" align="center" valign="middle" class="obrigatorio">Nenhuma opera&ccedil;&atilde;o foi encontrada.</td>
                        </tr>
                        </cfif>
                    </table>
                </td>
            </tr>
        </table>
    </cfcase>
    
    <cfcase value="8">
    	<cfset v_retorno = structnew()>
        <cfset cotacao = 0>
        <cfset tipo_cotacao = 0>
        <cftry>
            <cfscript>
				if(len(trim(vars.OPERACAO_ID_CRT))){
					connO = CreateComponent("_transportes.consulta.logistica.cfc_operacao");
					qrOperacao= connO.get_operacao(operacao_id = vars.OPERACAO_ID_CRT);
					vars.TIPO_SERVICO_COMERCIAL = qrOperacao.TIPO_SERVICO_ID;
				}else
					vars.TIPO_SERVICO_COMERCIAL =  '';
					
                conn_cons_tf = CreateComponent("modulos.transporte_internacional._componentes.consulta.cfc_tabela_frete");
                qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id_intc(ORIGEM_MUNICIPIO_ID  		= vars.RESP_MUNICIPIO_ID,
                                                                            	 DESTINO_MUNICIPIO_ID 		= vars.ENTREGA_MUNICIPIO_ID,
                                                                            	 COD_NEGOCIADOR       		= vars.COD_NEGOCIADOR,
                                                                            	 CLASSIFICACAO_NATUREZA_ID	= vars.CLASSIFICACAO_NATUREZA_ID,
                                                                            	 CLASSIFICACAO_COMERCIAL_ID = vars.CLASSIFICACAO_COMERCIAL_ID,
																				 TIPO_SERVICO_ID			= vars.TIPO_SERVICO_COMERCIAL);
            </cfscript>
            <cfif qrTabelaFreteRotaId.erro>
                <cfthrow object="#qrTabelaFreteRotaId.mensagem#">
            </cfif>
            
            <cfscript>
               qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID
                                                                     ,tabela_frete_id      = qrTabelaFreteRotaId.TABELA_FRETE_ID
                                                                     );
                
                vars.TABELA_FRETE_ID	  = qrTabelaFreteRota.TABELA_FRETE_ID;
                vars.TABELA_FRETE_ROTA_ID = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID;
                vars.TABELA_FRETE_VIGENCIA_ID = qrTabelaFreteRota.TABELA_FRETE_VIGENCIA_ID;
                
                // Constantes
                vars.CONSTANTE_PESO_BRUTO            = vars.PESO_BRUTO;
                vars.CONSTANTE_PESO_COBRADO          = vars.PESO_BRUTO;
                vars.CONSTANTE_PESO_LIQUIDO          = vars.PESO_LIQUIDO;				
                vars.CONSTANTE_CUBAGEM	              = vars.M3;
                vars.CONSTANTE_VALOR_MERCADORIA      = vars.VALOR_TOTAL;
                vars.CONSTANTE_MUNICIPIO_ID_ORIGEM   = vars.RESP_MUNICIPIO_ID;
                vars.CONSTANTE_MUNICIPIO_ID_DESTINO  = vars.ENTREGA_MUNICIPIO_ID;
                vars.CONSTANTE_FRETE_PROPRIO		     = 1;
                vars.CONSTANTE_DATA_EMISSAO          = vars.EMISSAO_DATA;
                vars.CONSTANTE_INTERNACIONAL         = 1;
                vars.CONSTANTE_CRT_ID                = vars.CONHECIMENTO_ID;
                vars.CONSTANTE_NRO_VOLUMES           = vars.QUANTIDADE_TOTAL;
                // ----------
                qrCalculo = conn_cons_tf.calculo_tabela_frete(argumentCollection = vars);
            </cfscript>

            <cfif qrCalculo.erro>
                <cfthrow object="#qrCalculo.mensagem#">
            </cfif> 
            <div id="div_negociacao_tabela_frete" style="display: none;">
                <table border="0" cellpadding="0" cellspacing="0">
                    <tr>
                        <td valign="top">
                            <table border="0">
                                <tr>
                                    <td valign="top">
                                        <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                            <tr class="titulo_1">
                                                <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                <td nowrap align="left">Valor</td>
                                                <td nowrap align="center">Tipo</td>
                                            </tr>
                                            <cfoutput query="qrCalculo.query">
                                            	<cfif qrCalculo.query.COD_VARIAVEL eq 'COTACAO'>
													<cfset cotacao = qrCalculo.query.VALOR>
                                                    <cfset tipo_cotacao = qrCalculo.query.TIPO>
                                                </cfif>
                                                <cfswitch expression="#qrCalculo.query.TIPO#">
                                                    <cfcase value="0">
                                                        <cfset v_imagem = 'seta_matriz'>
                                                        <cfset v_tipo   = 'Interna - No Editvel'>
                                                    </cfcase>
                                                    <cfcase value="1">
                                                        <cfset v_imagem = 'fx'>
                                                        <cfset v_tipo   = 'Frmula'>
                                                    </cfcase>
                                                    <cfcase value="2">
                                                        <cfset v_imagem = 'arquivo_detalhes'>
                                                        <cfset v_tipo   = 'Valor - Informando na Tabela'>
                                                    </cfcase>
                                                    <cfcase value="3">
                                                        <cfset v_imagem = 'editar'>
                                                        <cfset v_tipo   = 'Valor - Informando na Emisso do Documento'>
                                                    </cfcase>
                                                </cfswitch>
                                                <tr  class="linha_#(qrCalculo.query.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrCalculo.query.CurrentRow Mod 2) + 1#';">
                                                    <td nowrap align="left">#qrCalculo.query.DESCRICAO#</td>
                                                    <td nowrap align="left"><input type="text"  tipo_var="#qrCalculo.query.TIPO#" name="VARIAVEL_#qrCalculo.query.COD_VARIAVEL#" id="VARIAVEL_#qrCalculo.query.COD_VARIAVEL#" maxlength="15" value="<cfif IsNumeric(qrCalculo.query.VALOR)>#NumberFormat(Replace(qrCalculo.query.VALOR, ',', '.', 'all'), '_.______')#<cfelse>#qrCalculo.query.VALOR#</cfif>" <cfif qrCalculo.query.TIPO eq 3>obrigatorio="1"<cfelse>readonly</cfif> <cfif IsNumeric(qrCalculo.query.VALOR)>tipo="numerico"</cfif> display="#UCase(qrCalculo.query.DESCRICAO)#" onChange="this.value = Number(this.value); <cfif qrCalculo.query.TIPO eq 3>f_calculos();</cfif>" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px; text-align: right;" /></td>                                                    
                                                    <td nowrap align="center"><img src="/_imagens/botoes/16x16/#v_imagem#.gif" alt="#v_tipo#" title="#v_tipo#" width="16" height="16" align="absmiddle" /></td>
                                                </tr>
                                                <cfif qrCalculo.query.CurrentRow neq qrCalculo.query.RecordCount and qrCalculo.query.CurrentRow%10 eq 0>
                                                    </table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                    <tr class="titulo_1">
                                                        <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                        <td nowrap align="left">Valor</td>
                                                        <td nowrap align="center">Tipo</td>
                                                    </tr>
                                                </cfif>
                                            </cfoutput>
                                            <tr class="linha_#((qrCalculo.query.RecordCount + 1) Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#((qrCalculo.query.RecordCount + 1) Mod 2) + 1#';">
                                                <td colspan="2" nowrap align="left">&nbsp;</td>
                                                <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_calculos()"><img src="/_imagens/botoes/16x16/calculadora.gif" alt="Executar C&aacute;lculos" title="Executar C&aacute;lculos" width="16" height="16" align="absmiddle" /></button></td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td valign="top" style="padding-left: 20px;">
                            <cfscript>
                            	f_dados_tabela_frete();
                            </cfscript>
                        </td>
                    </tr>
                </table>
            </div>
            
            <cfset v_retorno.erro = false>
            <cfcatch>
                <cfset v_retorno.erro = true>
                <cfset v_retorno.mensagem = cfcatch>
                
                <div id="div_negociacao_tabela_frete" style="display: none;">
                    <cfif isDefined("v_retorno.mensagem.cause.errorCode") and listfind('20666,20777,20888',v_retorno.mensagem.cause.errorCode,',') >
						<cfscript>
                            f_dados_tabela_frete();
                        </cfscript>
                    <cfelse>
                        <table border="0" cellspacing="1" cellpadding="3">
                            <tr class="obrigatorio">
                                <td align="left"><button type="button" class="botao-16x16" onClick="f_calculos()" style="margin-right: 5px;"><img src="/_imagens/botoes/16x16/atualizar.gif" alt="Tentar Novamente" title="Tentar Novamente" width="16" height="16" align="absmiddle" /></button>
                                    <cfoutput>#JSStringFormat(Trim(fnc_format_erro(argumentCollection = v_retorno)))#</cfoutput></td>
                            </tr>
                        </table>
                    </cfif>
                </div>
                
                <div id="div_mensagem_erro" style="display:;">
				<cfscript>
                    fnc_trata_erros(struct_erro = v_retorno, mostra_msg_ok = false, abre_popup = false, abort_on_error = false);
                </cfscript>
                </div>
                <script>
					parent.document.getElementById('dv_form_erro_tabela_frete').innerHTML = document.getElementById('div_mensagem_erro').innerHTML;
				</script>
            </cfcatch>
        </cftry>
        
        <cfif Len(Trim(vars.CONHECIMENTO_ID))>
			<cfscript>
                conn = CreateComponent("modulos.transporte_internacional._componentes.consulta.cfc_transp_internacional");
                qrUltimaVersao = conn.get_crt_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID, ultima_versao = 1);
                qrVersaoTarifa = conn.get_conhecimento_tarifa(versao_id = qrUltimaVersao.VERSAO_ID);
            </cfscript>
            <cfdump var="#qrVersaoTarifa#">
            <script>
            if(parent.v_variaveis_tabela_frete == 1){
                parent.v_variaveis_tabela_frete = 0;
                <cfoutput query="qrVersaoTarifa">
                    try{
                        var valor = #qrVersaoTarifa.VALOR#;
                        document.getElementById("VARIAVEL_#qrVersaoTarifa.COD_VARIAVEL#").value = valor.toFixed(6);
                    }catch (e){
                    }
                </cfoutput>  
            }
            </script>        
        </cfif>
        
        <script type="text/javascript">
            parent.document.getElementById('tr_negociacao_carregando').style.display = 'none';
            
            parent.document.getElementById('td_negociacao_tabela_frete').innerHTML = document.getElementById('div_negociacao_tabela_frete').innerHTML;

			var custo_origem = 0;
			var custo_destino = 0;
			var outros_origem = 0;
			var outros_destino = 0;
												
			try{custo_origem = Number(parent.document.getElementById('VARIAVEL_CUSTO_FRETE_ORIGEM').value);}catch (e){}
			try{custo_destino = Number(parent.document.getElementById('VARIAVEL_CUSTO_FRETE_DESTINO').value);}catch (e){}
			try{outros_origem = Number(parent.document.getElementById('VARIAVEL_OUTROS_CUSTOS_ORIGEM').value);}catch (e){}
			try{outros_destino = Number(parent.document.getElementById('VARIAVEL_OUTROS_CUSTOS_DESTINO').value);}catch (e){}									
							
			parent.f_custos_frete(custo_origem,custo_destino,outros_origem,outros_destino);
			//se for edio s muda a cotao se no for do tipo 'informado na emisso'
			<cfif tipo_cotacao eq 3>
				if(parent.document.getElementById("CONTROLE_COTACAO").value != ''){
					parent.document.getElementById('COTACAO').value = Number('<cfoutput>#cotacao#</cfoutput>');
				}
				else{
					parent.document.getElementById("VARIAVEL_COTACAO").value = parent.document.getElementById("COTACAO").value;	
					parent.document.getElementById("CONTROLE_COTACAO").value = 1;
				}
			<cfelse>
				parent.document.getElementById('COTACAO').value = Number('<cfoutput>#cotacao#</cfoutput>');
			</cfif>

			if((Number(parent.document.getElementById('COTACAO').value)<=0 && parent.document.getElementById('EMISSAO_DATA').value != '') || parent.v_emite_tabela_frete == 0)
  				parent.document.getElementById('COTACAO').removeAttribute('disabled');
			else	
  				parent.document.getElementById('COTACAO').setAttribute('disabled','true');			

        </script>
        
        <script type="text/javascript">
            parent.f_habilitar_botao('confirmar', 'f_confirmar()');
        </script>
    </cfcase>
    
    <cfcase value="9">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
			qrVersao       = conn.get_crt_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID);
			qrUltimaVersao = conn.get_crt_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID, ultima_versao = 1);
			qrVersaoTarifa = conn.get_conhecimento_tarifa(versao_id = qrUltimaVersao.VERSAO_ID);
			
			conn = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
			qrTabelaFreteRota = conn.get_tabela_frete_rota(tabela_frete_rota_id = qrUltimaVersao.TABELA_FRETE_ROTA_ID);
		</cfscript>
    	<fieldset><legend>Vers&otilde;es</legend>
        <table width="100%" border="0" cellspacing="1" cellpadding="3">
            <tr class="titulo_1">
                <td width="1%" nowrap align="center">&nbsp;</td>
                <td width="1%" nowrap align="center">N&ordm; Vers&atilde;o</td>
                <td width="1%" nowrap align="left">Inserido por</td>
                <td nowrap align="left">Data de Inser&ccedil;&atilde;o</td>
            </tr>
            <cfoutput query="qrVersao">
                <tr class="titulo_4">
                    <td nowrap align="center"><button type="button" id="BTN_MOSTRAR_TARIFAS_#qrVersao.VERSAO_ID#" class="botao-16x16" onClick="f_mostrar_tarifas(#qrVersao.VERSAO_ID#)" <cfif qrVersao.CurrentRow eq 1>style="display: none;"</cfif>><img src="/_imagens/botoes/16x16/mostrar.gif" alt="Mostrar Tarifas" title="Mostrar Tarifas" width="16" height="16" align="absmiddle" /></button>
                        <button type="button" id="BTN_OCULTAR_TARIFAS_#qrVersao.VERSAO_ID#" class="botao-16x16" onClick="f_ocultar_tarifas(#qrVersao.VERSAO_ID#)" <cfif qrVersao.CurrentRow neq 1>style="display: none;"</cfif>><img src="/_imagens/botoes/16x16/ocultar.gif" alt="Ocultar Tarifas" title="Ocultar Tarifas" width="16" height="16" align="absmiddle" /></button></td>
                    <td nowrap align="center">#qrVersao.NUM_VERSAO#</td>
                    <td nowrap align="left">#qrVersao.USER_INSERT#</td>
                    <td nowrap align="left">#qrVersao.DATE_INSERT#</td>
                </tr>
                <cfif qrVersao.CurrentRow eq 1>
                <tr id="tr_versao_#qrVersao.VERSAO_ID#">
                    <td id="td_versao_#qrVersao.VERSAO_ID#" colspan="4">
                        <table border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td valign="top">
                                    <table border="0">
                                        <tr>
                                            <td valign="top">
                                                <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                    <tr class="titulo_1">
                                                        <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                        <td nowrap align="right">Valor</td>
                                                    </tr>
                                                    <cfloop query="qrVersaoTarifa">
                                                        <tr class="linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#';">
                                                            <td nowrap align="left">#qrVersaoTarifa.DESCRICAO#</td>
                                                            <td nowrap align="right">#LSNumberFormat(qrVersaoTarifa.VALOR, ',.__')#</td>
                                                        </tr>
                                                        <cfif qrVersaoTarifa.CurrentRow neq qrVersaoTarifa.RecordCount and qrVersaoTarifa.CurrentRow%10 eq 0>
                                                            </table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                            <tr class="titulo_1">
                                                                <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                                <td nowrap align="right">Valor</td>
                                                            </tr>
                                                        </cfif>
                                                    </cfloop>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td valign="top" style="padding-left: 20px;">
                                    <fieldset><legend>Dados da Tabela de Frete</legend>
                                    <table border="0" cellspacing="1" cellpadding="3">
                                        <tr>
                                            <td nowrap align="left" class="texto">Tabela de Frete:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.TABELA_FRETE_DESC#</td>
                                        </tr>
                                        <tr>
                                            <td nowrap align="left" class="texto">Rota:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.ROTA_DESC#</td>
                                        </tr>
                                        <tr>
                                            <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o de Natureza:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_NATUREZA_DESC#</td>
                                        </tr>
                                        <tr>
                                            <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o Comercial:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_COMERCIAL_DESC#</td>
                                        </tr>
                                    </table>
                                    </fieldset>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <cfelse>
                <tr id="tr_versao_#qrVersao.VERSAO_ID#" style="display: none;">
                    <td id="td_versao_#qrVersao.VERSAO_ID#" colspan="4"></td>
                </tr>
                </cfif>
            </cfoutput>
        </table>
        </fieldset>
    </cfcase>
    
    <cfcase value="10">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
			qrVersao       = conn.get_crt_comercial_versao(versao_id = vars.VERSAO_ID);
			qrVersaoTarifa = conn.get_conhecimento_tarifa(versao_id = vars.VERSAO_ID);
			
			conn = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
			qrTabelaFreteRota = conn.get_tabela_frete_rota(tabela_frete_rota_id = qrVersao.TABELA_FRETE_ROTA_ID);
		</cfscript>
        <table border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td valign="top">
                    <table border="0">
                        <tr>
                            <td valign="top">
                                <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                    <tr class="titulo_1">
                                        <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                        <td nowrap align="right">Valor</td>
                                    </tr>
                                    <cfoutput query="qrVersaoTarifa">
                                        <tr class="linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#';">
                                            <td nowrap align="left">#qrVersaoTarifa.DESCRICAO#</td>
                                            <td nowrap align="right">#LSNumberFormat(qrVersaoTarifa.VALOR, ',.__')#</td>
                                        </tr>
                                        <cfif qrVersaoTarifa.CurrentRow neq qrVersaoTarifa.RecordCount and qrVersaoTarifa.CurrentRow%10 eq 0>
                                            </table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                            <tr class="titulo_1">
                                                <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                <td nowrap align="right">Valor</td>
                                            </tr>
                                        </cfif>
                                    </cfoutput>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
                <td valign="top" style="padding-left: 20px;">
                    <cfscript>
						f_dados_tabela_frete();
					</cfscript>
                </td>
            </tr>
        </table>
    </cfcase>

    <cfcase value="11">
        <cfscript>
            conn = CreateComponent("modulos.transporte_internacional._componentes.consulta.cfc_transp_internacional");
            qrDacte= conn.get_dacte(argumentCollection = vars);
        </cfscript>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td class="texto">
                    <table width="100%" border="0" cellspacing="1" cellpadding="1">
                        <tr class="titulo_2">
                            <td nowrap align="center"><<>></td>
                            <td nowrap align="center">Num. Dacte</td>
                            <td nowrap align="center">CRTs Vinculados</td>                            
                            <td nowrap align="center">Data Emissao</td>
                            <td nowrap align="left">Rementente</td>
                            <td nowrap align="left">Coleta</td>
                            <td nowrap align="left">Destintario</td>
                            <td nowrap align="left">Entrega</td>
                            <td nowrap align="left">Cavalo</td>
                            <td nowrap align="left">Carreta</td>
                            <td nowrap align="right">Peso Total</td>
                            <td nowrap align="right">Peso Vinculado</td>
                            <td nowrap align="right">Peso Restante</td>
                            <td nowrap align="center">Peso</td>                            
                        </tr>
                        <cfoutput query="qrDacte">
                        <tr  style="height:20px;" class="linha_#(qrDacte.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrDacte.CurrentRow Mod 2) + 1#';" >
                            <td nowrap align="center"><cfif qrDacte.PESO gt qrDacte.VINCULADO_PESO><input name="CTE_ID_#qrDacte.CONHECIMENTO_ID#" id="CTE_ID_#qrDacte.CONHECIMENTO_ID#" type="checkbox" class="check" value="#qrDacte.CONHECIMENTO_ID#" onclick="f_vincular_peso(this.getAttribute('checked'),'#qrDacte.CONHECIMENTO_ID#');"/><cfelse>Vinculado</Cfif></td>
                            <td nowrap align="center">#qrDacte.NUM_CONHECIMENTO#/#qrDacte.SERIE#</td>
                            <td nowrap align="center">#qrDacte.CRTS_VINCULADOS#</td>                            
                            <td nowrap align="center">#qrDacte.DATA_EMISSAO#</td>
                            <td nowrap align="left">#qrDacte.REM_RAZAO_SOCIAL#</td>
                            <td nowrap align="left">#qrDacte.REM_MUNICIPIO#/#qrDacte.REM_UF#</td>
                            <td nowrap align="left">#qrDacte.DEST_RAZAO_SOCIAL#</td>
                            <td nowrap align="left">#qrDacte.DEST_MUNICIPIO#/#qrDacte.DEST_UF#</td>
                            <td nowrap align="left">#qrDacte.PLACA_TRACAO#</td>
                            <td nowrap align="left">#qrDacte.PLACA#</td>
                            <td nowrap align="right">#LSNumberFormat(qrDacte.PESO, ',.__')#</td>
                            <td nowrap align="right">#LSNumberFormat(qrDacte.VINCULADO_PESO, ',.__')#</td>
                            <td nowrap align="right">#LSNumberFormat(qrDacte.PESO-qrDacte.VINCULADO_PESO, ',.__')#</td>
                            <td nowrap align="center"><cfif qrDacte.PESO gt qrDacte.VINCULADO_PESO><input style="text-align:right" onchange="f_validar_peso(this,'#qrDacte.CONHECIMENTO_ID#',#qrDacte.PESO-qrDacte.VINCULADO_PESO#);" type="text" name="CTE_PESO_#qrDacte.CONHECIMENTO_ID#" id="CTE_PESO_#qrDacte.CONHECIMENTO_ID#" onkeypress="return f_formata_numero_decimal(this,event);" size="8" disabled readonly/></cfif> </td>                                                                                    
                        </tr>
                        </cfoutput>
                        <cfif qrDacte.RecordCount eq 0>
                        <tr>
                            <td colspan="2" align="center" valign="middle" class="obrigatorio">Nenhuma opera&ccedil;&atilde;o foi encontrada.</td>
                        </tr>
                        </cfif>
                    </table>
                </td>
            </tr>
        </table>
    </cfcase>
    
	<cfdefaultcase>
		<script defer="defer">
	    	alert('Operao no programada.');
	 	</script>
  	</cfdefaultcase>
</cfswitch>

<cffunction name="f_dados_tabela_frete" >
	<cfif not len(trim(vars.OPERACAO_ID_CRT)) >
    	<script>
			alert(' necessrio informar a operao logstica para consultar a forma de clculo.');
		</script>
        <cfset qrTabela.erro = true >
        <cfset qrTabela.mensagem.cause.message = ' necessrio informar a operao logstica para consultar a forma de clculo.' >  
    <cfelse>
        <cfscript>
			if(len(trim(vars.OPERACAO_ID_CRT))){
				connO = CreateComponent("_transportes.consulta.logistica.cfc_operacao");
				qrOperacao= connO.get_operacao(operacao_id = vars.OPERACAO_ID_CRT);
				vars.TIPO_SERVICO_COMERCIAL = qrOperacao.TIPO_SERVICO_ID;
			}else
				vars.TIPO_SERVICO_COMERCIAL =  '';
				
            connC = CreateComponent("modulos.transporte_internacional._componentes.consulta.cfc_tabela_frete");
    
            qrTabela = connC.valida_tabela_frete(ORIGEM_MUNICIPIO_ID  		= vars.RESP_MUNICIPIO_ID,
                                                 DESTINO_MUNICIPIO_ID 		= vars.ENTREGA_MUNICIPIO_ID,
                                                 COD_NEGOCIADOR       		= vars.COD_NEGOCIADOR,
                                                 CLASSIFICACAO_NATUREZA_ID	= vars.CLASSIFICACAO_NATUREZA_ID,
                                                 CLASSIFICACAO_COMERCIAL_ID = vars.CLASSIFICACAO_COMERCIAL_ID,
                                                 TIPO_SERVICO_ID			= vars.TIPO_SERVICO_COMERCIAL,
                                                 TIPO						= 1 //Internacional
                                                );
		</cfscript>
    </cfif>
        
	<script>
        parent.document.form_crt.TIPO_SERVICO_COMERCIAL.value = '<cfoutput>#vars.TIPO_SERVICO_COMERCIAL#</cfoutput>';
    </script>
    <cfset v_tipo = 'Internacional' >
    <cfif qrTabela.erro >
        <cfset v_negociador       = 'No identificado...' >
        <cfset v_num_tabelas      = 0 >
        <cfset v_num_vigencia     = 0 >
        <cfset v_num_rotas        = 0 >
        <cfset v_num_tipo 		  = 0 >
        <cfset v_rota		      = 'No identificado...' >
        <cfset v_tipo_veiculo     = 'No identificado...' >
        <cfset v_num_tipo_veiculo = 0 >
        <cfset v_produto          = 'No identificado...' >
        <cfset v_num_produto      = 0 >
        <cfset v_tipo_servico     = 'No identificado...' >
        <cfset v_num_tipo_servico = 0 >
        <cfif not len(trim(vars.OPERACAO_ID_CRT)) >
            <cfset v_tabela_frete     = ' necessrio informar a operao logstica para consultar a forma de clculo.'>
        <cfelse>
            <cfset v_tabela_frete     = 'N&atilde;o foi poss&iacute;vel definir a tabela de frete, entre em contato com o departamento comercial.<br />'&mid(qrTabela.mensagem.cause.message,12,len(qrTabela.mensagem.cause.message))>
        </cfif>
    <cfelse>
        <cfset v_negociador       = qrTabela.NEGOCIADOR >
        <cfset v_num_tabelas      = qrTabela.NUM_TABELAS >
        <cfset v_num_vigencia     = qrTabela.NUM_VIGENCIA >
        <cfset v_num_rotas        = qrTabela.NUM_ROTAS >
        <cfset v_rota		      = qrTabela.ROTA >
        <cfset v_tipo_veiculo     = qrTabela.TIPO_VEICULO >
        <cfset v_num_tipo_veiculo = qrTabela.NUM_TIPO_VEICULO >
        <cfset v_produto          = qrTabela.PRODUTO >
        <cfset v_num_produto      = qrTabela.NUM_PRODUTO >
        <cfset v_tipo_servico     = qrTabela.TIPO_SERVICO >
        <cfset v_num_tipo_servico = qrTabela.NUM_TIPO_SERVICO >
        <cfset v_num_tipo 		  = qrTabela.NUM_TIPO >
        <cfset v_tabela_frete     = ''>
    </cfif>
    
    <table border="0" cellspacing="1" cellpadding="3" class="borda" width="493">                           
        <tr>
            <td colspan="4" class="titulo_1" align="center" style="border-bottom:1px solid #91A6B9">Tabela de Frete</td>
        </tr>
        <tr class="texto" style="text-align:center; font-weight:bold;">
            <td style="border-bottom:1px solid #99adbf" width="20%">Itens</td>
            <td style="border-bottom:1px solid #99adbf" width="79%">Valores</td>
            <td style="border-bottom:1px solid #99adbf" width="10%"><nobr>Tabelas Ativas</nobr></td>
            <td style="border-bottom:1px solid #99adbf" width="1%">&nbsp;</td>
        </tr>
        <cfoutput>

        <cfif v_num_tabelas eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif v_num_tabelas eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_1">
            <td>Negociador</td>
            <td><nobr>#v_negociador#</nobr></td>
            <td align="center">#v_num_tabelas#</td>
            <td><img src="/_imagens/botoes/16x16/#v_img#"  /></td>
        </tr>
        <cfif v_num_tipo eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif v_num_tipo eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_2">
            <td>Tipo</td>
            <td><nobr>#v_tipo#</nobr></td>
            <td align="center">#v_num_tipo#</td>
            <td><img src="/_imagens/botoes/16x16/#v_img#"  /></td>
        </tr>
        <cfif v_num_vigencia eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif v_num_vigencia eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_1">
            <td>Vig&ecirc;ncia</td>
            <td>#lsDateFormat(now())#</td>
            <td align="center">#v_num_vigencia#</td>
            <td><img src="/_imagens/botoes/16x16/#v_img#"  /></td>
        </tr>
        <cfif v_num_rotas eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif v_num_rotas eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_2">
            <td>Rota</td>
            <td>#v_rota#</td>
            <td align="center">#v_num_rotas#</td>
            <td><img src="/_imagens/botoes/16x16/#v_img#"  /></td>
        </tr>
        <cfif v_num_produto eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif v_num_produto eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_1">
            <td>Mercadoria</td>
            <td>#v_produto#</td>
            <td align="center">#v_num_produto#</td>
            <td><img src="/_imagens/botoes/16x16/#v_img#"  /></td>
        </tr>
        <cfif v_num_tipo_veiculo eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif v_num_tipo_veiculo eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_2">
            <td valign="top"><nobr>Tipo do Ve&iacute;culo</nobr></td>
            <td>#v_tipo_veiculo#</td>
            <td valign="top" align="center">#v_num_tipo_veiculo#</td>
    
            <td valign="top"><img src="/_imagens/botoes/16x16/#v_img#"  /></td>
        </tr>
        <cfif v_num_tipo_servico eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif v_num_tipo_servico eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_1">
            <td><nobr>Tipo Servi&ccedil;o</nobr></td>
            <td>#v_tipo_servico#</td>
            <td align="center">#v_num_tipo_servico#</td>
            <td><img src="/_imagens/botoes/16x16/#v_img#"  /></td>
        </tr>
        <tr>
            <td colspan="4" <cfif not isDefined("qrTabela.TABELA_FRETE") or not len(trim(qrTabela.TABELA_FRETE))>  class="obrigatorio" <cfelse> class="texto" </cfif> align="center" height="30" style="border-top:1px solid ##91A6B9; <cfif isDefined("qrTabela.TABELA_FRETE") and len(trim(qrTabela.TABELA_FRETE))>font-weight:bold</cfif>">
                <cfif not isDefined("qrTabela.TABELA_FRETE") or not len(trim(qrTabela.TABELA_FRETE))>
                    <cfset qrTabela.TABELA_ENCONTRADA  = 0 >
                    <a onClick="f_show_erro_tf()" class="a_erro_tf" onmouseover="this.className = 'a_erro_tf_hover'" onmouseout="this.className = 'a_erro_tf'" >
                        No foi possvel identificar a tabela de frete. Entre em contato com o departamento comercial.
                    </a>
                <cfelse>
                    Tabela Selecionada: #qrTabela.TABELA_FRETE#
                </cfif>
            </td>
        </tr>
        <tr>
            <td colspan="4" style="border-top:1px solid ##91A6B9">
                <button type="button" class="botao_tbl_frete" onClick="f_busca_tipo_calculo()" style="margin-right: 5px; width:100%; text-align:center;"><img src="/_imagens/botoes/16x16/atualizar.gif" alt="Tentar Novamente" title="Tentar Novamente" width="16" height="16" align="absmiddle" />&nbsp;Reconsultar forma de C&aacute;lculo</button>
            </td>
        </tr>
        </cfoutput>
    </table>
	<cfreturn qrTabela >
</cffunction>
