<cfcomponent  extends="_transportes.funcoes.cfc_init">
    
    <!--- 
	-- PROPSITO
	-- Vincula um contrato de transporte a uma diviso de crt
	-- WAGNERS 06/03/2012 16:33:30 - CRIADO
	--->
	<cffunction name='EMBARQUE_DIVISAO_CONTRATO' displayname='Vincula um contrato de transporte a uma diviso de crt' access='remote' returntype='Struct' output='true'>
		<cfargument name='DIVISAO_ID' required='yes'>
		<cfargument name='CONTRATO_TRANSPORTE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.PRC_EMBARQUE_DIVISAO_CONTRATO' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_TRANSPORTE_ID#'  null='#iif(len(trim(arguments.CONTRATO_TRANSPORTE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vnculo efetuado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Permisso
	-- rafael 12/05/2009 16:43:35 - CRIADO
	--->
	<cffunction name='ins_permisso' displayname='Inserir Permisso' access='remote' returntype='Struct' output='true'>
		<cfargument name='PERMISSO_ID' required='no' default="">
		<cfargument name='COD_PAIS' required='yes'>
		<cfargument name='NUM_PERMISSO' required='yes'>
		<cfargument name='NUM_SEQUENCIAL_INICIAL' required='yes'>
        <cfargument name='TIPO_DOCUMENTO' required='yes'>
        <cfargument name='SERIE' required='yes'>
		<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_permisso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PERMISSO_ID#' variable='retorno.PERMISSO_ID'  null='#iif(len(trim(arguments.PERMISSO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_PAIS#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_PERMISSO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_SEQUENCIAL_INICIAL#'  null='#iif(len(trim(arguments.NUM_SEQUENCIAL_INICIAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_DOCUMENTO#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Permisso inserido com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Editar Permisso
	-- rafael 12/05/2009 16:46:41 - CRIADO	
	--->
	<cffunction name='upd_permisso' displayname='Editar Permisso' access='remote' returntype='Struct' output='true'>
		<cfargument name='PERMISSO_ID' required='yes'>
		<cfargument name='COD_PAIS' required='yes'>
		<cfargument name='NUM_PERMISSO' required='yes'>
		<cfargument name='NUM_SEQUENCIAL_INICIAL' required='yes'>
        <cfargument name='TIPO_DOCUMENTO' required='yes'>
        <cfargument name='SERIE' required='yes'>
			<cftry>
			<cftransaction action='begin'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_permisso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PERMISSO_ID#'  null='#iif(len(trim(arguments.PERMISSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_PAIS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_PERMISSO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_SEQUENCIAL_INICIAL#'  null='#iif(len(trim(arguments.NUM_SEQUENCIAL_INICIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_DOCUMENTO#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Permisso alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exluir Permisso
	-- rafael 12/05/2009 16:50:00 - CRIADO
	--->
	<cffunction name='del_permisso' displayname='Exluir Permisso' access='remote' returntype='Struct' output='true'>
		<cfargument name='PERMISSO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_permisso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PERMISSO_ID#'  null='#iif(len(trim(arguments.PERMISSO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Permisso excluido com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
        </cftry>
        <cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um conhecimento internacional
	-- 06/12/2005 - criado
	--->
    <cffunction name="ins_intc_conhecimento" displayname="Insere um tipo de objeto" access="remote" returntype="Struct" output="true">
        <cfargument name="numero" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="#session.cod_pessoa#" >
        <cfargument name="cod_organograma" required="yes">
        <cfargument name="emissao_local" required="no" default="">
        <cfargument name="emissao_municipio_id" required="yes" default="">
        <cfargument name="emissao_data" required="no" default="#DateFormat(now(), 'DD/MM/YYYY')#">
        <cfargument name="resp_local" required="yes">
        <cfargument name="resp_municipio_id" required="yes">
        <cfargument name="resp_data" required="yes">
        <cfargument name="entrega_local" required="yes">
        <cfargument name="entrega_municipio_id" required="yes">
        <cfargument name="entrega_data" required="yes">
        <cfargument name="transp_sucessivos" required="no" default="N.I.H.I.L">
        <cfargument name="cod_remetente" required="yes">
        <cfargument name="rem_endereco" required="yes">
        <cfargument name="rem_municipio" required="yes">
        <cfargument name="rem_uf" required="yes">
        <cfargument name="rem_pais" required="yes">
        <cfargument name="rem_cnpj_cpf" required="yes">
        <cfargument name="cod_destinatario" required="yes">
        <cfargument name="dest_nome" required="yes">
        <cfargument name="dest_endereco" required="yes">
        <cfargument name="dest_municipio" required="yes">
        <cfargument name="dest_uf" required="yes">
        <cfargument name="dest_pais" required="yes">
        <cfargument name="dest_cnpj_cpf" required="yes">
        <cfargument name="cod_consignatario" required="yes">
        <cfargument name="cons_nome" required="yes">
        <cfargument name="cons_endereco" required="yes">
        <cfargument name="cons_municipio" required="yes">
        <cfargument name="cons_uf" required="yes">
        <cfargument name="cons_pais" required="yes">
        <cfargument name="cons_cnpj_cpf" required="yes">
        <cfargument name="cod_notificar" required="yes">
        <cfargument name="not_nome" required="yes">
        <cfargument name="not_endereco" required="yes">
        <cfargument name="not_municipio" required="yes">
        <cfargument name="not_uf" required="yes">
        <cfargument name="not_pais" required="yes">
        <cfargument name="not_cnpj_cpf" required="yes">
        <cfargument name="mercadorias" required="no" default="">
        <cfargument name="num_especie" required="yes">
        <cfargument name="quantidade_total" required="yes">
        <cfargument name="peso_bruto" required="yes">
        <cfargument name="peso_liquido" required="yes">
        <cfargument name="unidade_id" required="yes">
        <cfargument name="m3" required="yes">
        <cfargument name="valor_total" required="yes">
        <cfargument name="valor_total_incoterm_id" required="yes">
        <cfargument name="valor_total_cod_moeda" required="yes">
        <cfargument name="total_custo_origem" required="yes">
        <cfargument name="total_custo_origem_cod_moeda" required="no" default="220">
        <cfargument name="total_custo_destino" required="yes">
        <cfargument name="total_custo_destino_cod_moeda" required="no" default="220">
        <cfargument name="valor_frt_externo" required="yes">
        <cfargument name="valor_frt_externo_cod_moeda" required="no" default="220">
        <cfargument name="valor_reembolso" required="yes">
        <cfargument name="valor_reembolso_cod_moeda" required="no" default="220">
        <cfargument name="valor_mercadorias" required="yes">
        <cfargument name="valor_mercadorias_incoterm" required="yes">
        <cfargument name="valor_mercadorias_cod_moeda" required="no" default="220">
        <cfargument name="alfandega_origem_id" required="yes">
        <cfargument name="alfandega_destino_id" required="yes">
        <cfargument name="pais_id_origem" required="yes">
        
        <cfargument name="pago_por" required="no" default="1">
        <cfargument name="declaracao_observacao" required="yes">
        <cfargument name="OBS_PAGO_POR" required="no">
        <cfargument name="ADICIONAIS_MERCADORIA" required="yes" >
        <cfargument name="SEGURO_PAGO_EMPRESA" required="no" default="0" >
        <cfargument name="QTDE_VEICULOS" required="no" default="1" >
        
        <cfargument name="EMISSAO_DATA_IMPRESSAO" required="no" default="" >
        <cfargument name="TAXA_MERCADORIA_SEGURO" required="no" default="0" >
    
        <cfargument name='COD_PAGADOR_ORIGEM' required='yes'>
        <cfargument name='PAG_ORIGEM_NOME' required='yes'>
        <cfargument name='PAG_ORIGEM_ENDERECO' required='yes'>
        <cfargument name='PAG_ORIGEM_MUNICIPIO' required='yes'>
        <cfargument name='PAG_ORIGEM_UF' required='yes'>
        <cfargument name='PAG_ORIGEM_PAIS' required='yes'>
        <cfargument name='PAG_ORIGEM_CNPJ_CPF' required='yes'>
        <cfargument name='COD_PAGADOR_DESTINO' required='yes'>
        <cfargument name='PAG_DESTINO_NOME' required='yes'>
        <cfargument name='PAG_DESTINO_ENDERECO' required='yes'>
        <cfargument name='PAG_DESTINO_MUNICIPIO' required='yes'>
        <cfargument name='PAG_DESTINO_UF' required='yes'>
        <cfargument name='PAG_DESTINO_PAIS' required='yes'>
        <cfargument name='PAG_DESTINO_CNPJ_CPF' required='yes'>    
        <cfargument name='PRE_CONHECIMENTO' required='yes' default="0">    
        <cfargument name='COTACAO' required='yes'>
        <cfargument name='ORGANIZACIONAL_ID_GERENCIAL' required='no' default="">  
        <cfargument name='PRAZO_ENTREGA' required='yes'>
        <cfargument name='COD_NEGOCIADOR' required='yes'>  
        <cfargument name='NF_FATURA' required='yes'>
        <cfargument name='TIPO_CRT' required='no' default="0">
        <cfargument name='OPERACAO_ID_CRT' required='no' default="">
        <cfargument name='CRT_COD_PAIS' required='no' default="">
        <cfargument name='CRT_NUM_PERMISSO' required='no' default="">
        <cfargument name='CRT_NUMERO' required='no' default="">
        <cfargument name='CRT_SERIE' required='no' default="">
        <cfargument name='PEDIDO_SHIPMENT' required='no' default="">
        <cfargument name='TIPO_SERVICO_COMERCIAL' required="yes" default="" >
		<cfargument name='LIMITE_PROG_CARGA' required="no" default="" >
        <cfargument name='LIMITE_PESO' required="no" default="" >
        <cfargument name='LIMITE_EMBARQUES' required="no" default="" >
        <cfargument name='NUM_LOTE_CLIENTE' required="no" default="" >
        <cfargument name='LIMITE_EMBARQUES_2' required="no" default="" >
		
		<cfargument name="rem_cod_endereco" required="yes">
		<cfargument name="dest_cod_endereco" required="yes">
		<cfargument name="cons_cod_endereco" required="yes">
		<cfargument name="not_cod_endereco" required="yes">
		<cfargument name='pag_origem_cod_endereco' required='yes' default="">
		<cfargument name='pag_destino_cod_endereco' required='yes'  default="">
		<cfargument name='neg_cod_endereco' required='yes'>	
        <cftry>
            <cfscript>
                v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
                v_mercadorias = "";
            </cfscript>
            <cfloop from="1" to="#ArrayLen(v_descricao)#" index="v_index">
                <cfset v_mercadorias = v_mercadorias&v_descricao[v_index]&chr(10)>			
            </cfloop>
                <cfset v_mercadorias = v_mercadorias&arguments.adicionais_mercadoria>			
            <cftransaction action="begin"> 
                <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_ins_conhecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#UCase(arguments.CRT_COD_PAIS)#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_varchar" value="#arguments.CRT_NUM_PERMISSO#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.CRT_NUMERO#" null="#iif(len(trim(arguments.CRT_NUMERO)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_pessoa_filial#" null="#iif(len(trim(arguments.cod_pessoa_filial)), de('no'), de('yes'))#">
                    <cfprocparam  			   type="in"  cfsqltype="cf_sql_varchar" value="#arguments.COD_ORGANOGRAMA#" null="#iif(len(trim(arguments.COD_ORGANOGRAMA)), de('no'), de('yes'))#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.emissao_local#">
                    <cfprocparam  		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.emissao_municipio_id#" null="#iif(len(trim(arguments.emissao_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.emissao_data#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.resp_local#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.resp_municipio_id#" null="#iif(len(trim(arguments.resp_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.resp_data#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.entrega_local#">
                    <cfprocparam  		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.entrega_municipio_id#" null="#iif(len(trim(arguments.entrega_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.entrega_data#">
                    <cfprocparam 			type="in"  cfsqltype="cf_sql_varchar" value="#arguments.transp_sucessivos#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_remetente#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_nome#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_endereco#">
                    <cfprocparam 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.rem_municipio_id#" null="#iif(len(trim(arguments.rem_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_municipio#">
    
                    <cfprocparam  						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_uf#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_pais#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_cnpj_cpf#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_destinatario#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_nome#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_endereco#">
                    <cfprocparam 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.dest_municipio_id#" null="#iif(len(trim(arguments.dest_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_municipio#">
    
                    <cfprocparam  						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_uf#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_pais#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_cnpj_cpf#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_consignatario#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_nome#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_endereco#">
                    <cfprocparam 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cons_municipio_id#" null="#iif(len(trim(arguments.cons_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_municipio#">
    
                    <cfprocparam  						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_uf#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_pais#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_cnpj_cpf#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_notificar#" null="#iif(len(trim(arguments.cod_notificar)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_nome#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_endereco#">
                    <cfprocparam 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.not_municipio_id#" null="#iif(len(trim(arguments.not_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_municipio#">
    
                    <cfprocparam  						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_uf#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_pais#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_cnpj_cpf#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#v_mercadorias#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.num_especie#" null="#iif(len(trim(arguments.num_especie)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.quantidade_total#" null="#iif(len(trim(arguments.quantidade_total)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_bruto#" null="#iif(len(trim(arguments.peso_bruto)), de('no'), de('yes'))#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_liquido#" null="#iif(len(trim(arguments.peso_liquido)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.unidade_id#">
                    <cfprocparam  							type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.m3#"  null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#Replace(arguments.valor_total, ',', '.', 'all')#" null="#iif(len(trim(arguments.valor_total)), de('no'), de('yes'))#">
                    <cfprocparam 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total_cod_moeda#">
                    <cfprocparam 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total_incoterm_id#" null="#iif(len(trim(arguments.valor_total_incoterm_id)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_origem#" null="#iif(len(trim(arguments.total_custo_origem)), de('no'), de('yes'))#">
                    <cfprocparam  type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_origem_cod_moeda#" null="#iif(len(trim(arguments.total_custo_origem_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_destino#" null="#iif(len(trim(arguments.total_custo_destino)), de('no'), de('yes'))#">
                    <cfprocparam  type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_destino_cod_moeda#" null="#iif(len(trim(arguments.total_custo_destino_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#Replace(arguments.valor_frt_externo, ',', '.', 'all')#" null="#iif(len(trim(arguments.valor_frt_externo)), de('no'), de('yes'))#">
                    <cfprocparam 	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_frt_externo_cod_moeda#" null="#iif(len(trim(arguments.valor_frt_externo_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso#"  null="#iif(len(trim(arguments.valor_reembolso)), de('no'), de('yes'))#">
                    <cfprocparam  	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso_cod_moeda#" null="#iif(len(trim(arguments.valor_reembolso_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#Replace(arguments.valor_mercadorias, ',', '.', 'all')#" null="#iif(len(trim(arguments.valor_mercadorias)), de('no'), de('yes'))#">
                    <cfprocparam  	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias_cod_moeda#" null="#iif(len(trim(arguments.valor_mercadorias_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam  	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias_incoterm#" null="#iif(len(trim(arguments.valor_mercadorias_incoterm)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.alfandega_origem_id#"  null="#iif(len(trim(arguments.alfandega_origem_id)), de('no'), de('yes'))#">
                    <cfprocparam  		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.alfandega_destino_id#"  null="#iif(len(trim(arguments.alfandega_destino_id)), de('no'), de('yes'))#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.pais_id_origem#"  null="#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.pago_por#" null="#iif(len(trim(arguments.pago_por)), de('no'), de('yes'))#">
                    <cfprocparam  		type="in"  cfsqltype="cf_sql_varchar" value="#arguments.declaracao_observacao#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_varchar"  value="#arguments.OBS_PAGO_POR#">
                    <cfprocparam 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.qtde_veiculos#" null="#iif(len(trim(arguments.qtde_veiculos)), de('no'), de('yes'))#">
                    <cfprocparam 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.seguro_pago_empresa#" null="#iif(len(trim(arguments.seguro_pago_empresa)), de('no'), de('yes'))#">
                    <cfprocparam  				type="inout" cfsqltype="cf_sql_numeric" scale="5" null="yes" variable="retorno.conhecimento_id">
                    <cfprocparam  						type="out" cfsqltype="cf_sql_varchar" variable="retorno.rowid">			
                    <cfprocparam 		type="in"  cfsqltype="cf_sql_varchar" value="#arguments.emissao_data_impressao#">
                    <cfprocparam 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.TAXA_MERCADORIA_SEGURO#" null="#iif(len(trim(arguments.TAXA_MERCADORIA_SEGURO)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PAGADOR_ORIGEM#'  null='#iif(len(trim(arguments.COD_PAGADOR_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_PAIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PAGADOR_DESTINO#'  null='#iif(len(trim(arguments.COD_PAGADOR_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_PAIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_CNPJ_CPF#' >
                    <cfprocparam 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.PRE_CONHECIMENTO#" null="#iif(len(trim(arguments.PRE_CONHECIMENTO)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COTACAO#' null='#iif(len(trim(arguments.COTACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID_GERENCIAL#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_GERENCIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.PRAZO_ENTREGA#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NF_FATURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_CRT#'  null='#iif(len(trim(arguments.TIPO_CRT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.OPERACAO_ID_CRT#'  null='#iif(len(trim(arguments.OPERACAO_ID_CRT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CRT_SERIE#'  null='#iif(len(trim(arguments.CRT_SERIE)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.pedido_shipment#" >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_SERVICO_COMERCIAL#'  null='#iif(len(trim(arguments.TIPO_SERVICO_COMERCIAL)), de('no'), de('yes'))#'>
		    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_PROG_CARGA#'  null='#iif(len(trim(arguments.LIMITE_PROG_CARGA)), de('no'), de('yes'))#'>                    
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_PESO#'  null='#iif(len(trim(arguments.LIMITE_PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_EMBARQUES#'  null='#iif(len(trim(arguments.LIMITE_EMBARQUES)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NUM_LOTE_CLIENTE#" >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_EMBARQUES_2#'  null='#iif(len(trim(arguments.LIMITE_EMBARQUES_2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   null="yes">
					<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" value="#arguments.rem_cod_endereco#">
					<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" value="#arguments.dest_cod_endereco#">
					<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cons_cod_endereco#">
					<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" value="#arguments.not_cod_endereco#">
					<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" value="#arguments.neg_cod_endereco#"> 
					<cfprocparam  		type='in'  cfsqltype='cf_sql_numeric' scale='5' value='#arguments.pag_origem_cod_endereco#' null='#iif(len(trim(arguments.pag_origem_cod_endereco)), de('no'), de('yes'))#'>
					<cfprocparam 		type='in'  cfsqltype='cf_sql_numeric' scale='5' value='#arguments.pag_destino_cod_endereco#' null='#iif(len(trim(arguments.pag_destino_cod_endereco)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <!--- Insercao de Mercadorias Transportadas --->
                <cfscript>
                    v_produto_id = this.ListaToArray (lista = arguments, variavel = "MERC_PRODUTO_ID_MERCADORIAS");
                    v_num_especie = this.ListaToArray (lista = arguments, variavel = "MERC_NUM_ESPECIE_MERCADORIAS");
                    v_quantidade = this.ListaToArray (lista = arguments, variavel = "MERC_QUANTIDADE_MERCADORIAS");
                    v_peso_bruto = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_BRUTO_MERCADORIAS");
                    v_peso_liquido = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_LIQUIDO_MERCADORIAS");
                    v_m3 = this.ListaToArray (lista = arguments, variavel = "MERC_VOLUME_MERCADORIAS");
                    v_unidade_id = this.ListaToArray (lista = arguments, variavel = "MERC_UNIDADE_ID_MERCADORIAS");
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                        this.ins_item_crt(	conhecimento_id = retorno.conhecimento_id,
                                            produto_id = v_produto_id[count],
                                            num_especie = v_num_especie[count],
                                            quantidade = v_quantidade[count],
                                            peso_bruto = v_peso_bruto[count],
                                            peso_liquido = v_peso_liquido[count],
                                            m3 = v_m3[count],
                                            descricao = v_descricao[count]);
                    </cfscript>
                </cfloop>
                <!--- Insercao de Custos --->
                <cfscript>
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "CUST_DESCRICAO_CUSTOS");
                    v_valor_origem = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_CUSTOS");
                    v_valor_origem_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_COD_MOEDA_CUSTOS");
                    v_valor_destino = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_CUSTOS");
                    v_valor_destino_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_COD_MOEDA_CUSTOS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                        this.ins_custo_crt(	conhecimento_id = retorno.conhecimento_id,
                                            descricao = v_descricao[count],
                                            valor_origem = v_valor_origem[count],
                                            valor_origem_cod_moeda = v_valor_origem_cod_moeda[count],
                                            valor_destino = v_valor_destino[count],
                                            valor_destino_cod_moeda = v_valor_destino_cod_moeda[count]);
                    </cfscript>
                </cfloop>
                <!--- Insercao de anexos --->
                <cfscript>
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "ANEXO_DESCRICAO_ANEXOS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                        this.ins_anexo_crt(	conhecimento_id = retorno.conhecimento_id,
                                            descricao = v_descricao[count]);
                    </cfscript>
                </cfloop>	
                    
                <!--- Alteraes dos Complementados --->
                <cfscript>
                    v_tipo_id_complemento = this.ListaToArray (lista = arguments, variavel = "TIPO_COMPLEMENTO_COMPLEMENTO");
                    v_conhecimento_id_complemento = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_COMPLEMENTO_ID_COMPLEMENTO");
                    v_numero_compl = this.ListaToArray (lista = arguments, variavel = "CRT_COMPLEMENTO_COMPLEMENTO");
                    v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_COMPLEMENTO, lista2 = ArrayToList(v_conhecimento_id_complemento));
                </cfscript>
                <!--- Excluir os itens --->
                <cfloop list="#v_excluir#" delimiters="," index="l_id">
                    <cfscript>
                        ret = this.del_conhecimento_complemento (conhecimento_id = retorno.conhecimento_id,
                                                            conhecimento_id_complemento   = l_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <!--- Insercao de FRONTEIRAS --->
                <cfscript>
                    v_fronteira_id = this.ListaToArray (lista = arguments, variavel = "FRONTEIRA_ID_FRONTEIRAS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_fronteira_id)#" index="count">
                    <cfscript>
                        this.ins_crt_fronteira(	conhecimento_id = retorno.conhecimento_id,
                                                fronteira_id	= v_fronteira_id[count]);
                    </cfscript>
                </cfloop>	  

				<!--- Insercao de ADUANAS --->
                <cfscript>
                    v_aduana_id = this.ListaToArray (lista = arguments, variavel = "ADUANA_ID_ADUANAS");
					v_aduana_ordem = this.ListaToArray (lista = arguments, variavel = "ADUANA_ORDEM_ADUANAS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_aduana_id)#" index="count">
                    <cfscript>
                        this.ins_crt_aduana(conhecimento_id = retorno.conhecimento_id,
                                            aduana_id	 = v_aduana_id[count],
											aduana_ordem = v_aduana_ordem[count]);
                    </cfscript>
                </cfloop>	           

                <!---Diviso--->
				<cfscript>
                    arguments.conhecimento_id = retorno.conhecimento_id; 
                    ret = this.ins_divisao(argumentCollection  = arguments );
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>                
                
                <cfloop from="1" to="#ArrayLen(v_conhecimento_id_complemento)#" index="count">
                    <cfscript>
                        ret = this.ins_conhecimento_complemento(	conhecimento_id = retorno.conhecimento_id,
                                                                    conhecimento_id_complemento = v_conhecimento_id_complemento[count],
                                                            tipo_id = v_tipo_id_complemento[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>	
               
               	<!--- Gera conhecimento FORM --->
                <cfscript>
					set_impressao = this.ins_intc_conhecimento_form(conhecimento_id = arguments.conhecimento_id);
				</cfscript>
               
			    <cfif IsDefined("set_impressao") and set_impressao.erro>
					<cfthrow object="#set_impressao.mensagem#">
                </cfif>
                <!--- Calcula Seguro --->
				<cfscript>
                    retorno = this.calcula_seguro_crt(conhecimento_id = retorno.conhecimento_id);
                </cfscript>                   
                <cfif IsDefined("retorno") and retorno.erro>
                    <cfthrow object="#retorno.mensagem#">
                </cfif>
                
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfscript>
					conn_cons_tf = CreateComponent("modulos.transporte_internacional._componentes.consulta.cfc_tabela_frete");
					qrGrupoNegociadorPessoa = conn_cons_tf.get_grupo_negociador_pessoa(cod_pessoa = arguments.COD_NEGOCIADOR);
				</cfscript>                
                
                <cfif qrGrupoNegociadorPessoa.EMITE_TABELA_FRETE eq 1 and ArrayLen(v_conhecimento_id_complemento) eq 0>
                	<cfscript>
						qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id_intc(ORIGEM_MUNICIPIO_ID  		= arguments.RESP_MUNICIPIO_ID,
																						 DESTINO_MUNICIPIO_ID 		= arguments.ENTREGA_MUNICIPIO_ID,
																						 COD_NEGOCIADOR       		= arguments.COD_NEGOCIADOR,
																						 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																						 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID,
																						 TIPO_SERVICO_ID			= arguments.TIPO_SERVICO_COMERCIAL);
					</cfscript>
					<cfif qrTabelaFreteRotaId.erro>
						<cfthrow object="#qrTabelaFreteRotaId.mensagem#">
					</cfif>
					
                    <cfscript>
						// Constantes
						arguments.CONSTANTE_PESO_BRUTO            = arguments.PESO_BRUTO;
						arguments.CONSTANTE_PESO_COBRADO          = arguments.PESO_BRUTO;
						arguments.CONSTANTE_CUBAGEM	            = arguments.M3;
						arguments.CONSTANTE_VALOR_MERCADORIA      = arguments.VALOR_TOTAL;
						arguments.CONSTANTE_MUNICIPIO_ID_ORIGEM   = arguments.RESP_MUNICIPIO_ID;
						arguments.CONSTANTE_MUNICIPIO_ID_DESTINO  = arguments.ENTREGA_MUNICIPIO_ID;
						arguments.CONSTANTE_FRETE_PROPRIO		   = 1;
						arguments.CONSTANTE_INTERNACIONAL		   = 1;
						arguments.CONSTANTE_CRT_ID				      = arguments.CONHECIMENTO_ID;
						arguments.CONSTANTE_NRO_VOLUMES			   = arguments.QUANTIDADE_TOTAL;
						// ----------
					</cfscript>
                    
                    <cfscript>
						qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID
																			 , tabela_frete_id 		= qrTabelaFreteRotaId.TABELA_FRETE_ID);
						qrConstante 	  = conn_cons_tf.get_constante();
						qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID
																				 , tabela_frete_id 		= qrTabelaFreteRotaId.TABELA_FRETE_ID);
						
						conn_manip_tf = CreateComponent("modulos.transporte_internacional._componentes.manipulacao.cfc_tabela_frete");
					</cfscript>
					
					<cfloop query="qrConstante">
						<cfscript>
							ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
														  		   VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
						</cfscript>
						<cfif ret_cons.erro>
							<cfthrow object="#ret_cons.mensagem#">
						</cfif>
					</cfloop>
					
					<cfscript>
						ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
														 		  VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_cons_tf.erro>
						<cfthrow object="#ret_cons_tf.mensagem#">
					</cfif>
					
					<cfscript>
						ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
														  		   VALOR		 = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID);
					</cfscript>
					<cfif ret_cons_tfr.erro>
						<cfthrow object="#ret_cons_tfr.mensagem#">
					</cfif>
					
                    <cfscript>
                    ret_cons_tfv = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_VIGENCIA_ID',
                                                      		   VALOR         = qrTabelaFreteRota.tabela_frete_vigencia_id);
                    </cfscript>
					<cfif ret_cons_tfv.erro>
						<cfthrow object="#ret_cons_tfv.mensagem#">
					</cfif>
					
					<cfloop query="qrVariavel">
						<cfscript>
							ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
																	 		  TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID,
																	 		  TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 		  VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					</cfloop>
                    
                    <cfscript>
						ret_calc = this.calcula_crt_tabela_frete(CONHECIMENTO_ID			= retorno.CONHECIMENTO_ID,
																 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID);
					</cfscript>
					<cfif ret_calc.erro>
						<cfthrow object="#ret_calc.mensagem#">
					</cfif>
                </cfif>
                <!--- Itinerrio --->
				<cfscript>
                    arguments.conhecimento_id = retorno.conhecimento_id; 
                    ret = this.ins_itinerarios(argumentCollection  = arguments );
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
                
                <!--- Vincula CTe e CRT  --->
				<cfscript>
                    arguments.conhecimento_id = retorno.conhecimento_id; 
                    ret = this.ins_cte_crt(argumentCollection  = arguments );
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>                   
				
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("C.R.T. inserido com sucesso!")>
            </cftransaction>
            <cfcatch>
                <cftransaction action="rollback"/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />		
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um conhecimento internacional
    -- 06/12/2005 - criado
    --->
    <cffunction name="upd_intc_conhecimento" displayname="Altera um conhecimento internacional" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="NUMERO" required="yes">
        <cfargument name="COD_PESSOA_FILIAL" required="yes">
        <cfargument name="COD_ORGANOGRAMA" required="yes">
        <cfargument name="EMISSAO_LOCAL" required="yes">
        <cfargument name="EMISSAO_MUNICIPIO_ID" required="yes">
        <cfargument name="RESP_LOCAL" required="yes">
        <cfargument name="RESP_MUNICIPIO_ID" required="yes">
        <cfargument name="RESP_DATA" required="yes">
        <cfargument name="ENTREGA_LOCAL" required="yes">
        <cfargument name="ENTREGA_MUNICIPIO_ID" required="yes">
        <cfargument name="ENTREGA_DATA" required="yes">
        <cfargument name="TRANSP_SUCESSIVOS" required="no" default="N.I.H.I.L">
        <cfargument name="COD_REMETENTE" required="yes">
        <cfargument name="REM_NOME" required="yes">
        <cfargument name="REM_ENDERECO" required="yes">
        <cfargument name="REM_MUNICIPIO" required="yes">
        <cfargument name="REM_UF" required="yes">
        <cfargument name="REM_PAIS" required="yes">
        <cfargument name="REM_CNPJ_CPF" required="yes">
        <cfargument name="COD_DESTINATARIO" required="yes">
        <cfargument name="DEST_NOME" required="yes">
        <cfargument name="DEST_ENDERECO" required="yes">
        <cfargument name="DEST_MUNICIPIO" required="yes">
        <cfargument name="DEST_UF" required="yes">
        <cfargument name="DEST_PAIS" required="yes">
        <cfargument name="DEST_CNPJ_CPF" required="yes">
        <cfargument name="COD_CONSIGNATARIO" required="yes">
        <cfargument name="CONS_NOME" required="yes">
        <cfargument name="CONS_ENDERECO" required="yes">
        <cfargument name="CONS_MUNICIPIO" required="yes">
        <cfargument name="CONS_UF" required="yes">
        <cfargument name="CONS_PAIS" required="yes">
        <cfargument name="CONS_CNPJ_CPF" required="yes">
        <cfargument name="COD_NOTIFICAR" required="yes">
        <cfargument name="NOT_NOME" required="yes">
        <cfargument name="NOT_ENDERECO" required="yes">
        <cfargument name="NOT_MUNICIPIO" required="yes">
        <cfargument name="NOT_UF" required="yes">
        <cfargument name="NOT_PAIS" required="yes">
        <cfargument name="NOT_CNPJ_CPF" required="yes">
        <cfargument name="MERCADORIAS" required="no" default="">
        <cfargument name="NUM_ESPECIE" required="yes">
        <cfargument name="QUANTIDADE_TOTAL" required="yes">
        <cfargument name="PESO_BRUTO" required="yes">
        <cfargument name="PESO_LIQUIDO" required="yes">
        <cfargument name="UNIDADE_ID" required="yes">
        <cfargument name="M3" required="yes">
        <cfargument name="VALOR_TOTAL" required="yes">
        <cfargument name="VALOR_TOTAL_COD_MOEDA" required="yes">
        <cfargument name="VALOR_TOTAL_INCOTERM_ID" required="yes">
        
        <cfargument name="TOTAL_CUSTO_ORIGEM" required="yes">
        <cfargument name="TOTAL_CUSTO_ORIGEM_COD_MOEDA" required="yes">
        <cfargument name="TOTAL_CUSTO_DESTINO" required="yes">
        <cfargument name="TOTAL_CUSTO_DESTINO_COD_MOEDA" required="yes">
        <cfargument name="VALOR_FRT_EXTERNO" required="yes">
        <cfargument name="VALOR_FRT_EXTERNO_COD_MOEDA" required="yes">
        <cfargument name="VALOR_REEMBOLSO" required="yes">
        <cfargument name="VALOR_REEMBOLSO_COD_MOEDA" required="yes">
        <cfargument name="VALOR_MERCADORIAS" required="yes">
        <cfargument name="VALOR_MERCADORIAS_COD_MOEDA" required="yes">
        <cfargument name="VALOR_MERCADORIAS_INCOTERM" required="yes">
        <cfargument name="ALFANDEGA_ORIGEM_ID" required="yes">
        <cfargument name="ALFANDEGA_DESTINO_ID" required="yes">
        <cfargument name="PAGO_POR" required="yes">
        <cfargument name="DECLARACAO_OBSERVACAO" required="yes">
        <cfargument name="OBS_PAGO_POR" required="no">
        <cfargument name="ADICIONAIS_MERCADORIA" required="yes">
        <cfargument name="pais_id_origem" required="yes">
    
        <cfargument name="SEGURO_PAGO_EMPRESA" required="no" default="0" >
        <cfargument name="QTDE_VEICULOS" required="no" default="1" >
        <cfargument name="EMISSAO_DATA_IMPRESSAO" required="no" default="" >
        <cfargument name="TAXA_MERCADORIA_SEGURO" required="no" default="0" >
    
        <cfargument name='COD_PAGADOR_ORIGEM' required='yes'>
        <cfargument name='PAG_ORIGEM_NOME' required='yes'>
        <cfargument name='PAG_ORIGEM_ENDERECO' required='yes'>
        <cfargument name='PAG_ORIGEM_MUNICIPIO' required='yes'>
        <cfargument name='PAG_ORIGEM_UF' required='yes'>
        <cfargument name='PAG_ORIGEM_PAIS' required='yes'>
        <cfargument name='PAG_ORIGEM_CNPJ_CPF' required='yes'>
        <cfargument name='COD_PAGADOR_DESTINO' required='yes'>
        <cfargument name='PAG_DESTINO_NOME' required='yes'>
        <cfargument name='PAG_DESTINO_ENDERECO' required='yes'>
        <cfargument name='PAG_DESTINO_MUNICIPIO' required='yes'>
        <cfargument name='PAG_DESTINO_UF' required='yes'>
        <cfargument name='PAG_DESTINO_PAIS' required='yes'>
        <cfargument name='PAG_DESTINO_CNPJ_CPF' required='yes'>    
        <cfargument name='PRE_CONHECIMENTO' required='yes' default="0"> 
        <cfargument name='COTACAO' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID_GERENCIAL' required='no' default="">
        <cfargument name='PRAZO_ENTREGA' required='yes'>
        <cfargument name="REGERAR_IMPRESSAO" required="no" default="0">
        <cfargument name='COD_NEGOCIADOR' required='yes'>  
        <cfargument name='NF_FATURA' required='yes'>
        <cfargument name='OPERACAO_ID_CRT' required='no' default="">
        <cfargument name='CRT_COD_PAIS' required='no' default="">
        <cfargument name='CRT_NUM_PERMISSO' required='no' default="">
        <cfargument name='CRT_NUMERO' required='no' default="">
        <cfargument name='CRT_SERIE' required='no' default="">
        <cfargument name='PEDIDO_SHIPMENT' required='no' default="">
	<cfargument name='LIMITE_PROG_CARGA' required="no" default="" >
        <cfargument name='LIMITE_PESO' required="no" default="" >
        <cfargument name='LIMITE_EMBARQUES' required="no" default="" >
        <cfargument name='NUM_LOTE_CLIENTE' required="no" default="" >
        <cfargument name='LIMITE_EMBARQUES_2' required="no" default="" > 
		<cfargument name="rem_cod_endereco" required="yes">
		<cfargument name="dest_cod_endereco" required="yes">
		<cfargument name="cons_cod_endereco" required="yes">
		<cfargument name="not_cod_endereco" required="yes">
		<cfargument name='pag_origem_cod_endereco' required='no' default="">
		<cfargument name='pag_destino_cod_endereco' required='no' default="">
		<cfargument name='neg_cod_endereco' required='yes'>	
        <cftry>
            <cfscript>
                v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
                v_mercadorias = "";
            </cfscript>
            <cfloop from="1" to="#ArrayLen(v_descricao)#" index="v_index">
                <cfset v_mercadorias = v_mercadorias&v_descricao[v_index]&chr(10)>			
            </cfloop>
            <cfset v_mercadorias = v_mercadorias&arguments.adicionais_mercadoria>				
            <cftransaction action="begin">
                <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_alt_conhecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#UCase(arguments.CRT_COD_PAIS)#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CRT_NUM_PERMISSO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CRT_NUMERO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.COD_PESSOA_FILIAL#" null="#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.COD_ORGANOGRAMA#" null="#iif(len(trim(arguments.COD_ORGANOGRAMA)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.EMISSAO_LOCAL#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.EMISSAO_MUNICIPIO_ID#" null="#iif(len(trim(arguments.EMISSAO_MUNICIPIO_ID)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.EMISSAO_DATA#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.RESP_LOCAL#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.RESP_MUNICIPIO_ID#" null="#iif(len(trim(arguments.RESP_MUNICIPIO_ID)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.RESP_DATA#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.ENTREGA_LOCAL#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ENTREGA_MUNICIPIO_ID#" null="#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.ENTREGA_DATA#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.TRANSP_SUCESSIVOS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.COD_REMETENTE#" null="#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_NOME#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_ENDERECO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_MUNICIPIO_ID#" null="#iif(len(trim(arguments.rem_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_MUNICIPIO#">
                    
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_UF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_PAIS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_CNPJ_CPF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.COD_DESTINATARIO#"  null="#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_NOME#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_ENDERECO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_MUNICIPIO_ID#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_MUNICIPIO#">
    
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_UF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_PAIS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_CNPJ_CPF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.COD_CONSIGNATARIO#" null="#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_NOME#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_ENDERECO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_MUNICIPIO_ID#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_MUNICIPIO#">
    
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_UF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_PAIS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_CNPJ_CPF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.COD_NOTIFICAR#" null="#iif(len(trim(arguments.COD_NOTIFICAR)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_NOME#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_ENDERECO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_MUNICIPIO_ID#" null="#iif(len(trim(arguments.NOT_MUNICIPIO_ID)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_MUNICIPIO#">
    
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_UF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_PAIS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_CNPJ_CPF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#v_MERCADORIAS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.NUM_ESPECIE#"  null="#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.quantidade_total#" null="#iif(len(trim(arguments.quantidade_total)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_bruto#" null="#iif(len(trim(arguments.peso_bruto)), de('no'), de('yes'))#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_liquido#" null="#iif(len(trim(arguments.peso_liquido)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.unidade_id#">
                    <cfprocparam  							type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.m3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
                    <cfprocparam  					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total#" null="#iif(len(trim(arguments.valor_total)), de('no'), de('yes'))#">
                    <cfprocparam 		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_cod_moeda#" null="#iif(len(trim(arguments.valor_total_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam 		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_incoterm_id#" null="#iif(len(trim(arguments.valor_total_incoterm_id)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_origem#" null="#iif(len(trim(arguments.total_custo_origem)), de('no'), de('yes'))#">
                    <cfprocparam  type="in"  cfsqltype="cf_sql_integer" value="#arguments.total_custo_origem_cod_moeda#" null="#iif(len(trim(arguments.total_custo_origem_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_destino#" null="#iif(len(trim(arguments.total_custo_destino)), de('no'), de('yes'))#">
                    <cfprocparam  type="in"  cfsqltype="cf_sql_integer" value="#arguments.total_custo_destino_cod_moeda#" null="#iif(len(trim(arguments.total_custo_destino_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_frt_externo#" null="#iif(len(trim(arguments.valor_frt_externo)), de('no'), de('yes'))#">
                    <cfprocparam 	type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_frt_externo_cod_moeda#" null="#iif(len(trim(arguments.valor_frt_externo_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso#"  null="#iif(len(trim(arguments.valor_reembolso)), de('no'), de('yes'))#">
                    <cfprocparam  	type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_reembolso_cod_moeda#" null="#iif(len(trim(arguments.valor_reembolso_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias#" null="#iif(len(trim(arguments.valor_mercadorias)), de('no'), de('yes'))#">
                
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.VALOR_MERCADORIAS_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_COD_MOEDA)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.VALOR_MERCADORIAS_INCOTERM#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_INCOTERM)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ALFANDEGA_ORIGEM_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ALFANDEGA_DESTINO_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_DESTINO_ID)), de('no'), de('yes'))#">
                    <cfprocparam  				type="in"  cfsqltype="cf_sql_integer" value="#arguments.pais_id_origem#"  null="#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#">
    
                    <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.PAGO_POR#"  null="#iif(len(trim(arguments.PAGO_POR)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DECLARACAO_OBSERVACAO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.OBS_PAGO_POR#">
                    <cfprocparam 				type="in"  cfsqltype="cf_sql_integer" value="#arguments.qtde_veiculos#" null="#iif(len(trim(arguments.qtde_veiculos)), de('no'), de('yes'))#">
                    <cfprocparam 			type="in"  cfsqltype="cf_sql_integer" value="#arguments.seguro_pago_empresa#" null="#iif(len(trim(arguments.seguro_pago_empresa)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.EMISSAO_DATA_IMPRESSAO#">
                    <cfprocparam 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.TAXA_MERCADORIA_SEGURO#" null="#iif(len(trim(arguments.TAXA_MERCADORIA_SEGURO)), de('no'), de('yes'))#">
    
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PAGADOR_ORIGEM#'  null='#iif(len(trim(arguments.COD_PAGADOR_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_PAIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_ORIGEM_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PAGADOR_DESTINO#'  null='#iif(len(trim(arguments.COD_PAGADOR_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_PAIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAG_DESTINO_CNPJ_CPF#' >
                    <cfprocparam 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.PRE_CONHECIMENTO#" null="#iif(len(trim(arguments.PRE_CONHECIMENTO)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COTACAO#' null="#iif(len(trim(arguments.COTACAO)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID_GERENCIAL#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_GERENCIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.PRAZO_ENTREGA#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NF_FATURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.OPERACAO_ID_CRT#'  null='#iif(len(trim(arguments.OPERACAO_ID_CRT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CRT_SERIE#'  null='#iif(len(trim(arguments.CRT_SERIE)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="CF_SQL_VARCHAR"  value="#arguments.pedido_shipment#" >
		    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_PROG_CARGA#'  null='#iif(len(trim(arguments.LIMITE_PROG_CARGA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_PESO#'  null='#iif(len(trim(arguments.LIMITE_PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_EMBARQUES#'  null='#iif(len(trim(arguments.LIMITE_EMBARQUES)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NUM_LOTE_CLIENTE#" >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_EMBARQUES_2#'  null='#iif(len(trim(arguments.LIMITE_EMBARQUES_2)), de('no'), de('yes'))#'><br>
					<cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.rem_cod_endereco#">
					<cfprocparam  		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.dest_cod_endereco#">
					<cfprocparam  		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cons_cod_endereco#">
					<cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.not_cod_endereco#">
					<cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.neg_cod_endereco#">
					<cfprocparam 		type='in'  cfsqltype='cf_sql_numeric' scale='5' value='#arguments.pag_origem_cod_endereco#' null='#iif(len(trim(arguments.pag_origem_cod_endereco)), de('no'), de('yes'))#'>
					<cfprocparam 		type='in'  cfsqltype='cf_sql_numeric' scale='5' value='#arguments.pag_destino_cod_endereco#' null='#iif(len(trim(arguments.pag_destino_cod_endereco)), de('no'), de('yes'))#'> 
                </cfstoredproc>
                
                <cfset retorno.conhecimento_id = arguments.conhecimento_id>
                
                <!--- Alteraes das mercadorias --->
                <cfscript>
					this.upd_intc_conhecimento_mercadorias(argumentCollection = arguments);
				</cfscript>                
                			
                <!--- Alteraes dos custos --->
                <cfscript>
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "CUST_DESCRICAO_CUSTOS");
                    v_valor_origem = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_CUSTOS");
                    v_valor_origem_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_COD_MOEDA_CUSTOS");
                    v_valor_destino = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_CUSTOS");
                    v_valor_destino_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_COD_MOEDA_CUSTOS");
                    v_item_id = this.ListaToArray (lista = arguments, variavel = "CUST_ITEM_ID_CUSTOS");
                    v_cust_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CUSTOS, lista2 = ArrayToList(v_item_id));
                </cfscript>
                    <!--- Excluir os itens --->
                <cfloop list="#v_cust_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        this.del_custo_crt (conhecimento_id = arguments.conhecimento_id,
                                            item_id   = l_item_id);
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                    if(not len(trim(v_item_id[count]))) {
                        //caso o item_id seja nulo insere
                        this.ins_custo_crt(	conhecimento_id = arguments.conhecimento_id,
                                            descricao = v_descricao[count],
                                            valor_origem = v_valor_origem[count],
                                            valor_origem_cod_moeda = v_valor_origem_cod_moeda[count],
                                            valor_destino = v_valor_destino[count],
                                            valor_destino_cod_moeda = v_valor_destino_cod_moeda[count]);
                    } else {
                        //senao altera
                        this.upd_custo_crt(	conhecimento_id = arguments.conhecimento_id,
                                            descricao = v_descricao[count],
                                            valor_origem = v_valor_origem[count],
                                            valor_origem_cod_moeda = v_valor_origem_cod_moeda[count],
                                            valor_destino = v_valor_destino[count],
                                            valor_destino_cod_moeda = v_valor_destino_cod_moeda[count],
                                            item_id = v_item_id[count]);
                    }
                    </cfscript>
                </cfloop>				
                <!--- Alteraes dos Anexos --->
                <cfscript>
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "ANEXO_DESCRICAO_ANEXOS");
                    v_item_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
                    v_anexos_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_item_id));
                </cfscript>
                    <!--- Excluir os itens --->
                <cfloop list="#v_anexos_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        this.del_anexo_crt (conhecimento_id = arguments.conhecimento_id,
                                            anexo_id   = l_item_id);
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                    if(not len(trim(v_item_id[count]))) {
                        //caso o item_id seja nulo insere
                        this.ins_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
                                            descricao = v_descricao[count]);
                    } else {
                        //senao altera
                        this.upd_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
                                            descricao = v_descricao[count],
                                            anexo_id = v_item_id[count]);
                    }
                    </cfscript>
                </cfloop>			
                
                <!--- Alteraes dos Complementados --->
                <cfscript>
                    retorno.conhecimento_id = arguments.conhecimento_id;
                    v_tipo_id_complemento = this.ListaToArray (lista = arguments, variavel = "TIPO_COMPLEMENTO_COMPLEMENTO");
                    v_conhecimento_id_complemento = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_COMPLEMENTO_ID_COMPLEMENTO");
                    v_numero_compl = this.ListaToArray (lista = arguments, variavel = "CRT_COMPLEMENTO_COMPLEMENTO");
                    v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_COMPLEMENTO, lista2 = ArrayToList(v_conhecimento_id_complemento));
                </cfscript>
                    <!--- Excluir os itens --->
                <cfloop list="#v_excluir#" delimiters="," index="l_id">
                    <cfscript>
                        ret = this.del_conhecimento_complemento (conhecimento_id = retorno.conhecimento_id,
                                                            conhecimento_id_complemento   = l_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_conhecimento_id_complemento)#" index="count">
                    <cfscript>
                        ret = this.ins_conhecimento_complemento(	conhecimento_id = retorno.conhecimento_id,
                                                                    conhecimento_id_complemento = v_conhecimento_id_complemento[count],
                                                            tipo_id = v_tipo_id_complemento[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>	
                
                <!--- Insercao de FRONTEIRAS --->
                <cfscript>
                    v_controle_id  = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_FRONTEIRAS");
                    v_fronteira_id = this.ListaToArray (lista = arguments, variavel = "FRONTEIRA_ID_FRONTEIRAS");
                    v_fronteira_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FRONTEIRAS, lista2 = ArrayToList(v_controle_id));
                </cfscript>
                <!--- Excluir os itens --->
                <cfloop list="#v_fronteira_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        this.del_crt_fronteira (controle_id = l_item_id);						
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                    if(not len(trim(v_controle_id[count]))) {
                        //caso o item_id seja nulo insere
                        this.ins_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
                                                fronteira_id = v_fronteira_id[count]);
                    } else {
                        //senao altera
                        this.upd_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
                                                fronteira_id    = v_fronteira_id[count],
                                                controle_id     = v_controle_id[count]);
                    }
                    </cfscript>
                </cfloop>	

				<!--- Insercao de ADUANAS --->
                <cfscript>
                    v_conhecimento_aduana_id  = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_ADUANA_ID_ADUANAS");
                    v_aduana_id = this.ListaToArray (lista = arguments, variavel = "ADUANA_ID_ADUANAS");
					v_aduana_ordem = this.ListaToArray (lista = arguments, variavel = "ADUANA_ORDEM_ADUANAS");
					v_aduana_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ADUANAS, lista2 = ArrayToList(v_conhecimento_aduana_id));
                </cfscript>
                <!--- Excluir os itens --->
                <cfloop list="#v_aduana_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        this.del_crt_aduana (conhecimento_aduana_id = l_item_id);						
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_conhecimento_aduana_id)#" index="count">
                    <cfscript>
                    if(not len(trim(v_conhecimento_aduana_id[count]))) {
                        //caso o item_id seja nulo insere
                        this.ins_crt_aduana(conhecimento_id = retorno.conhecimento_id,
                                            aduana_id	 = v_aduana_id[count],
											aduana_ordem = v_aduana_ordem[count]);
                    } else {
                        //senao altera
                        this.alt_crt_aduana(conhecimento_aduana_id = v_conhecimento_aduana_id[count],
							                conhecimento_id 	   = arguments.conhecimento_id,
                                            aduana_id    	       = v_aduana_id[count],
                                            aduana_ordem     	   = v_aduana_ordem[count]);
                    }
                    </cfscript>
                </cfloop>	
                
                <!---Diviso--->
				<cfscript>
                    arguments.conhecimento_id = retorno.conhecimento_id; 
                    ret = this.ins_divisao(argumentCollection  = arguments );
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>                
                
                <cfloop from="1" to="#ArrayLen(v_conhecimento_id_complemento)#" index="count">
                    <cfscript>
                        ret = this.ins_conhecimento_complemento(	conhecimento_id = retorno.conhecimento_id,
                                                                    conhecimento_id_complemento = v_conhecimento_id_complemento[count],
                                                            tipo_id = v_tipo_id_complemento[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>	
               
                <!--- Gera conhecimento FORM --->
                <cfscript>
					if(arguments.regerar_impressao eq 1) {
                		set_impressao = this.ins_intc_conhecimento_form(conhecimento_id = arguments.conhecimento_id);
					}
				</cfscript>
               
			    <cfif IsDefined("set_impressao") and set_impressao.erro>
					<cfthrow object="#set_impressao.mensagem#">
                </cfif>
                
                <!--- Calcula Seguro --->
				<cfscript>
                    retorno = this.calcula_seguro_crt(conhecimento_id = arguments.conhecimento_id);
                </cfscript>                   
                <cfif IsDefined("retorno") and retorno.erro>
                    <cfthrow object="#retorno.mensagem#">
                </cfif>
				
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfscript>
					conn_cons_tf = CreateComponent("modulos.transporte_internacional._componentes.consulta.cfc_tabela_frete");
					qrGrupoNegociadorPessoa = conn_cons_tf.get_grupo_negociador_pessoa(cod_pessoa = arguments.COD_NEGOCIADOR);
				</cfscript>                
                
                <cfif qrGrupoNegociadorPessoa.EMITE_TABELA_FRETE eq 1 and ArrayLen(v_tipo_id_complemento) eq 0>
                	<cfscript>
						qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id_intc(ORIGEM_MUNICIPIO_ID  		= arguments.RESP_MUNICIPIO_ID,
																						 DESTINO_MUNICIPIO_ID 		= arguments.ENTREGA_MUNICIPIO_ID,
																						 COD_NEGOCIADOR       		= arguments.COD_NEGOCIADOR,
																						 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																						 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID,
																				 		 TIPO_SERVICO_ID			= arguments.TIPO_SERVICO_COMERCIAL);
					</cfscript>
					<cfif qrTabelaFreteRotaId.erro>
						<cfthrow object="#qrTabelaFreteRotaId.mensagem#">
					</cfif>
					
                    <cfscript>
						// Constantes
						arguments.CONSTANTE_PESO_BRUTO            = arguments.PESO_BRUTO;
						arguments.CONSTANTE_PESO_COBRADO          = arguments.PESO_BRUTO;
						arguments.CONSTANTE_CUBAGEM	            = arguments.M3;
						arguments.CONSTANTE_VALOR_MERCADORIA      = arguments.VALOR_TOTAL;
						arguments.CONSTANTE_MUNICIPIO_ID_ORIGEM   = arguments.RESP_MUNICIPIO_ID;
						arguments.CONSTANTE_MUNICIPIO_ID_DESTINO  = arguments.ENTREGA_MUNICIPIO_ID;
						arguments.CONSTANTE_FRETE_PROPRIO		   = 1;
						arguments.CONSTANTE_INTERNACIONAL		   = 1;
						arguments.CONSTANTE_CRT_ID	               = arguments.CONHECIMENTO_ID;
						arguments.CONSTANTE_NRO_VOLUMES           = arguments.QUANTIDADE_TOTAL;
						// ----------
					</cfscript>
                    
                    <cfscript>
						qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID
																			 , tabela_frete_id      = qrTabelaFreteRotaId.TABELA_FRETE_ID);
						qrConstante 	  = conn_cons_tf.get_constante();
						qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID
																				 , tabela_frete_id      = qrTabelaFreteRotaId.TABELA_FRETE_ID);
						
						conn_manip_tf = CreateComponent("modulos.transporte_internacional._componentes.manipulacao.cfc_tabela_frete");
					</cfscript>
					
					<cfloop query="qrConstante">
						<cfscript>
							ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
														  		   VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
						</cfscript>
						<cfif ret_cons.erro>
							<cfthrow object="#ret_cons.mensagem#">
						</cfif>
					</cfloop>
					
					<cfscript>
						ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
														 		  VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_cons_tf.erro>
						<cfthrow object="#ret_cons_tf.mensagem#">
					</cfif>
					
					<cfscript>
						ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
														  		   VALOR		 = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID);
					</cfscript>
					<cfif ret_cons_tfr.erro>
						<cfthrow object="#ret_cons_tfr.mensagem#">
					</cfif>
					
                    <cfscript>
                    ret_cons_tfv = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_VIGENCIA_ID',
                                                      		   VALOR		 = qrTabelaFreteRota.tabela_frete_vigencia_id);
                    </cfscript>
					<cfif ret_cons_tfv.erro>
						<cfthrow object="#ret_cons_tfv.mensagem#">
					</cfif>
					
					<cfloop query="qrVariavel">
						<cfscript>
							ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
																	 		  TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID,
																	 		  TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 		  VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					</cfloop>
                    
                    <cfscript>
						ret_calc = this.calcula_crt_tabela_frete(CONHECIMENTO_ID			= retorno.CONHECIMENTO_ID,
																 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID);
					</cfscript>
					<cfif ret_calc.erro>
						<cfthrow object="#ret_calc.mensagem#">
					</cfif>
                </cfif>
                
                <cfscript>
					ret_valid_tf = this.valida_crt_tabela_frete(CONHECIMENTO_ID = retorno.CONHECIMENTO_ID);
				</cfscript>
				<cfif ret_valid_tf.erro>
					<cfthrow object="#ret_valid_tf.mensagem#">
				</cfif>
                <!--- Itinerrio --->
				<cfscript>
                    arguments.conhecimento_id = retorno.conhecimento_id; 
                    ret = this.ins_itinerarios(argumentCollection  = arguments );
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>       
                
                <!--- Vincula CTe e CRT  --->
				<cfscript>
                    arguments.conhecimento_id = retorno.conhecimento_id; 
                    ret = this.ins_cte_crt(argumentCollection  = arguments );
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>                              
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("C.R.T. alterado com sucesso!")>
            </cftransaction>
            <cfcatch>
                <cftransaction action="rollback"/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera as mercadorias do conhecimento
	-- Wagner Senger 25/09/2012
	--->
	<cffunction name="upd_intc_conhecimento_mercadorias" displayname="Altera as mercadorias do conhecimento" access="remote" returntype="void" output="true">
    	<!--- Alteraes das Mercadorias --->
		<cfscript>
            v_produto_id = this.ListaToArray (lista = arguments, variavel = "MERC_PRODUTO_ID_MERCADORIAS");
            v_num_especie = this.ListaToArray (lista = arguments, variavel = "MERC_NUM_ESPECIE_MERCADORIAS");
            v_quantidade = this.ListaToArray (lista = arguments, variavel = "MERC_QUANTIDADE_MERCADORIAS");
            v_peso_bruto = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_BRUTO_MERCADORIAS");
            v_peso_liquido = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_LIQUIDO_MERCADORIAS");
            v_m3 = this.ListaToArray (lista = arguments, variavel = "MERC_VOLUME_MERCADORIAS");
            v_unidade_id = this.ListaToArray (lista = arguments, variavel = "MERC_UNIDADE_ID_MERCADORIAS");
            v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
            v_item_id = this.ListaToArray (lista = arguments, variavel = "MERC_ITEM_ID_MERCADORIAS");
            v_merc_excluir = this.ListDiff(lista1 = arguments.lista_deleted_MERCADORIAS, lista2 = ArrayToList(v_item_id));
        </cfscript>
            <!--- Excluir os itens --->
        <cfloop list="#v_merc_excluir#" delimiters="," index="l_item_id">
            <cfscript>
                this.del_item_crt (	conhecimento_id = arguments.conhecimento_id,
                                    item_id   = l_item_id);
            </cfscript>
        </cfloop>
        <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
            <cfscript>
            if(not len(trim(v_item_id[count]))) {
                //caso o item_id seja nulo insere
                this.ins_item_crt(	conhecimento_id = arguments.conhecimento_id,
                                    produto_id = v_produto_id[count],
                                    num_especie = v_num_especie[count],
                                    quantidade = v_quantidade[count],
                                    peso_bruto = v_peso_bruto[count],
                                    peso_liquido = v_peso_liquido[count],
                                    m3 = v_m3[count],
                                    descricao = v_descricao[count]);
            } else {
                //senao altera
                this.upd_item_crt(	conhecimento_id = arguments.conhecimento_id,
                                    produto_id = v_produto_id[count],
                                    num_especie = v_num_especie[count],
                                    quantidade = v_quantidade[count],
                                    peso_bruto = v_peso_bruto[count],
                                    peso_liquido = v_peso_liquido[count],
                                    m3 = v_m3[count],
                                    descricao = v_descricao[count],
                                    item_id = v_item_id[count]);
            }
            </cfscript>
        </cfloop>
    
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere uma mercadoria ao CRT
    -- 06/12/2005 - criado
    --->
    <cffunction name="ins_item_crt" displayname="Insere uma mercadoria ao CRT" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="PRODUTO_ID" required="yes">
        <cfargument name="NUM_ESPECIE" required="yes">
        <cfargument name="QUANTIDADE" required="yes">
        <cfargument name="PESO_BRUTO" required="yes">
        <cfargument name="PESO_LIQUIDO" required="yes">
        <cfargument name="M3" required="yes">
        <cfargument name="DESCRICAO" required="yes">
        <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_ins_crt_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  null="yes">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.PRODUTO_ID#" null="#iif(len(trim(arguments.produto_id)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.NUM_ESPECIE#" null="#iif(len(trim(arguments.num_especie)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.QUANTIDADE#" null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.PESO_BRUTO#" null="#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.PESO_LIQUIDO#" null="#iif(len(trim(arguments.PESO_LIQUIDO)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.M3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="Kg">
            <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DESCRICAO#">
        </cfstoredproc>
        <cfreturn StructNew() />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera uma mercadoria do CRT
    -- 06/12/2005 - criado
    --->
    <cffunction name="upd_item_crt" displayname="Altera uma mercadoria do CRT" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="ITEM_ID" required="yes">
        <cfargument name="PRODUTO_ID" required="yes">
        <cfargument name="NUM_ESPECIE" required="yes">
        <cfargument name="QUANTIDADE" required="yes">
        <cfargument name="PESO_BRUTO" required="yes">
        <cfargument name="PESO_LIQUIDO" required="yes">
        <cfargument name="M3" required="yes">
        <cfargument name="DESCRICAO" required="yes">
        <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_alt_crt_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ITEM_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.PRODUTO_ID#" null="#iif(len(trim(arguments.produto_id)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.NUM_ESPECIE#" null="#iif(len(trim(arguments.num_especie)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.QUANTIDADE#" null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.PESO_BRUTO#" null="#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.PESO_LIQUIDO#" null="#iif(len(trim(arguments.PESO_LIQUIDO)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.M3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="Kg">
            <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DESCRICAO#">
        </cfstoredproc>
        <cfreturn StructNew() />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui uma mercadoria do CRT
    -- 06/12/2005 - criado
    --->
    <cffunction name="del_item_crt" displayname="Exclui uma mercadoria do CRT" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="ITEM_ID" required="yes">
        <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_del_crt_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ITEM_ID#">
        </cfstoredproc>
        <cfreturn StructNew() />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Insere um custo ao CRT
    -- 06/12/2005 - criado
    --->
    <cffunction name="ins_custo_crt" displayname="Insere um custo ao CRT" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="DESCRICAO" required="yes">
        <cfargument name="VALOR_ORIGEM" required="yes">
        <cfargument name="VALOR_ORIGEM_COD_MOEDA" required="yes">
        <cfargument name="VALOR_DESTINO" required="yes">
        <cfargument name="VALOR_DESTINO_COD_MOEDA" required="yes">
        <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_ins_crt_custo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  null="yes">
            <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DESCRICAO#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.VALOR_ORIGEM#" null="#iif(len(trim(arguments.VALOR_ORIGEM)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.VALOR_ORIGEM_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_ORIGEM_COD_MOEDA)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.VALOR_DESTINO#" null="#iif(len(trim(arguments.VALOR_DESTINO)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.VALOR_DESTINO_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_DESTINO_COD_MOEDA)), de('no'), de('yes'))#">
        </cfstoredproc>
        <cfreturn StructNew() />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um custo do CRT
    -- 06/12/2005 - criado
    --->
    <cffunction name="upd_custo_crt" displayname="Altera um custo do CRT" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="ITEM_ID" required="yes">
        <cfargument name="DESCRICAO" required="yes">
        <cfargument name="VALOR_ORIGEM" required="yes">
        <cfargument name="VALOR_ORIGEM_COD_MOEDA" required="yes">
        <cfargument name="VALOR_DESTINO" required="yes">
        <cfargument name="VALOR_DESTINO_COD_MOEDA" required="yes">
        <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_alt_crt_custo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ITEM_ID#" null="#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DESCRICAO#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.VALOR_ORIGEM#" null="#iif(len(trim(arguments.VALOR_ORIGEM)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.VALOR_ORIGEM_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_ORIGEM_COD_MOEDA)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_float"  value="#arguments.VALOR_DESTINO#" null="#iif(len(trim(arguments.VALOR_DESTINO)), de('no'), de('yes'))#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.VALOR_DESTINO_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_DESTINO_COD_MOEDA)), de('no'), de('yes'))#">
        </cfstoredproc>
        <cfreturn StructNew() />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um custo do CRT
    -- 06/12/2005 - criado
    --->
    <cffunction name="del_custo_crt" displayname="Exclui um custo do CRT" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="ITEM_ID" required="yes">
        <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_del_crt_custo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ITEM_ID#">
        </cfstoredproc>
        <cfreturn StructNew() />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Insere um anexo ao CRT
    -- 06/12/2005 - criado
    --->
    <cffunction name="ins_anexo_crt" displayname="Insere um anexo ao CRT" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="DESCRICAO" required="yes">
        <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_ins_crt_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  null="yes">
            <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DESCRICAO#">
        </cfstoredproc>
        <cfreturn StructNew() />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um anexo do CRT
    -- 06/12/2005 - criado
    --->
    <cffunction name="upd_anexo_crt" displayname="Altera um anexo do CRT" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="ANEXO_ID" required="yes">
        <cfargument name="DESCRICAO" required="yes">
        <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_alt_crt_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ANEXO_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DESCRICAO#">
        </cfstoredproc>
        <cfreturn StructNew() />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Exclui um anexo do CRT
    -- 06/12/2005 - criado
    --->
    <cffunction name="del_anexo_crt" displayname="Exclui um anexo do CRT" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="ANEXO_ID" required="yes">
        <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_del_crt_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
            <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ANEXO_ID#">
        </cfstoredproc>
        <cfreturn StructNew() />
    </cffunction>    
    
    <!--- 
	-- PROPSITO
	-- Insere novo INCOTERM
	-- FABIOG 30/09/2011 15:11:35 - CRIADO
	--->
	<cffunction name='ins_incoterm' displayname='Insere novo INCOTERM' access='remote' returntype='Struct' output='true'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='SIGNIFICADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_incoterm' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SIGNIFICADO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Incoterm inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Altera dados do Incoterm
	-- FABIOG 30/09/2011 15:13:11 - CRIADO
	--->
	<cffunction name='upd_incoterm' displayname='Altera dados do Incoterm' access='remote' returntype='Struct' output='true'>
		<cfargument name='INCOTERM_ID' required='yes'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='SIGNIFICADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_upd_incoterm' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INCOTERM_ID#'  null='#iif(len(trim(arguments.INCOTERM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SIGNIFICADO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Incoterm alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui incoterm
	-- FABIOG 30/09/2011 15:14:09 - CRIADO
	--->
	<cffunction name='del_incoterm' displayname='Exclui incoterm' access='remote' returntype='Struct' output='true'>
		<cfargument name='INCOTERM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_incoterm' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INCOTERM_ID#'  null='#iif(len(trim(arguments.INCOTERM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Incoterm excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Insere nova Rota
	-- FABIOG 30/09/2011 15:31:27 - CRIADO
	--->
	<cffunction name='ins_intc_manifesto_rota' displayname='Insere nova Rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='NOME_ROTA' required='yes'>
		<cfargument name='ROTA' required='yes'>
		<cfargument name='PRAZO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_intc_manifesto_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME_ROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PRAZO#'  null='#iif(len(trim(arguments.PRAZO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera dados da rota
	-- FABIOG 30/09/2011 15:32:55 - CRIADO
	--->
	<cffunction name='upd_intc_manifesto_rota' displayname='Altera dados da rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='NOME_ROTA' required='yes'>
		<cfargument name='ROTA' required='yes'>
		<cfargument name='PRAZO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_upd_intc_manifesto_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME_ROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PRAZO#'  null='#iif(len(trim(arguments.PRAZO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui rota
	-- FABIOG 30/09/2011 15:34:40 - CRIADO
	--->
	<cffunction name='del_intc_manifesto_rota' displayname='Exclui rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_intc_manifesto_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula fronteira ao CRT
	-- guto 03/07/2007 15:56:08 - CRIADO
	--->
	<cffunction name='ins_crt_fronteira' displayname='Vincula fronteira ao CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='FRONTEIRA_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_crt_fronteira' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera vinculo fronteira ao CRT
	-- guto 03/07/2007 15:59:04 - CRIADO
	--->
	<cffunction name='upd_crt_fronteira' displayname='Altera vinculo fronteira ao CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='FRONTEIRA_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_crt_fronteira' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui vinculo fronteira ao CRT
	-- guto 03/07/2007 15:59:32 - CRIADO
	--->
	<cffunction name='del_crt_fronteira' displayname='Exclui vinculo fronteira ao CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_crt_fronteira' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere os itens do CRT a serem impressos
	-- ANDERSONC 01/07/2009 10:52:46 - CRIADO
	--->
	<cffunction name='ins_intc_conhecimento_form' displayname='Insere os itens do CRT a serem impressos' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_intc_conhecimento_form' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Impresso inserida com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza os itens do CRT a serem impressos
	-- ANDERSONC 17/06/2009 15:05:22 - CRIADO
	--->
	<cffunction name='upd_intc_conhecimento_form' displayname='Atualiza os itens do CRT a serem impressos' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='CAMPO01' required='yes'>
		<cfargument name='CAMPO04' required='yes'>
        <cfargument name='CAMPO05' required='yes'>
		<cfargument name='CAMPO06' required='yes'>
		<cfargument name='CAMPO07' required='yes'>
		<cfargument name='CAMPO08' required='yes'>
		<cfargument name='CAMPO09' required='yes'>
		<cfargument name='CAMPO10' required='yes'>
		<cfargument name='CAMPO12' required='yes'>
		<cfargument name='CAMPO13' required='yes'>
		<cfargument name='CAMPO19_0' required='yes'>
		<cfargument name='CAMPO20_1' required='yes'>
		<cfargument name='CAMPO20_2' required='yes'>
		<cfargument name='CAMPO21_1' required='yes'>
		<cfargument name='CAMPO21_2' required='yes'>
		<cfargument name='CAMPO23' required='yes'>
		<cfargument name='CAMPO23_1' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_intc_conhecimento_form' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#REReplace(arguments.CAMPO01, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#REReplace(arguments.CAMPO04, '\r', '', 'all')#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO05#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#REReplace(arguments.CAMPO06, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO07#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO08#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#REReplace(arguments.CAMPO09, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO10#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#REReplace(arguments.CAMPO12, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#REReplace(arguments.CAMPO13, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CAMPO19_0#'  null='#iif(len(trim(arguments.CAMPO19_0)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO20_1#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO20_2#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#REReplace(arguments.CAMPO21_1, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO21_2#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#REReplace(arguments.CAMPO23, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO23_1#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impresso alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>


			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Calcular Seguro de um CRT
	-- RAFAEL 16/03/2010 14:07:00 - CRIADO
	--->
	<cffunction name='calcula_seguro_crt' displayname='Calcular Seguro de um CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_seguro_contratado.prc_calcula_seguro_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Executa o clculo da tabela de frete para o CRT
	-- ANDERSONC 04/10/2010 17:20:45 - CRIADO
	--->
	<cffunction name='calcula_crt_tabela_frete' displayname='Executa o clculo da tabela de frete para o CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='CLASSIFICACAO_NATUREZA_ID' required='yes'>
		<cfargument name='CLASSIFICACAO_COMERCIAL_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_calcula_crt_tabela_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CLASSIFICACAO_NATUREZA_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_NATUREZA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CLASSIFICACAO_COMERCIAL_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_COMERCIAL_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Valida a negociao comercial de um CRT
	-- ANDERSONC 07/10/2010 11:03:23 - CRIADO
	--->
	<cffunction name='valida_crt_tabela_frete' displayname='Valida a negociao comercial de um CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_valida_crt_tabela_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera a data de emissao de impressao
	-- wagner 15/02/2007 15:35:45 - CRIADO
	--->
	<cffunction name='imprimir_crt' displayname='Baixar CRTs entregues' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='EMISSAO_DATA_IMPRESSAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_imprimir_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.EMISSAO_DATA_IMPRESSAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula um conhecimento de complemento
	-- cristofer 24/05/2007 10:14:43 - CRIADO
	--->
	<cffunction name='ins_conhecimento_complemento' displayname='Vincula um conhecimento de complemento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID_COMPLEMENTO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cftry>
				<cfloop list="#arguments.CONHECIMENTO_ID_COMPLEMENTO#" index="crt_id">
                    <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_conhecimento_complemen' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#crt_id#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_COMPLEMENTO)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    </cfstoredproc>
                </cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT vinculado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Insere embarque
    -- guto 23/06/2009 10:09:06 - CRIADO
    --->
    <cffunction name='ins_intc_crt_embarque' displayname='Insere embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='DATA_EMBARQUE' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_intc_crt_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.EMBARQUE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMBARQUE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Embarque inserido com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.embarque_id = ''>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Altera embarque
    -- guto 23/06/2009 10:10:46 - CRIADO
    --->
    <cffunction name='upd_intc_crt_embarque' displayname='Altera embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cfargument name='DATA_EMBARQUE' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_intc_crt_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMBARQUE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Embarque alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Excluir embarque
    -- guto 23/06/2009 10:11:45 - CRIADO
    --->
    <cffunction name='del_intc_crt_embarque' displayname='Excluir embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_intc_crt_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Embarque excludo com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Insere diviso no embarque
    -- guto 23/06/2009 10:21:20 - CRIADO
    --->
    <cffunction name='ins_embarque_divisao' displayname='Insere diviso no embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='COD_MOEDA' required='yes'>
        <cfargument name='PERCENTUAL_CRT' required='yes'>
        <cfargument name='ROTA_ID' required='yes'>
        <cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cfargument name='DATA_DIVISAO' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_embarque_divisao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.DIVISAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PERCENTUAL_CRT#'  null='#iif(len(trim(arguments.PERCENTUAL_CRT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'    value='#arguments.DATA_DIVISAO#'  null='#iif(len(trim(arguments.DATA_DIVISAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Diviso inserida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera diviso no embarque
    -- guto 23/06/2009 10:22:41 - CRIADO
    --->
    <cffunction name='upd_embarque_divisao' displayname='Altera diviso no embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='COD_MOEDA' required='yes'>
        <cfargument name='PERCENTUAL_CRT' required='yes'>
        <cfargument name='ROTA_ID' required='yes'>
        <cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_embarque_divisao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PERCENTUAL_CRT#'  null='#iif(len(trim(arguments.PERCENTUAL_CRT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Diviso alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui diviso no embarque
    -- guto 23/06/2009 10:23:32 - CRIADO
    --->
    <cffunction name='del_embarque_divisao' displayname='Exclui diviso no embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_embarque_divisao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Diviso excluda com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere composio na diviso
    -- guto 23/06/2009 10:24:34 - CRIADO
    --->
    <cffunction name='ins_embarque_divisao_comp' displayname='Insere composio na diviso' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORDEM' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_embarque_divisao_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.CONTROLE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Composio inserida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera composio na diviso
    -- guto 23/06/2009 10:25:58 - CRIADO
    --->
    <cffunction name='upd_embarque_divisao_comp' displayname='Altera composio na diviso' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='ORDEM' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_embarque_divisao_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Composio alterada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui composio na diviso
    -- guto 23/06/2009 10:26:39 - CRIADO
    --->
    <cffunction name='del_embarque_divisao_comp' displayname='Exclui composio na diviso' access='remote' returntype='Struct' output='true'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_embarque_divisao_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Composio excluda com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Cancela um conhecimento internacional
	-- 06/12/2005 - criado
	--->
	<cffunction name="can_intc_conhecimento" displayname="Cancela um conhecimento internacional" access="remote" returntype="Struct" output="true">
		<cfargument name="CONHECIMENTO_ID" required="yes">
		<cfargument name="MOTIVO_CANCELAMENTO" required="no" default="">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="fiscal.pkg_transp_internacional.PRC_CRT_CANCELADO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.MOTIVO_CANCELAMENTO#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("C.R.T. cancelado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Assinatura Digital
	-- RAFAEL 20/11/2012 22:21:08 - CRIADO
	--->
	<cffunction name='ins_assinatura' displayname='Inserir Assinatura Digital' access='remote' returntype='Struct' output='true'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='NOME_ARQUIVO' required='yes'>
        <cfargument name='tipo' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>

				<!--- Busca arquivo --->
               <cffile action="readbinary" file="#expandPath("/")#temp/#arguments.NOME_ARQUIVO#" variable="VARQUIVO">
               <cfscript>
                  v_extensao = ListToArray(arguments.NOME_ARQUIVO, '.');
               </cfscript>               
                
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_pessoa_assinatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ASSINATURA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB'   value='#VARQUIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#v_extensao[ArrayLen(v_extensao)]#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO#'  null='#iif(len(trim(arguments.TIPO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Assinatura Digital inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualizar Assinatura Digital
	-- RAFAEL 20/11/2012 22:23:54 - CRIADO
	--->
	<cffunction name='upd_assinatura' displayname='Atualizar Assinatura Digital' access='remote' returntype='Struct' output='true'>
		<cfargument name='ASSINATURA_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='NOME_ARQUIVO' required='yes'>
        <cfargument name='tipo' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<!--- Busca arquivo --->
               <cffile action="readbinary" file="#expandPath("/")#temp/#arguments.NOME_ARQUIVO#" variable="VARQUIVO">
               <cfscript>
                  v_extensao = ListToArray(arguments.NOME_ARQUIVO, '.');
               </cfscript>
                
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_pessoa_assinatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ASSINATURA_ID#'  null='#iif(len(trim(arguments.ASSINATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB'   value='#VARQUIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#v_extensao[ArrayLen(v_extensao)]#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO#'  null='#iif(len(trim(arguments.TIPO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Assinatura Digital atualizada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Excluir Assinatura Digital
	-- RAFAEL 20/11/2012 22:24:47 - CRIADO
	--->
	<cffunction name='del_assinatura' displayname='Excluir Assinatura Digital' access='remote' returntype='Struct' output='true'>
		<cfargument name='ASSINATURA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_pessoa_assinatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ASSINATURA_ID#'  null='#iif(len(trim(arguments.ASSINATURA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Assinatura Digital excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Insere o arquivo temporariamento no servidor
	-- FABIOG 25/07/2011 17:47:40 - CRIADO
	--->
	<cffunction name='ins_anexo_temp' displayname='Insere o arquivo temporariamento no servidor' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO' required='yes'>
        <cftry>
            
			<!---Envia o Arquivo para o Servidor--->
            <cffile action="upload" destination="#expandPath("/")#temp" file="#arguments.ANEXO#" nameconflict="makeunique" result="VANEXO" filefield="ANEXO">
            
            <cfset retorno.nome_arquivo = VANEXO.serverfile>
            <cfset retorno.erro = false>
        <cfcatch>
        	<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Altera um conhecimento internacional
	-- Rafael Costa 05/06/2009 - alterado
	--->
	<cffunction name="upd_intc_conhecimento_lib_fatura" displayname="Altera um conhecimento internacional" access="remote" returntype="Struct" output="true">
		<cfargument name="CONHECIMENTO_ID" required="yes">
		<cfargument name="RESP_LOCAL" required="yes">
		<cfargument name="RESP_MUNICIPIO_ID" required="yes">
		<cfargument name="RESP_DATA" required="yes">
		<cfargument name="ENTREGA_LOCAL" required="yes">
		<cfargument name="ENTREGA_MUNICIPIO_ID" required="yes">
		<cfargument name="ENTREGA_DATA" required="yes">
		<cfargument name="TRANSP_SUCESSIVOS" required="no" default="N.I.H.I.L">
		<cfargument name="REM_ENDERECO" required="yes">
		<cfargument name="REM_MUNICIPIO" required="yes">
		<cfargument name="REM_UF" required="yes">
		<cfargument name="REM_PAIS" required="yes">
		<cfargument name="DEST_ENDERECO" required="yes">
		<cfargument name="DEST_MUNICIPIO" required="yes">
		<cfargument name="DEST_UF" required="yes">
		<cfargument name="DEST_PAIS" required="yes">
		<cfargument name="CONS_ENDERECO" required="yes">
		<cfargument name="CONS_MUNICIPIO" required="yes">
		<cfargument name="CONS_UF" required="yes">
		<cfargument name="CONS_PAIS" required="yes">
		<cfargument name="NOT_ENDERECO" required="yes">
		<cfargument name="NOT_MUNICIPIO" required="yes">
		<cfargument name="NOT_UF" required="yes">
		<cfargument name="NOT_PAIS" required="yes">
		<cfargument name="MERCADORIAS" required="no" default="">
		<cfargument name="NUM_ESPECIE" required="yes">
		<cfargument name="QUANTIDADE_TOTAL" required="yes">
		<cfargument name="PESO_BRUTO" required="yes">
		<cfargument name="PESO_LIQUIDO" required="yes">
		<cfargument name="UNIDADE_ID" required="yes">
		<cfargument name="M3" required="yes">
		<cfargument name="VALOR_TOTAL" required="yes">
		<cfargument name="VALOR_TOTAL_COD_MOEDA" required="yes">
		<cfargument name="VALOR_TOTAL_INCOTERM_ID" required="yes">
		
		<cfargument name="VALOR_REEMBOLSO" required="yes">
		<cfargument name="VALOR_REEMBOLSO_COD_MOEDA" required="yes">
		<cfargument name="VALOR_MERCADORIAS" required="yes">
		<cfargument name="VALOR_MERCADORIAS_COD_MOEDA" required="yes">
		<cfargument name="VALOR_MERCADORIAS_INCOTERM" required="yes">
		<cfargument name="ALFANDEGA_ORIGEM_ID" required="yes">
		<cfargument name="ALFANDEGA_DESTINO_ID" required="yes">
		<cfargument name="DECLARACAO_OBSERVACAO" required="yes">
		<cfargument name="ADICIONAIS_MERCADORIA" required="yes">
		<cfargument name="pais_id_origem" required="yes">
	
		<cfargument name="SEGURO_PAGO_EMPRESA" required="no" default="0" >
		<cfargument name="QTDE_VEICULOS" required="no" default="1" >
		<cfargument name="EMISSAO_DATA_IMPRESSAO" required="no" default="" >
		<cfargument name="EMISSAO_DATA" required="yes" >
		<cfargument name="TAXA_MERCADORIA_SEGURO" required="no" default="0" >
		
		<cfargument name='ORGANIZACIONAL_ID_GERENCIAL' required='no' default="">
		<cfargument name='PRAZO_ENTREGA' required='yes'> 
		<cfargument name="REGERAR_IMPRESSAO" required="no" default="0">
        <cfargument name='PEDIDO_SHIPMENT' required='no' default="">
		<cfargument name='LIMITE_PROG_CARGA' required="no" default="" >
        <cfargument name='LIMITE_PESO' required="no" default="" >
        <cfargument name='LIMITE_EMBARQUES' required="no" default="" >
        <cfargument name='NUM_LOTE_CLIENTE' required="no" default="" >
        <cfargument name='LIMITE_EMBARQUES_2' required="no" default="" >
		
		<cfargument name="rem_cod_endereco" required="yes">
		<cfargument name="dest_cod_endereco" required="yes">
		<cfargument name="cons_cod_endereco" required="yes">
		<cfargument name="not_cod_endereco" required="yes">
		<cfargument name='neg_cod_endereco' required='yes'>			
		<cftry>
			<cfscript>
				v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
				v_mercadorias = "";
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_descricao)#" index="v_index">
				<cfset v_mercadorias = v_mercadorias&v_descricao[v_index]&chr(10)>			
			</cfloop>
			<cfset v_mercadorias = v_mercadorias&arguments.adicionais_mercadoria>				
			<cftransaction action="begin">
				<cfstoredproc procedure="fiscal.pkg_transp_internacional.PRC_ALT_CRT_LIB_FATURA" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.CONHECIMENTO_ID#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.EMISSAO_DATA#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.EMISSAO_LOCAL#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.EMISSAO_MUNICIPIO_ID#" null="#iif(len(trim(arguments.EMISSAO_MUNICIPIO_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.RESP_LOCAL#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.RESP_MUNICIPIO_ID#" null="#iif(len(trim(arguments.RESP_MUNICIPIO_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.RESP_DATA#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.ENTREGA_LOCAL#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ENTREGA_MUNICIPIO_ID#" null="#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.ENTREGA_DATA#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.TRANSP_SUCESSIVOS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_ENDERECO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_MUNICIPIO_ID#" null="#iif(len(trim(arguments.rem_municipio_id)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_MUNICIPIO#">
					
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_UF#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.REM_PAIS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_ENDERECO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_MUNICIPIO_ID#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_MUNICIPIO#">
	
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_UF#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DEST_PAIS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_ENDERECO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_MUNICIPIO_ID#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_MUNICIPIO#">
	
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_UF#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.CONS_PAIS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_ENDERECO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_MUNICIPIO_ID#" null="#iif(len(trim(arguments.NOT_MUNICIPIO_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_MUNICIPIO#">
	
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_UF#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NOT_PAIS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#v_MERCADORIAS#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.NUM_ESPECIE#"  null="#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#">
					<cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.quantidade_total#" null="#iif(len(trim(arguments.quantidade_total)), de('no'), de('yes'))#">
					<cfprocparam  					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_bruto#" null="#iif(len(trim(arguments.peso_bruto)), de('no'), de('yes'))#">
					<cfprocparam  				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_liquido#" null="#iif(len(trim(arguments.peso_liquido)), de('no'), de('yes'))#">
					<cfprocparam  					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.unidade_id#">
					<cfprocparam  							type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.m3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
					<cfprocparam  					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total#" null="#iif(len(trim(arguments.valor_total)), de('no'), de('yes'))#">


					<cfprocparam 		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_cod_moeda#" null="#iif(len(trim(arguments.valor_total_cod_moeda)), de('no'), de('yes'))#">
					<cfprocparam 		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_incoterm_id#" null="#iif(len(trim(arguments.valor_total_incoterm_id)), de('no'), de('yes'))#">
					<cfprocparam  				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso#"  null="#iif(len(trim(arguments.valor_reembolso)), de('no'), de('yes'))#">
					<cfprocparam  	type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_reembolso_cod_moeda#" null="#iif(len(trim(arguments.valor_reembolso_cod_moeda)), de('no'), de('yes'))#">
					<cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias#" null="#iif(len(trim(arguments.valor_mercadorias)), de('no'), de('yes'))#">
				
					<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.VALOR_MERCADORIAS_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_COD_MOEDA)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.VALOR_MERCADORIAS_INCOTERM#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_INCOTERM)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ALFANDEGA_ORIGEM_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.ALFANDEGA_DESTINO_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_DESTINO_ID)), de('no'), de('yes'))#">
					<cfprocparam  				type="in"  cfsqltype="cf_sql_integer" value="#arguments.pais_id_origem#"  null="#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#">
	
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.DECLARACAO_OBSERVACAO#">
					<cfprocparam 				type="in"  cfsqltype="cf_sql_integer" value="#arguments.qtde_veiculos#" null="#iif(len(trim(arguments.qtde_veiculos)), de('no'), de('yes'))#">
					<cfprocparam 			type="in"  cfsqltype="cf_sql_integer" value="#arguments.seguro_pago_empresa#" null="#iif(len(trim(arguments.seguro_pago_empresa)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.EMISSAO_DATA_IMPRESSAO#">
					<cfprocparam 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.TAXA_MERCADORIA_SEGURO#" null="#iif(len(trim(arguments.TAXA_MERCADORIA_SEGURO)), de('no'), de('yes'))#">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID_GERENCIAL#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_GERENCIAL)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.PRAZO_ENTREGA#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.pedido_shipment#" >
				    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_PROG_CARGA#'  null='#iif(len(trim(arguments.LIMITE_PROG_CARGA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_PESO#'  null='#iif(len(trim(arguments.LIMITE_PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_EMBARQUES#'  null='#iif(len(trim(arguments.LIMITE_EMBARQUES)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.NUM_LOTE_CLIENTE#" >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LIMITE_EMBARQUES_2#'  null='#iif(len(trim(arguments.LIMITE_EMBARQUES_2)), de('no'), de('yes'))#'><br>
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   null="yes">
					<cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.rem_cod_endereco#">
					<cfprocparam  		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.dest_cod_endereco#">
					<cfprocparam  		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cons_cod_endereco#">
					<cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.not_cod_endereco#">
					<cfprocparam  			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.neg_cod_endereco#">
				</cfstoredproc>
				
				<cfset retorno.conhecimento_id = arguments.conhecimento_id>
				
				<!--- Alteraes das Mercadorias --->
				<cfscript>
					v_produto_id = this.ListaToArray (lista = arguments, variavel = "MERC_PRODUTO_ID_MERCADORIAS");
					v_num_especie = this.ListaToArray (lista = arguments, variavel = "MERC_NUM_ESPECIE_MERCADORIAS");
					v_quantidade = this.ListaToArray (lista = arguments, variavel = "MERC_QUANTIDADE_MERCADORIAS");
					v_peso_bruto = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_BRUTO_MERCADORIAS");
					v_peso_liquido = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_LIQUIDO_MERCADORIAS");
					v_m3 = this.ListaToArray (lista = arguments, variavel = "MERC_VOLUME_MERCADORIAS");
					v_unidade_id = this.ListaToArray (lista = arguments, variavel = "MERC_UNIDADE_ID_MERCADORIAS");
					v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
					v_item_id = this.ListaToArray (lista = arguments, variavel = "MERC_ITEM_ID_MERCADORIAS");
					v_merc_excluir = this.ListDiff(lista1 = arguments.lista_deleted_MERCADORIAS, lista2 = ArrayToList(v_item_id));
				</cfscript>
	
				<!--- Excluir os itens --->
				<cfloop list="#v_merc_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_item_crt (	conhecimento_id = arguments.conhecimento_id,
											item_id   = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
					if(not len(trim(v_item_id[count]))) {
						//caso o item_id seja nulo insere
						this.ins_item_crt(	conhecimento_id = arguments.conhecimento_id,
											produto_id = v_produto_id[count],
											num_especie = v_num_especie[count],
											quantidade = v_quantidade[count],
											peso_bruto = v_peso_bruto[count],
											peso_liquido = v_peso_liquido[count],
											m3 = v_m3[count],
											descricao = v_descricao[count]);
					} else {
						//senao altera
						this.upd_item_crt(	conhecimento_id = arguments.conhecimento_id,
											produto_id = v_produto_id[count],
											num_especie = v_num_especie[count],
											quantidade = v_quantidade[count],
											peso_bruto = v_peso_bruto[count],
											peso_liquido = v_peso_liquido[count],
											m3 = v_m3[count],
											descricao = v_descricao[count],
											item_id = v_item_id[count]);
					}
					</cfscript>
				</cfloop>			
	
				<!--- Alteraes dos Anexos --->
				<cfscript>
					v_descricao = this.ListaToArray (lista = arguments, variavel = "ANEXO_DESCRICAO_ANEXOS");
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
					v_anexos_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_anexos_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_anexo_crt (conhecimento_id = arguments.conhecimento_id,
											anexo_id   = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
					if(not len(trim(v_item_id[count]))) {
						//caso o item_id seja nulo insere
						this.ins_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
											descricao = v_descricao[count]);
					} else {
						//senao altera
						this.upd_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
											descricao = v_descricao[count],
											anexo_id = v_item_id[count]);
					}
					</cfscript>
				</cfloop>		
	
				
				<!--- Insercao de FRONTEIRAS --->
				<cfscript>
					v_controle_id  = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_FRONTEIRAS");
					v_fronteira_id = this.ListaToArray (lista = arguments, variavel = "FRONTEIRA_ID_FRONTEIRAS");
					v_fronteira_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FRONTEIRAS, lista2 = ArrayToList(v_fronteira_id));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_fronteira_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_crt_fronteira (controle_id = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
					<cfscript>
					if(not len(trim(v_controle_id[count]))) {
						//caso o item_id seja nulo insere
						this.ins_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
												fronteira_id = v_fronteira_id[count]);
					} else {
						//senao altera
						this.upd_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
												fronteira_id    = v_fronteira_id[count],
												controle_id     = v_controle_id[count]);
					}
					</cfscript>
				</cfloop>

				<!--- Insercao de ADUANAS --->
                <cfscript>
                    v_conhecimento_aduana_id  = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_ADUANA_ID_ADUANAS");
                    v_aduana_id = this.ListaToArray (lista = arguments, variavel = "ADUANA_ID_ADUANAS");
					v_aduana_ordem = this.ListaToArray (lista = arguments, variavel = "ADUANA_ORDEM_ADUANAS");
					v_aduana_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ADUANAS, lista2 = ArrayToList(v_conhecimento_aduana_id));
                </cfscript>
                <!--- Excluir os itens --->
                <cfloop list="#v_aduana_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        this.del_crt_aduana (conhecimento_aduana_id = l_item_id);						
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_conhecimento_aduana_id)#" index="count">
                    <cfscript>
                    if(not len(trim(v_conhecimento_aduana_id[count]))) {
                        //caso o item_id seja nulo insere
                        this.ins_crt_aduana(conhecimento_id = retorno.conhecimento_id,
                                            aduana_id	 = v_aduana_id[count],
											aduana_ordem = v_aduana_ordem[count]);
                    } else {
                        //senao altera
                        this.alt_crt_aduana(conhecimento_aduana_id = v_conhecimento_aduana_id[count],
							                conhecimento_id 	   = arguments.conhecimento_id,
                                            aduana_id    	       = v_aduana_id[count],
                                            aduana_ordem     	   = v_aduana_ordem[count]);
                    }
                    </cfscript>
                </cfloop>		
	
				<!---Diviso--->
                <cfscript>
                    v_divisao_controle_id = this.ListaToArray(lista = arguments, variavel = "DIVISAO_CONTROLE_ID_DIVISAO");
                    v_num_embarque        = this.ListaToArray(lista = arguments, variavel = "NUM_EMBARQUE_DIVISAO");
                    v_divisao_embarque_id = this.ListaToArray(lista = arguments, variavel = "EMBARQUE_ID_DIVISAO");
                    v_divisao_id          = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ID_DIVISAO");
                    v_embarque_data       = this.ListaToArray(lista = arguments, variavel = "EMBARQUE_DATA_DIVISAO");
                    v_placa_controle      = this.ListaToArray(lista = arguments, variavel = "PLACA_CONTROLE_DIVISAO");
                    v_placa_referencia_composicao = this.ListaToArray(lista = arguments, variavel = "PLACA_REFERENCIA_COMPOSICAO_DIVISAO");
                    v_divisao_cod_motorista       = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_MOTORISTA_DIVISAO");
                    v_divisao_motorista           = this.ListaToArray(lista = arguments, variavel = "DIVISAO_MOTORISTA_DIVISAO");
                    v_divisao_cod_pessoa_motorista = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_PESSOA_MOTORISTA_DIVISAO");
                    v_divisao_rota_abreviatura     = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ROTA_ABREVIATURA_DIVISAO");
                    v_divisao_rota_id    = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ROTA_ID_DIVISAO");
                    v_divisao_km         = this.ListaToArray(lista = arguments, variavel = "DIVISAO_KM_DIVISAO");
                    v_divisao_percentual = this.ListaToArray(lista = arguments, variavel = "DIVISAO_PERCENTUAL_DIVISAO");
                    v_divisao_cod_moeda  = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_MOEDA_DIVISAO");
                    v_divisao_valor      = this.ListaToArray(lista = arguments, variavel = "DIVISAO_VALOR_DIVISAO");				
                    v_divisao_data      = this.ListaToArray(lista = arguments, variavel = "DIVISAO_DATA_DIVISAO");
					v_embarque_excluir   = this.ListDiff(lista1 = arguments.lista_deleted_DIVISAO, lista2 = ArrayToList(v_divisao_embarque_id));
					v_divisao_excluir   = this.ListDiff(lista1 = arguments.lista_deleted_DIVISAO, lista2 = ArrayToList(v_divisao_id));
                 </cfscript>
        
                <!--- Excluir os itens --->
               <!--- <cfloop list="#v_embarque_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        set_embarque = this.del_intc_crt_embarque(embarque_id = l_item_id);
                    </cfscript>

                    <cfif set_embarque.erro>
                        <cfthrow object="#set_embarque.MENSAGEM#"/>
                    </cfif>    
                </cfloop>--->  
                
                <cfloop list="#v_divisao_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        set_divisao = this.del_embarque_divisao(divisao_id = l_item_id);
                    </cfscript>

					<cfif set_divisao.erro>
                        <cfthrow object="#set_divisao.MENSAGEM#"/>
                    </cfif>    
                </cfloop>               
                
                <cfset v_embarque = 0>
                <cfset v_embarque_id = 0>
                <cfloop from="1" to="#ArrayLen(v_num_embarque)#" index="count">
                     <cfscript>
                        if (v_embarque neq v_num_embarque[count])  {
                            // Registra embarque
                            v_embarque = v_num_embarque[count];
                            
                            if(not len(trim(v_divisao_embarque_id[count]))) {
                                //caso o item_id seja nulo insere
                                set_embarque = this.ins_intc_crt_embarque( conhecimento_id = arguments.conhecimento_id,
                                                                          data_embarque = v_embarque_data[count]);
                                
								if (not set_embarque.erro) 
                                     v_embarque_id = set_embarque.embarque_id;
                            }else{
								v_embarque_id = v_divisao_embarque_id[count];
							}
                        }
                     </cfscript>

                     <cfif IsDefined("set_embarque") and set_embarque.erro>
                        <cfthrow object="#set_embarque.Mensagem#">
                     </cfif>
                     
                    <cfscript>
                        if(not len(trim(v_divisao_id[count]))) {
                            //caso o item_id seja nulo insere
                            set_divisao = this.ins_embarque_divisao( valor                = v_divisao_valor[count]
                                                                    ,cod_moeda            = v_divisao_cod_moeda[count] 
                                                                    ,percentual_crt       = v_divisao_percentual[count] 
                                                                    ,rota_id              = v_divisao_rota_id[count] 
                                                                    ,cod_pessoa_motorista = v_divisao_cod_pessoa_motorista[count] 
                                                                    ,embarque_id          = v_embarque_id
																	,data_divisao 		  = v_divisao_data[count] 
                                                                   );
                            
							if (not set_divisao.erro) 
	                           v_divisao_id[count] = set_divisao.divisao_id;
                        } 
						
//						else {
//                            //senao altera
//                            set_divisao = this.upd_embarque_divisao( divisao_id			  = v_divisao_id[count]
//                                                                    ,valor                = v_divisao_valor[count]
//                                                                    ,cod_moeda            = v_divisao_cod_moeda[count] 
//                                                                    ,percentual_crt       = v_divisao_percentual[count] 
//                                                                    ,rota_id              = v_divisao_rota_id[count] 
//                                                                    ,cod_pessoa_motorista = v_divisao_cod_pessoa_motorista[count] 
//                                                                    ,embarque_id          = v_embarque_id
//                                                                   );
//                        }
                     </cfscript>            
                              
                     <cfif isDefined("set_divisao") and set_divisao.erro>
                        <cfthrow object="#set_divisao.Mensagem#">
                     </cfif>

                    <!---Exclui composicao--->
                    <cfscript>
                        set_divisao_comp = this.del_embarque_divisao_comp(divisao_id = v_divisao_id[count]);
                    </cfscript>
                    <cfif set_divisao_comp.erro>
                        <cfthrow object="#set_divisao_comp.Mensagem#">
                    </cfif>
                    
                    <!---Insere todas as composies--->
                    <cfscript>	
                        // Insere cavalo
						if(len(trim(v_placa_controle[count]))) {
                        set_divisao_comp = this.ins_embarque_divisao_comp( ordem                = 0
                                                                          ,placa                = v_placa_controle[count]
                                                                          ,divisao_id           = v_divisao_id[count] 
                                                                         );
						}
                     </cfscript>            
                              
                     <cfif set_divisao_comp.erro>
                        <cfthrow object="#set_divisao_comp.Mensagem#">
                     </cfif>

                     <cfset v_ordem = 1>
                     <cfloop list="#v_placa_referencia_composicao[count]#" index="l_placa" delimiters=",">
                            <cfscript>	
                                // Insere cavalo
								if(len(trim(v_placa_controle[count]))) {
                                set_divisao_comp = this.ins_embarque_divisao_comp( ordem                = v_ordem
                                                                                  ,placa                = l_placa
                                                                                  ,divisao_id           = v_divisao_id[count] 
                                                                                 );
								}
                             </cfscript>            
                             <cfset v_ordem = v_ordem + 1>

                             <cfif set_divisao_comp.erro>
                                <cfthrow object="#set_divisao_comp.Mensagem#">
                             </cfif>
                     </cfloop>
				</cfloop>
                   
                <!--- Gera conhecimento FORM --->
                <cfscript>
					if(arguments.regerar_impressao eq 1) {
                		set_impressao = this.ins_intc_conhecimento_form(conhecimento_id = arguments.conhecimento_id);
					}
				</cfscript>
               
			    <cfif IsDefined("set_impressao") and set_impressao.erro>
					<cfthrow object="#set_impressao.mensagem#">
                </cfif>
                
                <!--- Calcula Seguro --->
				<cfscript>
                    retorno = this.calcula_seguro_crt(conhecimento_id = arguments.conhecimento_id);
                </cfscript>                   
                <cfif IsDefined("retorno") and retorno.erro>
                    <cfthrow object="#retorno.mensagem#">
                </cfif>
                
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfscript>
					conn_cons_tf = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
					qrGrupoNegociadorPessoa = conn_cons_tf.get_grupo_negociador_pessoa(cod_pessoa = arguments.COD_NEGOCIADOR);
					conn = CreateComponent("modulos.transporte_internacional._componentes.consulta.cfc_transp_internacional");
					qrConhecimento_complemento = conn.get_intc_conhecimento_complemento(conhecimento_id = arguments.CONHECIMENTO_ID);					
				</cfscript>      
                <!---buscar se o crt eh d coplemento--->          
                <cfif qrGrupoNegociadorPessoa.EMITE_TABELA_FRETE eq 1 and qrConhecimento_complemento.RecordCount eq 0>
                	<cfscript>
						qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id_intc(ORIGEM_MUNICIPIO_ID  		= arguments.RESP_MUNICIPIO_ID,
																						 DESTINO_MUNICIPIO_ID 		= arguments.ENTREGA_MUNICIPIO_ID,
																						 COD_NEGOCIADOR       		= arguments.COD_NEGOCIADOR,
																						 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																						 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID,
																				 		 TIPO_SERVICO_ID			= arguments.TIPO_SERVICO_COMERCIAL);
					</cfscript>
					<cfif qrTabelaFreteRotaId.erro>
						<cfthrow object="#qrTabelaFreteRotaId.mensagem#">
					</cfif>
					
                    <cfscript>
						// Constantes
						
						// ----------
					</cfscript>
                    
                    <cfscript>
						qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID
																			 , tabela_frete_id      = qrTabelaFreteRotaId.TABELA_FRETE_ID);
						qrConstante 	  = conn_cons_tf.get_constante();
						qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID
																				 , tabela_frete_id      = qrTabelaFreteRotaId.TABELA_FRETE_ID);
						
						conn_manip_tf = CreateComponent("_transportes.manipulacao.comercial.cfc_tabela_frete");
					</cfscript>
					
					<cfloop query="qrConstante">
						<cfscript>
							ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
														  		   VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
						</cfscript>
						<cfif ret_cons.erro>
							<cfthrow object="#ret_cons.mensagem#">
						</cfif>
					</cfloop>
					
					<cfscript>
						ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
														 		  VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_cons_tf.erro>
						<cfthrow object="#ret_cons_tf.mensagem#">
					</cfif>
					
					<cfscript>
						ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
														  		   VALOR		 = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID);
					</cfscript>
					<cfif ret_cons_tfr.erro>
						<cfthrow object="#ret_cons_tfr.mensagem#">
					</cfif>
					
                    <cfscript>
                    ret_cons_tfv = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_VIGENCIA_ID',
                                                      VALOR		    = qrTabelaFreteRota.tabela_frete_vigencia_id);
                    </cfscript>
					<cfif ret_cons_tfv.erro>
						<cfthrow object="#ret_cons_tfv.mensagem#">
					</cfif>
					
					<cfloop query="qrVariavel">
						<cfscript>
							ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
																	 		  TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID,
																	 		  TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 		  VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					</cfloop>
                    
                    <cfscript>
						ret_calc = this.calcula_crt_tabela_frete(CONHECIMENTO_ID			= retorno.CONHECIMENTO_ID,
																 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID);
					</cfscript>
					<cfif ret_calc.erro>
						<cfthrow object="#ret_calc.mensagem#">
					</cfif>
                </cfif>
                
                <cfscript>
					ret_valid_tf = this.valida_crt_tabela_frete(CONHECIMENTO_ID = retorno.CONHECIMENTO_ID);
				</cfscript>
				<cfif ret_valid_tf.erro>
					<cfthrow object="#ret_valid_tf.mensagem#">
				</cfif>
                <!--- /// --->
                <!--- Itinerrio --->
				<cfscript>
                    arguments.conhecimento_id = retorno.conhecimento_id; 
                    ret = this.ins_itinerarios(argumentCollection  = arguments );
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>                   
                
                
                <!--- Vincula CTe e CRT  --->
				<cfscript>
                    arguments.conhecimento_id = retorno.conhecimento_id; 
                    ret = this.ins_cte_crt(argumentCollection  = arguments );
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>                  
                
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("C.R.T. alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um novo manifesto internacional (MIC/DTA)
	-- CRISTOFER 13/12/2005 - criado
	--->
	<cffunction name='ins_intc_manifesto' displayname='Insere um novo manifesto internacional (MIC/DTA)' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='TRANSITO_ADUANEIRO' required='no' default="0">
		<cfargument name='COD_TRANSPORTADOR' required='yes'>
		<cfargument name='TRANSP_NOME' required='yes'>
		<cfargument name='TRANSP_ENDERECO' required='yes'>
		<cfargument name='TRANSP_MUNICIPIO_ID' required='yes'>
		<cfargument name='TRANSP_DADOS_ADICIONAIS' required='yes'>
		<cfargument name='TRANSP_CNPJ_CPF' required='yes'>
		<cfargument name='ALFANDEGA_ORIGEM_ID' required='yes'>
		<cfargument name='ALFANDEGA_DESTINO_ID' required='yes'>		
		<cfargument name='DESTINO_LOCAL' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_COD_PESSOA' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_NOME' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_ENDERECO' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_CNPJ_CPF' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_CONTROLE' required='yes'>
		<cfargument name='VEIC_ORIG_MARCA' required='yes'>

		<cfargument name='VEIC_ORIG_CHASSIS' required='yes'>
		<cfargument name='VEIC_ORIG_CAPACIDADE' required='yes'>
		<cfargument name='VEIC_ORIG_ANO' required='yes'>
		<cfargument name='VEIC_ORIG_TIPO' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_REFERENCIA' required='no' default=""> 
		<cfargument name='VEIC_ORIG_MOT_COD_PESSOA' required='yes'>
        <cfargument name='VEIC_ORIG_PROP_DADOS_ADICIONAIS' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_COD_PESSOA' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_NOME' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_ENDERECO' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_MUNICIPIO_ID' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_CNPJ_CPF' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_CONTROLE' required='no' default="">
		<cfargument name='VEIC_SUBST_MARCA' required='no' default="">
		<cfargument name='VEIC_SUBST_CHASSIS' required='no' default="">
		<cfargument name='VEIC_SUBST_CAPACIDADE' required='no' default="">
		<cfargument name='VEIC_SUBST_ANO' required='no' default="">
		<cfargument name='VEIC_SUBST_TIPO' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_REFERENCIA' required='no' default="">
		<cfargument name='VEIC_SUBST_MOT_COD_PESSOA' required='no' default="">
		<cfargument name='NUM_DTA_ROTA' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ROMANEIO_ITEM_ID' required='no' default="">
        <cfargument name='EN_LASTRE' required='no' default="0">
		<cfset arguments.numero_cod_pais = mid(arguments.NUMERO,1,2) >
        <cfset arguments.numero_certificado = mid(arguments.NUMERO,3,3) >
        <cfset arguments.numero_sequencial = mid(arguments.NUMERO,6,len(arguments.NUMERO)) >
		<cfset arguments.serie = mid(arguments.permisso,8,1) >
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.numero_cod_pais#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.numero_certificado#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.numero_sequencial#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TRANSITO_ADUANEIRO#'  null='#iif(len(trim(arguments.TRANSITO_ADUANEIRO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TRANSP_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TRANSP_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TRANSP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.TRANSP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TRANSP_DADOS_ADICIONAIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TRANSP_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALFANDEGA_ORIGEM_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESTINO_LOCAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_ORIG_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_ORIG_PROP_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_ORIG_PROP_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_ORIG_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_ORIG_PROP_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#UCase(Replace(arguments.VEIC_ORIG_PLACA_CONTROLE,'-',''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_ORIG_MARCA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_ORIG_CHASSIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_ORIG_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_ORIG_CAPACIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_ORIG_ANO#'  null='#iif(len(trim(arguments.VEIC_ORIG_ANO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_ORIG_TIPO#'  null='#iif(len(trim(arguments.VEIC_ORIG_TIPO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_ORIG_PLACA_REFERENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_ORIG_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_SUBST_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_SUBST_PROP_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_SUBST_PROP_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_SUBST_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_SUBST_PROP_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#UCase(Replace(arguments.VEIC_SUBST_PLACA_CONTROLE,'-',''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_SUBST_MARCA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_SUBST_CHASSIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_SUBST_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_SUBST_CAPACIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_SUBST_ANO#'  null='#iif(len(trim(arguments.VEIC_SUBST_ANO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_SUBST_TIPO#'  null='#iif(len(trim(arguments.VEIC_SUBST_TIPO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VEIC_SUBST_PLACA_REFERENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEIC_SUBST_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_DTA_ROTA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MANIFESTO_ID#' variable='retorno.MANIFESTO_ID'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROMANEIO_ITEM_ID#'  null='#iif(len(trim(arguments.ROMANEIO_ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EN_LASTRE#'  null='#iif(len(trim(arguments.EN_LASTRE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ANEXO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
				<cfset arguments.manifesto_id = retorno.manifesto_id>
				<!--- Inseres dos Items --->
				<cfscript>
					v_nro_crt = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NUMERO_CRT_ITEMS");
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "ITEM_CONHECIMENTO_ID_ITEMS");
					v_id = 				this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ITEMS");
					v_item_id =			this.ListaToArray (lista = arguments, variavel = "ITEM_IT_ID_ITEMS");
					v_quantidade = 		this.ListaToArray (lista = arguments, variavel = "ITEM_QUANTIDADE_ITEMS");
					v_peso_bruto = 		this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_BRUTO_ITEMS");
					v_peso_liquido = 	this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_LIQUIDO_ITEMS");
					v_valor_total = 	this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_TOTAL_ITEMS");
					v_seguro = 			this.ListaToArray (lista = arguments, variavel = "ITEM_SEGURO_ITEMS");
					v_num_especie = 	this.ListaToArray (lista = arguments, variavel = "ITEM_NUM_ESPECIE_ITEMS");
					v_descricao = 		this.ListaToArray (lista = arguments, variavel = "ITEM_DESCRICAO_ITEMS");
					v_ncm = 			this.ListaToArray (lista = arguments, variavel = "ITEM_NCM_ITEMS");
					v_valor_fot = 		this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_FOT_ITEMS");
					v_nro_lacres = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NRO_LACRES_ITEMS");
					v_pais_id_origem =  this.ListaToArray (lista = arguments, variavel = "ITEM_PAIS_ID_ORIGEM");
					v_cod_remetente = 	this.ListaToArray (lista = arguments, variavel = "COD_REMETENTE_ITEMS");
					v_rem_nome =		this.ListaToArray (lista = arguments, variavel = "REM_NOME_ITEMS");
					v_rem_local =		this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_UF_PAIS_ITEMS");
					v_rem_municipio_id =this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_ID_ITEMS");
					v_anexos = 			this.ListaToArray (lista = arguments, variavel = "ITEM_ANEXOS_ITEMS");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
						this.ins_intc_manifesto_item(	manifesto_id 	= arguments.manifesto_id,
														conhecimento_id = v_conhecimento_id[count],
														item_id 		= v_id[count],
													    alfandega_destino_id  = arguments.alfandega_destino_id,
														quantidade		= v_quantidade[count],
														peso_bruto		= v_peso_bruto[count],
														peso_liquido	= v_peso_liquido[count],
														valor_total		= v_valor_total[count],
														valor_seguro	= v_seguro[count],
														num_especie		= v_num_especie[count],
														mercadorias		= v_descricao[count],
														numero_lacres	= v_nro_lacres[count],
														valor_fot		= v_valor_fot[count],
														ncm				= v_ncm[count],
														pais_id_origem  = v_pais_id_origem[count],
														anexo			= v_anexos[count],
														cod_remetente	= v_cod_remetente[count],
														rem_nome		= v_rem_nome[count],
														rem_local		= v_rem_local[count],
														rem_municipio_id= v_rem_municipio_id[count],
														en_lastre		= arguments.en_lastre);									
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MIC/DTA inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Insere um Item de CRT no MIC/DTA
	-- CRISTOFER 15/12/2005 - criado
	--->
	<cffunction name='ins_intc_manifesto_item' displayname='Insere um Item de CRT no MIC/DTA' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='ALFANDEGA_DESTINO_ID' required='no' default=''>
		<cfargument name='COD_MOEDA' required='no' default=''>
		<cfargument name='ORIGEM_LOCAL' required='no' default=''>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='VALOR_FOT' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='VALOR_SEGURO' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PESO_BRUTO' required='yes'>
		<cfargument name='PESO_LIQUIDO' required='yes'>
		<cfargument name='UNIDADE_ID' required='no' default='Kg'>
		<cfargument name='COD_REMETENTE' required='no' default=''>
		<cfargument name='REM_NOME' required='no' default=''>
		<cfargument name='REM_LOCAL' required='no' default=''>
		<cfargument name='REM_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='COD_DESTINATARIO' required='no' default=''>
		<cfargument name='DEST_NOME' required='no' default=''>
		<cfargument name='DEST_LOCAL' required='no' default=''>
		<cfargument name='DEST_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='COD_CONSIGNATARIO' required='no' default=''>
		<cfargument name='CONS_NOME' required='no' default=''>
		<cfargument name='CONS_LOCAL' required='no' default=''>
		<cfargument name='CONS_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='NUMERO_LACRES' required='yes'>
		<cfargument name='MERCADORIAS' required='yes'>
		<cfargument name='NCM' required='yes'>
		<cfargument name='PAIS_ID_ORIGEM' required='yes'>
		<cfargument name='ANEXO' required='yes'>
		<cfscript>
			conn = CreateObject("component", "_transportes.consulta.cfc_transp_internacional");
			qrConhecimento = conn.get_intc_conhecimento_item_mic(argumentCollection = arguments);
		</cfscript>
		<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_manifesto_crt_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ALFANDEGA_DESTINO_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_DESTINO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.COD_MOEDA#'  null='#iif(len(trim(qrConhecimento.COD_MOEDA)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#qrConhecimento.ORIGEM_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(qrConhecimento.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.VALOR_FOT#'  null='#iif(len(trim(arguments.VALOR_FOT)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.VALOR_SEGURO#'  null='#iif(len(trim(arguments.VALOR_SEGURO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.PESO_BRUTO#'  null='#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.PESO_LIQUIDO#'  null='#iif(len(trim(arguments.PESO_LIQUIDO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.UNIDADE_ID#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.COD_DESTINATARIO#'  null='#iif(len(trim(qrConhecimento.COD_DESTINATARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#qrConhecimento.DEST_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#qrConhecimento.DEST_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(qrConhecimento.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.COD_CONSIGNATARIO#'  null='#iif(len(trim(qrConhecimento.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#qrConhecimento.CONS_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#qrConhecimento.CONS_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.CONS_MUNICIPIO_ID#'  null='#iif(len(trim(qrConhecimento.CONS_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.NUMERO_LACRES#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MERCADORIAS#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.NCM#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.pais_id_origem#' null='#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.ANEXO#' >
		</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Vincula um valor a um embarque
    -- ERICG 20/10/2010 15:30 - CRIADO
    --->
    <cffunction name='viagem_embarque_valor' displayname='Vincula um valor a um embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cfargument name='CAMPO' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_intc_viagem.prc_viagem_embarque_valor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Campo vinculado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
        
    <!--- 
	-- PROPSITO
	-- Vincula um CRT a um embarque
	-- ANDERSONC 08/09/2009 15:37:21 - CRIADO
	--->
	<cffunction name='viagem_embarque_crt' displayname='Vincula um CRT a um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='MANIFESTO_ID' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_viagem_embarque_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
                <cfif Len(Trim(arguments.MANIFESTO_ID))>
                	<cfscript>
						ret = this.viagem_embarque_mic(EMBARQUE_ID  = arguments.EMBARQUE_ID,
													   MANIFESTO_ID = arguments.MANIFESTO_ID);
					</cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT vinculado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Finaliza um embarque
	-- ANDERSONC 15/01/2010 14:23:16 - CRIADO
	--->
	<cffunction name='finaliza_viagem_embarque' displayname='Finaliza um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='CONDICOES_ENTREGA_MERCADORIA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_finaliza_viagem_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONDICOES_ENTREGA_MERCADORIA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Embarque finalizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>            
	
	<!--- 
	-- PROPSITO
	-- Vincula um MIC/DTA a um embarque
	-- ANDERSONC 08/09/2009 15:41:25 - CRIADO
	--->
	<cffunction name='viagem_embarque_mic' displayname='Vincula um MIC/DTA a um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_viagem_embarque_mic' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('MIC/DTA vinculado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>  
    
    <!--- 
	-- PROPSITO
	-- Insere um anexo a uma programao ou a um embarque
	-- ANDERSONC 14/01/2010 15:08:55 - CRIADO
	--->
	<cffunction name='insere_anexo' displayname='Insere um anexo a uma programao ou a um embarque' access='remote' returntype='Struct' output='true'>

        <cfargument name='EMBARQUE_ID' required='no' default=''>
        <cfargument name='PROGRAMACAO_ID' required='no' default=''>
		<cftry><cfdump var="#arguments#">
			<cftransaction action='begin'>
	
                <!---Anexos---->
                 <cfscript>
					 v_nome_anexo   = this.ListaToArray(lista = arguments, variavel = 'NOME_ANEXO_ANEXOS');
					 v_nome_arquivo = this.ListaToArray(lista = arguments, variavel = 'NOME_ARQUIVO_ANEXOS');
				</cfscript>	 
                
                 <cfloop from="1" to="#ArrayLen(v_nome_arquivo)#" index="count_an">
                 	   <!--- Busca arquivo --->
					   <cfif Len(Trim(v_nome_arquivo[count_an]))>
                           <cffile action="readbinary" file="#expandPath("/")#temp/#v_nome_arquivo[count_an]#" variable="VARQUIVO">
                           <cfscript>
                           	  v_extensao = ListToArray(v_nome_arquivo[count_an], '.');
						   </cfscript>
                       <cfelse>
                           <cfset VARQUIVO = ''>
                           <cfset v_extensao = ''>
                       </cfif>
					   <cfscript>
						ret_ane = this.ins_anexo(CONTEUDO = VARQUIVO,
										         NOME 	  = v_nome_anexo[count_an],
						   				         EXTENSAO = v_extensao[ArrayLen(v_extensao)]
												);
					   </cfscript>
                    
                    <cfif ret_ane.erro >
                	   <cfthrow object="#ret_ane.mensagem#">
                    </cfif>   
                       
                
					<!--- Vincula o anexo a uma programao --->
                    <cfif Len(Trim(arguments.PROGRAMACAO_ID))>
                        <cfscript>
                            ret = this.ins_programacao_anexo(ANEXO_ID       = ret_ane.ANEXO_ID,
                                                             PROGRAMACAO_ID = arguments.PROGRAMACAO_ID);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>
                    
                    <!--- Vincula o anexo a um embarque --->
                    <cfif Len(Trim(arguments.EMBARQUE_ID))>
                        <cfscript>
                            ret = this.ins_embarque_anexo(ANEXO_ID    = ret_ane.ANEXO_ID,
                                                          EMBARQUE_ID = arguments.EMBARQUE_ID);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>
                </cfloop>
                
                <cfif Len(Trim(arguments.EMBARQUE_ID))>
					<cfscript>
                        ret = this.envia_email_anexo_reg_emb(EMBARQUE_ID = arguments.EMBARQUE_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
                <cfif Len(Trim(arguments.PROGRAMACAO_ID))>
					<cfscript>
                        ret = this.envia_email_ane_prog_car(PROGRAMACAO_ID = arguments.PROGRAMACAO_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Anexo(s) inserido(s) com sucesso.')>
			</cftransaction>
            <cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
	</cffunction>   
     
    <!--- 
	-- PROPSITO
	-- Exclui um anexo de uma programao ou de um embarque
	-- ANDERSONC 14/01/2010 15:08:55 - CRIADO
	--->
	<cffunction name='exclui_anexo' displayname='Exclui um anexo de uma programao ou de um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='EMBARQUE_ID' required='no' default=''>
        <cfargument name='PROGRAMACAO_ID' required='no' default=''>
		<cftry>
        	<cftransaction action='begin'>
            	<!--- Desvincula o anexo de uma programao --->
                <cfif Len(Trim(arguments.PROGRAMACAO_ID))>
					<cfscript>
                        ret = this.del_programacao_anexo(ANEXO_ID       = arguments.ANEXO_ID,
                                                         PROGRAMACAO_ID = arguments.PROGRAMACAO_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
                <!--- Desvincula o anexo de um embarque --->
                <cfif Len(Trim(arguments.EMBARQUE_ID))>
					<cfscript>
                        ret = this.del_embarque_anexo(ANEXO_ID    = arguments.ANEXO_ID,
                                                      EMBARQUE_ID = arguments.EMBARQUE_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
				<!--- Exclui o anexo --->
                <cfscript>
					ret = this.del_anexo(ANEXO_ID = arguments.ANEXO_ID);
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso.')>
			</cftransaction>
            <cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
	</cffunction>    
    
    
    <!--- 
	-- PROPSITO
	-- Envia email no momento em que  anexado um ou mais arquivos a programao de carga
	-- FABIOG 09/08/2011 15:19:40 - CRIADO
	--->
	<cffunction name='envia_email_ane_prog_car' displayname='Envia email no momento em que  anexado um ou mais arquivos a programao de carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_envia_email_ane_prog_car' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>    
    
    
	<!--- 
    -- PROPSITO
    -- Insere um anexo
    -- ANDERSONC 14/01/2010 14:57:28 - CRIADO
    --->
    <cffunction name='ins_anexo' displayname='Insere um anexo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTEUDO' required='yes'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='EXTENSAO' required='yes'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ANEXO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_BLOB'   value='#arguments.CONTEUDO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.EXTENSAO#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo inserido com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
        
    <!--- 
	-- PROPSITO
	-- Insere um anexo a uma programao
	-- ANDERSONC 14/01/2010 15:00:10 - CRIADO
	--->
	<cffunction name='ins_programacao_anexo' displayname='Insere um anexo a uma programao' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_programacao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo inserido com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um anexo a um embarque
	-- ANDERSONC 14/01/2010 15:08:04 - CRIADO
	--->
	<cffunction name='ins_embarque_anexo' displayname='Insere um anexo a um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_embarque_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo inserido com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>    
    
        
    <!--- 
	-- PROPSITO
	-- Enviar um e-mail quando insere um anexo no embarque
	-- FABIOG 02/08/2011 13:59:38 - CRIADO
	--->
	<cffunction name='envia_email_anexo_reg_emb' displayname='Enviar um e-mail quando insere um anexo no embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_envia_email_anexo_reg_emb' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um anexo de uma programao
	-- ANDERSONC 14/01/2010 15:06:05 - CRIADO
	--->
	<cffunction name='del_programacao_anexo' displayname='Exclui um anexo de uma programao' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_programacao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Exclui um anexo de um embarque
	-- ANDERSONC 14/01/2010 15:08:55 - CRIADO
	--->
	<cffunction name='del_embarque_anexo' displayname='Exclui um anexo de um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_embarque_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um anexo
    -- ANDERSONC 14/01/2010 14:58:43 - CRIADO
    --->
    <cffunction name='del_anexo' displayname='Exclui um anexo' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANEXO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>            
    
	
	<!--- 
	-- PROPSITO
	-- Exclui um embarque
	-- ANDERSONC 08/09/2009 15:47:54 - CRIADO
	--->
	<cffunction name='del_viagem_embarque' displayname='Exclui um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_viagem_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Embarque excludo com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera um embarque
    -- ANDERSONC 14/01/2010 14:47:17 - CRIADO
    --->
    <cffunction name='upd_viagem_embarque' displayname='Altera um embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='MANIFESTO_ID' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='PLACA_CAVALO' required='yes'>
        <cfargument name='PLACA_CARRETA' required='yes'>
        <cfargument name='DATA_SAIDA' required='yes'>
        <cfargument name='PREVISAO_CHEGADA_FRONTEIRA' required='yes'>
        <cfargument name='FRONTEIRA_ID' required='yes'>
        <cfargument name='COD_DESPACHANTE_ORIGEM' required='yes'>
        <cfargument name='COD_DESPACHANTE_DESTINO' required='yes'>
        <cfargument name='FACTURA' required='yes'>
        <cfargument name='SD' required='yes'>
        <cfargument name='TRAS' required='yes'>
        <cfargument name='PE' required='yes'>
        <cfargument name='DI' required='yes'>
        <cfargument name='DTA' required='yes'>
        <cfargument name='TRANSBORDO' required='yes'>
        <cfargument name='LOCAL_TRANSBORDO_ID' required='yes'>
        <cfargument name='DATA_DESCARGA_TRANSBORDO' required='yes'>
        <cfargument name='DATA_CARGA_TRANSBORDO' required='yes'>
        <cfargument name='PLACA_CAVALO_TRANSBORDO' required='yes'>
        <cfargument name='PLACA_CARRETA_TRANSBORDO' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='PROGRAMADO_PARA' required='yes'>
        <cfargument name='NUM_PEDIDO' required='yes'>
        <cfargument name='SOLICITACAO_CRUZE' required='yes'>
        <cfargument name='NUM_LOTE' required='no'>
        <cfargument name='DATA_CHEGADA_MIC' required='no'>
        <cfargument name='DATA_SOL_SENHA' required='no'>
        <cfargument name='DATA_LIB_SENHA' required='no'>
        <cfargument name='DATA_CHEGADA_ADUANA' required='no'>
        <cfargument name='DATA_SAIDA_ADUANA' required='no'>
        <cfargument name='DATA_INICIO_TRANSBORDO' required='no'>        
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_intc_viagem.prc_alt_viagem_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SAIDA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PREVISAO_CHEGADA_FRONTEIRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESPACHANTE_ORIGEM#'  null='#iif(len(trim(arguments.COD_DESPACHANTE_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESPACHANTE_DESTINO#'  null='#iif(len(trim(arguments.COD_DESPACHANTE_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FACTURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SD#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TRAS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DI#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DTA#'  null='#iif(len(trim(arguments.DTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TRANSBORDO#'  null='#iif(len(trim(arguments.TRANSBORDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LOCAL_TRANSBORDO_ID#'  null='#iif(len(trim(arguments.LOCAL_TRANSBORDO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_DESCARGA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CARGA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PROGRAMADO_PARA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_PEDIDO#'  null='#iif(len(trim(arguments.NUM_PEDIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SOLICITACAO_CRUZE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_LOTE#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CHEGADA_MIC#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SOL_SENHA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_LIB_SENHA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CHEGADA_ADUANA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SAIDA_ADUANA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_TRANSBORDO#' >                      
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Embarque alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>        

	<!--- 
    -- PROPSITO
    -- Registra um embarque
    -- ANDERSONC 11/01/2010 15:54:10 - CRIADO
    --->
    <cffunction name='ins_viagem_embarque' displayname='Registra um embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROGRAMACAO_ID' required='yes'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='MANIFESTO_ID' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='PLACA_CAVALO' required='yes'>
        <cfargument name='PLACA_CARRETA' required='yes'>
        <cfargument name='DATA_SAIDA' required='yes'>
        <cfargument name='PREVISAO_CHEGADA_FRONTEIRA' required='yes'>
        <cfargument name='FRONTEIRA_ID' required='yes'>
        <cfargument name='COD_DESPACHANTE_ORIGEM' required='yes'>
        <cfargument name='COD_DESPACHANTE_DESTINO' required='yes'>
        <cfargument name='FACTURA' required='yes'>
        <cfargument name='SD' required='yes'>
        <cfargument name='TRAS' required='yes'>
        <cfargument name='PE' required='yes'>
        <cfargument name='DI' required='yes'>
        <cfargument name='DTA' required='yes'>
        <cfargument name='TRANSBORDO' required='yes'>
        <cfargument name='LOCAL_TRANSBORDO_ID' required='yes'>
        <cfargument name='DATA_DESCARGA_TRANSBORDO' required='yes'>
        <cfargument name='DATA_CARGA_TRANSBORDO' required='yes'>
        <cfargument name='PLACA_CAVALO_TRANSBORDO' required='yes'>
        <cfargument name='PLACA_CARRETA_TRANSBORDO' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='LISTA_EMAIL' required='yes'>
        <cfargument name='PROGRAMADO_PARA' required='no'>
        <cfargument name='NUM_PEDIDO' required='no'>
        <cfargument name='SOLICITACAO_CRUZE' required='no'>
        <cfargument name='NUM_LOTE' required='no'>
        <cfargument name='DATA_CHEGADA_MIC' required='no'>
        <cfargument name='DATA_SOL_SENHA' required='no'>
        <cfargument name='DATA_LIB_SENHA' required='no'>
        <cfargument name='DATA_CHEGADA_ADUANA' required='no'>
        <cfargument name='DATA_SAIDA_ADUANA' required='no'>
        <cfargument name='DATA_INICIO_TRANSBORDO' required='no'>                                        
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_viagem_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_VIAGEM' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EMBARQUE_ID' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#' variable='retorno.VIAGEM_ID'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SAIDA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PREVISAO_CHEGADA_FRONTEIRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESPACHANTE_ORIGEM#'  null='#iif(len(trim(arguments.COD_DESPACHANTE_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESPACHANTE_DESTINO#'  null='#iif(len(trim(arguments.COD_DESPACHANTE_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FACTURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SD#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TRAS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DI#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DTA#'  null='#iif(len(trim(arguments.DTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TRANSBORDO#'  null='#iif(len(trim(arguments.TRANSBORDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LOCAL_TRANSBORDO_ID#'  null='#iif(len(trim(arguments.LOCAL_TRANSBORDO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_DESCARGA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CARGA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LISTA_EMAIL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PROGRAMADO_PARA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_PEDIDO#'  null='#iif(len(trim(arguments.NUM_PEDIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SOLICITACAO_CRUZE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_LOTE#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CHEGADA_MIC#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SOL_SENHA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_LIB_SENHA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CHEGADA_ADUANA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SAIDA_ADUANA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_TRANSBORDO#' >                                                                                
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Embarque registrado com sucesso  viagem N ' & retorno.NUM_VIAGEM & '.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
	-- PROPSITO
	-- Exclui uma viagem
	-- ANDERSONC 02/10/2009 09:42:10 - CRIADO
	--->
	<cffunction name='del_viagem' displayname='Exclui uma viagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='VIAGEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Viagem excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>    
    
	<!--- 
	-- PROPSITO
	-- Altera os dados do manifesto internacional (MIC/DTA)
	-- ANDERSON 17/07/2009 - ALTERADO
	--->
	<cffunction name='upd_intc_manifesto' displayname='Altera os dados do manifesto internacional (MIC/DTA)' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='TRANSITO_ADUANEIRO' required='no' default="0">
		<cfargument name='COD_TRANSPORTADOR' required='yes'>
		<cfargument name='TRANSP_NOME' required='yes'>
		<cfargument name='TRANSP_ENDERECO' required='yes'>
		<cfargument name='TRANSP_MUNICIPIO_ID' required='yes'>
		<cfargument name='TRANSP_DADOS_ADICIONAIS' required='yes'>
		<cfargument name='TRANSP_CNPJ_CPF' required='yes'>
		<cfargument name='ALFANDEGA_ORIGEM_ID' required='yes'>
		<cfargument name='DESTINO_LOCAL' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_COD_PESSOA' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_NOME' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_ENDERECO' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_CNPJ_CPF' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_CONTROLE' required='yes'>
		<cfargument name='VEIC_ORIG_MARCA' required='yes'>
		<cfargument name='VEIC_ORIG_CHASSIS' required='yes'>
		<cfargument name='VEIC_ORIG_CAPACIDADE' required='yes'>
		<cfargument name='VEIC_ORIG_ANO' required='yes'>
		<cfargument name='VEIC_ORIG_TIPO' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_REFERENCIA' required='yes'>
		<cfargument name='VEIC_ORIG_MOT_COD_PESSOA' required='yes'>
		<cfargument name='VEIC_SUBST_PROP_COD_PESSOA' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_NOME' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_ENDERECO' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_MUNICIPIO_ID' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_CNPJ_CPF' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_CONTROLE' required='no' default="">
		<cfargument name='VEIC_SUBST_MARCA' required='no' default="">
		<cfargument name='VEIC_SUBST_CHASSIS' required='no' default="">
		<cfargument name='VEIC_SUBST_CAPACIDADE' required='no' default="">
		<cfargument name='VEIC_SUBST_ANO' required='no' default="">
		<cfargument name='VEIC_SUBST_TIPO' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_REFERENCIA' required='no' default="">
		<cfargument name='VEIC_SUBST_MOT_COD_PESSOA' required='no' default="">
		<cfargument name='NUM_DTA_ROTA' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ROMANEIO_ITEM_ID' required='no' default="">
        <cfargument name='EN_LASTRE' required='no' default="0">
        <cfargument name='ANEXO' required='no' default="">
        <cfargument name='MIC_COD_PAIS' required='no' default="">
        <cfargument name='MIC_NUM_PERMISSO' required='no' default="">
        <cfargument name='MIC_NUMERO' required='no' default="">
        <cfargument name='MIC_SERIE' required='no' default="">
        
        <cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#UCase(arguments.MIC_COD_PAIS)#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MIC_NUM_PERMISSO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MIC_NUMERO#'   null="#iif(len(trim(arguments.MIC_NUMERO)), de('no'), de('yes'))#">
                    <cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.TRANSITO_ADUANEIRO#'  null='#iif(len(trim(arguments.TRANSITO_ADUANEIRO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.TRANSP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.TRANSP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.TRANSP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.TRANSP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.TRANSP_DADOS_ADICIONAIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.TRANSP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ALFANDEGA_ORIGEM_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DESTINO_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VEIC_ORIG_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_ORIG_PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_ORIG_PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VEIC_ORIG_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_ORIG_PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#UCase(Replace(arguments.VEIC_ORIG_PLACA_CONTROLE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_ORIG_MARCA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_ORIG_CHASSIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_double'    value='#arguments.VEIC_ORIG_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_ORIG_CAPACIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VEIC_ORIG_ANO#'  null='#iif(len(trim(arguments.VEIC_ORIG_ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VEIC_ORIG_TIPO#'  null='#iif(len(trim(arguments.VEIC_ORIG_TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_ORIG_PLACA_REFERENCIA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VEIC_ORIG_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VEIC_SUBST_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_SUBST_PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_SUBST_PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VEIC_SUBST_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_SUBST_PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#UCase(Replace(arguments.VEIC_SUBST_PLACA_CONTROLE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_SUBST_MARCA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_SUBST_CHASSIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_double'    value='#arguments.VEIC_SUBST_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_SUBST_CAPACIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VEIC_SUBST_ANO#'  null='#iif(len(trim(arguments.VEIC_SUBST_ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VEIC_SUBST_TIPO#'  null='#iif(len(trim(arguments.VEIC_SUBST_TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.VEIC_SUBST_PLACA_REFERENCIA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VEIC_SUBST_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.NUM_DTA_ROTA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ROTA_ID#' null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ROMANEIO_ITEM_ID#'  null='#iif(len(trim(arguments.ROMANEIO_ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.EN_LASTRE#'  null='#iif(len(trim(arguments.EN_LASTRE)), de('no'), de('yes'))#'>
                    <cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.ANEXO#' >
                    <cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MIC_SERIE#'  null='#iif(len(trim(arguments.MIC_SERIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
                <cfset retorno.manifesto_id = arguments.manifesto_id>
				<!--- Alteraes dos Items --->
				<cfscript>
					v_nro_crt = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NUMERO_CRT_ITEMS");
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "ITEM_CONHECIMENTO_ID_ITEMS");
					v_id = 				this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ITEMS");
					v_item_id =			this.ListaToArray (lista = arguments, variavel = "ITEM_IT_ID_ITEMS");
					v_quantidade = 		this.ListaToArray (lista = arguments, variavel = "ITEM_QUANTIDADE_ITEMS");
					v_peso_bruto = 		this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_BRUTO_ITEMS");
					v_peso_liquido = 	this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_LIQUIDO_ITEMS");
					v_valor_total = 	this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_TOTAL_ITEMS");
					v_seguro = 			this.ListaToArray (lista = arguments, variavel = "ITEM_SEGURO_ITEMS");
					v_num_especie = 	this.ListaToArray (lista = arguments, variavel = "ITEM_NUM_ESPECIE_ITEMS");
					v_descricao = 		this.ListaToArray (lista = arguments, variavel = "ITEM_DESCRICAO_ITEMS");
					v_ncm = 			this.ListaToArray (lista = arguments, variavel = "ITEM_NCM_ITEMS");
					v_pais_id_origem  = this.ListaToArray (lista = arguments, variavel = "ITEM_PAIS_ID_ORIGEM");
					v_valor_fot = 		this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_FOT_ITEMS");
					v_nro_lacres = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NRO_LACRES_ITEMS");
					v_anexos = 			this.ListaToArray (lista = arguments, variavel = "ITEM_ANEXOS_ITEMS");
					v_cod_remetente = 	this.ListaToArray (lista = arguments, variavel = "COD_REMETENTE_ITEMS");
					v_rem_nome =		this.ListaToArray (lista = arguments, variavel = "REM_NOME_ITEMS");
					v_rem_local =		this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_UF_PAIS_ITEMS");
					v_rem_municipio_id =this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_ID_ITEMS");
					
               v_item_excluir     = this.ListDiff(lista1 = arguments.lista_deleted_ITEMS, lista2 = ArrayToList(v_item_id));
					
					// TOTAIS
					v_pagina              = this.ListaToArray (lista = arguments, variavel = "PAGINA");
					v_campo42             = this.ListaToArray (lista = arguments, variavel = "CAMPO42");
					v_campo43             = this.ListaToArray (lista = arguments, variavel = "CAMPO43");
					v_campo44             = this.ListaToArray (lista = arguments, variavel = "CAMPO44");
					v_campo45             = this.ListaToArray (lista = arguments, variavel = "CAMPO45");
					v_campo46             = this.ListaToArray (lista = arguments, variavel = "CAMPO46");
					v_campo47             = this.ListaToArray (lista = arguments, variavel = "CAMPO47");
				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_pagina)#" index="count">
					<cfscript>
					//altera
					this.upd_intc_manifesto_pagina(	manifesto_id 		= arguments.manifesto_id,
													pagina			 	= v_pagina[count],
													campo42 		 	= v_campo42[count],
													campo43 		 	= v_campo43[count],
													campo44 		 	= v_campo44[count],
													campo45 		 	= v_campo45[count],
													campo46 		 	= v_campo46[count],
													campo47 		 	= v_campo47[count]);
					</cfscript>
				</cfloop>			
				
				<!--- Excluir os itens --->
				<cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_intc_manifesto_item (manifesto_id = arguments.manifesto_id,
												      item_id   = l_item_id);
													  
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
					if(not len(trim(v_item_id[count]))) {
						//caso o item_id seja nulo insere
						this.ins_intc_manifesto_item(	manifesto_id 		= arguments.manifesto_id,
													conhecimento_id 		= v_conhecimento_id[count],
													alfandega_destino_id    = arguments.alfandega_destino_id,
													item_id 				= v_id[count],
													quantidade				= v_quantidade[count],
													peso_bruto				= v_peso_bruto[count],
													peso_liquido			= v_peso_liquido[count],
													valor_total				= v_valor_total[count],
													valor_seguro			= v_seguro[count],
													num_especie				= v_num_especie[count],
													mercadorias				= v_descricao[count],
													numero_lacres			= v_nro_lacres[count],
													valor_fot				= v_valor_fot[count],
													ncm						= v_ncm[count],
													pais_id_origem			= v_pais_id_origem[count],
													anexo					= v_anexos[count],
													cod_remetente			= v_cod_remetente[count],
													rem_nome				= v_rem_nome[count],
													rem_local				= v_rem_local[count],
													rem_municipio_id		= v_rem_municipio_id[count],
													en_lastre				= arguments.en_lastre);
													
						
					} else {
						//senao altera
						this.upd_intc_manifesto_item(	manifesto_id 		= arguments.manifesto_id,
													conhecimento_id 		= v_conhecimento_id[count],
													item_id 				= v_id[count],
													alfandega_destino_id    = arguments.alfandega_destino_id,
													quantidade				= v_quantidade[count],
													peso_bruto				= v_peso_bruto[count],
													peso_liquido			= v_peso_liquido[count],
													valor_total				= v_valor_total[count],
													valor_seguro			= v_seguro[count],
													num_especie				= v_num_especie[count],
													mercadorias				= v_descricao[count],
													numero_lacres			= v_nro_lacres[count],
													valor_fot				= v_valor_fot[count],
													ncm						= v_ncm[count],
													pais_id_origem			= v_pais_id_origem[count],
													item_id					= v_item_id[count],
													anexo					= v_anexos[count],
													cod_remetente			= v_cod_remetente[count],
													rem_nome				= v_rem_nome[count],
													rem_local				= v_rem_local[count],
													rem_municipio_id		= v_rem_municipio_id[count],
													en_lastre				= arguments.en_lastre);
					}
					</cfscript>
				</cfloop>			
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MIC/DTA alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
        
	
	<!--- 
	-- PROPSITO
	-- Altera dados dos totais da pagina do MIC
	-- GUTO 30/01/2006 10:34:41 - CRIADO
	--->
	<cffunction name='upd_intc_manifesto_pagina' displayname='Altera dados dos totais da pagina do MIC' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='PAGINA' required='yes'>
		<cfargument name='CAMPO42' required='yes'>
		<cfargument name='CAMPO43' required='yes'>
		<cfargument name='CAMPO44' required='yes'>
		<cfargument name='CAMPO45' required='yes'>
		<cfargument name='CAMPO46' required='yes'>
		<cfargument name='CAMPO47' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_manifesto_pagina' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.PAGINA#'  null='#iif(len(trim(arguments.PAGINA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO42#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO43#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO44#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO45#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO46#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CAMPO47#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Altera um item de CRT do MIC/DTA
	-- CRISTOFER 15/12/2005 - criado
	--->
	<cffunction name='upd_intc_manifesto_item' displayname='Altera um item de CRT do MIC/DTA' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='ALFANDEGA_DESTINO_ID' required='no' default=''>
		<cfargument name='COD_MOEDA' required='no' default=''>
		<cfargument name='ORIGEM_LOCAL' required='no' default=''>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='VALOR_FOT' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='VALOR_SEGURO' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PESO_BRUTO' required='yes'>
		<cfargument name='PESO_LIQUIDO' required='yes'>
		<cfargument name='UNIDADE_ID' required='no' default='Kg'>
		<cfargument name='COD_REMETENTE' required='no' default=''>
		<cfargument name='REM_NOME' required='no' default=''>
		<cfargument name='REM_LOCAL' required='no' default=''>
		<cfargument name='REM_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='COD_DESTINATARIO' required='no' default=''>
		<cfargument name='DEST_NOME' required='no' default=''>
		<cfargument name='DEST_LOCAL' required='no' default=''>
		<cfargument name='DEST_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='COD_CONSIGNATARIO' required='no' default=''>
		<cfargument name='CONS_NOME' required='no' default=''>
		<cfargument name='CONS_LOCAL' required='no' default=''>
		<cfargument name='CONS_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='NUMERO_LACRES' required='yes'>
		<cfargument name='MERCADORIAS' required='yes'>
		<cfargument name='NCM' required='yes'>
		<cfargument name='PAIS_ID_ORIGEM' required='yes'>
		<cfargument name='ANEXO' required='yes'>
		<cfscript>
			conn = CreateObject("component", "_transportes.consulta.cfc_transp_internacional");
			qrConhecimento = conn.get_intc_conhecimento_item_mic(argumentCollection = arguments);
		</cfscript>	
		<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_manifesto_crt_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ALFANDEGA_DESTINO_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_DESTINO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.COD_MOEDA#'  null='#iif(len(trim(qrConhecimento.COD_MOEDA)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#qrConhecimento.ORIGEM_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.VALOR_FOT#'  null='#iif(len(trim(arguments.VALOR_FOT)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.VALOR_SEGURO#'  null='#iif(len(trim(arguments.VALOR_SEGURO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.PESO_BRUTO#'  null='#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.PESO_LIQUIDO#'  null='#iif(len(trim(arguments.PESO_LIQUIDO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.UNIDADE_ID#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.COD_DESTINATARIO#'  null='#iif(len(trim(qrConhecimento.COD_DESTINATARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#qrConhecimento.DEST_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#qrConhecimento.DEST_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(qrConhecimento.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.COD_CONSIGNATARIO#'  null='#iif(len(trim(qrConhecimento.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#qrConhecimento.CONS_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#qrConhecimento.CONS_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#qrConhecimento.CONS_MUNICIPIO_ID#'  null='#iif(len(trim(qrConhecimento.CONS_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.NUMERO_LACRES#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MERCADORIAS#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.NCM#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.pais_id_origem#' null='#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#'>
			
			<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.ANEXO#' >
		</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>         

	
	<!--- 
	-- PROPSITO
	-- Exclui um item de CRT do MIC/DTA
	-- CRISTOFER 13/12/2005 - criado
	--->
	<cffunction name='del_intc_manifesto_item' displayname='Exclui um item de CRT do MIC/DTA' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_manifesto_crt_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
		</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>
               
    
	<!--- 
    -- PROPSITO
    -- Emitir nova carta de porte.
    -- JAQUELINEF 12/08/2013 15:25:17 - CRIADO
    --->
    <cffunction name='ins_carta_porte' displayname='Emitir nova carta de porte.' access='remote' returntype='Struct' output='true'>
        <cfargument name='MIC' required='yes'>
        <cfargument name='CRT' required='yes'>
                <cfstoredproc procedure='fiscal.pkg_carta_porte.prc_ins_carta_porte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MIC#'  null='#iif(len(trim(arguments.MIC)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CRT#'  null='#iif(len(trim(arguments.CRT)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Alterar carta de porte.
    -- JAQUELINEF 12/08/2013 15:26:21 - CRIADO
    --->
    <cffunction name='alt_carta_porte' displayname='Alterar carta de porte.' access='remote' returntype='Struct' output='true'>
        <cfargument name='MIC' required='yes'>
        <cfargument name='CRT' required='yes'>
                <cfstoredproc procedure='fiscal.pkg_carta_porte.prc_alt_carta_porte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MIC#'  null='#iif(len(trim(arguments.MIC)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CRT#'  null='#iif(len(trim(arguments.CRT)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
<!--- 
	-- PROPSITO
	-- Excluir uma carta de porte.
	-- JAQUELINEF 12/08/2013 15:27:19 - CRIADO
	--->
	<cffunction name='del_carta_porte' displayname='Excluir uma carta de porte.' access='remote' returntype='Struct' output='true'>
        <cfargument name='MIC' required='yes'>
        <cfargument name='CRT' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_carta_porte.prc_del_carta_porte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MIC#'  null='#iif(len(trim(arguments.MIC)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CRT#'  null='#iif(len(trim(arguments.CRT)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Gerar PDF das Cartas de Porte do MIC
    -- JAQUELINEF 12/08/2013 16:54:00 - CRIADO
    --->
    <cffunction name='gera_cartas_porte' displayname='Gerar PDF dos documentos dos motoristas' access='remote' returntype='Struct' output='true'>
        <cfargument name='MIC' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_carta_porte.prc_gera_cartas_porte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MIC#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cartas de Porte gerradas com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>        
    
	<!--- 
    -- PROPSITO
    -- Inserir as Divises do CRT
    -- JAQUELINEF 13/02/2014 14:54:00 - CRIADO
    --->
    <cffunction name='ins_divisao' displayname='Inserir as Divises do CRT' access='remote' returntype='Struct' output='true'>    
    
			<cfscript>
                v_divisao_controle_id = this.ListaToArray(lista = arguments, variavel = "DIVISAO_CONTROLE_ID_DIVISAO");
                v_num_embarque        = this.ListaToArray(lista = arguments, variavel = "NUM_EMBARQUE_DIVISAO");
                v_divisao_embarque_id = this.ListaToArray(lista = arguments, variavel = "EMBARQUE_ID_DIVISAO");
                v_divisao_id          = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ID_DIVISAO");
                v_embarque_data       = this.ListaToArray(lista = arguments, variavel = "EMBARQUE_DATA_DIVISAO");
                v_placa_controle      = this.ListaToArray(lista = arguments, variavel = "PLACA_CONTROLE_DIVISAO");
                v_placa_referencia_composicao = this.ListaToArray(lista = arguments, variavel = "PLACA_REFERENCIA_COMPOSICAO_DIVISAO");
                v_divisao_cod_motorista       = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_MOTORISTA_DIVISAO");
                v_divisao_motorista           = this.ListaToArray(lista = arguments, variavel = "DIVISAO_MOTORISTA_DIVISAO");
                v_divisao_cod_pessoa_motorista = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_PESSOA_MOTORISTA_DIVISAO");
                v_divisao_rota_abreviatura     = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ROTA_ABREVIATURA_DIVISAO");
                v_divisao_rota_id    = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ROTA_ID_DIVISAO");
                v_divisao_km         = this.ListaToArray(lista = arguments, variavel = "DIVISAO_KM_DIVISAO");
                v_divisao_percentual = this.ListaToArray(lista = arguments, variavel = "DIVISAO_PERCENTUAL_DIVISAO");
                v_divisao_cod_moeda  = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_MOEDA_DIVISAO");
                v_divisao_valor      = this.ListaToArray(lista = arguments, variavel = "DIVISAO_VALOR_DIVISAO");
                v_divisao_data      = this.ListaToArray(lista = arguments, variavel = "DIVISAO_DATA_DIVISAO");
                v_embarque_excluir   = this.ListDiff(lista1 = arguments.lista_deleted_DIVISAO, lista2 = ArrayToList(v_divisao_embarque_id));
                v_divisao_excluir   = this.ListDiff(lista1 = arguments.lista_deleted_DIVISAO, lista2 = ArrayToList(v_divisao_id));
             </cfscript>
    
            <!--- Excluir os itens --->
            <!---<cfloop list="#v_embarque_excluir#" delimiters="," index="l_item_id">
                <cfscript>
                    set_embarque = this.del_intc_crt_embarque(embarque_id = l_item_id);
                </cfscript>

                <cfif set_embarque.erro>
                    <cfthrow object="#set_embarque.MENSAGEM#"/>
                </cfif>    
            </cfloop>---> 
            
            <cfloop list="#v_divisao_excluir#" delimiters="," index="l_item_id">
                <cfscript>
                    set_divisao = this.del_embarque_divisao(divisao_id = l_item_id);
                </cfscript>

                <cfif set_divisao.erro>
                   	<cfset retorno.erro = true>
                    <cfthrow object="#set_divisao.MENSAGEM#"/>
                </cfif>    
            </cfloop>            
            
            <cfset v_embarque = 0>
            <cfset v_embarque_id = 0>
            <cfloop from="1" to="#ArrayLen(v_num_embarque)#" index="count">
                 <cfscript>
                    if (v_embarque neq v_num_embarque[count])  {
                        // Registra embarque
                        v_embarque = v_num_embarque[count];
                        
                        if(not len(trim(v_divisao_embarque_id[count]))) {
                            //caso o item_id seja nulo insere
                            set_embarque = this.ins_intc_crt_embarque( conhecimento_id = retorno.conhecimento_id,
                                                                      data_embarque = v_embarque_data[count]);
                            
                            v_embarque_id = set_embarque.embarque_id;
                        } else {
                            //senao altera
                            set_embarque = this.upd_intc_crt_embarque( conhecimento_id = retorno.conhecimento_id,
                                                                      embarque_id     = v_divisao_embarque_id[count],
                                                                      data_embarque   = v_embarque_data[count]);
                            v_embarque_id = v_divisao_embarque_id[count];
                        }
                    }
                 </cfscript>


                 <cfif IsDefined("set_embarque") and set_embarque.erro>
                   	<cfset retorno.erro = true>
                    <cfthrow object="#set_embarque.Mensagem#">
                 </cfif>
                 
                <cfscript>
                    if(not len(trim(v_divisao_id[count]))) {
                        //caso o item_id seja nulo insere
                        set_divisao = this.ins_embarque_divisao( valor                = v_divisao_valor[count]
                                                                ,cod_moeda            = v_divisao_cod_moeda[count] 
                                                                ,percentual_crt       = v_divisao_percentual[count] 
                                                                ,rota_id              = v_divisao_rota_id[count] 
                                                                ,cod_pessoa_motorista = v_divisao_cod_pessoa_motorista[count] 
                                                                ,embarque_id          = v_embarque_id
                                                                ,data_divisao 		  = v_divisao_data[count] 
                                                               );
                        
                        if (not set_divisao.erro) {
                           v_divisao_id[count] = set_divisao.divisao_id;
                        }
                    } 
// AGORA DEVE-SE EXCLUIR E DEPOIS INSERIR PARA EDITAR						
//                      else {
//							//senao altera
//							set_divisao = this.upd_embarque_divisao( divisao_id			  = v_divisao_id[count]
//																	,valor                = v_divisao_valor[count]
//																	,cod_moeda            = v_divisao_cod_moeda[count] 
//																	,percentual_crt       = v_divisao_percentual[count] 
//																	,rota_id              = v_divisao_rota_id[count] 
//																	,cod_pessoa_motorista = v_divisao_cod_pessoa_motorista[count] 
//																	,embarque_id          = v_embarque_id
//																   );
//						}
                 </cfscript>            
                          
                 <cfif isDefined("set_divisao") and  set_divisao.erro>
                   	<cfset retorno.erro = true>                 
                    <cfthrow object="#set_divisao.Mensagem#">
                 </cfif>

                <!---Exclui composicao--->
                <cfscript>
                    set_divisao_comp = this.del_embarque_divisao_comp(divisao_id = v_divisao_id[count]);
                </cfscript>
                <cfif set_divisao_comp.erro>
                   	<cfset retorno.erro = true>                
                    <cfthrow object="#set_divisao_comp.Mensagem#">
                </cfif>
                
                <!---Insere todas as composies--->
                <cfscript>	
                    // Insere cavalo
                    if(len(trim(v_placa_controle[count]))) {
                    set_divisao_comp = this.ins_embarque_divisao_comp( ordem                = 0
                                                                      ,placa                = v_placa_controle[count]
                                                                      ,divisao_id           = v_divisao_id[count] 
                                                                     );
                    }
                 </cfscript>            
                          
                 <cfif set_divisao_comp.erro>
                   	<cfset retorno.erro = true>                 
                    <cfthrow object="#set_divisao_comp.Mensagem#">
                 </cfif>

                 <cfset v_ordem = 1>
                 <cfloop list="#v_placa_referencia_composicao[count]#" index="l_placa" delimiters=",">
                        <cfscript>	
                            // Insere cavalo
                            if(len(trim(v_placa_controle[count]))) {
                            set_divisao_comp = this.ins_embarque_divisao_comp( ordem                = v_ordem
                                                                              ,placa                = l_placa
                                                                              ,divisao_id           = v_divisao_id[count] 
                                                                             );
                            }
                         </cfscript>            
                         <cfset v_ordem = v_ordem + 1>

                         <cfif set_divisao_comp.erro>
	                    	<cfset retorno.erro = true>
                            <cfthrow object="#set_divisao_comp.Mensagem#">
                         </cfif>
                 </cfloop>
            </cfloop>    
        <cfset retorno.erro = false>    
        <cfreturn retorno />
    </cffunction>   
    
	<!--- 
    -- PROPSITO
    -- Inserir itinerrio do CRT
    -- JAQUELINEF 13/02/2014 14:54:00 - CRIADO
    --->
    <cffunction name='ins_itinerarios' displayname='Inserir itinerrio do CRT' access='remote' returntype='Struct' output='true'>    
    
			<cfscript>
                v_rota_id        = this.ListaToArray(lista = arguments, variavel = "ITINERARIO_ROTA_ID_ITINERARIO");
                v_ordem          = this.ListaToArray(lista = arguments, variavel = "ITINERARIO_ORDEM_ITINERARIO");
                v_itinerario_id  = this.ListaToArray(lista = arguments, variavel = "ITINERARIO_ID_ITINERARIO");				
                v_itinerario_del = this.ListDiff(lista1 = arguments.lista_deleted_ITINERARIO, lista2 = ArrayToList(v_itinerario_id));
             </cfscript>
            <cfloop list="#v_itinerario_del#" delimiters="," index="i">
                <cfscript>
                    ret = this.del_itinerario(itinerario_id = i);
                </cfscript>

                <cfif ret.erro>
                   	<cfset retorno.erro = true>
                    <cfthrow object="#ret.MENSAGEM#"/>
                </cfif>    
            </cfloop>            
                         
            <cfloop from="1" to="#ArrayLen(v_rota_id)#" index="i">
            	<cfif v_ordem[i] eq ArrayLen(v_rota_id)>
                	<cfset v_ultima = 1>
                <cfelse>
                	<cfset v_ultima = 0>
                </cfif>
            	<cfscript>
					ret = this.ins_itinerario_crt(CONHECIMENTO_ID = arguments.conhecimento_id
												, ROTA_ID         = v_rota_id[i]
												, ORDEM           = v_ordem[i]
												, ULTIMA          = v_ultima);
				</cfscript>
				 <cfif ret.erro>
                    <cfset retorno.erro = true>
                    <cfthrow object="#ret.Mensagem#">
                 </cfif>                
            </cfloop>
		<cfset retorno.erro = false>  
        <cfreturn retorno />
    </cffunction>     
        
	<!--- 
    -- PROPSITO
    -- Vincula a divisao do CRT ao CTE originario
    -- guto 18/11/2013 14:16:26 - CRIADO
    --->
    <cffunction name='vincula_cte_crt' displayname='Vincula a divisao do CRT ao CTE originario' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='CTE_ID' required='yes'>
        <cfargument name='PESO' required='yes'>     
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_vincula_cte_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CTE_ID#'  null='#iif(len(trim(arguments.CTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>                    
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('CTe viculado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>          
        
	<!--- 
    -- PROPSITO
    -- Inserir itinerrio do CRT
    -- JAQUELINEF 13/02/2014 14:54:00 - CRIADO
    --->
    <cffunction name='ins_cte_crt' displayname='Inserir itinerrio do CRT' access='remote' returntype='Struct' output='true'>    
    
			<cfscript>
                v_cte_id   = this.ListaToArray(lista = arguments, variavel = "CTE_ID");
                v_peso_cte = this.ListaToArray(lista = arguments, variavel = "CTE_PESO");
             </cfscript>
            <cfloop from="1" to="#ArrayLen(v_cte_id)#" index="i">
            	<cfscript>
                    ret = this.vincula_cte_crt(CONHECIMENTO_ID = arguments.conhecimento_id
										     , CTE_ID		   = v_cte_id[i]
											 , PESO			   = v_peso_cte[i]);
				</cfscript>
				 <cfif ret.erro>
                    <cfset retorno.erro = true>
                    <cfthrow object="#ret.Mensagem#">
                 </cfif>                
            </cfloop>             

		<cfset retorno.erro = false>  
        <cfreturn retorno />
    </cffunction>          
        
	<!--- 
    -- PROPSITO
    -- Inserir itinerario do CRT
    -- jaquelinef 13/02/2014 16:23:56 - CRIADO
    --->
    <cffunction name='ins_itinerario_crt' displayname='Inserir itinerario do CRT' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='ROTA_ID' required='yes'>
        <cfargument name='ORDEM' required='yes'>
        <cfargument name='ULTIMA' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_itinerario_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ULTIMA#'  null='#iif(len(trim(arguments.ULTIMA)), de('no'), de('yes'))#'>
                </cfstoredproc> 
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Composio excluda com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>       
        <cfreturn retorno />
    </cffunction>        

<!--- 
-- PROPSITO
-- Excluir uma rota do itinerrio do CRT.
-- jaquelinef 14/02/2014 10:03:26 - CRIADO
--->
<cffunction name='del_itinerario' displayname='Excluir uma rota do itinerrio do CRT.' access='remote' returntype='Struct' output='true'>
	<cfargument name='ITINERARIO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_itinerario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITINERARIO_ID#'  null='#iif(len(trim(arguments.ITINERARIO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Itinerrio excludo com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

   <!--- 
	-- PROPSITO
	-- Exclui um manifesto internacional (MIC/DTA)
	-- CRISTOFER 13/12/2005 - criado
	--->
	<cffunction name='del_intc_manifesto' displayname='Exclui um manifesto internacional (MIC/DTA)' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MIC/DTA excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Cancela um manifesto internacional (MIC/DTA)
	-- GUTO 03/03/2006 - criado
	--->
	<cffunction name='can_intc_manifesto' displayname='Cancela um manifesto internacional (MIC/DTA)' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='no' default="">
		
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_can_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.MOTIVO_CANCELAMENTO#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MIC/DTA cancelado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- /* Insere um novo DTI */
	-- GUTO 16/12/2005 - criado
	--->
	<cffunction name='ins_intc_despacho' displayname='/* Insere um novo DTI */' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_DESPACHO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_PESSOA_EMISSAO' required='yes'>
		<cfargument name='LOCAL_EMISSAO' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='ORIGEM_LOCAL' required='yes'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_LOCAL' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REM_NOME' required='yes'>
		<cfargument name='REM_CNPJ' required='yes'>
		<cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='REM_ENDERECO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_NOME' required='yes'>
		<cfargument name='DEST_CNPJ' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='NOTAS_FISCAIS' required='yes'>
		<cfargument name='VALOR_MERCADORIA' required='yes'>
		<cfargument name='VALOR_MERCADORIA_COD_MOEDA' required='no' default="">
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PESO_BRUTO' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_NOME' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_MUNICIPIO_ID' required='yes'>
		<cfargument name='PROP_CERT_PROPRIEDADE' required='yes'>
		<cfargument name='PROP_RTB' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='MOT_NOME' required='yes'>
		<cfargument name='MOT_CPF' required='yes'>
		<cfargument name='MOT_ENDERECO' required='yes'>
		<cfargument name='MOT_MUNICIPIO_ID' required='yes'>
		<cfargument name='MOT_CNH' required='yes'>
		<cfargument name='MOT_CNH_VALIDADE' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='PLACA_REBOQUE' required='yes'>
		<cfargument name='PESO_A_PAGAR' required='yes'>
		<cfargument name='VALOR_POR_KG' required='yes'>
		<cfargument name='VALOR_SERVICO' required='yes'>
		<cfargument name='VALOR_CARGA_DESCARGA' required='yes'>
		<cfargument name='VALOR_FRONTEIRA' required='yes'>
		<cfargument name='VALOR_IRRF' required='yes'>
		<cfargument name='VALOR_ADIANTAMENTO' required='yes'>
		<cfargument name='VALOR_ICMS_RETIDO' required='yes'>
		<cfargument name='VALOR_LIQUIDO' required='yes'>
		<cfargument name='VALOR_FALTA_AVARIAS' required='yes'>
		<cfargument name='VALOR_ADICIONAL' required='yes'>
		<cfargument name='DESCRICAO_VALOR_ADICIONAL' required='yes'>
		<cfargument name='LIQUIDO_A_PAGAR' required='yes'>
		<cfargument name='COTACAO_DOLAR' required='yes'>
		<cfargument name='NUM_DEPENDENTES' required='yes'>
		<cfargument name='BASE_CALC_IRRF' required='yes'>
		<cfargument name='OUTRAS_DEDUCOES' required='yes'>
		<cfargument name='DESCARGA_POR_CONTA_ID' required='yes'>
		<cfargument name='OBSERVACOES' required='yes'>
		<cfargument name='AUTORIZAR_PAGTO_POR' required='no' default="0">
		<cfargument name='AUTORIZAR_PAGTO_DATA' required='yes'>
		<cfargument name='AUTORIZAR_ADTO_POR' required='no' default="0">
		<cfargument name='AUTORIZAR_ADTO_DATA' required='yes'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cfargument name='CONDICAO_PAGTO' required='no'>	
		<cfargument name="TIPO" required="no" default="1">
		<cfargument name='OPERACAO_VALOR_ADICIONAL' required='no' default="1">
        <cfargument name='SERIE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_intc_despacho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.NUM_DESPACHO#'  null='#iif(len(trim(arguments.NUM_DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.LOCAL_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.ORIGEM_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DESTINO_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_CNPJ#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DEST_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DEST_CNPJ#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.NOTAS_FISCAIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_MERCADORIA#'  null='#iif(len(trim(arguments.VALOR_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.VALOR_MERCADORIA_COD_MOEDA#'  null='#iif(len(trim(arguments.VALOR_MERCADORIA_COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.PESO_BRUTO#'  null='#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.PROP_CERT_PROPRIEDADE#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.PROP_RTB#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOT_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOT_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOT_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MOT_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MOT_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOT_CNH#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOT_CNH_VALIDADE#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#UCase(REReplace(arguments.PLACA_TRACAO,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#UCase(REReplace(arguments.PLACA_REBOQUE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'   value='#arguments.PESO_A_PAGAR#'  null='#iif(len(trim(arguments.PESO_A_PAGAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_POR_KG#'  null='#iif(len(trim(arguments.VALOR_POR_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_CARGA_DESCARGA#'  null='#iif(len(trim(arguments.VALOR_CARGA_DESCARGA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_FRONTEIRA#'  null='#iif(len(trim(arguments.VALOR_FRONTEIRA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_IRRF#'  null='#iif(len(trim(arguments.VALOR_IRRF)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_ADIANTAMENTO#'  null='#iif(len(trim(arguments.VALOR_ADIANTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_ICMS_RETIDO#'  null='#iif(len(trim(arguments.VALOR_ICMS_RETIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_LIQUIDO#'  null='#iif(len(trim(arguments.VALOR_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_FALTA_AVARIAS#'  null='#iif(len(trim(arguments.VALOR_FALTA_AVARIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_ADICIONAL#'  null='#iif(len(trim(arguments.VALOR_ADICIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DESCRICAO_VALOR_ADICIONAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.LIQUIDO_A_PAGAR#'  null='#iif(len(trim(arguments.LIQUIDO_A_PAGAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.COTACAO_DOLAR#'  null='#iif(len(trim(arguments.COTACAO_DOLAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.NUM_DEPENDENTES#'  null='#iif(len(trim(arguments.NUM_DEPENDENTES)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.BASE_CALC_IRRF#'  null='#iif(len(trim(arguments.BASE_CALC_IRRF)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.OUTRAS_DEDUCOES#'  null='#iif(len(trim(arguments.OUTRAS_DEDUCOES)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DESCARGA_POR_CONTA_ID#'  null='#iif(len(trim(arguments.DESCARGA_POR_CONTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.OBSERVACOES#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.AUTORIZAR_PAGTO_POR#'  null='#iif(len(trim(arguments.AUTORIZAR_PAGTO_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.AUTORIZAR_PAGTO_DATA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.AUTORIZAR_ADTO_POR#'  null='#iif(len(trim(arguments.AUTORIZAR_ADTO_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.AUTORIZAR_ADTO_DATA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.TIPO#' >
					<cfprocparam type='inout' cfsqltype='cf_sql_integer'  value='#arguments.DESPACHO_ID#' variable='retorno.DESPACHO_ID' null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='out' cfsqltype='cf_sql_varchar'  variable='retorno.ROWID' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.OPERACAO_VALOR_ADICIONAL#'   null='#iif(len(trim(arguments.OPERACAO_VALOR_ADICIONAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
	
				<cfset arguments.despacho_id = retorno.despacho_id>
	
				<cfif IsDefined("arguments.CONDICAO_PAGTO") and Len(Trim(arguments.CONDICAO_PAGTO))>
					<cfloop list="#arguments.CONDICAO_PAGTO#" index="i" delimiters=",">
						<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_dti_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#retorno.DESPACHO_ID#'>
							<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#i#'>
						</cfstoredproc>
					</cfloop>
				</cfif>
	
				<!--- Inseres dos Items --->
				<cfscript>
					v_manifesto_id        = this.ListaToArray (lista = arguments, variavel = "MANIFESTO_ID_MIC");
					v_mic_crt_mic         = this.ListaToArray (lista = arguments, variavel = "MIC_CRT_MIC");
					v_conhecimento_id     = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_ID_CRT");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_manifesto_id)#" index="count">
					<cfscript>
							ret = this.ins_intc_dti_item(	despacho_id 		= arguments.despacho_id,
													conhecimento_id     = v_mic_crt_mic[count],
													manifesto_id		= v_manifesto_id[count]);
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
				</cfloop>				
	
				<cfloop from="1" to="#ArrayLen(v_conhecimento_id)#" index="count">
					<cfscript>
						ret = this.ins_intc_dti_item(	despacho_id 		= arguments.despacho_id,
												conhecimento_id     = v_conhecimento_id[count],
												manifesto_id		= '');
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
					
				</cfloop>				
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('D.T.I. inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera dados do DTI cadastrado
	-- GUTO 16/12/2005 - criado
	--->
	<cffunction name='upd_intc_despacho' displayname='Altera dados do DTI cadastrado' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cfargument name='NUM_DESPACHO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_PESSOA_EMISSAO' required='yes'>
		<cfargument name='LOCAL_EMISSAO' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='ORIGEM_LOCAL' required='yes'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_LOCAL' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REM_NOME' required='yes'>
		<cfargument name='REM_CNPJ' required='yes'>
		<cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='REM_ENDERECO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_NOME' required='yes'>
		<cfargument name='DEST_CNPJ' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='NOTAS_FISCAIS' required='yes'>
		<cfargument name='VALOR_MERCADORIA' required='yes'>
		<cfargument name='VALOR_MERCADORIA_COD_MOEDA' required='no' default="">
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PESO_BRUTO' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_NOME' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_MUNICIPIO_ID' required='yes'>
		<cfargument name='PROP_CERT_PROPRIEDADE' required='yes'>
		<cfargument name='PROP_RTB' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='MOT_NOME' required='yes'>
		<cfargument name='MOT_CPF' required='yes'>
		<cfargument name='MOT_ENDERECO' required='yes'>
		<cfargument name='MOT_MUNICIPIO_ID' required='yes'>
		<cfargument name='MOT_CNH' required='yes'>
		<cfargument name='MOT_CNH_VALIDADE' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='PLACA_REBOQUE' required='yes'>
		<cfargument name='PESO_A_PAGAR' required='yes'>
		<cfargument name='VALOR_POR_KG' required='yes'>
		<cfargument name='VALOR_SERVICO' required='yes'>
		<cfargument name='VALOR_CARGA_DESCARGA' required='yes'>
		<cfargument name='VALOR_FRONTEIRA' required='yes'>
		<cfargument name='VALOR_IRRF' required='yes'>
		<cfargument name='VALOR_ADIANTAMENTO' required='yes'>
		<cfargument name='VALOR_ICMS_RETIDO' required='yes'>
		<cfargument name='VALOR_LIQUIDO' required='yes'>
		<cfargument name='VALOR_FALTA_AVARIAS' required='yes'>
		<cfargument name='VALOR_ADICIONAL' required='yes'>
		<cfargument name='DESCRICAO_VALOR_ADICIONAL' required='yes'>
		<cfargument name='LIQUIDO_A_PAGAR' required='yes'>
		<cfargument name='COTACAO_DOLAR' required='yes'>
		<cfargument name='NUM_DEPENDENTES' required='yes'>
		<cfargument name='BASE_CALC_IRRF' required='yes'>
		<cfargument name='OUTRAS_DEDUCOES' required='yes'>
		<cfargument name='DESCARGA_POR_CONTA_ID' required='yes'>
		<cfargument name='OBSERVACOES' required='yes'>
		<cfargument name='AUTORIZAR_PAGTO_POR' required='yes' default="0">
		<cfargument name='AUTORIZAR_PAGTO_DATA' required='yes'>
		<cfargument name='AUTORIZAR_ADTO_POR' required='yes' default="0">
		<cfargument name='AUTORIZAR_ADTO_DATA' required='yes'>
		<cfargument name='TIPO' required='no' default="1">
		<cfargument name='OPERACAO_VALOR_ADICIONAL' required='no' default="1">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_intc_despacho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DESPACHO_ID#'  null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.NUM_DESPACHO#'  null='#iif(len(trim(arguments.NUM_DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.LOCAL_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.ORIGEM_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DESTINO_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_CNPJ#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.REM_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DEST_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DEST_CNPJ#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.NOTAS_FISCAIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_MERCADORIA#'  null='#iif(len(trim(arguments.VALOR_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'     value='#arguments.VALOR_MERCADORIA_COD_MOEDA#'  null='#iif(len(trim(arguments.VALOR_MERCADORIA_COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.PESO_BRUTO#'  null='#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.PROP_CERT_PROPRIEDADE#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.PROP_RTB#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOT_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOT_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOT_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MOT_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MOT_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOT_CNH#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOT_CNH_VALIDADE#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#UCase(REReplace(arguments.PLACA_TRACAO,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#UCase(REReplace(arguments.PLACA_REBOQUE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.PESO_A_PAGAR#'  null='#iif(len(trim(arguments.PESO_A_PAGAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_POR_KG#'  null='#iif(len(trim(arguments.VALOR_POR_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_CARGA_DESCARGA#'  null='#iif(len(trim(arguments.VALOR_CARGA_DESCARGA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_FRONTEIRA#'  null='#iif(len(trim(arguments.VALOR_FRONTEIRA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_IRRF#'  null='#iif(len(trim(arguments.VALOR_IRRF)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_ADIANTAMENTO#'  null='#iif(len(trim(arguments.VALOR_ADIANTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_ICMS_RETIDO#'  null='#iif(len(trim(arguments.VALOR_ICMS_RETIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_LIQUIDO#'  null='#iif(len(trim(arguments.VALOR_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_FALTA_AVARIAS#'  null='#iif(len(trim(arguments.VALOR_FALTA_AVARIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.VALOR_ADICIONAL#'  null='#iif(len(trim(arguments.VALOR_ADICIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'     value='#arguments.DESCRICAO_VALOR_ADICIONAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.LIQUIDO_A_PAGAR#'  null='#iif(len(trim(arguments.LIQUIDO_A_PAGAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.COTACAO_DOLAR#'  null='#iif(len(trim(arguments.COTACAO_DOLAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.NUM_DEPENDENTES#'  null='#iif(len(trim(arguments.NUM_DEPENDENTES)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.BASE_CALC_IRRF#'  null='#iif(len(trim(arguments.BASE_CALC_IRRF)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'     value='#arguments.OUTRAS_DEDUCOES#'  null='#iif(len(trim(arguments.OUTRAS_DEDUCOES)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DESCARGA_POR_CONTA_ID#'  null='#iif(len(trim(arguments.DESCARGA_POR_CONTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.OBSERVACOES#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.AUTORIZAR_PAGTO_POR#'  null='#iif(len(trim(arguments.AUTORIZAR_PAGTO_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.AUTORIZAR_PAGTO_DATA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.AUTORIZAR_ADTO_POR#'  null='#iif(len(trim(arguments.AUTORIZAR_ADTO_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.AUTORIZAR_ADTO_DATA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.TIPO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.OPERACAO_VALOR_ADICIONAL#'   null='#iif(len(trim(arguments.OPERACAO_VALOR_ADICIONAL)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.DESPACHO_ID = arguments.DESPACHO_ID>
				<cfscript>
					v_id_mic              = this.ListaToArray (lista = arguments, variavel = "MIC_ITEM_ID_MIC");
					v_id_crt              = this.ListaToArray (lista = arguments, variavel = "CRT_ITEM_ID_CRT");
					v_manifesto_id        = this.ListaToArray (lista = arguments, variavel = "MANIFESTO_ID_MIC");
					v_mic_crt_mic         = this.ListaToArray (lista = arguments, variavel = "MIC_CRT_MIC");
					v_conhecimento_id     = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_ID_CRT");
					v_item_excluir_mic    = this.ListDiff(lista1 = arguments.lista_deleted_MIC, lista2 = ArrayToList(v_id_mic));
					v_item_excluir_crt    = this.ListDiff(lista1 = arguments.lista_deleted_CRT, lista2 = ArrayToList(v_id_crt));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_item_excluir_mic#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_intc_dti_item(item_id   = l_item_id);
					</cfscript>
				</cfloop>
	
				<cfloop list="#v_item_excluir_crt#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_intc_dti_item(item_id   = l_item_id);
					</cfscript>
				</cfloop>
	
				
				<!--- Insere Itens --->
				<cfloop from="1" to="#ArrayLen(v_manifesto_id)#" index="count">
					<cfscript>
						if(not len(trim(v_id_mic[count]))) {
							//caso o item_id seja nulo insere
							ret = this.ins_intc_dti_item(	despacho_id 		= arguments.despacho_id,
													conhecimento_id     = v_mic_crt_mic[count],
													manifesto_id		= v_manifesto_id[count]);
						} else {
							//caso o item_id seja nulo insere
							ret = this.upd_intc_dti_item(	item_id 		= v_id_mic[count],
													conhecimento_id = v_mic_crt_mic[count],
													manifesto_id	= v_manifesto_id[count]);
						}
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>

				</cfloop>				
	
				<cfloop from="1" to="#ArrayLen(v_conhecimento_id)#" index="count">
					<cfscript>
						if(not len(trim(v_id_crt[count]))) {
							//caso o item_id seja nulo insere
							ret = this.ins_intc_dti_item(	despacho_id 	= arguments.despacho_id,
													conhecimento_id = v_conhecimento_id[count],
													manifesto_id	= '');
						} else {
							ret = this.upd_intc_dti_item(	item_id 		= v_id_crt[count],
													conhecimento_id = v_conhecimento_id[count],
													manifesto_id	= '');
						}							
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
				</cfloop>				
				
	
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('D.T.I. alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um DTI
	-- GUTO 19/12/2005 - criado
	--->
	<cffunction name='del_intc_despacho' displayname='Exclui um DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_intc_despacho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DESPACHO_ID#'  null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('D.T.I. excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Cancela um DTI
	-- GUTO 03/03/2006 - criado
	--->
	<cffunction name='can_intc_despacho' displayname='Exclui um DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='no' default="">
		<cfdump var="#arguments#">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_can_intc_despacho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DESPACHO_ID#'  null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   value='#arguments.MOTIVO_CANCELAMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('D.T.I. cancelado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Insere item ao DTI
	-- GUTO 19/12/2005 - criado
	--->
	<cffunction name='ins_intc_dti_item' displayname='Insere item ao DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='no'>
		<cfargument name='MANIFESTO_ID' required='no'>
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_dti_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.DESPACHO_ID#'  null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso!')>		
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera item do DTI
	-- GUTO 19/12/2005 - criado
	--->
	<cffunction name='upd_intc_dti_item' displayname='Altera item do DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_dti_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item do DTI alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Exclui item do dti
	-- GUTO 19/12/2005 - criado
	--->
	<cffunction name='del_intc_dti_item' displayname='Exclui item do dti' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_dti_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='in' cfsqltype='cf_sql_integer'   value='#arguments.ITEM_ID#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Item excluido com sucesso!')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Vincula aduana ao CRT
	-- Alex 02/10/2017
	--->
	<cffunction name='ins_crt_aduana' displayname='Vincula aduana ao CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='ADUANA_ID' required='yes'>
		<cfargument name='ADUANA_ORDEM' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_conhecimento_aduana' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC'  variable='retorno.CONHECIMENTO_ADUANA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ADUANA_ID#'  null='#iif(len(trim(arguments.ADUANA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ADUANA_ORDEM#'  null='#iif(len(trim(arguments.ADUANA_ORDEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera vinculo aduana ao CRT
	-- Alex 02/10/2017
	--->
	<cffunction name='alt_crt_aduana' displayname='Altera vinculo aduana ao CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ADUANA_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='ADUANA_ID' required='yes'>
		<cfargument name='ADUANA_ORDEM' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_conhecimento_aduana' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ADUANA_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ADUANA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ADUANA_ID#'  null='#iif(len(trim(arguments.ADUANA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ADUANA_ORDEM#'  null='#iif(len(trim(arguments.ADUANA_ORDEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui vinculo aduana ao CRT
	-- Alex 02/10/2017
	--->
	<cffunction name='del_crt_aduana' displayname='Exclui vinculo aduana ao CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ADUANA_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_conhecimento_aduana' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONHECIMENTO_ADUANA_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ADUANA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

</cfcomponent>
