<cfcomponent displayname="Componentes de Veculos"
		     hint="<b>KM&M  de Engenharia de Sistemas</b><br>
				   <b>Autor					: Guto ( guto@kmm.com.br )</b><br>
				   <b>Data Criao</b> 		: 07/12/2004<br> 
				   <b>Atualizador			: </b><br>
				   <b>Data Atualizao</b> 	: <br> 
				   <b>Descrio				: </b><br> <div align='justify'>Componente de consultas sobre veculos.</div>"
		     extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Retorna todas as marcas de veculos cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
    
	<cffunction name="get_marcas" displayname="Retorna todas as marcas de veculos cadastradas" output="true" returntype="query" access="public">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="marca" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select marca_id, marca
			  from oper.v$veiculo_marca
			 where 1=1
			 <cfif Len(Trim(arguments.marca_id))>
				 and marca_id = #arguments.marca_id#
			 </cfif>
			 <cfif Len(Trim(arguments.marca))>
				 and upper(marca) like upper('#arguments.marca#%')
			 </cfif>
			order by marca
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	<!--- 
	-- PROPSITO
	-- Retorna todos os modelos de veculos cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_modelos" displayname="Retorna todos os modelos de veculos cadastradas" output="true" returntype="query" access="remote">
		<cfargument name="marca_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select vm.marca_id, vm.modelo_id, vm.modelo, vm.tipo_carroceria_id, vm.tipo_id, vt.tipo,
				   vm.combustivel_id, vm.ano_lancto, vm.km_revisao, vm.tara, vm.capacidade, 
				   vm.eixo, vm.eixo_suspenso, vm.qtde_pneus, vm.qtde_pneus_estepe, vm.capacidade_tanque, 
				   vm.capacidade_m3, vm.observacao, vm.cavalo_potencia
			  from oper.v$veiculo_modelo vm
	         inner join oper.v$veiculo_tipo vt 
               on vt.tipo_id = vm.tipo_id
             where 1=1			  
			<cfif Len(Trim(arguments.marca_id))>
			   and marca_id = #arguments.marca_id#
			</cfif>		
			order by modelo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    	
	<!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="placa_exa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="frota_exa" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7"> 
		<!---Terceiros--->	
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct vd.veiculo_id, vd.placa,
                    vd.cod_veiculo,
                    vd.num_rastreador,
                    vd.rastreador_id,
                    vd.rastreador_com_problemas,
                    vd.marca_id,
                    vd.marca,
                    vd.modelo_id,
                    vd.situacao_id,
                    vd.uf,
                    vd.capacidade_tanque,
                    oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(vd.placa,sysdate) capacidade,
                    vd.km_revisao,
                    vd.modelo,
                    vd.proprietario,
                    vd.observacao,
                    vd.cor_predominante,
                    vd.ano,
                    vd.chassis,
                    vd.renavan,
                    va.agrupamento_id,
                    va.descricao as agrupamento,
                    vtc.tipo_carroceria_id,
               		vtc.descricao as tipo_carroceria,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TAG_CTF') as tag_ctf,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TARA') as tara,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'COMBUSTIVEL') as combustivel,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'NUMERO_EIXOS') as numero_eixos,
                    va.tracao,
                    vd.municipio_id,
                    (select municipio
                       from cep.municipio m
                      where m.municipio_id = vd.municipio_id) as municipio,
                    vd.tipo_carroceria_id,
                    vtc.descricao as tipo
              from oper.v$veiculo_dados vd
              left join oper.v$veiculo_tipo_carroceria vtc
                     on vd.tipo_carroceria_id = vtc.tipo_carroceria_id
              left join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
              left join oper.v$veiculo_proprietario vp on vp.placa = vd.placa
                                                      and vp.data_fim is null
             where 1 = 1			  
			<cfif Len(Trim(arguments.placa))>
			   and vd.placa like upper('%#arguments.placa#%')
			</cfif>		
			<cfif Len(Trim(arguments.placa_exa))>
			   and upper(vd.placa) = '#arguments.placa_exa#'
			</cfif>	
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vd.cod_veiculo) like upper('#arguments.cod_veiculo#%')
			</cfif>		
			<cfif Len(Trim(arguments.proprietario))>
			   and vd.proprietario in (#arguments.proprietario#)
			</cfif>		
			<cfif Len(Trim(arguments.frota))>
			   and (vd.placa like upper('#arguments.frota#%')
			       or vd.cod_veiculo like upper('#arguments.frota#%'))
			</cfif>	
			<cfif Len(Trim(arguments.frota_exa))>
			   and (upper(vd.placa) = '#arguments.frota_exa#'
			       or upper(vd.cod_veiculo) = '#arguments.frota_exa#')
			</cfif>		
			order by vd.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->
    	
	<cffunction name="get_veiculo_placa_frota" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="placa_exa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="frota_exa" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7"> 
		<!---Terceiros--->	
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select 
                	p.placa 
                from oper.v$veiculo p 
                where 1=1		  
			<cfif Len(Trim(arguments.placa))>
			   and (p.placa = upper('#arguments.placa#')
			       or p.cod_veiculo = upper('#arguments.placa#'))                 
			</cfif>			
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    		
	
	<!--- 
	-- PROPSITO
	-- Retorna a relao de veiculos ativos na data
	-- NOTAS EXPLICATIVAS
	--  
	-- 13/01/2006 - criado
	--->
	<cffunction name="get_veiculos_ativos" access="remote" returntype="query" output="true">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_veiculos" username="#session.usuario#" password="#session.senha#">
			select decode(vl.empresa,1,'Frota','Agregado') as proprietario, vl.placa, vl.marca, vl.modelo, vl.combustivel 
			 from oper.v$veiculo_empresa_liberado vl
			where 1=1
			<cfif len(trim(arguments.placa))>
			and vl.placa = upper('#arguments.placa#')
			</cfif>
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vl.cod_veiculo) like upper('#arguments.cod_veiculo#%')
			</cfif>		
			order by 1
  		</cfquery>	
		<cfreturn qr_veiculos>
	</cffunction>	
	
	<!---
	-- PROPSITO
	-- Retorna dados do proprietrio do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->
	<cffunction name="get_veiculo_proprietario" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select v.placa
              , p.cliente as nome
              , p.cnpj_cpf
              , p.identificador
              , to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
              , vp.cod_pessoa
              , v.chassis
              , m.marca
              , md.modelo
              , v.ano
              , oper.pkg_veiculo.fnc_capacidade_carga_compo(v.placa, sysdate)             as capacidade
              , oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'CAPACIDADE_TRACAO') as capacidade_tracao
              , oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'TARA')              as tara
              , oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'TAG_CTF')           as tag_ctf
              , kss.pkg_atributo.fnc_get_atributo(p.cod_pessoa, 6) as permisso_numero
              , kss.pkg_atributo.fnc_get_atributo(p.cod_pessoa, 7) as permisso_data
              , kss.pkg_atributo.fnc_get_atributo(p.cod_pessoa, 8) as apolice_numero
              , kss.pkg_atributo.fnc_get_atributo(p.cod_pessoa, 9) as apolice_vencimento
              , decode(p.tipo_pessoa
                      ,2 /*Estrangeira*/
                      ,pes.endereco
                      ,pe.logradouro || decode(pe.numero, '', '', ', ') ||
                       pe.numero || decode(pe.complemento, '', '', ' - ') ||
                       pe.complemento) endereco
              , pe.municipio as local
              , cep.fnc_municipio_uf(pe.municipio_id) municipio_uf
              , pe.municipio_id
              , va.tracao
              , oper.pkg_veiculo.fnc_veiculo_proprietario(v.placa) proprietario
              , p.rntrc_tac
           from oper.v$veiculo v
          inner join oper.v$veiculo_proprietario vp
             on vp.placa = v.placa
            and vp.data_fim is null
          inner join kss.v$pessoa p
             on p.cod_pessoa = vp.cod_pessoa
           left join kss.v$pessoa_estrangeira pes
             on pes.cod_pessoa = p.cod_pessoa
           left join kss.v$pessoa_endereco pe
             on pe.cod_pessoa = p.cod_pessoa
            and pe.endereco_padrao = 1
           left join oper.v$veiculo_marca m
             on m.marca_id = v.marca_id
           left join oper.v$veiculo_modelo md
             on md.marca_id = v.marca_id
            and md.modelo_id = v.modelo_id
           left join oper.v$veiculo_tipo_carroceria vtc
             on v.tipo_carroceria_id = vtc.tipo_carroceria_id
           left join oper.v$veiculo_agrupamento va
             on va.agrupamento_id = vtc.agrupamento_id
          where 1 = 1
			
         <cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
            and vp.placa = upper('#arguments.placa#')
			</cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
   
	<!--- 
	-- PROPSITO
	-- Retorna dados do proprietrio do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_proprietario_doc" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="public">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa, p.nome, p.cnpj_cpf, p.identificador, vp.data_inicio, vp.cod_pessoa,
		 		    v.chassis, m.marca, v.ano, md.capacidade,
					p.endereco,	p.municipio as local, p.municipio_uf, p.municipio_id					
	           from oper.v$veiculo v
		  left join oper.v$veiculo_marca m
				 on m.marca_id = v.marca_id
		  left join oper.v$veiculo_modelo md
				 on md.marca_id = v.marca_id
				and md.modelo_id = v.modelo_id
		 inner join oper.v$veiculo_proprietario_doc vp
				 on vp.placa = v.placa
				and vp.data_fim is null 
		 inner join oper.v$proprietario p
				 on p.cod_pessoa = vp.cod_pessoa        
			  where 1=1				  
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = upper('#arguments.placa#')
			</cfif>		
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
    
	<!--- 
	-- PROPSITO
	-- Retorna dados do proprietrio do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_motorista" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfargument name="data" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa, 
             		p.cliente as nome, 
                    p.cnpj_cpf, 
                    p.identificador, 
                    to_char(vp.data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio, 
                    vp.cod_pessoa,
		 		    v.chassis, 
                    m.marca, 
                    v.ano, 
                    oper.pkg_veiculo.fnc_capacidade_carga_compo(v.placa, sysdate) capacidade,
					decode(p.tipo_pessoa,2/*Estrangeira*/, pes.endereco, pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento) as endereco,
                    pe.municipio as local, 
                    cep.fnc_municipio_uf(pe.municipio_id) as municipio_uf, 
                    pe.municipio_id,
		            pf.cart_ident_num, 
                    pf.cart_ident_orgao
	           from oper.v$veiculo v
		 inner join oper.v$veiculo_motorista vp
		         on vp.placa = v.placa
                <cfif not len(trim(arguments.data))>
			    and vp.data_fim is null 
                </cfif>
		 inner join kss.v$pessoa p
		         on p.cod_pessoa = vp.cod_pessoa        
          left join kss.v$pessoa_endereco pe on pe.cod_pessoa = p.cod_pessoa and pe.endereco_padrao = 1
          left join kss.v$pessoa_estrangeira pes
                 on pes.cod_pessoa = p.cod_pessoa
          left join kss.v$pessoa_fisica pf 
                 on pf.cod_pessoa = p.cod_pessoa
	      left join oper.v$veiculo_marca m
			     on m.marca_id = v.marca_id
		  left join oper.v$veiculo_modelo md
                 on md.marca_id = v.marca_id
                and md.modelo_id = v.modelo_id
              where 1=1
            <cfif len(trim(arguments.data))>
                and '#arguments.data#' between vp.data_inicio and nvl(vp.data_fim,sysdate)
            </cfif>			  
			<cfif Len(Trim(arguments.placa))>
			    and vp.placa = upper('#arguments.placa#')
			</cfif>		
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Retorna dados do permissionario do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_permissionario" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="public">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa, 
             		p.cliente as nome, 
                    p.razao_social, 
                    p.cnpj_cpf, 
                    p.identificador, 
                    vp.data_inicio, 
                    vp.cod_pessoa,
		 		    v.chassis, 
                    m.marca, 
                    v.ano, 
                    oper.pkg_veiculo.fnc_capacidade_carga_compo(v.placa,sysdate) as capacidade,
					decode(p.tipo_pessoa,2/*Estrangeira*/, pes.endereco, pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento) endereco,
                    pe.municipio as local, 
                    cep.fnc_municipio_uf(pe.municipio_id) municipio_uf, 
                    pe.municipio_id,
					kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 6) as permisso_numero,
					kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 7) as permisso_data,
					kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 8) as apolice_numero,
					kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9) as apolice_vencimento
                    ,oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'TARA') as tara,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'CAPACIDADE_TRACAO') as capacidade_tracao
					,trunc(sysdate - to_date(decode(kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9),'0', to_char(sysdate,'dd/mm/yyyy'),kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9)), 'dd/mm/yyyy')) as dias_venc_apolice
	           from oper.v$veiculo v
		 inner join oper.v$veiculo_permissionario vp
				 on vp.placa = v.placa
				and nvl(vp.data_fim,sysdate) >= sysdate
		 inner join kss.v$pessoa p
				 on p.cod_pessoa = vp.cod_pessoa        
          left join kss.v$pessoa_estrangeira pes
                 on pes.cod_pessoa = p.cod_pessoa
          left join kss.v$pessoa_endereco pe
                 on pe.cod_pessoa = vp.cod_pessoa
                and pe.endereco_padrao = 1
		  left join oper.v$veiculo_marca m
				 on m.marca_id = v.marca_id
		  left join oper.v$veiculo_modelo md
				 on md.marca_id = v.marca_id
				and md.modelo_id = v.modelo_id
			  where 1=1				  
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = upper('#arguments.placa#')
			</cfif>		
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna dados da proxima reviso do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_proxima_revisao" displayname="Retorna dados da proxima reviso do veculo" output="true" returntype="query" access="public">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select vr.controle_id, vr.placa, vr.km_revisao, vr.data_revisao, vr.matriz, vr.motivo, 
				   vr.date_update, decode(vr.user_update,'OPER','Sistema',vr.user_update) as user_update
			  from oper.v$veiculo_revisao vr
			 where vr.data_revisao = (select max(vr2.data_revisao)
			                            from oper.v$veiculo_revisao vr2
									   where vr2.placa = vr.placa) 
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
		       and vr.placa = upper('#arguments.placa#')
			</cfif>		
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Busca os dados para o servio contratado
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 07/12/2005 - criado
	--->	
	<cffunction name="get_motorista_proprietario" displayname="Busca os dados para o servio contratado" access="remote" returntype="struct" output="false">
		<cfargument name="placa_controle" required="yes">
		<cfargument name="data_emissao" required="no" default="#LSDateFormat(now())# #TimeFormat(now(),'HH:MM:SS')#">
        <cfargument name="trata_erro" required="no" default="0">
			<cftry>
				<cfscript>
					qrVeiculo = this.get_composicao(cod_veiculo = arguments.placa_controle);
				</cfscript>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_motorista.prc_get_motorista_proprietario" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#Replace(qrVeiculo.placa,'-','')#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#arguments.data_emissao#">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnpj_prop">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.endereco">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cidade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.uf">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.proprietario_municipio_id">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cpf_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.nome_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_date"     variable="retorno.cnh_validade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnh_numero">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.pis_pasep_nit">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.retorno">
				</cfstoredproc>
                
				<cfset retorno.veiculo_proprietario = qrVeiculo.veiculo_proprietario>
				
				<cfscript>
					qrVeiculo = this.get_veiculo(placa = arguments.placa_controle);
				</cfscript>
                
				<cfset retorno.tag_ctf = qrVeiculo.tag_ctf>
                <cfset retorno.erro = false>
			<cfcatch>
            	<cfif arguments.trata_erro eq 0>
	            	<cfthrow detail="#cfcatch.Detail#">
                </cfif>
            	<cfif arguments.trata_erro eq 2>
					<cfset retorno.mensagem = cfcatch>
                    <cfset retorno.erro = true>
                </cfif>
            	<cfif arguments.trata_erro eq 1>
					<cfset retorno = StructNew()>
                    <cfset retorno.cod_pessoa_proprietario = ''>
                    <cfset retorno.proprietario = 'Problemas com o veculo.'>
                    <cfset retorno.cnpj_prop = ''>
                    <cfset retorno.endereco = ''>
                    <cfset retorno.cidade = ''>
                    <cfset retorno.uf = ''>
                    <cfset retorno.proprietario_municipio_id = ''>
                    <cfset retorno.cod_pessoa_motorista = ''>
                    <cfset retorno.nome_motorista = ''>
                    <cfset retorno.cnh_validade = ''>
                    <cfset retorno.cnh_numero = ''>
                    <cfset retorno.pis_pasep_nit = ''>
                    <cfset retorno.retorno = ''>
                </cfif>
			</cfcatch>
			</cftry>
			<cfset retorno.placa = arguments.placa_controle>
		<cfreturn retorno>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca os dados para o servio contratado
	-- NOTAS EXPLICATIVAS
	--  
	-- RAFAEL 03/01/2011 - CRIADO
	--->	
	<cffunction name="get_motorista_prop_doc" displayname="Busca os dados para o servio contratado" access="remote" returntype="struct" output="false">
		<cfargument name="placa_controle" required="yes">
		<cfargument name="data_emissao" required="no" default="#LSDateFormat(now())# #TimeFormat(now(),'HH:MM:SS')#">
        <cfargument name="trata_erro" required="no" default="0">
			<cftry>
				<cfscript>
					qrVeiculo = this.get_composicao(cod_veiculo = arguments.placa_controle);
				</cfscript>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_motorista.prc_get_motorista_prop_doc" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#Replace(qrVeiculo.placa,'-','')#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#arguments.data_emissao#">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnpj_prop">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.endereco">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cidade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.uf">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.proprietario_municipio_id">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cpf_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.nome_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_date"     variable="retorno.cnh_validade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnh_numero">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.pis_pasep_nit">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.retorno">
				</cfstoredproc>
                
				<cfset retorno.veiculo_proprietario = qrVeiculo.veiculo_proprietario>

				<cfscript>
					qrVeiculo = this.get_veiculo(placa = arguments.placa_controle);
				</cfscript>
                
				<cfset retorno.tag_ctf = qrVeiculo.tag_ctf>
                <cfset retorno.erro = false>
			<cfcatch>
            	<cfif arguments.trata_erro eq 0>
	            	<cfthrow detail="#cfcatch.Detail#">
                </cfif>
            	<cfif arguments.trata_erro eq 2>
					<cfset retorno.mensagem = cfcatch>
                    <cfset retorno.erro = true>
                </cfif>
            	<cfif arguments.trata_erro eq 1>
					<cfset retorno = StructNew()>
                    <cfset retorno.cod_pessoa_proprietario = ''>
                    <cfset retorno.proprietario = 'Problemas com o veculo.'>
                    <cfset retorno.cnpj_prop = ''>
                    <cfset retorno.endereco = ''>
                    <cfset retorno.cidade = ''>
                    <cfset retorno.uf = ''>
                    <cfset retorno.proprietario_municipio_id = ''>
                    <cfset retorno.cod_pessoa_motorista = ''>
                    <cfset retorno.nome_motorista = ''>
                    <cfset retorno.cnh_validade = ''>
                    <cfset retorno.cnh_numero = ''>
                    <cfset retorno.pis_pasep_nit = ''>
                    <cfset retorno.retorno = ''>
                </cfif>
			</cfcatch>
			</cftry>
			<cfset retorno.placa = arguments.placa_controle>
		<cfreturn retorno>
	</cffunction>	
    
	<!--- 
	-- PROPSITO 
	-- Busca a capacidade da composio
	-- CRISTOFER  12/06/2006
	--->		
	<cffunction name="get_capacidade" access="remote" returntype="numeric" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_operacional.fnc_converte_peso(oper.pkg_veiculo.fnc_capacidade_carga('#arguments.placa#'), 'Kg','TON') as capacidade 
			  from dual
		</cfquery>
		<cfreturn qr_result.capacidade>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca a romaneio do veculo na data
	-- GUTO 02/11/2006
	--->		
	<cffunction name="get_romaneio_data" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfargument name="data" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_operacional.FNC_ROMANEIO_PLACA_CONTROLE('#arguments.placa#','#arguments.data#') as num_romaneio
			  from dual
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca a capacidade da composio
	-- CRISTOFER  12/06/2006
	--->		
	<cffunction name="get_situacao_composicao" access="remote" returntype="struct" output="true">
		<cfargument name="placa_controle" required="yes">
		<cfargument name="placa_referencia" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transporte.prc_verifica_composicao" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.placa_controle#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.placa_referencia#">
				<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.resultado">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Items verificados com sucesso!">
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>	
		</cftry>
		<cfreturn retorno>	
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca motorista do veculo na data
	-- GUTO 10/08/2006
	--->		
	<cffunction name="get_motorista_data" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfargument name="data" required="yes">
		<cftry>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mrh.cod_pessoa, mrh.cod_registro as cod_funcionario, pf.nome
			  from oper.v$motorista_reg_historico mrh
			 inner join oper.v$pessoa_fisica pf
					 on pf.cod_pessoa = mrh.cod_pessoa
			 where mrh.cod_pessoa = oper.pkg_operacional.fnc_motorista_veiculo('#arguments.PLACA#','#arguments.DATA#') 
			   and data_fim is null 
   		</cfquery>
		<cfcatch>
			<cfset qr_result = QueryNew('COD_PESSOA,COD_FUNCIONARIO,NOME')>
		</cfcatch>
		</cftry>
		<cfreturn qr_result>	
	</cffunction>		
	<!--- 
	-- PROPSITO 
	-- Busca km do veculo na data especificada
	-- GUTO 10/08/2006
	--->		
	<cffunction name="get_km_data" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfargument name="data" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_pneu.fnc_km_data('#arguments.PLACA#','#arguments.DATA#') as km
			  from dual
   		</cfquery>
		<cfreturn qr_result>	
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca marca de veculos pela placa
	-- GUTO 10/08/2006
	--->		
	<cffunction name="get_marca_veiculo" access="remote" returntype="query" output="true">
		<cfargument name="placa_controle" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select vm.MARCA as marca
				  from oper.v$veiculo v 
			inner join oper.v$veiculo_marca vm on vm.MARCA_ID = v.MARCA_ID
				 where v.placa	 = '#Replace(arguments.placa_controle,"-","","ALL")#'
		</cfquery>
		<cfreturn qr_result>	
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca a composicao do veiculo
	-- CRISTOFER  24/10/2006
	--->		
	<cffunction name="get_composicao" access="remote" returntype="any" output="true">
		<cfargument name="cod_veiculo" required="yes"> 
		<cfargument name="data" required="no" default=""> 
		<cfargument name="trata_erro" required="no" default="0"> 
        <cftry>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select t.column_value as placa,
                         oper.pkg_veiculo.fnc_get_cod_veiculo(t.column_value) as cod_veiculo,
                         oper.pkg_veiculo.fnc_veiculo_id(t.column_value) as veiculo_id,
                         case when t.column_value = '-1' then 0 else oper.pkg_veiculo.fnc_veiculo_proprietario(t.column_value) end as veiculo_proprietario,
                         a.capacidade,
                         oper.pkg_veiculo.FNC_VEICULO_MODALIDADE(t.column_value) as modalidade,
                         (select d.articulado
                            from oper.v$veiculo_dados d
                           where d.placa = t.column_value) as articulado,
                         (select d.tipo_veiculo
                            from oper.v$veiculo_dados d
                           where d.placa = t.column_value) as tracao                         
                  from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.FNC_GET_COMPOSICAO(oper.pkg_veiculo.fnc_get_placa('#JSStringFormat(arguments.cod_veiculo)#')<cfif len(trim(arguments.data))>,'#arguments.data#'</cfif>),'|')) t,
                       (select oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(oper.pkg_veiculo.fnc_get_placa('#JSStringFormat(arguments.cod_veiculo)#')<cfif session.site eq 'delpozo/'>,0</cfif>,sysdate) as capacidade from dual) a
                 where t.column_value is not null
            </cfquery>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = "">
         	<cfcatch>
            	<cfif arguments.trata_erro eq 0>
                	<cfthrow object="#cfcatch#">
                <cfelseif arguments.trata_erro eq 1>
		            <cfset retorno.erro = true>
		            <cfset retorno.mensagem = cfcatch>
                    <cfset qr_result = retorno>
                </cfif>
            </cfcatch>
        </cftry>
        <cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca a composicao do veiculo
	-- GUTO  25/06/2006
	--->		
	<cffunction name="get_composicao_dados" access="remote" returntype="query" output="true">
		<cfargument name="cod_veiculo" required="yes">
	
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select distinct t.placa,
                    oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa) cod_veiculo,
                     oper.pkg_veiculo.fnc_veiculo_id(t.placa) as veiculo_id,
                    (select oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(t.placa,sysdate) as capacidade
                       from dual) as capacidade,
                    vd.marca,
                    vd.modelo,
                    t.ordem,
                    p.cnpj_cpf,
                    p.razao_social as motorista,
                    vtc.descricao as tipo_carroceria,
                    p.cod_pessoa as cod_pessoa_motorista
               from (select column_value as placa, 
               				rownum as ordem 
                       from table(kss.pkg_string.fnc_split(rtrim(ltrim(oper.pkg_veiculo.FNC_GET_COMPOSICAO(oper.pkg_veiculo.fnc_get_placa('#arguments.cod_veiculo#')),'|'),'|'),'|'))) t
               left join oper.v$veiculo_dados vd 
                      on vd.placa = t.placa
               left join oper.v$veiculo_tipo_carroceria vtc
                      on vtc.tipo_carroceria_id = vd.tipo_carroceria_id
               left join oper.v$veiculo_motorista vp 
                      on vp.placa = t.placa
                     and vp.data_fim is null
               left join kss.v$pessoa p 
                      on p.cod_pessoa = vp.cod_pessoa
              where t.placa is not null
              order by t.ordem
			</cfquery>
		
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca motoristas no perodo
	-- GUTO 30/10/2006
	--->		
	<cffunction name="get_motoristas_periodo" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfargument name="data_inicio" required="yes">
		<cfargument name="data_fim" required="yes">
		<cfquery name="qr_carreta" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.fnc_primeira_carreta('#arguments.PLACA#') as placa
			  from dual
		</cfquery>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct cod_pessoa, motorista, cod_funcionario
            from (
                      select /*+FIRST_ROWS*/ vma.cod_pessoa, oper.pkg_global.fnc_busca_nome_pessoa(vma.cod_pessoa) as motorista, mrh.cod_registro as cod_funcionario
                        from oper.v$veiculo_motorista vma
                       inner join oper.v$motorista_reg_historico mrh
                             on mrh.cod_pessoa = vma.cod_pessoa 
                            and vma.data_inicio between mrh.data_inicio and nvl(mrh.data_fim,sysdate) 
                            and vma.data_fim is null
                       where vma.placa = '#arguments.PLACA#'
                       
                      union all
                    
                    select distinct a.cod_pessoa, oper.pkg_global.fnc_busca_nome_pessoa(a.cod_pessoa) as motorista, mrh.COD_REGISTRO as cod_funcionario
                      from (select distinct /*+FIRST_ROWS*/ cod_pessoa, rhv.data_termino
                                 from oper.v$romaneio_hist_veiculo rhv
                                 where nvl(rhv.data_termino, to_date('#arguments.DATA_FIM#','dd/mm/yyyy hh24:mi')) between to_date('#arguments.DATA_INICIO#','dd/mm/yyyy hh24:mi') and to_date('#arguments.DATA_FIM#','dd/mm/yyyy hh24:mi')
                                    and rhv.placa_controle = '#arguments.PLACA#') a
                      inner join oper.v$motorista_reg_historico mrh
                                 on mrh.cod_pessoa = a.cod_pessoa 
                                and a.data_termino between mrh.data_inicio and nvl(mrh.data_fim,sysdate)
                    <cfif Len(Trim(qr_carreta.PLACA))>
                        union all
                        
                        select distinct a.cod_pessoa, oper.pkg_global.fnc_busca_nome_pessoa(a.cod_pessoa) as motorista, mrh.COD_REGISTRO as cod_funcionario
                          from (select distinct /*+FIRST_ROWS*/ cod_pessoa, rhv.data_termino
                                     from oper.v$romaneio_hist_veiculo rhv
                                     where nvl(rhv.data_termino, to_date('#arguments.DATA_FIM#','dd/mm/yyyy hh24:mi')) between to_date('#arguments.DATA_INICIO#','dd/mm/yyyy hh24:mi') and to_date('#arguments.DATA_FIM#','dd/mm/yyyy hh24:mi')
                                        and rhv.placa_referencia = '#qr_carreta.PLACA#') a
                          inner join oper.v$motorista_reg_historico mrh
                                     on mrh.cod_pessoa = a.cod_pessoa 
                                    and a.data_termino between mrh.data_inicio and nvl(mrh.data_fim,sysdate)
                    </cfif>
             )
		</cfquery>		
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca motoristas no perodo - xml
	-- LEOPOLDOS 12/07/2010
	--->		
	<cffunction name="get_motoristas_periodo_xml" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfargument name="data_inicio" required="yes">
		<cfargument name="data_fim" required="yes">
		<cfquery name="qr_carreta" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.fnc_primeira_carreta(oper.pkg_veiculo.fnc_get_placa('#arguments.PLACA#')) as placa
			  from dual
		</cfquery>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select dbms_xmlgen.getxml('
			select distinct cod_pessoa, motorista, cod_funcionario
            from (
                      select /*+FIRST_ROWS*/ vma.cod_pessoa, oper.pkg_global.fnc_busca_nome_pessoa(vma.cod_pessoa) as motorista, mrh.cod_registro as cod_funcionario
                        from oper.v$veiculo_motorista vma
                       inner join oper.v$motorista_reg_historico mrh
                             on mrh.cod_pessoa = vma.cod_pessoa 
                            and vma.data_inicio between mrh.data_inicio and nvl(mrh.data_fim,sysdate) 
                            and vma.data_fim is null
                       where vma.placa = ' || chr(39) || oper.pkg_veiculo.fnc_get_placa('#arguments.PLACA#') || chr(39) || '
                       
                      union all
                    
                    select distinct a.cod_pessoa, oper.pkg_global.fnc_busca_nome_pessoa(a.cod_pessoa) as motorista, mrh.COD_REGISTRO as cod_funcionario
                      from (select distinct /*+FIRST_ROWS*/ cod_pessoa, rhv.data_termino
                                 from oper.v$romaneio_hist_veiculo rhv
                                 where rhv.data_termino between to_date('|| chr(39) || '#arguments.DATA_INICIO#' || chr(39) ||',' || chr(39) || 'dd/mm/yyyy hh24:mi' || chr(39) || ') and to_date('|| chr(39) || '#arguments.DATA_FIM#'|| chr(39) ||',' || chr(39) || 'dd/mm/yyyy hh24:mi' || chr(39) || ')
                                    and rhv.placa_controle = '|| chr(39) || oper.pkg_veiculo.fnc_get_placa('#arguments.PLACA#') || chr(39) ||') a
                      inner join oper.v$motorista_reg_historico mrh
                                 on mrh.cod_pessoa = a.cod_pessoa 
                                and a.data_termino between mrh.data_inicio and nvl(mrh.data_fim,sysdate)
                    <cfif Len(Trim(qr_carreta.PLACA))>
                        union all
                        
                        select distinct a.cod_pessoa, oper.pkg_global.fnc_busca_nome_pessoa(a.cod_pessoa) as motorista, mrh.COD_REGISTRO as cod_funcionario
                          from (select distinct /*+FIRST_ROWS*/ cod_pessoa, rhv.data_termino
                                     from oper.v$romaneio_hist_veiculo rhv
                                     where rhv.data_termino between to_date('|| chr(39) ||'#arguments.DATA_INICIO#'|| chr(39) ||',' || chr(39) || 'dd/mm/yyyy hh24:mi' || chr(39) || ') and to_date('|| chr(39) ||'#arguments.DATA_FIM#'|| chr(39) ||',' || chr(39) || 'dd/mm/yyyy hh24:mi' || chr(39) || ')
                                        and rhv.placa_referencia = '|| chr(39) || oper.pkg_veiculo.fnc_get_placa('#qr_carreta.PLACA#') || chr(39) ||') a
                          inner join oper.v$motorista_reg_historico mrh
                                     on mrh.cod_pessoa = a.cod_pessoa 
                                    and a.data_termino between mrh.data_inicio and nvl(mrh.data_fim,sysdate)
                    </cfif>
             )') as resultado
         from dual
		</cfquery>		
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca FROTA
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_cod_veiculo" returntype="string" access="remote">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.fnc_get_cod_veiculo('#arguments.placa#') as cod_veiculo
			  from dual
 		</cfquery>		
		<cfreturn qr_result.cod_veiculo>
	</cffunction>


	<!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_localizar" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7"> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select * from (select distinct vd.placa,
							vd.cod_veiculo,
							vd.marca_id,
							ma.marca,
							vd.modelo_id,
							vd.situacao_id,
							vd.uf,
							md.modelo,
							oper.pkg_veiculo.fnc_veiculo_proprietario(vd.placa) as proprietario,
							vd.observacao,
							vd.cor_predominante,
							vd.ano,
							vd.chassis,
							vd.renavan, /* Relacionado ao pessoa_atributo */
							oper.pkg_veiculo_dml.fnc_veiculo_get_atributo(vd.placa,'TARA') as tara,
							oper.pkg_veiculo_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao /* Relacionado ao pessoa_atributo */
			  from oper.v$veiculo vd
			 inner join oper.v$veiculo_modelo md
					 on md.modelo_id = vd.modelo_id
					and md.marca_id  = vd.marca_id
			 inner join oper.v$veiculo_marca ma
					 on ma.marca_id  = vd.marca_id
	  left join oper.v$veiculo_proprietario vp on vp.placa = vd.placa
   				  and vp.data_fim is null
             where 1=1			  
			<cfif Len(Trim(arguments.placa))>
			   and vd.placa like upper('%#arguments.placa#%')
			</cfif>		
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vd.cod_veiculo) like upper('#arguments.cod_veiculo#%')
			</cfif>	
			<cfif Len(Trim(arguments.frota))>
			   and (vd.placa like upper('%'||'#arguments.frota#%')
			       or vd.cod_veiculo like upper('%'||'#arguments.frota#%'))
			</cfif>	) vd	
			 where 1 = 1
			<cfif Len(Trim(arguments.proprietario))>
               and oper.pkg_veiculo.fnc_veiculo_proprietario(vd.placa) in (#arguments.proprietario#)
			</cfif>
			order by vd.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca dados dos agregados
	-- NOTAS EXPLICATIVAS
	-- LOUIS 13/03/2006
	--->
	<cffunction name="get_dados_agregados" returntype="query" access="remote">
		<cfargument name="cod_veiculo" required="no">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ps.cod_pessoa as cod_motorista, 
					vpa.cod_pessoa as cod_proprietario,
       				vm.placa, v.cod_veiculo, 
					ps.identificador as identificador_m,
       				ps.cnpj_cpf as cpf_motorista,
       				ps.cliente as motorista,
					pr.identificador as identificador_p,
       				pr.cliente as proprietario,
				    pr.razao_social,
					 pr.inscricao_estadual
  			from oper.v$veiculo v
 			inner join oper.v$veiculo_proprietario_atual vpa 
					on v.placa = vpa.placa
       			inner join kss.v$pessoa pr
					on pr.COD_PESSOA = vpa.cod_pessoa    
 			inner join oper.v$veiculo_motorista vm 
					on v.placa = vm.placa          
 			inner join kss.v$pessoa ps 
					on vm.COD_PESSOA = ps.cod_pessoa
 			where v.cod_veiculo = '#arguments.cod_veiculo#'
        and vm.data_fim is null
		</cfquery>		
	<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca os dados dos engates(veiculos_
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS 20/06/2007 - criado
	--->
	<cffunction name="get_composicao1" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */ vc.placa_2 as placa, vc.placa_1, 
            	   oper.fnc_get_placa('#arguments.placa#') as placa_consulta,
		           vd.modelo,
		           vd.marca,
		           vt.tipo,
                   to_char(vc.data_hora_engate,'dd/mm/yyyy hh24:mi:ss') as data_hora_engate,
                   vc.km_engate
		      from oper.v$veiculo_composicao vc
	    inner join oper.v$veiculo_dados vd
	            on vd.placa = vc.PLACA_2
	    inner join oper.v$veiculo_tipo vt
	            on vt.TIPO_ID = vd.tipo_id
	         where 1=1
			 <cfif Len(Trim(arguments.placa))>
             and vc.data_hora_desengate is null
			 and (vc.placa_1 = oper.fnc_get_placa('#arguments.placa#')  
			   or vc.placa_2 = oper.fnc_get_placa('#arguments.placa#') )
  			 </cfif>
		</cfquery>	
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o tempo engatado e desengatado do veiculo
	-- CRISTOFER  25/07/2007
	--->		
	<cffunction name="get_tempo_engatado_desengatado" access="remote" returntype="query" output="true">
        <cfargument name="data_inicial" required="yes">
        <cfargument name="data_final" required="yes">
        <cfargument name="por_placa" required="no" default="0">
        <cfargument name="cod_proprietario" required="no" default="">
        <cfargument name="data_final_exata" required="no" default="1">
        <cfset arguments.data_final_exata = 1>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select round(sum(case
                          when tp.placa_carreta is null then (tp.data_fim-tp.data_inicio)*24
                          else 0
                       end),2) tempo_desengatado,
                   round(sum(case
                          when tp.placa_carreta is not null then (tp.data_fim-tp.data_inicio)*24
                          else 0
                       end),2) tempo_engatado,
                   <cfif arguments.por_placa eq 1>
                   tp.placa_tracao,
                   vc.nome proprietario,
                   vc.cod_pessoa cod_proprietario,
                   </cfif>
                   count(distinct placa) nro_veiculos,
                   min(data_inicio) data_inicial,
                   max(data_fim) data_final,
                   sum((tp.data_fim-tp.data_inicio)*24) as tempo_total,
                   (max(data_fim)-min(data_inicio))*24 as intervalo_horas,
                   (sum(case
                          when tp.placa_carreta is not null then (tp.data_fim-tp.data_inicio)*24
                          else 0
                       end)/sum((tp.data_fim-tp.data_inicio)*24))*100 perc_engatado,
                   (sum(case
                          when tp.placa_carreta is null then (tp.data_fim-tp.data_inicio)*24
                          else 0
                       end)/sum((tp.data_fim-tp.data_inicio)*24))*100 perc_desengatado
              from oper.v$veiculo_controle vc
             cross join table(oper.pkg_tempo_viagem.fnc_tempo_engatado(vc.placa,
                                                 '#arguments.data_inicial#',
                                                 to_date('#arguments.data_final#','dd/mm/yyyy')+1,
                                                 60)) tp
             where tp.placa_tracao is not null
           <cfif len(trim(arguments.cod_proprietario))>
           	   and vc.cod_pessoa in (#ListDeleteNulls(arguments.cod_proprietario)#)
           </cfif>
		   <cfif arguments.por_placa eq 1>
             group by tp.placa_tracao, vc.nome, vc.cod_pessoa
           </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os tempos engatado/engatado do veiculo
	-- CRISTOFER  27/07/2007
	--->		
	<cffunction name="get_tempo_engatado_desengatado_veiculo" access="remote" returntype="query" output="true">
        <cfargument name="data_inicial" required="yes">
        <cfargument name="data_final" required="yes">
        <cfargument name="placa" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select placa_tracao,
                   placa_carreta,
                   data_inicio,
                   data_fim,
                   case
                      when placa_carreta is null then 'Desengatado'
                      else 'Engatado'
                   end status,
                   (data_fim-data_inicio)*24 horas,
                   to_char(numtodsinterval((data_fim-data_inicio),'day')) tempo
              from table(oper.pkg_tempo_viagem.fnc_tempo_engatado('#arguments.placa#',
                                                             '#arguments.data_inicial#',
                                                             to_date('#arguments.data_final#','dd/mm/yyyy')+1,
                                                             60))  
                                                               
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os proprietarios de veiculos
	-- CRISTOFER  27/07/2007
	--->		
	<cffunction name="get_proprietarios_veiculos" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select kss.fnc_concat_all(to_concat_expr(cod_pessoa,',')) cod_pessoa,
                   razao_social proprietario
              from (select distinct p.cod_pessoa,
                           p.razao_social 
                      from oper.v$veiculo v
                     inner join oper.v$veiculo_proprietario vp
                             on vp.PLACA = v.placa
                     inner join oper.v$pessoa_modalidade m
                             on m.cod_pessoa = vp.cod_pessoa
                            and m.num_situacao = 1
                            and m.num_modalidade in (9,10)
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = vp.cod_pessoa
                     where v.situacao_id <> 0)
             group by razao_social    
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o grupo do veiculo
	-- CRISTOFER  08/08/2007
	--->		
	<cffunction name="get_veiculo_grupo" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vgs.cod_grupo,
                   vgs.descricao,
                   vgs.limite_veiculo,
                   vgs.situacao_id,
                   vgs.user_insert,
                   vgs.date_insert,
                   vgs.user_update,
                   vgs.date_update,
                   vgs.site,
                   vgs.dedicado,
                   vg.placa
              from oper.v$veiculo_grupo_setup vgs
             inner join oper.v$veiculo_grupo vg
                     on vg.cod_grupo = vgs.cod_grupo
             where 1=1
               and vg.data_termino is null
             <cfif len(trim(arguments.placa))>
               and vg.placa = '#arguments.placa#'
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Retorna os periodos de meses para calculos futuros
	-- CRISTOFER  13/08/2007
	--->		
	<cffunction name="get_periodos_meses" access="remote" returntype="query" output="true">	
    	<cfargument name="data_inicial" required="yes">
    	<cfargument name="data_final" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select case
                      when level = 1 then data_inicial
                      else trunc(add_months(data_inicial,level-1),'month') 
                   end inicio,
                   case
                      when to_char(add_months(data_inicial,level-1),'yyyy-mm') = to_char(data_final,'yyyy-mm') then data_final
                      else trunc(add_months(data_inicial,level),'month') 
                   end termino,
                   to_char(case
                      when level = 1 then data_inicial
                      else trunc(add_months(data_inicial,level-1),'month') 
                   end,'mm/yyyy') mes
              from (select to_date('#arguments.data_inicial#','dd/mm/yyyy') data_inicial,
                           to_date('#arguments.data_final#','dd/mm/yyyy') data_final
                      from dual)
             connect by to_char(add_months(data_inicial,level-1),'yyyy-mm') <= to_char(data_final,'yyyy-mm')
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Gera o grafico de tempo desengatado mensal
	-- CRISTOFER  13/08/2007
	--->		
	<cffunction name="get_tempo_engatado_desengatado_mensal" access="remote" returntype="query" output="true">
        <cfargument name="data_inicial" required="yes">
        <cfargument name="data_final" required="yes">
        <cfargument name="cod_proprietario" required="no" default="">
        <cfscript>
			qrMeses = this.get_periodos_meses(	data_inicial = arguments.data_inicial,
												data_final = arguments.data_final);
		</cfscript>
        <cfloop query="qrMeses">
        	
        	<cfset qrMesAtual = this.get_tempo_engatado_desengatado(data_inicial = LSDateFormat(qrMeses.inicio),
																	data_final = LSDateFormat(qrMeses.termino),
																	cod_proprietario = arguments.cod_proprietario,
																	data_final_exata = 1)>
            <cfset QueryAddColumn(qrMesAtual,'MES',arrayNew(1))>
            <cfset QuerySetCell(qrMesAtual,'MES',qrMeses.mes)>                                                        
        	<cfif qrMeses.currentrow eq 1>
            	<cfset qrMes = qrMesAtual>
            <cfelse>
            	<cfset qrMes = this.queryConcat(query1 = qrMes,
												query2 = qrMesAtual)>
            </cfif>
        </cfloop>
		<cfreturn qrMes>		
	</cffunction>
    
    
    <!---  
 -- PROPSITO  
 -- retorna o KM estimado do veiculo para a data 
 -- CRISTOFER 20/12/2007 
 --->  
 <cffunction name="get_km_estimado" access="remote" returntype="query" output="true">  
 <cfargument name="placa" required="yes"> 
 <cfargument name="data" required="yes"> 
 <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#"> 
 select oper.pkg_veiculo.fnc_get_km_estimado('#arguments.placa#','#arguments.data#') km  
 from dual 
 </cfquery> 
 <cfreturn qr_result>  
 </cffunction> 

	<!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_modelo" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="placa_exa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="frota_exa" required="no" default="">
        <cfargument name="marca" required="no" default="">
        <cfargument name="modelo" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7"> 
		<!---Terceiros--->	
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct vd.placa, vd.cod_veiculo, vd.num_rastreador, vd.rastreador_id, vd.rastreador_com_problemas,
				   vd.marca_id, vd.marca, vd.modelo_id, vd.situacao_id, vd.tipo_id, vd.uf, vd.modelo,
				   vd.capacidade_tanque, vd.capacidade, vd.km_revisao, vd.modelo, vd.proprietario,
				   vd.observacao, vd.cor_predominante, vd.ano, vd.chassis, vd.renavan, vt.tipo
			<cfif  session.site neq "delpozo/">
					,/* Relacionado ao pessoa_atributo */
				   oper.pkg_veiculo_dml.fnc_veiculo_get_atributo(vd.placa, 'TARA') as tara,
				   oper.pkg_veiculo_dml.fnc_veiculo_get_atributo(vd.placa, 'CAPACIDADE_TRACAO') as capacidade_tracao
					/* Relacionado ao pessoa_atributo */				   
					, vc.tracao
			</cfif>
			  from oper.v$veiculo_dados vd
			  left join oper.v$veiculo_tipo vt
			         on vt.tipo_id = vd.tipo_id
		      left join oper.v$veiculo_categoria vc
			         on vc.categoria_id = vt.categoria_id
			  left join oper.v$veiculo_proprietario vp
			          on vp.placa = vd.placa
					 and vp.data_fim is null
             where 1=1			  
			<cfif Len(Trim(arguments.placa))>
			   and vd.placa = '#arguments.placa#'
			</cfif>		
			<cfif Len(Trim(arguments.placa_exa))>
			   and upper(vd.placa) = '#arguments.placa_exa#'
			</cfif>	
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vd.cod_veiculo) = oper.fnc_get_cod_veiculo(upper('#arguments.cod_veiculo#'))
			</cfif>		
			<cfif Len(Trim(arguments.proprietario))>
			   and vd.proprietario in (#arguments.proprietario#)
			</cfif>		
			<cfif Len(Trim(arguments.frota))>
			   and (vd.placa like upper('%#arguments.frota#%')
			       or vd.cod_veiculo like upper('%#arguments.frota#%'))
			</cfif>	
			<cfif Len(Trim(arguments.frota_exa))>
			   and (upper(vd.placa) = '#arguments.frota_exa#'
			       or upper(vd.cod_veiculo) = '#arguments.frota_exa#')
			</cfif>		
			order by vd.cod_veiculo 
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    
	<!--- 
    -- PROPSITO
    -- Busca os romaneios vinculados ao veiculo
    -- 23/12/2009 - criado
    --->	
    <cffunction name="get_romaneio_veiculo" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="placa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            with x as
              (select r.num_romaneio, r.data_inicio, r.data_termino, r.remetente, r.destinatario
                 from oper.v$romaneio r
                where null is null
                  and r.data_inicio >= sysdate - 180
                  and exists (select 0
                                from oper.v$romaneio_hist_veiculo v
                               where v.num_romaneio = r.num_romaneio
                                 and (v.placa_controle like upper('#arguments.placa#%')
                                     or
                                      v.placa_referencia like upper('#arguments.placa#%')
                                     )
                              )
               
              ) 
            select num_romaneio, 
            	   to_char(data_inicio,'dd/mm/yyyy hh24:mi:ss') as data_inicio, 
                   to_char(data_termino,'dd/mm/yyyy hh24:mi:ss') as data_termino, 
                   remetente, 
                   destinatario,
                   rtrim(kss.fnc_concat_all(kss.to_concat_expr(placa_tracao, ', ')),', ') as placa_tracao,
                   rtrim(kss.fnc_concat_all(kss.to_concat_expr(placa_carreta, ', ')),', ') as placa_carreta
              from (
                     select distinct x.num_romaneio, x.data_inicio, x.data_termino, x.remetente, x.destinatario,
                            '' as placa_tracao, v.placa_referencia as placa_carreta
                        from x
                       inner join oper.v$romaneio_hist_veiculo v
                               on v.num_romaneio = x.num_romaneio
            
                      union all
            
                     select distinct x.num_romaneio, x.data_inicio, x.data_termino, x.remetente, x.destinatario,
                            v.placa_controle as placa_tracao, '' as placa_carreta
                        from x
                       inner join oper.v$romaneio_hist_veiculo v
                               on v.num_romaneio = x.num_romaneio
                   )
             group by num_romaneio, data_inicio, data_termino, remetente, destinatario
             order by num_romaneio
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca classificao
	-- NOTAS EXPLICATIVAS
	-- GUTO 17/07/2006
	--->
	<cffunction name="get_classificacao" access="remote" returntype="query" output="true">
		<cfargument name="agrupamento_id" required="no" default="">
		<cfargument name="tipo_carroceria_id" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select va.agrupamento_id, va.num_agrupamento, va.descricao as agrupamento,
                   vc.tipo_carroceria_id, vc.num_tipo_carroceria, vc.descricao as classificacao,
                   pg.num_gabarito, pg.descricao as gabarito
              from oper.v$veiculo_tipo_carroceria vc
             inner join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vc.agrupamento_id
             left join oper.v$pneu_gabarito pg
                     on pg.num_gabarito = vc.num_gabarito
               where 1=1
               <cfif Len(Trim(arguments.agrupamento_id))>
               	 and va.agrupamento_id = any(#arguments.agrupamento_id#)
               </cfif>
               <cfif Len(Trim(arguments.tipo_carroceria_id))>
               	 and va.tipo_carroceria_id = #arguments.tipo_carroceria_id#
               </cfif>
               order by agrupamento, vc.num_tipo_carroceria
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna agrupamentos
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_agrupamento" displayname="Retorna agrupamentos" output="true" returntype="query" access="remote">
		<cfargument name="tracao" required="no" default="">
		<cfargument name="terceiro" required="no" default="">
        <cfargument name="controla" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select va.agrupamento_id, va.num_agrupamento, va.descricao, va.tracao, va.articulado
              from oper.v$veiculo_agrupamento va
             where 1=1
            <cfif Len(Trim(arguments.tracao))>
			   and tracao = #arguments.tracao#
			</cfif>
			<cfif Len(Trim(arguments.controla))>
			   and controla = #arguments.controla#
			</cfif>
			<cfif Len(Trim(arguments.terceiro))>
			   and terceiro = #arguments.terceiro#
			</cfif>
             order by va.descricao
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna as Situaes cadastradas
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 12/03/2009
	--->	
	<cffunction name="get_situacao" displayname="Retorna as Situaes cadastradas" output="true" returntype="query" access="remote">
    	<cfargument name="situacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select situacao_id, situacao
  			  from oper.v$veiculo_situacao
             where 1 = 1
			<cfif Len(Trim(arguments.situacao_id))>
			   and situacao_id = #arguments.situacao_id#
			</cfif>
			 order by situacao asc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna as Modalidades cadastradas
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 12/03/2009
	--->	
	<cffunction name="get_modalidade" displayname="Retorna as Modalidades cadastradas" output="true" returntype="query" access="remote">
    	<cfargument name="item_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select item_id, valor
			  from kss.v$atributo_item
             where atributo_id = 115
			<cfif Len(Trim(arguments.item_id))>
			   and item_id = #arguments.item_id#
			</cfif>
			 order by valor
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os Atributos cadastrados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 19/03/2009
	--->	
	<cffunction name="get_atributo" displayname="Retorna os Atributos cadastrados" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vta.cod_atributo, vta.descricao_resumida as descricao,
                   vta.tipo_dado, at.valor_padrao
              from kss.v$atributo vta
             inner join kss.v$atributo_tabela at
                on at.cod_atributo = vta.cod_atributo
               and at.tabela = 'VEICULO'  
             where vta.grupo_id = 1 -- Operacional
               and vta.ativo = 1
               and vta.atributo_id not in (114,115)
             order by descricao_resumida
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os valores cadastrados para um(s) atributo(s)
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 19/03/2009
	--->	
	<cffunction name="get_valor_atributo" displayname="Retorna os valores cadastrados para um(s) atributo(s)" output="true" returntype="query" access="remote">
		<cfargument name="atributo_id" required="no" default="">
        <cfargument name="cod_atributo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ai.atributo_id, ai.valor
              from kss.v$atributo_item ai
             inner join kss.v$atributo a
                on a.atributo_id = ai.atributo_id
             where 1 = 1
			<cfif Len(Trim(arguments.atributo_id))>
			   and (ai.atributo_id = #arguments.atributo_id# or ai.atributo_id is null)
			</cfif>
			<cfif Len(Trim(arguments.cod_atributo))>
			   and (a.cod_atributo = '#arguments.cod_atributo#' or a.cod_atributo is null)
			</cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os laudos cadastrados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 20/03/2009
	--->	
	<cffunction name="get_laudos" displayname="Retorna os laudos cadastrados" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+PUSH_SUBQ*/
                   laudo_id, descricao, rowid
              from oper.v$veiculo_laudo
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
			   and laudo_id not in (select laudo_id from oper.v$veiculo_laudo_excecao where upper(placa) = upper('#arguments.placa#'))
			</cfif>
             order by laudo_id
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os laudos liberados para um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 23/03/2009
	--->	
	<cffunction name="get_laudos_liberados" displayname="Retorna os laudos liberados para um veculo" output="true" returntype="query" access="remote">
		<cfargument name="laudo_id" required="no" default="">
        <cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select lve.laudo_id, l.descricao as laudo, lve.rowid, 
                   lve.placa, lve.laudo_id||lve.placa as keyfield
              from oper.v$veiculo_laudo_excecao lve
             inner join oper.v$veiculo_laudo l
                on l.laudo_id = lve.laudo_id
             where 1 = 1
			<cfif Len(Trim(arguments.laudo_id))>
			   and lve.laudo_id = #arguments.laudo_id#
			</cfif>
            <cfif Len(Trim(arguments.placa))>
			   and upper(lve.placa) = upper('#arguments.placa#')
			</cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna as situaes cadastradas para um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 23/03/2009
	--->	
	<cffunction name="get_veiculo_hist_situacao" displayname="Retorna as situaes cadastradas para um veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vhs.veiculo_situacao_id, vhs.placa, vhs.situacao_id, to_char(vhs.data, 'dd/mm/yyyy hh24:mi:ss') as data,
                   vhs.rowid, vs.situacao,
                   to_date(to_char(vhs.data, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_f,
                   to_date(to_char(vhs.data, 'hh24:mi:ss'), 'hh24:mi:ss') hora_f,
                   vhs.user_insert, to_char(vhs.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert,
                   vhs.user_update, to_char(vhs.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update,
                   rownum as keyfield
              from oper.v$veiculo_hist_situacao vhs
             inner join oper.v$veiculo_situacao vs
                on vs.situacao_id = vhs.situacao_id
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and upper(vhs.placa) = upper('#arguments.placa#')
            </cfif>         
             order by vhs.data desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna as modalidades cadastradas para um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 23/03/2009
	--->	
	<cffunction name="get_veiculo_modalidade" displayname="Retorna as modalidades cadastradas para um veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select veiculo_modalidade_id, placa, modalidade,
                   to_char(data, 'dd/mm/yyyy hh24:mi:ss') as data, rowid,
                   user_insert, to_char(date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert,
                   user_update, to_char(date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update,
                   to_date(to_char(data, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_f,
                   to_date(to_char(data, 'hh24:mi:ss'), 'hh24:mi:ss') hora_f,
                   rownum as keyfield
              from oper.v$veiculo_modalidade
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and upper(placa) = upper('#arguments.placa#')
            </cfif>
 			 order by data desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os atributos cadastrados para um veculo

	-- NOTAS EXPLICATIVAS
	-- ANDERSON 23/03/2009
	--->	
	<cffunction name="get_veiculo_atributo" displayname="Retorna os atributos cadastrados para um veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select 1 as flag, va.placa, va.cod_atributo, va.valor, va.rowid,
                   a.descricao_resumida as descricao, a.tipo_dado,
                   case
                      when a.tipo_dado = 'COR HEXADECIMAL' then
                         '$'||va.valor
                      when a.tipo_dado = 'FLAG' then
                         decode(va.valor, 1, 'Sim', 'No')
                      else va.valor
                   end valor_formatado       
              from oper.v$veiculo_atributos va
             inner join kss.v$atributo a
                on a.cod_atributo = va.cod_atributo
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and upper(va.placa) = upper('#arguments.placa#')
            </cfif>
             order by va.cod_atributo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Retorna os veiculos de terceiro
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 25/06/2009 - criado
	--->
    	
	<cffunction name="get_veiculo_terceiro" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="proprietario_cnpj" required="no" default="">
		<cfargument name="motorista_cnpj" required="no" default="">
		<cfargument name="situacao" required="no" default="">
		<cfargument name="classificacao" required="no" default=""> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select distinct vd.placa
               ,vd.ano
               ,vd.uf
               ,vd.marca_id
               ,vd.marca
               ,vd.modelo_id
               ,vd.modelo
               ,vd.classificacao
               ,oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TARA') as tara
               ,oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao
               ,vd.situacao_id
               ,vs.situacao
               ,pp.cnpj_cpf as cpf_proprietario
               ,pp.cliente as nome_proprietario
               ,mp.cnpj_cpf as cpf_motorista
               ,mp.cliente as nome_motorista
           from oper.v$veiculo_dados vd
           left join oper.v$veiculo_tipo_carroceria vtc
                  on vd.tipo_carroceria_id = vtc.tipo_carroceria_id
           left join oper.v$veiculo_situacao vs
                  on vs.situacao_id = vd.situacao_id
           left join oper.v$veiculo_agrupamento va
                  on va.agrupamento_id = vtc.agrupamento_id
           inner join oper.v$veiculo_proprietario_atual vp
                  on vp.placa = vd.placa
           left join kss.v$pessoa pp
                  on pp.cod_pessoa = vp.cod_pessoa
           inner join oper.v$veiculo_motorista vm
                  on vm.placa = vd.placa
                  and vm.data_fim is null 
           left join kss.v$pessoa mp
                  on mp.cod_pessoa = vm.cod_pessoa  
           inner join kss.v$pessoa_modalidade pm
                  on  pm.cod_pessoa = vp.cod_pessoa
                  and pm.num_modalidade = 3
                  and pm.situacao = 1
          where 1 = 1
          and oper.pkg_veiculo.fnc_veiculo_proprietario(vd.placa) = 3
          <cfif Len(Trim(arguments.proprietario_cnpj))>
               and pp.cnpj_cpf = '#arguments.proprietario_cnpj#'
          </cfif>
          <cfif Len(Trim(arguments.motorista_cnpj))>
               and mp.cnpj_cpf = '#arguments.motorista_cnpj#'
          </cfif> 
          <cfif Len(Trim(arguments.situacao))>
               and vd.situacao_id = '#arguments.situacao#'
          </cfif> 
          <cfif Len(Trim(arguments.classificacao))>
               and upper(vd.classificacao) like  upper('#arguments.classificacao#')
          </cfif>  
         </cfquery>
		<cfreturn qr_result>
	</cffunction>  
    <!--- 
    -- PROPSITO 
    -- Retorna Laudos Pendentes por Frota
    -- LEOPOLDOS 25/06/2010 - CRIADO
    --->		
    <cffunction name="get_lista_laudo_pendente" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select dbms_xmlgen.getxml(' 
            select vl.placa, vl.situacao, vl.desc_situacao,
                   vl.laudo_id, vl.laudo, vl.data_verificacao,
                   vl.data_vencimento
            from oper.v$veiculo_laudos_situacao vl
          where vl.placa = ' || chr(39) || oper.pkg_veiculo.fnc_get_placa('#arguments.PLACA#') || chr(39) || '
            and vl.situacao <> 4') as resultado
          from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    <!--- 
    -- PROPSITO 
    -- Retorna Atributos de um determinado laudo
    -- LEOPOLDOS 25/06/2010 - CRIADO
    --->		
    <cffunction name="get_laudo_item" access="remote" returntype="query" output="true">
    	<cfargument name="laudo_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">		
         select dbms_xmlgen.getxml('
            select ls.laudo_id
                 , la.atributo_id
                 , la.descricao
                 , la.tipo_dado
              from oper.v$veiculo_laudo_atributo_setup ls
             inner join oper.v$veiculo_laudo_atributo la
                     on ls.atributo_id = la.atributo_id
             where ls.laudo_id = #arguments.LAUDO_ID#') as resultado 
           from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca FROTA
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_veiculo_integracao" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select v.veiculo_id
     			 , v.cod_veiculo
              from integracao.v$veiculo v
             where v.cod_veiculo like '%#arguments.placa#%'
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna o nmero de eixos de uma determinada placa ou composio na data atual
	-- ANDERSONC 27/09/2010 15:41:18 - CRIADO
	--->
	<cffunction name='get_numero_eixos_composicao' displayname='Retorna o nmero de eixos de uma determinada placa ou composio na data atual' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_veiculo.prc_numero_eixos_composicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EIXOS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EIXOS_SUPENSOS' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

 <!--- 
	-- PROPSITO
	-- Retorna dados do veculo desengatados
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
    <cffunction name="get_desengate" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
            <cfargument name="placa" required="yes"> 
         <cfquery datasource="#session.dsn#" name="qr_engate" username="#session.usuario#" password="#session.senha#">
                    select to_char(data_hora_engate,'dd/mm/yyyy hh24:mm:ss') as data_hora_engate, km_engate,
                           to_char(data_hora_desengate,'dd/mm/yyyy hh24:mm:ss') as data_hora_desengate
                    from oper.v$veiculo_composicao
                    where placa_1 = '#arguments.PLACA#'
           </cfquery>
        
       <cfreturn qr_engate>
     </cffunction>    

<!--- 
	-- PROPSITO
	-- Retorna dados do veculo engatado
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_engate" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="yes">
		<cfargument name="carretas" required="no" default="0">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7"> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">		
select column_value placa,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(column_value) cod_veiculo,
                   (select oper.pkg_veiculo.fnc_capacidade_carga(oper.pkg_veiculo.fnc_veiculo_id(column_value)) as capacidade
                      from dual) as capacidade,
                   vd.marca,
                   vd.modelo,
                   vd.placa,
                   vd.municipio_id,
                   m.municipio,
                   vd.cod_veiculo,
                   vd.num_rastreador,
                   vd.rastreador_id,
                   vd.rastreador_com_problemas,
                   vd.marca_id,
                   vd.modelo_id,
                   vd.marca,
                   vd.modelo,
                   vd.tipo_carroceria_id,
                   vd.classificacao,
                   vd.agrupamento_id,
                   vd.agrupamento,
                   vd.situacao_id,
                   vd.uf,
                   vd.capacidade_tanque,
                   vd.km_revisao,
                   vd.proprietario,
                   vd.observacao,
                   vd.cor_predominante,
                   vd.ano,
                   vd.chassis,
                   nvl(vd.renavan,'00000000') as renavan,
                   pe.razao_social as motorista,
                   p.cod_pessoa as cod_pessoa_motorista,
                   oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa, 'TARA') as tara,
                   nvl(oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'NUMERO_EIXOS'),0) as numero_eixos,
                   oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao
              from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.FNC_GET_COMPOSICAO(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')),'|')) t
              left join oper.v$veiculo_dados vd 
                     on vd.placa = column_value
              left join oper.v$veiculo_motorista vp 
                     on vp.placa = column_value and vp.data_fim is null
              left join kss.v$pessoa p 
                     on p.cod_pessoa = vp.cod_pessoa
              left join kss.v$pessoa pe 
                     on pe.cod_pessoa = p.cod_pessoa
              left join cep.municipio m 
                     on m.municipio_id = vd.municipio_id
             <cfif arguments.carretas eq 0>
                where column_value is not null
             <cfelse> 
                where column_value <> '#arguments.placa#'
             </cfif>
             order by instr(oper.pkg_veiculo.FNC_GET_COMPOSICAO(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')),column_value)
  	 </cfquery>
   <cfreturn qr_result>
 </cffunction>     
 
  	<!--- 
	-- PROPSITO
	-- Retorna as informaes bsicas do veculo
	-- NOTAS EXPLICATIVAS
	-- 16/09/2011 - criado
	--->	
    <cffunction name="get_veiculo_light" displayname="Retorna dados do veculo" returntype="query" access="remote" output="true">
         <cfargument name="placa" required="yes"> 
         <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select v.veiculo_id
                      from oper.v$veiculo v
                     where v.placa = '#arguments.PLACA#'
           </cfquery>
       <cfreturn qr_result>
     </cffunction>

  	<!--- 
	-- PROPSITO
	-- Retorna veiculos que j tiveram o KM inicializado
	-- NOTAS EXPLICATIVAS
	-- 06/06/2012 - criado
	--->	
    <cffunction name="get_veiculo_km_inicializacao" displayname="Retorna dados do veculo" returntype="query" access="remote" output="true">
         <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select max(vg.cod_grupo) keep  (dense_rank last order by vg.data_inicio) 
                      from oper.v$veiculo_grupo vg
                      where vg.placa = v.placa) as cod_grupo
                  ,v.veiculo_id
                  ,v.placa
                  ,v.cod_veiculo
                  ,to_char(vki.data_inicializacao,'dd/mm/yyyy hh24:mi') as data_inicializacao
                  ,vki.km
                  ,vki.user_insert
              from oper.v$veiculo_km_inicializacao vki
              inner join oper.v$veiculo v
                      on vki.veiculo_id = v.veiculo_id
             order by vki.date_insert desc
           </cfquery>
       <cfreturn qr_result>
     </cffunction>
     
    <!--- 
	-- PROPSITO 
	-- Busca os tipos de combustveis
	-- MARIA 06/08/2012
	--->		
	<cffunction name="get_veiculo_tipo_combustivel" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.valor as tipo_combustivel
              from kss.v$atributo_item a
             where a.atributo_id = 133
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca FROTA
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_veiculo_modalidade_proprietario" returntype="query" access="remote">
		<cfargument name="placa" required="yes">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.FNC_VEICULO_MODALIDADE(v.placa) as modalidade
                 , (select razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.FNC_PESSOA_PROPRIETARIO(v.placa, sysdate) ) as proprietario
                 , (select kss.pkg_string.fnc_formata_cnpj_cpf( p.cnpj_cpf )
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.FNC_PESSOA_PROPRIETARIO(v.placa, sysdate) ) as cnpj_cpf
                 , (select m.municipio
                      from cep.municipio m
                     where m.municipio_id = v.municipio_id) as municipio
                 , v.uf
                 , vm.modelo
                 , va.marca
            from oper.v$veiculo v
           inner join oper.v$veiculo_modelo vm
              on vm.modelo_id = v.modelo_id
           inner join oper.v$veiculo_marca va
              on va.marca_id = v.marca_id
           where v.PLACA = '#arguments.PLACA#'
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
</cfcomponent>
