<cfcomponent extends="_transportes.consulta.cfc_contrato_transporte">
    
    <!--- 
	-- PROPSITO 
	-- Busca os contratos de transporte
	-- ANDERSON - 14/07/2009 - ALTERADO
	--->		
	<cffunction name="get_contrato_transp" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="placa_controle" required="no" default="">
        <cfargument name="proprietario_cod_pessoa" required="no" default="">
        <cfargument name="num_formulario" required="no" default="">
        <cfargument name="lancto_id" required="no" default="">
        <cfargument name="cancelada" required="no" default="">
    	<cfargument name="tipo_contrato" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ FIRST_ROWS */
                   c.lancto_id,
                   c.num_romaneio,
                   c.num_formulario,
                   c.serie_formulario,
                   c.cod_modelo,
                   c.cod_pessoa_filial,
                   c.cod_departamento,
                   c.cod_setor,
                   c.cod_centro_custo,
                   to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao,
                   c.peso,
                   c.volume,
                   c.m3,
                   c.frete_em,
                   c.cod_unidade,
                   c.tolerancia_falta,
                   c.valor_unitario,
                   c.valor_frete_bruto,
                   c.valor_frete_liquido,
                   to_number(replace(replace(cf.cf_pedagio, '.', ''), ',', '.')) as valor_pedagio,
                   to_number(replace(replace(cf.cf_adiant, '.', ''), ',', '.')) as valor_adiant,
                   cf_total_impostos as valor_total_impostos,
                   to_number(replace(replace(cf.cf_saldo_frete, '.', ''), ',', '.')) as valor_saldo_frete,
                   c.motorista_cod_pessoa,
                   cf.cf_motorista as motorista,
                   c.placa_controle,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_controle) as cod_veiculo_controle,
                   c.placa_referencia,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_referencia) as cod_veiculo_referencia,
                   c.proprietario_cod_pessoa,
                   cf.cf_proprietario as proprietario,
                   c.proprietario_endereco,
                   c.proprietario_municipio_id,
                   c.proprietario_nit,
                   cf.cf_rem_municipio || '/' || cf_rem_uf as origem,
       			   cf.cf_dest_municipio || '/' || cf_dest_uf as destino,
                   nvl((select least(nvl(min(c1.impresso), 1), c.impresso)
                          from oper.v$contrato_transp c1
                         where c1.lancto_id_pai = c.lancto_id), 1) as impresso,
                   c.observacao,
                   c.proprietario_municipio_id,
                   c.num_rpa,
                   to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento,
                   c.usuario_cancelamento,
                   c.motivo_cancelamento,
                   c.tipo_contrato,
                   case
                      when c.tipo_contrato = 0 then 'TERCEIRO'
                      else 'AGREGADO'
                   end as tipo_contrato_desc,
                   c.parcela,
                   c.total_parcela,
                   c.valor_parcelamento,
                   c.lancto_id_pai,
                   c.user_insert,
                   c.date_insert,
                   c.user_update,
                   c.date_update,
                   c.site,
                   av.viagem_id,
                   (select max(ctc.conhecimento_id)
                     from oper.v$contrato_transp_conhecimento ctc
                    where ctc.lancto_id = c.lancto_id) as conhecimento_id
                   ,(select max(co.num_conhecimento) keep(dense_rank last order by ctc.conhecimento_id)
                     from oper.v$contrato_transp_conhecimento ctc
                     inner join fiscal.v$conhecimento co
                             on co.conhecimento_id = ctc.conhecimento_id
                    where ctc.lancto_id = c.lancto_id) as num_conhecimento
                   ,(select ctc.conhecimento_id
                     from oper.v$contrato_transp_intc_crt ctc
                    where ctc.lancto_id = c.lancto_id) as intc_conhecimento_id
                   ,(select upper(crt.numero_cod_pais || '.' || crt.numero_certificado || '.' || replace(replace(to_char(crt.numero_sequencial, '000,000'), ',', '.'), ' ', ''))
                     from oper.v$contrato_transp_intc_crt ctc
                     inner join fiscal.v$intc_conhecimento crt
                             on crt.conhecimento_id = ctc.conhecimento_id
                    where ctc.lancto_id = c.lancto_id) as num_crt              
              from oper.v$contrato_transp c
             inner join oper.v$contrato_transp_form cf
                     on cf.documento_id = c.lancto_id
              left join oper.v$agreg_viagem av
                     on av.lancto_id = c.lancto_id
             where 1 = 1
               and c.lancto_id_pai is null
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
               and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and c.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.placa_controle))>
               and (c.placa_controle = '#arguments.placa_controle#' 
                    or oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_controle) = '#arguments.placa_controle#')
            </cfif>
            <cfif Len(Trim(arguments.proprietario_cod_pessoa))>
               and c.proprietario_cod_pessoa = #arguments.proprietario_cod_pessoa#
            </cfif>
			<cfif Len(Trim(arguments.num_formulario))>
               and c.num_formulario = #arguments.num_formulario#
            </cfif>
            
            <cfif Len(Trim(arguments.serie_formulario))>
               and upper(c.serie_formulario) = upper('#arguments.serie_formulario#')
            </cfif>
            <cfif Len(Trim(arguments.lancto_id))>
               and c.lancto_id = #arguments.lancto_id#
            </cfif>
            <cfif Len(Trim(arguments.cancelada))>
				<cfif arguments.cancelada eq 1>
                	and c.data_cancelamento is not null
                <cfelse>
                	and c.data_cancelamento is null
                </cfif>
            </cfif>
            <cfif Len(Trim(arguments.tipo_contrato))>
               and c.tipo_contrato = #arguments.tipo_contrato#
            </cfif>
			<cfif Len(Trim(arguments.data_inicial))>
               and trunc(c.data_emissao) >= '#arguments.data_inicial#'
            </cfif>
            <cfif Len(Trim(arguments.data_final))>
               and trunc(c.data_emissao) <= '#arguments.data_final#'
            </cfif>
             order by c.data_emissao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

</cfcomponent>