<cfcomponent extends="_transportes.funcoes.cfc_init">

   <!---
	-- PROPSITO
	-- Consulta os roteiros cadastrados na Target
	-- Alex 28/09/2017
	--->
	<cffunction name='consulta_roteiros' displayname='Consulta os roteiros cadastrados na Target' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='target.pkg_target.prc_consulta_roteiros' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Solicita um roteiro
	-- Alex 28/09/2017
	--->
	<cffunction name='solicita_roteiro' displayname='Solicita um roteiro' access='remote' returntype='Struct' output='true'>
	<cfargument name='ROTA_ID' required='yes'>
	<cfargument name='CATEGORIA_VEICULO' required='yes'>
	<cfargument name='MODO_VALE_PEDAGIO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='target.pkg_target.prc_obtem_custo_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CATEGORIA_VEICULO#'  null='#iif(len(trim(arguments.CATEGORIA_VEICULO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODO_VALE_PEDAGIO#'  null='#iif(len(trim(arguments.MODO_VALE_PEDAGIO)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_PEDAGIO_ROTA' >
			</cfstoredproc>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Roteiro solicitado com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Verifica o roteiro e retorna o valor de pedgio
    -- ANDERSONC 30/05/2012 - ALTERADO
    --->
    <cffunction name='verificar_roteiro' displayname='Verifica o roteiro e retorna o valor de pedgio' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
        <cfargument name='ROTA_ID' required='no' default=''>
        <cfargument name='PLACA_CAVALO' required='no' default=''>
        <cfargument name='PLACA_CARRETA' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='target.pkg_logistica.prc_verificar_roteiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_PEDAGIO_ROTA' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao para Verificar Roteiro na Target enviada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Verifica o carto
    -- ANDERSONC 30/05/2012 - ALTERADO
    --->
    <cffunction name='verificar_cartao' displayname='Verifica o carto' access='remote' returntype='Struct' output='true'>
        <cfargument name='CARTAO_NUMERO' required='no' default=''>
        <cfargument name='MOTORISTA_COD_PESSOA' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='target.pkg_logistica.prc_verificar_cartao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTORISTA_COD_PESSOA#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao para Verificar Carto na Target enviada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Verifica os dados do contratado, motorista, cavalo e carreta
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='verificar_dados' displayname='Verifica os dados do contratado, motorista, cavalo e carreta' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
		<cfargument name='PLACA_CAVALO' required='no' default=''>
		<cfargument name='PLACA_CARRETA' required='no' default=''>
		<cfargument name='COD_MOTORISTA' required='no' default=''>
		<cfargument name='COD_CONTRATADO' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_logistica.prc_verificar_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CONTRATADO#'  null='#iif(len(trim(arguments.COD_CONTRATADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao para Atualizar Cadastros na Target enviada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Integra um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='integrar_contrato' displayname='Integra um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_contrato.prc_integrar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato integrado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Emite um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='emitir_contrato' displayname='Emite um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='ROTA_ID' required='no' default=''>
		<cfargument name='CARTAO_NUMERO' required='no' default="">
		<cfargument name='MODO_COMPRA_VALE_PEDAGIO' required='yes'>
		<cfargument name='CARTAO_PEDAGIO_NUMERO' required='no' default="">
		<cfargument name='PERMITE_QUITACAO_POSTO' required='no' default="">
		<cftry>
            <cfstoredproc procedure='target.pkg_contrato.prc_emitir_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTRATO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO#' null='#iif(len(trim(arguments.CARTAO_NUMERO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODO_COMPRA_VALE_PEDAGIO#'  null='#iif(len(trim(arguments.MODO_COMPRA_VALE_PEDAGIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_PEDAGIO_NUMERO#' null='#iif(len(trim(arguments.CARTAO_PEDAGIO_NUMERO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERMITE_QUITACAO_POSTO#'  null='#iif(len(trim(arguments.PERMITE_QUITACAO_POSTO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Contrato emitido com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Gera o PDF de impresso de um contrato
	-- Alex 05/10/2017
	--->
	<cffunction name='gera_contrato' displayname='Gera o PDF de impresso de um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_impressao.prc_gera_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impresso gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Cancela um contrato
	-- Alex 05/10/2017
	--->
	<cffunction name='cancelar_contrato' displayname='Cancela um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_contrato.prc_cancelar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato cancelado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere um dbito/crdito em um contrato
	-- Alex 05/10/2017
	--->
	<cffunction name='debito_credito_contrato' displayname='Insere um dbito/crdito em um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='USUARIO_LIBERACAO' required='yes'>
		<cfargument name='SENHA_LIBERACAO' required='yes'>
        <cfargument name='DEBITO_CREDITO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_contrato.prc_debito_credito_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' value='#arguments.USUARIO_LIBERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' value='#arguments.SENHA_LIBERACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
                <cfif arguments.DEBITO_CREDITO eq 1>
					<cfset retorno.mensagem = JSStringFormat('Dbito inserido com sucesso.')>
                <cfelse>
                	<cfset retorno.mensagem = JSStringFormat('Crdito inserido com sucesso.')>
                </cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Quita um contrato
	-- Alex 05/10/2017
	--->
	<cffunction name='quitar_contrato' displayname='Quita um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
        <cfargument name='PESO_ENTREGA' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfset v_atualiza_contrato = 0>
				
				<cfscript>
					conn = CreateComponent("modulos.target._componentes.manipulacao.cfc_target");
					
					v_cartao            = this.ListaToArray (lista = arguments, variavel = "TARGET_QUITACAO_CARTAO");
					v_parcela_id        = this.ListaToArray (lista = arguments, variavel = "TARGET_QUITACAO_CONTRATO_PARCELA_ID");
					v_data_pagto        = this.ListaToArray (lista = arguments, variavel = "TARGET_QUITACAO_DATA_PAGTO");
					v_valor             = this.ListaToArray (lista = arguments, variavel = "TARGET_QUITACAO_VALOR");
				</cfscript>
				
				<cfloop from="1" to="#ArrayLen(v_cartao)#" index="count">
					<cfscript>
						ret_cartao = conn.atualizar_parcela_quitacao( contrato_parcela_id  = v_parcela_id[count]
														            , cartao               = v_cartao[count]
														            , data_pagamento       = v_data_pagto[count]
														            );
						if (v_atualiza_contrato eq 0){
							v_atualiza_contrato = ret_cartao.atualizar_contrato;
						}
					</cfscript>
					<cfif ret_cartao.erro>
						<cfthrow object="#ret_cartao.mensagem#">
					</cfif>
				</cfloop>
				
				<cfstoredproc procedure='target.pkg_contrato.prc_quitar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_ENTREGA#'  null='#iif(len(trim(arguments.PESO_ENTREGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#v_atualiza_contrato#'  null='#iif(len(trim(v_atualiza_contrato)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato quitado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Consulta um contrato
	-- Alex 05/10/2017
	--->
	<cffunction name='consulta_contrato' displayname='Consulta um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='ATUALIZA_CONTRATO' required='yes' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_target.prc_buscar_op_transp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATUALIZA_CONTRATO#'  null='#iif(len(trim(arguments.ATUALIZA_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato consultado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera o modo de pagamento do pedagio do contrato
	-- Alex 06/10/2017
	--->
	<cffunction name='alterar_modo_pedagio' displayname='Altera o modo de pagamento do pedagio do contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='MODO_COMPRA_VALE_PEDAGIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_contrato.prc_alt_modo_compra_vale_pedag' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODO_COMPRA_VALE_PEDAGIO#'  null='#iif(len(trim(arguments.MODO_COMPRA_VALE_PEDAGIO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modo de pagamento de pedgio alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	<!---
	-- PROPSITO
	-- Vincular cartes a um contrato
	-- LEANDRO.SILVA 04/01/2018
	--->
	<cffunction name='vincular_cartao_contrato' displayname='Vincula cartes ao contrato Target' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID'          required='yes'>
		<cfargument name='CARTAO'               required='yes'>
		<cfargument name='ALIQUOTA'             required='yes'>
		<cfargument name='TIPO_PAGAMENTO'       required='yes'>
		<cfargument name='DATA_PAGAMENTO'       required='no' default="">
		<cfargument name='PAGAMENTO_AUTOMATICO' required='no' default="">
		<cftry>
            <cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_target_dml.prc_ins_contrato_cartao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'             value='#arguments.CARTAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALIQUOTA#'  null='#iif(len(trim(arguments.ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'             value='#arguments.TIPO_PAGAMENTO#'  null='#iif(len(trim(arguments.TIPO_PAGAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'             value='#arguments.DATA_PAGAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'             value='#arguments.PAGAMENTO_AUTOMATICO#'  null='#iif(len(trim(arguments.PAGAMENTO_AUTOMATICO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carto vinculado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!---
	-- PROPSITO
	-- Vincular cartes a um contrato
	-- LEANDRO.SILVA 04/01/2018
	--->
	<cffunction name='validar_vinculo_contrato_cartao' displayname='Valida vnculo entre cartes e contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
            <cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_contrato.prc_valida_contrato_cartao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Validao de vnculo entre carto e contrato executada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!---
	-- PROPSITO
	-- Gera o PDF de impresso do vale pedgio do contrato
	-- LEANDRO.SILVA 07/03/2018
	--->
	<cffunction name='gera_impressao_vale_pedagio' displayname='Gera o PDF de impresso do vale pedgio do contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_impressao.prc_gera_vale_pedagio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impresso gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!---
	-- PROPSITO
	-- Atualiza parcela para pagamento na quitao
	-- LEANDRO.SILVA 09/03/2018
	--->
	<cffunction name='atualizar_parcela_quitacao' displayname='Atualiza parcela para pagamento na quitao' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_PARCELA_ID'  required='yes'>
		<cfargument name='CARTAO'               required='yes'>
		<cfargument name='DATA_PAGAMENTO'       required='yes'>
		<cftry>
            <cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_target_dml.prc_alt_contrato_parcela_quit' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_PARCELA_ID#'  null='#iif(len(trim(arguments.CONTRATO_PARCELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'             value='#arguments.CARTAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'             value='#arguments.DATA_PAGAMENTO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ATUALIZAR_CONTRATO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Parcela atualizada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<cffunction name='ins_vinculo_manual_cartao' displayname='Vinculo entre motorista e carto' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_MOTORISTA'     required='yes'>
		<cfargument name='COD_TRANSPORTADOR' required='yes'>
		<cfargument name='CARTAO'            required='yes'>
		<cfargument name='VALE_PEDAGIO'      required='yes'>
		<cftry>
            <cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_target.prc_ins_vinculo_manual_cartao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'    value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'    value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'    value='#arguments.CARTAO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'    value='#arguments.VALE_PEDAGIO#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC'   variable='retorno.CARTAO_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carto vinculado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<cffunction name='alt_vinculo_manual_cartao' displayname='Atualizar vinculo entre motorista e carto' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARTAO_ID'    required='yes'>
		<cfargument name='VALE_PEDAGIO' required='yes'>
		<cftry>
            <cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_target.prc_alt_vinculo_manual_cartao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'    value='#arguments.CARTAO_ID#'  null='#iif(len(trim(arguments.CARTAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'    value='#arguments.VALE_PEDAGIO#'  null='#iif(len(trim(arguments.VALE_PEDAGIO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carto alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<cffunction name='del_vinculo_manual_cartao' displayname='Atualizar vinculo entre motorista e carto' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARTAO_ID'    required='yes'>
		<cftry>
            <cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_target_dml.prc_del_cartao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'    value='#arguments.CARTAO_ID#'  null='#iif(len(trim(arguments.CARTAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carto excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<cffunction name='pagar_adiantamento' displayname='Valida vnculo entre cartes e contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
            <cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_contrato.prc_pagar_adto_auto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pagamento de adiantamento realizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<cffunction name='atualizar_situacao_pedagio' displayname='Valida vnculo entre cartes e contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID'    required='no' default="">
		<cfargument name='LANCAR_EXCECAO' required='no' default="0">
		<cftry>
            <cftransaction action='begin'>
				<cfstoredproc procedure='target.pkg_contrato.prc_atualizar_situacao_pedagio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.LANCAR_EXCECAO#'  null='#iif(len(trim(arguments.LANCAR_EXCECAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Situao dos pedgios atualizadas.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>
