<cfcomponent extends="_transportes.funcoes.cfc_init">
       <!---
    -- PROPSITO
    -- Retorna o XML de Envio de uma requisio
    -- Luiz 21/09/2017
    --->
    <cffunction name="get_requisicao_xml_envio" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.xml_envio
              from target.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


	    <!---
    -- PROPSITO
    -- Retorna o XML de Retorno de uma requisio
    -- Luiz 21/09/2017
    --->
    <cffunction name="get_requisicao_xml_retorno" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.xml_retorno
              from target.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna o Erro de uma requisio
    -- Luiz 21/09/2017
    --->
    <cffunction name="get_requisicao_erro" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.erro
              from target.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	    <!---
    -- PROPSITO
    -- Retorna os mtodos da Target
    -- Luiz 21/09/2017
    --->
    <cffunction name="get_metodo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.metodo
              from target.v$metodo m
        </cfquery>
        <cfreturn qr_result>
    </cffunction>



	 <!---
    -- PROPSITO
    -- Retorna as requisies da Target
    -- Luiz 21/09/2017
    --->
    <cffunction name="get_requisicao" access="remote" returntype="query" output="true">
    	<cfargument name="metodo" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.requisicao_id
                 , r.metodo
                 , kss.to_tempo(r.tempo_execucao, 5).retorno as tempo_execucao
                 , case
                      when r.erro is not null then 1
                      else 0
                   end as possui_erro
                 , r.user_insert
                 , to_char(r.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , r.user_update
                 , to_char(r.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
	          from target.v$requisicao r
             where 1 = 1
			<cfif Len(Trim(arguments.metodo))>
               and upper(r.metodo) = upper('#arguments.metodo#')
			</cfif>

            <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
               and r.data_requisicao between to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
			<cfelseif Len(Trim(arguments.data_inicio))>
               and r.data_requisicao >= to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss')
			<cfelseif Len(Trim(arguments.data_termino))>
               and r.data_requisicao <= to_date('#arguments.data_termino#:00', 'dd/mm/yyyy hh24:mi:ss')
			</cfif>
             order by r.date_insert desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os roteiros de uma requisio
    -- Alex 28/09/2017
    --->
    <cffunction name="get_roteiro" access="remote" returntype="Struct" output="true">
    	<cfargument name="origem_municipio_id" required="no" default="" />
        <cfargument name="destino_municipio_id" required="no" default="" />
		<cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="tipo_integracao" required="yes" default="1" />
        <cftry>
        	<cftransaction action='begin'>
                <cfscript>
					conn = CreateComponent("modulos.target._componentes.manipulacao.cfc_target");
                    ret_cons_rot = conn.consulta_roteiros(ORIGEM_MUNICIPIO_ID  = arguments.origem_municipio_id,
														  DESTINO_MUNICIPIO_ID = arguments.destino_municipio_id,
														  NUM_ROMANEIO         = arguments.num_romaneio);
                </cfscript>
                <cfif ret_cons_rot.erro>
                    <cfthrow object="#ret_cons_rot.mensagem#">
                </cfif>

                <cfquery name="qr_roteiro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select distinct
                           r.roteirizacao_id
                         , r.rota_id
                         , r.codigo_rota_target
						             , r.km_rota_target
                         , r.rota_ok
                         , ro.descricao_via
                         , ro.descricao_rota
                         , mo.municipio as cidade_origem
                         , mo.uf_id as estado_origem
                         , md.municipio as cidade_destino
                         , md.uf_id as  estado_destino
                      from target.v$roteirizacao r
                     inner join oper.v$rota ro
                        on ro.rota_id = r.rota_id
                     inner join cep.municipio mo
                        on mo.municipio_id = ro.origem_municipio_id
                     inner join cep.municipio md
                        on md.municipio_id = ro.destino_municipio_id
                     where ro.ORIGEM_MUNICIPIO_ID = #arguments.origem_municipio_id#
                       and ro.destino_municipio_id = #arguments.destino_municipio_id#
                </cfquery>

                <cfset retorno.qr_roteiro = qr_roteiro>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>

    <cffunction name="get_pedagios_rota" access="remote" returntype="query" output="true">
    	<cfargument name="roteirizacao_valor_id" required="no" default="-1"/>
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rvp.roteirizacao_praca_id
			     , rvp.roteirizacao_valor_id
			     , rvp.ordem
			     , rvp.concessionaria
			     , rvp.praca
			     , rvp.valor_pedagio
			     , rvp.user_insert
			     , rvp.date_insert
			     , rvp.user_update
			     , rvp.date_update
			  from target.v$roteirizacao_valor_pracas rvp
			  where rvp.roteirizacao_valor_id = #arguments.roteirizacao_valor_id#
			  order by ordem
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPSITO
    -- Retorna o status de validao das integraes com a Repom
    -- ANDERSON 22/09/2011 - CRIADO
    --->
    <cffunction name="get_validacao_romaneio" access="remote" returntype="Struct" output="true">
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="cartao_numero" required="no" default="" />
        <cfargument name="rota_id" required="no" default="" />
        <cfargument name="cod_contratado" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="placa_cavalo" required="no" default="" />
        <cfargument name="placa_carreta" required="no" default="" />
        <cftry>
        	<cftransaction action='begin'>
				<cfif arguments.placa_referencia eq arguments.placa_cavalo>
                    <cfset arguments.placa_referencia = '' />
                </cfif>

                <cfscript>
                    conn = CreateComponent("modulos.target._componentes.manipulacao.cfc_target");
                </cfscript>


				<!---
                <cfscript>
                    ret_antt = conn.retorno_antt(placa_cavalo   = arguments.placa_cavalo
                                                ,placa_carreta  = arguments.placa_carreta
                                                ,cod_contratado = arguments.cod_contratado);

                </cfscript>
                <cfif ret_antt.erro>
                    <cfthrow object="#ret_antt.mensagem#">
                </cfif>

                <cfset retorno.veiculo_validado_antt = ret_antt.veiculo_validado_antt>
                <cfset retorno.veiculo_erro = ret_antt.veiculo_erro>
                <cfset retorno.carreta_validado_antt = ret_antt.carreta_validado_antt>
                <cfset retorno.carreta_erro = ret_antt.carreta_erro>
                <cfset retorno.contratado_validado_antt = ret_antt.contratado_validado_antt>
                <cfset retorno.contratado_erro = ret_antt.contratado_erro>
				--->

                <cfif Len(Trim(arguments.num_romaneio))>
                    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" debug="yes">
                        select case
                                  when '#arguments.cartao_numero#' is not null then
                                     (select sign(count(1))
                                        from target.v$cartao c
                                       where c.cartao_numero = '#arguments.cartao_numero#'
                                         and c.requisicao_id is not null
                                     )
                                  else
                                     0
                               end as cartao_ok
                             , case
                                  when '#arguments.rota_id#' is not null then
                                     target.pkg_logistica.fnc_rota_ok(null, v.viagem_id, '#arguments.rota_id#', case
																						                            when '#arguments.placa_cavalo#' is not null then
																						                            	oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_referencia#')
																						                            else 0
																					                            end)
                                  else 0
                               end as rota_ok
							 , case
						          when '#arguments.rota_id#' is not null then
						           target.pkg_logistica.fnc_roteirizacao_id('#arguments.rota_id#', case
																			                            when '#arguments.placa_cavalo#' is not null then
																			                            	oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_referencia#')
																			                            else 0
																		                            end)
						          else
						           null
						       end as roteirizacao_id
                             , case
                                  when '#arguments.cod_contratado#' is not null then
                                     target.pkg_logistica.fnc_contratado_ok(null, v.viagem_id, '#arguments.cod_contratado#')
                                  else 0
                               end as contratado_ok
                             , case
                                  when '#arguments.cod_motorista#' is not null then
                                     target.pkg_logistica.fnc_motorista_ok(null, v.viagem_id, '#arguments.cod_motorista#')
                                  else 0
                               end as motorista_ok
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     target.pkg_logistica.fnc_veiculo_ok(null, v.viagem_id, '#arguments.placa_cavalo#')
                                  else 0
                               end as cavalo_ok
                             , case
                                  when '#arguments.placa_referencia#' is not null then
                                     target.pkg_logistica.fnc_veiculo_ok(null, v.viagem_id, '#arguments.placa_referencia#')
                                  else 1
                               end as carreta_ok
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_referencia#')
                                  else 0
                               end as numero_eixos
                          from logistica.v$viagem v
                         where v.num_romaneio = #arguments.num_romaneio#
                    </cfquery>
                <cfelse>
                    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        select (select sign(count(1))
                                  from target.v$cartao c
                                 where c.cartao_numero = '#arguments.cartao_numero#'
                                   and c.requisicao_id is not null
                               ) as cartao_ok
                             , case
                                  when '#arguments.rota_id#' is not null then
                                     target.pkg_logistica.fnc_rota_ok(null, null, '#arguments.rota_id#', case
																						                 	when '#arguments.placa_cavalo#' is not null then
																						                 		oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_referencia#')
																						                 	else 0
																					                     end)
                                  else 0
                               end as rota_ok
							 , case
						          when '#arguments.rota_id#' is not null then
						           target.pkg_logistica.fnc_roteirizacao_id('#arguments.rota_id#', case
																			                            when '#arguments.placa_cavalo#' is not null then
																			                            	oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_referencia#')
																			                            else 0
																		                            end)
						          else
						           null
						       end as roteirizacao_id
                             , case
                                  when '#arguments.cod_contratado#' is not null then
                                     target.pkg_logistica.fnc_contratado_ok(null, null, '#arguments.cod_contratado#')
                                  else 0
                               end as contratado_ok
                             , case
                                  when '#arguments.cod_motorista#' is not null then
                                     target.pkg_logistica.fnc_motorista_ok(null, null, '#arguments.cod_motorista#')
                                  else 0
                               end as motorista_ok
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     target.pkg_logistica.fnc_veiculo_ok(null, null, '#arguments.placa_cavalo#')
                                  else 0
                               end as cavalo_ok
                             , case
                                  when '#arguments.placa_referencia#' is not null then
                                     target.pkg_logistica.fnc_veiculo_ok(null, null, '#arguments.placa_referencia#')
                                  else 0
                               end as carreta_ok
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_referencia#')
                                  else 0
                               end as numero_eixos
                          from dual
                    </cfquery>
        		</cfif>
                <cfset retorno.query = qr_result>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>

	<!---
    -- PROPSITO
    -- Retorna o histrico da utilizao dos cartes Repom
    -- ANDERSON 10/09/2011 - CRIADO
    --->
    <cffunction name="get_historico_cartao" access="remote" returntype="query" output="true">
    	<cfargument name="cartao_numero" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="cod_proprietario" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.contrato_id
                 , t.processo_transporte_codigo
                 , t.num_romaneio
                 , t.unidade_negocio
                 , t.centro_custo
                 , t.cartao_numero
                 , t.proprietario_cnpj_cpf
                 , t.proprietario_razao_social
                 , t.proprietario
                 , t.motorista_cpf
                 , t.motorista
                 , t.cod_veiculo_cavalo
                 , t.placa_cavalo
                 , t.cod_veiculo_carreta
                 , t.placa_carreta
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , t.usuario_cancelamento
                 , to_char(t.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
                 , (select count(*)
                      from target.v$contrato co
                     where co.cartao_id = t.cartao_id
                       ) as num_contratos
              from (
                    select ct.contrato_id
                         , ct.processo_transporte_codigo
                         , ct.num_romaneio
                         , (select o.cod_unidade_negocio || ' - ' || kss.pkg_pessoa.fnc_get_cliente(o.cod_pessoa, 1)
                              from logistica.v$viagem v
                             inner join logistica.v$viagem_carga vc
                                     on vc.viagem_id = v.viagem_id
                             inner join logistica.v$solicitacao_carga sc
                                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = sc.cod_organograma
                             where v.num_romaneio = ct.num_romaneio
                               and rownum = 1
                           ) as unidade_negocio
                         , (select o.cod_centro_custo || ' - ' || cc.centro_custo
                              from logistica.v$viagem v
                             inner join logistica.v$viagem_carga vc
                                     on vc.viagem_id = v.viagem_id
                             inner join logistica.v$solicitacao_carga sc
                                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = sc.cod_organograma
                             inner join kss.v$centro_custo cc
                                     on cc.cod_centro_custo = o.cod_centro_custo
                             where v.num_romaneio = ct.num_romaneio
                               and rownum = 1
                           ) as centro_custo
                         , c.cartao_numero
                         , c.cartao_id
                         , kss.pkg_pessoa.fnc_get_identificador(ct.cod_proprietario) as proprietario_cnpj_cpf
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_proprietario) as proprietario_razao_social
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_proprietario, 1) as proprietario
                         , kss.pkg_pessoa.fnc_get_identificador(ct.cod_motorista) as motorista_cpf
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_motorista, 1) as motorista
                         , oper.pkg_veiculo.fnc_placa(ct.veiculo_id_cavalo) as placa_cavalo
                         , oper.pkg_veiculo.fnc_cod_veiculo(ct.veiculo_id_cavalo) as cod_veiculo_cavalo
                         , oper.pkg_veiculo.fnc_placa(ct.veiculo_id_carreta) as placa_carreta
                         , oper.pkg_veiculo.fnc_cod_veiculo(ct.veiculo_id_carreta) as cod_veiculo_carreta
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento
                      from target.v$contrato ct
                     inner join target.v$cartao c
                             on c.cartao_id = ct.cartao_id
                     where 1 = 1
                       and (
                            <cfif Len(Trim(arguments.cartao_numero))>
								c.cartao_numero = to_char('#arguments.cartao_numero#')
                            </cfif>

                            <cfif Len(Trim(arguments.cod_motorista))>
								<cfif Len(Trim(arguments.cartao_numero))>
                                	or
                                </cfif>
                                ct.cod_motorista = #arguments.cod_motorista#
                            </cfif>

                            <cfif Len(Trim(arguments.cod_proprietario))>
                            	<cfif Len(Trim(arguments.cartao_numero)) or Len(Trim(arguments.cod_motorista))>
                                    or
                                </cfif>
                                ct.cod_proprietario = #arguments.cod_proprietario#
                            </cfif>
                           )
                     order by ct.date_insert desc
                   ) t
             where rownum <= 10
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPSITO
    -- Retorna os contratos
    -- ANDERSONC 01/11/2011 - CRIADO
    --->
    <cffunction name="get_contrato" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="no" default="" />
        <cfargument name="solicitacao_carga_id" required="no" default="" />
        <cfargument name="viagem_id" required="no" default="" />
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="processo_transporte_codigo" required="no" default="" />
        <cfargument name="lancto_id" required="no" default="" />
        <cfargument name="cod_pessoa_filial" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="placa_cavalo" required="no" default="" />
        <cfargument name="placa_carreta" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="tipo_contrato" required="no" default="" />
        <cfargument name="internacional" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.contrato_id
                 , c.tipo_contrato
                 , c.tipo_contrato_desc
                 , decode(c.internacional,0,'No','Sim') as internacional
                 , c.num_romaneio
                 , c.diaria_ctrc_id
                 , c.diaria_crt_id
                 , c.divisao_id
                 , c.lancto_id
                 , c.processo_cliente_codigo
                 , c.processo_transporte_codigo
                 , c.cod_unidade_negocio
                 , c.filial
                 , c.cod_centro_custo
                 , c.centro_custo
                 , to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , c.situacao_id
                 , c.situacao
                 , c.modo_compra_vale_pedagio
                 , c.modo_compra_vale_ped_desc
                 , c.status_codigo
                 , (select kss.fnc_concat_all(kss.to_concat_expr(card.cartao_numero,', '))
                      from target.v$cartao card
                     where card.cartao_id in (select cc.cartao_id
                                                from target.v$contrato_cartao cc
                                               where cc.contrato_id = c.contrato_id)) as cartao_numero
                 , c.cnpj_cpf_proprietario
                 , c.proprietario
                 , c.cpf_motorista
                 , c.motorista
                 , c.cod_veiculo_cavalo
                 , c.placa_cavalo
                 , c.cod_veiculo_carreta
                 , c.placa_carreta
                 , c.rota_id
                 , c.rota
                 , c.valor_inicial_adiantamento
                 , c.valor_inicial_frete
                 , c.valor_frete_bruto
                 , c.percentual_receita
                 , c.user_insert
                 , to_char(c.date_insert, 'dd/mm/yyyy hh24:mi') as date_insert
                 , c.usuario_cancelamento
                 , to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi') as data_cancelamento
                 , c.contrato_quitado
                 , c.usuario_quitacao
                 , to_char(c.data_quitacao, 'dd/mm/yyyy hh24:mi') as data_quitacao
                 , c.quitacao_quebra_peso
                 , c.modalidade_veiculo
                 , ct.valor_frete_liquido +
                 	nvl((select sum(cti.valor * decode(cti.desconto,0,1,-1))
	                       from oper.v$contrato_transp_item cti
	                      where cti.lancto_id = ct.lancto_id
	                        and cti.compoe_frete = 1
							and cti.desconto = 0
	                        and cti.data_cancelamento is null),0) as valor_frete_bruto_atual
                 , nvl(ct.valor_maximo_tabela_frete, 0) + nvl(ct.valor_maximo_pedagio, 0) as valor_maximo_gravado
				 , c.id_compra_vale_pedagio
				 , c.adto_pago
				 , c.tem_adto
				 , ct.observacao_aprovacao
				 , c.situacao_pedagio
				 , c.status_pedagio_codigo
              from target.v$contrato_dados c
              left join oper.v$contrato_transp ct
                on ct.lancto_id = c.lancto_id
             where 1 = 1
            <cfif Len(Trim(arguments.contrato_id))>
              and c.contrato_id = #arguments.contrato_id#
            <cfelseif Len(Trim(arguments.solicitacao_carga_id))>
               and exists (select 1
                             from logistica.v$viagem v
                            inner join logistica.v$viagem_carga vc
                                    on vc.viagem_id = v.viagem_id
                            where v.num_romaneio = c.num_romaneio
                              and vc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
                          )
            <cfelseif Len(Trim(arguments.viagem_id))>
               and exists (select 1
                             from logistica.v$viagem v
                            where v.num_romaneio = c.num_romaneio
                              and v.viagem_id = #arguments.viagem_id#
                          )
            <cfelseif Len(Trim(arguments.num_romaneio))>
               and c.num_romaneio = #arguments.num_romaneio#
            <cfelseif Len(Trim(arguments.processo_transporte_codigo))>
               and c.processo_transporte_codigo = #arguments.processo_transporte_codigo#
            <cfelseif Len(Trim(arguments.lancto_id))>
               and c.lancto_id = #arguments.lancto_id#
            <cfelse>
				<cfif Len(Trim(arguments.cod_pessoa_filial))>
                   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                </cfif>
                <cfif Len(Trim(arguments.cod_centro_custo))>
                   and c.cod_centro_custo = #arguments.cod_centro_custo#
                </cfif>
                <cfif Len(Trim(arguments.placa_cavalo))>
                   and c.placa_cavalo = '#arguments.placa_cavalo#'
                </cfif>
                <cfif Len(Trim(arguments.placa_carreta))>
                   and c.placa_carreta = '#arguments.placa_carreta#'
                </cfif>
                <cfif Len(Trim(arguments.cod_motorista))>
                   and c.cod_motorista = #arguments.cod_motorista#
                </cfif>
                <cfif Len(Trim(arguments.tipo_contrato))>
                   and c.tipo_contrato = #arguments.tipo_contrato#
                </cfif>
                <cfif Len(Trim(arguments.internacional))>
                   and c.internacional = #arguments.internacional#
                </cfif>

                <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                   and c.date_insert between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                <cfelseif Len(Trim(arguments.data_inicio))>
                   and c.date_insert >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
                <cfelseif Len(Trim(arguments.data_termino))>
                   and c.date_insert <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                </cfif>
			</cfif>
			<cfif IsDefined('arguments.modalidade_veiculo') and Len(Trim(arguments.modalidade_veiculo))>
               and upper(c.modalidade_veiculo) = upper('#arguments.modalidade_veiculo#')
            </cfif>
             order by c.processo_transporte_codigo
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os dados do romaneio/target
    -- Alex 05/10/2017
    --->
    <cffunction name="get_dados_contrato" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="" />
    	<cfargument name="contrato_id" required="no" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.contrato_id
                 , c.processo_transporte_codigo
                 , c.num_romaneio
                 , c.lancto_id
                 , (select ca.cartao_numero
                      from target.v$cartao ca
                     where ca.cartao_id = c.cartao_id
                   ) as cartao_numero
                 , c.valor_inicial_adiantamento
                 , c.valor_inicial_frete
                 , c.usuario_cancelamento
                 , to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi') as data_cancelamento
                 , case when c.data_quitacao is null then 0 else 1 end contrato_quitado
                 , c.usuario_quitacao
				 , to_char(c.data_quitacao, 'dd/mm/yyyy hh24:mi') as data_quitacao
                 , 0 as contrato_pagamento
                 , (select un.cod_unidade_negocio || ' - ' || kss.pkg_pessoa.fnc_get_cliente(un.cod_pessoa, 1)
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = c.cod_pessoa_filial) as unidade_negocio
			     , c.peso_final
                 , (select ct.peso
                      from oper.v$contrato_transp ct
                     where ct.lancto_id = c.lancto_id  ) as peso_carga
				 , (select sum(cp.valor)
					  from target.v$contrato_parcela cp
					 where cp.contrato_id = c.contrato_id ) as total_parcelas
			     , kss.fnc_ref_code('TARGET', 'CONTRATO.SITUACAO_ID', c.situacao_id) as situacao
              from target.v$contrato c
             where 1 = 1
            <cfif Len(Trim(arguments.num_romaneio))>
               and c.num_romaneio = #arguments.num_romaneio#
            <cfelseif Len(Trim(arguments.contrato_id))>
               and c.contrato_id = #arguments.contrato_id#
            </cfif>
             order by c.processo_transporte_codigo
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os dados do romaneio de um contrato
    -- Alex 05/10/2017
    --->
    <cffunction name="get_contrato_dados_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="yes" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) as cod_veiculo_controle
                 , r.placa_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_referencia) as cod_veiculo_referencia
                 , r.placa_referencia
                 , r.carregamento
                 , r.destino
                 , r.remetente
                 , r.destinatario
                 , (select n.descricao
                      from logistica.v$viagem v
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = v.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     inner join oper.v$natureza n
                             on n.num_natureza = sc.num_natureza
                     where v.num_romaneio = r.num_romaneio
                       and rownum = 1
                   ) as natureza
                 , (select e.descricao
                      from logistica.v$viagem v
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = v.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     inner join oper.v$especie e
                             on e.num_especie = sc.num_especie
                     where v.num_romaneio = r.num_romaneio
                       and rownum = 1
                   ) as especie
                 , (select um.unidade
                      from logistica.v$viagem v
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = v.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     inner join fiscal.v$unidade_medida um
                             on um.cod_unidade = sc.cod_unidade
                     where v.num_romaneio = r.num_romaneio
                       and rownum = 1
                   ) as unidade
                 , (select sc.valor_em
                      from logistica.v$viagem v
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = v.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     where v.num_romaneio = r.num_romaneio
                       and rownum = 1
                   ) as frete_em
                 , r.peso_total
                 , r.peso_cobrado
                 , r.frete_total
                 , r.frete_liquido
                 , to_char(r.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
                 , to_char(r.data_destinado, 'dd/mm/yyyy hh24:mi') as data_destinado
                 , to_char(r.data_inicio_carga, 'dd/mm/yyyy hh24:mi') as data_inicio_carga
                 , to_char(r.data_termino_carga, 'dd/mm/yyyy hh24:mi') as data_termino_carga
                 , to_char(r.data_inicio_descarga, 'dd/mm/yyyy hh24:mi') as data_inicio_descarga
                 , to_char(r.data_termino_descarga, 'dd/mm/yyyy hh24:mi') as data_termino_descarga
              from oper.v$romaneio r
             where exists (select 1
                             from target.v$contrato c
                            where c.num_romaneio = r.num_romaneio
                              and c.contrato_id = #arguments.contrato_id#
                          )
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os dados do agendamento de um romaneio
    -- Alex 05/10/2017
    --->
    <cffunction name="get_agendamento_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.viagem_id
                 , logistica.pkg_agendamento.fnc_viagem_composicao_definida(v.viagem_id) as composicao
                 , (select oper.pkg_global.fnc_get_cod_funcionario(vmv.cod_motorista) || ' - ' || kss.pkg_pessoa.fnc_get_cliente(vmv.cod_motorista)
                      from logistica.v$viagem_motorista_veiculo vmv
                     where vmv.viagem_id = v.viagem_id
                       and vmv.cod_motorista is not null
                   ) as motorista
                 , to_char(v.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
                 , to_char(v.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
              from logistica.v$viagem v
             where v.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna as solicitaes de carga vinculadas a um Romaneio
    -- Alex 05/10/2017
    --->
    <cffunction name="get_solicitacoes" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sc.solicitacao_carga_id
                 , kss.pkg_pessoa.fnc_get_cliente(sc.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(sc.cod_destinatario) as destinatario
                 , cep.pkg_municipio.fnc_municipio_uf(sc.origem_municipio_id, ' - ') as origem
                 , cep.pkg_municipio.fnc_municipio_uf(sc.destino_municipio_id, ' - ') as destino
                 , (select n.descricao
                      from oper.v$natureza n
                     where n.num_natureza = sc.num_natureza
                   ) as natureza
              from logistica.v$solicitacao_carga sc
             inner join logistica.v$viagem_carga vc
                     on vc.solicitacao_carga_id = sc.solicitacao_carga_id
             inner join logistica.v$viagem v
                     on v.viagem_id = vc.viagem_id
              where v.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os dados dos itens de um romaneio agendamento de um romaneio
    -- Alex 05/10/2017
    --->
    <cffunction name="get_romaneio_itens" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select ri.operacao_id
                 , logistica.pkg_operacao.fnc_descricao_completa(ri.operacao_id) as operacao
                 , kss.pkg_pessoa.fnc_get_cliente(ri.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(ri.cod_destinatario) as destinatario
                 , case
                    when exists (select 1
                                   from fiscal.v$conhecimento c
                                  where c.num_romaneio = ri.num_romaneio
                                    and c.item_id = ri.item_id

                                 union all

                                 select 1
                                   from fiscal.v$nf_es_frete f
                                  where f.num_romaneio = ri.num_romaneio
                                    and f.item_id = ri.item_id

                                 union all

                                 select 1
                                   from oper.v$romaneio_intc_conhecimento c
                                  where c.num_romaneio = ri.num_romaneio
                                ) then 'Sim'
                     else 'No'
                   end as documento_emitido
                 , (select case
                             when o.internacional = 0 then 'No'
                             else 'Sim'
                           end as internacional
                      from logistica.v$operacao o
                     where o.operacao_id = ri.operacao_id
                   )as internacional
              from oper.v$romaneio_item ri
             where ri.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os itinerrios de um Romaneio
    -- Alex 05/10/2017
    --->
    <cffunction name="get_itinerarios" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select r.descricao_rota
                      from oper.v$rota r
                     where r.rota_id = ri.rota_id
                   ) as descricao
            	 , (select m.municipio || ' - ' || m.uf_id
                      from cep.municipio m
                     where m.municipio_id = ri.origem_municipio_id
                   ) as origem
                 , (select m.municipio || ' - ' || m.uf_id
                      from cep.municipio m
                     where m.municipio_id = ri.destino_municipio_id
                   ) as destino
                 , to_char(ri.data_previsao, 'dd/mm/yyyy hh24:mi') as data_previsao
              from oper.v$romaneio_itinerario ri
             where ri.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os documentos vinculados a um Romaneio
    -- Alex 05/10/2017
    --->
    <cffunction name="get_documentos" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select 'CTRC/CTe' as tipo
                 , to_char(c.num_conhecimento || '/' || c.serie) as num_documento
                 , to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_pessoa_filial) as filial
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_destinatario) as destinatario
                 , c.total_conhecimento as valor
              from fiscal.v$conhecimento c
             where c.num_romaneio = #arguments.num_romaneio#

              union all

            select 'NF Frete' as tipo
                 , to_char(nf.num_nota_fiscal || '/' || nf.serie) as num_documento
                 , to_char(nf.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , kss.pkg_pessoa.fnc_get_cliente(nf.cod_pessoa_filial) as filial
                 , kss.pkg_pessoa.fnc_get_cliente(f.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(f.cod_destinatario) as destinatario
                 , f.total_viagem as valor
              from fiscal.v$nf_es_frete f
             inner join fiscal.v$nf_es nf
                     on nf.num_nota_id = f.nf_es_id
             where f.num_romaneio = #arguments.num_romaneio#

              union all

            select 'CRT' as tipo
                 , to_char(c2.num_crt_completo) as num_documento
                 , to_char(c2.emissao_data, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , kss.pkg_pessoa.fnc_get_cliente(c2.cod_pessoa_filial) as filial
                 , kss.pkg_pessoa.fnc_get_cliente(c2.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(c2.cod_destinatario) as destinatario
                 , nvl((c2.total_custo_origem + c2.total_custo_destino * c2.cotacao), 0) as valor
              from oper.v$romaneio_intc_conhecimento ic
             inner join fiscal.v$intc_conhecimento c2
                     on c2.conhecimento_id = ic.conhecimento_id
             where ic.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os Contratos de Tranmsporte vinculados a um Romaneio
    -- Alex 05/10/2017
    --->
    <cffunction name="get_contrato_transp" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.lancto_id
                 , ct.num_formulario || '/' || ct.serie_formulario as num_contrato
                 , to_char(ct.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , kss.pkg_pessoa.fnc_get_cliente(ct.cod_pessoa_filial) as filial
                 , kss.pkg_pessoa.fnc_get_cliente(ct.proprietario_cod_pessoa) as proprietario
                 , kss.pkg_pessoa.fnc_get_cliente(ct.motorista_cod_pessoa) as motorista
                 , ct.valor_frete_bruto as valor
              from oper.v$contrato_transp ct
             where ct.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os Contratos de Tranmsporte vinculados a um Romaneio
    -- Alex 05/10/2017
    --->
    <cffunction name="get_contrato_transp_item_setup" access="remote" returntype="query" output="true">
    	<cfargument name="debito_credito" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ctis.item_id
                 , ctis.descricao
              from oper.v$contrato_transp_item_setup ctis
             where ctis.compoe_frete = 1
			   and exists (select 1
                             from oper.v$contrato_transp_it_stp_finan cf
                            where cf.item_id = ctis.item_id
                              and cf.tipo_pagto_id = 7
                          )
        	<cfif arguments.debito_credito eq 1>
               and ctis.desconto = 1
			   and ctis.gera_cpg = 1
               and ctis.item_id not in (oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'INSS')
                                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'IRRF')
                                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'SEST')
                                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'SENAT')
                                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'INSS'))
            <cfelseif arguments.debito_credito eq 2>
               and ctis.desconto = 0
            </cfif>
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca os tipos de veiculos
	-- Alex 06/10/2017
	--->
	<cffunction name="get_veiculo_tipo" access="remote" returntype="query" output="true">
		<cfquery name="qrTipoVeiculo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vt.veiculo_tipo_id
                 , vt.descricao
                 , vt.id_externo
                 , vt.numero_eixos
                 , vt.tipo_rodagem
              from target.v$veiculo_tipo vt
             order by to_number(vt.id_externo)
		</cfquery>
		<cfreturn qrTipoVeiculo>
	</cffunction>
	
	<!---
    -- PROPSITO
    -- Retorna as movimentaes do contrato
    -- Leandro Silva 14/12/2017
    --->
    <cffunction name="get_dados_contr_movimento" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="yes" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctis.descricao as descricao
                 , to_char(cti.valor, 'FM9G9999G990D00', 'nls_numeric_characters=,.') as valor
                 , to_char(cti.data_item, 'dd/mm/yyyy hh24:mi') as data
                 , decode(ctis.desconto, 1, 'Desconto', 'Acrscimo') as tipo
              from target.v$contrato c
             inner join oper.v$contrato_transp ct
                on ct.lancto_id = c.lancto_id
             inner join oper.v$contrato_transp_item cti
                on cti.lancto_id = ct.lancto_id
               and cti.data_cancelamento is null
             inner join oper.v$contrato_transp_item_setup ctis
                on ctis.item_id = cti.item_id
               and ctis.compoe_frete = 1
               and ctis.imprime_tarifa = 1
             where c.contrato_id = #arguments.contrato_id#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
	
	<!---
    -- PROPSITO
    -- Retorna as parcelas em aberto para que o usurio possa alterar o carto de pagamento
    -- Leandro Silva 09/03/2018
    --->
    <cffunction name="get_parcelas_quitacao" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="yes" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cp.contrato_parcela_id
				 , cp.valor
				 , (select c.cartao_numero
					  from target.v$cartao c
					 where c.cartao_id = cp.cartao_id) as cartao
				 , to_char(cp.data_vencimento, 'DD/MM/YYYY') as data_vencimento
			  from target.v$contrato_parcela cp
			 where cp.contrato_id = #arguments.contrato_id#
			   and cp.pago = 0
			   and cp.contrato_item_id is null
			   and cp.pagar_na_insercao = 0
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_cartao" access="remote" returntype="query" output="true">
        <cfargument name="cartao_id" required="no" default="">
        <cfargument name="cartao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.cartao_id
				 , c.cartao_numero as cartao
				 , case c.tipo
					  when 0 then 'Carto VTG 100 Pessoa Fsica'
					  else 'Carto VTG 200 Empresarial'
				   end as cartao_tipo
				 , c.vale_pedagio
				 , decode(c.vale_pedagio, 0, 'No', 'Sim') as vale_pedagio_desc
				 , c.cod_pessoa as cod_motorista
				 , mot.cliente as motorista
				 , mot.cnpj_cpf as motorista_cpf
				 , c.cod_pessoa_juridica as cod_transportador
				 , pj.cliente as transportador
				 , pj.cnpj_cpf as transportador_cnpj
				 , c.user_insert
				 , to_char(c.date_insert, 'DD/MM/YYYY HH24:MI:SS') as date_insert
				 , c.user_update
				 , to_char(c.date_update, 'DD/MM/YYYY HH24:MI:SS') as date_update
			  from target.v$cartao c
			  left join kss.v$pessoa mot
				on mot.cod_pessoa = c.cod_pessoa
			  left join kss.v$pessoa pj
				on pj.cod_pessoa = c.cod_pessoa_juridica
			 where 1 = 1
			<cfif Len(Trim(arguments.cartao))>
               and c.cartao_numero like '#arguments.cartao#'
            </cfif>
			<cfif Len(Trim(arguments.cartao_id))>
               and c.cartao_id = #arguments.cartao_id#
            </cfif>
             order by motorista
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_quebra_valor" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="yes" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctis.descricao
				 , to_char(cti.data_item, 'DD/MM/YYYY HH24:MI:SS') as data_item
				 , cti.valor
				 , cti.user_insert
				 , to_char(cti.date_insert, 'DD/MM/YYYY HH24:MI:SS') as date_insert
			  from target.v$contrato_parcela_baixa ctb
			 inner join oper.v$contrato_transp_item cti
				on cti.contrato_item_id = ctb.contrato_item_id
			 inner join oper.v$contrato_transp_item_setup ctis
				on ctis.item_id = cti.item_id
			 where ctb.contrato_id = #arguments.contrato_id#
			   and cti.data_cancelamento is null
			   and cti.desconto = 1
			   and ctb.utilizado = 0
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_trava_quitacao_pedagio_pendente" access="remote" returntype="query" output="true">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pagfrete.pkg_contrato.fnc_valor_atributo_tipo_pagto(p_tipo_pagto_id => 7, p_atributo_id => 105) as trava_quitacao
              from dual
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
</cfcomponent>
