<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 01/02/2006 - criado
	--->		
	<cffunction name="get_pessoa_light" access="remote" returntype="Query" output="true">	  
			<cfargument name="cnpj_cpf" required="no" default="">
			<cfargument name="cod_cadastro_contribuinte" required="no" default="">		
			<cfargument name="cliente" required="no" default="">	
			<cfargument name="cod_pessoa" required="no" default="">	
			<cfargument name="tipo_pessoa" required="no" default="">
			<cfargument name="modalidade_id" required="no" default="">
			<cfargument name="num_modalidade" required="no" default="">
			<cfargument name="razao_social" required="no" default="">	
			<cfargument name="municipio" required="no" default="">
			<cfargument name="tipo" required="no" default="">
			<cfargument name="valor" required="no" default="">
			<cfargument name="rapida" required="no" default="0">
			<cfargument name="posto" required="no" default="0">			
			<cfargument name="oficina" required="no" default="0">
            <cfargument name="cod_atividade_fiscal" required="no" default="">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select distinct p.cod_pessoa,
					   p.tipo_pessoa,
					   p.cnpj_cpf,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.identificador) as identificador,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.cnpj_cpf) as cnpj_cpf,
					   p.inscricao_estadual,
					   p.razao_social,
					   p.cliente,
					   p.cod_atividade_fiscal,
                       po.numero,
                       po.logradouro,
					   p.tipo_pessoa as tipo_pessoa_id,
					   0 as cod_funcionario,
                       kss.pkg_pessoa.fnc_get_endereco(p.cod_pessoa,1) as endereco_completo,
					   nvl(po.municipio,pe.municipio) as municipio, po.uf, nvl(po.municipio_id, pe.municipio_id) as municipio_id,
                       nvl(po.municipio,pe.municipio) || ' - ' || po.uf as municipio_uf
					<cfif arguments.posto eq 1>
						,  (select preco
							  from oper.v$posto_historico_produto_prec php
							 where produto_id = 62
							   and cod_pessoa = p.cod_pessoa
							   and data_vigencia = (select max(data_vigencia)
													  from oper.v$posto_historico_produto_prec php2
													 where php2.cod_pessoa = php.cod_pessoa
													   and php2.produto_id = php.produto_id)) preco_diesel
					</cfif>
				  from kss.v$pessoa p
				  left join kss.v$pessoa_fisica pf
						 on pf.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_estrangeira pe
						 on pe.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_endereco po
				         on po.cod_pessoa = p.cod_pessoa
						  and po.endereco_padrao = 1
				<cfif len(trim(arguments.modalidade_Id))>
				 inner join kss.v$pessoa_modalidade pm
				         on pm.cod_pessoa = p.cod_pessoa
                        and pm.situacao = 1  
						and pm.num_modalidade in (#arguments.modalidade_id#)
				</cfif>
				<cfif len(trim(arguments.num_modalidade))>
				 inner join kss.v$pessoa_modalidade pm
				         on pm.cod_pessoa = p.cod_pessoa
                        and pm.situacao = 1  
						and pm.num_modalidade in (#arguments.num_modalidade#)
				</cfif>
				 where 1=1
				 <cfif len(trim(arguments.cliente))>
				   and upper(p.cliente) like upper('%#arguments.cliente#%')
				 </cfif>
				 <cfif len(trim(arguments.cnpj_cpf))>
				   and (p.cnpj_cpf like '#arguments.cnpj_cpf#%' or pe.cod_cadastro_contribuinte like '#arguments.cnpj_cpf#%')
				 </cfif> 
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 3 >
				   and (p.cnpj_cpf like '#arguments.valor#%' or pe.cod_cadastro_contribuinte like '#arguments.valor#%')
				 </cfif>
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 2 >
				   and upper(p.cliente) like upper('%#arguments.valor#%')
				 </cfif> 
				 <cfif len(trim(arguments.cod_cadastro_contribuinte))>
				   and pe.cod_cadastro_contribuinte = '#arguments.cod_cadastro_contribuinte#'
				 </cfif>
				 <cfif len(trim(arguments.cod_pessoa))>
				   and p.cod_pessoa = #arguments.cod_pessoa#
				 </cfif>
				 <cfif len(trim(arguments.tipo_pessoa))>
				   and p.tipo_pessoa = #arguments.tipo_pessoa#
				 </cfif>
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 1 >
				   and upper(p.razao_social) like upper('%#arguments.valor#%')
				 </cfif>
                 <cfif isDefined('arguments.tipo') and arguments.tipo eq 4 >
				   and upper(po.municipio) like upper('%#arguments.valor#%')
   					or upper(pe.municipio) like upper('%#arguments.valor#%')
				 </cfif>
                 <cfif len(trim(arguments.razao_social))>
				   and upper(p.razao_social) like upper('%#arguments.razao_social#%')
				 </cfif>
				 <cfif arguments.rapida eq 1>
				   and rownum = 1
				 </cfif>
                 <cfif Len(Trim(arguments.cod_atividade_fiscal))>
				   and p.cod_atividade_fiscal = #arguments.cod_atividade_fiscal#
				 </cfif>
				   order by <cfif arguments.oficina eq 1>p.cliente, </cfif>p.razao_social
			</cfquery>  
		<cfreturn qr />
	</cffunction>
    
</cfcomponent>
