<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init" output="yes">
	<!---
	-- PROPSITO
	-- Retorna as rotas cadastradas
	-- Alex 28/09/2017
	--->
	<cffunction name="get_rota" access="remote" returntype="query" output="true">
    	<cfargument name="rota_id" required="no" default="" />
		<cfargument name="abreviatura" required="no" default="" />
        <cfargument name="descricao_rota" required="no" default="" />
		<cfargument name="origem_municipio_id" required="no" default="" />
		<cfargument name="destino_municipio_id" required="no" default="" />
        <cfargument name="municipio_origem" required="no" default="" />
        <cfargument name="municipio_destino" required="no" default="" />
        <cfargument name="referencia_origem" required="no" default="" />
        <cfargument name="referencia_destino" required="no" default="" />
        <cfargument name="operacao_id" required="no" default="" />
        <cfargument name="rapida" required="no" default="0" />
        <cfargument name="target" required="no" default="0" />
        <cfargument name="tipo_integracao" required="yes" default="1" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.rota_id
                 , r.abreviatura
                 , r.descricao_rota
                 , r.descricao_via
                 , r.origem_municipio_id
                 , cep.fnc_cidade_completa(r.origem_municipio_id) as origem
                 , r.origem_cod_pessoa
                 , r.origem_latitude
                 , r.origem_longitude
                 , r.destino_municipio_id
                 , cep.fnc_cidade_completa(r.destino_municipio_id) as destino
                 , r.destino_cod_pessoa
                 , r.destino_latitude
                 , r.destino_longitude
                 , r.distancia_padrao
                 , r.distancia_hodometro
                 , r.consolidado
                 , r.referencia_origem_id
                 , (select re.referencia
                      from oper.v$referencia re
                     where re.referencia_id = r.referencia_origem_id
                   ) as referencia_origem
                 , r.referencia_destino_id
                 , (select re.referencia
                      from oper.v$referencia re
                     where re.referencia_id = r.referencia_destino_id
                   ) as referencia_destino
                 , r.user_insert
                 , r.date_insert
                 , r.user_update
                 , r.date_update
                 , r.site
              <cfif arguments.target eq 1>
                 , sign((select sign(count(1))
                           from target.v$roteirizacao cr
							            inner join target.v$roteirizacao_valor rv
                             on rv.roteirizacao_id = cr.roteirizacao_id
                          where cr.rota_id = r.rota_id
                        )
                       ) as possui_target
					       , sign((select sign(count(1))
                           from target.v$roteirizacao cr
                          inner join target.v$roteirizacao_valor rv
                             on rv.roteirizacao_id = cr.roteirizacao_id
                          where cr.rota_id = r.rota_id
                        )
                       ) as vigente
					       , 0 as pedagio_ida_volta
              </cfif>
				         , rv.veiculo_tipo_id
                 , vt.descricao as categoria_descricao
                 , rv.numero_eixos
                 , rv.modo_vale_pedagio
                 , kss.fnc_ref_code('TARGET', 'CONTRATO.MODO_COMPRA_VALE_PEDAGIO', rv.modo_vale_pedagio) as modo_compra_vale_ped_desc
                 , rv.valor_pedagio
				         , rv.roteirizacao_valor_id
              from oper.v$rota r
             inner join cep.municipio mo
                on mo.municipio_id = r.origem_municipio_id
             inner join cep.municipio md
                on md.municipio_id = r.destino_municipio_id
		          left join target.v$roteirizacao rot
                on rot.rota_id = r.rota_id
              left join target.v$roteirizacao_valor rv
                on rv.roteirizacao_id = rot.roteirizacao_id
              left join target.v$veiculo_tipo vt
                on vt.veiculo_tipo_id = rv.veiculo_tipo_id
             where 1 = 1
             <cfif Len(Trim(arguments.rota_id))>
               and r.rota_id = #arguments.rota_id#
             <cfelse>
				<cfif Len(Trim(arguments.abreviatura))>
					and kss.pkg_string.fnc_string_clean(upper(r.abreviatura)) like kss.pkg_string.fnc_string_clean(upper('#arguments.abreviatura#%'))
                </cfif>
                <cfif Len(Trim(arguments.descricao_rota))>
					and kss.pkg_string.fnc_string_clean(upper(r.descricao_rota)) like kss.pkg_string.fnc_string_clean(upper('#arguments.descricao_rota#%'))
                </cfif>
                <cfif Len(Trim(arguments.origem_municipio_id))>
                  	and r.origem_municipio_id = #arguments.origem_municipio_id#
                </cfif>
                <cfif Len(Trim(arguments.destino_municipio_id))>
                  	and r.destino_municipio_id = #arguments.destino_municipio_id#
                </cfif>
                <cfif Len(Trim(arguments.municipio_origem))>
                   	and kss.pkg_string.fnc_string_clean(upper(mo.municipio)) like kss.pkg_string.fnc_string_clean(upper('#arguments.municipio_origem#%'))
                </cfif>
                <cfif Len(Trim(arguments.municipio_destino))>
                   	and kss.pkg_string.fnc_string_clean(upper(md.municipio)) like kss.pkg_string.fnc_string_clean(upper('#arguments.municipio_destino#%'))
                </cfif>
                <cfif Len(Trim(arguments.referencia_origem))>
                   	and (select kss.pkg_string.fnc_string_clean(upper(re.referencia))
                           from oper.v$referencia re
                          where re.referencia_id = r.referencia_origem_id
                        ) like kss.pkg_string.fnc_string_clean(upper('#arguments.referencia_origem#%'))
                </cfif>
                <cfif Len(Trim(arguments.referencia_destino))>
                   	and (select kss.pkg_string.fnc_string_clean(upper(re.referencia))
                           from oper.v$referencia re
                          where re.referencia_id = r.referencia_destino_id
                        ) like kss.pkg_string.fnc_string_clean(upper('#arguments.referencia_destino#%'))
                </cfif>
                <cfif Len(Trim(arguments.operacao_id))>
                    and not exists (select 1
                                      from dedicado.v$local_rota lr
                                     where lr.rota_id = r.rota_id
                                       and lr.data_cancelamento is null
                                       and lr.operacao_id = #arguments.operacao_id#
                                   )
                </cfif>
                <cfif arguments.rapida eq 1>
                    and rownum = 1
                </cfif>
			</cfif>
             order by r.descricao_rota
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>
