<script type="text/javascript" src="/_scripts/scripts_db.js"></script>
<cfswitch expression="#vars.CONSULTA#">
    <cfcase value="1">
    	<cfscript>
			conn = CreateComponent("modulos.rodocred._componentes.manipulacao.cfc_rodocred");
			set_impressao = conn.imprimir_contrato(contrato_id = vars.CONTRATO_ID);
			
			fnc_trata_erros(struct_erro = set_impressao, mostra_msg_ok = 0);
		</cfscript>
		
        <cfset v_data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss') />
        <cffile action="write" file="#ExpandPath("/")#temp/contrato_#vars.CONTRATO_ID#_#v_data_hora#.pdf" nameconflict="makeunique" output="#set_impressao.ARQUIVO#">
		<script type="text/javascript">
			NewWindow('<cf_url>/temp/contrato_<cfoutput>#vars.CONTRATO_ID#_#v_data_hora#</cfoutput>.pdf</cf_url>', '', 800, 600, 'yes');
        </script>
    </cfcase>
    
    <cfcase value="2">
		<cfscript>
			conn = CreateComponent("modulos.rodocred._componentes.consulta.cfc_contrato_transporte");
			qrConhecimento = conn.get_conhecimentos_carta_frete_baseline(argumentCollection = vars);
		</cfscript>
        <table width="100%" border="0" cellspacing="1" cellpadding="3" class="borda">
        	<cfif qrConhecimento.RecordCount gt 0>
        		<tr class="titulo_2">
                	<td nowrap align="right">N&uacute;mero</td>
                    <td nowrap align="left">S&eacute;rie</td>
                    <td nowrap align="left">Data de Emiss&atilde;o</td>
                    <td nowrap align="left">Unidade de Neg&oacute;cio</td>
                    <td nowrap align="left">Departamento</td>
                    <td nowrap align="left">Setor</td>
                    <td nowrap align="left">Centro de Custo</td>
                    <td nowrap align="right">Valor</td>
                </tr>
                <cfoutput query="qrConhecimento">
               	<tr class="linha_#(qrConhecimento.CurrentRow Mod 2) + 1#">
                    <td nowrap align="right">#qrConhecimento.NUM_CONHECIMENTO#</td>
                    <td nowrap align="left">#qrConhecimento.SERIE#</td>
                    <td nowrap align="left">#qrConhecimento.DATA_EMISSAO#</td>
                    <td nowrap align="left">#qrConhecimento.UNIDADE_NEGOCIO#</td>
                    <td nowrap align="left">#qrConhecimento.DEPARTAMENTO#</td>
                    <td nowrap align="left">#qrConhecimento.SETOR#</td>
                    <td nowrap align="left">#qrConhecimento.CENTRO_CUSTO#</td>
                    <td nowrap align="right">#LSNumberFormat(qrConhecimento.TOTAL_CONHECIMENTO, ',.__')#</td>
                </tr>
                </cfoutput>
            <cfelse>
            	<tr>
                	<td colspan="9" align="center" valign="middle" class="obrigatorio">Nenhum conhecimento foi encontrado para esta carta frete.</td>
                </tr>
            </cfif>
        </table>
	</cfcase>
    
    <cfdefaultcase>
		<script defer="defer">
	    	alert('Operao no programada.');
	 	</script>
  	</cfdefaultcase>
</cfswitch>