<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Consulta Rotas
	-- ANDERSONC 25/01/2012 14:12:22 - CRIADO
	--->
	<cffunction name='consultar_rotas' displayname='Consulta Rotas' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='rodocred.pkg_rodocred.prc_consultar_rotas' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_MUNICIPIO_ID'  value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Detalhar Rota
	-- ANDERSONC 26/01/2012 15:03:56 - CRIADO
	--->
	<cffunction name='detalhar_rota' displayname='Detalhar Rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='CODIGO_ROTA' required='yes'>
		<cftry>
            <cfstoredproc procedure='rodocred.pkg_rodocred.prc_detalhar_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CODIGO_ROTA'  value='#arguments.CODIGO_ROTA#'  null='#iif(len(trim(arguments.CODIGO_ROTA)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISICAO_ID' variable='retorno.REQUISICAO_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Consultar Estabelecimentos
	-- ANDERSONC 26/01/2012 17:23:58 - CRIADO
	--->
	<cffunction name='consultar_estabelecimentos' displayname='Consultar Estabelecimentos' access='remote' returntype='Struct' output='true'>
		<cfargument name='CODIGO_ROTA' required='yes'>
		<cftry>
            <cfstoredproc procedure='rodocred.pkg_rodocred.prc_consultar_estabelecimentos' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CODIGO_ROTA'  value='#arguments.CODIGO_ROTA#'  null='#iif(len(trim(arguments.CODIGO_ROTA)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISICAO_ID' variable='retorno.REQUISICAO_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Consultar Tarifas
	-- ANDERSONC 27/01/2012 09:21:26 - CRIADO
	--->
	<cffunction name='consultar_tarifas' displayname='Consultar Tarifas' access='remote' returntype='Struct' output='true'>
		<cfargument name='CODIGO_ROTA' required='yes'>
		<cfargument name='QTDE_EIXOS' required='yes'>
		<cfargument name='TIPO_RODAGEM' required='yes'>
		<cftry>
            <cfstoredproc procedure='rodocred.pkg_rodocred.prc_consultar_tarifas' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CODIGO_ROTA'  value='#arguments.CODIGO_ROTA#'  null='#iif(len(trim(arguments.CODIGO_ROTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_EIXOS'  value='#arguments.QTDE_EIXOS#'  null='#iif(len(trim(arguments.QTDE_EIXOS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_RODAGEM'  value='#arguments.TIPO_RODAGEM#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISICAO_ID' variable='retorno.REQUISICAO_ID' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_CUPONS' variable='retorno.QTDE_CUPONS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TARIFA_PEDAGIO' variable='retorno.VALOR_TARIFA_PEDAGIO' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza o cadastro de um proprietrio
	-- ANDERSONC 07/02/2012 11:55:57 - CRIADO
	--->
	<cffunction name='atualizar_transportador' displayname='Atualiza o cadastro de um proprietrio' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_TRANSPORTADOR' required='yes'>
        <cfargument name='CARTAO_NUMERO_PROPRIETARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodocred.pkg_logistica.prc_atualizar_transportador' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CARTAO_NUMERO'  value='#arguments.CARTAO_NUMERO_PROPRIETARIO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISICAO_ID' variable='retorno.REQUISICAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Proprietrio atualizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza o cadastro de um veculo
	-- ANDERSONC 07/02/2012 12:00:57 - CRIADO
	--->
	<cffunction name='atualizar_veiculo' displayname='Atualiza o cadastro de um veculo' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodocred.pkg_logistica.prc_atualizar_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISICAO_ID' variable='retorno.REQUISICAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Veculo atualizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza o cadastro de um motorista
	-- RAFAEL 28/03/2012 11:31:47 - CRIADO
	--->
	<cffunction name='atualizar_motorista' displayname='Atualiza o cadastro de um motorista' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_TRANSPORTADOR' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='CARTAO_NUMERO_MOTORISTA' required='no' default="">		
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodocred.pkg_logistica.prc_atualizar_motorista' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CARTAO_NUMERO'  value='#arguments.CARTAO_NUMERO_MOTORISTA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISICAO_ID' variable='retorno.REQUISICAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Motorista atualizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Emite contrato na Rodocred
	-- RAFAEL 28/03/2012 14:02:38 - CRIADO
	--->
	<cffunction name='emite_contrato' displayname='Emite contrato na REPOM' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='ROTEIRO_ID' required='yes'>
		<cftry>			
            <cfstoredproc procedure='rodocred.pkg_contrato.prc_emite_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID' variable='retorno.CONTRATO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTEIRO_ID'  value='#arguments.ROTEIRO_ID#'  null='#iif(len(trim(arguments.ROTEIRO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir clusulas de um contratao de transporte da Rodocred
	-- RAFAEL 28/03/2012 14:04:50 - CRIADO
	--->
	<cffunction name='ins_contrato_clausula' displayname='Inserir clusulas de um contratao de transporte da Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='CLAUSULA_ID' required='yes'>
		<cftry>			
            <cfstoredproc procedure='rodocred.pkg_contrato.prc_ins_contrato_clausula' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_CLAUSULA_ID' variable='retorno.CONTRATO_CLAUSULA_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLAUSULA_ID'  value='#arguments.CLAUSULA_ID#'  null='#iif(len(trim(arguments.CLAUSULA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>			
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincular um Agrupamento com um Tipo de Veculo da Rodocred
	-- RAFAEL 28/03/2012 16:49:15 - CRIADO
	--->
	<cffunction name='ins_agrup_tipo_veiculo' displayname='Vincular um Agrupamento com um Tipo de Veculo da Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='AGRUPAMENTO_ID' required='yes'>
		<cfargument name='TIPO_VEICULO_ID' required='yes'>
		<cfargument name='TIPO_RODAGEM' required='yes'>
		<cftry>			
            <cfstoredproc procedure='rodocred.pkg_logistica.prc_ins_agrup_tipo_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AGRUPAMENTO_TIPO_VEICULO_ID' variable='retorno.AGRUPAMENTO_TIPO_VEICULO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AGRUPAMENTO_ID'  value='#arguments.AGRUPAMENTO_ID#'  null='#iif(len(trim(arguments.AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_VEICULO_ID'  value='#arguments.TIPO_VEICULO_ID#'  null='#iif(len(trim(arguments.TIPO_VEICULO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_RODAGEM'  value='#arguments.TIPO_RODAGEM#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera o vnculo de um Agrupamento com um Tipo de Veculo da Rodocred
	-- RAFAEL 28/03/2012 16:50:23 - CRIADO
	--->
	<cffunction name='upd_agrup_tipo_veiculo' displayname='Altera o vnculo de um Agrupamento com um Tipo de Veculo da Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='AGRUPAMENTO_TIPO_VEICULO_ID' required='yes'>
		<cfargument name='AGRUPAMENTO_ID' required='yes'>
		<cfargument name='TIPO_VEICULO_ID' required='yes'>
		<cfargument name='TIPO_RODAGEM' required='yes'>
		<cftry>
            <cfstoredproc procedure='rodocred.pkg_logistica.prc_alt_agrup_tipo_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AGRUPAMENTO_TIPO_VEICULO_ID'  value='#arguments.AGRUPAMENTO_TIPO_VEICULO_ID#'  null='#iif(len(trim(arguments.AGRUPAMENTO_TIPO_VEICULO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AGRUPAMENTO_ID'  value='#arguments.AGRUPAMENTO_ID#'  null='#iif(len(trim(arguments.AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_VEICULO_ID'  value='#arguments.TIPO_VEICULO_ID#'  null='#iif(len(trim(arguments.TIPO_VEICULO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_RODAGEM'  value='#arguments.TIPO_RODAGEM#' >
            </cfstoredproc>
            <cfset retorno.erro = false>				
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Excluio vnculo de um Agrupamento com um Tipo de Veculo da Rodocred
	-- RAFAEL 28/03/2012 16:51:06 - CRIADO
	--->
	<cffunction name='del_agrup_tipo_veiculo' displayname='Excluio vnculo de um Agrupamento com um Tipo de Veculo da Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='AGRUPAMENTO_TIPO_VEICULO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='rodocred.pkg_logistica.prc_del_agrup_tipo_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AGRUPAMENTO_TIPO_VEICULO_ID'  value='#arguments.AGRUPAMENTO_TIPO_VEICULO_ID#'  null='#iif(len(trim(arguments.AGRUPAMENTO_TIPO_VEICULO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um tipo de embalagem
    -- ANDERSONC 29/12/2009 11:08:12 - CRIADO
    --->
    <cffunction name='vincula_agrup_tipo_veiculo' displayname='Altera um tipo de embalagem' access='remote' returntype='Struct' output='true'>
        <cftry>
            <cftransaction action='begin'>
                <!--- Criao de variaveis --->
				<cfscript>
                    v_agrupamento_tipo_veiculo_id	= this.ListaToArray(lista = arguments, variavel = 'AGRUPAMENTO_TIPO_VEICULO_ID_VINCULOS');
					v_agrupamento_id				= this.ListaToArray(lista = arguments, variavel = 'AGRUPAMENTO_ID_VINCULOS');
					v_tipo_veiculo_id				= this.ListaToArray(lista = arguments, variavel = 'TIPO_VEICULO_ID_VINCULOS');
					v_tipo_rodagem					= this.ListaToArray(lista = arguments, variavel = 'TIPO_RODAGEM_VINCULOS');
					v_excluir						= this.ListDiff(lista1 = lista_deleted_VINCULOS, lista2 = ArrayToList(v_agrupamento_tipo_veiculo_id));
                </cfscript>
                
                <!--- Exclui os vnculos --->
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
					<cfscript>
                        ret = this.del_agrup_tipo_veiculo(AGRUPAMENTO_TIPO_VEICULO_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <!--- Insere/Atualiza os vnculos --->
                <cfloop from="1" to="#ArrayLen(v_agrupamento_tipo_veiculo_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_agrupamento_tipo_veiculo_id[count]))) {
							ret_ins_upd = this.ins_agrup_tipo_veiculo(AGRUPAMENTO_ID	= v_agrupamento_id[count],
																	  TIPO_VEICULO_ID	= v_tipo_veiculo_id[count],
																	  TIPO_RODAGEM		= v_tipo_rodagem[count]);
						}
						else{
							ret_ins_upd = this.upd_agrup_tipo_veiculo(AGRUPAMENTO_TIPO_VEICULO_ID	= v_agrupamento_tipo_veiculo_id[count],
																	  AGRUPAMENTO_ID				= v_agrupamento_id[count],
																	  TIPO_VEICULO_ID				= v_tipo_veiculo_id[count],
																	  TIPO_RODAGEM					= v_tipo_rodagem[count]);
						}
                    </cfscript>
                    <cfif ret_ins_upd.erro>
                        <cfthrow object="#ret_ins_upd.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vnculos atualizados com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Integrar contrato com a Rodocred
	-- RAFAEL 11/05/2012 17:00:49 - CRIADO
	--->
	<cffunction name='integrar_contrato' displayname='Integrar contrato com a Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodocred.pkg_contrato.prc_envia_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato integrado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Imprimir contrato Rodocred
	-- RAFAEL 17/05/2012 17:17:14 - CRIADO
	--->
	<cffunction name='imprimir_contrato' displayname='Imprimir contrato Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodocred.pkg_impressao.prc_gera_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impresso gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Imprimir contrato Agregado Rodocred
	-- RAFAEL 08/05/2013 - 14:49 - CRIADO
	--->
	<cffunction name='imprimir_contrato_agregado' displayname='Imprimir contrato Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAC_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_agreg_rcred_impressao.prc_gera_contrato_agreg' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAC_ID'  value='#arguments.TAC_ID#'  null='#iif(len(trim(arguments.TAC_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impresso gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Entregar Documentos referentes ao Contrato de Transporte Rodocred
	-- RAFAEL 01/08/2012 09:31:42 - CRIADO
	--->
	<cffunction name='entregar_documento' displayname='Entregar Documentos referentes ao Contrato de Transporte Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodocred.pkg_contrato.prc_entregar_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro de entrega de documento efetuado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Efetuar a liberao do Saldo do Contrato de Transporte Rodocred
	-- RAFAEL 01/08/2012 09:33:49 - CRIADO
	--->
	<cffunction name='liberar_saldo' displayname='Efetuar a liberao do Saldo do Contrato de Transporte Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodocred.pkg_contrato.prc_liberar_saldo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Liberao de saldo efetuada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Efetuar a Liberao de Saldo de Vrios Contratos na Rodocred
	-- RAFAEL 13/11/2012 09:09:25 - CRIADO
	--->
	<cffunction name='liberar_saldo_multiplo' displayname='Efetuar a Liberao de Saldo de Vrios Contratos na Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='LISTA_CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodocred.pkg_contrato.prc_liberar_saldo_multiplo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LISTA_CONTRATO_ID'  value='#arguments.LISTA_CONTRATO_ID#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MENSAGEM_ERRO' variable='retorno.MENSAGEM_ERRO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Liberao de saldo efetuada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Efetua  liberao do Adiantamento na Rodocred
	-- RAFAEL 19/11/2012 14:38:31 - CRIADO
	--->
	<cffunction name='liberar_adiantamento' displayname='Efetua  liberao do Adiantamento na Rodocred' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodocred.pkg_contrato.prc_liberar_adiantamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Liberao de adiantamento efetuada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Valida se na emisso do contrato foi informado o adiantamento.
	-- WAGNERS 13/11/2012 09:39:17 - CRIADO
	--->
	<cffunction name='valida_adto_contrato' displayname='Valida se na emisso do contrato foi informado o adiantamento.' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cftry>
			<cfstoredproc procedure='rodocred.pkg_contrato.prc_valida_adto_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('O adiantamento foi informado.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>    
    
    
    <!--- 
	-- PROPSITO
	-- Valida entrega de documentos para integrar com a rodocred.
	-- WAGNERS 23/11/2012 11:20:57 - CRIADO
	--->
	<cffunction name='valida_entrega_documento' displayname='Valida entrega de documentos para integrar com a rodocred.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodocred.pkg_contrato.prc_valida_entrega_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documentos validados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
</cfcomponent>