<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os roteiros de uma requisio
    -- ANDERSON 25/01/2012 - CRIADO
    --->		
    <cffunction name="get_roteiro" access="remote" returntype="Struct" output="true">
    	<cfargument name="origem_municipio_id" required="yes" />
        <cfargument name="destino_municipio_id" required="yes" />
        <cftry>
        	<cftransaction action='begin'>
                <cfscript>
					conn = CreateComponent("modulos.rodocred._componentes.manipulacao.cfc_rodocred");
                    ret_cons_rot = conn.consultar_rotas(ORIGEM_MUNICIPIO_ID  = arguments.origem_municipio_id,
														DESTINO_MUNICIPIO_ID = arguments.destino_municipio_id);
                </cfscript>
                <cfif ret_cons_rot.erro>
                    <cfthrow object="#ret_cons_rot.mensagem#">
                </cfif>
                
                <cfquery name="qr_roteiro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select r.roteiro_id
                         , r.codigo_rota
                         , r.nome_rota
                         , r.descricao_rota
                         , r.uf_origem
                         , r.localidade_origem
                         , r.codigo_ibge_origem
                         , r.uf_destino
                         , r.localidade_destino
                         , r.codigo_ibge_destino
                         , r.distancia_total
                         , kss.to_tempo(numToDsInterval(r.tempo_total, 'hour'), 1).retorno as tempo_total
                      from rodocred.v$roteiro r
                     where r.ativo = 1
                       and r.codigo_ibge_origem  = (select distinct im.cod_uf || lpad(im.cod_municipio, 4, 0) || im.cod_dv
                                                      from cep.ibge_municipio im
                                                     where im.municipio_id_kmm = #arguments.origem_municipio_id#
                                                       and im.nome_categoria <> 'Vila'
                                                   )
                       and r.codigo_ibge_destino = (select distinct im.cod_uf || lpad(im.cod_municipio, 4, 0) || im.cod_dv
                                                      from cep.ibge_municipio im
                                                     where im.municipio_id_kmm = #arguments.destino_municipio_id#
                                                       and im.nome_categoria <> 'Vila'
                                                   )
                </cfquery>
                
                <cfset retorno.qr_roteiro = qr_roteiro>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna uma rota detalhada atravs de uma requisio
    -- ANDERSON 25/01/2012 - CRIADO
    --->		
    <cffunction name="get_detalhar_rota" access="remote" returntype="Struct" output="true">
    	<cfargument name="codigo_rota" required="yes" />
        <cftry>
        	<cftransaction action='begin'>
                <cfscript>
					conn = CreateComponent("modulos.rodocred._componentes.manipulacao.cfc_rodocred");
                    ret_det_rot = conn.detalhar_rota(CODIGO_ROTA = arguments.codigo_rota);
                </cfscript>
                <cfif ret_det_rot.erro>
                    <cfthrow object="#ret_det_rot.mensagem#">
                </cfif>
                
                <cfquery name="qr_praca" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select trim(extractvalue(t.column_value, 'Praca/NomePraca', 'xmlns="https://ws.rodocred.com.br/"')) as nome_praca
                         , trim(extractvalue(t.column_value, 'Praca/LocalPraca', 'xmlns="https://ws.rodocred.com.br/"')) as local_praca
                         , trim(extractvalue(t.column_value, 'Praca/Concessionaria', 'xmlns="https://ws.rodocred.com.br/"')) as concessionaria
                         , trim(extractvalue(t.column_value, 'Praca/Informativo', 'xmlns="https://ws.rodocred.com.br/"')) as informativo
                      from table(xmlsequence(extract(rodocred.pkg_comunicacao.fnc_xml_retorno_requisicao(#ret_det_rot.requisicao_id#), '/DetalharRotaResponse/Rota/ListaPracasRota/Praca', 'xmlns="https://ws.rodocred.com.br/"'))) t
                </cfquery>
                
                <cfquery name="qr_estabelecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select trim(extractvalue(t.column_value, 'Estabelecimento/CNPJEstabelecimento', 'xmlns="https://ws.rodocred.com.br/"')) as cnpj_estabelecimento
                         , trim(extractvalue(t.column_value, 'Estabelecimento/NomeEstabelecimento', 'xmlns="https://ws.rodocred.com.br/"')) as nome_estabelecimento
                      from table(xmlsequence(extract(rodocred.pkg_comunicacao.fnc_xml_retorno_requisicao(#ret_det_rot.requisicao_id#), '/DetalharRotaResponse/Rota/ListaEstabelecimentosRota/Estabelecimento', 'xmlns="https://ws.rodocred.com.br/"'))) t
                </cfquery>
                
                <cfset retorno.qr_praca = qr_praca>
                <cfset retorno.qr_estabelecimento = qr_estabelecimento>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os estabelecimentos de uma rota atravs de uma requisio
    -- ANDERSON 25/01/2012 - CRIADO
    --->		
    <cffunction name="get_consultar_estabelecimentos" access="remote" returntype="Struct" output="true">
    	<cfargument name="codigo_rota" required="yes" />
        <cftry>
        	<cftransaction action='begin'>
                <cfscript>
					conn = CreateComponent("modulos.rodocred._componentes.manipulacao.cfc_rodocred");
                    ret_cons_est = conn.consultar_estabelecimentos(CODIGO_ROTA = arguments.codigo_rota);
                </cfscript>
                <cfif ret_cons_est.erro>
                    <cfthrow object="#ret_cons_est.mensagem#">
                </cfif>
                
                <cfquery name="qr_estabelecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select trim(extractvalue(t.column_value, 'Estabelecimentos/CNPJEstabelecimento', 'xmlns="https://ws.rodocred.com.br/"')) as cnpj_estabelecimento
                         , trim(extractvalue(t.column_value, 'Estabelecimentos/NomeEstabelecimento', 'xmlns="https://ws.rodocred.com.br/"')) as nome_estabelecimento
                         , trim(extractvalue(t.column_value, 'Estabelecimentos/Cidade', 'xmlns="https://ws.rodocred.com.br/"')) as cidade
                         , trim(extractvalue(t.column_value, 'Estabelecimentos/UF', 'xmlns="https://ws.rodocred.com.br/"')) as uf
                         , trim(extractvalue(t.column_value, 'Estabelecimentos/Bandeira', 'xmlns="https://ws.rodocred.com.br/"')) as bandeira
                      from table(xmlsequence(extract(rodocred.pkg_comunicacao.fnc_xml_retorno_requisicao(#ret_cons_est.requisicao_id#), '/ConsultarEstabelecimentosResponse/ListaEstabelecimentos/Estabelecimentos', 'xmlns="https://ws.rodocred.com.br/"'))) t
                </cfquery>
                
                <cfset retorno.qr_estabelecimento = qr_estabelecimento>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as tarifas de uma rota atravs de uma requisio
    -- ANDERSON 25/01/2012 - CRIADO
    --->		
    <cffunction name="get_consultar_tarifas" access="remote" returntype="Struct" output="true">
    	<cfargument name="codigo_rota" required="yes" />
        <cfargument name="qtde_eixos" required="yes" />
        <cfargument name="tipo_rodagem" required="yes" />
        <cftry>
        	<cftransaction action='begin'>
                <cfscript>
					conn = CreateComponent("modulos.rodocred._componentes.manipulacao.cfc_rodocred");
                    ret_cons_tar = conn.consultar_tarifas(CODIGO_ROTA  = arguments.codigo_rota,
					                                      QTDE_EIXOS   = arguments.qtde_eixos,
														  TIPO_RODAGEM = arguments.tipo_rodagem);
                </cfscript>
                <cfif ret_cons_tar.erro>
                    <cfthrow object="#ret_cons_tar.mensagem#">
                </cfif>
                
                <cfset retorno.qtde_cupons = ret_cons_tar.qtde_cupons>
                <cfset retorno.valor_tarifa_pedagio = ret_cons_tar.valor_tarifa_pedagio>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os mtodos da Rodocred
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_metodo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.metodo
              from rodocred.v$metodo m
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as requisies da Rodocred
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_requisicao" access="remote" returntype="query" output="true">
    	<cfargument name="metodo" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.requisicao_id
                 , r.metodo
                 , kss.to_tempo(r.tempo_execucao, 2).retorno as tempo_execucao
                 , case
                      when r.erro is not null then 1
                      else 0
                   end as possui_erro
                 , r.user_insert
                 , to_char(r.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , r.user_update
                 , to_char(r.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from rodocred.v$requisicao r
             where 1 = 1
			<cfif Len(Trim(arguments.metodo))>
               and upper(r.metodo) = upper('#arguments.metodo#')
			</cfif>
            
            <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
               and r.date_insert between to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
			<cfelseif Len(Trim(arguments.data_inicio))>
               and r.date_insert >= to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss')
			<cfelseif Len(Trim(arguments.data_termino))>
               and r.date_insert <= to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
			</cfif>
             order by r.date_insert desc, r.requisicao_id desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o XML de Envio de uma requisio
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_requisicao_xml_envio" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.xml_envio.getClobVal() as xml_envio
              from rodocred.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o XML de Retorno de uma requisio
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_requisicao_xml_retorno" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select xml_retorno
              from rodocred.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o Erro de uma requisio
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_requisicao_erro" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.erro
              from rodocred.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as clusulas que podem ser usadas na emisso dos contratos
    -- ANDERSON 07/02/2012 - CRIADO
    --->		
    <cffunction name="get_clausula" access="remote" returntype="query" output="true">
        <cfargument name="tipo_viagem" required="no" default=""/>
		<cfargument name="ativo" required="no" default="1"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.clausula_id
                 , c.tipo_viagem
                 , c.codigo_clausula
                 , c.descricao_clausula
                 , c.possui_regra_calculo
                 , c.codigo_regra_calculo
                 , c.descricao_regra_calculo
              from rodocred.v$clausula c
             where 1 = 1
               and ativo = #arguments.ativo#
            <cfif Len(Trim(arguments.tipo_viagem))>
               and upper(c.tipo_viagem) = upper('#arguments.tipo_viagem#')
			</cfif>
              
             order by c.codigo_clausula
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca o proprietrio do veculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 16/03/2009
	--->
	<cffunction name="get_proprietario" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select vp.cod_pessoa
              from oper.v$veiculo_proprietario_atual vp
              where vp.placa = '#arguments.placa#'
   		</cfquery>
	<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o status de validao das integraes com a Rodocred
    -- ANDERSON 22/09/2011 - CRIADO
    --->		
    <cffunction name="get_validacao" access="remote" returntype="query" output="true">
        <cfargument name="cod_transportador" required="yes" />
        <cfargument name="cod_motorista" required="yes" />
        <cfargument name="placa_cavalo" required="yes" />
        <cfargument name="placa_carreta" required="yes" />
        <cfscript>
			if(Len(Trim(arguments.placa_cavalo))) {
				qrPropCavalo  = this.get_proprietario(placa = arguments.placa_cavalo);
				prop_cavalo = qrPropCavalo.cod_pessoa;
			}else{
				prop_cavalo = 0;
			}
			if(Len(Trim(arguments.placa_carreta))) {
				qrPropCarreta = this.get_proprietario(placa = arguments.placa_carreta);
				prop_carreta = qrPropCarreta.cod_pessoa;
			}else{
				prop_carreta = 0;
			}
		</cfscript>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select sign(count(1))
                      from rodocred.v$manter_pessoa mp
                     where mp.cod_pessoa = '#arguments.cod_transportador#'
                       and mp.tipo_pessoa_operacao = 1
                   ) as transportador_ok
                 , (select r.erro
                      from rodocred.v$requisicao r
                     where r.requisicao_id = (select max(mp.requisicao_id) keep(dense_rank last order by mp.data_operacao)
                                                from rodocred.v$manter_pessoa mp
                                               where mp.cod_pessoa = '#arguments.cod_transportador#'
                                                 and mp.tipo_pessoa_operacao = 1)
                   ) as transportador_alertas 
                 , (select sign(count(1))
                      from rodocred.v$manter_pessoa mp
                     where mp.cod_pessoa = '#arguments.cod_motorista#'
                       and mp.tipo_pessoa_operacao = 2
                   ) as motorista_ok
                 , (select r.erro
                      from rodocred.v$requisicao r
                     where r.requisicao_id = (select max(mp.requisicao_id) keep(dense_rank last order by mp.data_operacao)
                                                from rodocred.v$manter_pessoa mp
                                               where mp.cod_pessoa = '#arguments.cod_motorista#'
                                                 and mp.tipo_pessoa_operacao = 2)
                   ) as motorista_alertas  
                 , (select sign(count(1))
                      from rodocred.v$manter_veiculo mv
                     where mv.placa = '#arguments.placa_cavalo#'
                   ) as cavalo_ok
                 , (select r.erro
                      from rodocred.v$requisicao r
                     where r.requisicao_id = (select max(mv.requisicao_id) keep(dense_rank last order by mv.data_operacao)
                                                from rodocred.v$manter_veiculo mv
                                               where mv.placa = '#arguments.placa_cavalo#')
                   ) as cavalo_alertas 
              <cfif (arguments.placa_carreta eq arguments.placa_cavalo) or (prop_cavalo neq prop_carreta)>
                 , 1 as carreta_ok
                 , null as carreta_alertas
              <cfelseif not Len(Trim(arguments.placa_carreta))>
                 , 0 as carreta_ok
                 , null as carreta_alertas
              <cfelse>
                 , (select sign(count(1))
                      from rodocred.v$manter_veiculo mv
                     where mv.placa = '#arguments.placa_carreta#'
                   ) as carreta_ok
                 , (select r.erro
                      from rodocred.v$requisicao r
                     where r.requisicao_id = (select max(mv.requisicao_id) keep(dense_rank last order by mv.data_operacao)
                                                from rodocred.v$manter_veiculo mv
                                               where mv.placa = '#arguments.placa_carreta#')
                   ) as carreta_alertas 
              </cfif>
                 
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as rotas do Rodcred
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_roteiros" access="remote" returntype="query" output="true">
        <cfargument name="codigo_rota" required="yes" />
        <cfargument name="todos" required="no" default="0"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.roteiro_id
                 , r.codigo_rota
                 , r.nome_rota
                 , r.descricao_rota
                 , r.uf_origem
                 , r.localidade_origem
                 , r.codigo_ibge_origem
                 , r.uf_destino
                 , r.localidade_destino
                 , r.codigo_ibge_destino
                 , r.distancia_total
                 , kss.to_tempo(numToDsInterval(r.tempo_total, 'hour'), 1).retorno as tempo_total
              from rodocred.v$roteiro r
             where 1 = 1
             <cfif arguments.todos eq 0>
               and r.ativo = 1
             </cfif>
			 <cfif Len(Trim(arguments.codigo_rota))>
               and r.codigo_rota = #arguments.codigo_rota#
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de veculo da Rodocred
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_tipo_veiculo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tv.tipo_veiculo_id
                 , tv.descricao
              from rodocred.v$tipo_veiculo tv
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os vinculos entre agrupamento e tipos de veculo da Rodocred
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_agrupamento_tipo_veiculo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select atv.agrupamento_tipo_veiculo_id
                 , atv.agrupamento_id
                 , atv.tipo_veiculo_id
                 , atv.tipo_rodagem
              from rodocred.v$agrupamento_tipo_veiculo atv
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o contrato_id a partir do lancto_id
    -- WAGNER 13/11/2012 - CRIADO
    --->		
    <cffunction name="get_contrato_transp_lancto" access="remote" returntype="query" output="true">
        <cfargument name="lancto_id" required="yes" default="" />
        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
			select t.lancto_id
                 , t.contrato_id
                 , t.situacao_id
              from rodocred.v$contrato t
             where t.lancto_id = #arguments.lancto_id#
		</cfquery>
        <cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as cartas frete Rodocred
    -- RAFAEL 29/03/2012 - CRIADO
    --->		
    <cffunction name="get_contrato_transp_baseline" access="remote" returntype="query" output="true">
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="num_formulario" required="no" default="" />
        <cfargument name="num_manifesto" required="no" default="" />
        <cfargument name="lancto_id" required="no" default="" />
        <cfargument name="cod_pessoa_filial" required="no" default="" />
        <cfargument name="cod_organograma_gerencial" required="no" default="" />
        <cfargument name="placa_cavalo" required="no" default="" />
        <cfargument name="placa_carreta" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfargument name="contrato_id" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
            select t.lancto_id
                 , t.contrato_id
                 , case
                      when t.num_formulario < 0 then ''
                      else to_char(t.num_formulario)
                   end as num_formulario
                 , decode(t.tipo_contrato, 0, 'TERCEIRO', 'AGREGADO') as tipo_contrato
                 , (select cg.rv_abbreviation
                      from oper.v$agreg_viagem av
                     inner join oper.cg_ref_codes cg
                             on cg.rv_domain = 'AGREG_VIAGEM.TIPO_SERVICO'
                            and cg.rv_low_value = av.tipo_servico
                     where av.lancto_id = t.lancto_id
                   ) as tipo_servico
                 , t.num_romaneio
                 , (select r.carregamento
                      from oper.v$romaneio r
                     where r.num_romaneio = t.num_romaneio 
                   ) as carregamento
                 , (select r.destino
                      from oper.v$romaneio r
                     where r.num_romaneio = t.num_romaneio 
                   ) as destino
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = t.cod_pessoa_filial
                   ) as unidade_negocio
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = t.cod_departamento
                   ) as departamento
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = t.cod_setor
                   ) as setor
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = t.cod_centro_custo
                   ) as centro_custo
                 , t.valor_adiantamento
                 , to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , t.peso
                 , t.cod_unidade
                 , t.volume
                 , t.m3
                 , t.frete_em
                 , t.lancto_id_pai
                 , nvl(t.parcela, 1) as parcela
                 , nvl(t.total_parcela, 1) as total_parcela
                 , t.valor_unitario
                 , t.valor_frete_bruto
                 , t.valor_frete_liquido
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_controle) as cod_veiculo_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_referencia) as cod_veiculo_referencia
                 , kss.pkg_pessoa.fnc_get_cliente(t.proprietario_cod_pessoa) as proprietario
                 , kss.pkg_pessoa.fnc_get_cliente(t.motorista_cod_pessoa) as motorista
                 , t.rpa_id
                 , t.impresso_desc
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , t.usuario_cancelamento

                 , to_char(t.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
                 , t.numero_viagem as numero_viagem_rodocred
                 , nvl2(t.ciot,t.ciot || '/' || t.ciot_dv, '') as ciot
                 , t.codigo_rota
                 , t.nome_rota
                 , decode(t.rota_ativo, 1, 'Sim', 'No') as rota_ativo
                 , t.uf_origem
                 , t.localidade_origem
                 , t.uf_destino
                 , t.localidade_destino
                 , t.distancia_total
                 , t.tempo_total
                 , t.usuario_entrega_documentos
                 , to_char(t.data_entrega_documentos, 'dd/mm/yyyy hh24:mi:ss') as data_entrega_documentos
                 , t.usuario_liberacao_saldo
                 , to_char(t.data_liberacao_saldo, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_saldo
                 , t.usuario_liberacao_adto
                 , to_char(t.data_liberacao_adto, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_adto
				 , (select mp.numero_cartao
                      from rodocred.v$manter_pessoa mp
                     where mp.cod_pessoa = t.proprietario_cod_pessoa
                       and numero_cartao is not null
                       and rownum = 1) as numero_cartao
                 , case 
                     when t.situacao_id = 1 then
                      'Pendente de Integrao'
                     when t.situacao_id = 2 then
                      'Integrado'
                     when t.situacao_id = 3 then
                      'Erros de Integrao'
                   end situacao
                 , situacao_id
                 , (select sign(count(1))
                      from rodocred.v$operacao_viagem ov
                     where ov.contrato_id = t.contrato_id
                       and ov.cod_operacao = 'ADF') as possui_adto
                 , (select sign(count(1))
                      from rodocred.v$operacao_viagem ov
                     where ov.contrato_id = t.contrato_id
                       and ov.cod_operacao = 'EDL') as possui_entrega_doctos
                 , (select sign(count(1))
                      from rodocred.v$operacao_viagem ov
                     where ov.contrato_id = t.contrato_id
                       and ov.cod_operacao = 'LSF') as possui_liberacao_saldo
			     , t.observacao_aprovacao
              from (
                    select ct.lancto_id
                         , c.contrato_id
                         , ct.num_formulario
                         , ct.tipo_contrato
                         , ct.num_romaneio
                         , ct.cod_pessoa_filial
                         , ct.cod_departamento
                         , ct.cod_setor
                         , ct.cod_centro_custo
                         , ct.data_emissao
                         , ct.peso
                         , ct.cod_unidade
                         , ct.volume
                         , ct.m3
                         , ct.frete_em
                         , ct.lancto_id_pai
                         , ct.parcela
                         , ct.total_parcela
                         , ct.valor_unitario
                         , ct.valor_frete_bruto
                         , ct.valor_frete_liquido
                         , ct.placa_controle
                         , ct.placa_referencia
                         , ct.proprietario_cod_pessoa
                         , ct.motorista_cod_pessoa
                         , ct.rpa_id
                         , decode(ct.impresso, 1, 'Sim', 'No') as impresso_desc
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento as data_cancelamento
                         , c.numero_viagem
                         , c.ciot
                         , c.ciot_dv
                         , r.codigo_rota
                         , r.nome_rota
                         , r.ativo as rota_ativo
                         , r.uf_origem
                         , r.localidade_origem
                         , r.uf_destino
                         , r.localidade_destino
                         , r.distancia_total
                         , kss.to_tempo(numToDsInterval(r.tempo_total, 'hour'), 1).retorno as tempo_total
                         , c.usuario_entrega_documentos
                         , c.data_entrega_documentos
                         , c.usuario_liberacao_saldo
                         , c.data_liberacao_saldo
                         , c.valor_adiantamento
						 , c.situacao_id
                         , c.usuario_liberacao_adto
                         , c.data_liberacao_adto
						 , ct.observacao_aprovacao
                      from oper.v$contrato_transp ct
                inner join rodocred.v$contrato c
                        on c.lancto_id = ct.lancto_id
                inner join rodocred.v$roteiro r
                        on r.roteiro_id = c.roteiro_id                
                     where 1 = 1
					<cfif Len(Trim(arguments.num_romaneio))>
                       and ct.num_romaneio = #arguments.num_romaneio#
                    <cfelseif Len(Trim(arguments.num_formulario))>
                       and ct.num_formulario = #arguments.num_formulario#
                    <cfelseif Len(Trim(arguments.lancto_id))>
                       and ct.lancto_id = #arguments.lancto_id#
                    <cfelseif Len(Trim(arguments.CONTRATO_ID))>
                       and c.contrato_id = #arguments.CONTRATO_ID#
                    <cfelseif Len(Trim(arguments.num_manifesto))>
                       and exists (select 1
                                     from oper.v$manifesto m
                                    where m.manifesto_id = ct.manifesto_id
                                      and m.num_manifesto = #arguments.num_manifesto# )                       
                    <cfelse>
                        <cfif Len(Trim(arguments.cod_pessoa_filial))>
                           and ct.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                        </cfif>
                        <cfif Len(Trim(arguments.cod_organograma_gerencial))>
                           and ct.cod_organograma_gerencial = #arguments.cod_organograma_gerencial#
                        </cfif>
                        <cfif Len(Trim(arguments.placa_cavalo))>
                           and ct.placa_controle = '#arguments.placa_cavalo#'
                        </cfif>
                        <cfif Len(Trim(arguments.placa_carreta))>
                           and ct.placa_referencia = '#arguments.placa_carreta#'
                        </cfif>
                        <cfif Len(Trim(arguments.cod_motorista))>
                           and ct.motorista_cod_pessoa = #arguments.cod_motorista#
                        </cfif>
                        <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                           and ct.date_insert between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                        <cfelseif Len(Trim(arguments.data_inicio))>
                           and ct.date_insert >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
                        <cfelseif Len(Trim(arguments.data_termino))>
                           and ct.date_insert <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                        </cfif>
                        
			<cfparam name="arguments.docto_entregue" default="0">
                        <cfif arguments.docto_entregue eq 1>
                           and c.usuario_entrega_documentos is not null
                        <cfelseif arguments.docto_entregue eq 0>
                           and c.usuario_entrega_documentos is null
                        </cfif>
			<cfparam name="arguments.saldo_liberado" default="0">
                        <cfif arguments.saldo_liberado eq 1>
                           and c.usuario_liberacao_saldo is not null
                        <cfelseif arguments.saldo_liberado eq 0>
                           and c.usuario_liberacao_saldo is null
                        </cfif>
			<cfparam name="arguments.adiantamento_liberado" default="0">
                        <cfif arguments.adiantamento_liberado eq 1>
                           and c.usuario_liberacao_adto is not null
                        <cfelseif arguments.adiantamento_liberado eq 0>
                           and c.usuario_liberacao_adto is null
                        </cfif>
                    </cfif>
                   ) t
             order by t.data_emissao, t.lancto_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as cartas frete Rodocred
    -- RAFAEL 29/03/2012 - CRIADO
    --->		
    <cffunction name="get_contrato_transp_bbm" access="remote" returntype="query" output="true">
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="num_formulario" required="no" default="" />
        <cfargument name="num_manifesto" required="no" default="" />
        <cfargument name="lancto_id" required="no" default="" />
        <cfargument name="cod_pessoa_filial" required="no" default="" />
        <cfargument name="cod_organograma_gerencial" required="no" default="" />
        <cfargument name="placa_cavalo" required="no" default="" />
        <cfargument name="placa_carreta" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
            select t.lancto_id
                 , t.contrato_id
                 , case
                      when t.num_formulario < 0 then ''
                      else to_char(t.num_formulario)
                   end as num_formulario
                 , case
                       when oper.pkg_veiculo.fnc_veiculo_modalidade(t.placa_controle, t.data_emissao) = 'AGREGADO' then
                          'AGREGADO'
                       else
                          'TERCEIRO'
                   end as tipo_contrato
                 , (select cg.rv_abbreviation
                      from oper.v$agreg_viagem av
                     inner join oper.cg_ref_codes cg
                             on cg.rv_domain = 'AGREG_VIAGEM.TIPO_SERVICO'
                            and cg.rv_low_value = av.tipo_servico
                     where av.lancto_id = t.lancto_id
                   ) as tipo_servico
                 , (select cg.rv_abbreviation
                      from oper.cg_ref_codes cg
                     where cg.rv_domain = 'CONTRATO_TRANSP.TIPO_CARGA'
                       and cg.rv_low_value = t.tipo_carga
                   ) as tipo_carga
                 , t.num_romaneio
                 , (select r.carregamento
                      from oper.v$romaneio r
                     where r.num_romaneio = t.num_romaneio 
                   ) as carregamento
                 , (select r.destino
                      from oper.v$romaneio r
                     where r.num_romaneio = t.num_romaneio 
                   ) as destino
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = t.cod_pessoa_filial
                   ) as unidade_negocio
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = t.cod_departamento
                   ) as departamento
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = t.cod_setor
                   ) as setor
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = t.cod_centro_custo
                   ) as centro_custo
                 , t.cod_organograma_gerencial
                 , to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , t.peso
                 , t.cod_unidade
                 , t.volume
                 , t.m3
                 , t.frete_em
                 , t.lancto_id_pai
                 , nvl(t.parcela, 1) as parcela
                 , nvl(t.total_parcela, 1) as total_parcela
                 , t.valor_unitario
                 , t.valor_frete_bruto
                 , t.valor_frete_liquido
                 , null as valor_frete_bruto_acum
                 , t.total_conhecimento
                 , t.ganho_bruto
                 , case
                      when t.total_conhecimento > 0 then
                         round((t.ganho_bruto / t.total_conhecimento) * 100, 2)
                      else 0
                   end as percentual_ganho_bruto
                 , null as total_nf_es_frete
                 , null as total_crt
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_controle) as cod_veiculo_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_referencia) as cod_veiculo_referencia
                 , kss.pkg_pessoa.fnc_get_cliente(t.proprietario_cod_pessoa) as proprietario
                 , kss.pkg_pessoa.fnc_get_cliente(t.motorista_cod_pessoa) as motorista
                 , t.rpa_id
                 , t.impresso_desc
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , t.usuario_cancelamento
                 , to_char(t.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
                 , t.usuario_aprovacao
                 , to_char(t.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao
                 , t.usuario_reprovacao
                 , to_char(t.data_reprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_reprovacao
                 , t.motivo_reprovacao
                 , t.num_manifesto
                 , t.numero_viagem as numero_viagem_rodocred
                 , nvl2(t.ciot,t.ciot || '/' || t.ciot_dv, '') as ciot
                 , t.codigo_rota
                 , t.nome_rota
                 , decode(t.rota_ativo, 1, 'Sim', 'No') as rota_ativo
                 , t.uf_origem
                 , t.localidade_origem
                 , t.uf_destino
                 , t.localidade_destino
                 , t.distancia_total
                 , t.tempo_total
                 , t.usuario_entrega_documentos
                 , to_char(t.data_entrega_documentos, 'dd/mm/yyyy hh24:mi:ss') as data_entrega_documentos
                 , t.usuario_liberacao_saldo
                 , to_char(t.data_liberacao_saldo, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_saldo
                 , t.usuario_liberacao_adto
                 , to_char(t.data_liberacao_adto, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_adto
                 , (select sign(count(1))
                      from rodocred.v$operacao_viagem ov
                     where ov.contrato_id = t.contrato_id
                       and ov.cod_operacao = 'ADF') as possui_adto
                 , (select sign(count(1))
                      from rodocred.v$operacao_viagem ov
                     where ov.contrato_id = t.contrato_id
                       and ov.cod_operacao = 'EDL') as possui_entrega_doctos
                 , (select sign(count(1))
                      from rodocred.v$operacao_viagem ov
                     where ov.contrato_id = t.contrato_id
                       and ov.cod_operacao = 'LSF') as possui_liberacao_saldo
                 , t.valor_adiantamento
                 , t.valor_saldo
                 , t.tac_id
                 , (select decode(ta.data_encerramento, null, 0, 1)
                      from rodocred.v$tac_agregado ta
                     where ta.tac_id = t.tac_id) as permite_imprimir
              from (
                    select ct.lancto_id
                         , c.contrato_id
                         , ct.num_formulario
                         , ct.tipo_contrato
                         , ct.tipo_carga
                         , ct.num_romaneio
                         , ct.cod_pessoa_filial
                         , ct.cod_departamento
                         , ct.cod_setor
                         , ct.cod_centro_custo
                         , ct.cod_organograma_gerencial
                         , ct.data_emissao
                         , ct.peso
                         , ct.cod_unidade
                         , ct.volume
                         , ct.m3
                         , ct.frete_em
                         , ct.lancto_id_pai
                         , ct.parcela
                         , ct.total_parcela
                         , ct.valor_unitario
                         , ct.valor_frete_bruto
                         , ct.valor_frete_liquido
                         , null as total_conhecimento
                         , null as ganho_bruto
                         , ct.placa_controle
                         , ct.placa_referencia
                         , ct.proprietario_cod_pessoa
                         , ct.motorista_cod_pessoa
                         , ct.rpa_id
                         , decode(ct.impresso, 1, 'Sim', 'No') as impresso_desc
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento as data_cancelamento
                         , ct.usuario_aprovacao
                         , ct.data_aprovacao
                         , ct.usuario_reprovacao
                         , ct.data_reprovacao
                         , ct.motivo_reprovacao
                         , null as num_manifesto
                         , c.numero_viagem
                         , c.ciot
                         , c.ciot_dv
                         , r.codigo_rota
                         , r.nome_rota
                         , r.ativo as rota_ativo
                         , r.uf_origem
                         , r.localidade_origem
                         , r.uf_destino
                         , r.localidade_destino
                         , r.distancia_total
                         , kss.to_tempo(numToDsInterval(r.tempo_total, 'hour'), 1).retorno as tempo_total
                         , c.usuario_entrega_documentos
                         , c.data_entrega_documentos
                         , c.usuario_liberacao_saldo
                         , c.data_liberacao_saldo
                         , c.usuario_liberacao_adto
                         , c.data_liberacao_adto
                         , c.valor_adiantamento
                         , rodocred.pkg_contrato.fnc_valor_saldo(c.contrato_id) as valor_saldo
                         , c.tac_id
                      from oper.v$contrato_transp_todos ct
                inner join rodocred.v$contrato c
                        on c.lancto_id = ct.lancto_id
                inner join rodocred.v$roteiro r
                        on r.roteiro_id = c.roteiro_id                
                     where 1 = 1
					<cfif Len(Trim(arguments.num_romaneio))>
                       and ct.num_romaneio = #arguments.num_romaneio#
                    <cfelseif Len(Trim(arguments.num_formulario))>
                       and ct.num_formulario = #arguments.num_formulario#
                    <cfelseif Len(Trim(arguments.lancto_id))>
                       and ct.lancto_id = #arguments.lancto_id#
                    <cfelseif Len(Trim(arguments.num_manifesto))>
                       and exists (select 1
                                     from oper.v$manifesto m
                                    where m.manifesto_id = ct.manifesto_id
                                      and m.num_manifesto = #arguments.num_manifesto# )                       
                    <cfelse>
                        <cfif Len(Trim(arguments.cod_pessoa_filial))>
                           and ct.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                        </cfif>
                        <cfif Len(Trim(arguments.cod_organograma_gerencial))>
                           and ct.cod_organograma_gerencial = #arguments.cod_organograma_gerencial#
                        </cfif>
                        <cfif Len(Trim(arguments.placa_cavalo))>
                           and ct.placa_controle = '#arguments.placa_cavalo#'
                        </cfif>
                        <cfif Len(Trim(arguments.placa_carreta))>
                           and ct.placa_referencia = '#arguments.placa_carreta#'
                        </cfif>
                        <cfif Len(Trim(arguments.cod_motorista))>
                           and ct.motorista_cod_pessoa = #arguments.cod_motorista#
                        </cfif>
                        <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                           and ct.date_insert between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                        <cfelseif Len(Trim(arguments.data_inicio))>
                           and ct.date_insert >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
                        <cfelseif Len(Trim(arguments.data_termino))>
                           and ct.date_insert <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                        </cfif>
          
                        <cfif arguments.docto_entregue eq 1>
                           and c.usuario_entrega_documentos is not null
                        <cfelseif arguments.docto_entregue eq 0>
                           and c.usuario_entrega_documentos is null
                        </cfif>
                        <cfif arguments.saldo_liberado eq 1>
                           and c.usuario_liberacao_saldo is not null
                        <cfelseif arguments.saldo_liberado eq 0>
                           and c.usuario_liberacao_saldo is null
                        </cfif>
                        <cfif arguments.adiantamento_liberado eq 1>
                           and c.usuario_liberacao_adto is not null
                        <cfelseif arguments.adiantamento_liberado eq 0>
                           and c.usuario_liberacao_adto is null
                        </cfif>
                    </cfif>
                   ) t
             order by t.data_emissao, t.lancto_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
</cfcomponent>
