<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os conhecimentos (CTRCs) de uma carta frete
    -- ANDERSON 22/03/2010 - CRIADO
    --->		
    <cffunction name="get_conhecimentos_carta_frete_baseline" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id
                 , c.num_conhecimento
                 , c.serie
                 , to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = c.cod_pessoa_filial
                   ) as unidade_negocio
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = c.cod_departamento
                   ) as departamento
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = c.cod_setor
                   ) as setor
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = c.cod_centro_custo
                   ) as centro_custo
                 , c.total_conhecimento
              from oper.v$contrato_transp_conhecimento ctc
             inner join fiscal.v$conhecimento c
                     on c.conhecimento_id = ctc.conhecimento_id
             where ctc.lancto_id = #arguments.lancto_id#
             order by c.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os conhecimentos (CTRCs) de uma carta frete
    -- ANDERSON 22/03/2010 - CRIADO
    --->		
    <cffunction name="get_conhecimentos_carta_frete_bbm" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id
                 , c.num_conhecimento
                 , c.serie
                 , to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = c.cod_pessoa_filial
                   ) as unidade_negocio
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = c.cod_departamento
                   ) as departamento
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = c.cod_setor
                   ) as setor
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = c.cod_centro_custo
                   ) as centro_custo
                 , c.total_conhecimento
                 , dcte.documento_id
              from oper.v$contrato_transp_conhecimento ctc
             inner join fiscal.v$conhecimento c
                on c.conhecimento_id = ctc.conhecimento_id
             inner join fiscal.v$documento_cte dcte
                on dcte.conhecimento_id = c.conhecimento_id
             where ctc.lancto_id = #arguments.lancto_id#
             order by c.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
</cfcomponent>