<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere/Altera/Exclui os dados Repom para uma solicitao de carga
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='ins_solicit_carga_dados' displayname='Insere/Altera/Exclui os dados Repom para uma solicitao de carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
		<cfargument name='CARTAO_NUMERO' required='yes'>
		<cfargument name='ADTO_TRAJETO_VAZIO' required='yes'>
		<cftry>
            <cfstoredproc procedure='repom.pkg_logistica.prc_ins_solicit_carga_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ADTO_TRAJETO_VAZIO#'  null='#iif(len(trim(arguments.ADTO_TRAJETO_VAZIO)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.MENSAGEM' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Consulta os roteiros cadastrados na Repom
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='consulta_roteiros' displayname='Consulta os roteiros cadastrados na Repom' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
        <cfargument name='TIPO_INTEGRACAO' required="no" default="1">
		<cftry>
            <cfstoredproc procedure='repom.pkg_repom.prc_consulta_roteiros' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5"  value='#arguments.TIPO_INTEGRACAO#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Solicita um roteiro
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='solicita_roteiro' displayname='Solicita um roteiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_ID' required='yes'>
        <cfargument name='DESCRICAO_ROTA' required='no' default=''>
		<cfargument name='PEDAGIO_IDA_VOLTA' required='no' default=''>
        <cfargument name='ENVIA_SOLICITACAO' required='no' default=''>
        <cfargument name='TIPO_INTEGRACAO' required='no' default='1' >
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_repom.prc_solicita_roteiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO_ROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO_IDA_VOLTA#'  null='#iif(len(trim(arguments.PEDAGIO_IDA_VOLTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ENVIA_SOLICITACAO#'  null='#iif(len(trim(arguments.ENVIA_SOLICITACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.TIPO_INTEGRACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Roteiro solicitado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Verifica o carto
    -- ANDERSONC 30/05/2012 - ALTERADO
    --->
    <cffunction name='verificar_cartao' displayname='Verifica o carto' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
        <cfargument name='CARTAO_NUMERO' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='repom.pkg_logistica.prc_verificar_cartao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao para Verificar Carto na Repom enviada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Verifica o roteiro e retorna o valor de pedgio
    -- ANDERSONC 30/05/2012 - ALTERADO
    --->
    <cffunction name='verificar_roteiro' displayname='Verifica o roteiro e retorna o valor de pedgio' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
        <cfargument name='ROTA_ID' required='no' default=''>
        <cfargument name='PLACA_CAVALO' required='no' default=''>
        <cfargument name='PLACA_CARRETA' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='repom.pkg_logistica.prc_verificar_roteiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_PEDAGIO_ROTA' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao para Verificar Roteiro na Repom enviada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Solicita o roteiro
    -- ANDERSONC 30/05/2012 - ALTERADO
    --->
    <cffunction name='solicitar_roteiro' displayname='Solicita o roteiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
        <cfargument name='ROTA_ID' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='repom.pkg_logistica.prc_solicitar_roteiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Roteiro solicitado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Verifica os dados do contratado, motorista, cavalo e carreta
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='verificar_dados' displayname='Verifica os dados do contratado, motorista, cavalo e carreta' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
		<cfargument name='PLACA_CAVALO' required='no' default=''>
		<cfargument name='PLACA_CARRETA' required='no' default=''>
		<cfargument name='COD_MOTORISTA' required='no' default=''>
		<cfargument name='COD_CONTRATADO' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_logistica.prc_verificar_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CONTRATADO#'  null='#iif(len(trim(arguments.COD_CONTRATADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao para Atualizar Cadastros na Repom enviada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Emite um contrato vazio
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='emitir_contrato_vazio' displayname='Emite um contrato vazio' access='remote' returntype='Struct' output='true'>
		<cfargument name='VIAGEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_contrato.prc_emitir_contrato_vazio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTRATO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato emitido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Emite um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='emitir_contrato' displayname='Emite um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='ROTA_ID' required='yes'>
		<cfargument name='CARTAO_NUMERO' required='yes'>
		<cfargument name='EIXO_SUSPENSO' required='no' default=''>
		
		<cftry>
            <cfstoredproc procedure='repom.pkg_contrato.prc_emitir_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTRATO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'     value='#arguments.EIXO_SUSPENSO#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Contrato emitido com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Integra um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='integrar_contrato' displayname='Integra um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_contrato.prc_integrar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato integrado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancela um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='cancelar_contrato' displayname='Cancela um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_contrato.prc_cancelar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato cancelado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gera o PDF de impresso de um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='gera_contrato' displayname='Gera o PDF de impresso de um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_impressao.prc_gera_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impresso gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Consulta um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='consulta_contrato' displayname='Consulta um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_repom.prc_consulta_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1'  null='no'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.RESULT' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato consultado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um dbito/crdito em um contrato
	-- ANDERSONC 30/05/2012 15:06:08 - CRIADO
	--->
	<cffunction name='debito_credito_contrato' displayname='Insere um dbito/crdito em um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='USUARIO_LIBERACAO' required='yes'>
		<cfargument name='SENHA_LIBERACAO' required='yes'>
        <cfargument name='DEBITO_CREDITO' required='yes'>
        <cfargument name='OBSERVACAO' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_contrato.prc_debito_credito_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO_LIBERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SENHA_LIBERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
                <cfif arguments.DEBITO_CREDITO eq 1>
					<cfset retorno.mensagem = JSStringFormat('Dbito inserido com sucesso.')>
                <cfelse>
                	<cfset retorno.mensagem = JSStringFormat('Crdito inserido com sucesso.')>
                </cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Quita um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='quitar_contrato' displayname='Quita um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='PESO_ENTREGA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_contrato.prc_quitar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTRATO_QUITACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_ENTREGA#'  null='#iif(len(trim(arguments.PESO_ENTREGA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato quitado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gera o PDF de impresso de um recibo de pagamento
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='gera_contrato_quitacao' displayname='Gera o PDF de impresso de um recibo de pagamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_QUITACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_impressao.prc_gera_contrato_quitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_QUITACAO_ID#'  null='#iif(len(trim(arguments.CONTRATO_QUITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impresso gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Autoriza o pagamento de um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='autoriza_pagamento' displayname='Autoriza o pagamento de um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='QUANTIDADE_DIAS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_repom.prc_autoriza_pagamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE_DIAS#'  null='#iif(len(trim(arguments.QUANTIDADE_DIAS)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pagamento do contrato autorizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Buscar o retorno da validao da ANTT
	-- RAFAEL 19/06/2012 16:36:40 - CRIADO
	--->
	<cffunction name='retorno_financeiro' displayname='Retornos financeiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='MERCOSUL' required='yes' default="0">
		<cftry>
				<cfstoredproc procedure='repom.pkg_retorno.prc_financeiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MERCOSUL#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch.Detail>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!--- 
	-- PROPSITO
	-- Buscar o retorno da validao da ANTT
	-- RAFAEL 19/06/2012 16:36:40 - CRIADO
	--->
	<cffunction name='retorno_contabil' displayname='Retornos financeiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='MERCOSUL' required='yes' default="0">
		<cftry>
				<cfstoredproc procedure='repom.pkg_retorno.prc_contabil' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MERCOSUL#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch.Detail>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!--- 
	-- PROPSITO
	-- Buscar o retorno da validao da ANTT
	-- RAFAEL 19/06/2012 16:36:40 - CRIADO
	--->
	<cffunction name='retorno_antt' displayname='Buscar o retorno da validao da ANTT' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA_CAVALO' required='yes'>
		<cfargument name='PLACA_CARRETA' required='yes'>
		<cfargument name='COD_CONTRATADO' required='yes'>
		<cftry>
				<cfstoredproc procedure='repom.pkg_logistica.prc_retorno_antt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CONTRATADO#'  null='#iif(len(trim(arguments.COD_CONTRATADO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VEICULO_VALIDADO_ANTT' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.VEICULO_ERRO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CARRETA_VALIDADO_ANTT' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CARRETA_ERRO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTRATADO_VALIDADO_ANTT' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CONTRATADO_ERRO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere a taxa de ativacao do contrato
	-- KMM_THOMASJ 08/04/2014 14:05:00- CRIADO
	--->
	<cffunction name='ins_taxa_ativacao' displayname='nsere a taxa de ativacao do contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='CARTAO_NUMERO' required='yes'>
        <cfargument name='CARTAO_ID' required='no'>
		<cftry>
            <cfstoredproc procedure='repom.pkg_contrato.prc_ins_taxa_ativacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CARTAO_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

</cfcomponent>
