<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Seleciona as tarefas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 20/07/2005 - criado
	--->
	<cffunction name="getEmail" access="remote" returntype="Query" output="false">	  
		<cfargument name="cod_pessoa" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select pe.email_id,
					   pe.email_proprietario,
					   pe.email_obs,
					   em.email_completo as email_end,
					   pe.email_padrao,
                       pe.cargo_id as email_cargo_id,
                       pe.setor_id as email_setor_id,
                       pe.email_tipo_id 
				  from kss.v$pessoa_email pe
				 inner join kss.v$email em 
						 on em.email_id = pe.email_id
				 where pe.cod_pessoa = #arguments.cod_pessoa#
				 order by email_padrao desc
			</cfquery>  
		<cfreturn qr />
	</cffunction>			
	
	<!--- 
	-- PROPSITO
	-- Seleciona as tarefas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="getEndereco" access="remote" returntype="Query" output="false">	  
		<cfargument name="cod_pessoa" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select cod_pessoa,
					   cod_endereco,
					   cep,
					   logradouro,
					   numero,
					   complemento,
					   bairro,
					   uf,
					   municipio,
					   cod_endereco_tipo,
					   endereco_padrao, municipio_id
				  from kss.v$pessoa_endereco
				 where cod_pessoa = #arguments.cod_pessoa#
			</cfquery>  
		<cfreturn qr />
	</cffunction>			
	
	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVA
	--  
	-- CRISTOFER 20/07/2005 - criado
	--->		
	<cffunction name="getPessoa" access="remote" returntype="Query" output="true">	  
			<cfargument name="cnpj_cpf" required="no" default="">
			<cfargument name="rapida" displayname="Informa se a consulta  rapida" required="no" default="0">
			<cfargument name="cod_cadastro_contribuinte" required="no" default="">		
			<cfargument name="razao_social" required="no" default="">
            <cfargument name="cliente" required="no" default="">
            <cfargument name="municipio" required="no" default="">
			<cfargument name="cod_pessoa" required="no" default="">	
			<cfargument name="cod_funcionario" required="no" default="">	
			<cfargument name="num_modalidade" required="no" default="">
			<cfargument name="tipo_pessoa" required="no" default="">
			<cfargument name="completo" required="no" default="0">
			<cfargument name="excluir_filiais" required="no" default="">
			<cfif len(Trim(arguments.COD_FUNCIONARIO))>
				<cfquery name="qr_func" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select decode(oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.COD_FUNCIONARIO#),-1,#arguments.COD_FUNCIONARIO#,oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.COD_FUNCIONARIO#)) as cod_pessoa
					  from dual 
				</cfquery>
				<cfset arguments.COD_PESSOA = qr_func.COD_PESSOA>
			</cfif>
			<cfquery result="query" name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select p.cod_pessoa,
					   p.tipo_pessoa,
                       pf.naturalidade,
                       <cfif session.site eq "delpozo/">
                       pf.cart_ident_emissao_uf,
                       to_char(pf.cnh_primeira_habilitacao,'dd/mm/yyyy') as primeira_cnh,
                       (select to_char(pcc.data_emissao_rntrc_tac, 'dd/mm/yyyy')
                          from kss.v$pessoa_cliente pcc
                         where pcc.cod_pessoa = p.cod_pessoa) as data_emissao_rntrc_tac,                       
                       to_char(pj.data_admissao,'dd/mm/yyyy') as data_admissao,
                       to_char(pf.cnh_data_emissao,'dd/mm/yyyy') as cnh_data_emissao,
					   (select to_char(pcc.data_validade_registro, 'dd/mm/yyyy')
                          from kss.v$pessoa_cliente pcc
                         where pcc.cod_pessoa = p.cod_pessoa) as data_validade_registro,
                       (select pcc.rntrc
                          from kss.v$pessoa_cliente pcc
                         where pcc.cod_pessoa = p.cod_pessoa) as rntrc,
                       </cfif>
                       <cfif session.site neq "delpozo/" and session.site neq "ouroverde/" and session.site neq "rodomar/" and session.site neq "bbm/">
                           decode(p.tipo_pessoa, 0, pj.rntrc_tac, 1, pf.rntrc_tac, 2, pe.rntrc_tac) as rntrc_tac,
                           decode(p.tipo_pessoa, 0, to_char(pj.data_vencimento_rntrc_tac,'dd/mm/yyyy'), 1, to_char(pf.data_vencimento_rntrc_tac,'dd/mm/yyyy'), 2, to_char(pe.data_vencimento_rntrc_tac,'dd/mm/yyyy')) as data_vencimento_rntrc_tac,
                           decode(p.tipo_pessoa, 0, to_char(pj.data_emissao_rntrc_tac,'dd/mm/yyyy'), 1, to_char(pf.data_emissao_rntrc_tac,'dd/mm/yyyy'), 2, to_char(pe.data_emissao_rntrc_tac,'dd/mm/yyyy')) as data_emissao_rntrc_tac,
                           to_char(pf.cnh_data_emissao,'dd/mm/yyyy') as cnh_data_emissao,
                           pf.cart_ident_uf,
                           to_char(pf.cnh_primeira_habilitacao, 'dd/mm/yyyy') as cnh_primeira_habilitacao,
                           pf.cnh_numero,
                           pf.cnh_uf as cnh_uf,
                       </cfif>
                       to_char(pf.cart_ident_emissao,'dd/mm/yyyy') as cart_ident_emissao,
                       pj.inscricao_municipal as ins_municipal,
                       pj.inscricao_municipal as insc_municipal,
      				   pf.uf_naturalidade,
                       pj.razao_social,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.identificador) as identificador,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.cnpj_cpf) as cnpj_cpf,
					   p.inscricao_estadual,
					   p.cliente,                      
					   p.cod_atividade_fiscal,
					   p.tipo_pessoa as tipo_pessoa_id,
					   pf.cnh_num_registro as cnh,
					   trim(to_char(pf.cnh_validade, 'dd/mm/yyyy')) as validade_cnh,
					   pf.cnh_cod_categoria as categoria_cnh,
					   trim(to_char(pf.data_nascimento, 'dd/mm/yyyy')) as data_nascimento,
					   pf.cart_ident_num as rg,
					   pf.nome_pai,
					   pf.nome_mae,
                       pf.cod_estado_civil as estado_civil,
                       (select ec.estado_civil
                          from kss.estado_civil ec
                         where ec.cod_estado_civil = pf.cod_estado_civil) as estado_civil_desc,
					   pf.cart_ident_orgao as rg_orgao,
                       pf.cod_sexo,
                       <cfif session.site eq "delpozo/">
                       kss.pkg_pessoa.FNC_GET_ATRIBUTO(p.cod_pessoa, 4) as ja_carrega_empresa,
                       </cfif>
						<cfif session.site neq "transemba/" and session.site neq "portalkmm/" and session.site neq "delpozo/" >
						/* Relacionado ao pessoa_atributo */				   
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 1) as rntrc,
                       kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 18) as cart_ident_emissao_uf,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 2) as validade_rntrc,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 3) as primeira_cnh,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 4) as ja_carrega_empresa,				   
					   <cfif (session.site neq "ouroverde/") and (session.site neq "axon/")>
                       kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 5) as uf_cnh,
                       </cfif>
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 6) as permisso_numero,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 7) as permisso_data,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 8) as apolice_numero,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9) as apolice_vencimento,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 10) as IVA,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 11) as NOME_ESCRITORIO,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 12) as CONTATOS,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 13) as EMPRESAS_REPRESENTADAS,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 16) as COD_CONTA,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 17) as CONTATO_CORRESPONDENCIA,
                       </cfif>
                       
						/* Relacionado ao pessoa_atributo */				   
	
					   case when p.tipo_pessoa = 0 then p.cnpj_cpf else null end as cnpj_completo,
					   case when p.tipo_pessoa = 0 then p.cliente else null end as nome_fantasia,
					   case when p.tipo_pessoa = 0 then p.inscricao_estadual else null end as inscricao_estadual_pj,
					   case when p.tipo_pessoa = 0 then p.razao_social else null end as razao_social,
					   case when p.tipo_pessoa = 0 then pj.cnae else null end as cnae,
                       <cfif session.site eq "rodomar/">
                       	case when p.tipo_pessoa = 0 then pj.alvara else null end as alvara_pj,
							case when p.tipo_pessoa = 1 then pf.alvara else null end as alvara_pf,  
                       </cfif>	
					   
                       case when p.tipo_pessoa = 1 then p.cliente else null end as nome,
					   case when p.tipo_pessoa = 1 then p.inscricao_estadual else null end as inscricao_estadual_pf,
					   case when p.tipo_pessoa = 1 then p.cnpj_cpf else null end as cpf,
                       
					   case when p.tipo_pessoa = 2 then p.cliente else null end as pe_nome,
					   case when p.tipo_pessoa = 2 then pe.municipio else null end as pe_municipio,
					   case when p.tipo_pessoa = 2 then pe.cod_cadastro_contribuinte else null end as cod_cadastro_contribuinte,
					   case when p.tipo_pessoa = 2 then pe.endereco else null end as pe_endereco,
					   case when p.tipo_pessoa = 2 then pe.estado_provincia else null end as estado_provincia,
					   case when p.tipo_pessoa = 2 then pe.codigo_postal else null end as codigo_postal,
					   case when p.tipo_pessoa = 2 then pe.pais else null end as pe_pais,
					   
                       pe.nome_fantasia as pe_nome_fantasia,
					   ped.logradouro as logradouro,
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.endereco, ped.logradouro || ', ' || ped.numero || decode(ped.complemento,null,'',' - ' || ped.complemento) || decode(ped.bairro,null,'',' - ' || ped.bairro)) as endereco,
					   ped.bairro, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.codigo_postal, to_char(ped.cep)) as cep, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.municipio, ped.municipio) as municipio, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, 'EX', ped.uf) as uf, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.municipio, ped.municipio) || decode(nvl(ped.uf,'EX'), 'EX', '', ' - ' || ped.uf) municipio_uf, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.municipio_ID, ped.municipio_id) municipio_id, 
					   decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) telefone, 
					   m.pais_id, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.pais,ps.descricao) as pais,
					   pf.pis_pasep_nit
					<cfif (session.site neq "granex/") and (session.site neq "transemba/") and (session.site neq "portalkmm/")>
					   ,oper.pkg_global.FNC_GET_COD_FUNCIONARIO(p.cod_pessoa) as cod_funcionario
					</cfif>
					<cfif (session.site eq "ouroverde/")>
                        ,pf.cnh_numero
                        ,pf.cnh_uf as uf_cnh
                    <cfelseif (session.site eq "axon/")>
                        ,pf.cnh_numero
                        ,pf.cnh_uf as uf_cnh
                    </cfif>
                    <cfif (session.site eq "transemba/" or session.site eq "axon/"  or session.site eq "estapostes/")>
                    	, p.tipo_transportador
                    </cfif>
				  from kss.v$pessoa p
				  left join kss.v$pessoa_fisica pf
						 on pf.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_juridica pj
						 on pj.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_estrangeira pe
						 on pe.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_endereco ped 
						 on ped.cod_pessoa = p.cod_pessoa
						and ped.endereco_padrao = 1
				  left join kss.v$pessoa_telefone pt 
						 on pt.cod_pessoa = p.cod_pessoa
						and pt.telefone_padrao = 1
				  left join kss.v$telefone t 
						 on t.telefone_id = pt.telefone_id
				  left join cep.municipio m
						 on m.municipio_id = ped.municipio_id
				  left join cep.pais ps 
						 on ps.pais_id = m.pais_id					 
				 where 1 = 1
				 <cfif len(trim(arguments.razao_social))>
				   and upper(kss.pkg_string.fnc_string_clean(p.razao_social)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.razao_social#%'))
				 </cfif>
                 <cfif len(trim(arguments.cliente))>
				   and upper(kss.pkg_string.fnc_string_clean(p.cliente)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.cliente#%'))
				 </cfif>
                 <cfif len(trim(arguments.municipio))>
				   and upper(kss.pkg_string.fnc_string_clean(decode(p.tipo_pessoa, 2 /*Estrangeira*/, pe.municipio, ped.municipio))) like upper(kss.pkg_string.fnc_string_clean('%#arguments.municipio#%'))
				 </cfif>
				 <cfif len(trim(arguments.excluir_filiais))>
				   and  p.cnpj_cpf not like  '#Left(Replace(Replace(session.empresa.CNPJ,'C.N.P.J.: ','','ALL'),'.','','ALL'),8)#%'
				 </cfif>
				 <cfif len(trim(arguments.cnpj_cpf)) and arguments.completo eq 0>
				   and (p.cnpj_cpf like '#arguments.cnpj_cpf#%' or pe.cod_cadastro_contribuinte like '#arguments.cnpj_cpf#%')
				 </cfif> 
				 <cfif len(trim(arguments.cnpj_cpf)) and arguments.completo eq 1>
				   and p.cnpj_cpf = '#arguments.cnpj_cpf#'
				 </cfif> 
				 <cfif arguments.rapida eq 1>
				   and rownum = 1
				 </cfif>
				 <cfif len(trim(arguments.cod_cadastro_contribuinte))>
				   and pe.cod_cadastro_contribuinte = '#arguments.cod_cadastro_contribuinte#'
				 </cfif>
				 <cfif len(trim(arguments.cod_pessoa))>
				   and p.cod_pessoa = #arguments.cod_pessoa#
				 </cfif>
				 <cfif len(trim(arguments.tipo_pessoa)) >
				   and p.tipo_pessoa in (#arguments.tipo_pessoa#)
				 </cfif>	
				 <cfif len(trim(arguments.num_modalidade))>
                   and exists (select 1
                                 from kss.v$pessoa_modalidade pm 
                                where pm.cod_pessoa = p.cod_pessoa
                                  and pm.num_modalidade in (#arguments.num_modalidade#)
                                  and pm.situacao = 1)
				 </cfif>                 
				 order by p.cliente
			</cfquery>  
		<cfreturn qr />
	</cffunction>			


	<!--- 
	-- PROPSITO
	-- CRISTOFER 20/07/2005 - criado
	--->		
	<cffunction name="get_pessoa_endereco_comercial" access="remote" returntype="Query" output="true">	  
			<cfargument name="cnpj_cpf" required="no" default="">
			<cfargument name="rapida" displayname="Informa se a consulta  rapida" required="no" default="0">
			<cfargument name="cod_cadastro_contribuinte" required="no" default="">		
			<cfargument name="cliente" required="no" default="">	
			<cfargument name="cod_pessoa" required="no" default="">	
			<cfargument name="cod_funcionario" required="no" default="">	
			<cfargument name="num_modalidade" required="no" default="">
			<cfargument name="tipo_pessoa" required="no" default="">
			<cfargument name="excluir_filiais" required="no" default="">
            <cfargument name="cod_atividade_fiscal" required="no" default="">
			<cfif len(Trim(arguments.COD_FUNCIONARIO))>
				<cfquery name="qr_func" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.COD_FUNCIONARIO#) as cod_pessoa
					  from dual 
				</cfquery>
				<cfset arguments.COD_PESSOA = qr_func.COD_PESSOA>
			</cfif>
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select p.cod_pessoa,
					   p.tipo_pessoa,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.identificador) as identificador,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.cnpj_cpf) as cnpj_cpf,
					   p.inscricao_estadual,
					   p.cliente,
					   p.cod_atividade_fiscal,
					   p.tipo_pessoa as tipo_pessoa_id,
					   pf.cnh_num_registro as cnh,
					   trim(to_char(pf.cnh_validade, 'dd/mm/yyyy')) as validade_cnh,
					   pf.cnh_cod_categoria as categoria_cnh,
					   trim(to_char(pf.data_nascimento, 'dd/mm/yyyy')) as data_nascimento,
					   pf.cart_ident_num as rg,
					   pf.nome_pai,
					   pf.nome_mae,
					   pf.cod_estado_civil as estado_civil,
					   pf.cart_ident_orgao as rg_orgao,
	
					   case when p.tipo_pessoa = 0 then p.cnpj_cpf else null end as cnpj_completo,
					   case when p.tipo_pessoa = 0 then p.cliente else null end as nome_fantasia,
					   case when p.tipo_pessoa = 0 then p.inscricao_estadual else null end as inscricao_estadual_pj,
					   case when p.tipo_pessoa = 0 then p.razao_social else null end as razao_social,
					   case when p.tipo_pessoa = 0 then pj.cnae else null end as cnae,
	
					   case when p.tipo_pessoa = 1 then p.cliente else null end as nome,
					   case when p.tipo_pessoa = 1 then p.inscricao_estadual else null end as inscricao_estadual_pf,
					   case when p.tipo_pessoa = 1 then p.cnpj_cpf else null end as cpf,
	
					   case when p.tipo_pessoa = 2 then p.cliente else null end as pe_nome,
					   case when p.tipo_pessoa = 2 then pe.municipio else null end as pe_municipio,
					   case when p.tipo_pessoa = 2 then pe.cod_cadastro_contribuinte else null end as cod_cadastro_contribuinte,
					   case when p.tipo_pessoa = 2 then pe.endereco else null end as pe_endereco,
					   case when p.tipo_pessoa = 2 then pe.estado_provincia else null end as estado_provincia,
					   case when p.tipo_pessoa = 2 then pe.codigo_postal else null end as codigo_postal,
					   case when p.tipo_pessoa = 2 then pe.pais else null end as pe_pais,
					   
					   case when p.tipo_pessoa <> 2 then ped.logradouro else pe.endereco end as logradouro,
					   ped.numero as endereco_numero,
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.endereco, ped.logradouro || ', ' || ped.numero || decode(ped.complemento,null,'',' - ' || ped.complemento) || decode(ped.bairro,null,'',' - ' || ped.bairro)) as endereco,
					   ped.bairro, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.codigo_postal, to_char(ped.cep)) as cep, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.municipio, ped.municipio) as municipio, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, 'EX', ped.uf) as uf, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.municipio, ped.municipio) || decode(nvl(ped.uf,'EX'), 'EX', '', ' - ' || ped.uf) municipio_uf, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.municipio_ID, ped.municipio_id) municipio_id, 
					   decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) telefone, 
					   m.pais_id, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.pais,ps.descricao) as pais,
					   pf.pis_pasep_nit
				  from kss.v$pessoa p
				  left join kss.v$pessoa_fisica pf
						 on pf.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_juridica pj
						 on pj.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_estrangeira pe
						 on pe.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_endereco ped 
						 on ped.cod_pessoa = p.cod_pessoa
						and ped.endereco_padrao = 1
				  left join kss.v$pessoa_telefone pt 
						 on pt.cod_pessoa = p.cod_pessoa
						and pt.telefone_padrao = 1
				  left join kss.v$telefone t 
						 on t.telefone_id = pt.telefone_id
				  left join cep.municipio m
						 on m.municipio_id = ped.municipio_id
				  left join cep.pais ps 
						 on ps.pais_id = m.pais_id					 
				 <cfif len(trim(arguments.num_modalidade))>
				 inner join kss.v$pessoa_modalidade pm
						 on pm.cod_pessoa = p.cod_pessoa
						and pm.num_modalidade in (#arguments.num_modalidade#)
						and pm.situacao = 1
				 </cfif>
				 where 1=1
				 <cfif len(trim(arguments.cliente))>
				   and upper(p.cliente) like upper('%#arguments.cliente#%')
				 </cfif>
				 <cfif len(trim(arguments.excluir_filiais))>
				   and  p.cnpj_cpf not like  '#Left(Replace(Replace(session.empresa.CNPJ,'C.N.P.J.: ','','ALL'),'.','','ALL'),8)#%'
				 </cfif>
				 <cfif len(trim(arguments.cnpj_cpf))>
				   and (p.cnpj_cpf like '#arguments.cnpj_cpf#' or pe.cod_cadastro_contribuinte like '#arguments.cnpj_cpf#%')
				 </cfif> 
				 <cfif arguments.rapida eq 1>
				   and rownum = 1
				 </cfif>
				 <cfif len(trim(arguments.cod_cadastro_contribuinte))>
				   and pe.cod_cadastro_contribuinte = '#arguments.cod_cadastro_contribuinte#'
				 </cfif>
				 <cfif len(trim(arguments.cod_pessoa))>
				   and p.cod_pessoa = #arguments.cod_pessoa#
				 </cfif>
				 <cfif len(trim(arguments.tipo_pessoa))>
				   and p.tipo_pessoa in (#arguments.tipo_pessoa#)
				 </cfif>
                 <cfif Len(Trim(arguments.cod_atividade_fiscal))>
				   and p.cod_atividade_fiscal = #arguments.cod_atividade_fiscal#
				 </cfif>
				 order by p.cliente
			</cfquery>  
		<cfreturn qr />
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Seleciona as tarefas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="getTelefone" access="remote" returntype="Query" output="false">	  
		<cfargument name="cod_pessoa" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select pt.cod_pessoa,
					   pt.telefone_id,
					   pt.telefone_contato,
					   pt.telefone_tipo_id,
					   pt.telefone_padrao,
					   te.fone_ddd telefone_ddd,
					   te.fone_prefixo telefone_prefixo,
					   te.fone_numero telefone_numero,
					   te.fone_ramal telefone_ramal,
					   te.fone_ramal as ramal,
                       pt.cargo_id as telefone_cargo_id,
                       pt.setor_id as telefone_setor_id
				  from kss.v$pessoa_telefone pt
				 inner join kss.v$telefone te on te.telefone_id = pt.telefone_id
				 where pt.cod_pessoa = #arguments.cod_pessoa#
			</cfquery>  
		<cfreturn qr />
	</cffunction>			
	
	<!--- 
	-- PROPSITO
	-- Seleciona as tarefas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="getTelefoneTipo" access="remote" returntype="Query" output="false">	  
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select telefone_tipo_id,
					   telefone_tipo_descricao,
					   telefone_tipo_abrev
				  from kss.v$telefone_tipo
			</cfquery>  
		<cfreturn qr />
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Seleciona as tarefas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="getUsuariosPessoa" access="remote" returntype="Query" output="false">	  
			<cfargument name="cod_pessoa" required="no" default="">   			
            <cfargument name="usuario" required="no" default="">
            <cfargument name="cnpj_cpf" required="no" default="">
            <cfargument name="pessoa_fisica" required="no" default="">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select u.usuario as usuario_login,
					   u.nome as usuario_nome,
					   u.apelido,
					   u.ativo,
					   u.email_id,
					   case when e.email_id is not null then e.email_username||'@'||e.email_provedor else null end as usuario_email,
					   u.cod_pessoa,
					   p.cnpj_cpf,
                       p.razao_social,
					   u.user_insert,
					   u.date_insert,
					   u.user_update,
					   u.date_update,
					   u.site
				  from kss.v$usuarios u
				  left join kss.v$email e 
						 on e.email_id = u.email_id
                  left join kss.v$pessoa p
                  	     on p.cod_pessoa = u.cod_pessoa
				  where 1 = 1                 
				  <cfif Len(Trim(arguments.cod_pessoa))>
                         and u.cod_pessoa = #arguments.cod_pessoa#
                 </cfif>                   
                 <cfif Len(Trim(arguments.usuario))>
                         and upper(u.usuario) = upper('#arguments.usuario#')
                 </cfif>
                 <cfif Len(Trim(arguments.cnpj_cpf))>
                         and p.cnpj_cpf = '#arguments.cnpj_cpf#'
                 </cfif>
                 <cfif arguments.pessoa_fisica eq 1>
                         and p.tipo_pessoa <> 0
                         and p.tipo_pessoa <> 2
                 </cfif>
    		     and u.ativo = 1
			</cfquery>  
		<cfreturn qr />
	</cffunction>			
	
	<!--- 
	-- PROPSITO
	-- Seleciona a Gesto
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="getGestaoPessoa" access="remote" returntype="Query" output="false">	  
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select cod_pessoa, 
					   cod_gestao, 
					   nome
				  from transportes.v$gestao_pessoa
			</cfquery>  
		<cfreturn qr />
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Seleciona a conta corrente
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="getContaCorrente" access="remote" returntype="Query" output="false">	  
		<cfargument name="cod_pessoa" required="yes" />
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select cod_conta, descricao_conta, 
					   oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cod_conta, sysdate) as saldo,
					   modalidade_id
				  from oper.v$ccorrente 
				  where cod_pessoa = #arguments.cod_pessoa#
  			</cfquery>  
		<cfreturn qr_result />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Verifica se a pessoa j est relacionada a alguma modalidade
	-- NOTAS EXPLICATIVAS
	--  
	-- ARLEN 11/10/2006 - criado
	--->			
	<cffunction name="getPessoaModalidade" access="remote" returntype="Query" output="false">	  
		<cfargument name="cod_pessoa" required="yes" />
		<cfargument name="num_modalidade" required="yes" />
        <cfargument name="multiplas_modalidades" required="no" default="0" />
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select cod_pessoa, num_modalidade
				  from kss.v$pessoa_modalidade
				 where cod_pessoa = #arguments.cod_pessoa#
				<cfif arguments.multiplas_modalidades eq 0>
                   and num_modalidade = #arguments.num_modalidade#
				<cfelse>
				   and num_modalidade in (#arguments.num_modalidade#)
                </cfif>
  			</cfquery>  
		<cfreturn qr_result />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona dados da empresa
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 31/01/2006 - criado
	--->			
	<cffunction name="get_dados_empresa" access="remote" returntype="Query" output="false">	  
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
        	select e.cod_pessoa, 
            	   e.razao_social, 
                   e.nome_fantasia, 
                   p.cnpj_cpf as cnpj,
                   kss.pkg_atributo.fnc_get_atributo(e.cod_pessoa,6) as permisso_numero,
                   kss.pkg_atributo.fnc_get_atributo(e.cod_pessoa,7) as permisso_vencto,
                   kss.pkg_atributo.fnc_get_atributo(e.cod_pessoa,8) as apolice_numero,
                   kss.pkg_atributo.fnc_get_atributo(e.cod_pessoa,9) as apolice_vencto,
                   decode(p.tipo_pessoa,2/*Estrangeira*/, pes.endereco, pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento) as endereco,
                   pe.bairro, 
                   decode(p.tipo_pessoa,2/*Estrangeira*/, pes.codigo_postal, to_char(pe.cep)) as cep, 
                   decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio, pe.municipio) as municipio, 
                   decode(p.tipo_pessoa,2/*Estrangeira*/, 'EX', pe.uf) as uf, 
                   decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio, pe.municipio) || decode(nvl(pe.uf,'EX'), 'EX', (select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = p.cod_pessoa), ' - ' || pe.uf) municipio_uf, 
                   decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio_id, pe.municipio_id) as municipio_id,
                   decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) telefone, 
                   m.pais_id, 
                   decode(p.tipo_pessoa,2/*Estrangeira*/, pes.pais,ps.descricao) as pais
              from kss.v$empresa e
             inner join kss.v$pessoa p
                     on p.cod_pessoa = e.cod_pessoa
              left join kss.v$pessoa_endereco pe 
                     on pe.cod_pessoa = e.cod_pessoa
                    and pe.endereco_padrao = 1
              left join kss.v$pessoa_estrangeira pes
                     on pes.cod_pessoa = e.cod_pessoa
              left join kss.v$pessoa_telefone pt 
                     on pt.cod_pessoa = e.cod_pessoa
                    and pt.telefone_padrao = 1
              left join kss.v$telefone t 
                     on t.telefone_id = pt.telefone_id
              left join cep.municipio m
                     on m.municipio_id = pe.municipio_id
              left join cep.pais ps 
                     on ps.pais_id = m.pais_id
		</cfquery>  
		<cfreturn qr_result/>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Seleciona o endereo da pessoa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="get_endereco" access="remote" returntype="query" output="false">
		<cfargument name="cep" displayname="CEP para ser consultado" required="true">
			<cfquery name="qr_endereco" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select m.municipio_id, log.cep8_log as cep,            
					   initcap(tit.abrev_tipo || '.' || '  ' || log.nome_log) as logradouro,            
					   initcap(decode(loc.tipo_local, 'D', 'Dist. ' || initcap(loc.nome_local),  
					   decode(loc.tipo_local,'P', 'Pov. ' || initcap(loc.nome_local) , 
					   initcap(bai.extenso_bai)))) as bairro,            
					   initcap(bai2.extenso_bai) as bairro2,            
					   m.municipio as local,            
					   uf.sigla_uf as uf, loc.cod_uf, 
					   loc.cod_municipio, loc.cod_distrito, loc.cod_dv
				  from cep.cep_log log
				 inner join cep.cep_tit tit
						 on log.chave_tipo = tit.chave_tipo
				 inner join cep.cep_bai bai
						 on log.chvbai1_log = bai.chave_bai
						and log.chave_local = bai.chave_local
				 inner join cep.cep_loc loc
						 on log.chave_local = loc.chave_local     
				 inner join cep.cep_ufs uf
						 on log.uf_log = uf.sigla_uf     
				  left join cep.cep_bai bai2
						 on log.chvbai2_log = bai2.chave_bai
						and log.chave_local = bai2.chave_local
                 <cfif session.site eq "delpozo/" or session.site eq "nsti/" or session.site eq "diariodoscampos/" or session.site eq "vocati/">
                 left join cep.municipio m
						 on loc.municipio_id = m.municipio_id 
                 <cfelse>
                 left join cep.municipio m
 				   on loc.municipio_id_kmm = m.municipio_id 
                 </cfif>  
				 where log.cep8_log = #arguments.cep#
										
				union          
											
				select m.municipio_id, decode(loc.sit_local,'0', loc.cep8_local, log.cep8_log)  as cep,             
					   decode(loc.sit_local,'0', 'No codificado - Preencha com seu logradouro',  log.nome_log )  as logradouro,             
					   decode(loc.tipo_local, 'D', 'DIST. ' || loc.nome_local,  decode(loc.tipo_local,'P', 'POV. ' || loc.nome_local , 
					   bai.extenso_bai)) as bairro,             
					   initcap(bai2.extenso_bai),             
					   m.municipio as local,             
					   uf.sigla_uf as uf, 
					   loc.cod_uf, 
					   loc.cod_municipio, 
					   loc.cod_distrito, 
					   loc.cod_dv
				  from cep.cep_loc loc
				 inner join cep.cep_ufs uf
						 on loc.sigla_uf = uf.sigla_uf       
				  left join cep.cep_loc loc2
						 on loc.subor_local =  loc2.chave_local
				  left join cep.cep_log log 
						 on loc.chave_local =  log.chave_local
				  left join cep.cep_bai bai 
						 on log.chvbai1_log  =  bai.chave_bai
						and log.chave_local = bai.chave_local
				  left join cep.cep_bai bai2
						 on log.chvbai2_log  =  bai2.chave_bai
						and log.chave_local = bai2.chave_local
                 <cfif session.site eq "delpozo/" or session.site eq "nsti/" or session.site eq "diariodoscampos/" or session.site eq "vocati/">
                 left join cep.municipio m
						 on loc.municipio_id = m.municipio_id 
                 <cfelse>
                 left join cep.municipio m
 				   on loc.municipio_id_kmm = m.municipio_id 
                 </cfif>  
				where loc.cep8_local = #arguments.cep#
											
				union    
				
				select m.municipio_id, esp.cep8_esp as cep,            
					   initcap(esp.nome_esp || esp.comple_esp) as logradouro,            
					   initcap(bai.extenso_bai) as bairro,            
					   initcap(bai.extenso_bai) as bairro,
                       m.municipio as local,
					   esp.uf_esp as uf, 
					   loc.cod_uf, 
					   loc.cod_municipio, 
					   loc.cod_distrito, 
					   loc.cod_dv
				  from cep.cep_loc loc
				 inner join cep.cep_esp esp
						 on esp.chave_local = loc.chave_local     
				 inner join cep.cep_bai bai
						 on esp.chave_bai = bai.chave_bai     
						and esp.chave_local = bai.chave_local
                 <cfif session.site eq "delpozo/" or session.site eq "nsti/" or session.site eq "diariodoscampos/" or session.site eq "vocati/">
                 left join cep.municipio m
						 on loc.municipio_id = m.municipio_id 
                 <cfelse>
                 left join cep.municipio m
 				   on loc.municipio_id_kmm = m.municipio_id 
                 </cfif> 
				 where esp.cep8_esp = #arguments.cep#
				
				union    
				
				select m.municipio_id, 
					   agp.cep8_agp as cep,            
					   initcap(agp.nome_agp) as logradouro,            
					   initcap(bai.extenso_bai) as bairro,
					   initcap(bai.extenso_bai) as bairro,
                       m.municipio as local,
					   agp.uf_agp as uf, 
					   loc.cod_uf, 
					   loc.cod_municipio, 
					   loc.cod_distrito, 
					   loc.cod_dv
				  from cep.cep_loc loc
				 inner join cep.cep_agp agp
						 on agp.chave_local = loc.chave_local     
				 inner join cep.cep_bai bai
						 on agp.chave_bai = bai.chave_bai     
						and agp.chave_local = bai.chave_local 
                 <cfif session.site eq "delpozo/" or session.site eq "nsti/" or session.site eq "diariodoscampos/" or session.site eq "vocati/">
                 left join cep.municipio m
						 on loc.municipio_id = m.municipio_id 
                 <cfelse>
                 left join cep.municipio m
 				   on loc.municipio_id_kmm = m.municipio_id 
                 </cfif>       
				 where agp.cep8_agp = #arguments.cep#
			
			
			</cfquery>
		<cfreturn qr_endereco>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Seleciona as Categorias de CNH 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 29/12/2005 - criado
	--->			
	<cffunction name="getCategoriaCNH" access="remote" returntype="Query" output="false">	  
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select cod_categoria_cnh,
				   categoria_cnh,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from kss.categoria_cnh
			</cfquery>
		<cfreturn qr>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Seleciona os Estados Civis
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 29/12/2005 - criado
	--->			
	<cffunction name="getEstadoCivil" access="remote" returntype="Query" output="false">	  
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select cod_estado_civil,
				   estado_civil,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from kss.estado_civil
		</cfquery>
		<cfreturn qr>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Seleciona lista de itens de atributos do tipo LISTA
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 02/02/2006 - criado
	--->			
	<cffunction name="get_itens_atributo" access="remote" returntype="Query" output="false">	  
		<cfargument name="atributo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select atributo_id, item_id, descricao 
			  from kss.v$pessoa_atributo_item
			 where atributo_id = #arguments.atributo_id#			  
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Busca CEP
	-- NOTAS EXPLICATIVAS
	--  
	-- 16/12/2005 - criado
	--->
	<cffunction name="getCep" displayname="Busca CEP com os parmetros passados" access="remote" output="false">
			<cfargument name="logradouro" required="true">
			<cfargument name="municipio" required="true">
			<cfargument name="tipo" required="true">
			<cfargument name="uf" required="true">
			<cfquery datasource="#session.dsn#" name="qr_cep" username="#session.usuario#" password="#session.senha#">
				select log.cep8_log as cep, 
					   initcap(tit.abrev_tipo || '.' || '  ' || log.nome_log) as logradouro,           
					   initcap(bai.extenso_bai) as bairro, 
					   initcap(loc.nome_local) as local,           
					   initcap(bai2.extenso_bai) as bairro2, 
					   uf.sigla_uf as uf    
				  from cep.cep_log log
				 inner join cep.cep_bai bai
						 on log.chvbai1_log = bai.chave_bai  
						and log.chave_local = bai.chave_local  
				 inner join cep.cep_loc loc 
						 on log.chave_local = loc.chave_local  
				 inner join cep.cep_ufs uf    
						 on loc.sigla_uf = uf.sigla_uf
				 inner join cep.cep_tit tit 
						 on log.chave_tipo = tit.chave_tipo  
				  left join cep.cep_bai bai2
						 on log.chvbai2_log  =  bai2.chave_bai
						and log.chave_local = bai2.chave_local
				  where kss.pkg_string.fnc_string_clean(trim(upper(log.nome_log))) like kss.pkg_string.fnc_string_clean(trim(upper('#arguments.logradouro#')))||'%'
					and kss.pkg_string.fnc_string_clean(trim(upper(loc.nome_local))) like kss.pkg_string.fnc_string_clean(trim(upper('#arguments.municipio#')))|| '%'  
					and kss.pkg_string.fnc_string_clean(trim(upper(tit.nome_tipo))) like kss.pkg_string.fnc_string_clean(trim(upper('#arguments.tipo#')))|| '%' 
					and kss.pkg_string.fnc_string_clean(trim(upper(loc.sigla_uf))) = kss.pkg_string.fnc_string_clean(trim(upper('#arguments.uf#')))
				
				 union
				 
				select esp.cep8_esp as cep, 
					   initcap(esp.nome_esp || esp.comple_esp) as logradouro,           
					   initcap(bai.extenso_bai) as bairro, 
					   initcap(loc.nome_local) as local,           
					   initcap(bai.extenso_bai) as bairro2, 
					   esp.uf_esp as uf  
				  from cep.cep_loc loc
				 inner join cep.cep_esp esp
						 on esp.chave_local = loc.chave_local  
				 inner join cep.cep_bai bai 
						 on esp.chave_bai = bai.chave_bai  
						and esp.chave_local = bai.chave_local 
				 where kss.pkg_string.fnc_string_clean(trim(upper(esp.nome_esp))) like kss.pkg_string.fnc_string_clean(trim(upper('#arguments.logradouro#'))) || '%'  
				   and kss.pkg_string.fnc_string_clean(trim(upper(loc.nome_local))) like kss.pkg_string.fnc_string_clean(trim(upper('#arguments.municipio#'))) || '%'  
				   and kss.pkg_string.fnc_string_clean(trim(upper(loc.sigla_uf))) = kss.pkg_string.fnc_string_clean(trim(upper('#arguments.uf#')))

/*
				SELECT log.cep8_log as cep, initcap(tit.abrev_tipo || '.' || '  ' || log.nome_log) as logradouro,           
					   initcap(bai.extenso_bai) as bairro, initcap(loc.nome_local) as local,           
					   initcap(bai2.extenso_bai) as bairro2, uf.sigla_uf as uf    
				  FROM cep.cep_log log, 
					   cep.cep_bai bai,cep.cep_bai bai2,  
					   cep.cep_loc loc, 
					   cep.cep_tit tit, 
					   cep.cep_ufs uf    
				 WHERE upper(log.nome_log) like '#Ucase(arguments.logradouro)#' || '%'  
				   and upper(loc.nome_local) like '#Ucase(arguments.municipio)#' || '%'  
				   and upper(tit.nome_tipo) like '#Ucase(arguments.tipo)#'  || '%' 
				   and log.chvbai1_log = bai.chave_bai  
				   and log.chave_local = bai.chave_local  
				   and log.chave_local = loc.chave_local  
				   and upper(loc.sigla_uf) = '#arguments.uf#'
				   and loc.sigla_uf = uf.sigla_uf  
				   and log.chave_tipo = tit.chave_tipo  
				   and log.chvbai2_log  =  bai2.chave_bai (+)   
				   and log.chave_local = bai2.chave_local (+)      
				
				union        
				
				SELECT esp.cep8_esp as cep, initcap(esp.nome_esp || esp.comple_esp) as logradouro,           
					   initcap(bai.extenso_bai) as bairro, initcap(loc.nome_local) as local,           
					   initcap(bai.extenso_bai) as bairro2, esp.uf_esp as uf  
				  FROM cep.cep_loc loc, 
					   cep.cep_bai bai, 
					   cep.cep_esp esp  
				 WHERE upper(esp.nome_esp) like '#Ucase(arguments.logradouro)#' || '%'  
				   and upper(loc.nome_local) like '#Ucase(arguments.municipio)#' || '%'  
				   and esp.chave_local = loc.chave_local  
				   and esp.chave_bai = bai.chave_bai  
				   and esp.chave_local = bai.chave_local 
				   and upper(loc.sigla_uf) = '#arguments.uf#'*/
			</cfquery>
			<cfif qr_cep.RecordCount EQ 0>
				<cfquery datasource="#session.dsn#" name="qr_cep" username="#session.usuario#" password="#session.senha#">
					select decode(loc.sit_local,'0', loc.cep8_local, log.cep8_log)  as cep,          
						   initcap(decode(loc.sit_local,'0', 'No codificado com logradouro',  log.nome_log ))  as logradouro,                      
						   initcap(decode(loc.tipo_local, 'D', 'Dist. ' || loc.nome_local,  
						   decode(loc.tipo_local,'P', 'Pov. ' || loc.nome_local , bai.extenso_bai))) as bairro,                      
						   initcap(decode(loc2.nome_local, null, loc.nome_local, loc2.nome_local)) as local,                      
						   initcap(bai2.extenso_bai) as bairro2, uf.sigla_uf as uf  
					  from cep.cep_loc loc
					 inner join cep.cep_ufs uf
							 on loc.sigla_uf = uf.sigla_uf       
					  left join cep.cep_loc loc2
							 on loc.subor_local =  loc2.chave_local
					  left join cep.cep_log log
							 on loc.chave_local = log.chave_local
					  left join cep.cep_bai bai
							 on log.chvbai1_log  =  bai.chave_bai
							and log.chave_local = bai.chave_local
					  left join cep.cep_bai bai2
							 on log.chvbai2_log  =  bai2.chave_bai
							and log.chave_local = bai2.chave_local
					  WHERE kss.pkg_string.fnc_string_clean(trim(upper(loc.nome_local))) like kss.pkg_string.fnc_string_clean(trim(upper('#arguments.municipio#'))) || '%'       
						and kss.pkg_string.fnc_string_clean(trim(upper(loc.sigla_uf))) like kss.pkg_string.fnc_string_clean(trim(upper('#arguments.uf#')))
						and kss.pkg_string.fnc_string_clean(trim(upper(loc.sit_local))) like kss.pkg_string.fnc_string_clean(trim(upper('#arguments.logradouro#'))) || '%'  
				
				
				
					/*SELECT decode(loc.sit_local,'0', loc.cep8_local, log.cep8_log)  as cep,          
						   initcap(decode(loc.sit_local,'0', 'No codificado com logradouro',  log.nome_log ))  as logradouro,                      
						   initcap(decode(loc.tipo_local, 'D', 'Dist. ' || loc.nome_local,  
						   decode(loc.tipo_local,'P', 'Pov. ' || loc.nome_local , bai.extenso_bai))) as bairro,                      
						   initcap(decode(loc2.nome_local, null, loc.nome_local, loc2.nome_local)) as local,                      
						   initcap(bai2.extenso_bai) as bairro2, uf.sigla_uf as uf  
					  FROM cep.cep_loc loc, 
						   cep.cep_ufs uf, 
						   cep.cep_loc loc2, 
						   cep.cep_log log, 
						   cep.cep_bai bai, 
						   cep.cep_bai bai2  
					 WHERE upper(loc.nome_local) like '#Ucase(arguments.municipio)#' || '%'       
					   and upper(loc.sigla_uf) like '#arguments.uf#'
					   and upper(loc.sit_local) like '#Ucase(arguments.logradouro)#' || '%'  
					   and loc.sigla_uf = uf.sigla_uf       
					   and loc.subor_local =  loc2.chave_local (+)       
					   and loc.chave_local =  log.chave_local (+)       
					   and log.chvbai1_log  =  bai.chave_bai (+)         
					   and log.chave_local = bai.chave_local (+)       
					   and log.chvbai2_log  =  bai2.chave_bai (+)         
					   and log.chave_local = bai2.chave_local (+)*/
				</cfquery>
			</cfif>
			<cfreturn qr_cep>
		</cffunction>
	
    <!--- 
    -- PROPSITO 
    -- Busca todas as filiais
    -- ANDERSON 14/08/2009 - EDITADO
    --->		
    <cffunction name="get_filiais" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="caixa_ativo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct o.cod_pessoa
                 , o.cod_unidade_negocio
                 , substr(p.cnpj_cpf, 1, 8) as cnpj_basico
                 , substr(p.cnpj_cpf, 9, 4) as cnpj_ordem
                 , p.cnpj_cpf as cnpj_completo
                 , (select pe.municipio
                      from kss.v$pessoa_endereco_padrao pe
                     where pe.cod_pessoa= o.cod_pessoa) as municipio
                 , (select pe.uf
                      from kss.v$pessoa_endereco_padrao pe
                     where pe.cod_pessoa= o.cod_pessoa) as uf
                 , p.cliente as nome_fantasia
                 , p.cliente as nome
              from kss.v$organograma o
             inner join kss.v$pessoa p
                     on p.cod_pessoa = o.cod_pessoa
             where 1 = 1
			<cfif Len(Trim(arguments.cod_pessoa_filial))>
               and o.cod_pessoa = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.caixa_ativo)) >
            	and exists ( select 'x'
                               from finan.v$caixa_gestao cg
                              where cg.cod_pessoa = p.COD_PESSOA
                                and cg.ativo = 1)
            </cfif>
             order by p.cliente
        </cfquery>
        <cfreturn qr_result>
    </cffunction>		  
	
	<!--- 
	-- PROPSITO
	-- Busca todos os setores
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 04/01/2006 - criado
	--->
	<cffunction name="get_setores" displayname="Busca todos os setores" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" 	required="no">
		<cfargument name="borracharia" 			required="no">
		<cfquery name="qr_agencias" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct  s.cod_setor, 
                   pj.nome_fantasia as descricao, 
                   pj.nome_fantasia as setor, 
                   s.cod_pessoa_filial as cod_pessoa, 
                   s.cod_pessoa_filial, pj.cnpj_basico, pj.cnpj_ordem, pj.nome_fantasia as filial
              from kss.v$setor_informacoes s
             inner join kss.v$pessoa_juridica pj
                     on s.cod_pessoa_filial = pj.cod_pessoa
			 where 1=1
			 <cfif isDefined("arguments.borracharia")>
				and s.possui_borracharia = 1
			 </cfif>
			 <cfif isDefined("arguments.cod_pessoa_filial")>
				and s.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 <cfelse>
			  order by s.cod_pessoa_filial 
			 </cfif>
		</cfquery>
		<cfreturn qr_agencias>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 01/02/2006 - criado
	--->		
	<cffunction name="get_pessoa_light" access="remote" returntype="Query" output="true">	  
			<cfargument name="cnpj_cpf" required="no" default="">
			<cfargument name="cod_cadastro_contribuinte" required="no" default="">		
			<cfargument name="cliente" required="no" default="">	
			<cfargument name="cod_pessoa" required="no" default="">	
			<cfargument name="tipo_pessoa" required="no" default="">
			<cfargument name="modalidade_id" required="no" default="">
			<cfargument name="num_modalidade" required="no" default="">
			<cfargument name="razao_social" required="no" default="">	
			<cfargument name="municipio" required="no" default="">
			<cfargument name="tipo" required="no" default="">
			<cfargument name="valor" required="no" default="">
			<cfargument name="rapida" required="no" default="0">
			<cfargument name="posto" required="no" default="0">			
			<cfargument name="oficina" required="no" default="0">
            <cfargument name="cod_atividade_fiscal" required="no" default="">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select distinct p.cod_pessoa,
					   p.tipo_pessoa,
					   p.cnpj_cpf,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.identificador) as identificador,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.cnpj_cpf) as cnpj_cpf,
					   p.inscricao_estadual,
					   p.razao_social,
					   p.cliente,
					   p.cod_atividade_fiscal,
                       po.numero,
                       po.logradouro,
					   p.tipo_pessoa as tipo_pessoa_id,
					   0 as cod_funcionario,
                       kss.pkg_pessoa.fnc_get_endereco(p.cod_pessoa,1) as endereco_completo,
					   nvl(po.municipio,pe.municipio) as municipio, po.uf, nvl(po.municipio_id, pe.municipio_id) as municipio_id,
                       nvl(po.municipio,pe.municipio) || ' - ' || po.uf as municipio_uf
					<cfif arguments.posto eq 1>
						,  (select preco
							  from oper.v$posto_historico_produto_prec php
							 where produto_id = 62
							   and cod_pessoa = p.cod_pessoa
							   and data_vigencia = (select max(data_vigencia)
													  from oper.v$posto_historico_produto_prec php2
													 where php2.cod_pessoa = php.cod_pessoa
													   and php2.produto_id = php.produto_id)) preco_diesel
					</cfif>
				  from kss.v$pessoa p
				  left join kss.v$pessoa_fisica pf
						 on pf.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_estrangeira pe
						 on pe.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_endereco po
				         on po.cod_pessoa = p.cod_pessoa
						  and po.endereco_padrao = 1
				<cfif len(trim(arguments.modalidade_Id))>
				 inner join kss.v$pessoa_modalidade pm
				         on pm.cod_pessoa = p.cod_pessoa
                        and pm.situacao = 1  
						and pm.num_modalidade in (#arguments.modalidade_id#)
				</cfif>
				<cfif len(trim(arguments.num_modalidade))>
				 inner join kss.v$pessoa_modalidade pm
				         on pm.cod_pessoa = p.cod_pessoa
                        and pm.situacao = 1  
						and pm.num_modalidade in (#arguments.num_modalidade#)
				</cfif>
				 where 1=1
				 <cfif len(trim(arguments.cliente))>
				   and upper(p.cliente) like upper('%#arguments.cliente#%')
				 </cfif>
				 <cfif len(trim(arguments.cnpj_cpf))>
				   and (p.cnpj_cpf like '#arguments.cnpj_cpf#%' or pe.cod_cadastro_contribuinte like '#arguments.cnpj_cpf#%')
				 </cfif> 
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 3 >
				   and (p.cnpj_cpf like '#arguments.valor#%' or pe.cod_cadastro_contribuinte like '#arguments.valor#%')
				 </cfif>
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 2 >
				   and upper(p.cliente) like upper('%#arguments.valor#%')
				 </cfif> 
				 <cfif len(trim(arguments.cod_cadastro_contribuinte))>
				   and pe.cod_cadastro_contribuinte = '#arguments.cod_cadastro_contribuinte#'
				 </cfif>
				 <cfif len(trim(arguments.cod_pessoa))>
				   and p.cod_pessoa = #arguments.cod_pessoa#
				 </cfif>
				 <cfif len(trim(arguments.tipo_pessoa))>
				   and p.tipo_pessoa = #arguments.tipo_pessoa#
				 </cfif>
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 1 >
				   and upper(p.razao_social) like upper('%#arguments.valor#%')
				 </cfif>
                 <cfif isDefined('arguments.tipo') and arguments.tipo eq 4 >
				   and upper(po.municipio) like upper('%#arguments.valor#%')
   					or upper(pe.municipio) like upper('%#arguments.valor#%')
				 </cfif>
                 <cfif len(trim(arguments.razao_social))>
				   and upper(p.razao_social) like upper('%#arguments.razao_social#%')
				 </cfif>
				 <cfif arguments.rapida eq 1>
				   and rownum = 1
				 </cfif>
                 <cfif Len(Trim(arguments.cod_atividade_fiscal))>
				   and p.cod_atividade_fiscal = #arguments.cod_atividade_fiscal#
				 </cfif>
				   order by <cfif arguments.oficina eq 1>p.cliente, </cfif>p.razao_social
			</cfquery>  
		<cfreturn qr />
	</cffunction>
    
   			

	<cffunction name="get_pessoa_juridica" displayname="Busca os dados gerais da PESSOA" access="remote" returntype="query" output="true">
		<cfargument name="cnpj" type="string" displayname="CNPJ completo" required="false" >
		<cfargument name="nome" type="string" displayname="Nome" required="false" >
        <cfargument name="razao_social" type="string" displayname="Razao_social" required="false" >
		<cfargument name="modalidade" type="string" required="false" default="9,12" hint="Se igual a -1 busca todas">
        <cfargument name="vale_autorizado" required="no" default=""> <!--- Para a Delpozo  produto 7. --->
		<cfquery name="qr_pessoa_juridica" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	<cfif Len(Trim(arguments.vale_autorizado)) >
            select * from (
            </cfif>
                select distinct p.identificador,
                       pj.cod_pessoa,
                       pj.cnpj_basico || pj.cnpj_ordem || pj.cnpj_dv as cnpj,
                       pj.nome_fantasia,
                       pe.municipio,
                       pj.razao_social,
                       pe.uf
                       <cfif Len(Trim(arguments.vale_autorizado)) >
                       ,(select x.autorizado
                           from (select php.autorizado,php.cod_pessoa
                                   from oper.v$posto_historico_produto php
                                  where php.produto_id = 7
                                  order by php.data_vigencia desc
                                ) x                            
                          where x.cod_pessoa = pj.cod_pessoa
                            and rownum = 1                          
                        ) autorizado
                       
                       </cfif>
                  from kss.v$pessoa_juridica pj
                 inner join kss.v$pessoa p 
                         on p.cod_pessoa = pj.cod_pessoa
                 inner join kss.v$pessoa_modalidade pm 
                         on pj.cod_pessoa = pm.cod_pessoa
				<cfif arguments.modalidade neq -1>
					and pm.num_modalidade in (#arguments.modalidade#)
				</cfif>
                        and pm.situacao = 1
                 inner join kss.v$pessoa_endereco pe
                         on pe.cod_pessoa = pj.cod_pessoa
                        and pe.endereco_padrao = 1
                 where 1=1
			<cfif isDefined('Arguments.cnpj')>
			       and cnpj_basico || cnpj_ordem || cnpj_dv like '#Arguments.cnpj#%'
       			   and rownum = 1
			</cfif>           
			<cfif isDefined('Arguments.nome')>
			       and upper(nome_fantasia) like upper('%#Arguments.nome#%')
			</cfif>
            <cfif isDefined('Arguments.razao_social')>
			       and upper(razao_social) like upper('%#Arguments.razao_social#%')
			</cfif>
			<cfif arguments.modalidade eq '12'>
                   and exists (select 'x'
                                 from oper.v$posto_produto_autorizado pp
                                where pp.cod_pessoa = pj.cod_pessoa  
                                  and pp.produto_id = 7)
			</cfif>
        <cfif Len(Trim(arguments.vale_autorizado)) >
            ) y where y.autorizado = #arguments.vale_autorizado#
        </cfif>
		</cfquery>
		<cfreturn qr_pessoa_juridica>
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Lista os clientes e filiais da empresa
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 10/04/2006 - criado
	--->	
	<cffunction name="get_cliente_filial" displayname="Lista os clientes e filiais da empresa" access="remote" returntype="query" output="true">
		<cfargument name="nome" required="no" default="">
		<cfargument name="razao_social" required="no" default="">
		<cfargument name="filial" required="no" default="">
		<cfargument name="municipio" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="cnpj_cpf" required="no" default="">
		<cfargument name="rapida" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select t.*
              from (select /*+ FIRST_ROWS */ p.cod_pessoa, p.tipo_pessoa, p.razao_social, p.cliente as nome, p.identificador,
                           decode(p.tipo_pessoa,2/*Estrangeira*/, pes.cod_cadastro_contribuinte, p.cnpj_cpf) as cnpj_cpf,
                           p.inscricao_estadual,
                           decode(p.tipo_pessoa,2/*Estrangeira*/, pes.endereco, pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento) as endereco,
                           pe.bairro,
                           decode(p.tipo_pessoa,2/*Estrangeira*/, pes.codigo_postal, to_char(pe.cep)) as cep,
                           decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio, pe.municipio) as municipio,
                           decode(p.tipo_pessoa,2/*Estrangeira*/, 'EX', pe.uf) as uf,
                           decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio, pe.municipio) || decode(nvl(pe.uf,'EX'), 'EX', (select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = p.cod_pessoa), ' - ' || pe.uf) municipio_uf,
                           decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio_id, pe.municipio_id) as municipio_id,
                           decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) telefone,
                           m.pais_id,
                           decode(p.tipo_pessoa,2/*Estrangeira*/, pes.pais,ps.descricao) as pais, 0 as filial
                      from kss.v$pessoa p
                     inner join kss.v$pessoa_modalidade pm
                             on p.cod_pessoa = pm.cod_pessoa
                            and num_modalidade in (5, 13, 15)
                            and pm.situacao = 1
                      left join kss.v$pessoa_endereco pe
                             on pe.cod_pessoa = p.cod_pessoa
                            and pe.endereco_padrao = 1
                      left join kss.v$pessoa_estrangeira pes
                             on pes.cod_pessoa = p.cod_pessoa
                      left join kss.v$pessoa_telefone pt
                             on pt.cod_pessoa = p.cod_pessoa
                            and pt.telefone_padrao = 1
                      left join kss.v$telefone t
                             on t.telefone_id = pt.telefone_id
                      left join cep.municipio m
                             on m.municipio_id = pe.municipio_id
                      left join cep.pais ps
                             on ps.pais_id = m.pais_id
                     union all
                    select /*+ FIRST_ROWS */ p.cod_pessoa, p.tipo_pessoa, p.razao_social, p.cliente as nome, p.identificador,
                           p.cnpj_cpf,
                           p.inscricao_estadual,
                           pe.logradouro || decode(pe.numero, '', '', ', ')  || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento as endereco,
                           pe.bairro,
                           to_char(pe.cep) as cep,
                           pe.municipio, pe.uf,
                           pe.municipio || decode(pe.uf, 'EX', (select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = p.cod_pessoa), ' - ' || pe.uf) municipio_uf,
                           pe.municipio_id,
                           decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) telefone,
                           m.pais_id, ps.descricao as pais, 1 as filial
                      from kss.v$pessoa p
                     inner join kss.v$unidade_negocio un
                             on p.cod_pessoa = un.cod_pessoa
                      left join kss.v$pessoa_endereco pe
                             on pe.cod_pessoa = p.cod_pessoa
                            and pe.endereco_padrao = 1
                      left join kss.v$pessoa_telefone pt
                             on pt.cod_pessoa = p.cod_pessoa
                            and pt.telefone_padrao = 1
                      left join kss.v$telefone t
                             on t.telefone_id = pt.telefone_id
                      left join cep.municipio m
                             on m.municipio_id = pe.municipio_id
                      left join cep.pais ps
                             on ps.pais_id = m.pais_id) t
			 where 1=1
			 <cfif len(trim(arguments.nome))>
			   and upper(t.nome) like upper('%#arguments.nome#%')
			 </cfif>
			 <cfif len(trim(arguments.razao_social))>
			   and upper(t.razao_social) like upper('%#arguments.razao_social#%')
			 </cfif>
			 <cfif len(trim(arguments.municipio))>
			   and upper(t.municipio) like upper('%#arguments.municipio#%')
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa))>
			   and t.cod_pessoa = #arguments.cod_pessoa# 
			 </cfif>
			 <cfif len(trim(arguments.cnpj_cpf))>
			   and t.cnpj_cpf = '#arguments.cnpj_cpf#'
			 </cfif>
			 <cfif arguments.rapida eq 1>
			   and rownum = 1
			 </cfif>
		      order by t.razao_social, t.municipio_uf			 
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna as cidades cadastradas no sistema
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 10/14/2006 - criado
	--->	
	<cffunction name="get_cidade" displayname="Retorna as cidades cadastradas no sistema" access="remote" returntype="query" output="true">
		<cfargument name="municipio_id" required="no" />
		<cfargument name="municipio" required="no" />
		<cfargument name="pais_id" required="no" />
		<cfargument name="uf_id" required="no" />
		<cfif session.site eq "rodomar/" or session.site eq "delpozo/">
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				select distinct municipio_id, m.municipio, m.latitude, m.longitude, p.pais_id, m.uf_id,
					   m.altitude, m.cep, m.cod_inpe, m.intc_cod_municipio, p.descricao as pais, 
					   cep.fnc_cidade_completa(municipio_id) as descricao
					   <cfif session.site neq "granex/">
					   ,ccl.cod_uf, ccl.cod_municipio, ccl.cod_dv, ccl.cod_distrito
					   </cfif>
				  from cep.municipio m
				 <cfif session.site neq "granex/">
				 left join cep.ibge_municipio ccl
             			 on ccl.municipio_id_kmm = m.municipio_id
				 </cfif>
				 inner join cep.pais p
						 on p.pais_id = m.pais_id
				 where 1=1
				<cfif IsDefined("arguments.municipio") and Len(Trim(arguments.municipio))>
				   and upper(kss.pkg_string.fnc_string_clean(m.municipio)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.municipio#%'))
				</cfif>
				<cfif IsDefined("arguments.pais_id") and Len(Trim(arguments.pais_id))>
				   and p.pais_id = #arguments.pais_id#
				</cfif>
				<cfif IsDefined("arguments.uf_id") and Len(Trim(arguments.uf_id))>
				   and uf_id = '#arguments.uf_id#'
				</cfif>
				<cfif IsDefined("arguments.municipio_id") and Len(Trim(arguments.municipio_id))>
				   and municipio_id = #arguments.municipio_id#
				</cfif>			
				order by municipio
			</cfquery>
		<cfelse>
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				select distinct municipio_id, municipio, latitude, longitude, p.pais_id, uf_id,
					   altitude, cep, cod_inpe, intc_cod_municipio, p.descricao as pais, 
					   cep.fnc_cidade_completa(municipio_id) as descricao
				  from cep.municipio m 		
				 inner join cep.pais p
						 on p.pais_id = m.pais_id
				 where 1=1
				<cfif IsDefined("arguments.municipio") and Len(Trim(arguments.municipio))>
				   and upper(kss.pkg_string.fnc_string_clean(m.municipio)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.municipio#%'))
				</cfif>
				<cfif IsDefined("arguments.pais_id") and Len(Trim(arguments.pais_id))>
				   and p.pais_id = #arguments.pais_id#
				</cfif>
				<cfif IsDefined("arguments.uf_id") and Len(Trim(arguments.uf_id))>
				   and uf_id = '#arguments.uf_id#'
				</cfif>
				<cfif IsDefined("arguments.municipio_id") and Len(Trim(arguments.municipio_id))>
				   and municipio_id = #arguments.municipio_id#
				</cfif>			
				order by municipio
			</cfquery>
		</cfif>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os remetentes e destinatarios cadastrados
	-- CRISTOFER  12/06/2006
	--->		
	<cffunction name="get_remetente_destinatario" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" 	required="no" default="">
		<cfargument name="codigo" 		required="no" default="">
		<cfargument name="nome" 		required="no" default="">
		<cfargument name="razao_social" required="no" default="">
		<cfargument name="tipo" 		required="no" default="" displayname="Tipo para  consulta, 1 - CNPJ e Estrangeiro, 2 - CPF e Estrangeiro, 3 - Sem Estrangeiro, 4 - Somente CPF" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa, codigo, bairro, endereco, cep, complemento, codigo as cnpj, codigo as identificador,
				   nome_fantasia, razao_social, municipio, uf, cod_atividade_fiscal, inscricao_estadual,
				   nvl(oper.pkg_global.fnc_endereco_ibge(cep).cod_uf,im.cod_uf) as cod_uf,
				   nvl(oper.pkg_global.fnc_endereco_ibge(cep).cod_municipio,im.cod_municipio) as cod_municipio,
				   nvl(oper.pkg_global.fnc_endereco_ibge(cep).cod_distrito,im.cod_distrito) as cod_distrito,
				   nvl(oper.pkg_global.fnc_endereco_ibge(cep).cod_dv,im.cod_dv) as cod_dv,
	            case rd.situacao_id
				     when 0 then 'Inativo'
				     when 1 then 'Ativo'
				     when 2 then 'Em avaliao'
               end situacao, rd.municipio_id
 		      from oper.v$remetente_destinatario rd
            left join cep.ibge_municipio im
                 on im.municipio_id_kmm = rd.municipio_id
		      where 0=0 
			 <cfif len(trim(arguments.cod_pessoa))>
				 and rd.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif len(trim(arguments.codigo)) and len(arguments.codigo) eq 14>
				 and rd.codigo like '#arguments.codigo#%'
			 <cfelseif len(trim(arguments.codigo)) and len(arguments.codigo) eq 11>
				 and rd.codigo like '#arguments.codigo#%'
			 <cfelseif len(trim(arguments.codigo))>
				 and rd.cod_pessoa = #arguments.codigo#
			 </cfif>
			 <cfif len(trim(arguments.nome))>
				 and upper(rd.nome_fantasia) like upper('%#arguments.nome#%')
			 </cfif>
			 <cfif len(trim(arguments.razao_social))>
				 and upper(rd.razao_social) like upper('%#arguments.razao_social#%')
			 </cfif>			
			<cfif len(trim(arguments.tipo)) and arguments.tipo eq 1>
				 and rd.cpf is null
			</cfif>
			<cfif len(trim(arguments.tipo)) and arguments.tipo eq 2>
				 and rd.cnpj_basico is null
			</cfif>
			<cfif len(trim(arguments.tipo)) and arguments.tipo eq 3>
				 and rd.cpf is not null
				 or rd.cnpj_basico is not null
			</cfif>
			<cfif len(trim(arguments.tipo)) and arguments.tipo eq 4>
				 and rd.cpf is not null
				 and rd.cnpj_basico is null
				 and rd.cod_estrangeiro is null
			</cfif>
			 order by nome_fantasia			
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Motoristas
	-- Wagner  16/06/2006
	--->
	
	<cffunction name="get_pessoa_fisica" displayname="Busca as pessoa fsicas" access="remote" returntype="query" output="true">
		<cfargument name="nome" displayname="Nome da pessoa a ser consultada, ou parte dele." required="false" >
		<cfargument name="cpf" displayname="CPF completo" required="false" >
		<cfargument name="modalidade_id" required="no" >
		<cfquery name="qr_pessoa_fisica" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct cod_pessoa, cpf, cpf_dv, nome, cnh_num_registro, cnh_validade
			  from oper.pessoa_fisica
			 where 1=1
			 <cfif isDefined("arguments.nome")>
				 and lower(nome) like lower('%#arguments.nome#%')
			 </cfif>
			 <cfif isDefined("arguments.cpf")>
				 and cpf = '#Left(arguments.cpf,9)#'
				 and cpf_dv = '#Right(arguments.cpf,2)#'
			 </cfif>
			 <cfif isDefined("arguments.modalidade_id")>
				 and modalidade_id = #arguments.modalidade_id# 
			 </cfif>
		</cfquery>
		<cfreturn qr_pessoa_fisica>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Motoristas
	-- Wagner  16/06/2006
	--->
	
	<cffunction name="get_gerenciadora" displayname="Busca todas as Gerenciadoras" access="remote" returntype="query" output="true">
		<cfargument name="nome" displayname="Nome da pessoa a ser consultada, ou parte dele." required="false" >
		<cfargument name="cpf" displayname="CPF completo" required="false" >
		<cfargument name="modalidade_id" required="no" >
		<cfquery name="qr_pessoa_fisica" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct cod_pessoa, cpf, cpf_dv, nome, cnh_num_registro, cnh_validade
			  from oper.pessoa_fisica
			 where 1=1
			 <cfif isDefined("arguments.nome")>
				 and lower(nome) like lower('%#arguments.nome#%')
			 </cfif>
			 <cfif isDefined("arguments.cpf")>
				 and cpf = '#Left(arguments.cpf,9)#'
				 and cpf_dv = '#Right(arguments.cpf,2)#'
			 </cfif>
			 <cfif isDefined("arguments.modalidade_id")>
				 and modalidade_id = #arguments.modalidade_id# 
			 </cfif>
		</cfquery>
		<cfreturn qr_pessoa_fisica>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Situaes do Cadastro
	-- Wagner  03/07/2006
	--->
	
	<cffunction name="get_pj_situacao" displayname="Busca Situacao PJ" access="remote" returntype="query" output="true">
		<cfquery name="qr_situacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select s.num_situacao, s.descricao
			  from oper.situacao s
   	   	</cfquery>
		<cfreturn qr_situacao>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Atividades Fiscais
	-- Wagner  03/07/2006
	--->
	
	<cffunction name="get_atividade_fiscal" displayname="Consulta atividades Fiscais" output="true" returntype="query" access="remote">
		<cfquery name="qr_atividade_fiscal" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_atividade_fiscal, descricao 
			  from kss.v$atividade_fiscal		
		</cfquery>
		<cfreturn qr_atividade_fiscal>	
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Tipo de Endereo
	-- Wagner  03/07/2006
	--->
		
	<cffunction name="get_endereco_tipo" displayname="Busca Tipos de endereco" access="remote" returntype="query" output="true">
		<cfquery name="qr_endereco_tipo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_endereco_tipo, descricao
			  from kss.endereco_tipo	
   	   	</cfquery>
		<cfreturn qr_endereco_tipo>	
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Tipo de Endereo
	-- Wagner  03/07/2006
	--->
		
	<cffunction name="get_cnae" displayname="Busca CNAE de pessoa jurdica" access="remote" returntype="query" output="true">
		<cfargument name="cnae" required="yes">
		<cfquery name="qr_endereco_tipo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cnae, descricao_cla
			  from cnae.v$cnae
			 where cnae like '#arguments.cnae#%'	
   	   	</cfquery>
		<cfreturn qr_endereco_tipo>	
	</cffunction>	
	
    <!--- 
	-- PROPSITO
	-- Busca todos os setores de origem na transferencia de materiais
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS 30/08/2006 - criado
	--->
	<cffunction name="get_setores_origem" displayname="Busca todos os setores de origem na transferencia de materiais" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="yes">
		<cfquery name="qr_agencias" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct (select t.nome
                    		   from oper.v$filial t
                  		  	  where t.cod_pessoa =  mo.cod_pessoa_filial) as filial_origem,
                  			(select t.nome
                    		   from oper.v$filial t
                  			  where t.cod_pessoa =  tr.cod_pessoa_filial_destino) as filial_destino,
                            mo.cod_pessoa_filial as origem,
                            tr.cod_pessoa_filial_destino as destino
              from almoxarifado.v$movimentacao_dados mo 
        inner join almoxarifado.v$transferencia tr 
                on tr.lancamento_id_saida = mo.lancamento_id
         where 1=1
         <cfif len(trim(arguments.cod_pessoa_filial))>
           and mo.cod_pessoa_filial = #arguments.cod_pessoa_filial#
         </cfif>
         and tr.data_entrada is null
		</cfquery>
		<cfreturn qr_agencias>		
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca dados bancrios da pessoa
	-- NOTAS EXPLICATIVAS
	--  
	-- WAGNER LUIS VITCOSKI  22 de janeiro de 2008 - criado
	--->
	<cffunction name="get_dados_bancarios" displayname="Busca os dados bancarios" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 
               c.banco_id,
               a.agencia_id,
               c.conta as CONTA_NUMERO,
               c.conta_dv,
               a.agencia_id_dv as conta_ag_dv,
               c.conta_padrao,
               kss.pkg_pessoa.fnc_get_identificador(c.cod_pessoa) titular_cpf_cnpj,
               kss.pkg_pessoa.fnc_get_cliente(c.cod_pessoa) titular_nome,
               a.uf banco_uf,a.municipio as AGENCIA_CIDADE      
      from kss.v$pessoa_conta_bancaria c
      inner join kss.banco_agencia a on a.agencia_id = c.agencia_id  and a.banco_id = c.banco_id
         where 1=1
         <cfif len(trim(arguments.cod_pessoa))>
           and c.cod_pessoa = #arguments.cod_pessoa#
         </cfif>         
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
    
    
     <!--- 
	-- PROPSITO
	-- Busca todos os graus de parentesco
	-- NOTAS EXPLICATIVAS
	--  
	-- WAGNER LUIS VITCOSKI  24 de janeiro de 2008 - criado
	--->
	<cffunction name="get_grau_parentesco" displayname="" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select cod_grau_parentesco,
               parentesco
          from kss.grau_parentesco			   
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
     <!--- 
	-- PROPSITO
	-- Busca todos os graus de parentesco
	-- NOTAS EXPLICATIVAS
	--  
	-- WAGNER LUIS VITCOSKI  24 de janeiro de 2008 - criado
	--->
	<cffunction name="get_dependentes" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
               select cod_pessoa,
               cod_dependente,
               nome,
               to_char(data_nascimento, 'dd/mm/yyyy') as data_nascimento,
               cod_sexo as sexo,
               cod_grau_parentesco,
               decode(calcula_salario_familia,1,'true') as calcula_salario_familia,
               decode(desconta_irrf,1,'true')as  desconta_irrf,
               decode(pensao_alimenticia,1,'true') as pensao_alimenticia,
               local_nascimento,
               uf_nascimento,
               cartorio,
               num_livro,
               num_folha,
               num_registro,
               to_char(data_entrega_certidao,'dd/mm/yyyy') as data_entrega_certidao              
          from kss.v$dependente where cod_pessoa = #arguments.cod_pessoa#		   
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Seleciona categorias para imagens
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 06/03/2007 - criado
	--->
	<cffunction name="get_categoria_imagem" access="remote" returntype="Query" output="false">	  
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
      select p.categoria_id, p.descricao
        from kss.v$pessoa_imagem_categoria p
			</cfquery>  
		<cfreturn qr />
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Seleciona categorias para imagens
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 06/03/2007 - criado
	--->
	<cffunction name="getPessoaFoto" access="remote" returntype="Query" output="false">	  
			<cfargument name="cod_pessoa" required="yes">
            <cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
      		select * from kss.v$pessoa_imagem where 1=1
            and cod_pessoa = #arguments.cod_pessoa#
			</cfquery>  
		<cfreturn qr />
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os responsves
	-- Rafael  16/06/2006
	--->
	<cffunction name="get_responsavel" displayname="Busca os responsves" access="remote" returntype="query" output="true">
		<cfargument name="cpf" displayname="CPF completo" required="no" default="">
		<cfargument name="numero_matricula" displayname="CPF completo" required="no" default="">
		<cfquery name="qr_pessoa_fisica" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct pf.cod_pessoa,
                   pf.cpf,
                   pf.cpf_dv,
                   pf.nome,
                  fm.num_matricula as matricula    
             from oper.pessoa_fisica pf
             left join kss.v$funcionario_matr_atual fm
                    on fm.cod_pessoa = pf.cod_pessoa
			 where 1=1
			<cfif Len(Trim(arguments.cpf))>
		      and cpf = '#Left(arguments.cpf,9)#'
		      and cpf_dv = '#Right(arguments.cpf,2)#'
			</cfif>
			<cfif Len(Trim(arguments.numero_matricula))>
              and fm.num_matricula = #arguments.numero_matricula#
            </cfif>
		</cfquery>
		<cfreturn qr_pessoa_fisica>
	</cffunction> 
    
    <!--- 
	-- PROPSITO 
	-- Busca os motoristas
	-- Rafael  16/06/2006
	--->
	<cffunction name="get_motorista" displayname="Busca os motoristas" access="remote" returntype="query" output="true">
   	    <cfargument name="nome" displayname="Nome do Motorista" required="no" default="">
		<cfargument name="cod_motorista" displayname="Codigo Pessoa do Motorista" required="no" default="">
        <cfargument name="codigo_motorista" displayname="Codigo de Registro do Motorista" required="no" default="">
		<cfquery name="qr_pessoa_fisica" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.cod_pessoa,t.nome,t.cod_registro
              from (select pf.cod_pessoa,
                           pf.nome,
                     (select mrh.cod_registro
                              from oper.v$motorista_reg_historico mrh
                             where mrh.cod_pessoa = pf.cod_pessoa
                               and mrh.data_inicio =
                                   (select max(mrh2.data_inicio)
                                      from oper.v$motorista_reg_historico mrh2
                    where mrh2.cod_pessoa = mrh.cod_pessoa)) as cod_registro
                    from oper.v$pessoa_fisica pf
                        where exists 
                        (select mrh.cod_registro
                        from oper.v$motorista_reg_historico mrh
                        where mrh.cod_pessoa = pf.cod_pessoa
                          and mrh.data_inicio = 
							  (select max(mrh2.data_inicio)
                        from oper.v$motorista_reg_historico mrh2
                        where mrh2.cod_pessoa = mrh.cod_pessoa))) t
                        where 1 = 1
                        <cfif Len(Trim(arguments.nome))>
                        	and upper(t.nome) like upper('#arguments.nome#%')
                        </cfif>
								<cfif Len(Trim(arguments.cod_motorista))>
                        	and t.cod_pessoa = #arguments.cod_motorista#
                        </cfif>
                        <cfif Len(Trim(arguments.codigo_motorista))>
                        	and t.cod_registro = #arguments.codigo_motorista#
                        </cfif>
        </cfquery>
        <cfreturn qr_pessoa_fisica>
    </cffunction>     
    
	<!--- 
	-- PROPSITO 
	-- Busca os remetentes e destinatarios cadastrados
	-- CRISTOFER  12/06/2006
	--->		
	<cffunction name="qrCobertura" access="remote" returntype="query" output="true">
		<cfargument name="cod_gerenciadora" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_gerenciadora,
            	   cod_cobertura,
                   valor_cobertura,
                   descricao,
                   observacao,
                   rowid
              from grisco.v$gerenciadora_cobertura          
             where cod_gerenciadora = #arguments.cod_gerenciadora# 
            order by descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados da pessoa e da Modalidade
	-- CRISTOFER  12/06/2006
	--->		
	<cffunction name="get_pessoa_modalidade_light" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="cnpj_cpf" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.cod_pessoa
                 , t.cnpj_cpf
                 , t.razao_social
                 , t.cliente
                 , t.identificador
                 , case
                      when t.modalidade in(2,3,8,10,11,15) then
                         '0'
                      when t.modalidade in(5,7,12,13,14,16,17,18,19,20,21) then
                         '1'
                      when t.modalidade in(4,6,9) then
                         '2'
                     end as modalidade
                     
                     from(select p.cod_pessoa
                               , p.cnpj_cpf
                               , p.razao_social
                               , p.identificador
                               , p.cliente
                               , (select max(pm.num_modalidade)
                                    from kss.v$pessoa_modalidade pm
                                   where pm.cod_pessoa = p.cod_pessoa ) as modalidade
                            from kss.v$pessoa p
                           where 1=1
                           <cfif Len(Trim(arguments.cod_pessoa))>
                             and p.cod_pessoa = #arguments.cod_pessoa#
                           </cfif>
                           <cfif Len(Trim(arguments.cnpj_cpf))>
                             and p.cnpj_cpf like '#arguments.cnpj_cpf#'
                           </cfif>) t
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca oa referencia de uma Pessoa
	-- CRISTOFER  12/06/2006
	--->		
	<cffunction name="get_pessoa_referencia" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select r.referencia_id
                     , r.referencia
                  from kss.v$pessoa_ref_geografica prg
            inner join oper.v$referencia r
                    on r.referencia_id = prg.referencia_id
                  where prg.cod_pessoa = #arguments.cod_pessoa#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna Cargo do Cliente
    -- LEOPOLDOS 18/08/2010 - CRIADO
    --->		
    <cffunction name="get_cargo_cliente" access="remote" returntype="query" output="true">
    	<cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select *
              from kss.v$cliente_cargo cc
			<cfif Len(Trim(#arguments.DESCRICAO#))>
             where upper(cc.descricao) like upper('%#arguments.DESCRICAO#%')
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna Setor do Cliente
    -- LEOPOLDOS 18/08/2010 - CRIADO
    --->		
    <cffunction name="get_setor_cliente" access="remote" returntype="query" output="true">
    	<cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select *
              from kss.v$cliente_setor cs
			<cfif Len(Trim(#arguments.DESCRICAO#))>
             where upper(cs.descricao) like upper('%#arguments.DESCRICAO#%')
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna listagens de clientes na modalidade Cliente/Fornecedor
    -- LEOPOLDOS 24/08/2010 - CRIADO
    --->		
    <cffunction name="get_lista_cliente_fornecedor" access="remote" returntype="query" output="true">
    	<cfargument name="setor_id" required="no" default="">
    	<cfargument name="cargo_id" required="no" default="">
    	<cfargument name="cod_pessoa_cliente" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.cod_pessoa
                 , p.cliente
                 , p.razao_social
                 , p.cnpj_cpf
                 , p.identificador
                 , pep.logradouro
                 , pep.municipio
                 , pep.uf
                 <cfif Len(Trim(arguments.setor_id)) or Len(Trim(arguments.cargo_id))>
                 , (select e2.email_completo
                 	  from kss.v$pessoa_email p2
                     inner join kss.v$email e2
                     		 on e2.email_id = p2.email_id
                     where rownum = 1
                       and p2.cod_pessoa = p.cod_pessoa
					   <cfif Len(Trim(arguments.setor_id))>
                       and p2.setor_id = #arguments.setor_id#
                       </cfif>
                       <cfif Len(Trim(arguments.cargo_id))>
                       and p2.cargo_id = #arguments.cargo_id#
                       </cfif>
                       ) as email
                 <cfelse>
                 , (select e2.email_completo
                 	  from kss.v$pessoa_email p2
                     inner join kss.v$email e2
                     		 on e2.email_id = p2.email_id
                     where rownum = 1
                       and p2.cod_pessoa = p.cod_pessoa
                       and p2.email_padrao = 1) as email
                 </cfif>
				 <cfif Len(Trim(arguments.setor_id)) or Len(Trim(arguments.cargo_id))>
                 , (select ('+' || t2.fone_cod_pais || ' (' || t2.fone_ddd || ') ' || t2.fone_prefixo || ' ' || t2.fone_numero) as telefone
                      from kss.v$pessoa_telefone p2
                     inner join kss.v$telefone t2
                             on p2.telefone_id = t2.telefone_id
                     where rownum = 1
                       and p2.cod_pessoa = p.cod_pessoa
					   <cfif Len(Trim(arguments.setor_id))>
                       and p2.setor_id = #arguments.setor_id#
                       </cfif>
                       <cfif Len(Trim(arguments.cargo_id))>
                       and p2.cargo_id = #arguments.cargo_id#
                       </cfif>
                       ) as telefone
                 <cfelse>
                 , (select ('+' || t2.fone_cod_pais || ' (' || t2.fone_ddd || ') ' || t2.fone_prefixo || ' ' || t2.fone_numero) as telefone
                      from kss.v$pessoa_telefone p2
                     inner join kss.v$telefone t2
                             on p2.telefone_id = t2.telefone_id
                     where rownum = 1
                       and p2.cod_pessoa = p.cod_pessoa
                       and p2.telefone_padrao = 1) as telefone
                 </cfif>
              from kss.v$pessoa p
             inner join kss.v$pessoa_modalidade pm
                     on pm.cod_pessoa = p.cod_pessoa
             inner join kss.v$pessoa_endereco_padrao pep
                     on pep.cod_pessoa = p.cod_pessoa
             <cfif Len(Trim(arguments.cod_pessoa_cliente))>
             inner join ( select distinct p.cod_pessoa
                               , p.cliente
                           from fiscal.v$conhecimento c
                          inner join kss.v$pessoa p
                                  on p.cod_pessoa = c.cod_destinatario
                          where c.cod_remetente = #arguments.cod_pessoa_cliente#

                          union all
                         
                         select distinct p.cod_pessoa
                              , p.cliente
                           from fiscal.v$intc_conhecimento c
                          inner join kss.v$pessoa p
                                  on p.cod_pessoa = c.cod_destinatario
                          where c.cod_remetente = #arguments.cod_pessoa_cliente#) pp
                     on pp.cod_pessoa = p.cod_pessoa
             </cfif>
             where pm.num_modalidade = 5   
               and (exists (select 'x'
                             from kss.v$pessoa_email pe
                            where pe.cod_pessoa = p.cod_pessoa
                            <cfif Len(Trim(arguments.setor_id))>
                              and pe.setor_id = #arguments.setor_id#
                            </cfif>
                            <cfif Len(Trim(arguments.cargo_id))>
                              and pe.cargo_id = #arguments.cargo_id#
                            </cfif>
                            )
                or  exists (select 'x'
                             from kss.v$pessoa_telefone pt
                            where pt.cod_pessoa = p.cod_pessoa
                            <cfif Len(Trim(arguments.setor_id))>
                              and pt.setor_id = #arguments.setor_id#
                            </cfif>
                            <cfif Len(Trim(arguments.cargo_id))>
                              and pt.cargo_id = #arguments.cargo_id#
                            </cfif>
                            )
                    )
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna E-mails da pessoa
    -- LEOPOLDOS 24/08/2010 - CRIADO
    --->		
    <cffunction name="get_emails_pessoa" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pe.email_id
	             , pe.cod_pessoa
                 , pe.email_padrao
                 , pe.email_proprietario as contato
                 , (select cs.descricao
                      from kss.v$cliente_setor cs 
                     where cs.setor_id = pe.setor_id) as setor
                 , (select cc.descricao
                      from kss.v$cliente_cargo cc
                     where cc.cargo_id = pe.cargo_id) as cargo
                 , e.email_completo as email
              from kss.v$pessoa_email pe
             inner join kss.v$email e
                     on e.email_id = pe.email_id
             where pe.cod_pessoa = #arguments.cod_pessoa# 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna telefones da pessoa
    -- LEOPOLDOS 10/09/2010 - CRIADO
    --->		
    <cffunction name="get_telefones_pessoa" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pt.telefone_id
               	 , pt.cod_pessoa
                 , pt.telefone_padrao
                 , pt.telefone_contato
                 , (select cs.descricao
                      from kss.v$cliente_setor cs 
                     where cs.setor_id = pt.setor_id) as setor
                 , (select cc.descricao
                      from kss.v$cliente_cargo cc
                     where cc.cargo_id = pt.cargo_id) as cargo
                 , (select tt.telefone_tipo_descricao
                      from kss.v$telefone_tipo tt
                     where tt.telefone_tipo_id = pt.telefone_tipo_id) as tipo_telefone
                 , ('+' || t.fone_cod_pais || ' (' || t.fone_ddd || ') ' || t.fone_prefixo || ' ' || t.fone_numero) as telefone
              from kss.v$pessoa_telefone pt
             inner join kss.v$telefone t
                     on t.telefone_id = pt.telefone_id
             where pt.cod_pessoa = #arguments.cod_pessoa# 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna pessoas modalidade Cliente/Fornecedor
    -- LEOPOLDOS 10/09/2010 - CRIADO
    --->		
    <cffunction name="get_cliente_fornecedor_nome" access="remote" returntype="query" output="true">
    	<cfargument name="nome" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct p.cod_pessoa
                 , p.cliente
                 , p.razao_social
                 , p.cnpj_cpf
              from kss.v$pessoa p
             inner join kss.v$pessoa_modalidade pm
                     on pm.cod_pessoa = p.cod_pessoa
             where pm.num_modalidade = 5
             <cfif Len(Trim(#arguments.nome#))>
               and upper(p.cliente) like upper('%#arguments.nome#%')
                or upper(p.razao_social) like upper('%#arguments.nome#%')
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO 
    -- Retorna se o motorista possui bloqueio temporrio
    -- ERICG 30/09/2010 - CRIADO
    --->		
    <cffunction name="get_motorista_bloqueio" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa" required="yes">
        <cfargument name="num_modalidade" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.cod_pessoa
                 , p.nome
                 , to_char(mm.data_bloqueio, 'dd/mm/yyyy') as data_bloqueio
                 , mm.comentario
              from oper.v$motorista_bloqueio mm
             inner join kss.v$pessoa_fisica p
                     on p.cod_pessoa = mm.cod_pessoa
             inner join oper.v$pessoa_modalidade pm
                     on pm.cod_pessoa = p.cod_pessoa        
             where pm.num_modalidade in (#arguments.num_modalidade#)
               and sysdate between mm.data_bloqueio and nvl(mm.data_desbloqueio, sysdate)
               and p.cod_pessoa = #arguments.cod_pessoa#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de e-mail
    -- FABIOG 30/09/2010 - CRIADO
    --->		
    <cffunction name="get_tipo_email" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select et.email_tipo_id
                 , et.descricao 
              from kss.v$email_tipo et
             order by et.descricao 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os bancos cadastrados
    -- FABIOG 30/09/2010 - CRIADO
    --->		
    <cffunction name="get_bancos" access="remote" returntype="query" output="true">
        <cfargument name="tipo" required="yes">
        <cfargument name="valor" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select b.banco_id
                 , b.banco_abrev
                 , b.banco_descricao
                 , ba.agencia_id
                 , ba.agencia_id_dv
                 , decode(ba.municipio,null,'',ba.municipio||' - ') || ba.uf as agencia_descricao_filtro
                 , 'Ag. ' || ba.agencia_id || ' - ' || ba.agencia_id_dv || ' -' || ba.logradouro || ', ' || ba.numero || ' - CEP ' || ba.cep || ' - ' ||  decode(ba.municipio,null,'',ba.municipio||' - ') || ba.uf agencia_descricao
              from kss.banco b
             inner join kss.banco_agencia ba
                      on ba.banco_id = b.banco_id
             where 1 = 1
             <cfif arguments.tipo eq 1>
               and upper(b.banco_descricao) like upper('%#arguments.VALOR#%')
             </cfif>
             <cfif arguments.tipo eq 2>
               and upper(b.banco_abrev) like upper('%#arguments.VALOR#%')
             </cfif>
             <cfif arguments.tipo eq 3>
               and ba.agencia_id = #arguments.VALOR#
             </cfif>
             <cfif arguments.tipo eq 4>
               and b.banco_id = #arguments.VALOR#
             </cfif>
             order by banco_descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados da conta bancaria da pessoa
    -- FABIOG 30/09/2010 - CRIADO
    --->		
    <cffunction name="get_dados_bancararios" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pcb.agencia_id
                 , pcb.banco_id
                 , pcb.conta
                 , pcb.conta_dv
                 , pcb.conta_ag_dv
                 , pcb.conta_padrao
                 , decode(ba.municipio,null,'',ba.municipio||' - ') || ba.uf as agencia
                 , 'Ag. ' || ba.agencia_id || ' - ' || ba.agencia_id_dv || ' -' || ba.logradouro || ', ' || ba.numero || ' - CEP ' || ba.cep || ' - ' ||  decode(ba.municipio,null,'',ba.municipio||' - ') || ba.uf agencia_descricao
                 , b.banco_abrev
                 , b.banco_descricao as banco
              from kss.v$pessoa_conta_bancaria pcb
             inner join kss.banco_agencia ba
                     on ba.agencia_id = pcb.agencia_id
             inner join kss.banco b
                     on b.banco_id = pcb.banco_id 
                    and b.banco_id = ba.banco_id
             where pcb.cod_pessoa = #arguments.cod_pessoa#         
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
     <!--- 
    -- PROPSITO 
    -- Retorna o agregado
    -- FABIOG 30/09/2010 - CRIADO
    --->		
    <cffunction name="get_pessoa_agregado" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_pessoa,
                   tipo_pessoa,
                   cnpj_cpf,
                   identificador,
                   inscricao_estadual,
                   razao_social,
                   cliente,
                   cod_atividade_fiscal
              from kss.v$pessoa_agregado p
             where p.cod_pessoa = #arguments.cod_pessoa#         
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as UF's ara Consulta do Webservice da SEFAZ
    -- RAFAEL 15/08/2012 - CRIADO
    --->		
    <cffunction name="get_uf_webservice_sefaz" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct kss.pkg_string.initcap2(nome_uf) as nome_uf
                 , pep.uf
              from sefaz.v$emitente_ambiente ea
             inner join kss.v$pessoa p
                on p.cnpj_cpf = ea.cnpj_cpf
             inner join kss.v$pessoa_endereco_padrao pep
                on pep.cod_pessoa = p.cod_pessoa
             inner join cep.cep_ufs uf
                on uf.sigla_uf = pep.uf
             where ea.cod_docto = 'NFE'
            
            union
            
            select distinct kss.pkg_string.initcap2(nome_uf) as nome_uf
                 , x.column_value as uf
              from table(kss.pkg_string.fnc_split(kss.pkg_global.fnc_obtem_parametro_str(25, 'SEFAZ.EXE', 42, 5) , ',')) x
             inner join cep.cep_ufs uf
                on uf.sigla_uf = x.column_value
             order by 1
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna todas as modalidades para configurao de obrigatoriedade de documento
    -- JAQUELINEF 08/05/2013 - CRIADO
    --->		
    <cffunction name="get_tipo_doc_mod" access="remote" returntype="query" output="true">
        <cfargument name="cod_tipo_doc" required="no" default="">   
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.num_modalidade, m.descricao
              from kss.v$modalidade m
             <cfif Len(Trim(arguments.cod_tipo_doc))>
              inner join kss.v$pessoa_tipo_doc_modalidade tdm
                on tdm.cod_modalidade = m.num_modalidade
               and tdm.cod_tipo_doc = #arguments.cod_tipo_doc#
             </cfif>                              
             where 1 = 1                           
             order by m.descricao 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>   
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de documento caastrados
    -- JAQUELINEF 08/05/2013 - CRIADO
    --->		
    <cffunction name="get_tipo_doc" access="remote" returntype="query" output="true">
        <cfargument name="cod_tipo_doc" required="no" default="">    
        <cfargument name="nome" required="no" default="">      
        <cfargument name="cod_pessoa" required="no" default="">            
        <cfargument name="modalidades" required="no" default="">  <!---Flag de documento obrigatorio para a modalidade--->                            
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select td.nome, td.cod_tipo_doc
            <cfif Len(Trim(arguments.modalidades))>
               ,(select sign(count(1)) 
                  from kss.v$pessoa_tipo_doc_modalidade m
                 where m.cod_modalidade in (#arguments.modalidades#)
                   and td.cod_tipo_doc = m.cod_tipo_doc
               <cfif Len(Trim(arguments.cod_pessoa))>
                   and not exists (select 1
                                     from kss.v$pessoa_documento pd
                                    where pd.cod_tipo_doc = td.cod_tipo_doc
                                      and pd.cod_pessoa = #arguments.cod_pessoa#)
	           </cfif>                                        
                ) as obrigatorio 
            </cfif>            
              from kss.v$pessoa_tipo_documento td
             where 1 = 1            
             <cfif Len(Trim(arguments.nome))>
               and upper(td.nome) like upper('%#arguments.nome#%')
             </cfif>  
             <cfif Len(Trim(arguments.cod_tipo_doc))>
               and td.cod_tipo_doc = #arguments.cod_tipo_doc#
             </cfif>                            
             order by td.nome 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>   
    
    <!--- 
    -- PROPSITO 
    -- Retorna o logotipo da pessoa
    -- JAQUELINEF 08/05/2013 - CRIADO
    --->		
    <cffunction name="get_foto" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa" required="no" default="">            
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select p.cod_pessoa, p.logotipo
			    from kss.v$pessoa_logotipo p
             where 1 = 1            
             <cfif Len(Trim(arguments.cod_pessoa))>
               and cod_pessoa = #arguments.cod_pessoa#
             </cfif>  
        </cfquery>
        <cfreturn qr_result>
    </cffunction>       
    
</cfcomponent>