<cfcomponent displayname="Componente com funcoes gerais"
		     extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Utilizado para a visualizacao de arquivos salvos no banco de dados no browser.
	-- CRISTOFER - 01/02/2006
	--->	
	<cffunction name="mostrar_arquivo" output="true" access="public">
		<cfargument name="conteudo" required="yes" />
		<cfargument name="type" required="yes" />
		<CFCONTENT type="#arguments.type#" variable="#toBinary(arguments.conteudo)#" reset="yes">
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as Ufs
	-- CRISTOFER  01/11/2006
	--->		
	<cffunction name="get_uf" access="remote" returntype="query" output="true">
		<cfargument name="with_ex" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct uf_id
			  from cep.municipio
			 where uf_id <> 'EX'
			<cfif arguments.with_ex eq 1>
			union all
			select 'EX'
			  from dual		
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os municipios
	-- CRISTOFER  10/11/2006
	--->		
	<cffunction name="get_municipio" access="remote" returntype="query" output="true">
		<cfargument name="uf_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select municipio_id,
				   municipio,
				   pais_id,
				   uf_id,
				   cod_pessoa_un
			  from cep.municipio	
			 where 1=1
			 <cfif len(trim(arguments.uf_id))>
			   and uf_id = '#ucase(arguments.uf_id)#'
			 </cfif>
			 order by upper(municipio)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o municipio da pessoa
	-- CRISTOFER  20/11/2006
	--->		
	<cffunction name="get_municipio_pessoa" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.municipio_id,
				   m.municipio,
				   m.uf_id uf
			  from kss.v$pessoa_endereco pe
			 inner join cep.municipio m
					 on m.municipio_id = pe.municipio_id
			 where cod_pessoa = #arguments.cod_pessoa#
			   and endereco_padrao = 1	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os paises
	-- CRISTOFER  10/11/2006
	--->		
	<cffunction name="get_pais" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pais_id,
				   descricao,
				   id_3,
                   id_2
			  from cep.pais	
			 where 1=1
			 order by upper(descricao)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os paises
	-- CRISTOFER  10/11/2006
	--->		
	<cffunction name="get_parametro_num" access="remote" returntype="string" output="true">
    	<cfargument name="cod_projeto" required="yes">
    	<cfargument name="cod_aplicacao" required="yes">
    	<cfargument name="parametro_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_global.FNC_OBTEM_PARAMETRO_NUM(#arguments.cod_projeto#,'#arguments.cod_aplicacao#',#arguments.parametro_id#) valor from dual
		</cfquery>
		<cfreturn qr_result.valor>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o dado de um parametro
	-- CRISTOFER  10/11/2006
	--->		
	<cffunction name="get_parametro_valor" access="remote" returntype="string" output="true">
    	<cfargument name="cod_projeto" required="yes">
    	<cfargument name="cod_aplicacao" required="yes">
    	<cfargument name="parametro_grupo_id" required="yes">
    	<cfargument name="parametro_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_global.fnc_obtem_parametro_str(#arguments.cod_projeto#,'#arguments.cod_aplicacao#',#arguments.parametro_grupo_id#,#arguments.parametro_id#) valor from dual
		</cfquery>
		<cfreturn qr_result.valor>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca os dados da CG_REF_CODES
	-- CRISTOFER  16/04/2009
	--->		
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
    	<cfargument name="owner" required="yes">
    	<cfargument name="rv_domain" required="yes">
    	<cfargument name="rv_low_value" required="no" default="">
    	<cfargument name="order" required="no" default="rv_low_value">        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rv_domain, 
                   rv_low_value, 
                   rv_high_value, 
                   rv_abbreviation, 
                   rv_meaning,
                   owner
              from kss.cg_ref_codes
             where 1=1
               and owner = '#arguments.owner#'
               and rv_domain = '#arguments.rv_domain#'
             <cfif len(trim(arguments.rv_low_value))>
               and rv_low_value in (#arguments.rv_low_value#)
             </cfif>
             order by #order#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    
  

    
</cfcomponent>
