<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init" output="yes">
	<!--- 
	-- PROPSITO
	-- Todos os veculos do controle de trfego
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 18/11/2005 - criado
	--->	
	<cffunction name="get_controle_trafego" displayname="Todos os veculos do controle de trfego" output="true" returntype="query" access="public">
		<cfargument name="COD_GRUPO" required="no">
		<cfargument name="VEICULOS" required="no">
		<cfargument name="RASTREADOS" required="no">
		<cfargument name="ENCOSTADOS" required="no">
		<cfargument name="ACIDENTADOS" required="no">
		<cfargument name="STATUS" required="no">
		<cfargument name="PROPRIETARIO" required="no">
		<cfargument name="AGREGADO" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select ct.*,        <cfif session.site eq "verdescampos/">
                     	oper.pkg_veiculo.fnc_get_reboque(placa_tracao) as composicao,
					    </cfif>  
			   rhv.rastreador_id 
	      from (select upper(kss.pkg_string.fnc_string_clean(destino)) as destino_clear,
		  			   upper(kss.pkg_string.fnc_string_clean(origem)) as origem_clear,
		  			   media_frete_unitario,  
                                                     
					   placa_tracao,                                                
					   case                                                         
						 when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) then 1 
					   else 0 end tracao,                                           
					   placa_reboque,                                               
					   case                                                         
						 when (ct.placa_referencia is not null) then 1              
					   else 0 end semi_reboque,                                     
					   placa_controle,                                              
					   num_rastreador,                                              
					   possui_rastreador,                                           
					   rastreador_com_problemas,                                    
					   case                                                         
						  when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) 
						  then km_30dias 
					   	  else 0 
					   end km_30dias,                                        
					   case                                                         
						  when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) 
						  then km_atual  
					      else 0 
					   end km_atual,                                         
					   case                                                         
						  when ct.placa_controle is null 
						  then 0
					      else km_revisao 
					   end km_revisao,                              
					   km_revisao_local,                                            
					   capacidade_carga,                                            
					   cod_grupo,                                                   
					   marca,                                                       
					   modelo,                                                      
					   capacidade_tanque,                                           
					   veiculo_empresa,                                             
					   placa_referencia,                                            
					   engatada,                                                    
					   articulado,                                                  
					   cod_pessoa,                                                  
					   cod_funcionario,                                             
					   com_motorista,                                               
					   aniversario_motorista, 
                       <cfif session.site eq "verdescampos/">
					   dias_trabalho,
                       <cfelse>
                       do_df_dv,
                       </cfif>
					   data_residencia,                                             
					   mdr_num_romaneio,                                            
					   maxdatahora,                                                 
					   distancia,                                                   
					   referencia,                                                  
					   latitude,                                                    
					   longitude,                                                   
					   num_evento,                                                  
					   tempo,                                                       
					   tempo_evento,                                                
					   status,
					   nvl(status_msg_destina, 'E') status_msg_destina,
               		   nvl(status_msg_previsao,'E') status_msg_previsao,                                                       
					   <!--- Foi alterado pois no rodava na Delpozo					   
					   decode(status_msg_destina,null, 'E', status_msg_destina) status_msg_destina,   
					   decode(status_msg_previsao,null, 'E', status_msg_previsao) status_msg_previsao,--->
	   /* Se o tempo do evento no status destinado for maior que 1:30 alterta que o motorista pode ter antecipado a macro 5 antes de descarregar  */
					   case                                                                                                                                       
						  when status = 'Destinado' and segundos_tempo_evento > 5400 and                                                                        
							   oper.pkg_coord_geografica.fnc_haversine1(ct.evo_latitude, ct.evo_longitude, ct.latitude, ct.longitude) < 5                         
						  then 1                                                                                                                                  
					   else 0 end parado_origem,                                                                                                                  
					   segundos,                                                                        
					   segundos_tempo_evento,                                                           
					   atraso_vazio,                                                                    
					   atraso_carregado,                                                                
					   problema_macro,                                                                  
					   num_romaneio,                                                                    
					   rastreabilidade_id,                                                              
					   num_entrega,                                                                     
					   frete_proprio,                                                                   
					   origem,                                                                          
					   carregamento,                                                                    
					   destino,                                                                         
					   cliente,                                                                         
					   remetente,                                                                       
					   destinatario,                                                                    
					   data_evento,                                                                     
					   data_evento_resumida,                                                            
					   data_inicio,                                                                     
					   data_inicio_resumida,                                                            
					   previsao_descarga,                                                               
					   previsao_descarga_resumida,                                                      
					   num_motorista_vazio,                                                             
					   previsao_vazio,                                                                  
					   to_char(previsao_vazio, 'DD Dy HH24:MI ' ||  case                              
																	   when cod_pessoa_atraso_vazio is null then  '"('||    
																		  decode(num_motorista_vazio, 0, '', num_motorista_vazio) || decode(bloquear_previsao_vazio, 1, 'B') || ')"'
																	   when bloquear_previsao_vazio = 1 then  '"(B)"' 
																	 else null end) previsao_vazio_resumida,            
					   cod_pessoa_atraso_vazio,                                                         
					   num_motorista_carregado,                                                         
					   to_char(previsao_carregado, 'DD Dy HH24:MI ' ||  case                          
																		  when cod_pessoa_atraso_carr is null then  '"('||  
																			 decode(num_motorista_carregado, 0, '', num_motorista_carregado) || decode(bloquear_previsao_carr, 1, 'B') || ')"' 
																		  when bloquear_previsao_carr = 1 then  '"(B)"'
																		 else null end) previsao_carregado_resumida,     
					   previsao_carregado,                                                                               
					   cod_pessoa_atraso_carr,                                                                           
					   bloquear_previsao_carr, 
					   bloquear_previsao_vazio,                                                  
					   motivo,                                                                                           
					   comentario_veiculo,                                                                               
					   comentario_motorista,                                                                             
					   comentario_viagem,                                                                                
					   decode(num_romaneio, null, 0, oper.pkg_operacional.fnc_converte_peso(peso_total, 'Kg', cod_unidade)) peso_total, 
					   referencia_id, referencia_situacao_id, referencia_situacao,                                       
					   controle_situacao_id, controle_situacao, status_celular, ct.nota, status_msg_livre,               
					   placa_controle||placa_referencia||cod_pessoa||num_evento||status||num_romaneio keyfield,          
					   previsao_tempo_descarga, previsao_texto_descarga, temp_minima_descarga, temp_maxima_descarga,
					   previsao_tempo_carga, previsao_texto_carga, temp_minima_carga, temp_maxima_carga,                                         
                       <cfif session.site eq "verdescampos/">
                     	oper.pkg_veiculo.fnc_get_reboque(placa_controle) as composicao,
					    </cfif>
					   proprietario_reboque, proprietario_tracao, cnh_status, cnh_mensagem,
					   /*vhr.rastreador_id,*/ laudo_tracao, laudo_reboque, status_cavalo
				  from oper.v$controle_trafego ct 
				 where 1=1
				 <cfif IsDefined("arguments.COD_GRUPO") and Len(Trim(arguments.COD_GRUPO))>
					 and ct.cod_grupo = any( #ListQualify(arguments.COD_GRUPO,"'")# )
				 <cfelseif IsDefined("arguments.COD_GRUPO")>
					 and ct.cod_grupo is null
				 </cfif>
			
				 <cfif IsDefined("arguments.VEICULOS")>
					 <cfswitch expression="#arguments.VEICULOS#">
						<cfcase value="2">
						   and (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null))
						</cfcase>
						<cfcase value="3">
						   and ct.placa_referencia is not null
						</cfcase>
						<cfdefaultcase></cfdefaultcase>
					  </cfswitch>
				  </cfif>
			
				  <cfif IsDefined("arguments.RASTREADOS") and arguments.RASTREADOS eq 1>
					 and ct.possui_rastreador = 1 
				  </cfif>
			
				  <cfif IsDefined("arguments.ENGATADOS") and arguments.ENGATADOS eq 1>
				   and ct.engatada = 1
				  </cfif>
			
				  <cfif IsDefined("arguments.ENCOSTADOS") and IsDefined("arguments.ACIDENTADOS") and arguments.ENCOSTADOS eq 1 and arguments.ACIDENTADOS eq 1>
					   and ct.controle_situacao_id in (1, 2, 3, 4)
				  <cfelseif IsDefined("arguments.ENCOSTADOS") and arguments.ENCOSTADOS eq 1>
					   and ct.controle_situacao_id in (1, 3, 4)
				  <cfelseif IsDefined("arguments.ACIDENTADOS") and arguments.ACIDENTADOS eq 1>
					   and ct.controle_situacao_id in (1, 2, 4)
				  <cfelseif not ListFind('CVRD',UCase(session.USUARIO))>
					   and ct.controle_situacao_id in (1, 4)
				  </cfif>
			
				  <cfif IsDefined("arguments.STATUS") and Len(Trim(arguments.STATUS))>
					   and (ct.descricao_resumida = any(#ListQualify(arguments.STATUS,"'")#) or ct.descricao_resumida is null )
				  <cfelseif IsDefined("arguments.STATUS")>
					   and ct.descricao_resumida is null
				  </cfif>
	
				  <cfif IsDefined("arguments.PROPRIETARIO") and arguments.PROPRIETARIO eq 1>
					  and ct.placa_controle = any(#ListQualify(v_lista_placas,"'")#)		
				  </cfif>
				  <cfif session.site eq 'rodomar/'>
					  <cfif UCase(session.usuario) eq 'CVRD'>
						  and ct.placa_tracao in ('2101', '2102')
						  and ct.engatada = 1
					  </cfif>
					  <cfif UCase(session.usuario) eq 'BELGO'>
						  and ct.placa_tracao in ('9930', '9928', '9917')
						  and ct.engatada = 1
					  </cfif>
					  <cfif UCase(session.usuario) eq 'MANNESMANN'>
						  and ct.cod_grupo = 'PARAOPEBA'
						  and ct.engatada = 1
					  </cfif>
				  </cfif>
				) ct
		   left join integracao.v$rastreador_historico_veiculo rhv
                  on rhv.placa = ct.placa_controle
                 and rhv.principal = 1
                 and rhv.data_termino is null
			<cfif arguments.agregado eq 1>
		 inner join oper.v$veiculo_agregado va
				 on (va.placa = ct.placa_controle or va.placa = ct.placa_referencia)
		 where possui_rastreador = 1
		   and va.cod_pessoa = #session.cod_pessoa_usuario# 
			</cfif>
            
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna grupos de veculos ativos
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 21/11/2005 - criado
	--->	
	<cffunction name="get_grupos_veiculos" displayname="Retorna grupos de veculos ativos" output="true" returntype="query" access="public">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select vgs.cod_grupo
               	 , vgs.grupo_id
			  from oper.v$veiculo_grupo_setup vgs
			 where vgs.situacao_id = 1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os status de eventos possiveis para os veculos
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 21/11/2005 - criado
	--->	
	<cffunction name="get_status_eventos" displayname="Retorna todos os status de eventos possiveis para os veculos" output="true" returntype="query" access="public">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select descricao_resumida 
				  from oper.v$evento_operacao_setup
			 where num_grupo = 1
			   and prioridade = 1
			   and situacao = 1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna possiveis proprietrios de veculos
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 21/11/2005 - criado
	--->	
	<cffunction name="get_proprietarios" displayname="Retorna possiveis proprietrios de veculos" output="true" returntype="query" access="public">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                 select pj.cnpj_basico || pj.cnpj_ordem as cpf_cnpj,
                           pj.cod_pessoa,
                           pj.razao_social as proprietario,
                           '1' as tipo_proprietario -- agregado
                      from oper.pessoa_juridica pj
                     where exists (select '*'
                                    from oper.v$veiculo v
                                   inner join oper.v$veiculo_modelo m
                                                on m.marca_id = v.marca_id
                                             and v.modelo_id = v.modelo_id
                                   inner join oper.v$veiculo_proprietario pjv
                                                on pjv.placa = v.placa                       
                                             and pjv.data_fim is null
                                   where pjv.cod_pessoa = pj.cod_pessoa
                                     and exists(select 'x'
                                                  from oper.v$veiculo_tracao vt
                                                 where vt.tipo_id = m.tipo_id)
                                     and v.situacao_id = 1)
                       and pj.modalidade_id = 10 --agregado
                       and pj.situacao_id = 1 --ativo		
					   and pj.cod_pessoa = 1			   
                    union all
                    select pj.cnpj_basico as cpf_cnpj,
                           pj.cod_pessoa,
                           pj.razao_social as proprietario,
                           '2' as tipo_proprietario
                      from oper.v$pessoa_juridica pj
                     inner join kss.v$unidade_negocio un1
                                   on pj.cod_pessoa = un1.cod_pessoa
                     where pj.cnpj_ordem = (select min(pj1.cnpj_ordem)
                                              from kss.v$unidade_negocio un
                                             inner join oper.v$pessoa_juridica pj1
                                                     on pj1.cod_pessoa = un.cod_pessoa)
					   and pj.cod_pessoa = 1
                    order by proprietario
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Retorna historico de posicoes do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 22/11/2005 - criado
	--->	
	<cffunction name="get_controle_posicoes" displayname="Retorna historico de posicoes do veculo" access="remote" returntype="query" output="true">
	<cfargument name="placa" required="yes">
	<cfargument name="retroagir" required="yes">
	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
		select referencia,                                                                                               
			   data_inicio data_ini, data_termino date_term,                                                             
			   to_char(data_inicio,'dd/mm hh24:mi') data_inicio,                                                       
			   to_char(data_termino,'dd/mm hh24:mi') data_termino,                                                     
			   oper.pkg_global.fnc_tempo_formatado(((data_termino - data_inicio))*60*60*24) diferenca_tempo,             
			   case                                                                                                      
				  when (data_termino - data_inicio)*60*60*24-(trunc(next_raio*60*1.1)) > 300 and tempo > 0 then          
					   oper.pkg_global.fnc_tempo_formatado(((data_termino - data_inicio)*60*60*24-(trunc(next_raio*60*1.1)))) 
				  else '  00 : 00'                                                                                     
			   end tempo_horas,                                                                                          
			   next_raio,                                                                                                
			   '#arguments.placa#' placa 
		  from (select /*+ORDERED*/                                                                                      
					   referencia,                                                                                       
					   data_inicio,                                                                                      
					   nvl((lead(data_inicio) over (order by grp))-1/86400,  data_termino) data_termino,                 
					   max(next_raio) next_raio, sum(tempo) tempo                                                        
				  from (select grp,                                                                                      
							   last_value(referencia) over (partition by grp) referencia,                                
							   first_value(data) over (partition by grp) data_inicio,                                    
							   last_value(next_data) over (partition by grp) data_termino,                               
							   lag(referencia) over (order by grp) ref_anterior,                                         
							   tempo, next_raio                                                                          
						  from (select sum(case                                                                          
											  when raio < limiar and limiar > 5 and raio < 4  then 0                     
											  when raio < 4 and raio < limiar and ((next_data - data) * 60 * 60 * 24 - round(limiar * 1.2)) > 0 then 0 
											  else 1                                                                     
										   end) over (order by data rows unbounded preceding) grp,                       
									   case                                                                              
										  when raio < limiar and limiar > 5 and raio < 4 and tempo < 0 then              
											 (next_data - data) * 60 * 60 * 24 + (tempo )                                
										  when raio < limiar and limiar > 5 and raio < 4 then                            
											 (next_data - data) * 60 * 60 * 24                                           
										  when raio < 4 and raio < limiar and ((next_data - data) * 60 * 60 * 24 - round(limiar * 2)) > 0 then   
											(next_data - data) * 60 * 60 * 24 - round(limiar * 1.1)                      
									   when raio < (next_tempo/5) and next_tempo > 180 and raio > 4 then                 
										((next_data - data) * 60 * 60 * 24) - round(next_raio * 1.1 * 60 )               
										  else 0                                                                         
									   end tempo,                                                                        
									   referencia, data, (next_data-1/86400) next_data,                                  
									   raio, next_raio                                                                   
								  from (select raio, next_raio, tempo - round(next_raio * 2) tempo, referencia,          
											   last_data, data, next_data,                                               
											   (data - last_data) * 60 * 24 / 5 limiar,                                  
											   (next_data - data) * 60 * 24 next_tempo                                   
										  from (select nvl(raio, 999) raio, next_raio, last_data, data, trunc((next_data - data) * 60 * 24) tempo,  
													   referencia, next_data                                             
												  from (select data, landmark referencia,                                
															   nvl(lag(data) over(order by data), data) last_data,       
															   nvl(lead(data) over(order by data), data) next_data,      
															   round(oper.pkg_coord_geografica.fnc_haversine1(latitude, longitude, lag(latitude) over(order by data), lag(longitude) over(order by data)), 2) raio,           
															   round(oper.pkg_coord_geografica.fnc_haversine1(latitude, longitude, lead(latitude) over(order by data), lead(longitude) over(order by data)), 2) next_raio     
														  from oper.v$posicao                                            
														 where placa = '#arguments.placa#'
														   and data between trunc(sysdate - #arguments.retroagir#) and to_date(to_char(sysdate, 'dd/mm/yyyy')||' 23:59:59', 'dd/mm/yyyy hh24:mi:ss') )))))            
				   where referencia <> ref_anterior or tempo > 0                                                         
				   group by grp, referencia, data_inicio, data_termino                                                   
				   order by data_inicio desc) 
	</cfquery>
   <cfreturn qr_result>	   
</cffunction>	

	<!--- 
	-- PROPSITO
	-- Macros de envio da empresa
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 22/11/2005 - criado
	--->	
	<cffunction name="get_macros_envio" displayname="Macros de envio da empresa" access="remote" returntype="query" output="true">
    	<cfargument name="rastreador_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select macro_id, num_macro, nome_macro, conta_id,
				   oper.fnc_interpreta_macro_html(texto) as texto, parametros
			  from oper.v$macro t
			where tipo = 0
			  and situacao = 1
	          and ((num_macro =1 and conta_id = 1) or (macro_id = 0 and conta_id <> 1))
              <cfif Len(Trim(arguments.RASTREADOR_ID))>
              and t.conta_id = (select rc.conta_id
                                from rastreador.v$rastreador r
                               inner join rastreador.v$rastreador_conta rc
                                       on rc.cod_conta = r.cod_conta
                                      and rc.modelo_id = r.modelo_id
                               where rastreador_id = #arguments.RASTREADOR_ID# )                                
              </cfif>
			order by num_macro
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Macros de envio da empresa
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 22/11/2005 - criado
	--->	
	<cffunction name="get_localiza_carga" displayname="Macros de envio da empresa" access="remote" returntype="query" output="true">
		<cfargument name="cnpj_cpf" required="yes">
		<cfargument name="nro_nf" required="yes">
		<cfquery name="qrPessoa" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_global.fnc_get_cod_pessoa('#arguments.CNPJ_CPF#') as cod_pessoa from dual
		</cfquery>
		<cfif qrPessoa.recordcount>
			<cfset v_cod_pessoa = qrPessoa.cod_pessoa>
		<cfelse>
			<cfset v_cod_pessoa = -1>
		</cfif>
		<cfquery name="qrViagem" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select placa_referencia, placa_controle, status, data_previsao_chegada, 
				   data_ult_posicao, distancia, referencia, destinatario, 
				   carregamento, remetente,  
                   to_char(data_ult_posicao,'dd/mm hh24:mi') as data_ult_posicao_form,
                   to_char(data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio, 
                   to_char(data_destinado,'dd/mm/yyyy hh24:mi') as data_destinado, 
				   to_char(data_termino,'dd/mm/yyyy hh24:mi') as data_termino,                    
                   to_char(data_inicio_carga,'dd/mm/yyyy hh24:mi') as data_inicio_carga, 
                   to_char(data_inicio_carga,'dd/mm') as dia_mes_inicio_carga,
                   to_char(data_termino_carga,'dd/mm/yyyy hh24:mi') as data_termino_carga,
                   to_char(data_termino_carga,'dd/mm') as dia_mes_termino_carga, 
				   to_char(data_inicio_descarga,'dd/mm/yyyy hh24:mi') as data_inicio_descarga, 
                   to_char(data_inicio_descarga,'dd/mm') as dia_mes_inicio_descarga, 
                   to_char(data_termino_descarga,'dd/mm/yyyy hh24:mi') as data_termino_descarga, 
                   to_char(data_termino_descarga,'dd/mm') as dia_mes_termino_descarga, 
                   latitude, longitude
			  from oper.v$localiza_carga
			 where nf_numero = #arguments.nro_nf#
			   and (cod_destinatario = #v_cod_pessoa# or cod_remetente = #v_cod_pessoa#) 
		</cfquery>
	   <cfreturn qrViagem>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca a previsao do tempo no municipio por webservices na kmm
	-- CRISTOFER 08/03/2006
	--->	
	<cffunction name="get_previsao_municipio" access="remote" returntype="query" output="yes">
		<cfargument name="data" required="no" default="">
		<cfargument name="municipio" required="yes">
		<cfargument name="uf" required="yes">
		<cfif len(trim(arguments.data))>
			<cfset arguments.parse_data = CreateDate(ListGetAt(arguments.data, 3, '/'), ListGetAt(arguments.data, 2, '/'), ListGetAt(arguments.data, 1, '/'))>	
			<cfset regs = 1>
		<cfelse>
			<cfset regs = 4>
		</cfif>
		<cfquery name="qr_previsao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct upper(kss.pkg_string.fnc_string_clean(t.municipio)) as municipio,
				   t.sigla_uf,
				   trunc(t.data) as data,
				   t.url_previsao,
				   t.maxima,
				   t.minima,
			  from oper.v$previsao_tempo_municipio t
			 where upper(kss.pkg_string.fnc_string_clean(t.municipio)) = upper(kss.pkg_string.fnc_string_clean('#arguments.municipio#'))
			   and sigla_uf = upper('#arguments.UF#')
			 <cfif len(trim(arguments.data))>
			   and trunc(data) = '#arguments.DATA#'
			 <cfelse>
			   and trunc(data) between trunc(sysdate) and trunc(sysdate)+3
			 </cfif>
			   and date_update > sysdate - (1/24)*5
		</cfquery>
		<cfif (not (qr_previsao.recordCount ge regs)) and ((not len(trim(arguments.data))) or (DateDiff('d', arguments.parse_data, now()) le 3 and DateDiff('d', arguments.parse_data, now()) gt -1))>        
            <cfscript>
                //Similar ao webservice, porem com acesso direto (para tratamento de erros).
                conn = CreateObject("component", "_webservices.cfc_previsao");
                qrPrevisaoMunic = conn.get_previsao_municipio(data = arguments.data,
                                                              uf = arguments.uf,
                                                              municipio = arguments.municipio);
            </cfscript> 
            <cfoutput query="qrPrevisaoMunic">				
                    <cfscript>
                    this.ins_previsao(	municipio = arguments.municipio,
                                        uf = arguments.uf,
                                        data = DateFormat(qrPrevisaoMunic.data,'dd/mm/yyyy'),
                                        url_previsao = qrPrevisaoMunic.url_previsao,
                                        maxima = qrPrevisaoMunic.maxima,
                                        minima = qrPrevisaoMunic.minima);
                    </cfscript>                  
            </cfoutput>
        </cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct upper(kss.pkg_string.fnc_string_clean(t.municipio)) as municipio,
				   t.sigla_uf,
				   trunc(t.data) as data,
				   t.url_previsao,
				   t.maxima,
				   t.minima,
				   p.descricao,
				   p.ordem
			  from oper.v$previsao_tempo_municipio t		
             inner join oper.v$previsao_tempo p
               on p.url = t.url_previsao	
			 where upper(kss.pkg_string.fnc_string_clean(t.municipio)) = upper(kss.pkg_string.fnc_string_clean('#arguments.municipio#'))
			   and sigla_uf = upper('#arguments.UF#')
			 <cfif len(trim(arguments.data))>
			   and data = '#arguments.DATA#'
			 <cfelse>
			   and trunc(data) between trunc(sysdate) and trunc(sysdate)+3
			 </cfif>
			 order by data
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca a previsao do tempo no municipio por webservices na kmm
	-- CRISTOFER 08/03/2006
	--->	
	<cffunction name="get_previsao_tempo" access="remote" returntype="query" output="true">	
		<cfargument name="com_imagem" required="no" default="0">
		<cfargument name="tipo" required="no" default=""><!--- 0 - Pequena, 1 - Grande, "" - Ambas--->
		<cfargument name="url" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select url,
				<cfif (not len(trim(arguments.tipo))) or arguments.tipo eq 1>
				   imagem, 
				</cfif>
				<cfif (not len(trim(arguments.tipo))) or arguments.tipo eq 0>
				   mini, 
				</cfif>
				   descricao, 
				   ordem 
			  from oper.v$previsao_tempo
			 where 1=1
			 <cfif arguments.com_imagem eq 1>
			   and imagem is not null
			 </cfif>
			   and upper(url) = upper('#arguments.url#')
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma previsao do tempo para o municipio
	-- cristofer 10/03/2006 16:31:33 - CRIADO
	--->
	<cffunction name='ins_previsao' displayname='' access='package' returntype='Struct' output='yes'>;
		<cfargument name='MUNICIPIO' required='yes'>
		<cfargument name='UF' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='URL_PREVISAO' required='yes'>
		<cfargument name='MAXIMA' required='yes'>
		<cfargument name='MINIMA' required='yes'>
		<cfstoredproc procedure='oper.pkg_previsao_tempo.prc_ins_previsao_tempo_munic' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MUNICIPIO'  value='#UCase(arguments.MUNICIPIO)#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SIGLA_UF'  value='#UCase(arguments.UF)#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_PREVISAO'  value='#arguments.URL_PREVISAO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MAXIMA'  value='#arguments.MAXIMA#'  null='#iif(len(trim(arguments.MAXIMA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MINIMA'  value='#arguments.MINIMA#'  null='#iif(len(trim(arguments.MINIMA)), de('no'), de('yes'))#'>
		</cfstoredproc>
		<cfreturn StructNew()/>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca eventos
	-- GUTO 10/08/2006
	--->	
	<cffunction name="get_evento" access="remote" returntype="query" output="true">	
		<cfargument name="num_evento" required="no" default="">
		<cfargument name="num_grupo" required="no" default="">
		<cfargument name="operacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.num_evento, e.descricao, e.descricao_resumida, e.prioridade, e.num_grupo, 
				   e.evento_critico, e.registra_km, e.situacao<cfif Len(Trim(arguments.operacao_id))>, oe.codigo as cod_evento</cfif>
			  from oper.v$evento_operacao_setup e
			  <cfif Len(Trim(arguments.operacao_id))>
                inner join dedicado.v$operacao_evento oe 
                        on oe.num_evento = e.num_evento
                       and oe.operacao_id = #arguments.operacao_id# 
              </cfif>
			 where permite_lancto_manual = 1
			   and situacao = 1
			  <cfif not Len(Trim(arguments.operacao_id))>
				  and num_grupo <> 6
			  </cfif>
			  <cfif Len(Trim(arguments.num_grupo))>
				  and num_grupo = #arguments.num_grupo#
			  </cfif>
			  <cfif Len(Trim(arguments.num_evento))>
				  and num_evento = #arguments.num_evento#
			  </cfif>
			  order by descricao
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	<!--- 
	-- PROPSITO
	-- Busca parametros dos eventos
	-- GUTO 10/08/2006
	--->	
	<cffunction name="get_evento_parametro" access="remote" returntype="query" output="true">	
		<cfargument name="num_evento" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ed.num_evento, ed.dado_id, eds.descricao, eds.tipo_dado, ed.obrigatorio
			  from oper.v$evento_dado ed
			 inner join oper.v$evento_dado_setup eds
					 on eds.dado_id = ed.dado_id	
			 where 1=1
			 <cfif Len(Trim(arguments.num_evento))>
			  and ed.num_evento = #arguments.num_evento#
			 </cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
<!---	<!--- 
	-- PROPSITO
	-- Busca referencias
	-- GUTO 10/08/2006
	--->	
	<cffunction name="get_referencia" access="remote" returntype="query" output="true">	
		<cfargument name="classe_id" required="no" default="">
		<cfargument name="referencia" required="no" default="">
		<cfargument name="referencia_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select referencia_id, referencia, classe_id, latitude, longitude
			  from rastreador.v$referencia r
			 where 1=1
			 <cfif Len(Trim(arguments.referencia_id))>
			  and r.referencia_id = #arguments.referencia_id#
			 </cfif>
			 <cfif Len(Trim(arguments.referencia))>
			  and upper(r.referencia) like upper('%#arguments.referencia#%')
			 </cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	--->	
	<!--- 
	-- PROPSITO
	-- Busca eventos
	-- GUTO 15/08/2006
	--->	
	<cffunction name="get_evento_operacao" access="remote" returntype="query" output="true">	
		<cfargument name="controle_evo_id" required="no" default="">
		<cfargument name="num_romaneio" required="no" default=""> 
		<cfargument name="placa" required="no" default=""> 
		<cfargument name="cod_veiculo" required="no" default=""> 
		<cfargument name="data_inicio" required="no" default=""> 
		<cfargument name="data_fim" required="no" default=""> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select re.num_romaneio,	 eo.controle_evo_id, eo.num_evento, eos.descricao_resumida as evento, eo.cod_pessoa, mrh.cod_registro as cod_funcionario,
			  	   pf.nome as nome_funcionario,
				   eo.placa, vd.cod_veiculo, to_char(eo.data,'dd/mm/yyyy hh24:mi') as data , 
                   eo.km, eo.origem, eo.latitude, eo.longitude, 
				   eo.debitar_motorista, eo.referencia_id, r.referencia,  eo.local, 
				   eo.user_insert, to_char(eo.date_insert,'dd/mm/yyyy hh24:mi') as date_insert, eo.user_update, 
                   to_char(eo.date_update,'dd/mm/yyyy hh24:mi') as date_update
			  from oper.v$evento_operacao eo
			 inner join oper.v$referencia r
					 on r.referencia_id = eo.referencia_id  
			 inner join oper.v$veiculo_dados vd
						on vd.placa = eo.placa
			 inner join oper.v$evento_operacao_setup eos
			         on eos.num_evento = eo.num_evento
			 left join oper.v$motorista_reg_historico mrh
					 on mrh.cod_pessoa = eo.cod_pessoa
					and mrh.data_fim is null
			 left join kss.v$pessoa_fisica pf
					on pf.cod_pessoa = mrh.cod_pessoa
			 left join oper.v$romaneio_evento re
			        on re.controle_evo_id = eo.controle_evo_id
			  where eos.permite_lancto_manual = 1
			    and eos.situacao = 1
			    <cfif Len(Trim(arguments.controle_evo_id))>
				    and eo.controle_evo_id = #arguments.controle_evo_id#
				 </cfif>
			    <cfif Len(Trim(arguments.placa))>
				    and placa = '#arguments.placa#'
				 </cfif>
			    <cfif Len(Trim(arguments.cod_veiculo))>
				    and upper(vd.cod_veiculo) = upper('#arguments.cod_veiculo#')
				 </cfif>
			    <cfif Len(Trim(arguments.num_romaneio))>
				    and re.num_romaneio = #arguments.num_romaneio#
				 </cfif>
			    <cfif Len(Trim(arguments.data_inicio))>
				    and to_date(to_char(data, 'dd/mm/yyyy'), 'dd/mm/yyyy') >= to_date('#arguments.data_inicio#','dd/mm/yyyy') 
 				</cfif>
                <cfif Len(Trim(arguments.data_fim))>                   
                    and to_date(to_char(data, 'dd/mm/yyyy'), 'dd/mm/yyyy') <= to_date('#arguments.data_fim#','dd/mm/yyyy')
				 </cfif>
				order by eo.data desc
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>		
	<!--- 
	-- PROPSITO
	-- Busca dados do evento
	-- GUTO 15/08/2006
	--->	
	<cffunction name="get_evento_dado" access="remote" returntype="query" output="true">	
		<cfargument name="controle_evo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select eod.controle_evo_id, eod.dado_id, eod.valor,
			 	    eds.tipo_dado, eds.descricao
			   from oper.v$evento_operacao eo
			  inner join oper.v$evento_operacao_dado eod
					  on eod.controle_evo_id = eo.controle_evo_id
			  inner join oper.v$evento_dado_setup eds
					  on eds.dado_id = eod.dado_id          			  
			  where 1=1
			  <cfif Len(Trim(arguments.controle_evo_id))>
			    and eo.controle_evo_id = #arguments.controle_evo_id#
			  </cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados do veiculo para a tela de destinar
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_veiculo_dados_destinar" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+FIRST_ROWS*/v.placa, v.num_rastreador, vm.cod_pessoa,
				   oper.pkg_global.fnc_get_cod_funcionario(vm.cod_pessoa) cod_funcionario,
				   oper.pkg_veiculo.fnc_km_atual(v.placa) km_atual,
				   (select vc.placa_2
					  from oper.v$veiculo_composicao vc
					 where vc.placa_1 = v.placa
					   and vc.data_hora_desengate is null
					union
					select vei.placa as placa_2
					  from oper.v$veiculo vei
					 inner join oper.v$veiculo_modelo vm
							 on vm.marca_id = vei.marca_id
							and vm.modelo_id = vei.modelo_id
					 inner join oper.v$veiculo_tipo vt
							 on vt.tipo_id = vm.tipo_id
					 inner join oper.v$veiculo_categoria vct
							 on vct.categoria_id = vt.categoria_id
							and vct.controla = 1
							and vct.tracao = 1
							and vct.articulado = 0
					 where vei.placa = v.placa) placa_referencia,
				   v.placa placa_tracao,
				   oper.pkg_veiculo.fnc_capacidade_carga_compo(v.placa, nvl(v.capacidade,0))/1000 capacidade_real, -- Sempre em Toneladas
				   (oper.pkg_veiculo.fnc_capacidade_carga_compo(v.placa, nvl(v.capacidade,0)) + (oper.pkg_veiculo.fnc_capacidade_carga_compo(v.placa, nvl(v.capacidade,0)) * 0.10))/1000  capacidade_carga
			  from oper.v$veiculo_dados v 
			 inner join oper.v$veiculo_motorista vm
					 on vm.placa = v.placa
					and vm.data_fim is null
			 where v.placa = '#arguments.placa#'	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as naturezas
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_natureza" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */
				   n.num_natureza, n.descricao
			  from oper.v$natureza  n
			 order by n.descricao	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as especies
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_especie" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.num_especie, e.descricao,
				   e.abreviatura, e.peso
			  from oper.v$especie e
			 order by e.abreviatura
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as unidades de medida
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_unidade_medida" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select u.cod_unidade,
				   u.unidade
			  from kss.v$unidade_medida u
			 order by u.unidade	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca a posicao atual do veiculo
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_posicao_veiculo" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfargument name="num_romaneio" required="no" default="">
		<cftry>
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+FIRST_ROWS*/
					   oper.pkg_operacional.fnc_coord_geograf_placa('#arguments.placa#', decode('#arguments.num_romaneio#', 0, null, '#arguments.num_romaneio#')).latitude as latitude,
					   oper.pkg_operacional.fnc_coord_geograf_placa('#arguments.placa#', decode('#arguments.num_romaneio#', 0, null, '#arguments.num_romaneio#')).longitude as longitude
				  from dual	
			</cfquery>
			<cfcatch>
				<cfscript>
					qr_result = queryNew("latitude,longitude");
					QueryAddRow(qr_result);
					QuerySetCell(qr_result, "latitude", 0);
					QuerySetCell(qr_result, "longitude", 0);
				</cfscript>
			</cfcatch>
		</cftry>
		<cfreturn qr_result>		
	</cffunction>
	
	<!---
	-- PROPSITO 
	-- Busca os lotes para destinar
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_lotes_destinar" access="remote" returntype="query" output="true">	
		<cfargument name="placa" required="yes">
		<cfargument name="latitude" required="yes">
		<cfargument name="longitude" required="yes">
		<cfargument name="municipio_id" required="no" default="">
		<cfargument name="fracionado" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+LEADING(LOE)*/ loe.num_lote,
				   oper.pkg_operacional.fnc_converte_peso(loe.peso, 'Kg', loe.cod_unidade) peso,
				   loe.volume, 
				   loe.m3,
				   loe.frete_valor_unitario, 
				   loe.frete_em,
				   loe.qtde_viagem, 
				   loe.controle_peso,
				   decode(loe.controle_peso_veiculo, 0, oper.pkg_operacional.fnc_converte_peso(oper.pkg_veiculo.fnc_capacidade_carga_compo('#arguments.placa#'), 'Kg', loe.cod_unidade), loe.controle_peso_veiculo) controle_peso_veiculo,
				   loe.controle_viagem,
				   
				   /* Remetente */
				   loe.cod_pessoa_remetente, 
				   loe.coleta_logradouro,
				   loe.coleta_complemento, 
				   loe.coleta_bairro,
				   loe.coleta_cep, 
				   loe.coleta_cod_uf,
				   loe.coleta_cod_municipio, 
				   loe.coleta_cod_dv,
				   loe.coleta_cod_distrito, 
					loe.coleta_municipio_id,
				   ibge.municipio coleta_nome_municipio,
				   ibge.uf_id coleta_sigla_uf,
				   oper.pkg_operacional.fnc_cliente(loe.cod_pessoa_remetente) remetente,
				   rem.cnpj_cpf remetente_cnpj_cpf,
				   
				   /* Destinatario */
				   loe.cod_pessoa_destinatario,
				   loe.entrega_logradouro, 
				   loe.entrega_complemento,
				   loe.entrega_bairro, 
				   loe.entrega_cep,
				   loe.entrega_cod_uf, 
				   loe.entrega_cod_municipio,
				   loe.entrega_cod_distrito, 
				   loe.entrega_cod_dv,
					loe.entrega_municipio_id,
				   ibge2.municipio entrega_nome_municipio,
				   ibge2.uf_id entrega_sigla_uf,
				   oper.pkg_operacional.fnc_cliente(loe.cod_pessoa_destinatario) destinatario,
				   dest.cnpj_cpf destinatario_cnpj_cpf,
				   
				   loe.gauge,
				   loe.quantidade,
				   to_char(loe.data_prazo_retirada, 'dd/mm hh24:mi') prazo,
				   loe.num_natureza, 
				   loe.num_especie, 
				   loe.num_produto,
				   loe.cod_pessoa_filial, 
				   loe.cod_departamento,
				   loe.cod_setor, 
				   loe.cod_centro_custo,
				   loe.cod_unidade, 
				   n.descricao natureza,
				   loe.fracionado,
				   cep.fnc_cidade_completa(loe.coleta_municipio_id,' ') || '/' ||
				   cep.fnc_cidade_completa(loe.entrega_municipio_id,' ') || ' ( ' ||
				   oper.pkg_operacional.fnc_cliente(loe.cod_pessoa_remetente) || ') - ' || p.descricao viagem,
				   case loe.frete_proprio
					  when 0 then 'Sub-Contratado'
					  when 1 then 'Prprio'
					  when 2 then 'Avulso'
						end Tipo_Frete,
				   round(oper.pkg_coord_geografica.fnc_haversine1(oper.pkg_coord_geografica.fnc_graus2decimais(ibge.latitude),
																  oper.pkg_coord_geografica.fnc_graus2decimais(ibge.longitude),
																  1, 1)) distancia,
		           p.descricao as frete_tipo
			  from oper.v$lote_romaneio loe
			 inner join oper.v$natureza n
					 on n.num_natureza = loe.num_natureza
		     inner join oper.v$produto p 
			   	     on p.produto_id = loe.num_produto
			 left join cep.municipio ibge
					 on loe.coleta_municipio_id = ibge.municipio_id
			 left join cep.municipio ibge2
					 on loe.entrega_municipio_id = ibge2.municipio_id
			 left join kss.v$pessoa rem
					 on rem.cod_pessoa = loe.cod_pessoa_remetente
			 left join kss.v$pessoa dest
					 on dest.cod_pessoa = loe.cod_pessoa_destinatario
			 where loe.situacao_id = 1
			  /* and not exists(select \*+ORDERED*\ '*'
								from oper.v$contrato_transp ct
							   inner join oper.v$romaneio_item ri
									   on ri.num_romaneio = ct.num_romaneio
							   where ri.num_lote = loe.num_lote) */
			 <cfif len(trim(arguments.municipio_id))>
			   and loe.coleta_municipio_id = #arguments.municipio_id#
			 </cfif>
			 <cfif len(trim(arguments.fracionado))>
			   and loe.fracionado = #arguments.fracionado#
			 </cfif>
			 order by loe.num_lote	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os municipios dos lotes a destinar
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_municipio_lote_destinar" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ORDERED*/ 
				   distinct
				   ibge.municipio, 
				   ibge.municipio_id as keyfield,
				   ibge.uf_id, ibge.municipio_id
			  from oper.v$lote_romaneio loe
			 inner join oper.v$natureza n
					 on n.num_natureza = loe.num_natureza
			 inner join cep.municipio ibge
					 on loe.coleta_municipio_id = ibge.municipio_id
			 where loe.situacao_id = 1
			   and not exists(select /*+ORDERED*/ '*'
								from oper.v$contrato_transp ct
							   inner join oper.v$romaneio_item ri
									   on ri.num_romaneio = ct.num_romaneio
							   where ri.num_lote = loe.num_lote)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os valores para o campo FRETE EM na tela de destinar
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_frete_em_destinar" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 'PESO' descricao
			from dual
			union
			select 'VOLUME' descricao
			from dual
			union
			select 'M3' descricao
			from dual				   	
			union
			select 'LOTACAO' descricao
			from dual				   	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os municipios
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_municipio_uf" access="remote" returntype="query" output="true">
		<cfargument name="sigla_uf" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */
				   i.sigla_uf, InitCap(i.nome_municipio) municipio,
				   i.cod_uf, i.cod_municipio, i.cod_dv, i.cod_distrito,
					i.municipio_id_kmm as municipio_id
			  from cep.ibge_municipio i
			 where i.nome_categoria in ('Capital', 'Cidade')
			 <cfif not isnumeric(arguments.sigla_uf)>
			   and i.sigla_uf = '#arguments.sigla_uf#' 
			 </cfif>
			 <cfif isnumeric(arguments.sigla_uf)>
			   and i.cod_uf = #arguments.sigla_uf#
			  </cfif>
			 order by i.sigla_uf, i.nome_municipio
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as UFs
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_uf" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct upper(sigla_uf) sigla_uf, cod_uf
			  from cep.ibge_municipio	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as liberaes de seguro 
	-- CRISTOFER  16/10/2006
	--->		
	<cffunction name="get_liberacao_seguro" access="remote" returntype="query" output="true">
		<cfargument name="tipo_seguro" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select scl.id_seguradora, scl.num_liberacao, sc.tipo_seguro
			  from oper.v$seg_contratado sc
			 inner join oper.v$seg_cont_liberacao scl
					 on scl.id_seguradora = sc.id_seguradora
					and scl.liberacao_por_viagem = 1
					and not exists(select '*'
									 from oper.v$romaneio_liberacao rl
									where rl.seguradora_id_rctrc = scl.id_seguradora
									  and rl.num_liberacao_rctr_c = scl.num_liberacao)           
			 where 1=1
			 <cfif len(trim(arguments.tipo_seguro))>
			   and sc.tipo_seguro = #arguments.tipo_seguro#
			 </cfif>
			   and sc.data_cancelamento is null
			   and trunc(sysdate) between sc.data_inicio_vigencia and sc.data_fim_vigencia
			 order by scl.num_liberacao	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Retorna as rotas cadastradas
	-- ANDERSON 11/01/2010 - ALTERADO
	--->
	<cffunction name="get_rota" access="remote" returntype="query" output="true">
    	<cfargument name="rota_id" required="no" default="" />
		<cfargument name="abreviatura" required="no" default="" />
        <cfargument name="descricao_rota" required="no" default="" />
		<cfargument name="origem_municipio_id" required="no" default="" />
		<cfargument name="destino_municipio_id" required="no" default="" />
        <cfargument name="municipio_origem" required="no" default="" />
        <cfargument name="municipio_destino" required="no" default="" />
        <cfargument name="referencia_origem" required="no" default="" />
        <cfargument name="referencia_destino" required="no" default="" />
        <cfargument name="operacao_id" required="no" default="" />
        <cfargument name="rapida" required="no" default="0" />
        <cfargument name="repom" required="no" default="0" />
        <cfargument name="tipo_integracao" required="yes" default="1" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.rota_id
                 , r.abreviatura
                 , r.descricao_rota
                 , r.descricao_via
                 , r.origem_municipio_id
                 , cep.fnc_cidade_completa(r.origem_municipio_id) as origem
                 , r.origem_cod_pessoa
                 , r.origem_latitude
                 , r.origem_longitude
                 , r.destino_municipio_id
                 , cep.fnc_cidade_completa(r.destino_municipio_id) as destino
                 , r.destino_cod_pessoa
                 , r.destino_latitude
                 , r.destino_longitude
                 , r.distancia_padrao
                 , r.distancia_hodometro
                 , r.consolidado
                 , r.referencia_origem_id
                 , (select re.referencia
                      from oper.v$referencia re
                     where re.referencia_id = r.referencia_origem_id
                   ) as referencia_origem
                 , r.referencia_destino_id
                 , (select re.referencia
                      from oper.v$referencia re
                     where re.referencia_id = r.referencia_destino_id
                   ) as referencia_destino
                 , r.user_insert
                 , r.date_insert
                 , r.user_update
                 , r.date_update
                 , r.site
                <cfif arguments.repom eq 1>
                     <cfif arguments.tipo_integracao eq 2>
                     , sign((select count(1)
                               from repom.v$consulta_rota_vpr cr
                              where cr.rota_id = r.rota_id
                            )
                           ) as possui_repom
                     , (select rt.pedagio_ida_volta
                          from repom.v$rota_vpr rt
                         where rt.rota_id = r.rota_id 
                       ) as pedagio_ida_volta
                    <cfelse>
                     , sign((select count(1)
                               from repom.v$consulta_rota cr
                              where cr.rota_id = r.rota_id
                            )
                           ) as possui_repom
                     , (select rt.pedagio_ida_volta
                          from repom.v$rota rt
                         where rt.rota_id = r.rota_id 
                       ) as pedagio_ida_volta
                    </cfif>   
                </cfif>
              from oper.v$rota r
             inner join cep.municipio mo
                     on mo.municipio_id = r.origem_municipio_id
             inner join cep.municipio md
                     on md.municipio_id = r.destino_municipio_id
             where 1 = 1
             <cfif Len(Trim(arguments.rota_id))>
               and r.rota_id = #arguments.rota_id#
             <cfelse>
				<cfif Len(Trim(arguments.abreviatura))>
					and kss.pkg_string.fnc_string_clean(upper(r.abreviatura)) like kss.pkg_string.fnc_string_clean(upper('#arguments.abreviatura#%'))
                </cfif>
                <cfif Len(Trim(arguments.descricao_rota))>
					and kss.pkg_string.fnc_string_clean(upper(r.descricao_rota)) like kss.pkg_string.fnc_string_clean(upper('#arguments.descricao_rota#%'))
                </cfif>
                <cfif Len(Trim(arguments.origem_municipio_id))>
                  	and r.origem_municipio_id = #arguments.origem_municipio_id#
                </cfif>
                <cfif Len(Trim(arguments.destino_municipio_id))>
                  	and r.destino_municipio_id = #arguments.destino_municipio_id#
                </cfif>
                <cfif Len(Trim(arguments.municipio_origem))>
                   	and kss.pkg_string.fnc_string_clean(upper(mo.municipio)) like kss.pkg_string.fnc_string_clean(upper('#arguments.municipio_origem#%'))
                </cfif>
                <cfif Len(Trim(arguments.municipio_destino))>
                   	and kss.pkg_string.fnc_string_clean(upper(md.municipio)) like kss.pkg_string.fnc_string_clean(upper('#arguments.municipio_destino#%'))
                </cfif>
                <cfif Len(Trim(arguments.referencia_origem))>
                   	and (select kss.pkg_string.fnc_string_clean(upper(re.referencia))
                           from oper.v$referencia re
                          where re.referencia_id = r.referencia_origem_id
                        ) like kss.pkg_string.fnc_string_clean(upper('#arguments.referencia_origem#%'))
                </cfif>
                <cfif Len(Trim(arguments.referencia_destino))>
                   	and (select kss.pkg_string.fnc_string_clean(upper(re.referencia))
                           from oper.v$referencia re
                          where re.referencia_id = r.referencia_destino_id
                        ) like kss.pkg_string.fnc_string_clean(upper('#arguments.referencia_destino#%'))
                </cfif>
                <cfif Len(Trim(arguments.operacao_id))>
                    and not exists (select 1
                                      from dedicado.v$local_rota lr
                                     where lr.rota_id = r.rota_id
                                       and lr.data_cancelamento is null
                                       and lr.operacao_id = #arguments.operacao_id#
                                   )
                </cfif>
                <cfif arguments.rapida eq 1>
                    and rownum = 1 
                </cfif>
			</cfif>
             order by r.descricao_rota
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Retorna as cidades cadastradas no sistema
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->	
	<cffunction name="get_cidade" displayname="Retorna as cidades cadastradas no sistema" access="remote" returntype="query" output="true">
		<cfargument name="municipio_id" required="no" />
		<cfargument name="municipio" required="no" />
		<cfargument name="pais_id" required="no" />
		<cfargument name="uf_id" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select distinct municipio_id, municipio, latitude, longitude, uf_id,
				   altitude, cep, cod_inpe, intc_cod_municipio, 
				   cep.fnc_cidade_completa(municipio_id) as descricao
			  from oper.v$municipio m 		
			 where 1=1
		    <cfif IsDefined("arguments.municipio") and Len(Trim(arguments.municipio))>
			   and upper(kss.pkg_string.fnc_string_clean(municipio)) like upper('%#arguments.municipio#%')
			</cfif>
		    <cfif IsDefined("arguments.uf_id") and Len(Trim(arguments.uf_id))>
			   and uf_id = '#arguments.uf_id#'
			</cfif>
		    <cfif IsDefined("arguments.municipio_id") and Len(Trim(arguments.municipio_id))>
			   and municipio_id = #arguments.municipio_id#
			</cfif>			
			order by municipio
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca a ultima posicao do veiculo
	-- CRISTOFER  25/10/2006
	--->		
	<cffunction name="get_posicao_atual_veiculo" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+FIRST_ROWS*/
				   latitude,
				   longitude,
				   landmark
			  from oper.v$rank_frota r
			 where placa_controle = '#arguments.placa#'
			and (r.evo_id_desengate is null or placa_referencia is null)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os itens do romaneio para redestinar
	-- CRISTOFER  25/10/2006
	--->		
	<cffunction name="get_romaneio_item_destinar" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ri.item_id,
				   ri.num_lote,
				   ri.cod_remetente,
				   rem.cnpj_cpf cnpj_remetente,
				   rem.cliente remetente,
				   rmun.municipio municipio_remetente,
				   rmun.uf_id sigla_uf_remetente,
				   r.org_complemento complemento_remetente,
				   r.org_logradouro rem_logradouro,
				   r.org_cep rem_cep,
				   r.org_bairro rem_bairro,
				   ri.rem_cod_uf,
				   ri.rem_cod_municipio,
				   ri.rem_cod_distrito,
				   ri.rem_cod_dv,
					ri.rem_municipio_id,
				   ri.cod_destinatario,
				   dest.cnpj_cpf cnpj_destinatario,
				   dest.cliente destinatario,
				   dmun.municipio municipio_destinatario,
				   dmun.uf_id sigla_uf_destinatario,
				   r.dest_complemento complemento_destinatario,
				   r.dest_logradouro dest_logradouro,
				   r.dest_cep dest_cep,
				   r.dest_bairro dest_bairro,
				   ri.dest_cod_uf,
				   ri.dest_cod_municipio,
				   ri.dest_cod_distrito,
				   ri.dest_cod_dv,
					ri.dest_municipio_id,
				   r.num_natureza,
				   r.num_especie,
				   r.cod_unidade,
				   r.frete_em,
				   ri.peso/1000 peso,
				   ri.m3,
				   ri.volume,
				   l.frete_valor_unitario valor_unitario,
				   ri.valor_frete,
				   ri.observacao,
				   ri.redespacho,
			       l.COD_PESSOA_DESTINATARIO lote_cod_destinatario,
				   man.manifesto_id,
				   man.num_manifesto,
				   ri.ordem,
				   rot.descricao_rota rota,
				   rot.abreviatura rota_abreviatura,
				   rot.rota_id,
				   rot.origem_municipio_id rota_origem,
				   rot.destino_municipio_id rota_destino,
				   rit.data_previsao,
                   l.dedicado,
                   to_char(r.data_carregado_planejado, 'dd/mm/yyyy hh24:mi') as data_carregado_planejado,
     			   to_char(r.data_vazio_planejado, 'dd/mm/yyyy hh24:mi') as data_vazio_planejado
			  from oper.v$romaneio_item ri
			 inner join oper.v$lote l
					 on ri.num_lote = l.num_lote 
			 inner join oper.v$romaneio r
					 on r.num_romaneio = ri.num_romaneio
			 inner join kss.v$pessoa rem
					 on rem.cod_pessoa = ri.cod_remetente
			 inner join cep.municipio rmun
					 on ri.rem_municipio_id = rmun.municipio_id
			 left join kss.v$pessoa dest
					 on dest.cod_pessoa = ri.cod_destinatario
			 left join cep.municipio dmun
					 on ri.rem_municipio_id  = dmun.municipio_id
			  left join oper.v$manifesto man
			         on man.roo_item_id = ri.item_id
			  left join oper.v$romaneio_itinerario rit 
			         on rit.itinerario_id = ri.itinerario_id
			  left join oper.v$rota rot
			         on rot.rota_id = rit.rota_id
			  where ri.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os itens do romaneio que pertencem a lotes internacionais
	-- GUTO 13/01/2007
	--->		
	<cffunction name="get_romaneio_item_internacional" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select ri.item_id,
				   ri.num_lote,
				   ri.cod_remetente,
				   rem.cnpj_cpf cnpj_remetente,
				   rem.cliente remetente,
				   rmun.municipio municipio_remetente,
				   rmun.uf_id sigla_uf_remetente,
				   r.org_complemento complemento_remetente,
				   r.org_logradouro rem_logradouro,
				   r.org_cep rem_cep,
				   r.org_bairro rem_bairro,
				   ri.rem_cod_uf,
				   ri.rem_cod_municipio,
				   ri.rem_cod_distrito,
				   ri.rem_cod_dv,
				 	 ri.rem_municipio_id,
				   ri.cod_destinatario,
				   dest.cnpj_cpf cnpj_destinatario,
				   dest.cliente destinatario,
				   dmun.municipio municipio_destinatario,
				   dmun.uf_id sigla_uf_destinatario,
				   r.dest_complemento complemento_destinatario,
				   r.dest_logradouro dest_logradouro,
				   r.dest_cep dest_cep,
				   r.dest_bairro dest_bairro,
				   ri.dest_cod_uf,
				   ri.dest_cod_municipio,
				   ri.dest_cod_distrito,
				   ri.dest_cod_dv,
					 ri.dest_municipio_id,
				   r.num_natureza,
				   r.num_especie,
				   r.cod_unidade,
				   r.frete_em,
				   ri.peso/1000 peso,
				   ri.m3,
				   ri.volume,
				   l.frete_valor_unitario valor_unitario,
				   ri.valor_frete,
				   ri.observacao,
				   ri.redespacho,
			       l.COD_PESSOA_DESTINATARIO lote_cod_destinatario,
				   man.manifesto_id,
				   man.num_manifesto,
				   ri.ordem,
				   rot.descricao_rota rota,
				   rot.abreviatura rota_abreviatura,
				   rot.rota_id,
				   rot.origem_municipio_id rota_origem,
				   rot.destino_municipio_id rota_destino,
				   rit.data_previsao, 
           it.itinerario_id,
           it.origem_municipio_id,
           it.destino_municipio_id,
           it.rota_id, ro.abreviatura, ro.descricao_rota
			  from oper.v$romaneio_item ri
			 inner join oper.v$lote l
					 on ri.num_lote = l.num_lote 
          and l.internacional = 1
			 inner join oper.v$romaneio r
					 on r.num_romaneio = ri.num_romaneio
			 inner join kss.v$pessoa rem
					 on rem.cod_pessoa = ri.cod_remetente
			 inner join cep.municipio rmun
					 on ri.rem_municipio_id = rmun.municipio_id
       inner join oper.v$romaneio_itinerario it
               on it.itinerario_id = ri.itinerario_id
       inner join oper.v$rota ro
               on ro.rota_id = it.rota_id
			 left join kss.v$pessoa dest
					 on dest.cod_pessoa = ri.cod_destinatario
			 left join cep.municipio dmun
					    on ri.rem_municipio_id  = dmun.municipio_id
		   left join oper.v$manifesto man
		          on man.roo_item_id = ri.item_id
			 left join oper.v$romaneio_itinerario rit 
			        on rit.itinerario_id = ri.itinerario_id
			 left join oper.v$rota rot
			        on rot.rota_id = rit.rota_id
			  where ri.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os itens do romaneio que pertencem a lotes internacionais
	-- GUTO 13/01/2007
	--->		
	<cffunction name="get_romaneio_item_subcontratado" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select ri.item_id,
				   ri.num_lote,
				   ri.cod_remetente,
				   rem.cnpj_cpf cnpj_remetente,
				   rem.cliente remetente,
				   rmun.municipio municipio_remetente,
				   rmun.uf_id sigla_uf_remetente,
				   r.org_complemento complemento_remetente,
				   r.org_logradouro rem_logradouro,
				   r.org_cep rem_cep,
				   r.org_bairro rem_bairro,
				   ri.rem_cod_uf,
				   ri.rem_cod_municipio,
				   ri.rem_cod_distrito,
				   ri.rem_cod_dv,
				 	 ri.rem_municipio_id,
				   ri.cod_destinatario,
				   dest.cnpj_cpf cnpj_destinatario,
				   dest.cliente destinatario,
				   dmun.municipio municipio_destinatario,
				   dmun.uf_id sigla_uf_destinatario,
				   r.dest_complemento complemento_destinatario,
				   r.dest_logradouro dest_logradouro,
				   r.dest_cep dest_cep,
				   r.dest_bairro dest_bairro,
				   ri.dest_cod_uf,
				   ri.dest_cod_municipio,
				   ri.dest_cod_distrito,
				   ri.dest_cod_dv,
					 ri.dest_municipio_id,
				   r.num_natureza,
				   r.num_especie,
				   r.cod_unidade,
				   r.frete_em,
				   ri.peso/1000 peso,
				   ri.m3,
				   ri.volume,
				   l.frete_valor_unitario valor_unitario,
				   ri.valor_frete,
				   ri.observacao,
				   ri.redespacho,
			       l.COD_PESSOA_DESTINATARIO lote_cod_destinatario,
				   man.manifesto_id,
				   man.num_manifesto,
				   ri.ordem,
				   rot.descricao_rota rota,
				   rot.abreviatura rota_abreviatura,
				   rot.rota_id,
				   rot.origem_municipio_id rota_origem,
				   rot.destino_municipio_id rota_destino,
				   rit.data_previsao, 
           it.itinerario_id,
           it.origem_municipio_id,
           it.destino_municipio_id,
           it.rota_id, ro.abreviatura, ro.descricao_rota
			  from oper.v$romaneio_item ri
			 inner join oper.v$lote l
					 on ri.num_lote = l.num_lote 
          and l.frete_proprio = 0
			 inner join oper.v$romaneio r
					 on r.num_romaneio = ri.num_romaneio
			 inner join kss.v$pessoa rem
					 on rem.cod_pessoa = ri.cod_remetente
			 inner join cep.municipio rmun
					 on ri.rem_municipio_id = rmun.municipio_id
       inner join oper.v$romaneio_itinerario it
               on it.itinerario_id = ri.itinerario_id
       inner join oper.v$rota ro
               on ro.rota_id = it.rota_id
			 left join kss.v$pessoa dest
					 on dest.cod_pessoa = ri.cod_destinatario
			 left join cep.municipio dmun
					    on ri.rem_municipio_id  = dmun.municipio_id
		   left join oper.v$manifesto man
		          on man.roo_item_id = ri.item_id
			 left join oper.v$romaneio_itinerario rit 
			        on rit.itinerario_id = ri.itinerario_id
			 left join oper.v$rota rot
			        on rot.rota_id = rit.rota_id
			  where ri.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados do romaneio para redestinar
	-- CRISTOFER  25/10/2006
	--->		
	<cffunction name="get_romaneio_destinar" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.NUM_ROMANEIO,
				   r.CARREGAMENTO,
				   r.destino,
				   r.REMETENTE,
				   r.DESTINATARIO,
				   r.CLIENTE,
				   r.NUM_NATUREZA,
				   r.num_especie,
				   r.cod_unidade,
				   r.frete_em,
				   r.PESO_TOTAL,
				   r.M3_TOTAL,
				   r.VOLUME_TOTAL,
				   r.frete_total VALOR_TOTAL,
				   r.ORG_CEP,
				   r.ORG_LOGRADOURO,
				   r.org_bairro,
				   r.org_complemento,
				   r.ORG_COD_UF,
				   r.org_cod_municipio,
				   r.org_cod_distrito,
				   r.org_cod_dv,
				   omun.uf_id org_sigla_uf,
				   omun.municipio org_municipio,
				   r.dest_CEP,
				   r.dest_LOGRADOURO,
				   r.dest_bairro,
				   r.dest_complemento,
				   r.dest_COD_UF,
				   r.dest_cod_municipio,
				   r.dest_cod_distrito,
				   r.dest_cod_dv,
				   dmun.uf_id dest_sigla_uf,
				   dmun.municipio dest_municipio,
				   r.OBSERVACAO
			  from oper.v$romaneio r
			 inner join cep.municipio omun
					 on omun.municipio_id = r.org_municipio_id
			 inner join cep.municipio dmun
					 on dmun.municipio_id = r.dest_municipio_id
			 where r.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os itinerarios dos romaneios
	-- GUTO  04/01/2007
	--->		
	<cffunction name="get_itinerario_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="no" default="">
		<cfargument name="vazio_carregado" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ri.itinerario_id, r.abreviatura, 
					 r.descricao_rota, r.rota_id, 
					 ri.data_previsao, ri.vazio_carregado, ri.ordem
			  from oper.v$romaneio_itinerario ri
			 inner join oper.v$rota r
						on r.rota_id = ri.rota_id
			  where 1=1
			  <cfif Len(Trim(arguments.num_romaneio))>
			  	 and ri.num_romaneio = #arguments.num_romaneio#
			  </cfif>
			  <cfif Len(Trim(arguments.vazio_carregado))>
			  	 and ri.vazio_carregado = #arguments.vazio_carregado#
			  </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os itinerarios
	-- CRISTOFER  26/10/2006
	--->		
	<cffunction name="get_itinerario" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select i.itinerario_id,
				   i.plano_id,
				   i.rota_id,
				   i.cod_pessoa,
				   i.placa_controle,
				   i.placa_referencia,
				   i.peso_tara,
				   i.capacidade_carga,
				   i.peso_liquido,
				   i.km_hodometro,
				   i.km_rota,
				   i.data_origem,
				   i.data_chegada,
				   i.data_previsao_estimado,
				   i.data_previsao_planejado,
				   i.tempo_percurso_planejado,
				   i.tempo_percurso,
				   i.potencia,
				   i.data_inicio_operacao,
				   i.data_termino_operacao,
				   i.bloquear_previsao,
				   i.vazio_carregado,
				   i.itinerario_id_anterior,
				   i.user_insert,
				   i.date_insert,
				   i.user_update,
				   i.date_update,
				   i.site,
				   i.itinerario_id_posterior,
				   p.num_romaneio,
				   p.num_romaneio,
				   r.descricao_rota,
				   r.abreviatura
			  from (select it.*, level ordem 
			          from oper.v$itinerario it
					 start with it.itinerario_id_anterior is null
					connect by prior it.itinerario_id = it.itinerario_id_anterior) i
			 inner join oper.v$plano_viagem p 
					 on p.plano_id = i.plano_id
			 inner join oper.v$rota r
					 on r.rota_id = i.rota_id					 
			 where 1=1
			 <cfif len(trim(arguments.num_romaneio))>
			   and p.num_romaneio = #arguments.num_romaneio#
			 </cfif>
			 order by ordem
--			 start with itinerario_id_anterior is null
--			connect by prior itinerario_id = itinerario_id_anterior and placa_controle = placa_controle;
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o plano de viagem
	-- CRISTOFER  26/10/2006
	--->		
	<cffunction name="get_plano_viagem" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select plano_id,
				   placa,
				   num_romaneio,
				   data_inicio,
				   data_termino,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from oper.v$plano_viagem	
			 where 1=1
			 <cfif len(trim(arguments.num_romaneio))>
			   and num_romaneio = #arguments.num_romaneio#
			 </cfif>
			 <cfif len(trim(arguments.placa))>
			   and placa = '#arguments.placa#'
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os itinerarios para o veiculo
	-- CRISTOFER  11/12/2006
	--->		
	<cffunction name="get_itinerarios_veiculo" access="remote" returntype="query" output="true">
		<cfargument name="placa_controle" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ORDERED*/i.itinerario_id,
				   roo.num_romaneio,
				   i.rota_id,
				   r.descricao_rota rota_descricao,
				   r.abreviatura rota_abreviatura,
				   rhv.cod_pessoa,
				   i.placa_referencia,
				   i.km_rota,
				   i.km_rota,
				   i.data_chegada,
				   i.data_previsao,
				   to_char(i.data_previsao,'dd/mm/yyyy hh24:mi') data_previsao_estimado_data,
				   i.vazio_carregado,
				   i.itinerario_id_anterior,
				   i.itinerario_id_posterior,
				   i.origem_municipio_id,
				   i.destino_municipio_id,
				   p.cliente motorista,
				   p.cnpj_cpf cnpj_cpf_motorista,
				   to_char(roo.data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio              
				  from oper.v$romaneio roo
		         inner join oper.v$romaneio_itinerario i
                 		 on roo.NUM_ROMANEIO = i.num_romaneio
        		 left join oper.v$romaneio_hist_veiculo rhv
                 		on rhv.NUM_ROMANEIO = roo.NUM_ROMANEIO
                	   and i.data_previsao between rhv.DATA_INICIO and nvl(rhv.DATA_TERMINO,sysdate+10)
				 inner join oper.v$rota_todas r
						 on r.rota_id = i.rota_id
			  	 inner join kss.v$pessoa p
				  	     on p.cod_pessoa = rhv.cod_pessoa
			 where 1=1
			 <cfif len(trim(arguments.placa_referencia))>
			   and (i.placa_referencia = '#arguments.placa_referencia#'
			   		or
					i.placa_referencia = oper.pkg_veiculo.fnc_get_placa('#arguments.placa_referencia#'))
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and (roo.data_inicio >= '#arguments.data_inicial#' or roo.data_inicio is null)
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and (roo.data_termino <= '#arguments.data_final#' or roo.data_termino is null)
			 </cfif>
  			order by i.itinerario_id          
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca a posio indicada pelo ultimo itinerario do veculo
	-- CRISTOFER  11/12/2006
	--->		
	
	<cffunction name="get_ultimo_itinerario" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" maxrows="1">
			select t.itinerario_id,
				   t.destino_municipio_id,
				   cep.fnc_municipio_uf(t.destino_municipio_id,' - ') municipio
			  from oper.v$romaneio_itinerario t
			 where placa_referencia = '#arguments.placa#'
			   and itinerario_id_posterior is null
			 order by itinerario_id desc	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as mensagens no integradas
	-- WAGNER  13/12/2006
	--->
			
	<cffunction name="get_msg_nao_integrada" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="NUM_MENSAGEM" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" >
             select num_mensagem, 
             		to_number(num_rastreador) num_rastreador, 
                    rastreador_id, 
                    num_erro,          
       				erro_interno, 
                    envia_mensagem, 
                    debita_motorista, 
                    conferido as conferido_id,
       				decode(conferido, 1, 'Conferido', 'No Conferido') as conferido,                                
       				to_number(num_macro) num_macro, 
                    to_number(macro_version) macro_version, 
                    to_char(data_hora,'dd/mm/yyyy hh24:mi:ss') data_hora, 
                    texto, 
       				landmark, 
                    latitude, 
                    longitude, 
                    placa_controle, 
                    placa,                                     
       				to_char(cod_funcionario) cod_funcionario, 
                    modelo_rastreador, 
                    decode(integrada,1,'Sim','No') as integrada,
       				nome_macro, 
                    modelo_rastreador as modelo_id
  			  from oper.v$controle_msg_log_erro                                 
 			 where 1=1
			<cfif Len(trim(arguments.data_inicial)) and Len(trim(arguments.data_inicial))>
			   and trunc(data_hora) between '#LSDateFormat(arguments.data_inicial)#' and '#LSDateFormat(arguments.data_final)#'
   			</cfif>
			<cfif Len(trim(arguments.PLACA))>
			   and placa = '#arguments.placa#'
   			</cfif>
			<cfif Len(trim(arguments.NUM_MENSAGEM))>
			   and num_mensagem = #arguments.NUM_MENSAGEM#
   			</cfif>
 		 order by data_hora
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as Grupos de Referencia
	-- WAGNER  15/12/2006
	--->
			
	<cffunction name="get_grupo_referencia" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" >
				 select cg.rv_meaning grupo, cg.rv_low_value id 
				   from rastreador.cg_ref_codes cg 
				  where cg.rv_domain = 'REFERENCIA_CLASSE.GRUPO' 
				  order by 1
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Referncias
	-- WAGNER  15/12/2006
	--->
			
	<cffunction name="get_referencia_grupo" access="remote" displayname="Busca Referncias" returntype="query" output="true">
		<cfargument name="grupo" required="no" default="">
		<cfargument name="referencia" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" >
				select r.referencia_id, r.referencia, r.latitude, r.longitude, 
       				   oper.pkg_coord_geografica.fnc_formata_graus(oper.pkg_coord_geografica.fnc_decimais2graus(r.latitude, 0)) graus_latitude,
					   oper.pkg_coord_geografica.fnc_formata_graus(oper.pkg_coord_geografica.fnc_decimais2graus(r.longitude, 1)) graus_longitude,
					   rc.classe, rc.grupo
  				  from rastreador.v$referencia r 
 			inner join rastreador.v$referencia_classe rc 
         			on rc.classe_id = r.classe_id 
 				 where 1=1
				<cfif Len(trim(arguments.grupo))>
				   and rc.grupo = #arguments.grupo#
				</cfif>
				<cfif Len(trim(arguments.referencia))>
				   and upper(r.referencia) like upper('%#arguments.referencia#%')
				</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Controle de Evento
	-- WAGNER  15/12/2006
	--->
			
	<cffunction name="get_controle_evo_id" access="remote" displayname="Busca Controle de Evento" returntype="query" output="true">
		<cfargument name="num_mensagem" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" >
					select emr.controle_evo_id
					  from rastreador.v$msg_retorno mr
				inner join oper.v$evento_msg_rastreador emr
						on emr.mensagem_retorno_id = mr.mensagem_id
				<cfif Len(trim(arguments.num_mensagem))>
				   where mr.num_mensagem = #arguments.num_mensagem#
				</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca tipo de mensagem
	-- WAGNER  15/12/2006
	--->
			
	<cffunction name="get_tipo_mensagem" access="remote" displayname="Busca tipo de mensagem" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" >
				select kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 13, 10) valor
				  from dual
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Motivo de erro na macro
	-- WAGNER  15/12/2006
	--->
			
	<cffunction name="get_motivo_erro_macro" access="remote" displayname="Busca motivo de erro na macro" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" >
				select motivo_id, descricao_resumida
				  from oper.v$consumo_comb_motivo 
				 where ativo = 1 
			  order by descricao_resumida 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o nro de conhecimentos vinculados ao romaneio
	-- CRISTOFER  02/01/2007
	--->		
	<cffunction name="get_conhecimentos_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select count(*) as qtde
			  from oper.v$conhecimento 
			 where num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as filiais
	-- CRISTOFER  08/08/2007
	--->		
	<cffunction name="get_filial" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select un.cod_pessoa,
                   un.unidade_negocio nome
              from kss.v$unidade_negocio un
             where 1 = 1
             <cfif len(trim(arguments.operacao_id))>
			 		and un.cod_pessoa in (select o.cod_pessoa
                    						from logistica.v$operacao_filial_emissao ofe
                                           inner join kss.v$organograma o
                                           		   on o.cod_organograma = ofe.cod_organograma                                                   
                                           where ofe.operacao_id = #arguments.operacao_id#)
             </cfif>
             order by un.unidade_negocio
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
 

	<!--- 
	-- PROPSITO 
	-- Busca as referencias
	-- CRISTOFER  22/08/2007
	--->		
	<cffunction name="get_referencia" access="remote" returntype="query" output="true">
    	<cfargument name="classe_id" required="no" default="">
        <cfargument name="municipio" required="no" default="">
        <cfargument name="referencia" required="no" default="">
        <cfargument name="referencia_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.referencia_id,
                   r.referencia,
                   r.classe_id,
                   rc.classe,
                   r.latitude,
                   r.longitude,
                   r.municipio_id,
                   cep.fnc_municipio_uf(r.municipio_id) municipio,
                   r.date_update,
                   r.user_update,
                   r.site
              from rastreador.v$referencia r
             inner join rastreador.v$referencia_classe rc
                     on r.classe_id = rc.classe_id
              left join cep.municipio m
                     on r.municipio_id = m.municipio_id
             where 1=1
             <cfif len(trim(arguments.referencia_id))>
               and r.referencia_id in (#arguments.referencia_id#)
             </cfif>
             <cfif len(trim(arguments.municipio))>
               and upper(municipio) like upper('%#arguments.municipio#%')
             </cfif>
             <cfif len(trim(arguments.classe_id))>
               and r.classe_id in (#arguments.classe_id#)
             </cfif>
             <cfif len(trim(arguments.referencia))>
               and kss.pkg_string.fnc_string_clean(upper(trim(r.referencia))) like kss.pkg_string.fnc_string_clean(upper(trim('%#arguments.referencia#%')))
             </cfif>
             order by r.referencia
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
         	
	<!--- 
	-- PROPSITO 
	-- Busca as classes de referencias
	-- CRISTOFER  22/08/2007
	--->		
	<cffunction name="get_referencia_classe" access="remote" returntype="query" output="true">
    	<cfargument name="classe" required="no" default="">
        <cfargument name="classe_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rc.classe_id,
                   rc.classe,
                   rc.grupo,
                   rc.user_insert,
                   rc.date_insert,
                   rc.user_update,
                   rc.date_update,
                   rc.site
              from rastreador.v$referencia_classe rc
             where 1=1
             <cfif len(trim(arguments.classe))>
               and kss.pkg_string.fnc_string_clean(upper(trim(rc.classe))) like kss.pkg_string.fnc_string_clean(upper(trim('%#arguments.classe#%')))
             </cfif>
             <cfif len(trim(arguments.classe_id))>
               and rc.classe_id in (#arguments.classe_id#)
             </cfif>
             order by rc.classe
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca as mensagens do veiculo
	-- WAGNER  27/08/2007
	--->
	<cffunction name="get_controle_mensagens" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="NUM_MENSAGEM" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" >
            select placa_controle, 
            	   placa, 
                   cod_funcionario, 
                   motorista, 
                   mensagem, 
                   macro, 
                   tipo_macro, 
                   tipo_macro_id, 
                   referencia, 
                   to_char(horario,'dd/mm/yyyy hh24:mi:ss') horario, 
                   num_msg, 
                   qtde_caracter, 
                   inserido_por, 
                   integrada, 
                   controle_evo_id, 
                   modelo_rastreador, 
                   to_char(data_hora,'dd/mm/yyyy hh24:mi:ss') data_hora, 
                   cod_pessoa,
                   latitude, 
                   longitude, 
                   macro_versao,
                   num_rastreador, 
                   erro_interno, 
                   alterado_por, 
                   nome_macro 
              from oper.v$controle_mensagem
             where data_hora > '05/01/2005' 
			<cfif Len(trim(arguments.data_inicial)) and Len(trim(arguments.data_inicial))>
			   and trunc(data_hora) >= '#LSDateFormat(arguments.data_inicial)#' 
            </cfif>
            <cfif Len(trim(arguments.data_final)) and Len(trim(arguments.data_final))>
               and trunc(data_hora) <= '#LSDateFormat(arguments.data_final)#'
   			</cfif>
			<cfif Len(trim(arguments.PLACA))>
			   and placa = '#arguments.placa#'
   			</cfif>
			<cfif Len(trim(arguments.NUM_MENSAGEM))>
			   and num_msg = #arguments.NUM_MENSAGEM#
   			</cfif>
            order by data_hora
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dados do rastreador para o romaneio
	-- CRISTOFER  28/08/2007
	--->		
	<cffunction name="get_romaneio_rastreador" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vhr.rastreador_id,
                   vhr.placa,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(vhr.placa) frota
              from oper.v$rank_frota rf
             inner join integracao.v$rastreador_historico_veiculo vhr
                     on vhr.placa = rf.placa_controle
                    and vhr.principal = 1
             where 1=1
             <cfif len(trim(arguments.num_romaneio))>
               and rf.num_romaneio = #arguments.num_romaneio#
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca os CRTs vinculados ao conhecimento
	-- CRISTOFER  22/11/2007
	--->		
	<cffunction name="get_romaneio_intc_conhecimento" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="">
    	<cfargument name="conhecimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rc.conhecimento_id, 
                   rc.num_romaneio, 
                   c.numero_cod_pais,
                   c.numero_certificado,
                   c.numero_sequencial,
                   lpad(c.numero_cod_pais,2,' ')||'.'||lpad(c.numero_certificado,3,'0')||'.'||lpad(c.numero_sequencial,6,'0') numero
              from oper.v$romaneio_intc_conhecimento rc
             inner join fiscal.v$intc_conhecimento c
                     on c.conhecimento_id = rc.conhecimento_id
             where 1=1
            <cfif len(trim(arguments.num_romaneio))>
               and rc.num_romaneio = #arguments.num_romaneio#
            </cfif>
            <cfif len(trim(arguments.conhecimento_id))>
               and rc.conhecimento_id = #arguments.conhecimento_id#
            </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
    -- PROPSITO
    -- Busca a posio geografica dos veiculos
    -- 13/12/2008 - criado
    --->	
    <cffunction name="get_posicao_veiculo_mapa" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="rank_frota_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rank_frota_id,
            	   placa_controle as placa,
            	   oper.pkg_veiculo.fnc_get_cod_veiculo(placa_controle) as frota_controle,
            	   placa_referencia as placa_referencia,
            	   oper.pkg_veiculo.fnc_get_cod_veiculo(placa_referencia) as frota_referencia,
            	   landmark, 
                   latitude, 
                   longitude 
              from oper.v$rank_frota 
             where rank_frota_id in (#ListQualify(arguments.rank_frota_id,"'",',')#)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


	<!--- 
    -- PROPSITO
    -- Busca a viagem vazia para o romaneio
    -- 03/02/2009 - criado
    --->	
    <cffunction name="get_romaneio_agreg_viagem_vazio" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select av.viagem_id, av.lancto_id, c.num_formulario
              from oper.v$agreg_viagem av
             left join oper.v$cfa c
                    on c.lancto_id = av.lancto_id 
             where av.viagem_id  = (select max(viagem_id) as viagem_id
                                      from oper.v$agreg_viagem
                                     where num_romaneio = #arguments.num_romaneio#
                                       and tipo_servico = 3
                                       and data_cancelamento is null)	 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os romaneios dedicados cadastrados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 10/06/2009 - ALTERADO
	--->
	<cffunction name="get_evento_operacao_dedicado" displayname="Retorna os romaneios dedicados cadastrados" output="true" returntype="query" access="remote">
		<cfargument name="controle_evo_id" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select eod.controle_evo_id,
            	   eod.num_romaneio,
                   eod.local_rota_id
              from dedicado.v$evento_operacao_dedicado eod
             where 1 = 1
			<cfif Len(Trim(arguments.controle_evo_id))>
               and eod.controle_evo_id = #arguments.controle_evo_id#
            </cfif>
			<cfif Len(Trim(arguments.num_romaneio))>
               and eod.num_romaneio = #arguments.num_romaneio#
            </cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca a posio geografica das filiais
	-- CRISTOFER  01/06/2009
	--->		
	<cffunction name="get_unidade_negocio_referencia" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select '' as cod_unidade_negocio,
            	   '' as cod_pessoa,
                   r.referencia as unidade_negocio,
                   r.referencia_id,
                   r.referencia,
                   r.latitude,
                   r.longitude
              from oper.v$referencia r
             inner join oper.v$referencia_classe c
                     on c.classe_id = r.classe_id
             where c.tipo_id = 3
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Busca a posio geografica dos veiculos de um grupo de monitoramento
    -- 13/12/2008 - criado
    --->	
    <cffunction name="get_posicao_veiculo_monitoramento" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="usuario_monitoramento" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pv.placa_controle as placa
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(pv.placa_controle) as frota_controle
                 , pv.placa_referencia as placa_referencia
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(pv.placa_referencia) as frota_referencia
                 , pv.landmark
                 , pv.latitude
                 , pv.longitude
                 , pv.operador      
              from logistica.v$plano_viagem_monitoramento pv
             where 1= 1
             <cfif Len(Trim(arguments.usuario_monitoramento))>
               and pv.operador = upper('#arguments.usuario_monitoramento#')
             </cfif>             
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
    <!--- 
    -- PROPSITO
    -- Busca os dados do rastreador de um veculo
    -- 23/02/2011 - FABIOG
    --->	
    <cffunction name="get_dados_rastreador_veiculo" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="placa" required="yes">
        <cfargument name="cod_veiculo" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.cod_veiculo as placa
                 , v.cod_frota as cod_veiculo
                 , (select kss.fnc_concat_all(kss.to_concat_expr(oper.pkg_veiculo.fnc_get_cod_veiculo(t.column_value), ' > '))
                      from table(kss.pkg_string.fnc_split(rtrim(ltrim(oper.pkg_veiculo.fnc_get_composicao(v.cod_veiculo), '|'), '|'), '|')) t
                   ) as composicao
                 , r.num_rastreador
                 , to_char(rv.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio_rastreador
                 , rc.modelo_id
                 , rm.descricao as modelo
                 , rc.conta_id
                 , rc.cod_conta
                 , (select kss.pkg_pessoa.fnc_get_cliente(vm.cod_pessoa) 
                      from oper.v$veiculo_motorista vm
                     where vm.placa = v.cod_veiculo
                       and sysdate between vm.data_inicio and nvl(vm.data_fim, sysdate)
                   ) as nome_motorista
              from integracao.v$veiculo v
             inner join integracao.v$rastreador_veiculo rv
                     on rv.veiculo_id = v.veiculo_id
                    and sysdate between rv.data_inicio and nvl(rv.data_termino, sysdate)
             inner join integracao.v$rastreador r
                     on rv.rastreador_id = r.rastreador_id
             inner join integracao.v$rastreador_conta rc
                     on rc.conta_id = r.conta_id
             inner join integracao.v$rastreador_modelo rm
                     on rm.modelo_id = rc.modelo_id
             where (v.cod_veiculo = '#arguments.placa#' or v.cod_frota = '#arguments.cod_veiculo#')
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Busca os eventos de envio de mensagem
    -- 23/02/2011 - FABIOG
    --->	
    <cffunction name="get_evento_envia_mensagem" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="conta_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select eos.num_evento
                 , eos.descricao
                 , m.macro_id
                 , m.descricao as macro
                 , m.texto
              from oper.v$evento_operacao_setup eos
             inner join integracao.v$macro_evento me
                     on me.num_evento = eos.num_evento
             inner join integracao.v$macro m
                     on m.macro_id = me.macro_id
             where m.conta_id = #arguments.conta_id#
               and m.tipo_id = 0
               and m.liberada_web = 1
             order by eos.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Busca os parmetros de uma macro
    -- 25/02/2011 - FABIOG
    --->	
    <cffunction name="get_macro_parametro" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="macro_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mp.parametro_id
                 , mp.macro_id
                 , mp.ordem
                 , mp.tipo_dado
                 , mp.descricao
                 , mp.tamanho
              from integracao.v$macro_parametro mp 
             where mp.macro_id = #arguments.macro_id#
             order by mp.ordem
        </cfquery>
        <cfreturn qr_result>
    </cffunction>                  	            	    
</cfcomponent>