<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de postos" extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere uma nota fiscal
    -- 12/01/2006 - criado
    --->
    <cffunction name="ins_nota_fiscal" displayname="Insere uma nota fiscal" access="remote" returntype="Struct" output="true">
        <cfargument name="COD_PESSOA_POSTO" required="yes">
        <cfargument name="COD_PESSOA_FILIAL" required="yes">
        <cfargument name="COD_CENTRO_CUSTO_FILIAL" required="yes">
        <cfargument name="NUM_NOTA_FISCAL" required="yes">
        <cfargument name="SERIE" required="yes">
        <cfargument name="DATA_EMISSAO" required="yes">
        <cfargument name="BASE_ICMS" required="yes">
        <cfargument name="VALOR_ICMS" required="no" default="0">
        <cfargument name="BASE_ICMS_SUBST" required="no" default="0">
        <cfargument name="VALOR_ICMS_SUBST" required="no" default="0">
        <cfargument name="VALOR_TOTAL_PRODUTOS" required="no" default="0">
        <cfargument name="VALOR_FRETE" required="no" default="0">
        <cfargument name="VALOR_SEGURO" required="no" default="0">
        <cfargument name="OUTRAS_DESPESAS" required="no" default="0">
        <cfargument name="VALOR_TOTAL_IPI" required="no" default="0">
        <cfargument name="VALOR_TOTAL_NOTA" required="yes">
        <cfargument name="NOTA_SEM_CUPOM" required="no" default="0">
        <cfargument name="DATA_INICIAL" required="no" default="">
        <cfargument name="DATA_FINAL" required="no" default="">
       <cfdump var="#arguments#">
        <cfset arguments.valor_total_nota = 0>
        <cftry>
            <cftransaction action="begin">
                <cfstoredproc procedure="oper.pkg_posto.prc_ins_nota_fiscal" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA_POSTO" value="#arguments.COD_PESSOA_POSTO#" null="#iif(len(trim(arguments.COD_PESSOA_POSTO)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA_FILIAL" value="#arguments.COD_PESSOA_FILIAL#" null="#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_CENTRO_CUSTO_FILIAL" value="#arguments.COD_CENTRO_CUSTO_FILIAL#" null="#iif(len(trim(arguments.COD_CENTRO_CUSTO_FILIAL)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_NOTA_FISCAL" value="#arguments.NUM_NOTA_FISCAL#" null="#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#" >
                    <cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="P_NUM_NOTA_ID" variable="retorno.NUM_NOTA_REMESSA"  >
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_SERIE" value="#arguments.SERIE#"  >
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_EMISSAO" value="#arguments.DATA_EMISSAO#"  >
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_ENTRADA" value="#arguments.DATA_EMISSAO#"  >
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_BASE_CALC_ICMS" value="0" null="#iif(len(trim(arguments.BASE_ICMS)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_VALOR_ICMS" value="0" null="#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_BASE_ICMS_SUBST" value="0" null="#iif(len(trim(arguments.BASE_ICMS_SUBST)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_VALOR_ICMS_SUBST" value="0" null="#iif(len(trim(arguments.VALOR_ICMS_SUBST)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_VALOR_TOTAL_PRODUTOS" value="0" null="#iif(len(trim(arguments.VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_VALOR_FRETE" value="0" null="#iif(len(trim(arguments.VALOR_FRETE)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_VALOR_SEGURO" value="0" null="#iif(len(trim(arguments.VALOR_SEGURO)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_OUTRAS_DESPESAS" value="0" null="#iif(len(trim(arguments.OUTRAS_DESPESAS)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_VALOR_TOTAL_IPI" value="0" null="#iif(len(trim(arguments.VALOR_TOTAL_IPI)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_VALOR_TOTAL_NOTA" value="0" null="#iif(len(trim(arguments.VALOR_TOTAL_NOTA)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COD_CONTABIL" null="yes">
                    <cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="P_NATUREZA_ID" value="3">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NATUREZA_DESCRICAO"  value="Nota Fiscal de Terceiro">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_DESCONTO" value="0" >
                    <cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" variable="retorno.ROWID"  >
                </cfstoredproc>
                <cfscript>
                    v_quantidade = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_PRODUTOS");
                    v_valor_unitario = this.ListaToArray (lista = arguments, variavel = "VALOR_UNITARIO_PRODUTOS");
                    v_valor_total = this.ListaToArray (lista = arguments, variavel = "VALOR_TOTAL_PRODUTOS");
                    v_produto_id = this.ListaToArray (lista = arguments, variavel = "PRODUTO_ID_PRODUTOS");
                    v_cod_unidade = this.ListaToArray (lista = arguments, variavel = "COD_UNIDADE_PRODUTOS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_valor_unitario)#" index="item">
                    <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_posto.prc_ins_nota_fiscal_itens" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam type="in" 		dbvarname="p_num_nota_id" 	cfsqltype="cf_sql_integer" 	value="#retorno.num_nota_remessa#">
                        <cfprocparam type="in" 		dbvarname="p_data_hora" 		cfsqltype="cf_sql_varchar" 	value="#arguments.data_emissao#">
                        <cfprocparam type="in" 		dbvarname="p_cod_pessoa_posto" 	cfsqltype="cf_sql_integer" 	value="#arguments.cod_pessoa#">
                        <cfprocparam type="in" 		dbvarname="p_quantidade" 		cfsqltype="cf_sql_numeric" scale="5" 	value="#v_quantidade[item]#">
                        <cfprocparam type="in" 		dbvarname="p_valor_unitario" 	cfsqltype="cf_sql_numeric" scale="5" 	value="#v_valor_unitario[item]#">
                        <cfprocparam type="in" 		dbvarname="p_valor_total" 		cfsqltype="cf_sql_numeric" scale="5" 	value="#v_valor_total[item]#">
                        <cfprocparam type="in" 		dbvarname="p_desconto_percentual" cfsqltype="cf_sql_numeric" scale="5" 	value="0">
    
                        <cfprocparam type="in" 		dbvarname="p_produto_id" 		cfsqltype="cf_sql_integer" 	value="#v_produto_id[item]#">
                        <cfprocparam type="in" 		dbvarname="p_cod_unidade" 		cfsqltype="cf_sql_varchar" 	value="#v_cod_unidade[item]#">
                        <cfprocparam type="in" 		dbvarname="p_nota_sem_cupom" 	cfsqltype="cf_sql_integer" 	value="#arguments.nota_sem_cupom#">
                        <cfprocparam type="in" 		dbvarname="p_placa" 			cfsqltype="cf_sql_varchar" 	value="#UCase(Replace(arguments.placa, '-', '', 'ALL'))#">
                        <cfprocparam type="inout" 	dbvarname="p_km" 				cfsqltype="cf_sql_integer" 	value="#arguments.km#" variable="retorno.km">
                        <cfprocparam type="in"      dbvarname="p_valor_desconto"    cfsqltype="cf_sql_integer"  value="0">
                        <cfprocparam type="out" 	cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" variable="retorno.ROWID"  >
                    </cfstoredproc>
                </cfloop>
                
                <cfscript>
                    set_vinculo = this.vincula_cupons_nota(	num_nota_remessa = retorno.num_nota_remessa,
                                                            data_inicial     = arguments.data_inicial,
                                                            data_final       = arguments.data_final);
                </cfscript>
                
                <cfif set_vinculo.erro>
                   <cfthrow object="#set_vinculo.mensagem#">
                </cfif>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("Nota inserida com sucesso.")>
            </cftransaction>
            <cfcatch>
                <cftransaction action="rollback"/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Vincula os cupons do periodo a nota fiscal
    -- CRISTOFER  13/01/2006
    --->
    <cffunction name="vincula_cupons_nota" returntype="struct" access="remote">
        <cfargument name="num_nota_remessa" required="yes">
        <cfargument name="data_inicial" required="yes">
        <cfargument name="data_final" required="yes">
        <cftry>
            <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_posto.prc_vincula_nota_cupons" username="#session.usuario#" password="#session.senha#">
                <cfprocparam type="in" dbvarname="p_num_nota_remessa" cfsqltype="cf_sql_integer" value="#arguments.num_nota_remessa#">
                <cfprocparam type="in" dbvarname="p_cod_pessoa_posto" cfsqltype="cf_sql_integer" value="#session.cod_pessoa_usuario#">
                <cfprocparam type="in" dbvarname="p_data_inicio" cfsqltype="cf_sql_varchar" value="#arguments.data_inicial#">
                <cfprocparam type="in" dbvarname="p_data_fim" cfsqltype="cf_sql_varchar" value="#arguments.data_final#">
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = 'Ok'>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno>	
    </cffunction>	
    
    <!--- 
    -- PROPSITO 
    -- Insere cupom fiscal
    -- CRISTOFER  13/01/2006
    --->
    <cffunction name="ins_cupons" displayname="Insere cupom fiscal" access="remote" returntype="struct">
        <cfargument name="num_cupom_fiscal" required="yes">
        <cfargument name="produto" required="yes">
        <cfargument name="placa" required="yes">
        <cfargument name="km_veiculo" required="yes">
        <cfargument name="data_hora" required="yes">
        <cfargument name="quantidade" required="yes">
        <cfargument name="valor_total" required="yes">
        <cfargument name="cod_pessoa" required="yes">
        <cfargument name="controle_id" required="yes">
        <cftry>
            <cfstoredproc procedure='oper.pkg_abastecimento.prc_confirma_abastecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTROLE_ID'  			value='#arguments.CONTROLE_ID#' variable='retorno.CONTROLE_ID'  null="#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_POSTO'  	value='#session.COD_PESSOA_USUARIO#'  null="#iif(len(trim(session.COD_PESSOA_USUARIO)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_MOTORISTA'  null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_DATA_HORA'  			value='#arguments.DATA_HORA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_CUPOM_FISCAL'  	value='#arguments.NUM_CUPOM_FISCAL#'  null="#iif(len(trim(arguments.NUM_CUPOM_FISCAL)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_NOTA_ID'  			null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_PLACA'  				value='#UCase(replace(arguments.placa, '-', '', 'ALL'))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_KM'  					value="#arguments.km_veiculo#" null="#iif(len(trim(arguments.km_veiculo)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_PRODUTO_ID'  			value='#arguments.PRODUTO#'  null="#iif(len(trim(arguments.PRODUTO)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_QUANTIDADE'  			value='#arguments.QUANTIDADE#'  null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_LANCTO_CRT_ID'  		null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_UNITARIO'  		value='#arguments.VALOR_UNITARIO#'  null="#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_TOTAL'  			value='#arguments.VALOR_TOTAL#'  null="#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ALIQUOTA_ICMS'  		null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_REQUISICAO'  		null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ESTOQUE_ID'  			null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONFERIDO'  			null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_BOMBA_ID'  			null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ENCHEU'  				null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_TIPO_ENTRADA'  		value='1'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTADOR_INICIAL'  	null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTADOR_FINAL'  		null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_LANCTO_CAIXA_INTC_ID'  null='yes'>
            </cfstoredproc>
        
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = 'Lanamento inserido com sucesso.'>
        <cfcatch>
            <cftransaction action="rollback"/>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>
    
    <!--- 
-- PROPSITO 
-- Exclui cupom fiscal
-- CRISTOFER  13/01/2006
--->
<cffunction name="del_cupons" displayname="Exclui cupom fiscal" access="remote" returntype="struct">
	<cfargument name="controle_id" required="yes">
	<cftry>
		<cfstoredproc procedure="oper.pkg_abastecimento.prc_del_abastecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONTROLE_ID" value="#arguments.CONTROLE_ID#" null="#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_MOTIVO_ID" value="Excludo pelo posto">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_TIPO_ENTRADA" value="1">
		</cfstoredproc>
		<cfset retorno.erro = false>
		<cfset retorno.mensagem = 'Lanamento excluido com sucesso.'>
	<cfcatch>
		<cftransaction action="rollback"/>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cfset request.erro = cfcatch>
	</cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>
</cfcomponent>