<cfcomponent displayname="Componentes de Veculos"
		     hint="<b>KM&M  de Engenharia de Sistemas</b><br>
				   <b>Autor					: Guto ( guto@kmm.com.br )</b><br>
				   <b>Data Criao</b> 		: 07/12/2004<br> 
				   <b>Atualizador			: </b><br>
				   <b>Data Atualizao</b> 	: <br> 
				   <b>Descrio				: </b><br> <div align='justify'>Componente de consultas sobre veculos.</div>"
		     extends="_transportes.funcoes.cfc_init">
   		
	
	<!--- 
	-- PROPSITO
	-- Retorna a relao de veiculos ativos na data
	-- NOTAS EXPLICATIVAS
	-- 13/01/2006 - criado
	--->
	<cffunction name="get_veiculos_ativos" access="remote" returntype="query" output="true">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_veiculos" username="#session.usuario#" password="#session.senha#">
            select decode(vl.empresa, 1, 'Frota', 'agregado') as proprietario
                 , vl.placa
                 , vl.marca
                 , vl.modelo
              from (select (substr(v.placa, 1, 3) || '-' || substr(v.placa, 4, 7)) as placa
                         , vm.marca
                         , vmod.modelo
                         , vfg.empresa
                      from (select vt.tipo_carroceria_id as tipo_id
                                 , vt.descricao as tipo
                                 , vc.articulado as articulado
                              from oper.v$veiculo_tipo_carroceria vt
                             inner join oper.v$veiculo_agrupamento vc
                                     on vt.agrupamento_id = vc.agrupamento_id
                             where vc.tracao = 1
                               and vc.controla = 1) vt
                     inner join oper.v$veiculo_dados v
                             on v.tipo_carroceria_id = vt.tipo_id
                     inner join oper.v$veiculo_marca vm
                             on vm.marca_id = v.marca_id
                     inner join oper.v$veiculo_modelo vmod
                             on vmod.marca_id = v.marca_id
                            and vmod.modelo_id = v.modelo_id
                     inner join oper.v$veiculo_frota_geral vfg
                             on vfg.placa = v.placa
                     where v.situacao_id = 1
                     order by vm.marca, vmod.modelo) vl
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and replace(upper(vl.placa), '-', '') = replace(upper('#arguments.placa#'), '-', '')
            </cfif>
			<cfif Len(Trim(arguments.cod_veiculo))>
               and upper(vl.cod_veiculo) like upper('#arguments.cod_veiculo#%')
            </cfif>
  		</cfquery>	
		<cfreturn qr_veiculos>
	</cffunction>
	
    
</cfcomponent>