<!-- KM&M Componentes -->
<cfcomponent extends="_transportes.funcoes.cfc_init">
		
	<!--- 
	-- PROPSITO 
	-- Busca dados do posto
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/01/2006
	--->
	<cffunction name="get_dados_posto" displayname="Busca dados do posto" access="remote" returntype="query">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery name="qrDadosPosto" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct p.cupom_fiscal, 
				   pj.cod_pessoa, 
				   nvl(pj.cnpj_basico,0) as posto, 
				   pe.uf
			  from kss.pessoa_juridica pj   
          inner join kss.pessoa_endereco pe
                  on pe.cod_pessoa = pj.cod_pessoa
			  left outer join oper.v$posto p 
				on pj.cod_pessoa = p.cod_pessoa
			 where p.cod_pessoa = #arguments.cod_pessoa#
		</cfquery>	
		<cfreturn qrDadosPosto>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca vales trocados no dia
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  10/01/2004
	--->		
	<cffunction name="get_vales" displayname="Busca vales trocados no dia" access="remote" returntype="query">
		<cfquery name="qr_vales" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			SELECT v.num_vale, v.valor, v.date_update as data_envio
			  FROM oper.v$vale v, oper.v$kss_controle c  
			 WHERE situacao_id = 4               
			   AND trunc(v.date_update) = trunc(sysdate)          
			   AND v.cod_pessoa_troca = c.cod_pessoa    
			   and v.user_update = c.usuario 
			 ORDER BY data_envio desc
		</cfquery>
		<cfreturn qr_vales>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca cupons
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/01/2004
	--->
	<cffunction name="get_cupons" displayname="Busca cupons" output="true" access="remote" returntype="query">
		<cfargument name="cod_pessoa" required="yes">
        <cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="situacao" required="no" default="">
		<cfargument name="ultimos_lancados" required="no" default="0">
		<cfif not Len(Trim(arguments.data_inicial))>
			<cfquery datasource="#session.dsn#" name="qr_cupons" username="#session.usuario#" password="#session.senha#">
            	select /*+LEADING(PL)*/ pp.descricao as produto,
                       pl.controle_id,
                       pl.num_cupom_fiscal,
                       (substr(pl.placa_veiculo, 1, 3) || '-' ||
                       substr(pl.placa_veiculo, 4, 7)) as placa_veiculo,
                       pl.km_veiculo,
                       trunc(pl.data_hora) as data,
                       to_char(pl.data_hora, 'hh24:mi') as hora,
                       pl.quantidade,
                       pl.valor_unitario,
                       pl.valor_total,
                       u.unidade,
                       pp.cod_unidade,
                       pl.aliquota_icms,
                       pl.produto_id
                  from (select pl.cod_pessoa_posto,
                               pl.num_nota_id,
                               pl.produto_id,
                               pl.controle_id,
                               pl.num_cupom_fiscal,
                               pl.placa as placa_veiculo,
                               pl.km as km_veiculo,
                               pl.data_hora,
                               pl.quantidade,
                               pl.valor_unitario,
                               pl.valor_total,
                               pl.aliquota_icms,
                               pl.data_confirmacao
                          from oper.v$abastecimento pl
                         where pl.cod_pessoa_posto = #arguments.cod_pessoa#
                           and pl.data_confirmacao is not null
                           and pl.num_nota_id is null
                         order by data_hora desc
                       ) pl,
                       fiscal.v$unidade_medida u,
                       oper.v$posto_produto pp
                 where pl.produto_id = pp.produto_id
                   and u.cod_unidade = pp.cod_unidade
                   and pl.produto_id = pp.produto_id
			</cfquery>
		<cfelse>		
			<cfquery datasource="#session.dsn#" name="qr_cupons" username="#session.usuario#" password="#session.senha#">
            	select /*+INDEX(PL IDX_ABST_02)*/
                       (substr(pl.placa, 1, 3) || '-' || substr(pl.placa, 4, 7)) as placa_veiculo,
                       pl.km as km_veiculo,
                       trunc(pl.data_hora) as data,
                       to_char(pl.data_hora, 'hh24:mi') as hora,
                       pl.num_cupom_fiscal,
                       pl.quantidade,
                       pl.valor_unitario,
                       pl.valor_total,
                       p.descricao as produto,
                       pp.cod_unidade,
                       pp.produto_id
                  from oper.v$abastecimento pl
                  left join fiscal.v$produto p
                         on p.produto_id = pl.produto_id
                  left join oper.v$posto_produto pp
                         on pp.produto_id = pl.produto_id
                 where pl.cod_pessoa_posto = #arguments.cod_pessoa#
                   and pl.data_confirmacao is not null
                   and pl.data_hora between to_date('#arguments.data_inicial#', 'dd/mm/yyyy hh24:mi') and to_date('#arguments.data_final#', 'dd/mm/yyyy hh24:mi')
				<cfif Len(Trim(arguments.situacao)) and arguments.situacao eq 0>
                   and pl.num_nota_id is null
                </cfif>
                 order by pl.num_cupom_fiscal
			</cfquery>
		</cfif>
		<cfreturn qr_cupons>
	</cffunction>
   
   <!--- 
	-- PROPSITO 
	-- Busca os itens da nota para o faturamento dos cupons
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/02/2006
	--->
	<cffunction name="get_itens_nota" displayname="Busca notas fiscais" access="remote" returntype="query">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfargument name="situacao" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_notas" username="#session.usuario#" password="#session.senha#">
			 select /*+INDEX(PL IDX_ABST_02)*/
			 		sum(pl.quantidade) as quantidade,
				    avg(pl.valor_unitario) as valor_unitario,
				    sum(pl.valor_total) as valor_total,
				    pl.produto_id, p.cod_unidade
               from oper.v$abastecimento pl
			  inner join fiscal.v$produto p
					  on p.produto_id = pl.produto_id
			  where pl.cod_pessoa_posto = #arguments.cod_pessoa#
			    and trunc(pl.data_hora) between '#arguments.DATA_INICIAL#' and '#arguments.DATA_FINAL#'
				and pl.data_confirmacao is not null
			  group by pl.produto_id, p.cod_unidade
		
		</cfquery>
		<cfreturn qr_notas>
	</cffunction>
   
   
   
   <!--- 
	-- PROPSITO 
	-- Autentica o abastecimento conforme regras do banco.
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/01/2004
	--->
	<cffunction name="autentica_abastecimento" displayname="Autentica o abastecimento conforme regras do banco." access="remote" returntype="struct">
		<cfargument name="data_hora" required="yes">
		<cfargument name="placa" required="yes">
		<cfargument name="produto" required="yes">
		<cfargument name="quantidade" required="yes">
		<cfargument name="km" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cftry>
			<cftransaction action="begin">
			<cfquery datasource="#session.dsn#" name="qrDataLimite" username="#session.usuario#" password="#session.senha#">
				SELECT sysdate - oper.pkg_global.fnc_get_parametro(8,'ABASTECIMENTO') as data_limite,
						to_date('#arguments.DATA_HORA#','dd/mm/yyyy hh24:mi') as data
				  FROM dual
			</cfquery>
			<cfquery datasource="#session.dsn#" name="qrCod_Pessoa_Motorista" username="#session.usuario#" password="#session.senha#">
				SELECT oper.pkg_motorista.fnc_motorista_veiculo('#arguments.PLACA#','#LSDateFormat(arguments.data_hora,'dd/mm/yyyy')#') as cod_pessoa_motorista
				  FROM dual
			</cfquery>
		
			<cfif DateCompare(qrDataLimite.data,qrDataLimite.data_limite) eq -1>
				<cfset retorno.mensagem = "Data deve ser superior a data limite para lanamento que : "& DateFormat(qrDataLimite.data_limite,'dd/mm/yyyy')& " " &TimeFormat(qrDataLimite.data_limite,'HH:mm')& DateFormat(qrDataLimite.data,'dd/mm/yyyy')& " " &TimeFormat(qrDataLimite.data,'HH:mm')>
				<cfthrow errorcode="20000" detail="Data deve ser superior a data limite para lanamento." >
			<cfelse>
				<cfset retorno.mensagem = "OK">
			</cfif> 
         <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_abastecimento.prc_autentica_abastecimento" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="P_COD_PESSOA_POSTO" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_motorista" cfsqltype="cf_sql_integer" value="#qrCod_Pessoa_Motorista.cod_pessoa_motorista#">
				<cfprocparam type="in" dbvarname="P_PLACA" cfsqltype="cf_sql_varchar" value="#arguments.PLACA#">
				<cfprocparam type="inout" dbvarname="P_KM" cfsqltype="cf_sql_integer" value="#arguments.KM#" variable="retorno.km">
				<cfprocparam type="in" dbvarname="P_PRODUTO_ID" cfsqltype="cf_sql_integer" value="#arguments.PRODUTO#">
				<cfprocparam type="in" dbvarname="P_QUANTIDADE" cfsqltype="cf_sql_numeric" scale="5" value="#arguments.QUANTIDADE#">
				<cfprocparam type="in" dbvarname="p_data_hora" cfsqltype="cf_sql_varchar" value="#arguments.data_hora#">
				<cfprocparam type="in" dbvarname="P_ENCHEU" cfsqltype="cf_sql_numeric" scale="5" value="0">
				<cfprocparam type="out" dbvarname="P_CONTROLE_ID" cfsqltype="cf_sql_integer" variable="retorno.CONTROLE_ID">					
				<cfprocparam type="out" dbvarname="P_AUTENTICADO" cfsqltype="cf_sql_integer" variable="retorno.AUTENTICADO">					
				<cfprocparam type="out" dbvarname="P_NAO_AUTENTICAO_MOTIVO" cfsqltype="cf_sql_varchar" variable="retorno.NAO_AUTENTICAO_MOTIVO">
                <cfprocparam type="out" dbvarname="P_ENCONTROU_ABAST" cfsqltype="cf_sql_integer" variable="retorno.ENCONTROU_ABAST">					
			</cfstoredproc>
			<cfset retorno.erro = false>						
			</cftransaction>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca itens da nota fiscal
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/01/2004
	--->	
	<cffunction name="get_nota_itens" displayname="Busca itens da nota fiscal" access="remote" returntype="query">
		<cfargument name="num_nota_remessa" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_nota" username="#session.usuario#" password="#session.senha#">
            select ni.descricao,
                   u.unidade,
                   ni.qtde_volume as quantidade,
                   round(valor_unitario, 3) as valor_unitario,
                   valor_total
              from fiscal.v$nf_terceiro_it nf
             inner join fiscal.v$nf_item ni on ni.num_nota_it_id = nf.num_nota_it_id
             inner join fiscal.v$unidade_medida u on ni.cod_unidade = u.cod_unidade
             where nf.num_nota_id = #arguments.num_nota_remessa#
		</cfquery>
		<cfreturn qr_nota>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca produtos autorizados para compra nos postos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/01/2004
	--->	
	<cffunction name="get_produtos" displayname="Busca produtos autorizados para compra nos postos" access="remote" returntype="query">
		<cfargument name="data_hora"	required="yes">
		<cfargument name="cod_pessoa" 	required="yes">
		<cfquery name="qr_produtos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			SELECT php.produto_id
                 , substr(p.descricao,1,20) as produto
                 , p.descricao as prod_status
                 , u.unidade
                 , u.cod_unidade
                 , php.preco as preco
                 , php.preco_agregado as preco_agregado
                 , php.preco_terceiro as preco_terceiro
			  from oper.v$posto_historico_produto ph, 
				   oper.v$posto_historico_produto_prec php, 
				   fiscal.v$unidade_medida u, 
				   oper.v$posto_produto p  
			 where php.cod_pessoa = #arguments.cod_pessoa#
			   and ph.cod_pessoa = php.cod_pessoa
			   and ph.produto_id = php.produto_id               
			   and ph.produto_id = p.produto_id               
			   and php.data_vigencia = ph.data_vigencia               
			   and ph.autorizado = 1               
			   and u.cod_unidade = p.cod_unidade 
			   and p.servico = 0
			   and php.data_vigencia = (select max(ph2.data_vigencia)  
										  FROM oper.v$posto_historico_produto ph2  
										 WHERE ph2.cod_pessoa = php.cod_pessoa
										   and ph2.data_vigencia <= to_date('#arguments.DATA_HORA#','dd/mm/yyyy hh24:mi')
										   and ph2.produto_id = php.produto_id )               
		</cfquery>
		<cfreturn qr_produtos>		
	</cffunction>

    <!--- 
	-- PROPSITO 
	-- Busca dados da nota fiscal
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/01/2004
	--->	
	<cffunction name="get_nota" displayname="Busca dados da nota fiscal" access="remote" returntype="query">
		<cfargument name="num_nota_remessa" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_nota" username="#session.usuario#" password="#session.senha#">
			select num_nota_id as num_nota_remessa
                 , num_nota_fiscal
                 , data_emissao
                 , calc_valor_icms as valor_icms
                 , calc_valor_total_nota as valor_total_icms
                 , calc_base_icms as base_calculo_icms
			  from fiscal.v$nf_terceiro
			 where num_nota_id = #arguments.num_nota_remessa#
		</cfquery>
		<cfreturn qr_nota>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca data limite para lanamentos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/01/2004
	--->
	<cffunction name="get_data_limite" displayname="Busca data limite para lanamentos" access="remote" returntype="string">
		<cfquery datasource="#session.dsn#" name="qr_data_limite" username="#session.usuario#" password="#session.senha#">
			SELECT sysdate - oper.pkg_global.fnc_get_parametro(8,'ABASTECIMENTO') as data_limite
			  FROM dual
		</cfquery>
		<cfreturn qr_data_limite.data_limite>
	</cffunction>

    <!--- 
	-- PROPSITO 
	-- Busca os Dados do Posto
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 23/02/2010
	--->	
	<cffunction name="get_posto_dados" displayname="Busca os Dados do Posto" access="remote" returntype="query">
		<cfargument name="cod_pessoa_posto" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_postos" username="#session.usuario#" password="#session.senha#">
            select pnf.cod_pessoa_filial
                 , (select kss.pkg_global.fnc_parametro_num(11, 'OPERACIONAL', 14, 30)
                      from dual) as cod_centro_custo
              from oper.v$posto_filial_nf pnf
             where pnf.cod_pessoa_posto = #arguments.cod_pessoa_posto#
		</cfquery>
		<cfreturn qr_postos>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca a Modalidade do Veculo
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 23/02/2010
	--->	
	<cffunction name="get_veiculo_modalidade" displayname="Busca a Modalidade do Veculo" access="remote" returntype="query">
		<cfargument name="data_hora" required="yes">
		<cfargument name="placa" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_postos" username="#session.usuario#" password="#session.senha#">
            select oper.pkg_veiculo.fnc_veiculo_modalidade('#arguments.placa#','#LSDateFormat(arguments.data_hora,'dd/mm/yyyy')#') as modalidade
              from dual
		</cfquery>
		<cfreturn qr_postos>
	</cffunction>
</cfcomponent>