<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- VERIFICA O NVEL DE ACESSO DO USURIO EM DETERMINADO MDULO
	-- LEOPOLDOS 23/04/2010
	--->			
	<cffunction name="get_modulo_usuario_movel" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
        <cfargument name="cod_modulo" required="yes">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  select dbms_xmlgen.getxml(
                 'select u.modulo_id
                       , u.usuario
                       , u.nivel_acesso
                       , n.descricao as nivel
                       , (select distinct f.num_matricula
                            from kss.v$kss_usuarios ku
                            left join kss.v$funcionario_matr_atual f
                              on f.cod_pessoa = ku.cod_pessoa
                           where ku.usuario = u.usuario
                             and rownum = 1) as cod_funcionario
                    from acesso.v$modulo_usuario u
                   inner join acesso.v$nivel_acesso n
                      on n.nivel_acesso = u.nivel_acesso
                   inner join acesso.v$modulo m
                      on m.modulo_id = u.modulo_id
                   where 1=1 
                     and m.cod_modulo = '  || chr(39) || upper('#arguments.cod_modulo#')  || chr(39) ||'
                     and u.usuario = '  || chr(39) || upper('#session.usuario#')  || chr(39) ||'') as resultado 
                from dual
		</cfquery>
		<cfreturn qr />
	</cffunction>	
    
    <!--- 
    -- PROPSITO 
    -- Retorna Plataformas
    -- LEOPOLDOS 28/04/2010 - CRIADO
    --->		
    <cffunction name="get_plataforma" access="remote" returntype="query" output="true">
        <cfargument name="NOME" required="yes">
        <cfargument name="EXTENSAO_INSTALADOR" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select *
              from movel.v$plataforma p
             where 1=1 
             <cfif Len(Trim(arguments.NOME))>
	           and upper(p.nome) like upper('%#arguments.NOME#%') 
             </cfif>
             <cfif Len(Trim(arguments.EXTENSAO_INSTALADOR))>
               and upper(p.extensao_instalador) like upper('%#arguments.EXTENSAO_INSTALADOR#%')
             </cfif>
             order by p.nome ASC
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna Aplicativos
    -- LEOPOLDOS 29/04/2010 - CRIADO
    --->		
    <cffunction name="get_aplicativo" access="remote" returntype="query" output="true">
        <cfargument name="NOME" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select *
              from movel.v$aplicativo a
             where 1=1 
             <cfif Len(Trim(arguments.NOME))>
              and upper(a.nome) like upper('%#arguments.NOME#%')
             </cfif>
             order by a.nome ASC
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna Verses
    -- LEOPOLDOS 29/04/2010 - CRIADO
    --->		
    <cffunction name="get_aplicativo_versao" access="remote" returntype="query" output="true">
        <cfargument name="VERSAO" required="yes">
        <cfargument name="PLATAFORMA_ID" required="yes">
        <cfargument name="APLICATIVO_ID" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select av.versao_id as versao_id
                 , av.plataforma_id
                 , av.aplicativo_id
                 , av.versao
                 , a.nome as aplicativo
                 , p.nome as plataforma
              from movel.v$aplicativo_versao av
             inner join movel.v$aplicativo a
                on a.aplicativo_id = av.aplicativo_id
             inner join movel.v$plataforma p
                on av.plataforma_id = p.plataforma_id
             where 1=1 
             <cfif Len(Trim(arguments.VERSAO))>
              and upper(av.versao) like upper('%#arguments.VERSAO#%')
             </cfif>
             <cfif Len(Trim(arguments.PLATAFORMA_ID))>
              and av.plataforma_id = #arguments.PLATAFORMA_ID#
             </cfif>
             <cfif Len(Trim(arguments.APLICATIVO_ID))>
              and av.aplicativo_id = #arguments.APLICATIVO_ID#
             </cfif>
             order by av.versao_id ASC
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna Verses na base do Cliente
    -- LEOPOLDOS 29/04/2010 - CRIADO
    --->		
    <cffunction name="get_aplicativo_versao_cliente" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select av.versao_id as versao_id 
                 , av.plataforma_id 
                 , av.aplicativo_id 
                 , av.versao 
                 , av.aplicativo_nome as aplicativo 
                 , av.plataforma_nome as plataforma
              from movel.v$aplicativo_versao av 
             order by av.versao_id ASC
        </cfquery>
        <cfreturn qr_result>
    </cffunction>		
            
	 <!--- 
    -- PROPSITO 
    -- Retorna Arquivo de Instalao
    -- LEOPOLDOS 29/04/2010 - CRIADO
    --->		
    <cffunction name="get_aplicativo_versao_instalador" access="remote" returntype="query" output="true">
        <cfargument name="VERSAO_ID" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select av.versao_id
                 , av.arq_instalador
                 , p.extensao_instalador ext
                 , a.nome nome
              from movel.v$aplicativo_versao av
             inner join movel.v$aplicativo a
                on av.aplicativo_id = a.aplicativo_id
             inner join movel.v$plataforma p
                on av.plataforma_id = p.plataforma_id
             where 1=1 
               and av.versao_id = #arguments.VERSAO_ID#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
   <!--- 
    -- PROPSITO 
    -- Retorna Aparelho
    -- LEOPOLDOS 29/04/2010 - CRIADO
    --->		
    <cffunction name="get_aparelho" access="remote" returntype="query" output="true">
        <cfargument name="DESCRICAO" required="yes">
        <cfargument name="VERSAO_ID" required="yes">
        <cfargument name="CONFIG_ID" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select a.aparelho_id
                 , a.token
                 , a.cod_identificador
                 , to_char(a.data_ativacao, 'dd/mm/yyyy') as data_ativacao
                 , to_char(a.data_ultima_atualizacao, 'dd/mm/yyyy') as data_ultima_atualizacao
                 , a.descricao
                 , ap.nome as aplicativo
                 , c.nome as cliente
                 , cfc.url_requisicao as url
                 , av.versao as versao
                 , a.versao_id
                 , a.config_id
                 , p.nome plataforma
              from movel.v$aparelho a
             inner join movel.v$aplicativo_versao av
                on a.versao_id = av.versao_id
             inner join movel.v$aplicativo ap
                on av.aplicativo_id = ap.aplicativo_id
             inner join movel.v$configuracao_cliente cfc
                on a.config_id = cfc.config_id
             inner join movel.v$plataforma p
                on av.plataforma_id = p.plataforma_id
             inner join kmm.v$cliente c
                on cfc.cliente_id = c.cliente_id
             where 1=1
             <cfif Len(Trim(arguments.DESCRICAO))>
			   and upper(a.descricao) like upper('%#arguments.DESCRICAO#%')
             </cfif>
             <cfif Len(Trim(arguments.VERSAO_ID))>
               and a.versao_id = #arguments.VERSAO_ID#
             </cfif>
             <cfif Len(Trim(arguments.CONFIG_ID))>
               and a.config_id = #arguments.CONFIG_ID#
             </cfif>             
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna Aparelho
    -- LEOPOLDOS 30/04/2010 - CRIADO
    --->		
    <cffunction name="get_aparelho_cliente" access="remote" returntype="query" output="true">
        <cfargument name="DESCRICAO" required="yes">
        <cfargument name="VERSAO_ID" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select a.aparelho_id
                 , a.token
                 , a.cod_identificador
                 , a.data_ativacao
                 , a.data_ultima_atualizacao
                 , a.descricao
                 , av.aplicativo_nome as aplicativo
                 , av.versao as versao
                 , a.versao_id
                 , a.config_id
                 , av.plataforma_nome as plataforma
              from movel.v$aparelho a
             inner join movel.v$aplicativo_versao av
                on a.versao_id = av.versao_id
             where 1=1
             <cfif Len(Trim(arguments.DESCRICAO))>
			   and upper(a.descricao) like upper('%#arguments.DESCRICAO#%')
             </cfif>
             <cfif Len(Trim(arguments.VERSAO_ID))>
               and a.versao_id = #arguments.VERSAO_ID#
             </cfif>           
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as configuraes dos clientes
    -- GUSTAVOC 29/04/2010 - CRIADO
    --->		
    <cffunction name="get_configuracao_cliente" access="remote" returntype="query" output="true">
        <cfargument name="CLIENTE_ID" required="yes">
        <cfargument name="DB_NAME" required="yes">
        <cfargument name="DB_USUARIO" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cfc.config_id
                 , cfc.url_requisicao
                 , cfc.cliente_id
                 , cfc.db_name
                 , cfc.db_usuario
                 , cfc.db_senha
                 , cfc.db_host
                 , cfc.db_port
                 , cfc.site
                 , c.nome
              from movel.v$configuracao_cliente cfc
             inner join kmm.v$cliente c
                on c.cliente_id = cfc.cliente_id
             where 1=1 
             <cfif Len(Trim(arguments.CLIENTE_ID))>
              and cfc.cliente_id = #arguments.CLIENTE_ID#
             </cfif>
             <cfif Len(Trim(arguments.DB_NAME))>
              and upper(cfc.db_name) like upper('%#arguments.DB_NAME#%')
             </cfif>
             <cfif Len(Trim(arguments.DB_USUARIO))>
              and upper(cfc.db_usuario) like upper('%#arguments.DB_USUARIO#%')
             </cfif>
             order by c.nome ASC
        </cfquery>
        <cfreturn qr_result>
    </cffunction>      
    
    <!--- 
    -- PROPSITO 
    -- Retorna Configuraes do Token
    -- LEOPOLDOS 01/05/2010 - CRIADO
    --->		
    <cffunction name="get_configuracao_cliente_token" access="remote" returntype="query" output="true">
    	<cfargument name="TOKEN" required="yes">
       	<cfargument name="COD_IDENTIFICADOR" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.token
                 , a.descricao
                 , a.cod_identificador
                 , cfc.url_requisicao as url
              from movel.v$aparelho a
             inner join movel.v$configuracao_cliente cfc
                on a.config_id = cfc.config_id
             where a.token = '#arguments.TOKEN#'
               and a.cod_identificador = #arguments.COD_IDENTIFICADOR#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Verifica se existem verses mais novas do aplicativo
    -- LEOPOLDOS 99/99/2010 - CRIADO
    --->		
    <cffunction name="get_consulta_versoes" access="remote" returntype="query" output="true">
    	<cfargument name="TOKEN" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sql.versao_atual_id as versao_atual_id
                 , apv.versao as versao_atual
                 , sql.versao_aparelho_id
                 , sql.versao_aparelho as versao_aparelho
              from movel.v$aplicativo_versao apv
             inner join (
               
               select max(av.versao_id) as versao_atual_id
                    , app.versao_id as versao_aparelho_id
                    , app.versao as versao_aparelho
                    , ap.nome
                 from movel.v$aplicativo_versao av
                inner join movel.v$aplicativo ap
                   on av.aplicativo_id = ap.aplicativo_id
                inner join (select avv.aplicativo_id, avv.versao_id, avv.versao
                              from movel.v$aparelho a
                             inner join movel.v$aplicativo_versao avv
                                on a.versao_id = avv.versao_id
                             where a.token = '#arguments.TOKEN#') app
                   on app.aplicativo_id = av.aplicativo_id
                group by ap.nome, app.versao_id, app.versao
                
                ) sql
                on apv.versao_id = sql.versao_atual_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna Dados aparelho pelo Token
    -- LEOPOLDOS 99/99/2010 - CRIADO
    --->		
    <cffunction name="get_aparelho_token" access="remote" returntype="query" output="true">
    	<cfargument name="TOKEN" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.aparelho_id
                 , a.config_id
                 , a.token
                 , a.descricao
                 , a.cod_identificador
                 , a.data_ativacao
                 , a.data_ultima_atualizacao
                 , a.versao_id
              from movel.v$aparelho a
			 where a.token = '#arguments.TOKEN#'
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
</cfcomponent>