
<cfscript>
	conn = CreateComponent("modulos.pessoa._componentes.consulta.cfc_pessoa");
	qrAtividade    = conn.get_atividade_fiscal();
	qrRegimeTributario = conn.get_regime_tributario();
	qrTributacao = conn.get_tributacao();
</cfscript>

<script>
function set_pessoa_juridica(p_value) {
	with (document.forms[0]) {
		CNPJ_COMPLETO.setAttribute('tipo', p_value?'CNPJ':'' );
		CNPJ_COMPLETO.setAttribute('obrigatorio', p_value?1:0);
		RAZAO_SOCIAL.setAttribute('obrigatorio', p_value?1:0);
		NOME_FANTASIA.setAttribute('obrigatorio', p_value?1:0);
		INSCRICAO_ESTADUAL_PJ.setAttribute('obrigatorio', p_value?1:0 );
		CNAE.setAttribute('obrigatorio', p_value?1:0 );
	}
}
function f_busca_cnae(valor){
	with(document.forms[0]) {
		if((CNAE.value != "") && (CNAE.value.length >= 7)){
			p_url = '/modulos/pessoa/_componentes/consulta/cfc_pessoa.cfc?method=get_cnae';
			f_query_wddx(p_url,'CNAE='+valor, f_busca_cnae_result);
		}
		else {
			document.getElementById('td_cnae_descricao').innerHTML = '';
			return;
		}
	}
}
function f_busca_cnae_result(obj){
	if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
		v_rows = new Array();
		v_rows = obj.struct.descricao_cla;
		if(v_rows.length > 0){
			document.getElementById("td_cnae_descricao").innerHTML = v_rows[0];
		}else{
			document.getElementById("td_cnae_descricao").innerHTML ='C.N.A.E. Inexistente !';
		}
	}
}

function f_cancelar(){
	document.forms[0].OPERACAO.value = 1; // consultar
	f_desabilita_todos_campos();
	f_on_cancelar();
	try {
		f_habilitar_botao('localizar','f_localizar()');
	} catch(e) {
	}
	
	try {
		  f_habilitar_botao('pessoa_webservice','f_incluir_via_webservice()');
		}
	catch(e) {}
	
	f_habilitar_botao('incluir','f_incluir()');
	f_desabilitar_botao('cancelar');
	f_desabilitar_botao('confirmar');
	document.getElementById("td_cnae_descricao").innerHTML ='';
};

function f_incluir(){
	f_habilita_todos_campos();
	f_limpar_campos();
	f_on_incluir();
	try {
		f_desabilitar_botao('localizar');
	} catch(e) {}
	f_desabilitar_botao('incluir');
	f_desabilitar_botao('editar');
	f_desabilitar_botao('excluir');
	f_habilitar_botao('cancelar','f_cancelar()');
	f_habilitar_botao('confirmar','f_confirmar()');
	document.forms[0].OPERACAO.value = 2; // incluir
	document.getElementById("td_cnae_descricao").innerHTML ='';
};

function f_verificar_regime_tributario(regime_tributario){
   with (document.forms[0]) {
		TIPO_LUCRO.setAttribute('obrigatorio', regime_tributario.value == 3 ? 1 : 0 );
   };
};

</script>
<table width="100%" border="0" cellspacing="3" cellpadding="0">
  <tr>
    <td width="1%"  nowrap="nowrap" class="texto_negrito" style="width: 123px">C.N.P.J:</td>
    <td colspan="3" nowrap="nowrap" ><span><input name="CNPJ_COMPLETO" tipo="cnpj" onkeypress="return f_formata(this, '00000000000000')" type="text" class="caixa_texto" id="CNPJ_COMPLETO" size="23" maxlength="14" display="CNPJ" obrigatorio="1" onchange="f_busca_dados()" <cfif IsDefined("vars.CNPJ_COMPLETO")>value="<cfoutput>#vars.CNPJ_COMPLETO#</cfoutput>"</cfif>></span>
      &nbsp;<span class="texto">(somente os n&uacute;meros) </td>
  </tr>
  <tr>
    <td  nowrap="nowrap" class="texto_negrito">Raz&atilde;o Social: </td>
    <td colspan="3"><input name="RAZAO_SOCIAL" type="text" class="caixa_texto" id="RAZAO_SOCIAL" style="width:450" maxlength="60" display="RAZ&Atilde;O SOCIAL" obrigatorio="1" /></td>
  </tr>
  <tr>
    <td nowrap="nowrap" class="texto_negrito">Nome Fantasia:</td>
    <td colspan="3"><input name="NOME_FANTASIA" type="text" class="caixa_texto" id="NOME_FANTASIA" style="width:450" maxlength="40" display="NOME FANTASIA" obrigatorio="1" /></td>
  </tr>
  <tr>
    <td nowrap="nowrap" class="texto_negrito" align="left">Inscri&ccedil;&atilde;o Estadual:</td>
    <td colspan="3"><span><input name="INSCRICAO_ESTADUAL_PJ" type="text" class="caixa_texto" id="INSCRICAO_ESTADUAL_PJ" size="18" maxlength="14" display="INSCRI&Ccedil;&Atilde;O ESTADUAL" obrigatorio="1" /></span>
    <button type="button" style="text-align: left" onclick="NewWindow('http://www.sintegra.gov.br','Sintegra',760,480,'yes')" class="botao-16x16">
    <img src="/_imagens/botoes/16x16/sintegra.gif" alt="Buscar dados Sintegra" width="20" height="16" align="left" />Sintegra</button>
     </td>
  </tr>
  <tr>
    <td nowrap="nowrap" class="texto_negrito">C.N.A.E.:</td>
    <td ><nobr><span><input name="CNAE" type="text" class="caixa_texto" id="CNAE" onkeypress="return f_formata(this, '0000000000')" size="18" maxlength="10" obrigatorio="1" display="C.N.A.E." onchange="f_busca_cnae(this.value)"/></span>
    <button type="button" style="text-align: left" onclick="NewWindow('http://www.receita.fazenda.gov.br/PessoaJuridica/CNPJ/cnpjreva/Cnpjreva_Solicitacao.asp','Receita',760,480,'yes')" class="botao-16x16">
    <img src="/_imagens/botoes/16x16/receita_federal.gif" alt="Buscar dados na Receita Federal" width="20" height="16" align="left" />Receita Federal&nbsp;&nbsp;<span class="texto">(somente n&uacute;meros)</span></nobr></button></td>
    <td id="td_cnae_descricao" class="texto">&nbsp;</td>
  </tr>
  <tr>
    <td nowrap="nowrap" class="texto_negrito">Data Cadastro:</td>
    <td width="595" class="texto_negrito"><input name="DATA_ADMISSAO_PJ" display="DATA CADASTRO" type="text" class="caixa_texto" id="DATA_ADMISSAO_PJ" size="18" onkeypress="return f_formata(this, '00/00/0000')" style="width: 75px"/>
    <button type="button" class="botao-16x16" id="btn_admissao_pj"><img width="16" height="16" src="/_imagens/botoes/16x16/calendario.gif" /></button></td>
  </tr>
  <script>
    Calendar.setup(
      {
      inputField  : "DATA_ADMISSAO_PJ", // ID of the input field
      ifFormat    : "%d/%m/%Y",         // the date format
      button      : "btn_admissao_pj",  // ID of the button
	  range       : [2001,2050]
      }
    );
  </script>
  <tr>
    <td nowrap="nowrap" class="texto_negrito">Atividade Fiscal:</td>
    <td colspan="3"><select name="COD_ATIVIDADE_FISCAL" class="caixa_texto" id="COD_ATIVIDADE_FISCAL"  fixo="1">
      <option value="">-- Selecione --</option>
      <cfoutput query="qrAtividade">
        <option value="#qrAtividade.COD_ATIVIDADE_FISCAL#" <cfif qrAtividade.COD_ATIVIDADE_FISCAL eq 5>selected</cfif>>#qrAtividade.DESCRICAO#</option>
      </cfoutput>
    </select></td>
  </tr>
  <tr>
  	<td nowrap class="texto_negrito">Regime Tribut&aacute;rio:</td>
    <td><select onchange="f_verificar_regime_tributario(this);" name="COD_REGIME_TRIBUTARIO" class="caixa_texto" id="COD_REGIME_TRIBUTARIO" display="Regime Tribut&aacute;rio" obrigatorio="1">
	  <option value="">-- Selecione --</option>
	  <cfoutput query="qrRegimeTributario">
        <option value="#qrRegimeTributario.COD_REGIME_TRIBUTARIO#">#qrRegimeTributario.DESCRICAO#</option>
      </cfoutput>
    </select>
	<button type="button" style="text-align: left" title="Consulta optante" onclick="NewWindow('http://www8.receita.fazenda.gov.br/simplesnacional/aplicacoes/atbhe/consultaoptantes.app/consultaropcao.aspx','Receita',760,480,'yes')" class="botao-16x16">
    <img src="/_imagens/botoes/16x16/receita_federal.gif" alt="Consulta optante" width="20" height="16" align="left" /></button>
	&nbsp;<label class="texto_negrito">Tributa&ccedil;&atilde;o:</label>
    <select name="TIPO_LUCRO" class="caixa_texto" id="TIPO_LUCRO" display="Tributa&ccedil;&atilde;o" obrigatorio="0">
	  <option value="">-- Selecione --</option>
	  <cfoutput query="qrTributacao">
        <option value="#qrTributacao.TIPO_LUCRO#">#qrTributacao.DESCRICAO#</option>
      </cfoutput>
    </select></td>
  </tr>
  <tr>
    <tr id="tr_rntrc_juridica">
        <td class="texto_negrito">N&deg; RNTRC/TAC:</td>
        <td id="td_rntrc_juridica" align="left" class="texto"><input name="RNTRC_TAC" type="text" id="RNTRC_TAC" maxlength="8" display="NUMERO DO RNTRC/TAC" obrigatorio="0" />
        &nbsp;<b>Data Emiss&atilde;o:</b>
        <input type="text" name="DATA_EMISSAO_RNTRC_TAC" id="DATA_EMISSAO_RNTRC_TAC" obrigatorio="0" tipo="data" display="DATA DE EMISSAO" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 75px;" />
        <button type="button" id="BTN_DATA_EMISSAO_RNTRC_TAC" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
        &nbsp;<b>Validade:</b>
        <input type="text" name="DATA_VENCIMENTO_RNTRC_TAC" id="DATA_VENCIMENTO_RNTRC_TAC" maxlength="10" obrigatorio="0" tipo="data" display="VALIDADE RNTRC/TAC" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 75px;" />
        <button type="button" id="BTN_DATA_VENCIMENTO_RNTRC_TAC" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
        &nbsp;<button type="button" onclick="NewWindow('http://consultapublicarntrc.antt.gov.br/consultapublica','ANTT',760,480,'yes')" id="BTN_ANTT" class="botao-16x16"><img src="\_imagens\botoes\16x16\antt.gif" alt="Localizar RNTRC" title="Localizar RNTRC" width="16" height="16" align="absmiddle">&nbsp;ANTT</button></td>
    </tr>
  </tr>
  
  <tr>
  <cfif ListFind(secoes, 'tipo_transportador',',')>
        <tr id="tr_tipo_transp_juridica">
            <td class="texto_negrito">Tipo Transportador:</td>
            <td id="td_tipo_transp_juridica" align="left" class="texto">
               <select name="TIPO_TRANSPORTADOR" id="TIPO_TRANSPORTADOR" obrigatorio="0" display="TIPO DO TRANSPORTADOR">
                   <option value="">-- Selecione -- </option>
				   <cfoutput query="qrTipoTransp">
                    <option value="#qrTipoTransp.RV_LOW_VALUE#">#qrTipoTransp.RV_LOW_VALUE# - #qrTipoTransp.RV_MEANING#</option>
                   </cfoutput>
               </select>
            </td> 
        </tr>
  </cfif>
  </tr>
  
  <tr>
    <td colspan="3" nowrap="nowrap" class="texto_negrito" height="9"></td>
  </tr>  
</table>


