<cfcomponent displayname="Controle e manipulao de veculos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere uma nova conta corrente
	-- guto 07/03/2006 15:51:15 - CRIADO
	--->
	<cffunction name='ins_conta_corrente' displayname='Insere uma nova conta corrente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
				<cfstoredproc procedure='finan.pkg_ccorrente.PRC_INSERE_CONTA_PESSOA' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'  null="yes" variable='retorno.ROWID' >
				</cfstoredproc>
		<cfcatch></cfcatch>
		</cftry>		
		<cfreturn retorno />
	</cffunction>
    
	
<cffunction name="ins_pessoa" displayname="Insere uma pessoa no sistema" access="remote" returntype="Struct" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 07/10/2005 - criado
	--->
	<cfargument name="tipo_pessoa" required="yes">
	<cfargument name="permisso_numero" required="no">
	<cfargument name="permisso_data" required="no">
	<cfargument name="apolice_numero" required="no">
	<cfargument name="apolice_vencimento" required="no">
    <cfargument name="num_modalidade" required="no">
	<cfargument name="IVA" required="no">
    <cfargument name="cnh_numero" required="no" default="">
    <cfargument name="cnh_uf" required="no" default="">
    <cfargument name="cnh_primeira_habilitacao" required="no" default="">
    <cfargument name="FOTO_PF" required="no" default="">
	<cfargument name="limite_carga_valor" required="no" default="">
	<cfargument name="cnh_renach" required="no" default="">
	<cftry>
		<cftransaction action="begin">
			<!---Insero da Pessoa--->
			<cfif arguments.tipo_pessoa eq 0>
				<cfscript>
					retorno.cod_pessoa = this.ins_pessoa_juridica(argumentCollection = arguments, cod_pessoa = "");
				</cfscript>
			<cfelseif arguments.tipo_pessoa eq 1>
				<cfscript>
					retorno.cod_pessoa = this.ins_pessoa_fisica(argumentCollection = arguments, cod_pessoa = "");
				</cfscript>
                <cfif Len(Trim(arguments.FOTO_PF))>
					<!--- Insere Logotipo Pessoa --->
                    <cfscript>  				
                        ret_banco = this.ins_pessoa_logo(cod_pessoa  	= retorno.cod_pessoa
                                            			,nome_arquivo	= arguments.FOTO_PF
			                                            );
                    </cfscript>  
					<cfif ret_banco.erro>
                       <cfthrow object="#ret_banco.mensagem#">
                    </cfif>                    
                </cfif>                
			<cfelseif arguments.tipo_pessoa eq 2>
				<cfscript>
					retorno.cod_pessoa = this.ins_pessoa_estrangeira(argumentCollection = arguments, cod_pessoa = "");
				</cfscript>
			</cfif>
			<cfif  IsDefined("arguments.permisso_numero") and len(trim(arguments.permisso_numero))>
					<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="6">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.permisso_numero#">
				</cfstoredproc>
			</cfif>
			<cfif  IsDefined("arguments.permisso_data") and len(trim(arguments.permisso_data))>
					<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="7">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.permisso_data#">
				</cfstoredproc>
			</cfif>
	
			<cfif  IsDefined("arguments.apolice_numero") and len(trim(arguments.apolice_numero))>
					<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="8">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.apolice_numero#">
				</cfstoredproc>
			</cfif>
					<cfif  IsDefined("arguments.apolice_vencimento") and len(trim(arguments.apolice_vencimento))>
					<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="9">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.apolice_vencimento#">
				</cfstoredproc>
			</cfif>
			<cfif  IsDefined("arguments.IVA") and len(trim(arguments.IVA))>
					<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="10">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.IVA#">
				</cfstoredproc>
			</cfif>
    <cfscript>
	    v_banco_id 	  = this.ListaToArray (lista = arguments, variavel = "BANCO_ID_BANCO");
		v_agencia_id   = this.ListaToArray (lista = arguments, variavel = "AGENCIA_ID_BANCO");
		v_conta_ag_dv  = this.ListaToArray (lista = arguments, variavel = "CONTA_AG_DV_BANCO");
		v_conta 	      = this.ListaToArray (lista = arguments, variavel = "CONTA_BANCO");
		v_conta_dv 	  = this.ListaToArray (lista = arguments, variavel = "CONTA_DV_BANCO");	
	    v_conta_padrao = this.ListaToArray (lista = arguments, variavel = "PADRAO_BANCO");			
	    v_cod_pessoa_titular = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_TITULAR_BANCO");
	    v_conta_tipo_id = this.ListaToArray (lista = arguments, variavel = "CONTA_TIPO_ID_BANCO");
    </cfscript> 
	<cfloop from="1" to="#ArrayLen(v_conta)#" index="count">
	   <cfscript>
			ret_banco = this.insere_conta_bancaria(cod_pessoa   = retorno.cod_pessoa
										          ,banco_id 	= v_banco_id[count]
										          ,agencia_id   = v_agencia_id[count]
										          ,conta 	    = v_conta[count]
										          ,conta_dv 	= v_conta_dv[count]
										          ,conta_ag_dv  = v_conta_ag_dv[count]
										          ,conta_padrao = v_conta_padrao[count]
										          ,cod_pessoa_titular = v_cod_pessoa_titular[count]
										          ,conta_tipo_id 	  = v_conta_tipo_id[count]
										          );      
		</cfscript>
        	<cfif ret_banco.erro>
            	<cfthrow object="#ret_banco.mensagem#">
            </cfif>
	</cfloop>
     
            
			<!---Inseres de Email--->
			<cfscript>
            
                v_email_proprietario = this.ListaToArray (lista = arguments, variavel = "EMAIL_PROPRIETARIO_EMAIL");
                v_email_end 	     = this.ListaToArray (lista = arguments, variavel = "EMAIL_END_EMAIL");
                v_email_id 			 = this.ListaToArray (lista = arguments, variavel = "EMAIL_ID_EMAIL");
                v_email_obs 		 = this.ListaToArray (lista = arguments, variavel = "EMAIL_OBS_EMAIL");
                v_email_padrao 		 = this.ListaToArray (lista = arguments, variavel = "PADRAO_EMAIL");
                v_cargo_id 			 = this.ListaToArray(lista = arguments, variavel = "EMAIL_CARGO_ID");
                v_setor_id 			 = this.ListaToArray(lista = arguments, variavel = "EMAIL_SETOR_ID");
				v_email_tipo_id      = this.ListaToArray(lista = arguments, variavel = "EMAIL_TIPO_ID_EMAIL");
            </cfscript>
            <cfloop from="1" to="#ArrayLen(v_email_proprietario)#" index="count">
                <cfscript>

                    this.ins_email(email_end 	      = v_email_end[count]
							 	  ,email_proprietario = v_email_proprietario[count]
								  ,email_padrao 	  = v_email_padrao[count]
								  ,email_obs 		  = v_email_obs[count]
								  ,cod_pessoa 		  = retorno.cod_pessoa
								  ,cargo_id   		  = v_cargo_id[count]
								  ,setor_Id	  		  = v_setor_id[count]
								  ,email_tipo_id	  = v_email_tipo_id[count]
								  );
                </cfscript>
            </cfloop>
			<!---Inseres de Endereco--->
			<cfscript>
				v_cep 			    = this.ListaToArray (lista = arguments, variavel = "CEP");
				v_logradouro 		= this.ListaToArray (lista = arguments, variavel = "LOGRADOURO");
				v_numero 			= this.ListaToArray (lista = arguments, variavel = "NUMERO");
				v_complemento 		= this.ListaToArray (lista = arguments, variavel = "COMPLEMENTO");
				v_bairro 			= this.ListaToArray (lista = arguments, variavel = "BAIRRO");
				v_municipio 		= this.ListaToArray (lista = arguments, variavel = "MUNICIPIO_ENDERECO");
				v_cod_endereco_tipo = this.ListaToArray (lista = arguments, variavel = "COD_ENDERECO_TIPO_ENDERECO");
				v_uf 				= this.ListaToArray (lista = arguments, variavel = "UF_ENDERECO");
				v_endereco_padrao 	= this.ListaToArray (lista = arguments, variavel = "PADRAO_ENDERECO");
				v_municipio_id 		= this.ListaToArray (lista = arguments, variavel = "MUNICIPIO_ID_ENDERECO");
				v_pais_id			= this.ListaToArray (lista = arguments, variavel = "PAIS_ID");
				v_estado_provincia  = this.ListaToArray (lista = arguments, variavel = "ESTADO_PROVINCIA");
				v_codigo_postal	    = this.ListaToArray (lista = arguments, variavel = "CODIGO_POSTAL");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_cep)#" index="count">
				<cfscript>
					this.ins_endereco(cod_pessoa  		= retorno.cod_pessoa
									 ,cep		  		= v_cep[count]
									 ,logradouro  		= v_logradouro[count]
									 ,numero      		= v_numero[count]
									 ,complemento 		= v_complemento[count]
									 ,bairro      		= v_bairro[count]
									 ,municipio   		= v_municipio[count]
									 ,cod_endereco_tipo = v_cod_endereco_tipo[count]
									 ,uf          	    = v_uf[count]
									 ,padrao      	    = v_endereco_padrao[count]
									 ,municipio_id 		= v_municipio_id[count]
									 ,pais_id           = v_pais_id[count]
									 ,estado_provincia	= v_estado_provincia[count]
									 ,codigo_postal		= v_codigo_postal[count]
									 );
				</cfscript>
			</cfloop>
			<!---Inseres de Telefones--->
			<cfscript>
                v_contato = this.ListaToArray (lista = arguments, variavel = "TELEFONE_CONTATO");
                v_ddd     = this.ListaToArray (lista = arguments, variavel = "TELEFONE_DDD");
                v_prefixo = this.ListaToArray (lista = arguments, variavel = "TELEFONE_PREFIXO");
                v_numero  = this.ListaToArray (lista = arguments, variavel = "TELEFONE_NUMERO");
                v_ramal   = this.ListaToArray (lista = arguments, variavel = "RAMAL");
                v_tipo    = this.ListaToArray (lista = arguments, variavel = "TELEFONE_TIPO_ID");
                v_padrao  = this.ListaToArray (lista = arguments, variavel = "PADRAO_TELEFONE");	
                v_cargo_id = this.ListaToArray(lista = arguments, variavel = "TELEFONE_CARGO_ID");
                v_setor_id = this.ListaToArray(lista = arguments, variavel = "TELEFONE_SETOR_ID");
            </cfscript>
            <cfloop from="1" to="#ArrayLen(v_contato)#" index="count">
                <cfscript>
                    this.ins_telefone(cod_pessoa  	   = retorno.cod_pessoa
									 ,telefone_ddd	   = v_ddd[count]
									 ,telefone_prefixo = v_prefixo[count]
									 ,telefone_numero  = v_numero[count]
									 ,telefone_ramal   = v_ramal[count]
									 ,telefone_tipo_id = v_tipo[count]
									 ,telefone_contato = v_contato[count]
									 ,padrao      	   = v_padrao[count]
									 ,cargo_id	  	   = v_cargo_id[count]
									 ,setor_id	  	   = v_setor_id[count]
									 );
                </cfscript>
            </cfloop>
			<!---Inseres de IE Adicional--->
			<cfif arguments.tipo_pessoa eq 0>
				<cfscript>
					v_iead_inscricao_estadual = this.ListaToArray (lista = arguments, variavel = "IEAD_INSCRICAO_ESTADUAL_IE_ADICIONAL");
					v_iead_uf      		      = this.ListaToArray (lista = arguments, variavel = "IEAD_UF_IE_ADICIONAL");
				</cfscript>
                <cfloop from="1" to="#ArrayLen(v_iead_inscricao_estadual)#" index="count">
					<cfscript>
						this.ins_ie_adicional(cod_pessoa  		 = retorno.cod_pessoa
										     ,inscricao_estadual = v_iead_inscricao_estadual[count]
										     ,uf  				 = v_iead_uf[count]
										     );
					</cfscript>
				</cfloop>
			</cfif>			
			<!---Inseres de Documentos--->
			<cfscript>
                v_nome_arquivo  = this.ListaToArray (lista = arguments, variavel = "URL");
                v_tipo          = this.ListaToArray (lista = arguments, variavel = "TIPOD");
                v_comentario    = this.ListaToArray (lista = arguments, variavel = "COMENTARIO");
            </cfscript>

            <cfloop from="1" to="#ArrayLen(v_nome_arquivo)#" index="count">
                <cfscript>  				
                    ret_banco = this.ins_documento(cod_pessoa  	= retorno.cod_pessoa
									  ,nome_arquivo	= v_nome_arquivo[count]
									  ,cod_tipo_doc	= v_tipo[count]
									  ,observacao   = v_comentario[count]
									  );
                </cfscript>
				 <cfif ret_banco.erro>
                    <cfthrow object="#ret_banco.mensagem#">
                 </cfif>                
            </cfloop>   
			<!---Inseres de Usuarios--->
			<cfscript>
				v_login = this.ListaToArray (lista = arguments, variavel = "USUARIO_LOGIN");
				v_senha = this.ListaToArray (lista = arguments, variavel = "USUARIO_SENHA");
				v_nome  = this.ListaToArray (lista = arguments, variavel = "USUARIO_NOME");
				v_email = this.ListaToArray (lista = arguments, variavel = "USUARIO_EMAIL");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_login)#" index="count">
				<cfscript>
					this.ins_usuario (cod_pessoa  = retorno.cod_pessoa,
									  usuario     = v_login[count],
									  nome        = v_nome[count],
									  senha       = v_senha[count],
									  email       = v_email[count]);
				</cfscript>
			</cfloop>
			<cfif IsDefined("arguments.NUM_MODALIDADE") and Len(Trim(arguments.NUM_MODALIDADE))> 
				<cfscript>
					this.ins_pessoa_modalidade(cod_pessoa = retorno.cod_pessoa,
											   num_modalidade = arguments.num_modalidade, situacao=1
											   , nova_pessoa = 1
											   ); 
				</cfscript>
	
				<!--- Se modalidade igual a 5 (cliente) ento gera conta corrente --->
				<cfif arguments.num_modalidade eq 5>
					<cfscript>
						this.ins_conta_corrente(cod_pessoa    = retorno.cod_pessoa);											
					</cfscript>
				</cfif>		
			</cfif>
            
			<!---Inseres regras de faturamento--->
            <cfif IsDefined("arguments.PAGADOR_FATURAMENTO_0")>
				<cfscript>
                    v_pagador        = this.ListaToArray (lista = arguments, variavel = "PAGADOR_FATURAMENTO");
                    v_dia_inicial    = this.ListaToArray (lista = arguments, variavel = "DIA_INICIAL_FATURAMENTO");
                    v_dia_final      = this.ListaToArray (lista = arguments, variavel = "DIA_FINAL_FATURAMENTO");
                    v_dia_vencimento = this.ListaToArray (lista = arguments, variavel = "DIA_VENCIMENTO_FATURAMENTO");
                    v_mes_vencimento = this.ListaToArray (lista = arguments, variavel = "MES_VENCIMENTO_FATURAMENTO");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_pagador)#" index="count">
                    <cfscript>
                        set_fat_regra = this.ins_faturamento_regra(cod_pessoa  	  = retorno.cod_pessoa,
																   dia_inicial    = v_dia_inicial[count],
																   dia_final      = v_dia_final[count],
																   dia_vencimento = v_dia_vencimento[count],
																   pagador        = v_pagador[count],
																   mes_vencimento = v_mes_vencimento[count]);
                    </cfscript>
					<cfif set_fat_regra.erro>
                        <cfthrow object="#set_fat_regra.mensagem#"/>
                    </cfif>                    
                </cfloop>
            </cfif>
			<!---Inseres regras de faturamento--->
            <cfif IsDefined("arguments.FAT_FORMA_ID") and IsDefined("arguments.FAT_AGRUPAMENTO_ID") and IsDefined("arguments.FAT_CONDICAO_ID")
			  and IsDefined("arguments.C026_ID") and IsDefined("arguments.COD_MOEDA")>
				<cfscript>
                set_fat = this.ins_pessoa_faturamento(cod_pessoa        = retorno.cod_pessoa,
													 fat_forma_id       = arguments.FAT_FORMA_ID,
													 fat_agrupamento_id = arguments.FAT_AGRUPAMENTO_ID,
													 fat_condicao_id    = arguments.FAT_CONDICAO_ID,
													 c026_ID            = arguments.C026_ID,
													 num_dias_protesto  = arguments.NUM_DIAS_PROTESTO,
													 cod_moeda          = arguments.COD_MOEDA
												    );
                </cfscript>
                <cfif set_fat.erro>
                    <cfthrow object="#set_fat.mensagem#"/>
                </cfif>
            </cfif>
			
			<cfif  IsDefined("arguments.COD_CONTA") and len(trim(arguments.COD_CONTA))>
					<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="16">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.COD_CONTA#">
				</cfstoredproc>
			</cfif>
			<cfif  IsDefined("arguments.CONTATO_CORRESPONDENCIA") and len(trim(arguments.CONTATO_CORRESPONDENCIA))>
					<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">

					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="17">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.CONTATO_CORRESPONDENCIA#">
				</cfstoredproc>
			</cfif>
            
            <cfif arguments.tipo_pessoa eq 1 and IsDefined("arguments.GERENCIADORA_ID")>
            	<cfscript>
					ret = this.ins_consulta_motorista(COD_PESSOA         = retorno.cod_pessoa,
													  GERENCIADORA_ID    = arguments.GERENCIADORA_ID,
													  COD_LIBERACAO      = arguments.COD_LIBERACAO,
													  LIBERACAO_VALIDADE = arguments.LIBERACAO_VALIDADE);
				</cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
            </cfif>
            
            <cfif IsDefined("arguments.POSSUI_CENTRAL_CAD") and arguments.POSSUI_CENTRAL_CAD eq 1>
               	<cfscript>
                   ret = this.atualizar_centra_cadastros(COD_PESSOA = retorno.cod_pessoa);
                </cfscript>
                <cfif ret.erro>
                   <cfthrow object="#ret.mensagem#">
                </cfif>
            </cfif>
            
            <cfscript>
			   ret_val = this.valida_pessoa(COD_PESSOA = retorno.cod_pessoa);
			</cfscript>
			<cfif ret_val.erro>
			   <cfthrow object="#ret_val.mensagem#">
			</cfif>
            
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Pessoa inserida com sucesso!")>
		</cftransaction>
		<cfcatch type="database">
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<!--- 
-- PROPSITO
-- insere dependente
-- wagnerlv 24/01/2008 17:26:21 - CRIADO
--->
<cffunction name='ins_dependente' displayname='insere dependente' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='NOME' required='yes'>
	<cfargument name='DATA_NASCIMENTO' required='yes'>
	<cfargument name='COD_SEXO' required='yes'>
	<cfargument name='COD_GRAU_PARENTESCO' required='yes'>
	<cfargument name='CALCULA_SALARIO_FAMILIA' required='yes'>
	<cfargument name='DESCONTA_IRRF' required='yes'>
	<cfargument name='PENSAO_ALIMENTICIA' required='yes'>
	<cfargument name='LOCAL_NASCIMENTO' required='yes'>
	<cfargument name='UF_NASCIMENTO' required='yes'>
	<cfargument name='CARTORIO' required='yes'>
	<cfargument name='NUM_LIVRO' required='yes'>
	<cfargument name='NUM_FOLHA' required='yes'>
	<cfargument name='NUM_REGISTRO' required='yes'>
	<cfargument name='DATA_ENTREGA_CERTIDAO' required='yes'>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_insere_dependente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.COD_DEPENDENTE' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_NASCIMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_SEXO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_GRAU_PARENTESCO#'  null='#iif(len(trim(arguments.COD_GRAU_PARENTESCO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CALCULA_SALARIO_FAMILIA#'  null='#iif(len(trim(arguments.CALCULA_SALARIO_FAMILIA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DESCONTA_IRRF#'  null='#iif(len(trim(arguments.DESCONTA_IRRF)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PENSAO_ALIMENTICIA#'  null='#iif(len(trim(arguments.PENSAO_ALIMENTICIA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LOCAL_NASCIMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF_NASCIMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTORIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_LIVRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_FOLHA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_REGISTRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ENTREGA_CERTIDAO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
	<cfreturn structnew() />
</cffunction>


<!--- 
-- PROPSITO
-- Insere uma agencia, se nao existir
-- wagnerlv 22/01/2008 09:10:32 - CRIADO
--->
<cffunction name='ins_agencia' displayname='Insere uma agencia, se nao existir' access='remote' returntype='Struct' output='true'>
	
	<cfargument name='banco_id' required='yes'>
	<cfargument name='agencia_id' required='yes'>
	<cfargument name='conta_ag_dv' required='yes'>
	<cfargument name='DADOS_BANCARIOS_CEP' required='yes' default="">
	<cfargument name='DADOS_BANCARIOS_LOGRADOURO' required='yes' default="">
	<cfargument name='DADOS_BANCARIOS_NUMERO' required='yes' default="">
	<cfargument name='DADOS_BANCARIOS_COMPLEMENTO' required='yes' default="">
	<cfargument name='agencia_cidade' required='yes' default="">
	<cfargument name='banco_uf' required='yes'>
	<cfargument name='DADOS_BANCARIOS_BAIRRO' required='yes' default="">
			<cfstoredproc procedure='kss.pkg_banco.prc_insere_agencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.banco_id#' variable='retornoAgencia.BANCO_ID' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.agencia_id#' variable='retornoAgencia.AGENCIA_ID'  null='#iif(len(trim(arguments.agencia_id)), de('no'), de('yes'))#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.conta_ag_dv#' variable='retornoAgencia.AGENCIA_DV' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DADOS_BANCARIOS_CEP#'  null='#iif(len(trim(arguments.DADOS_BANCARIOS_CEP)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DADOS_BANCARIOS_LOGRADOURO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DADOS_BANCARIOS_NUMERO#'  null='#iif(len(trim(arguments.DADOS_BANCARIOS_NUMERO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DADOS_BANCARIOS_COMPLEMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.agencia_cidade#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.banco_uf#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DADOS_BANCARIOS_BAIRRO#' >
               	
			</cfstoredproc>
	<cfreturn retornoAgencia />
</cffunction>

<!--- 
-- PROPSITO
-- Insere uma conta bancaria
-- wagnerlv 21/01/2008 17:30:56 - CRIADO
--->
<cffunction name='ins_conta_bancaria' displayname='Insere uma conta bancaria' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA_CONTA' required='yes'>
	<cfargument name='banco_id' required='yes'>
	<cfargument name='agencia_id' required='yes'>
	<cfargument name='conta' required='yes'>
	<cfargument name='conta_dv' required='yes'>
	<cfargument name='conta_ag_dv' required='yes'>
	<cfargument name='DADOS_BANCARIOS_CONTA_PADRAO' required='yes' default="1">         
	<cfargument name='COD_PESSOA_TITULAR' required='no'>
	<cfargument name='CONTA_TIPO_ID' required='yes'>
    <cfargument name='titular_cpf_cnpj' required='yes' default="">
    <cfargument name='titular_nome' required='yes' default="">
			<cfstoredproc procedure='kss.pkg_pessoa.prc_insere_conta_bancaria' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#ARGUMENTS.COD_PESSOA_CONTA#'  null='#iif(len(trim(ARGUMENTS.COD_PESSOA_CONTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#ARGUMENTS.banco_id#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#ARGUMENTS.agencia_id#'  null='#iif(len(trim(ARGUMENTS.agencia_id)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#ARGUMENTS.conta#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#ARGUMENTS.conta_dv#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#ARGUMENTS.conta_ag_dv#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#ARGUMENTS.DADOS_BANCARIOS_CONTA_PADRAO#'  null='#iif(len(trim(ARGUMENTS.DADOS_BANCARIOS_CONTA_PADRAO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#ARGUMENTS.COD_PESSOA_TITULAR#'  null='#iif(len(trim(ARGUMENTS.COD_PESSOA_TITULAR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#ARGUMENTS.CONTA_TIPO_ID#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.titular_cpf_cnpj#' >
              	<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.titular_nome#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
	<cfreturn structnew() />
</cffunction>
<!--- 
-- PROPSITO
-- excluir uma conta bancaria
-- wagnerlv 31/01/2008 09:27:18 - CRIADO
--->
<cffunction name='excluir_conta_bancaria' displayname='excluir uma conta bancaria' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA' required='yes'>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_excluir_contas_bancarias' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
			</cfstoredproc>
	<cfreturn structnew() />
</cffunction>

<!--- 
-- PROPSITO
-- altera a conta bancaria
-- wagnerlv 22/01/2008 16:45:25 - CRIADO
--->
<cffunction name='alt_conta_bancaria' displayname='altera a conta bancaria' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA_CONTA' required='yes'>
	<cfargument name='banco_id' required='yes'>
	<cfargument name='agencia_id' required='yes'>
	<cfargument name='conta' required='yes'>
	<cfargument name='conta_dv' required='yes'>
	<cfargument name='conta_ag_dv' required='yes'>
	<cfargument name='CONTA_PADRAO' required='yes' default="1">         
	<cfargument name='cod_pessoa_titular' required='no'>
	<cfargument name='conta_tipo_id' required='yes'>
    <cfargument name='titular_cpf_cnpj' required='yes' default="">
    <cfargument name='titular_nome' required='yes' default="">
			<cfstoredproc procedure='kss.pkg_pessoa.prc_atualiza_conta_bancaria' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_CONTA#'  null='#iif(len(trim(arguments.COD_PESSOA_CONTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.BANCO_ID#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.AGENCIA_ID#'  null='#iif(len(trim(arguments.AGENCIA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONTA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONTA_DV#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONTA_AG_DV#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTA_PADRAO#'  null='#iif(len(trim(arguments.CONTA_PADRAO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_TITULAR#'  null='#iif(len(trim(arguments.COD_PESSOA_TITULAR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTA_TIPO_ID#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULAR_CPF_CNPJ#' >
              	<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULAR_NOME#' >
			</cfstoredproc>
	<cfreturn structnew() />
</cffunction>

<!--- 
-- PROPSITO
-- apaga depednente
-- wagnerlv 24/01/2008 17:47:25 - CRIADO
--->
<cffunction name='del_dependente' displayname='apaga depednente' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='COD_DEPENDENTE' required='yes'>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_excluir_dependente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_DEPENDENTE#'  null='#iif(len(trim(arguments.COD_DEPENDENTE)), de('no'), de('yes'))#'>
			</cfstoredproc>
	<cfreturn structnew() />
</cffunction>


<!--- 
-- PROPSITO
-- altera dependente
-- wagnerlv 25/01/2008 16:19:35 - CRIADO
--->
<cffunction name='altera_dependente' displayname='altera dependente' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='COD_DEPENDENTE' required='yes'>
	<cfargument name='NOME' required='yes'>
	<cfargument name='DATA_NASCIMENTO' required='yes'>
	<cfargument name='COD_SEXO' required='yes'>
	<cfargument name='COD_GRAU_PARENTESCO' required='yes'>
	<cfargument name='CALCULA_SALARIO_FAMILIA' required='yes'>
	<cfargument name='DESCONTA_IRRF' required='yes'>
	<cfargument name='PENSAO_ALIMENTICIA' required='yes'>
	<cfargument name='LOCAL_NASCIMENTO' required='yes'>
	<cfargument name='UF_NASCIMENTO' required='yes'>
	<cfargument name='CARTORIO' required='yes'>
	<cfargument name='NUM_LIVRO' required='yes'>
	<cfargument name='NUM_FOLHA' required='yes'>
	<cfargument name='NUM_REGISTRO' required='yes'>
	<cfargument name='DATA_ENTREGA_CERTIDAO' required='yes'>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_atualiza_dependente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_DEPENDENTE#'  null='#iif(len(trim(arguments.COD_DEPENDENTE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_NASCIMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_SEXO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_GRAU_PARENTESCO#'  null='#iif(len(trim(arguments.COD_GRAU_PARENTESCO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CALCULA_SALARIO_FAMILIA#'  null='#iif(len(trim(arguments.CALCULA_SALARIO_FAMILIA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DESCONTA_IRRF#'  null='#iif(len(trim(arguments.DESCONTA_IRRF)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PENSAO_ALIMENTICIA#'  null='#iif(len(trim(arguments.PENSAO_ALIMENTICIA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LOCAL_NASCIMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF_NASCIMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTORIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_LIVRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_FOLHA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_REGISTRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ENTREGA_CERTIDAO#' >
			</cfstoredproc>
	<cfreturn structnew() />
</cffunction>



<cffunction name="upd_pessoa" displayname="Insere uma pessoa no sistema" access="remote" returntype="Struct" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 07/10/2005 - criado
	--->			
	<cfargument name="tipo_pessoa" required="yes">
	<cfargument name="permisso_numero" required="no">
	<cfargument name="permisso_data" required="no">
	<cfargument name="apolice_numero" required="no">
	<cfargument name="apolice_vencimento" required="no">
	<cfargument name="IVA" required="no">
    <cfargument name="cnh_numero" required="no" default="">
    <cfargument name="cnh_uf" required="no" default="">
    <cfargument name="cnh_primeira_habilitacao" required="no" default="">
    <cfargument name="FOTO_PF" required="no" default=""> 
    <cfargument name="DOC_EXCLUIR" required="no" default="">
	<cfargument name="lista_deleted_ie_adicional" required="no" default="">
	<cfargument name="limite_carga_valor" required="no" default="">
	<cfargument name="cnh_renach" required="no" default="">
	<cftry>
		<cftransaction action="begin">
			<!---Alterao da Pessoa--->
			<cfif arguments.tipo_pessoa eq 0>
				<cfscript>
					retorno.cod_pessoa = this.ins_pessoa_juridica(argumentCollection = arguments);
				</cfscript>
			<cfelseif arguments.tipo_pessoa eq 1>
				<cfscript>
					retorno.cod_pessoa = this.ins_pessoa_fisica(argumentCollection = arguments);
				</cfscript>
				<!--- Insere Logotipo Pessoa --->               
				<cfscript>  
                    ret_banco = this.del_pessoa_logo(cod_pessoa = retorno.cod_pessoa);
                </cfscript>  
                <cfif ret_banco.erro>
                   <cfthrow object="#ret_banco.mensagem#">
                </cfif>
                <cfif Len(Trim(arguments.FOTO_PF))>                
					<cfscript>  								
                        ret_banco = this.ins_pessoa_logo(cod_pessoa = retorno.cod_pessoa
			                                            ,nome_arquivo = arguments.FOTO_PF
            			                                );
                    </cfscript>  
					<cfif ret_banco.erro>
                       <cfthrow object="#ret_banco.mensagem#">
                    </cfif>                                               
                 </cfif>             
			<cfelseif arguments.tipo_pessoa eq 2>
				<cfscript>
					retorno.cod_pessoa = this.ins_pessoa_estrangeira(argumentCollection = arguments);
				</cfscript>
			</cfif>
		<cfif session.site neq "transemba/" and session.site neq "portalkmm/" and session.site neq "transgires/" and session.site neq "axon/">

			<!--- Insere atributos se existirem --->
			<cfif  IsDefined("arguments.permisso_numero") and len(trim(arguments.permisso_numero))>
				<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="6">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.permisso_numero#">
				</cfstoredproc>
			</cfif>
			<cfif  IsDefined("arguments.permisso_data") and len(trim(arguments.permisso_data))>
				<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="7">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.permisso_data#">
				</cfstoredproc>
			</cfif>
	
			<cfif  IsDefined("arguments.apolice_numero") and len(trim(arguments.apolice_numero))>
				<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="8">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.apolice_numero#">
				</cfstoredproc>
			</cfif>
				<cfif  IsDefined("arguments.apolice_vencimento") and len(trim(arguments.apolice_vencimento))>
				<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="9">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.apolice_vencimento#">
				</cfstoredproc>
			</cfif>			
			<cfif  IsDefined("arguments.IVA") and len(trim(arguments.IVA))>
				<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="10">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.IVA#">
				</cfstoredproc>
			</cfif>
           </cfif>
           
      <cfif IsDefined("arguments.lista_deleted_BANCO")>
			<cfscript>
               v_banco_id 	    = this.ListaToArray (lista = arguments, variavel = "BANCO_ID_BANCO");
               v_agencia_id     = this.ListaToArray (lista = arguments, variavel = "AGENCIA_ID_BANCO");
			   v_conta 	        = this.ListaToArray (lista = arguments, variavel = "CONTA_BANCO");
			   v_banco_id_old 	= this.ListaToArray (lista = arguments, variavel = "BANCO_ID_OLD_BANCO");
               v_agencia_id_old = this.ListaToArray (lista = arguments, variavel = "AGENCIA_ID_OLD_BANCO");
			   v_conta_old 	    = this.ListaToArray (lista = arguments, variavel = "CONTA_OLD_BANCO");
			   v_conta_dv_old   = this.ListaToArray (lista = arguments, variavel = "CONTA_DV_OLD_BANCO");
               v_conta_ag_dv    = this.ListaToArray (lista = arguments, variavel = "CONTA_AG_DV_BANCO");
               v_conta_dv 	    = this.ListaToArray (lista = arguments, variavel = "CONTA_DV_BANCO");	
               v_conta_padrao   = this.ListaToArray (lista = arguments, variavel = "PADRAO_BANCO");
			   v_valida_edicao  = this.ListaToArray (lista = arguments, variavel = "VERIFICA_EDICAO_BANCO");
			   v_excluir        = this.ListDiff(lista1 = arguments.lista_deleted_BANCO, lista2 = ArrayToList(v_banco_id));			
			   v_cod_pessoa_titular = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_TITULAR_BANCO");
			   v_conta_tipo_id      = this.ListaToArray (lista = arguments, variavel = "CONTA_TIPO_ID_BANCO");			
            </cfscript>
            <!---Exclui as contas--->
            <cfloop list="#v_excluir#" delimiters="," index="i">
				<cfscript>
                    ret_ban = this.exclui_conta_bancaria(cod_pessoa = retorno.cod_pessoa
														,banco_id   = ListGetAt(i,1,'_')
														,agencia_id = ListGetAt(i,2,'_')
														,conta      = ListGetAt(i,3,'_')
														);
                </cfscript>
                
                <cfif ret_ban.erro>
                    <cfthrow object="#ret_ban.mensagem#">
                </cfif>
            </cfloop>                
              <!---Insere as novas ou atualiza as existentes--->
              <cfloop from="1" to="#ArrayLen(v_conta)#" index="count">
                 <cfif Len(Trim(v_banco_id_old[count])) and v_banco_id_old[count] neq ''>
                    <cfscript>
						ret_ban = this.atualiza_conta_bancaria(cod_pessoa   = retorno.cod_pessoa
															  ,banco_id 	= v_banco_id[count]
															  ,agencia_id   = v_agencia_id[count]
															  ,conta 		= v_conta[count]
															  ,conta_dv 	= v_conta_dv[count]
															  ,conta_ag_dv  = v_conta_ag_dv[count]
															  ,conta_padrao = v_conta_padrao[count]
															  ,cod_pessoa_titular = v_cod_pessoa_titular[count]
															  ,conta_tipo_id	  = v_conta_tipo_id[count]
															  ,old_banco_id       = v_banco_id_old[count]
															  ,old_agencia_id     = v_agencia_id_old[count]
															  ,old_conta          = v_conta_old[count]
															  ,old_conta_dv       = v_conta_dv_old[count]
															  );      
					</cfscript>
                 <cfelse>
				    <cfscript>
						 ret_ban = this.insere_conta_bancaria(cod_pessoa   = retorno.cod_pessoa
															 ,banco_id 	   = v_banco_id[count]
															 ,agencia_id   = v_agencia_id[count]
															 ,conta 	   = v_conta[count]
															 ,conta_dv 	   = v_conta_dv[count]
															 ,conta_ag_dv  = v_conta_ag_dv[count]
															 ,conta_padrao = v_conta_padrao[count]
															 ,cod_pessoa_titular = v_cod_pessoa_titular[count]
															 ,conta_tipo_id	     = v_conta_tipo_id[count]
															); 
				    </cfscript>
                 </cfif>
                 <cfif ret_ban.erro>
                    <cfthrow object="#ret_ban.mensagem#">
                 </cfif>
              </cfloop>
        </cfif>  
            
			<!---Alteraes de Email--->
			<cfscript>
            
                v_email_proprietario = this.ListaToArray (lista = arguments, variavel = "EMAIL_PROPRIETARIO");
                v_email_end 		 = this.ListaToArray (lista = arguments, variavel = "EMAIL_END");
                v_email_id 			 = this.ListaToArray (lista = arguments, variavel = "EMAIL_ID");
                v_email_obs 		 = this.ListaToArray (lista = arguments, variavel = "EMAIL_OBS");
                v_email_padrao 		 = this.ListaToArray (lista = arguments, variavel = "PADRAO_EMAIL");
                v_cargo_id 		     = this.ListaToArray(lista = arguments, variavel = "EMAIL_CARGO_ID");
                v_setor_id 			 = this.ListaToArray(lista = arguments, variavel = "EMAIL_SETOR_ID");
				v_email_tipo_id      = this.ListaToArray(lista = arguments, variavel = "EMAIL_TIPO_ID_EMAIL");
				v_old_email_tipo_id  = this.ListaToArray(lista = arguments, variavel = "OLD_EMAIL_TIPO_ID");
                v_email_excluir 	 = this.ListDiff(lista1 = arguments.lista_deleted_email, lista2 = ArrayToList(v_email_id));
            </cfscript>

            <cfloop list="#v_email_excluir#" delimiters="," index="i">
                <cfscript>
                    this.del_email (cod_pessoa        = retorno.cod_pessoa
								   ,email_id          = ListGetAt(i,1,'_')
								   ,old_email_tipo_id = ListGetAt(i,2,'_'))
								   ;
                </cfscript>
            </cfloop>
            <cfloop from="1" to="#ArrayLen(v_email_proprietario)#" index="count">
            
                <cfscript>
                    if(not len(trim(v_email_id[count]))) {
                        this.ins_email(email_end 		  = v_email_end[count]
									  ,email_proprietario = v_email_proprietario[count]
									  ,email_padrao 	  = v_email_padrao[count]
									  ,email_obs 		  = v_email_obs[count]
									  ,cod_pessoa 		  = retorno.cod_pessoa
									  ,cargo_id   		  = v_cargo_id[count]
									  ,setor_id   		  = v_setor_id[count]
									  ,email_tipo_id	  = v_email_tipo_id[count]
									  );
                    } else {
                        this.upd_email(email_id           = v_email_id[count],
                                       email_end		  = v_email_end[count],
                                       email_proprietario = v_email_proprietario[count],
                                       email_padrao 	  = v_email_padrao[count],
                                       email_obs 		  = v_email_obs[count],
                                       cod_pessoa 		  = retorno.cod_pessoa,
                                       cargo_id			  = v_cargo_id[count],
                                       setor_id			  = v_setor_id[count],
									   email_tipo_id	  = v_email_tipo_id[count],
									   old_email_tipo_id  = v_old_email_tipo_id[count]
									   );
                    }
                </cfscript>
            </cfloop>
			<!---Inseres de Endereco--->
			<cfscript>
				v_cod_endereco 	    = this.ListaToArray (lista = arguments, variavel = "COD_ENDERECO_ENDERECO");
				v_cep			    = this.ListaToArray (lista = arguments, variavel = "CEP_ENDERECO");
				v_logradouro	    = this.ListaToArray (lista = arguments, variavel = "LOGRADOURO_ENDERECO");
				v_numero 			= this.ListaToArray (lista = arguments, variavel = "NUMERO_ENDERECO");
				v_complemento	    = this.ListaToArray (lista = arguments, variavel = "COMPLEMENTO_ENDERECO");
				v_bairro 			= this.ListaToArray (lista = arguments, variavel = "BAIRRO_ENDERECO");
				v_municipio 		= this.ListaToArray (lista = arguments, variavel = "MUNICIPIO_ENDERECO");
				v_cod_endereco_tipo = this.ListaToArray (lista = arguments, variavel = "COD_ENDERECO_TIPO_ENDERECO");
				v_uf 				= this.ListaToArray (lista = arguments, variavel = "UF_ENDERECO");
				v_endereco_padrao   = this.ListaToArray (lista = arguments, variavel = "PADRAO_ENDERECO");
				v_municipio_id 	    = this.ListaToArray (lista = arguments, variavel = "MUNICIPIO_ID_ENDERECO");
				v_pais_id			= this.ListaToArray (lista = arguments, variavel = "PAIS_ID");
				v_estado_provincia  = this.ListaToArray (lista = arguments, variavel = "ESTADO_PROVINCIA");
				v_codigo_postal	    = this.ListaToArray (lista = arguments, variavel = "CODIGO_POSTAL");
				v_endereco_excluir  = this.ListDiff(lista1 = arguments.lista_deleted_endereco, lista2 = ArrayToList(v_cod_endereco, ','));				
			</cfscript>
			
			<cfloop list="#v_endereco_excluir#" delimiters="," index="l_cod_endereco">
				<cfscript>
					this.del_endereco (cod_pessoa   = retorno.cod_pessoa,
									   cod_endereco = l_cod_endereco);
				</cfscript>
			</cfloop>			
			<cfloop from="1" to="#ArrayLen(v_cep)#" index="count">
				<cfscript>
				if(not len(trim(v_cod_endereco[count]))) {
					this.ins_endereco(cod_pessoa  		= retorno.cod_pessoa
									 ,cep		  		= v_cep[count]
									 ,logradouro  		= v_logradouro[count]
									 ,numero      		= v_numero[count]
									 ,complemento 		= v_complemento[count]
									 ,bairro      		= v_bairro[count]
									 ,municipio   		= v_municipio[count]
									 ,cod_endereco_tipo = v_cod_endereco_tipo[count]
									 ,uf         	    = v_uf[count]
									 ,padrao      	    = v_endereco_padrao[count]
									 ,municipio_id 	    = v_municipio_id[count]
									 ,pais_id			= v_pais_id[count]
									 ,estado_provincia  = v_estado_provincia[count]
									 ,codigo_postal		= v_codigo_postal[count]
									 );
				} else {
					this.upd_endereco(cod_endereco 		= v_cod_endereco[count]
									 ,cod_pessoa  		= retorno.cod_pessoa
									 ,cep		  		= v_cep[count]
									 ,logradouro  		= v_logradouro[count]
									 ,numero      		= v_numero[count]
									 ,complemento 		= v_complemento[count]
									 ,bairro      		= v_bairro[count]
									 ,municipio   		= v_municipio[count]
									 ,cod_endereco_tipo = v_cod_endereco_tipo[count]
									 ,uf          	    = v_uf[count]
									 ,padrao      	    = v_endereco_padrao[count]
									 ,municipio_id      = v_municipio_id[count]
									 ,pais_id			= v_pais_id[count]
									 ,estado_provincia  = v_estado_provincia[count]
									 ,codigo_postal		= v_codigo_postal[count]
									 );
				}
				</cfscript>
			</cfloop>
			
			<!---Inseres de Telefones--->
			<cfscript>
                v_telefone_id 	   = this.ListaToArray (lista = arguments, variavel = "TELEFONE_ID");
                v_contato     	   = this.ListaToArray (lista = arguments, variavel = "TELEFONE_CONTATO");
                v_ddd      	  	   = this.ListaToArray (lista = arguments, variavel = "TELEFONE_DDD");
                v_prefixo     	   = this.ListaToArray (lista = arguments, variavel = "TELEFONE_PREFIXO");
                v_numero           = this.ListaToArray (lista = arguments, variavel = "TELEFONE_NUMERO");
                v_ramal    		   = this.ListaToArray (lista = arguments, variavel = "RAMAL");
                v_tipo     		   = this.ListaToArray (lista = arguments, variavel = "TELEFONE_TIPO_ID");
                v_padrao   		   = this.ListaToArray (lista = arguments, variavel = "PADRAO_TELEFONE");
                v_cargo_id 		   = this.ListaToArray (lista = arguments, variavel = "TELEFONE_CARGO_ID");
                v_setor_id 		   = this.ListaToArray (lista = arguments, variavel = "TELEFONE_SETOR_ID");
                v_telefone_excluir = this.ListDiff(lista1 = arguments.lista_deleted_telefone, lista2 = ArrayToList(v_telefone_id, ','));
            </cfscript>
            <cfloop list="#v_telefone_excluir#" delimiters="," index="l_telefone_id">
                <cfscript>
                    this.del_telefone (cod_pessoa   = retorno.cod_pessoa,
                                       cod_telefone  = l_telefone_id);
                </cfscript>
            </cfloop>	
            <cfloop from="1" to="#ArrayLen(v_contato)#" index="count">
                <cfscript>
                  if(not len(trim(v_telefone_id[count]))) {
                    this.ins_telefone(cod_pessoa       = retorno.cod_pessoa
									 ,telefone_ddd     = v_ddd[count]
									 ,telefone_prefixo = v_prefixo[count]
									 ,telefone_numero  = v_numero[count]
									 ,telefone_ramal   = v_ramal[count]
									 ,telefone_tipo_id = v_tipo[count]
									 ,telefone_contato = v_contato[count]
									 ,padrao      	   = v_padrao[count]
									 ,cargo_id         = v_cargo_id[count]
									 ,setor_id         = v_setor_id[count]
									 );
                  } else {
                    this.upd_telefone(telefone_id 	   = v_telefone_id[count]
									 ,cod_pessoa  	   = retorno.cod_pessoa
									 ,telefone_ddd	   = v_ddd[count]
									 ,telefone_prefixo = v_prefixo[count]
									 ,telefone_numero  = v_numero[count]
									 ,telefone_ramal   = v_ramal[count]
									 ,telefone_tipo_id = v_tipo[count]
									 ,telefone_contato = v_contato[count]
									 ,padrao      	   = v_padrao[count]
									 ,cargo_id    	   = v_cargo_id[count]
									 ,setor_id    	   = v_setor_id[count]
									 );
                  }
                </cfscript>
            </cfloop>
			<!---Inseres de IE Adicional--->
			<cfif arguments.tipo_pessoa eq 0>
				<cfscript>
					v_iead_inscricao_estadual = this.ListaToArray (lista = arguments, variavel = "IEAD_INSCRICAO_ESTADUAL_IE_ADICIONAL");
					v_iead_uf				  = this.ListaToArray (lista = arguments, variavel = "IEAD_UF_IE_ADICIONAL");
					v_iead_id			 	  = this.ListaToArray (lista = arguments, variavel = "IEAD_ID_IE_ADICIONAL");
					v_ie_excluir         	  = this.ListDiff(lista1 = arguments.lista_deleted_ie_adicional, lista2 = ArrayToList(v_iead_id, ','));				
				</cfscript>
              
				<cfloop list="#v_ie_excluir#" delimiters="," index="l_iead_id">
					<cfscript>
						this.del_ie_adicional(pessoa_inscricao_estadual_id = l_iead_id);
					</cfscript>
				</cfloop>			
				<cfloop from="1" to="#ArrayLen(v_iead_inscricao_estadual)#" index="count">
					<cfscript>
					if(not len(trim(v_iead_id[count]))) {
						this.ins_ie_adicional(cod_pessoa  	     = retorno.cod_pessoa
										     ,inscricao_estadual = v_iead_inscricao_estadual[count]
										     ,uf  				 = v_iead_uf[count]
										     );
					} else {
						this.upd_ie_adicional(pessoa_inscricao_estadual_id	= v_iead_id[count]
										     ,cod_pessoa  		 		   	= retorno.cod_pessoa
										     ,inscricao_estadual 			= v_iead_inscricao_estadual[count]
										     ,uf  				 			= v_iead_uf[count]
										     );
					}
					</cfscript>
				</cfloop>
			</cfif>			
			<!---Inseres de Documentos--->
			<cfscript>
                v_nome_arquivo      = this.ListaToArray (lista = arguments, variavel = "URL");
                v_tipo              = this.ListaToArray (lista = arguments, variavel = "TIPOD");
                v_comentario        = this.ListaToArray (lista = arguments, variavel = "COMENTARIO");		
            </cfscript>
            <cfloop list="#arguments.DOC_EXCLUIR#" delimiters="," index="doc_excluir">
                <cfscript>
                    this.del_documento (cod_documento = doc_excluir);
                </cfscript>
            </cfloop>	

            <cfloop from="1" to="#ArrayLen(v_nome_arquivo)#" index="count">
            	<cfif Len(Trim(v_nome_arquivo[count]))>
					<cfscript>  				
                        ret_banco = this.ins_documento(cod_pessoa  	= retorno.cod_pessoa
                                          ,nome_arquivo	= v_nome_arquivo[count]
                                          ,cod_tipo_doc	= v_tipo[count]
                                          ,observacao   = v_comentario[count]
                                          );
                    </cfscript>
                     <cfif ret_banco.erro>
                        <cfthrow object="#ret_banco.mensagem#">
                     </cfif>
                 </cfif>                                                   
            </cfloop>              
			<!---Inseres de Usuarios--->
			<cfscript>
				v_login = this.ListaToArray (lista = arguments, variavel = "USUARIO_LOGIN");
				v_senha = this.ListaToArray (lista = arguments, variavel = "USUARIO_SENHA");
				v_nome  = this.ListaToArray (lista = arguments, variavel = "USUARIO_NOME");
				v_email = this.ListaToArray (lista = arguments, variavel = "USUARIO_EMAIL");				
			</cfscript>
            
			<cfif IsDefined("arguments.num_modalidade") and Len(Trim(arguments.num_modalidade))>
				<cfloop from="1" to="#ArrayLen(v_login)#" index="count">
					<cfscript>
						this.ins_usuario (cod_pessoa = retorno.cod_pessoa
										 ,usuario    = v_login[count]
										 ,nome       = v_nome[count]
										 ,senha      = v_senha[count]
										 ,email      = v_email[count]
										 );
					</cfscript>
				</cfloop>
				<!--- Verifica se a pessoa j est relacionada a alguma modalidade --->
				<cfscript>
					conn = CreateComponent("modulos.pessoa._componentes.consulta.cfc_pessoa");
					qrPessoaModalidade = conn.getPessoaModalidade(cod_pessoa     = retorno.cod_pessoa
					                                             ,num_modalidade = arguments.num_modalidade
																  );
					if (qrPessoaModalidade.RecordCount eq 0) {
						this.ins_pessoa_modalidade(cod_pessoa    = retorno.cod_pessoa
												  ,num_modalidade = arguments.num_modalidade,situacao=1
												  );
					}
					else {
						if(qrPessoaModalidade.possui_central_cadastros eq 0){
							this.upd_pessoa_modalidade(cod_pessoa = retorno.cod_pessoa
													  ,num_modalidade = arguments.num_modalidade,situacao=1
													  );
						}
					}
					
										   
				</cfscript>
			</cfif>

			<!---Inseres regras de faturamento--->
            <cfif IsDefined("arguments.PAGADOR")>
				<cfscript>
                    v_pagador        = this.ListaToArray (lista = arguments, variavel = "PAGADOR_FATURAMENTO");
                    v_dia_inicial    = this.ListaToArray (lista = arguments, variavel = "DIA_INICIAL_FATURAMENTO");
                    v_dia_final      = this.ListaToArray (lista = arguments, variavel = "DIA_FINAL_FATURAMENTO");
                    v_dia_vencimento = this.ListaToArray (lista = arguments, variavel = "DIA_VENCIMENTO_FATURAMENTO");
                    v_mes_vencimento = this.ListaToArray (lista = arguments, variavel = "MES_VENCIMENTO_FATURAMENTO");
                </cfscript>
                <cfloop list="#arguments.LISTA_DELETED_FATURAMENTO#" index="i" delimiters=","> 
                    <cfscript>
                        if (ListLen(i,'_') gt 0){
                            ret = this.del_faturamento_regra(cod_pessoa  = retorno.cod_pessoa
                                                            ,dia_inicial = ListGetAt(i,1,'_') 
                                                            ,dia_final   = ListGetAt(i,2,'_') 
                                                            ,pagador     = ListGetAt(i,3,'_'));
                        }
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>					
                 </cfloop>
                 
                
                <cfloop from="1" to="#ArrayLen(v_pagador)#" index="count">
                    <cfscript>
						ret = this.del_faturamento_regra(cod_pessoa  = retorno.cod_pessoa
														,dia_inicial = v_dia_inicial[count]
														,dia_final   = v_dia_final[count]  
														,pagador     = v_pagador[count]);
						
                        set_fat_regra = this.ins_faturamento_regra(cod_pessoa     = retorno.cod_pessoa
																  ,dia_inicial    = v_dia_inicial[count]
																  ,dia_final      = v_dia_final[count]
																  ,dia_vencimento = v_dia_vencimento[count]
																  ,pagador        = v_pagador[count]
																  ,mes_vencimento = v_mes_vencimento[count]
																  );
                    </cfscript>
					<cfif set_fat_regra.erro>
                        <cfthrow object="#set_fat_regra.mensagem#"/>
                    </cfif>
                    
                </cfloop>
            </cfif>
            
			<!---Inseres regras de faturamento--->
            <cfif IsDefined("arguments.FAT_FORMA_ID") and IsDefined("arguments.FAT_AGRUPAMENTO_ID") and IsDefined("arguments.FAT_CONDICAO_ID")
			  and IsDefined("arguments.C026_ID") and IsDefined("arguments.COD_MOEDA")>
            	<cfscript>
				set_fat = this.ins_pessoa_faturamento(cod_pessoa         = retorno.cod_pessoa,
                                                      fat_forma_id       = arguments.FAT_FORMA_ID,
                                                      fat_agrupamento_id = arguments.FAT_AGRUPAMENTO_ID,
                                                      fat_condicao_id    = arguments.FAT_CONDICAO_ID,
                                                      c026_ID            = arguments.C026_ID,
                                                      num_dias_protesto  = arguments.NUM_DIAS_PROTESTO,
                                                      cod_moeda          = arguments.COD_MOEDA
                                                     );
				</cfscript>
				<cfif set_fat.erro>
                    <cfthrow object="#set_fat.mensagem#"/>
                </cfif>
            </cfif>

			<cfif  IsDefined("arguments.COD_CONTA") and len(trim(arguments.COD_CONTA))>
					<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="16">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.COD_CONTA#">
				</cfstoredproc>
			</cfif>
			<cfif  IsDefined("arguments.CONTATO_CORRESPONDENCIA") and len(trim(arguments.CONTATO_CORRESPONDENCIA))>
					<cfstoredproc procedure="kss.pkg_pessoa.prc_set_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam  	type="in"	cfsqltype="cf_sql_integer" value="#retorno.cod_pessoa#">
					<cfprocparam 	type="in"	cfsqltype="cf_sql_integer" value="17">
					<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.CONTATO_CORRESPONDENCIA#">
				</cfstoredproc>
			</cfif>
            
            <cfif IsDefined("arguments.POSSUI_CENTRAL_CAD") and arguments.POSSUI_CENTRAL_CAD eq 1>
               	<cfscript>
                   ret = this.atualizar_centra_cadastros(COD_PESSOA = retorno.cod_pessoa);
                </cfscript>
                <cfif ret.erro>
                   <cfthrow object="#ret.mensagem#">
                </cfif>
            </cfif>
            
            <cfscript>
			   ret_val = this.valida_pessoa(COD_PESSOA = retorno.cod_pessoa);
			</cfscript>
			<cfif ret_val.erro>
			   <cfthrow object="#ret_val.mensagem#">
			</cfif>
			
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Pessoa alterada com sucesso!")>
		</cftransaction>

		<cfcatch type="database">
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<cffunction name="del_pessoa" displayname="Insere uma pessoa no sistema" access="remote" returntype="Struct" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 07/10/2005 - criado
	--->			
	<cfargument name="tipo_pessoa" required="yes">
	<cftry>
		<cftransaction action="begin">
			<!---Insero da Pessoa--->
			<cfif arguments.tipo_pessoa eq 0>
				<cfscript>
					retorno.cod_pessoa = this.del_pessoa_juridica(argumentCollection = arguments);
				</cfscript>
			<cfelseif arguments.tipo_pessoa eq 1>
				<cfscript>
					retorno.cod_pessoa = this.del_pessoa_fisica(argumentCollection = arguments);
				</cfscript>
			</cfif>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Pessoa excluida com sucesso!")>
		</cftransaction>
		<cfcatch type="database">
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>


<cffunction name="ins_pessoa_juridica" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 07/10/2005 - criado
	--->			
	<cfargument name="CNAE"                 	 required="no" default="00000">
	<cfargument name="cod_atividade_fiscal" 	 required="no" default="1">
	<cfargument name="data_admissao"        	 required="no" default="#now()#" >
    <cfargument name="alvara_pj"            	 required="no" default="">
	<cfargument name="rntrc_tac" 			     required="no" default="">
	<cfargument name="data_vencimento_rntrc_tac" required="no" default="">    
    <cfargument name="data_emissao_rntrc_tac" 	 required="no" default="">
    <cfargument name="SUFRAMA" 					 required="no" default="">
    <cfargument name="COD_REGIME_TRIBUTARIO" 	 required="no" default="">
    <cfargument name="TIPO_LUCRO" 				 required="no" default="">    
    <cfargument name="tipo_transportador" 		 required="no" default="">
    <cfargument name="dolar_fixo" 				 required="no" default="0">
	<cfif not len(trim(arguments.cnae))>
		<cfset arguments.cnae = '00000'>
	</cfif>
    <cfif not len(trim(arguments.cod_atividade_fiscal))>
		<cfset arguments.cod_atividade_fiscal = 1>
	</cfif>
	<cfstoredproc procedure="kss.pkg_pessoa.prc_insere_pessoa_juridica" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  			     type="inout"	variable="retorno.cod_pessoa" cfsqltype="cf_sql_bigint" value="#arguments.cod_pessoa#" null="#iif(len(trim(arguments.cod_pessoa)), de('no'), de('yes'))#">
		<cfprocparam 		 	     type="in" 		cfsqltype="cf_sql_varchar" value="#Left(arguments.cnpj_completo, 8)#">
		<cfprocparam 			 	 type="in" 	 	cfsqltype="cf_sql_varchar" value="#mid(arguments.cnpj_completo, 9, 4)#">
		<cfprocparam 				 	 type="in"	 	cfsqltype="cf_sql_varchar" value="#Right(arguments.cnpj_completo, 2)#">
		<cfprocparam 			 	 type="inout" 	cfsqltype="cf_sql_varchar" value="#arguments.razao_social#">
		<cfprocparam 		 	 type="inout" 	cfsqltype="cf_sql_varchar" value="#arguments.nome_fantasia#">
		<cfprocparam  	 	 type="in" 		cfsqltype="cf_sql_varchar" value="#UCase(arguments.inscricao_estadual_pj)#" null="#iif(len(trim(arguments.inscricao_estadual_pj)), de('no'), de('yes'))#">
		<cfprocparam  	 	 type="in" 		cfsqltype="cf_sql_varchar" null="yes">
		<cfprocparam  	 type="inout" 	cfsqltype="cf_sql_varchar" value="#Left(arguments.razao_social, 30)#">
		<cfprocparam  				 	 type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.CNAE#">
		<cfprocparam   	 type="in" 		cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_atividade_fiscal#">
		<cfprocparam 	 	 	 type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.data_admissao_pj#">
		<cfprocparam  		 	 type="in" 		cfsqltype="cf_sql_varchar" null="yes">
		<cfprocparam  			 	 type="in" 		cfsqltype="cf_sql_varchar" null="yes">
        <cfprocparam  			     	 type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.alvara_pj#">
        <cfprocparam 	 			 	 type="in"		cfsqltype="cf_sql_integer"	null="yes">
        <cfprocparam  				 type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.rntrc_tac#">
		<cfprocparam  type="in"  	cfsqltype="cf_sql_varchar" value="#arguments.data_vencimento_rntrc_tac#">
        <cfprocparam 	 type="in"  	cfsqltype="cf_sql_varchar" value="#arguments.data_emissao_rntrc_tac#">
        <cfprocparam  					 type='IN' 		cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SUFRAMA#' >
        <cfprocparam  	 type='IN' 		cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REGIME_TRIBUTARIO#'  null='#iif(len(trim(arguments.COD_REGIME_TRIBUTARIO)), de('no'), de('yes'))#'>
        <cfprocparam  				 type='IN' 		cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_LUCRO#'  null='#iif(len(trim(arguments.TIPO_LUCRO)), de('no'), de('yes'))#'>        
        <cfprocparam  		 type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.tipo_transportador#">
        <cfprocparam  			 type="in" 		cfsqltype="cf_sql_varchar" null="yes">
	</cfstoredproc>	
	<cfreturn retorno.cod_pessoa />		
</cffunction>

<cffunction name="ins_pessoa_fisica" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 07/10/2005 - criado
	--->		
		<cfargument name="cod_pessoa" 			required="no" default="">
		<cfargument name="cpf" 					required="no" default="">
		<cfargument name="nome"					required="no" default="">
		<cfargument name="inscricao_estadual" 	required="no" default="">
		<cfargument name="nome_pai" 			required="no" default="">
		<cfargument name="nome_mae" 			required="no" default="">
        <cfargument name="rg" 					required="no" default="">
		<cfargument name="RG_ORGAO" 			required="no" default="">
        <cfargument name="P_CART_IDENT_EMISSAO"	required="no" default="">
		<cfargument name="estado_civil" 		required="no" default="">
		<cfargument name="data_nascimento" 		required="no" default="">
		<cfargument name="VALIDADE_CNH" 		required="no" default="">
		<cfargument name="CNH" 					required="no" default="">
		<cfargument name="CATEGORIA_CNH" 		required="no" default="">
		<cfargument name="rntrc" 				required="no" default="">
		<cfargument name="validade_rntrc" 		required="no" default="">
		<cfargument name="rntrc_tac" 			     required="no" default="">
        <cfargument name="data_emissao_rntrc_tac" required="no" default="">   
		<cfargument name="data_vencimento_rntrc_tac" required="no" default="">           
		<cfargument name="primeira_cnh" 		required="no" default="">
		<cfargument name="ja_carrega_empresa" 	required="no" default="0">
		<cfargument name="uf_cnh" 				required="no" default="">
		<cfargument name="nome_escritorio" 		required="no" default="">
		<cfargument name="contatos" 		    required="no" default="0">
		<cfargument name="empresas_representadas" required="no" default="">       
		<cfargument name="pis_pasep_nit" 		required="no" default="">
		<cfargument name="naturalidade" 		required="no" default="">    
        <cfargument name="uf_naturalidade" 		required="no" default=""> 
        <cfargument name="cnh_data_emissao" 	required="no" default="">
        <cfargument name="alvara_pf"			 required="no" default="">      
        <cfargument name="cnae"					required="no" default="">
        <cfargument name='cart_ident_uf' 		required='no' default="">
        <cfargument name="dolar_fixo" required="no" default="0">
        <cfargument name="tipo_transportador" required="no" default="">
		<cfargument name="cod_sexo"				required="no" default="">
 		<cfargument name="COD_NACIONALIDADE_ESOCIAL"				required="no" default="">
		<cfargument name="COD_PAIS_NASCIMENTO"				required="no" default="">
		<cfargument name="RACA_COR"				required="no" default="">
		<cfargument name="GRAU_INSTRUCAO"				required="no" default="">
		<cfargument name="DEF_FISICA"				required="no" default="">
		<cfargument name="DEF_VISUAL"				required="no" default="">
		<cfargument name="DEF_AUDITIVA"				required="no" default="">
		<cfargument name="DEF_MENTAL"				required="no" default="">
		<cfargument name="DEF_INTELECTUAL"				required="no" default="">
		<cfargument name="DEF_REABILITADO"				required="no" default="">
		<cfargument name="OBSERVACAO_ESOCIAL"				required="no" default="">
		
		<cfif not len(trim(arguments.inscricao_estadual))>
			<cfset arguments.inscricao_estadual = "ISENTO">
		</cfif>
		
		
		
		

		<cfstoredproc procedure="kss.pkg_pessoa.prc_insere_pessoa_fisica" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam  			        type="inout"	variable="retorno.cod_pessoa" cfsqltype="cf_sql_bigint" value="#arguments.cod_pessoa#" null="#iif(len(trim(arguments.cod_pessoa)), de('no'), de('yes'))#">
			<cfprocparam 	 			type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.data_admissao_pf#">
			<cfprocparam  							type="in" 	 	cfsqltype="cf_sql_varchar" value="#Left(arguments.cpf, 9)#">
			<cfprocparam  						type="in"	 	cfsqltype="cf_sql_varchar" value="#Right(arguments.cpf, 2)#">
			<cfprocparam  						type="inout" 	cfsqltype="cf_sql_varchar" value="#arguments.nome#">
			<cfprocparam  					type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.cod_sexo#">
			<cfprocparam  			type="in" 		cfsqltype="cf_sql_integer" null="yes">
			<cfprocparam  			type="in" 		cfsqltype="cf_sql_integer" value="#arguments.estado_civil#" null="#iif(len(trim(arguments.estado_civil)), de('no'), de('yes'))#">
			<cfprocparam  				type="in" 		cfsqltype="cf_sql_varchar" value="#LSDateFormat(arguments.data_nascimento)#">
			<cfprocparam  				type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.rg#">
			<cfprocparam  			type="in" 		cfsqltype="cf_sql_varchar" value="#UCase(arguments.rg_orgao)#">
            <cfprocparam  			type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.CART_IDENT_EMISSAO#" >
            <cfprocparam  			type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.cnh#">
			<cfprocparam  				type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.validade_cnh#">
			<cfprocparam  			type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.categoria_cnh#">
			<cfprocparam  			type="in" 		cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam  			type="in" 		cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam  			type="in" 		cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam 		 	type="in" 		cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam 		 	type="in" 		cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam  					type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.nome_pai#">
			<cfprocparam  				type="inout" 		cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam  			type="inout" 		cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam  					type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.nome_mae#">
			<cfprocparam  				type="inout" 		cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam  			type="inout" 		cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam  					type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.observacao#">
			<cfprocparam  				type="in" 		cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam  				type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.pis_pasep_nit#">
			<cfprocparam  				type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.naturalidade#">
			<cfprocparam  				type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.uf_naturalidade#">
			<cfprocparam 			type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.inscricao_estadual#">
            <cfprocparam  						type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.cnae#">         
		    <cfprocparam 	 					type="in"		cfsqltype="cf_sql_integer"	null="yes">
        	<cfprocparam 			type="in" 	    cfsqltype="cf_sql_integer" null="yes">
            <cfprocparam  					type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.cnh_numero#">
            <cfprocparam  						type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.cnh_uf#">
            <cfprocparam  					type="in" 		cfsqltype="cf_sql_varchar" null="yes">
            <cfprocparam  					type="in" 		cfsqltype="cf_sql_varchar" null="yes">
            <cfprocparam  						type="in" 		cfsqltype="cf_sql_varchar" null="yes">
         	<cfprocparam  					type="in" 		cfsqltype="cf_sql_varchar" value="#arguments.rntrc_tac#">
        	<cfprocparam 	type="in"  		cfsqltype="cf_sql_varchar" value="#arguments.data_vencimento_rntrc_tac#">
            <cfprocparam        type="in"  		cfsqltype="cf_sql_varchar" value="#arguments.data_emissao_rntrc_tac#">
            <cfprocparam 	            type='in'   	cfsqltype='cf_sql_varchar' value='#arguments.cart_ident_uf#' >
  		    <cfprocparam  		    type='in' 		cfsqltype='cf_sql_varchar'  value='#arguments.cnh_data_emissao#' >
  			<cfprocparam  	type='in' 		cfsqltype='cf_sql_varchar'   value='#arguments.cnh_primeira_habilitacao#' >
            <cfprocparam  	  		type="in"		cfsqltype="cf_sql_varchar" value="#arguments.tipo_transportador#">
			<cfprocparam 				type="in" 	    cfsqltype="cf_sql_integer" null="yes">
			<cfprocparam 			type="in" 	    cfsqltype="cf_sql_varchar" null="yes">
			<cfprocparam 			type="in" 	    cfsqltype="cf_sql_integer" value="0">
			<cfprocparam 						type="in" 	    cfsqltype="cf_sql_integer" null="yes">
			<cfprocparam  					type="in"  		cfsqltype="cf_sql_varchar" value="#arguments.nome_social#">
			<cfprocparam  			type="in"  		cfsqltype="cf_sql_varchar" value="#arguments.COD_NACIONALIDADE_ESOCIAL#">
			<cfprocparam  				type="in"  		cfsqltype="cf_sql_varchar" value="#arguments.COD_PAIS_NASCIMENTO#">
			<cfprocparam  					type="in"  		cfsqltype="cf_sql_integer" value="#arguments.RACA_COR#" null="#iif(len(trim(arguments.RACA_COR)), de('no'), de('yes'))#">
			<cfprocparam  				type="in"  		cfsqltype="cf_sql_varchar" value="#arguments.GRAU_INSTRUCAO#">
			<cfprocparam  					type="in"  		cfsqltype="cf_sql_integer" value="#iif(len(trim(arguments.DEF_FISICA)), de(arguments.DEF_FISICA), de(0))#">
			<cfprocparam  					type="in"  		cfsqltype="cf_sql_integer" value="#iif(len(trim(arguments.DEF_VISUAL)), de(arguments.DEF_VISUAL), de(0))#">
			<cfprocparam  				type="in"  		cfsqltype="cf_sql_integer" value="#iif(len(trim(arguments.DEF_AUDITIVA)), de(arguments.DEF_AUDITIVA), de(0))#">
			<cfprocparam  					type="in"  		cfsqltype="cf_sql_integer" value="#iif(len(trim(arguments.DEF_MENTAL)), de(arguments.DEF_MENTAL), de(0))#">
			<cfprocparam  				type="in"  		cfsqltype="cf_sql_integer" value="#iif(len(trim(arguments.DEF_INTELECTUAL)), de(arguments.DEF_INTELECTUAL), de(0))#">
			<cfprocparam  				type="in"  		cfsqltype="cf_sql_integer" value="#iif(len(trim(arguments.DEF_REABILITADO)), de(arguments.DEF_REABILITADO), de(0))#">
			<cfprocparam  				type="in"  		cfsqltype="cf_sql_varchar" value="#arguments.OBSERVACAO_ESOCIAL#">
			<cfprocparam     		type="in"  		cfsqltype="cf_sql_numeric" value="#arguments.LIMITE_CARGA_VALOR#" null="#iif(len(trim(arguments.LIMITE_CARGA_VALOR)), de('no'), de('yes'))#">
			<cfprocparam  				    type="in"  		cfsqltype="cf_sql_varchar" value="#arguments.CNH_RENACH#">


			
        </cfstoredproc>
        
	<cfreturn retorno.cod_pessoa />		
</cffunction>

<cffunction name="ins_pessoa_estrangeira" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 07/10/2005 - criado
	--->		
	<cfargument name="municipio_id"   required="no" default=""/>
	<cfargument name="rntrc_tac" 			     required="no" default="">
	<cfargument name="data_vencimento_rntrc_tac" required="no" default="">    
    <cfargument name="data_emissao_rntrc_tac" required="no" default="">
    <cfargument name="tipo_transportador" required="no" default="">
    <cfargument name="dolar_fixo" required="no" default="0">
    
	<cfstoredproc procedure="kss.pkg_pessoa.prc_insere_pessoa_estrangeira" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  					type="inout" cfsqltype="cf_sql_integer" variable="retorno.cod_pessoa" value="#arguments.COD_PESSOA#" null="#iif(len(trim(arguments.cod_pessoa)), de('no'), de('yes'))#">
		<cfprocparam  						type="inout" cfsqltype="cf_sql_varchar" value="#arguments.PE_NOME#">
		<cfprocparam  				type="in"    cfsqltype="cf_sql_varchar" value="#arguments.data_admissao_pe#">        
		<cfprocparam  				type="in"    cfsqltype="cf_sql_varchar" null="yes">
		<cfprocparam  					type="in"    cfsqltype="cf_sql_varchar" value="">
		<cfprocparam  				type="inout" cfsqltype="cf_sql_varchar" value="#left(arguments.PE_NOME_FANTASIA,60)#">
		<cfprocparam     type="in"    cfsqltype="cf_sql_varchar" value="#arguments.COD_CADASTRO_CONTRIBUINTE#">
        <cfprocparam  					type="in"    cfsqltype="cf_sql_varchar" value="#arguments.rntrc_tac#">
   		<cfprocparam 	type="in"  	 cfsqltype="cf_sql_varchar" value="#arguments.data_vencimento_rntrc_tac#">
        <cfprocparam 		type="in"  	 cfsqltype="cf_sql_varchar" value="#arguments.data_emissao_rntrc_tac#">
      	<cfprocparam  			type="in" 	 cfsqltype="cf_sql_varchar" value="#arguments.tipo_transportador#">
    </cfstoredproc>
	<cfreturn retorno.cod_pessoa />		
</cffunction>

<cffunction name="ins_email" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 07/10/2005 - criado
	--->	
	<cfargument name="email_end" required="yes">
	<cfargument name="email_proprietario" required="yes">
	<cfargument name="email_padrao" required="yes">
	<cfargument name="email_obs" required="yes">
	<cfargument name="cod_pessoa" required="yes">
    <cfargument name="cargo_id" required="no" default="">
    <cfargument name="setor_id" required="no" default="">
    <cfargument name="email_tipo_id" required="no" default="">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_insere_email" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  			type="out"	variable="email_id" 		cfsqltype="cf_sql_integer">
		<cfprocparam 	 	type="in"	cfsqltype="cf_sql_varchar" 	value="#ListGetAt(arguments.email_end, 1, '@')#">
		<cfprocparam 	 	type="in"	cfsqltype="cf_sql_varchar" 	value="#ListGetAt(arguments.email_end, 2, '@')#">
		<cfprocparam  	type="in"	cfsqltype="cf_sql_varchar" 	value="#arguments.email_proprietario#">
		<cfprocparam 	 		type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.email_padrao#">
		<cfprocparam 	 		type="in"	cfsqltype="cf_sql_varchar" 	value="#arguments.email_obs#">
		<cfprocparam 	 		type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.cod_pessoa#">
        <cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer"	null="yes">
		<cfprocparam 	 			type="out"	cfsqltype="cf_sql_varchar"	variable="rowid">
        <cfprocparam 	type="in"	cfsqltype="cf_sql_integer" 	value="1">
        <cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.cargo_id#" null="#iif(len(trim(arguments.cargo_id)), de('no'), de('yes'))#">
		<cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.setor_id#" null="#iif(len(trim(arguments.setor_id)), de('no'), de('yes'))#">
        <cfprocparam 	 	type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.email_tipo_id#" null="#iif(len(trim(arguments.email_tipo_id)), de('no'), de('yes'))#">
	</cfstoredproc>	
	<cfreturn email_id />		
</cffunction>

<cffunction name="ins_endereco" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">

<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="cod_pessoa"        required="yes">
	<cfargument name="cep"               required="yes">
	<cfargument name="logradouro"        required="yes">
	<cfargument name="numero"            required="yes">
	<cfargument name="complemento"       required="yes">
	<cfargument name="bairro"            required="yes">
	<cfargument name="municipio"         required="yes">
	<cfargument name="cod_endereco_tipo" required="yes">
	<cfargument name="uf"                required="yes">
	<cfargument name="padrao"            required="no" default="1">
	<cfargument name="municipio_id"      required="no" default="">
	<cfargument name="pais_id"           required="no" default="">
	<cfargument name="estado_provincia"  required="no" default="">
	<cfargument name="codigo_postal"     required="no" default="">
	<cfif not len(trim(arguments.cep))>
		<cfset arguments.cep = '00000000'>
	</cfif>
    <cfif not len(trim(arguments.municipio))>
    	<cfthrow 
        	message="No foi fornecido o municipio para o endereco"
            detail="No foi fornecido o municipio para o endereco">
    </cfif>
	<cfstoredproc procedure="kss.pkg_pessoa.prc_insere_endereco" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      <cfprocparam            type="in"      cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
      <cfprocparam          type="out"     cfsqltype="cf_sql_numeric" variable="cod_endereco">
      <cfprocparam                   type="in"      cfsqltype="cf_sql_varchar" value="#arguments.cep#">
      <cfprocparam            type="inout"   cfsqltype="cf_sql_varchar" value="#arguments.logradouro#">
      <cfprocparam                type="in"      cfsqltype="cf_sql_varchar" value="#arguments.numero#">
      <cfprocparam           type="inout"   cfsqltype="cf_sql_varchar" value="#arguments.complemento#">
      <cfprocparam                type="inout"   cfsqltype="cf_sql_varchar" value="#arguments.bairro#">
      <cfprocparam                    type="in"      cfsqltype="cf_sql_varchar" value="#UCase(arguments.uf)#">
      <cfprocparam             type="inout"   cfsqltype="cf_sql_varchar" value="#arguments.municipio#" variable="retorno.municipio">
      <cfprocparam     type="in"      cfsqltype="cf_sql_integer" value="#arguments.cod_endereco_tipo#">
      <cfprocparam       type="in"      cfsqltype="cf_sql_integer" value="#arguments.padrao#">
      <cfprocparam          type="in"      cfsqltype="cf_sql_integer" value="#arguments.municipio_id#" null="#iif(len(trim(arguments.municipio_id)), de('no'), de('yes'))#">
      <cfprocparam               type="in"      cfsqltype="cf_sql_integer" null="yes">
      <cfprocparam                 type="out"     cfsqltype="cf_sql_varchar" variable="rowid">
      <cfprocparam  type="in"      cfsqltype="cf_sql_integer" null="yes">
      <cfprocparam    type="in"      cfsqltype="cf_sql_varchar" null="yes">
      <cfprocparam  type="in"      cfsqltype="cf_sql_integer" null="yes">
      <cfprocparam         type="in"      cfsqltype="cf_sql_integer" null="yes">   
      <cfprocparam               type="in"      cfsqltype="cf_sql_integer" value="#arguments.pais_id#">
      <cfprocparam      type="in"      cfsqltype="cf_sql_varchar" value="#arguments.estado_provincia#">
      <cfprocparam         type="in"      cfsqltype="cf_sql_varchar" value="#arguments.codigo_postal#">
	</cfstoredproc>	
	<cfreturn cod_endereco />		
</cffunction>

<cffunction name="ins_telefone" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
    <!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="telefone_ddd" required="yes">
	<cfargument name="telefone_prefixo" required="yes">
	<cfargument name="telefone_numero" required="yes">
	<cfargument name="telefone_ramal" required="yes">
	<cfargument name="telefone_tipo_id" required="yes">
	<cfargument name="telefone_contato" required="yes">
	<cfargument name="padrao" required="no" default="1">
	<cfargument name="cargo_id" required="no" default="">
	<cfargument name="setor_id" required="no" default="">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_insere_telefone" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  			type="out"	cfsqltype="cf_sql_integer"	variable="telefone_id">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_varchar"	value="55">
		<cfprocparam  					type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.telefone_ddd#">
		<cfprocparam  				type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.telefone_prefixo#">
		<cfprocparam  				type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.telefone_numero#">
		<cfprocparam  				type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.telefone_ramal#">
		<cfprocparam  				type="inout" cfsqltype="cf_sql_integer"	value="#arguments.telefone_tipo_id#">
		<cfprocparam  				type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.telefone_contato#">
		<cfprocparam  				type="in"	cfsqltype="cf_sql_integer"	value="#arguments.padrao#">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
		<cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer" 	null="yes">
		<cfprocparam  				type="out"	cfsqltype="cf_sql_varchar"	variable="rowid">
        <cfprocparam 	type="in"	cfsqltype="cf_sql_integer" 	value="1">
        <cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.cargo_id#" null="#iif(len(trim(arguments.cargo_id)), de('no'), de('yes'))#">
		<cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.setor_id#" null="#iif(len(trim(arguments.setor_id)), de('no'), de('yes'))#">
	</cfstoredproc>	
	<cfreturn telefone_id />		
</cffunction>

<cffunction name="ins_usuario" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="usuario" required="yes">
	<cfargument name="senha" required="yes">
	<cfargument name="nome" required="yes">
	<cfargument name="email" required="yes">
	<cfargument name="cod_pessoa" required="yes">
	<cfstoredproc procedure="transportes.pkg_controle.prc_ins_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_varchar"	value="#UCASE(arguments.usuario)#">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.senha#">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.nome#">
		<cfprocparam  	type="in"	cfsqltype="cf_sql_varchar"	value="#ListGetAt(arguments.email, 1, '@')#">
		<cfprocparam 	type="in"	cfsqltype="cf_sql_varchar"	value="#ListGetAt(arguments.email, 2, '@')#">
		<cfprocparam  		type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>

<cffunction name="ins_pessoa_modalidade" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="num_modalidade" required="yes">
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="situacao" required="no" default="1">
	<cfargument name="nova_pessoa" required="no" default="0">    
	
	<!--- De acordo com a modalidade a ser inserida, esta sendo Agregado, Frota ou Terceiro, desativa as outras --->
	<cfscript>
		if (arguments.NUM_MODALIDADE eq 2 and arguments.nova_pessoa eq 0) {
			this.del_pessoa_modalidade_private(num_modalidade = 6, cod_pessoa = arguments.COD_PESSOA);
			this.del_pessoa_modalidade_private(num_modalidade = 8, cod_pessoa = arguments.COD_PESSOA);
		}
		else if (arguments.NUM_MODALIDADE eq 6 and arguments.nova_pessoa eq 0) {
			this.del_pessoa_modalidade_private(num_modalidade = 2, cod_pessoa = arguments.COD_PESSOA);
			this.del_pessoa_modalidade_private(num_modalidade = 8, cod_pessoa = arguments.COD_PESSOA);
		}
		else if (arguments.NUM_MODALIDADE eq 8 and arguments.nova_pessoa eq 0) {
			this.del_pessoa_modalidade_private(num_modalidade = 2, cod_pessoa = arguments.COD_PESSOA);
			this.del_pessoa_modalidade_private(num_modalidade = 6, cod_pessoa = arguments.COD_PESSOA);
		}
			// As modalidades 3 e 7 estavam duplicadas, nas bases novas ficar apenas a 7
			// este if foi retornado da verso anterior do CFC... com crtz no e a melhor soluo, mas revirei o cfc, os arquivos web do cadastro de proprietrio, vi se tinha especfico e no encontrei onde manda modalidade como 3 =\  Como era emergencia, voltei essa soluo
		if (arguments.NUM_MODALIDADE eq 3) {
			arguments.NUM_MODALIDADE = 7;
		}
	</cfscript>
	<cfstoredproc procedure="kss.pkg_modalidade.prc_ins_modalidade" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam 	type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.num_modalidade#">
		<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.cod_pessoa#">
		<cfprocparam 			type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.situacao#">
            <cfprocparam 	 		type="in"	cfsqltype="cf_sql_integer" null="yes">
		<cfprocparam             type='OUT'  cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID'>
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>

<cffunction name="upd_pessoa_modalidade" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- ARLEN 11/10/2006 - criado
	--->	
	<cfargument name="num_modalidade" required="yes">
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="situacao" required="no" default="1">
	<cfstoredproc procedure="kss.pkg_modalidade.prc_alt_modalidade" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam 	type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.num_modalidade#">
		<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.cod_pessoa#">
		<cfprocparam 			type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.situacao#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>
<cffunction name="del_pessoa_modalidade_private" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 12/04/2007 - criado
	--->	
	<cfargument name="num_modalidade" required="yes">
	<cfargument name="cod_pessoa" required="yes">
	<cfstoredproc procedure="kss.pkg_modalidade.prc_del_modalidade" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam 	type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.num_modalidade#">
		<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.cod_pessoa#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>
<cffunction name="ins_gestao" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="cod_pessoa" required="yes">
	<cfstoredproc procedure="transportes.pkg_controle.prc_ins_pessoa_gestao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.cod_pessoa#">
		<cfprocparam 		type="out"	cfsqltype="cf_sql_integer"	variable="cod_gestao">
	</cfstoredproc>	
	<cfreturn cod_gestao />		
</cffunction>

<cffunction name="upd_email" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 07/10/2005 - criado
	--->	
	<cfargument name="email_id" 			required="yes">
	<cfargument name="email_end" 			required="yes">
	<cfargument name="email_proprietario"	required="yes">
	<cfargument name="email_padrao" 		required="yes">
	<cfargument name="email_obs" 			required="yes">
	<cfargument name="cod_pessoa" 			required="yes">
    <cfargument name="cargo_id" 			required="no" default="">
    <cfargument name="setor_id" 			required="no" default="">
    <cfargument name="email_tipo_id"  	    required="yes">
    <cfargument name="old_email_tipo_id"  	 required="yes">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_atualiza_email" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_integer"	value="#arguments.email_id#">
		<cfprocparam 	 	type="in"	cfsqltype="cf_sql_varchar" 	value="#ListGetAt(arguments.email_end, 1, '@')#">
		<cfprocparam 	 	type="in"	cfsqltype="cf_sql_varchar" 	value="#ListGetAt(arguments.email_end, 2, '@')#">
		<cfprocparam  	type="in"	cfsqltype="cf_sql_varchar" 	value="#arguments.email_proprietario#">
		<cfprocparam 	 		type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.email_padrao#">
		<cfprocparam 	 		type="in"	cfsqltype="cf_sql_varchar" 	value="#arguments.email_obs#">
		<cfprocparam 	 		type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.cod_pessoa#">
        <cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer"	null="yes">
        <cfprocparam 	type="in"	cfsqltype="cf_sql_integer" 	value="1">
        <cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.cargo_id#" null="#iif(len(trim(arguments.cargo_id)), de('no'), de('yes'))#">
		<cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.setor_id#" null="#iif(len(trim(arguments.setor_id)), de('no'), de('yes'))#">
        <cfprocparam 	 	type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.email_tipo_id#">
        <cfprocparam 	type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.old_email_tipo_id#">
	</cfstoredproc>	
	<cfreturn email_id />		
</cffunction>

<cffunction name="upd_endereco" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="cep" required="yes">
	<cfargument name="logradouro" required="yes">
	<cfargument name="numero" required="yes">
	<cfargument name="complemento" required="yes">
	<cfargument name="bairro" required="yes">
	<cfargument name="municipio" required="yes">
	<cfargument name="cod_endereco_tipo" required="yes">
	<cfargument name="uf" required="yes">
	<cfargument name="padrao" required="no" default="1">
	<cfargument name="pais_id" required="no" default="Brasil">
	<cfargument name="estado_provincia" required="no" default="">
	<cfargument name="codigo_postal" required="no" default="">
	<cfif not len(trim(arguments.cep))>
		<cfset arguments.cep = '00000000'>
	</cfif>
	<cfstoredproc procedure="kss.pkg_pessoa.prc_atualiza_endereco" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  			type="in"		cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
		<cfprocparam  		type="in"		cfsqltype="cf_sql_integer"	value="#arguments.cod_endereco#">
		<cfprocparam  					type="in"		cfsqltype="cf_sql_varchar"	value="#arguments.cep#">
		<cfprocparam  			type="inout"	cfsqltype="cf_sql_varchar"	value="#arguments.logradouro#">
		<cfprocparam  				type="in"		cfsqltype="cf_sql_varchar"	value="#arguments.numero#">
		<cfprocparam 		 	type="inout"	cfsqltype="cf_sql_varchar" 	value="#arguments.complemento#">
		<cfprocparam 	 			type="inout"	cfsqltype="cf_sql_varchar" 	value="#arguments.bairro#">
		<cfprocparam  					type="in"		cfsqltype="cf_sql_varchar" 	value="#arguments.uf#">
		<cfprocparam 	 		type="inout"	cfsqltype="cf_sql_varchar" 	value="#arguments.municipio#">
		<cfprocparam 	type="in"		cfsqltype="cf_sql_integer" 	value="#arguments.cod_endereco_tipo#">
		<cfprocparam 	 	type="in"		cfsqltype="cf_sql_integer" 	value="#arguments.padrao#">
        <cfprocparam 	 		type="in"		cfsqltype="cf_sql_integer" 	null="yes">
        <cfprocparam 	 			type="in"		cfsqltype="cf_sql_integer"	null="yes">
		<cfprocparam  type="in"		cfsqltype="cf_sql_integer"	null="yes">
		<cfprocparam  	type="in"		cfsqltype="cf_sql_varchar"	null="yes">
		<cfprocparam  type="in"		cfsqltype="cf_sql_integer"	null="yes">
		<cfprocparam  				type="in"		cfsqltype="cf_sql_integer"	null="yes">
		<cfprocparam  		type="in"		cfsqltype="cf_sql_integer"	null="yes">		
		<cfprocparam  				type="in"		cfsqltype="cf_sql_integer"	value="#arguments.pais_id#">
		<cfprocparam   	type="in"		cfsqltype="cf_sql_varchar"	value="#arguments.estado_provincia#">
		<cfprocparam 		type="in"		cfsqltype="cf_sql_varchar"	value="#arguments.codigo_postal#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>

<cffunction name="upd_telefone" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="telefone_id" required="yes">
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="telefone_ddd" required="yes">
	<cfargument name="telefone_prefixo" required="yes">
	<cfargument name="telefone_numero" required="yes">
	<cfargument name="telefone_ramal" required="yes">
	<cfargument name="telefone_tipo_id" required="yes">
	<cfargument name="telefone_contato" required="yes">
	<cfargument name="padrao" required="no" default="1">
    <cfargument name="cargo_id" required="no" default="">
    <cfargument name="setor_id" required="no" default="">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_atualiza_telefone" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_integer"	value="#arguments.telefone_id#">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_varchar"	value="55">
		<cfprocparam  					type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.telefone_ddd#">
		<cfprocparam  				type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.telefone_prefixo#">
		<cfprocparam  				type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.telefone_numero#">
		<cfprocparam  				type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.telefone_ramal#">
		<cfprocparam  				type="inout" cfsqltype="cf_sql_integer"	value="#arguments.telefone_tipo_id#">
		<cfprocparam  				type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.telefone_contato#">
		<cfprocparam  				type="in"	cfsqltype="cf_sql_integer"	value="#arguments.padrao#">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
        <cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer"	null="yes">
        <cfprocparam 	type="in"	cfsqltype="cf_sql_integer" 	value="1">
        <cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.cargo_id#" null="#iif(len(trim(arguments.cargo_id)), de('no'), de('yes'))#">
		<cfprocparam 	 			type="in"	cfsqltype="cf_sql_integer" 	value="#arguments.setor_id#" null="#iif(len(trim(arguments.setor_id)), de('no'), de('yes'))#">
	</cfstoredproc>	
	<cfreturn telefone_id />		
</cffunction>
		
<cffunction name="del_pessoa_fisica" displayname="Insere uma pessoa no sistema" access="remote" returntype="any" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="cod_pessoa" required="yes">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_excluir_pessoa_fisica" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  	type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>
<cffunction name="del_pessoa_juridica" displayname="Insere uma pessoa no sistema" access="remote" returntype="any" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="cod_pessoa" required="yes">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_excluir_pessoa_juridica" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  	type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>
<cffunction name="del_email" displayname="Insere uma pessoa no sistema" access="remote" returntype="any" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="email_id" required="yes">
    <cfargument name="old_email_tipo_id" required="yes">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_excluir_email" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  	  type="in"	cfsqltype="cf_sql_integer"	value="#arguments.email_id#">
        <cfprocparam  	  type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
        <cfprocparam    type="in"	cfsqltype="cf_sql_integer"	value="1">
        <cfprocparam  type="in"	cfsqltype="cf_sql_integer"	value="#arguments.old_email_tipo_id#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>		
<cffunction name="del_endereco" displayname="Insere uma pessoa no sistema" access="remote" returntype="any" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="cod_endereco" required="yes">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_excluir_endereco" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  	type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
		<cfprocparam  	type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_endereco#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>			
<cffunction name="del_telefone" displayname="Insere uma pessoa no sistema" access="remote" returntype="any" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="cod_telefone" required="yes">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_excluir_telefone" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  		type="in"	cfsqltype="cf_sql_integer"	value="#ListgetAt(arguments.cod_telefone, 1, '_')#">
		<cfprocparam  type="in"	cfsqltype="cf_sql_integer"	value="#ListGetAt(arguments.cod_telefone, 2, '_')#">
		<cfprocparam 	 	type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>			
<cffunction name="del_usuario" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="usuario" required="yes">
	<cfargument name="cod_pessoa" required="yes">
	<cfstoredproc procedure="transportes.pkg_controle.prc_del_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.usuario#">
		<cfprocparam  		type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>
<cffunction name="del_pessoa_modalidade" displayname="Insere uma pessoa no sistema" access="remote" returntype="struct" output="true">
<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/10/2005 - criado
	--->	
	<cfargument name="num_modalidade" required="yes">
	<cfargument name="cod_pessoa" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="kss.pkg_modalidade.prc_del_modalidade" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam 	type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.num_modalidade#">
				<cfprocparam 		type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.cod_pessoa#">
			</cfstoredproc>	
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Pessoa excluida com sucesso!")>
		</cftransaction>
		<cfcatch type="database">
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<!--- 
-- PROPSITO
-- Insere regra de faturamento para o cliente
-- GUTO 13/07/2009 11:50:42 - CRIADO
--->
<cffunction name='ins_faturamento_regra' displayname='Insere regra de faturamento para o cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='DIA_INICIAL' required='yes'>
	<cfargument name='DIA_FINAL' required='yes'>
	<cfargument name='DIA_VENCIMENTO' required='yes'>
	<cfargument name='PAGADOR' required='yes'>
	<cfargument name='MES_VENCIMENTO' required='yes'>
	<cftry>
            <cfstoredproc procedure='kss.pkg_pessoa.prc_ins_faturamento_regra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIA_INICIAL#'  null='#iif(len(trim(arguments.DIA_INICIAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIA_FINAL#'  null='#iif(len(trim(arguments.DIA_FINAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIA_VENCIMENTO#'  null='#iif(len(trim(arguments.DIA_VENCIMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>

                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MES_VENCIMENTO#'  null='#iif(len(trim(arguments.MES_VENCIMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='cf_sql_varchar'   variable='retorno.ROWID'  null='yes'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Altera regra de faturamento para o cliente
-- GUTO 13/07/2009 11:55:37 - CRIADO
--->
<cffunction name='upd_faturamento_regra' displayname='Altera regra de faturamento para o cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='DIA_INICIAL' required='yes'>
	<cfargument name='DIA_FINAL' required='yes'>
	<cfargument name='DIA_VENCIMENTO' required='yes'>
	<cfargument name='PAGADOR' required='yes'>
	<cfargument name='MES_VENCIMENTO' required='yes'>
	<cftry>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_alt_faturamento_regra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIA_INICIAL#'  null='#iif(len(trim(arguments.DIA_INICIAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIA_FINAL#'  null='#iif(len(trim(arguments.DIA_FINAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIA_VENCIMENTO#'  null='#iif(len(trim(arguments.DIA_VENCIMENTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MES_VENCIMENTO#'  null='#iif(len(trim(arguments.MES_VENCIMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='cf_sql_varchar'   variable='retorno.ROWID'  null='yes'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui regra de faturamento para o cliente
-- GUTO 13/07/2009 11:56:21 - CRIADO
--->
<cffunction name='del_faturamento_regra' displayname='Exclui regra de faturamento para o cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='DIA_INICIAL' required='yes'>
	<cfargument name='DIA_FINAL' required='yes'>
	<cfargument name='PAGADOR' required='yes'>
	<cftry>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_del_faturamento_regra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIA_INICIAL#'  null='#iif(len(trim(arguments.DIA_INICIAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DIA_FINAL#'  null='#iif(len(trim(arguments.DIA_FINAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Insere regra de faturamento para o cliente
-- GUTO 13/07/2009 11:52:43 - CRIADO
--->
<cffunction name='ins_pessoa_faturamento' displayname='Insere regra de faturamento para o cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='FAT_FORMA_ID' required='yes'>
	<cfargument name='FAT_AGRUPAMENTO_ID' required='yes'>
	<cfargument name='FAT_CONDICAO_ID' required='yes'>
	<cfargument name='C026_ID' required='yes'>
	<cfargument name='NUM_DIAS_PROTESTO' required='yes'>
	<cfargument name='COD_MOEDA' required='yes'>
	<cftry>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_insere_faturamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.FAT_FORMA_ID#'  null='#iif(len(trim(arguments.FAT_FORMA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.FAT_AGRUPAMENTO_ID#'  null='#iif(len(trim(arguments.FAT_AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.FAT_CONDICAO_ID#'  null='#iif(len(trim(arguments.FAT_CONDICAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.C026_ID#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_DIAS_PROTESTO#'  null='#iif(len(trim(arguments.NUM_DIAS_PROTESTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui regra de faturamento para o cliente
-- GUTO 13/07/2009 12:01:13 - CRIADO
--->
<cffunction name='del_pessoa_faturamento' displayname='Exclui regra de faturamento para o cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cftry>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_excluir_faturamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Consulta e Cadastro em Gerenciadora de Risco
-- ANDERSONC 12/03/2010 11:29:51 - CRIADO
--->
<cffunction name='ins_consulta_motorista' displayname='Consulta e Cadastro em Gerenciadora de Risco' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='GERENCIADORA_ID' required='yes'>
	<cfargument name='COD_LIBERACAO' required='yes'>
	<cfargument name='LIBERACAO_VALIDADE' required='yes'>
	<cftry>
        <cfstoredproc procedure='kss.pkg_pessoa.prc_ins_consulta_motorista' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GERENCIADORA_ID#'  null='#iif(len(trim(arguments.GERENCIADORA_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_LIBERACAO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LIBERACAO_VALIDADE#' >
        </cfstoredproc>
        <cfset retorno.erro = false>
        <cfset retorno.mensagem = JSStringFormat('Consulta cadastral inserida com sucesso.')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
<!--- 
-- PROPSITO
-- Inserir cargo cliente
-- LEOPOLDOS 18/08/2010 14:25:50 - CRIADO
--->
<cffunction name='ins_cliente_cargo' displayname='Inserir cargo cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='DESCRICAO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_ins_cliente_cargo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CARGO_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Cargo inserido com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
<!--- 
-- PROPSITO
-- Atualizar cargo cliente
-- LEOPOLDOS 18/08/2010 14:26:35 - CRIADO
--->
<cffunction name='upd_cliente_cargo' displayname='Atualizar cargo cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='CARGO_ID' required='yes'>
	<cfargument name='DESCRICAO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_alt_cliente_cargo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGO_ID#'  null='#iif(len(trim(arguments.CARGO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Cargo atualizado com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
<!--- 
-- PROPSITO
-- Apaga cargo cliente
-- LEOPOLDOS 18/08/2010 14:27:31 - CRIADO
--->
<cffunction name='del_cliente_cargo' displayname='Apaga cargo cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='CARGO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_del_cliente_cargo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGO_ID#'  null='#iif(len(trim(arguments.CARGO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Cargo deletado com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
<!--- 
-- PROPSITO
-- Insere setor cliente
-- LEOPOLDOS 18/08/2010 14:28:34 - CRIADO
--->
<cffunction name='ins_cliente_setor' displayname='Insere setor cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='DESCRICAO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_ins_cliente_setor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.SETOR_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Setor inserido com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
<!--- 
-- PROPSITO
-- Atualiza setor cliente
-- LEOPOLDOS 18/08/2010 14:29:30 - CRIADO
--->
<cffunction name='upd_cliente_setor' displayname='Atualiza setor cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='SETOR_ID' required='yes'>
	<cfargument name='DESCRICAO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_alt_cliente_setor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SETOR_ID#'  null='#iif(len(trim(arguments.SETOR_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Setor atualizado com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
<!--- 
-- PROPSITO
-- Apaga setor cliente
-- LEOPOLDOS 18/08/2010 17:27:31 - CRIADO
--->
<cffunction name='del_cliente_setor' displayname='Apaga setor cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='SETOR_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kss.pkg_pessoa.prc_del_cliente_setor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SETOR_ID#'  null='#iif(len(trim(arguments.SETOR_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Setor deletado com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!--- 
    -- PROPSITO
    -- Inserir uma conta bancria.
    -- FABIOG 08/09/2011 18:52:22 - CRIADO
    --->
    <cffunction name='insere_conta_bancaria' displayname='Inserir uma conta bancria.' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='BANCO_ID' required='yes'>
        <cfargument name='AGENCIA_ID' required='yes'>
        <cfargument name='CONTA' required='yes'>
        <cfargument name='CONTA_DV' required='yes'>
        <cfargument name='CONTA_AG_DV' required='yes'>
        <cfargument name='CONTA_PADRAO' required='yes'>
        <cfargument name='COD_PESSOA_TITULAR' required='no'>
        <cfargument name='CONTA_TIPO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='kss.pkg_pessoa.prc_insere_conta_bancaria' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.BANCO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AGENCIA_ID#'  null='#iif(len(trim(arguments.AGENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONTA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONTA_DV#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONTA_AG_DV#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTA_PADRAO#'  null='#iif(len(trim(arguments.CONTA_PADRAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_TITULAR#'  null='#iif(len(trim(arguments.COD_PESSOA_TITULAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTA_TIPO_ID#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Excluir as contas bancarias vinculadas a pessoa.
	-- FABIOG 09/09/2011 09:51:57 - CRIADO
	--->
	<cffunction name='exclui_conta_bancaria' displayname='Excluir as contas bancarias vinculadas a pessoa.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='BANCO_ID' required='yes'>
		<cfargument name='AGENCIA_ID' required='yes'>
		<cfargument name='CONTA' required='yes'>
		<cftry>
				<cfstoredproc procedure='kss.pkg_pessoa.prc_excluir_conta_bancaria' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.BANCO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AGENCIA_ID#'  null='#iif(len(trim(arguments.AGENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONTA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
    <!--- 
	-- PROPSITO
	-- Alterar uma conta bancria
	-- FABIOG 09/09/2011 15:47:09 - CRIADO
	--->
	<cffunction name='atualiza_conta_bancaria' displayname='Alterar uma conta bancria' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='BANCO_ID' required='yes'>
		<cfargument name='AGENCIA_ID' required='yes'>
		<cfargument name='CONTA' required='yes'>
		<cfargument name='CONTA_DV' required='yes'>
		<cfargument name='CONTA_AG_DV' required='yes'>
		<cfargument name='CONTA_PADRAO' required='yes'>
		<cfargument name='COD_PESSOA_TITULAR' required='no'>
		<cfargument name='CONTA_TIPO_ID' required='yes'>
		<cfargument name='OLD_BANCO_ID' required='no'>
		<cfargument name='OLD_AGENCIA_ID' required='no'>
		<cfargument name='OLD_CONTA' required='no'>
		<cfargument name='OLD_CONTA_DV' required='no'>
		<cftry>
				<cfstoredproc procedure='kss.pkg_pessoa.prc_atualiza_conta_bancaria' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.BANCO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AGENCIA_ID#'  null='#iif(len(trim(arguments.AGENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONTA_DV#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONTA_AG_DV#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTA_PADRAO#'  null='#iif(len(trim(arguments.CONTA_PADRAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_TITULAR#'  null='#iif(len(trim(arguments.COD_PESSOA_TITULAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTA_TIPO_ID#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OLD_BANCO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OLD_AGENCIA_ID#'  null='#iif(len(trim(arguments.OLD_AGENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OLD_CONTA#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OLD_CONTA_DV#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Consultar um CNPJ na Sefaz
	-- RAFAEL 15/08/2012 10:32:13 - CRIADO
	--->
	<cffunction name='prc_consulta_webservice' displayname='Consultar um CNPJ na Sefaz' access='remote' returntype='Struct' output='true'>
		<cfargument name='WEBSERVICE' required='yes'>
        <cfargument name='UF_CONSULTA' required='yes'>
		<cfargument name='CONSULTA_POR' required='yes'>
		<cfargument name='VALOR_CONSULTA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kss.pkg_consulta_cad.prc_xml_consulta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.WEBSERVICE#'  null='#iif(len(trim(arguments.WEBSERVICE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF_CONSULTA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONSULTA_POR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR_CONSULTA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_LONGVARCHAR'  variable='retorno.XML' >
                </cfstoredproc>
                
                <cfquery name="qr_dados_basicos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select extractvalue(column_value, '/kmm/cnpj') as cnpj
                         , extractvalue(column_value, '/kmm/ie') as ie
                         , extractvalue(column_value, '/kmm/cnae') as cnae
                         , extractvalue(column_value, '/kmm/razao_social') as razao_social
                         , extractvalue(column_value, '/kmm/nome_fantasia') as nome_fantasia                         
                      from table(xmlSequence(
                                    extract(xmltype.createXml('#retorno.XML#'), '/kmm')
                                )
                           ) x
                </cfquery>
                
                <cfquery name="qr_enderecos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select extractValue( column_value, '/endereco/logradouro') as logradouro
                         , extractValue( column_value, '/endereco/numero') as numero
                         , extractValue( column_value, '/endereco/complemento') as complemento
                         , extractValue( column_value, '/endereco/bairro') as bairro
                         , extractValue( column_value, '/endereco/codigo_ibge') as codigo_ibge
                         , extractValue( column_value, '/endereco/municipio') as municipio
                         , extractValue( column_value, '/endereco/cep') as cep
                    
                      from table(xmlSequence(
                                    extract(xmltype.createXml('#retorno.XML#'), '/kmm/enderecos/endereco')
                                )
                           ) x
                </cfquery>
                
                <cfquery name="qr_ie_adicional" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select extractValue( column_value, '/ie_adicional') as ie                    
                      from table(xmlSequence(
                                    extract(xmltype.createXml('#retorno.XML#'), '/kmm/ie_adicional')
                                )
                           ) x
                </cfquery>
                
                <cfset retorno.qr_dados_basicos = qr_dados_basicos>
                <cfset retorno.qr_enderecos = qr_enderecos>
                <cfset retorno.qr_ie_adicional = qr_ie_adicional>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Consulta efetuada com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
    -- Inserir um novo tipo de documento.
    -- JAQUELINEF 08/05/2013 14:15:17 - CRIADO
    --->
    <cffunction name='ins_tipo_documento' displayname='Inserir um novo tipo de documento.' access='remote' returntype='Struct' output='true'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='MODALIDADES' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kss.pkg_pessoa.prc_ins_tipo_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODALIDADES#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.COD_TIPO_DOC' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de documento inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Alterar tipo de documento.
    -- JAQUELINEF 08/05/2013 14:16:01 - CRIADO
    --->
    <cffunction name='alt_tipo_documento' displayname='Alterar tipo de documento.' access='remote' returntype='Struct' output='true'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='MODALIDADES' required='no' default="">
        <cfargument name='COD_TIPO_DOC' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kss.pkg_pessoa.prc_alt_tipo_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODALIDADES#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_TIPO_DOC#'  null='#iif(len(trim(arguments.COD_TIPO_DOC)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de documento alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Excluir um tipo de documento.
    -- JAQUELINEF 08/05/2013 14:16:52 - CRIADO
    --->
    <cffunction name='del_tipo_documento' displayname='Excluir um tipo de documento.' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_TIPO_DOC' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kss.pkg_pessoa.prc_del_tipo_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_TIPO_DOC#'  null='#iif(len(trim(arguments.COD_TIPO_DOC)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de documento excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Inserir um documento.
    -- JAQUELINEF 09/05/2013 11:43:55 - CRIADO
    --->
    <cffunction name='ins_documento' displayname='Inserir um documento.' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='COD_TIPO_DOC' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>     
        <cfargument name='NOME_ARQUIVO' required='yes'>                           
        <cftry>            
				<!--- Busca arquivo --->
               <cffile action="readbinary" file="#expandPath("/")#/#arguments.NOME_ARQUIVO#" variable="VARQUIVO">
               <cfscript>
                  v_extensao = ListToArray(arguments.NOME_ARQUIVO, '.');
               </cfscript>    

                <cfstoredproc procedure='kss.pkg_pessoa.prc_ins_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_TIPO_DOC#'  null='#iif(len(trim(arguments.COD_TIPO_DOC)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_BLOB'   value='#VARQUIVO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#v_extensao[ArrayLen(v_extensao)]#'>                    
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Documento inserido co sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
<!--- 
-- PROPSITO
	-- Inserir foto de uma pessoa
	-- JAQUELINEF 09/05/2013 15:53:24 - CRIADO
	--->
	<cffunction name='ins_pessoa_logo' displayname='Inserir foto de uma pessoa' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='NOME_ARQUIVO' required='yes'>
		<cftry>
			<!--- Busca arquivo --->
           <cffile action="readbinary" file="#expandPath("/")#/#arguments.NOME_ARQUIVO#" variable="VARQUIVO">       
	        
				<cfstoredproc procedure='kss.pkg_pessoa.prc_ins_pessoa_logo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB'   value='#VARQUIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Foto inserida com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Excluir a foto de uma pessoa.
    -- JAQUELINEF 09/05/2013 17:38:45 - CRIADO
    --->
    <cffunction name='del_pessoa_logo' displayname='Excluir a foto de uma pessoa.' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cftry>
                <cfstoredproc procedure='kss.pkg_pessoa.prc_del_pessoa_logo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Foto excluida com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 
    
	<!--- 
    -- PROPSITO
    -- Excluir um documento de uma pessoa
    -- JAQUELINEF 13/05/2013 09:57:37 - CRIADO
    --->
    <cffunction name='del_documento' displayname='Excluir um documento de uma pessoa' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_DOCUMENTO' required='yes'>
        <cftry>
                <cfstoredproc procedure='kss.pkg_pessoa.prc_del_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DOCUMENTO#'  null='#iif(len(trim(arguments.COD_DOCUMENTO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Documento excluido com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <cffunction name='atualizar_centra_cadastros' displayname='Atualiza situao na central de cadastro' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cftry>
                <cfstoredproc procedure='ccad.pkg_central_cadastros.prc_manipula_alteracao_pessoa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Central de cadastros atualizada com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <cffunction name='valida_pessoa' displayname='Faz a validao do cadastro da pessoa' access='remote' returntype='Struct' output='true'>
       <cfargument name='COD_PESSOA' required='yes'>
       <cftry>
          <cfstoredproc procedure='kss.pkg_pessoa.prc_valida_pessoa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
          </cfstoredproc>
             <cfset retorno.erro = false>
             <cfset retorno.mensagem = JSStringFormat('Cadastro validado com sucesso.')>
       <cfcatch>
          <cfset retorno.erro = true>
          <cfset retorno.mensagem = cfcatch>
          <cfset request.erro = cfcatch>
       </cfcatch>
       </cftry>
       <cfreturn retorno />
    </cffunction>
	
	<cffunction name="ins_ie_adicional" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
    <!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- Nicolle 29/08/2017
	--->	
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="inscricao_estadual" required="yes">
	<cfargument name="uf" required="yes">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_ins_pessoa_inscr_estadual" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam 	type="out"	cfsqltype="cf_sql_integer"	variable="pessoa_inscricao_estadual_id">
		<cfprocparam  		  			type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
		<cfprocparam  			type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.inscricao_estadual#">
		<cfprocparam  			      			type="in"	cfsqltype="cf_sql_varchar"	value="#arguments.uf#">
	</cfstoredproc>	
	<cfreturn pessoa_inscricao_estadual_id />		
	</cffunction>	

	<cffunction name="upd_ie_adicional" displayname="Insere uma pessoa no sistema" access="remote" returntype="numeric" output="true">
	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- Nicolle 29/08/2017
	--->	
	<cfargument name="pessoa_inscricao_estadual_id" required="yes">
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="inscricao_estadual" required="yes">
	<cfargument name="uf" required="yes">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_alt_pessoa_inscr_estadual" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  type="in"	cfsqltype="cf_sql_integer"	value="#arguments.pessoa_inscricao_estadual_id#">
		<cfprocparam  					type="in"	cfsqltype="cf_sql_integer"	value="#arguments.cod_pessoa#">
        <cfprocparam 	 		type="in"	cfsqltype="cf_sql_varchar" 	value="#arguments.inscricao_estadual#">
        <cfprocparam 	 						type="in"	cfsqltype="cf_sql_varchar" 	value="#arguments.uf#">
	</cfstoredproc>	
	<cfreturn pessoa_inscricao_estadual_id />		
	</cffunction>	
	
	<cffunction name="del_ie_adicional" displayname="Insere uma pessoa no sistema" access="remote" returntype="any" output="true">
	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- Nicolle 29/08/2017
	--->	
	<cfargument name="pessoa_inscricao_estadual_id" required="yes">
	<cfstoredproc procedure="kss.pkg_pessoa.prc_del_pessoa_inscr_estadual" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam  type="in" cfsqltype="cf_sql_integer" value="#ListgetAt(arguments.pessoa_inscricao_estadual_id, 1, '_')#">
	</cfstoredproc>	
	<cfreturn 0 />		
</cffunction>		
</cfcomponent>	
