<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init">
	<!---
   -- PROPSITO
   -- Retorna a imagem do captcha
   -- RAFAEL 05/04/2018
   --->
   <cffunction name="get_captcha" access="remote" returntype="query" output="true">
      <cfargument name="requisicao_id" required="yes"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	 select 'data:image/png;base64,'||x.captcha as image
		   from xmltable('/params' passing (select t.requisicao
							 				  from kss.v$consulta_cad_req_web t
											 where t.requisicao_id = #arguments.requisicao_id#)
				  columns
					 captcha clob path '/params/captcha'
			   ) x
        </cfquery>
        <cfreturn qr_result>
   </cffunction>
   
   <!---
   -- PROPSITO
   -- Retorna a imagem do captcha
   -- RAFAEL 05/04/2018
   --->
   <cffunction name="get_log_cons_cad" access="remote" returntype="query" output="true">
      <cfargument name="cod_pessoa" required="yes"/>
      <cfquery name="qr_pessoa" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	  select cnpj_cpf
            from kss.v$pessoa i
           where i.cod_pessoa = '#arguments.cod_pessoa#'
        </cfquery>
	  <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	 select i.qualificacao_cadastral_it_id
			  , i.qualificacao_cadastral_id
			  , i.cpf
			  , i.nis
			  , i.nome
			   --, to_char(i.data_nascimento, 'dd/mm/yyyy') as data_nascimento
			  , i.data_nascimento
			  , i.situacao
			  , (select cg.rv_meaning
				   from kss.cg_ref_codes cg
			      where cg.rv_domain = 'QUALIFICACAO_CADASTRAL.SITUACAO'
				    and cg.owner = 'FOLHA'
				    and cg.rv_low_value = i.situacao) as situacao_desc
			  , nvl(qcm.descricao, i.mensagem) as mensagem
			  , i.orientacao
			  , to_char(i.date_insert, 'dd/mm/yyyy hh24:mi:ss') as data_consulta
			  , i.user_insert
			  , i.date_insert
			  , i.user_update
			  , i.date_update
		   from folha.v$qualificacao_cadastral_it i
		   left join folha.v$qualificacao_cadastral_ocorr qco
		     on qco.qualificacao_cadastral_it_id = i.qualificacao_cadastral_it_id
		   left join folha.v$qualificacao_cadastral_msg qcm
		     on qcm.codigo = qco.codigo
		    and qcm.dominio = qco.dominio
	      where 1 = 1
	        and i.cpf = '#qr_pessoa.cnpj_cpf#'
	   order by i.qualificacao_cadastral_it_id desc
        </cfquery>
        <cfreturn qr_result>
   </cffunction>
   
   <!---
   -- PROPSITO
   -- Retorna a imagem do captcha
   -- RAFAEL 05/04/2018
   --->
   <cffunction name="get_pessoa_situacao" access="remote" returntype="query" output="true">
      <cfargument name="cpf" required="no"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	  select nvl(max(i.situacao) keep (dense_rank last order by i.qualificacao_cadastral_it_id) , -1) as situacao
            from folha.v$qualificacao_cadastral_it i
           where 1 = 1            
	         and i.cpf = '#arguments.cpf#'
        </cfquery>
        <cfreturn qr_result>
   </cffunction>
   
</cfcomponent>
