<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPÓSITO
	-- Gera o PDF de impressão do vale pedágio
	-- LEANDRO.SILVA 07/03/2018
	--->
	<cffunction name='gera_impressao_vale_pedagio' displayname='Gera o PDF de impressão do vale pedágio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_COMPROVANTE' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_vale_pedagio.prc_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_COMPROVANTE#'  null='#iif(len(trim(arguments.NUM_COMPROVANTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impressão gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<cffunction name='cancelar_vale_pedagio' displayname='Cancelar vale pedágio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_COMPROVANTE' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_vale_pedagio.prc_cancela_vale_pedagio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_COMPROVANTE#'  null='#iif(len(trim(arguments.NUM_COMPROVANTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'             value='#arguments.MOTIVO#'  null='#iif(len(trim(arguments.MOTIVO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vale pedágio cancelado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>
