<cfcomponent extends="_transportes.funcoes.cfc_init">    
	<cffunction name="get_pedagio" access="remote" returntype="Query" output="true">	  
			<cfargument name="romaneios" required="no" default="">
			<cfargument name="placa_cavalo" required="no" default="">
			<cfargument name="cod_fornecedora" required="no" default="">
			<cfargument name="data_inicio_romaneio" required="no" default="">
			<cfargument name="data_termino_romaneio" required="no" default="">
			<cfargument name="data_inicio_compra" required="no" default="">
			<cfargument name="data_termino_compra" required="no" default="">
			<cfargument name="num_comprovante" required="no" default="">
			<cfargument name="rotas" required="no" default="">
			<cfargument name="cod_motorista" required="no" default="">
			<cfargument name="conhecimentos" required="no">
			<cfargument name="contratos" required="no">
			<cfargument name="vale_pedagio_operadora_id" required="no" default="">
			<cfargument name="cnpj_cpf" required="no" default="">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				 select distinct vpr.vale_pedagio_romaneio_id
					  , p.cnpj_cpf as cnpj_cpf_fornecedora
					  , kss.pkg_string.initcap2(p.razao_social) as fornecedora
					  , (select vpo.identificador
						   from oper.v$vale_pedagio_operadora vpo
						  where vpo.vale_pedagio_operadora_id = vpr.vale_pedagio_operadora_id) as operadora
					  , vpri.num_comprovante
					  , (select kss.fnc_concat_all(distinct kss.to_concat_expr(rot.rota_id || ' - ' || rot.descricao_rota,'|'))
						   from oper.v$vale_pedagio_romaneio_it rit
						  inner join oper.v$rota rot 
							 on rot.rota_id = rit.rota_id
						  where rit.vale_pedagio_romaneio_it_id = vpri.vale_pedagio_romaneio_it_id) as rotas
					  , nvl(vpri.nome_praca,
							(select pr.descricao
							   from oper.v$pedagio_praca pr
							  where pr.praca_id = vpri.praca_id)) as pracas
					  , decode(vpr.num_comprovante_carregado, vpri.num_comprovante, vpri.valor, 0) as valor_carregado
					  , decode(vpr.num_comprovante_vazio    , vpri.num_comprovante, vpri.valor, 0) as valor_vazio
					  , vpri.valor
					  , (select sum(rit.valor)
						   from oper.v$vale_pedagio_romaneio_it rit
						  where rit.vale_pedagio_romaneio_id = vpr.vale_pedagio_romaneio_id
							and rit.num_comprovante = vpri.num_comprovante) as valor_total
					  , (select max(vioc.descricao) keep (dense_rank last order by vpoc.vale_pedagio_ocorrencia_id) as ocorrencia
						   from oper.v$vale_pedagio_ocorrencia vpoc
						  inner join oper.v$vale_pedagio_tipo_ocorren vioc
							 on vioc.vale_pedagio_tp_ocorren_id = vpoc.vale_pedagio_tp_ocorren_id
						  where vpoc.vale_pedagio_romaneio_id = vpr.vale_pedagio_romaneio_id
							and vpoc.num_comprovante = vpri.num_comprovante
						) as ocorrencia
					  , vpr.num_romaneio
					  , vpri.usuario_cancelamento
					  , to_char(vpri.data_cancelamento, 'DD/MM/YYYY HH24:MI:SS') as data_cancelamento
					  , logistica.pkg_agendamento.fnc_motorista_viagem(v.viagem_id) as motorista
					  , logistica.pkg_agendamento.fnc_viagem_composicao(v.viagem_id) as composicao
					  , '' as requisicoes
					  , '' as conhecimento
					  , '' as ocorrencias
					  , '' as contrato_transp
					  , (select max('Emitido')
						   from oper.v$vale_pedagio_contrato_transp vpct
						  where vpct.vale_pedagio_romaneio_id = vpr.vale_pedagio_romaneio_id) as contrato_transporte
					  , (select sum(rit.valor)
						   from oper.v$vale_pedagio_romaneio_it rit
						  inner join oper.v$romaneio_itinerario ritn
							 on ritn.itinerario_id = rit.itinerario_id
							and ritn.rota_id = rit.rota_id
							and ritn.vazio_carregado = 0
						  where rit.vale_pedagio_romaneio_id = vpr.vale_pedagio_romaneio_id
							and ritn.num_romaneio = vpr.num_romaneio) as valor_vazio
					  , (select max('Emitido')
						   from oper.v$vale_pedagio_conhecimento vpct
						  where vpct.vale_pedagio_romaneio_id = vpr.vale_pedagio_romaneio_id) as conhecimento
					  , decode(vpr.manual, 0, 'N&atilde;o', 'Sim') as manual
					  , vpri.user_insert
					  , to_char(vpri.date_insert, 'DD/MM/YYYY HH24:MI:SS') as date_insert
					  , vpri.user_update
					  , to_char(vpri.date_update, 'DD/MM/YYYY HH24:MI:SS') as date_update
					  , oper.pkg_vale_pedagio.fnc_usuario_cancelamento(p_num_comprovante => vpri.num_comprovante
																	 , p_num_romaneio    => vpr.num_romaneio) as permite_cancelar
				 from oper.v$vale_pedagio_romaneio vpr
				inner join oper.v$vale_pedagio_romaneio_it vpri
				   on vpri.vale_pedagio_romaneio_id = vpr.vale_pedagio_romaneio_id
				inner join kss.v$pessoa p
				   on p.cod_pessoa = vpr.cod_pessoa_fornecedora
				 left join logistica.v$viagem v
				   on v.num_romaneio = vpr.num_romaneio
				where 1 = 1
			      <cfif len(trim(arguments.romaneios))>
				  and vpr.num_romaneio in (select t.column_value
                                             from (table(kss.str2table(replace('#arguments.romaneios#', ',', ';')))) t)
				  <cfelse>
					  <cfif len(trim(arguments.conhecimentos))>
					  and exists (select 1
									from oper.v$vale_pedagio_conhecimento vpc
								   inner join fiscal.v$conhecimento cte
									  on cte.conhecimento_id = vpc.conhecimento_id
								   where vpc.num_comprovante = vpri.num_comprovante
									 and cte.num_conhecimento in (select t.column_value
																	from (table(kss.str2table(replace('#arguments.conhecimentos#', ',', ';')))) t))
					  <cfelse>
						  <cfif len(trim(arguments.contratos))>
						  and exists (select 1
										from oper.v$vale_pedagio_contrato_transp vpc
									   inner join oper.v$contrato_transp ct
										  on ct.lancto_id = vpc.lancto_id
									   where vpc.num_comprovante = vpri.num_comprovante
										 and ct.lancto_id in (select t.column_value
																		from (table(kss.str2table(replace('#arguments.contratos#', ',', ';')))) t))

						  <cfelse>
							  <cfif len(trim(arguments.num_comprovante))>
							  and vpri.num_comprovante in (select t.column_value
															 from (table(kss.str2table(replace('#arguments.num_comprovante#', ',', ';')))) t)
							  <cfelse>
								  <cfif len(trim(arguments.placa_cavalo))>
								  and v.veiculo_id = oper.pkg_veiculo.fnc_veiculo_id(p_placa => '#arguments.placa_cavalo#')
								  </cfif>
								  <cfif len(trim(arguments.cod_fornecedora))>
								  and  vpr.cod_pessoa_fornecedora = #arguments.cod_fornecedora#
								  </cfif>
								  <cfif len(trim(arguments.data_inicio_romaneio))>
								  and exists(select 1
										from oper.v$romaneio r
									   where r.num_romaneio = v.num_romaneio
										 and r.data_inicio >= to_date('#arguments.data_inicio_romaneio#' || ' 23:59:59', 'DD/MM/YYYY HH24:MI:SS'))
								  </cfif>
								  <cfif len(trim(arguments.data_termino_romaneio))>
								  and exists(select 1
										from oper.v$romaneio r
									   where r.num_romaneio = v.num_romaneio
										 and r.data_inicio <= to_date('#arguments.data_termino_romaneio#' || ' 23:59:59', 'DD/MM/YYYY HH24:MI:SS'))
								  </cfif>
								  <cfif len(trim(arguments.data_inicio_compra))>
								  and vpri.date_insert >= to_date('#arguments.data_inicio_compra#' || ' 00:00:00', 'DD/MM/YYYY HH24:MI:SS')
								  </cfif>
								  <cfif len(trim(arguments.data_termino_compra))>
								  and vpri.date_insert <= to_date('#arguments.data_termino_compra#' || ' 23:59:59', 'DD/MM/YYYY HH24:MI:SS')
								  </cfif>
								  <cfif len(trim(arguments.rotas))>
								  and vpri.rota_id in (select t.column_value
														 from (table(kss.str2table(replace('#arguments.rotas#', ',', ';')))) t)
								  </cfif>
								  <cfif len(trim(arguments.cod_motorista))>
								  and v.cod_motorista = #arguments.cod_motorista#
								  </cfif>
							  </cfif>
						  </cfif>
					  </cfif>
				  </cfif>
			</cfquery>
		<cfreturn qr />
	</cffunction>
	
	<cffunction name="get_contrato_pedagio" access="remote" returntype="Query" output="true">	  
			<cfargument name="vale_pedagio_romaneio_id" required="yes">
			<cfargument name="num_comprovante" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select cp.lancto_id
				 	 , cp.num_formulario
			 		 , cp.serie_formulario
					 , kss.pkg_organograma.fnc_unidade_negocio(cp.cod_pessoa_filial) as unidade_negocio
					 , kss.pkg_organograma.fnc_departamento(cp.cod_departamento) as departamento
					 , kss.pkg_organograma.fnc_setor(cp.cod_setor) as setor
					 , kss.pkg_organograma.fnc_centro_custo(cp.cod_centro_custo) centro_custo
					 , to_char(cp.data_emissao, 'DD/MM/YYYY HH24:MI:SS') as data_emissao
					 , cp.user_insert
					 , to_char(cp.date_insert, 'DD/MM/YYYY HH24:MI:SS') as date_insert
					 , cp.user_update
					 , to_char(cp.date_update, 'DD/MM/YYYY HH24:MI:SS') as date_update
				  from oper.v$contrato_transp cp
				 where exists (select 1
								 from oper.v$vale_pedagio_contrato_transp vpct
							    where vpct.lancto_id = cp.lancto_id
							 	  and vpct.vale_pedagio_romaneio_id = #arguments.vale_pedagio_romaneio_id#
								  and vpct.num_comprovante = #arguments.num_comprovante#)

			</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<cffunction name="get_conhecimento_pedagio" access="remote" returntype="Query" output="true">	  
			<cfargument name="vale_pedagio_romaneio_id" required="yes">
			<cfargument name="num_comprovante" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select cte.num_conhecimento
					 , cte.serie
					 , kss.pkg_organograma.fnc_unidade_negocio(cte.cod_pessoa_filial) as unidade_negocio
					 , kss.pkg_organograma.fnc_departamento(cte.cod_departamento) as departamento
					 , kss.pkg_organograma.fnc_setor(cte.cod_setor) as setor
					 , kss.pkg_organograma.fnc_centro_custo(cte.cod_centro_custo) centro_custo
					 , to_char(cte.data_emissao, 'DD/MM/YYYY HH24:MI:SS') as data_emissao
					 , cte.user_insert
					 , to_char(cte.date_insert, 'DD/MM/YYYY HH24:MI:SS') as date_insert
					 , cte.user_update
					 , to_char(cte.date_update, 'DD/MM/YYYY HH24:MI:SS') as date_update
				  from  fiscal.v$conhecimento cte
				 where 1=1
			       and exists (select 1
								 from oper.v$vale_pedagio_conhecimento vpc
							    where vpc.conhecimento_id = cte.conhecimento_id
								  and vpc.vale_pedagio_romaneio_id = #arguments.vale_pedagio_romaneio_id#
								  and vpc.num_comprovante = #arguments.num_comprovante#)
			 order by cte.data_emissao
			</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<cffunction name="get_ocorrencia_pedagio" access="remote" returntype="Query" output="true">	  
			<cfargument name="vale_pedagio_romaneio_id" required="yes">
			<cfargument name="num_comprovante" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select vpo.vale_pedagio_ocorrencia_id
					 , vpo.vale_pedagio_tp_ocorren_id
					 , (select vpto.descricao
						  from oper.v$vale_pedagio_tipo_ocorren vpto
						 where vpto.vale_pedagio_tp_ocorren_id = vpo.vale_pedagio_tp_ocorren_id) as ocorrencia
					 , vpo.vale_pedagio_romaneio_id
					 , vpo.observacao
					 , vpo.user_insert
					 , to_char(vpo.date_insert, 'DD/MM/YYYY HH24:MI:SS') as date_insert
					 , vpo.user_update
					 , to_char(vpo.date_update, 'DD/MM/YYYY HH24:MI:SS') as date_update
				  from oper.v$vale_pedagio_ocorrencia vpo
				 where vpo.vale_pedagio_romaneio_id = #arguments.vale_pedagio_romaneio_id#
			       and vpo.num_comprovante = #arguments.num_comprovante#
			     order by vpo.vale_pedagio_ocorrencia_id
			</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<cffunction name="get_requisicao_pedagio" access="remote" returntype="Query" output="true">	  
			<cfargument name="num_romaneio" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select vpr.vale_pedagio_requisicao_id
					 , kss.pkg_string.initcap2(p.razao_social) as fornecedora
					 , p.cnpj_cpf as cnpj_cpf_fornecedora
					 , (select vpo.identificador
				 		  from oper.v$vale_pedagio_operadora vpo
						 where vpo.vale_pedagio_operadora_id = vpr.vale_pedagio_operadora_id) as operadora
					 , to_char(vpr.date_insert, 'DD/MM/YYYY HH24:MI:SS') as data_requisicao
					 , (select vpm.funcao
						  from oper.v$vale_pedagio_metodo vpm
						 where vpm.vale_pedagio_metodo_id = vpr.vale_pedagio_metodo_id
						   and vpm.vale_pedagio_operadora_id = vpr.vale_pedagio_operadora_id) as metodo
					 , vprr.num_romaneio
					 , logistica.pkg_agendamento.fnc_viagem_composicao(v.viagem_id) as composicao
					 , '' as xml_envio
					 , '' as xml_retorno
					 , vpr.observacao
					 , vpr.user_insert as inserido_por
					 , to_char(vpr.date_insert, 'DD/MM/YYYY HH24:MI:SS') as inserido_em
					 , vpr.user_update as alterado_por
					 , to_char(vpr.date_update, 'DD/MM/YYYY HH24:MI:SS') as alterado_em
				  from oper.v$vale_pedagio_requisicao vpr
				  left join oper.v$vale_pedagio_romaneio vprr
				    on vprr.vale_pedagio_romaneio_id = vpr.vale_pedagio_romaneio_id
				  left join logistica.v$viagem v
				    on v.num_romaneio = vprr.num_romaneio
				  left join kss.v$pessoa p
				    on p.cod_pessoa = vprr.cod_pessoa_fornecedora
				 where v.num_romaneio in (select t.column_value
								            from (table(kss.str2table(replace('#arguments.num_romaneio#', ',', ';')))) t)
			     order by vpr.date_insert

			</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<cffunction name="get_requisicao_xml_envio" access="remote" returntype="Query" output="true">	  
			<cfargument name="vale_pedagio_requisicao_id" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select vpr.xml_envio
                  from oper.v$vale_pedagio_requisicao vpr
				 where vpr.vale_pedagio_requisicao_id = #arguments.vale_pedagio_requisicao_id#
			</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<cffunction name="get_requisicao_xml_retorno" access="remote" returntype="Query" output="true">	  
			<cfargument name="vale_pedagio_requisicao_id" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select vpr.xml_retorno
                  from oper.v$vale_pedagio_requisicao vpr
				 where vpr.vale_pedagio_requisicao_id = #arguments.vale_pedagio_requisicao_id#
			</cfquery>  
		<cfreturn qr />
	</cffunction>
	
</cfcomponent>
