<html>
<cfinclude template="/_scripts/scripts.cfm" />
<cfparam name="vars.TERCEIRIZADO" default="0">
<cfparam name="vars.CUMMINS" default="0">
<cfscript>
	conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_operacao");
	qrOperacao = conn.get_operacao_tree(cod_organograma = session.cod_organograma, somente_ativas = 1);
	qrUnidade  = conn.get_unidade();
	qrEspecie  = conn.get_especie();
	qrSubSerie = conn.get_sub_serie_nota(documento_proprio = 0, carga_transportada = 1);
	qrParamModalidade = conn.get_parametro_modalidade("M204-P0178");
	qrAcaoComposicaoContainer = conn.get_acao_cod('SOLT', 'DEFINIR_COMPOSICAO_CONTAINER');

	conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_solicitacao");
	qrValidacaoANTT = conn.get_parametro(identificador = 'M204-P0006');
	qrGrisco_upper  = conn.get_grisco_upper();

	v_nfe_cfop_obrigatorio = conn.get_parametro(identificador = 'M309-P0182');

	conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_global");
	qrValorEm           	= conn.get_cg_ref_codes(rv_domain = 'LOTE.FRETE_EM', owner = 'OPER');
	qrModalidade        	= conn.get_cg_ref_codes(rv_domain = 'VEICULO_MODALIDADE.MODALIDADE', owner = 'OPER');
	qrPrioridade        	= conn.get_cg_ref_codes(rv_domain = 'PRIORIDADE', owner = 'LOGISTICA');
	v_nf_serie_liberada     = conn.get_parametro_valor(cod_projeto = 25, cod_aplicacao = 'FISCAL', parametro_id = 311, parametro_grupo_id = 8);
	v_valor_sug_obrigatorio = conn.get_parametro_valor(cod_projeto = 11, cod_aplicacao = 'OPERACIONAL', parametro_id = 486, parametro_grupo_id = 17);
	v_recurso_ccad			= conn.get_recurso_ativo(cod_recurso = 'M110-REC00001');
	v_alerta_cpg_aberto		= conn.get_parametro_valor_lista('M204-P0208');

</cfscript>
<script type="text/javascript">
	// Configura botoes //
	parent.f_set_texto( 'titulo_aplicacao', '<cf_language>Controle Logstico</cf_language>' );
	parent.f_set_texto( 'titulo_pagina', '<cf_language>Solicitaes de Carga</cf_language>' );

	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); }

	parent.f_hidden('btn_excluir');
	f_cria_botao('cancelar_doc', 'Cancelar', 'f_cancelar_doc()', parent.document.getElementById('barra_botoes_top'));
	f_cria_botao('localizar', 'Localizar', 'f_localizar()', parent.document.getElementById('barra_botoes_top'));
	f_desabilitar_botao('cancelar_doc');

    <cfif "#vars.TERCEIRIZADO#" eq 1>
		parent.f_hidden('btn_incluir');
	</cfif>
	// -------------------- //

	var v_inserida = 0;
	var v_count_composicao = 0;

	function f_busca_container(p_container_identificador){
		with(document.forms[0]){
			if(p_container_identificador == ''){
				if(CONTAINER_IDENTIFICADOR.disabled) {
					CONTAINER_IDENTIFICADOR.disabled = false;
					CONTAINER_IDENTIFICADOR.value = '';
					CONTAINER_IDENTIFICADOR.disabled = true;
				} else {
					CONTAINER_IDENTIFICADOR.value = '';
				}
				CONTAINER_ID.value = '';
				CONTAINER_TIPO_ID.value = '';
				CONTAINER_TIPO_ISO_CODE.value = '';
				document.getElementById("CONTAINER_TIPO_ISO_CODE").setAttribute("obrigatorio", "0");
				document.getElementById("LBL_MSG_CONTAINER").style.display = "none";
				CONTAINER_TIPO.value = '';
				return;
			}

			CONSULTA.value = 3;
			if(CONTAINER_IDENTIFICADOR.disabled) {
				CONTAINER_IDENTIFICADOR.disabled = false;
				CONTAINER_IDENTIFICADOR.value = p_container_identificador;
				CONTAINER_IDENTIFICADOR.disabled = true;
			} else {
				CONTAINER_IDENTIFICADOR.value = p_container_identificador;
			}
			target = 'consultas';
			action = 'consultas.cfm';
			if(CONTAINER_IDENTIFICADOR.disabled) {
				CONTAINER_IDENTIFICADOR.disabled = false;
				submit();
				CONTAINER_IDENTIFICADOR.disabled = true;
			} else {
				submit();
			}
		}
	}
	function f_busca_tipo_container(p_iso_code){
		with(document.forms[0]){
			CONSULTA.value = 4;
			CONTAINER_TIPO_ISO_CODE.value = p_iso_code;
			target = 'consultas';
			action = 'consultas.cfm';
			submit();
		}
	}

	function f_confirmar() {
		with(document.forms[0]) {
			OPERACAO.disabled = false;
			target = 'consultas';
			action = 'confirma.cfm';
			if(COD_ORGANOGRAMA.value == '') {
				alert('O usurio atual no possui lotao, impossvel prosseguir!');
				return false;
			}
			if(VALOR_TOTAL_SUGERIDO.value.trim() != '' && Number(VALOR_TOTAL_SUGERIDO.value) <<cfif v_valor_sug_obrigatorio eq 1 >=</cfif> 0) {
				alert('No  possvel gerar uma solicitao de carga com valor sugerido inferior a 0 (zero).');
				return false;
			}
			if(Number(VALOR_TOTAL_SUGERIDO.value) < Number(VALOR_TOTAL_NF.value)) {
				alert('No  possvel gerar uma solicitao de carga com valor sugerido inferior ao valor total das notas fiscais..');
				return false;
			}
			if(Number(PESO.value) > 80000) {
				alert('No  possvel gerar uma solicitao de carga com peso superior a 80.000 Kg.');
				return false;
			}
			/*if(Number(VALOR_TOTAL.value) > 20000) {
				alert('No  possvel gerar uma solicitao de carga com valor superior a R$ 20.000,00.');
				return false;
			}*/

			if(DATA_CARREGAMENTO_INICIO.value == '') {
				alert(' necessrio definir a hora de inicio de carregamento para a carga.');
				DATA_CARREGAMENTO_INICIO.select();
				return false;
			}
			if(DATA_CARREGAMENTO_FIM.value == '') {
				alert(' necessrio definir a hora de trmino de carregamento para a carga.');
				DATA_CARREGAMENTO_FIM.select();
				return false;
			}
			if(DATA_ENTREGA_INICIO.value == '') {
				alert(' necessrio definir a hora de inicio de entrega para a carga.');
				DATA_ENTREGA_INICIO.select();
				return false;
			}
			if(DATA_ENTREGA_FIM.value == '') {
				alert(' necessrio definir a hora de trmino de entrega para a carga.');
				DATA_ENTREGA_FIM.select();
				return false;
			}
			
			<cfif v_alerta_cpg_aberto eq 'Sim'>
			   if(POSSUI_CPG_ABERTO.value == 1 && document.getElementById("CIENTE_CPG_ABERTO").checked == false){
				  alert('O motorista possui CPG com saldo em aberto.\nVerifique as informaes e confirme que est ciente disto para poder prosseguir.');
				  return false;
			   }
			</cfif>

			VALOR_UNITARIO.setAttribute('obrigatorio', (VALOR_EM.value == 'LOTACAO')?'0':'1');
			if(f_verifica_form(document.forms[0])) {
				document.getElementById('sp_origem_restrita').disabled = false;
				document.getElementById('sp_origem_aberta').disabled = false;
				document.getElementById('sp_destino_restrita').disabled = false;
				document.getElementById('sp_destino_aberta').disabled = false;

				MODALIDADE.disabled = false;
				COD_UNIDADE.disabled = false;
				LIBERADA_AGENDAMENTO.disabled = false;
				VALOR_UNITARIO.disabled = false;

				v_tipo_docto_id = document.getElementById('TIPO_DOCUMENTO_ID');
				v_status = v_tipo_docto_id.disabled;
				v_tipo_docto_id.disabled = '';

				f_set_terceirizado_disabled(false);
				
				if (LOTE_ID.value != ''){
					if ((COMPOSICAO_CAPACIDADE.value - PESO.value) > 0 && (LOTE_PESO_RESTANTE.value - PESO.value) <= 0){
					   if(confirm('A composio ainda possui capacidade de '+((COMPOSICAO_CAPACIDADE.value - PESO.value)/1000)+' Ton. para carregamento, apesar do lote N '+LOTE_ID.value+' (Ton. restante: '+LOTE_PESO_RESTANTE.value/1000+') estar sendo esgotado. Deseja criar uma nova solicitao ou pagar como lotao?')){
						  LOTE_VINCULA_SOLICITACAO.value = 1;
					   } else{
						  LOTE_VINCULA_SOLICITACAO.value = 0;
						  PESO.value = LOTE_PESO_RESTANTE.value;
						  VALOR_EM.value = 'LOTACAO';
					   }
					} else{
				      LOTE_VINCULA_SOLICITACAO.value = 0;
				   }
				} else{
				   LOTE_VINCULA_SOLICITACAO.value = 0;
				}
				
				submit();
				f_set_terceirizado_disabled(true);
				v_tipo_docto_id.disabled = v_status;

			}
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;

	function f_set_terceirizado_disabled(p_disabled){
		for (var i = 0; i<document.forms[0].elements.length; i++) {
			var v_elem = document.forms[0].elements[i];
			if(v_elem.getAttribute("terceirizado") && v_elem.getAttribute("terceirizado") == 1){
				v_elem.disabled = p_disabled;
			}
		}

	}

	function f_cancelar_doc() {
		f_abrir_janela('/modulos/pcl/solicitacao/cancelar.cfm?solicitacao_carga_id='+document.getElementById('SOLICITACAO_CARGA_ID').value, 'f_atualizar()','600', '200');
	}
	parent.f_cancelar_doc = f_cancelar_doc;

	function f_localizar() {
		NewWindow('localizar.cfm?TERCEIRIZADO=<cfoutput>#vars.TERCEIRIZADO#</cfoutput>', 'Localizar', '800', '600', 'yes');
	}
	parent.f_localizar = f_localizar;

	function f_on_incluir() {
		with(document.forms[0]) {
			f_desabilitar_botao('cancelar_doc');

			document.getElementById('operacao_pendente').innerHTML = '';

			catTree.closeAll();
			document.getElementById('arvore').disabled = false;

			f_limpa_select(NATUREZA_COMBO);
			document.getElementById('sp_natureza_restrita').style.display = 'none';
			document.getElementById('sp_natureza_aberta').style.display = '';

			f_limpa_select(NOME_REMETENTE_COMBO);
			document.getElementById('sp_remetente_restrita').style.display = 'none';
			document.getElementById('sp_remetente_aberta').style.display = '';

			f_limpa_select(NOME_DESTINATARIO_COMBO);			
			document.getElementById('sp_destinatario_restrita').style.display = 'none';
			document.getElementById('sp_destinatario_aberta').style.display = '';

			f_limpa_select(NOME_CONSIGNATARIO_COMBO);
			document.getElementById('sp_consignatario_restrita').style.display = 'none';
			document.getElementById('sp_consignatario_aberta').style.display = '';

			f_limpa_select(NOME_REDESPACHO_COMBO);
			document.getElementById('sp_redespacho_restrita').style.display = 'none';
			document.getElementById('sp_redespacho_aberta').style.display = '';

			f_limpa_select(NOME_COBRANCA_COMBO);
			document.getElementById('sp_cobranca_restrita').style.display = 'none';
			document.getElementById('sp_cobranca_aberta').style.display = '';

			f_limpa_select(ORIGEM_MUNICIPIO_COMBO);
			document.getElementById('sp_origem_restrita').style.display = 'none';
			document.getElementById('sp_origem_aberta').style.display = '';

			f_limpa_select(DESTINO_MUNICIPIO_COMBO);
			document.getElementById('sp_destino_restrita').style.display = 'none';
			document.getElementById('sp_destino_aberta').style.display = '';

			f_limpa_select(LOTE_COMBO);
			
			document.getElementById('sp_m3').style.display = 'none';
			document.getElementById('sp_volumes').style.display = 'none';
			VALOR_UNITARIO.disabled = false;
			VALOR_UNITARIO.className = '';
			f_obrigatorio(VALOR_UNITARIO, 0);

			document.getElementById('sp_situacao').innerHTML = '';
			f_limpa_composicao();

			VALOR_TOTAL_NF.value = '0.00';
			COD_UNIDADE.value = 'Kg';
			NOTA_ALTURA.value = 0;
			NOTA_COMPRIMENTO.value = 0;
			NOTA_LARGURA.value = 0;
			NOTA_QTDE_VOLUME.value = 1;
			
			COMPOSICAO.readOnly = false;
			CPF_MOTORISTA.readOnly = false;

			document.getElementById('tr_gerar_romaneio').style.display = '';
			GERA_ROMANEIO.disabled = true;
			GERA_ROMANEIO.checked  = false;

			f_limpar_NOTAS_FISCAIS();
			f_limpar_NFE();
			f_limpar_OUTROS();
			TIPO_DOCUMENTO_ID.value = 1;
			TIPO_DOC_OUTROS.value = '99';
			f_muda_tipo_documento();

			document.getElementById("MODALIDADE").value = 'FROTA';
			document.getElementById("LIBERADA_AGENDAMENTO").value = '1';
			 // <cfoutput>#qrValidacaoANTT.valor#</cfoutput>
			<cfif qrValidacaoANTT.valor eq 'NAO VALIDA'>
			  document.getElementById('btn_valida_antt').disabled = true;
			</cfif>
			f_muda_liberada_agendamento();
		}
	}

	function f_on_editar() {
		with(document.forms[0]) {
			if(TERCEIRIZADO.value == 1){
				if(<cfoutput>'#qrAcaoComposicaoContainer.recordCount#'</cfoutput> != 1){
					alert("Seu usurio no possui ao para editar solicitaes de carga");
					f_cancelar();
					return;
				}
			}

			f_desabilitar_botao('cancelar_doc');

			catTree.closeAll();
			document.getElementById('arvore').disabled = true;

			if(document.getElementById('sp_natureza_restrita').style.display == '' && NATUREZA_COMBO.options.length == 1 || TERCEIRIZADO.value == 1)
				NATUREZA_COMBO.disabled = true;
			else
				NATUREZA_COMBO.disabled = false;

			if(document.getElementById('sp_remetente_restrita').style.display == '' && NOME_REMETENTE_COMBO.options.length == 1 || TERCEIRIZADO.value == 1)
				NOME_REMETENTE_COMBO.disabled = true;
			else
				NOME_REMETENTE_COMBO.disabled = false;

			if(document.getElementById('sp_destinatario_restrita').style.display == '' && NOME_DESTINATARIO_COMBO.options.length == 1 || TERCEIRIZADO.value == 1)
				NOME_DESTINATARIO_COMBO.disabled = true;
			else
				NOME_DESTINATARIO_COMBO.disabled = false;

			if(document.getElementById('sp_consignatario_restrita').style.display == '' && NOME_CONSIGNATARIO_COMBO.options.length == 1 || TERCEIRIZADO.value == 1)
				NOME_CONSIGNATARIO_COMBO.disabled = true;
			else
				NOME_CONSIGNATARIO_COMBO.disabled = false;

			if(document.getElementById('sp_redespacho_restrita').style.display == '' && NOME_REDESPACHO_COMBO.options.length == 1 || TERCEIRIZADO.value == 1)
				NOME_REDESPACHO_COMBO.disabled = true;
			else
				NOME_REDESPACHO_COMBO.disabled = false;

			if(document.getElementById('sp_cobranca_restrita').style.display == '' && NOME_COBRANCA_COMBO.options.length == 1 || TERCEIRIZADO.value == 1)
				NOME_COBRANCA_COMBO.disabled = true;
			else
				NOME_COBRANCA_COMBO.disabled = false;

			if(document.getElementById('sp_origem_restrita').style.display == '' && ORIGEM_MUNICIPIO_COMBO.options.length == 1 || TERCEIRIZADO.value == 1)
				ORIGEM_MUNICIPIO_COMBO.disabled = true;
			else
				ORIGEM_MUNICIPIO_COMBO.disabled = false;

			if(document.getElementById('sp_destino_restrita').style.display == '' && DESTINO_MUNICIPIO_COMBO.options.length == 1 || TERCEIRIZADO.value == 1)
				DESTINO_MUNICIPIO_COMBO.disabled = true;
			else
				DESTINO_MUNICIPIO_COMBO.disabled = false;

			if (TIPO_DOCUMENTO_ID.value == '')
    		   TIPO_DOCUMENTO_ID.value = 0;

			f_controla_tipo_docto_frete();

			// Se a SITUACAO_ID for 1 ou 2, permite alterar os dados da composio
			if(Number(SITUACAO_ID.value) == 1 && Number(LIBERADA_AGENDAMENTO.value) == 0 || TERCEIRIZADO.value == 1) {
				MODALIDADE.disabled           = false;
				LIBERADA_AGENDAMENTO.disabled = false;
				f_muda_liberada_agendamento();
				MULTIPLA_SOLICITACAO.disabled = false;

				document.getElementById('COMPOSICAO').readOnly = false;
				for(var i = 1; i <= v_count_composicao.length; i++) {
					document.getElementById('COMPOSICAO_' + i).readOnly = false;
				}
				CPF_MOTORISTA.readOnly = false;
				document.getElementById('btn_add_composicao').disabled = false;
				document.getElementById('btn_localizar_motorista').disabled = false;
			}
			else {
				MODALIDADE.disabled           = true;
				LIBERADA_AGENDAMENTO.disabled = true;
				f_muda_liberada_agendamento();
				MULTIPLA_SOLICITACAO.checked  = false;
				MULTIPLA_SOLICITACAO.disabled = true;

				document.getElementById('COMPOSICAO').readOnly = true;
				for(var i = 1; i <= v_count_composicao.length; i++) {
					document.getElementById('COMPOSICAO_' + i).readOnly = true;
				}
				CPF_MOTORISTA.readOnly = true;
				document.getElementById('btn_add_composicao').disabled = true;
				document.getElementById('btn_localizar_motorista').disabled = true;
			}

			<cfif qrValidacaoANTT.valor eq 'NAO VALIDA'>
			  document.getElementById('btn_valida_antt').disabled = true;
			</cfif>

			if(POSSUI_MOVTO_CONTAINER.value == 1){
				document.getElementById("BTN_BUSCA_CONTAINER").style.display = "none";
				document.getElementById("CONTAINER_IDENTIFICADOR").disabled = true;
			} else {
				document.getElementById("BTN_BUSCA_CONTAINER").style.display = "";
				document.getElementById("CONTAINER_IDENTIFICADOR").disabled = false;
			}

			if(NUM_ROMANEIO.value == '' && <cfoutput>'#v_recurso_ccad#'</cfoutput> == '0'){
				document.getElementById('btn_add_composicao').disabled = false;
				for(var i = 2; i <= v_count_composicao; i++) {
					document.getElementById('COMPOSICAO_' + i).disabled = false;
				}
				document.getElementById('COMPOSICAO').disabled = false;
				document.getElementById('btn_localizar_motorista').disabled = false;
				document.getElementById('CPF_MOTORISTA').disabled = false;
			} else {
				document.getElementById('btn_add_composicao').disabled = true;
				for(var i = 2; i <= v_count_composicao; i++) {
					document.getElementById('COMPOSICAO_' + i).disabled = true;
				}
				document.getElementById('COMPOSICAO').disabled = true;
				document.getElementById('btn_localizar_motorista').disabled = true;
				document.getElementById('CPF_MOTORISTA').disabled = true;
			}

			f_set_terceirizado_disabled(true);

		}
	}

	function f_on_cancelar() {
		catTree.closeAll();
		document.getElementById('arvore').disabled = true;
	}

	function f_muda_operacao() {
		with(document.forms[0]) {
			document.getElementById('TEMPO_ROTA').value = '';
			if(OPERACAO_ID.value == ""){
				OPERACAO_DESCRICAO.value = "";
				return false;
			}
			
			NOME_REMETENTE_COMBO.disabled = false;
			NOME_DESTINATARIO_COMBO.disabled = false;			
			NOME_CONSIGNATARIO_COMBO.disabled = false;
			NOME_REDESPACHO_COMBO.disabled = false;
			NOME_COBRANCA_COMBO.disabled = false;
			ORIGEM_MUNICIPIO_COMBO.disabled = false;
			DESTINO_MUNICIPIO_COMBO.disabled = false;
			
			f_cria_carregando_ajax();
			CONSULTA.value = 2;
			target = 'consultas';
			action = 'consultas.cfm';
			submit();
		}
	}

	function f_muda_valor_em() {
		with(document.forms[0]) {
			switch(VALOR_EM.value) {
				case 'M3':
					document.getElementById('sp_m3').style.display = '';
					document.getElementById('sp_volumes').style.display = 'none';
					VALOR_UNITARIO.disabled = false;
					VALOR_UNITARIO.className = 'requerido_form';
					parent.f_obrigatorio(VALOR_UNITARIO, 1);
					break;
				case 'VOLUME':
					document.getElementById('sp_m3').style.display = 'none';
					document.getElementById('sp_volumes').style.display = '';
					VALOR_UNITARIO.disabled = false;
					VALOR_UNITARIO.className = 'requerido_form';
					parent.f_obrigatorio(VALOR_UNITARIO, 1);
					break;
				case 'PESO':
					document.getElementById('sp_m3').style.display = 'none';
					document.getElementById('sp_volumes').style.display = 'none';
					VALOR_UNITARIO.disabled = false;
					VALOR_UNITARIO.className = 'requerido_form';
					parent.f_obrigatorio(VALOR_UNITARIO, 1);
					break;
				case 'LOTACAO':
					document.getElementById('sp_m3').style.display = 'none';
					document.getElementById('sp_volumes').style.display = 'none';
					VALOR_UNITARIO.disabled = true;
					VALOR_UNITARIO.className = 'input_disable';
					parent.f_obrigatorio(VALOR_UNITARIO, 0);
					break;
				default:
					document.getElementById('sp_m3').style.display = 'none';
					document.getElementById('sp_volumes').style.display = 'none';
					VALOR_UNITARIO.disabled = false;
					VALOR_UNITARIO.className = 'requerido_form';
					parent.f_obrigatorio(VALOR_UNITARIO, 1);
					break;
			}
			f_calcula_peso(VALOR_EM);
		}
	}
	
	function f_muda_peso() {
		with(document.forms[0]) {
			LOTE_PESO_RESTANTE.value = LOTE_COMBO.options[LOTE_COMBO.selectedIndex].getAttribute('lote_peso_restante');
			if (COD_UNIDADE.value == 'Kg'){
				LOTE_PESO_RESTANTE.value = LOTE_PESO_RESTANTE.value*1000;
			}
		}
	}
	
	v_alert_natureza = 1;
	function f_busca_natureza(p_opcao) {
		with(document.forms[0]) {
			PESO_ESPECIFICO.value = 1;

			switch(p_opcao) {
				case 1:
					if(document.getElementById('sp_natureza_aberta').style.display == 'none') {
						NATUREZA_COMBO.value = NUM_NATUREZA.value;

						if(!NUM_NATUREZA.value) {
							return;
						}

						if(NATUREZA_COMBO.value) {
							PESO_ESPECIFICO.value = NATUREZA_COMBO.options[NATUREZA_COMBO.selectedIndex].getAttribute('peso_especifico');
						}
						else {
							alert('Natureza no permitida para a operao ' + OPERACAO_DESCRICAO.value + ', selecione uma das naturezas permitidas.');
							NUM_NATUREZA.focus();
						}
					}
					else {
						NATUREZA.value = '';

						if(!NUM_NATUREZA.value) {
							return;
						}
						NATUREZA.value = 'Buscando natureza...';
						f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_operacao.cfc</cf_url>?method=get_natureza'
									,'num_natureza=' + NUM_NATUREZA.value
									,function(obj) {
										if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
											if(obj.struct.num_natureza.length > 0) {
												NATUREZA.value        = obj.struct.descricao[0];
												PESO_ESPECIFICO.value = obj.struct.peso_especifico[0];
											}
											else {
												NATUREZA.value = '';
												alert('Natureza no encontrada.');
												NUM_NATUREZA.focus();
											}
										}
									});
					}
					break;
				case 2:
					NUM_NATUREZA.value = NATUREZA_COMBO.value;
					break;
			}
			v_num_natureza_notas = NUM_NATUREZA.value;
				v_alert_natureza = 0;
				NOTA_NUM_NATUREZA.value = NUM_NATUREZA.value;
				NOTA_NUM_NATUREZA.onchange();


				NFE_NUM_NATUREZA.value = NUM_NATUREZA.value;
				NFE_NUM_NATUREZA.onchange();

				OUTROS_NUM_NATUREZA.value = NUM_NATUREZA.value;
				OUTROS_NUM_NATUREZA.onchange();
				v_alert_natureza = 1;
		}
	}

	function f_calcula_peso(obj) {
		with(document.forms[0]) {
			switch(VALOR_EM.value) {
				case 'M3':
					if(obj == PESO) {
						if(Number(PESO_ESPECIFICO.value) == 0) {
							M3.value = 0;
						}
						else {
							M3.value = Math.round(Number(PESO.value) / Number(PESO_ESPECIFICO.value), 2);
						}
					}
					else {
						PESO.value = Math.round(Number(M3.value) * Number(PESO_ESPECIFICO.value), 2);
					}
					break;
				case 'VOLUME':
					if(obj == PESO) {
						if(Number(QTDE_VOLUME.value) == 0) {
							PESO_VOLUME.value = 0;
						}
						else {
							PESO_VOLUME.value = Math.round(Number(PESO.value) / Number(QTDE_VOLUME.value), 2);
						}
					}
					else {
						PESO.value = Math.round(Number(PESO_VOLUME.value) * Number(QTDE_VOLUME.value), 2);
					}
					break;
				case 'PESO':

					break;
				case 'LOTACAO':

					break;
				default:

					break;
			}
			
		}
		f_calcula_valor();
	}

	function f_calcula_valor(obj) {
		with(document.forms[0]) {
			switch(VALOR_EM.value) {
				case 'M3':
					if(obj == VALOR_TOTAL) {
						VALOR_UNITARIO.value = Number(Number(VALOR_TOTAL.value) / Number(M3.value)).toFixed(2);
					}
					else {
						VALOR_TOTAL.value = Number(Number(VALOR_UNITARIO.value) * Number(M3.value)).toFixed(2);
					}
					break;
				case 'VOLUME':
					if(obj == VALOR_TOTAL) {
						VALOR_UNITARIO.value = Number(Number(VALOR_TOTAL.value) / Number(QTDE_VOLUME.value)).toFixed(2);
					}
					else {
						VALOR_TOTAL.value = Number(Number(VALOR_UNITARIO.value) * Number(QTDE_VOLUME.value)).toFixed(2);
					}
					break;
				case 'LOTACAO':
					// No altera o Valor
					break;
				default:
					if(obj == VALOR_TOTAL) {
							if(PESO.value == ''){
								alert('Informe o Peso.');
								VALOR_TOTAL.value = '';
								 return;
							}
							if(PESO.value == 0){
								alert('O Peso deve ser maior que zero.');
								VALOR_TOTAL.value = '';
								 return;
							}
						VALOR_UNITARIO.value = Number((Number(VALOR_TOTAL.value) / Number(PESO.value))).toFixed(2);

						}
						else if(obj == VALOR_UNITARIO){
							if(PESO.value == ''){
								alert('Informe o Peso.');
								VALOR_UNITARIO.value = '';
								return;
							}
							if(PESO.value == 0){
								alert('O Peso deve ser maior que zero.');
								VALOR_TOTAL.value = '';
								 return;
							}
							VALOR_TOTAL.value = Number(Number(VALOR_UNITARIO.value) * Number(PESO.value)).toFixed(2);
					}
					else {
						VALOR_TOTAL.value = Number(Number(VALOR_UNITARIO.value) * Number(PESO.value)).toFixed(2);
					}
					break;
			}
		}
	}

	function f_valida_data_campo(p_campo, p_data) {
		v_display = p_campo.getAttribute('display').toString();
		if(Number(p_campo.value.getDateTime()) < Number(p_data)) {
			alert('O campo ' + v_display + ' deve ser maior que a data atual.');
			p_campo.select();
			return false;
		}
		else if (Number(p_campo.value.getDateTime()) > Number(p_data)+(30*24*60*60*1000)) {
			alert('O campo ' + v_display + ' no pode ser maior que ' + (new Date(Number(new Date()) + (30 * 24 * 60 * 60 * 1000))).format('dd/mm/yyyy hh24:mi') + '.');
			p_campo.select();
			return false;
		}
		return true;
	}

	v_count_composicao = 0;

	function f_add_composicao() {
		with(document.forms[0]) {
			v_div = document.getElementById('dv_composicao');
			v_dv = document.createElement('span');
			v_count_composicao++;
			if(<cfoutput>'#v_recurso_ccad#'</cfoutput> == '0'){
			   v_dv.innerHTML = '&nbsp;<input type="text" name="COMPOSICAO" id="COMPOSICAO_' + v_count_composicao + '" readonly="false" onChange="f_change_composicao(this)" onBlur="f_change_composicao(this)" onKeyPress="return f_formata(this, event, \'AAAAAAAAAAAAAAAAAA\')" />';
			   v_div.appendChild(v_dv);
			   document.getElementById('COMPOSICAO_' + v_count_composicao).readOnly = false;
			   document.getElementById('COMPOSICAO_' + v_count_composicao).select();
			} else {
			   v_dv.innerHTML = '&nbsp;<input type="text" name="COMPOSICAO" id="COMPOSICAO_' + v_count_composicao + '" readonly="true" onChange="f_change_composicao(this)" onBlur="f_change_composicao(this)" onKeyPress="return f_formata(this, event, \'AAAAAAAAAAAAAAAAAA\')" />';
			   v_div.appendChild(v_dv);
			   document.getElementById('COMPOSICAO_' + v_count_composicao).readOnly = true;
			}
		}
	}

	function f_change_composicao(v_obj) {
		if(v_obj.value == '') {
			v_obj.parentNode.parentNode.removeChild(v_obj.parentNode);
			return;
		}
	}

	function f_limpa_composicao() {
		v_div = document.getElementById('dv_composicao');

		for(i = v_div.childNodes.length - 1; i >= 0; i--) {
			v_div.removeChild(v_div.childNodes[i]);
		}

		v_count_composicao = 0;
		
		<cfif v_alerta_cpg_aberto eq 'Sim'>
		   with(document.forms[0]) {
			   POSSUI_CPG_ABERTO.value = 0;
			   document.getElementById('tr_cpg_aberto').style.display = 'none';
		   }
		</cfif>
		
	}

	function f_busca_composicao() {
		with(document.forms[0]) {
			NOME_MOTORISTA.value = '';
			COD_MOTORISTA.value = '';
			CPF_MOTORISTA.value = '';
			COMPOSICAO_CAPACIDADE.value = '0';
			if(document.getElementById('COMPOSICAO').value == '') {
				f_limpa_composicao();
				return;
			}
			f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_operacao.cfc</cf_url>?method=get_composicao'
						,'cod_veiculo='+document.getElementById('COMPOSICAO').value+'&solicitacao_carga_id_vinculo='+document.getElementById('SOLICITACAO_CARGA_ID_VINCULO').value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.cod_veiculo.length > 0 && obj.struct.cod_veiculo[0] != -1) {
									f_limpa_composicao();
									for(var i=0;i<obj.struct.cod_veiculo.length;i++) {
										if(i == 0) {
											document.getElementById('COMPOSICAO').value = obj.struct.cod_veiculo[0];
											COD_PROPRIETARIO.value = obj.struct.cod_proprietario[0];
											MODALIDADE_VEICULO.value = obj.struct.modalidade[0];
											MODALIDADE.value = obj.struct.modalidade[0];
											f_muda_modalidade();
											f_busca_motorista();
										}
										else {
											f_add_composicao();
											document.getElementById('COMPOSICAO_'+v_count_composicao).value = obj.struct.cod_veiculo[i];
										}
									}
									COMPOSICAO_CAPACIDADE.value = obj.struct.capacidade[0];
									document.getElementById('composicao_capacidade_span').innerHTML = 'Cap.: '+COMPOSICAO_CAPACIDADE.value/1000+' Ton.';
									
									if (COMPOSICAO_CAPACIDADE.value > 0){
										if (COD_UNIDADE.value == 'Kg'){
											PESO.value = COMPOSICAO_CAPACIDADE.value;
										} else {
											PESO.value = COMPOSICAO_CAPACIDADE.value/1000;
										}
									}
									// Valida ANTT
									f_valida_antt();
								}
							}
						});
		}
	}

	function f_busca_motorista() {
		with(document.forms[0]) {
			COD_MOTORISTA.value  = '';
			CPF_MOTORISTA.value  = '';
			NOME_MOTORISTA.value = '';

			if(!document.getElementById('COMPOSICAO').value) {
				f_busca_historico_cartao();

				return;
			}else{
				f_busca_historico_cartao();
			}
			
			NOME_MOTORISTA.value = 'Aguarde, buscando dados...';
			f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_operacao.cfc</cf_url>?method=get_motorista_proprietario'
						,'placa_controle=' + document.getElementById('COMPOSICAO').value
						+'&trata_erro=2'
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.erro == 'true') {
									alert(obj.struct.mensagem.detail.replace(/^ORA-20000: |ORA-[0-9]{5}.*|\n/g, ''));
								 	COD_MOTORISTA.value  = '';
									CPF_MOTORISTA.value  = '';
									NOME_MOTORISTA.value = '';
									
									<cfif v_alerta_cpg_aberto eq 'Sim'>
									   document.getElementById('tr_cpg_aberto').style.display = 'none';
									</cfif>
								}
								else{
									if(obj.struct.cod_pessoa_proprietario[0] != '') {
										COD_MOTORISTA.value = obj.struct.cod_pessoa_motorista;
										CPF_MOTORISTA.value = obj.struct.cpf_motorista;
									 	NOME_MOTORISTA.value = obj.struct.nome_motorista;
										f_verifica_bloqueio_motorista();
										f_verifica_motorista_cpg_aberto();
								   	}
							  	}

								f_busca_historico_cartao();
							}
						});
		}
	}

	function f_busca_dados(p_solicitacao_carga_id, p_editar) {
		with(document.form_transportes) {
			CONSULTA.value = 1; // Todos os Dados
			SOLICITACAO_CARGA_ID.value = p_solicitacao_carga_id;
			EDITAR.value = p_editar;
			target = 'consultas';
			action = '/modulos/pcl/solicitacao/consultas.cfm';
			submit();
		}
	}

	function f_localizar_motorista(){
		with(document.form_transportes) {
			var v_modalidade;

			if(MODALIDADE_VEICULO.value == 'AGREGADO'){
				v_modalidade = '2,6';
			}else{
				v_modalidade = '2,6,8';
			}

			NewWindow('<cf_url>/_consultas/localizar_pessoa.cfm</cf_url>?field=COD_PESSOA,CNPJ_CPF,CLIENTE&campo=COD_MOTORISTA,CPF_MOTORISTA,NOME_MOTORISTA&funcao=f_verifica_bloqueio_motorista();opener.f_verifica_limite_motorista()&num_modalidade=' + v_modalidade,'_blank',800,600,'yes');
		}
	}

	function f_muda_liberada_agendamento() {
		with(document.forms[0]) {
			if((FRACIONADO.value == 0) || (FRACIONADO.value == 1 && CONTROLA_CONTAINER.value == 1 && CONTROLA_CONTAINER_CG_DIRETA.value == 1)){
				if(MODALIDADE.value == 'FROTA' && Number(LIBERADA_AGENDAMENTO.value) == 1 && <cfoutput>#qrParamModalidade.FROTA#</cfoutput> == 1) {
					GERA_ROMANEIO.disabled = false;
					if(TERCEIRIZADO.value == 1){
						GERA_ROMANEIO.checked  = true;
						GERA_ROMANEIO.disabled = true;
					}
				}
				else if(MODALIDADE.value == 'AGREGADO' && Number(LIBERADA_AGENDAMENTO.value) == 1 && <cfoutput>#qrParamModalidade.AGREGADO#</cfoutput> == 1) {
					GERA_ROMANEIO.disabled = false;
					if(TERCEIRIZADO.value == 1){
						GERA_ROMANEIO.checked  = true;
						GERA_ROMANEIO.disabled = true;
					}
				}
				else if(MODALIDADE.value == 'TERCEIRO' && Number(LIBERADA_AGENDAMENTO.value) == 1 && <cfoutput>#qrParamModalidade.TERCEIRO#</cfoutput> == 1) {
					GERA_ROMANEIO.disabled = false;
					if(TERCEIRIZADO.value == 1){
						GERA_ROMANEIO.checked  = true;
						GERA_ROMANEIO.disabled = true;
					}
				}
				else {
					GERA_ROMANEIO.checked  = false;
					GERA_ROMANEIO.disabled = true;
				}
			} else {
				GERA_ROMANEIO.checked  = false;
				GERA_ROMANEIO.disabled = true;
			}
		}
	}

	function f_muda_modalidade() {
		with(document.forms[0]){
			if(MODALIDADE.value == 'FROTA' && <cfoutput>#qrParamModalidade.FROTA#</cfoutput> == 1) {
				GERA_ROMANEIO.disabled   = false;

				CARTAO_NUMERO.value		 = '';
				ADTO_TRAJETO_VAZIO.value = '';

				document.getElementById('dados_repom').style.display = 'none';
			}
			else if(MODALIDADE.value == 'AGREGADO' && <cfoutput>#qrParamModalidade.AGREGADO#</cfoutput> == 1) {
				GERA_ROMANEIO.disabled = false;

				if(Number(POSSUI_REPOM.value) == 1) {
					document.getElementById('dados_repom').style.display = '';
				}
				else {
					document.getElementById('dados_repom').style.display = 'none';
				}
			}
			else if(MODALIDADE.value == 'TERCEIRO' && <cfoutput>#qrParamModalidade.TERCEIRO#</cfoutput> == 1) {
				GERA_ROMANEIO.disabled = false;

				if(Number(POSSUI_REPOM.value) == 1) {
					document.getElementById('dados_repom').style.display = '';
				}
				else {
					document.getElementById('dados_repom').style.display = 'none';
				}
			}
			else {
				GERA_ROMANEIO.checked  = false;
				GERA_ROMANEIO.disabled = true;

				if(Number(POSSUI_REPOM.value) == 1) {
					document.getElementById('dados_repom').style.display = '';
				}
				else {
					document.getElementById('dados_repom').style.display = 'none';
				}
			}

			if (<cfoutput>'#v_recurso_ccad#'</cfoutput> == '1') {
				CPF_MOTORISTA.value = '';
				NOME_MOTORISTA.value = '';
				CPF_MOTORISTA.readOnly = true;
				document.getElementById('btn_add_composicao').disabled      = true;
				document.getElementById('btn_localizar_motorista').disabled = true;
			} else {
				CPF_MOTORISTA.readOnly = false;
				document.getElementById('btn_add_composicao').disabled      = false;
				document.getElementById('btn_localizar_motorista').disabled = false;
			}

			f_muda_liberada_agendamento();
		}
	}

	function f_muda_especie() {
		with(document.forms[0]) {
			NOTA_NUM_ESPECIE.value = NUM_ESPECIE.value;
			NFE_NUM_ESPECIE.value = NUM_ESPECIE.value;
			OUTROS_NUM_ESPECIE.value = NUM_ESPECIE.value;

			v_num_especie_notas = NUM_ESPECIE.value;
			
			if(NUM_ESPECIE.options[NUM_ESPECIE.selectedIndex].getAttribute('frete_em') != ''){
				VALOR_EM.value = NUM_ESPECIE.options[NUM_ESPECIE.selectedIndex].getAttribute('frete_em');
			}

			NOTA_NUM_ESPECIE.onchange();
			NFE_NUM_ESPECIE.onchange();
			OUTROS_NUM_ESPECIE.onchange();
		}
	}

	function f_busca_historico_cartao() {
		with(document.forms[0]) {
			if(Number(TIPO_PAGAMENTO_ID.value) != 2 || !COD_MOTORISTA.value) {
				CARTAO_NUMERO_HISTORICO.value = '';
				f_validar_cartao_historico();

				return;
			}

			f_query_wddx('/modulos/pcl/_componentes/consulta/cfc_repom.cfc?method=get_historico_cartao'
							,'cod_motorista=' + COD_MOTORISTA.value
							,function(obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									if(obj.struct.cartao_numero.length > 0) {
										CARTAO_NUMERO_HISTORICO.value = obj.struct.cartao_numero[0];

										if (Number(obj.struct.num_contratos[0]) > 0) {
										   	document.getElementById('tr_contrato_pendente').style.display = '';
										   	document.getElementById('td_contrato_pendente').innerHTML = 'Este carto possui ' + obj.struct.num_contratos[0] + ' contratos pendentes de quitao. <span style="cursor:pointer" onclick="f_visualizar_cartao_historico()">Ver contratos</span>';
										}
										else {
										   	document.getElementById('td_contrato_pendente').innerHTML = '';
										   	document.getElementById('tr_contrato_pendente').style.display = 'none';
										}

										if(!CARTAO_NUMERO.value) {
											CARTAO_NUMERO.value = obj.struct.cartao_numero[0];
										}
									}
									else {
										CARTAO_NUMERO_HISTORICO.value = '';
									}

									f_validar_cartao_historico();
								}
							});
		}
	}

	function f_validar_cartao_historico() {
		with(document.forms[0]) {
			if(CARTAO_NUMERO_HISTORICO.value) {
				document.getElementById('tr_info_cartao_historico').style.display = '';
				document.getElementById('sp_info_cartao_historico').innerHTML = 'Nmero do ltimo carto Repom utilizado por este motorista: ' + CARTAO_NUMERO_HISTORICO.value + '.';
			}
			else {
				document.getElementById('tr_info_cartao_historico').style.display = 'none';
				document.getElementById('sp_info_cartao_historico').innerHTML = '';
			}
		}
	}

	function f_visualizar_cartao_historico() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/aplicacoes/transporte/repom/consulta_cartao/principal.cfm</cf_url>?CARTAO_NUMERO=' + CARTAO_NUMERO_HISTORICO.value, '', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_verifica_bloqueio_motorista(){
		with(document.forms[0]){
			if(COD_MOTORISTA.value != ''){
			f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_operacao.cfc</cf_url>?method=verifica_bloqueio_motorista'
						,'cod_motorista=' + COD_MOTORISTA.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.motorista_bloqueado.length > 0) {
									if(Number(obj.struct.motorista_bloqueado[0]) > 0){
								   	  alert('O motorista ' + NOME_MOTORISTA.value + ' est bloqueado.');
								    }
								}
							}
						});
		}
	}
	}

	function f_verifica_bloqueio_veiculo(){
		with(document.forms[0]){
			var placa_controle = COMPOSICAO.value.split(',');
			f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_operacao.cfc</cf_url>?method=verifica_bloqueio_veiculo'
						,'placa=' + placa_controle[0]
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.veiculo_bloqueado.length > 0) {
								   if(Number(obj.struct.veiculo_bloqueado[0]) > 0){
									 alert('O veculo ' + placa_controle[0] + ' est bloqueado.');
								   }
								}
							}
						});
		}
	}

	function f_valida_antt(){
		with(document.forms[0]){
			if (COMPOSICAO.value) {
  			   var placas = COMPOSICAO.value.split(',');
			   var v_placa_cavalo = placas[0];
			   var v_placa_carreta = placas[1];
			   try {
			      var v_placa_carreta2 = placas[2];
			   }
			   catch(e) {
			      var v_placa_carreta2 = '';
			   }
			   
			   try {
			      var v_placa_carreta3 = placas[3];
			   }
			   catch(e) {
			      var v_placa_carreta3 = '';
			   }
			} else {
			   var v_placa_cavalo = COMPOSICAO[0].value;
			   var v_placa_carreta = COMPOSICAO[1].value;
			   
			   try {
			      var v_placa_carreta2 = COMPOSICAO[2].value;
			   }
			   catch(e) {
			      var v_placa_carreta2 = '';
			   }
			   
			   try {
			      var v_placa_carreta3 = COMPOSICAO[3].value;
			   }
			   catch(e) {
			      var v_placa_carreta3 = '';
			   }
			}

			if (!v_placa_carreta) {
			   v_placa_carreta = '';
			}
			
			if (!v_placa_carreta2) {
			   v_placa_carreta2 = '';
			}
			
			if (!v_placa_carreta3) {
			   v_placa_carreta3 = '';
			}

			f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_solicitacao.cfc</cf_url>?method=get_validacao_antt_repom'
						,'placa_cavalo=' + v_placa_cavalo + '&placa_carreta=' + v_placa_carreta + '&placa_carreta2=' + v_placa_carreta2 + '&placa_carreta3=' + v_placa_carreta3 + '&cod_contratado=' + COD_PROPRIETARIO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.erro.length > 0) {
								   if(Number(obj.struct.validacao_executada) == 1){
							 		 document.getElementById('tr_validacao_antt').style.display = '';
 							 		 document.getElementById('sp_antt').innerHTML = '';
									 if (Number(obj.struct.veiculo_validado_antt) == 1) {
										document.getElementById('td_antt_cavalo_msg').innerHTML = obj.struct.veiculo_erro;
										document.getElementById('td_antt_cavalo_validado').innerHTML = 'Validado';
										document.getElementById('td_antt_cavalo_validado').className = 'linha_verde';
									 }
									 else {
										document.getElementById('td_antt_cavalo_msg').innerHTML = obj.struct.veiculo_erro;
										document.getElementById('td_antt_cavalo_validado').innerHTML = 'No validado';
										document.getElementById('td_antt_cavalo_validado').className = 'linha_vermelha';
									 }
									 if (Number(obj.struct.carreta_validado_antt) == 1) {
										document.getElementById('td_antt_carreta_msg').innerHTML = obj.struct.carreta_erro;
										document.getElementById('td_antt_carreta_validado').innerHTML = 'Validado';
										document.getElementById('td_antt_carreta_validado').className = 'linha_verde';
									 }
									 else {
										document.getElementById('td_antt_carreta_msg').innerHTML = obj.struct.carreta_erro;
										document.getElementById('td_antt_carreta_validado').innerHTML = 'No validado';
										document.getElementById('td_antt_carreta_validado').className = 'linha_vermelha';
									 }
									 
									 if(v_placa_carreta2 != ''){
									     document.getElementById('linha_carreta2').style.display = '';
										 
										 if (Number(obj.struct.carreta2_validado_antt) == 1) {
											document.getElementById('td_antt_carreta2_msg').innerHTML = obj.struct.carreta2_erro;
											document.getElementById('td_antt_carreta2_validado').innerHTML = 'Validado';
											document.getElementById('td_antt_carreta2_validado').className = 'linha_verde';
										 }
										 else {
											document.getElementById('td_antt_carreta2_msg').innerHTML = obj.struct.carreta2_erro;
											document.getElementById('td_antt_carreta2_validado').innerHTML = 'No validado';
											document.getElementById('td_antt_carreta2_validado').className = 'linha_vermelha';
										 }
									 }else{
									    document.getElementById('linha_carreta2').style.display = 'none';
									 }
									 
									 if(v_placa_carreta3 != ''){
									     document.getElementById('linha_carreta3').style.display = '';
										 
										 if (Number(obj.struct.carreta3_validado_antt) == 1) {
											document.getElementById('td_antt_carreta3_msg').innerHTML = obj.struct.carreta3_erro;
											document.getElementById('td_antt_carreta3_validado').innerHTML = 'Validado';
											document.getElementById('td_antt_carreta3_validado').className = 'linha_verde';
										 }
										 else {
											document.getElementById('td_antt_carreta3_msg').innerHTML = obj.struct.carreta3_erro;
											document.getElementById('td_antt_carreta3_validado').innerHTML = 'No validado';
											document.getElementById('td_antt_carreta3_validado').className = 'linha_vermelha';
										 }
									 }else{
									    document.getElementById('linha_carreta3').style.display = 'none';
									 }
									 
									 if (Number(obj.struct.contratado_validado_antt) == 1) {
										document.getElementById('td_antt_prop_msg').innerHTML = obj.struct.contratado_erro;
										document.getElementById('td_antt_prop_validado').innerHTML = 'Validado';
										document.getElementById('td_antt_prop_validado').className = 'linha_verde';
									 }
									 else {
										document.getElementById('td_antt_prop_msg').innerHTML = obj.struct.contratado_erro;
										document.getElementById('td_antt_prop_validado').innerHTML = 'No validado';
										document.getElementById('td_antt_prop_validado').className = 'linha_vermelha';
									 }
								   } else {
 							 		 document.getElementById('tr_validacao_antt').style.display = 'none';
									 if(Number(obj.struct.validacao_executada) == 0){
 							 		    if(obj.struct.veiculo_erro != ''){
											document.getElementById('sp_antt').innerHTML = obj.struct.veiculo_erro; 
										 } else {
											document.getElementById('sp_antt').innerHTML = 'd ANTsaT desativada';											 
										 }
									 }
									 if (obj.struct.erro != 'FALSE') {
 							 		    document.getElementById('sp_antt').innerHTML = 'Problemas para executar a validao ANTT.';
									 	alert(obj.struct.erro);
									 }
								   }
								}
							}
						});
		}
	}



	function f_busca_crt(){
		with(document.forms[0]) {
			if(!NUM_CRT_COMPLETO.value){
				document.getElementById('dados_crt').innerHTML 		   = '';
				document.getElementById('span_divisoes').innerHTML     = '';
				document.getElementById('span_divisoes').style.border  = 'none';
				document.getElementById('span_divisoes').style.padding = '0px';
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_crt'
						,'num_crt_completo='+NUM_CRT_COMPLETO.value

						,function(obj){
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								//alert(obj.struct.conhecimento_id);
								if(obj.struct.conhecimento_id.length == 1){
									if(obj.struct.cancelado == 1){
										alert("C.R.T. cancelado. Informe um C.R.T vlido.");
										document.getElementById('NUM_CRT_COMPLETO').value = '';
										exit(0);
									}
									INTC_CONHECIMENTO_ID.value = obj.struct.conhecimento_id[0];
									document.getElementById('dados_crt').innerHTML = 'Cliente: ' + obj.struct.rem_nome[0] + ' Pedido Shipment: ' + obj.struct.pedido_shipment[0] + ' Qtde. Embarques: ' + obj.struct.embarques[0] + ' Peso Bruto: ' + Number(obj.struct.peso_bruto[0]).toFixed(3) + ' Kg';
								    f_busca_crt_divisao();
								}else{
									alert("C.R.T. no encontrado. Verifique o nmero do conhecimento informado.");
									document.getElementById('dados_crt').innerHTML = '';
									NUM_CRT_COMPLETO.value = '';
									INTC_CONHECIMENTO_ID.value = "";
								}
							}
						});
		}
	}


	var v_limite_por = '';
	var v_embarques = 0;
	var v_peso_carregado_origem = 0;
	var v_peso_carregado_fronteira = 0;
	var v_limite_peso = 0;
	var v_limite_embarques = 0;

	function f_busca_crt_divisao(){
		with(document.forms[0]) {
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_intc_crt_divisao'
						,'mostra_canceladas=0&conhecimento_id='+INTC_CONHECIMENTO_ID.value
						,function(obj){
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.conhecimento_id.length > 0){
									var divisoes = '<table width="100%" height="100%" border="0" cellspacing="1" cellpadding="1" class="borda">';
											divisoes += '<tr class="titulo_1">';
												divisoes += '<td style="width:120px;"><nobr>Num. Embarque</nobr></td>';
												divisoes += '<td>Composio</td>';
												divisoes += '<td>Motorista</td>';
												divisoes += '<td>Origem</td>';
												divisoes += '<td>Destino</td>';
												divisoes += '<td style="text-align:right">Peso KG</td>';
												divisoes += '<td style="text-align:right">KM</td>';
											divisoes += '</tr>';
									var linha = 1;
									for(var i=0; i<obj.struct.conhecimento_id.length; i++){
										linha=linha==1?2:1;
										divisoes += '<tr class="linha_'+linha+'">';
											divisoes += '<td>'+obj.struct.num_embarque[i]+'</td>';
											divisoes += '<td>'+obj.struct.placa_controle[i];
											divisoes += obj.struct.placa_referencia_composicao[i]!=''?','+obj.struct.placa_referencia_composicao[i]+'</td>':'</td>';
											divisoes += '<td>'+obj.struct.motorista[i]+'</td>';
											divisoes += '<td>'+obj.struct.origem[i]+'</td>';
											divisoes += '<td>'+obj.struct.destino[i]+'</td>';
											divisoes += '<td style="text-align:right">'+Number(obj.struct.peso_sol[i]).toFixed(3)+'</td>';
											divisoes += '<td style="text-align:right">'+obj.struct.distancia_padrao[i]+'</td>';

											v_limite_por = obj.struct.tipo_limite[i];
											v_peso_carregado_origem = obj.struct.peso_total_embarcado[i];
											v_peso_carregado_fronteira = obj.struct.peso_embarcado_fronteira[i];
											v_embarques        = obj.struct.numero_embarques[i];
											v_limite_peso      = obj.struct.limite_peso[i];
											v_limite_embarques = obj.struct.limite_embarques[i];
										divisoes += '</tr>';
									}
									divisoes += '<tr class="titulo_2">';
  									    divisoes += '<td colspan="7">CRT possui limite "'+v_limite_por+'". ';
										if (v_limite_por == 'Por peso') {
											divisoes += ' Peso embarcado origem: ' +Number(v_peso_carregado_origem).toFixed(3) + ' Kg - Peso restante para embarque: ' + Number(v_limite_peso - v_peso_carregado_origem).toFixed(3) + ' Kg';
										}
										if (v_limite_por == 'Por Embarque') {
											divisoes += ' Embarque(s) realizado(s): ' + v_embarques + ' - Embarque(s) restante(s): ' + Number(v_limite_embarques - v_embarques).toFixed(0) + '.';
										}
  									    divisoes += '</td>';
								    divisoes += '</tr>';

									divisoes += '<tr class="titulo_2">';
										if (v_limite_por == 'Por peso') {
											divisoes += '<td colspan="7">';
											divisoes += ' Peso embarcado na fronteira: ' + Number(v_peso_carregado_fronteira).toFixed(3) + ' Kg - Peso restante para embarque na fronteira: ' + Number(v_peso_carregado_origem - v_peso_carregado_fronteira).toFixed(3) + ' Kg';
											divisoes += '</td>';
								        }
								    divisoes += '</tr>';


									divisoes += '</table>';
									document.getElementById('span_divisoes').innerHTML     = divisoes;
									document.getElementById('span_divisoes').style.padding = '1px';

								} else {
									document.getElementById('span_divisoes').innerHTML     = '';
									document.getElementById('span_divisoes').style.border  = 'none';
									document.getElementById('span_divisoes').style.padding = '0px';
							   }
							}
						});
		}
	}

	function f_get_tempo_rota() {
		with(document.forms[0]) {
			if(ORIGEM_MUNICIPIO_ID.value != '' && DESTINO_MUNICIPIO_ID.value != ''){
				f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_solicitacao.cfc</cf_url>?method=get_tempo_rota'
							,'origem_municipio_id='+ORIGEM_MUNICIPIO_ID.value+'&destino_municipio_id='+DESTINO_MUNICIPIO_ID.value+
							'&cod_remetente='+COD_REMETENTE.value+'&cod_destinatario='+COD_DESTINATARIO.value+
							'&data_inicio='+DATA_CARREGAMENTO_FIM.value+
							'&operacao_id='+OPERACAO_ID.value
							,function(obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									document.getElementById('TEMPO_ROTA').value = obj.struct.tempo_rota[0];
									
									if ((OPERACAO.value == 2 || OPERACAO.value == 3) && obj.struct.data_final[0] != '') {
									    var diferenca = (document.getElementById('DATA_ENTREGA_FIM').value.getDateTime() - document.getElementById('DATA_ENTREGA_INICIO').value.getDateTime());
										document.getElementById('DATA_ENTREGA_INICIO').value = obj.struct.data_final[0];
										document.getElementById('DATA_ENTREGA_INICIO').value = document.getElementById('DATA_ENTREGA_INICIO').value.getDateTime().format('dd/mm/yyyy hh24:mi');
										
									    if (DATA_ENTREGA_INICIO.value == '' || DATA_ENTREGA_FIM.value == '') {
										   document.getElementById('DATA_ENTREGA_FIM').value = obj.struct.data_final_1[0];
										   document.getElementById('DATA_ENTREGA_FIM').value = document.getElementById('DATA_ENTREGA_FIM').value.getDateTime().format('dd/mm/yyyy hh24:mi');
										} else{
										   var v_data_auxiliar = document.getElementById('DATA_ENTREGA_INICIO').value.getDateTime();
										   document.getElementById('DATA_ENTREGA_FIM').value = new Date(v_data_auxiliar.getTime() + diferenca).format('dd/mm/yyyy hh24:mi');
										}
									}
								} else {
									document.getElementById('TEMPO_ROTA').value = 'Rota no encontrada.';
								}
							});
			}  else {
				document.getElementById('TEMPO_ROTA').value = 'Rota no encontrada.';
			}
		}
	}

	function f_busca_pre_ordem(){
		with(document.forms[0]) {
			if(!PRE_ORDEM_ID.value){
				document.getElementById('sp_dados_pre_ordem').innerHTML     = '';
				document.getElementById('sp_dados_pre_ordem').style.border  = 'none';
				document.getElementById('sp_dados_pre_ordem').style.padding = '0px';
				return;
			}
			f_query_wddx('<cf_url>/modulos/grisco/_componentes/consulta/cfc_grisco.cfc</cf_url>?method=get_pre_ordens'
						,'pre_ordem_id_filtro='+PRE_ORDEM_ID.value

						,function(obj){
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.pre_ordem_id.length == 1){
									if(obj.struct.valida[0] == 1){
										if(obj.struct.status_codigo[0] == 1){
											if(obj.struct.solicitacao_carga_id[0] == ''){
												PRE_ORDEM_ID.value = obj.struct.pre_ordem_id[0];
												v_pre_ordem = '<strong>Motorista:</strong> ' + obj.struct.mot_nome[0] + ' (' + obj.struct.mot_cpf[0] + ')<br>' +
															  '<strong>Cavalo:</strong> ' + obj.struct.cavalo_placa[0] + ' <strong>Proprietrio:</strong> ' + obj.struct.cavalo_prop_nome[0]  + ' (' + obj.struct.cavalo_prop_cnpj_cpf[0] + ')<br>' +
															  '<strong>Carreta:</strong> ' + obj.struct.carreta_placa[0] + ' <strong>Proprietrio:</strong> ' + obj.struct.carreta_prop_nome[0]  + ' (' + obj.struct.carreta_prop_cnpj_cpf[0] + ')<br>';

												if(obj.struct.carreta2_placa[0] != ''){
													v_pre_ordem = v_pre_ordem + '<strong>2 Carreta:</strong> ' + obj.struct.carreta2_placa[0] + ' <strong>Proprietrio:</strong> ' + obj.struct.carreta2_prop_nome[0]  + ' (' + obj.struct.carreta2_prop_cnpj_cpf[0] + ')<br>';
												}

												if(obj.struct.carreta3_placa[0] != ''){
													v_pre_ordem = v_pre_ordem + '<strong>3 Carreta:</strong> ' + obj.struct.carreta3_placa[0] + ' <strong>Proprietrio:</strong> ' + obj.struct.carreta3_prop_nome[0]  + ' (' + obj.struct.carreta3_prop_cnpj_cpf[0] + ')<br>';
												}

												v_pre_ordem = v_pre_ordem + '<strong>Origem:</strong> ' + obj.struct.origem_municipio[0] + ' - ' + obj.struct.origem_uf[0] + '<br>';
												v_pre_ordem = v_pre_ordem + '<strong>Destino:</strong> ' + obj.struct.destino_municipio[0] + ' - ' + obj.struct.destino_uf[0] + '<br>';
												v_pre_ordem = v_pre_ordem + '<strong>Mercadoria:</strong> ' + obj.struct.mercadoria[0] + ' <strong>Valor mercadoria:</strong> R$ ' +  obj.struct.valor_mercadoria_formatado[0];

												document.getElementById('sp_dados_pre_ordem').innerHTML = v_pre_ordem;
											}else{
												alert("A pr-ordem informada encontra-se vinculada a solicitao de carga n " + obj.struct.solicitacao_carga_id[0] +'.');
												document.getElementById('sp_dados_pre_ordem').innerHTML = '';
												PRE_ORDEM_ID.value = '';
												return;
											}
										}else{
											alert("O status da pr-ordem informada no permite que a mesma seja vinculada a uma solicitao de carga.");
											document.getElementById('sp_dados_pre_ordem').innerHTML = '';
											PRE_ORDEM_ID.value = '';
											return;
										}
									}else{
										alert("A pr-ordem informada est fora do perodo de validade. Gere uma nova pr-ordem para poder vincul-la a solicitao.");
										document.getElementById('sp_dados_pre_ordem').innerHTML = '';
										PRE_ORDEM_ID.value = '';
										return;
									}
								}else{
									alert("Pr-ordem no encontrada.");
									document.getElementById('sp_dados_pre_ordem').innerHTML = '';
									PRE_ORDEM_ID.value = '';
									return;
								}
							}
						});
		}
	}
	
	function f_muda_endereco_DESTINO(){
		with(document.forms[0]) {
			if(ENDERECO_COMBO_REDESPACHO.options[ENDERECO_COMBO_REDESPACHO.options.selectedIndex].municipio_id == ''){
				if(ENDERECO_COMBO_DESTINATARIO.options[ENDERECO_COMBO_DESTINATARIO.options.selectedIndex].municipio_uf != 'undefined'){
					DESTINO_MUNICIPIO.value    	  = ENDERECO_COMBO_DESTINATARIO.options[ENDERECO_COMBO_DESTINATARIO.options.selectedIndex].municipio_uf;
					DESTINO_MUNICIPIO_COMBO.value = ENDERECO_COMBO_DESTINATARIO.options[ENDERECO_COMBO_DESTINATARIO.options.selectedIndex].municipio_id;
					DESTINO_MUNICIPIO_ID.value    = ENDERECO_COMBO_DESTINATARIO.options[ENDERECO_COMBO_DESTINATARIO.options.selectedIndex].municipio_id;
					DESTINATARIO_INSCRICAO_ESTADUAL.value = ENDERECO_COMBO_DESTINATARIO.options[ENDERECO_COMBO_DESTINATARIO.options.selectedIndex].inscricao_estadual;
				}
			}else{
				if(ENDERECO_COMBO_REDESPACHO.options[ENDERECO_COMBO_REDESPACHO.options.selectedIndex].municipio_uf){
					DESTINO_MUNICIPIO.value    	  = ENDERECO_COMBO_REDESPACHO.options[ENDERECO_COMBO_REDESPACHO.options.selectedIndex].municipio_uf;
					DESTINO_MUNICIPIO_COMBO.value = ENDERECO_COMBO_REDESPACHO.options[ENDERECO_COMBO_REDESPACHO.options.selectedIndex].municipio_id;
					DESTINO_MUNICIPIO_ID.value    = ENDERECO_COMBO_REDESPACHO.options[ENDERECO_COMBO_REDESPACHO.options.selectedIndex].municipio_id;
					REDESPACHO_INSCRICAO_ESTADUAL.value = ENDERECO_COMBO_REDESPACHO.options[ENDERECO_COMBO_REDESPACHO.options.selectedIndex].inscricao_estadual;
				}
			}
			
		}
	}
	
	function f_muda_endereco_ORIGEM(){
		with(document.forms[0]) {
			if(ENDERECO_COMBO_CONSIGNATARIO.options[ENDERECO_COMBO_CONSIGNATARIO.options.selectedIndex].municipio_id == ''){
				if(ENDERECO_COMBO_REMETENTE.options[ENDERECO_COMBO_REMETENTE.options.selectedIndex].municipio_uf != 'undefined'){
					ORIGEM_MUNICIPIO.value    	  	= ENDERECO_COMBO_REMETENTE.options[ENDERECO_COMBO_REMETENTE.options.selectedIndex].municipio_uf;
					ORIGEM_MUNICIPIO_COMBO.value 	= ENDERECO_COMBO_REMETENTE.options[ENDERECO_COMBO_REMETENTE.options.selectedIndex].municipio_id;
					ORIGEM_MUNICIPIO_ID.value    	= ENDERECO_COMBO_REMETENTE.options[ENDERECO_COMBO_REMETENTE.options.selectedIndex].municipio_id;
					REMETENTE_INSCRICAO_ESTADUAL.value = ENDERECO_COMBO_REMETENTE.options[ENDERECO_COMBO_REMETENTE.options.selectedIndex].inscricao_estadual;
				}
			}else{
				if(ENDERECO_COMBO_CONSIGNATARIO.options[ENDERECO_COMBO_CONSIGNATARIO.options.selectedIndex].municipio_uf != 'undefined'){
					ORIGEM_MUNICIPIO.value    	  	= ENDERECO_COMBO_CONSIGNATARIO.options[ENDERECO_COMBO_CONSIGNATARIO.options.selectedIndex].municipio_uf;
					ORIGEM_MUNICIPIO_COMBO.value 	= ENDERECO_COMBO_CONSIGNATARIO.options[ENDERECO_COMBO_CONSIGNATARIO.options.selectedIndex].municipio_id;
					ORIGEM_MUNICIPIO_ID.value    	= ENDERECO_COMBO_CONSIGNATARIO.options[ENDERECO_COMBO_CONSIGNATARIO.options.selectedIndex].municipio_id;
					CONSIGNATARIO_INSCRICAO_ESTADUAL.value = ENDERECO_COMBO_CONSIGNATARIO.options[ENDERECO_COMBO_CONSIGNATARIO.options.selectedIndex].inscricao_estadual;
				}
			}
			
		}
	}
	
	function f_verifica_motorista_cpg_aberto() {
		with(document.forms[0]) {
			<cfif v_alerta_cpg_aberto eq 'Sim'>
			   if (COMPOSICAO.value) {
				   var placa_controle = COMPOSICAO.value.split(',');
				   PLACA_CONTROLE.value = placa_controle[0];
			   }
			   
			   
			   if(COD_MOTORISTA.value == '' && PLACA_CONTROLE.value == '') {
			      return;
			   }
			   f_query_wddx('/modulos/pcl/_componentes/consulta/cfc_solicitacao.cfc?method=get_cpg_aberto'
							,'COD_MOTORISTA='+COD_MOTORISTA.value + '&PLACA_CONTROLE='+PLACA_CONTROLE.value
							,function (obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									with(document.forms[0]) {
										POSSUI_CPG_ABERTO.value = obj.struct.possui_cpg_aberto[0];
										
										if(POSSUI_CPG_ABERTO.value == 1 ){
										   document.getElementById('tr_cpg_aberto').style.display = '';
										   f_buscar_contrato_cpg_aberto();
										}else{
										   document.getElementById('tr_cpg_aberto').style.display = 'none';
										}
										
									}
								}
							})
			<cfelse>
			   return;
			</cfif>
		}
	}
	
	function f_buscar_contrato_cpg_aberto() {
		with(document.forms[0]) {
			if(COD_MOTORISTA.value || PLACA_CONTROLE.value) {
				f_query_ajax('/modulos/pcl/solicitacao/consultas.cfm' +
							'?consulta=5&COD_MOTORISTA=' + COD_MOTORISTA.value+ '&placa_controle=' + PLACA_CONTROLE.value
							,function(obj) {
								document.getElementById('td_cpg_aberto').innerHTML = obj;
							});
			}
		}
	}
	
	function f_verifica_limite_motorista(){
		with(document.forms[0]){
			if(COD_MOTORISTA.value != ''){
			f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_operacao.cfc</cf_url>?method=verifica_limite_motorista'
						,'cod_motorista=' + COD_MOTORISTA.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.limite_carga_valor.length > 0) {
									if(Number(obj.struct.limite_carga_valor[0]) > 0){
								   	  document.getElementById('MOTORISTA_LBL_AVISO_LIMITE').style.display = '';
									  document.getElementById('MOTORISTA_LBL_AVISO_LIMITE').innerHTML = 'Valor limite de carga configurado para esse motorista de: R$ '+obj.struct.limite_carga_valor[0];
								    } else{
										document.getElementById('MOTORISTA_LBL_AVISO_LIMITE').style.display = 'none';
										document.getElementById('MOTORISTA_LBL_AVISO_LIMITE').innerHTML = '';
									}
								} else{
									document.getElementById('MOTORISTA_LBL_AVISO_LIMITE').style.display = 'none';
									document.getElementById('MOTORISTA_LBL_AVISO_LIMITE').innerHTML = '';
								}
							}
						});
		}
	}
	}
	
	
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KMM :..</title>
<link href="<cf_url>/_estilos/abas.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/status.css</cf_url>" rel="stylesheet" type="text/css" />
<script src="/_scripts/dragdrop/drag.js"></script>
<script src="/_scripts/dragdrop/tree.js"></script>
</head>
<body class="background" style="height:100%; overflow:auto">
<form id="form_transportes" name="form_transportes" method="post" action="" onSubmit="return f_confirmar()" enctype="multipart/form-data">
  <input name="OPERACAO" type="hidden" value="" sempre_ativo="1">
  <input name="CFOP_OBRIGATORIO" type="hidden" id="CFOP_OBRIGATORIO" />
  <input name="OPERACAO_OLD" type="hidden" value="" sempre_ativo="1">
  <input name="CONSULTA" type="hidden" value="" sempre_ativo="1">
  <input name="EDITAR" type="hidden" value="" sempre_ativo="1">
  <input name="SOLICITACAO_CARGA_ID" type="hidden" value="" sempre_ativo="1">
  <input name="SITUACAO_ID" type="hidden" value="" sempre_ativo="1">
  <input name="COD_ORGANOGRAMA" type="hidden" value="<cfoutput>#session.cod_organograma#</cfoutput>" sempre_ativo="1" fixo="1" obrigatorio="1" display="LOTAO DO USURIO">
  <input name="COD_PROPRIETARIO" type="hidden" value="" sempre_ativo="1" fixo="1" obrigatorio="0" >
  <input name="COD_MOTORISTA" type="hidden" value="" sempre_ativo="1" fixo="1" obrigatorio="0" >
  <input name="MODALIDADE_VEICULO" type="hidden" value="" sempre_ativo="1" fixo="1" obrigatorio="0" >
  <input name="TIPO_PAGAMENTO_ID" id="TIPO_PAGAMENTO_ID" type="hidden" value="" sempre_ativo="1">
  <input name="POSSUI_REPOM" id="POSSUI_REPOM" type="hidden" value="" sempre_ativo="1">
  <input name="SOLICITACAO_CARGA_ID_VINCULO" id="SOLICITACAO_CARGA_ID_VINCULO" type="hidden" value="" sempre_ativo="1">
  <input name="CARTAO_NUMERO_HISTORICO" id="CARTAO_NUMERO_HISTORICO" type="hidden" value="" sempre_ativo="1" />
  <input name="TIPO_DOCTO_FRETE" id="TIPO_DOCTO_FRETE" type="hidden" sempre_ativo="1" />
  <input name="INTC_CONHECIMENTO_ID" type="hidden" id="INTC_CONHECIMENTO_ID" fixo="1" sempre_ativo="1"/>
  <input name="COD_TRANSPORTADOR_SUGERIDO" type="hidden" id="COD_TRANSPORTADOR_SUGERIDO" fixo="1" sempre_ativo="1"/>
  <input name="CONTAINER_VAZIO" type="hidden" id="CONTAINER_VAZIO" fixo="1" sempre_ativo="1"/>
  <input name="NUM_ROMANEIO" type="hidden" id="NUM_ROMANEIO" fixo="1" sempre_ativo="1"/>

  <input name="FRACIONADO" type="hidden" id="FRACIONADO" value="0"/>
  <input name="CONTROLA_CONTAINER" type="hidden" id="CONTROLA_CONTAINER" value="0"/>
  <input name="CONTROLA_CONTAINER_CG_DIRETA" type="hidden" id="CONTROLA_CONTAINER_CG_DIRETA" value="0"/>
  <input name="TERCEIRIZADO" type="hidden" id="TERCEIRIZADO" value="<cfoutput>#vars.TERCEIRIZADO#</cfoutput>" sempre_ativo="1"/>
  <input name="CARGA_CONSOLIDADA_ID" type="hidden" id="CARGA_CONSOLIDADA_ID" value="0" sempre_ativo="1"/>  
  <input name="POSSUI_MOVTO_CONTAINER" type="hidden" id="POSSUI_MOVTO_CONTAINER" value="0" sempre_ativo="1"/>
  <input name="LOTE_VINCULA_SOLICITACAO" type="hidden" id="LOTE_VINCULA_SOLICITACAO" value="0" sempre_ativo="1"/>
  <input name="POSSUI_CPG_ABERTO" ID="POSSUI_CPG_ABERTO" type="hidden" value="0" sempre_ativo="1" />
  <input name="PLACA_CONTROLE" ID="PLACA_CONTROLE" type="hidden" value="" sempre_ativo="1" />
  <input name="CUMMINS" ID="CUMMINS" type="hidden" value="<cfoutput>#vars.CUMMINS#</cfoutput>" sempre_ativo="1" fixo="1"/>


  <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" >
    <tr valign="top">
      <td width="1%"<cfif "#vars.TERCEIRIZADO#" eq 1 > style="display:none" </cfif>><table width="250" height="100%" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td height="1"><button type="button" class="botao-16x16" onClick="catTree.openAll()"><img src="/_imagens/botoes/16x16/expandir_projeto_escopo.gif" alt="Expandir Tudo" title="Expandir Tudo" width="16" height="16" align="absmiddle" /></button>
              <button type="button" class="botao-16x16" onClick="catTree.closeAll()"><img src="/_imagens/botoes/16x16/contrair_projeto_escopo.gif" alt="Contrair Tudo" title="Contrair Tudo" width="16" height="16" align="absmiddle" /></button></td>
          </tr>
          <tr>
            <td><div id="arvore" class="lista">
                <link rel="StyleSheet" href="/_scripts/dragdrop/tree.css" type="text/css" />
                <script type="text/javascript">
						<!--
						var catTree = new Tree('servTree', {
							imgPath:'/_scripts/dragdrop/tree/',
							defaultNodeConfig: {
								onclick: function(obj) {
									with(document.forms[0]) {
										OPERACAO_ID.value = obj.data['operacao_id'];
										f_muda_operacao();
									}
								}
							}
						});
						node = catTree.addNode(0,-1,"Operaes");
						node.data["operacao_id"] = '';
						node.data["descricao"] = '';
						node.data["carregado"] = true;
						node.setHaveChildren(true);
						node.select(true);

						<cfoutput query="qrOperacao">
						node = catTree.addNode(#qrOperacao.operacao_id#,#qrOperacao.operacao_id_pai_nvl#,"#Replace(qrOperacao.descricao, '"', '', 'ALL')#");
						node.data["operacao_id"] = "#qrOperacao.operacao_id#";
						node.data["descricao"] = "#Replace(qrOperacao.descricao, '"', '', 'ALL')#";
						node.data["carregado"] = true;
						<cfif qrOperacao.possui_filhos>
  						   node.setHaveChildren(true);
						</cfif>
						</cfoutput>

						catTree.moveObj.enabled = false;
						catTree.print();
						//-->
            	  	</script>
              </div></td>
          </tr>
        </table></td>
      <td width="1%" class="separador">&nbsp;</td>
      <td width="98%" valign="top"><div class="lista">
          <table width="100%" border="0" cellspacing="1" cellpadding="3">
            <tr class="texto">
              <td width="1%">Opera&ccedil;&atilde;o:</td>
              <td width="99%"><input type="text" name="OPERACAO_ID" onChange="f_muda_operacao()" id="OPERACAO_ID" display="OPERAO" obrigatorio="1" style="width: 60px"  sempre_ativo="1" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif>>
                <input type="text" name="OPERACAO_DESCRICAO" id="OPERACAO_DESCRICAO" readonly style="width: 496px">&nbsp;<span id="operacao_pendente" style="color:#F00"></span></td>
            </tr>
            <tr class="texto">
              <td>Natureza:</td>
              <td><input type="text" name="NUM_NATUREZA" id="NUM_NATUREZA" maxlength="10" obrigatorio="1" tipo="numerico" display="NATUREZA" onChange="f_busca_natureza(1)" onKeyPress="return f_formata(this, '0000000000')" style="width:60px;" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif>/>
                <span id="sp_natureza_restrita" style="display: none;">
                <select name="NATUREZA_COMBO" id="NATUREZA_COMBO" display="NATUREZA" onChange="f_busca_natureza(2)" <cfif "#vars.TERCEIRIZADO#" eq 1 > terceirizado="1" </cfif>>
                </select>
                </span> <span id="sp_natureza_aberta">
                <input type="text" name="NATUREZA" id="NATUREZA" readonly display="NATUREZA" style="width: 296px;" />
                &nbsp;
                <button type="button" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" </cfif> disabled class="botao-16x16" onClick="NewWindow('../_localizar/localizar_natureza.cfm?num_natureza=NUM_NATUREZA&natureza=NATUREZA', '_blank', 640, 480, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Natureza" title="Buscar Natureza" width="16" height="16" align="absmiddle" /></button>
                </span></td>
            </tr>
            <cfset pessoa_cliente_cod = 'COD_REMETENTE'>
            <cfset pessoa_cliente_pref = 'REMETENTE'>
            <cfset pessoa_cliente_descricao = 'Remetente'>
            <cfset pessoa_cliente_descricao2 = 'remetentes'>
            <cfset pessoa_cliente_obrigatorio = '1'>
            <cfset funcao = 'f_after_localizar_remetente'>
            <cfinclude template="/modulos/pcl/solicitacao/forms/pessoa_cliente.cfm">
            <cfset pessoa_cliente_cod = 'COD_DESTINATARIO'>
            <cfset pessoa_cliente_pref = 'DESTINATARIO'>
            <cfset pessoa_cliente_descricao = 'Destinatrio'>
            <cfset pessoa_cliente_descricao2 = 'destinatrios'>
            <cfset pessoa_cliente_obrigatorio = '0'>
            <cfset funcao = 'f_after_localizar_destinatario'>
            <cfinclude template="/modulos/pcl/solicitacao/forms/pessoa_cliente.cfm">
            <tr class="texto" height="1">
              <td>Origem:</td>
              <td><input name="ORIGEM_MUNICIPIO_ID" id="ORIGEM_MUNICIPIO_ID" type="hidden" value="" sempre_ativo="1" obrigatorio="1" display="ORIGEM" onChange="f_get_tempo_rota()" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif>>
                <input name="ORIGEM_MUNICIPIO_ORIGEM" id="ORIGEM_MUNICIPIO_ORIGEM" type="text" value="" sempre_ativo="1" style="display:none; width:250px;" readonly>
                <span id="sp_origem_restrita" style="display: none">
                <select name="ORIGEM_MUNICIPIO_COMBO" id="ORIGEM_MUNICIPIO_COMBO" onChange="document.forms[0].ORIGEM_MUNICIPIO_ID.value = this.value; f_get_tempo_rota();"<cfif "#vars.TERCEIRIZADO#" eq 1 > terceirizado="1" </cfif>>
                </select>
                </span><span id="sp_origem_aberta">
                <input type="text" name="ORIGEM_MUNICIPIO" id="ORIGEM_MUNICIPIO" style="width: 350px" readonly tabindex="-1" onChange="f_get_tempo_rota()">
                <button type="button" class="botao-16x16" onClick="NewWindow('<cf_url>/_consultas/localizar_cidade.cfm</cf_url>?municipio_id=ORIGEM_MUNICIPIO_ID&municipio_uf=ORIGEM_MUNICIPIO&funcao=f_get_tempo_rota();','_blank',800,600,'yes')"<cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" </cfif>><img src="/_imagens/botoes/16x16/buscar.gif" align="absmiddle" height="16" width="16" /></button>
                </span></td>
            </tr>
            <tr class="texto" height="1">
              <td>Destino:</td>
              <td><input name="DESTINO_MUNICIPIO_ID" id="DESTINO_MUNICIPIO_ID" type="hidden" value="" sempre_ativo="1" obrigatorio="0" display="DESTINO" onChange="f_get_tempo_rota()" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> >
                <input name="DESTINO_MUNICIPIO_DESTINO" id="DESTINO_MUNICIPIO_DESTINO" type="text" value="" sempre_ativo="1" style="display:none; width:250px;" readonly>
                <span id="sp_destino_restrita" style="display: none">
                <select name="DESTINO_MUNICIPIO_COMBO" id="DESTINO_MUNICIPIO_COMBO" onChange="document.forms[0].DESTINO_MUNICIPIO_ID.value = this.value; f_get_tempo_rota();">
                </select>
                </span><span id="sp_destino_aberta">
                <input type="text" name="DESTINO_MUNICIPIO" id="DESTINO_MUNICIPIO" style="width: 350px" readonly tabindex="-1" onChange="f_get_tempo_rota()">
                <button type="button"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" </cfif> class="botao-16x16" onClick="NewWindow('<cf_url>/_consultas/localizar_cidade.cfm</cf_url>?municipio_id=DESTINO_MUNICIPIO_ID&municipio_uf=DESTINO_MUNICIPIO&funcao=f_get_tempo_rota();','_blank',800,600,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" align="absmiddle" height="16" width="16" /></button>
                </span></td>
            </tr>
			
			<tr class="texto" height="1">
              <td>Lote:</td>
              <td>
			    <input name="LOTE_ID" id="LOTE_ID" type="hidden" value="" sempre_ativo="1" obrigatorio="0" display="LOTE">
                <input name="LOTE_INFO_LOTE" id="LOTE_INFO_LOTE" type="text" value="" sempre_ativo="1" style="display:none; width:250px;" readonly>
				<input name="LOTE_PESO_RESTANTE" id="LOTE_PESO_RESTANTE" type="hidden" value="0" sempre_ativo="1" obrigatorio="0" display="LOTE_PESO_RESTANTE">
                <span id="lote_restrita">
			      <select name="LOTE_COMBO" id="LOTE_COMBO" onchange="document.forms[0].LOTE_ID.value = this.value; f_muda_peso();"></select>
                </span>
			  </td>
            </tr>
			
            <tr class="texto" height="1">
              <td>Modalidade:</td>
              <td><select name="MODALIDADE" id="MODALIDADE" obrigatorio="0" display="MODALIDADE" onChange="f_muda_modalidade();" <cfif "#vars.TERCEIRIZADO#" eq 1 > terceirizado="1" </cfif> >
                  <option value="">-- No Definida --</option>
                  <cfoutput query="qrModalidade">
                    <option value="#qrModalidade.rv_low_value#">#qrModalidade.rv_abbreviation#</option>
                  </cfoutput>
                </select>
                &nbsp;&nbsp;&nbsp;
                Liberada p/ Agendamento:
                <select name="LIBERADA_AGENDAMENTO" id="LIBERADA_AGENDAMENTO" obrigatorio="1" display="LIBERADA PARA AGENDAMENTO" onChange="f_muda_liberada_agendamento()" style="width: 50px;" <cfif "#vars.TERCEIRIZADO#" eq 1 > terceirizado="1" </cfif> >
                  <option value="">---</option>
                  <option value="0">N&atilde;o</option>
                  <option value="1">Sim</option>
                </select>
                <span id="sp_situacao" class="obrigatorio" style="margin-left: 20px;"></span></td>
            </tr>
            <tr class="texto" height="1">
              <td>Prioridade:</td>
              <td><select name="PRIORIDADE" id="PRIORIDADE" display='PRIORIDADE CARGA' obrigatorio="1" fixo="1" <cfif "#vars.TERCEIRIZADO#" eq 1 > terceirizado="1" </cfif> >
                  <cfoutput query="qrPrioridade">
                    <option value="#qrPrioridade.rv_low_value#">#qrPrioridade.rv_abbreviation#</option>
                  </cfoutput>
                </select></td>
            </tr>
            <tr id="tr_multipla_solicitacao" class="texto" height="1">
              <td>&nbsp;</td>
              <td><nobr>
                <input type="checkbox" name="MULTIPLA_SOLICITACAO" id="MULTIPLA_SOLICITACAO" class="check" value="1"  <cfif "#vars.TERCEIRIZADO#" eq 1 > terceirizado="1" </cfif> />
                &nbsp;
                <label for="MULTIPLA_SOLICITACAO">Selecione para Gerar M&uacute;ltiplas Solicita&ccedil;&otilde;es de Cargas</label>
                </nobr></td>
            </tr>
            <tr id="tr_gerar_romaneio" class="texto" height="1">
              <td>&nbsp;</td>
              <td><nobr>
                <input type="checkbox" name="GERA_ROMANEIO" id="GERA_ROMANEIO" class="check" value="1"  <cfif "#vars.TERCEIRIZADO#" eq 1 > terceirizado="1" </cfif> />
                &nbsp;
                <label for="GERA_ROMANEIO">Selecione para Gerar Romaneio (Modalidades Frota e Agregado)</label>
                </nobr></td>
            </tr>
            <tr class="texto" height="1">
              <td nowrap>Valor Mercadorias:</td>
              <td><input type="text" name="VALOR_TOTAL_NF" id="VALOR_TOTAL_NF" obrigatorio="1" readonly display="VALOR (NOTAS FISCAIS)" style="width: 85px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> />
                Valor Sugerido:
                <input type="text" name="VALOR_TOTAL_SUGERIDO" id="VALOR_TOTAL_SUGERIDO" maxlength="15" obrigatorio="<cfoutput>#v_valor_sug_obrigatorio#</cfoutput>" tipo="numerico" display="VALOR SUGERIDO" onChange="this.value = toCurrency(this.value);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> />
            </tr>
            <tr class="texto" height="1">
            	<td nowrap valign="top">Pedido/Shipment:</td>
                <td><textarea name="PEDIDO_SHIPMENT" id="PEDIDO_SHIPMENT" display="PEDIDO SHIPMENT" onKeyPress="if (this.value.length >= 160) return false;" onBlur="if (this.value.length > 160) this.value = this.value.substr(0, 160);" obrigatorio="<cfoutput>#qrOperacao.PEDIDO_SHIPMENT#</cfoutput>" cols="60" row="4" style="width: 500px; resize: none; height:45px;" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> ></textarea></td>
            </tr>
            <tr class="texto" height="1">
            	<td nowrap>Container:</td>
                <td>
                    <input type="hidden" name="CONTAINER_ID" id="CONTAINER_ID">
                    <input type="hidden" name="CONTAINER_TIPO_ID" id="CONTAINER_TIPO_ID">
                    <input type="text" name="CONTAINER_IDENTIFICADOR" onKeyPress="return f_formata(this, event, 'XXXX0000000')" id="CONTAINER_IDENTIFICADOR" value="" maxlength="11" onChange="f_busca_container(this.value)" display="CONTAINER"  <cfif "#vars.TERCEIRIZADO#" eq 1 and qrAcaoComposicaoContainer.recordCount eq 0 > readonly </cfif> />
                    &nbsp;
               	    <button type="button" name="BTN_BUSCA_CONTAINER" id="BTN_BUSCA_CONTAINER" <cfif "#vars.TERCEIRIZADO#" eq 1 and qrAcaoComposicaoContainer.recordCount eq 0 > ativo="0" </cfif>
                    class="botao-16x16" onClick="NewWindow('/_consultas/localizar_container.cfm', '_blank', 640, 480, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Container" title="Buscar Container" width="16" height="16" align="absmiddle" /></button>
                	&nbsp;
                    <label id="LBL_MSG_CONTAINER" style="display:none">O container no foi encontrado no sistema e ser cadastrado. Por favor, informe o tipo do container.</label>
                </td>
            </tr>
            <tr class="texto" height="1">
            	<td nowrap>Tipo Container:</td>
                <td>
	                <input type="text" name="CONTAINER_TIPO_ISO_CODE" display="TIPO DO CONTAINER" onChange="f_busca_tipo_container(this.value)" obrigatorio="0" id="CONTAINER_TIPO_ISO_CODE" maxlength="11" <cfif "#vars.TERCEIRIZADO#" eq 1 and qrAcaoComposicaoContainer.recordCount eq 0 > readonly </cfif>>
                    <input type="text" name="CONTAINER_TIPO" id="CONTAINER_TIPO" readonly>
                    &nbsp;
               	    <button type="button" name="BTN_BUSCA_CONTAINER_TIPO" id="BTN_BUSCA_CONTAINER_TIPO" style="display:none" class="botao-16x16" <cfif "#vars.TERCEIRIZADO#" eq 1 and qrAcaoComposicaoContainer.recordCount eq 0 > ativo="0" </cfif>
                    onClick="NewWindow('/_consultas/localizar_tipo_container.cfm', '_blank', 640, 480, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Tipo de Container" title="Buscar Tipo de Container" width="16" height="16" align="absmiddle" /></button>
              </td>
            </tr>
            <tr class="texto" height="1" id="tr_internacional" style="display:none">
              <td colspan="2"><fieldset>
                  <legend>Docto Internacional</legend>
                  <table width="100%" border="0" cellspacing="1" cellpadding="2" class="texto">
                    <tr>
                      <td width="1%" nowrap="nowrap">CRT:</td>
                      <td width="99%"><input name="NUM_CRT_COMPLETO" type="text" id="NUM_CRT_COMPLETO" style="width:110px" display="CRT" onKeyPress="return f_formata(this, 'XX.000.000000')" onChange="f_busca_crt()"  <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> />
                        &nbsp;<span id="dados_crt" class="texto_negrito">&nbsp;</span></td>
                    </tr>
                    <tr>
                      <td colspan="2" nowrap="nowrap"><span id="span_divisoes"></span></td>
                    </tr>
                  </table>
                </fieldset></td>
            </tr>
            <tr class="texto" height="1">
              <td colspan="2"><fieldset id="fld_composicao">
                  <legend>Composio Sugerida</legend>
                  <table width="100%" border="0" cellspacing="1" cellpadding="3">
                    <tr class="texto">
					  <input type="hidden" name="COMPOSICAO_CAPACIDADE" id="COMPOSICAO_CAPACIDADE" value="0" readonly style="width:395px">
                      <td width="1%">Ve&iacute;culos:</td>
                      <td width="99%"><input type="text" name="COMPOSICAO" id="COMPOSICAO" readonly onChange="f_busca_composicao()" onKeyPress="return f_formata(this,event,'AAAAAAAAAAAAAAAAAA')" obrigatorio="0" display="VEICULOS"  <cfif "#vars.TERCEIRIZADO#" eq 1 and qrAcaoComposicaoContainer.recordCount eq 0 > readonly </cfif> >
                        <span id="dv_composicao"></span>
                        <button type="button" id="btn_add_composicao" class="botao-16x16" onClick="f_add_composicao()" <cfif "#vars.TERCEIRIZADO#" eq 1 and qrAcaoComposicaoContainer.recordCount eq 0> ativo="0" </cfif> ><img src="/_imagens/botoes/16x16/mais.gif" align="absmiddle" height="16" width="16" id="add_composicao" /></button>&nbsp;<span id="composicao_capacidade_span" class="texto">Cap.: 0 Ton.</span>&nbsp;<button type="button" id="btn_valida_antt"  <cfif "#vars.TERCEIRIZADO#" eq 1 and qrAcaoComposicaoContainer.recordCount eq 0> ativo="0" </cfif> class="botao" onClick="f_valida_antt()" <cfif qrValidacaoANTT.valor eq 'NAO VALIDA'>disabled</cfif> ><img src="/_imagens/botoes/16x16/antt.gif" align="absmiddle" height="16" width="16" id="valida_antt" />&nbsp;Valida ANTT</button>&nbsp;<span id="sp_antt" class="obrigatorio"></span>
					  </td>
                    </tr>
                    <tr class="texto">
                      <td>Motorista:</td>
                      <td><input type="text" name="CPF_MOTORISTA" id="CPF_MOTORISTA" readonly onKeyPress="return f_formata(this,event,'00000000000000')" tipo="numerico" >
                        &nbsp;
                        <button type="button" id="btn_localizar_motorista" class="botao-16x16" onClick="f_localizar_motorista();" <cfif "#vars.TERCEIRIZADO#" eq 1 and qrAcaoComposicaoContainer.recordCount eq 0> ativo="0" </cfif> ><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Motorista" align="absmiddle" height="16" width="16" /></button>
                        <input type="text" name="NOME_MOTORISTA" id="NOME_MOTORISTA" readonly style="width:395px">
						<label id="MOTORISTA_LBL_AVISO_LIMITE" class="obrigatorio" name="MOTORISTA_LBL_AVISO_LIMITE" style="display:none"></label>
						</td>
                    </tr>
                    <tr style="display: none;" id="tr_validacao_antt">
                      <td nowrap class="texto" colspan="2"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                          <tr class="titulo_1">
                            <td nowrap align="center" colspan="3">Valida&ccedil;&atilde;o ANTT</td>
                          </tr>
                          <tr class="titulo_2">
                            <td nowrap align="center">Cadastro</td>
                            <td nowrap align="center">Situa&ccedil;&atilde;o</td>
                            <td nowrap align="center">Mensagem</td>
                          </tr>
                          <!---Proprietrio--->
                          <tr class="linha_1">
                            <td nowrap align="left">Propriet&aacute;rio</td>
                            <td id="td_antt_prop_validado" nowrap align="center" class="linha_amarela" style="width: 110px;"><nobr>N&atilde;o Validado</nobr></td>
                            <td id="td_antt_prop_msg" align="left">&nbsp;</td>
                          </tr>
                          <!---Cavalo--->
                          <tr class="linha_1">
                            <td nowrap align="left">Cavalo</td>
                            <td id="td_antt_cavalo_validado" nowrap align="center" class="linha_amarela" style="width: 110px;"><nobr>N&atilde;o Validado</nobr></td>
                            <td id="td_antt_cavalo_msg" align="left">&nbsp;</td>
                          </tr>
                          <!---Carreta--->
                          <tr class="linha_1">
                            <td nowrap align="left">Carreta</td>
                            <td id="td_antt_carreta_validado" nowrap align="center" class="linha_amarela" style="width: 110px;"><nobr>N&atilde;o Validado</nobr></td>
                            <td id="td_antt_carreta_msg" align="left">&nbsp;</td>
                          </tr>
						  
						  <!---Carreta2--->
                          <tr class="linha_1" id="linha_carreta2" style="display: none;">
                            <td nowrap align="left">2&ordf; Carreta</td>
                            <td id="td_antt_carreta2_validado" nowrap align="center" class="linha_amarela" style="width: 110px;"><nobr>N&atilde;o Validado</nobr></td>
                            <td id="td_antt_carreta2_msg" align="left">&nbsp;</td>
                          </tr>
						  
						  <!---Carreta3--->
                          <tr class="linha_1" id="linha_carreta3" style="display: none;">
                            <td nowrap align="left">3&ordf; Carreta</td>
                            <td id="td_antt_carreta3_validado" nowrap align="center" class="linha_amarela" style="width: 110px;"><nobr>N&atilde;o Validado</nobr></td>
                            <td id="td_antt_carreta3_msg" align="left">&nbsp;</td>
                          </tr>
						  
                          <tr class="linha_2">
                            <td colspan="3" nowrap align="center">Consulte os dados no site da ANTT. <a href="http://rn3.antt.gov.br/system/Modulos/Transportador/tra00006.aspx" target="_blank">Clique aqui</a></td>
                          </tr>
                        </table></td>
                    </tr>
                    <tr id="tr_info_cartao_historico" style="display: none;">
                      <td nowrap class="texto"></td>
                      <td nowrap class="texto"><span id="sp_info_cartao_historico" class="obrigatorio"></span>&nbsp;
                        <button type="button" class="botao-16x16" onClick="f_visualizar_cartao_historico()" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" </cfif> ><img src="/_imagens/botoes/16x16/repom.gif" alt="Visualizar Hist&oacute;rico do Cart&atilde;o" title="Visualizar Hist&oacute;rico do Cart&atilde;o" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                  </table>
                </fieldset></td>
            </tr>
			
			<cfif v_alerta_cpg_aberto eq 'Sim'>
			<tr id="tr_cpg_aberto" style="display:none">
				<td colspan="2">
					<fieldset><legend>Informa&ccedil;&otilde;es referentes a t&iacute;tulos no Financeiro em aberto</legend>
					<table width="100%" border="0" cellspacing="0" cellpadding="3">
						<tr>
						   <td id="td_cpg_aberto">
						   </td>
						</tr>
						<tr>
						   <td class="texto">
							  <input type="checkbox" name="CIENTE_CPG_ABERTO" id="CIENTE_CPG_ABERTO" class="check" value="1" />
							  <label for="CIENTE_CPG_ABERTO">&nbsp;Declaro que fiz a verifica&ccedil;&atilde;o junto ao motorista sobre os contratos em aberto e que o mesmo possui a comprova&ccedil;&atilde;o de entrega destes</label>&nbsp;
						   </td>
						</tr>
						<tr>
							<td>
							   <textarea name="INF_ADIC_CPG_ABERTO" id="INF_ADIC_CPG_ABERTO" display="INFORMAO ADICIONAL - CPG EM ABERTO" style="width: 100%; height: 60px;"></textarea>
							</td>
						</tr>
					</table>
					</fieldset>
				</td>            
			</tr>  
			</cfif>

            <cfif qrGrisco_upper.recordcount gte 1>
                <tr class="texto" height="1" id="tr_pre_ordem">
                  <td colspan="2"><fieldset>
                      <legend>Vincular pr-ordem de carregamento</legend>
                      <table width="100%" border="0" cellspacing="1" cellpadding="2" class="texto">
                        <tr>
                          <td width="1%" nowrap="nowrap">Pr-ordem:</td>
                          <td width="99%"><input name="PRE_ORDEM_ID" type="text" id="PRE_ORDEM_ID" style="width:110px" display="PRE_ORDEM_ID" onChange="f_busca_pre_ordem()" onKeyPress="return f_formata(this,event,'000000000000')"/></td>
                        </tr>
                         <tr>
                          <td colspan="2" nowrap="nowrap"><span id="sp_dados_pre_ordem"></span></td>
                        </tr>
                      </table>
                    </fieldset></td>
                </tr>
            </cfif>


            <tr id="dados_repom" style="display:none">
              <td colspan="2"><fieldset>
                  <legend>Repom</legend>
                  <table width="100%" height="100%" border="0" cellspacing="2" cellpadding="3">
                    <tr class="texto">
                      <td nowrap width="1%">N&deg; Cart&atilde;o:</td>
                      <td width="99%"><input type="text" name="CARTAO_NUMERO" id="CARTAO_NUMERO" maxlength="20" tipo="numerico" display="NMERO DO CARTO REPOM" onChange="f_validar_cartao_historico()" onKeyPress="return f_formata(this,event,'00000000000000000000')"  style="width: 150px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> />
                        &nbsp; <span class="obrigatorio">* N&uacute;mero que consta no verso do cart&atilde;o Repom.</span></td>
                    </tr>
                    <tr class="texto" id="tr_contrato_pendente" style="display:none">
                      <td colspan="2" nowrap id="td_contrato_pendente" class="obrigatorio">&nbsp;</td>
                    </tr>
                    <tr class="texto">
                      <td nowrap>Adto. Trajeto Vazio:</td>
                      <td><input type="text" name="ADTO_TRAJETO_VAZIO" id="ADTO_TRAJETO_VAZIO"  tipo="numerico" display="ADTO. TRAJETO VAZIO" onChange="this.value = toCurrency(this.value);" onBlur="this.value = toCurrency(this.value);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> /></td>
                    </tr>
                  </table>
                </fieldset></td>
            </tr>
            <tr class="texto">
              <td colspan="2"><table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" id="tbl_abas">
                  <tr>
                    <td height="1%" width="1%"><nobr>Carregamento</nobr></td>
                    <td width="1%"><nobr>Coleta/Entrega/Cobran&ccedil;a</nobr></td>
                    <td width="1%"><nobr>Notas Fiscais</nobr></td>
                    <td width="1%"><nobr>Observa&ccedil;&otilde;es</nobr></td>
					<cfif vars.CUMMINS eq 1>
					   <td width="1%"><nobr>Dados do cliente</nobr></td>
					   <td width="95%">&nbsp;</td>
					<cfelse>
					   <td width="96%">&nbsp;</td>
					</cfif>
                    
                  </tr>
                  <tr>
                    <td <cfif vars.CUMMINS eq 1>colspan="6"<cfelse>colspan="5"</cfif> valign="top"><table width="100%" border="0" cellspacing="1" cellpadding="3">
                        <tr>
                          <td><fieldset>
                              <legend>Frete</legend>
                              <table width="100%" border="0" cellspacing="1" cellpadding="3">
                                <tr class="texto">
                                  <td width="5%">Esp&eacute;cie/Embalagem:</td>
                                  <td width="5%">
								    <select name="NUM_ESPECIE" id="NUM_ESPECIE" obrigatorio="1" display="CARREGAMENTO / ESPECIE/EMBALAGEM" onChange="f_muda_especie()" <cfif "#vars.TERCEIRIZADO#" eq 1 > terceirizado="1" </cfif> >
                                      <option value="">-- Selecione --</option>
                                      <cfoutput query="qrEspecie">
                                        <option value="#qrEspecie.num_especie#" frete_em="#qrEspecie.frete_em#">#qrEspecie.descricao#</option>
                                      </cfoutput>
                                    </select> 
								  </td>
								  <td width="5%">Frete em:</td>
								  <td>
									<select name="VALOR_EM" id="VALOR_EM" obrigatorio="1" display="CARREGAMENTO / FRETE EM" onChange="f_muda_valor_em()" <cfif "#vars.TERCEIRIZADO#" eq 1 > terceirizado="1" </cfif> >
                                      <option value="">-- Selecione --</option>
                                      <cfoutput query="qrValorEm">
                                        <option value="#qrValorEm.rv_low_value#">#qrValorEm.rv_abbreviation#</option>
                                      </cfoutput>
                                    </select>
                                    <span id="sp_m3" style="display:none"> <nobr>M<sup>3</sup>:
                                    <input type="text" name="M3" id="M3" style="width:50px" onKeyPress="return f_formata_numero_decimal(this,event)" onChange="f_calcula_peso(this)" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> >
                                    &nbsp;
                                    Peso Espec&iacute;fico:
                                    <input type="text" name="PESO_ESPECIFICO" id="PESO_ESPECIFICO" onKeyPress="return f_formata_numero_decimal(this,event)" style="width: 70px" onChange="f_calcula_peso(this)" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> >
                                    </nobr> </span><span id="sp_volumes" style="display:none"> </span></td>
                                </tr>
                                <tr class="texto">
                                  <td>Volumes:</td>
                                  <td>
                                    <input type="text" name="QTDE_VOLUME" id="QTDE_VOLUME" style="width:50px" onKeyPress="return f_formata_numero_decimal(this,event)" onChange="f_calcula_peso(this)" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> >
								  </td>
								  <td><nobr>Peso do Volume:</nobr></td>
								  <td>
                                    <input type="text" name="PESO_VOLUME" id="PESO_VOLUME" style="width:70px" onKeyPress="return f_formata_numero_decimal(this,event)" onChange="f_calcula_peso(this)" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> >
                                  </td>
                                </tr>
                                <tr class="texto">
                                  <td>Peso em:</td>
                                  <td><select name="COD_UNIDADE" id="COD_UNIDADE" obrigatorio="1" display="CARREGAMENTO / PESO EM" onChange="f_calcula_peso(this)" ativo="0" <cfif "#vars.TERCEIRIZADO#" eq 1 > terceirizado="1" </cfif>>
                                      <option value="">-- Selecione --</option>
                                      <cfoutput query="qrUnidade">
                                        <option value="#qrUnidade.cod_unidade#" equivalencia_kg="#qrUnidade.equivalencia_kg#">#qrUnidade.unidade#</option>
                                      </cfoutput>
                                    </select>
                                  </td>
								  <td>Peso:</td>
								  <td>
                                    <input type="text" name="PESO" id="PESO" style="width:70px" onKeyPress="return f_formata_numero_decimal(this,event)" tipo="numerico" obrigatorio="1" display="CARREGAMENTO / PESO TOTAL" onChange="f_calcula_peso(this)" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> ></td>
                                </tr>
                                <tr class="texto">
                                  <td><nobr>Valor Unit&aacute;rio:</nobr></td>
                                  <td><input type="text" name="VALOR_UNITARIO" id="VALOR_UNITARIO" style="width:70px" onKeyPress="return f_formata_numero_decimal(this,event)" tipo="numerico" obrigatorio="0" display="CARREGAMENTO / VALOR UNITRIO"  onChange="f_calcula_valor(this)" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> ></td>
								  <td>Valor Total:</td>
								  <td>
                                    <input type="text" name="VALOR_TOTAL" id="VALOR_TOTAL" style="width:70px" onKeyPress="return f_formata_numero_decimal(this,event)" tipo="numerico" obrigatorio="1" display="CARREGAMENTO / VALOR TOTAL" onChange="f_calcula_valor(this)" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> ></td>
                                </tr>
                              </table>
                            </fieldset></td>
                        </tr>
                        <tr>
                          <td><fieldset>
                              <legend>Agendamento</legend>
                              <table width="642" border="0" cellpadding="3" cellspacing="1">
                                <tr>
                                  <td width="25%"><fieldset>
                                      <legend>Carregamento</legend>
                                      <table width="100%" border="0" cellspacing="1" cellpadding="3">
                                        <tr class="texto">
                                          <td width="2%"><nobr>In&iacute;cio:</nobr></td>
                                          <td width="98%"><input type="text" name="DATA_CARREGAMENTO_INICIO" id="DATA_CARREGAMENTO_INICIO" style="width:110px" obrigatorio="1" display="DATA DE INICIO DE CARREGAMENTO" onKeyPress="return f_formata(this,event,'00/00/0000 00:00')" />
                                            <button id="btn_DATA_CARREGAMENTO_INICIO" type="button" class="botao-16x16" ><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
                                        </tr>
                                        <script>
                                    Calendar.setup({
                                        inputField  : "DATA_CARREGAMENTO_INICIO",      // ID of the input field
                                        ifFormat    : "%d/%m/%Y %H:%M",    // the date format
                                        button      : "btn_DATA_CARREGAMENTO_INICIO",    // ID of the button
                                        range       : [2001,2050],
                                        showsTime	: true
                                    });
                                    </script>
                                        <tr class="texto">
                                          <td><nobr>T&eacute;rmino:</nobr></td>
                                          <td><input type="text" name="DATA_CARREGAMENTO_FIM" id="DATA_CARREGAMENTO_FIM" style="width:110px" obrigatorio="1" display="DATA DE TERMINO DE CARREGAMENTO" onKeyPress="return f_formata(this,event,'00/00/0000 00:00')" />
                                            <button id="btn_DATA_CARREGAMENTO_FIM" type="button" class="botao-16x16" ><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
                                        </tr>
                                        <script>
                                    Calendar.setup({
                                        inputField  : "DATA_CARREGAMENTO_FIM",      // ID of the input field
                                        ifFormat    : "%d/%m/%Y %H:%M",    // the date format
                                        button      : "btn_DATA_CARREGAMENTO_FIM",    // ID of the button
                                        range       : [2001,2050],
                                        showsTime	: true
                                    });
                                    </script>
                                      </table>
                                    </fieldset></td>
                                  <td width="25%"><fieldset>
                                      <legend>Entrega</legend>
                                      <table width="100%" border="0" cellspacing="1" cellpadding="3">
                                        <tr class="texto">
                                          <td width="19%">In&iacute;cio:</td>
                                          <td width="81%"><input type="text" name="DATA_ENTREGA_INICIO" id="DATA_ENTREGA_INICIO" style="width:110px" obrigatorio="1" display="DATA DE INICIO DE ENTREGA" onKeyPress="return f_formata(this,event,'00/00/0000 00:00')" />
                                            <button id="btn_DATA_ENTREGA_INICIO" type="button" class="botao-16x16" ><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
                                        </tr>
                                        <script>
                                    Calendar.setup({
                                        inputField  : "DATA_ENTREGA_INICIO",      // ID of the input field
                                        ifFormat    : "%d/%m/%Y %H:%M",    // the date format
                                        button      : "btn_DATA_ENTREGA_INICIO",    // ID of the button
                                        range       : [2001,2050],
                                        showsTime	: true
                                    });
                                    </script>
                                        <tr class="texto">
                                          <td><nobr>T&eacute;rmino:</nobr></td>
                                          <td><input type="text" name="DATA_ENTREGA_FIM" id="DATA_ENTREGA_FIM" style="width:110px" obrigatorio="1" display="DATA DE TERMINO DE ENTREGA" onKeyPress="return f_formata(this,event,'00/00/0000 00:00')"/>
                                            <button id="btn_DATA_ENTREGA_FIM" type="button" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
                                        </tr>
                                        <script>
                                    Calendar.setup({
                                        inputField  : "DATA_ENTREGA_FIM",      // ID of the input field
                                        ifFormat    : "%d/%m/%Y %H:%M",    // the date format
                                        button      : "btn_DATA_ENTREGA_FIM",    // ID of the button
                                        range       : [2001,2050],
                                        showsTime	: true
                                    });
                                    </script>
                                      </table>
                                    </fieldset></td>
                                  <td width="50%" style="vertical-align:top"><fieldset>
                                      <legend>Tempo sugerido para a rota</legend>
                                      <table width="100%" border="0" cellspacing="1" cellpadding="3">
                                        <tr class="texto">
                                          <td width="15%"><nobr>Tempo:</nobr></td>
                                          <td width="85%"><input type="text" name="TEMPO_ROTA" id="TEMPO_ROTA" style="width:100%" display="TEMPO SUGERIDO PARA A ROTA" readonly></td>
                                        </tr>
                                      </table>
                                    </fieldset></td>
                                </tr>
                              </table>
                            </fieldset></td>
                        </tr>
                      </table></td>
                  </tr>
                  <tr>
                    <td <cfif vars.CUMMINS eq 1>colspan="6"<cfelse>colspan="5"</cfif> valign="top"><table width="100%" border="0" cellspacing="1" cellpadding="3">
                        <cfset pessoa_cliente_cod = 'COD_CONSIGNATARIO'>
                        <cfset pessoa_cliente_pref = 'CONSIGNATARIO'>
                        <cfset pessoa_cliente_descricao = 'Local de Coleta'>
                        <cfset campos = ',ORIGEM_MUNICIPIO_ID,ORIGEM_MUNICIPIO_ORIGEM'>
                        <cfset pessoa_cliente_descricao2 = 'locais de coleta'>
                        <cfset pessoa_cliente_obrigatorio = '0'>
                        <cfset funcao = 'f_after_localizar_consignatario'>
                        <cfinclude template="/modulos/pcl/solicitacao/forms/pessoa_cliente.cfm">
						
                        <cfset pessoa_cliente_cod = 'COD_REDESPACHO'>
                        <cfset pessoa_cliente_pref = 'REDESPACHO'>
                        <cfset campos = ',DESTINO_MUNICIPIO_ID,DESTINO_MUNICIPIO_DESTINO'>
                        <cfset pessoa_cliente_descricao = 'Local de Entrega'>
                        <cfset pessoa_cliente_descricao2 = 'locais de entrega'>
                        <cfset pessoa_cliente_obrigatorio = '0'>
                        <cfset funcao = 'f_after_localizar_redespacho'>
                        <cfinclude template="/modulos/pcl/solicitacao/forms/pessoa_cliente.cfm">
						
                        <cfset pessoa_cliente_cod = 'COD_COBRANCA'>
                        <cfset pessoa_cliente_pref = 'COBRANCA'>
                        <cfset pessoa_cliente_descricao = 'Cliente Cobrana'>
                        <cfset pessoa_cliente_descricao2 = 'clientes de cobrana'>
                        <cfset pessoa_cliente_obrigatorio = '0'>
                        <cfinclude template="/modulos/pcl/solicitacao/forms/pessoa_cliente.cfm">
                      </table></td>
                  </tr>
                  <tr>
                    <td <cfif vars.CUMMINS eq 1>colspan="6"<cfelse>colspan="5"</cfif> valign="top"><cfinclude template="/modulos/pcl/solicitacao/forms/notas_fiscais.cfm"></td>
                  </tr>
                  <tr>
                    <td <cfif vars.CUMMINS eq 1>colspan="6"<cfelse>colspan="5"</cfif> valign="top"><textarea name="OBSERVACAO" id="OBSERVACAO" style="width:100%; height:150px" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> ></textarea></td>
                  </tr>
				  <cfif vars.CUMMINS eq 1>
				  <tr>
                    <td colspan="6" valign="top"><cfinclude template="/modulos/pcl/solicitacao/forms/dados_cliente.cfm"></td>
                  </tr>
				  </cfif>
                </table>
                <script>
				 initAbas('tbl_abas',0);
				 </script></td>
            </tr>
          </table>
        </div></td>
    </tr>
  </table>
</form>
<span id="span_consultas" style="position: absolute; top: 0px; left:0px; border:1px solid black; background:white; display:none"></span>
<script>
	document.getElementById('arvore').disabled = true;
	<cfif not len(trim(session.cod_organograma))>
		alert('O usurio atual no possui lotao, impossvel prosseguir.');
		parent.document.getElementById('btn_voltar').click();
	</cfif>
</script>
</body>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style="display:none;"></iframe>
