<cfscript>
	if(Isdefined("vars.SOLICITACAO_CARGA_ID")){
		conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_solicitacao");
		qrOrdemLavagem = conn.get_ordem_lavagem_print(solicitacao_carga_id = vars.SOLICITACAO_CARGA_ID);
		
		if(Len(Trim(qrOrdemLavagem.NUM_ROMANEIO))){
			qrDoctos = conn.get_ordem_lavagem_doctos(num_romaneio = qrOrdemLavagem.NUM_ROMANEIO);
		}
	}
</cfscript>
<cfif Not IsDefined("qrOrdemLavagem")>
	<script>
		alert('Solicitao de Carga no definida!');
		window.close();
	</script>
</cfif>
<cfdocument name="pdf_lavagem" format="pdf" orientation="portrait" unit="cm" pagetype="a4">
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Ordem de Lavagem - Imprimir</title>
<style type="text/css">
	body {
		margin: 0;
		padding: 0;
	}
	.fonte {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-stretch: condensed;
		font-size: 9px;
	}
	.titulo {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-size: 18px;
		font-weight:bold;
	}
	.subtitulo {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-size: 11px;
		font-weight:bold;
	}
	.borda_tlbr {
		border-top: solid 1px #000;
		border-bottom: solid 1px #000;
		border-left: solid 1px #000;
		border-right: solid 1px #000;
	}
	.borda_tbr {
		border-top: solid 1px #000;
		border-bottom: solid 1px #000;
		border-right: solid 1px #000;
	}
	.borda_t {
		border-top: solid 1px #000;
	}
	.borda_b {
		border-bottom: solid 1px #000;
	}
	.borda_lbr {
		border-bottom: solid 1px #000;
		border-left: solid 1px #000;
		border-right: solid 1px #000;
	}
	.borda_lr {
		border-left: solid 1px #000;
		border-right: solid 1px #000;
	}
	.borda_br {
		border-bottom: solid 1px #000;
		border-right: solid 1px #000;
	}
	.div_check {
		border: solid 1px ##000;
		width: 5px;
		height: 5px;
		margin-left: 15px;
	}
</style>
</head>
<body>
<cfif IsDefined("qrOrdemLavagem")>
	<cfif qrOrdemLavagem.RecordCount gt 0>	
        <table width="85%" border="0" cellpadding="3" cellspacing="0" class="fonte">
        	<tr>
                <td width="15%" height="100%">&nbsp;</td>
                <td width="20%" height="100%">&nbsp;</td>
                <td width="20%" height="100%">&nbsp;</td>
                <td width="30%" height="100%">&nbsp;</td>
                <td width="15%" height="100%">&nbsp;</td>
            </tr>
            <tr class="titulo">
  	            <cfset logo =  f_url("/_imagens/logos/logo_relatorio.jpg")/> 
                <td class="borda_tlbr"><img src="<cfoutput>#logo#</cfoutput>" height="35" /></td>
                <td colspan="3" align="center" class="borda_tbr">ORDEM DE LAVAGEM DE VE&Iacute;CULOS</td>
                <td align="center" class="borda_tbr"><span class="subtitulo">N&ordm;&nbsp;<cfoutput>#qrOrdemLavagem.SOLICITACAO_COMPRA#</cfoutput></span></td>
            </tr>
            <tr>
            	<td colspan="5">&nbsp;</td>
            </tr>
            <!---DADOS GERAIS--->
            <tr>
            	<td colspan="2" class="borda_tlbr">Data:&nbsp;<cfoutput>#qrOrdemLavagem.DATA#</cfoutput></td>
                <td colspan="3" class="borda_tbr">Filial:&nbsp;<cfoutput>#qrOrdemLavagem.FILIAL#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="3" class="borda_lbr">Empresa:&nbsp;<cfoutput>#qrOrdemLavagem.EMPRESA#</cfoutput></td>
                <td colspan="2" class="borda_br">Cidade:&nbsp;<cfoutput>#qrOrdemLavagem.CIDADE#</cfoutput></td>                
            </tr>
            <tr>
            	<td colspan="5" class="borda_lbr">Endere&ccedil;o:&nbsp;<cfoutput>#qrOrdemLavagem.ENDERECO#</cfoutput></td>                              
            </tr>
            <tr>
            	<td colspan="5" class="borda_lbr">Telefone / FAX:&nbsp;<cfoutput>#qrOrdemLavagem.TELEFONE#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="3" class="borda_lbr">Frota Cavalo:&nbsp;<cfoutput>#qrOrdemLavagem.FROTA_CAVALO#</cfoutput></td>
                <td colspan="2" class="borda_br">Frota Carreta:&nbsp;<cfoutput>#qrOrdemLavagem.FROTA_CARRETA#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="5" class="borda_lbr">&Uacute;ltima Carga:&nbsp;<cfoutput>#qrOrdemLavagem.ULTIMA_CARGA#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="3" class="borda_lbr">N&ordm; Risco:&nbsp;<cfoutput>#qrOrdemLavagem.NUM_RISCO#</cfoutput></td>
                <td colspan="2" class="borda_br">N&ordm; ONU:&nbsp;<cfoutput>#qrOrdemLavagem.NUM_ONU#</cfoutput></td>
            </tr>
            <!---DADOS DO CAVALO--->
            <tr class="subtitulo">
            	<td colspan="5" align="center" class="borda_lbr">CAVALO</td>
            </tr>
            <tr>
            	<td colspan="5" class="borda_lbr">
                	<table width="100%" border="0" cellpadding="3" cellspacing="0" class="fonte">
                    	<tr>
                        	<td style="width:3%" align="center"><div class="div_check" style="width:3mm; height:3mm; text-align:center;"><b><cfoutput>#qrOrdemLavagem.APARENCIA#</cfoutput></b></div></td>
                            <td style="width:97%" align="left">Apar&ecirc;ncia</td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
            	<td colspan="5" class="borda_lbr">
                	<table width="100%" border="0" cellpadding="3" cellspacing="0" class="fonte">
                    	<tr>
                        	<td style="width:3%" align="center"><div class="div_check" style="width:3mm; height:3mm; text-align:center;"><b><cfoutput>#qrOrdemLavagem.COMPLETA#</cfoutput></b></div></td>
                            <td style="width:97%" align="left">Completa</td>
                        </tr>
                    </table>
                </td>
            </tr>
            <!---DADOS DA CARRETA--->
            <tr class="subtitulo">
            	<td colspan="5" align="center" class="borda_lbr">TANQUE / CARRETA</td>
            </tr>
            <tr>
            	<td colspan="5" class="borda_lbr">
                	<table width="100%" border="0" cellpadding="3" cellspacing="0" class="fonte">
                    	<tr>
                        	<td style="width:3%" align="center"><div class="div_check" style="width:3mm; height:3mm; text-align:center;"><b><cfoutput>#qrOrdemLavagem.LAVAGEM_INTERNA#</cfoutput></b></div></td>
                            <td style="width:97%" align="left">Lavagem Interna</td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
            	<td colspan="5" class="borda_lbr">
                	<table width="100%" border="0" cellpadding="3" cellspacing="0" class="fonte">
                    	<tr>
                        	<td style="width:3%" align="center"><div class="div_check" style="width:3mm; height:3mm; text-align:center;"><b><cfoutput>#qrOrdemLavagem.LAVAGEM_EXTERNA#</cfoutput></b></div></td>
                            <td style="width:97%" align="left">Lavagem Externa</td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
            	<td colspan="5" class="borda_lbr">
                	<table width="100%" border="0" cellpadding="3" cellspacing="0" class="fonte">
                    	<tr>
                        	<td style="width:3%" align="center"><div class="div_check" style="width:3mm; height:3mm; text-align:center;"><b><cfoutput>#qrOrdemLavagem.OUTROS#</cfoutput></b></div></td>
                            <td style="width:15%" align="left" nowrap="nowrap">Outros Servi&ccedil;os:</td>
                            <td style="width:82%" align="left"><cfoutput>#qrOrdemLavagem.DESCRICAO_OUTROS#</cfoutput></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <!---OBSERVAES--->
            <cfif Not IsDefined("qrDoctos")>
                <tr>
                    <td colspan="5" class="borda_lr"><br>DOCUMENTOS VINCULADOS:<br><br>
                    <cfoutput query="qrDoctos">
                    &nbsp;&nbsp;&nbsp;Tipo:&nbsp;#qrDoctos.TIPO#&nbsp;&nbsp;N&ordm;&nbsp;#qrDoctos.NUM_DOCTO#&nbsp;&nbsp;Remetente:&nbsp;#qrDoctos.REMETENTE#&nbsp;&nbsp;Coleta:#qrDoctos.COLETA#&nbsp;&nbsp;
                    Destinat&aacute;rio:&nbsp;#qrDoctos.DESTINATARIO#&nbsp;&nbsp;Entrega:&nbsp;#qrDoctos.ENTREGA#&nbsp;&nbsp;<br>
                    </cfoutput>
                    <br>
                    </td>
                </tr>
            </cfif>
            <tr>
            	<td colspan="5" class="borda_lbr"><br>OBSERVA&Ccedil;&Otilde;ES:<br><br>
                                                  &nbsp;&nbsp;&nbsp;Os pagamentos dos servi&ccedil;os somente ser&atilde;o liberados mediante c&oacute;pia anexada &agrave; <b>fatura</b>, dos seguintes documentos:<br>
                                                &nbsp;&nbsp;&nbsp;1) C&oacute;pia da "<b>ORDEM DE LAVAGEM DE VE&Iacute;CULOS</b>";<br>
                                                &nbsp;&nbsp;&nbsp;2) C&oacute;pia de "<b>CERTIFICADO DE LIMPEZA</b>" ou "<b>DECLARA&Ccedil;&Atilde;O DE LIMPEZA</b>" ou "<b>CERTIFICADO DE DESCONTAMINA&Ccedil;&Atilde;O</b>";<br>
                                                &nbsp;&nbsp;&nbsp;3) A partir de 01/12/2007 todos os lavadores devem atender a Portaria 255/2007 do INMETRO.</td>
            </tr>
            <!---RESPONSVEIS--->
            <tr>
            	<td colspan="2" class="borda_lbr">Solicitante:&nbsp;<cfoutput>#qrOrdemLavagem.SOLICITANTE#</cfoutput></td>
                <td colspan="3" class="borda_br">Motorista:&nbsp;<cfoutput>#qrOrdemLavagem.MOTORISTA#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="2" class="borda_lbr" style="height:10mm;">Assinatura:</td>
                <td colspan="3" class="borda_br">Assinatura:</td>
            </tr>
        </table>
  	</cfif>
</cfif>
</body>
</html>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfset data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss')>
<cfpdf action="merge" destination="#path#/pdf_lavagem_#data_hora#.pdf" overwrite="yes">
	<cfpdfparam source="pdf_lavagem" />
</cfpdf>
<script>
	window.location = '/temp/pdf_lavagem_<cfoutput>#data_hora#</cfoutput>.pdf';
</script>