<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_global");
	qrTipoDocumentos = conn.get_cg_ref_codes(owner = 'FISCAL', rv_domain = 'CONHECIMENTO_NOTA_FISCAL.TIPO_DOCUMENTO_ID');
	qrTipoDocOutros = conn.get_cg_ref_codes(owner = 'FISCAL', rv_domain = 'CONHECIMENTO_NOTA_FISCAL.TIPO_DOC_OUTROS');
</cfscript>
<script type="text/javascript">
	var v_serie = [];
	<cfoutput query="qrSubSerie" group="COD_MODELO">
		<cfoutput group="SERIE">
			v_serie.push( {
				cod_modelo: '#qrSubSerie.COD_MODELO#',
				serie: 		'#qrSubSerie.SERIE#' 
			} );
		</cfoutput>
	</cfoutput>

	var v_sub_serie = [];
	<cfoutput query="qrSubSerie">
		v_sub_serie.push( {
			cod_modelo: '#qrSubSerie.COD_MODELO#',
			serie: 		'#qrSubSerie.SERIE#',
			sub_serie: 	'#qrSubSerie.SUBSERIE#'
		} );
	</cfoutput>

	function set_pedido_shipment(valor) {
		with(document.forms[0]) {
			if(PEDIDO_SHIPMENT.value.length == 0) {
				PEDIDO_SHIPMENT.value = valor;
			}
		}
	}

	function f_busca_serie_nota() {
		with(document.forms[0]) {
		<cfif v_nf_serie_liberada eq 1>
			NOTA_SERIE.value = '';
			NOTA_SUB_SERIE.value = '';
			var v_serie_sel = '';
			var v_count = 0;

			if(!NOTA_MODELO.value) {
				return;
			}

			for(var i = 0; i < v_serie.length; i++) {
				if(v_serie[i].cod_modelo == NOTA_MODELO.value) {
					v_serie_sel = v_serie[i].serie;
					v_count++;
				}
			}

			if(v_count == 1) {
				NOTA_SERIE.value = v_serie_sel;
				f_busca_sub_serie_nota();
			}
		<cfelse>
			f_limpa_select(NOTA_SERIE);
			f_limpa_select(NOTA_SUB_SERIE);
			f_cria_option('', '--', NOTA_SERIE);
			f_cria_option('', '--', NOTA_SUB_SERIE);
			var v_count = 0;

			if(!NOTA_MODELO.value) {
				return;
			}

			for(var i = 0; i < v_serie.length; i++) {
				if(v_serie[i].cod_modelo == NOTA_MODELO.value) {
					f_cria_option(v_serie[i].serie, v_serie[i].serie, NOTA_SERIE);
					v_count++;
				}
			}

			if(v_count == 1) {
				NOTA_SERIE.options[0] = null;
				NOTA_SERIE.options[0].selected = true;
				f_busca_sub_serie_nota();
			}
		</cfif>
		}
	}

	function f_busca_sub_serie_nota() {
		with(document.forms[0]) {
		<cfif v_nf_serie_liberada eq 1>
			NOTA_SUB_SERIE.value = '';
			var v_sub_serie_sel = '';
			var v_count = 0;

			if(!NOTA_SERIE.value) {
				return;
			}

			for(var i = 0; i < v_sub_serie.length; i++) {
				if(v_sub_serie[i].cod_modelo == NOTA_MODELO.value && v_sub_serie[i].serie == NOTA_SERIE.value) {
					v_sub_serie_sel = v_sub_serie[i].sub_serie;
					v_count++;
				}
			}

			if(v_count == 1) {
				NOTA_SUB_SERIE.value = v_sub_serie_sel;
			}
		<cfelse>
			f_limpa_select(NOTA_SUB_SERIE);
			f_cria_option('', '--', NOTA_SUB_SERIE);
			var v_count = 0;

			if(!NOTA_SERIE.value) {
				return;
			}

			for(var i = 0; i < v_sub_serie.length; i++) {
				if(v_sub_serie[i].cod_modelo == NOTA_MODELO.value && v_sub_serie[i].serie == NOTA_SERIE.value) {
					f_cria_option(v_sub_serie[i].sub_serie, v_sub_serie[i].sub_serie, NOTA_SUB_SERIE);
					v_count++;
				}
			}

			if(v_count == 1) {
				NOTA_SUB_SERIE.options[0] = null;
				NOTA_SUB_SERIE.options[0].selected = true;
			}
		</cfif>
		}
	}

	<!---function f_busca_natureza(p_nome) {
		with(document.forms[0]) {
			if (!v_edicao){
				if(document.getElementById(p_nome+'_NUM_NATUREZA').value){
					document.getElementById(p_nome+'_NATUREZA').value = 'Aguarde, consultando...';
					f_query_wddx('/modulos/cte/_componentes/consulta/cfc_emissao_documentos.cfc?method=get_natureza'
								,'num_natureza='+document.getElementById(p_nome+'_NUM_NATUREZA').value+'&operacao_id='+ OPERACAO_ID_CTRC.value
								,function(obj){
									if(obj.ajax.readyState == 4 && obj.ajax.status == 200){
										if(obj.struct.num_natureza.length == 1){
											document.getElementById(p_nome+'_NATUREZA').value = obj.struct.descricao[0];
										}else{
											document.getElementById(p_nome+'_NATUREZA').value = '';
											alert('Natureza no encontrada ou no permitida para esta Operao Logstica.');
										}
									}
								});
				}else{
					document.getElementById(p_nome+'_NATUREZA').value = '';
				}
			}
		}
	}--->

	function f_busca_nota_natureza(p_nome,p_opcao) {
		with(document.forms[0]) {
			switch(p_opcao) {
				case 1:
					if(document.getElementById('sp_'+p_nome+'_natureza_aberta').style.display == 'none') {
						document.getElementById(p_nome+'_NATUREZA_COMBO').value = document.getElementById(p_nome+'_NUM_NATUREZA').value;

						if(!document.getElementById(p_nome+'_NUM_NATUREZA').value) {
							return;
						}

						if(!document.getElementById(p_nome+'_NATUREZA_COMBO').value && v_alert_natureza == 1) {
							alert('Natureza no permitida para a operao ' + OPERACAO_DESCRICAO.value + ', selecione uma das naturezas permitidas.');
							document.getElementById(p_nome+'_NUM_NATUREZA').focus();
						}
					}
					else {
						document.getElementById(p_nome+'_NATUREZA').value = '';

						if(!document.getElementById(p_nome+'_NUM_NATUREZA').value) {
							return;
						}
						document.getElementById(p_nome+'_NATUREZA').value = 'Buscando natureza...';
						f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_operacao.cfc</cf_url>?method=get_natureza'
									,'num_natureza=' + document.getElementById(p_nome+'_NUM_NATUREZA').value
									,function(obj) {
										if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
											if(obj.struct.num_natureza.length > 0) {
												document.getElementById(p_nome+'_NATUREZA').value = obj.struct.descricao[0];
											}
											else {
												document.getElementById(p_nome+'_NATUREZA').value = '';
												alert('Natureza no encontrada.');
												document.getElementById(p_nome+'_NUM_NATUREZA').focus();
											}
										}
									});
					}
					break;
				case 2:
					document.getElementById(p_nome+'_NUM_NATUREZA').value = document.getElementById(p_nome+'_NATUREZA_COMBO').value;
					break;
			}
		}
	}

	function f_busca_especie(p_nome) {
		with(document.forms[0]) {
			if (!v_edicao){
				if(document.getElementById(p_nome+'_NUM_ESPECIE').value){
					document.getElementById(p_nome+'_ESPECIE').value = 'Aguarde, consultando...';
					f_query_wddx('/modulos/cte/_componentes/consulta/cfc_emissao_documentos.cfc?method=get_especie'
								,'num_especie='+document.getElementById(p_nome+'_NUM_ESPECIE').value
								,function(obj){
									if(obj.ajax.readyState == 4 && obj.ajax.status == 200){
										if(obj.struct.num_especie.length > 0){
											document.getElementById(p_nome+'_ESPECIE').value = obj.struct.descricao[0];
										}else{
											document.getElementById(p_nome+'_ESPECIE').value = '';
											alert('Espcie no encontrada.');
										}
									}
								});
				}else{
					document.getElementById(p_nome+'_ESPECIE').value = '';
				}
			}
		}
	}

	function f_calcula_peso_cobrado(p_nome) {
		with(document.forms[0]){
			var p_nome = p_nome ? p_nome : 'NOTA';
			if(Number(document.getElementById(p_nome+'_PESO_KG_CONVERTIDO').value) > Number(document.getElementById(p_nome+'_CUBAGEM').value)){
				document.getElementById(p_nome+'_PESO_COBRADO').value = document.getElementById(p_nome+'_PESO_KG_CONVERTIDO').value;
			}else{
				document.getElementById(p_nome+'_PESO_COBRADO').value = document.getElementById(p_nome+'_CUBAGEM').value;
			}
		}
	}

	function f_calcula_peso_kg(p_nome) {
		with(document.forms[0]) {
			var p_nome = p_nome ? p_nome : 'NOTA';
			document.getElementById(p_nome+'_PESO_KG_CONVERTIDO').value = '';
			if(document.getElementById(p_nome+'_PESO').value == '' || document.getElementById(p_nome+'_COD_UNIDADE').value == '') {
				return;
			}
			f_query_wddx('/modulos/cte/_componentes/consulta/cfc_logistico.cfc?method=converte_unidade'
						,'valor='+document.getElementById(p_nome+'_PESO').value+'&unidade_origem='+document.getElementById(p_nome+'_COD_UNIDADE').value+'&unidade_destino=KG'
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									document.getElementById(p_nome+'_PESO_KG_CONVERTIDO').value = toCurrency(obj.struct);
									f_calcula_peso_cobrado(p_nome);
								}
							}
						})
		}
	}
	function f_calcula_cubagem(p_nome){
		with(document.forms[0]){
			var p_nome = p_nome ? p_nome : 'NOTA';
			if(document.getElementById(p_nome+'_ALTURA').value != null &&  document.getElementById(p_nome+'_LARGURA').value != null && document.getElementById(p_nome+'_COMPRIMENTO').value != null){
				document.getElementById(p_nome+'_M3').value = toCurrency(Number(document.getElementById(p_nome+'_ALTURA').value * document.getElementById(p_nome+'_LARGURA').value * document.getElementById(p_nome+'_COMPRIMENTO').value * document.getElementById(p_nome+'_QTDE_VOLUME').value));
				document.getElementById(p_nome+'_CUBAGEM').value = toCurrency(Number(document.getElementById(p_nome+'_ALTURA').value * document.getElementById(p_nome+'_LARGURA').value * document.getElementById(p_nome+'_COMPRIMENTO').value * 300));
				document.getElementById(p_nome+'_PESO_CUBADO').value = Number(document.getElementById(p_nome+'_ALTURA').value * document.getElementById(p_nome+'_LARGURA').value * document.getElementById(p_nome+'_COMPRIMENTO').value);
			}
		}
		f_calcula_peso_cobrado(p_nome);
	}

	function f_muda_tipo_documento(){
		with(document.forms[0]) {
			//Verifica se no possui ennhum documento
			v_total_nf = f_listagem_NOTAS_FISCAIS();
			v_total_nfe = f_listagem_NFE();
			v_total_outros = f_listagem_OUTROS();

			if( (Number(v_total_nf.length) + Number(v_total_nfe.length) + Number(v_total_outros.length) ) > 0){
				alert('Para alternar para outro tipo de documento , os documentos inseridos atualmente devem ser excluidos.');

				if(Number(v_total_nf.length)){
					TIPO_DOCUMENTO_ID.value = 0;
				}

				if(Number(v_total_nfe.length)){
					TIPO_DOCUMENTO_ID.value = 1;
				}

				if(Number(v_total_outros.length)){
					TIPO_DOCUMENTO_ID.value = 2;
				}

				return;
			}

			switch (Number(TIPO_DOCUMENTO_ID.value)){
				case 0:
					//habilita o fieldset especifico
					document.getElementById('tb_nota_fiscal').style.display = '';
					document.getElementById('tb_nota_fiscal').disabled = 0;


					//desabilita os outros fieldsets
					document.getElementById('fs_nfe').style.display = 'none';
					document.getElementById('fs_nfe').disabled = 1;
					document.getElementById('td_nfe').style.display = 'none';
					document.getElementById('td_nfe').disabled = 1;
					document.getElementById('td_tipo_doc_outros').style.display = 'none';
					document.getElementById('td_tipo_doc_outros').disabled = 1;

					document.getElementById('fs_outros').style.display = 'none';
					document.getElementById('fs_outros').disabled = 1;
					break;
				case 1:
					//habilita o fieldset especifico
					document.getElementById('fs_nfe').style.display = '';
					document.getElementById('fs_nfe').disabled = 0;
					document.getElementById('td_nfe').style.display = '';
					document.getElementById('td_nfe').disabled = 0;
					

					//desabilita os outros fieldsets
					document.getElementById('tb_nota_fiscal').style.display = 'none';
					document.getElementById('tb_nota_fiscal').disabled = 1;
					document.getElementById('fs_outros').style.display = 'none';
					document.getElementById('fs_outros').disabled = 1;
					document.getElementById('td_tipo_doc_outros').style.display = 'none';
					document.getElementById('td_tipo_doc_outros').disabled = 1;
					break;
				case 2:
					//habilita o fieldset especifico
					document.getElementById('fs_outros').style.display = '';
					document.getElementById('fs_outros').disabled = 0;
					document.getElementById('td_tipo_doc_outros').style.display = '';
					document.getElementById('td_tipo_doc_outros').disabled = 0;

					//desabilita os outros fieldsets
					document.getElementById('fs_nfe').style.display = 'none';
					document.getElementById('fs_nfe').disabled = 1;
					document.getElementById('td_nfe').style.display = 'none';
					document.getElementById('td_nfe').disabled = 1;
					document.getElementById('tb_nota_fiscal').style.display = 'none';
					document.getElementById('tb_nota_fiscal').disabled = 1;
					break;
				default:
					document.getElementById('td_tipo_doc_outros').style.display = 'none';
					document.getElementById('td_tipo_doc_outros').disabled = 1;
					document.getElementById('tb_nota_fiscal').style.display = 'none';
					document.getElementById('tb_nota_fiscal').disabled = 1;
			}
		}
	}
	
	function f_muda_tipo_doc_outros(){
		with(document.forms[0]) {
			v_total_outros = f_listagem_OUTROS();

			if( (Number(v_total_outros.length) ) > 0){
				alert('Para alternar o tipo de documento outros, os documentos inseridos atualmente devem ser excludos.');
					TIPO_DOC_OUTROS.value = v_lista[0].TIPO_DOC_OUTROS;
				return;
			}
		}
	}
	
	function f_busca_dados_nfe() {
		with(document.forms[0]) {
			if(ARQUIVO.value){
				var v_nome_arquivo = ARQUIVO.value;
				var v_extensao = v_nome_arquivo.substr(v_nome_arquivo.lastIndexOf('.'));

				if(v_extensao != '.xml' && v_extensao != '.XML'){
					document.getElementById('td_nfe').innerHTML = document.getElementById('td_nfe').innerHTML;
					alert('O arquivo selecionado deve ser um XML.');
					return false;
				}

				f_cria_carregando_ajax();

				OPERACAO_OLD.value = OPERACAO.value;
				OPERACAO.value = 5;
				target = 'consultas';
				action = 'confirma.cfm';
				submit();
				OPERACAO.value = OPERACAO_OLD.value;
			}
		}
	}

	function f_busca_dados_chave_nfe(){
		with(document.forms[0]) {
			if(CHAVE_ACESSO_NFE.value){
				f_validar_chave_nfe();

				v_chave = CHAVE_ACESSO_NFE.value.toString();
				MODELO_NFE.value = Number(v_chave.substr(20,2));
				NUMERO_NFE.value = Number(v_chave.substr(25,9));
				SERIE_NFE.value = Number(v_chave.substr(22,3));
			}
		}

	}

	parent.f_busca_dados_chave_nfe = f_busca_dados_chave_nfe;

	function f_validar_chave_nfe() {
		with(document.forms[0]) {
			f_cria_carregando_ajax();

			OPERACAO_OLD.value = OPERACAO.value;
			OPERACAO.value = 6;
			target = 'consultas';
			action = 'confirma.cfm';
			submit();
			OPERACAO.value = OPERACAO_OLD.value;
		}
		return false;
	}

	function f_controla_tipo_docto_frete(){
		with(document.forms[0]){
			if(TIPO_DOCTO_FRETE.value == ''){
				TIPO_DOCUMENTO_ID.disabled = '';
				TIPO_DOC_OUTROS.disabled = '';
			}else{
				TIPO_DOCUMENTO_ID.value = TIPO_DOCTO_FRETE.value;
				f_muda_tipo_documento();
				TIPO_DOCUMENTO_ID.disabled = 'disabled';
				TIPO_DOC_OUTROS.disabled = 'disabled';
			}
		}
	}

	function f_get_nfe_cfop_obrigatorio(){
	   return <cfoutput>"v_nfe_cfop_obrigatorio.valor"</cfoutput>;
	}

	function f_pedido_shipment_obrigatorio(v_obrigatorio){
		v_class = v_obrigatorio == 1 ? 'requerido_form' : '';
		v_nota = document.getElementById('NOTA_ORDEM_COMPRA');
		v_nfe = document.getElementById('NFE_ORDEM_COMPRA');
		v_outros = document.getElementById('OUTROS_ORDEM_COMPRA');

		v_nota.setAttribute('obrigatorio',v_obrigatorio);
		v_nfe.setAttribute('obrigatorio',v_obrigatorio);
		v_outros.setAttribute('obrigatorio',v_obrigatorio);
		v_nota.className = v_class;
		v_nfe.className  = v_class;
		v_outros.className  = v_class;
	}

	function f_localizar_nfe(){
		with(document.forms[0]){
			if(CNPJ_CPF_DESTINATARIO.value == '' || CNPJ_CPF_REMETENTE.value == '' || OPERACAO_ID.value == ''){
				alert("Para localizar NF-e's integradas o Remetente e o Destinatrio devem estar preenchidos.");
				return false;
			}

			f_abrir_janela('<cf_url>/modulos/cte/emitir/localizar_nfe.cfm</cf_url>?cpf_cnpj_destinatario='+CNPJ_CPF_DESTINATARIO.value+'&cpf_cnpj_emitente='+CNPJ_CPF_REMETENTE.value +'&operacao_id='+ OPERACAO_ID.value, 'f_atualizar()', 800, 600, true)
		}
	}

	function f_insere_nfe_integrada(p_documento_id, p_num_natureza, p_natureza){
		with(document.forms[0]) {
			DOCUMENTO_ID.value = p_documento_id;

			if(!DOCUMENTO_ID.value) {
				return;
			}

			f_query_wddx('<cf_url>/modulos/cte/_componentes/consulta/cfc_cte.cfc</cf_url>?method=get_nfe'
						,'documento_id=' + DOCUMENTO_ID.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.documento_id.length > 0) {
									for(var i = 0; i < obj.struct.documento_id.length; i++) {
										f_incluir_NFE();

										v_inserida = 1;

										/* Campos */
										CHAVE_ACESSO_NFE.value       = obj.struct.chave_numerica[i];
										NFE_VALOR.value              = obj.struct.valor[i];
										NFE_VALOR_SEGURADO.value     = obj.struct.valor[i];

										NFE_NUM_NATUREZA.value       = p_num_natureza;
										NFE_NATUREZA.value           = 'NFe Integrada';
										NFE_NATUREZA_COMBO.value     = p_num_natureza;

										NFE_PESO.value               = obj.struct.peso[i];
										NFE_PESO_COBRADO.value       = obj.struct.peso[i];
										NFE_CFOP.value               = obj.struct.cfop[i];
										NFE_NUM_ESPECIE.value        = obj.struct.num_especie[i];
										NFE_ESPECIE.value            = obj.struct.especie_mapeada[i];


										PIN_SUFRAMA_NFE.value        = '';
										REMETENTE_NFE.value          = obj.struct.razao_social_emitente[i];
										CNPJ_REMETENTE_NFE.value     = obj.struct.cpf_cnpj_emitente[i];
										DESTINATARIO_NFE.value       = obj.struct.razao_social_destinatario[i];
										CNPJ_DESTINATARIO_NFE.value  = obj.struct.cpf_cnpj_destinatario[i];
										NOME_ARQUIVO.value           = '';
										NUMERO_NFE.value             = obj.struct.numero_documento[i];
										MODELO_NFE.value             = obj.struct.modelo_documento[i];
										SERIE_NFE.value              = obj.struct.serie_documento[i];
										DATA_EMISSAO_NFE.value       = obj.struct.data_emissao[i];
										NFE_DOCUMENTO_ID.value       = obj.struct.documento_id[i];
										/* ------ */

										f_salvar_NFE();
									}

								}
								else {
									alert('NFE no encontrada.');
								}
							}
						});

			v_inserida = 0;
		}
	}

	function f_valor_segurado_automatico(tipo_documento, atualiza_valor_segurado) {
           with(document.forms[0]) {
              f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_operacao.cfc</cf_url>?method=get_config_valor_segurado'
                          ,'operacao_id=' + OPERACAO_ID.value
                          ,function(obj) {
                              if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
                                 if(obj.struct.destinado_exportacao.length > 0) {
                                    for(var i = 0; i < obj.struct.destinado_exportacao.length; i++) {
                                       if (obj.struct.destinado_exportacao[i] == 1 && obj.struct.adicional_valor_segurado[i] > 0) {
                                          document.getElementById(tipo_documento+'_VALOR_SEGURADO').setAttribute('disabled', 'disabled');
                                          if (atualiza_valor_segurado == 1) {
                                             if (document.getElementById(tipo_documento+'_VALOR').value == '') {
                                                document.getElementById(tipo_documento+'_VALOR_SEGURADO').value = document.getElementById(tipo_documento+'_VALOR').value;
                                             } else {
                                                document.getElementById(tipo_documento+'_VALOR_SEGURADO').value = toCurrency(Number(document.getElementById(tipo_documento+'_VALOR').value) + (document.getElementById(tipo_documento+'_VALOR').value * obj.struct.adicional_valor_segurado[i] / 100));
                                             }
                                          }
                                       } else {
                                          document.getElementById(tipo_documento+'_VALOR_SEGURADO').removeAttribute('disabled');
                                          if (atualiza_valor_segurado == 1) {
                                             document.getElementById(tipo_documento+'_VALOR_SEGURADO').value = document.getElementById(tipo_documento+'_VALOR').value;
                                          }
                                       }
                                       if (OPERACAO_ID.value !== "") {
                                          f_query_wddx('<cf_url>/modulos/pcl/_componentes/consulta/cfc_operacao.cfc</cf_url>?method=get_sobretaxa_seguro_operacao'
                                                      ,'operacao_id=' + OPERACAO_ID.value
                                                      ,function(obj2) {
                                                          if(obj2.ajax.readyState == 4 && obj2.ajax.status == 200) {
                                                             if(obj2.struct.perc_sobretaxa.length > 0) {
                                                                var valor_segurado = Number(document.getElementById(tipo_documento+'_VALOR_SEGURADO').value);
                                                                valor_segurado = toCurrency(valor_segurado + (valor_segurado * obj2.struct.perc_sobretaxa[0] / 100));
                                                                document.getElementById(tipo_documento+'_VALOR_SEGURADO').value = valor_segurado;
                                                             }
                                                          }
                                                       });
                                       }
									}
                                 }
                              }
                           });
              }
           }
</script>
<input type="hidden" name="SOLICITACAO_CARGA_NF_ID" fixo="1" value="" />
<input type="hidden" name="DOCUMENTO_ID" id="DOCUMENTO_ID" value=""/>
<table width="900px%" border="0" cellpadding="0" cellspacing="0">
	<tr>
    	<td width="90%">
        	<table width="90%" border="0" cellpadding="1" cellspacing="3">
            	<tr>
                	<td class="texto" nowrap style="width: 430px;">Tipo do Documento:
                    <select name="TIPO_DOCUMENTO_ID" id="TIPO_DOCUMENTO_ID" obrigatorio="1" display="TIPO DO DOCUMENTO" style="width: 300px;" onChange="f_muda_tipo_documento();" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
					  <cfoutput query="qrTipoDocumentos">
                        	<option value="#qrTipoDocumentos.RV_LOW_VALUE#">#qrTipoDocumentos.RV_ABBREVIATION#</option>
                      </cfoutput>
                    </select></td>
                    <td class="texto" nowrap id="td_nfe" style="display:none;">&nbsp;Enviar Arquivo:
                        <input type="file" name="CONTEUDO" id="CONTEUDO" display="NFE / XML" secao="NFE" onChange="document.forms[0].ARQUIVO.value = document.forms[0].CONTEUDO.value;f_busca_dados_nfe();" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >&nbsp;&nbsp;
                        <button id="btn_busca_nfe" class="botao" onClick="f_localizar_nfe();" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
                        	<img alt="" align=absmiddle src="/_imagens/botoes/16x16/buscar.gif" width=16 height=16>&nbsp;Localizar NFE
                        </button>
                    </td>
                    <td class="texto" nowrap id="td_tipo_doc_outros" style="display:none;">&nbsp;Tipo de Documento para Outros:
                      <select name="TIPO_DOC_OUTROS" id="TIPO_DOC_OUTROS" display="TIPO DOCUMENTO OUTROS" style="width:200px;" onChange="f_muda_tipo_doc_outros();">
					  <cfoutput query="qrTipoDocOutros">
                        	<option value="#qrTipoDocOutros.RV_LOW_VALUE#">#qrTipoDocOutros.RV_LOW_VALUE# - #qrTipoDocOutros.RV_ABBREVIATION#</option>                        
                      </cfoutput>
                      </select>
					</td>
                </tr>
            </table>
        </td>
    </tr>
</table>
<table width="100%" border="0" cellpadding="3" cellspacing="1" class="texto" id="tb_nota_fiscal"><!--DWLayoutTable-->
   <tr>
     <td height="1" colspan="4" nowrap style="padding:0"><fieldset><legend>Nota Fiscal</legend><table width="100%" border="0" cellspacing="1" cellpadding="3">
   <tr>
      <td width="1%" height="1" nowrap class="texto">N&ordm; Nota:
	    <input name="NOTAS" type="hidden" id="NOTAS" value="">
        <input type="hidden" name="ARQUIVO" id="ARQUIVO" display="NFE / ARQUIVO" value="" sempre_ativo="1" secao="NFE"/>
        <input type="hidden" name="COD_MODELO" id="COD_MODELO" value=""/></td>
      <td class="texto" ><input name="NOTA_NUMERO" type="text" id="NOTA_NUMERO" size="15" maxlength="10" obrigatorio="1" display="NOTAS FISCAIS / NUM NOTA" tipo="numerico" secao="NOTAS_FISCAIS" onkeypress="return f_formata(this,event,'000000000000')" <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> ></td>
      <td class="texto" ><nobr>Emiss&atilde;o: </nobr></td>
      <td class="texto" ><nobr><input name="NOTA_DATA_EMISSAO" type="text" id="NOTA_DATA_EMISSAO" onkeypress="return f_formata(this,event,'00/00/0000')" size="15" maxlength="10" obrigatorio="1" value="" display="NOTAS FISCAIS / DATA EMISS&Atilde;O" tipo="data" secao="NOTAS_FISCAIS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> />
<button class="botao-16x16" id="trigger" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ><img src="/_imagens/botoes/16x16/calendario.gif" width="16" height="16" align="absmiddle" /></button>
     </nobr>	  </td>
   </tr>

   <tr>
      <td height="1" nowrap class="texto">Modelo:</td>
      <td width="1%" class="texto"><select name="NOTA_MODELO" id="NOTA_MODELO" obrigatorio="1" display="NOTAS FISCAIS / MODELO" secao="NOTAS_FISCAIS" fixo="1" onchange="f_busca_serie_nota()" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
        <cfif qrSubSerie.RecordCount gt 0>
          <option value="">--- Selecione ---</option>
          <cfoutput query="qrSubSerie" group="COD_MODELO">
            <option value="#qrSubSerie.COD_MODELO#">#qrSubSerie.COD_MODELO#</option>
          </cfoutput>
        </cfif>
      </select></td>
      <td width="1%" class="texto">S&eacute;rie:<nobr></nobr></td>
      <td width="99%" class="texto">
      <cfif v_nf_serie_liberada eq 1>
      <input name="NOTA_SERIE" id="NOTA_SERIE" style="width:40px" obrigatorio="1" display="NOTAS FISCAIS / S&Eacute;RIE" fixo="1" secao="NOTAS_FISCAIS" onchange="f_busca_sub_serie_nota()" onkeypress="return f_formata(this,event,'AAA')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
        Sub-s&eacute;rie:
        <input name="NOTA_SUB_SERIE" id="NOTA_SUB_SERIE" style="width:40px" obrigatorio="1" display="NOTAS FISCAIS / SUB-S&Eacute;RIE" fixo="1" secao="NOTAS_FISCAIS"  onkeypress="return f_formata(this,event,'000')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
      <cfelse>
      <select name="NOTA_SERIE" id="NOTA_SERIE" obrigatorio="1" display="NOTAS FISCAIS / S&Eacute;RIE" fixo="1" secao="NOTAS_FISCAIS" onchange="f_busca_sub_serie_nota()" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
        <option value="">--</option>
      </select>
        Sub-s&eacute;rie:
        <select name="NOTA_SUB_SERIE" id="NOTA_SUB_SERIE" obrigatorio="1" display="NOTAS FISCAIS / SUB-S&Eacute;RIE" fixo="1" secao="NOTAS_FISCAIS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
          <option value="">--</option>
        </select>
       </cfif></td></tr>

   <tr>
      <td height="1" nowrap class="texto">Valor da Nota:</td>
     <td class="texto"><input name="NOTA_VALOR" type="text" id="NOTA_VALOR" onkeypress="return f_formata_numero_decimal(this,event)" size="15" maxlength="15" obrigatorio="1" display="NOTAS FISCAIS / VALOR" tipo="numerico" secao="NOTAS_FISCAIS" onchange="this.value = toCurrency(this.value); f_valor_segurado_automatico('NOTA', 1);"  <cfif "#vars.TERCEIRIZADO#" eq 1 > readonly </cfif> /></td>
     <td class="texto"><nobr>Valor Segurado: </nobr> </td>
     <td class="texto"><input name="NOTA_VALOR_SEGURADO" type="text" id="NOTA_VALOR_SEGURADO" onkeypress="return f_formata_numero_decimal(this,event)" size="15" maxlength="15" obrigatorio="0" display="NOTAS FISCAIS / VALOR" tipo="numerico" secao="NOTAS_FISCAIS" onchange="this.value = toCurrency(this.value)"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
     <nobr>CFOP: </nobr>
     	<input name="NOTA_CFOP" type="text" id="NOTA_CFOP" size="10" maxlength="4" obrigatorio="0" display="NOTAS FISCAIS / CFOP" secao="NOTAS_FISCAIS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
  </tr>
   <tr>
     <td valign="top" class="texto">Pedido/Shipment:</td>
     <td colspan="6" valign="top" class="texto"><textarea name="NOTA_ORDEM_COMPRA" id="NOTA_ORDEM_COMPRA" onKeyPress="if (this.value.length > 160) return false;" onBlur="if (this.value.length >= 160) this.value = this.value.substr(0, 160);" obrigatorio="0" display="NOTAS FISCAIS / PEDIDO/SHIPMENT" secao="NOTAS_FISCAIS" cols="60" row="4" style="width: 500px; resize: none; height:45px;" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ></textarea></td>
     </tr>
     </table></fieldset></td>
   </tr>
   <tr>
     <td height="1" colspan="4" nowrap style="padding:0"><fieldset>
     <legend>Mercadoria</legend>
     <table width="100%" border="0" cellspacing="1" cellpadding="3">
              <tr>
                <td width="8%" class="texto">Volumes:</td>
                <td width="12%" class="texto"><input name="NOTA_QTDE_VOLUME" type="text" id="NOTA_QTDE_VOLUME" size="15" maxlength="10" obrigatorio="1" display="NOTAS FISCAIS / QUANTIDADE" tipo="numerico" secao="NOTAS_FISCAIS" onkeypress="return f_formata_numero_decimal(this,event)"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                <td class="texto">Peso:
                  <input name="NOTA_PESO" type="text" id="NOTA_PESO" size="10" maxlength="10" obrigatorio="1" display="NOTAS FISCAIS / PESO" tipo="numerico" secao="NOTAS_FISCAIS" onkeypress="return f_formata_numero_decimal(this,event)" onchange="/*this.value = toCurrency(this.value);*/ f_calcula_peso_kg('NOTA')"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                  <select name="NOTA_COD_UNIDADE" id="NOTA_COD_UNIDADE" fixo="1" manter="1" obrigatorio="1" display="NOTAS FISCAIS / UNIDADE" secao="NOTAS_FISCAIS" onchange="f_calcula_peso_kg('NOTA')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
							             <option value="Kg" selected="selected">Kilogramas</option>
<!---                    <option value="">-- Selecione --</option>
                    <cfoutput query="qrUnidade">
                      <option value="#qrUnidade.cod_unidade#" <cfif qrUnidade.cod_unidade eq 'Kg'>selected</cfif>>#qrUnidade.unidade#</option>
                    </cfoutput>
--->                  </select>
                  <input name="NOTA_M3" type="hidden" id="NOTA_M3" value="0" fixo="1" />
                  <input name="NOTA_PESO_CUBADO" type="hidden" id="NOTA_PESO_CUBADO" value="0" fixo="1" />
                  <input name="NOTA_PESO_KG_CONVERTIDO" type="hidden" id="NOTA_PESO_KG_CONVERTIDO" size="10" maxlength="10" obrigatorio="0" display="NOTAS FISCAIS / PESO" tipo="numerico" secao="NOTAS_FISCAIS"  /></td>
              </tr>

              <tr>
                <td nowrap class="texto">Natureza:</td>
                <td colspan="3" class="texto"><input type="text" name="NOTA_NUM_NATUREZA" id="NOTA_NUM_NATUREZA" maxlength="10" obrigatorio="1" tipo="numerico" secao="NOTAS_FISCAIS" display="NOTAS FISCAIS / NATUREZA" onChange="f_busca_nota_natureza('NOTA',1)" onKeyPress="return f_formata(this, '0000000000')" style="width: 50px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                    <span id="sp_NOTA_natureza_restrita" style="display: none;">
                        <select name="NOTA_NATUREZA_COMBO" id="NOTA_NATUREZA_COMBO" secao="NOTAS_FISCAIS" display="NOTAS FISCAIS / NATUREZA" onChange="f_busca_nota_natureza('NOTA',2)" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
                        </select>
                    </span>
                    <span id="sp_NOTA_natureza_aberta">
                        <input type="text" name="NOTA_NATUREZA" id="NOTA_NATUREZA" readonly secao="NOTAS_FISCAIS" display="NOTAS FISCAIS / NATUREZA" style="width: 250px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />&nbsp;
                        <button type="button" class="botao-16x16" onClick="NewWindow('../_localizar/localizar_natureza.cfm?num_natureza=NOTA_NUM_NATUREZA&natureza=NOTA_NATUREZA','_blank',600,400,'yes')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Natureza" title="Buscar Natureza" width="16" height="16" align="absmiddle" /></button>
                    </span></td>
              </tr>


              <tr>
                <td class="texto">Esp&eacute;cie:</td>
                <td colspan="2" class="texto"><input name="NOTA_NUM_ESPECIE" type="text" id="NOTA_NUM_ESPECIE" style="width: 40px" onkeypress="return f_formata(this,event,'000000')" onchange="f_busca_especie('NOTA')" obrigatorio="1" display="NOTAS FISCAIS / ESPECIE" secao="NOTAS_FISCAIS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                  <input name="NOTA_ESPECIE" type="text" id="NOTA_ESPECIE" readonly="true" style="width: 200px" obrigatorio="1" display="NOTAS FISCAIS / ESPECIE" secao="NOTAS_FISCAIS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                  <button type="button" class="botao-16x16" onclick="NewWindow('/_consultas/localizar_especie.cfm?num_ESPECIE=NOTA_NUM_ESPECIE&ESPECIE=NOTA_ESPECIE','_blank',600,400,'yes')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle" /></button></td>
              </tr>
              <tr>
                <td class="texto">Altura:</td>
                <td colspan="2" class="texto"><input name="NOTA_ALTURA" type="text" id="NOTA_ALTURA" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / ALTURA" obrigatorio="0" onchange="f_calcula_cubagem('NOTA');" tipo="numerico" secao="NOTAS_FISCAIS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                  Comprimento:
                    <input name="NOTA_COMPRIMENTO" type="text" id="NOTA_COMPRIMENTO" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / COMPRIMENTO" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('NOTA');" secao="NOTAS_FISCAIS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                    Largura:
                    <input name="NOTA_LARGURA" type="text" id="NOTA_LARGURA" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / LARGURA" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('NOTA');" secao="NOTAS_FISCAIS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                    Cubagem:
                <input name="NOTA_CUBAGEM" type="text" id="NOTA_CUBAGEM" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / CUBAGEM" tipo="numerico" obrigatorio="0" secao="NOTAS_FISCAIS" readonly="true"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
              </tr>
              <tr>
                <td class="texto"><nobr>Peso Cobrado: </nobr> </td>
                <td colspan="2" class="texto"><input name="NOTA_PESO_COBRADO" type="text" id="NOTA_PESO_COBRADO" style="width: 90px" obrigatorio="1" display="NOTAS FISCAIS / PESO COBRADO" secao="NOTAS_FISCAIS" onkeypress="return f_formata_numero_decimal(this,event)"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                  Kg</td>
              </tr>
      </table></fieldset></td>
   </tr>
   <tr>
      <td colspan="4">
		<cfset lista_id = 'NOTAS_FISCAIS'>
			  <cfset lista_campos = 'SOLICITACAO_CARGA_NF_ID,NOTA_NUMERO,NOTA_SERIE,NOTA_SUB_SERIE,NOTA_MODELO,NOTA_DATA_EMISSAO,NOTA_VALOR,'>
			  <cfset lista_campos = lista_campos&'NOTA_VALOR_SEGURADO,NOTA_ORDEM_COMPRA,NOTA_QTDE_VOLUME,NOTA_PESO,'>
			  <cfset lista_campos = lista_campos&'NOTA_COD_UNIDADE,NOTA_M3,NOTA_PESO_CUBADO,NOTA_PESO_KG_CONVERTIDO,'>
			  <cfset lista_campos = lista_campos&'NOTA_NUM_NATUREZA,NOTA_NATUREZA,NOTA_NUM_ESPECIE,NOTA_ESPECIE,NOTA_NATUREZA_COMBO,'>
			  <cfset lista_campos = lista_campos&'NOTA_ALTURA,NOTA_LARGURA,NOTA_COMPRIMENTO,NOTA_CUBAGEM,NOTA_PESO_COBRADO,NOTA_CFOP'>

			  <cfset lista_titulos = 'N Nota,Modelo,Srie,Sub-Srie,Data Emisso,Valor,Peso'>
			  <cfset lista_titulos_campos = 'NOTA_NUMERO,NOTA_MODELO,NOTA_SERIE,NOTA_SUB_SERIE,NOTA_DATA_EMISSAO,NOTA_VALOR,NOTA_PESO'>
			  <cfset lista_titulos_tamanho = '100,80,80,80,120,150,150'>
			  <cfset lista_campo_id = 'SOLICITACAO_CARGA_NF_ID'>
			  <cfset lista_default = 0>
			  <cfset lista_height = '200'>
			  <cfset lista_width = '100%'>
			  <cfinclude template="/_include/lista.cfm">
		<script language="javascript1.2">
		var v_num_especie_notas = '';
		var v_num_natureza_notas = '';
		var v_cod_unidade_notas = '';
		var v_edicao = false;
		function f_on_incluir_NOTAS_FISCAIS() {
			with(document.forms[0]) {
				NOTA_ALTURA.value = 0;
				NOTA_LARGURA.value = 0;
				NOTA_COMPRIMENTO.value = 0;
				if (!v_edicao){
					NOTA_COMPRIMENTO.onchange();
				}

				v_lista = f_listagem_NOTAS_FISCAIS();
				if(v_lista.length > 0){
					NOTA_NUM_NATUREZA.value = v_lista[0].NOTA_NUM_NATUREZA;
					NOTA_NUM_NATUREZA.onchange();
					NOTA_NUM_ESPECIE.value = v_lista[0].NOTA_NUM_ESPECIE;

					NOTA_NUM_ESPECIE.onchange();
				}

				NOTA_QTDE_VOLUME.value = 1;
				f_valor_segurado_automatico('NOTA', 0);
				v_edicao = false;
			}
		}


		function f_on_salva_lista_NOTAS_FISCAIS() {
			with(document.forms[0]) {

				v_lista = f_listagem_NOTAS_FISCAIS();
				if(v_lista.length > 0){
					NUM_NATUREZA.value = v_lista[0].NOTA_NUM_NATUREZA;
					NUM_NATUREZA.onchange();
					NUM_ESPECIE.value = v_lista[0].NOTA_NUM_ESPECIE;
					NUM_ESPECIE.onchange();
				}

				VALOR_TOTAL_NF.value = toCurrency(f_total_campo_NOTAS_FISCAIS('NOTA_VALOR'));

				if(Number(VALOR_TOTAL_SUGERIDO.value) < Number(VALOR_TOTAL_NF.value)) {
					VALOR_TOTAL_SUGERIDO.value = VALOR_TOTAL_NF.value;
				}
			}
		}
		function f_before_salvar_NOTAS_FISCAIS() {
			with(document.forms[0]) {
				if(f_ajax_running() > 0 && v_inserida == 0) {
					alert('Aguarde o trmino do processamento antes de salvar.');
					return false;
				}
				if(NOTA_NUM_ESPECIE.value && !NOTA_ESPECIE.value && !NOTA_ESPECIE_COMBO.value) {
					alert('A espcie selecionada no  vlida!');
					return false;
				}
				if(NOTA_NUM_NATUREZA.value && !NOTA_NATUREZA.value && !NOTA_NATUREZA_COMBO.value) {
					alert('A natureza selecionada no  vlida!');
					return false;
				}
				<cfif IsDefined("v_valida_valor_segurado") and v_valida_valor_segurado eq 1>
				if(Number(NOTA_VALOR.value) > Number(NOTA_VALOR_SEGURADO.value)) {
					alert('O Valor Segurado (R$ '+ Number(NOTA_VALOR_SEGURADO.value).toFixed(2) +') da nota fiscal ' + NOTA_NUMERO.value + '/' + NOTA_SERIE.value + ' deve ser maior ou igual ao valor da mesma (R$ '+ Number(NOTA_VALOR.value).toFixed(2) +').');
					NOTA_VALOR_SEGURADO.focus();
					return false;
				}
				</cfif>
				set_pedido_shipment(NOTA_ORDEM_COMPRA.value);
				return true;
			}
		}
		function f_on_seleciona_NOTAS_FISCAIS() {
			with(document.forms[0]) {
				f_busca_serie_nota();
				NOTA_SERIE.value = document.getElementById('NOTA_SERIE_NOTAS_FISCAIS_'+lista_selected_NOTAS_FISCAIS.value).value;
				f_busca_sub_serie_nota();
				NOTA_SUB_SERIE.value = document.getElementById('NOTA_SUB_SERIE_NOTAS_FISCAIS_'+lista_selected_NOTAS_FISCAIS.value).value;
			}
		}
		</script>	  </td>
   </tr>
</table>

<table width="100%" border="0" cellpadding="1" cellspacing="0">
	<tr>
    	<td width="100%">
        	<fieldset id="fs_nfe" style="display:none" disabled="true"><legend>Nota Fiscal Eletr&ocirc;nica</legend>
                <table width="100%" border="0" cellpadding="1" cellspacing="3">
                    <tr>
                        <td nowrap width="100%" class="texto">Chave de Acesso da NFe:
                        <input type="hidden" name="NFE_ID" id="NFE_ID" />
                        <input type="hidden" name="NOME_ARQUIVO" id="NOME_ARQUIVO" />
                        <input type="hidden" name="NFE_DOCUMENTO_ID" id="NFE_DOCUMENTO_ID" />
                        <input type="hidden" name="NFE_XML" id="NFE_XML" />
                        <input type="text" name="CHAVE_ACESSO_NFE" id="CHAVE_ACESSO_NFE" maxlength="44" obrigatorio="1" secao="NFE" display="NFE / CHAVE DE ACESSO DA NFE" style="width: 320px;" onchange="f_busca_dados_chave_nfe();" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                        &nbsp;PIN do Suframa:
                    	<input type="text" name="PIN_SUFRAMA_NFE" id="PIN_SUFRAMA_NFE" maxlength="30" secao="NFE" display="NFE / PIN DO SUFRAMA" style="width: 100px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                        &nbsp;Valor da Nota:
                    	<input type="text" name="NFE_VALOR" id="NFE_VALOR" maxlength="15" obrigatorio="1" tipo="numerico" secao="NFE" display="NFE / VALOR" onChange="this.value = Number(this.value).toFixed(2); f_valor_segurado_automatico('NFE', 1);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                        &nbsp;Valor Segurado:
                    	<input type="text" name="NFE_VALOR_SEGURADO" id="NFE_VALOR_SEGURADO" maxlength="15" obrigatorio="1" tipo="numerico" secao="NFE" display="NFE / VALOR SEGURADO" onChange="this.value = Number(this.value).toFixed(2);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                        </td>
                    <tr>
                        <td nowrap width="100%" class="texto">Data de Emiss&atilde;o:
                        	<input type="text" name="DATA_EMISSAO_NFE" id="DATA_EMISSAO_NFE" onkeypress="return f_formata(this,event,'00/00/0000')" size="15" maxlength="10" obrigatorio="1" tipo="data" secao="NFE" display="NFE / DATA DE EMISSAO DA NFE" style="width: 85px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                                            <button type="button" id="BTN_DATA_EMISSAO_NFE" class="botao-16x16" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
																<script type="text/javascript">
                                                                    Calendar.setup( {
                                                                        inputField  : "DATA_EMISSAO_NFE",      // ID of the input field
                                                                        ifFormat    : "%d/%m/%Y",               // the date format
                                                                        button      : "BTN_DATA_EMISSAO_NFE",  // ID of the button
                                                                        range       : [2001,2050]
                                                                    } );
                                                                </script>
                        &nbsp;N&uacute;mero:<input type="text" name="NUMERO_NFE" id="NUMERO_NFE" maxlength="44" obrigatorio="1" secao="NFE" display="NFE / NMERO DA NFE" style="width: 85px;" readonly="readonly" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                        &nbsp;Modelo:<input type="text" name="MODELO_NFE" id="MODELO_NFE" maxlength="44" obrigatorio="1" secao="NFE" display="NFE / MODELO DA NFE" style="width: 85px;" readonly="readonly" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                        &nbsp;S&eacute;rie:<input type="text" name="SERIE_NFE" id="SERIE_NFE" maxlength="44" obrigatorio="1" secao="NFE" display="NFE / SRIE DA NFE" style="width: 85px;" readonly="readonly" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                        &nbsp;CFOP:
									 <cfif v_nfe_cfop_obrigatorio.valor eq "Sim">
                                        <input name="NFE_CFOP" type="text" id="NFE_CFOP" size="10" maxlength="4" display="NFE / CFOP" secao="NFE" obrigatorio="1"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                     <cfelse>
                                        <input name="NFE_CFOP" type="text" id="NFE_CFOP" size="10" maxlength="4" display="NFE / CFOP" secao="NFE" obrigatorio="0"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                     </cfif>
                        </td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto"><label style="vertical-align:top;">Pedido/Shipment:&nbsp;</label><textarea name="NFE_ORDEM_COMPRA" id="NFE_ORDEM_COMPRA" onKeyPress="if (this.value.length >= 160) return false;" onBlur="if (this.value.length > 160) this.value = this.value.substr(0, 160);" obrigatorio="0" display="NFE / PEDIDO/SHIPMENT" secao="NFE" cols="60" row="4" style="width: 500px; resize: none; height:45px;" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ></textarea></td>
                    </tr>
                    <tr>
                    	<td nowrap width="100%" class="texto">
                        	<fieldset id="fs_nfe_arquivo"><legend>Dados do Arquivo</legend>
                                <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                    <tr>
                                        <td width="8%" class="texto">Remetente:</td>
                                        <td width="20%" class="texto"><input type="text" name="REMETENTE_NFE" id="REMETENTE_NFE" readonly="readonly" maxlength="30" secao="NFE" display="NFE / REMETENTE DA NFE" style="width: 400px;" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                                        <td width="10%" class="texto" nowrap="nowrap">CPF/CNPJ Remetente:</td>
                                        <td width="50%" class="texto">
                                            <input type="text" name="CNPJ_REMETENTE_NFE" id="CNPJ_REMETENTE_NFE" readonly="readonly" maxlength="30" secao="NFE" display="NFE / REMETENTE DA NFE" style="width: 125px;" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td width="8%" class="texto">Destinat&aacute;rio:</td>
                                        <td width="20%" class="texto"><input type="text" name="DESTINATARIO_NFE" id="DESTINATARIO_NFE" readonly="readonly" maxlength="30" secao="NFE" display="NFE / DESTINATRIO DA NFE" style="width: 400px;" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                                        <td width="10%" class="texto" nowrap="nowrap">CPF/CNPJ Destinat&aacute;rio:</td>
                                        <td width="50%" class="texto">
                                            <input type="text" name="CNPJ_DESTINATARIO_NFE" id="CNPJ_DESTINATARIO_NFE" readonly="readonly" maxlength="30" secao="NFE" display="NFE / DESTINATRIO DA NFE" style="width: 125px;" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                                    </tr>

                                </table>
                            </fieldset>
                        </td>
                    </tr>
                    <tr>
                     	<td height="1" colspan="4" nowrap style="padding:0"><fieldset>
                         <legend>Mercadoria</legend>
                         <table width="100%" border="0" cellspacing="1" cellpadding="3">
                                  <tr>
                                    <td width="8%" class="texto">Volumes:</td>
                                    <td width="12%" class="texto"><input name="NFE_QTDE_VOLUME" type="text" id="NFE_QTDE_VOLUME" size="15" maxlength="10" obrigatorio="1" display="NFE / QUANTIDADE" tipo="numerico" secao="NFE" onkeypress="return f_formata_numero_decimal(this,event)"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                                    <td class="texto">Peso:
                                      <input name="NFE_PESO" type="text" id="NFE_PESO" size="10" maxlength="10" obrigatorio="1" display="NFE / PESO" tipo="numerico" secao="NFE" onkeypress="return f_formata_numero_decimal(this,event)" onchange="/*this.value = toCurrency(this.value);*/ f_calcula_peso_kg('NFE')"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                      <select name="NFE_COD_UNIDADE" id="NFE_COD_UNIDADE" fixo="1" manter="1" obrigatorio="1" display="NFE / UNIDADE" secao="NFE" onchange="f_calcula_peso_kg('NFE')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
                                                             <option value="Kg" selected="selected">Kilogramas</option>
                                      </select>
                                      <input name="NFE_M3" type="hidden" id="NFE_M3" value="0" fixo="1" />
                                      <input name="NFE_PESO_CUBADO" type="hidden" id="NFE_PESO_CUBADO" value="0" fixo="1" />
                                      <input name="NFE_PESO_KG_CONVERTIDO" type="hidden" id="NFE_PESO_KG_CONVERTIDO" size="10" maxlength="10" obrigatorio="0" display="NFE / PESO" tipo="numerico" secao="NFE"  /></td>
                                  </tr>
                                  <tr>
                                    <td nowrap class="texto">Natureza:</td>
                                    <td colspan="3" class="texto"><input type="text" name="NFE_NUM_NATUREZA" id="NFE_NUM_NATUREZA" maxlength="10" obrigatorio="1" tipo="numerico" secao="NFE" display="NFE / NATUREZA" onChange="f_busca_nota_natureza('NFE',1)" onKeyPress="return f_formata(this, '0000000000')" style="width: 50px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                        <span id="sp_NFE_natureza_restrita" style="display: none;">
                                            <select name="NFE_NATUREZA_COMBO" id="NFE_NATUREZA_COMBO" secao="NFE" display="NFE/ NATUREZA" onChange="f_busca_nota_natureza('NFE',2)" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
                                            </select>
                                        </span>
                                        <span id="sp_NFE_natureza_aberta">
                                            <input type="text" name="NFE_NATUREZA" id="NFE_NATUREZA" readonly secao="NFE" display="NFE / NATUREZA" style="width: 250px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />&nbsp;
                                            <button type="button" class="botao-16x16" onClick="NewWindow('../_localizar/localizar_natureza.cfm?num_natureza=NFE_NUM_NATUREZA&natureza=NFE_NATUREZA','_blank',600,400,'yes')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Natureza" title="Buscar Natureza" width="16" height="16" align="absmiddle" /></button>
                                        </span></td>
                                  </tr>
                                  <tr>
                                    <td class="texto">Esp&eacute;cie:</td>
                                    <td colspan="2" class="texto"><input name="NFE_NUM_ESPECIE" type="text" id="NFE_NUM_ESPECIE" style="width: 40px" onkeypress="return f_formata(this,event,'000000')" onchange="f_busca_especie('NFE')" obrigatorio="1" display="NFE / ESPECIE" secao="NFE"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                      <input name="NFE_ESPECIE" type="text" id="NFE_ESPECIE" readonly="true" style="width: 200px" obrigatorio="1" display="NFE / ESPECIE" secao="NFE"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                      <button type="button" class="botao-16x16" onclick="NewWindow('/_consultas/localizar_especie.cfm?num_ESPECIE=NFE_NUM_ESPECIE&ESPECIE=NFE_ESPECIE','_blank',600,400,'yes')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle" /></button></td>
                                  </tr>
                                  <tr>
                                    <td class="texto">Altura:</td>
                                    <td colspan="2" class="texto"><input name="NFE_ALTURA" type="text" id="NFE_ALTURA" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / ALTURA" obrigatorio="0" onchange="f_calcula_cubagem('NFE');" tipo="numerico" secao="NFE"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                      Comprimento:
                                        <input name="NFE_COMPRIMENTO" type="text" id="NFE_COMPRIMENTO" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / COMPRIMENTO" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('NFE');" secao="NFE"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                        Largura:
                                        <input name="NFE_LARGURA" type="text" id="NFE_LARGURA" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / LARGURA" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('NFE');" secao="NFE"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                        Cubagem:
                                    <input name="NFE_CUBAGEM" type="text" id="NFE_CUBAGEM" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / CUBAGEM" tipo="numerico" obrigatorio="0" secao="NFE" readonly="true"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                                  </tr>
                                  <tr>
                                    <td class="texto"><nobr>Peso Cobrado: </nobr> </td>
                                    <td colspan="2" class="texto"><input name="NFE_PESO_COBRADO" type="text" id="NFE_PESO_COBRADO" style="width: 90px" obrigatorio="1" display="NFE / PESO COBRADO" secao="NFE" onkeypress="return f_formata_numero_decimal(this,event)"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                      Kg</td>
                                  </tr>
                          </table></fieldset></td>
                   </tr>
                </table>
                <table width="100%" border="0" cellpadding="1" cellspacing="3">
                	<tr>
                        <td style="padding-top: 5px;" width="90%">
                            <table width="100%" border="0" cellpadding="1" cellspacing="3">
                            <tr><td>
                            <cfset lista_id = 'NFE'>
                            <cfset lista_campos = 'SOLICITACAO_CARGA_NF_ID,NFE_ID,CHAVE_ACESSO_NFE,NFE_VALOR,NFE_VALOR_SEGURADO,PIN_SUFRAMA_NFE,REMETENTE_NFE,CNPJ_REMETENTE_NFE,DESTINATARIO_NFE,'>
							<cfset lista_campos = lista_campos&'CNPJ_DESTINATARIO_NFE,NOME_ARQUIVO,NUMERO_NFE,MODELO_NFE,SERIE_NFE,DATA_EMISSAO_NFE,NFE_DOCUMENTO_ID,'>
                            <cfset lista_campos = lista_campos&'NFE_QTDE_VOLUME,NFE_PESO,NFE_COD_UNIDADE,NFE_M3,NFE_PESO_CUBADO,NFE_PESO_KG_CONVERTIDO,NFE_NUM_NATUREZA,'>
							<cfset lista_campos = lista_campos&'NFE_NATUREZA,NFE_NUM_ESPECIE,NFE_ESPECIE,NFE_NATUREZA_COMBO,'>
                            <cfset lista_campos = lista_campos&'NFE_ALTURA,NFE_COMPRIMENTO,NFE_LARGURA,NFE_CUBAGEM,NFE_PESO_COBRADO,NFE_ORDEM_COMPRA,NFE_XML,NFE_CFOP'>
                            <cfset lista_titulos = 'N Nota, Modelo, Srie,Data de Emisso,Chave de Acesso,Valor'>
                            <cfset lista_titulos_campos = "NUMERO_NFE,MODELO_NFE,SERIE_NFE,DATA_EMISSAO_NFE,CHAVE_ACESSO_NFE,NFE_VALOR">
                            <cfset lista_default = 0>
                            <cfset lista_titulos_tamanho = '10%,10%,10%,10%,40%,20%'>
                            <cfset lista_titulos_align = 'right,left,left,left,right,left'>
                            <cfset lista_campo_id = 'SOLICITACAO_CARGA_NF_ID'>
                            <cfset lista_campos_unique = 'CHAVE_ACESSO_NFE'>
                            <cfset lista_width = '100%'>
                            <cfset lista_height = '200'>
                            <cfinclude template="/_include/lista.cfm">
                            </script>
                            <script type="text/javascript">
								var v_num_especie_notas = '';
								var v_num_natureza_notas = '';
								var v_cod_unidade_notas = '';
								function f_on_incluir_NFE() {
									with(document.forms[0]) {
										NFE_ALTURA.value = 0;
										NFE_LARGURA.value = 0;
										NFE_COMPRIMENTO.value = 0;
										NFE_COMPRIMENTO.onchange();

										v_lista = f_listagem_NFE();
										if(v_lista.length > 0){
											NFE_NUM_NATUREZA.value = v_lista[0].NFE_NUM_NATUREZA;
											NFE_NUM_NATUREZA.onchange();
											NFE_NUM_ESPECIE.value = v_lista[0].NFE_NUM_ESPECIE;
											NFE_NUM_ESPECIE.onchange();
										}

										NFE_QTDE_VOLUME.value = 1;
										f_valor_segurado_automatico('NFE', 0);
									}
								}
								function f_on_salva_lista_NFE() {
									with(document.forms[0]) {
										v_lista = f_listagem_NFE();
										if(v_lista.length > 0){
											NUM_NATUREZA.value = v_lista[0].NFE_NUM_NATUREZA;
											NUM_NATUREZA.onchange();
											NUM_ESPECIE.value = v_lista[0].NFE_NUM_ESPECIE;
											NUM_ESPECIE.onchange();
										}

										VALOR_TOTAL_NF.value = toCurrency(f_total_campo_NFE('NFE_VALOR'));

										if(Number(VALOR_TOTAL_SUGERIDO.value) < Number(VALOR_TOTAL_NF.value)) {
											VALOR_TOTAL_SUGERIDO.value = VALOR_TOTAL_NF.value;
										}
									}
								}
								function f_before_salvar_NFE() {
									with(document.forms[0]) {
										if(f_ajax_running() > 0 && v_inserida == 0) {
											alert('Aguarde o trmino do processamento antes de salvar.');
											return false;
										}
										if(NFE_NUM_ESPECIE.value && !NFE_ESPECIE.value && !NFE_ESPECIE_COMBO.value) {
											alert('A espcie selecionada no  vlida!');
											return false;
										}
										if(NFE_NUM_NATUREZA.value && !NFE_NATUREZA.value && !NFE_NATUREZA_COMBO.value) {
											alert('A natureza selecionada no  vlida!');
											return false;
										}
										if(Number(CHAVE_ACESSO_NFE.value.length) != 44) {
											alert('A Chave de Acesso da NFE no  vlida.');
											return false;
										}
										<cfif IsDefined("v_valida_valor_segurado") and v_valida_valor_segurado eq 1>
										if(Number(NFE_VALOR.value) > Number(NFE_VALOR_SEGURADO.value)) {
											alert('O Valor Segurado (R$ '+ Number(NFE_VALOR_SEGURADO.value).toFixed(2) +') da nota fiscal ' + NUMERO_NFE.value + '/' + SERIE_NFE.value + ' deve ser maior ou igual ao valor da mesma (R$ '+ Number(NFE_VALOR.value).toFixed(2) +').');
											NFE_VALOR_SEGURADO.focus();
											return false;
										}
										</cfif>
										set_pedido_shipment(NFE_ORDEM_COMPRA.value);
										return true;
									}
								}
							</script>
                            </td>
                            </tr>
                            </table>
                        </td>
                    </tr>
                </table>
        	</fieldset>
    	</td>
	</tr>
</table>

<table width="90%" border="0" cellpadding="1" cellspacing="0">
	<tr>
    	<td width="90%">
        	<fieldset id="fs_outros" style="display:none" disabled="true"><legend>Outros Documentos</legend>
                <table border="0" cellpadding="1" cellspacing="3">
                    <tr>
                        <td width="1%" nowrap class="texto">N&uacute;mero:</td>
                        <td width="1%" nowrap class="texto">
                        <input type="hidden" name="OUTROS_ID" id="OUTROS_ID" />
                        <input type="text" name="OUTROS_NUMERO" id="OUTROS_NUMERO" maxlength="20" obrigatorio="1" secao="OUTROS" display="NMERO DO DOCUMENTO" style="width: 85px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                        &nbsp;Data de Emiss&atilde;o:
                        <input type="text" name="OUTROS_DATA_EMISSAO" id="OUTROS_DATA_EMISSAO" maxlength="10" obrigatorio="1" tipo="data" secao="OUTROS" display="OUTROS DOCUMENTOS / DATA DE EMISSO" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 85px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                            <button type="button" id="BTN_OUTROS_DATA_EMISSAO" class="botao-16x16" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
                            <script type="text/javascript">
                                Calendar.setup( {
                                    inputField  : "OUTROS_DATA_EMISSAO",      // ID of the input field
                                    ifFormat    : "%d/%m/%Y",               // the date format
                                    button      : "BTN_OUTROS_DATA_EMISSAO",  // ID of the button
                                    range       : [2001,2050]
                                } );
                            </script>
                        &nbsp;Valor do Documento:
                    	<input type="text" name="OUTROS_VALOR" id="OUTROS_VALOR" maxlength="15" obrigatorio="1" tipo="numerico" secao="OUTROS" display="OUTROS DOCUMENTOS / VALOR" onChange="this.value = Number(this.value).toFixed(2); this.form.NOTA_VALOR_SEGURADO.value = this.value;" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 94px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                    <tr>
                        <td class="texto">Descri&ccedil;&atilde;o:</td>
                        <td width="90%" class="texto"><input type="text" name="OUTROS_DESCRICAO" id="OUTROS_DESCRICAO" obrigatorio="1" secao="OUTROS" display="OUTROS DOCUMENTOS / DESCRIO DO DOCUMENTO" style="width: 500px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                    </tr>
                    <tr>
                       <td class="texto"><label style="vertical-align:top;">Pedido/Shipment:</label></td>
                       <td class="texto">
     				      <textarea name="OUTROS_ORDEM_COMPRA" id="OUTROS_ORDEM_COMPRA" onKeyPress="if (this.value.length >= 160) return false;" onBlur="if (this.value.length > 160) this.value = this.value.substr(0, 160);" obrigatorio="0" display="OUTROS DOCUMENTOS / PEDIDO/SHIPMENT" secao="OUTROS" cols="60" row="4" style="width: 500px; resize: none; height:45px;" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ></textarea>
                       </td>
                    </tr>
                    <tr>
                     	<td height="1" colspan="4" nowrap style="padding:0"><fieldset>
                         <legend>Mercadoria</legend>
                         <table width="100%" border="0" cellspacing="1" cellpadding="3">
                                  <tr>
                                    <td width="8%" class="texto">Volumes:</td>
                                    <td width="12%" class="texto"><input name="OUTROS_QTDE_VOLUME" type="text" id="OUTROS_QTDE_VOLUME" size="15" maxlength="10" obrigatorio="1" display="OUTROS DOCUMENTOS / QUANTIDADE" tipo="numerico" secao="OUTROS" onkeypress="return f_formata_numero_decimal(this,event)"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                                    <td class="texto">Peso:
                                      <input name="OUTROS_PESO" type="text" id="OUTROS_PESO" size="10" maxlength="10" obrigatorio="1" display="OUTROS DOCUMENTOS / PESO" tipo="numerico" secao="OUTROS" onkeypress="return f_formata_numero_decimal(this,event)" onchange="/*this.value = toCurrency(this.value);*/ f_calcula_peso_kg('OUTROS')"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                      <select name="OUTROS_COD_UNIDADE" id="OUTROS_COD_UNIDADE" fixo="1" manter="1" obrigatorio="1" display="OUTROS DOCUMENTOS / UNIDADE" secao="OUTROS" onchange="f_calcula_peso_kg('OUTROS')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
                                                             <option value="Kg" selected="selected">Kilogramas</option>
                                      </select>
                                      <input name="OUTROS_M3" type="hidden" id="OUTROS_M3" value="0" fixo="1" />
                                      <input name="OUTROS_PESO_CUBADO" type="hidden" id="OUTROS_PESO_CUBADO" value="0" fixo="1" />
                                      <input name="OUTROS_PESO_KG_CONVERTIDO" type="hidden" id="OUTROS_PESO_KG_CONVERTIDO" size="10" maxlength="10" obrigatorio="0" display="OUTROS DOCUMENTOS / PESO" tipo="numerico" secao="OUTROS"  /></td>
                                  </tr>
                                  <tr>
                                    <td nowrap class="texto">Natureza:</td>
                                    <td colspan="3" class="texto"><input type="text" name="OUTROS_NUM_NATUREZA" id="OUTROS_NUM_NATUREZA" maxlength="10" obrigatorio="1" tipo="numerico" secao="OUTROS" display="OUTROS / NATUREZA" onChange="f_busca_nota_natureza('OUTROS',1)" onKeyPress="return f_formata(this, '0000000000')" style="width: 50px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                        <span id="sp_OUTROS_natureza_restrita" style="display: none;">
                                            <select name="OUTROS_NATUREZA_COMBO" id="OUTROS_NATUREZA_COMBO" secao="OUTROS" display="OUTROS / NATUREZA" onChange="f_busca_nota_natureza('OUTROS',2)" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> >
                                            </select>
                                        </span>
                                        <span id="sp_OUTROS_natureza_aberta">
                                            <input type="text" name="OUTROS_NATUREZA" id="OUTROS_NATUREZA" readonly secao="OUTROS" display="OUTROS / NATUREZA" style="width: 250px;"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />&nbsp;
                                            <button type="button" class="botao-16x16" onClick="NewWindow('../_localizar/localizar_natureza.cfm?num_natureza=OUTROS_NUM_NATUREZA&natureza=OUTROS_NATUREZA','_blank',600,400,'yes')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Natureza" title="Buscar Natureza" width="16" height="16" align="absmiddle" /></button>
                                        </span></td>
                                  </tr>
                                  <tr>
                                    <td class="texto">Esp&eacute;cie:</td>
                                    <td colspan="2" class="texto"><input name="OUTROS_NUM_ESPECIE" type="text" id="OUTROS_NUM_ESPECIE" style="width: 40px" onkeypress="return f_formata(this,event,'000000')" onchange="f_busca_especie('OUTROS')" obrigatorio="1" display="OUTROS DOCUMENTOS / ESPECIE" secao="OUTROS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                      <input name="OUTROS_ESPECIE" type="text" id="OUTROS_ESPECIE" readonly="true" style="width: 200px" obrigatorio="1" display="OUTROS DOCUMENTOS / ESPECIE" secao="OUTROS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                      <button type="button" class="botao-16x16" onclick="NewWindow('/_consultas/localizar_especie.cfm?num_ESPECIE=OUTROS_NUM_ESPECIE&ESPECIE=OUTROS_ESPECIE','_blank',600,400,'yes')" <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> ><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle" /></button></td>
                                  </tr>
                                  <tr>
                                    <td class="texto">Altura:</td>
                                    <td colspan="2" class="texto"><input name="OUTROS_ALTURA" type="text" id="OUTROS_ALTURA" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / ALTURA" obrigatorio="0" onchange="f_calcula_cubagem('OUTROS');" tipo="numerico" secao="OUTROS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                      Comprimento:
                                        <input name="OUTROS_COMPRIMENTO" type="text" id="OUTROS_COMPRIMENTO" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / COMPRIMENTO" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('OUTROS');" secao="OUTROS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                        Largura:
                                        <input name="OUTROS_LARGURA" type="text" id="OUTROS_LARGURA" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / LARGURA" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('OUTROS');" secao="OUTROS"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                        Cubagem:
                                    <input name="OUTROS_CUBAGEM" type="text" id="OUTROS_CUBAGEM" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / CUBAGEM" tipo="numerico" obrigatorio="0" secao="OUTROS" readonly="true"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> /></td>
                                  </tr>
                                  <tr>
                                    <td class="texto"><nobr>Peso Cobrado: </nobr> </td>
                                    <td colspan="2" class="texto"><input name="OUTROS_PESO_COBRADO" type="text" id="OUTROS_PESO_COBRADO" style="width: 90px" obrigatorio="1" display="OUTROS DOCUMENTOS / PESO COBRADO" secao="OUTROS" onkeypress="return f_formata_numero_decimal(this,event)"  <cfif "#vars.TERCEIRIZADO#" eq 1 > ativo="0" terceirizado="1"</cfif> />
                                      Kg</td>
                                  </tr>
                          </table></fieldset></td>
                   </tr>
                </table>
                <table width="90%" border="0" cellpadding="1" cellspacing="3">
                	<tr>
                        <td style="padding-top: 5px;" width="90%">
                            <table width="90%" border="0" cellpadding="1" cellspacing="3">
                            <tr><td>
                            <cfset lista_id = 'OUTROS'>
                            <cfset lista_campos = 'SOLICITACAO_CARGA_NF_ID,OUTROS_ID,OUTROS_NUMERO,OUTROS_DATA_EMISSAO,OUTROS_DESCRICAO,OUTROS_VALOR,OUTROS_QTDE_VOLUME,OUTROS_PESO,'>
                            <cfset lista_campos = lista_campos&'OUTROS_COD_UNIDADE,OUTROS_M3,OUTROS_PESO_CUBADO,OUTROS_PESO_KG_CONVERTIDO,OUTROS_NUM_NATUREZA,'>
							<cfset lista_campos = lista_campos&'OUTROS_NATUREZA,OUTROS_NATUREZA_COMBO,OUTROS_NUM_ESPECIE,OUTROS_ESPECIE,'>
                            <cfset lista_campos = lista_campos&'OUTROS_ALTURA,OUTROS_COMPRIMENTO,OUTROS_LARGURA,OUTROS_CUBAGEM,OUTROS_PESO_COBRADO,OUTROS_ORDEM_COMPRA,TIPO_DOC_OUTROS'>
							<cfset lista_titulos = 'N&ordm; do Documento,Data de Emiss&atilde;o,Descri&ccedil;&atilde;o,Valor,Tipo Doc. Outros'>
                            <cfset lista_titulos_campos = "OUTROS_NUMERO,OUTROS_DATA_EMISSAO,OUTROS_DESCRICAO,OUTROS_VALOR,TIPO_DOC_OUTROS">
                            <cfset lista_default = 0>
                            <cfset lista_titulos_tamanho = '10%,10%,60%,10%,10%'>
                            <cfset lista_titulos_align = 'right,right,left,right,left'>
                            <cfset lista_campo_id = 'SOLICITACAO_CARGA_NF_ID'>
                            <cfset lista_width = '100%'>
                            <cfset lista_height = '200'>
                            <cfinclude template="/_include/lista.cfm">
                            </script>
                            <script type="text/javascript">
								var v_num_especie_notas = '';
								var v_num_natureza_notas = '';
								var v_cod_unidade_notas = '';
								function f_on_incluir_OUTROS() {
									with(document.forms[0]) {
										OUTROS_ALTURA.value = 0;
										OUTROS_LARGURA.value = 0;
										OUTROS_COMPRIMENTO.value = 0;
										OUTROS_COMPRIMENTO.onchange();
										OUTROS_NUM_ESPECIE.value = v_num_especie_notas;
										OUTROS_NUM_ESPECIE.onchange();
										OUTROS_NUM_NATUREZA.value = v_num_natureza_notas;
										OUTROS_NUM_NATUREZA.onchange();
										OUTROS_QTDE_VOLUME.value = 1;
									}
								}
								function f_on_salva_lista_OUTROS() {
									with(document.forms[0]) {
										v_lista = f_listagem_OUTROS();
										if(v_lista.length > 0){
											NUM_NATUREZA.value = v_lista[0].OUTROS_NUM_NATUREZA;
											NUM_NATUREZA.onchange();
											NUM_ESPECIE.value = v_lista[0].OUTROS_NUM_ESPECIE;
											NUM_ESPECIE.onchange();
										}

										VALOR_TOTAL_NF.value = toCurrency(f_total_campo_OUTROS('OUTROS_VALOR'));

										if(Number(VALOR_TOTAL_SUGERIDO.value) < Number(VALOR_TOTAL_NF.value)) {
											VALOR_TOTAL_SUGERIDO.value = VALOR_TOTAL_NF.value;
										}
									}
								}
								function f_before_salvar_OUTROS() {
									with(document.forms[0]) {
										if(f_ajax_running() > 0 && v_inserida == 0) {
											alert('Aguarde o trmino do processamento antes de salvar.');
											return false;
										}
										if(OUTROS_NUM_ESPECIE.value && !OUTROS_ESPECIE.value && !OUTROS_ESPECIE_COMBO.value) {
											alert('A espcie selecionada no  vlida!');
											return false;
										}
										if(OUTROS_NUM_NATUREZA.value && !OUTROS_NATUREZA.value && !OUTROS_NATUREZA_COMBO.value) {
											alert('A natureza selecionada no  vlida!');
											return false;
										}
										set_pedido_shipment(OUTROS_ORDEM_COMPRA.value);
										return true;
									}
								}
							</script>
                            </td>
                            </tr>
                            </table>
                        </td>
                    </tr>
                </table>
        	</fieldset>
    	</td>
	</tr>
</table>
<script>
Calendar.setup(
    {
      inputField  : "NOTA_DATA_EMISSAO",      // ID of the input field
      ifFormat    :    "%d/%m/%Y",    // the date format
      button      : "trigger",    // ID of the button
	  range       : [2001,2050]
    }
  );
  with(document.forms[0]){
      <cfif "#vars.TERCEIRIZADO#" eq 1 >
		  btn_lista_incluir_NFE.setAttribute("ativo", "0");
		  btn_lista_excluir_NFE.setAttribute("ativo", "0");
		  btn_lista_salvar_NFE.setAttribute("ativo", "0");
		  btn_lista_cancelar_NFE.setAttribute("ativo", "0");
		  btn_lista_incluir_NOTAS_FISCAIS.setAttribute("ativo", "0");
		  btn_lista_excluir_NOTAS_FISCAIS.setAttribute("ativo", "0");
		  btn_lista_salvar_NOTAS_FISCAIS.setAttribute("ativo", "0");
		  btn_lista_cancelar_NOTAS_FISCAIS.setAttribute("ativo", "0");
		  btn_lista_incluir_OUTROS.setAttribute("ativo", "0");
		  btn_lista_excluir_OUTROS.setAttribute("ativo", "0");
		  btn_lista_salvar_OUTROS.setAttribute("ativo", "0");
		  btn_lista_cancelar_OUTROS.setAttribute("ativo", "0");
	  </cfif>
  }

</script>
