<cfif isDefined("vars.CONSULTA")>
	<cfswitch expression="#vars.CONSULTA#">
    	<cfcase value="1">
			<cfscript>
                conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_solicitacao");
                qrSolicitacao    = conn.get_solicitacao_carga(solicitacao_carga_id = vars.SOLICITACAO_CARGA_ID);
				qrComposicao	 = conn.get_solicitacao_carga_composicao(solicitacao_carga_id = vars.SOLICITACAO_CARGA_ID);
				qrSolicitacaoNF	 = conn.get_solicitacao_carga_nf(solicitacao_carga_id = vars.SOLICITACAO_CARGA_ID);
                qrCummins		 = conn.get_solicitacao_carga_cummins(solicitacao_carga_id = vars.SOLICITACAO_CARGA_ID);																	  
				v_nfe_cfop_obrigatorio = conn.get_parametro(identificador = 'M309-P0182');
				
				conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_operacao");
				qrNatureza 		 = conn.get_operacao_natureza(operacao_id = qrSolicitacao.OPERACAO_ID);
				qrRemetente 	 = conn.get_operacao_cliente(operacao_id = qrSolicitacao.OPERACAO_ID, tipo_cliente = 0);
				qrDestinatario   = conn.get_operacao_cliente(operacao_id = qrSolicitacao.OPERACAO_ID, tipo_cliente = 1);
				qrConsignatario  = conn.get_operacao_cliente(operacao_id = qrSolicitacao.OPERACAO_ID, tipo_cliente = 2);
				qrRedespacho	 = conn.get_operacao_cliente(operacao_id = qrSolicitacao.OPERACAO_ID, tipo_cliente = 3);
				qrCobranca 		 = conn.get_operacao_cliente(operacao_id = qrSolicitacao.OPERACAO_ID, tipo_cliente = 4);
				qrOrigem 		 = conn.get_operacao_municipio(operacao_id = qrSolicitacao.OPERACAO_ID, origem_destino = 0);
				qrDestino 		 = conn.get_operacao_municipio(operacao_id = qrSolicitacao.OPERACAO_ID, origem_destino = 1);
				qrLote 		     = conn.get_operacao_lote(operacao_id = qrSolicitacao.OPERACAO_ID, lote_id = qrSolicitacao.LOTE_ID);
				qrOperacao 		 = conn.get_operacao(operacao_id = qrSolicitacao.OPERACAO_ID);
				conn 		 = CreateComponent("_transportes.consulta.transporte.cfc_repom");
				qrDadosRepom = conn.get_dados_cartao(solicitacao_carga_id = vars.SOLICITACAO_CARGA_ID);
				connG = CreateComponent("_transportes.consulta.cfc_global");											 
				v_crt_obrigatorio_intc = connG.get_parametro_valor(cod_projeto        = 25, 
																	  cod_aplicacao      = 'FISCAL.EXE',
																	  parametro_id       = 6,
																	  parametro_grupo_id = 44);		
            </cfscript>
            <cfif qrSolicitacao.RecordCount gt 0>
                <script type="text/javascript">
                    with(parent.document.form_transportes) {
						parent.f_limpar_NOTAS_FISCAIS();
						parent.f_limpar_NFE();
						parent.f_limpar_OUTROS();
						
						SITUACAO_ID.value = '<cfoutput>#JSStringFormat(qrSolicitacao.SITUACAO_ID)#</cfoutput>';
						COD_ORGANOGRAMA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_ORGANOGRAMA)#</cfoutput>';
						COD_MOTORISTA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_MOTORISTA)#</cfoutput>';
						OPERACAO_ID.value = '<cfoutput>#JSStringFormat(qrSolicitacao.OPERACAO_ID)#</cfoutput>';
						OPERACAO_DESCRICAO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.OPERACAO)#</cfoutput>';
						TIPO_PAGAMENTO_ID.value = '<cfoutput>#JSStringFormat(qrOperacao.TIPO_PAGAMENTO_ID)#</cfoutput>';
						POSSUI_REPOM.value = '<cfoutput>#JSStringFormat(qrOperacao.POSSUI_REPOM)#</cfoutput>';
						PRIORIDADE.value = '<cfoutput>#JSStringFormat(qrSolicitacao.PRIORIDADE_ID)#</cfoutput>';
						CARGA_CONSOLIDADA_ID.value = '<cfoutput>#JSStringFormat(qrSolicitacao.CARGA_CONSOLIDADA_ID)#</cfoutput>';
						POSSUI_MOVTO_CONTAINER.value = '<cfoutput>#JSStringFormat(qrSolicitacao.POSSUI_MOVTO_CONTAINER)#</cfoutput>';
						NUM_ROMANEIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.NUM_ROMANEIO)#</cfoutput>';

						FRACIONADO.value = '<cfoutput>#qrOperacao.FRACIONADO#</cfoutput>';
						CONTROLA_CONTAINER.value = '<cfoutput>#qrOperacao.CONTROLA_CONTAINER#</cfoutput>';
						CONTROLA_CONTAINER_CG_DIRETA.value = '<cfoutput>#qrOperacao.CONTROLA_CONTAINER_CG_DIRETA#</cfoutput>';	
						CONTAINER_VAZIO.value = '<cfoutput>#qrSolicitacao.CONTAINER_VAZIO#</cfoutput>';
						COD_TRANSPORTADOR_SUGERIDO.value = '<cfoutput>#qrSolicitacao.COD_TRANSPORTADOR_SUGERIDO#</cfoutput>';
						parent.f_busca_container('<cfoutput>#qrSolicitacao.CONTAINER#</cfoutput>');

						
						
						<!--- CRT --->
						<cfif qrOperacao.INTERNACIONAL eq 1>		
							parent.document.getElementById('tr_internacional').style.display = '';		
							parent.document.getElementById('NUM_CRT_COMPLETO').value = '<cfoutput>#qrSolicitacao.NUM_CRT_COMPLETO#</cfoutput>';		
							<cfif v_crt_obrigatorio_intc eq 1>
								parent.document.getElementById('NUM_CRT_COMPLETO').setAttribute('obrigatorio',1);
								parent.document.getElementById('NUM_CRT_COMPLETO').className = 'requerido_form';
							<cfelse>
								parent.document.getElementById('NUM_CRT_COMPLETO').setAttribute('obrigatorio',0);
								parent.document.getElementById('NUM_CRT_COMPLETO').className = '';						
							</cfif>
						<cfelse>						
							parent.document.getElementById('tr_internacional').style.display = 'none';								
							parent.document.getElementById('NUM_CRT_COMPLETO').setAttribute('obrigatorio',0);
							parent.document.getElementById('NUM_CRT_COMPLETO').className = '';
						</cfif>
						
						<!--- Natureza --->
						parent.f_limpa_select(NATUREZA_COMBO);
						parent.f_limpa_select(NOTA_NATUREZA_COMBO);
						parent.f_limpa_select(NFE_NATUREZA_COMBO);
						parent.f_limpa_select(OUTROS_NATUREZA_COMBO);
						
						<cfif vars.TERCEIRIZADO eq 0>
							NUM_NATUREZA.readOnly = false;
							NATUREZA_COMBO.disabled = false;
							NOTA_NUM_NATUREZA.readOnly = false;
							NOTA_NATUREZA_COMBO.disabled = false;
							NFE_NUM_NATUREZA.readOnly = false;
							NFE_NATUREZA_COMBO.disabled = false;
							OUTROS_NUM_NATUREZA.readOnly = false;
							OUTROS_NATUREZA_COMBO.disabled = false;
						</cfif>
						
						<cfif qrNatureza.RecordCount gt 0>
							// Naturezas restritas
							parent.document.getElementById('sp_natureza_restrita').style.display = '';
							parent.document.getElementById('sp_natureza_aberta').style.display = 'none';
															
							parent.document.getElementById('sp_NOTA_natureza_restrita').style.display = '';
							parent.document.getElementById('sp_NOTA_natureza_aberta').style.display = 'none';
							parent.document.getElementById('sp_NFE_natureza_restrita').style.display = '';
							parent.document.getElementById('sp_NFE_natureza_aberta').style.display = 'none';
							parent.document.getElementById('sp_OUTROS_natureza_restrita').style.display = '';
							parent.document.getElementById('sp_OUTROS_natureza_aberta').style.display = 'none';
							
							<cfif qrNatureza.RecordCount gt 1>
								v_opt = parent.f_cria_option('', '-- Selecione --', NATUREZA_COMBO);
								v_opt.setAttribute('peso_especifico', '');
								
								v_opt = parent.f_cria_option('', '-- Selecione --', NOTA_NATUREZA_COMBO);
								v_opt = parent.f_cria_option('', '-- Selecione --', NFE_NATUREZA_COMBO);
								v_opt = parent.f_cria_option('', '-- Selecione --', OUTROS_NATUREZA_COMBO);
								
								
							<cfelse>
								NUM_NATUREZA.readOnly = true;
								NATUREZA_COMBO.disabled = true;
								
								NOTA_NUM_NATUREZA.readOnly = true;
								NOTA_NATUREZA_COMBO.disabled = true;
								
								NFE_NUM_NATUREZA.readOnly = true;
								NFE_NATUREZA_COMBO.disabled = true;
								
								OUTROS_NUM_NATUREZA.readOnly = true;
								OUTROS_NATUREZA_COMBO.disabled = true;
							</cfif>
							
							<cfoutput query="qrNatureza">
								v_opt = parent.f_cria_option('#JSStringFormat(qrNatureza.NUM_NATUREZA)#', '#JSStringFormat(qrNatureza.NUM_NATUREZA)#-#JSStringFormat(qrNatureza.NATUREZA)#', NATUREZA_COMBO);
								v_opt.setAttribute('peso_especifico', '#JSStringFormat(qrNatureza.PESO_ESPECIFICO)#');
								
								v_opt = parent.f_cria_option('#JSStringFormat(qrNatureza.NUM_NATUREZA)#', '#JSStringFormat(qrNatureza.NUM_NATUREZA)#-#JSStringFormat(qrNatureza.NATUREZA)#', NOTA_NATUREZA_COMBO);
								v_opt = parent.f_cria_option('#JSStringFormat(qrNatureza.NUM_NATUREZA)#', '#JSStringFormat(qrNatureza.NUM_NATUREZA)#-#JSStringFormat(qrNatureza.NATUREZA)#', NFE_NATUREZA_COMBO);
								v_opt = parent.f_cria_option('#JSStringFormat(qrNatureza.NUM_NATUREZA)#', '#JSStringFormat(qrNatureza.NUM_NATUREZA)#-#JSStringFormat(qrNatureza.NATUREZA)#', OUTROS_NATUREZA_COMBO);
							</cfoutput>
							
							NATUREZA_COMBO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.NUM_NATUREZA)#</cfoutput>';
							NOTA_NATUREZA_COMBO.onchange();
							NFE_NATUREZA_COMBO.onchange();
							OUTROS_NATUREZA_COMBO.onchange();														
						<cfelse>
							// Natureza aberta
							parent.document.getElementById('sp_natureza_restrita').style.display = 'none';
							parent.document.getElementById('sp_natureza_aberta').style.display = '';
							
							parent.document.getElementById('sp_NOTA_natureza_restrita').style.display = 'none';
							parent.document.getElementById('sp_NOTA_natureza_aberta').style.display = '';
							parent.document.getElementById('sp_NFE_natureza_restrita').style.display = 'none';
							parent.document.getElementById('sp_NFE_natureza_aberta').style.display = '';
							parent.document.getElementById('sp_OUTROS_natureza_restrita').style.display = 'none';
							parent.document.getElementById('sp_OUTROS_natureza_aberta').style.display = '';
							
							NATUREZA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.NATUREZA)#</cfoutput>';
						</cfif>
						
						NUM_NATUREZA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.NUM_NATUREZA)#</cfoutput>';
						
						<!--- Remetente --->
						parent.f_limpa_select(NOME_REMETENTE_COMBO);
						<cfif vars.TERCEIRIZADO eq 0>
							CNPJ_CPF_REMETENTE.readOnly = false;
						</cfif>
						
						<cfif vars.CUMMINS eq 1>
							<cfif qrCummins.RecordCount gt 0>
								CUMMINS_BU.value = '<cfoutput>#JSStringFormat(qrCummins.BU)#</cfoutput>';
								CUMMINS_CCUSTO.value = '<cfoutput>#JSStringFormat(qrCummins.CENTRO_CUSTO)#</cfoutput>';
								CUMMINS_MOTIVO.value = '<cfoutput>#JSStringFormat(qrCummins.MOTIVO)#</cfoutput>';
							</cfif>							
						</cfif>
						
						<cfif qrRemetente.RecordCount gt 0>
							// Remetente restritos
							parent.document.getElementById('sp_remetente_restrita').style.display = '';
							parent.document.getElementById('sp_remetente_aberta').style.display = 'none';
							
							<cfif qrRemetente.RecordCount gt 1>
								v_opt = parent.f_cria_option('', '-- Selecione --', NOME_REMETENTE_COMBO);
								v_opt.setAttribute('cnpj_cpf', '');
								v_opt.setAttribute('endereco', '');
								v_opt.setAttribute('municipio_id', '');
								v_opt.setAttribute('municipio_uf', '');
							<cfelse>
								CNPJ_CPF_REMETENTE.readOnly = true;
							</cfif>
							
							<cfoutput query="qrRemetente">
								v_opt = parent.f_cria_option('#qrRemetente.COD_PESSOA#', '#JSStringFormat(qrRemetente.CLIENTE)#', NOME_REMETENTE_COMBO);
								v_opt.setAttribute('cnpj_cpf', '#JSStringFormat(qrRemetente.CNPJ_CPF)#');
								v_opt.setAttribute('endereco', '#JSStringFormat(qrRemetente.ENDERECO)#');
								v_opt.setAttribute('municipio_id', '#JSStringFormat(qrRemetente.MUNICIPIO_ID)#');
								v_opt.setAttribute('municipio_uf', '#JSStringFormat(qrRemetente.MUNICIPIO_UF)#');
							</cfoutput>
							
							NOME_REMETENTE.value = '';
							NOME_REMETENTE_COMBO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_REMETENTE)#</cfoutput>';
							
						<cfelse>
							// Remetente aberto
							parent.document.getElementById('sp_remetente_restrita').style.display = 'none';
							parent.document.getElementById('sp_remetente_aberta').style.display = '';
							
							NOME_REMETENTE.value = '<cfoutput>#JSStringFormat(qrSolicitacao.REMETENTE)#</cfoutput>';
						</cfif>
						
						COD_REMETENTE.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_REMETENTE)#</cfoutput>';
						CNPJ_CPF_REMETENTE.value = '<cfoutput>#JSStringFormat(qrSolicitacao.REM_CNPJ_CPF)#</cfoutput>';
						CNPJ_CPF_REMETENTE_OLD.value = '<cfoutput>#JSStringFormat(qrSolicitacao.REM_CNPJ_CPF)#</cfoutput>';						
		                COD_ENDERECO_REMETENTE.value = '<cfoutput>#JSStringFormat(qrSolicitacao.ENDERECO_REMETENTE_ID)#</cfoutput>';
						CNPJ_CPF_REMETENTE.onchange();
						ENDERECO_REMETENTE.value = '<cfoutput>#JSStringFormat(qrSolicitacao.REM_ENDERECO)#</cfoutput>';
						parent.document.getElementById("NOME_REMETENTE_COMBO").onchange;
						<!--- Destinatrio --->
						parent.f_limpa_select(NOME_DESTINATARIO_COMBO);
						<cfif vars.TERCEIRIZADO eq 0>
							CNPJ_CPF_DESTINATARIO.readOnly = false;
						</cfif>
						
						<cfif qrDestinatario.RecordCount gt 0>
							// Destinatrios restritos
							parent.document.getElementById('sp_destinatario_restrita').style.display = '';
							parent.document.getElementById('sp_destinatario_aberta').style.display = 'none';
							
							<cfif qrDestinatario.RecordCount gt 1>
								v_opt = parent.f_cria_option('', '-- Selecione --', NOME_DESTINATARIO_COMBO);
								v_opt.setAttribute('cnpj_cpf', '');
								v_opt.setAttribute('endereco', '');
								v_opt.setAttribute('municipio_id', '');
								v_opt.setAttribute('municipio_uf', '');
							<cfelse>
								CNPJ_CPF_DESTINATARIO.readOnly = true;
							</cfif>
							
							<cfoutput query="qrDestinatario">
								v_opt = parent.f_cria_option('#qrDestinatario.COD_PESSOA#', '#JSStringFormat(qrDestinatario.CLIENTE)#', NOME_DESTINATARIO_COMBO);
								v_opt.setAttribute('cnpj_cpf', '#JSStringFormat(qrDestinatario.CNPJ_CPF)#');
								v_opt.setAttribute('endereco', '#JSStringFormat(qrDestinatario.ENDERECO)#');
								v_opt.setAttribute('municipio_id', '#JSStringFormat(qrDestinatario.MUNICIPIO_ID)#');
								v_opt.setAttribute('municipio_uf', '#JSStringFormat(qrDestinatario.MUNICIPIO_UF)#');
							</cfoutput>
							
							NOME_DESTINATARIO.value = '';
							NOME_DESTINATARIO_COMBO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_DESTINATARIO)#</cfoutput>';
						<cfelse>
							// Destinatrio aberto
							parent.document.getElementById('sp_destinatario_restrita').style.display = 'none';
							parent.document.getElementById('sp_destinatario_aberta').style.display = '';
							
							NOME_DESTINATARIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DESTINATARIO)#</cfoutput>';
						</cfif>
						
						COD_DESTINATARIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_DESTINATARIO)#</cfoutput>';
						CNPJ_CPF_DESTINATARIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DEST_CNPJ_CPF)#</cfoutput>';
						CNPJ_CPF_DESTINATARIO_OLD.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DEST_CNPJ_CPF)#</cfoutput>';						
		                COD_ENDERECO_DESTINATARIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.ENDERECO_DESTINATARIO_ID)#</cfoutput>';						
						CNPJ_CPF_DESTINATARIO.onchange();
						ENDERECO_DESTINATARIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DEST_ENDERECO)#</cfoutput>';
						
						<!--- Consignatrio --->
						parent.f_limpa_select(NOME_CONSIGNATARIO_COMBO);
						<cfif vars.TERCEIRIZADO eq 0>
							CNPJ_CPF_CONSIGNATARIO.readOnly = false;
						</cfif>
						
						<cfif qrConsignatario.RecordCount gt 0>
							// Consignatrios restritos
							parent.document.getElementById('sp_consignatario_restrita').style.display = '';
							parent.document.getElementById('sp_consignatario_aberta').style.display = 'none';
							
							<cfif qrConsignatario.RecordCount gt 1>
								v_opt = parent.f_cria_option('', '-- Selecione --', NOME_CONSIGNATARIO_COMBO);
								v_opt.setAttribute('cnpj_cpf', '');
								v_opt.setAttribute('endereco', '');
							<cfelse>
								CNPJ_CPF_CONSIGNATARIO.readOnly = true;
							</cfif>
							
							<cfoutput query="qrConsignatario">
								v_opt = parent.f_cria_option('#qrConsignatario.COD_PESSOA#', '#JSStringFormat(qrConsignatario.CLIENTE)#', NOME_CONSIGNATARIO_COMBO);
								v_opt.setAttribute('cnpj_cpf', '#JSStringFormat(qrConsignatario.CNPJ_CPF)#');
								v_opt.setAttribute('endereco', '#JSStringFormat(qrConsignatario.ENDERECO)#');
								v_opt.setAttribute('municipio_id', '#JSStringFormat(qrConsignatario.MUNICIPIO_ID)#');
							</cfoutput>
							
							NOME_CONSIGNATARIO.value = '';
							NOME_CONSIGNATARIO_COMBO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_CONSIGNATARIO)#</cfoutput>';
						<cfelse>
							// Consignatrio aberto
							parent.document.getElementById('sp_consignatario_restrita').style.display = 'none';
							parent.document.getElementById('sp_consignatario_aberta').style.display = '';
							
							NOME_CONSIGNATARIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.CONSIGNATARIO)#</cfoutput>';
						</cfif>
						
						COD_CONSIGNATARIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_CONSIGNATARIO)#</cfoutput>';
						CNPJ_CPF_CONSIGNATARIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.CONS_CNPJ_CPF)#</cfoutput>';
						CNPJ_CPF_CONSIGNATARIO_OLD.value = '<cfoutput>#JSStringFormat(qrSolicitacao.CONS_CNPJ_CPF)#</cfoutput>';						
		                COD_ENDERECO_CONSIGNATARIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.ENDERECO_COLETA_ID)#</cfoutput>';
						CNPJ_CPF_CONSIGNATARIO.onchange();
						ENDERECO_CONSIGNATARIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.CONS_ENDERECO)#</cfoutput>';

						
						<!--- Redespacho --->
						parent.f_limpa_select(NOME_REDESPACHO_COMBO);
						<cfif vars.TERCEIRIZADO eq 0>
							CNPJ_CPF_REDESPACHO.readOnly = false;
						</cfif>
						
						<cfif qrRedespacho.RecordCount gt 0>
							// Redespachos restritos
							parent.document.getElementById('sp_redespacho_restrita').style.display = '';
							parent.document.getElementById('sp_redespacho_aberta').style.display = 'none';
							
							<cfif qrRedespacho.RecordCount gt 1>
								v_opt = parent.f_cria_option('', '-- Selecione --', NOME_REDESPACHO_COMBO);
								v_opt.setAttribute('cnpj_cpf', '');
								v_opt.setAttribute('endereco', '');
							<cfelse>
								CNPJ_CPF_REDESPACHO.readOnly = true;
							</cfif>
							
							<cfoutput query="qrRedespacho">
								v_opt = parent.f_cria_option('#qrRedespacho.COD_PESSOA#', '#JSStringFormat(qrRedespacho.CLIENTE)#', NOME_REDESPACHO_COMBO);
								v_opt.setAttribute('cnpj_cpf', '#JSStringFormat(qrRedespacho.CNPJ_CPF)#');
								v_opt.setAttribute('endereco', '#JSStringFormat(qrRedespacho.ENDERECO)#');
								v_opt.setAttribute('municipio_id', '#JSStringFormat(qrRedespacho.MUNICIPIO_ID)#');
							</cfoutput>
							
							NOME_REDESPACHO.value = '';
							NOME_REDESPACHO_COMBO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_REDESPACHO)#</cfoutput>';
						<cfelse>
							// Redespacho aberto
							parent.document.getElementById('sp_redespacho_restrita').style.display = 'none';
							parent.document.getElementById('sp_redespacho_aberta').style.display = '';
							
							NOME_REDESPACHO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.REDESPACHO)#</cfoutput>';
						</cfif>
						
						COD_REDESPACHO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_REDESPACHO)#</cfoutput>';
						CNPJ_CPF_REDESPACHO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.RED_CNPJ_CPF)#</cfoutput>';
						CNPJ_CPF_REDESPACHO_OLD.value = '<cfoutput>#JSStringFormat(qrSolicitacao.RED_CNPJ_CPF)#</cfoutput>';						
		                COD_ENDERECO_REDESPACHO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.ENDERECO_ENTREGA_ID)#</cfoutput>';
						CNPJ_CPF_REDESPACHO.onchange();
						ENDERECO_REDESPACHO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.RED_ENDERECO)#</cfoutput>';
						
						<!--- Cobrana --->
						parent.f_limpa_select(NOME_COBRANCA_COMBO);
						<cfif vars.TERCEIRIZADO eq 0>
							CNPJ_CPF_COBRANCA.readOnly = false;
						</cfif>
						
						<cfif qrCobranca.RecordCount gt 0>
							// Cobranas restritas
							parent.document.getElementById('sp_cobranca_restrita').style.display = '';
							parent.document.getElementById('sp_cobranca_aberta').style.display = 'none';
							
							<cfif qrCobranca.RecordCount gt 1>
								v_opt = parent.f_cria_option('', '-- Selecione --', NOME_COBRANCA_COMBO);
								v_opt.setAttribute('cnpj_cpf', '');
								v_opt.setAttribute('endereco', '');
							<cfelse>
								CNPJ_CPF_COBRANCA.readOnly = true;
							</cfif>
							
							<cfoutput query="qrCobranca">
								v_opt = parent.f_cria_option('#qrCobranca.COD_PESSOA#', '#JSStringFormat(qrCobranca.CLIENTE)#', NOME_COBRANCA_COMBO);
								v_opt.setAttribute('cnpj_cpf', '#JSStringFormat(qrCobranca.CNPJ_CPF)#');
								v_opt.setAttribute('endereco', '#JSStringFormat(qrCobranca.ENDERECO)#');
								v_opt.setAttribute('municipio_id', '#JSStringFormat(qrCobranca.MUNICIPIO_ID)#');
							</cfoutput>
							
							NOME_COBRANCA.value = '';
							NOME_COBRANCA_COMBO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_COBRANCA)#</cfoutput>';
						<cfelse>
							// Cobrana aberta
							parent.document.getElementById('sp_cobranca_restrita').style.display = 'none';
							parent.document.getElementById('sp_cobranca_aberta').style.display = '';
							
							NOME_COBRANCA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COBRANCA)#</cfoutput>';
						</cfif>
						
						COD_COBRANCA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_COBRANCA)#</cfoutput>';
						CNPJ_CPF_COBRANCA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COB_CNPJ_CPF)#</cfoutput>';
						CNPJ_CPF_COBRANCA_OLD.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COB_CNPJ_CPF)#</cfoutput>';						
		                COD_ENDERECO_COBRANCA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.ENDERECO_COBRANCA_ID)#</cfoutput>';
						CNPJ_CPF_COBRANCA.onchange();
						ENDERECO_COBRANCA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COB_ENDERECO)#</cfoutput>';
						
						<!--- Origem --->
						parent.f_limpa_select(ORIGEM_MUNICIPIO_COMBO);
						
						<cfif qrOrigem.RecordCount gt 0>
							// Origens restritas
							parent.document.getElementById('sp_origem_restrita').style.display = '';
							parent.document.getElementById('sp_origem_aberta').style.display = 'none';
							
							<cfif qrOrigem.RecordCount gt 1>
								v_opt = parent.f_cria_option('', '-- Selecione --', ORIGEM_MUNICIPIO_COMBO);
							</cfif>
							
							<cfoutput query="qrOrigem" group="UF">
								v_optGroup = parent.f_cria_optgroup('#JSStringFormat(qrOrigem.UF)#', ORIGEM_MUNICIPIO_COMBO);
								<cfoutput>
									v_opt = parent.f_cria_option('#JSStringFormat(qrOrigem.MUNICIPIO_ID)#', '#JSStringFormat(qrOrigem.MUNICIPIO)#', ORIGEM_MUNICIPIO_COMBO);
									v_optGroup.appendChild(v_opt);
								</cfoutput>
							</cfoutput>
							
							ORIGEM_MUNICIPIO.value = '';
							ORIGEM_MUNICIPIO_COMBO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.ORIGEM_MUNICIPIO_ID)#</cfoutput>';
						<cfelse>
							// Origem aberta
							parent.document.getElementById('sp_origem_restrita').style.display = 'none';
							parent.document.getElementById('sp_origem_aberta').style.display = '';
							
							ORIGEM_MUNICIPIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.ORIGEM)#</cfoutput>';
						</cfif>
						
						ORIGEM_MUNICIPIO_ID.value = '<cfoutput>#JSStringFormat(qrSolicitacao.ORIGEM_MUNICIPIO_ID)#</cfoutput>';
						
						<!--- Destino --->
						parent.f_limpa_select(DESTINO_MUNICIPIO_COMBO);
						
						<cfif qrDestino.RecordCount gt 0>
							// Destinos restritos
							parent.document.getElementById('sp_destino_restrita').style.display = '';
							parent.document.getElementById('sp_destino_aberta').style.display = 'none';
							
							<cfif qrDestino.RecordCount gt 1>
								v_opt = parent.f_cria_option('', '-- Selecione --', DESTINO_MUNICIPIO_COMBO);
							</cfif>
							
							<cfoutput query="qrDestino" group="UF">
								v_optGroup = parent.f_cria_optgroup('#JSStringFormat(qrDestino.UF)#', DESTINO_MUNICIPIO_COMBO);
								<cfoutput>
									v_opt = parent.f_cria_option('#JSStringFormat(qrDestino.MUNICIPIO_ID)#', '#JSStringFormat(qrDestino.MUNICIPIO)#', DESTINO_MUNICIPIO_COMBO);
									v_optGroup.appendChild(v_opt);
								</cfoutput>
							</cfoutput>
							
							DESTINO_MUNICIPIO.value = '';
							DESTINO_MUNICIPIO_COMBO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DESTINO_MUNICIPIO_ID)#</cfoutput>';
						<cfelse>
							// Destino aberto
							parent.document.getElementById('sp_destino_restrita').style.display = 'none';
							parent.document.getElementById('sp_destino_aberta').style.display = '';
							
							DESTINO_MUNICIPIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DESTINO)#</cfoutput>';
						</cfif>
						
						DESTINO_MUNICIPIO_ID.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DESTINO_MUNICIPIO_ID)#</cfoutput>';
						
						<!--- Lote --->
						parent.f_limpa_select(LOTE_COMBO);
						parent.document.getElementById('lote_restrita').style.display = '';
						v_opt = parent.f_cria_option('', '-- Selecione --', LOTE_COMBO);
						<cfif qrLote.RecordCount gt 0>						
							<cfoutput query="qrLote" group="LOTE_ID">
								<cfoutput>
									v_opt = parent.f_cria_option(#qrLote.LOTE_ID#, '#JSStringFormat(qrLote.LOTE_INFO)#', LOTE_COMBO);
									var att = document.createAttribute("lote_peso_restante");       
									att.value = #qrLote.LOTE_PESO_RESTANTE#;                           
									v_opt.setAttributeNode(att); 
								</cfoutput>
							</cfoutput>		
						</cfif>
						
						LOTE_ID.value = '<cfoutput>#JSStringFormat(qrSolicitacao.LOTE_ID)#</cfoutput>';
						LOTE_COMBO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.LOTE_ID)#</cfoutput>';
						
						<!--- Composio --->
						parent.f_limpa_composicao();
						
						<cfoutput query="qrComposicao">
							if(parent.v_count_composicao == 0) {
								parent.document.getElementById('COMPOSICAO').value = '#JSStringFormat(qrComposicao.COD_VEICULO)#';
								parent.v_count_composicao++;
							}
							else {
								parent.f_add_composicao();
								parent.document.getElementById('COMPOSICAO_' + parent.v_count_composicao).value = '#JSStringFormat(qrComposicao.COD_VEICULO)#';
							}
						</cfoutput>
						
						<!--- Dados Gerais --->
						MODALIDADE.value = '<cfoutput>#JSStringFormat(qrSolicitacao.MODALIDADE)#</cfoutput>';
						LIBERADA_AGENDAMENTO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.LIBERADA_AGENDAMENTO)#</cfoutput>';
						VALOR_TOTAL_NF.value = parent.toCurrency('<cfoutput>#JSStringFormat(qrSolicitacao.VALOR_TOTAL_NF)#</cfoutput>');
						VALOR_TOTAL_SUGERIDO.value = parent.toCurrency('<cfoutput>#JSStringFormat(qrSolicitacao.VALOR_TOTAL_SUGERIDO)#</cfoutput>');
						PEDIDO_SHIPMENT.setAttribute('obrigatorio','<cfoutput>#JSStringFormat(qrSolicitacao.pedido_shiment_obrigatorio)#</cfoutput>');
						CPF_MOTORISTA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.MOT_CPF)#</cfoutput>';
						NOME_MOTORISTA.value = '<cfoutput>#JSStringFormat(qrSolicitacao.MOTORISTA)#</cfoutput>';
						
						VALOR_EM.value = '<cfoutput>#JSStringFormat(qrSolicitacao.VALOR_EM)#</cfoutput>';
						
						<!---Apenas quando vinculado a gerenciadores de riscos UPPER--->
						try{
							PRE_ORDEM_ID.value = '<cfoutput>#JSStringFormat(qrSolicitacao.PRE_ORDEM_ID)#</cfoutput>';
						}catch (e){}
						
						switch(VALOR_EM.value) {
							case 'M3':
								parent.document.getElementById('sp_m3').style.display = '';
								parent.document.getElementById('sp_volumes').style.display = 'none';
								<cfif vars.TERCEIRIZADO eq 0>
									VALOR_UNITARIO.disabled = false;
								</cfif>
								VALOR_UNITARIO.className = 'requerido_form';
								parent.parent.f_obrigatorio(VALOR_UNITARIO, 1);
								break;
							case 'VOLUME':
								parent.document.getElementById('sp_m3').style.display = 'none';
								parent.document.getElementById('sp_volumes').style.display = '';
								<cfif vars.TERCEIRIZADO eq 0>
									VALOR_UNITARIO.disabled = false;
								</cfif>
								VALOR_UNITARIO.className = 'requerido_form';
								parent.parent.f_obrigatorio(VALOR_UNITARIO, 1);
								break;
							case 'PESO':
								parent.document.getElementById('sp_m3').style.display = 'none';
								parent.document.getElementById('sp_volumes').style.display = 'none';
								<cfif vars.TERCEIRIZADO eq 0>
									VALOR_UNITARIO.disabled = false;
								</cfif>
								VALOR_UNITARIO.className = 'requerido_form';
								parent.parent.f_obrigatorio(VALOR_UNITARIO, 1);
								break;
							case 'LOTACAO':
								parent.document.getElementById('sp_m3').style.display = 'none';
								parent.document.getElementById('sp_volumes').style.display = 'none';
								VALOR_UNITARIO.disabled = true;
								VALOR_UNITARIO.className = 'input_disable';
								parent.f_obrigatorio(VALOR_UNITARIO, 0);
								break;
							default:
								parent.document.getElementById('sp_m3').style.display = 'none';
								parent.document.getElementById('sp_volumes').style.display = 'none';
								<cfif vars.TERCEIRIZADO eq 0>
									VALOR_UNITARIO.disabled = false;
								</cfif>
								VALOR_UNITARIO.className = 'requerido_form';
								parent.parent.f_obrigatorio(VALOR_UNITARIO, 1);
								break;
						}
						
						M3.value = '<cfoutput>#JSStringFormat(qrSolicitacao.M3)#</cfoutput>';
						PESO_ESPECIFICO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.PESO_ESPECIFICO)#</cfoutput>';
						QTDE_VOLUME.value = '<cfoutput>#JSStringFormat(qrSolicitacao.QTDE_VOLUME)#</cfoutput>';
						PESO_VOLUME.value = '<cfoutput>#JSStringFormat(qrSolicitacao.PESO_VOLUME)#</cfoutput>';
						COD_UNIDADE.value = '<cfoutput>#JSStringFormat(qrSolicitacao.COD_UNIDADE)#</cfoutput>';
						NUM_ESPECIE.value = '<cfoutput>#JSStringFormat(qrSolicitacao.NUM_ESPECIE)#</cfoutput>';
						PESO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.PESO)#</cfoutput>';
						VALOR_UNITARIO.value = parent.toCurrency('<cfoutput>#JSStringFormat(qrSolicitacao.VALOR_UNITARIO)#</cfoutput>');
						VALOR_TOTAL.value = parent.toCurrency('<cfoutput>#JSStringFormat(qrSolicitacao.VALOR_TOTAL)#</cfoutput>');
						
						DATA_CARREGAMENTO_INICIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DATA_CARREGAMENTO_INICIO)#</cfoutput>'.substring(0, 16);
						DATA_CARREGAMENTO_FIM.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DATA_CARREGAMENTO_FIM)#</cfoutput>'.substring(0, 16);
						DATA_ENTREGA_INICIO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DATA_ENTREGA_INICIO)#</cfoutput>'.substring(0, 16);
						DATA_ENTREGA_FIM.value = '<cfoutput>#JSStringFormat(qrSolicitacao.DATA_ENTREGA_FIM)#</cfoutput>'.substring(0, 16);
						
						<cfif qrOperacao.PEDIDO_SHIPMENT eq 1>
						   parent.document.getElementById('NOTA_ORDEM_COMPRA').setAttribute('obrigatorio',1);
						   parent.document.getElementById('NOTA_ORDEM_COMPRA').className = 'requerido_form';
						   parent.document.getElementById('NFE_ORDEM_COMPRA').setAttribute('obrigatorio',1);
						   parent.document.getElementById('NFE_ORDEM_COMPRA').className = 'requerido_form';
						   parent.document.getElementById('OUTROS_ORDEM_COMPRA').setAttribute('obrigatorio',1);
						   parent.document.getElementById('OUTROS_ORDEM_COMPRA').className = 'requerido_form';
						   
						   
						<cfelse>			
						   parent.document.getElementById('NOTA_ORDEM_COMPRA').setAttribute('obrigatorio',0);
						   parent.document.getElementById('NOTA_ORDEM_COMPRA').className = '';
						   parent.document.getElementById('NFE_ORDEM_COMPRA').setAttribute('obrigatorio',0);
						   parent.document.getElementById('NFE_ORDEM_COMPRA').className = '';
						   parent.document.getElementById('OUTROS_ORDEM_COMPRA').setAttribute('obrigatorio',0);
						   parent.document.getElementById('OUTROS_ORDEM_COMPRA').className = '';
						</cfif>
						
						OBSERVACAO.value = '<cfoutput>#JSStringFormat(qrSolicitacao.OBSERVACAO)#</cfoutput>';
						parent.document.getElementById('sp_situacao').innerHTML = '<cfoutput>#JSStringFormat(qrSolicitacao.SITUACAO)#</cfoutput>';
							<!--- Documentos Fiscais vinculados --->
							with(parent.document.forms[0]) {
								parent.f_limpar_NOTAS_FISCAIS();
								TIPO_DOCUMENTO_ID.value = <cfoutput>'#JSStringFormat(qrSolicitacaoNF.tipo_documento_id)#'</cfoutput>;
								TIPO_DOC_OUTROS.value = <cfoutput>'#JSStringFormat(qrSolicitacaoNF.tipo_doc_outros)#'</cfoutput>;
								TIPO_DOCUMENTO_ID.onchange();
								parent.v_inserida = 1;
							}	
							
							<cfoutput query="qrSolicitacaoNF">														
							<cfswitch expression="#qrSolicitacaoNF.tipo_documento_id#">
								<cfcase value="0">
									
										NOTA_CFOP.setAttribute('obrigatorio', 0);
										parent.f_incluir_NOTAS_FISCAIS();
										
										SOLICITACAO_CARGA_NF_ID.value = '#JSStringFormat(qrSolicitacaoNF.solicitacao_carga_nf_id)#';
										NOTA_M3.value			  = '#JSStringFormat(qrSolicitacaoNF.m3)#';
										NOTA_NUMERO.value		  = '#JSStringFormat(qrSolicitacaoNF.numero)#';
										NOTA_DATA_EMISSAO.value	  = '#JSStringFormat(qrSolicitacaoNF.data_emissao)#';
										NOTA_MODELO.value		  = '#JSStringFormat(qrSolicitacaoNF.modelo)#';
										NOTA_MODELO.onchange();
										NOTA_SERIE.value     	  = '#JSStringFormat(qrSolicitacaoNF.serie)#';
										NOTA_SERIE.onchange();
										NOTA_SUB_SERIE.value 	  = '#JSStringFormat(qrSolicitacaoNF.sub_serie)#';
										NOTA_VALOR.value		  = parent.toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_total)#');
										NOTA_VALOR_SEGURADO.value = parent.toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_segurado)#');
										NOTA_ORDEM_COMPRA.value   = '#JSStringFormat(qrSolicitacaoNF.ordem_compra_cliente)#';
										NOTA_QTDE_VOLUME.value	  = '#JSStringFormat(qrSolicitacaoNF.qtde_volume)#';
										NOTA_COD_UNIDADE.value	  = 'Kg';
										NOTA_NUM_NATUREZA.value	  = '#JSStringFormat(qrSolicitacaoNF.num_natureza)#';
										NOTA_NATUREZA_COMBO.value = '#JSStringFormat(qrSolicitacaoNF.num_natureza)#';
										NOTA_NATUREZA.value    	  = '#JSStringFormat(qrSolicitacaoNF.natureza)#';
										NOTA_NUM_ESPECIE.value 	  = '#JSStringFormat(qrSolicitacaoNF.num_especie)#';
										NOTA_ESPECIE.value 		  = '#JSStringFormat(qrSolicitacaoNF.especie)#';
										NOTA_ALTURA.value 		  = ('#JSStringFormat(qrSolicitacaoNF.altura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.altura)#';
										NOTA_COMPRIMENTO.value 	  = ('#JSStringFormat(qrSolicitacaoNF.comprimento)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.comprimento)#';
										NOTA_LARGURA.value 		  = ('#JSStringFormat(qrSolicitacaoNF.largura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.largura)#';
										NOTA_CUBAGEM.value 		  = '#JSStringFormat(qrSolicitacaoNF.cubagem)#';
										NOTA_CFOP.value 		  = '#JSStringFormat(qrSolicitacaoNF.cfop)#';
										<cfif IsDefined("vars.COMPLEMENTO") and vars.COMPLEMENTO eq 1>
											NOTA_PESO.value               = 0;
											NOTA_PESO_CUBADO.value        = 0;
											NOTA_PESO_KG_CONVERTIDO.value = 0;
											NOTA_PESO_COBRADO.value       = 0;
										<cfelse>	
											NOTA_PESO.value               = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											NOTA_PESO_CUBADO.value        = '#JSStringFormat(qrSolicitacaoNF.peso_cubado)#';
											NOTA_PESO_KG_CONVERTIDO.value = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											NOTA_PESO_COBRADO.value       = ('#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#' == '') ? '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#' : '#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#';
										</cfif>
										parent.f_calcula_cubagem('NOTA');
										
										parent.f_salvar_NOTAS_FISCAIS();
										NOTA_CFOP.setAttribute('obrigatorio', 1);
																			
								</cfcase>
								<cfcase value="1">
									
										NFE_CFOP.setAttribute('obrigatorio', 0);
										parent.f_incluir_NFE();
										
										SOLICITACAO_CARGA_NF_ID.value = '#JSStringFormat(qrSolicitacaoNF.solicitacao_carga_nf_id)#';
										CHAVE_ACESSO_NFE.value      = '#JSStringFormat(qrSolicitacaoNF.chave_acesso_nfe)#';
										NFE_VALOR.value             = parent.toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_total)#');
										NFE_VALOR_SEGURADO.value    = parent.toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_segurado)#');
										NOME_ARQUIVO.value          = '';
										NUMERO_NFE.value            = '#JSStringFormat(qrSolicitacaoNF.numero)#';
										MODELO_NFE.value            = '#JSStringFormat(qrSolicitacaoNF.modelo)#';
										SERIE_NFE.value             = '#JSStringFormat(qrSolicitacaoNF.serie)#';
										DATA_EMISSAO_NFE.value      = '#JSStringFormat(qrSolicitacaoNF.data_emissao)#';
										REMETENTE_NFE.value			= '';
										CNPJ_REMETENTE_NFE.value    = '';
										DESTINATARIO_NFE.value      = '';
										CNPJ_DESTINATARIO_NFE.value = '';
										NFE_QTDE_VOLUME.value      	= '#JSStringFormat(qrSolicitacaoNF.qtde_volume)#';
										NFE_COD_UNIDADE.value      	= 'Kg';
										NFE_NUM_NATUREZA.value     	= '#JSStringFormat(qrSolicitacaoNF.num_natureza)#';
										NFE_NATUREZA_COMBO.value	= '#JSStringFormat(qrSolicitacaoNF.num_natureza)#';
										NFE_NATUREZA.value       	= '#JSStringFormat(qrSolicitacaoNF.natureza)#';
										NFE_NUM_ESPECIE.value      	= '#JSStringFormat(qrSolicitacaoNF.num_especie)#';
										NFE_ESPECIE.value       	= '#JSStringFormat(qrSolicitacaoNF.especie)#';
										NFE_ALTURA.value       		= ('#JSStringFormat(qrSolicitacaoNF.altura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.altura)#';
										NFE_COMPRIMENTO.value      	= ('#JSStringFormat(qrSolicitacaoNF.comprimento)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.comprimento)#';
										NFE_LARGURA.value       	= ('#JSStringFormat(qrSolicitacaoNF.largura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.largura)#';
										NFE_CUBAGEM.value       	= '#JSStringFormat(qrSolicitacaoNF.cubagem)#';
										NFE_XML.value				= '#JSStringFormat(qrSolicitacaoNF.nfe_xml)#';
										NFE_CFOP.value				= '#JSStringFormat(qrSolicitacaoNF.cfop)#';
										NFE_ORDEM_COMPRA.value		= '#JSStringFormat(qrSolicitacaoNF.ordem_compra_cliente)#';
										<cfif IsDefined("vars.COMPLEMENTO") and vars.COMPLEMENTO eq 1>
											NFE_PESO.value               = 0;
											NFE_PESO_CUBADO.value        = 0;
											NFE_PESO_KG_CONVERTIDO.value = 0;
											NFE_PESO_COBRADO.value       = 0;
										<cfelse>	
											NFE_PESO.value               = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											NFE_PESO_CUBADO.value        = '#JSStringFormat(qrSolicitacaoNF.peso_cubado)#';
											NFE_PESO_KG_CONVERTIDO.value = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											NFE_PESO_COBRADO.value       = ('#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#' == '') ? '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#' : '#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#';
										</cfif>
										parent.f_calcula_cubagem('NFE');
										
										parent.f_salvar_NFE();
										<cfif v_nfe_cfop_obrigatorio.valor eq "Sim">
                                      		NFE_CFOP.setAttribute('obrigatorio', 1);
										<cfelse>
											NFE_CFOP.setAttribute('obrigatorio', 0);
										</cfif>
								</cfcase>
								<cfcase value="2">
									with(parent.document.forms[0]) {
										parent.f_incluir_OUTROS();
										
										SOLICITACAO_CARGA_NF_ID.value = '#JSStringFormat(qrSolicitacaoNF.solicitacao_carga_nf_id)#';
										OUTROS_NUMERO.value				= '#JSStringFormat(qrSolicitacaoNF.numero)#';
										OUTROS_DATA_EMISSAO.value      = '#JSStringFormat(qrSolicitacaoNF.data_emissao)#';
										OUTROS_DESCRICAO.value			= '#JSStringFormat(qrSolicitacaoNF.descricao_docto)#';
										OUTROS_VALOR.value				= parent.toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_total)#');
										OUTROS_QTDE_VOLUME.value      	= '#JSStringFormat(qrSolicitacaoNF.qtde_volume)#';
										OUTROS_COD_UNIDADE.value      	= 'Kg';
										OUTROS_NUM_NATUREZA.value     	= '#JSStringFormat(qrSolicitacaoNF.num_natureza)#';
										OUTROS_NATUREZA_COMBO.value		= '#JSStringFormat(qrSolicitacaoNF.num_natureza)#';
										OUTROS_NATUREZA.value       	= '#JSStringFormat(qrSolicitacaoNF.natureza)#';
										OUTROS_NUM_ESPECIE.value      	= '#JSStringFormat(qrSolicitacaoNF.num_especie)#';
										OUTROS_ESPECIE.value       		= '#JSStringFormat(qrSolicitacaoNF.especie)#';
										OUTROS_ALTURA.value       		= ('#JSStringFormat(qrSolicitacaoNF.altura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.altura)#';
										OUTROS_COMPRIMENTO.value      	= ('#JSStringFormat(qrSolicitacaoNF.comprimento)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.comprimento)#';
										OUTROS_LARGURA.value       		= ('#JSStringFormat(qrSolicitacaoNF.largura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.largura)#';
										OUTROS_CUBAGEM.value       		= '#JSStringFormat(qrSolicitacaoNF.cubagem)#';
										OUTROS_ORDEM_COMPRA.value		= '#JSStringFormat(qrSolicitacaoNF.ordem_compra_cliente)#';
										TIPO_DOC_OUTROS.value			= '#JSStringFormat(qrSolicitacaoNF.tipo_doc_outros)#';
										<cfif IsDefined("vars.COMPLEMENTO") and vars.COMPLEMENTO eq 1>
											OUTROS_PESO.value               = 0;
											OUTROS_PESO_CUBADO.value        = 0;
											OUTROS_PESO_KG_CONVERTIDO.value = 0;
											OUTROS_PESO_COBRADO.value       = 0;
										<cfelse>	
											OUTROS_PESO.value               = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											OUTROS_PESO_CUBADO.value        = '#JSStringFormat(qrSolicitacaoNF.peso_cubado)#';
											OUTROS_PESO_KG_CONVERTIDO.value = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											OUTROS_PESO_COBRADO.value       = ('#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#' == '') ? '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#' : '#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#';
										</cfif>
										parent.f_calcula_cubagem('OUTROS');
										
										parent.f_salvar_OUTROS();
									}
								</cfcase>                            
							</cfswitch>
                        </cfoutput>
                        
						parent.v_inserida = 0;
                    	<cfif vars.TERCEIRIZADO eq 0>
						parent.f_habilitar_botao('cancelar_doc', 'f_cancelar_doc()');
						</cfif>
						// Se a SITUACAO_ID for 1 habilita o boto Editar
						<cfif qrSolicitacao.SITUACAO_ID eq 1 or qrSolicitacao.SITUACAO_ID eq 2>
							parent.f_habilitar_botao('editar', 'f_editar()');
							
							// Se a varivel EDITAR for 1 entra em modo de edio
							<cfif vars.EDITAR eq 1 and vars.TERCEIRIZADO eq 1>
								parent.f_editar();
							</cfif>
						</cfif>
						
						<cfif qrDadosRepom.RecordCount gt 0>
						    parent.document.getElementById('dados_repom').style.display = '';
							CARTAO_NUMERO.value      = '<cfoutput>#JSStringFormat(qrDadosRepom.CARTAO_NUMERO)#</cfoutput>';
							ADTO_TRAJETO_VAZIO.value = '<cfoutput>#JSStringFormat(qrDadosRepom.ADTO_TRAJETO_VAZIO)#</cfoutput>';
							<cfif Len(Trim(qrSolicitacao.NUM_ROMANEIO)) >
								CARTAO_NUMERO.readOnly = true;
								ADTO_TRAJETO_VAZIO.readOnly = true;
							<cfelse>
								<cfif vars.TERCEIRIZADO eq 0>
									CARTAO_NUMERO.readOnly = false;
									ADTO_TRAJETO_VAZIO.readOnly = false;
								</cfif>
							</cfif>
							<cfif qrOperacao.ADIANTAMENTO_FRETE_VAZIO eq 0 or vars.TERCEIRIZADO eq 1>
								ADTO_TRAJETO_VAZIO.readOnly = true;
							<cfelse>
								ADTO_TRAJETO_VAZIO.readOnly = false;
							</cfif>
						<cfelse>
							parent.document.getElementById('dados_repom').style.display = 'none';
							CARTAO_NUMERO.value      = '';
							ADTO_TRAJETO_VAZIO.value = '';		
						</cfif>
						PEDIDO_SHIPMENT.value = '<cfoutput>#JSStringFormat(qrSolicitacao.PEDIDO_SHIPMENT)#</cfoutput>';
					}
					parent.f_get_tempo_rota();
                </script>
                
            <cfelse>
                <script type="text/javascript">
                    alert('Nenhuma solicitao de carga foi encontrada.');
                </script>
            </cfif>
        </cfcase>
        
    	<cfcase value="2">
        	<cfscript>
				conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_operacao");
				qrOperacao 		 = conn.get_operacao(operacao_id = vars.OPERACAO_ID);
				qrNatureza 		 = conn.get_operacao_natureza(operacao_id = vars.OPERACAO_ID);
				qrRemetente 	 = conn.get_operacao_cliente(operacao_id = vars.OPERACAO_ID, tipo_cliente = 0);
				qrDestinatario   = conn.get_operacao_cliente(operacao_id = vars.OPERACAO_ID, tipo_cliente = 1);
				qrConsignatario  = conn.get_operacao_cliente(operacao_id = vars.OPERACAO_ID, tipo_cliente = 2);
				qrRedespacho	 = conn.get_operacao_cliente(operacao_id = vars.OPERACAO_ID, tipo_cliente = 3);
				qrCobranca 		 = conn.get_operacao_cliente(operacao_id = vars.OPERACAO_ID, tipo_cliente = 4);
				qrOrigem 		 = conn.get_operacao_municipio(operacao_id = vars.OPERACAO_ID, origem_destino = 0);
				qrDestino 		 = conn.get_operacao_municipio(operacao_id = vars.OPERACAO_ID, origem_destino = 1);
				qrLote 		     = conn.get_operacao_lote(operacao_id = vars.OPERACAO_ID, lote_id = vars.LOTE_ID);
				qrOperacaoTempo  = conn.get_operacao_tempo(operacao_id = vars.OPERACAO_ID);
				connG = CreateComponent("_transportes.consulta.cfc_global");											 
				v_crt_obrigatorio_intc = connG.get_parametro_valor(cod_projeto        = 25,
																	  cod_aplicacao      = 'FISCAL.EXE',
																	  parametro_id       = 6,
																	  parametro_grupo_id = 44);				
			</cfscript>
			<script type="text/javascript">
                with(parent.document.forms[0]) {
					OPERACAO_ID.value = '<cfoutput>#JSStringFormat(vars.OPERACAO_ID)#</cfoutput>';
					OPERACAO_DESCRICAO.value = '<cfoutput>#JSStringFormat(qrOperacao.DESCRICAO)#</cfoutput>';
					TIPO_PAGAMENTO_ID.value = '<cfoutput>#JSStringFormat(qrOperacao.TIPO_PAGAMENTO_ID)#</cfoutput>';
					POSSUI_REPOM.value = '<cfoutput>#JSStringFormat(qrOperacao.POSSUI_REPOM)#</cfoutput>';
					
					PEDIDO_SHIPMENT.setAttribute('obrigatorio','<cfoutput>#JSStringFormat(qrOperacao.PEDIDO_SHIPMENT)#</cfoutput>');
					
					FRACIONADO.value = '<cfoutput>#qrOperacao.FRACIONADO#</cfoutput>';
					CONTROLA_CONTAINER.value = '<cfoutput>#qrOperacao.CONTROLA_CONTAINER#</cfoutput>';
					CONTROLA_CONTAINER_CG_DIRETA.value = '<cfoutput>#qrOperacao.CONTROLA_CONTAINER_CG_DIRETA#</cfoutput>';
					

					<cfif qrOperacao.pendente eq 1>
					    parent.document.getElementById('operacao_pendente').innerHTML = 'A operao selecionada est indisponvel pois est marcada para realizar troca de notas e o vnculo est pendente de aprovao.';
						alert('A operao selecionada est indisponvel pois est marcada para realizar troca de notas e o vnculo est pendente de aprovao.\nNecessrio realizar a aprovao do vnculo pela interface\n\nPlanejamento e Controle Logstico / Operao / Lista de Operaes com Segundo Trecho\n');
						parent.f_cancelar();
				    </cfif>
					
					<cfif qrOperacao.POSSUI_REPOM eq 1>
						parent.document.getElementById('dados_repom').style.display = '';
					<cfelse>
						parent.document.getElementById('dados_repom').style.display = 'none';
					</cfif>
					
					<cfif qrOperacao.ADIANTAMENTO_FRETE_VAZIO eq 0 or vars.TERCEIRIZADO eq 1 >
						ADTO_TRAJETO_VAZIO.readOnly = true;
					<cfelse>
						ADTO_TRAJETO_VAZIO.readOnly = false;
					</cfif>
					
					<cfif qrOperacao.INTERNACIONAL eq 1>		
						parent.document.getElementById('tr_internacional').style.display = '';				
						<cfif v_crt_obrigatorio_intc eq 1>
							parent.document.getElementById('NUM_CRT_COMPLETO').setAttribute('obrigatorio',1);
							parent.document.getElementById('NUM_CRT_COMPLETO').className = 'requerido_form';
						<cfelse>
							parent.document.getElementById('NUM_CRT_COMPLETO').setAttribute('obrigatorio',0)
							parent.document.getElementById('NUM_CRT_COMPLETO').className = '';						
						</cfif>
					<cfelse>						
						parent.document.getElementById('tr_internacional').style.display = 'none';								
						parent.document.getElementById('NUM_CRT_COMPLETO').setAttribute('obrigatorio',0);
						parent.document.getElementById('NUM_CRT_COMPLETO').className = '';
					</cfif>
					
					<cfif qrOperacao.PEDIDO_SHIPMENT eq 1>
					   parent.document.getElementById('NOTA_ORDEM_COMPRA').setAttribute('obrigatorio',1);
					   parent.document.getElementById('NOTA_ORDEM_COMPRA').className = 'requerido_form';
					   parent.document.getElementById('NFE_ORDEM_COMPRA').setAttribute('obrigatorio',1);
					   parent.document.getElementById('NFE_ORDEM_COMPRA').className = 'requerido_form';
					   parent.document.getElementById('OUTROS_ORDEM_COMPRA').setAttribute('obrigatorio',1);
					   parent.document.getElementById('OUTROS_ORDEM_COMPRA').className = 'requerido_form';
					   
					   
					<cfelse>			
   					   parent.document.getElementById('NOTA_ORDEM_COMPRA').setAttribute('obrigatorio',0);
					   parent.document.getElementById('NOTA_ORDEM_COMPRA').className = '';
					   parent.document.getElementById('NFE_ORDEM_COMPRA').setAttribute('obrigatorio',0);
					   parent.document.getElementById('NFE_ORDEM_COMPRA').className = '';
					   parent.document.getElementById('OUTROS_ORDEM_COMPRA').setAttribute('obrigatorio',0);
					   parent.document.getElementById('OUTROS_ORDEM_COMPRA').className = '';
					</cfif>
					
					<!--- Natureza --->
					NUM_NATUREZA.value = '';
					NATUREZA.value = '';
					PESO_ESPECIFICO.value = '';
					parent.f_limpa_select(NATUREZA_COMBO);
					
					NOTA_NUM_NATUREZA.value = '';
					NOTA_NATUREZA.value = '';
					parent.f_limpa_select(NOTA_NATUREZA_COMBO);
					
					NFE_NUM_NATUREZA.value = '';
					NFE_NATUREZA.value = '';
					parent.f_limpa_select(NFE_NATUREZA_COMBO);					
					
					<cfif vars.TERCEIRIZADO eq 0>
						NUM_NATUREZA.readOnly = false;
						NATUREZA_COMBO.disabled = false;
						
						NOTA_NUM_NATUREZA.readOnly = false;
						NOTA_NATUREZA_COMBO.disabled = false;
						
						NFE_NUM_NATUREZA.readOnly = false;
						NFE_NATUREZA_COMBO.disabled = false;		
					</cfif>
					<cfif qrNatureza.RecordCount gt 0>
						// Naturezas restritas
						parent.document.getElementById('sp_natureza_restrita').style.display = '';
						parent.document.getElementById('sp_natureza_aberta').style.display = 'none';
						
						parent.document.getElementById('sp_NOTA_natureza_restrita').style.display = '';
						parent.document.getElementById('sp_NOTA_natureza_aberta').style.display = 'none';
						parent.document.getElementById('sp_NFE_natureza_restrita').style.display = '';
						parent.document.getElementById('sp_NFE_natureza_aberta').style.display = 'none';
						parent.document.getElementById('sp_OUTROS_natureza_restrita').style.display = '';
						parent.document.getElementById('sp_OUTROS_natureza_aberta').style.display = 'none';
						
						<cfif qrNatureza.RecordCount gt 1>
							v_opt = parent.f_cria_option('', '-- Selecione --', NATUREZA_COMBO);
							v_opt.setAttribute('peso_especifico', '');
							
							v_opt = parent.f_cria_option('', '-- Selecione --', NOTA_NATUREZA_COMBO);
							v_opt = parent.f_cria_option('', '-- Selecione --', NFE_NATUREZA_COMBO);
							v_opt = parent.f_cria_option('', '-- Selecione --', OUTROS_NATUREZA_COMBO);
						<cfelse>
							NUM_NATUREZA.value = '<cfoutput>#JSStringFormat(qrNatureza.NUM_NATUREZA)#</cfoutput>';
							PESO_ESPECIFICO.value = '<cfoutput>#JSStringFormat(qrNatureza.PESO_ESPECIFICO)#</cfoutput>';
							NUM_NATUREZA.readOnly = true;
							NATUREZA_COMBO.disabled = true;
							
							NOTA_NUM_NATUREZA.value = '<cfoutput>#JSStringFormat(qrNatureza.NUM_NATUREZA)#</cfoutput>';
							NOTA_NUM_NATUREZA.readOnly = true;
							NOTA_NATUREZA_COMBO.disabled = true;

							NFE_NUM_NATUREZA.value = '<cfoutput>#JSStringFormat(qrNatureza.NUM_NATUREZA)#</cfoutput>';
							NFE_NUM_NATUREZA.readOnly = true;
							NFE_NATUREZA_COMBO.disabled = true;
							
							OUTROS_NUM_NATUREZA.value = '<cfoutput>#JSStringFormat(qrNatureza.NUM_NATUREZA)#</cfoutput>';
							OUTROS_NUM_NATUREZA.readOnly = true;
							OUTROS_NATUREZA_COMBO.disabled = true;														
						</cfif>
						
						<cfoutput query="qrNatureza">
							v_opt = parent.f_cria_option('#JSStringFormat(qrNatureza.NUM_NATUREZA)#', '#JSStringFormat(qrNatureza.NUM_NATUREZA)#-#JSStringFormat(qrNatureza.NATUREZA)#', NATUREZA_COMBO);
							v_opt.setAttribute('peso_especifico', '#JSStringFormat(qrNatureza.PESO_ESPECIFICO)#');
							
							v_opt = parent.f_cria_option('#JSStringFormat(qrNatureza.NUM_NATUREZA)#', '#JSStringFormat(qrNatureza.NUM_NATUREZA)#-#JSStringFormat(qrNatureza.NATUREZA)#', NOTA_NATUREZA_COMBO);
							v_opt = parent.f_cria_option('#JSStringFormat(qrNatureza.NUM_NATUREZA)#', '#JSStringFormat(qrNatureza.NUM_NATUREZA)#-#JSStringFormat(qrNatureza.NATUREZA)#', NFE_NATUREZA_COMBO);
							v_opt = parent.f_cria_option('#JSStringFormat(qrNatureza.NUM_NATUREZA)#', '#JSStringFormat(qrNatureza.NUM_NATUREZA)#-#JSStringFormat(qrNatureza.NATUREZA)#', OUTROS_NATUREZA_COMBO);
						</cfoutput>
					<cfelse>
						// Natureza aberta
						parent.document.getElementById('sp_natureza_restrita').style.display = 'none';
						parent.document.getElementById('sp_natureza_aberta').style.display = '';
						
						parent.document.getElementById('sp_NOTA_natureza_restrita').style.display = 'none';
						parent.document.getElementById('sp_NOTA_natureza_aberta').style.display = '';
						parent.document.getElementById('sp_NFE_natureza_restrita').style.display = 'none';
						parent.document.getElementById('sp_NFE_natureza_aberta').style.display = '';
						parent.document.getElementById('sp_OUTROS_natureza_restrita').style.display = 'none';
						parent.document.getElementById('sp_OUTROS_natureza_aberta').style.display = '';
					</cfif>
					
					NUM_NATUREZA.onchange();
					
					<!--- Remetente --->
					parent.f_limpa_select(ENDERECO_COMBO_REMETENTE);
					parent.f_cria_option('', '--Selecione--', ENDERECO_COMBO_REMETENTE);
					COD_REMETENTE.value = '';
					CNPJ_CPF_REMETENTE.value = '';
					NOME_REMETENTE.value = '';
					ENDERECO_REMETENTE.value = '';
					parent.f_limpa_select(NOME_REMETENTE_COMBO);
					
					<cfif vars.TERCEIRIZADO eq 0>
						CNPJ_CPF_REMETENTE.readOnly = false;
						NOME_REMETENTE_COMBO.disabled = false;
					</cfif>
					<cfif qrRemetente.RecordCount gt 0>
						// Remetente restritos
						parent.document.getElementById('sp_remetente_restrita').style.display = '';
						parent.document.getElementById('sp_remetente_aberta').style.display = 'none';
						
						<cfif qrRemetente.RecordCount gt 1>
							v_opt = parent.f_cria_option('', '-- Selecione --', NOME_REMETENTE_COMBO);
							v_opt.setAttribute('cnpj_cpf', '');
							v_opt.setAttribute('endereco', '');
							v_opt.setAttribute('municipio_id', '');
							v_opt.setAttribute('municipio_uf', '');
						<cfelse>
							COD_REMETENTE.value = '<cfoutput>#JSStringFormat(qrRemetente.COD_PESSOA)#</cfoutput>';
							CNPJ_CPF_REMETENTE.value = '<cfoutput>#JSStringFormat(qrRemetente.CNPJ_CPF)#</cfoutput>';
							ENDERECO_REMETENTE.value = '<cfoutput>#JSStringFormat(qrRemetente.ENDERECO)#</cfoutput>';
							CNPJ_CPF_REMETENTE.readOnly = true;
							NOME_REMETENTE_COMBO.disabled = true;
						</cfif>
						
						<cfoutput query="qrRemetente">
							v_opt = parent.f_cria_option('#qrRemetente.COD_PESSOA#', '#JSStringFormat(qrRemetente.CLIENTE)#', NOME_REMETENTE_COMBO);
							v_opt.setAttribute('cnpj_cpf', '#JSStringFormat(qrRemetente.CNPJ_CPF)#');
							v_opt.setAttribute('endereco', '#JSStringFormat(qrRemetente.ENDERECO)#');
							v_opt.setAttribute('municipio_id', '#JSStringFormat(qrRemetente.MUNICIPIO_ID)#');
							v_opt.setAttribute('municipio_uf', '#JSStringFormat(qrRemetente.MUNICIPIO_UF)#');
						</cfoutput>
					<cfelse>
						// Remetente aberto
						parent.document.getElementById('sp_remetente_restrita').style.display = 'none';
						parent.document.getElementById('sp_remetente_aberta').style.display = '';
					</cfif>
					CNPJ_CPF_REMETENTE.onchange();
					
					<!--- Destinatrio --->
					parent.f_limpa_select(ENDERECO_COMBO_DESTINATARIO);
					parent.f_cria_option('', '--Selecione--', ENDERECO_COMBO_DESTINATARIO);
					COD_DESTINATARIO.value = '';
					CNPJ_CPF_DESTINATARIO.value = '';
					NOME_DESTINATARIO.value = '';
					ENDERECO_DESTINATARIO.value = '';
					parent.f_limpa_select(NOME_DESTINATARIO_COMBO);
					
					<cfif vars.TERCEIRIZADO eq 0>
						CNPJ_CPF_DESTINATARIO.readOnly = false;
						NOME_DESTINATARIO_COMBO.disabled = false;
					</cfif>
					
					<cfif qrDestinatario.RecordCount gt 0>
						// Destinatrios restritos
						parent.document.getElementById('sp_destinatario_restrita').style.display = '';
						parent.document.getElementById('sp_destinatario_aberta').style.display = 'none';
						
						<cfif qrDestinatario.RecordCount gt 1>
							v_opt = parent.f_cria_option('', '-- Selecione --', NOME_DESTINATARIO_COMBO);
							v_opt.setAttribute('cnpj_cpf', '');
							v_opt.setAttribute('endereco', '');
							v_opt.setAttribute('municipio_id', '');
							v_opt.setAttribute('municipio_uf', '');
						<cfelse>
							COD_DESTINATARIO.value = '<cfoutput>#JSStringFormat(qrDestinatario.COD_PESSOA)#</cfoutput>';
							CNPJ_CPF_DESTINATARIO.value = '<cfoutput>#JSStringFormat(qrDestinatario.CNPJ_CPF)#</cfoutput>';
							ENDERECO_DESTINATARIO.value = '<cfoutput>#JSStringFormat(qrDestinatario.ENDERECO)#</cfoutput>';
							CNPJ_CPF_DESTINATARIO.readOnly = true;
							NOME_DESTINATARIO_COMBO.disabled = true;
						</cfif>
						
						<cfoutput query="qrDestinatario">
							v_opt = parent.f_cria_option('#qrDestinatario.COD_PESSOA#', '#JSStringFormat(qrDestinatario.CLIENTE)#', NOME_DESTINATARIO_COMBO);
							v_opt.setAttribute('cnpj_cpf', '#JSStringFormat(qrDestinatario.CNPJ_CPF)#');
							v_opt.setAttribute('endereco', '#JSStringFormat(qrDestinatario.ENDERECO)#');
							v_opt.setAttribute('municipio_id', '#JSStringFormat(qrDestinatario.MUNICIPIO_ID)#');
							v_opt.setAttribute('municipio_uf', '#JSStringFormat(qrDestinatario.MUNICIPIO_UF)#');
						</cfoutput>
					<cfelse>
						// Destinatrio aberto
						parent.document.getElementById('sp_destinatario_restrita').style.display = 'none';
						parent.document.getElementById('sp_destinatario_aberta').style.display = '';
					</cfif>
					
					CNPJ_CPF_DESTINATARIO.onchange();
					
					<!--- Consignatrio --->
					parent.f_limpa_select(ENDERECO_COMBO_CONSIGNATARIO);
					parent.f_cria_option('', '--Selecione--', ENDERECO_COMBO_CONSIGNATARIO);
					COD_CONSIGNATARIO.value = '';
					CNPJ_CPF_CONSIGNATARIO.value = '';
					NOME_CONSIGNATARIO.value = '';
					ENDERECO_CONSIGNATARIO.value = '';
					parent.f_limpa_select(NOME_CONSIGNATARIO_COMBO);
					
					<cfif vars.TERCEIRIZADO eq 0>
						CNPJ_CPF_CONSIGNATARIO.readOnly = false;
						NOME_CONSIGNATARIO_COMBO.disabled = false;
					</cfif>
					<cfif qrConsignatario.RecordCount gt 0>
						// Consignatrios restritos
						parent.document.getElementById('sp_consignatario_restrita').style.display = '';
						parent.document.getElementById('sp_consignatario_aberta').style.display = 'none';
						
						<cfif qrConsignatario.RecordCount gt 1>
							v_opt = parent.f_cria_option('', '-- Selecione --', NOME_CONSIGNATARIO_COMBO);
							v_opt.setAttribute('cnpj_cpf', '');
							v_opt.setAttribute('endereco', '');
							v_opt.setAttribute('municipio_id', '');
							v_opt.setAttribute('municipio_uf', '');
						<cfelse>
							COD_CONSIGNATARIO.value = '<cfoutput>#JSStringFormat(qrConsignatario.COD_PESSOA)#</cfoutput>';
							CNPJ_CPF_CONSIGNATARIO.value = '<cfoutput>#JSStringFormat(qrConsignatario.CNPJ_CPF)#</cfoutput>';
							ENDERECO_CONSIGNATARIO.value = '<cfoutput>#JSStringFormat(qrConsignatario.ENDERECO)#</cfoutput>';
							CNPJ_CPF_CONSIGNATARIO.readOnly = true;
							NOME_CONSIGNATARIO_COMBO.disabled = true;
						</cfif>
						
						<cfoutput query="qrConsignatario">
							v_opt = parent.f_cria_option('#qrConsignatario.COD_PESSOA#', '#JSStringFormat(qrConsignatario.CLIENTE)#', NOME_CONSIGNATARIO_COMBO);
							v_opt.setAttribute('cnpj_cpf', '#JSStringFormat(qrConsignatario.CNPJ_CPF)#');
							v_opt.setAttribute('endereco', '#JSStringFormat(qrConsignatario.ENDERECO)#');
							v_opt.setAttribute('municipio_id', '#JSStringFormat(qrConsignatario.MUNICIPIO_ID)#');
							v_opt.setAttribute('municipio_uf', '#JSStringFormat(qrConsignatario.MUNICIPIO_UF)#');
						</cfoutput>
					<cfelse>
						// Consignatrio aberto
						parent.document.getElementById('sp_consignatario_restrita').style.display = 'none';
						parent.document.getElementById('sp_consignatario_aberta').style.display = '';
					</cfif>
					
					CNPJ_CPF_CONSIGNATARIO.onchange();


					<!--- Redespacho --->
					parent.f_limpa_select(ENDERECO_COMBO_REDESPACHO);
					parent.f_cria_option('', '--Selecione--', ENDERECO_COMBO_REDESPACHO);
					COD_REDESPACHO.value = '';
					CNPJ_CPF_REDESPACHO.value = '';
					NOME_REDESPACHO.value = '';
					ENDERECO_REDESPACHO.value = '';
					parent.f_limpa_select(NOME_REDESPACHO_COMBO);
					
					<cfif vars.TERCEIRIZADO eq 0>
						CNPJ_CPF_REDESPACHO.readOnly = false;
						NOME_REDESPACHO_COMBO.disabled = false;
					</cfif>
					<cfif qrRedespacho.RecordCount gt 0>
						// Redespachos restritos
						parent.document.getElementById('sp_redespacho_restrita').style.display = '';
						parent.document.getElementById('sp_redespacho_aberta').style.display = 'none';
						
						<cfif qrRedespacho.RecordCount gt 1>
							v_opt = parent.f_cria_option('', '-- Selecione --', NOME_REDESPACHO_COMBO);
							v_opt.setAttribute('cnpj_cpf', '');
							v_opt.setAttribute('endereco', '');
							v_opt.setAttribute('municipio_id', '');
							v_opt.setAttribute('municipio_uf', '');
						<cfelse>
							COD_REDESPACHO.value = '<cfoutput>#JSStringFormat(qrRedespacho.COD_PESSOA)#</cfoutput>';
							CNPJ_CPF_REDESPACHO.value = '<cfoutput>#JSStringFormat(qrRedespacho.CNPJ_CPF)#</cfoutput>';
							ENDERECO_REDESPACHO.value = '<cfoutput>#JSStringFormat(qrRedespacho.ENDERECO)#</cfoutput>';
							CNPJ_CPF_REDESPACHO.readOnly = true;
							NOME_REDESPACHO_COMBO.disabled = true;
						</cfif>
						
						<cfoutput query="qrRedespacho">
							v_opt = parent.f_cria_option('#qrRedespacho.COD_PESSOA#', '#JSStringFormat(qrRedespacho.CLIENTE)#', NOME_REDESPACHO_COMBO);
							v_opt.setAttribute('cnpj_cpf', '#JSStringFormat(qrRedespacho.CNPJ_CPF)#');
							v_opt.setAttribute('endereco', '#JSStringFormat(qrRedespacho.ENDERECO)#');
							v_opt.setAttribute('municipio_id', '#JSStringFormat(qrRedespacho.MUNICIPIO_ID)#');
							v_opt.setAttribute('municipio_uf', '#JSStringFormat(qrRedespacho.MUNICIPIO_UF)#');
						</cfoutput>
					<cfelse>
						// Redespacho aberto
						parent.document.getElementById('sp_redespacho_restrita').style.display = 'none';
						parent.document.getElementById('sp_redespacho_aberta').style.display = '';

					</cfif>
					
					CNPJ_CPF_REDESPACHO.onchange();
					
					<!--- Cobrana --->
					parent.f_limpa_select(ENDERECO_COMBO_COBRANCA);
					parent.f_cria_option('', '--Selecione--', ENDERECO_COMBO_COBRANCA);
					COD_COBRANCA.value = '';
					CNPJ_CPF_COBRANCA.value = '';
					NOME_COBRANCA.value = '';
					ENDERECO_COBRANCA.value = '';
					parent.f_limpa_select(NOME_COBRANCA_COMBO);
					<cfif vars.TERCEIRIZADO eq 0>
						CNPJ_CPF_COBRANCA.readOnly = false;
						NOME_COBRANCA_COMBO.disabled = false;
					</cfif>
					<cfif qrCobranca.RecordCount gt 0>
						// Cobranas restritas
						parent.document.getElementById('sp_cobranca_restrita').style.display = '';
						parent.document.getElementById('sp_cobranca_aberta').style.display = 'none';
						
						<cfif qrCobranca.RecordCount gt 1>
							v_opt = parent.f_cria_option('', '-- Selecione --', NOME_COBRANCA_COMBO);
							v_opt.setAttribute('cnpj_cpf', '');
							v_opt.setAttribute('endereco', '');
						<cfelse>
							COD_COBRANCA.value = '<cfoutput>#JSStringFormat(qrCobranca.COD_PESSOA)#</cfoutput>';
							CNPJ_CPF_COBRANCA.value = '<cfoutput>#JSStringFormat(qrCobranca.CNPJ_CPF)#</cfoutput>';
							ENDERECO_COBRANCA.value = '<cfoutput>#JSStringFormat(qrCobranca.ENDERECO)#</cfoutput>';
							CNPJ_CPF_COBRANCA.readOnly = true;
							NOME_COBRANCA_COMBO.disabled = true;
						</cfif>
						
						<cfoutput query="qrCobranca">
							v_opt = parent.f_cria_option('#qrCobranca.COD_PESSOA#', '#JSStringFormat(qrCobranca.CLIENTE)#', NOME_COBRANCA_COMBO);
							v_opt.setAttribute('cnpj_cpf', '#JSStringFormat(qrCobranca.CNPJ_CPF)#');
							v_opt.setAttribute('endereco', '#JSStringFormat(qrCobranca.ENDERECO)#');
							v_opt.setAttribute('municipio_id', '#JSStringFormat(qrCobranca.MUNICIPIO_ID)#');
						</cfoutput>
					<cfelse>
						// Cobrana aberta
						parent.document.getElementById('sp_cobranca_restrita').style.display = 'none';
						parent.document.getElementById('sp_cobranca_aberta').style.display = '';
					</cfif>
					
					CNPJ_CPF_COBRANCA.onchange();
					
					<!--- Origem --->				
					ORIGEM_MUNICIPIO_ID.value = '';
					ORIGEM_MUNICIPIO.value = '';
					parent.f_limpa_select(ORIGEM_MUNICIPIO_COMBO);
					
					<cfif vars.TERCEIRIZADO eq 0>
						ORIGEM_MUNICIPIO_COMBO.disabled = false;
					</cfif>
					<cfif qrOrigem.RecordCount gt 0>
						// Origens restritas
						parent.document.getElementById('sp_origem_restrita').style.display = '';
						parent.document.getElementById('sp_origem_aberta').style.display = 'none';
						
						<cfif qrOrigem.RecordCount gt 1>
							v_opt = parent.f_cria_option('', '-- Selecione --', ORIGEM_MUNICIPIO_COMBO);
						<cfelse>
							ORIGEM_MUNICIPIO_ID.value = '<cfoutput>#JSStringFormat(qrOrigem.MUNICIPIO_ID)#</cfoutput>';
							ORIGEM_MUNICIPIO_COMBO.disabled = true;
						</cfif>
						
						<cfoutput query="qrOrigem" group="UF">
							v_optGroup = parent.f_cria_optgroup('#JSStringFormat(qrOrigem.UF)#', ORIGEM_MUNICIPIO_COMBO);
							<cfoutput>
								v_opt = parent.f_cria_option('#JSStringFormat(qrOrigem.MUNICIPIO_ID)#', '#JSStringFormat(qrOrigem.MUNICIPIO)#', ORIGEM_MUNICIPIO_COMBO);
								v_optGroup.appendChild(v_opt);
							</cfoutput>
						</cfoutput>
					<cfelse>
						// Origem aberta
						parent.document.getElementById('sp_origem_restrita').style.display = 'none';
						parent.document.getElementById('sp_origem_aberta').style.display = '';
					</cfif>						
					if(NOME_REMETENTE_COMBO.value != '' && !ORIGEM_MUNICIPIO_COMBO.disabled){
						ORIGEM_MUNICIPIO_COMBO.value =  '<cfoutput>#JSStringFormat(qrRemetente.MUNICIPIO_ID)#</cfoutput>';					
						ORIGEM_MUNICIPIO_ID.value    =  '<cfoutput>#JSStringFormat(qrRemetente.MUNICIPIO_ID)#</cfoutput>';															
					}
					try{
						if(NOME_CONSIGNATARIO_COMBO.options[NOME_CONSIGNATARIO_COMBO.selectedIndex].getAttribute('municipio_id') && !ORIGEM_MUNICIPIO_COMBO.disabled){
							ORIGEM_MUNICIPIO_COMBO.value = NOME_CONSIGNATARIO_COMBO.options[NOME_CONSIGNATARIO_COMBO.selectedIndex].getAttribute('municipio_id');
							ORIGEM_MUNICIPIO_ID.value = NOME_CONSIGNATARIO_COMBO.options[NOME_CONSIGNATARIO_COMBO.selectedIndex].getAttribute('municipio_id');
						}
					}catch (e){}

					<!--- Destino --->
					DESTINO_MUNICIPIO_ID.value = '';
					DESTINO_MUNICIPIO.value = '';
					parent.f_limpa_select(DESTINO_MUNICIPIO_COMBO);
					
					<cfif vars.TERCEIRIZADO eq 0>
						DESTINO_MUNICIPIO_COMBO.disabled = false;
					</cfif>
					<cfif qrDestino.RecordCount gt 0>
						// Destinos restritos
						parent.document.getElementById('sp_destino_restrita').style.display = '';
						parent.document.getElementById('sp_destino_aberta').style.display = 'none';
						
						<cfif qrDestino.RecordCount gt 1>
							v_opt = parent.f_cria_option('', '-- Selecione --', DESTINO_MUNICIPIO_COMBO);
						<cfelse>

							DESTINO_MUNICIPIO_ID.value = '<cfoutput>#JSStringFormat(qrDestino.MUNICIPIO_ID)#</cfoutput>';
							DESTINO_MUNICIPIO_COMBO.disabled = true;
						</cfif>
						
						<cfoutput query="qrDestino" group="UF">
							v_optGroup = parent.f_cria_optgroup('#JSStringFormat(qrDestino.UF)#', DESTINO_MUNICIPIO_COMBO);
							<cfoutput>
								v_opt = parent.f_cria_option('#JSStringFormat(qrDestino.MUNICIPIO_ID)#', '#JSStringFormat(qrDestino.MUNICIPIO)#', DESTINO_MUNICIPIO_COMBO);
								v_optGroup.appendChild(v_opt);
							</cfoutput>
						</cfoutput>
					<cfelse>
						// Destino aberto
						parent.document.getElementById('sp_destino_restrita').style.display = 'none';
						parent.document.getElementById('sp_destino_aberta').style.display = '';				
					</cfif>
					if(NOME_DESTINATARIO_COMBO.value != ''  && !DESTINO_MUNICIPIO_COMBO.disabled){
						DESTINO_MUNICIPIO_COMBO.value =  '<cfoutput>#JSStringFormat(qrDestino.MUNICIPIO_ID)#</cfoutput>';					
						DESTINO_MUNICIPIO_ID.value    =  '<cfoutput>#JSStringFormat(qrDestino.MUNICIPIO_ID)#</cfoutput>';
					}
					try{
						if(NOME_REDESPACHO_COMBO.options[NOME_REDESPACHO_COMBO.selectedIndex].getAttribute('municipio_id') && !DESTINO_MUNICIPIO_COMBO.disabled){
							DESTINO_MUNICIPIO_COMBO.value = NOME_REDESPACHO_COMBO.options[NOME_REDESPACHO_COMBO.selectedIndex].getAttribute('municipio_id');
							DESTINO_MUNICIPIO_ID.value = NOME_REDESPACHO_COMBO.options[NOME_REDESPACHO_COMBO.selectedIndex].getAttribute('municipio_id');							
						}
					}catch (e){}
					
					<!--- Lote --->
					LOTE_ID.value = '';
					parent.f_limpa_select(LOTE_COMBO);
					parent.document.getElementById('lote_restrita').style.display = '';
					v_opt = parent.f_cria_option('', '-- Selecione --', LOTE_COMBO);
					<cfif qrLote.RecordCount gt 0>						
						<cfoutput query="qrLote" group="LOTE_ID">
							<cfoutput>
								v_opt = parent.f_cria_option(#qrLote.LOTE_ID#, '#JSStringFormat(qrLote.LOTE_INFO)#', LOTE_COMBO);
								var att = document.createAttribute("lote_peso_restante");       
								att.value = #qrLote.LOTE_PESO_RESTANTE#;                           
								v_opt.setAttributeNode(att); 
							</cfoutput>
						</cfoutput>		
					</cfif>

					COD_UNIDADE.value = 'Kg';
					NUM_ESPECIE.value = '<cfoutput>#JSStringFormat(qrOperacao.NUM_ESPECIE)#</cfoutput>';
					NUM_ESPECIE.onchange();
					parent.f_form_select();

					TIPO_DOCTO_FRETE.value = '<cfoutput>#qrOperacao.TIPO_DOCTO_FRETE#</cfoutput>';
					parent.f_controla_tipo_docto_frete();
					
					<!--- Datas --->
					DATA_CARREGAMENTO_INICIO.value = '<cfoutput>#qrOperacaoTempo.carga_inicio#</cfoutput>';
					DATA_CARREGAMENTO_FIM.value    = '<cfoutput>#qrOperacaoTempo.carga_termino#</cfoutput>';
					DATA_ENTREGA_INICIO.value 	   = '<cfoutput>#qrOperacaoTempo.descarga_inicio#</cfoutput>';
					DATA_ENTREGA_FIM.value         = '<cfoutput>#qrOperacaoTempo.descarga_termino#</cfoutput>';
					
					parent.f_hide_carregando_ajax();	
				}
				parent.f_get_tempo_rota();
				parent.f_muda_modalidade();
			</script> 
    	</cfcase>
        
        <!--- Manipulao dos containers --->
        <cfcase value="3"> <!--- Container --->
        	<cfscript>
				conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_solicitacao");
				qrContainer = conn.get_container(container_identificador = vars.CONTAINER_IDENTIFICADOR);
			</cfscript>
            <script type="text/javascript">
				parent.document.getElementById("CONTAINER_TIPO").value = '';
				parent.document.getElementById("CONTAINER_ID").value = '';
				parent.document.getElementById("CONTAINER_TIPO_ISO_CODE").value = '';
				parent.document.getElementById("CONTAINER_TIPO_ID").value = '';
				parent.document.getElementById("BTN_BUSCA_CONTAINER_TIPO").style.display = "none";
				parent.document.getElementById("LBL_MSG_CONTAINER").style.display = "none";
				<cfif qrContainer.recordCount eq 0>
					parent.document.getElementById("CONTAINER_TIPO_ISO_CODE").setAttribute("obrigatorio", "1");
					parent.document.getElementById("CONTAINER_TIPO_ISO_CODE").setAttribute("ativo", "1");
					parent.document.getElementById("CONTAINER_TIPO_ISO_CODE").disabled = false;
					parent.document.getElementById("CONTAINER_TIPO").setAttribute("ativo", "1");					
					parent.document.getElementById("BTN_BUSCA_CONTAINER_TIPO").style.display = "";
					parent.document.getElementById("LBL_MSG_CONTAINER").style.display = "";
					parent.document.getElementById("CONTAINER_ID").value = '';
				<cfelseif qrContainer.recordCount eq 1>
					parent.document.getElementById("CONTAINER_TIPO_ISO_CODE").setAttribute("ativo", "0");
					parent.document.getElementById("CONTAINER_TIPO_ISO_CODE").disabled = true;			
					parent.document.getElementById("BTN_BUSCA_CONTAINER_TIPO").style.display = "none";
					parent.document.getElementById("LBL_MSG_CONTAINER").style.display = "none";
					parent.document.getElementById("CONTAINER_TIPO_ISO_CODE").setAttribute("obrigatorio", "0");
					parent.document.getElementById("CONTAINER_TIPO_ISO_CODE").value = <cfoutput>'#qrContainer.ISO_CODE#'</cfoutput>;
					parent.document.getElementById("CONTAINER_TIPO").value = <cfoutput>'#qrContainer.TIPO#'</cfoutput>;
					parent.document.getElementById("CONTAINER_TIPO_ID").value = <cfoutput>'#qrContainer.TIPO_ID#'</cfoutput>;
					parent.document.getElementById("CONTAINER_ID").value = <cfoutput>'#qrContainer.CONTAINER_ID#'</cfoutput>;
				<cfelse>
					alert("Mais de um container encontrado.");
				</cfif>
			</script>
        </cfcase>
        
        <cfcase value="4"> <!--- Tipo do container --->
        	<cfscript>
				conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_solicitacao");
				qrTipo = conn.get_tipo_container(iso_code = vars.CONTAINER_TIPO_ISO_CODE);
			</cfscript>
            <script type="text/javascript">
				parent.document.getElementById("CONTAINER_TIPO").value = '';
				parent.document.getElementById("CONTAINER_TIPO_ISO_CODE").value = '';
				parent.document.getElementById("CONTAINER_TIPO_ID").value = '';
				<cfif qrTipo.recordCount eq 1>
					parent.document.getElementById("CONTAINER_TIPO_ISO_CODE").value = <cfoutput>'#qrTipo.ISO_CODE#'</cfoutput>;
					parent.document.getElementById("CONTAINER_TIPO").value = <cfoutput>'#qrTipo.TIPO#'</cfoutput>;
					parent.document.getElementById("CONTAINER_TIPO_ID").value = <cfoutput>'#qrTipo.TIPO_ID#'</cfoutput>;
				</cfif>
			</script>        
        </cfcase>        
        
        <!--- Fim da manipulao dos containers --->
		
		<cfcase value="5">
			<cfscript>
                conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_solicitacao");
                qrContratos = conn.get_cpg_aberto_dados(argumentCollection = vars);
            </cfscript>
            <cfif qrContratos.Recordcount gt 0>
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td class="texto">
                        	<fieldset><legend>Contratos ainda sem baixa financeira</legend>
                            <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                <tr class="titulo_1">
                                    <td nowrap align="left">N&ordm; contrato</td>
                                    <td nowrap align="left">N&ordm; formul&aacute;rio</td>
									<td nowrap align="left">S&eacute;rie</td>
                                    <td nowrap align="left">Data de emiss&atilde;o</td>
                                    <td nowrap align="left">N&ordm; romaneio</td>
									<td nowrap align="left">Placa cavalo</td>
									<td nowrap align="left">Placa carreta</td>
									<td nowrap align="left">Nome motorista</td>
									<td nowrap align="left">Cliente</td>
									<td nowrap align="left">Rota</td>
									
                                </tr>
                                <cfoutput query="qrContratos">
                                    <tr class="linha_#(qrContratos.CurrentRow Mod 2) + 1#">
                                        <td nowrap align="right">#qrContratos.LANCTO_ID#</td>
                                        <td nowrap align="right">#qrContratos.NUM_FORMULARIO#</td>
										<td nowrap align="left">#qrContratos.SERIE_FORMULARIO#</td>
                                        <td nowrap align="center">#qrContratos.DATA_EMISSAO#</td>
										<td nowrap align="right">#qrContratos.NUM_ROMANEIO#</td>
										<td nowrap align="center">#qrContratos.PLACA_CONTROLE#</td>
										<td nowrap align="center">#qrContratos.PLACA_REFERENCIA#</td>
                                        <td nowrap align="left">#qrContratos.MOTORISTA#</td>
										<td nowrap align="left">#qrContratos.DESTINATARIO#</td>
										<td nowrap align="left">#qrContratos.ROTA#</td>
                                    </tr>
                                </cfoutput>
                                
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                </table>
            </cfif>
        </cfcase>
        
        
        <cfcase value="100">
			<cfscript>
                conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_solicitacao");
                qrSolicitacao = conn.get_solicitacao_carga(solicitacao_carga_id		 = vars.SOLICITACAO_CARGA_ID,
														   data_carregamento_inicial = vars.DATA_INICIAL,
														   data_carregamento_final   = vars.DATA_FINAL,
														   modalidade				 = vars.MODALIDADE,
														   situacao_id				 = vars.SITUACAO_ID,
														   viagem_id				 = vars.VIAGEM_ID,
														   container_identificador   = vars.CONTAINER_IDENTIFICADOR,
														   terceirizado			     = vars.TERCEIRIZADO);
            </cfscript>
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                    <td class="texto">
                        <table width="100%" border="0" cellspacing="1" cellpadding="1">
                            <tr class="titulo_2">
                                <td nowrap align="right">Solicita&ccedil;&atilde;o</td>
                                <td nowrap align="left">Opera&ccedil;&atilde;o</td>
                                <td nowrap align="left">Remetente</td>
                                <td nowrap align="left">Origem</td>
                                <td nowrap align="left">Destinat&aacute;rio</td>
                                <td nowrap align="left">Destino</td>
                                <td nowrap align="left">In&iacute;cio Carga</td>
                                <td nowrap align="left">T&eacute;rmino Carga</td>
                                <td nowrap align="left">In&iacute;cio Descarga</td>
                                <td nowrap align="left">T&eacute;rmino Descarga</td>
                                <td nowrap align="left">Situa&ccedil;&atilde;o</td>
                                <td nowrap align="right">N&ordm; Romaneio</td>
                                <td nowrap align="left">Modalidade</td>
                                <td nowrap align="left">Container</td>
                            </tr>
                            <cfoutput query="qrSolicitacao">
                            <tr class="linha_#(qrSolicitacao.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrSolicitacao.CurrentRow Mod 2) + 1#';" onClick="f_retorna_valor('#JSStringFormat(qrSolicitacao.SOLICITACAO_CARGA_ID)#', '#JSStringFormat(qrSolicitacao.COD_ORGANOGRAMA)#')">
                                <td nowrap align="right">#qrSolicitacao.SOLICITACAO_CARGA_ID#</td>
                                <td nowrap align="left">#qrSolicitacao.OPERACAO#</td>
                                <td nowrap align="left">#qrSolicitacao.REMETENTE#</td>
                                <td nowrap align="left">#qrSolicitacao.ORIGEM#</td>
                                <td nowrap align="left">#qrSolicitacao.DESTINATARIO#</td>
                                <td nowrap align="left">#qrSolicitacao.DESTINO#</td>
                                <td nowrap align="left">#qrSolicitacao.DATA_CARREGAMENTO_INICIO#</td>
                                <td nowrap align="left">#qrSolicitacao.DATA_CARREGAMENTO_FIM#</td>
                                <td nowrap align="left">#qrSolicitacao.DATA_ENTREGA_INICIO#</td>
                                <td nowrap align="left">#qrSolicitacao.DATA_ENTREGA_FIM#</td>
                                <td nowrap align="left">#qrSolicitacao.SITUACAO#</td>
                                <td nowrap align="right">#qrSolicitacao.NUM_ROMANEIO#</td>
                                <td nowrap align="left">#qrSolicitacao.MODALIDADE#</td>
                                <td nowrap align="left">#qrSolicitacao.CONTAINER#</td>                                
                            </tr>
                            </cfoutput>
                            <cfif qrSolicitacao.RecordCount eq 0>
                            <tr>
                                <td colspan="13" align="center" valign="middle" class="obrigatorio">Nenhuma solicita&ccedil;&atilde;o de carga foi encontrada.</td>
                            </tr>
                            </cfif>
                        </table>
                    </td>
                </tr>
            </table>
        </cfcase>
    	
    	<cfdefaultcase>
			<script defer language="javascript1.2">
                alert('Operao no programada.');
            </script>
        </cfdefaultcase>
    </cfswitch>
<cfelse>
	<script defer language="javascript1.2">
		parent.f_hide_carregando_ajax();
	</script>
</cfif>
<cfabort>
