<cfscript>
	if(Isdefined("vars.SOLICITACAO_CARGA_ID")){
		conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_solicitacao");
		qrSolicitacaoForm = conn.get_solicitacao_carga_coleta_form(docto_fiscal = 0, solicitacao_carga_id = vars.SOLICITACAO_CARGA_ID);	
	}
</cfscript>
<cfif Not IsDefined("qrSolicitacaoForm")>
	<script>
		alert('Solicitao de Carga no definida!');
		window.close();
	</script>
</cfif>
<cfdocument name="pdf_autorizacao" format="pdf" orientation="portrait">
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Autorizao de Carga - Imprimir</title>
<style type="text/css">
	body {
		margin: 0;
		padding: 0;
	}
	.fonte {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-stretch: condensed;
		font-size: 9px;
	}
	.titulo {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-size: 18px;
		font-weight:bold;
	}
	.subtitulo {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-size: 11px;
		font-weight:bold;
	}
	.borda_tlbr {
		border-top: solid 1px #000;
		border-bottom: solid 1px #000;
		border-left: solid 1px #000;
		border-right: solid 1px #000;
	}
	.borda_tbr {
		border-top: solid 1px #000;
		border-bottom: solid 1px #000;
		border-right: solid 1px #000;
	}
	.borda_t {
		border-top: solid 1px #000;
	}
	.borda_b {
		border-bottom: solid 1px #000;
	}
	.borda_lbr {
		border-bottom: solid 1px #000;
		border-left: solid 1px #000;
		border-right: solid 1px #000;
	}
	.borda_br {
		border-bottom: solid 1px #000;
		border-right: solid 1px #000;
	}
</style>
</head>
<body>
<cfif IsDefined("qrSolicitacaoForm")>
	<cfif qrSolicitacaoForm.RecordCount gt 0>	
        <table width="100%" border="0" cellpadding="3" cellspacing="0" class="fonte">
        	<tr>
                <td width="33%" height="100%">&nbsp;</td>
                <td width="17%" height="100%">&nbsp;</td>
                <td width="20%" height="100%">&nbsp;</td>
                <td width="30%" height="100%">&nbsp;</td>
            </tr>
            <tr class="titulo">
              	            <cfset logo =  f_url("/_imagens/logos/logo_relatorio.jpg")/> 
                <td class="borda_tlbr"><img src="<cfoutput>#logo#</cfoutput>" height="35" /></td>
                <td colspan="2" align="center" class="borda_tbr">ORDEM DE CARREGAMENTO
                </td>
                <td align="center" class="borda_tbr"><span class="subtitulo">N&ordm;&nbsp;<cfoutput>#qrSolicitacaoForm.NUM_AUTORIZACAO_CARGA#</cfoutput></span>
                </td>
            </tr>
            <tr>
            	<td colspan="4">&nbsp;</td>
            </tr>
            <!---DADOS DO REMETENTE / CARREGAMENTO--->
            <tr class="subtitulo">
            	<td colspan="4" align="center" class="borda_tlbr">DADOS DO REMETENTE / CARREGAMENTO</td>
            </tr>
            <tr>
            	<td colspan="4" class="borda_lbr">Tranportadora:&nbsp;<cfoutput>#qrSolicitacaoForm.PROP_NOME#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="4"class="borda_lbr">Endere&ccedil;o:&nbsp;<cfoutput>#qrSolicitacaoForm.PROP_ENDERECO#</cfoutput></td>
            </tr>
            <tr>
            	<td class="borda_lbr">Bairro:&nbsp;<cfoutput>#qrSolicitacaoForm.PROP_BAIRRO#</cfoutput></td>
                <td colspan="2" class="borda_br">CNPJ:&nbsp;<cfoutput>#qrSolicitacaoForm.PROP_CNPJ_CPF#</cfoutput></td>
                <td class="borda_br">I.E.:&nbsp;<cfoutput>#qrSolicitacaoForm.PROP_IE#</cfoutput></td>
            </tr>
            <tr>
            	<td class="borda_lbr">Data:&nbsp;<cfoutput>#qrSolicitacaoForm.DATA_CARREGAMENTO#</cfoutput></td>
                <td colspan="3" class="borda_br">Filial:&nbsp;<cfoutput>#qrSolicitacaoForm.LOCAL_EMISSAO#</cfoutput></td>                                
            </tr>
            <tr>
            	<td colspan="2" class="borda_lbr">Local:&nbsp;<cfoutput>#qrSolicitacaoForm.LOCAL_CARREGAMENTO#</cfoutput></td>
                <td colspan="2" rowspan="2" class="borda_br">Cidade:&nbsp;<cfoutput>#qrSolicitacaoForm.CIDADE_CARREGAMENTO#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="2" class="borda_lbr">Pessoa de Contato:&nbsp;<cfoutput>#qrSolicitacaoForm.COLETA_CONTATO#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="2" rowspan="3" class="borda_lbr">Endere&ccedil;o:&nbsp;<cfoutput>#qrSolicitacaoForm.COLETA_ENDERECO#</cfoutput></td>
                <td colspan="2" class="borda_br">Planta/Site:&nbsp;(<cfoutput>#qrSolicitacaoForm.COLETA_PLANTA_SITE#</cfoutput>)</td>
            </tr>
            <tr>
            	<td colspan="2" class="borda_br">Porto:&nbsp;(<cfoutput>#qrSolicitacaoForm.COLETA_PORTO#</cfoutput>)</td>
            </tr>
            <tr>
            	<td colspan="2" class="borda_br">Outros:&nbsp;(<cfoutput>#qrSolicitacaoForm.COLETA_OUTROS#</cfoutput>)&nbsp;-&nbsp;<cfoutput>#qrSolicitacaoForm.COLETA_OUTROS_TEXTO#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="4" class="borda_lbr">Telefone / Fax:&nbsp;<cfoutput>#qrSolicitacaoForm.COLETA_FONE#</cfoutput></td>
            </tr>
            <!---DADOS DOS VECULOS / EQUIPAMENTOS / MOTORISTA--->
            <tr class="subtitulo">
            	<td colspan="4" align="center" class="borda_lbr">DADOS DOS VE&Iacute;CULOS / EQUIPAMENTOS / MOTORISTA</td>
            </tr>
            <tr>
            	<td colspan="2" class="borda_lbr">Frota Cavalo Mec&acirc;nico:&nbsp;<cfoutput>#qrSolicitacaoForm.FROTA_TRACAO#</cfoutput></td>
                <td colspan="2" class="borda_br">Placa Cavalo Mec&acirc;nico:&nbsp;<cfoutput>#qrSolicitacaoForm.PLACA_TRACAO#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="4" class="borda_lbr">Tipo do Ve&iacute;culo:&nbsp;&nbsp;<cfoutput>#qrSolicitacaoForm.CLASSIFICACAO#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="2" class="borda_lbr">Frota da Carreta:&nbsp;<cfoutput>#qrSolicitacaoForm.FROTA_CARRETA#</cfoutput></td>
                <td colspan="2" class="borda_br">Placa da Carreta:&nbsp;<cfoutput>#qrSolicitacaoForm.PLACA_CARRETA#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="4" class="borda_lbr">Capacidade do Ve&iacute;culo:&nbsp;<cfoutput>#qrSolicitacaoForm.CAPACIDADE#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="3" class="borda_lbr">Motorista:&nbsp;<cfoutput>#qrSolicitacaoForm.MOTORISTA#</cfoutput></td>
                <td rowspan="5" valign="middle" class="borda_br">N&ordm; CNH:&nbsp;<cfoutput>#qrSolicitacaoForm.MOTORISTA_CNH#</cfoutput></td>
            </tr>
            <tr>
            	<td class="borda_lbr">RG:&nbsp;<cfoutput>#qrSolicitacaoForm.MOTORISTA_RG#</cfoutput></td>
                <td colspan="2" class="borda_br">CPF:&nbsp;<cfoutput>#qrSolicitacaoForm.MOTORISTA_CPF#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="3" class="borda_lbr">Efetua carregamento/descarregamento:&nbsp;<cfoutput>
            	<cf_sim_nao>#qrSolicitacaoForm.EFETUA_CARREGAMENTO#</cf_sim_nao></cfoutput></td>
            </tr>
            <tr>
            	<td colspan="3" class="borda_lbr">Coopera&ccedil;&atilde;o no carregamento/descarregamento:&nbsp;<cfoutput><cf_sim_nao>#qrSolicitacaoForm.COOPERA_CARREGAMENTO#</cf_sim_nao></cfoutput></td>
            </tr>
            <tr>
            	<td colspan="3" class="borda_lbr">Detalhes das a&ccedil;&otilde;es do Motorista:&nbsp;<cfoutput>#qrSolicitacaoForm.ACOES_MOTORISTA#</cfoutput></td>
            </tr>
            <!---DADOS DO PRODUTO--->
            <tr class="subtitulo">
            	<td colspan="4" align="center"  class="borda_lbr">DADOS DO PRODUTO</td>
            </tr>
            <tr>
            	<td colspan="2" class="borda_lbr">Produto:&nbsp;<cfoutput>#qrSolicitacaoForm.DESCRICAO_CARGA_COLETADA#</cfoutput></td>
                <td colspan="2" class="borda_br">Volume carregado:&nbsp;<cfoutput>#qrSolicitacaoForm.PESO#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="2" class="borda_lbr">N&ordm; Risco:&nbsp;<cfoutput>#qrSolicitacaoForm.PRODUTO_RISCO#</cfoutput></td>
                <td colspan="2" class="borda_br">N&ordm; ONU:&nbsp;<cfoutput>#qrSolicitacaoForm.PRODUTO_ONU#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="4" class="borda_lbr">Observa&ccedil;&otilde;es:&nbsp;<cfoutput>#qrSolicitacaoForm.PRODUTO_OBSERVACOES#</cfoutput></td>
            </tr>
            <!---DADOS DO DESTINATRIO/DESCARREGAMENTO--->
            <tr class="subtitulo">
            	<td colspan="4" align="center" class="borda_lbr">DADOS DO DESTINAT&Aacute;RIO / DESCARREGAMENTO</td>
            </tr>
            <tr>
            	<td colspan="2" class="borda_lbr">Local:&nbsp;<cfoutput>#qrSolicitacaoForm.LOCAL_DESCARREGAMENTO#</cfoutput></td>
                <td colspan="2" rowspan="2" class="borda_br">Cidade:&nbsp;<cfoutput>#qrSolicitacaoForm.CIDADE_DESCARREGAMENTO#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="2"class="borda_lbr">Pessoa para Contato:&nbsp;<cfoutput>#qrSolicitacaoForm.ENTREGA_CONTATO#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="2" rowspan="3" class="borda_lbr">Endere&ccedil;o:&nbsp;<cfoutput>#qrSolicitacaoForm.ENTREGA_ENDERECO#</cfoutput></td>
                <td colspan="2" class="borda_br">Planta/Site:&nbsp;(<cfoutput>#qrSolicitacaoForm.ENTREGA_PLANTA_SITE#)</cfoutput></td>                                
            </tr>
            <tr>
            	<td colspan="2" class="borda_br">Porto:&nbsp;(<cfoutput>#qrSolicitacaoForm.ENTREGA_PORTO#</cfoutput>)</td>
            </tr>
            <tr>
            	<td colspan="2" class="borda_br">Outros:&nbsp;(<cfoutput>#qrSolicitacaoForm.ENTREGA_OUTROS#</cfoutput>)&nbsp;-&nbsp;<cfoutput>#qrSolicitacaoForm.ENTREGA_OUTROS_TEXTO#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="4"class="borda_lbr">Telefone / FAX:&nbsp;<cfoutput>#qrSolicitacaoForm.ENTREGA_FONE#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="2" align="center"class="borda_lbr">Local e Data:</td>
                <td colspan="2"class="borda_br">Ouro Verde Transporte e Loca&ccedil;&atilde;o LTDA.</td>
            </tr>
            <tr>
            	<td colspan="2" rowspan="2" valign="middle" align="center" class="borda_lbr">&nbsp;</td>
                <td colspan="2"class="borda_br">Nome:&nbsp;<cfoutput>#qrSolicitacaoForm.MOTORISTA#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="2"class="borda_br">CPF:&nbsp;<cfoutput>#qrSolicitacaoForm.MOTORISTA_CPF#</cfoutput></td>
            </tr>
            <tr>
            	<td colspan="4" align="center"><b>SEGURANA:</b>&nbsp;Motorista, seguir as regras/orienta&ccedil;&otilde;es de segurana estabelecidas pelas empresas tanto no carregamento quanto no descarregamento.</td>
            </tr>
        </table>
  	</cfif>
</cfif>
</body>
</html>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfset data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss')>
<cfpdf action="merge" destination="#path#/pdf_autorizacao_#data_hora#.pdf" overwrite="yes">
	<cfpdfparam source="pdf_autorizacao" />
</cfpdf>
<script>
	window.location = '/temp/pdf_autorizacao_<cfoutput>#data_hora#</cfoutput>.pdf';
</script>