<cfcomponent extends="_transportes.funcoes.cfc_init">

    <!---
    -- PROPSITO
    -- Busca os endereos
    -- RICARDO 21/10/2014
    --->
    <cffunction name="get_endereco" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pe.cod_endereco
                 , pe.cod_pessoa
                 , pe.logradouro || ', '|| pe.numero ||' - '|| pe.bairro || ' CEP '|| pe.cep ||' - '|| pe.municipio||'/'||pe.uf as endereco
                 , pe.endereco_padrao
                 , pe.municipio_id
                 , pe.municipio||'-'||pe.uf as municipio_uf
                 , pe.inscricao_estadual
              from kss.v$pessoa_endereco_todos pe
              <cfif Len(Trim(#arguments.cod_pessoa#))>
                 where pe.cod_pessoa = #arguments.cod_pessoa#
              <cfelse>
                 where 1 = 0
             </cfif>
             order by pe.endereco_padrao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


    <!---
    -- PROPSITO
    -- Busca as solicitaes de carga
    -- CRISTOFER  08/04/2009
    --->
    <cffunction name="get_solicitacao_carga" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfargument name="cod_organograma" required="no" default="">
        <cfargument name="data_carregamento_inicial" required="no" default="">
        <cfargument name="data_carregamento_final" required="no" default="">
        <cfargument name="atendido" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="situacao_logistica_id" required="no" default="">
        <cfargument name="viagem_id" required="no" default="">
        <cfargument name="cod_pessoa_remetente" required="no" default="">
        <cfargument name="cod_pessoa_destinatario" required="no" default="">
        <cfargument name="container_identificador" required="no" default="">
        <cfargument name="terceirizado" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct sc.solicitacao_carga_id
                 , sc.operacao_id
                 , oper.descricao as operacao
                 , oper.pedido_shipment as pedido_shiment_obrigatorio
                 , a.viagem_id as viagem_id
                 , sc.cod_organograma
                 , kss.pkg_organograma.fnc_unidade_negocio(o.cod_pessoa) as unidade_negocio
                 , kss.pkg_organograma.fnc_departamento(o.cod_departamento) as departamento
                 , kss.pkg_organograma.fnc_setor(o.cod_setor) as setor
                 , kss.pkg_organograma.fnc_centro_custo(o.cod_centro_custo) as centro_custo
                 , sc.num_natureza
                 , (select nat.descricao
                      from oper.v$natureza nat
                     where nat.num_natureza = sc.num_natureza) as natureza
                   /* Remetente */
                 , sc.cod_remetente
                 , kss.pkg_pessoa.fnc_get_cliente(sc.cod_remetente) as remetente
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = sc.cod_remetente) as rem_cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_endereco(sc.cod_remetente, 1) as rem_endereco
                   /* Destinatrio */
                 , sc.cod_destinatario
                 , kss.pkg_pessoa.fnc_get_cliente(sc.cod_destinatario) as destinatario
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = sc.cod_destinatario) as dest_cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_endereco(sc.cod_destinatario, 1) as dest_endereco
                   /* Consignatrio */
                 , sc.cod_consignatario
                 , kss.pkg_pessoa.fnc_get_cliente(sc.cod_consignatario) as consignatario
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = sc.cod_consignatario) as cons_cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_endereco(sc.cod_consignatario, 1) as cons_endereco
                   /* Redespacho */
                 , sc.cod_redespacho
                 , kss.pkg_pessoa.fnc_get_cliente(sc.cod_redespacho) as redespacho
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = sc.cod_redespacho) as red_cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_endereco(sc.cod_redespacho, 1) as red_endereco
                   /* Cobrana */
                 , sc.cod_cobranca
                 , kss.pkg_pessoa.fnc_get_cliente(sc.cod_cobranca) as cobranca
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = sc.cod_cobranca) as cob_cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_endereco(sc.cod_cobranca, 1) as cob_endereco
                   /* Origem */
                 , sc.origem_municipio_id
                 , cep.pkg_municipio.fnc_municipio_uf(sc.origem_municipio_id) as origem
                   /* Destino */
                 , sc.destino_municipio_id
                 , cep.pkg_municipio.fnc_municipio_uf(sc.destino_municipio_id) as destino
                   /* Motorista */
                 , nvl(a.cod_motorista,sc.cod_motorista) as cod_motorista
                 , kss.pkg_pessoa.fnc_get_cliente(nvl(a.cod_motorista,sc.cod_motorista)) as motorista
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = nvl(a.cod_motorista,sc.cod_motorista)) as mot_cpf
                 , (select p.identificador
                      from kss.v$pessoa p
                     where p.cod_pessoa = nvl(a.cod_motorista,sc.cod_motorista)) as cpf_motorista
                 , (select scc.cod_veiculo
                      from logistica.v$solicitacao_carga_composicao scc
                     where scc.solicitacao_carga_id = sc.solicitacao_carga_id
                       and scc.ordem = 1) as cod_veiculo_tracao

                 , sc.modalidade
                 , nvl(sc.liberada_agendamento,0) as liberada_agendamento
                 , sc.nf_numero
                 , to_char(sc.nf_data_emissao, 'dd/mm/yyyy') as nf_data_emissao
                 , sc.valor_total_nf
                 , sc.valor_total_sugerido
                 , sc.valor_em
                 , sc.m3
                 , sc.peso_especifico
                 , sc.qtde_volume
                 , sc.peso_volume
                 , sc.cod_unidade
                 , sc.num_especie
                 , sc.peso
                 , sc.valor_unitario
                 , sc.valor_total

                 , to_char(sc.data_carregamento_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_carregamento_inicio
                 , to_char(sc.data_carregamento_fim, 'dd/mm/yyyy hh24:mi:ss') as data_carregamento_fim
                 , to_char(sc.data_entrega_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_entrega_inicio
                 , to_char(sc.data_entrega_fim, 'dd/mm/yyyy hh24:mi:ss') as data_entrega_fim

                 , to_char(sc.data_carregamento_inicio, 'dd/mm/yyyy') as data_carregamento
                 , to_char(sc.data_carregamento_inicio, 'hh24:mi') as hora_carregamento_inicio
                 , to_char(sc.data_carregamento_fim, 'hh24:mi') as hora_carregamento_fim

                 , to_char(sc.data_entrega_inicio, 'dd/mm/yyyy') as data_entrega
                 , to_char(sc.data_entrega_inicio, 'hh24:mi') as hora_entrega_inicio
                 , to_char(sc.data_entrega_fim, 'hh24:mi') as hora_entrega_fim
                 , sc.observacao
                 , ri.num_romaneio
                 , sc.situacao_id
                 , case
                      when sc.situacao_id = 4 then 1
                      else 0
                   end as atendido
                 , kss.fnc_ref_code('LOGISTICA', 'SOLICITACAO_CARGA.SITUACAO_ID', sc.situacao_id) situacao
                 , kss.fnc_ref_code('LOGISTICA', 'SOLICITACAO_CARGA.SITUACAO_LOGISTICA_ID', sc.situacao_logistica_id) as situacao_logistica
                 , to_char(sc.date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , sc.user_insert
                 , to_char(sc.date_update,'dd/mm/yyyy hh24:mi:ss') as date_update
                 , sc.user_update
                 , to_char(c.data_emissao, 'dd/mm/yyyy') as data_emissao

                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) as frota_cavalo_rom
                 , r.placa_controle as placa_cavalo_rom
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_referencia) as frota_carreta_rom
                 , r.placa_referencia as placa_carreta_rom
                 , (select v.cod_veiculo
                      from logistica.v$viagem_veiculo vv
                     inner join oper.v$veiculo v
                        on v.veiculo_id = vv.veiculo_id
                     where vv.posicao = 2
                       and vv.viagem_id = a.viagem_id) as frota_carreta2_rom
                 , (select v.placa
                      from logistica.v$viagem_veiculo vv
                     inner join oper.v$veiculo v
                        on v.veiculo_id = vv.veiculo_id
                     where vv.posicao = 2
                       and vv.viagem_id = a.viagem_id) as placa_carreta2_rom
                 , (select v.cod_veiculo
                      from logistica.v$viagem_veiculo vv
                     inner join oper.v$veiculo v
                        on v.veiculo_id = vv.veiculo_id
                     where vv.posicao = 3
                       and vv.viagem_id = a.viagem_id) as frota_carreta3_rom
                 , (select v.placa
                      from logistica.v$viagem_veiculo vv
                     inner join oper.v$veiculo v
                        on v.veiculo_id = vv.veiculo_id
                     where vv.posicao = 3
                       and vv.viagem_id = a.viagem_id) as placa_carreta3_rom

                 , (select v.cod_veiculo
                      from logistica.v$solicitacao_carga_composicao scc
                     inner join oper.v$veiculo v
                        on v.veiculo_id = scc.veiculo_id
                     where scc.ordem = 1
                       and scc.solicitacao_carga_id = sc.solicitacao_carga_id) as frota_cavalo_sol
                 , (select v.placa
                      from logistica.v$solicitacao_carga_composicao scc
                     inner join oper.v$veiculo v
                        on v.veiculo_id = scc.veiculo_id
                     where scc.ordem = 1
                       and scc.solicitacao_carga_id = sc.solicitacao_carga_id) as placa_cavalo_sol
                 , (select v.cod_veiculo
                      from logistica.v$solicitacao_carga_composicao scc
                     inner join oper.v$veiculo v
                        on v.veiculo_id = scc.veiculo_id
                     where scc.ordem = 2
                       and scc.solicitacao_carga_id = sc.solicitacao_carga_id) as frota_carreta_sol
                 , (select v.placa
                      from logistica.v$solicitacao_carga_composicao scc
                     inner join oper.v$veiculo v
                        on v.veiculo_id = scc.veiculo_id
                     where scc.ordem = 2
                       and scc.solicitacao_carga_id = sc.solicitacao_carga_id) as placa_carreta_sol
                 , (select v.cod_veiculo
                      from logistica.v$solicitacao_carga_composicao scc
                     inner join oper.v$veiculo v
                        on v.veiculo_id = scc.veiculo_id
                     where scc.ordem = 3
                       and scc.solicitacao_carga_id = sc.solicitacao_carga_id) as frota_carreta2_sol
                 , (select v.placa
                      from logistica.v$solicitacao_carga_composicao scc
                     inner join oper.v$veiculo v
                        on v.veiculo_id = scc.veiculo_id
                     where scc.ordem = 3
                       and scc.solicitacao_carga_id = sc.solicitacao_carga_id) as placa_carreta2_sol
                 , (select v.cod_veiculo
                      from logistica.v$solicitacao_carga_composicao scc
                     inner join oper.v$veiculo v
                        on v.veiculo_id = scc.veiculo_id
                     where scc.ordem = 4
                       and scc.solicitacao_carga_id = sc.solicitacao_carga_id) as frota_carreta3_sol
                 , (select v.placa
                      from logistica.v$solicitacao_carga_composicao scc
                     inner join oper.v$veiculo v
                        on v.veiculo_id = scc.veiculo_id
                     where scc.ordem = 4
                       and scc.solicitacao_carga_id = sc.solicitacao_carga_id) as placa_carreta3_sol

                 , coalesce(oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle),(select v.cod_veiculo
                                                                                      from logistica.v$solicitacao_carga_composicao scc
                                                                                      inner join oper.v$veiculo v
                                                                                              on v.veiculo_id = scc.veiculo_id
                                                                                      where scc.ordem = 1
                                                                                        and scc.solicitacao_carga_id = sc.solicitacao_carga_id)) as frota_cavalo
                 , coalesce(r.placa_controle,(select v.placa
                                          from logistica.v$solicitacao_carga_composicao scc
                                          inner join oper.v$veiculo v
                                                  on v.veiculo_id = scc.veiculo_id
                                          where scc.ordem = 1
                                            and scc.solicitacao_carga_id = sc.solicitacao_carga_id)) as placa_cavalo

                 , coalesce(oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_referencia),(select v.cod_veiculo
                                                                                  from logistica.v$solicitacao_carga_composicao scc
                                                                                  inner join oper.v$veiculo v
                                                                                          on v.veiculo_id = scc.veiculo_id
                                                                                  where scc.ordem = 2
                                                                                    and scc.solicitacao_carga_id = sc.solicitacao_carga_id)) as frota_carreta
                 , coalesce(r.placa_referencia,(select v.placa
                                              from logistica.v$solicitacao_carga_composicao scc
                                              inner join oper.v$veiculo v
                                                      on v.veiculo_id = scc.veiculo_id
                                              where scc.ordem = 2
                                                    and scc.solicitacao_carga_id = sc.solicitacao_carga_id)) as placa_carreta
            ,coalesce((select v.cod_veiculo
                 from logistica.v$viagem_veiculo vv
                inner join oper.v$veiculo v
                   on v.veiculo_id = vv.veiculo_id
                where vv.posicao = 2
                  and vv.viagem_id = a.viagem_id),
                 (select v.cod_veiculo
                    from logistica.v$solicitacao_carga_composicao scc
                   inner join oper.v$veiculo v
                      on v.veiculo_id = scc.veiculo_id
                   where scc.ordem = 3
                     and scc.solicitacao_carga_id = sc.solicitacao_carga_id)) as frota_carreta2
            ,coalesce((select v.placa
                 from logistica.v$viagem_veiculo vv
                inner join oper.v$veiculo v
                   on v.veiculo_id = vv.veiculo_id
                where vv.posicao = 2
                  and vv.viagem_id = a.viagem_id),
              (select v.placa
                 from logistica.v$solicitacao_carga_composicao scc
                inner join oper.v$veiculo v
                   on v.veiculo_id = scc.veiculo_id
                where scc.ordem = 3
                  and scc.solicitacao_carga_id = sc.solicitacao_carga_id)) as placa_carreta2
            ,coalesce((select v.cod_veiculo
                 from logistica.v$viagem_veiculo vv
                inner join oper.v$veiculo v
                   on v.veiculo_id = vv.veiculo_id
                where vv.posicao = 3
                  and vv.viagem_id = a.viagem_id),
              (select v.cod_veiculo
                 from logistica.v$solicitacao_carga_composicao scc
                inner join oper.v$veiculo v
                   on v.veiculo_id = scc.veiculo_id
                where scc.ordem = 4
                  and scc.solicitacao_carga_id = sc.solicitacao_carga_id)) as frota_carreta3
            ,coalesce((select v.placa
                 from logistica.v$viagem_veiculo vv
                inner join oper.v$veiculo v
                   on v.veiculo_id = vv.veiculo_id
                where vv.posicao = 3
                  and vv.viagem_id = a.viagem_id),
              (select v.placa
                 from logistica.v$solicitacao_carga_composicao scc
                inner join oper.v$veiculo v
                   on v.veiculo_id = scc.veiculo_id
                where scc.ordem = 4
                  and scc.solicitacao_carga_id = sc.solicitacao_carga_id)) as placa_carreta3
                 ,(select crt.num_crt_completo
                     from logistica.v$solicitacao_carga_crt scrt
                    inner join fiscal.v$intc_conhecimento crt
                       on crt.conhecimento_id = scrt.conhecimento_id
                    where scrt.solicitacao_carga_id = sc.solicitacao_carga_id) as num_crt_completo
                 ,(select cg.rv_abbreviation
                   from logistica.v$cg_ref_codes cg
                  where cg.rv_domain = 'PRIORIDADE'
                    and cg.rv_low_value = sc.prioridade) as prioridade
                ,sc.prioridade as prioridade_id
                ,(select max(eos.DESCRICAO_RESUMIDA) keep(dense_rank last order by re.CONTROLE_EVO_ID)
                    from oper.v$evento_operacao e
                   inner join oper.v$evento_operacao_setup eos
                      on eos.NUM_EVENTO = e.num_evento
                   inner join oper.v$romaneio_evento re
                      on re.CONTROLE_EVO_ID = e.controle_evo_id
                   where re.NUM_ROMANEIO = r.NUM_ROMANEIO
                     and eos.NUM_GRUPO = 1
                     and eos.PRIORIDADE = 1
                  ) as situacao_romaneio
    ,(select rtrim(kss.fnc_concat_all(kss.to_concat_expr(ordem_compra_cliente,', ')),', ')
                   from( select scnf.ordem_compra_cliente, solicitacao_carga_id
                           from logistica.v$solicitacao_carga_nf scnf
                          where scnf.ordem_compra_cliente is not null
                          group by scnf.ordem_compra_cliente,solicitacao_carga_id)
                   where solicitacao_carga_id = sc.solicitacao_carga_id) as pedido
                 , (select kss.fnc_concat_all(distinct kss.to_concat_expr(c.num_conhecimento,'/'))
                      from fiscal.v$conhecimento c
                     inner join logistica.v$solicitacao_carga_documento scd
                       on scd.conhecimento_id = c.conhecimento_id
                      where scd.solicitacao_carga_id = sc.solicitacao_carga_id) as num_conhecimento
                , co.num_formulario as ordem_coleta
                , to_char(co.data_impressao,'dd/mm/yyyy') as aut_carga
                , (select case
                             when sct.solicitacao_id_segundo_trecho = sc.solicitacao_carga_id then
                                sct.solicitacao_id_primeiro_trecho
                          end as solicitacao_trecho
                     from logistica.v$solicitacao_carga_trecho sct
                    where sct.solicitacao_id_primeiro_trecho = sc.solicitacao_carga_id
                       or sct.solicitacao_id_segundo_trecho = sc.solicitacao_carga_id) as solicitacao_primeiro_trecho
                , (select case
                             when sct.solicitacao_id_primeiro_trecho = sc.solicitacao_carga_id then
                                sct.solicitacao_id_segundo_trecho
                           end as solicitacao_trecho
                      from logistica.v$solicitacao_carga_trecho sct
                     where sct.solicitacao_id_primeiro_trecho = sc.solicitacao_carga_id
                        or sct.solicitacao_id_segundo_trecho = sc.solicitacao_carga_id) as solicitacao_segundo_trecho
                , nvl((nvl((select case
                                      when c.cod_retorno = 1 then
                                         'Liberado'
                                      when c.cod_retorno = 0 or c.cod_retorno is null then
                                         'Pendente de retorno'
                                      else
                                         'No recomendado'
                                   end
                              from grisco.v$consulta c
                             where c.viagem_id = a.viagem_id)
                           , 'No Consultado'))
                      ,(select 'OK'
                          from logistica.v$operacao_seguro os
                         where sc.operacao_id = os.operacao_id
                           and os.data_exclusao is null
                           and os.exige_monitoramento = 0)) as GR
                      , sc.pedido_shipment
                      , (select ps.pre_ordem_id
                           from grisco.v$pre_ordem_sol_carga ps
                          where ps.solicitacao_carga_id = sc.solicitacao_carga_id
                            and ps.data_cancelamento is null) as pre_ordem_id
                 , sc.endereco_coleta_id
                 , sc.endereco_entrega_id
                 , sc.endereco_cobranca_id
                 , sc.endereco_remetente_id
                 , sc.endereco_destinatario_id
                 , (select ctn.identificador
                      from multimodal.v$container ctn
                     inner join multimodal.v$movto_container mc
                        on mc.container_id = ctn.container_id
                     inner join multimodal.v$movto_container_it mi
                        on mi.movto_container_id = mc.movto_container_id
                     where mi.solicitacao_carga_id = sc.solicitacao_carga_id
                       and mc.data_estorno is null
                       and mc.movto_situacao_id <> 10
                       and not exists (select *
                                         from multimodal.v$movto_evento me
                                        where me.movto_container_id = mc.movto_container_id
                                          and me.evento_id = 6)) as container
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = sc.cod_transportador_sugerido ) as transportador_sugerido
                 , (select distinct ccc.carga_consolidada_id
                      from logistica.v$carga_consolidada_carga ccc
                     where ccc.solicitacao_carga_id = sc.solicitacao_carga_id
                       and ccc.situacao_id not in (0,5)) as CARGA_CONSOLIDADA_ID
                 , (select sign(count(1))
                      from multimodal.v$movto_container_it i
                     inner join multimodal.v$movto_container mc
                        on mc.movto_container_id = i.movto_container_id
                       and mc.data_estorno is null
                     where i.solicitacao_carga_id = sc.solicitacao_carga_id) as possui_movto_container
                 , sc.container_vazio
                 , sc.cod_transportador_sugerido
                 , sc.lote_id
              from logistica.v$solicitacao_carga sc
             inner join kss.v$organograma o
                     on o.cod_organograma = sc.cod_organograma
             inner join logistica.v$operacao oper
                    on oper.operacao_id = sc.operacao_id
              left join (select vc.viagem_id, vc.solicitacao_carga_id, vc.viagem_carga_id, v.cod_motorista, vc.carga_consolidada_id
                           from logistica.v$solicitacao_carga_viagem vc
                          inner join logistica.v$viagem v
                                  on v.viagem_id = vc.viagem_id
                                 and v.situacao_id <> 0
                                 <cfif len(trim(arguments.viagem_id))>
                                   and v.viagem_id = #arguments.viagem_id#
                                </cfif>
                                 
                                 ) a
                     on sc.solicitacao_carga_id = a.solicitacao_carga_id

              left join oper.v$romaneio_item ri
                     on ri.viagem_carga_id = a.viagem_carga_id
                     or ri.carga_consolidada_id = a.carga_consolidada_id
              left join oper.v$romaneio r
                     on r.num_romaneio = ri.num_romaneio
              left join fiscal.v$conhecimento c
                     on c.num_romaneio = r.num_romaneio
                    and c.item_id = ri.item_id
             left join logistica.v$solicitacao_carga_coleta co
               on sc.solicitacao_carga_id = co.solicitacao_carga_id
             
             where 1 = 1
            <cfif len(trim(arguments.solicitacao_carga_id))>
               and sc.solicitacao_carga_id in (#arguments.solicitacao_carga_id#)
            </cfif>
            <cfif len(trim(arguments.cod_organograma))>
               and sc.cod_organograma in (#arguments.cod_organograma#)
            </cfif>
            <cfif len(trim(arguments.data_carregamento_inicial))>
               and trunc(sc.data_carregamento_inicio) >= '#arguments.data_carregamento_inicial#'
            </cfif>
            <cfif len(trim(arguments.data_carregamento_final))>
               and trunc(sc.data_carregamento_fim) <= '#arguments.data_carregamento_final#'
            </cfif>
            <cfif len(trim(arguments.situacao_id))>
               and sc.situacao_id in (#arguments.situacao_id#)
            </cfif>
            <cfif len(trim(arguments.situacao_logistica_id))>
               and sc.situacao_logistica_id in (#arguments.situacao_logistica_id#)
            </cfif>
            <cfif arguments.atendido eq 1>
               and sc.situacao_id in (2)
            </cfif>
            <cfif arguments.atendido eq 0>
               and sc.situacao_id not in (2)
            </cfif>
            <cfif len(trim(arguments.viagem_id))>
               and sc.solicitacao_carga_id in (select vc.solicitacao_carga_id
                                                 from logistica.v$solicitacao_carga_viagem vc
                                                where vc.viagem_id = #arguments.viagem_id#)
            </cfif>
            <cfif len(trim(arguments.cod_pessoa_remetente))>
               and sc.cod_remetente = #arguments.cod_pessoa_remetente#
            </cfif>
            <cfif len(trim(arguments.cod_pessoa_destinatario))>
               and sc.cod_destinatario = #arguments.cod_pessoa_destinatario#
            </cfif>
            <cfif len(trim(arguments.CONTAINER_IDENTIFICADOR))>
               and exists (select 1
                             from multimodal.v$container ctn
                            inner join multimodal.v$movto_container mc
                               on mc.container_id = ctn.container_id
                            inner join multimodal.v$movto_container_it mi
                               on mi.movto_container_id = mc.movto_container_id
                            where mi.solicitacao_carga_id = sc.solicitacao_carga_id
                              and mc.data_estorno is null
                              and mc.movto_situacao_id <> 10
                              and not exists (select *
                                                from multimodal.v$movto_evento me
                                               where me.movto_container_id = mc.movto_container_id
                                                 and me.evento_id = 6)
                              and upper(ctn.identificador) like upper('#arguments.CONTAINER_IDENTIFICADOR#') || '%')
             </cfif>
             <cfif len(trim(arguments.TERCEIRIZADO)) and arguments.TERCEIRIZADO eq 1>
                and sc.liberada_agendamento = 1
                and sc.cod_transportador_sugerido = (select us.cod_pessoa
                                                       from kss.v$usuarios us
                                                      where us.usuario = user )
                and exists (select 1 from logistica.v$carga_consolidada_carga ccc where ccc.solicitacao_carga_id = sc.solicitacao_carga_id and ccc.situacao_id <> 0)
             </cfif>
             order by to_char(sc.data_carregamento_inicio, 'dd/mm/yyyy hh24:mi:ss')
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca os dados da viagem vinculada a solicitacao
    -- CRISTOFER  13/05/2009
    --->
    <cffunction name="get_solicitacao_carga_viagem" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select solicitacao_carga_Id,
                   cod_motorista,
                   kss.pkg_pessoa.fnc_get_cliente(cod_motorista) as motorista,
                   placa_tracao,
                   modalidade,
                   cod_proprietario,
                   kss.pkg_pessoa.fnc_get_cliente(cod_proprietario) as proprietario,
                   composicao
              from (select solicitacao_carga_id,
                           logistica.pkg_agendamento.fnc_viagem_motorista(vc.viagem_id) as cod_motorista,
                           oper.pkg_veiculo.fnc_placa(logistica.pkg_agendamento.fnc_viagem_tracao(vc.viagem_id)) as placa_tracao,
                           v.modalidade,
                           logistica.pkg_agendamento.fnc_viagem_composicao(vc.viagem_id,null,',',0) as composicao,
                           (select cod_pessoa
                              from oper.v$veiculo_proprietario vm
                             where vm.placa = oper.pkg_veiculo.fnc_placa(logistica.pkg_agendamento.fnc_viagem_tracao(vc.viagem_id))
                               and vm.data_fim is null) as cod_proprietario,
                           v.situacao_id
                      from logistica.v$viagem_carga vc
                     inner join logistica.v$viagem v
                             on v.viagem_id = vc.viagem_id
                            and v.situacao_id not in (0)
                     where 1=1
                     <cfif len(trim(arguments.solicitacao_carga_id))>
                       and vc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
                     </cfif>
                       )
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca os dados de uma solicitao de carga para o formulrio de impresso de ACT
    -- ANDERSON 26/05/2009
    --->
    <cffunction name="get_solicitacao_carga_act_form" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select scaf.solicitacao_carga_id,
                   scaf.nf_numero,
                   scaf.nf_data_emissao,
                   scaf.quant_solicitada,
                   scaf.produto,
                   scaf.situacao_id,
                   scaf.data_impressao,
                   scaf.data_carregamento,
                   scaf.motorista,
                   scaf.razao_social,
                   scaf.frota_tracao,
                   scaf.placa_tracao,
                   scaf.frota_carreta,
                   scaf.placa_carreta,
                   scaf.dest_cnpj_cpf,
                   scaf.dest_razao_social,
                   scaf.dest_endereco,
                   scaf.dest_identificador,
                   scaf.dest_inscricao_estadual,
                   scaf.dest_municipio,
                   scaf.dest_uf,
                   scaf.dest_cep,
                   scaf.rem_cnpj_cpf,
                   scaf.rem_razao_social,
                   scaf.rem_endereco,
                   scaf.rem_identificador,
                   scaf.rem_inscricao_estadual,
                   scaf.rem_municipio,
                   scaf.rem_uf,
                   scaf.rem_cep,
                   scaf.cons_cnpj_cpf,
                   scaf.cons_razao_social,
                   scaf.cons_endereco,
                   scaf.cons_identificador,
                   scaf.cons_inscricao_estadual,
                   scaf.cons_municipio,
                   scaf.cons_uf,
                   scaf.cons_cep,
                   scaf.emitente,
                   scaf.local_emitente,
                   scaf.data_emissao,
                   sca.num_formulario,
                   upper(sca.observacao) as observacao
              from logistica.v$solicitacao_carga_act_form scaf
              left join logistica.v$solicitacao_carga_act sca
                     on sca.solicitacao_carga_id = scaf.solicitacao_carga_id
             where scaf.solicitacao_carga_id = #arguments.solicitacao_carga_id#
               and scaf.situacao_id <> 0
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca os dados de uma solicitao de carga para o formulrio de impresso de Coleta
    -- ANDERSON 27/05/2009
    --->
    <cffunction name="get_solicitacao_carga_coleta_form" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfargument name="docto_fiscal" required="no" default="0">
        <cfargument name="gerar" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select scc.num_autorizacao_carga,
                   sc.situacao_id,
                   to_char(sysdate,'dd/mm/yyyy') as data_impressao,
                   kss.pkg_pessoa.fnc_get_cliente((select vp.cod_pessoa
                                                     from oper.v$veiculo_proprietario vp
                                                    where vp.placa = oper.pkg_veiculo.fnc_placa(v.veiculo_id)
                                                      and v.data_inicio between vp.data_inicio and nvl(vp.data_fim, v.data_inicio))) as razao_social,
                   oper.pkg_veiculo.fnc_cod_veiculo(v.veiculo_id) as frota_tracao,
                   oper.pkg_veiculo.fnc_placa(v.veiculo_id) as placa_tracao,
                   oper.pkg_veiculo.fnc_cod_veiculo(v.veiculo_id_referencia) as frota_carreta,
                   oper.pkg_veiculo.fnc_placa(v.veiculo_id_referencia) as placa_carreta,
                   rem.cod_pessoa as cod_remetente,
                   upper(rem.razao_social) as rem_razao_social,
                   upper(r_end.endereco) as rem_endereco,
                   upper(r_end.municipio) as rem_municipio,
                   ptr.telefone as rem_telefone,
                   rem.identificador as rem_identificador,
                   rem.inscricao_estadual as rem_inscricao_estadual,
                   r_end.uf as rem_uf,
                   r_end.cep as rem_cep,
                   r_end.bairro as rem_bairro,
                   ptr.telefone as rem_telefone,
                   upper(ptr.telefone_contato) as rem_contato,
                   d_end.municipio as dest_municipio,
                   kss.pkg_pessoa.fnc_get_cliente(sc.cod_destinatario) as destinatario,
                   ptd.telefone_contato as dest_contato,
                   ptd.telefone as dest_telefone,
                   d_end.endereco as dest_endereco,
                   'Solicitante' as nome_solicitante,
                   '00:00' as hora_chamada,
                   to_char(v.data_inicio, 'dd/mm/yyyy') as data_carregamento,
                   sc.num_especie,
                   (select n.descricao
                      from oper.v$natureza n
                     where n.num_natureza = sc.num_natureza) as material,
                   (select n.descricao
                      from oper.v$natureza n
                     where n.num_natureza = sc.num_natureza) as material,
                   rtrim(to_char(sc.peso,'FM999G999D99','nls_numeric_characters='',.'''),',') as peso,
                   sc.qtde_volume as volume_total,
                   kss.pkg_pessoa.fnc_get_cliente(v.cod_motorista) as motorista,
                   pf.cnh_num_registro as motorista_cnh,
                   pf.cart_ident_num as motorista_rg,
                   kss.pkg_string.fnc_formata_cnpj_cpf(pf.cpf || pf.cpf_dv) as motorista_cpf,
                   'Chapa' as chapa,
                   sc.qtde_volume as quantidade,
                   (select es.descricao
                     from oper.v$especie es
                    where es.num_especie = sc.num_especie) as tipo_volume,
                   (select n.descricao
                      from oper.v$natureza n
                     where n.num_natureza = sc.num_natureza) as descricao_carga_coletada,
                   (select ngr.cod_risco
                      from oper.v$natureza_grupo_risco ngr
                     where ngr.risco_id =  (select no2.risco_id
                                              from oper.v$natureza_onu no2
                                             where no2.natureza_onu_id = (select n3.natureza_onu_id
                                                                           from oper.v$natureza n3
                                                                          where n3.num_natureza = sc.num_natureza))) as produto_risco,
                   (select no.num_natureza_onu
                      from oper.v$natureza_onu no
                     where no.natureza_onu_id = (select n2.natureza_onu_id
                                                   from oper.v$natureza n2
                                                  where n2.num_natureza = sc.num_natureza)) as produto_onu,
                   scc.produto_observacoes,
                   to_char(sc.nf_data_emissao, 'dd/mm/yyyy') as data_nf,
                   sc.nf_numero as num_nota_fiscal,
                   cep.fnc_municipio_uf(sc.destino_municipio_id) as destino,
                   cc.centro_custo as local_emissao,
                   scc.num_formulario,
                   scc.local_carregamento,
                   scc.cidade_carregamento,
                   scc.coleta_contato,
                   scc.coleta_endereco,
                   scc.coleta_fone,
                   decode(scc.coleta_planta_site, 0, '', 1, 'X') as coleta_planta_site,
                   decode(scc.coleta_porto, 0, '', 1, 'X') as coleta_porto,
                   decode(scc.coleta_outros, 0, '', 1, 'X') as coleta_outros,
                   scc.coleta_outros_texto,
                   decode(scc.entrega_planta_site, 0, ' ', 1, 'X') as entrega_planta_site,
                   decode(scc.entrega_porto, 0, ' ', 1, 'X') as entrega_porto,
                   decode(scc.entrega_outros, 0, ' ', 1, 'X') as entrega_outros,
                   scc.entrega_outros_texto,
                   scc.efetua_carregamento,
                   scc.coopera_carregamento,
                   scc.acoes_motorista,
                   scc.local_descarregamento,
                   scc.cidade_descarregamento,
                   scc.entrega_contato,
                   scc.entrega_fone,
                   scc.entrega_endereco,
                   cc.centro_custo as local_emissao,
                   (select m.municipio
                      from cep.municipio m
                     where m.municipio_id = sc.origem_municipio_id) as coleta_municipio,
                   to_char((oper.pkg_veiculo.fnc_capacidade_carga_compo(oper.pkg_veiculo.fnc_placa(v.veiculo_id),scc.data_coleta)),'FM9G9999G990','nls_numeric_characters=,.') as capacidade,
                   (select vd.classificacao
                      from oper.v$veiculo_dados vd
                     where vd.placa = oper.pkg_veiculo.fnc_placa(v.veiculo_id_referencia)) as classificacao,
                   (select vd.classificacao
                      from oper.v$veiculo_dados vd
                     where vd.placa = oper.pkg_veiculo.fnc_placa(v.veiculo_id_referencia)) as classificacao,
                   (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = decode(v.viagem_id, null, null, oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(oper.pkg_veiculo.fnc_placa(v.veiculo_id), to_char(v.data_inicio, 'dd/mm/yyyy')))) as prop_nome,
                   (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = decode(v.viagem_id, null, null, oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(oper.pkg_veiculo.fnc_placa(v.veiculo_id), to_char(v.data_inicio, 'dd/mm/yyyy')))) as prop_cnpj_cpf,
                   (select p.inscricao_estadual
                      from kss.v$pessoa p
                     where p.cod_pessoa = decode(v.viagem_id, null, null, oper.pkg_veiculo.fnc_pessoa_proprietario(oper.pkg_veiculo.fnc_placa(v.veiculo_id), to_char(v.data_inicio, 'dd/mm/yyyy')))) as prop_ie,
                   pep.endereco as prop_endereco,
                   pep.bairro as prop_bairro,
                   pep.municipio || ' - ' || pep.uf as prop_endereco,
                   (select sign(instr(lower(e1.razao_social), 'bbm'))
                      from kss.v$empresa e1) as is_bbm
              from logistica.v$solicitacao_carga sc
              left join logistica.v$solicitacao_carga_viagem vc
                     on vc.solicitacao_carga_id = sc.solicitacao_carga_id
              left join logistica.v$viagem v
                     on vc.viagem_id = v.viagem_id
              left join logistica.v$solicitacao_carga_coleta scc
                     on scc.solicitacao_carga_id = sc.solicitacao_carga_id
              left join kss.v$pessoa_fisica pf
                     on pf.cod_pessoa = v.cod_motorista
              left join kss.v$pessoa rem
                     on sc.cod_remetente = rem.cod_pessoa
              left join kss.v$pessoa_endereco_todos r_end
                     on r_end.cod_pessoa = rem.cod_pessoa
                    and (r_end.cod_endereco = sc.endereco_remetente_id
                         or (sc.endereco_remetente_id is null and r_end.endereco_padrao = 1))
              left join kss.v$pessoa_telefone_padrao ptr
                     on ptr.cod_pessoa = rem.cod_pessoa
              left join kss.v$pessoa dest
                     on sc.cod_destinatario = dest.cod_pessoa
              left join kss.v$pessoa_endereco_todos d_end
                     on d_end.cod_pessoa = dest.cod_pessoa
                    and (d_end.cod_endereco = sc.endereco_destinatario_id
                         or (sc.endereco_destinatario_id is null and d_end.endereco_padrao = 1))
              left join kss.v$pessoa_telefone_padrao ptd
                     on ptd.cod_pessoa = dest.cod_pessoa
              left join kss.v$organograma o
                     on o.cod_organograma = sc.cod_organograma
              left join kss.v$centro_custo cc
                     on cc.cod_centro_custo = o.cod_centro_custo
              left join kss.v$pessoa_endereco_padrao pep
                on pep.cod_pessoa =
                   decode(v.viagem_id, null, null, oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(oper.pkg_veiculo.fnc_placa(v.veiculo_id),
                                                            to_char(v.data_inicio, 'dd/mm/yyyy')))
              <cfif Len(Trim(arguments.docto_fiscal))>
                    and scc.docto_fiscal = #arguments.docto_fiscal#
              </cfif>
             where sc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

  <!---
    -- PROPSITO
    -- Busca os dados de uma solicitao de carga para o formulrio de impresso de Coleta
    -- LUKAS 20/02/2015
    --->
    <cffunction name="get_ordem_coleta_print" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfargument name="docto_fiscal" required="no" default="0">
        <cfargument name="gerar" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select scc.num_autorizacao_carga,
                   scf.situacao_id,
                   scf.data_impressao,
                   scf.razao_social,
                   scf.frota_tracao,
                   scf.placa_tracao,
                   scf.frota_carreta,
                   scf.placa_carreta,
                   scf.cod_remetente,
                   scf.rem_razao_social as razao_social_rem,
                   scf.rem_razao_social as remetente,
                   scf.rem_endereco as endereco_rem,
                   scf.rem_endereco as endereco,
                   scf.rem_municipio as municipio_rem,
                   scf.rem_telefone as telefone_rem,
                   scf.rem_identificador as cnpj,
                   scf.rem_inscricao_estadual as inscricao_estadual,
                   scf.rem_uf as uf_rem,
                   scf.rem_cep as cep_rem,
                   scf.rem_bairro,
                   scf.rem_telefone,
                   scf.rem_contato,
                   scf.dest_municipio as municipio,
                   scf.destinatario,
                   scf.dest_contato,
                   scf.dest_telefone,
                   scf.dest_endereco,
                   scf.dest_uf as uf,
                   scf.nome_solicitante,
                   scf.hora_chamada,
                   scf.data_carregamento,
                   scf.num_especie,
                   scf.material,
                   scf.peso,
                   scf.volume_total,
                   scf.motorista,
                   scf.motorista_cnh,
                   scf.motorista_rg,
                   scf.motorista_cpf,
                   scf.chapa,
                   scf.quantidade,
                   scf.tipo_volume,
                   scf.descricao_carga_coletada,
                   scf.produto_risco,
                   scf.produto_onu,
                   scc.produto_observacoes,
                   scf.data_nf,
                   scf.num_nota_fiscal,
                   scf.destino,
                   scf.local_emissao,
                   scc.num_formulario,
                   scc.local_carregamento,
                   scc.cidade_carregamento,
                   scc.coleta_contato,
                   scc.coleta_endereco,
                   scc.coleta_fone,
                   decode(scc.coleta_planta_site, 0, '', 1, 'X') as coleta_planta_site,
                   decode(scc.coleta_porto, 0, '', 1, 'X') as coleta_porto,
                   decode(scc.coleta_outros, 0, '', 1, 'X') as coleta_outros,
                   scc.coleta_outros_texto,
                   decode(scc.entrega_planta_site, 0, ' ', 1, 'X') as entrega_planta_site,
                   decode(scc.entrega_porto, 0, ' ', 1, 'X') as entrega_porto,
                   decode(scc.entrega_outros, 0, ' ', 1, 'X') as entrega_outros,
                   scc.entrega_outros_texto,
                   scc.efetua_carregamento,
                   scc.coopera_carregamento,
                   scc.acoes_motorista,
                   scc.local_descarregamento,
                   scc.cidade_descarregamento,
                   scc.entrega_contato,
                   scc.entrega_fone,
                   scc.entrega_endereco,
                   scf.local_emissao,
                   scf.dest_municipio,
                   scf.coleta_municipio,
                   to_char((oper.pkg_veiculo.fnc_capacidade_carga_compo(scf.placa_tracao,scc.data_coleta)),'FM9G9999G990','nls_numeric_characters=,.') as capacidade,
                   (select vd.classificacao
                      from oper.v$veiculo_dados vd
                     where vd.placa = scf.placa_carreta) as classificacao,
                   (select vd.classificacao
                      from oper.v$veiculo_dados vd
                     where vd.placa = scf.placa_carreta) as classificacao,
                   (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as proprietario,
                   (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_cnpj_cpf,
                   (select p.inscricao_estadual
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.fnc_pessoa_proprietario(scf.placa_tracao, scf.data_carregamento)) as prop_ie,
                   pep.endereco,
                   pep.bairro,
                   pep.complemento,
                   pep.municipio || ' - ' || pep.uf as municipio,
                   (select sign(instr(lower(e1.razao_social), 'bbm'))
                      from kss.v$empresa e1) as is_bbm,
                   '' as transportar_para,
                   '' as marca,
                   '' as placas,
                   '' as observacao
              from logistica.v$solicitacao_coleta_form scf
             left join logistica.v$solicitacao_carga_coleta scc
                     on scc.solicitacao_carga_id = scf.solicitacao_carga_id
             left join kss.v$pessoa_endereco_padrao pep
               on pep.cod_pessoa =
                  oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao,
                                                           scf.data_carregamento)
              <cfif Len(Trim(arguments.docto_fiscal))>
                    and scc.docto_fiscal = #arguments.docto_fiscal#
              </cfif>
             where scf.solicitacao_carga_id = #arguments.solicitacao_carga_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

 <!---
    -- PROPSITO
    -- NOTAS EXPLICATIVAS
    --  Busca itens da Coleta
    -- LUKAS 20/02/2015 - criado
    --->
    <cffunction name="get_coleta_item" displayname="Busca items da Coleta" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="yes" >
        <cfquery datasource="#session.dsn#" name="qr_aplicacoes" username="#session.usuario#" password="#session.senha#">
               select scni.quantidade as qtde_volume
           , scn.peso_cobrado as peso_cobrado_kg
           , n.descricao as natureza_descricao
           , numero as nf_numero
           , data_emissao as nf_data_emissao
           , nvl(m3, 0) as m3
           , nvl(CUBAGEM, 0) as cubagem
           , '' as ordem_compra
        from logistica.v$solicitacao_carga_nf scn
       inner join logistica.v$solicitacao_carga_nf_item scni
          on scni.solicitacao_carga_nf_id = scn.solicitacao_carga_nf_id
       inner join oper.v$natureza n
          on n.num_natureza = scn.num_natureza
       where 1=1
                   and scn.solicitacao_carga_id = #arguments.solicitacao_carga_id#
        </cfquery>
        <cfreturn qr_aplicacoes>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna o prximo nm. formulrio de ACT para a Solicitao de Carga informada
    -- ANDERSONC 28/05/2009 14:59:39 - CRIADO
    --->
    <cffunction name='get_num_formulario_act' displayname='Retorna o prximo nm. formulrio de ACT para a Solicitao de Carga informada' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
            <cftry>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_num_formulario_act' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.NUM_FORMULARIO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.SERIE' >
                </cfstoredproc>
                <cfcatch>
                    <cfset retorno.NUM_FORMULARIO = -1>
                </cfcatch>
            </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna o prximo nm. formulrio de Coleta para a Solicitao de Carga informada
    -- ANDERSONC 28/05/2009 15:02:59 - CRIADO
    --->
    <cffunction name='get_num_formulario_coleta' displayname='Retorna o prximo nm. formulrio de Coleta para a Solicitao de Carga informada' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
            <cftry>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_num_formulario_coleta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.NUM_FORMULARIO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.SERIE' >
                </cfstoredproc>
                <cfcatch>
                    <cfset retorno.NUM_FORMULARIO = -1>
                </cfcatch>
            </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna o prximo nm. formulrio de Coleta para a Solicitao de Carga informada
    -- ANDERSONC 28/05/2009 15:02:59 - CRIADO
    --->
    <cffunction name='get_num_formulario_autorizacao_carga' displayname='Retorna o prximo nm. formulrio de Coleta para a Solicitao de Carga informada' access='remote' returntype='query' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nvl(scc.num_autorizacao_carga,-1) as num_formulario
             from logistica.v$solicitacao_carga_coleta scc
            where scc.docto_fiscal = 0
              and scc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Resumo de acompanhamento
    -- CRISTOFER  12/06/2009
    --->
    <cffunction name="get_resumo_acompanhamento" access="remote" returntype="query" output="true">
        <cfargument name="data_inicial" required="yes">
        <cfargument name="data_final" required="yes">
        <cfargument name="tipo" required="no" default="RESUMIDO">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select un.cod_centro_custo,
                   un.centro_custo,
                   case
                      when dt.data_inicial = dt.data_final then to_char(dt.data_inicial,'dd/mm/yyyy')
                      else to_char(dt.data_inicial,'dd/mm/yyyy')||'=>'||to_char(dt.data_final,'dd/mm/yyyy')
                   end as data,
                   (select count(*)
                      from logistica.v$solicitacao_carga sc
                     inner join kss.v$organograma o
                             on o.cod_organograma = sc.cod_organograma
                     where o.cod_centro_custo = un.cod_centro_custo
                       and trunc(sc.date_insert) between dt.data_inicial and dt.data_final) as solicitacoes,
                   (select count(*)
                      from logistica.v$viagem vg
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = vg.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     inner join kss.v$organograma o
                             on o.cod_organograma = sc.cod_organograma
                     where o.cod_centro_custo = un.cod_centro_custo
                       and vg.situacao_id <> 0
                       and trunc(vg.date_insert) between dt.data_inicial and dt.data_final) as solicitacoes_agendadas,
                   (select count(*)
                      from fiscal.v$conhecimento c
                     where c.cod_centro_custo = un.cod_centro_custo
                       and c.modalidade = 'FROTA'
                       and trunc(c.date_insert) between dt.data_inicial and dt.data_final) conhecimentos_frota,
                   (select count(*)
                      from fiscal.v$conhecimento c
                     where c.cod_centro_custo = un.cod_centro_custo
                       and c.modalidade = 'AGREGADO'
                       and trunc(c.date_insert) between dt.data_inicial and dt.data_final) conhecimentos_agregado,
                   (select count(*)
                      from fiscal.v$conhecimento c
                     where c.cod_centro_custo = un.cod_centro_custo
                       and c.modalidade = 'TERCEIRO'
                       and trunc(c.date_insert) between dt.data_inicial and dt.data_final) conhecimentos_terceiro,
                   (select count(*)
                      from fiscal.v$conhecimento c
                     where c.cod_centro_custo = un.cod_centro_custo
                       and c.modalidade is not null
                       and trunc(c.date_insert) between dt.data_inicial and dt.data_final) conhecimentos,
                   (select count(*)
                      from fiscal.v$nf_es_frete nf
                     inner join kss.v$organograma o
                             on o.cod_organograma = nf.cod_organograma_gerencial
                     where o.cod_centro_custo = un.cod_centro_custo
                       and trunc(nf.date_insert) between dt.data_inicial and dt.data_final) nf,
                   (select count(*)
                      from fiscal.v$intc_conhecimento crt
                     inner join kss.v$organograma o
                             on o.cod_organograma = crt.cod_organograma
                     where o.cod_centro_custo = un.cod_centro_custo
                       and trunc(crt.date_insert) between dt.data_inicial and dt.data_final) crt,
                                      (select count(*)
                      from fiscal.v$conhecimento c
                     inner join fiscal.v$conhecimento_receber cr
                             on cr.conhecimento_id = c.conhecimento_id
                     inner join finan.v$finan_contas_receber r
                             on r.contas_receber_id = cr.contas_receber_id
                     where c.cod_centro_custo = un.cod_centro_custo
                       and trunc(r.data_emissao) between dt.data_inicial and dt.data_final) as faturamento_conhecimentos,
                   (select count(*)
                      from fiscal.v$nf_es_frete nf
                     inner join fiscal.v$nf_es_receber nr
                             on nr.num_nota_id = nf.nf_es_id
                     inner join finan.v$finan_contas_receber r
                             on nr.contas_receber_id = r.contas_receber_id
                     inner join kss.v$organograma o
                             on o.cod_organograma = nf.cod_organograma_gerencial
                     where o.cod_centro_custo = un.cod_centro_custo
                       and trunc(r.data_emissao) between dt.data_inicial and dt.data_final
                       ) as faturamento_nf,
                   (select count(*)
                      from fiscal.v$intc_conhecimento c
                     inner join fiscal.v$intc_conhecimento_receber cr
                             on cr.conhecimento_id = c.CONHECIMENTO_ID
                     inner join finan.v$finan_contas_receber r
                             on r.contas_receber_id = cr.contas_receber_id
                     inner join kss.v$organograma o
                             on o.cod_organograma = c.cod_organograma
                     where o.cod_centro_custo = un.cod_centro_custo
                       and trunc(c.date_insert) between dt.data_inicial and dt.data_final
                    ) as faturamento_crt,
                   (select count(*)
                      from oper.v$contrato_transp ct
                     where ct.cod_centro_custo = un.cod_centro_custo
                       and trunc(ct.date_insert) between dt.data_inicial and dt.data_final ) as carta_frete
              from kss.v$centro_custo un
             <cfif ucase(trim(arguments.tipo)) eq "RESUMIDO">
             cross join (select to_date('#arguments.data_inicial#','dd/mm/yyyy')as data_inicial,
                                to_date('#arguments.data_final#','dd/mm/yyyy')as data_final
                           from dual) dt
             <cfelse>
             cross join (select trunc(to_date('#arguments.data_inicial#','dd/mm/yyyy')-1+level) as data_inicial,
                                trunc(to_date('#arguments.data_inicial#','dd/mm/yyyy')-1+level) as data_final
                           from dual
                         connect by to_date('#arguments.data_inicial#','dd/mm/yyyy')-1+level <= to_date('#arguments.data_final#','dd/mm/yyyy')) dt
             </cfif>
             order by un.cod_centro_custo, data
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca a composio de uma solicitao de carga
    -- ANDERSON 21/09/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_carga_composicao" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.solicitacao_carga_id
                 , t.veiculo_id
                 , t.cod_veiculo
                 , oper.pkg_veiculo.fnc_get_placa(t.cod_veiculo) as placa
                 , t.ordem
              from logistica.v$solicitacao_carga_composicao t
             where t.solicitacao_carga_id = #arguments.solicitacao_carga_id#
             order by t.ordem asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca os tipos de carroceria de uma solicitao de carga
    -- ANDERSON 21/09/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_carga_tipo_carr" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.solicitacao_carga_id
                 , t.tipo_carroceria_id
              from logistica.v$solicitacao_carga_tipo_carr t
             where t.solicitacao_carga_id = #arguments.solicitacao_carga_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca os acessrios de uma solicitao de carga
    -- ANDERSON 21/09/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_carga_acessorio" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.solicitacao_carga_id
                 , t.material_id
              from logistica.v$solicitacao_carga_acessorio t
             where t.solicitacao_carga_id = #arguments.solicitacao_carga_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca as notas fiscais de uma solicitao de carga
    -- ANDERSON 28/09/2009 - ALTERADO
    --->
    <cffunction name="get_solicitacao_carga_nf" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfargument name="viagem_carga_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.solicitacao_carga_nf_id
                 , t.solicitacao_carga_id
                 , t.numero
                 , to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , t.modelo
                 , t.serie
                 , t.sub_serie
                 , t.valor_total
                 , t.valor_segurado
                 , t.ordem_compra_cliente
                 , t.qtde_volume
                 , t.peso
                 , t.cod_unidade
                 , t.num_natureza
                 , (select n.descricao
                     from oper.v$natureza n
                    where n.num_natureza = t.num_natureza) as natureza
                 , t.num_especie
                 , (select e.descricao
                     from oper.v$especie e
                    where e.num_especie = t.num_especie) as especie
                 , t.altura
                 , t.comprimento
                 , t.largura
                 , t.cubagem
                 , t.m3
                 , t.peso_cubado
                 , fiscal.pkg_fiscal.fnc_converte_peso(t.peso, t.cod_unidade, 'KG') as peso_kg_convertido
                 , t.peso_cobrado
                 , t.cfop
                 , t.tipo_documento_id
                 , t.descricao_docto
                 , t.chave_acesso_nfe
                 , t.date_insert
                 , t.user_insert
                 , t.date_update
                 , t.user_update
                 , t.site
                 , t.nf_eletronica
                 , t.complemento
                 , t.num_romaneio
                 , t.valor_base_calculo_icms
                 , t.valor_icms
                 , t.valor_base_calculo_icms_st
                 , t.valor_icms_st
                 , t.valor_produtos
                 , t.pin_suframa
                 , t.nfe_xml
                 , t.documento_id
                 , t.tipo_doc_outros
              from logistica.v$solicitacao_carga_nf t
             where 1 = 1
            <cfif Len(Trim(arguments.solicitacao_carga_id))>
               and t.solicitacao_carga_id in (#arguments.solicitacao_carga_id#)
            </cfif>
            <cfif Len(Trim(arguments.viagem_carga_id))>
               and t.solicitacao_carga_id = (select vg.solicitacao_carga_id
                                               from logistica.v$viagem_carga vg
                                              where vg.viagem_carga_id = #arguments.viagem_carga_id#)
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca as ocorrncias de solicitao de carga
    -- WAGNERS 28/09/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_carga_ocorrencia" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfargument name="gerenciadora_risco" required="no" default="">
        <cfargument name="class_risco" required="no" default="">
        <cfargument name="plano_risco" required="no" default="">
        <cfargument name="operacao" required="no" default="">
        <cfargument name="operador" required="no" default="">
        <cfargument name="liberacao_gerenciadora" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.ocorrencia_id,
                   ot.tipo_id,
                   ot.descricao as tipo,
                   to_char(o.comentario) as comentario,
                   kss.fnc_ref_code('LOGISTICA','OCORRENCIA_TIPO.LOCAL_OCORRENCIA_ID',ot.local_ocorrencia_id) as local,
                   o.usuario,
                   o.data
              from logistica.v$ocorrencia o
             inner join logistica.v$ocorrencia_tipo ot
                     on ot.tipo_id = o.tipo_id
             inner join logistica.v$solicitacao_carga_ocor sco
                     on sco.ocorrencia_id = o.ocorrencia_id


             <!---Gerenciadora de Risco: --->
             <cfif len(trim(arguments.gerenciadora_risco))>
                 inner join logistica.v$gerenciadora_ocorrencia cro
                         on o.ocorrencia_id = cro.ocorrencia_id
                        and cro.gerenciadora_id = #arguments.solicitacao_carga_id#
            </cfif>

            <!---Classe de Risco:--->
            <cfif len(trim(arguments.class_risco))>
                 inner join logistica.v$classe_risco_ocorrencia cro
                         on o.ocorrencia_id = cro.ocorrencia_id
                        and cro.classe_risco_id = #arguments.solicitacao_carga_id#
            </cfif>

            <!---Plano de Risco:--->
            <cfif len(trim(arguments.plano_risco))>
                 inner join logistica.v$plano_risco_ocorrencia cro
                         on o.ocorrencia_id = cro.ocorrencia_id
                    and cro.plano_risco_id = #arguments.solicitacao_carga_id#
            </cfif>

            <!---Operacao:--->
            <cfif len(trim(arguments.operacao))>
                 inner join logistica.v$operacao_risco_ocorrencia cro
                         on o.ocorrencia_id = cro.ocorrencia_id
                        and cro.operacao_id = #arguments.solicitacao_carga_id#
            </cfif>

            <!---Operador:--->
            <cfif len(trim(arguments.operador))>
                 inner join logistica.v$operador_ocorrencia cro
                         on o.ocorrencia_id = cro.ocorrencia_id
                        and cro.operador_id = #arguments.solicitacao_carga_id#
            </cfif>

            <!---Liberao na Gerenciadora:--->
            <cfif len(trim(arguments.liberacao_gerenciadora))>
                 inner join logistica.v$plano_risco_ocor cro
                         on o.ocorrencia_id = cro.ocorrencia_id
                        and cro.plano_risco_id = #arguments.solicitacao_carga_id#
            </cfif>

            where 1=1

            <cfif len(trim(arguments.solicitacao_carga_id))>
                 and solicitacao_carga_id = #arguments.solicitacao_carga_id#
            </cfif>

             order by o.data
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca os dados de para a Gerao de Ordem de Lavagem
    -- RAFAEL 29/03/2010
    --->
    <cffunction name="get_ordem_lavagem_dados" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select (select p.cnpj_cpf
                  from kss.v$pessoa p
                 where p.cod_pessoa = ((select max(r.cod_pessoa) keep(dense_rank last order by r.data_inicio)
                                          from oper.v$motorista_reg_historico r
                                         where r.cod_pessoa = v.cod_motorista))) as motorista
             , (select v_controle.cod_veiculo
                  from oper.v$veiculo v_controle
                 where v.veiculo_id = v_controle.veiculo_id) as cod_veiculo_controle
             , (select v_referencia.cod_veiculo
                  from oper.v$veiculo v_referencia
                 where v.veiculo_id_referencia = v_referencia.veiculo_id) as cod_veiculo_referencia
          from logistica.v$solicitacao_carga s
     left join logistica.v$viagem_carga vc
            on vc.solicitacao_carga_id = s.solicitacao_carga_id
     left join logistica.v$viagem v
            on v.viagem_id = vc.viagem_id
         where s.solicitacao_carga_id = #arguments.solicitacao_carga_id#
          and not exists(select 1
                           from logistica.v$ordem_lavagem ol
                          where ol.solicitacao_carga_id = #arguments.solicitacao_carga_id#)


        union all

        select (select p.cnpj_cpf
                  from kss.v$pessoa p
                 where p.cod_pessoa = ol2.cod_motorista) as motorista
             , oper.pkg_veiculo.fnc_cod_veiculo(ol2.veiculo_id_controle) as cod_veiculo_controle
             , oper.pkg_veiculo.fnc_cod_veiculo(ol2.veiculo_id_referencia) as cod_veiculo_referencia
          from logistica.v$ordem_lavagem ol2
         where ol2.solicitacao_carga_id = #arguments.solicitacao_carga_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca os dados de para a impresso de Ordem de Lavagem
    -- RAFAEL 29/03/2010
    --->
    <cffunction name="get_ordem_lavagem_print" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select to_char(ol.date_insert) as data
             , (select p.razao_social
                  from kss.v$pessoa p
                 where exists (select 0
                                from kss.organograma org
                               where org.cod_organograma = ol.cod_organograma
                                 and org.cod_pessoa = p.cod_pessoa)) as filial
             , (select p_for.razao_social
                  from kss.v$pessoa p_for
                 where p_for.cod_pessoa = ol.cod_fornecedor) as empresa
             , (select p_for.cnpj_cpf
                  from kss.v$pessoa p_for
                 where p_for.cod_pessoa = ol.cod_fornecedor) as empresa_cnpj_cpf
             , pep.municipio as cidade
             , trim(pep.endereco) || ' - ' || trim(pep.bairro) || chr(13) || 'CEP: ' || pep.cep as endereco
             , (select ptp.telefone
                  from kss.v$pessoa_telefone_padrao ptp
                 where ptp.cod_pessoa = ol.cod_fornecedor) as telefone
             , (select vf.cod_veiculo || ' - ' || vf.placa
                  from oper.v$veiculo vf
                 where vf.veiculo_id = ol.veiculo_id_controle) as frota_cavalo
             , (select vc.cod_veiculo || ' - ' || vc.placa
                  from oper.v$veiculo vc
                 where vc.veiculo_id = ol.veiculo_id_referencia) as frota_carreta
             , (select kss.fnc_concat_all(kss.to_concat_expr(n_carga.descricao,', '))
                  from logistica.v$viagem_carga vc
                  inner join logistica.v$solicitacao_carga sc_carga
                          on sc_carga.solicitacao_carga_id = vc.solicitacao_carga_id
                  inner join  oper.v$natureza n_carga
                          on n_carga.num_natureza = sc_carga.num_natureza
                 where vc.viagem_id = (select max(v.viagem_id) keep(dense_rank last order by v.data_termino)
                                         from logistica.v$viagem v
                                        where v.veiculo_id_referencia = ol.veiculo_id_referencia)) as ultima_carga
             , (select ngr.cod_risco
                  from oper.v$natureza_grupo_risco ngr
                 where ngr.risco_id = o.risco_id) as num_risco
             , o.num_natureza_onu as num_onu
             , decode(ol.aparencia, 1, 'X', '') as aparencia
             , ol.aparencia as aparencia_value
             , decode(ol.completa, 1, 'X', '') as completa
             , ol.completa as completa_value
             , decode(ol.lavagem_interna, 1, 'X', '') as lavagem_interna
             , ol.lavagem_interna as lavagem_interna_value
             , decode(ol.lavagem_externa, 1, 'X', '') as lavagem_externa
             , ol.lavagem_externa as lavagem_externa_value
             , decode(ol.outros, 1, 'X', '') as outros
             , ol.outros as outros_value
             , ol.descricao_outros
             , (select p_sol.razao_social
                  from kss.v$pessoa p_sol
                 where p_sol.cod_pessoa = ol.cod_solicitante) as solicitante
             , (select p_mot.razao_social
                  from kss.v$pessoa p_mot
                 where p_mot.cod_pessoa = ol.cod_motorista) as motorista
             , (select s.num_controle
                  from compras.v$solicitacao s
                 where s.solicitacao_id = ol.solicitacao_id) as solicitacao_compra
             , ol.solicitacao_id
             , (select v.num_romaneio
                  from logistica.v$viagem v
                 where v.situacao_id <> 0
                   and v.viagem_id in (select vc.viagem_id
                                         from logistica.v$viagem_carga vc
                                        where vc.solicitacao_carga_id = ol.solicitacao_carga_id) ) as num_romaneio
          from logistica.v$ordem_lavagem ol
    inner join logistica.v$solicitacao_carga sc
            on sc.solicitacao_carga_id = ol.solicitacao_carga_id
     left join oper.v$natureza n
            on n.num_natureza = sc.num_natureza
     left join oper.v$natureza_onu o
            on o.natureza_onu_id = n.natureza_onu_id
     left join kss.v$pessoa_endereco_padrao pep
            on pep.cod_pessoa = ol.cod_fornecedor
         where sc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna o nmero da Ordem de Lavagem
    -- ANDERSONC 28/05/2009 15:02:59 - CRIADO
    --->
    <cffunction name='get_num_ordem_lavagem' displayname='Retorna o nmero da Ordem de Lavagem' access='remote' returntype='query' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ol.ordem_lavagem_id as numero
              from logistica.v$ordem_lavagem ol
             where ol.solicitacao_carga_id = #arguments.solicitacao_carga_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

     <!---
    -- PROPSITO
    -- Retorna os documentos vicnulados a Ordem de Lavagem
    -- RAFAEL 08/04/2010 - CRIADO
    --->
    <cffunction name='get_ordem_lavagem_doctos' displayname='Retorna os documentos vicnulados a Ordem de Lavagem' access='remote' returntype='query' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select 'CRT' as tipo
                 , ic.num_crt_completo as num_docto
                 , ic.REM_NOME as remetente
                 , ic.RESP_LOCAL as coleta
                 , ic.DEST_NOME as destinatario
                 , ic.DEST_CIDADE || ' - ' || ic.DEST_UF || ' - ' || ic.DEST_PAIS as entrega
                          from oper.v$romaneio_intc_conhecimento rc
                         inner join fiscal.v$intc_conhecimento ic
                                 on ic.conhecimento_id = rc.conhecimento_id
                         where 1=1
                         and rc.num_romaneio = #arguments.num_romaneio#

            union all

            select 'CTRC' as tipo
                 , c.num_conhecimento || '/' || c.serie  as num_docto
                 , c.rem_razao_social as remetente
                 , c.rem_municipio || ' - ' || c.rem_uf as coleta
                 , c.dest_razao_social as destinatario
                 , c.dest_municipio || ' - ' || c.dest_uf as entrega
              from fiscal.v$conhecimento c
             where c.num_romaneio = #arguments.num_romaneio#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca os dados de uma solicitao de carga para o formulrio de impresso de Coleta
    -- ANDERSON 27/05/2009
    --->
    <cffunction name="get_autorizacao_carga_dados" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfargument name="gerar" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_number('') as num_autorizacao_carga,
                   scf.frota_tracao,
                   scf.placa_tracao,
                   scf.frota_carreta,
                   scf.placa_carreta,
                   scf.cod_remetente,
                   scf.rem_razao_social,
                   scf.rem_endereco,
                   scf.rem_municipio,
                   scf.rem_telefone,
                   scf.rem_identificador,
                   scf.rem_inscricao_estadual,
                   scf.rem_uf,
                   scf.rem_cep,
                   scf.rem_bairro,
                   scf.rem_contato,
                   scf.dest_municipio,
                   scf.destinatario,
                   scf.dest_contato,
                   scf.dest_telefone,
                   scf.dest_endereco,
                   scf.nome_solicitante,
                   scf.hora_chamada,
                   scf.data_carregamento,
                   scf.num_especie,
                   scf.material,
                   scf.peso,
                   scf.volume_total,
                   scf.motorista,
                   scf.motorista_cnh,
                   scf.motorista_rg,
                   scf.motorista_cpf,
                   scf.chapa,
                   scf.quantidade,
                   scf.tipo_volume,
                   scf.descricao_carga_coletada,
                   scf.produto_risco,
                   scf.produto_onu,
                   '' as produto_observacoes,
                   scf.data_nf,
                   scf.num_nota_fiscal,
                   scf.destino,
                   scf.local_emissao,
                   to_number('') as num_formulario,
                   '' as local_carregamento,
                   '' as cidade_carregamento,
                   '' as coleta_contato,
                   '' as coleta_endereco,
                   '' as coleta_fone,
                   to_number('') as coleta_planta_site,
                   to_number('') as coleta_porto,
                   to_number('') as coleta_outros,
                   '' as coleta_outros_texto,
                   to_number('') as entrega_planta_site,
                   to_number('') as entrega_porto,
                   to_number('') as entrega_outros,
                   '' as entrega_outros_texto,
                   to_number('') as efetua_carregamento,
                   to_number('') as coopera_carregamento,
                   '' as acoes_motorista,
                   '' as local_descarregamento,
                   '' as cidade_descarregamento,
                   '' as entrega_contato,
                   '' as entrega_fone,
                   '' as entrega_endereco,
                   scf.local_emissao,
                   scf.dest_municipio,
                   scf.coleta_municipio,
                   '' as capacidade,
                   '' as classificacao,
                   (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_nome,
                   (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_cnpj_cpf,
                   (select p.inscricao_estadual
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.fnc_pessoa_proprietario(scf.placa_tracao, scf.data_carregamento)) as prop_ie,
                   (select pep.endereco
                      from kss.v$pessoa_endereco_padrao pep
                     where pep.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_endereco,
                   (select pep.bairro
                      from kss.v$pessoa_endereco_padrao pep
                     where pep.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_bairro,
                   (select pep.municipio || ' - ' || pep.uf
                      from kss.v$pessoa_endereco_padrao pep
                     where pep.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_endereco
              from logistica.v$solicitacao_coleta_form scf
             where scf.solicitacao_carga_id = #arguments.solicitacao_carga_id#
               and not exists(select 1
                                from logistica.v$solicitacao_carga_coleta scc
                               where scc.solicitacao_carga_id = #arguments.solicitacao_carga_id# )
            union all

            select scc.num_autorizacao_carga,
                   scf.frota_tracao,
                   scf.placa_tracao,
                   scf.frota_carreta,
                   scf.placa_carreta,
                   scf.cod_remetente,
                   scc.local_carregamento as rem_razao_social,
                   scc.coleta_endereco as rem_endereco,
                   scc.rem_municipio,
                   scc.coleta_fone as rem_telefone,
                   scf.rem_identificador,
                   scf.rem_inscricao_estadual,
                   scc.rem_uf,
                   scc.rem_cep,
                   scf.rem_bairro,
                   scc.coleta_contato as rem_contato,
                   scf.dest_municipio,
                   scf.destinatario,
                   scc.entrega_contato as dest_contato,
                   scc.entrega_fone as dest_telefone,
                   scc.entrega_endereco as dest_endereco,
                   scf.nome_solicitante,
                   scf.hora_chamada,
                   scf.data_carregamento,
                   scf.num_especie,
                   scf.material,
                   scf.peso,
                   scf.volume_total,
                   scf.motorista,
                   scf.motorista_cnh,
                   scf.motorista_rg,
                   scf.motorista_cpf,

                   scf.chapa,
                   scf.quantidade,
                   scf.tipo_volume,
                   scf.descricao_carga_coletada,
                   scf.produto_risco,
                   scf.produto_onu,
                   scc.produto_observacoes,
                   scf.data_nf,
                   scf.num_nota_fiscal,
                   scf.destino,
                   scf.local_emissao,
                   scc.num_formulario,
                   scc.local_carregamento,
                   scc.cidade_carregamento,
                   scc.coleta_contato,
                   scc.coleta_endereco,
                   scc.coleta_fone,
                   nvl(scc.coleta_planta_site,0) as coleta_planta_site,
                   nvl(scc.coleta_porto,0) as coleta_porto,
                   nvl(scc.coleta_outros,0) as coleta_outros,
                   scc.coleta_outros_texto,
                   nvl(scc.entrega_planta_site,0) as entrega_planta_site,
                   nvl(scc.entrega_porto,0) as entrega_porto,
                   nvl(scc.entrega_outros,0) as entrega_outros,
                   scc.entrega_outros_texto,
                   scc.efetua_carregamento,
                   scc.coopera_carregamento,
                   scc.acoes_motorista,
                   scc.local_descarregamento,
                   scc.cidade_descarregamento,
                   scc.entrega_contato,
                   scc.entrega_fone,
                   scc.entrega_endereco,
                   scf.local_emissao,
                   scf.dest_municipio,
                   scf.coleta_municipio,
                   to_char((oper.pkg_veiculo.fnc_capacidade_carga_compo(scf.placa_tracao,scc.data_coleta)),'FM9G9999G990','nls_numeric_characters=,.') as capacidade,
                   (select vd.classificacao
                      from oper.v$veiculo_dados vd
                     where vd.placa = scf.placa_carreta) as classificacao,
                   (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_nome,
                   (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_cnpj_cpf,
                   (select p.inscricao_estadual
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.fnc_pessoa_proprietario(scf.placa_tracao, scf.data_carregamento)) as prop_ie,
                   (select pep.endereco
                      from kss.v$pessoa_endereco_padrao pep
                     where pep.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_endereco,
                   (select pep.bairro
                      from kss.v$pessoa_endereco_padrao pep
                     where pep.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_bairro,
                   (select pep.municipio || ' - ' || pep.uf
                      from kss.v$pessoa_endereco_padrao pep
                     where pep.cod_pessoa = oper.pkg_veiculo.FNC_pessoa_PROPRIETARIO(scf.placa_tracao, scf.data_carregamento)) as prop_endereco
              from logistica.v$solicitacao_coleta_form scf
             left join logistica.v$solicitacao_carga_coleta scc
                     on scc.solicitacao_carga_id = scf.solicitacao_carga_id
                    and scc.docto_fiscal = 0
             where scf.solicitacao_carga_id = #arguments.solicitacao_carga_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

     <!---
    -- PROPSITO
    -- Retorna os motivos de cancelamento de solicitao de carga
    -- JAQUELINEF 01/11/2013 - CRIADO
    --->
    <cffunction name='get_motivos_cancelamento' displayname='Retorna os motivos de cancelamento de solicitao de carga' access='remote' returntype='query' output='true'>
        <cfargument name='motivo_id' required='no' default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.motivo_id
                 , t.descricao
              from logistica.v$solicitacao_motivo_can t
             where 1=1
            <cfif len(trim(arguments.motivo_id))>
                 and motivo_id = #arguments.motivo_id#
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <cffunction name="get_versao_repom" access="remote" returntype="string" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select d.versao_atual
             from kmmupdate.v$modulo d
            where d.cod_modulo = 'M319'
              and d.versao_atual = 'null'
        </cfquery>
        <cfreturn qr_result.versao_atual>
    </cffunction>

    <cffunction name="get_tempo_rota" access="remote" returntype="query" output="true">
        <cfargument name='origem_municipio_id' required='yes' default="">
        <cfargument name='destino_municipio_id' required='yes' default="">
        <cfargument name='cod_remetente' required='yes' default="">
        <cfargument name='cod_destinatario' required='yes' default="">
        <cfargument name='data_inicio' required='yes' default="">
        <cfargument name='operacao_id' required='yes' default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select logistica.pkg_solicitacao.fnc_get_tempo_rota(p_origem_municipio_id  => #arguments.origem_municipio_id#
                                                              ,p_destino_municipio_id => #arguments.destino_municipio_id#
                                                              <cfif len(trim(arguments.cod_remetente))>
                                                                 ,p_cod_remetente        => #arguments.cod_remetente#
                                                              <cfelse>
                                                                 ,p_cod_remetente        => -1
                                                              </cfif>
                                                               <cfif len(trim(arguments.cod_destinatario))>
                                                                 ,p_cod_destinatario     => #arguments.cod_destinatario#
                                                              <cfelse>
                                                                 ,p_cod_destinatario     => -1
                                                              </cfif>
                                                              ,p_operacao_id => #arguments.operacao_id#
                                                              ) as tempo_rota
                , to_char(logistica.pkg_solicitacao.fnc_get_tempo_rota_livre(p_origem_municipio_id  => #arguments.origem_municipio_id#
                                                                    ,p_destino_municipio_id => #arguments.destino_municipio_id#
                                                                    <cfif len(trim(arguments.cod_remetente))>
                                                                       ,p_cod_remetente        => #arguments.cod_remetente#
                                                                    <cfelse>
                                                                       ,p_cod_remetente        => -1
                                                                    </cfif>
                                                                    <cfif len(trim(arguments.cod_destinatario))>
                                                                       ,p_cod_destinatario     => #arguments.cod_destinatario#
                                                                    <cfelse>
                                                                       ,p_cod_destinatario     => -1
                                                                    </cfif>
                                                                    ,p_data_inicial         => to_date('#arguments.data_inicio#','dd/mm/yyyy HH24:mi:ss')
                                                                    ,p_operacao_id          => #arguments.operacao_id#
                                                                    ), 'dd/mm/yyyy HH24:mi:ss') as data_final
                , to_char(logistica.pkg_solicitacao.fnc_get_tempo_rota_livre(p_origem_municipio_id  => #arguments.origem_municipio_id#
                                                                    ,p_destino_municipio_id => #arguments.destino_municipio_id#
                                                                    <cfif len(trim(arguments.cod_remetente))>
                                                                       ,p_cod_remetente        => #arguments.cod_remetente#
                                                                    <cfelse>
                                                                       ,p_cod_remetente        => -1
                                                                    </cfif>
                                                                    <cfif len(trim(arguments.cod_destinatario))>
                                                                       ,p_cod_destinatario     => #arguments.cod_destinatario#
                                                                    <cfelse>
                                                                       ,p_cod_destinatario     => -1
                                                                    </cfif>
                                                                    ,p_data_inicial         => to_date('#arguments.data_inicio#','dd/mm/yyyy HH24:mi:ss')
                                                                    ,p_operacao_id          => #arguments.operacao_id#
                                                                    ) + 1/24/60 , 'dd/mm/yyyy HH24:mi:ss') as data_final_1
             from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <cffunction name="get_validacao_antt_repom" access="remote" returntype="struct" output="true">
        <cfargument name='placa_cavalo' required='yes' default="">
        <cfargument name='placa_carreta' required='yes' default="">
        <cfargument name='placa_carreta2' required='no' default="">
        <cfargument name='placa_carreta3' required='no' default="">
        <cfargument name='cod_contratado' required='yes' default="">
        <cftry>
            <cfstoredproc procedure='logistica.pkg_agendamento.prc_validacao_antt_repom_novo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5'   value='#arguments.PLACA_CAVALO#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5'   value='#arguments.PLACA_CARRETA#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5'   value='#arguments.PLACA_CARRETA2#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5'   value='#arguments.PLACA_CARRETA3#'>
                <cfprocparam type='IN' cfsqltype='cf_sql_numeric' scale='5'   value='#arguments.COD_CONTRATADO#'>
                <cfprocparam type='IN' cfsqltype='cf_sql_numeric' scale='5'   value='0'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.VALIDACAO_EXECUTADA' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.VEICULO_VALIDADO_ANTT' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.VEICULO_ERRO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CARRETA_VALIDADO_ANTT' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CARRETA_ERRO' >             
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CARRETA2_VALIDADO_ANTT' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CARRETA2_ERRO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CARRETA3_VALIDADO_ANTT' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CARRETA3_ERRO' >               
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CONTRATADO_VALIDADO_ANTT' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CONTRATADO_ERRO' >
            </cfstoredproc>
            <cfset retorno.ERRO = 'FALSE'>
            <cfcatch>
                <cfset retorno.ERRO = cfcatch.Detail>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna parametro
    -- GUTO
    --->

    <cffunction name="get_parametro" displayname="Verifica se o veculo esta bloqueado" access="remote" returntype="query" output="false">
        <cfargument name="identificador" required="yes"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select trim(kss.pkg_parametro.fnc_valor_lista('#arguments.identificador#')) as valor
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca cadastros da Upper
    -- RAFAEL 11/09/2014
    --->
    <cffunction name="get_grisco_upper" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select 1
              from grisco.v$modelo m
             inner join grisco.v$gerenciadora g
                on g.gerenciadora_modelo = m.modelo_id
             where m.descricao = 'UPPER'
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca o romaneio da viagem
    -- LEANDROS 29/10/2014
    --->
    <cffunction name="get_romaneio_viagem" access="remote" returntype="query" output="true">
        <cfargument name="viagem_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.num_romaneio
              from logistica.v$viagem v
             where v.viagem_id = '#arguments.viagem_id#'
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca container
    -- RICARDO 21/01/2016
    --->
    <cffunction name='get_container' displayname='Retorna os containers' access='remote' returntype='query' output='true'>
        <cfargument name='container_identificador' required='no' default="">
        <cfargument name='container_tipo' required='no' default="">
        <cfargument name='container_iso_code' required='no' default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.container_id
                 , c.identificador
                 , c.tipo_id
                 , ct.iso_code
                 , ct.tipo
                 , ct.tipo_id
              from multimodal.v$container c
             inner join multimodal.v$container_tipo ct
                on ct.tipo_id = c.tipo_id
             where 1 = 1
         <cfif len(trim(arguments.container_identificador))>
           and upper(c.identificador) like upper('#arguments.container_identificador#')||'%'
         </cfif>
         <cfif len(trim(arguments.container_tipo))>
           and upper(ct.tipo) like upper('#arguments.container_tipo#')||'%'
         </cfif>
         <cfif len(trim(arguments.container_iso_code))>
           and upper(ct.iso_code) = upper('#arguments.container_iso_code#')
         </cfif>

        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca tipo de container
    -- RICARDO 21/01/2016
    --->
    <cffunction name='get_tipo_container' displayname='Retorna os containers' access='remote' returntype='query' output='true'>
        <cfargument name='tipo_id' required='no' default="">
        <cfargument name='tipo' required='no' default="">
        <cfargument name='iso_code' required='no' default="">
        <cfargument name='descricao' required='no' default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.tipo_id
                 , c.iso_code
                 , c.tipo
                 , c.descricao
                 , c.comprimento
                 , c.largura
                 , c.altura
                 , c.observacao
              from multimodal.v$container_tipo c
             where 1 = 1
         <cfif len(trim(arguments.descricao))>
           and upper(c.descricao) like upper('#arguments.descricao#')||'%'
         </cfif>
         <cfif len(trim(arguments.tipo))>
           and upper(c.tipo) like upper('#arguments.tipo#')||'%'
         </cfif>
         <cfif len(trim(arguments.iso_code))>
           and upper(c.iso_code) = upper('#arguments.iso_code#')
         </cfif>
         <cfif len(trim(arguments.tipo_id))>
           and c.tipo_id = '#arguments.tipo_id#'
         </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
     <!---
    -- PROPSITO
    -- Retorna as situaes logsticas das solicitaes de carga
    -- RAFAELP 08/02/2016 - CRIADO
    --->
    <cffunction name='get_situacao_logistica' displayname='Retorna as situaes logsticas das solicitaes de carga' access='remote' returntype='query' output='true'>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.rv_abbreviation
                 , c.rv_low_value
              from logistica.cg_ref_codes c
             where c.rv_domain ='SOLICITACAO_CARGA.SITUACAO_LOGISTICA_ID'
             order by to_number(regexp_substr(c.rv_low_value,'^[0-9]+'))
                    , to_number(regexp_substr(c.rv_low_value,'[0-9]+$'))
                    , c.rv_low_value
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca a quantidade de cpg em aberto do mesmo motorista
    -- RAFAEL 27/06/2018 - ADICIONADO
    --->
    <cffunction name="get_cpg_aberto" access="remote" returntype="query" output="true">
        <cfargument name="COD_MOTORISTA" required="no" default=""/>
        <cfargument name="PLACA_CONTROLE" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select sign(count(1)) as possui_cpg_aberto
              from oper.v$contrato_transp ct
             inner join oper.v$contrato_transp_pagar ctp
                on ctp.lancto_id = ct.lancto_id
             where 1 = 1
               and (1 = 2
                   <cfif Len(Trim(arguments.COD_MOTORISTA)) >
                    or ct.motorista_cod_pessoa = #arguments.COD_MOTORISTA#
                   </cfif>
                   <cfif Len(Trim(arguments.PLACA_CONTROLE)) >
                    or ct.placa_controle = '#arguments.PLACA_CONTROLE#'
                   </cfif>             
                    )
            <cfif !Len(Trim(arguments.COD_MOTORISTA)) and !Len(Trim(arguments.PLACA_CONTROLE)) >
               and 1 = 2
            </cfif> 
               and ct.data_cancelamento is null 
               and exists (select 1
                             from finan.v$finan_contas_pagar fcp
                            where fcp.contas_pagar_id = ctp.contas_pagar_id 
                              and fcp.situacao <> 1
                           )
               and not exists (select 1
                                 from logistica.v$contrato_transp_cpg_aberto ctca
                                where ctca.lancto_id_anterior = ct.lancto_id
                                  and ctca.data_cancelamento is null )         
        </cfquery>
    <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os dados dos cpg em aberto do mesmo motorista
    -- RAFAEL 05/07/2018 - ADICIONADO
    --->
    <cffunction name="get_cpg_aberto_dados" access="remote" returntype="query" output="true">
        <cfargument name="COD_MOTORISTA" required="no" default=""/>
        <cfargument name="PLACA_CONTROLE" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct ct.lancto_id
                 , ct.num_formulario
                 , ct.serie_formulario
                 , to_char(ct.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , ct.num_romaneio
                 , ct.placa_controle
                 , ct.placa_referencia
                 , (select r.descricao_rota
                      from oper.v$rota r
                      where r.rota_id = ct.rota_id ) as rota
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = ct.motorista_cod_pessoa ) as motorista
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = ct.cod_destinatario ) as destinatario
              from oper.v$contrato_transp ct
             inner join oper.v$contrato_transp_pagar ctp
                on ctp.lancto_id = ct.lancto_id
             where 1 = 1
               and (1 = 2
                   <cfif Len(Trim(arguments.COD_MOTORISTA)) >
                    or ct.motorista_cod_pessoa = #arguments.COD_MOTORISTA#
                   </cfif>
                   <cfif Len(Trim(arguments.PLACA_CONTROLE)) >
                    or ct.placa_controle = '#arguments.PLACA_CONTROLE#'
                   </cfif>             
                    )
            <cfif !Len(Trim(arguments.COD_MOTORISTA)) and !Len(Trim(arguments.PLACA_CONTROLE)) >
               and 1 = 2
            </cfif> 
               and ct.data_cancelamento is null 
               and exists (select 1
                             from finan.v$finan_contas_pagar fcp
                            where fcp.contas_pagar_id = ctp.contas_pagar_id 
                              and fcp.situacao <> 1
                           )
               and not exists (select 1
                                 from logistica.v$contrato_transp_cpg_aberto ctca
                                where ctca.lancto_id_anterior = ct.lancto_id
                                  and ctca.data_cancelamento is null )
        </cfquery>
    <cfreturn qr_result>
    </cffunction>
    
    <!---
    -- PROPSITO
    -- Busca os dados da Cummins
    -- RAFAEL 04/07/2019
    --->
    <cffunction name="get_solicitacao_carga_cummins" access="remote" returntype="query" output="true">
        <cfargument name="SOLICITACAO_CARGA_ID" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sc.bu
                 , sc.centro_custo
                 , sc.motivo
              from logistica.v$solicitacao_cummins sc
              <cfif Len(Trim(#arguments.SOLICITACAO_CARGA_ID#))>
                 where sc.solicitacao_carga_id = #arguments.SOLICITACAO_CARGA_ID#
              <cfelse>
                 where 1 = 0
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

</cfcomponent>
