<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
    -- PROPSITO 
    -- Retorna o histrico da utilizao dos cartes Repom
    -- ANDERSON 10/09/2011 - CRIADO
    --->		
    <cffunction name="get_historico_cartao" access="remote" returntype="query" output="true">
    	<cfargument name="cartao_numero" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="cod_proprietario" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.contrato_id
                 , t.processo_transporte_codigo
                 , t.num_romaneio
                 , t.unidade_negocio
                 , t.centro_custo
                 , t.cartao_numero
                 , t.proprietario_cnpj_cpf
                 , t.proprietario_razao_social
                 , t.proprietario
                 , t.motorista_cpf
                 , t.motorista
                 , t.cod_veiculo_cavalo
                 , t.placa_cavalo
                 , t.cod_veiculo_carreta
                 , t.placa_carreta
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , t.usuario_cancelamento
                 , to_char(t.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
                 , (select count(*) 
                      from repom.v$contrato co
                     where co.cartao_id = t.cartao_id
                       and co.status_codigo in (1,14)) as num_contratos
              from (
                    select ct.contrato_id
                         , ct.processo_transporte_codigo
                         , ct.num_romaneio
                         , (select o.cod_unidade_negocio || ' - ' || kss.pkg_pessoa.fnc_get_cliente(o.cod_pessoa, 1)
                              from logistica.v$viagem v
                             inner join logistica.v$viagem_carga vc
                                     on vc.viagem_id = v.viagem_id
                             inner join logistica.v$solicitacao_carga sc
                                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = sc.cod_organograma
                             where v.num_romaneio = ct.num_romaneio
                               and rownum = 1
                           ) as unidade_negocio
                         , (select o.cod_centro_custo || ' - ' || cc.centro_custo
                              from logistica.v$viagem v
                             inner join logistica.v$viagem_carga vc
                                     on vc.viagem_id = v.viagem_id
                             inner join logistica.v$solicitacao_carga sc
                                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = sc.cod_organograma
                             inner join kss.v$centro_custo cc
                                     on cc.cod_centro_custo = o.cod_centro_custo
                             where v.num_romaneio = ct.num_romaneio
                               and rownum = 1
                           ) as centro_custo
                         , c.cartao_numero
                         , c.cartao_id
                         , kss.pkg_pessoa.fnc_get_identificador(ct.cod_proprietario) as proprietario_cnpj_cpf
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_proprietario) as proprietario_razao_social
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_proprietario, 1) as proprietario
                         , kss.pkg_pessoa.fnc_get_identificador(ct.cod_motorista) as motorista_cpf
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_motorista, 1) as motorista
                         , oper.pkg_veiculo.fnc_placa(ct.veiculo_id_cavalo) as placa_cavalo
                         , oper.pkg_veiculo.fnc_cod_veiculo(ct.veiculo_id_cavalo) as cod_veiculo_cavalo
                         , oper.pkg_veiculo.fnc_placa(ct.veiculo_id_carreta) as placa_carreta
                         , oper.pkg_veiculo.fnc_cod_veiculo(ct.veiculo_id_carreta) as cod_veiculo_carreta
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento
                      from repom.v$contrato ct
                     inner join repom.v$cartao c
                             on c.cartao_id = ct.cartao_id
                     where 1 = 1
                       and (
                            <cfif Len(Trim(arguments.cartao_numero))>
								c.cartao_numero = #arguments.cartao_numero#
                            </cfif>
                            
                            <cfif Len(Trim(arguments.cod_motorista))>
								<cfif Len(Trim(arguments.cartao_numero))>
                                	or
                                </cfif>
                                ct.cod_motorista = #arguments.cod_motorista#
                            </cfif>
                            
                            <cfif Len(Trim(arguments.cod_proprietario))>
                            	<cfif Len(Trim(arguments.cartao_numero)) or Len(Trim(arguments.cod_motorista))>
                                    or
                                </cfif>
                                ct.cod_proprietario = #arguments.cod_proprietario#
                            </cfif>
                           )
                     order by ct.date_insert desc
                   ) t
             where rownum <= 10
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
</cfcomponent>
