<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPSITO
	-- Busca lotes/operaes ativas
	--->
	<cffunction name="get_operacao_ativa" access="remote" returntype="query" output="true">
    	<cfargument name="cod_organograma" required="no" default="">
    	<cfargument name="data" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select l.lote_id, cc.cod_centro_custo, cc.centro_custo
                   , l.num_contrato, l.descricao as lote, o.operacao_id
                   , o.descricao as operacao
                   , <cfif len(trim(arguments.DATA))>'#arguments.DATA#'<cfelse>trunc(sysdate)</cfif> as data
                   , round(l.cadencia_ton_dia) as cadencia_ton_dia
                   , nvl(pcd.peso_programado,0) as peso_programado
                   , (select kss.fnc_concat_all(kss.to_concat_expr('Peso: ' || pcd.peso_programado || ' Ton cancelado por: ' || pcd.usuario_cancelamento || ' em ' || to_char(pcd.data_cancelamento,'dd/mm/yyyy'),chr(10)))
                        from kmm_bi.v$prog_carga_dia pcd
                       where pcd.cod_centro_custo = og.cod_centro_custo
                         and pcd.operacao_id = lo.operacao_id
                         and pcd.data = <cfif len(trim(arguments.DATA))>'#arguments.DATA#'<cfelse>trunc(sysdate)</cfif>
                         and pcd.data_cancelamento is not null) as ajustes
              from logistica.v$lote l
             inner join logistica.v$lote_operacao lo
                on lo.lote_id = l.lote_id
             inner join logistica.v$operacao o
                on o.operacao_id = lo.operacao_id
             inner join logistica.v$operacao_filial_emissao ofe
                on ofe.operacao_id = o.operacao_id
             inner join kss.v$organograma og
                on og.cod_organograma = ofe.cod_organograma
             inner join kss.v$centro_custo cc
                on cc.cod_centro_custo = og.cod_centro_custo   
             left join kmm_bi.v$prog_carga_dia pcd
                on pcd.cod_centro_custo = og.cod_centro_custo
               and pcd.operacao_id = lo.operacao_id
               and pcd.data = <cfif len(trim(arguments.DATA))>'#arguments.DATA#'<cfelse>trunc(sysdate)</cfif>
               and pcd.data_cancelamento is null
             where l.data_termino >= <cfif len(trim(arguments.DATA))>'#arguments.DATA#'<cfelse>trunc(sysdate)</cfif>
               and ofe.cod_organograma = #arguments.cod_organograma#
            order by cc.centro_custo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca a arvore de Operaes
	-- CRISTOFER  09/05/2009
	--->
	<cffunction name="get_operacao" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
        <cfargument name="edi" required="no" default="">
        <cfargument name="cod_organograma" required="no" default="">
        <cfargument name="internacional" required="no" default="">
        <cfargument name="consultar_por" required="no" default="">
        <cfargument name="valor" required="no" default="">
        <cfargument name="somente_ativas" required="no" default="0">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_departamento" required="no" default="">
        <cfargument name="cod_setor" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select replace(substr(sys_connect_by_path(o.descricao, '!!'),5), '!!', '->') as operacao_completa,
                   operacao_id,
                   operacao_id_pai,
                   nvl(o.operacao_id_pai,0) as operacao_id_pai_nvl,
                   (select o2.descricao
                      from logistica.v$operacao o2
                     where o2.operacao_id = o.operacao_id_pai) as operacao_pai_descricao,
                   descricao,
                   veiculos_dedicados,
                   internacional,
                   dedicado,
                   fracionado,
                   frete_proprio,
                   num_especie,
                   regra_fiscal_id,
                   cod_negociador,
                   (select oc.cod_pessoa
                      from logistica.v$operacao_cliente oc
                     where oc.tipo_cliente = 4
                       and oc.operacao_id = o.operacao_id
                       and rownum = 1 ) as cod_cliente_cobranca,
                   frete_por_conta,
                   case (select count(o2.operacao_id)
                           from logistica.v$operacao o2
                          where o2.operacao_id_pai = o.operacao_id)
                      when 0
                         then 'false'
                      else  'true'
                   end possui_filhos,
                   o.tipo_pagamento_id,
                   o.pedido_shipment,
                   o.adiantamento_frete_vazio,
                   o.tipo_servico_id,
                   o.tipo_docto_frete,
                   o.exige_xml_nfe,
                   (select sign(count(*))
                      from logistica.v$operacao_trecho_aprovacao ota
                     where (ota.operacao_id_1 = o.operacao_id or ota.operacao_id_2 = o.operacao_id)
                       and ota.desaprovado_em is null
                       and ota.aprovado_em is null) as pendente,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site,
                   controla_container,
                   controla_container_cg_direta,
				   (select count(1)
                      from logistica.v$operacao_tipo_pagamento otp
                     where otp.operacao_id = o.operacao_id
                       and otp.tipo_pagamento_id = 2/*Repom*/ ) as possui_repom
              from logistica.v$operacao o
             where 1=1
		 <cfif len(trim(arguments.operacao_id))>
           	   and o.operacao_id = #arguments.operacao_id#
         </cfif>
         <cfif Len(Trim(arguments.internacional))>
            and o.internacional = #arguments.internacional#
         </cfif>
         <cfif Len(Trim(arguments.consultar_por)) and Len(Trim(arguments.valor))>
         	<cfif arguments.consultar_por eq 1>
            	and o.operacao_id = #arguments.valor#
            </cfif>
            <cfif arguments.consultar_por eq 2>
            	and upper(kss.pkg_string.fnc_string_clean(o.descricao)) like  upper(kss.pkg_string.fnc_string_clean('%#arguments.valor#%'))
            </cfif>
         </cfif>
         <cfif Len(Trim(arguments.cod_centro_custo))>
               and operacao_id in (select operacao_id
                                     from logistica.v$operacao op
                                    start with operacao_id in (select operacao_id
                                                                 from logistica.v$operacao_filial_emissao
                                                                where cod_organograma in (select o.cod_organograma
                                                                                            from kss.v$organograma o
                                                                                           where 1=1
                                                                                           	<cfif Len(Trim(arguments.cod_pessoa_filial))>
                                                                                             and o.cod_pessoa = #arguments.cod_pessoa_filial#
                                                                                            </cfif>
                                                                                            <cfif Len(Trim(arguments.cod_departamento))>
                                                                                             and o.cod_departamento = #arguments.cod_departamento#
                                                                                            </cfif>
                                                                                            <cfif Len(Trim(arguments.cod_setor))>
                                                                                             and o.cod_setor = #arguments.cod_setor#
                                                                                            </cfif>
                                                                                            <cfif Len(Trim(arguments.cod_centro_custo))>
                                                                                             and o.cod_centro_custo = #arguments.cod_centro_custo#))
                                                                                            </cfif>
                                   connect by operacao_id = prior operacao_id_pai)
             <cfelse>
             	<cfif len(trim(arguments.cod_organograma))>
                   and operacao_id in (select operacao_id
                                         from logistica.v$operacao op
                                        start with operacao_id in (select operacao_id
                                                                     from logistica.v$operacao_filial_emissao
                                                                    where cod_organograma in (#arguments.cod_organograma#))
                                       connect by operacao_id = prior operacao_id_pai)
                 </cfif>
             </cfif>
         <cfif arguments.somente_ativas eq 1>
           and o.ativo = 1
         </cfif>
          start with o.operacao_id_pai is null
  connect by prior o.operacao_id = o.operacao_id_pai
		 <cfif len(trim(arguments.edi))>
          order by operacao_pai_descricao, o.descricao
         <cfelseif Len(Trim(arguments.consultar_por)) and Len(Trim(arguments.valor))>
          order by o.descricao
         </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as naturezas de uma operacao
	-- CRISTOFER  09/05/2009
	--->
	<cffunction name="get_operacao_natureza" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select n.operacao_id,
                   n.num_natureza,
                   nat.descricao as natureza,
                   nat.peso_especifico
              from logistica.v$operacao_natureza n
             inner join oper.v$natureza nat
                     on nat.num_natureza = n.num_natureza
             where n.operacao_id = #arguments.operacao_id#
             order by nat.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as acoes pelo cdigo do item de acesso
	-- RICARDO 08/01/2016
	--->
	<cffunction name="get_acao_cod" access="remote" returntype="query" output="true">
    	<cfargument name="item_acesso_cod" required="yes">
        <cfargument name="cod_acao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ac.cod_acao
              from acesso.v$item_acesso_acao iaa
             inner join acesso.v$acao ac
                on ac.acao_id = iaa.acao_id
             inner join acesso.v$grupo_item_acesso_acao giaa
                on giaa.item_acesso_acao_id = iaa.item_acesso_acao_id
             inner join acesso.v$grupo_acesso ga
                on ga.grupo_acesso_id = giaa.grupo_acesso_id
             inner join acesso.v$grupo_acesso_usuario gau
                on gau.grupo_acesso_id = ga.grupo_acesso_id
             where iaa.item_acesso_id in (select item_acesso_id
                                            from acesso.item_acesso
                                           where item_acesso_cod = '#arguments.item_acesso_cod#')
               and gau.usuario = user
               <cfif len(trim(arguments.cod_acao))>
                  and ac.cod_acao = '#arguments.cod_acao#'
              </cfif>
               and (exists (select 0
                              from acesso.v$grupo_usuario_filial guf
                             inner join kss.v$unidade_negocio un
                                on un.cod_pessoa = guf.cod_pessoa
                             where guf.grupo_acesso_usuario_id = gau.grupo_acesso_usuario_id)
                    or not exists (select 0
                                     from acesso.v$grupo_usuario_filial guf
                                    where guf.grupo_acesso_usuario_id = gau.grupo_acesso_usuario_id))
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca o parametro de modalidade
	-- RICARDO 08/01/2016
	--->
	<cffunction name="get_parametro_modalidade" access="remote" returntype="query" output="true">
    	<cfargument name="identificador" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select case when upper(x.valor) like '%FROTA%' then 1 else 0 end as frota
                 , case when upper(x.valor) like '%AGREGADO%' then 1 else 0 end as agregado
                 , case when upper(x.valor) like '%TERCEIRO%' then 1 else 0 end as terceiro
              from (select kss.pkg_parametro.fnc_valor_string('#arguments.identificador#') as valor from dual) x
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as pessoas de uma operacao
	-- CRISTOFER  09/05/2009
	--->
	<cffunction name="get_operacao_cliente" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
        <cfargument name="tipo_cliente" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.operacao_id
                 , c.cod_pessoa
                 , p.cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_pessoa,1) as cliente
                 , kss.pkg_pessoa.fnc_get_endereco(c.cod_pessoa, 1) as endereco
                 , nvl(ped.municipio_id, pe.municipio_id) as municipio_id
                 , nvl(ped.municipio, pe.municipio) || ' - ' || ped.uf as municipio_uf
              from logistica.v$operacao_cliente c
             inner join kss.v$pessoa p
                     on p.cod_pessoa = c.cod_pessoa
              left join kss.v$pessoa_estrangeira pe
                     on pe.cod_pessoa = c.cod_pessoa
              left join kss.v$pessoa_endereco_padrao ped
                     on ped.cod_pessoa = c.cod_pessoa
             where 1 = 1
			<cfif len(trim(arguments.tipo_cliente))>
               and c.tipo_cliente = #arguments.tipo_cliente#
            </cfif>
            <cfif len(trim(arguments.operacao_id))>
               and c.operacao_id = #arguments.operacao_id#
            </cfif>
             order by cliente
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os municipios da operacao
	-- CRISTOFER  11/05/2009
	--->
	<cffunction name="get_operacao_municipio" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
        <cfargument name="origem_destino" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.operacao_id,
                   m.municipio_id,
                   cep.pkg_municipio.fnc_municipio_uf(m.municipio_id) as municipio,
                   (select u.nome_uf
                      from cep.cep_ufs u
                     inner join cep.municipio m2
                             on m2.uf_id = u.sigla_uf
                     where m2.municipio_id = m.municipio_id) uf
              from logistica.v$operacao_municipio m
             where 1=1
             <cfif len(trim(arguments.operacao_id))>
               and m.operacao_id = #arguments.operacao_id#
             </cfif>
             <cfif len(trim(arguments.origem_destino))>
               and m.origem_destino = #arguments.origem_destino#
             </cfif>
             order by uf, municipio
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os tipos de carroceria da operacao
	-- CRISTOFER  12/05/2009
	--->
	<cffunction name="get_operacao_tipo_carroceria" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select s.operacao_id,
                   s.tipo_carroceria_id,
                   vt.descricao tipo_carroceria,
                   va.descricao as agrupamento,
                   s.date_insert,
                   s.user_insert,
                   s.date_update,
                   s.user_update,
                   s.site
              from logistica.v$operacao_tipo_carroceria s
             inner join oper.v$veiculo_tipo_carroceria vt
                     on vt.tipo_carroceria_id = s.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vt.agrupamento_id
             where 1=1
             <cfif len(trim(arguments.operacao_id))>
               and s.operacao_id = #arguments.operacao_id#
             </cfif>
             order by vt.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os acessorios da operacao
	-- CRISTOFER  12/05/2009
	--->
	<cffunction name="get_operacao_acessorio" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oa.operacao_id,
                   oa.material_id,
                   ma.descricao as acessorio,
                   mc.descricao as categoria,
                   oa.date_insert,
                   oa.user_insert,
                   oa.date_update,
                   oa.user_update,
                   oa.site
              from logistica.v$operacao_acessorio oa
             inner join oper.v$material_acessorio ma
                     on ma.material_id = oa.material_id
             inner join oper.v$material_categoria mc
                     on mc.CATEGORIA_ID = ma.CATEGORIA_ID
             where 1=1
             <cfif len(trim(arguments.operacao_id))>
               and oa.operacao_id = #arguments.operacao_id#
             </cfif>
             order by ma.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os acessorios da operacao
	-- RAFAEL 22/03/2010
	--->
	<cffunction name="get_operacao_gerenciadora" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select g.descricao
                      from logistica.v$gerenciadora g
                     where g.gerenciadora_id = prg.gerenciadora_id) as descricao
                 , (select g.gerenciadora_id
                      from logistica.v$gerenciadora g
                     where g.gerenciadora_id = prg.gerenciadora_id) as gerenciadora_id
                 , (select g.padrao
                      from logistica.v$gerenciadora g
                     where g.gerenciadora_id = prg.gerenciadora_id) as padrao
                 , prg.obrigatoria
              from logistica.v$plano_risco_gerenciadora prg
             where prg.plano_risco_id = (select o.plano_risco_id
                                           from logistica.v$operacao_risco o
                                          where o.operacao_id = #arguments.operacao_id#)
             order by obrigatoria desc, padrao desc, descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Retorna os tipos de pagamento
    -- ANDERSON 13/06/2011 - CRIADO
    --->
    <cffunction name="get_tipo_pagamento" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tp.tipo_pagamento_id
                 , tp.descricao
              from logistica.v$tipo_pagamento tp
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca unidades de medida
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 20/04/2009
	--->
	<cffunction name="get_unidade" displayname="Busca unidades de medida" access="remote" returntype="query" output="false">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select u.cod_unidade,
            	   u.unidade,
                   u.cod_grupo_umedida,
                   nvl((select uc.equivalencia
                      from fiscal.v$unidade_medida_conversao uc
                     where uc.cod_unidade = u.cod_unidade
                       and uc.cod_unidade_eq = 'Kg'),1) as equivalencia_kg
			  from fiscal.v$unidade_medida u
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca espcie
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_especie" displayname="Busca Espcie" access="remote" returntype="query" output="false">
		<cfargument name="num_especie" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select  e.num_especie, e.descricao, e.frete_em
			  from oper.v$especie e
			 where 1=1
			 <cfif len(trim(arguments.num_especie))>
			   and num_especie = #arguments.num_especie#
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(e.descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by e.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Sub-series para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_sub_serie_nota" displayname="Busca Sub-series para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1" />
		<cfargument name="todas" required="no" default="0" />
        <cfargument name="cod_pessoa" required="no" default="" />
        <cfargument name="cod_departamento" required="no" default="" />
        <cfargument name="cod_setor" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="nfes" required="no" default="" />
        <cfargument name="carga_transportada" required="no" default="" />
		<cfif arguments.TODAS eq 0>
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.cod_modelo
                               ,ms.serie
                               ,ms.subserie
                               ,smf.modelo
                               ,nvl((select (max(nf.num_nota_fiscal)+1)
                                       from fiscal.v$nf_es nf
                                       where nf.cod_pessoa_filial = ms.cod_pessoa
                                       and nf.cod_departamento  = ms.cod_departamento
                                       and nf.cod_setor         = ms.cod_setor
                                       and nf.cod_centro_custo  = ms.cod_centro_custo
                                       and nf.cod_modelo        = ms. cod_modelo
                                       and nf.serie             = ms.serie
                                       and nf.subserie          = ms.subserie),(ms.num_inicial)) as prox_nota
                          	from fiscal.v$modelo_serie ms
                      inner join fiscal.v$sintegra_modelo_fiscal smf
                       	      on smf.cod_modelo = ms.cod_modelo

                           where 1=1
                            and ms.ativo = 1
                 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
                 <cfif Len(Trim(arguments.nfes))>
					and smf.nfes = '#arguments.nfes#'
				 </cfif>
                 <cfif Len(Trim(arguments.carga_transportada))>
					and smf.cod_modelo in (select column_value
                           from table(kss.str2table(replace(kss.pkg_global.fnc_parametro_str(25,'FISCAL.EXE',9,405),',',';')))
                                          )
				 </cfif>
				 <cfif Len(Trim(arguments.cod_modelo))>
					and ms.cod_modelo in ('#PreserveSingleQuotes(arguments.cod_modelo)#')
				 </cfif>
				 <cfif Len(Trim(arguments.serie))>
					and ms.serie ='#arguments.serie#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_departamento))>
					and ms.cod_departamento ='#arguments.cod_departamento#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_pessoa))>
					and ms.cod_pessoa ='#arguments.cod_pessoa#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_setor))>
					and ms.cod_setor ='#arguments.cod_setor#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_centro_custo))>
					and ms.cod_centro_custo ='#arguments.cod_centro_custo#'
				 </cfif>
                 order by ms.cod_modelo, ms.serie, ms.subserie
				</cfquery>
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.subserie
				  from fiscal.v$modelo_serie ms
				 where 1=1
				 and ms.ativo = 1
				 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
				</cfquery>
		</cfif>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca a composicao do veiculo
	-- CRISTOFER  24/10/2006
	--->
	<cffunction name="get_composicao" access="remote" returntype="any" output="true">
		<cfargument name="cod_veiculo" required="yes">
		<cfargument name="data" required="no" default="">
		<cfargument name="trata_erro" required="no" default="0">
		<cfargument name="solicitacao_carga_id_vinculo" required="no" default="-1">
        <cftry>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select t.column_value as placa,
                         oper.pkg_veiculo.fnc_get_cod_veiculo(t.column_value) as cod_veiculo,
                         oper.pkg_veiculo.fnc_veiculo_id(t.column_value) as veiculo_id,
                         case when t.column_value = '-1' then 0 else oper.pkg_veiculo.fnc_veiculo_proprietario(t.column_value) end as veiculo_proprietario,
                         ((a.capacidade) - nvl((select sum(sc.peso)
												  from logistica.v$viagem_carga vc
												 inner join logistica.v$solicitacao_carga sc
													on vc.solicitacao_carga_id = sc.solicitacao_carga_id
												 where vc.viagem_id = (select vc2.viagem_id
																		 from logistica.v$viagem_carga vc2
																		where vc2.solicitacao_carga_id = '#arguments.solicitacao_carga_id_vinculo#')), 0)) as capacidade,
                         oper.pkg_veiculo.FNC_VEICULO_MODALIDADE(t.column_value) as modalidade,
                         (select d.articulado
                            from oper.v$veiculo_dados d
                           where d.placa = t.column_value) as articulado,
                         (select d.tipo_veiculo
                            from oper.v$veiculo_dados d
                           where d.placa = t.column_value) as tracao,
                         (select vpa.cod_pessoa
                            from oper.v$veiculo_proprietario_atual vpa
                           where vpa.placa = t.column_value) as cod_proprietario
                  from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.FNC_GET_COMPOSICAO(oper.pkg_veiculo.fnc_get_placa('#JSStringFormat(arguments.cod_veiculo)#')<cfif len(trim(arguments.data))>,'#arguments.data#'</cfif>),'|')) t,
                       (select oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(oper.pkg_veiculo.fnc_get_placa('#JSStringFormat(arguments.cod_veiculo)#')<cfif session.site eq 'delpozo/'>,0</cfif>,sysdate) as capacidade from dual) a
                 where t.column_value is not null
            </cfquery>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = "">
         	<cfcatch>
            	<cfif arguments.trata_erro eq 0>
                	<cfthrow object="#cfcatch#">
                <cfelseif arguments.trata_erro eq 1>
		            <cfset retorno.erro = true>
		            <cfset retorno.mensagem = cfcatch>
                    <cfset qr_result = retorno>
                </cfif>
            </cfcatch>
        </cftry>
        <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os dados para o servio contratado
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO - 07/12/2005 - criado
	--->
	<cffunction name="get_motorista_proprietario" displayname="Busca os dados para o servio contratado" access="remote" returntype="struct" output="false">
		<cfargument name="placa_controle" required="yes">
		<cfargument name="data_emissao" required="no" default="#LSDateFormat(now())# #TimeFormat(now(),'HH:MM:SS')#">
        <cfargument name="trata_erro" required="no" default="0">
			<cftry>
				<cfscript>
					qrVeiculo = this.get_composicao(cod_veiculo = arguments.placa_controle);
				</cfscript>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_motorista.prc_get_motorista_proprietario" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#Replace(qrVeiculo.placa,'-','')#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#arguments.data_emissao#">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnpj_prop">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.endereco">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cidade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.uf">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.proprietario_municipio_id">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cpf_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.nome_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_date"     variable="retorno.cnh_validade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnh_numero">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.pis_pasep_nit">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.retorno">
				</cfstoredproc>

				<cfset retorno.veiculo_proprietario = qrVeiculo.veiculo_proprietario>

				<cfscript>
					qrVeiculo = this.get_veiculo(placa = arguments.placa_controle);
				</cfscript>

				<cfset retorno.tag_ctf = qrVeiculo.tag_ctf>
                <cfset retorno.erro = false>
			<cfcatch>
            	<cfif arguments.trata_erro eq 0>
	            	<cfthrow detail="#cfcatch.Detail#">
                </cfif>
            	<cfif arguments.trata_erro eq 2>
					<cfset retorno.mensagem = cfcatch>
                    <cfset retorno.erro = true>
                </cfif>
            	<cfif arguments.trata_erro eq 1>
					<cfset retorno = StructNew()>
                    <cfset retorno.cod_pessoa_proprietario = ''>
                    <cfset retorno.proprietario = 'Problemas com o veculo.'>
                    <cfset retorno.cnpj_prop = ''>
                    <cfset retorno.endereco = ''>
                    <cfset retorno.cidade = ''>
                    <cfset retorno.uf = ''>
                    <cfset retorno.proprietario_municipio_id = ''>
                    <cfset retorno.cod_pessoa_motorista = ''>
                    <cfset retorno.nome_motorista = ''>
                    <cfset retorno.cnh_validade = ''>
                    <cfset retorno.cnh_numero = ''>
                    <cfset retorno.pis_pasep_nit = ''>
                    <cfset retorno.retorno = ''>
                </cfif>
			</cfcatch>
			</cftry>
			<cfset retorno.placa = arguments.placa_controle>
		<cfreturn retorno>
	</cffunction>

    <!---
	-- PROPSITO
	-- Verifica se o motorista esta bloqueado para emisso do conhecimento
	-- FABIOG 30/08/2011
	--->
    <cffunction name="verifica_bloqueio_motorista" displayname="Verifica se o motorista esta bloqueado" access="remote" returntype="query" output="false">
		<cfargument name="cod_motorista" required="yes"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select count(1) as motorista_bloqueado
              from oper.v$agreg_bloqueio_motorista v
             where v.cod_pessoa = #arguments.cod_motorista#
               and v.data_desbloqueio is null
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Verifica se o veculo esta bloqueado para emisso do conhecimento
	-- FABIOG 30/08/2011
	--->

    <cffunction name="verifica_bloqueio_veiculo" displayname="Verifica se o veculo esta bloqueado" access="remote" returntype="query" output="false">
		<cfargument name="placa" required="yes"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select count(1) as veiculo_bloqueado
              from oper.v$agreg_bloqueio_veiculo v
             where v.veiculo_id = oper.pkg_veiculo.fnc_veiculo_id('#arguments.placa#')
               and v.data_desbloqueio is null
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>


	<!---
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--
	-- 07/12/2005 - criado
	--->
	<cffunction name="get_veiculo" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="placa_exa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="frota_exa" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7">
		<!---Terceiros--->
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct vd.veiculo_id, vd.placa,
                    vd.cod_veiculo,
                    vd.num_rastreador,
                    vd.rastreador_id,
                    vd.rastreador_com_problemas,
                    vd.marca_id,
                    vd.marca,
                    vd.modelo_id,
                    vd.situacao_id,
                    vd.uf,
                    vd.capacidade_tanque,
                    oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(vd.placa,sysdate) capacidade,
                    vd.km_revisao,
                    vd.modelo,
                    vd.proprietario,
                    vd.observacao,
                    vd.cor_predominante,
                    vd.ano,
                    vd.chassis,
                    vd.renavan,
                    va.agrupamento_id,
                    va.descricao as agrupamento,
                    vtc.tipo_carroceria_id,
               		vtc.descricao as tipo_carroceria,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TAG_CTF') as tag_ctf,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TARA') as tara,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'COMBUSTIVEL') as combustivel,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'NUMERO_EIXOS') as numero_eixos,
                    va.tracao,
                    vd.municipio_id,
                    (select municipio
                       from cep.municipio m
                      where m.municipio_id = vd.municipio_id) as municipio,
                    vd.tipo_carroceria_id,
                    vtc.descricao as tipo
              from oper.v$veiculo_dados vd
              left join oper.v$veiculo_tipo_carroceria vtc
                     on vd.tipo_carroceria_id = vtc.tipo_carroceria_id
              left join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
              left join oper.v$veiculo_proprietario vp on vp.placa = vd.placa
                                                      and vp.data_fim is null
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
			   and vd.placa like upper('%#arguments.placa#%')
			</cfif>
			<cfif Len(Trim(arguments.placa_exa))>
			   and upper(vd.placa) = '#arguments.placa_exa#'
			</cfif>
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vd.cod_veiculo) like upper('#arguments.cod_veiculo#%')
			</cfif>
			<cfif Len(Trim(arguments.proprietario))>
			   and vd.proprietario in (#arguments.proprietario#)
			</cfif>
			<cfif Len(Trim(arguments.frota))>
			   and (vd.placa like upper('#arguments.frota#%')
			       or vd.cod_veiculo like upper('#arguments.frota#%'))
			</cfif>
			<cfif Len(Trim(arguments.frota_exa))>
			   and (upper(vd.placa) = '#arguments.frota_exa#'
			       or upper(vd.cod_veiculo) = '#arguments.frota_exa#')
			</cfif>
			order by vd.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca natureza
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 19/07/2009 - MODIFICADO
	--->
	<cffunction name="get_natureza" displayname="Busca Natureza" access="remote" returntype="query" output="false">
		<cfargument name="num_natureza" required="no" default="">
		<cfargument name="descricao" required="no" default="">
        <cfargument name="order_by" required="no" default="0" hint="0-Descrio Resumida, Descrio; 1-Descrio">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select n.num_natureza, n.descricao, n.grupo_natureza_id, gn.descricao_resumida grupo, gn.descricao as descricao_grupo, n.peso_especifico
              from oper.v$natureza n
             inner join oper.v$grupo_natureza gn
                     on gn.grupo_natureza_id = n.grupo_natureza_id
             where 1=1
			<cfif Len(Trim(arguments.num_natureza))>
			   and n.num_natureza = #arguments.num_natureza#
			</cfif>
			<cfif Len(Trim(arguments.descricao))>
			   and upper(n.descricao) like upper('%#arguments.descricao#%')
			</cfif>

            <cfif arguments.order_by eq 0>
			 order by gn.descricao_resumida, n.descricao
            <cfelseif arguments.order_by eq 1>
             order by n.descricao
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca configurao de valor segurado para notas fiscais
	--->
	<cffunction name="get_config_valor_segurado" displayname="Busca configurao de valor segurado para notas fiscais" access="remote" returntype="query" output="false">
		<cfargument name="operacao_id" required="yes" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select o.destinado_exportacao
                 , nvl(kss.pkg_parametro.fnc_valor_numerico('M204-P0150'), 0) as adicional_valor_segurado
                 , os.perc_sobretaxa
              from logistica.v$operacao o
             inner join logistica.v$operacao_seguro os
			       on os.operacao_id = o.operacao_id
              where 1=1
			<cfif Len(Trim(arguments.operacao_id))>
			   and o.operacao_id = #arguments.operacao_id#
			</cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca percentual de sobretaxa do seguro da operao
	-- ALEXANDRE ANFILO 05/2017
	--->
	<cffunction name="get_sobretaxa_seguro_operacao" displayname="Busca percentual de sobretaxa do seguro da operao" access="remote" returntype="query" output="false">
	 <cfargument name="operacao_id" required="yes" default="">
	 <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
	    select os.perc_sobretaxa
		   from logistica.v$operacao o
		  inner join logistica.v$operacao_seguro os
		     on os.operacao_id = o.operacao_id
		  where 1=1
		 <cfif Len(Trim(arguments.operacao_id))>
		    and o.operacao_id = #arguments.operacao_id#
		 </cfif>
	 </cfquery>
	 <cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os lotes da operao
	-- Gustavo R. 14/06/2017
	--->
	<cffunction name="get_operacao_lote" displayname="Retorna os lotes da operao" access="remote" returntype="query" output="false">
	 <cfargument name="operacao_id" required="yes" default="">
	 <cfargument name="lote_id" required="no" default="">
	 <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
	    select distinct 
			   l.lote_id
			 , case 
			      when l.situacao_id = 2 then l.lote_id||' - '||l.descricao||' (ESGOTADO)'
			      else l.lote_id||' - '||l.descricao||' (Viagens: '||(l.viagem_limite - l.viagem_realizada)||'; Ton.: '||(l.tonelada_limite - l.tonelada_realizada)||'; R$: '||(l.valor_limite - l.valor_realizado)||')' 
			   end lote_info
			 , (l.viagem_limite - l.viagem_realizada) as lote_viagem_restante
			 , (l.tonelada_limite - l.tonelada_realizada) as lote_peso_restante
			 , (l.valor_limite - l.valor_realizado) as lote_valor_restante
		  from logistica.v$lote l
		 inner join logistica.v$lote_operacao lo
			on lo.lote_id = l.lote_id
		 where 1=1
		   and lo.operacao_id = #arguments.operacao_id#
        <cfif Len(Trim(arguments.lote_id))>
		   and ((l.situacao_id = 1 and sysdate between l.data_inicio and l.data_termino) or l.lote_id = #arguments.lote_id#)
		<cfelse>
		   and (l.situacao_id = 1 and sysdate between l.data_inicio and l.data_termino)
		</cfif>
		 order by l.lote_id
	 </cfquery>
	 <cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as datas de incio e trmino de carga e descarga
	-- Gustavo R. 14/06/2017
	--->
	<cffunction name="get_operacao_tempo" displayname="Retorna as datas da operao" access="remote" returntype="query" output="false">
	 <cfargument name="operacao_id" required="yes" default="">
	 <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
	    select to_char(
				 case
					when to_number(to_char(sysdate, 'hh24')) < 12 then trunc(sysdate)+1/2
					else trunc(sysdate+1)
				 end
				 , 'dd/mm/yyyy hh24:mi') as carga_inicio
			 , to_char(
				 case
					when to_number(to_char(sysdate, 'hh24')) < 12 then trunc(sysdate)+1/2
					else trunc(sysdate+1)
				 end + decode(o.tempo_min_carga, null, 1/24, o.tempo_min_carga - trunc(o.tempo_min_carga))
				 , 'dd/mm/yyyy hh24:mi') as carga_termino
			 , to_char(
				 case
					when to_number(to_char(sysdate, 'hh24')) < 12 then trunc(sysdate)+1
					else trunc(sysdate)+2.5
				 end
				 , 'dd/mm/yyyy hh24:mi') as descarga_inicio
		     , to_char(
				 case
					when to_number(to_char(sysdate, 'hh24')) < 12 then trunc(sysdate)+1
					else trunc(sysdate)+2.5
				 end + decode(o.tempo_min_descarga, null, 1/24, o.tempo_min_descarga - trunc(o.tempo_min_descarga))
				 , 'dd/mm/yyyy hh24:mi') as descarga_termino
		  from logistica.v$operacao o
		 where 1=1
		   and o.operacao_id = #arguments.operacao_id#
	 </cfquery>
	 <cfreturn qr_result>
	</cffunction>
</cfcomponent>
