<cfcomponent displayname="CConsultas da área de emissao de documentos" extends="_transportes.funcoes.cfc_init"> 

<!--- 
	-- PROPÓSITO 
	-- Busca os dados da operação para a emissao de conhecimentos, da estrutura fracionada
	-- NOTAS EXPLICATIVAS
	-- Ricardo Laurindo 22/02/2017
	--->		
	<cffunction name="get_operacao_ctrc_fracionado" access="remote" returntype="query" output="true">
		<cfargument name="operacao_id" required="no" default="">
		<cfargument name="carga_consolidada_id" required="no" default="">
		<cfargument name="solicitacao_carga_id" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select distinct o.operacao_id
                , o.pedido_shipment
				, o.pedido_shipment_edicao
                , ccc.carga_consolidada_id
                , o.regra_fiscal_id
                , o.descricao as operacao
                , logistica.pkg_operacao.fnc_descricao_completa(o.operacao_id) as operacao_descricao
                , sc.valor_em as frete_em
                , o.frete_por_conta
                , rem.cod_atividade_fiscal
                , fiscal.pkg_conhecimento.fnc_produto_frete(nvl(remm.municipio_id,pes.municipio_id),nvl(destm.municipio_id,pesd.municipio_id),o.frete_proprio) as num_produto
                
                , rem.cod_pessoa cod_remetente
                , rem.tipo_pessoa as rem_tipo_pessoa
                , rem.cnpj_cpf rem_cnpj_cpf
                , nvl(rem.razao_social,rem.cliente) rem_razao_social
                , rem.inscricao_estadual rem_inscricao_estadual
                , reme.logradouro as rem_logradouro
                , reme.numero as rem_numero
                , reme.bairro as rem_bairro
                , reme.logradouro||decode(reme.numero,'','',',')||reme.numero||' '||reme.complemento||' - '||reme.bairro rem_endereco
                , to_char(reme.cep) rem_cep
                , nvl(remm.municipio,pes.municipio) rem_municipio
                , remm.uf_id rem_uf
                , nvl(remm.municipio_id,pes.municipio_id) rem_municipio_id
                
                , dest.cod_pessoa cod_destinatario
                , dest.tipo_pessoa as dest_tipo_pessoa
                , dest.cnpj_cpf dest_cnpj_cpf
                , nvl(dest.razao_social,dest.cliente) dest_razao_social
                , dest.inscricao_estadual dest_inscricao_estadual
                , trim(decode(dest.cod_pessoa,null,'',deste.logradouro||decode(deste.numero,'','',',')|| deste.numero||' '||deste.complemento|| decode(deste.bairro,'','',' - ')||deste.bairro)) dest_endereco
                , to_char(deste.cep) dest_cep
                , deste.logradouro||decode(deste.numero,'','',',')||deste.numero||' '||deste.complemento||' - '||deste.bairro dest_endereco
                , deste.logradouro as dest_logradouro
                , deste.numero as dest_numero
                , deste.bairro as dest_bairro
                , nvl(destm.municipio,pesd.municipio) dest_municipio
                , destm.uf_id dest_uf
                , nvl(destm.municipio_id,pesd.municipio_id) dest_municipio_id
                
                , decode(sc.cod_consignatario, null , 1 , 0) as permite_editar_consignatario                
                , nvl(sc.cod_consignatario,rem.cod_pessoa) cod_consignatario
                , nvl(cons.tipo_pessoa,rem.tipo_pessoa) as cons_tipo_pessoa
                , nvl(cons.cnpj_cpf,rem.cnpj_cpf) as cons_cnpj_cpf
                , nvl(cons.razao_social,nvl(rem.razao_social,rem.cliente)) cons_razao_social
                , nvl(cons.inscricao_estadual,rem.inscricao_estadual) cons_inscricao_estadual
                , nvl(cons_end.logradouro,reme.logradouro) as cons_logradouro
                , nvl(cons_end.numero,reme.numero) as cons_endereco_num
                , nvl(cons_end.bairro,reme.bairro) as cons_bairro
                , decode(sc.cod_consignatario,null,reme.logradouro||decode(reme.numero,'','',',')||reme.numero||' '||reme.complemento||' - '||reme.bairro
                , cons_end.logradouro||decode(cons_end.numero,'','',',')||cons_end.numero||' '||cons_end.complemento||' - '||cons_end.bairro) as cons_endereco
                , nvl(to_char(cons_end.cep),to_char(reme.cep)) cons_cep
                , nvl(cons_end.municipio,nvl(remm.municipio,pes.municipio)) cons_municipio
                , nvl(cons_end.uf,remm.uf_id) as cons_uf
                , nvl(cons_end.municipio_id,nvl(remm.municipio_id,pes.municipio_id)) cons_municipio_id
                
                , reme.cep as coleta_cep
                , reme.logradouro as coleta_logradouro
                , reme.complemento as coleta_complemento
                , reme.bairro as coleta_bairro
                , col.municipio coleta_municipio
                , reme.uf coleta_uf
                , sc.origem_municipio_id as coleta_municipio_id
                
                , deste.cep as entrega_cep
                , deste.logradouro as entrega_logradouro
                , deste.complemento entrega_complemento
                , deste.bairro entrega_bairro
                , ent.municipio entrega_municipio
                , ent.uf_id entrega_uf
                , sc.destino_municipio_id as entrega_municipio_id
                
                , decode(sc.cod_redespacho, null , 1 , 0) as permite_editar_redespacho
                , nvl(red.cod_pessoa, dest.cod_pessoa) as cod_redespacho
                , nvl(red.tipo_pessoa, dest.tipo_pessoa) as redespacho_tipo_pessoa
                , nvl(red.cnpj_cpf, dest.cnpj_cpf) as redespacho_cnpj_cpf
                , nvl(red.razao_social, nvl(dest.razao_social,dest.cliente)) as redespacho_razao_social
                , nvl(red.inscricao_estadual, dest.inscricao_estadual) as redespacho_inscricao_estadual
                , trim(decode(red.cod_pessoa,null,deste.logradouro||decode(deste.numero,'','',',')|| deste.numero||' '||deste.complemento|| decode(deste.bairro,'','',' - ')||deste.bairro, red_end.logradouro||decode(red_end.numero,'','',',')|| red_end.numero||' '||red_end.complemento|| decode(red_end.bairro,'','',' - ')||red_end.bairro)) red_endereco
                , to_char(nvl(red_end.cep, deste.cep)) redespacho_cep
                , nvl(red_end.logradouro, deste.logradouro) as redespacho_logradouro
                , deste.logradouro as dest_logradouro
                , nvl(red_end.numero, deste.numero) as redespacho_numero
                , nvl(red_end.bairro, deste.bairro) as redespacho_bairro
                , nvl(red_end.municipio,  nvl(destm.municipio,pesd.municipio)) redespacho_municipio
                , nvl(red_end.uf, destm.uf_id) as redespacho_uf
                , nvl(red_end.municipio_id, nvl(destm.municipio_id,pesd.municipio_id)) as redespacho_municipio_id
                
                , cob.cod_pessoa cod_cliente_cobranca
                , cob.tipo_pessoa cob_tipo_pessoa
                , cob.cnpj_cpf cob_cnpj_cpf
                , cob.razao_social cob_razao_social
                , cob.inscricao_estadual cob_inscricao_estadual
                , ecob.logradouro as cob_endereco
                , ecob.cep cob_cep
                , cobm.municipio cob_municipio
                , cobm.uf_id cob_uf
                , ecob.municipio_id cob_municipio_id
                , o.cod_negociador
                , neg.tipo_pessoa as neg_tipo_pessoa
                , neg.cnpj_cpf as neg_cnpj_cpf
                , neg.razao_social as neg_razao_social
                , neg.inscricao_estadual as neg_inscricao_estadual
                , neg_end.logradouro || ' ' || neg_end.numero as neg_endereco
                , to_char(neg_end.cep) as neg_cep
                , neg_end.municipio as neg_municipio
                , neg_end.uf as neg_uf
                , sc.num_natureza
                , (select opn.num_natureza
                     from logistica.v$operacao_natureza opn
                    where opn.operacao_id = o.operacao_id
                      and opn.num_natureza = sc.num_natureza) num_natureza_operacao
                , sc.num_especie
                , sc.cod_unidade
                , o.fracionado
                , o.internacional
                , o.frete_proprio
                , o.dedicado
                , logistica.pkg_agendamento.fnc_viagem_composicao_definida(v.viagem_id,' > ', 1) as composicao
                , logistica.pkg_agendamento.fnc_viagem_composicao_definida(v.viagem_id,' > ') as composicao_frota
                , logistica.pkg_agendamento.fnc_viagem_motorista_definida(v.viagem_id) as motorista
                , (select pm.cliente
                     from kss.v$pessoa pm
                    where pm.cod_pessoa = logistica.pkg_agendamento.fnc_viagem_motorista_definida(v.viagem_id)) as motorista_nome
                , to_char(v.data_termino,'dd/mm/yyyy hh24:mi') as data_termino
                , (select count(*)
                     from fiscal.v$categoria_imp_retencao cir
                    inner join fiscal.v$produto pr
                       on pr.categoria_id = cir.categoria_id
                    where produto_id = fiscal.pkg_conhecimento.fnc_produto_frete(nvl(remm.municipio_id,
                                                                                     pes.municipio_id),
                                                                                 nvl(destm.municipio_id,
                                                                                     pesd.municipio_id),
                                                                                 o.frete_proprio)) as impostos
                , to_char(sc.data_entrega_inicio, 'dd/mm/yyyy hh24:mi') as prazo_entrega
                , o.tipo_frete
                , o.tipo_servico_id
                , o.tipo_docto_frete
                , o.pagto_vale_pedagio
                , o.operadora_vale_pedagio
                , kss.pkg_pessoa.fnc_get_identificador(o.operadora_vale_pedagio, 0 ) as cnpj_operadora_vale_ped
                , kss.pkg_pessoa.fnc_get_cliente(o.operadora_vale_pedagio) as nome_operadora_vale_ped
                , o.fornecedora_vale_pedagio
                , o.exige_xml_nfe
                , o.operacao_vinculada_otm
                , sc.pedido_shipment as pedido_shipment_solicitacao
                , v.viagem_id
                , rem.inscricao_estadual || ',' ||
                  nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                         from kss.v$pessoa_inscricao_estadual ie2
                        where ie2.cod_pessoa = reme.cod_pessoa),
                      (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                         from kss.v$pessoa_endereco e
                        where e.cod_pessoa = rem.cod_pessoa
                          and rem.tipo_pessoa = 1
                          and e.inscricao_estadual <> rem.inscricao_estadual)) as rem_ie_adicional
                , nvl(cons.inscricao_estadual, rem.inscricao_estadual)|| ',' ||
                  nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                         from kss.v$pessoa_inscricao_estadual ie2
                        where ie2.cod_pessoa = nvl(cons.cod_pessoa, rem.cod_pessoa)),
                      (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                         from kss.v$pessoa_endereco e
                        where e.cod_pessoa = nvl(cons.cod_pessoa, rem.cod_pessoa)
                          and nvl(cons.tipo_pessoa,rem.tipo_pessoa) = 1
                          and e.inscricao_estadual <> nvl(cons.inscricao_estadual, rem.inscricao_estadual))) as coleta_ie_adicional
                , dest.inscricao_estadual || ',' ||
                  nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                         from kss.v$pessoa_inscricao_estadual ie2
                        where ie2.cod_pessoa = dest.cod_pessoa),
                      (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                         from kss.v$pessoa_endereco e
                        where e.cod_pessoa = dest.cod_pessoa
                          and dest.tipo_pessoa = 1
                          and e.inscricao_estadual <> dest.inscricao_estadual))  as dest_ie_adicional
                , nvl(red.inscricao_estadual, dest.inscricao_estadual)|| ',' ||
                  nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual,','))
                         from kss.v$pessoa_inscricao_estadual ie2
                        where ie2.cod_pessoa = nvl(red.cod_pessoa, dest.cod_pessoa)),
                      (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                         from kss.v$pessoa_endereco e
                        where e.cod_pessoa = nvl(red.cod_pessoa, dest.cod_pessoa)
                          and nvl(red.tipo_pessoa,dest.tipo_pessoa) = 1
                          and e.inscricao_estadual <> nvl(red.inscricao_estadual, dest.inscricao_estadual))) as entrega_ie_adicional
                , cob.inscricao_estadual || ',' ||
                  nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                         from kss.v$pessoa_inscricao_estadual ie2
                        where ie2.cod_pessoa = cob.cod_pessoa),
                      (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                         from kss.v$pessoa_endereco e
                        where e.cod_pessoa = cob.cod_pessoa
                          and cob.tipo_pessoa = 1
                          and e.inscricao_estadual <> cob.inscricao_estadual)) as cob_ie_adicional
                , neg.inscricao_estadual || ',' ||
                  nvl((select  kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                         from kss.v$pessoa_inscricao_estadual ie2
                        where ie2.cod_pessoa = neg.cod_pessoa),
                      (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                         from kss.v$pessoa_endereco e
                        where e.cod_pessoa = neg.cod_pessoa
                          and neg.tipo_pessoa = 1
                          and e.inscricao_estadual <> neg.inscricao_estadual)) as neg_ie_adicional
                , snf.ordem_compra_cliente
				, o.emite_multimodal
				, case when o.emite_multimodal = 1 or o.operacao_vinculada_otm = 1 then 1 else 0 end as vinculado_multimodal
				, o.tipo_documento as tipo_documento_operacao
				, to_char(fiscal.pkg_cte.fnc_permite_emitir_cte(sc.solicitacao_carga_id, 1)) as permite_emitir_cte
				, (select count(1)
				     from fiscal.v$conhecimento c
					inner join fiscal.v$documento_cte d
					   on d.conhecimento_id = c.conhecimento_id
					where c.modal = 6
					  and c.solicitacao_carga_id = sc.solicitacao_carga_id
					  and (select max(s.situacao_id) keep(dense_rank last order by ds.data_status, ds.doc_status_id)
						     from sefaz.documento_status ds
							inner join sefaz.status s
							   on s.cod_docto = ds.cod_docto
							  and s.cod_status = ds.cod_status
							where ds.documento_id = d.documento_id) in (0,1,2,5 )/*0 - Em digitação, 1 - Em Processamento, 2 - Autorizada, 5 - Rejeitada*/
					) as possui_multimodal_vinculado
			    , to_char(sc.data_carregamento_inicio, 'dd/mm/yyyy hh24:mi') as data_carregamento_inicio
				, sc.observacao
             from logistica.v$carga_consolidada_viagem ccv
            inner join logistica.v$viagem v
               on v.viagem_id = ccv.viagem_id
			   inner join logistica.v$carga_consolidada_carga ccc
				   on ccc.carga_consolidada_id = ccv.carga_consolidada_id
				  and ccc.situacao_id <> 0
            inner join logistica.v$solicitacao_carga sc
               on sc.solicitacao_carga_id = ccc.solicitacao_carga_id
             left join logistica.v$solicitacao_carga_nf snf
               on snf.solicitacao_carga_id = sc.solicitacao_carga_id       
            inner join logistica.v$operacao o
               on o.operacao_id = sc.operacao_id                            
            inner join cep.municipio col
               on col.municipio_id = sc.origem_municipio_id
             left join kss.v$pessoa rem
               on rem.cod_pessoa = sc.cod_remetente
             left join kss.v$pessoa_endereco_todos reme
               on reme.cod_pessoa = rem.cod_pessoa
              and ((reme.cod_endereco = sc.endereco_remetente_id) or (sc.endereco_remetente_id is null and reme.endereco_padrao = 1))
             left join kss.v$pessoa_estrangeira pes
               on pes.cod_pessoa = rem.cod_pessoa
             left join cep.municipio remm
               on remm.municipio_id = reme.municipio_id
             left join kss.v$pessoa dest
               on dest.cod_pessoa = sc.cod_destinatario
             left join kss.v$pessoa cob
               on cob.cod_pessoa = sc.cod_cobranca               
             left join kss.v$pessoa_endereco_todos ecob
               on ecob.cod_pessoa = sc.cod_cobranca
              and ((ecob.cod_endereco = sc.endereco_cobranca_id) or (sc.endereco_cobranca_id is null and ecob.endereco_padrao = 1))                              
             left join cep.municipio cobm
               on cobm.municipio_id =  ecob.municipio_id
             left join kss.v$pessoa_endereco_todos deste
               on deste.cod_pessoa = sc.cod_destinatario
              and ((deste.cod_endereco = sc.endereco_destinatario_id) or (sc.endereco_destinatario_id is null and deste.endereco_padrao = 1))               
             left join kss.v$pessoa_estrangeira pesd
               on pesd.cod_pessoa = dest.cod_pessoa
             left join cep.municipio destm
               on destm.municipio_id = deste.municipio_id
             left join cep.municipio ent
               on ent.municipio_id = sc.destino_municipio_id
             left join kss.v$pessoa neg
               on neg.cod_pessoa = o.cod_negociador
             left join kss.v$pessoa_endereco_padrao neg_end
               on neg_end.cod_pessoa = o.cod_negociador
             left join kss.v$pessoa cons
               on cons.cod_pessoa = sc.cod_consignatario               
             left join kss.v$pessoa_endereco_todos cons_end
               on cons_end.cod_pessoa = sc.cod_consignatario
              and ((cons_end.cod_endereco = sc.endereco_coleta_id) or (sc.endereco_coleta_id is null and cons_end.endereco_padrao = 1))
             left join kss.v$pessoa red
               on red.cod_pessoa = sc.cod_redespacho
             left join kss.v$pessoa_endereco_todos red_end
               on red_end.cod_pessoa = sc.cod_redespacho
              and ((red_end.cod_endereco = sc.endereco_entrega_id) or (sc.endereco_entrega_id is null and red_end.endereco_padrao = 1))               
            where ccv.situacao_id <> 0
			  and not exists (select 1
			         			from logistica.v$solicitacao_carga_documento d
							   inner join fiscal.v$conhecimento c
         						  on c.conhecimento_id = d.conhecimento_id
							   where d.solicitacao_carga_id = sc.solicitacao_carga_id
                                 and c.modal = 1)
           <cfif Len(Trim(arguments.OPERACAO_ID)) and not Len(Trim(arguments.CARGA_CONSOLIDADA_ID))>
              and o.operacao_id = #arguments.OPERACAO_ID#
           </cfif>
           <cfif Len(Trim(arguments.CARGA_CONSOLIDADA_ID))>
              and ccc.carga_consolidada_id = #arguments.CARGA_CONSOLIDADA_ID#
           </cfif>
           <cfif Len(Trim(arguments.num_romaneio))>
              and v.num_romaneio = #arguments.num_romaneio#
           </cfif>
		   <cfif Len(Trim(arguments.SOLICITACAO_CARGA_ID))>
              and sc.solicitacao_carga_id = #arguments.SOLICITACAO_CARGA_ID#
           </cfif>		   
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

    <!--- 
	-- PROPÓSITO 
	-- Busca dados do item do romaneio, porém da estrutura fracionada
	-- NOTAS EXPLICATIVAS
	-- RICARDO LAURINDO 22/02/2017
	--->
	<cffunction name="get_romaneio_item_fracionado" displayname="Busca o item do romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes" />
		<cfargument name="item_id" required="no" default="" />
		<cfargument name="frete_proprio" displayname="FLAG que indica se a consulta é por frete propio" required="no" default="" />
        <cfargument name="tipo_documento" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
             select distinct
                   ri.num_romaneio,
                   ri.item_id, o.operacao_id, ri.viagem_carga_id,
                   ri.num_lote, 
                   ri.volume,
                   ri.m3,
                   ri.valor_frete,
                   fiscal.pkg_conhecimento.fnc_produto_frete(col.municipio_id, ent.municipio_id, o.frete_proprio) as num_produto,
                   
                   ri.cod_remetente,
                   rem.razao_social as remetente,
                   rem.cnpj_cpf as rem_cnpj_cpf,
                   col.municipio_id as rem_municipio_id,
                   col.uf_id as rem_uf,
                   per.logradouro || ',' || per.numero || ' - ' || per.complemento as rem_endereco,
                   per.logradouro as rem_logradouro,
                   per.numero as rem_endereco_num,
                   to_char(per.cep) as rem_cep,
                   per.bairro as rem_bairro,
                   initcap(col.municipio) as rem_municipio,
                   rem.inscricao_estadual as rem_inscr_estadual,
                   nvl( sc.cod_destinatario, ri.cod_destinatario) as cod_destinatario,
                   dest.razao_social as destinatario,
                   dest.cnpj_cpf as dest_cnpj_cpf,
                   d_end.logradouro || ', ' || d_end.numero || ' - ' || d_end.complemento as dest_endereco,
                   d_end.logradouro as dest_logradouro,
                   d_end.numero as dest_endereco_num,
                   d_end.uf as dest_uf,
                   to_char(d_end.cep) as dest_cep,
                   d_end.bairro as dest_bairro,
                   initcap(ent.municipio) as dest_municipio,
                   ent.municipio_id as dest_municipio_id,
                   dest.cod_atividade_fiscal as dest_atividade_fiscal,
                   dest.inscricao_estadual as dest_inscr_estadual,
                   
                   ri.observacao,
                   case
                     when sc.valor_em = 'PESO' then
                      ri.valor_frete / decode(fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade),0,1,fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade))
                     when sc.valor_em = 'LOTACAO' then
                      ri.valor_frete
                     else
                      ri.valor_frete /
                      decode(fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade),
                             0,
                             1,
                             fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade))
                   end frete_valor_unitario,
                   o.frete_por_conta,
                   sc.valor_em as frete_em, 
                   decode(o.frete_por_conta,0,rem.cod_atividade_fiscal,dest.cod_atividade_fiscal) as cod_atividade_fiscal, 
                   fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'Kg', sc.cod_unidade) as peso,
                   '' as rodape,
                   decode(dest.cod_pessoa, null, 0, 1) as lote_com_destinatario, 
                   o.frete_proprio,
                   o.regra_fiscal_id,
                   
                   nvl(sc.cod_consignatario,ri.cod_remetente) as cod_consignatario,
                
                   nvl(cons.razao_social,rem.razao_social) as cons_razao_social,
                   nvl(cons.cnpj_cpf,rem.cnpj_cpf) as cons_cnpj_cpf,
                   nvl(cons.inscricao_estadual,rem.inscricao_estadual) as cons_inscricao_estadual,
                   nvl(decode(sc.cod_consignatario,null,'',cons_end.logradouro || ',' || cons_end.numero)
                       ,per.logradouro || ',' || per.numero || ' - ' || per.complemento)  as cons_endereco,
                   nvl(cons_end.numero,per.numero) as cons_endereco_num,
                   nvl(cons_end.bairro,per.bairro) as cons_bairro,
                   nvl(cons_end.cep,to_char(per.cep)) as cons_cep,
                   nvl(cons_end.municipio,initcap(col.municipio)) as cons_municipio,
                   nvl(cons_end.uf,col.uf_id) as cons_uf,
                   nvl(cons_mun.municipio_id,col.municipio_id) as cons_municipio_id,
                   
                   nvl(sc.cod_redespacho,ri.cod_destinatario) as cod_redespacho,
                   nvl(red.razao_social,dest.razao_social) as redespacho,
                   nvl(red.cnpj_cpf,dest.cnpj_cpf) as red_cnpj_cpf,
                   nvl(red_end.logradouro,d_end.logradouro) as red_logradouro,
                   nvl(red_end.numero,d_end.numero) as red_endereco_num,
                   nvl(red_end.uf,d_end.uf) as red_uf,
                   nvl(to_char(red_end.cep),to_char(d_end.cep)) as red_cep,
                   nvl(red_end.bairro,d_end.bairro) as red_bairro,
                   nvl(initcap(red_mun.municipio),initcap(ent.municipio)) as red_municipio,
                   nvl(red_mun.municipio_id,ent.municipio_id) as red_municipio_id,
                   nvl(red.cod_atividade_fiscal,dest.cod_atividade_fiscal) as red_atividade_fiscal,
                   nvl(red.inscricao_estadual,dest.inscricao_estadual) as red_inscr_estadual,
                   
                   pcob.cod_pessoa as  cod_cliente_cobranca,
                   pcob.cnpj_cpf cob_cnpj_cpf,
                   pcob.razao_social cob_razao_social,
                   pcob.inscricao_estadual cob_inscricao_estadual,
                   pecob.logradouro as cob_endereco,
                   pecob.numero as cob_endereco_numero,
                   pecob.cep cob_cep,
                   cobm.municipio cob_municipio,
                   cobm.uf_id cob_uf,
                   pecob.municipio_id cob_municipio_id,
                   ro.abreviatura as rota_abreviatura,
                   
                   o.cod_negociador,
                   neg.cnpj_cpf as neg_cnpj_cpf,
                   neg.razao_social as neg_razao_social,
                   neg.inscricao_estadual as neg_inscricao_estadual,
                   neg_end.logradouro as neg_endereco,
                   neg_end.numero as neg_endereco_num,
                   neg_end.cep as neg_cep,
                   neg_end.municipio as neg_municipio,
                   neg_end.municipio_id as neg_municipio_id,
                   neg_end.bairro as neg_bairro,
                   neg_end.uf as neg_uf , o.descricao as operacao,
                   sc.origem_municipio_id, sc.destino_municipio_id,
                   v.viagem_id, 
                   sc.solicitacao_carga_id,
				   to_char(sc.data_carregamento_inicio, 'dd/mm/yyyy hh24:mi') as data_carregamento_inicio,
                   to_char(sc.data_entrega_fim, 'dd/mm/yyyy hh24:mi') as data_entrega_fim,
                   (select count(*)
                     from fiscal.v$conhecimento c
                    where c.num_romaneio = ri.num_romaneio
                      and c.item_id = ri.item_id
							 and c.solicitacao_carga_id = sc.solicitacao_carga_id) as possui_conhecimento,
				       ri.carga_consolidada_id
              from oper.v$romaneio_item ri
             inner join logistica.v$carga_consolidada_carga ccc
				    on ccc.carga_consolidada_id = ri.carga_consolidada_id
					and ccc.situacao_id <> 0
				 inner join logistica.v$carga_consolidada_viagem ccv
				    on ccv.carga_consolidada_id = ccc.carga_consolidada_id
				   and ccv.situacao_id <> 0
				 inner join logistica.v$viagem v
				    on v.viagem_id = ccv.viagem_id
             inner join logistica.v$solicitacao_carga sc
                on sc.solicitacao_carga_id = ccc.solicitacao_carga_id
              left join kss.v$pessoa rem 
                on rem.cod_pessoa = sc.cod_remetente
              left join kss.v$pessoa_endereco_todos per
                on per.cod_pessoa = sc.cod_remetente
               and ((per.cod_endereco = sc.endereco_remetente_id) or (sc.endereco_remetente_id is null and per.endereco_padrao = 1))                     
              left join cep.municipio col 
                on ri.rem_municipio_id = col.municipio_id
             inner join logistica.v$operacao o 
                on ri.operacao_id = o.operacao_id
              left join(oper.v$romaneio_itinerario iti
                        inner join oper.v$rota ro 
                           on ro.rota_id = iti.rota_id) 
                on iti.itinerario_id = ri.itinerario_id
              left join kss.v$pessoa dest 
                on nvl(sc.cod_destinatario,  ri.cod_destinatario) = dest.cod_pessoa
              left join kss.v$pessoa_endereco_todos d_end
                on d_end.cod_pessoa = sc.cod_destinatario
               and ((d_end.cod_endereco = sc.endereco_destinatario_id) or (sc.endereco_destinatario_id is null and d_end.endereco_padrao = 1))
              left join kss.v$pessoa_endereco_todos pecob
                on pecob.cod_pessoa = sc.cod_cobranca
               and ((pecob.cod_endereco = sc.endereco_cobranca_id) or (sc.endereco_cobranca_id is null and pecob.endereco_padrao = 1))
              left join kss.v$pessoa pcob
                on pcob.cod_pessoa = sc.cod_cobranca
              left join cep.municipio cobm 
                on cobm.municipio_id = pecob.municipio_id
              left join cep.municipio ent 
                on d_end.municipio_id = ent.municipio_id
              left join kss.v$pessoa red 
                on sc.cod_redespacho = red.cod_pessoa
              left join kss.v$pessoa_endereco_todos red_end
                on red_end.cod_pessoa = sc.cod_redespacho
               and ((red_end.cod_endereco = sc.endereco_entrega_id) or (sc.endereco_entrega_id is null and red_end.endereco_padrao = 1))
              left join cep.municipio red_mun
                on red_end.municipio_id = red_mun.municipio_id
              left join kss.v$pessoa neg 
                on neg.cod_pessoa = o.cod_negociador
              left join kss.v$pessoa_endereco_padrao neg_end 
                on neg_end.cod_pessoa = o.cod_negociador
              left join kss.v$pessoa cons 
                on cons.cod_pessoa = sc.cod_consignatario
              left join kss.v$pessoa_endereco_todos cons_end
                on cons_end.cod_pessoa = sc.cod_consignatario
               and ((cons_end.cod_endereco = sc.endereco_coleta_id) or (sc.endereco_coleta_id is null and cons_end.endereco_padrao = 1))                     
              left join cep.municipio cons_mun
                on cons_end.municipio_id = cons_mun.municipio_id
             where ri.num_romaneio = #arguments.num_romaneio# 
			 <cfif Len(Trim(arguments.item_id))>
			      and ri.item_id = #arguments.item_id#
			 </cfif>
             <cfif Len(Trim(arguments.tipo_documento))>
			      and o.tipo_documento = #arguments.tipo_documento#
			 </cfif>
 			 <cfif Len(Trim(arguments.frete_proprio))>
   			   and o.frete_proprio = #arguments.frete_proprio#
			 </cfif> 
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

   <!--- 
	-- PROPÓSITO 
	-- Define se um romaneio é fracionado
	-- NOTAS EXPLICATIVAS
	-- RICARDOC 22/02/2017
	--->
	<cffunction name="get_romaneio_fracionado" access="remote" returntype="query" output="true">
   		<cfargument name="solicitacao_carga_id" displayname="solicitacao_carga_id" required="no"/>
   		<cfargument name="num_romaneio" displayname="num_romaneio" required="no"/>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select sign(count(*)) as fracionado
				  from logistica.v$carga_consolidada_carga ccc
				  left join logistica.v$carga_consolidada_viagem ccv
				    on ccv.carga_consolidada_id = ccc.carga_consolidada_id
				   and ccv.situacao_id <> 0
				  left join logistica.v$viagem v
				    on v.viagem_id = ccv.viagem_id
				 where ccc.situacao_id <> 0
				<cfif Len(Trim(arguments.solicitacao_carga_id))>
				   and ccc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
				</cfif>			 					                      
				<cfif Len(Trim(arguments.num_romaneio))>
				   and v.num_romaneio = #arguments.num_romaneio#
				</cfif>			 					                      			 
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>


   <!--- 
	-- PROPÓSITO 
	-- Busca cartão vpr do motorista
	-- NOTAS EXPLICATIVAS
	-- RICARDOC 24/08/2015
	--->
	<cffunction name="verifica_vpr" access="remote" returntype="query" output="true">
   		<cfargument name="cod_pessoa_operadora" displayname="Código da operadora" required="yes"/>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select o.vale_pedagio_operadora_id as cod_operadora
                 , decode(o.identificador, 'REPOM', 1, 0) as result
              from oper.v$vale_pedagio_operadora o
             where o.cod_pessoa = #arguments.cod_pessoa_operadora#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

   <!--- 
	-- PROPÓSITO 
	-- Busca cartão vpr do motorista
	-- NOTAS EXPLICATIVAS
	-- RICARDOC 24/08/2015
	--->
	<cffunction name="get_cartao_vpr" access="remote" returntype="query" output="true">
   		<cfargument name="cod_motorista" required="yes"/>
   		<cfargument name="cod_operadora" required="yes"/>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select mc.num_cartao as num_cartao
              from pagfrete.v$motorista_cartao mc
             where mc.data_fim is null -- Cartão vigente
               and mc.cartao_tipo_vale_pedagio = 1 -- Seja de VP
               and mc.cartao_operadora_vale_pedagio = #arguments.cod_operadora# -- Seja REPOM
               and mc.cod_pessoa_motorista = #arguments.cod_motorista#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPÓSITO
	-- Busca o Tipo de Conhecimento
	-- NOTAS EXPLICATIVAS
	-- WAGNERS 30/03/2011
	--->
    <cffunction name="get_conhecimento_tipo" displayname="Busca o Tipo de Conhecimento" access="remote" returntype="query" output="false">
		<cfargument name="conhecimento_tipo_id" displayname="Identificador do tipo de conhecimento" required="no"/>
        <cfargument name="descricao" displayname="Descrição do tipo de conhecimento" required="no"/>
        <cfargument name="lista_valores" displayname="Lista de Identificadores do tipo de conhecimento" required="no"/>
        <cfargument name="cadastro" displayname="Lista os Tipos que são permitidos para cadastro de CTe emitido anteiriormente" required="no" default="0"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select conhecimento_tipo_id,
                   descricao,
                   tipo_servico_id,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from fiscal.v$conhecimento_tipo ct
             where 1=1
             <cfif isDefined("arguments.conhecimento_tipo_id") and len(trim(arguments.conhecimento_tipo_id)) >
             	and ct.conhecimento_tipo_id = #arguments.conhecimento_tipo_id#
             </cfif>
             <cfif isDefined("arguments.lista_valores") and len(trim(arguments.lista_valores)) >
             	and ct.conhecimento_tipo_id in (#arguments.lista_valores#)
             </cfif>
             <cfif isDefined("arguments.cadastro") and arguments.cadastro eq 0 >
             	and ct.conhecimento_tipo_id <> kss.pkg_global.fnc_obtem_parametro_str(25 , 'FISCAL.EXE', 40, 9)
             <cfelse>
                and ct.conhecimento_tipo_id = kss.pkg_global.fnc_obtem_parametro_str(25 , 'FISCAL.EXE', 40, 9)
             </cfif>
             <cfif isDefined("arguments.descricao") and len(trim(arguments.descricao)) >
             	and upper(ct.descricao) like upper('%#arguments.descricao#%')
             </cfif>

             order by descricao
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca Organograma completo
	-- GUTO  20/12/2006
	--->
	<cffunction name="get_organograma" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select o.cod_organograma, o.cod_unidade_negocio,
				   p.cliente as filial, o.cod_pessoa,
				   d.descricao as departamento, o.cod_departamento,
				   s.descricao as setor, o.cod_setor,
				   cc.centro_custo, o.cod_centro_custo
			  from kss.v$organograma o
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = o.cod_pessoa
			 inner join kss.v$departamento d
					 on d.cod_departamento = o.cod_departamento
			 inner join kss.v$setor s
					 on s.cod_setor = o.cod_setor
			 inner join kss.v$centro_custo cc
					 on cc.cod_centro_custo = o.cod_centro_custo
             where 1=1
			 <cfif Len(Trim(arguments.cod_pessoa))>
			   and o.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_centro_custo))>
			   and o.cod_centro_custo = '#arguments.cod_centro_custo#'
			 </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca Séries
	-- NOTAS EXPLICATIVAS
	-- GUTO 24/02/2006
	--->
	<cffunction name="get_serie" displayname="Busca Séries" access="remote" returntype="query" output="false">
	    <cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_pessoa" hint="Usado para algumas telas que usam o COD_PESSOA como o código pessoa da filial" required="no" default=""/>
	    <cfargument name="cod_departamento" required="no">
	    <cfargument name="cod_setor" required="no">
	    <cfargument name="cod_centro_custo" required="no">
		<cfargument name="cod_modelo" required="no" default="">
	    <cfargument name="organograma" required="no" default="">
		<cfargument name="todas" required="no">
		<cfif Len(Trim(arguments.cod_pessoa)) and not Len(Trim(arguments.cod_pessoa_filial))>
			<cfset arguments.cod_pessoa_filial = arguments.cod_pessoa>
		</cfif>
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>
		<cfif not isDefined("arguments.todas")>
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
				 <cfif Len(Trim(arguments.cod_pessoa_filial))>
					select ags.serie, ags.cod_modelo , (select f.formulario_id
                                                          from kss.v$formulario f
                                                         where f.formulario_id = ags.formulario_id) as formulario
					  from fiscal.v$modelo_serie ags
					 where ags.cod_pessoa       = #arguments.cod_pessoa_filial#
					   and ags.cod_departamento = #arguments.cod_departamento#
					   and ags.cod_setor        = #arguments.cod_setor#
                       and ags.cod_centro_custo = #arguments.cod_centro_custo#
					   and ags.ativo 			= 1
					   <cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
                       		<cfif arguments.cod_modelo eq "'08'">
                            	and ags.documento_proprio = 1
                            </cfif>
					   		and ags.cod_modelo in(#PreserveSingleQuotes(arguments.cod_modelo)#)
					   </cfif>
					  order by ags.cod_pessoa, ags.cod_departamento, ags.cod_setor
				 <cfelse>
					select distinct ags.serie
					  from fiscal.v$modelo_serie ags
					 inner join kss.v$kss_usuario_lotacao ul
						on ags.cod_pessoa = ul.cod_pessoa
					   and ags.cod_departamento = ul.cod_departamento
					   and ags.cod_setor = ul.cod_setor
					  where ags.ativo 	 = 1
                        and ul.usuario = user
					  	<cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					   		and ags.cod_modelo = '#arguments.cod_modelo#'
					   </cfif>
					  order by ags.serie
				 </cfif>
			</cfquery>
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
				select distinct serie
				from fiscal.v$modelo_serie ags
				where ativo 	 = 1
				<cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					and ags.cod_modelo in (#ListQualify(arguments.cod_modelo,"'",",")#)
				</cfif>
  			</cfquery>
	    </cfif>
		<cfreturn qr_serie>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca natureza
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 19/07/2009 - MODIFICADO
	--->
	<cffunction name="get_natureza" displayname="Busca Natureza" access="remote" returntype="query" output="false">
		<cfargument name="num_natureza" required="no" default="">
		<cfargument name="descricao" required="no" default="">		
		<cfargument name="TIPO" required="no" default="">
        <cfargument name="order_by" required="no" default="0" hint="0-Descrição Resumida, Descrição; 1-Descrição">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select n.num_natureza, n.descricao, n.grupo_natureza_id, gn.descricao_resumida grupo, gn.descricao as descricao_grupo, n.peso_especifico, n.cod_ncm
              from oper.v$natureza n
             inner join oper.v$grupo_natureza gn
                     on gn.grupo_natureza_id = n.grupo_natureza_id
             where 1=1
			<cfif Len(Trim(arguments.num_natureza))>
			   and n.num_natureza = #arguments.num_natureza#
			</cfif>
			<cfif arguments.TIPO eq 1>
				<cfif Len(Trim(arguments.descricao))>
					and upper(n.descricao) like upper('%#arguments.descricao#%')
				</cfif>
			<cfelse>
				and upper( kss.pkg_string.fnc_char_clean(n.cod_ncm)) like upper('%'|| kss.pkg_string.fnc_char_clean('#arguments.descricao#')||'%')
			</cfif>
            <cfif arguments.order_by eq 0>
			 order by gn.descricao_resumida, n.descricao
            <cfelseif arguments.order_by eq 1>
             order by n.descricao
            </cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
    
    <!--- 
	-- PROPÓSITO 
	-- Busca espécie
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_especie" displayname="Busca Espécie" access="remote" returntype="query" output="false">
		<cfargument name="num_especie" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select  e.num_especie, e.descricao
			  from oper.v$especie e
			 where 1=1
			 <cfif len(trim(arguments.num_especie))>
			   and num_especie = #arguments.num_especie#
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(e.descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by e.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca unidades de medida
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 20/04/2009
	--->
	<cffunction name="get_unidade" displayname="Busca unidades de medida" access="remote" returntype="query" output="false">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select u.cod_unidade
            	 , u.unidade
                 , u.cod_grupo_umedida
                 , u.valor_em
                 , nvl((select uc.equivalencia
                      from fiscal.v$unidade_medida_conversao uc
                     where uc.cod_unidade = u.cod_unidade
                       and uc.cod_unidade_eq = 'Kg'),1) as equivalencia_kg
			  from fiscal.v$unidade_medida u
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPÓSITO 
    -- Retorna as situações tributárias
    -- ANDERSON 26/08/2010 - CRIADO
    --->
    <cffunction name="get_situacao_tributaria" access="remote" returntype="query" output="true">
    	<cfargument name="st_icms_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.st_icms_id
                 , t.st_icms_descricao
              from fiscal.v$st_icms t
             where 1 = 1
			<cfif Len(Trim(arguments.st_icms_id))>
               and t.st_icms_id in (#PreserveSingleQuotes(arguments.st_icms_id)#)
			</cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca as filiais cadastradas
	-- CRISTOFER  18/12/2006
	--->
	<cffunction name="get_filial" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct t.cod_pessoa, p.cliente filial, p.cliente as nome
			  from kss.v$organograma t
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = t.cod_pessoa
	         order by p.cliente
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca as notas fiscais do conhecimento
	-- CRISTOFER  06/12/2006
	--->
	<cffunction name="get_conhecimento_nota_fiscal" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
        <cfargument name="xml" required="no" default="0">
		<cfargument name="complemento" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfquery name="qr_pram" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  select kss.pkg_parametro.fnc_valor_lista('M309-P0212') as valor
                from dual 
			</cfquery>
			<cfif arguments.complemento eq 0 or qr_pram.valor neq 'Sim'>
			select cnf.conhecimento_id,
				   cnf.numero,
				   cnf.data_emissao,
				   to_char(cnf.data_emissao,'dd/mm/yyyy') data_emissao_data,
				   cnf.modelo,
				   cnf.serie,
				   cnf.sub_serie,
				   cnf.valor_total,
				   cnf.user_insert,
				   cnf.date_insert,
				   cnf.user_update,
				   cnf.date_update,
				   cnf.site,
				   cnf.valor_segurado,
				   cnf.ordem_compra_cliente,
				   cnf.peso,
				   to_char(fiscal.pkg_fiscal.fnc_converte_peso(cnf.peso,cnf.cod_unidade,'Kg')) peso_kg_convertido,
				   cnf.peso_cubado,
				   cnf.peso_cobrado,
				   nvl(cnf.qtde_volume,1) as qtde_volume,
				   cnf.altura,
				   cnf.comprimento,
				   cnf.largura,
				   cnf.m3,
				   cnf.cubagem,
                   cnf.altura * cnf.comprimento * cnf.largura * nvl(cnf.qtde_volume,1) * (select kss.pkg_parametro.fnc_valor_numerico('M204-P0173') from dual) as cubagem_sugerida,
				   cnf.num_natureza,
				   nat.descricao natureza,
				   cnf.complemento,
				   cnf.num_especie,
				   esp.descricao especie,
				   cnf.cod_unidade,
				   cnf.premio_seguro_rctrc,
				   cnf.premio_seguro_rcfdc,
				   cnf.premio_seguro_rr,
                   (select cc.carga_id
                      from oper.v$carga_ctrc cc
                     where cc.conhecimento_id = cnf.conhecimento_id
                       and cc.num_nota_id = cnf.numero) as carga_id ,
                   cnf.cfop,
                   cnf.chave_acesso_nfe,
                   cnf.tipo_documento_id,
                   cnf.descricao_docto,
                   kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/emit/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
                                                          ,extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/emit/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_emitente,
                   extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/emit/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as emitente,
                   kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/dest/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
                                                          ,extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/dest/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_destinatario,
                   extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/dest/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as destinatario

                   <cfif arguments.xml eq 1>
                   , cnf.nfe_xml
                   </cfif>
                   ,cnf.valor_segurado
                   ,cnf.icms_partilhado
			  from fiscal.v$conhecimento_nota_fiscal cnf
			  left join oper.v$especie esp
					 on esp.num_especie = cnf.num_especie
			  left join oper.v$natureza nat
					 on nat.num_natureza = cnf.num_natureza
			 where 1=1
			   and cnf.conhecimento_id = #arguments.conhecimento_id#
          union all
         select #arguments.conhecimento_id# as conhecimento_id
               , cnf.numero
               , cnf.data_emissao
               , to_char(cnf.data_emissao,'dd/mm/yyyy') data_emissao_data
               , cnf.modelo
               , cnf.serie
               , cnf.sub_serie
               , cnf.valor_total
               , cnf.user_insert
               , cnf.date_insert
               , cnf.user_update
               , cnf.date_update
               , cnf.site
               , cnf.valor_segurado
               , cnf.ordem_compra_cliente
               , cnf.peso
               , to_char(fiscal.pkg_fiscal.fnc_converte_peso(cnf.peso,cnf.cod_unidade,'Kg')) peso_kg_convertido
               , cnf.peso_cubado
               , cnf.peso_cobrado
               , nvl(cnf.qtde_volume,1) as qtde_volume
               , cnf.altura
               , cnf.comprimento
               , cnf.largura
               , cnf.m3
               , cnf.cubagem
               , cnf.altura * cnf.comprimento * cnf.largura * nvl(cnf.qtde_volume,1) * (select kss.pkg_parametro.fnc_valor_numerico('M204-P0173') from dual) as cubagem_sugerida
               , cnf.num_natureza
               , nat.descricao natureza
               , cnf.complemento
               , cnf.num_especie
               , esp.descricao especie
               , cnf.cod_unidade
               , null as premio_seguro_rctrc
               , null as premio_seguro_rcfdc
               , null as premio_seguro_rr
               , (select cc.carga_id
                     from oper.v$carga_ctrc cc
                     where cc.conhecimento_id = #arguments.conhecimento_id#
                     and cc.num_nota_id = cnf.numero) as carga_id
               , cnf.cfop
               , cnf.chave_acesso_nfe
               , cnf.tipo_documento_id
               , cnf.descricao_docto
               , kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/emit/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
                                                         ,extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/emit/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_emitente
               , extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/emit/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as emitente
               , kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/dest/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
                                                         ,extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/dest/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_destinatario
               , extractvalue(xmltype.createxml(substr(cnf.nfe_xml, instr( cnf.nfe_xml, '<'), length(cnf.nfe_xml) - instr( cnf.nfe_xml, '<') + 1 )),'//NFe/infNFe/dest/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as destinatario
               <cfif arguments.xml eq 1>
               , cnf.nfe_xml
               </cfif>
               , cnf.valor_segurado
               , null as icms_partilhado
            from logistica.v$solicitacao_carga_nf cnf
            inner join fiscal.v$conhecimento c
               on c.solicitacao_carga_id = cnf.solicitacao_carga_id
              and cnf.tipo_documento_id = 3
             left join oper.v$especie esp
               on esp.num_especie = cnf.num_especie
             left join oper.v$natureza nat
               on nat.num_natureza = cnf.num_natureza
            where c.conhecimento_id = #arguments.conhecimento_id#
		   </cfif>
		   <cfif arguments.complemento eq 1 and qr_pram.valor eq 'Sim'>
			   select notas.conhecimento_id
					, '999999' as numero
					, min(notas.data_emissao) as data_emissao
					, min(notas.data_emissao_data) as data_emissao_data
					, 55 as modelo
					, min(notas.serie)  as serie
					, min(notas.sub_serie)  as sub_serie
					, sum(notas.valor_total) as valor_total
					, null as user_insert
					, null as date_insert
					, null as user_update
					, null as date_update
					, null as site
					, sum(notas.valor_segurado) as valor_segurado
					, null as ordem_compra_cliente
					, sum(notas.peso) as peso
					, sum(notas.peso_kg_convertido) as peso_kg_convertido
					, sum(notas.peso_cubado) as peso_cubado
					, sum(notas.peso_cobrado) as peso_cobrado
					, sum(notas.qtde_volume) as qtde_volume
					, sum(notas.altura) as altura
					, sum(notas.comprimento) as comprimento
					, sum(notas.largura) as largura
					, sum(notas.m3) as m3
					, sum(notas.cubagem) as cubagem
					, sum(notas.cubagem_sugerida) as cubagem_sugerida
					, min(notas.num_natureza) as num_natureza
					, min(notas.natureza) as natureza
					, null as complemento
					, min(notas.num_especie) as num_especie
					, min(notas.especie) as especie
					, min(notas.cod_unidade) as cod_unidade
					, sum(notas.premio_seguro_rctrc) as premio_seguro_rctrc
					, sum(notas.premio_seguro_rcfdc) as premio_seguro_rcfdc
					, sum(notas.premio_seguro_rr) as premio_seguro_rr
					, min(notas.carga_id) as carga_id
					, min(notas.cfop) as cfop
					, min(notas.chave_acesso_nfe) as chave_acesso_nfe
					, min(notas.tipo_documento_id) as tipo_documento_id
					, min(notas.descricao_docto) as descricao_docto
					, min(notas.cnpj_emitente) as cnpj_emitente
					, min(notas.emitente) as emitente
					, min(notas.cnpj_destinatario) as cnpj_destinatario
					, min(notas.destinatario) as destinatario
					, null as nfe_xml
					, min(notas.icms_partilhado) as icms_partilhado
				 from (select cnf.conhecimento_id
				            , cnf.numero
							, cnf.data_emissao
							, to_char(cnf.data_emissao,'dd/mm/yyyy') data_emissao_data
							, cnf.modelo
							, cnf.serie
							, cnf.sub_serie
							, cnf.valor_total
							, cnf.user_insert
							, cnf.date_insert
							, cnf.user_update
							, cnf.date_update
							, cnf.site
							, cnf.valor_segurado
							, cnf.ordem_compra_cliente
							, cnf.peso
							, to_char(fiscal.pkg_fiscal.fnc_converte_peso(cnf.peso,cnf.cod_unidade,'Kg')) peso_kg_convertido
							, cnf.peso_cubado
							, cnf.peso_cobrado
							, nvl(cnf.qtde_volume,1) as qtde_volume
							, cnf.altura
							, cnf.comprimento
							, cnf.largura
							, cnf.m3
							, cnf.cubagem
							, cnf.altura * cnf.comprimento * cnf.largura * nvl(cnf.qtde_volume,1) * (select kss.pkg_parametro.fnc_valor_numerico('M204-P0173') from dual) as cubagem_sugerida
							, cnf.num_natureza
							, nat.descricao natureza
							, cnf.complemento
							, cnf.num_especie
							, esp.descricao especie
							, cnf.cod_unidade
							, cnf.premio_seguro_rctrc
							, cnf.premio_seguro_rcfdc
							, cnf.premio_seguro_rr
							, (select cc.carga_id
								 from oper.v$carga_ctrc cc
								where cc.conhecimento_id = cnf.conhecimento_id
								  and cc.num_nota_id = cnf.numero) as carga_id
							, cnf.cfop
							, cnf.chave_acesso_nfe
							, cnf.tipo_documento_id
							, cnf.descricao_docto
							, kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/emit/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
										                             ,extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/emit/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_emitente
							, extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/emit/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as emitente
							, kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/dest/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
							                                         ,extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/dest/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_destinatario
				            , extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/dest/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as destinatario
							, cnf.icms_partilhado
						 from fiscal.v$conhecimento_nota_fiscal cnf
						 left join oper.v$especie esp
						   on esp.num_especie = cnf.num_especie
						 left join oper.v$natureza nat
						   on nat.num_natureza = cnf.num_natureza
						where 1=1
						  and cnf.conhecimento_id = #arguments.conhecimento_id#
					  ) notas
					group by notas.conhecimento_id
		   </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca os dados da operação para a emissao de conhecimentos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 13/12/2006
	--->
	<cffunction name="get_operacao_ctrc" access="remote" returntype="query" output="true">
		<cfargument name="operacao_id" required="no" default="">
		<cfargument name="viagem_carga_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select o.operacao_id
                , o.pedido_shipment
				, o.pedido_shipment_edicao
                , vc.viagem_carga_id
                , o.regra_fiscal_id
                , o.descricao as operacao
                , logistica.pkg_operacao.fnc_descricao_completa(o.operacao_id) as operacao_descricao
                , sc.valor_em as frete_em
                , o.frete_por_conta
                , rem.cod_atividade_fiscal
                , fiscal.pkg_conhecimento.fnc_produto_frete(nvl(remm.municipio_id,pes.municipio_id),nvl(destm.municipio_id,pesd.municipio_id),o.frete_proprio) as num_produto

                , rem.cod_pessoa cod_remetente
                , rem.tipo_pessoa as rem_tipo_pessoa
                , rem.cnpj_cpf rem_cnpj_cpf
                , nvl(rem.razao_social,rem.cliente) rem_razao_social
                , nvl(rem.inscricao_estadual, decode(rem.tipo_pessoa, 1, 'ISENTO', null)) as rem_inscricao_estadual
                , reme.logradouro as rem_logradouro
                , reme.numero as rem_numero
                , reme.bairro as rem_bairro
                , reme.logradouro||decode(reme.numero,'','',',')||reme.numero||' '||reme.complemento||' - '||reme.bairro rem_endereco
                , to_char(reme.cep) rem_cep
                , nvl(remm.municipio,pes.municipio) rem_municipio
                , remm.uf_id rem_uf
                , nvl(remm.municipio_id,pes.municipio_id) rem_municipio_id

                , dest.cod_pessoa cod_destinatario
                , dest.tipo_pessoa as dest_tipo_pessoa
                , dest.cnpj_cpf dest_cnpj_cpf
                , nvl(dest.razao_social,dest.cliente) dest_razao_social
                , nvl(dest.inscricao_estadual, decode(dest.tipo_pessoa, 1, 'ISENTO', null)) as dest_inscricao_estadual
                , trim(decode(dest.cod_pessoa,null,'',deste.logradouro||decode(deste.numero,'','',',')|| deste.numero||' '||deste.complemento|| decode(deste.bairro,'','',' - ')||deste.bairro)) dest_endereco
                , to_char(deste.cep) dest_cep
                , deste.logradouro||decode(deste.numero,'','',',')||deste.numero||' '||deste.complemento||' - '||deste.bairro dest_endereco
                , deste.logradouro as dest_logradouro
                , deste.numero as dest_numero
                , deste.bairro as dest_bairro
                , nvl(destm.municipio,pesd.municipio) dest_municipio
                , destm.uf_id dest_uf
                , nvl(destm.municipio_id,pesd.municipio_id) dest_municipio_id

                , decode(sc.cod_consignatario, null , 1 , 0) as permite_editar_consignatario
                , nvl(sc.cod_consignatario,rem.cod_pessoa) cod_consignatario
                , nvl(cons.tipo_pessoa,rem.tipo_pessoa) as cons_tipo_pessoa
                , nvl(cons.cnpj_cpf,rem.cnpj_cpf) as cons_cnpj_cpf
                , nvl(cons.razao_social,nvl(rem.razao_social,rem.cliente)) cons_razao_social
                , nvl(nvl(cons.inscricao_estadual,rem.inscricao_estadual), decode(nvl(cons.tipo_pessoa,rem.tipo_pessoa), 1, 'ISENTO', null)) cons_inscricao_estadual
                , nvl(cons_end.logradouro,reme.logradouro) as cons_logradouro
                , nvl(cons_end.numero,reme.numero) as cons_endereco_num
                , nvl(cons_end.bairro,reme.bairro) as cons_bairro
                , decode(sc.cod_consignatario,null,reme.logradouro||decode(reme.numero,'','',',')||reme.numero||' '||reme.complemento||' - '||reme.bairro
                , cons_end.logradouro||decode(cons_end.numero,'','',',')||cons_end.numero||' '||cons_end.complemento||' - '||cons_end.bairro) as cons_endereco
                , nvl(to_char(cons_end.cep),to_char(reme.cep)) cons_cep
                , nvl(cons_end.municipio,nvl(remm.municipio,pes.municipio)) cons_municipio
                , nvl(cons_end.uf,remm.uf_id) as cons_uf
                , nvl(cons_end.municipio_id,nvl(remm.municipio_id,pes.municipio_id)) cons_municipio_id

                , reme.cep as coleta_cep
                , reme.logradouro as coleta_logradouro
                , reme.complemento as coleta_complemento
                , reme.bairro as coleta_bairro
                , col.municipio coleta_municipio
                , reme.uf coleta_uf
                , sc.origem_municipio_id as coleta_municipio_id

                , deste.cep as entrega_cep
                , deste.logradouro as entrega_logradouro
                , deste.complemento entrega_complemento
                , deste.bairro entrega_bairro
                , ent.municipio entrega_municipio
                , ent.uf_id entrega_uf
                , sc.destino_municipio_id as entrega_municipio_id

                , decode(sc.cod_redespacho, null , 1 , 0) as permite_editar_redespacho
                , nvl(red.cod_pessoa, dest.cod_pessoa) as cod_redespacho
                , nvl(red.tipo_pessoa, dest.tipo_pessoa) as redespacho_tipo_pessoa
                , nvl(red.cnpj_cpf, dest.cnpj_cpf) as redespacho_cnpj_cpf
                , nvl(red.razao_social, nvl(dest.razao_social,dest.cliente)) as redespacho_razao_social
                , nvl(nvl(red.inscricao_estadual, dest.inscricao_estadual), decode(nvl(red.tipo_pessoa,dest.tipo_pessoa), 1, 'ISENTO', null)) as redespacho_inscricao_estadual
                , trim(decode(red.cod_pessoa,null,deste.logradouro||decode(deste.numero,'','',',')|| deste.numero||' '||deste.complemento|| decode(deste.bairro,'','',' - ')||deste.bairro, red_end.logradouro||decode(red_end.numero,'','',',')|| red_end.numero||' '||red_end.complemento|| decode(red_end.bairro,'','',' - ')||red_end.bairro)) red_endereco
                , to_char(nvl(red_end.cep, deste.cep)) redespacho_cep
                , nvl(red_end.logradouro, deste.logradouro) as redespacho_logradouro
                , deste.logradouro as dest_logradouro
                , nvl(red_end.numero, deste.numero) as redespacho_numero
                , nvl(red_end.bairro, deste.bairro) as redespacho_bairro
                , nvl(red_end.municipio,  nvl(destm.municipio,pesd.municipio)) redespacho_municipio
                , nvl(red_end.uf, destm.uf_id) as redespacho_uf
                , nvl(red_end.municipio_id, nvl(destm.municipio_id,pesd.municipio_id)) as redespacho_municipio_id

                , cob.cod_pessoa cod_cliente_cobranca
                , cob.tipo_pessoa cob_tipo_pessoa
                , cob.cnpj_cpf cob_cnpj_cpf
                , cob.razao_social cob_razao_social
                , nvl(cob.inscricao_estadual, decode(cob.tipo_pessoa, 1, 'ISENTO', null)) as cob_inscricao_estadual
                , ecob.logradouro as cob_endereco
                , ecob.cep cob_cep
                , cobm.municipio cob_municipio
                , cobm.uf_id cob_uf
                , ecob.municipio_id cob_municipio_id
                , o.cod_negociador
                , neg.tipo_pessoa as neg_tipo_pessoa
                , neg.cnpj_cpf as neg_cnpj_cpf
                , neg.razao_social as neg_razao_social
                , nvl(neg.inscricao_estadual, decode(neg.tipo_pessoa, 1, 'ISENTO', null)) as neg_inscricao_estadual
                , neg_end.logradouro || ' ' || neg_end.numero as neg_endereco
                , to_char(neg_end.cep) as neg_cep
                , neg_end.municipio as neg_municipio
                , neg_end.uf as neg_uf
                , sc.num_natureza
                , (select opn.num_natureza
                     from logistica.v$operacao_natureza opn
                    where opn.operacao_id = o.operacao_id
                      and opn.num_natureza = sc.num_natureza) num_natureza_operacao
                , sc.num_especie
                , sc.cod_unidade
                , o.fracionado
                , o.internacional
                , o.frete_proprio
                , o.dedicado
                , logistica.pkg_agendamento.fnc_viagem_composicao_definida(vc.viagem_id,' > ', 1) as composicao
                , logistica.pkg_agendamento.fnc_viagem_composicao_definida(vc.viagem_id,' > ') as composicao_frota
                , logistica.pkg_agendamento.fnc_viagem_motorista_definida(vc.viagem_id) as motorista
                , (select pm.cliente
                     from kss.v$pessoa pm
                    where pm.cod_pessoa = logistica.pkg_agendamento.fnc_viagem_motorista_definida(vc.viagem_id)) as motorista_nome
                , to_char(v.data_termino,'dd/mm/yyyy hh24:mi') as data_termino
                , (select count(*)
                     from fiscal.v$categoria_imp_retencao cir
                    inner join fiscal.v$produto pr
                       on pr.categoria_id = cir.categoria_id
                    where produto_id = fiscal.pkg_conhecimento.fnc_produto_frete(nvl(remm.municipio_id,
                                                                                     pes.municipio_id),
                                                                                 nvl(destm.municipio_id,
                                                                                     pesd.municipio_id),
                                                                                 o.frete_proprio)) as impostos
                 , to_char(sc.data_entrega_inicio, 'dd/mm/yyyy hh24:mi') as prazo_entrega
                 , o.tipo_frete
                 , o.tipo_servico_id
                 , o.tipo_docto_frete
                 , o.pagto_vale_pedagio
                 , o.operadora_vale_pedagio
                 , kss.pkg_pessoa.fnc_get_identificador(o.operadora_vale_pedagio, 0 ) as cnpj_operadora_vale_ped
                 , kss.pkg_pessoa.fnc_get_cliente(o.operadora_vale_pedagio) as nome_operadora_vale_ped
                 , o.fornecedora_vale_pedagio
                 , o.exige_xml_nfe
                 , o.operacao_vinculada_otm
                 , sc.pedido_shipment as pedido_shipment_solicitacao
                 , v.viagem_id
                 , rem.inscricao_estadual || ',' ||
                   nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                          from kss.v$pessoa_inscricao_estadual ie2
                         where ie2.cod_pessoa = reme.cod_pessoa),
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                          from kss.v$pessoa_endereco e
                         where e.cod_pessoa = rem.cod_pessoa
                           and rem.tipo_pessoa = 1
                           and e.inscricao_estadual <> rem.inscricao_estadual)) as rem_ie_adicional
                 , nvl(cons.inscricao_estadual, rem.inscricao_estadual)|| ',' ||
                   nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                          from kss.v$pessoa_inscricao_estadual ie2
                         where ie2.cod_pessoa = nvl(cons.cod_pessoa, rem.cod_pessoa)),
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                          from kss.v$pessoa_endereco e
                         where e.cod_pessoa = nvl(cons.cod_pessoa, rem.cod_pessoa)
                           and nvl(cons.tipo_pessoa,rem.tipo_pessoa) = 1
                           and e.inscricao_estadual <> nvl(cons.inscricao_estadual, rem.inscricao_estadual))) as coleta_ie_adicional
                 , dest.inscricao_estadual || ',' ||
                   nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                          from kss.v$pessoa_inscricao_estadual ie2
                         where ie2.cod_pessoa = dest.cod_pessoa),
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                          from kss.v$pessoa_endereco e
                         where e.cod_pessoa = dest.cod_pessoa
                           and dest.tipo_pessoa = 1
                           and e.inscricao_estadual <> dest.inscricao_estadual))  as dest_ie_adicional
                 , nvl(red.inscricao_estadual, dest.inscricao_estadual)|| ',' ||
                   nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual,','))
                          from kss.v$pessoa_inscricao_estadual ie2
                         where ie2.cod_pessoa = nvl(red.cod_pessoa, dest.cod_pessoa)),
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                          from kss.v$pessoa_endereco e
                         where e.cod_pessoa = nvl(red.cod_pessoa, dest.cod_pessoa)
                           and nvl(red.tipo_pessoa,dest.tipo_pessoa) = 1
                           and e.inscricao_estadual <> nvl(red.inscricao_estadual, dest.inscricao_estadual))) as entrega_ie_adicional
                 , cob.inscricao_estadual || ',' ||
                   nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                          from kss.v$pessoa_inscricao_estadual ie2
                         where ie2.cod_pessoa = cob.cod_pessoa),
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                          from kss.v$pessoa_endereco e
                         where e.cod_pessoa = cob.cod_pessoa
                           and cob.tipo_pessoa = 1
                           and e.inscricao_estadual <> cob.inscricao_estadual)) as cob_ie_adicional
                 , neg.inscricao_estadual || ',' ||
                   nvl((select  kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                          from kss.v$pessoa_inscricao_estadual ie2
                         where ie2.cod_pessoa = neg.cod_pessoa),
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                          from kss.v$pessoa_endereco e
                         where e.cod_pessoa = neg.cod_pessoa
                           and neg.tipo_pessoa = 1
                           and e.inscricao_estadual <> neg.inscricao_estadual)) as neg_ie_adicional
                , snf.ordem_compra_cliente
				, o.emite_multimodal
				, case when o.emite_multimodal = 1 or o.operacao_vinculada_otm = 1 then 1 else 0 end as vinculado_multimodal
				, o.tipo_documento as tipo_documento_operacao
                , to_char(fiscal.pkg_cte.fnc_permite_emitir_cte(sc.solicitacao_carga_id, 1)) as permite_emitir_cte
				, (select count(1)
				     from fiscal.v$conhecimento c
					inner join fiscal.v$documento_cte d
					   on d.conhecimento_id = c.conhecimento_id
					where c.modal = 6
					  and c.solicitacao_carga_id = sc.solicitacao_carga_id
					  and (select max(s.situacao_id) keep(dense_rank last order by ds.data_status, ds.doc_status_id)
						     from sefaz.documento_status ds
							inner join sefaz.status s
							   on s.cod_docto = ds.cod_docto
							  and s.cod_status = ds.cod_status
							where ds.documento_id = d.documento_id) in (0,1,2,5 )/*0 - Em digitação, 1 - Em Processamento, 2 - Autorizada, 5 - Rejeitada*/
					) as possui_multimodal_vinculado
			    , to_char(sc.data_carregamento_inicio, 'dd/mm/yyyy hh24:mi') as data_carregamento_inicio
				, sc.observacao
             from logistica.v$viagem_carga vc
            inner join logistica.v$viagem v
               on v.viagem_id = vc.viagem_id
            inner join logistica.v$solicitacao_carga sc
               on sc.solicitacao_carga_id = vc.solicitacao_carga_id
             left join logistica.v$solicitacao_carga_nf snf
               on snf.solicitacao_carga_id = sc.solicitacao_carga_id
            inner join logistica.v$operacao o
               on o.operacao_id = sc.operacao_id
            inner join cep.municipio col
               on col.municipio_id = sc.origem_municipio_id
            inner join kss.v$pessoa rem
               on rem.cod_pessoa = sc.cod_remetente
             left join kss.v$pessoa_endereco_todos reme
               on reme.cod_pessoa = rem.cod_pessoa
              and ((reme.cod_endereco = sc.endereco_remetente_id) or (sc.endereco_remetente_id is null and reme.endereco_padrao = 1))
             left join kss.v$pessoa_estrangeira pes
               on pes.cod_pessoa = rem.cod_pessoa
             left join cep.municipio remm
               on remm.municipio_id = reme.municipio_id
             left join kss.v$pessoa dest
               on dest.cod_pessoa = sc.cod_destinatario
             left join kss.v$pessoa cob
               on cob.cod_pessoa = sc.cod_cobranca
             left join kss.v$pessoa_endereco_todos ecob
               on ecob.cod_pessoa = sc.cod_cobranca
              and ((ecob.cod_endereco = sc.endereco_cobranca_id) or (sc.endereco_cobranca_id is null and ecob.endereco_padrao = 1))
             left join cep.municipio cobm
               on cobm.municipio_id =  ecob.municipio_id
             left join kss.v$pessoa_endereco_todos deste
               on deste.cod_pessoa = sc.cod_destinatario
              and ((deste.cod_endereco = sc.endereco_destinatario_id) or (sc.endereco_destinatario_id is null and deste.endereco_padrao = 1))
             left join kss.v$pessoa_estrangeira pesd
               on pesd.cod_pessoa = dest.cod_pessoa
             left join cep.municipio destm
               on destm.municipio_id = deste.municipio_id
             left join cep.municipio ent
               on ent.municipio_id = sc.destino_municipio_id
             left join kss.v$pessoa neg
               on neg.cod_pessoa = o.cod_negociador
             left join kss.v$pessoa_endereco_padrao neg_end
               on neg_end.cod_pessoa = o.cod_negociador
             left join kss.v$pessoa cons
               on cons.cod_pessoa = sc.cod_consignatario
             left join kss.v$pessoa_endereco_todos cons_end
               on cons_end.cod_pessoa = sc.cod_consignatario
              and ((cons_end.cod_endereco = sc.endereco_coleta_id) or (sc.endereco_coleta_id is null and cons_end.endereco_padrao = 1))
             left join kss.v$pessoa red
               on red.cod_pessoa = sc.cod_redespacho
             left join kss.v$pessoa_endereco_todos red_end
               on red_end.cod_pessoa = sc.cod_redespacho
              and ((red_end.cod_endereco = sc.endereco_entrega_id) or (sc.endereco_entrega_id is null and red_end.endereco_padrao = 1))
            where 1=1
           <cfif Len(Trim(arguments.OPERACAO_ID)) and not Len(Trim(arguments.VIAGEM_CARGA_ID))>
              and o.operacao_id = #arguments.OPERACAO_ID#
           </cfif>
           <cfif Len(Trim(arguments.VIAGEM_CARGA_ID))>
              and vc.viagem_carga_id = #arguments.VIAGEM_CARGA_ID#
           </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca dados do romaneio
	-- NOTAS EXPLICATIVAS
	-- GUTO 08/04/2006
	--->
	<cffunction name="get_romaneio_aberto" displayname="Busca o romaneio aberto para o veículo" access="remote" returntype="query" output="true">
		<cfargument name="placa_referencia" required="no" default="" />
		<cfargument name="placa_controle" required="no" default="" />
		<cfargument name="data" required="no" default="" />
		<cfargument name="num_romaneio" required="no" default="" />
		<cfquery result="query" datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ STAR_TRANSFORMATION */
            	   r.num_romaneio,
                   r.carregamento,
                   r.destino,
                   r.cliente,
                   r.remetente,
                   r.destinatario,
                   to_char(rhv.data_inicio,'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(rhv.data_termino,'dd/mm/yyyy hh24:mi:ss') as data_termino,
                   r.data_previsao_descarga,
				   r.data_previsao_carregado,
                   r.num_natureza,
                   n.descricao as natureza,
                   r.num_especie,
                   r.cod_unidade,
                   r.frete_em,
                   fiscal.pkg_fiscal.fnc_converte_peso(r.peso_total, 'Kg',r.cod_unidade) as peso_convertido,
				   r.peso_total,
                   r.volume_total,
                   r.m3_total,
                   r.frete_total,
				   r.valor_entregue,
                   r.km_vazio,
                   r.km_carregado,
                   r.valor_pedagio_vazio,
                   r.valor_pedagio_carregado,
                   nvl(r.valor_descarga,0) as valor_descarga,
                   r.org_logradouro,
				   r.org_complemento,
                   r.org_bairro,
                   r.org_cep,
                   r.dest_logradouro,
				   r.dest_complemento,
                   r.dest_bairro,
                   r.dest_cep,
                   r.situacao_id,
				   r.data_inicio_carga,
                   r.data_termino_carga,
                   r.data_inicio_descarga,
                   r.data_termino_descarga,
                   r.observacao,
                   r.data_destinado,
                   rhv.placa_referencia,
                   rhv.placa_controle,
				   oper.pkg_veiculo.fnc_get_composicao(rhv.placa_controle) as composicao,
				   oper.pkg_veiculo.fnc_veiculo_proprietario(rhv.placa_controle) as veiculo_proprietario,
				   r.placa_referencia, r.cod_pessoa_filial,
				   case
				      when exists (select 0
                                     from logistica.v$operacao_filial_emissao lsd
                                    inner join oper.v$romaneio_item ri
                                       on ri.operacao_id = lsd.operacao_id
                                    where ri.num_romaneio = r.num_romaneio
									  and lsd.cod_organograma = '#session.cod_organograma#') then 1
					 else 0 end permitido_filial,
					 (select count(*)
					    from oper.v$romaneio_item ri
					   where ri.num_romaneio = r.num_romaneio) as num_entregas,
				   (select count(*)
                        from oper.v$romaneio_item rit
                       inner join logistica.v$operacao o
                          on o.operacao_id = rit.operacao_id
                         and o.internacional = 1
                       where rit.num_romaneio = r.num_romaneio) as possui_internacional
			  from oper.v$romaneio r
			  inner join oper.v$romaneio_hist_veiculo rhv
				on r.num_romaneio = rhv.num_romaneio
			  left join oper.v$natureza n
				on r.num_natureza = n.num_natureza
			 where 1 = 1
			 	and nvl(rhv.data_termino,sysdate) = (select max(nvl(rhv2.data_termino,sysdate))
												      from oper.v$romaneio_hist_veiculo rhv2
													 where rhv2.num_romaneio = rhv.num_romaneio)
			 <cfif Len(Trim(arguments.num_romaneio))>
				and r.num_romaneio = #arguments.num_romaneio#
			 <cfelse>
			 	<cfif Len(Trim(arguments.data)) and Len(Trim(arguments.placa_referencia)) and Len(Trim(arguments.placa_controle))>
				   and rhv.placa_controle = '#Replace(arguments.placa_controle,'-','')#'
				   and rhv.placa_referencia = '#Replace(arguments.placa_referencia,'-','')#'
				   and to_date('#arguments.data#','dd/mm/yyyy hh24:mi') between rhv.data_inicio and nvl(rhv.data_termino,sysdate)
			   <cfelseif not Len(Trim(arguments.data)) and Len(Trim(arguments.placa_referencia)) and Len(Trim(arguments.placa_controle))>
			       and rhv.placa_referencia = '#Replace(arguments.placa_referencia,'-','')#'
				   and rhv.placa_controle = '#Replace(arguments.placa_controle,'-','')#'
				   and nvl(rhv.data_termino,sysdate) = (select max(nvl(rhv2.data_termino,sysdate))
														  from oper.v$romaneio_hist_veiculo rhv2
														   where rhv2.placa_referencia = '#Replace(arguments.placa_referencia,'-','')#'
															 and rhv2.placa_controle = '#Replace(arguments.placa_controle,'-','')#')

			   </cfif>
			 </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca dados do item do romaneio
	-- NOTAS EXPLICATIVAS
	-- GUTO 08/04/2006
	--->
	<cffunction name="get_romaneio_item" displayname="Busca o item do romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes" />
		<cfargument name="item_id" required="no" default="" />
		<cfargument name="frete_proprio" displayname="FLAG que indica se a consulta é por frete propio" required="no" default="" />
        <cfargument name="tipo_documento" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
             select /*+ORDERED*/
                   ri.num_romaneio,
                   ri.item_id, o.operacao_id, vc.viagem_carga_id,
                   ri.num_lote,
                   ri.volume,
                   ri.m3,
                   ri.valor_frete,
                   fiscal.pkg_conhecimento.fnc_produto_frete(col.municipio_id, ent.municipio_id, o.frete_proprio) as num_produto,

                   ri.cod_remetente,
                   rem.razao_social as remetente,
                   rem.cnpj_cpf as rem_cnpj_cpf,
                   col.municipio_id as rem_municipio_id,
                   col.uf_id as rem_uf,
                   per.logradouro || ',' || per.numero || ' - ' || per.complemento as rem_endereco,
                   per.logradouro as rem_logradouro,
                   per.numero as rem_endereco_num,
                   to_char(per.cep) as rem_cep,
                   per.bairro as rem_bairro,
                   initcap(col.municipio) as rem_municipio,
                   rem.inscricao_estadual as rem_inscr_estadual,

                   ri.cod_destinatario,
                   dest.razao_social as destinatario,
                   dest.cnpj_cpf as dest_cnpj_cpf,
                   d_end.logradouro || ', ' || d_end.numero || ' - ' || d_end.complemento as dest_endereco,
                   d_end.logradouro as dest_logradouro,
                   d_end.numero as dest_endereco_num,
                   d_end.uf as dest_uf,
                   to_char(d_end.cep) as dest_cep,
                   d_end.bairro as dest_bairro,
                   initcap(ent.municipio) as dest_municipio,
                   ent.municipio_id as dest_municipio_id,
                   dest.cod_atividade_fiscal as dest_atividade_fiscal,
                   dest.inscricao_estadual as dest_inscr_estadual,

                   ri.observacao,
                   case
                     when sc.valor_em = 'PESO' then
                      ri.valor_frete / decode(fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade),0,1,fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade))
                     when sc.valor_em = 'LOTACAO' then
                      ri.valor_frete
                     else
                      ri.valor_frete /
                      decode(fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade),
                             0,
                             1,
                             fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade))
                   end frete_valor_unitario,
                   o.frete_por_conta,
                   sc.valor_em as frete_em,
                   decode(o.frete_por_conta,0,rem.cod_atividade_fiscal,dest.cod_atividade_fiscal) as cod_atividade_fiscal,
                   fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'Kg', sc.cod_unidade) as peso,
                   '' as rodape,
                   decode(dest.cod_pessoa, null, 0, 1) as lote_com_destinatario,
                   o.frete_proprio,
                   o.regra_fiscal_id,

                   nvl(sc.cod_consignatario,ri.cod_remetente) as cod_consignatario,

                   nvl(cons.razao_social,rem.razao_social) as cons_razao_social,
                   nvl(cons.cnpj_cpf,rem.cnpj_cpf) as cons_cnpj_cpf,
                   nvl(cons.inscricao_estadual,rem.inscricao_estadual) as cons_inscricao_estadual,
                   nvl(decode(sc.cod_consignatario,null,'',cons_end.logradouro || ',' || cons_end.numero)
                       ,per.logradouro || ',' || per.numero || ' - ' || per.complemento)  as cons_endereco,
                   nvl(cons_end.numero,per.numero) as cons_endereco_num,
                   nvl(cons_end.bairro,per.bairro) as cons_bairro,
                   nvl(cons_end.cep,to_char(per.cep)) as cons_cep,
                   nvl(cons_end.municipio,initcap(col.municipio)) as cons_municipio,
                   nvl(cons_end.uf,col.uf_id) as cons_uf,
                   nvl(cons_mun.municipio_id,col.municipio_id) as cons_municipio_id,

                   nvl(sc.cod_redespacho,ri.cod_destinatario) as cod_redespacho,
                   nvl(red.razao_social,dest.razao_social) as redespacho,
                   nvl(red.cnpj_cpf,dest.cnpj_cpf) as red_cnpj_cpf,
                   nvl(red_end.logradouro,d_end.logradouro) as red_logradouro,
                   nvl(red_end.numero,d_end.numero) as red_endereco_num,
                   nvl(red_end.uf,d_end.uf) as red_uf,
                   nvl(to_char(red_end.cep),to_char(d_end.cep)) as red_cep,
                   nvl(red_end.bairro,d_end.bairro) as red_bairro,
                   nvl(initcap(red_mun.municipio),initcap(ent.municipio)) as red_municipio,
                   nvl(red_mun.municipio_id,ent.municipio_id) as red_municipio_id,
                   nvl(red.cod_atividade_fiscal,dest.cod_atividade_fiscal) as red_atividade_fiscal,
                   nvl(red.inscricao_estadual,dest.inscricao_estadual) as red_inscr_estadual,

                   pcob.cod_pessoa as  cod_cliente_cobranca,
                   pcob.cnpj_cpf cob_cnpj_cpf,
                   pcob.razao_social cob_razao_social,
                   pcob.inscricao_estadual cob_inscricao_estadual,
                   pecob.logradouro as cob_endereco,
                   pecob.numero as cob_endereco_numero,
                   pecob.cep cob_cep,
                   cobm.municipio cob_municipio,
                   cobm.uf_id cob_uf,
                   pecob.municipio_id cob_municipio_id,
                   ro.abreviatura as rota_abreviatura,

                   o.cod_negociador,
                   neg.cnpj_cpf as neg_cnpj_cpf,
                   neg.razao_social as neg_razao_social,
                   neg.inscricao_estadual as neg_inscricao_estadual,
                   neg_end.logradouro as neg_endereco,
                   neg_end.numero as neg_endereco_num,
                   neg_end.cep as neg_cep,
                   neg_end.municipio as neg_municipio,
                   neg_end.municipio_id as neg_municipio_id,
                   neg_end.bairro as neg_bairro,
                   neg_end.uf as neg_uf , o.descricao as operacao,
                   sc.origem_municipio_id, sc.destino_municipio_id,
                   vc.viagem_id,
                   sc.solicitacao_carga_id,
				   to_char(sc.data_carregamento_inicio, 'dd/mm/yyyy hh24:mi') as data_carregamento_inicio,
                   to_char(sc.data_entrega_fim, 'dd/mm/yyyy hh24:mi') as data_entrega_fim,
                   (select count(*)
                     from fiscal.v$conhecimento c
                    where c.num_romaneio = ri.num_romaneio
                      and c.item_id = ri.item_id) as possui_conhecimento
              from oper.v$romaneio_item ri
             inner join logistica.v$viagem_carga vc
                     on vc.viagem_carga_id = ri.viagem_carga_id
             inner join logistica.v$solicitacao_carga sc
                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
             inner join kss.v$pessoa rem
                     on rem.cod_pessoa = sc.cod_remetente
             inner join kss.v$pessoa_endereco_todos per
                     on per.cod_pessoa = sc.cod_remetente
                    and ((per.cod_endereco = sc.endereco_remetente_id) or (sc.endereco_remetente_id is null and per.endereco_padrao = 1))
             inner join cep.municipio col
                     on ri.rem_municipio_id = col.municipio_id
             inner join logistica.v$operacao o
                     on ri.operacao_id = o.operacao_id
              left join(oper.v$romaneio_itinerario iti
                        inner join oper.v$rota ro
                                on ro.rota_id = iti.rota_id)
                     on iti.itinerario_id = ri.itinerario_id
              left join kss.v$pessoa dest
                     on ri.cod_destinatario = dest.cod_pessoa
              left join kss.v$pessoa_endereco_todos d_end
                     on d_end.cod_pessoa = sc.cod_destinatario
                    and ((d_end.cod_endereco = sc.endereco_destinatario_id) or (sc.endereco_destinatario_id is null and d_end.endereco_padrao = 1))
              left join kss.v$pessoa_endereco_todos pecob
                     on pecob.cod_pessoa = sc.cod_cobranca
                    and ((pecob.cod_endereco = sc.endereco_cobranca_id) or (sc.endereco_cobranca_id is null and pecob.endereco_padrao = 1))
              left join kss.v$pessoa pcob
                     on pcob.cod_pessoa = sc.cod_cobranca
              left join cep.municipio cobm
                     on cobm.municipio_id = pecob.municipio_id
              left join cep.municipio ent
                     on d_end.municipio_id = ent.municipio_id
              left join kss.v$pessoa red
                     on sc.cod_redespacho = red.cod_pessoa
              left join kss.v$pessoa_endereco_todos red_end
                     on red_end.cod_pessoa = sc.cod_redespacho
                    and ((red_end.cod_endereco = sc.endereco_entrega_id) or (sc.endereco_entrega_id is null and red_end.endereco_padrao = 1))
              left join cep.municipio red_mun
                     on red_end.municipio_id = red_mun.municipio_id
              left join kss.v$pessoa neg
                     on neg.cod_pessoa = o.cod_negociador
              left join kss.v$pessoa_endereco_padrao neg_end
                     on neg_end.cod_pessoa = o.cod_negociador
              left join kss.v$pessoa cons
                     on cons.cod_pessoa = sc.cod_consignatario
              left join kss.v$pessoa_endereco_todos cons_end
                     on cons_end.cod_pessoa = sc.cod_consignatario
                    and ((cons_end.cod_endereco = sc.endereco_coleta_id) or (sc.endereco_coleta_id is null and cons_end.endereco_padrao = 1))
              left join cep.municipio cons_mun
                     on cons_end.municipio_id = cons_mun.municipio_id
            where ri.num_romaneio = #arguments.num_romaneio#
			 <cfif Len(Trim(arguments.item_id))>
			   and ri.item_id = #arguments.item_id#
			 </cfif>
             <cfif Len(Trim(arguments.tipo_documento))>
			   and o.tipo_documento = #arguments.tipo_documento#
			 </cfif>
 			 <cfif Len(Trim(arguments.frete_proprio))>
			   and o.frete_proprio = #arguments.frete_proprio#
			 </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca os dados gerais do conhecimento
	-- CRISTOFER  06/12/2006
	--->
	<cffunction name="get_conhecimento_dados" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="serie" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
		<cfargument name="rem_cnpj" required="no" default="">
		<cfargument name="rem_razao_social" required="no" default="">
		<cfargument name="dest_cnpj" required="no" default="">
		<cfargument name="dest_razao_social" required="no" default="">
		<cfargument name="cpf_motorista" required="no" default="">
		<cfargument name="nome_motorista" required="no" default="">
                <cfargument name="data_emissao" required="no" default="">  
                <cfargument name="lotacao" required="no" default="1">
		<cfargument name="valida_ambiente" required="no" default="0">
		<cfif valida_ambiente eq 1 and Len(Trim(arguments.cod_pessoa_filial))>
			<cfquery result="reslt" name="qr_ambiente" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			   select ea.ambiente_id as ambiente_id
			     from sefaz.v$emitente_ambiente ea
		        where ea.cnpj_cpf = (select p.cnpj_cpf
				      				   from kss.v$pessoa p
								      where p.cod_pessoa = #arguments.cod_pessoa_filial#
								     )
			       and ea.cod_docto = 'CTE'
			</cfquery>
		</cfif>
		
		<cfquery result="reslt" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select con.conhecimento_id,
				   con.num_conhecimento,
				   con.serie,
				   con.item_id,
				   con.num_romaneio,
				   p.cliente as filial,
				   con.cod_pessoa_filial,
				   con.cod_departamento,
				   con.cod_setor,
				   con.cod_centro_custo,
				   con.data_emissao,
				   to_char(con.data_emissao, 'dd/mm/yyyy hh24:mi') data_emissao_dt_hr,
				   to_char(sysdate, 'dd/mm/yyyy hh24:mi') data_emissao_data_hora,
				   con.num_produto,
				   con.cfop_id,
				   con.cfop,
				   con.natureza_operacao,
				   trim(con.st_origem_id) as st_origem_id,
				   trim(con.st_icms_id) as st_icms_id,
				   con.pagador,
				   con.cod_remetente,
				   con.rem_razao_social,
				   con.rem_endereco,
				   con.rem_endereco_num,
				   con.rem_bairro,
				   con.rem_municipio,
				   con.rem_municipio_id,
				   con.rem_uf,
				   to_char(con.rem_cep) as rem_cep,
				   (select pcnpj.cnpj_cpf
				      from kss.v$pessoa pcnpj
				     where pcnpj.cod_pessoa = con.cod_remetente) as rem_cnpj_cpf,
				   con.rem_inscricao_estadual,
				   con.cod_destinatario,
				   con.dest_razao_social,
				   con.dest_endereco,
				   con.dest_endereco_num,
				   con.dest_bairro,
				   con.dest_municipio,
				   con.dest_municipio_id,
				   con.dest_uf,
				   to_char(con.dest_cep) as dest_cep,
				   (select pcnpj.cnpj_cpf
				      from kss.v$pessoa pcnpj
				     where pcnpj.cod_pessoa = con.cod_destinatario) as dest_cnpj_cpf,
				   con.dest_inscricao_estadual,
				   con.cod_consignatario,
				   con.cons_razao_social,
				   con.cons_endereco,
				   con.cons_endereco_num,
				   con.cons_bairro,
				   con.cons_municipio,
				   con.cons_municipio_id,
				   con.cons_uf,
				   to_char(con.cons_cep) as cons_cep,
				   (select pcnpj.cnpj_cpf
				      from kss.v$pessoa pcnpj
				     where pcnpj.cod_pessoa = con.cod_consignatario) as cons_cnpj_cpf,
				   con.cons_inscricao_estadual,
				   con.cod_redespacho,
				   con.red_razao_social,
				   con.red_endereco,
				   con.red_endereco_num,
				   con.red_bairro,
				   con.red_municipio,
				   con.red_municipio_id,
				   con.red_uf,
				   to_char(con.red_cep) as red_cep,
				   (select pcnpj.cnpj_cpf
				      from kss.v$pessoa pcnpj
				     where pcnpj.cod_pessoa = con.cod_redespacho) as red_cnpj_cpf,
				   con.red_inscricao_estadual,
				   con.peso,
				   con.volume,
				   con.m3,
				   con.frete_unitario,
				   con.frete_peso,
				   con.frete_valor,
				   con.despacho,
				   con.base_calculo_icms,
				   con.aliquota_icms,
				   con.ademe,
				   con.desconto,
				   con.sec_cat,
				   con.gris,
				   con.pedagio,
				   con.valor_icms,
				   con.valor_icms_substit,
				   con.coleta_entrega,
				   con.impostos,
				   con.total_conhecimento,
				   con.num_natureza,
				   con.num_especie,
				   con.cod_unidade,
				   con.coleta_cod_pessoa,
				   con.coleta_logradouro,
				   con.coleta_complemento,
				   con.coleta_bairro,
				   con.coleta_num,
				   to_char(con.coleta_cep) as coleta_cep,
				   con.entrega_logradouro,
				   con.entrega_complemento,
				   con.entrega_bairro,
				   to_char(con.entrega_cep) as entrega_cep,
				   nvl((select cv.placa
						 from fiscal.v$conhecimento_veiculo cv
						where cv.conhecimento_id = con.conhecimento_id
						  and cv.ordem = 2),
					   con.placa) as placa,
				   (select kss.fnc_concat_all(kss.to_concat_expr(cv.placa, ','))
					  from fiscal.v$conhecimento_veiculo cv
					 where cv.conhecimento_id = con.conhecimento_id
					   and cv.ordem > 2) as carretas,
				   con.cod_motorista,
				   con.nome_motorista,
				   con.cod_proprietario,
				   con.prop_razao_social,
				   con.prop_cnpj_cpf,
				   con.prop_endereco,
				   con.prop_uf,
				   nvl2(con.cancelado, 1, 0) as situacao_id,
				   nvl2(con.impresso, 1, 0) as impresso,
				   nvl2(con.conferido, 1, 0) as conferido,
				   con.observacao,
				   con.observacao_automatica,
				   con.rodape,
				   con.entrada_dados,
				   con.user_insert,
				   con.date_insert,
				   con.user_update,
				   con.date_update,
				   con.site,
				   con.coleta_municipio_id,
				   con.peso_real,
				   mc.municipio coleta_municipio,
				   mc.uf_id coleta_uf,
				   con.entrega_municipio_id,
				   me.municipio entrega_municipio,
				   me.uf_id entrega_uf,
				   con.cod_cliente_cobranca,
				   con.cob_razao_social,
				   con.cob_endereco,
				   con.cob_endereco_num,
				   con.cob_bairro,
				   con.cob_municipio,
				   con.cob_municipio_id,
				   con.cob_uf,
				   to_char(con.cob_cep) as cob_cep,
				   (select pcnpj.cnpj_cpf
				      from kss.v$pessoa pcnpj
				     where pcnpj.cod_pessoa = con.cod_cliente_cobranca) as cob_cnpj_cpf,
				   con.cob_inscricao_estadual,
				   con.cod_negociador,
				   neg.cnpj_cpf as neg_cnpj_cpf,
				   neg.razao_social as neg_razao_social,
				   neg.inscricao_estadual as neg_inscricao_estadual,
				   neg_end.logradouro as neg_endereco,
				   neg_end.numero as neg_endereco_num,
				   neg_end.bairro as neg_bairro,
				   to_char(neg_end.cep) as neg_cep,
				   neg_end.municipio as neg_municipio,
				   neg_end.municipio_id as neg_municipio_id,
				   neg_end.uf as neg_uf,
				   con.prazo_entrega,
				   to_char(con.prazo_entrega, 'dd/mm/yyyy hh24:mi') prazo_entrega_data,
				   con.cod_organograma_gerencial,
				   con.regra_fiscal_id,
				   con.valor_iss,
				   con.base_calculo_iss,
				   con.aliquota_iss,
				   con.coleta_cnpj_cpf,
				   con.coleta_razao_social,
				   con.coleta_inscricao_estadual,
				   to_char(substr(pj.cnpj_ordem, 3, 2)) cnpj_ordem,
				   nvl2((select cv.placa
						  from fiscal.v$conhecimento_veiculo cv
						 where cv.conhecimento_id = con.conhecimento_id
						   and cv.ordem = 1),
						con.placa_tracao,
						substr(oper.pkg_veiculo.fnc_get_composicao(con.placa,
																   con.data_emissao),
							   2,
							   instr(oper.pkg_veiculo.fnc_get_composicao(con.placa,
																		 con.data_emissao),
									 '|',
									 2) - 2)) placa_tracao,
				   decode(nvl2((select cv.placa
								 from fiscal.v$conhecimento_veiculo cv
								where cv.conhecimento_id = con.conhecimento_id
								  and cv.ordem = 1),
							   con.placa_tracao,
							   substr(oper.pkg_veiculo.fnc_get_composicao(nvl(con.placa, con.placa_tracao),
																		  con.data_emissao),
									  2,
									  instr(oper.pkg_veiculo.fnc_get_composicao(nvl(con.placa, con.placa_tracao),
																				con.data_emissao),
											'|',
											2) - 2)),
						  '',
						  '',
						  oper.pkg_veiculo.fnc_veiculo_proprietario(con.placa_tracao)) proprietario_tracao,
				   p.cnpj_cpf cnpj_cpf_filial,
				   nvl2(con.cancelado, 1, 0) as cancelado,
				   nvl(o.operacao_id, con.operacao_id) as operacao_id,
				   o.descricao as operacao_descricao,

				   con.solicitacao_carga_id,
				   sc.valor_em as frete_em,
				   (select sign(count(1))
					  from fiscal.v$ctrc_comercial_versao ccv
					 where ccv.conhecimento_id = con.conhecimento_id) as possui_tabela_frete,
				   con.cod_endereco_rem,
				   con.cod_endereco_coleta,
				   con.cod_endereco_dest,
				   con.cod_endereco_entrega,
				   con.cod_endereco_cob,
				   con.cod_endereco_neg,
				   con.entrega_num,
				   con.organizacional_id,
				   (select o.cod_organizacional
					  from kss.v$organizacional o
					 where o.organizacional_id = con.organizacional_id) as cod_organizacional,
				   (select substr(replace(sys_connect_by_path(o.descricao, '@@'),
										  '@@',
										  '/'),
								  2) as descricao_completa
					  from kss.v$organizacional o
					 where o.organizacional_id = con.organizacional_id
					 start with o.organizacional_id_pai = -1
					connect by prior o.organizacional_id = o.organizacional_id_pai) as organizacional_descricao,
				   o.tipo_frete,
				   (select sign(count(1))
					  from fiscal.v$conhecimento_complemento cc
					 where cc.conhecimento_id = con.conhecimento_id) as possui_complemento,
				   (select sign(count(1))
					  from fiscal.v$conhecimento_complemento cc
					 where cc.conhecimento_complemento_id = con.conhecimento_id) as complemento,
				   (select sign(count(1))
					  from fiscal.v$conhecimento_substituto cs
					 where cs.conhecimento_id = con.conhecimento_id) as possui_substituto,
				   kss.pkg_pessoa.fnc_get_cod_atividade_fiscal(con.cod_remetente,
															   con.cod_endereco_rem) as rem_cod_atividade,
				   kss.pkg_pessoa.fnc_get_cod_atividade_fiscal(con.coleta_cod_pessoa,
															   con.cod_endereco_coleta) as coleta_cod_atividade,
				   kss.pkg_pessoa.fnc_get_cod_atividade_fiscal(con.cod_destinatario,
															   con.cod_endereco_dest) as dest_cod_atividade,
				   kss.pkg_pessoa.fnc_get_cod_atividade_fiscal(con.entrega_cod_pessoa,
															   con.cod_endereco_entrega) as entrega_cod_atividade,
				   kss.pkg_pessoa.fnc_get_cod_atividade_fiscal(con.cod_cliente_cobranca,
															   con.cod_endereco_cob) as cob_cod_atividade,
				   kss.pkg_pessoa.fnc_get_cod_atividade_fiscal(con.cod_negociador,
															   con.cod_endereco_neg) as neg_cod_atividade

				  ,
				   nvl(con.rem_inscricao_estadual,
					   kss.pkg_pessoa.fnc_get_inscricao_estadual(con.cod_remetente,
																 con.cod_endereco_rem)) as rem_inscricao_estadual,
				   nvl(con.coleta_inscricao_estadual,
					   kss.pkg_pessoa.fnc_get_inscricao_estadual(con.coleta_cod_pessoa,
																 con.cod_endereco_coleta)) as coleta_inscricao_estadual,
				   nvl(con.dest_inscricao_estadual,
					   kss.pkg_pessoa.fnc_get_inscricao_estadual(con.cod_destinatario,
																 con.cod_endereco_dest)) as dest_inscricao_estadual,
				   nvl(con.red_inscricao_estadual,
					   kss.pkg_pessoa.fnc_get_inscricao_estadual(con.entrega_cod_pessoa,
																 con.cod_endereco_entrega)) as entrega_inscricao_estadual,
				   nvl(con.cob_inscricao_estadual,
					   kss.pkg_pessoa.fnc_get_inscricao_estadual(con.cod_cliente_cobranca,
																 con.cod_endereco_cob)) as cob_inscricao_estadual,
				   kss.pkg_pessoa.fnc_get_inscricao_estadual(con.cod_negociador,
															 con.cod_endereco_neg) as neg_inscricao_estadual,
				   sc.pedido_shipment as pedido_shipment_solicitacao,
				   (select d.cod_status
					  from fiscal.v$documento_cte t
					 inner join sefaz.v$documento_status d
						on d.documento_id = t.documento_id
					 where t.conhecimento_id = con.conhecimento_id) as cod_status,
				   vc.viagem_carga_id

				  ,
				   (select kss.pkg_pessoa.fnc_get_inscricao_estadual(con.cod_remetente,
																	 con.cod_endereco_rem) || ',' ||
						   kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual,
																 ','))
					  from kss.v$pessoa_inscricao_estadual ie2
					 where ie2.cod_pessoa = con.cod_remetente) as rem_ie_adicional

				  ,
				   (select kss.pkg_pessoa.fnc_get_inscricao_estadual(con.coleta_cod_pessoa,
																	 con.cod_endereco_coleta) || ',' ||
						   kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual,
																 ','))
					  from kss.v$pessoa_inscricao_estadual ie2
					 where ie2.cod_pessoa = con.coleta_cod_pessoa) as coleta_ie_adicional

				  ,
				   (select kss.pkg_pessoa.fnc_get_inscricao_estadual(con.cod_destinatario,
																	 con.cod_endereco_dest) || ',' ||
						   kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual,
																 ','))
					  from kss.v$pessoa_inscricao_estadual ie2
					 where ie2.cod_pessoa = con.cod_destinatario) as dest_ie_adicional

				  ,
				   (select kss.pkg_pessoa.fnc_get_inscricao_estadual(con.entrega_cod_pessoa,
																	 con.cod_endereco_entrega) || ',' ||
						   kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual,
																 ','))
					  from kss.v$pessoa_inscricao_estadual ie2
					 where ie2.cod_pessoa = con.entrega_cod_pessoa) as entrega_ie_adicional

				  ,
				   (select kss.pkg_pessoa.fnc_get_inscricao_estadual(con.cod_cliente_cobranca,
																	 con.cod_endereco_cob) || ',' ||
						   kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual,
																 ','))
					  from kss.v$pessoa_inscricao_estadual ie2
					 where ie2.cod_pessoa = con.cod_cliente_cobranca) as cob_ie_adicional

				  ,
				   (select neg.inscricao_estadual || ',' ||
						   kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual,
																 ','))
					  from kss.v$pessoa_inscricao_estadual ie2
					 where ie2.cod_pessoa = con.cod_negociador) as neg_ie_adicional
                ,  (select count(*)
                      from fiscal.v$conhecimento_complemento cc
                     where cc.conhecimento_id = con.conhecimento_id) as qtde_complementos
                  , con.tipo_servico_id
 				  , o.emite_multimodal
				  , con.modal
				  , case when (o.emite_multimodal = 1 and nvl(con.modal,0) <> 6) or o.operacao_vinculada_otm = 1 then 1 else 0 end as vinculado_multimodal
				  , (select 1
				       from fiscal.v$conhecimento_anulacao a
					  where a.conhecimento_id_original = con.conhecimento_id
                        and rownum = 1) as tem_anulacao
				  , con.dispensado_tabela_frete
				  , con.conhecimento_tipo_id
			  from fiscal.v$conhecimento con
			 inner join kss.v$pessoa p
				on p.cod_pessoa = con.cod_pessoa_filial
			 inner join cep.municipio mc
				on mc.municipio_id = con.coleta_municipio_id
			 inner join cep.municipio me
				on me.municipio_id = con.entrega_municipio_id
			  left join oper.v$romaneio_item ri
				on ri.item_id = con.item_id
			  left join logistica.v$operacao o
				on o.operacao_id = nvl(con.operacao_id, ri.operacao_id)
			  left join logistica.v$solicitacao_carga sc
				on sc.solicitacao_carga_id = con.solicitacao_carga_id
			  left join logistica.v$viagem_carga vc
				on vc.solicitacao_carga_id = sc.solicitacao_carga_id
			  left join kss.v$pessoa_juridica pj
				on pj.cod_pessoa = con.cod_pessoa_filial
			  left join kss.v$pessoa neg
				on neg.cod_pessoa = con.cod_negociador
			  left join kss.v$pessoa_endereco neg_end
				on neg_end.cod_pessoa = con.cod_negociador
			   and neg_end.endereco_padrao = 1
			 where 1 = 1
			 <cfif len(trim(arguments.num_conhecimento))>
			   and con.num_conhecimento in (#arguments.num_conhecimento#)
			 </cfif>
			 <cfif len(trim(arguments.serie))>
			   and con.serie  = '#arguments.serie#'
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_filial)) && (arguments.lotacao neq 0)>
			   and con.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
             <cfif len(trim(arguments.cod_centro_custo)) && (arguments.lotacao neq 0)>
			   and con.cod_centro_custo = #arguments.cod_centro_custo#
			 </cfif>
			 <cfif len(trim(arguments.conhecimento_id))>
			   and con.conhecimento_id in (#arguments.conhecimento_id#)
			 </cfif>
			 <cfif len(trim(arguments.rem_cnpj))>
			   and con.rem_cnpj_cpf = '#arguments.rem_cnpj#'
			 </cfif>
			 <cfif len(trim(arguments.rem_razao_social))>
			   and upper(con.rem_razao_social) like upper('%#arguments.rem_razao_social#%')
			 </cfif>
			 <cfif len(trim(arguments.dest_cnpj))>
			   and con.dest_cnpj_cpf = '#arguments.dest_cnpj#'
			 </cfif>
			 <cfif len(trim(arguments.dest_razao_social))>
			   and upper(con.dest_razao_social) like upper('%#arguments.dest_razao_social#%')
			 </cfif>
			 <cfif len(trim(arguments.data_emissao))>
			   and trunc(con.data_emissao) = '#arguments.data_emissao#'
			 </cfif>
			 <cfif valida_ambiente eq 1 and Len(Trim(arguments.cod_pessoa_filial))>
			   and con.ambiente_id = #qr_ambiente.ambiente_id#
			 </cfif>
			 order by con.num_conhecimento
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca estrutura organizacional
	-- GUTO 29/05/2009
	--->
	<cffunction name="get_organizacional" access="remote" returntype="query" output="true">
    	<cfargument name="organizacional_id" required="no" default="" />
        <cfargument name="operacao_id" required="no" default="" />
        <cfargument name="multipla_consulta" required="no" default="0" hint="0-Busca de pelo ID e/ou pela operação separadamente; 1-Busca pelo ID e pela operação juntamente;" />
        <cfargument name="entrada_saida" required="no" default="" hint="0-Entrada; 1-Saída;" />
        <cfargument name="somente_ativos" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">

            select o.organizacional_id, o.organizacional_id_pai,
            	   upper(o.cod_organizacional) as cod_organizacional, o.descricao,
                   substr(replace(sys_connect_by_path(o.descricao, '@@'),'@@','/'),2) as descricao_completa,
                   connect_by_isleaf as folha
              from kss.v$organizacional o
              where 1 = 1
				<cfif arguments.multipla_consulta eq 1>
                   and (o.organizacional_id in (#arguments.organizacional_id#)
                        or (o.organizacional_id in (select op.organizacional_id
                                                     from logistica.v$operacao_organizacional op
                                                    where op.operacao_id = #arguments.operacao_id#)
                            or not exists (select op.organizacional_id
                                             from logistica.v$operacao_organizacional op
                                            where op.operacao_id = #arguments.operacao_id#)
                           )
                       )
                <cfelse>
                    <cfif Len(Trim(arguments.organizacional_id))>
                        and o.organizacional_id in (#arguments.organizacional_id#)
                    </cfif>
                    <cfif Len(Trim(arguments.operacao_id))>
                        and (o.organizacional_id in (select op.organizacional_id
                                                       from logistica.v$operacao_organizacional op
                                                      where op.operacao_id = #arguments.operacao_id#))
	                    and not exists (select 1
                                          from kss.v$organizacional o2
                                         where o2.organizacional_id_pai = o.organizacional_id)
                    </cfif>
                </cfif>
                <cfif Len(Trim(arguments.entrada_saida))>
                    <cfif arguments.entrada_saida eq 0>
                        and o.tipo in (0,2)
                    <cfelseif arguments.entrada_saida eq 1>
                        and o.tipo in (1,2)
                    </cfif>
                </cfif>
                <cfif arguments.somente_ativos eq 1>
                   and o.ativo = 1
                </cfif>
             start with o.organizacional_id_pai = -1
            connect by prior o.organizacional_id = o.organizacional_id_pai
            order siblings by o.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca Todos os romaneios de lotes próprios que não possuem conhecimento emitido no sistema
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 28/08/2009 - ALTERADO
	--->
	<cffunction name="get_romaneio_sem_conhecimento" displayname="Busca Todos os romaneios de lotes próprios que não possuem conhecimento emitido no sistema" access="remote" returntype="query" output="true">
    	<cfargument name="frete_proprio" required="no" default="">
    	<cfargument name="municipal" required="no" default="">
        <cfargument name="lotacao" required="no" default="">
        <cfargument name="tipo_documento" required="no" default="">
			<cfargument name="data_inicio" required="no" default="">		  
			<cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_fitro_data" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select nvl(kss.pkg_global.fnc_obtem_parametro_str(25,'FISCAL.EXE',12),'01/07/2009') as data_filtro
            from dual
        </cfquery>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#" blockfactor="10">
            select 
                   distinct sc.solicitacao_carga_id,
                   v.viagem_id,
                   roo.cod_pessoa_filial,
                   kss.pkg_pessoa.fnc_get_cliente(roo.cod_pessoa_filial, 1) as filial,
                   oper.pkg_veiculo.fnc_placa(v.veiculo_id) as placa_controle,
                   oper.pkg_veiculo.fnc_placa(v.veiculo_id_referencia) as placa_referencia,
                   oper.pkg_veiculo.fnc_cod_veiculo(v.veiculo_id) as frota_controle,
                   oper.pkg_veiculo.fnc_cod_veiculo(v.veiculo_id_referencia) as frota_referencia,
                   roo.num_romaneio,
                   roo.carregamento,
                   kss.pkg_pessoa.fnc_get_cliente(sc.cod_remetente) as remetente,
                   kss.pkg_pessoa.fnc_get_cliente(sc.cod_destinatario) as destinatario,
                   (select kss.fnc_concat_all(kss.to_concat_expr(scnf.numero,'/'))
                      from logistica.v$solicitacao_carga_nf scnf
                     where scnf.solicitacao_carga_id = sc.solicitacao_carga_id) as numero,
                   (select sum(scnf.valor_total)
                      from logistica.v$solicitacao_carga_nf scnf
                     where scnf.solicitacao_carga_id = sc.solicitacao_carga_id) as valor_total,
                   case
                      when roo.situacao_id = 1 then '<<Encerrado>>'
                      else to_char(rfr.data_ultima_posicao, 'dd/mm/yyyy hh24:mi:ss')
                   end as data_ultima_posicao,
                   case
                      when roo.situacao_id = 1 then '<<Encerrado>>'
                      else rfr.landmark
                   end as referencia,
                   case
                      when roo.situacao_id = 1 then 'Encerrado'
                      else evs.descricao_resumida
                   end as status,
                   sc.observacao as observacao_carga
              from oper.v$romaneio roo
             inner join oper.v$romaneio_item rit
                on roo.num_romaneio = rit.num_romaneio
              left join logistica.v$viagem_carga vc
                on vc.viagem_carga_id = rit.viagem_carga_id
				  left join logistica.v$carga_consolidada_carga ccc
				    on ccc.carga_consolidada_id = rit.carga_consolidada_id
					and ccc.situacao_id <> 0
             inner join logistica.v$solicitacao_carga sc
                on sc.solicitacao_carga_id = nvl(vc.solicitacao_carga_id, ccc.solicitacao_carga_id)
               and sc.situacao_id <> 5
             inner join logistica.v$viagem v
                on v.viagem_id = vc.viagem_id
               and v.situacao_id <> 0
             inner join logistica.v$operacao op
                on op.operacao_id = sc.operacao_id
             inner join logistica.v$operacao_filial_emissao ofe
                on ofe.operacao_id = sc.operacao_id
			<cfif Len(Trim(arguments.lotacao)) and arguments.lotacao eq 1>
               and ofe.cod_organograma = #session.COD_ORGANOGRAMA#
			</cfif>

              left join oper.v$rank_frota rfr
                on rfr.placa_referencia = oper.pkg_veiculo.fnc_placa(v.veiculo_id_referencia)
              left join oper.v$evento_operacao evo
                on evo.controle_evo_id = rfr.roo_evo_id
              left join oper.v$evento_operacao_setup evs
                on evs.num_evento = evo.num_evento
             where 1 = 1
               and op.internacional = 0
               and trunc(sc.data_carregamento_inicio) >= to_date('#qr_fitro_data.DATA_FILTRO#','dd/mm/yyyy')
               and not exists (select 1
					                  from logistica.v$solicitacao_carga_documento d
										  inner join fiscal.v$conhecimento c
											  on c.conhecimento_id = d.conhecimento_id
									     where d.solicitacao_carga_id = sc.solicitacao_carga_id
                                  and c.num_romaneio = roo.num_romaneio
                                  and c.item_id = rit.item_id)
               and not exists (select 1
                                 from logistica.v$solicitacao_carga_documento d
										  inner join fiscal.v$nf_es_frete nf
										     on nf.nf_es_id = d.nf_es_id
										  where d.solicitacao_carga_id = sc.solicitacao_carga_id
                                  and nf.num_romaneio = roo.num_romaneio
                                  and nf.item_id = rit.item_id)
               and not exists (select 1
                                 from logistica.v$solicitacao_carga_documento d
										  inner join fiscal.v$nf_es_frete_romaneio n
										     on n.nf_es_id = d.nf_es_id										  
										  where d.solicitacao_carga_id = sc.solicitacao_carga_id
                                  and n.num_romaneio = roo.num_romaneio)
               and roo.situacao_id <> 2
			<cfif Len(Trim(arguments.frete_proprio))>
		       and op.frete_proprio = #arguments.frete_proprio#
			</cfif>

			<cfif Len(Trim(arguments.data_inicio))>
		       and TRUNC(sc.data_carregamento_inicio) >= to_date('#arguments.data_inicio#', 'DD/MM/YYYY')
			</cfif>
			<cfif Len(Trim(arguments.data_fim))>
		       and trunc(sc.data_entrega_fim) <= to_date('#arguments.data_fim#', 'DD/MM/YYYY')
			</cfif>

			<cfif Len(Trim(arguments.municipal)) and arguments.municipal eq 1>
		       and sc.origem_municipio_id = sc.destino_municipio_id
			</cfif>
            <cfif Len(Trim(arguments.tipo_documento))>
		       and op.tipo_documento = #arguments.tipo_documento#
			</cfif>
 	    </cfquery>
	    <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Executa todos os calculos do CTRC levando em consideração as regras fiscais
	-- guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name='calcula_ctrc_comercial' displayname='Executa todos os calculos do CTRC levando em considera??o as regras fiscais' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='PEDAGIO' required='yes' >
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='VALOR_MERCADORIA' required='yes'>
		<cfargument name='AD_VALOREM' required='no' default="0">
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='ENTREGA_UF' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COD_REMETENTE' required='no' default="">
		<cfargument name='COD_CLIENTE_COBRANCA' required='no' default="">
		<cfargument name='COD_UNIDADE' required='no' default="">
		<cfargument name='REGRA_FISCAL_ID' required='no' default="1">
		<cfargument name='COLETA_MUNICIPIO_ID' required='no' default="">
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='no' default="">
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='SEM_ICMS' required='no' default="0">
		<!---Novos campos para CONTRATO--->
		<cfargument name='COD_NEGOCIADOR' required='no' default="">
		<cfargument name='FRACIONADO' required='no' default="">
		<cfargument name='NUM_NATUREZA' required='no' default="">
		<cfargument name='COD_TABELA_FRETE' required='no' default="">
		<cfargument name='VALOR_TOTAL_NOTA' required='no' default="">
		<cfargument name='FLAG_COLETA' required='no' default="">
		<cfargument name='NUM_EIXOS' required='no' default="">
		<cfargument name='FLAG_URGENTE' required='no' default="">
		<cfargument name='FLAG_TRUCK' required='no' default="">
		<cfargument name='NUM_AJUDANTES' required='no' default="">
		<cfargument name='NUM_ENTREGAS' required='no' default="">
		<cfargument name='FLAG_LOTACAO' required='no' default="">
		<cfargument name='M3' required='no' default="">
		<cfargument name='CTRC_COMPLEMENTAR' required='no' default="0">
		<cfargument name='ADEME' required='no' default="">
		<cfargument name='NOTA_FISCAL' required='no' default="0">
		<cfargument name='FRETE_EM' required='no' default="">
        <cfargument name='COD_ATIVIDADE_TOMA' required='no' default="">
        <cfargument name='COD_ATIVIDADE_REM' required='no' default="">
        <cfargument name='COD_ATIVIDADE_DEST' required='no' default="">
    	<cftry>
            <cfstoredproc procedure='fiscal.pkg_conhecimento.prc_calcula_ctrc_comercial' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#' variable="retorno.PESO">

                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#' variable='retorno.DESPACHO'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#' variable='retorno.SEC_CAT'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#' variable='retorno.GRIS'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#' variable='retorno.PEDAGIO'>

                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#' variable="retorno.NUM_PRODUTO">
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#' variable='retorno.COLETA_ENTREGA' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_UF#'  null='#iif(len(trim(arguments.COLETA_UF)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.ENTREGA_UF#'  null='#iif(len(trim(arguments.ENTREGA_UF)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.VALOR_MERCADORIA#' null='#iif(len(trim(arguments.VALOR_MERCADORIA)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.AD_VALOREM#' null='#iif(len(trim(arguments.AD_VALOREM)), de('no'), de('yes'))#' variable='retorno.AD_VALOREM'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.FRETE_UNITARIO#' variable='retorno.FRETE_UNITARIO' null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ST_ICMS_ID#' variable='retorno.ST_ICMS_ID' >

                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.FRETE_VALOR#'  variable='retorno.FRETE_VALOR'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.FRETE_PESO'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.TOTAL_CONHECIMENTO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.BASE_CALCULO_ICMS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.ALIQUOTA_ICMS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.VALOR_ICMS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.VALOR_ICMS_SUBSTIT' >

                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COD_REMETENTE#' null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5'  value='#arguments.COD_UNIDADE#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5'  value='#arguments.regra_fiscal_id#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5'  value='#arguments.COB_UF#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COLETA_MUNICIPIO_ID#' null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.ENTREGA_MUNICIPIO_ID#' null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.NUM_LOTE#' null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.SEM_ICMS#' null='#iif(len(trim(arguments.SEM_ICMS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COD_CLIENTE_COBRANCA#' null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'> 
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.UF_EMITENTE#'>

                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.CFOP' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CFOP_ID' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.NATUREZA_OPERACAO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.FUNDAMENTACAO_LEGAL' >
				<!---Novos campos para CONTRATO--->
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.PEDAGIO_INCLUSO' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COD_NEGOCIADOR#' null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.FRACIONADO#' null='#iif(len(trim(arguments.FRACIONADO)), de('no'), de('yes'))#'>
                <!---Se possuir M3 então é 1 (por volume) senão é PESO (0)--->
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#iif(arguments.M3 gt 0,DE("1"),DE("0"))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.NUM_NATUREZA#' null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.COD_TABELA_FRETE_RET' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DESCRICAO_CONTRATO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.LISTA_TABELA_FRETE' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COD_TABELA_FRETE#' null='#iif(len(trim(arguments.COD_TABELA_FRETE)), de('no'), de('yes'))#'> 
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.VALOR_TOTAL_NOTA#' null='#iif(len(trim(arguments.VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.FLAG_COLETA#' null='#iif(len(trim(arguments.FLAG_COLETA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.NUM_EIXOS#' null='#iif(len(trim(arguments.NUM_EIXOS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.FLAG_URGENTE#' null='#iif(len(trim(arguments.FLAG_URGENTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.FLAG_TRUCK#' null='#iif(len(trim(arguments.FLAG_TRUCK)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.NUM_AJUDANTES#' null='#iif(len(trim(arguments.NUM_AJUDANTES)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.NUM_ENTREGAS#' null='#iif(len(trim(arguments.NUM_ENTREGAS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.FLAG_LOTACAO#' null='#iif(len(trim(arguments.FLAG_LOTACAO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.M3#' null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.OUTROS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.PESO_COBRADO' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.CTRC_COMPLEMENTAR#' null='#iif(len(trim(arguments.CTRC_COMPLEMENTAR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.ADEME#' null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.NOTA_FISCAL#' null='#iif(len(trim(arguments.NOTA_FISCAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.QUANTIDADE#' null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.FRETE_EM#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COD_ATIVIDADE_TOMA#' null='#iif(len(trim(arguments.COD_ATIVIDADE_TOMA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COD_ATIVIDADE_REM#' null='#iif(len(trim(arguments.COD_ATIVIDADE_REM)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COD_ATIVIDADE_DEST#' null='#iif(len(trim(arguments.COD_ATIVIDADE_DEST)), de('no'), de('yes'))#'>

            </cfstoredproc>
            <cfif not Len(Trim(retorno.FRETE_UNITARIO))>
                <cfset retorno.FRETE_UNITARIO = 0>
            </cfif>
            <cfif not Len(Trim(retorno.AD_VALOREM))>
                <cfset retorno.AD_VALOREM = 0>
            </cfif>
        <cfset retorno.erro = false>
        <cfset retorno.mensagem = JSStringFormat('Ok')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfif Find('ORA-',cfcatch.Detail,10)>
	            <cfset retorno.mensagem_str = Mid(cfcatch.Detail,1,Find('ORA-',cfcatch.Detail,10)-1)>
            <cfelse>
                <cfset retorno.mensagem_str = cfcatch.Message>
            </cfif>
            <cfset retorno.mensagem = cfcatch.detail>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
		<cfreturn retorno/>
	</cffunction>
	
	<!--- 
	-- PROPÓSITO 
	-- Busca romaneio
	-- CRISTOFER  18/12/2006
	--->
	<cffunction name="get_produto_frete" access="remote" returntype="query" output="true">
		<cfargument name="municipio_id_origem" required="no" default="">
		<cfargument name="municipio_id_destino" required="no" default="">
		<cfargument name="frete_proprio" required="no" default="">
        <cfif Len(Trim(frete_proprio)) >
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select fiscal.pkg_conhecimento.fnc_produto_frete(#arguments.municipio_id_origem#, #arguments.municipio_id_destino#, #arguments.frete_proprio#) as num_produto
                  from dual
            </cfquery>
        <cfelse>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                  select produto_id, descricao as produto
                  from fiscal.v$produto p
                 inner join table(kss.pkg_string.fnc_split(fiscal.pkg_conhecimento.fnc_produto_frete_list(#arguments.municipio_id_origem#, #arguments.municipio_id_destino#),';')) a
                         on a.column_value = p.produto_id
          </cfquery>
        </cfif>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Retorna os dados fiscais do CTRC através dos parâmetros informados
	-- ANDERSONC 13/07/2010 - CRIADO
	--->
	<cffunction name='get_ctrc_dados_fiscais' displayname='Retorna os dados fiscais do CTRC através dos parâmetros informados' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='PAGO_POR' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='ENTREGA_UF' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
		<cfargument name='VIAGEM_CARGA_ID' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='UF_FILIAL' required='yes'>
		<cfargument name='NOTA_FISCAL' required='yes'>
        <cfargument name='COD_ATIVIDADE_TOMA' required='no' default="">
        <cfargument name='COD_NEGOCIADOR' required='no' default="">
        <cfargument name='TIPO_DOCUMENTO_ID' required='no' default="">
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_conhecimento.prc_ctrc_dados_fiscais' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PRODUTO_ID#' variable='retorno.PRODUTO_ID'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PAGO_POR#'  null='#iif(len(trim(arguments.PAGO_POR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ENTREGA_UF#' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ST_ICMS_ID#' variable='retorno.ST_ICMS_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COB_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_CARGA_ID#'  null='#iif(len(trim(arguments.VIAGEM_CARGA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF_FILIAL#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CFOP' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CFOP_ID' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.NATUREZA_OPERACAO' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.FUNDAMENTACAO_LEGAL' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.PEDAGIO_INCLUSO' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.FRETE_PROPRIO' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.TOMADOR_UF' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.COD_ATIVIDADE_TOMADOR' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NOTA_FISCAL#'  null='#iif(len(trim(arguments.NOTA_FISCAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COD_ATIVIDADE_TOMA#' null='#iif(len(trim(arguments.COD_ATIVIDADE_TOMA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.COD_NEGOCIADOR#' null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.TIPO_DOCUMENTO_ID#' null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Retorna a previsão de chegada para uma rota
	-- ANDERSON 06/05/2009
	--->
	<cffunction name="get_previsao_entrega" display="Retorna a previsão de chegada para uma rota" access="remote" returntype="query" output="true">
		<cfargument name='ROTA_ID' required='no' default="">
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default="">
		<cfargument name='DESTINO_MUNICIPIO_ID' required='no' default="">
		<cfargument name='DATA_INICIO' required='no' default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select to_char(oper.pkg_rota.fnc_previsao_chegada(to_date('#arguments.data_inicio#', 'dd/mm/yyyy hh24:mi'),r.origem_municipio_id,r.destino_municipio_id),'dd/mm/yyyy hh24:mi') as data_prazo_entrega
              from oper.v$rota r
             where 1 = 1
			<cfif Len(Trim(arguments.origem_municipio_id))>
              and r.origem_municipio_id = #arguments.origem_municipio_id#
            </cfif>
            <cfif Len(Trim(arguments.destino_municipio_id))>
              and r.destino_municipio_id = #arguments.destino_municipio_id#
            </cfif>
            <cfif Len(Trim(arguments.rota_id))>
              and r.rota_id = #arguments.rota_id#
            </cfif>
        </cfquery>
        <cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca os CFOP
	-- JAQUELINEF  24/03/2014
	--->
	<cffunction name="get_cfop" access="remote" returntype="query" output="true">
		<cfargument name='cfop' required='no' default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.cfop
                 , c.id
                 , c.natureza_id
                 , c.ativo
              from fiscal.v$cfop_id c
             where c.ativo = 1
            <cfif Len(Trim(arguments.cfop))>
              and  c.cfop = #arguments.cfop#
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Retorna se permite que o usuário habilite o vale pedágio na emissão de CTe
	-- LEANDROS 01/05/2014 - CRIADO
	--->
	<cffunction name='verifica_emissao_vale_pedagio' displayname='Retorna se permite que o usuário habilite o vale pedágio na emissão de CTe' access='remote' returntype='Struct' output='true'>
		<cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default="">
        <cfargument name='VIAGEM_ID' required='no' default="">
		<cftry>
            <cfstoredproc procedure='oper.pkg_vale_pedagio.prc_verifica_emissao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC'  SCALE='5'   value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC'  SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   variable='retorno.NUM_COMPROVANTE'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC'  SCALE='20'  variable='retorno.EMITE_VALEPEDAGIO'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   variable='retorno.MENSAGEM_RETORNO'>
                <cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC'  SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC'  SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC'   variable='retorno.VALOR'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca as informações da empresa
	-- LEANDROS  03/05/2014
	--->
	<cffunction name="get_empresa" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.cod_pessoa
                 , e.razao_social
                 , kss.pkg_string.fnc_num_clean(kss.fnc_get_identificador(p_cod_pessoa => e.cod_pessoa)) as cnpj
              from kss.v$empresa e
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Verifica se está configurado para emitir CTe Complementar por tabela de frete
	-- LEANDROS  28/05/2014
	--->
	<cffunction name="permite_emitir_tf" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fiscal.pkg_cte.fnc_emite_cte_diaria_tf as emite_por_tabela
              from dual
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPÓSITO 
	-- Obtem a descriação de um produto
	-- ROGERSP  15/01/2015
	--->
	<cffunction name="get_descricao_produto" access="remote" returntype="query" output="true">
		<cfargument name="produto_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select descricao
			  from fiscal.v$produto p
             where 1=1
			 <cfif Len(Trim(arguments.produto_id))>
			   and p.produto_id = #arguments.produto_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPÓSITO 
	-- Obtem a descriação de uma atividade fiscal
	-- ROGERSP  15/01/2015
	--->
	<cffunction name="get_descricao_atividade" access="remote" returntype="query" output="true">
		<cfargument name="cod_atividade_fiscal" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select descricao
			  from kss.v$atividade_fiscal a
             where 1=1
			 <cfif Len(Trim(arguments.cod_atividade_fiscal))>
			   and a.cod_atividade_fiscal = #arguments.cod_atividade_fiscal#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>    
    
    <!--- 
	-- PROPÓSITO 
	-- Busca as informações de um vale pedágio a partir do número de comprovante
	-- KMM_THOMASJ  18/08/2014
	--->
	<cffunction name="get_vale_pedagio" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct vpri.num_comprovante
                 , f.cod_pessoa as cod_pessoa_fornecedora
                 , f.cnpj_cpf as cnpj_cpf_fornecedora
                 , f.razao_social as fornecedora
                 , o.cod_pessoa as cod_pessoa_operadora
                 , o.cnpj_cpf as cnpj_cpf_operadora
                 , o.razao_social as operadora
              from oper.v$vale_pedagio_romaneio_it vpri
             inner join oper.v$vale_pedagio_romaneio vpr
                on vpr.vale_pedagio_romaneio_id = vpri.vale_pedagio_romaneio_id
             inner join oper.v$vale_pedagio_operadora vpo
                on vpo.vale_pedagio_operadora_id = vpr.vale_pedagio_operadora_id
             inner join kss.v$pessoa o
                on o.cod_pessoa = vpo.cod_pessoa
             inner join kss.v$pessoa f
                on f.cod_pessoa = vpr.cod_pessoa_fornecedora
             where 1=1
            <cfif Len(Trim(arguments.num_comprovante))>
               and vpri.num_comprovante = #arguments.num_comprovante#
            <cfelse>
               and 1=0
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
     <!--- 
	-- PROPÓSITO 
	-- Busca as informações de configuração de vale pedágio para uma operadora e um fornecedor
	-- KMM_THOMASJ  18/08/2014
	--->
	<cffunction name="get_vale_pedagio_config" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vpc.vale_pedagio_config_id
              from oper.v$vale_pedagio_config vpc
             inner join oper.v$vale_pedagio_operadora vpo
                on vpo.vale_pedagio_operadora_id = vpc.vale_pedagio_operadora_id
             where 1=1
               and kss.pkg_parametro.fnc_valor_lista('M309-P0014') = 'Sim' /*Se não realiza integração automática, nem consulta*/
             <cfif Len(Trim(arguments.cod_pessoa_fornecedora))>
               and vpc.cod_pessoa_fornecedora = #arguments.cod_pessoa_fornecedora#
            <cfelse>
               and 1=0
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_operadora))>
               and vpo.cod_pessoa =#arguments.cod_pessoa_operadora#
            <cfelse>
               and 1=0
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Retorna o custo do vale pedágio
	-- THOMASJ 26/09/2014 - CRIADO
	--->
	<cffunction name="get_vale_pedagio_valor"  access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID'>
        <cfargument name='VIAGEM_ID'>
        <cfargument name='VALE_PEDAGIO_CONFIG_ID' required="no" default="">
        <cfargument name='ROTA_ID' required="no" default="">
		<cftry>
            <cfstoredproc procedure='oper.pkg_vale_pedagio.prc_get_valor_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC'  SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC'  SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC'  SCALE='5'   value='1'>
				<cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC'  SCALE='5'   value='1'>
                <cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC'  SCALE='5'   value='#arguments.VALE_PEDAGIO_CONFIG_ID#'  null='#iif(len(trim(arguments.VALE_PEDAGIO_CONFIG_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC'  SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC'   variable='retorno.VALOR'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca as múltiplas inscrições estaduais que uma pessoa pode possuir. (Atualmente apenas o estado do AM permite)
	-- KMM_MATHEUSB 31/03/2015
	--->
	<cffunction name="get_inscricoes_estaduais_pessoa" access="remote" returntype="query" output="true">
	    <cfargument name="cod_pessoa" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.inscricao_estadual
                 , p.cod_pessoa
              from (select pj.inscricao_estadual
                         , pj.cod_pessoa
                      from kss.v$pessoa_juridica pj
                     union all
                    select pie.inscricao_estadual
                         , pie.cod_pessoa
                      from kss.v$pessoa_inscricao_estadual pie
                     ) p
                     where 1=1
                       and p.cod_pessoa = #arguments.cod_pessoa#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>
