<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!---
   -- PROPSITO
   -- Insere um contrato pamcard
   -- fabiog 18/03/2014 09:35:27 - CRIADO
   --->
   <cffunction name='inclui_contrato_frete' displayname='Insere um contrato pamcard' access='remote' returntype='Struct' output='true'>
      <cfargument name='COD_PESSOA' required='yes'>
      <cfargument name='LANCTO_ID' required='yes'>
      <cfargument name='ROTA_ID' required='yes'>
      <cfargument name='CARTAO_FAV1' required='yes'>
      <cfargument name='CARTAO_FAV2' required='yes'>
	  <cfargument name='TIPO_PAGTO_PEDAGIO_PAMCARD' required='yes'>
      <cftry>
         <cfstoredproc procedure='pamcard.pkg_integracao.prc_inclui_contrato_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' value='#arguments.CARTAO_FAV1#' >
            <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' variable='retorno.CONTRATO_ID'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' value='#arguments.CARTAO_FAV2#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' value='#arguments.TIPO_PAGTO_PEDAGIO_PAMCARD#'>
         </cfstoredproc>
         <cfset retorno.erro = false>
         <cfset retorno.mensagem = JSStringFormat('Contrato inserido com sucesso')>
         <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
         </cfcatch>
      </cftry>
      <cfreturn retorno />
   </cffunction>

   <!---
   -- PROPSITO
   -- Buscar o retorno da validao da ANTT
   -- FABIOG 18/04/2014 - CRIADO
   --->
   <cffunction name='retorno_antt' displayname='Buscar o retorno da validao da ANTT' access='remote' returntype='Struct' output='true'>
      <cfargument name='PLACA_CAVALO' required='yes'>
      <cfargument name='PLACA_CARRETA' required='yes'>
      <cfargument name='COD_CONTRATADO' required='yes'>
      <cftry>
            <cfstoredproc procedure='pamcard.pkg_integracao.prc_retorno_antt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
               <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#session.COD_PESSOA#' >
               <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
               <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
               <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CONTRATADO#'  null='#iif(len(trim(arguments.COD_CONTRATADO)), de('no'), de('yes'))#'>
               <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VEICULO_VALIDADO_ANTT' >
               <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.VEICULO_ERRO' >
               <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CARRETA_VALIDADO_ANTT' >
               <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CARRETA_ERRO' >
               <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTRATADO_VALIDADO_ANTT' >
               <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CONTRATADO_ERRO' >
            </cfstoredproc>
            <cfset retorno.erro = false>
         <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
         </cfcatch>
      </cftry>
      <cfreturn retorno />
   </cffunction>

   <!---
	-- PROPSITO
	-- Consultar uma roteiro
	-- fabiog 18/03/2014 17:26:54 - CRIADO
	--->
	<cffunction name='roteirizar' displayname='Consultar uma roteiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='no'>
      <cfquery name="qr_veiculo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select v.veiculo_id
           from oper.v$veiculo v
          where upper(v.placa) = upper(trim('#arguments.placa_controle#'))
      </cfquery>
      <cfset arguments.veiculo_id = qr_veiculo.veiculo_id>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_roteirizar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEICULO_ID#'  null='#iif(len(trim(arguments.VEICULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_PEDAGIO_ROTA'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Roteiro consultado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

   <!---
	-- PROPSITO
	-- Valida as pessoas fiscais
	-- fabiog 20/03/2014 09:41:35 - CRIADO
	--->
	<cffunction name='retorno_pessoa_fiscal' displayname='Valida as pessoas fiscais' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cftry>
			<cfstoredproc procedure='pamcard.pkg_integracao.prc_retorno_pessoa_fiscal' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REMETENTE_OK' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DESTINATARIO_OK' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CONSIGNATARIO_OK' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Pessoas validadas com sucesso.')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

   <!---
	-- PROPSITO
	-- Valida as pessoas fiscais
	-- fabiog 20/03/2014 09:41:35 - CRIADO
	--->
	<cffunction name='verificar_cartao' displayname='Valida as pessoas fiscais' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARTAO_NUMERO' required='yes'>
      <cfargument name='COD_CONTRATADO' required='yes'>
		<cftry>
			<cfstoredproc procedure='pamcard.pkg_integracao.prc_retorno_pessoa_fiscal' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REMETENTE_OK' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DESTINATARIO_OK' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CONSIGNATARIO_OK' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Carto verificado com sucesso.')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Gera o PDF de impresso de um contrato
	-- FABIOG 20/04/2014 - CRIADO
	--->
	<cffunction name='gera_contrato' displayname='Gera o PDF de impresso de um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_impressao.prc_gera_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impresso gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

   <!---
	-- PROPSITO
	-- Consulta um contrato na Pamcard
	-- fabiog 21/03/2014 13:51:53 - CRIADO
	--->
	<cffunction name='consulta_contrato' displayname='Consulta um contrato na Pamcard' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_consulta_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Consulta realizada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

   <!---
	-- PROPSITO
	-- Reintegrar um contrato Pamcard
	-- fabiog 21/03/2014 09:13:00 - CRIADO
	--->
	<cffunction name='reintegrar_contrato' displayname='Reintegrar um contrato Pamcard' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
        <cfargument name='TOTAL_PARCELA' required='no' default='null'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_reintegrar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'     value='#session.COD_PESSOA#'      null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'    value='#arguments.CONTRATO_ID#'   null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.TOTAL_PARCELA#' null='#iif(len(trim(arguments.TOTAL_PARCELA)), de('no'), de('yes'))#'>
                </cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato integrado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

   <!---
	-- PROPSITO
	-- Cancela um contrato Pamcard.
	-- fabiog 21/03/2014 09:44:25 - CRIADO
	--->
	<cffunction name='cancela_viagem_contrato' displayname='Cancela um contrato Pamcard.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='CANCELAMENTO_MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_cancela_viagem_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CANCELAMENTO_MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato cancelado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

   <!---
	-- PROPSITO
	-- Encerra um contrato Pamcard.
	-- fabiog 21/03/2014 10:57:13 - CRIADO
	--->
	<cffunction name='encerra_contrato' displayname='Encerra um contrato Pamcard.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='ENCERRAMENTO_DATA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_encerra_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ENCERRAMENTO_DATA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato encerrado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

   <!---
	-- PROPSITO
	-- Liberar pagamento de parcela
	-- fabiog 21/03/2014 11:37:14 - CRIADO
	--->
	<cffunction name='altera_status_parcela' displayname='Liberar pagamento de parcela' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='CONTRATO_PARCELA_ID' required='yes'>
		<cfargument name='PARCELA_STATUS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_altera_status_parcela' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_PARCELA_ID#'  null='#iif(len(trim(arguments.CONTRATO_PARCELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PARCELA_STATUS#'  null='#iif(len(trim(arguments.PARCELA_STATUS)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pagamento de parcela liberada com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

   <!---
	-- PROPSITO
	-- Libera o adiantamento
	-- fabiog 21/03/2014 15:55:07 - CRIADO
	--->
	<cffunction name='libera_adiantamento' displayname='Libera o adiantamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='NUMERO_DIAS' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_libera_adiantamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUMERO_DIAS#'  null='#iif(len(trim(arguments.NUMERO_DIAS)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Adiantamento liberado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

   <!---
	-- PROPSITO
	-- Libera o saldo
	-- fabiog 21/03/2014 15:55:07 - CRIADO
	--->
	<cffunction name='libera_saldo' displayname='Libera o adiantamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='NUMERO_DIAS' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_libera_saldo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUMERO_DIAS#'  null='#iif(len(trim(arguments.NUMERO_DIAS)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Saldo liberado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Libera a parcela
	-- fabiog 21/03/2014 15:55:07 - CRIADO
	--->
	<cffunction name='libera_parcela' displayname='Libera a parcea' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_PARCELA_ID' required='yes'>
		<cfargument name='NUMERO_DIAS' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_libera_parcela' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_PARCELA_ID#'  null='#iif(len(trim(arguments.CONTRATO_PARCELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Parcela liberada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Libera a parcela
	-- rafael 30/09/2016 15:55:07 - CRIADO
	--->
	<cffunction name='desbloquear_parcela' displayname='Desbloquear a parcela' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_PARCELA_ID' required='yes'>
		<cfargument name='NUMERO_DIAS' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_desbloquear_parcela' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_PARCELA_ID#'  null='#iif(len(trim(arguments.CONTRATO_PARCELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Parcela desbloqueada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Cancela a parcela
	-- fabiog 21/03/2014 15:55:07 - CRIADO
	--->
	<cffunction name='cancela_parcela' displayname='Cancela a parcela' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_PARCELA_ID' required='yes'>
		<cfargument name='CANCELAMENTO_MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_cancela_parcela' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_PARCELA_ID#'  null='#iif(len(trim(arguments.CONTRATO_PARCELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CANCELAMENTO_MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Parcela cancelada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Alterar o status da parcela para em processo de liberao
	-- FELIPEBUENO 24/12/2014 09:16:01 - CRIADO
	--->
	<cffunction name='solicita_lib_parcela' displayname='Alterar o status da parcela para em processo de liberao' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_PARCELA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_solicita_lib_parcela' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_PARCELA_ID#'  null='#iif(len(trim(arguments.CONTRATO_PARCELA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao de liberao de parcela efetuada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna o status de parcelas pendentes de liberao para Pendente
	-- FELIPEBUENO 24/12/2014 09:18:05 - CRIADO
	--->
	<cffunction name='cancela_solic_lib_parcela' displayname='Retorna o status de parcelas pendentes de liberao para Pendente' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_PARCELA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcard.pkg_integracao.prc_cancela_solic_lib_parcela' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_PARCELA_ID#'  null='#iif(len(trim(arguments.CONTRATO_PARCELA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cancelamento da solicitao de liberao de parcela efetuado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Marca a parcela como Gerou Prejuzo, inserindo um item referente no contrato de transporte, para possibilitar contabilizao de prejuzo.
    -- FELIPEBUENO 09/01/2015 11:07:10 - CRIADO
    --->
    <cffunction name='parcela_prejuizo' displayname='Marca a parcela como Gerou Prejuzo, inserindo um item referente no contrato de transporte, para possibilitar contabilizao de prejuzo.' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTRATO_PARCELA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='pamcard.pkg_integracao.prc_parcela_prejuizo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_PARCELA_ID#'  null='#iif(len(trim(arguments.CONTRATO_PARCELA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Parcela definida como Gerou Prejuzo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

<!---
-- PROPSITO
-- Lanar crdito manual
-- ricardocabral 13/05/2015 16:44:16 - CRIADO
--->
<cffunction name='ins_credito' displayname='Lanar crdito manual' access='remote' returntype='Struct' output='true'>
	<cfargument name='LANCTO_ID' required='yes'>
	<cfargument name='USUARIO_LIBERACAO' required='no'>
	<cfargument name='SENHA_LIBERACAO' required='no'>
	<cfargument name='VALOR' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='oper.pkg_ctransp.prc_ins_credito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO_LIBERACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SENHA_LIBERACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Lanamento realizado com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!---
-- PROPSITO
-- Lanar dbito manual
-- ricardocabral 13/05/2015 16:45:34 - CRIADO
--->
<cffunction name='ins_debito' displayname='Lanar dbito manual' access='remote' returntype='Struct' output='true'>
	<cfargument name='LANCTO_ID' required='yes'>
	<cfargument name='VALOR' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='oper.pkg_ctransp.prc_ins_debito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Lanamento realizado com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

</cfcomponent>
