<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Seta os Parametros do agregado
	-- CRISTOFER  28/12/2005
	--->
	<cffunction name="upd_parametro" access="remote" returntype="struct" description="Altera parmetros ativos.">
	<cfargument name="id" displayname="Identificador do parmetro" type="numeric"  required="true">
	<cfargument name="descricao" displayname="Descrio para o parmetro" type="string"  required="true">
	<cfargument name="valor" displayname="Valor padro para o parmetro" type="numeric"  required="true">
	<cfargument name="status" displayname="Status para o parmetro" type="any" default="0" required="false">
	<cftry>
		<cftransaction action="begin">
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				UPDATE oper.agregado_gestao_padrao 
				   SET descricao = '#arguments.descricao#', 
					   valor = #arguments.valor#, 
					   ativo = #arguments.status# 
				  WHERE ID = #arguments.id#
			</cfquery>
			<cfset retorno.mensagem = 'Alterao feita com sucesso!'>
			<cfset retorno.erro = false>						
			</cftransaction>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
		</cfcatch>
	
	</cftry>
	<cfreturn retorno>
	</cffunction>
  
	<!--- 
	-- PROPSITO
	-- Insere lanamento na conta corrente do agregado
	-- guto 09/02/2006 15:15:54 - CRIADO
	--->
	<cffunction name='ins_lancto_conta_corrente' displayname='Insere lan?amento na conta corrente do agregado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_CONTA' required='yes'>
		<cfargument name='COD_DOCUMENTO' required='yes'>
		<cfargument name='NUM_DOCUMENTO' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='HISTORICO' required='yes'>
		<cfargument name='VALOR_LANCAMENTO' required='yes'>
		<cfargument name='DEB_CRED' required='yes'>
		<cfargument name='FAVORECIDO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ccorrente.prc_insere_lancto_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC'  null="yes" variable='retorno.NUM_LANCAMENTO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_CONTA#'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='1' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_DOCUMENTO#'  null='#iif(len(trim(arguments.COD_DOCUMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_DOCUMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.HISTORICO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_FLOAT'   value='#arguments.VALOR_LANCAMENTO#'  null='#iif(len(trim(arguments.VALOR_LANCAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.DEB_CRED#'  null='#iif(len(trim(arguments.DEB_CRED)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FAVORECIDO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'  null="yes" variable='retorno.ROWID' >
				</cfstoredproc>
				
                <cfif Len(Trim(session.cod_organograma))>
					<cfscript>
                        this.ins_lancto_ccorrente_romaneio(num_romaneio         = arguments.NUM_ROMANEIO,
                                                           num_lancto_ccorrente = retorno.NUM_LANCAMENTO,
                                                          categoria_id 			= arguments.categoria_id,
                                                          cod_organograma       = session.cod_organograma,
                                                          placa                 = arguments.placa);
                    
                    </cfscript>
                <cfelse>
                	<cfthrow detail="Problema com a Lotao do usurio.">
                </cfif> 
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento efetuado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction> 

	<!--- 
	-- PROPSITO
	-- Vincula o lanamento do bonus com o romaneio
	-- guto 05/01/2007 11:09:04 - CRIADO
	--->
	<cffunction name='ins_lancto_ccorrente_romaneio' displayname='Vincula o lanamento do bonus com o romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='NUM_LANCTO_CCORRENTE' required='yes'>
		<cfargument name='CATEGORIA_ID' required='yes'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
		<cfargument name='PLACA' required='yes'>
				<cfstoredproc procedure='oper.pkg_agregado.prc_ins_ccorrente_agregado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_LANCTO_CCORRENTE#'  null='#iif(len(trim(arguments.NUM_LANCTO_CCORRENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CATEGORIA_ID#'  null='#iif(len(trim(arguments.CATEGORIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera dados de lan?amento feito na conta corrente do agregado
	-- guto 09/02/2006 15:42:54 - CRIADO
	--->
	<cffunction name='upd_lancto_conta_corrente' displayname='Altera dados de lan?amento feito na conta corrente do agregado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NUM_LANCAMENTO' required='yes'>
		<cfargument name='COD_CONTA' required='yes'>
		<cfargument name='COD_DOCUMENTO' required='yes'>
		<cfargument name='NUM_DOCUMENTO' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='HISTORICO' required='yes'>
		<cfargument name='VALOR_LANCAMENTO' required='yes'>
		<cfargument name='DEB_CRED' required='yes'>
		<cfargument name='FAVORECIDO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ccorrente.prc_atualiza_lancto_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.NUM_LANCAMENTO#'  null='#iif(len(trim(arguments.NUM_LANCAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_CONTA#'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='1'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_DOCUMENTO#'  null='#iif(len(trim(arguments.COD_DOCUMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_DOCUMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.HISTORICO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_FLOAT'   value='#arguments.VALOR_LANCAMENTO#'  null='#iif(len(trim(arguments.VALOR_LANCAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.DEB_CRED#'  null='#iif(len(trim(arguments.DEB_CRED)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FAVORECIDO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui lanamento da conta corrente.
	-- guto 09/02/2006 15:34:27 - CRIADO
	--->
	<cffunction name='del_lancto_conta_corrente' displayname='Exclui lanamento da conta corrente.' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NUM_LANCAMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ccorrente.prc_excluir_lancto_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.NUM_LANCAMENTO#'  null='#iif(len(trim(arguments.NUM_LANCAMENTO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	 
	
	<!--- 
	-- PROPSITO
	-- Executa o fechamento para a placa
	-- guto 13/02/2006 11:00:57 - CRIADO
	--->
	<cffunction name='fechamento_placa' displayname='Executa o fechamento para a placa' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PLACA' required='yes'>
		<cfargument name='MES_FECHAMENTO' required='yes'>
		<cfargument name='ANO_FECHAMENTO' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_agregado.prc_fechamento_placa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.MES_FECHAMENTO#'  null='#iif(len(trim(arguments.MES_FECHAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ANO_FECHAMENTO#'  null='#iif(len(trim(arguments.ANO_FECHAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_PESSOA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_FLOAT'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fechamento executado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Reabre o fechamento para a placa
	-- guto 13/02/2006 11:00:57 - CRIADO
	--->
	<cffunction name='reabre_acerto_agregado' displayname='Executa o fechamento para a placa' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FECHAMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
			    <cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    	delete oper.v$agregado_fechamento 
					 where fechamento_id = #val(arguments.fechamento_id)#
			    </cfquery>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fechamento reaberto com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Executa o fechamento (confimao) para o ms, faz os lanamentos financeiros
	-- guto 13/02/2006 11:24:05 - CRIADO
	--->
	<cffunction name='agregado_fechamento_mes' displayname='Executa o fechamento (confima??o) para o m?s, faz os lan?amentos financeiros' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FECHAMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_agregado.prc_fechamento_mes' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.FECHAMENTO_ID#'  null='#iif(len(trim(arguments.FECHAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fechamento confirmado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!--- 
	-- PROPSITO
	-- Altera parmetro para o agregado
	-- guto 13/02/2006 11:24:05 - CRIADO
	--->
	<cffunction name="upd_parametros" access="remote" returntype="struct" description="Altera parmetros ativos.">
		<cfargument name="id" required="yes" />
		<cfargument name="valor" required="yes" />
		<cfargument name="data_vigencia_antiga" required="yes" />
		<cfargument name="data_vigencia" required="yes" />
		<cfargument name="cod_pessoa" required="yes" />

		<cfif arguments.data_vigencia eq 'Geral'>
		  <cfset arguments.data_vigencia = DateFormat(Now(),'dd/mm/yyyy')>
		</cfif>
		<cftry>
		  <cftransaction action='begin'>
			  <cfquery datasource="#session.dsn#" name="qrParametro" username="#session.usuario#" password="#session.senha#">
				  select data_vigencia 
					from oper.v$agregado_gestao_individual 
					where id = #arguments.id# 
					and cod_pessoa = #arguments.cod_pessoa# 
					and trunc(data_vigencia) = '#arguments.data_vigencia_antiga#'
			  </cfquery>
			
			  <cfquery datasource="#session.dsn#" name="qrParametroPadrao" username="#session.usuario#" password="#session.senha#">
					select tipo_valor_id, valor
					  from oper.v$agregado_gestao_padrao
					  where id = #arguments.id# 
			  </cfquery>
			  
			  <cfswitch expression="#qrParametroPadrao.tipo_valor_id#">
				  <cfcase value="1">
					 <cfset v_valor = ((arguments.valor*100)/qrParametroPadrao.valor) - 100>
				  </cfcase>
				  <cfcase value="2">
					 <cfset v_valor = arguments.valor />
				  </cfcase>
				  <cfcase value="3">
					 <cfset v_valor = arguments.valor />
				  </cfcase>
			  </cfswitch>
			  <cfif qrParametro.RecordCount GT 0>
				<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					update oper.v$agregado_gestao_individual 
					   set percentual = #v_valor#,
						   data_vigencia = '#arguments.data_vigencia#'
					 where ID = #arguments.id# and cod_pessoa = #arguments.cod_pessoa#
				</cfquery>
				<cfelse>
				<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					insert into oper.v$agregado_gestao_individual 
						(cod_pessoa, id, data_vigencia, percentual) 
					values 
						(#arguments.cod_pessoa#, #arguments.id#, '#arguments.data_vigencia#', #v_valor# )
				</cfquery>
			  </cfif>
			  <cfset retorno.mensagem = 'Alterao feita com sucesso.'>
			  <cfset retorno.erro = false>
			 </cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
            
    <!--- 
    -- PROPSITO
    -- Insere uma viagem de Agregado
    -- cristofer 16/04/2008 08:48:34 - CRIADO
    --->
    <cffunction name='ins_viagem' displayname='Insere uma viagem de Agregado' access='remote' returntype='Struct' output='true'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='no'  default="">
        <cfargument name='COD_PESSOA_AGREGADO' required='yes'>
        <cfargument name='PLACA_CONTROLE' required='yes'>
        <cfargument name='PLACA_REFERENCIA' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='NUM_EIXOS' required='yes'>
        <cfargument name='MUNICIPIO_ID_ORIGEM' required='yes'>
        <cfargument name='MUNICIPIO_ID_DESTINO' required='yes'>
        <cfargument name='TIPO_SERVICO' required='yes'>
        <cfargument name='VALOR_SERVICO' required='yes'>
        <cfargument name='VALOR_CARGA' required='yes'>
        <cfargument name='VALOR_DESCARGA' required='yes'>
        <cfargument name='VALOR_PEDAGIO' required='yes'>
        <cfargument name='VALOR_PEDAGIO_SEMPARAR' required='yes'>
        <cfargument name='VALOR_ADIANTAMENTO' required='yes'>
        <cfargument name='ADTO_PEDAGIO' required='no' default="0">
        <cfargument name='ADTO_CARGA' required='no' default="0">
        <cfargument name='ADTO_DESCARGA' required='no' default="0">
        <cfargument name='CARGA_ID_COLETA' required='no' default="">
        <cfargument name='CARGA_ID_ENTREGA' required='no' default="">
        <cfargument name='TOTAL_PARCELAS' required='no' default="">
        <cfargument name='SERIE_FORMULARIO' required='no' default="U">
        <cfargument name='OBSERVACAO' required='no' default="">
        <cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
        <cfargument name='CTRC_ID' required='no' default="">
        <cfargument name='CRT_ID' required='no' default="">
        <cfif not len(trim(arguments.adto_pedagio))>
        	<cfset arguments.adto_pedagio = 0>
        </cfif>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_agreg.prc_ins_viagem_web' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VIAGEM_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_AGREGADO#'  null='#iif(len(trim(arguments.COD_PESSOA_AGREGADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CONTROLE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_REFERENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_EIXOS#'  null='#iif(len(trim(arguments.NUM_EIXOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MUNICIPIO_ID_ORIGEM#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MUNICIPIO_ID_DESTINO#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_SERVICO#'  null='#iif(len(trim(arguments.TIPO_SERVICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_CARGA#'  null='#iif(len(trim(arguments.VALOR_CARGA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_DESCARGA#'  null='#iif(len(trim(arguments.VALOR_DESCARGA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_PEDAGIO#'  null='#iif(len(trim(arguments.VALOR_PEDAGIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_PEDAGIO_SEMPARAR#'  null='#iif(len(trim(arguments.VALOR_PEDAGIO_SEMPARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ADIANTAMENTO#'  null='#iif(len(trim(arguments.VALOR_ADIANTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ADTO_PEDAGIO#'  null='#iif(len(trim(arguments.ADTO_PEDAGIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ADTO_CARGA#'  null='#iif(len(trim(arguments.ADTO_CARGA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ADTO_DESCARGA#'  null='#iif(len(trim(arguments.ADTO_DESCARGA)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.PERCURSO_ID_PAI' >
                    <cfif session.site eq 'rodomar/' or session.site eq 'bbm/'>
	                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CTRC_ID#'  null='#iif(len(trim(arguments.CTRC_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CRT_ID#'  null='#iif(len(trim(arguments.CRT_ID)), de('no'), de('yes'))#'>
                    </cfif>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
				
                
                <cfscript>
                    v_percurso_id = this.ListaToArray (lista = arguments, variavel = "PERCURSO_ID_PERCURSOS");
                    v_rota_id = this.ListaToArray (lista = arguments, variavel = "PERCURSOS_ROTA_ID_PERCURSOS");
                    v_pedagio_eixo = this.ListaToArray (lista = arguments, variavel = "PERCURSOS_PEDAGIO_EIXO_PERCURSOS");
                    v_pedagio_fixo = this.ListaToArray (lista = arguments, variavel = "PERCURSOS_PEDAGIO_FIXO_PERCURSOS");
                    v_pedagio_semparar_fixo = this.ListaToArray (lista = arguments, variavel = "PERCURSOS_PEDAGIO_SEMPARAR_FIXO_PERCURSOS");
                    v_pedagio_semparar_eixo = this.ListaToArray (lista = arguments, variavel = "PERCURSOS_PEDAGIO_SEMPARAR_EIXO_PERCURSOS");
                    v_km = this.ListaToArray (lista = arguments, variavel = "PERCURSOS_KM_PERCURSOS");
                    v_previsao_chegada = this.ListaToArray (lista = arguments, variavel = "PERCURSOS_PREVISAO_CHEGADA_PERCURSOS");
                    v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_PERCURSOS, lista2 = ArrayToList(v_percurso_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="l_id">
                    <cfscript>
                        ret = this.del_viagem_percurso (	percurso_id = l_id);
                    </cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfloop from="1" to="#ArrayLen(v_rota_id)#" index="count">
                    <cfscript>
                    if(not len(trim(v_percurso_id[count]))) {
                        //caso o item_id seja nulo insere
                        ret = this.ins_viagem_percurso(
													viagem_id				= retorno.viagem_id,
													rota_id					= v_rota_id[count],
													pedagio_eixo			= v_pedagio_eixo[count],
													pedagio_eixo_semparar	= v_pedagio_semparar_eixo[count],
													pedagio_fixo			= v_pedagio_fixo[count],
													pedagio_fixo_semparar	= v_pedagio_semparar_fixo[count],
													km						= v_km[count],
													previsao_chegada		= v_previsao_chegada[count],
													percurso_id_pai			= retorno.percurso_id_pai);
                    } else {
                        ret = this.upd_viagem_percurso(
													percurso_id				= v_percurso_id[count],
													viagem_id				= retorno.viagem_id,
													rota_id					= v_rota_id[count],
													pedagio_eixo			= v_pedagio_eixo[count],
													pedagio_eixo_semparar	= v_pedagio_semparar_eixo[count],
													pedagio_fixo			= v_pedagio_fixo[count],
													pedagio_fixo_semparar	= v_pedagio_semparar_fixo[count],
													km						= v_km[count],
													previsao_chegada		= v_previsao_chegada[count],
													percurso_id_pai			= retorno.percurso_id_pai);
                    }
                    </cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    <cfelse>
                    	<cfset retorno.percurso_id_pai = ret.percurso_id>
                    </cfif>
                </cfloop>	 
                
                <cfif arguments.tipo_servico eq 6>
                    <cfloop list="#arguments.carga_Id_coleta#" delimiters="," index="v_carga_id">
                        <cfscript>
                            ret = this.vincula_carga(viagem_id = retorno.viagem_id
                                                    ,carga_id  = v_carga_id
													,operacao_id = 1);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>


                    <cfloop list="#arguments.carga_Id_entrega#" delimiters="," index="v_carga_id">
                        <cfscript>
                            ret = this.vincula_carga(viagem_id = retorno.viagem_id
                                                    ,carga_id  = v_carga_id
													,operacao_id = 2);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>
                </cfif>
                
                <cfscript>
					ret = this.validar_viagem(  viagem_id		= retorno.viagem_id,
												gerar_cfa		= arguments.remunerado,
												num_formulario	= arguments.num_cfa,
												serie_formulario = arguments.serie_formulario,
												total_parcelas  = arguments.total_parcelas,
												cod_organograma_gerencial = arguments.cod_organograma_gerencial);
				</cfscript>
                
                <cfif ret.erro>
                	<cfthrow object="#ret.mensagem#">
                <cfelse>
                	<cfset retorno.lancto_Id = ret.lancto_id>
                </cfif>
				
                <cfif session.site eq 'transemba/'>
                <!---Vincula ao CTRC--->
					<cfif not len(trim(arguments.conhecimento_id))>
                        <!--- Busca os dados do conhecimento pelo formulario --->
                        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                            select conhecimento_id
                              from fiscal.v$conhecimento
                             where num_conhecimento = #arguments.num_cfa#
                        </cfquery>
                        <cfset arguments.conhecimento_id = qr_result.conhecimento_id>
                    </cfif>
                    
					<cfscript>
                        conn = CreateComponent("modulos.contratotransp._componentes.manipulacao.cfc_contrato_transporte");
                        set_vinculo = conn.ins_vinculo_contrato_conhecimento(lancto_id = retorno.LANCTO_ID,
                                                                             conhecimento_id = arguments.conhecimento_id);
                    </cfscript>
                    <cfif set_vinculo.erro>
                        <cfthrow object="#set_vinculo.mensagem#">
                    </cfif>
                </cfif>    
            </cftransaction>
            
            <cfscript>
				conn = CreateComponent("modulos.contratotransp._componentes.manipulacao.cfc_contrato_transporte");
				set_email = conn.enviar_email_aprovacao(lancto_id = retorno.LANCTO_ID);
			</cfscript>
            
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Viagem inserida com sucesso.')>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere um percurso de uma viagem de Agregado
    -- cristofer 16/04/2008 09:12:08 - CRIADO
    --->
    <cffunction name='ins_viagem_percurso' displayname='Insere um percurso de uma viagem de Agregado' access='remote' returntype='Struct' output='true'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cfargument name='ROTA_ID' required='yes'>
        <cfargument name='PEDAGIO_EIXO' required='yes'>
        <cfargument name='PEDAGIO_EIXO_SEMPARAR' required='yes'>
        <cfargument name='PEDAGIO_FIXO' required='yes'>
        <cfargument name='PEDAGIO_FIXO_SEMPARAR' required='yes'>
        <cfargument name='KM' required='yes'>
        <cfargument name='PREVISAO_CHEGADA' required='yes'>
        <cfargument name='PERCURSO_ID_PAI' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_agreg.prc_ins_percurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.PERCURSO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO_EIXO#'  null='#iif(len(trim(arguments.PEDAGIO_EIXO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO_EIXO_SEMPARAR#'  null='#iif(len(trim(arguments.PEDAGIO_EIXO_SEMPARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO_FIXO#'  null='#iif(len(trim(arguments.PEDAGIO_FIXO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO_FIXO_SEMPARAR#'  null='#iif(len(trim(arguments.PEDAGIO_FIXO_SEMPARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM#'  null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PREVISAO_CHEGADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERCURSO_ID_PAI#'  null='#iif(len(trim(arguments.PERCURSO_ID_PAI)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Percurso inserido com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
        
    <!--- 
    -- PROPSITO
    -- Altera um percurso de uma viagem de Agregado
    -- cristofer 16/04/2008 09:23:50 - CRIADO
    --->
    <cffunction name='upd_viagem_percurso' displayname='Altera um percurso de uma viagem de Agregado' access='remote' returntype='Struct' output='true'>
        <cfargument name='PERCURSO_ID' required='yes'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cfargument name='ROTA_ID' required='yes'>
        <cfargument name='PEDAGIO_EIXO' required='yes'>
        <cfargument name='PEDAGIO_EIXO_SEMPARAR' required='yes'>
        <cfargument name='PEDAGIO_FIXO' required='yes'>
        <cfargument name='PEDAGIO_FIXO_SEMPARAR' required='yes'>
        <cfargument name='KM' required='yes'>
        <cfargument name='PREVISAO_CHEGADA' required='yes'>
        <cfargument name='PERCURSO_ID_PAI' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_agreg.prc_alt_percurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERCURSO_ID#'  null='#iif(len(trim(arguments.PERCURSO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO_EIXO#'  null='#iif(len(trim(arguments.PEDAGIO_EIXO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO_EIXO_SEMPARAR#'  null='#iif(len(trim(arguments.PEDAGIO_EIXO_SEMPARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO_FIXO#'  null='#iif(len(trim(arguments.PEDAGIO_FIXO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO_FIXO_SEMPARAR#'  null='#iif(len(trim(arguments.PEDAGIO_FIXO_SEMPARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM#'  null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PREVISAO_CHEGADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERCURSO_ID_PAI#'  null='#iif(len(trim(arguments.PERCURSO_ID_PAI)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Percurso alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
        
    <!--- 
    -- PROPSITO
    -- Exclui um percurso de uma viagem de Agregado
    -- cristofer 16/04/2008 09:28:32 - CRIADO
    --->
    <cffunction name='del_viagem_percurso' displayname='Exclui um percurso de uma viagem de Agregado' access='remote' returntype='Struct' output='true'>
        <cfargument name='PERCURSO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_agreg.prc_del_percurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERCURSO_ID#'  null='#iif(len(trim(arguments.PERCURSO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Percurso excluido com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
        
    <!--- 
    -- PROPSITO
    -- Valida uma viagem de agregado
    -- cristofer 16/04/2008 09:38:20 - CRIADO
    --->
    <cffunction name='validar_viagem' displayname='Valida uma viagem de agregado' access='remote' returntype='Struct' output='true'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cfargument name='GERAR_CFA' required='yes'>
        <cfargument name='NUM_FORMULARIO' required='yes'>
        <cfargument name='SERIE_FORMULARIO' required='yes' default="U">
        <cfargument name='TOTAL_PARCELAS' required='no' default="">
        <cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_agreg.prc_validar_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GERAR_CFA#'  null='#iif(len(trim(arguments.GERAR_CFA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_PARCELAS#'  null='#iif(len(trim(arguments.TOTAL_PARCELAS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.COD_ORGANOGRAMA_GERENCIAL#'  null='#iif(len(trim(arguments.COD_ORGANOGRAMA_GERENCIAL)), de('no'), de('yes'))#'>
					<cfif session.site eq 'transemba/'>
	                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.SERIE_FORMULARIO#'  null='#iif(len(trim(arguments.SERIE_FORMULARIO)), de('no'), de('yes'))#'>
                    </cfif>
                </cfstoredproc>
                <cfquery name="qr_result" datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                	select lancto_id
                      from oper.v$agreg_viagem
                     where viagem_id = #arguments.viagem_id#
                </cfquery>
                <cfset retorno.lancto_id = qr_result.lancto_id>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Viagem validada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
    -- PROPSITO
    -- Vincula uma carga  viagem de agregado
    -- cristofer 24/04/2008 15:40:45 - CRIADO
    --->
    <cffunction name='vincula_carga' displayname='Vincula uma carga  viagem de agregado' access='remote' returntype='Struct' output='true'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cfargument name='CARGA_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_agreg.prc_vincula_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Carga vinculada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Desvincula uma carga  viagem de agregado
    -- cristofer 24/04/2008 15:40:45 - CRIADO
    --->
    <cffunction name='desvincula_carga' displayname='Desvincula uma carga  viagem de agregado' access='remote' returntype='Struct' output='true'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cfargument name='CARGA_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_agreg.prc_desvincula_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Carga desvinculada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


    <!--- 
    -- PROPSITO
    -- Cancela uma viagem de Agregado
    -- cristofer 16/04/2008 08:48:34 - CRIADO
    --->
    <cffunction name='cancelar_viagem' displayname='Cancela uma viagem de Agregado' access='remote' returntype='Struct' output='true'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_agreg.prc_cancelar_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Viagem cancelada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Marca uma CFA como impressa
    -- cristofer 28/04/2008 09:57:24 - CRIADO
    --->
    <cffunction name='imprimir_cfa' displayname='Marca uma CFA como impressa' access='remote' returntype='Struct' output='true'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_agreg.prc_imprimir_cfa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('CFA impressa com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere um despacho da viagem
    -- cristofer 03/02/2009 09:53:19 - CRIADO
    --->
    <cffunction name='ins_viagem_despacho' displayname='Insere um despacho da viagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='GERAR_CFA' required='yes'>
        <cfargument name='NUM_FORMULARIO' required='yes'>
        <cfargument name='VALOR_SERVICO' required='yes'>
        <cfargument name='VALOR_ADIANTAMENTO' required='yes'>
        <cfargument name='CANCELAR_VIAGEM' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_agreg.prc_ins_viagem_despacho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GERAR_CFA#'  null='#iif(len(trim(arguments.GERAR_CFA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ADIANTAMENTO#'  null='#iif(len(trim(arguments.VALOR_ADIANTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CANCELAR_VIAGEM#'  null='#iif(len(trim(arguments.CANCELAR_VIAGEM)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Despacho inserido com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	<!--- 
    -- PROPSITO
    -- Inserir tipo de custo
    -- LEOPOLDOS 25/08/2010 09:55:19 - CRIADO
    --->
    <cffunction name='ins_agreg_custo_tipo' displayname='Inserir tipo de custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_agreg.prc_ins_agreg_custo_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CUSTO_TIPO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de custo inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    <!--- 
	-- PROPSITO
	-- Alterar tipo de custo
	-- LEOPOLDOS 25/08/2010 09:56:22 - CRIADO
	--->
	<cffunction name='upd_agreg_custo_tipo' displayname='Alterar tipo de custo' access='remote' returntype='Struct' output='true'>
		<cfargument name='CUSTO_TIPO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_agreg.prc_alt_agreg_custo_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CUSTO_TIPO_ID#'  null='#iif(len(trim(arguments.CUSTO_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de custo alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!--- 
	-- PROPSITO
	-- Deletar tipo de custo.
	-- LEOPOLDOS 25/08/2010 14:18:06 - CRIADO
	--->
	<cffunction name='del_agreg_custo_tipo' displayname='Deletar tipo de custo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CUSTO_TIPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_agreg.prc_del_agreg_custo_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CUSTO_TIPO_ID#'  null='#iif(len(trim(arguments.CUSTO_TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Custo deletado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!--- 
	-- PROPSITO
	-- Inserir custo por agregado
	-- LEOPOLDOS 25/08/2010 15:51:06 - CRIADO
	--->
	<cffunction name='ins_agreg_custo_pessoa' displayname='Inserir custo por agregado' access='remote' returntype='Struct' output='true'>
		<cfargument name='FROTA' required='yes'>
		<cfargument name='CUSTO_TIPO_ID' required='yes'>
		<cfargument name='DATA_VIGENCIA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_agreg.prc_ins_agreg_custo_pessoa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CUSTO_PESSOA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CUSTO_TIPO_ID#'  null='#iif(len(trim(arguments.CUSTO_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VIGENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Custo inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!--- 
	-- PROPSITO
	-- Alterar custo por agregado
	-- LEOPOLDOS 25/08/2010 15:51:58 - CRIADO
	--->
	<cffunction name='upd_agreg_custo_pessoa' displayname='Alterar custo por agregado' access='remote' returntype='Struct' output='true'>
		<cfargument name='CUSTO_PESSOA_ID' required='yes'>
		<cfargument name='FROTA' required='yes'>
		<cfargument name='CUSTO_TIPO_ID' required='yes'>
		<cfargument name='DATA_VIGENCIA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_agreg.prc_alt_agreg_custo_pessoa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CUSTO_PESSOA_ID#'  null='#iif(len(trim(arguments.CUSTO_PESSOA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CUSTO_TIPO_ID#'  null='#iif(len(trim(arguments.CUSTO_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VIGENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Custo alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!--- 
	-- PROPSITO
	-- Deletar custo por agregado
	-- LEOPOLDOS 25/08/2010 15:53:15 - CRIADO
	--->
	<cffunction name='del_agreg_custo_pessoa' displayname='Deletar custo por agregado' access='remote' returntype='Struct' output='true'>
		<cfargument name='CUSTO_PESSOA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_agreg.prc_del_agreg_custo_pessoa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CUSTO_PESSOA_ID#'  null='#iif(len(trim(arguments.CUSTO_PESSOA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Custo deletado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
<!--- 
-- PROPSITO
-- Inserir lanamento de de pagamento/recebimento de agregado
-- ERICG 09/11/2010 18:49:05 - CRIADO
--->
<cffunction name='ins_lancto_solicit' displayname='Inserir lanamento de de pagamento/recebimento de agregado' access='remote' returntype='Struct' output='true'>
	<cfargument name='PLACA_CONTROLE' required='yes'>
	<cfargument name='COD_PESSOA_AGREGADO' required='yes'>
	<cfargument name='DEB_CRED' required='yes'>
	<cfargument name='CONFIG_ID' required='yes'>
	<cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
	<cfargument name='VALOR' required='yes'>
	<cfargument name='NUM_PARCELA' required='yes'>
	<cfargument name='TOTAL_PARCELA' required='yes'>
	<cfargument name='VALOR_PARCELAMENTO' required='yes'>
	<cfargument name='DESCRICAO' required='yes'>
	<cfargument name='DATA_LANCAMENTO' required='yes'>
	<cfargument name='DATA_VENCIMENTO' required='yes'>
	<cfargument name='OBSERVACAO' required='yes'>
	<cfargument name='LANCAMENTO_ID' required='yes'>
	<cfargument name='RPA_ID' required='yes'>
	<cfargument name='DATA_CANCELAMENTO' required='yes'>
	<cfargument name='USUARIO_CANCELAMENTO' required='yes'>
	<cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
	<cfargument name='DATA_APROVACAO' required='yes'>
	<cfargument name='USUARIO_APROVACAO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='oper.pkg_agreg.prc_ins_lancto_solicit' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.SOLICITACAO_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CONTROLE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_AGREGADO#'  null='#iif(len(trim(arguments.COD_PESSOA_AGREGADO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEB_CRED#'  null='#iif(len(trim(arguments.DEB_CRED)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONFIG_ID#'  null='#iif(len(trim(arguments.CONFIG_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA_GERENCIAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_PARCELA#'  null='#iif(len(trim(arguments.NUM_PARCELA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_PARCELA#'  null='#iif(len(trim(arguments.TOTAL_PARCELA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_PARCELAMENTO#'  null='#iif(len(trim(arguments.VALOR_PARCELAMENTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_LANCAMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VENCIMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RPA_ID#'  null='#iif(len(trim(arguments.RPA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CANCELAMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO_CANCELAMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO_CANCELAMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_APROVACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO_APROVACAO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Lanamento inserido com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>    
</cfcomponent>
