<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Retorna a relao de veiculos ativos na data
	-- NOTAS EXPLICATIVAS
	-- 13/01/2006 - criado
	--->
	<cffunction name="get_veiculos_ativos" access="remote" returntype="query" output="true">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_veiculos" username="#session.usuario#" password="#session.senha#">
            select decode(vl.empresa, 1, 'Frota', 'agregado') as proprietario
                 , vl.placa
                 , vl.marca
                 , vl.modelo
                 , vl.combustivel
              from (select (substr(v.placa, 1, 3) || '-' || substr(v.placa, 4, 7)) as placa
                         , vm.marca
                         , vmod.modelo
                         , pp.descricao as combustivel
                         , vfg.empresa
                      from (select vt.tipo_carroceria_id as tipo_id
                                 , vt.descricao as tipo
                                 , vc.articulado as articulado
                              from oper.v$veiculo_tipo_carroceria vt
                             inner join oper.v$veiculo_agrupamento vc
                                     on vt.agrupamento_id = vc.agrupamento_id
                             where vc.tracao = 1
                               and vc.controla = 1) vt
                     inner join oper.v$veiculo_dados v
                             on v.tipo_carroceria_id = vt.tipo_id
                     inner join oper.v$veiculo_marca vm
                             on vm.marca_id = v.marca_id
                     inner join oper.v$veiculo_modelo vmod
                             on vmod.marca_id = v.marca_id
                            and vmod.modelo_id = v.modelo_id
                     inner join oper.v$veiculo_frota_geral vfg
                             on vfg.placa = v.placa,
                     oper.v$posto_produto pp
                     where pp.produto_id in (1)
                       and pp.ativo <> 2
                       and v.situacao_id = 1
                     order by vm.marca, vmod.modelo) vl
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and replace(upper(vl.placa), '-', '') = replace(upper('#arguments.placa#'), '-', '')
            </cfif>
			<cfif Len(Trim(arguments.cod_veiculo))>
               and upper(vl.cod_veiculo) like upper('#arguments.cod_veiculo#%')
            </cfif>
  		</cfquery>	
		<cfreturn qr_veiculos>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca classificao
	-- NOTAS EXPLICATIVAS
	-- GUTO 17/07/2006
	--->
	<cffunction name="get_classificacao" access="remote" returntype="query" output="true">
		<cfargument name="agrupamento_id" required="no" default="">
		<cfargument name="tipo_carroceria_id" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select va.agrupamento_id, 
            	   va.num_agrupamento, 
                   va.descricao as agrupamento,
                   vc.tipo_carroceria_id, 
                   vc.num_tipo_carroceria, 
                   vc.descricao as classificacao
              from oper.v$veiculo_tipo_carroceria vc
             inner join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vc.agrupamento_id
               where 1=1
               <cfif Len(Trim(arguments.agrupamento_id))>
               	 and va.agrupamento_id = any(#arguments.agrupamento_id#)
               </cfif>
               <cfif Len(Trim(arguments.tipo_carroceria_id))>
               	 and va.tipo_carroceria_id = #arguments.tipo_carroceria_id#
               </cfif>
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca CENTRO DE CUSTO do veiculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2008
	--->
	<cffunction name="get_centro_custo_veiculo" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="no" default="">
		<cfargument name="data" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select vcc.placa, vcc.data, cc.cod_centro_custo, cc.centro_custo
              from oper.v$veiculo_ccusto_todos vcc
                inner join kss.v$centro_custo cc
                        on cc.cod_centro_custo = vcc.cod_centro_custo
             where vcc.data_cancelamento is null
               and vcc.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
               and vcc.data = (select max(vcc2.data) 
                                   from oper.v$veiculo_ccusto_todos vcc2
                                  where vcc2.data_cancelamento is null
                                    and vcc2.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
				                <cfif Len(Trim(arguments.data))>
                                    and vcc2.data <= '#arguments.data#')
               					<cfelse>
                                    and vcc2.data <= sysdate)
								</cfif>
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_localizar" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="tipo" required="no" default="">
        <cfargument name="valor" required="no" default="">
        <cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
        <cfargument name="trazer_proprietario" required="no" default="1">
        <cfargument name="trazer_agrupamento_id" required="no" default="0">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select * from (select distinct vd.placa,
							vd.cod_veiculo,
                            vd.veiculo_id,
							vd.marca_id,
							ma.marca,
							vd.modelo_id,
                            <cfif arguments.trazer_agrupamento_id eq 1>
								tpc.agrupamento_id,
							</cfif>
                            vd.tipo_carroceria_id,
							vd.uf,
							md.modelo,
                            <cfif arguments.trazer_proprietario eq 1>
                            	oper.pkg_veiculo.fnc_veiculo_proprietario(vd.placa) as proprietario,
							</cfif>
							vd.observacao,
							vd.cor_predominante,
							vd.ano,
							vd.chassis,
							vd.renavan, /* Relacionado ao pessoa_atributo */
                            vd.capacidade_tanque,
							oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TARA') as tara,
							oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao /* Relacionado ao pessoa_atributo */
			  from oper.v$veiculo vd
			 inner join oper.v$veiculo_modelo md
					 on md.modelo_id = vd.modelo_id
					and md.marca_id  = vd.marca_id
			 inner join oper.v$veiculo_marca ma
					 on ma.marca_id  = vd.marca_id
			<cfif arguments.trazer_agrupamento_id eq 1>
			 inner join oper.v$veiculo_tipo_carroceria tpc
             		 on tpc.tipo_carroceria_id = vd.tipo_carroceria_id
			</cfif>
	          left join oper.v$veiculo_proprietario vp on vp.placa = vd.placa
   			   and vp.data_fim is null
             where 1 = 1
			<cfif Len(Trim(arguments.tipo))>
            	<cfif arguments.tipo eq 1>
					and upper(vd.cod_veiculo) like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 2>
                	and upper(vd.placa) like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 3>
                	and upper(vd.renavan) like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 4>
                	and upper(ma.marca) like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 5>
                	and upper(md.modelo) like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 6>
                	and upper(vd.uf) like upper('%#arguments.valor#%')
                </cfif>
            </cfif>
			<cfif Len(Trim(arguments.placa))>
			   and upper(vd.placa) like upper('%#arguments.placa#%')
			</cfif>		
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vd.cod_veiculo) like upper('%#arguments.cod_veiculo#%')
			</cfif>		
			<cfif Len(Trim(arguments.proprietario))>
			</cfif>
			<cfif Len(Trim(arguments.frota))>
			   and (vd.placa like upper('%'||'#arguments.frota#%')
			       or vd.cod_veiculo like upper('%'||'#arguments.frota#%'))
			</cfif>	)vd	
			 where 1 = 1
			<cfif Len(Trim(arguments.proprietario))>
			   and oper.pkg_veiculo.fnc_veiculo_proprietario(vd.placa) in (#arguments.proprietario#)
			</cfif>
			 order by vd.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>		

    <!--- 
	-- PROPSITO
	-- Retorna todos os modelos de veculos cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_modelos" displayname="Retorna todos os modelos de veculos cadastradas" output="true" returntype="query" access="remote">
		<cfargument name="marca_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select vm.marca_id, vm.modelo_id, vm.modelo
			  from oper.v$veiculo_modelo vm
             where 1=1			  
			<cfif Len(Trim(arguments.marca_id))>
			   and marca_id = #arguments.marca_id#
			</cfif>		
			order by modelo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
    
    
	<!--- 
	-- PROPSITO
	-- Retorna dados do proprietrio do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_proprietario" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa, 
             		p.cliente as nome, 
                    p.cnpj_cpf, 
                    p.identificador, 
                    to_char(vp.data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio, 
                    vp.cod_pessoa,
		 		    v.chassis, 
                    m.marca, 
                    v.ano,
       				pe.logradouro||' '||pe.numero as endereco,
			        pe.municipio as municipio_uf

	     from oper.v$veiculo v
		  left join oper.v$veiculo_marca m
				 on m.marca_id = v.marca_id
		  left join oper.v$veiculo_modelo md
				 on md.marca_id = v.marca_id
				and md.modelo_id = v.modelo_id
		 inner join oper.v$veiculo_proprietario vp
				 on vp.placa = v.placa
				and vp.data_fim is null 
		 inner join kss.v$pessoa p
				 on p.cod_pessoa = vp.cod_pessoa
         inner join kss.v$pessoa_endereco pe on pe.cod_pessoa = p.cod_pessoa
                                    and pe.endereco_padrao = 1        
			  where 1=1				  
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = upper('#arguments.placa#')
			</cfif>		
            
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Retorna dados do proprietrio do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_proprietario_doc" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="public">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa, 
             		p.cliente as nome, 
                    p.cnpj_cpf, 
                    p.identificador, 
                    vp.data_inicio, 
                    vp.cod_pessoa,
		 		    v.chassis, 
                    m.marca, 
                    v.ano
	           from oper.v$veiculo v
		  left join oper.v$veiculo_marca m
				 on m.marca_id = v.marca_id
		  left join oper.v$veiculo_modelo md
				 on md.marca_id = v.marca_id
				and md.modelo_id = v.modelo_id
		 inner join oper.v$veiculo_proprietario_doc vp
				 on vp.placa = v.placa
				and vp.data_fim is null 
		 inner join kss.v$pessoa p
				 on p.cod_pessoa = vp.cod_pessoa
        
			  where 1=1				  
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = upper('#arguments.placa#')
			</cfif>
            
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>	


    
	<!--- 
	-- PROPSITO
	-- Retorna dados do permissionario do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_permissionario" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="public">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.placa,
                   p.cliente as nome,
                   p.razao_social,
                   p.cnpj_cpf,
                   p.identificador,
                   vp.data_inicio,
                   vp.cod_pessoa,
                   v.chassis,
                   m.marca,
                   v.ano,
                   oper.pkg_veiculo.fnc_capacidade_carga_compo(v.placa, sysdate) as capacidade,
                   pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero ||
                   decode(pe.complemento, '', '', ' - ') || pe.complemento endereco,
                   pe.municipio as local,
                   pe.uf,
                   pe.municipio_id,
                   pe.municipio as municipio_uf,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 6) as permisso_numero,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 7) as permisso_data,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 8) as apolice_numero,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9) as apolice_vencimento,
                   oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'TARA') as tara,
                   oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'CAPACIDADE_TRACAO') as capacidade_tracao,
                   trunc(to_date(decode(kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9), '0', to_char(sysdate, 'dd/mm/yyyy'), kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9)), 'dd/mm/yyyy') - sysdate) as dias_venc_apolice
              from oper.v$veiculo v
             inner join oper.v$veiculo_permissionario vp
                     on vp.placa = v.placa
                    and vp.data_fim is null
             inner join kss.v$pessoa p
                     on p.cod_pessoa = vp.cod_pessoa
              left join kss.v$pessoa_endereco pe
                     on pe.cod_pessoa = vp.cod_pessoa
                    and pe.endereco_padrao = 1
              left join oper.v$veiculo_marca m
                     on m.marca_id = v.marca_id
              left join oper.v$veiculo_modelo md
                     on md.marca_id = v.marca_id
                    and md.modelo_id = v.modelo_id
             where 1 = 1
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = oper.pkg_veiculo.fnc_get_placa(upper('#arguments.placa#'))
			</cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna dados do proprietrio do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_motorista" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa,
                   p.cliente as nome,
                   p.cnpj_cpf,
                   p.identificador,
                   to_char(vp.data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio,
                   vp.cod_pessoa,
                   v.chassis,
                   m.marca,
                   v.ano,
                   pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento endereco,
                   pe.municipio as local,
                   pe.uf as municipio_uf,
                   pe.municipio_id,
                   pf.cart_ident_num,
                   pf.cart_ident_orgao
              from oper.v$veiculo v
              left join oper.v$veiculo_marca m 
                     on m.marca_id = v.marca_id
              left join oper.v$veiculo_modelo md 
                     on md.marca_id = v.marca_id
                    and md.modelo_id = v.modelo_id
             inner join oper.v$veiculo_motorista vp 
                     on vp.placa = v.placa
                    and vp.data_fim is null
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = vp.cod_pessoa
             inner join kss.v$pessoa_fisica pf
                     on pf.cod_pessoa = p.cod_pessoa
              left join kss.v$pessoa_endereco pe
                     on pe.cod_pessoa = p.cod_pessoa
                    and pe.endereco_padrao = 1
             where 1 = 1		  
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			    and vp.placa = upper('#arguments.placa#')
			</cfif>		
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os proprietrios cadastrados para um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 23/03/2009
	--->	
	<cffunction name="get_veiculo_proprietario_geral" displayname="Retorna os proprietrios cadastrados para um veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vp.placa, vp.cod_pessoa, to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(vp.data_fim, 'dd/mm/yyyy hh24:mi:ss') as data_fim, vp.rowid,
                   to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as old_data_inicio,
                   to_date(to_char(vp.data_inicio, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_ini,
                   to_date(to_char(vp.data_inicio, 'hh24:mi:ss'), 'hh24:mi:ss') hora_ini,
                   to_date(to_char(vp.data_fim, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_f,
                   to_date(to_char(vp.data_fim, 'hh24:mi:ss'), 'hh24:mi:ss') hora_f,
                   p.cnpj_cpf, p.razao_social,
                   vp.user_insert, vp.user_update,
                   to_char(vp.data_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert, to_char(vp.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update, 
                   rownum as keyfield
              from oper.v$veiculo_proprietario vp
             inner join kss.v$pessoa p
                on p.cod_pessoa = vp.cod_pessoa 
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and upper(vp.placa) = upper('#arguments.placa#')
            </cfif>
              order by vp.data_inicio desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Retorna os permissionrios cadastrados para um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 23/03/2009
	--->	
	<cffunction name="get_veiculo_permissionario_geral" displayname="Retorna os permissionrios cadastrados para um veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vp.placa, vp.cod_pessoa, to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(vp.data_fim, 'dd/mm/yyyy hh24:mi:ss') as data_fim, vp.rowid,
                   to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as old_data_inicio,
                   to_date(to_char(vp.data_inicio, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_ini,
                   to_date(to_char(vp.data_inicio, 'hh24:mi:ss'), 'hh24:mi:ss') hora_ini,
                   to_date(to_char(vp.data_fim, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_f,
                   to_date(to_char(vp.data_fim, 'hh24:mi:ss'), 'hh24:mi:ss') hora_f,
                   p.cnpj_cpf, p.razao_social,
                   vp.user_insert, vp.user_update,
                   to_char(vp.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert, to_char(vp.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update, 
                   rownum as keyfield
              from oper.v$veiculo_permissionario vp
             inner join kss.v$pessoa p
                on p.cod_pessoa = vp.cod_pessoa 
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and upper(vp.placa) = upper('#arguments.placa#')
            </cfif>
             order by vp.data_inicio desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os proprietrios de documentos cadastrados para um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 23/03/2009
	--->	
	<cffunction name="get_veiculo_proprietario_doc_geral" displayname="Retorna os proprietrios de documentos cadastrados para um veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vp.placa, vp.cod_pessoa, to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(vp.data_fim, 'dd/mm/yyyy hh24:mi:ss') as data_fim, vp.rowid,
                   to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as old_data_inicio,
                   to_date(to_char(vp.data_inicio, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_ini,
                   to_date(to_char(vp.data_inicio, 'hh24:mi:ss'), 'hh24:mi:ss') hora_ini,
                   to_date(to_char(vp.data_fim, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_f,
                   to_date(to_char(vp.data_fim, 'hh24:mi:ss'), 'hh24:mi:ss') hora_f,
                   p.cnpj_cpf, p.razao_social,
                   vp.user_insert, vp.user_update,
                   to_char(vp.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert, to_char(vp.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update, 
                   rownum as keyfield
              from oper.v$veiculo_proprietario_doc vp
             inner join kss.v$pessoa p
                on p.cod_pessoa = vp.cod_pessoa
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and upper(vp.placa) = upper('#arguments.placa#')
            </cfif>
             order by vp.data_inicio desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca os dados para o servio contratado
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 07/12/2005 - criado
	--->	
	<cffunction name="get_motorista_proprietario" displayname="Busca os dados para o servio contratado" access="remote" returntype="struct" output="false">
		<cfargument name="placa_controle" required="yes">
		<cfargument name="data_emissao" required="no" default="#LSDateFormat(now())# #TimeFormat(now(),'HH:MM:SS')#">
        <cfargument name="trata_erro" required="no" default="0">
			<cftry>
				<cfscript>
					qrVeiculo = this.get_composicao(cod_veiculo = arguments.placa_controle);
				</cfscript>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_motorista.prc_get_motorista_proprietario" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#Replace(qrVeiculo.placa,'-','')#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#arguments.data_emissao#">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnpj_prop">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.endereco">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cidade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.uf">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.proprietario_municipio_id">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cpf_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.nome_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_date"     variable="retorno.cnh_validade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnh_numero">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.pis_pasep_nit">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.retorno">
				</cfstoredproc>
                
				<cfset retorno.veiculo_proprietario = qrVeiculo.veiculo_proprietario>
				
				<cfscript>
					qrVeiculo = this.get_veiculo(placa = arguments.placa_controle);
				</cfscript>
                
				<cfset retorno.tag_ctf = qrVeiculo.tag_ctf>
                <cfset retorno.erro = false>
			<cfcatch>
            	<cfif arguments.trata_erro eq 0>
	            	<cfthrow detail="#cfcatch.Detail#">
                </cfif>
            	<cfif arguments.trata_erro eq 2>
					<cfset retorno.mensagem = cfcatch>
                    <cfset retorno.erro = true>
                </cfif>
            	<cfif arguments.trata_erro eq 1>
					<cfset retorno = StructNew()>
                    <cfset retorno.cod_pessoa_proprietario = ''>
                    <cfset retorno.proprietario = 'Problemas com o veculo.'>
                    <cfset retorno.cnpj_prop = ''>
                    <cfset retorno.endereco = ''>
                    <cfset retorno.cidade = ''>
                    <cfset retorno.uf = ''>
                    <cfset retorno.proprietario_municipio_id = ''>
                    <cfset retorno.cod_pessoa_motorista = ''>
                    <cfset retorno.nome_motorista = ''>
                    <cfset retorno.cnh_validade = ''>
                    <cfset retorno.cnh_numero = ''>
                    <cfset retorno.pis_pasep_nit = ''>
                    <cfset retorno.retorno = ''>
                </cfif>
			</cfcatch>
			</cftry>
			<cfset retorno.placa = arguments.placa_controle>
		<cfreturn retorno>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="placa_exa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="frota_exa" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7"> 
		<!---Terceiros--->	
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct vd.veiculo_id, vd.placa,
                    vd.cod_veiculo,
                    vd.num_rastreador,
                    vd.rastreador_id,
                    vd.rastreador_com_problemas,
                    vd.marca_id,
                    vd.marca,
                    vd.modelo_id,
                    vd.situacao_id,
                    vd.uf,
                    vd.capacidade_tanque,
                    oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(vd.placa,sysdate) capacidade,
                    vd.km_revisao,
                    vd.modelo,
                    vd.proprietario,
                    vd.observacao,
                    vd.cor_predominante,
                    vd.ano,
                    vd.chassis,
                    vd.renavan,
                    va.agrupamento_id,
                    va.descricao as agrupamento,
                    vtc.tipo_carroceria_id,
               		vtc.descricao as tipo_carroceria,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TAG_CTF') as tag_ctf,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TARA') as tara,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'COMBUSTIVEL') as combustivel,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'NUMERO_EIXOS') as numero_eixos,
                    va.tracao,
                    vd.municipio_id,
                    (select municipio
                       from cep.municipio m
                      where m.municipio_id = vd.municipio_id) as municipio,
                    vd.tipo_carroceria_id,
                    vtc.descricao as tipo
              from oper.v$veiculo_dados vd
              left join oper.v$veiculo_tipo_carroceria vtc
                     on vd.tipo_carroceria_id = vtc.tipo_carroceria_id
              left join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
              left join oper.v$veiculo_proprietario vp on vp.placa = vd.placa
                                                      and vp.data_fim is null
             where 1 = 1			  
			<cfif Len(Trim(arguments.placa))>
			   and vd.placa like upper('%#arguments.placa#%')
			</cfif>		
			<cfif Len(Trim(arguments.placa_exa))>
			   and upper(vd.placa) = '#arguments.placa_exa#'
			</cfif>	
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vd.cod_veiculo) like upper('#arguments.cod_veiculo#%')
			</cfif>		
			<cfif Len(Trim(arguments.proprietario))>
			   and vd.proprietario in (#arguments.proprietario#)
			</cfif>		
			<cfif Len(Trim(arguments.frota))>
			   and (vd.placa like upper('#arguments.frota#%')
			       or vd.cod_veiculo like upper('#arguments.frota#%'))
			</cfif>	
			<cfif Len(Trim(arguments.frota_exa))>
			   and (upper(vd.placa) = '#arguments.frota_exa#'
			       or upper(vd.cod_veiculo) = '#arguments.frota_exa#')
			</cfif>
			order by vd.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca a composicao do veiculo
	-- CRISTOFER  24/10/2006
	--->		
	<cffunction name="get_composicao" access="remote" returntype="any" output="true">
		<cfargument name="cod_veiculo" required="yes"> 
		<cfargument name="data" required="no" default=""> 
		<cfargument name="trata_erro" required="no" default="0"> 
        <cftry>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select t.column_value as placa,
                         oper.pkg_veiculo.fnc_get_cod_veiculo(t.column_value) as cod_veiculo,
                         oper.pkg_veiculo.fnc_veiculo_id(t.column_value) as veiculo_id,
                         case when t.column_value = '-1' then 0 else oper.pkg_veiculo.fnc_veiculo_proprietario(t.column_value) end as veiculo_proprietario,
                         a.capacidade,
                         oper.pkg_veiculo.FNC_VEICULO_MODALIDADE(t.column_value) as modalidade,
                         (select distinct d.articulado
                            from oper.v$veiculo_dados d
                           where d.placa = t.column_value) as articulado,
                         (select distinct d.tipo_veiculo
                            from oper.v$veiculo_dados d
                           where d.placa = t.column_value) as tracao
                  from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.FNC_GET_COMPOSICAO(oper.pkg_veiculo.fnc_get_placa('#JSStringFormat(arguments.cod_veiculo)#')<cfif len(trim(arguments.data))>,'#arguments.data#'</cfif>),'|')) t,
                       (select oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(oper.pkg_veiculo.fnc_get_placa('#JSStringFormat(arguments.cod_veiculo)#')<cfif session.site eq 'delpozo/'>,0</cfif>,sysdate) as capacidade from dual) a
                 where t.column_value is not null
            </cfquery>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = "">
         	<cfcatch>
            	<cfif arguments.trata_erro eq 0>
                	<cfthrow object="#cfcatch#">
                <cfelseif arguments.trata_erro eq 1>
		            <cfset retorno.erro = true>
		            <cfset retorno.mensagem = cfcatch>
                    <cfset qr_result = retorno>
                </cfif>
            </cfcatch>
        </cftry>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna o nmero de eixos de uma determinada placa ou composio na data atual
	-- ANDERSONC 27/09/2010 15:41:18 - CRIADO
	--->
	<cffunction name='get_numero_eixos_composicao' displayname='Retorna o nmero de eixos de uma determinada placa ou composio na data atual' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_veiculo.prc_numero_eixos_composicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EIXOS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EIXOS_SUPENSOS' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna o motorista para viagens de terceiro
	-- LEANDROS  10/10/2014
	--->		
	<cffunction name="get_motorista_terceiro" access="remote" returntype="any" output="true">
		<cfargument name="num_romaneio" required="yes"> 
		<cfargument name="placa_controle" required="yes"> 
        <cftry>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select pf.cod_pessoa
     				 , pf.cpf
     				 , pf.nome
     				 , pf.cnh_numero
     				 , pf.cnh_validade
  				  from kss.v$pessoa_fisica pf
 				 where pf.cod_pessoa = (select hv.COD_PESSOA
                 				          from oper.v$romaneio_hist_veiculo hv
                         				 where hv.num_romaneio = '#arguments.num_romaneio#'
                           				   and hv.PLACA_CONTROLE = '#arguments.placa_controle#')
            </cfquery>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = "">
         	<cfcatch>
            	<cfif arguments.trata_erro eq 0>
                	<cfthrow object="#cfcatch#">
                <cfelseif arguments.trata_erro eq 1>
		            <cfset retorno.erro = true>
		            <cfset retorno.mensagem = cfcatch>
                    <cfset qr_result = retorno>
                </cfif>
            </cfcatch>
        </cftry>
        <cfreturn qr_result>		
	</cffunction>
	
	<cffunction name="verifica_responsavel_vale_pedagio" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="yes" >
		<cfargument name="operacao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nvl(instr(upper(kss.pkg_parametro.fnc_valor_string(p_identificador => 'M212-P0153')), case oper.pkg_veiculo.fnc_veiculo_proprietario(upper('#arguments.placa#'))
																										    when 1 then 'FROTA'
																										    when 2 then 'AGREGADO'
																										    when 3 then 'TERCEIRO'
																										    else null
																									     end), 0) as modalidade_esta_no_parametro
		         , nvl((select c.rv_abbreviation
					      from kss.cg_ref_codes c
					     where c.rv_domain = 'OPERACAO.FORNECEDOR_VALE_PEDAGIO'
					       and c.rv_low_value = (select o.fornecedora_vale_pedagio
											       from logistica.v$operacao o
											      where o.operacao_id = '#arguments.operacao_id#')), 'Transportadora') as responsavel_vale_pedagio
			  from dual
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>
