<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Lista os itens do crt
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 19/05/2009
	--->	
	<cffunction name="get_crt_form" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select conhecimento_id,
                   numero_cod_pais,
                   versao,
				   campo01,
				   campo02,
                   '' as campo03,
				   campo04,
				   campo05,
				   campo06,
				   campo07,
				   campo08,
				   campo09,
				   campo10,
				   campo11,
				   campo12,
				   campo13,
				   campo14_1,
				   campo14_2,
				   campo15_1,
				   campo15_2,
				   campo15_3,
				   campo15_4,
				   campo16_1,
				   campo16_2,
				   campo17,
				   campo18,
                   campo19_0,
				   campo19_1,
				   campo19_2,
				   campo20_1,
				   campo20_2,
				   campo21_1,
				   campo21_2,
				   campo22,
                   campo23,
                   campo23_1,
                   campo24
			  from fiscal.v$intc_conhecimento_form	
 			 where conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Lista os itens do crt
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 18/06/2009
	--->	
	<cffunction name="get_crt_print" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select conhecimento_id,
                   numero_cod_pais,
                   versao,
                   campo01,
                   campo02,
                   '' as campo03,
                   campo04,
                   campo05,
                   campo06,
                   campo07,
                   campo08,
                   campo09,
                   campo10,
                   campo11,
                   campo12,
                   campo13,
                   campo14_1,
                   campo14_2,
                   campo15_1,
                   campo15_2,
                   campo15_3,
                   campo15_4,
                   campo16_1,
                   campo16_2,
                   campo17,
                   campo18,
                   campo19_0,
                   campo19_1,
                   campo19_2,
                   campo20_1,
                   campo20_2,
                   campo21_1,
                   campo21_2,
                   campo22,
                   campo23,
                   campo23_1,
                   campo24
              from fiscal.v$intc_conhecimento_print
             where conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>    
    
    <!--- 
	-- PROPSITO
	-- Lista os itens do crt
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 18/06/2009
	--->	
	<cffunction name="get_crt_campo_15" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select descricao,
                   replace(replace(replace(to_char(valor_origem, '999G999G990D00'),'.','%'),',','.'),'%',',') as valor_origem,
                   decode(nvl(valor_origem, 0),0,'',
                          (select b.moeda
                             from finan.v$moeda_bacen b
                            where b.cod_moeda = valor_origem_cod_moeda)) as valor_origem_cod_moeda,
                   replace(replace(replace(to_char(valor_destino, '999G999G990D00'),'.','%'),',','.'),'%',',') as valor_destino,
                   decode(nvl(valor_destino, 0),0,'',
                          (select b.moeda
                             from finan.v$moeda_bacen b
                            where b.cod_moeda = valor_destino_cod_moeda)) as valor_destino_cod_moeda
              from fiscal.v$intc_conhecimento_custo
             where conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna dados do MIC para a impresso
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 20/05/2009
	--->	
	<cffunction name="get_intc_manifesto_form" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfargument name="vias" required="no" default="1">
		<cfargument name="paginas" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">	
			select manifesto_id, numero_cod_pais,
				   conhecimento_id,
				   pagina,
				   total_paginas,
				   campo01,
				   campo02,
				   campo03_1,
				   campo03_2,
				   campo04,
				   campo05,
				   campo06,
				   campo07,
				   campo07_cod1,
				   campo07_cod2,
				   campo07_cod3,
				   campo07_cod4,
				   campo07_cod5,
				   campo07_cod6,
				   campo07_cod7,
				   campo07_cod8,
				   campo08,
                   campo08_cod1,
                   campo08_cod2,
                   campo08_cod3,
				   campo09,
				   campo10,
				   campo11,
				   campo12,
				   campo13,
				   campo14,
				   campo15_1,
				   campo15_2,
				   campo15_3,
       			   '' as campo16,
				   campo17,
				   campo18,
				   campo19,
				   campo20,
				   campo21,
				   campo22_1,
				   campo22_2,
				   campo22_3,
				   campo23,
				   campo24,
				   campo24_cod1,
				   campo24_cod2,
				   campo24_cod3,
				   campo24_cod4,
				   campo24_cod5,
				   campo24_cod6,
				   campo24_cod7,
				   campo24_cod8,
				   campo25,
				   campo26,
                   campo26_cod1,
				   campo26_cod2,
				   campo26_cod3,
				   campo27,
				   campo28,
				   campo29,
				   campo30,
                   campo30_cod1,
                   campo30_cod2,
				   campo31,
				   campo32,
				   campo33,
				   campo34,
				   campo35,
				   campo36,
				   campo37,
				   campo38,
				   campo38_1,
				   campo38_cod1,
				   campo38_cod2,
				   campo38_cod3,
				   campo38_cod4,
				   campo38_cod5,
				   campo38_cod6,
				   campo38_cod7,
				   campo38_cod8,
				   campo38_cod9,
				   campo38_cod10,
				   campo40,
				   campo42,
				   campo43,
				   campo44,
				   campo45,
				   campo46,
				   campo47,
                   campo39
			  from fiscal.v$intc_manifesto_form
			 where manifesto_id  = #arguments.manifesto_id#
			 <cfif arguments.paginas eq 0>
			 and pagina = 1
			 <cfelseif arguments.paginas eq 1>
			 and pagina <> 1
			 </cfif>
			 order by pagina
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  	
    
    <!--- 
	-- PROPSITO
	-- Lista os itens do crt
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 20/05/2009
	--->	
	<cffunction name="get_intc_manifesto" access="remote" returntype="query" output="true">
		<cfargument name="numero" required="no" default="">
		<cfargument name="numero_cod_pais" required="no" default="">
		<cfargument name="manifesto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.manifesto_id,
                   m.numero_cod_pais,
                   m.numero_certificado,
                   m.numero_sequencial,
                   m.serie,
                   upper(m.numero_cod_pais) || m.numero_certificado || replace(replace(to_char(m.numero_sequencial, '000000'), ' ', ''), ',', '.') as numero,
                   m.data_emissao,
                   m.transito_aduaneiro,
                   m.cod_transportador,
                   m.transp_nome,
                   m.transp_endereco,
                   m.transp_municipio_id,
                   cep.fnc_cidade_completa(m.transp_municipio_id) as transp_mun_uf_pais,
                   m.transp_dados_adicionais,
                   m.transp_cnpj_cpf,
                   m.alfandega_origem_id,
                   a.nome as alfandega,
                   m.pais_id_origem,
                   m.destino_local,
                   m.destino_municipio_id,
                   m.veic_orig_prop_cod_pessoa,
                   m.veic_orig_prop_nome,
                   m.veic_orig_prop_endereco,
                   m.veic_orig_prop_municipio_id,
                   cep.fnc_cidade_completa(m.veic_orig_prop_municipio_id) as veic_orig_prop_mun_uf_pais,
                   m.veic_orig_prop_cnpj_cpf,
                   m.veic_orig_placa_controle,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(m.veic_orig_placa_controle) veic_orig_frota_controle,
                   m.veic_orig_marca,
                   m.veic_orig_chassis,
                   m.veic_orig_capacidade,
                   oper.pkg_frota_dml.fnc_veiculo_get_atributo(m.veic_orig_placa_controle, 'TARA') as veic_orig_tara,
                   m.veic_orig_ano,
                   m.veic_orig_tipo,
                   m.veic_orig_placa_referencia,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(m.veic_orig_placa_referencia) veic_orig_frota_referencia,
                   m.veic_orig_mot_cod_pessoa,
                   oper.pkg_global.fnc_mascara_cnpj_cpf(m.veic_orig_mot_cod_pessoa) as veic_orig_mot_cnpj_cpf,
                   oper.pkg_global.fnc_busca_nome_pessoa(m.veic_orig_mot_cod_pessoa) as veic_orig_mot_nome,
                   m.veic_subst_prop_cod_pessoa,
                   m.veic_subst_prop_nome,
                   m.veic_subst_prop_endereco,
                   m.veic_subst_prop_municipio_id,
                   cep.fnc_cidade_completa(m.veic_subst_prop_municipio_id) as veic_subst_prop_mun_uf_pais,
                   m.veic_subst_prop_cnpj_cpf,
                   m.veic_subst_placa_controle,
                   m.veic_subst_marca,
                   m.veic_subst_chassis,
                   m.veic_subst_capacidade,
                   m.veic_subst_mot_cod_pessoa,
                   oper.pkg_global.fnc_mascara_cnpj_cpf(m.veic_subst_mot_cod_pessoa) as veic_subst_mot_cnpj_cpf,
                   oper.pkg_global.fnc_busca_nome_pessoa(m.veic_subst_mot_cod_pessoa) as veic_subst_mot_nome,
                   oper.pkg_frota_dml.fnc_veiculo_get_atributo(m.veic_subst_placa_controle, 'TARA') as veic_subst_tara,
                   m.veic_subst_ano,
                   m.veic_subst_tipo,
                   m.veic_subst_placa_referencia,
                   m.num_dta_rota,
                   m.rota_id,
                   m.complemento,
                   m.cancelado,
                   m.embarcado,
                   m.num_romaneio,
                   m.item_id as romaneio_item_id,
                   m.en_lastre,
                   m.anexo,
                   (select kss.fnc_concat_all(kss.to_concat_expr(c.numero_cod_pais || '.' || lpad(c.numero_certificado, 3, '0') || '.' || trim(replace(to_char(c.numero_sequencial, '000g000'), ',', '.')), ' <br>'))
                      from fiscal.v$intc_manifesto_crt mc
                     inner join fiscal.v$intc_conhecimento c
                             on c.conhecimento_id = mc.conhecimento_id
                     where mc.manifesto_id = m.manifesto_id) crts,
                   (select count(*)
                      from fiscal.v$intc_manifesto_crt_item mci
                     where mci.manifesto_id = m.manifesto_id) as num_crts
              from fiscal.v$intc_manifesto m
              left join fiscal.v$alfandega a
                     on a.alfandega_id = m.alfandega_origem_id
             where 1 = 1
			<cfif len(trim(arguments.numero))>
			   and upper(replace(m.num_mic_completo,'.','')) like upper(replace('%#arguments.numero#%','.',''))
			</cfif>
			<cfif len(trim(arguments.numero_cod_pais))>
			   and upper(m.numero_cod_pais) = upper('#arguments.numero_cod_pais#')
			</cfif>
			<cfif len(trim(arguments.manifesto_id))>
			   and manifesto_id in (#arguments.manifesto_id#)
			</cfif>
			 order by m.numero_cod_pais desc, m.numero_certificado desc, m.numero_sequencial desc
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Lista os itens do crt
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 20/05/2009
	--->	
	<cffunction name="get_intc_manifesto_item" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct i.manifesto_id,
                            c.numero_sequencial,
                            i.conhecimento_id,
                            ci.item_id as conhecimento_item_id,
                            upper(c.numero_cod_pais || '.' || c.numero_certificado || '.' ||
                                  replace(to_char(c.numero_sequencial, '000000'),
                                          ' ',
                                          '')) as numero_crt,
                            i.alfandega_destino_id,
                            i.cod_moeda,
                            i.origem_local,
                            i.origem_municipio_id,
                            ic.valor_fot,
                            ic.valor_total,
                            ic.valor_seguro,
                            ci.produto_id,
                            i.num_especie,
                            ic.quantidade,
                            ic.peso_bruto,
                            ic.peso_liquido,
                            i.unidade_id,
                            i.cod_remetente,
                            i.rem_nome,
                            i.rem_local,
                            rem.cnpj_cpf as rem_cnpj_cpf,
                            rem.inscricao_estadual as rem_inscr_estadual,
                            decode(rem.tipo_pessoa,
                                   2 /*Estrangeira*/,
                                   rpes.endereco,
                                   rpe.logradouro || decode(rpe.numero, '', '', ', ') ||
                                   rpe.numero || decode(rpe.complemento, '', '', ' - ') ||
                                   rpe.complemento) as rem_endereco,
                            rmun.municipio as rem_municipio,
                            rmun.uf_id as rem_uf,
                            rps.descricao as rem_pais,
                            cep.fnc_cidade_completa(i.rem_municipio_id) as rem_local,
                            i.rem_municipio_id,
                            i.cod_destinatario,
                            i.dest_nome,
                            i.dest_local,
                            dest.cnpj_cpf as dest_cnpj_cpf,
                            dest.inscricao_estadual as dest_inscr_estadual,
                            decode(dest.tipo_pessoa,
                                   2 /*Estrangeira*/,
                                   dpes.endereco,
                                   dpe.logradouro || decode(dpe.numero, '', '', ', ') ||
                                   dpe.numero || decode(dpe.complemento, '', '', ' - ') ||
                                   dpe.complemento) as dest_endereco,
                            dmun.municipio as dest_municipio,
                            dmun.uf_id as dest_uf,
                            dps.descricao as dest_pais,
                            cep.fnc_cidade_completa(i.dest_municipio_id) as dest_local,
                            i.dest_municipio_id,
                            i.cod_consignatario,
                            i.cons_nome,
                            i.cons_local,
                            i.cons_municipio_id,
                            i.numero_lacres,
                            ic.descricao as mercadorias,
                            '' as ncm,
                            i.user_insert,
                            i.date_insert,
                            i.user_update,
                            i.date_update,
                            i.site,
                            i.anexo,
                            ic.item_id,
                            i.pais_id_origem
                       from fiscal.v$intc_manifesto_crt  i
                      inner join fiscal.v$intc_manifesto_crt_item ic
                              on i.manifesto_id = ic.manifesto_id
                             and i.conhecimento_id = ic.conhecimento_id
                      inner join fiscal.v$intc_conhecimento_item ci
                              on ic.conhecimento_id = i.conhecimento_id
                             and ci.item_id = ic.item_id
                      inner join fiscal.v$intc_conhecimento c
                              on c.conhecimento_id = i.conhecimento_id
                      inner join kss.v$pessoa rem 
                              on rem.cod_pessoa = i.cod_remetente
                       left join kss.v$pessoa_estrangeira rpes
                              on rpes.cod_pessoa = i.cod_remetente
                       left join kss.v$pessoa_endereco rpe
                              on rpe.cod_pessoa = rem.cod_pessoa
                             and rpe.endereco_padrao = 1
                       left join cep.municipio rmun
                              on rmun.municipio_Id = rpe.municipio_id
                       left join cep.pais rps
                              on rps.pais_id = rmun.pais_id
                       left join kss.v$pessoa dest
                              on dest.cod_pessoa = i.cod_destinatario
                       left join kss.v$pessoa_estrangeira dpes
                              on dpes.cod_pessoa = i.cod_destinatario
                       left join kss.v$pessoa_endereco dpe
                              on dpe.cod_pessoa = dest.cod_pessoa
                             and dpe.endereco_padrao = 1
                       left join cep.municipio dmun
                              on dmun.municipio_Id = dpe.municipio_id
                       left join cep.pais dps
                              on dps.pais_id = dmun.pais_id
               where i.manifesto_id = #arguments.manifesto_id#
               order by c.numero_sequencial
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Lista os CRTs para faturamento de um cliente
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_intc_conhecimento_faturar_old" displayname="Lista os CRTs para faturamento de um cliente" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_cliente" required="no" default="">
		<cfargument name="lista_crt" required="no" default="">
		<cfargument name="fatura_id" required="no" default="">
		<cfargument name="internacional" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select f.conhecimento_id, f.numero, f.emissao_data, f.origem, f.destino, f.pagador,
				   f.cod_pessoa_pagador, f.valor_total, f.cod_moeda, f.pago_por, f.fatura_emitida, f.fatura_id,
				   f.data_embarque, f.numero_cod_pais
			  from fiscal.v$intc_conhecimento_faturar f
             inner join fiscal.v$intc_permisso p
                     on p.num_permisso = f.numero_certificado
                    and p.cod_pais = f.numero_cod_pais 
			 where 1=1
			 <cfif Len(Trim(arguments.cod_pessoa_cliente))>
			   and cod_pessoa_pagador = #arguments.cod_pessoa_cliente#
			 </cfif>
			 <cfif Len(Trim(arguments.lista_crt))>
			   and conhecimento_id in (#arguments.lista_crt#)
			 </cfif>
			 <cfif Len(Trim(arguments.internacional))>
			   and (numero_cod_pais = 'AR' or (pago_por in (3,4)))
			 </cfif>
			 <cfif Len(Trim(arguments.fatura_id))>
			   and fatura_id = #arguments.fatura_id#
			 </cfif>
			 order by pagador, numero
   		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Lista os tipos de produto
	-- NOTAS EXPLICATIVAS
	-- ANDERSON - 16/07/2009 - ALTERADO
	--->	
	<cffunction name="get_crt" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfargument name="numero" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_remetente" required="no" default="">
		<cfargument name="cod_destinatario" required="no" default="">
      	<cfargument name="num_crt_completo" required="no" default="">
        <cfargument name="diaria" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select c.conhecimento_id,
                   c.versao,
                   c.numero_cod_pais,
                   c.numero_certificado,
                   c.numero_sequencial,
                   c.serie,
                   upper(c.numero_cod_pais || c.numero_certificado || replace(to_char(c.numero_sequencial, '000000'), ' ', '')) as numero,
                   upper(c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(replace(to_char(c.numero_sequencial, '000,000'), ',', '.'), ' ', '')) as numero_form,
                   c.cod_pessoa_filial,
                   c.emissao_local,
                   c.emissao_municipio_id,
                   c.emissao_data,
                   to_char(c.emissao_data, 'dd/mm/yyyy') emissao_data_char,
                   c.resp_local,
                   c.resp_municipio_id,
                   cep.fnc_cidade_completa(c.resp_municipio_id) as resp_cidade,
                   to_char(c.resp_data, 'dd/mm/yyyy') as resp_data,
                   c.entrega_local,
                   c.entrega_municipio_id,
                   cep.fnc_cidade_completa(c.entrega_municipio_id) as entrega_cidade,
                   to_char(c.entrega_data, 'dd/mm/yyyy') as entrega_data,
                   c.transp_sucessivos,
                   c.cod_remetente,
                   c.rem_nome,
                   c.rem_endereco,
                   c.rem_cidade,
                   c.rem_municipio_id,
                   c.pais_id_origem,
                   c.rem_uf,
                   c.rem_pais,
                   decode(c.rem_uf, 'EX',
                         (select pe.cod_cadastro_contribuinte
                            from kss.v$pessoa_estrangeira pe
                           where pe.cod_pessoa = c.cod_remetente),
                         c.rem_cnpj_cpf) as rem_cnpj_cpf,
                   rem.inscricao_estadual as rem_inscricao_estadual,
                   c.rem_cidade ||
                   decode(nvl(c.rem_uf, 'EX'), 'EX',
                         (select decode(pe.estado_provincia, null, '', ' - ' || to_char(pe.estado_provincia))
                            from kss.v$pessoa_estrangeira pe
                           where pe.cod_pessoa = c.cod_remetente),
                         ' - ' || c.rem_uf) || ' - ' || c.rem_pais as rem_municipio_uf_pais,
                   c.rem_cnpj_cpf as remetente_cnpj_cpf,
                   c.cod_destinatario,
                   c.dest_nome,
                   c.dest_endereco,
                   c.dest_cidade,
                   c.dest_municipio_id,
                   c.dest_cnpj_cpf,
                   c.dest_uf,
                   c.dest_pais,
                   dest.inscricao_estadual as dest_inscricao_estadual,
                   c.dest_cidade ||
                   decode(nvl(c.dest_uf, 'EX'), 'EX',
                         (select decode(pe.estado_provincia, null, '', ' - ' || to_char(pe.estado_provincia))
                            from kss.v$pessoa_estrangeira pe
                           where pe.cod_pessoa = c.cod_destinatario),
                         ' - ' || c.dest_uf) || ' - ' || c.dest_pais as dest_municipio_uf_pais,
                   c.cod_consignatario,
                   c.cons_nome,
                   c.cons_endereco,
                   c.cons_cidade,
                   c.cons_municipio_id,
                   c.cons_uf,
                   c.cons_pais,
                   c.cons_cnpj_cpf,
                   c.cons_cidade ||
                   decode(nvl(c.cons_uf, 'EX'), 'EX',
                         (select decode(pe.estado_provincia, null, '', ' - ' || to_char(pe.estado_provincia))
                            from kss.v$pessoa_estrangeira pe
                           where pe.cod_pessoa = c.cod_consignatario),
                         ' - ' || c.cons_uf) || ' - ' || c.cons_pais as cons_municipio_uf_pais,
                   c.cod_notificar,
                   c.not_nome,
                   c.not_endereco,
                   c.not_cidade,
                   c.not_municipio_id,
                   c.not_uf,
                   c.not_pais,
                   c.not_cnpj_cpf,
                   c.not_cidade ||
                   decode(nvl(c.not_uf, 'EX'), 'EX',
                         (select decode(pe.estado_provincia, null, '', ' - ' || to_char(pe.estado_provincia))
                            from kss.v$pessoa_estrangeira pe
                           where pe.cod_pessoa = c.cod_notificar),
                         ' - ' || c.not_uf) || ' - ' || c.not_pais as not_municipio_uf_pais,
                   c.mercadorias,
                   c.num_especie,
                   to_char(c.quantidade_total, '999999') as quantidade_total,
                   c.peso_bruto,
                   c.peso_liquido,
                   c.unidade_id,
                   to_char(c.m3, '999999D999') as m3,
                   c.valor_total,
                   c.valor_total_cod_moeda,
                   c.valor_total_incoterm_id,
                   c.total_custo_origem,
                   c.total_custo_origem_cod_moeda,
                   c.total_custo_destino,
                   c.total_custo_destino_cod_moeda,
                   c.valor_frt_externo,
                   c.valor_frt_externo_cod_moeda,
                   c.valor_reembolso,
                   c.valor_reembolso_cod_moeda,
                   c.valor_mercadorias,
                   c.valor_mercadorias_cod_moeda,
                   c.valor_mercadorias_incoterm_id as valor_mercadorias_incoterm,
                   c.alfandega_origem_id,
                   c.alfandega_destino_id,
                   c.pago_por,
                   c.declaracao_observacao,
                   c.user_insert,
                   c.date_insert,
                   c.user_update,
                   c.date_update,
                   c.site,
                   f.cliente as filial,
                   c.cancelado,
                   c.liberado_fatura,
                   c.obs_pago_por,
                   c.seguro_pago_empresa,
                   c.qtde_veiculos,
                   c.cod_organograma,
                   c.taxa_mercadoria_seguro,
                   c.organizacional_id_gerencial,
                   kss.pkg_organizacional.fnc_descricao_completa(c.organizacional_id_gerencial) as organizacional_gerencial,
                   to_char(c.prazo_entrega,'dd/mm/yyyy') as prazo_entrega,
                   (select o.cod_centro_custo
                      from kss.v$organograma o
                     where o.cod_organograma = c.cod_organograma) as cod_centro_custo,
                   (select cc.centro_custo
                      from kss.v$organograma o
                     inner join kss.v$centro_custo cc
                             on cc.cod_centro_custo = o.cod_centro_custo
                     where o.cod_organograma = c.cod_organograma) as centro_custo,
                   to_char(c.emissao_data_impressao,'dd/mm/yyyy') as emissao_data_impressao,
                   c.cod_pagador_origem,
                   c.pag_origem_nome,
                   c.pag_origem_endereco,
                   c.pag_origem_cidade,
                   c.pag_origem_uf,
                   c.pag_origem_pais,
                   c.pag_origem_cnpj_cpf,
                   c.pag_origem_cidade ||
                   decode(nvl(c.pag_origem_uf, 'EX'), 'EX',
                         (select decode(pe.estado_provincia, null, '', ' - ' || to_char(pe.estado_provincia))
                            from kss.v$pessoa_estrangeira pe
                           where pe.cod_pessoa = c.cod_pagador_origem),
                         ' - ' || c.pag_origem_uf) || ' - ' || c.pag_origem_pais as pag_origem_cidade_uf_pais,
                   c.cod_pagador_destino,
                   c.pag_destino_nome,
                   c.pag_destino_endereco,
                   c.pag_destino_cidade,
                   c.pag_destino_uf,
                   c.pag_destino_pais,
                   c.pag_destino_cnpj_cpf,
                   c.pag_destino_cidade ||
                   decode(nvl(c.pag_destino_uf, 'EX'), 'EX',
                         (select decode(pe.estado_provincia, null, '', ' - ' || to_char(pe.estado_provincia))
                            from kss.v$pessoa_estrangeira pe
                           where pe.cod_pessoa = c.cod_pagador_destino),
                         ' - ' || c.pag_destino_uf) || ' - ' || c.pag_destino_pais as pag_destino_cidade_uf_pais,
                   c.pre_conhecimento,
                   c.cotacao,
                   c.cod_negociador,
                   kss.pkg_pessoa.fnc_get_cliente(c.cod_negociador) as neg_nome,
                   (select pe.endereco || decode(pe.bairro, null, '', ' - ' || pe.bairro)
                      from kss.v$pessoa_endereco_padrao pe
                     where pe.cod_pessoa = c.cod_negociador) as neg_endereco,
                   (select pe.municipio
                      from kss.v$pessoa_endereco_padrao pe
                     where pe.cod_pessoa = c.cod_negociador) as neg_municipio,
                   (select pe.municipio_id
                      from kss.v$pessoa_endereco_padrao pe
                     where pe.cod_pessoa = c.cod_negociador) as neg_municipio_id,
                   case
                      when (select p.tipo_pessoa
                              from kss.v$pessoa p
                             where p.cod_pessoa = c.cod_negociador) = 2 then
                         (select nvl(pe.cod_cadastro_contribuinte, pe.cod_pessoa)
                            from kss.v$pessoa_estrangeira pe
                           where pe.cod_pessoa = c.cod_negociador)
                      else (select p.cnpj_cpf
                              from kss.v$pessoa p
                             where p.cod_pessoa = c.cod_negociador)
                   end as neg_cnpj_cpf,
                   (select pe.uf
                      from kss.v$pessoa_endereco_padrao pe
                     where pe.cod_pessoa = c.cod_negociador) as neg_uf,
                   (select pe.pais
                      from kss.v$pessoa_endereco_padrao pe
                     where pe.cod_pessoa = c.cod_negociador) as neg_pais,
                   (select cep.pkg_municipio.fnc_cidade_completa(pe.municipio_id)
                      from kss.v$pessoa_endereco_padrao pe
                     where pe.cod_pessoa = c.cod_negociador) as neg_municipio_uf_pais,
                   c.nf_fatura,
                   c.operacao_id,
                   c.pedido_shipment,
                   c.tipo_servico_comercial,
                   c.numero_cod_pais as crt_cod_pais,
                   c.numero_certificado as crt_num_permisso
              from fiscal.v$intc_conhecimento c
              left join kss.v$pessoa f
                     on f.cod_pessoa = c.cod_pessoa_filial
              left join kss.v$pessoa rem
                     on rem.cod_pessoa = c.cod_remetente
              left join kss.v$pessoa dest
                     on dest.cod_pessoa = c.cod_destinatario
             where 1 = 1
			<cfif len(trim(arguments.conhecimento_id))>
			   and c.conhecimento_id = #arguments.conhecimento_id#
			</cfif>
          	<cfif len(trim(arguments.num_crt_completo))>
			   and upper(replace(c.num_crt_completo,'.','')) = upper(replace('#arguments.num_crt_completo#','.',''))
			</cfif>
			<cfif len(trim(arguments.cod_remetente))>
			   and c.cod_remetente = #arguments.cod_remetente#
			</cfif>
			<cfif len(trim(arguments.cod_destinatario))>
			   and c.cod_destinatario = #arguments.cod_destinatario#
			</cfif>
			<cfif len(trim(arguments.numero))>
			   and upper(replace(c.num_crt_completo,'.','')) like upper(replace('%#arguments.numero#%','.',''))
			</cfif>
			<cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			</cfif>
            <cfif arguments.diaria eq 1>
			   and c.tipo_crt = #arguments.diaria#
			</cfif>
			 order by c.numero_cod_pais desc, c.numero_certificado desc, c.numero_sequencial desc
       </cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	

    <!--- 
	-- PROPSITO
	-- Retorna dados do embarque
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 18/05/2009
	--->
	<cffunction name="get_intc_crt_divisao" displayname="Retorna o prximo nmero de CRT de acordo com o pas informado" output="true" returntype="query" access="remote">
		<cfargument name="conhecimento_id" required="no" default=""> 
		<cfargument name="num_romaneio" required="no" default="">
        <cfargument name="mostra_canceladas" required="no" default="1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select ce.conhecimento_id, c.numero_cod_pais || '.' || c.numero_certificado || '.' || to_char(c.numero_sequencial,'000000') as numero_crt,
                               ce.embarque_id, to_char(ce.data_embarque,'dd/mm/yyyy') as data_embarque,
                               to_char(ced.data_divisao,'dd/mm/yyyy') as data_divisao,
                               dense_rank() over(order by ce.embarque_id) as num_embarque,
                               ced.divisao_id, ced.cod_pessoa_motorista, pm.cliente as motorista,        
                               (select max(r2.distancia_padrao)
						          from oper.v$rota r2
						         where r2.origem_municipio_id = c.resp_municipio_id
						           and r2.destino_municipio_id = c.dest_municipio_id)  as km_crt,
                               ced.rota_id, r.descricao_rota, r.abreviatura, r.distancia_padrao, ced.percentual_crt,
                               ced.cod_moeda, ced.valor, ct.cod_centro_custo as filial, ced.valor * c.cotacao as valor_reais, (c.total_custo_origem + c.total_custo_destino) as valor_frete,
                               ced.cod_moeda, ced.valor, to_char(ced.data_cancelamento,'DD/MM/YYYY hh24:mi:ss') as data_cancelamento, to_char(ced.date_insert,'DD/MM/YYYY hh24:mi:ss') as date_insert, ced.user_insert,
                               (select oper.pkg_veiculo.fnc_veiculo_modalidade(v.placa)
                                  from fiscal.v$intc_crt_embarque_div_comp cec
                                 inner join oper.v$veiculo v
                                         on v.veiculo_id = cec.veiculo_id 
                                 where cec.divisao_id = ced.divisao_id
                                   and cec.ordem = 0) as modalidade,                       
                               (select oper.pkg_veiculo.fnc_get_cod_veiculo(v.placa)
                                  from fiscal.v$intc_crt_embarque_div_comp cec
                                 inner join oper.v$veiculo v
                                         on v.veiculo_id = cec.veiculo_id 
                                 where cec.divisao_id = ced.divisao_id
                                   and cec.ordem = 0) as placa_controle,
                               (select v.placa
                                  from fiscal.v$intc_crt_embarque_div_comp cec
                                 inner join oper.v$veiculo v
                                         on v.veiculo_id = cec.veiculo_id 
                                 where cec.divisao_id = ced.divisao_id
                                   and cec.ordem = 0) as placa,
                               (select kss.fnc_concat_all(kss.to_concat_expr(oper.pkg_veiculo.fnc_get_cod_veiculo(v.placa),','))
                                  from fiscal.v$intc_crt_embarque_div_comp cec
                                 inner join oper.v$veiculo v
                                         on v.veiculo_id = cec.veiculo_id 
                                 where cec.divisao_id = ced.divisao_id
                                   and cec.ordem > 0) as placa_referencia_composicao, ced.lancto_id, ct.num_formulario, ct.serie_formulario as serie,
                                   (select v.placa
                                  from fiscal.v$intc_crt_embarque_div_comp cec
                                 inner join oper.v$veiculo v
                                         on v.veiculo_id = cec.veiculo_id 
                                 where cec.divisao_id = ced.divisao_id
                                   and cec.ordem = 0) as placa_frota_controle
                          from fiscal.v$intc_crt_embarque ce
                         inner join fiscal.v$intc_conhecimento c
                                 on c.conhecimento_id = ce.conhecimento_id
                         inner join fiscal.v$intc_crt_embarque_divisao ced
                                 on ced.embarque_id = ce.embarque_id
                          <cfif arguments.mostra_canceladas eq 0>
                                and ced.data_cancelamento is null
                          </cfif>
                         left join kss.v$pessoa pm 
                                 on pm.cod_pessoa = ced.cod_pessoa_motorista
                         left join oper.v$rota r
                                 on r.rota_id = ced.rota_id
                         left join oper.v$contrato_transp ct
                                on ct.lancto_id = ced.lancto_id
             <cfif Len(Trim(arguments.num_romaneio))>
             inner join oper.v$romaneio_intc_conhecimento ic
                     on ic.conhecimento_id = ce.conhecimento_id
                    and ic.num_romaneio = #arguments.num_romaneio#
             </cfif>
             where 1=1
               <cfif Len(Trim(arguments.conhecimento_id))>
               and ce.conhecimento_id = #arguments.conhecimento_id#
               </cfif>
               order by ce.embarque_id, ced.divisao_id
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>  

	<!--- 
	-- PROPSITO
	-- Retorna os dados dos contrato de transporte de um conhecimento
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 29/06/2009
	--->
	<cffunction name="get_contrato_transporte" displayname="Retorna os dados dos contrato de transporte de um conhecimento" output="true" returntype="query" access="remote">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select ct.lancto_id
             	   ,c.conhecimento_id
                   ,rc.num_romaneio
                   ,ct.cod_centro_custo as cod_filial
                   ,fi.nome as filial
                   ,ct.num_formulario as carta_frete
                   ,pf.cpf ||' - '||pf.nome as motorista
                   ,to_char(ct.data_emissao,'dd/mm/yyyy') as data_emissao
                   ,ct.valor_frete_liquido as valor_frete_motorista
                   ,(c.total_custo_origem + c.total_custo_destino) as valor_frete_empresa
                   ,replace(replace(replace(to_char(((ct.valor_frete_liquido / ((c.total_custo_origem + c.total_custo_destino)*c.cotacao))*100), '999G999G990D00'), '.', '%'), ',','.'),'%',',') as porcentagem
              from fiscal.v$intc_conhecimento c
        inner join oper.v$romaneio_intc_conhecimento rc
                on rc.conhecimento_id =  c.conhecimento_id
        inner join oper.v$contrato_transp ct
                on ct.num_romaneio = rc.num_romaneio
        inner join kss.v$pessoa_fisica pf
                on pf.cod_pessoa = ct.motorista_cod_pessoa
        inner join oper.v$filial fi
                on fi.cod_pessoa = ct.cod_pessoa_filial
             where 1=1
               <cfif Len(Trim(arguments.conhecimento_id))>
               and c.conhecimento_id = #arguments.conhecimento_id#
               </cfif>
               order by ct.num_formulario, ct.lancto_id
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Relao de CRTs para Importao e Exportao
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 06/07/2009
	--->
	<cffunction name="get_crts_importacao" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfargument name="cod_pais" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.num_crt_completo as numero_crt,
                   c.emissao_data,
                   case
                      when m.manifesto_id is not null then
                         replace(m.numero_cod_pais || '.' || m.numero_certificado || '.' || replace(to_char(m.numero_sequencial,'000,000'), ',','.'), ' ','')
                      else ''
                   end as numero_mic,
                   ice.data_embarque,
                   (v.placa || nvl2(v2.placa, ' / ' || v2.placa, '')) as placas,
                   decode(oper.pkg_veiculo.fnc_veiculo_proprietario(v.placa), 1, 'Frota', 2, 'Agregado', 'Terceiro') as proprietario,
                   c.peso_bruto,
                   c.valor_mercadorias as valor_mercadoria,
                   (c.total_custo_origem + c.total_custo_destino) as valor_frete,
                   c.rem_nome,
                   c.dest_nome,
                   c.resp_local as origem_local,
                   c.dest_cidade as destino_local,
                   decode(c.pago_por, 1, c.rem_nome, c.dest_nome) as pagador,
                   f.descricao as fronteira,
                   pfi.cliente as filial,
                   c.cotacao,
                   (select sum(ind.valor_servico) / count(*)
                      from fiscal.v$intc_despacho ind
                     inner join fiscal.v$intc_despacho_item idi
                             on idi.despacho_id = ind.despacho_id
                     where idi.conhecimento_id = c.conhecimento_id
                       and ind.cancelado = 0
                       and ind.cod_motorista = m.veic_orig_mot_cod_pessoa) as total_dti,
                   kss.pkg_organizacional.fnc_descricao_completa(c.organizacional_id_gerencial) as organizacional_gerencial
              from fiscal.v$intc_conhecimento c
             inner join fiscal.v$intc_conhecimento_fronteira cf
                     on cf.conhecimento_id = c.conhecimento_id
             inner join fiscal.v$fronteira f
                     on f.fronteira_id = cf.fronteira_id
             inner join fiscal.v$intc_crt_embarque ice
                     on ice.conhecimento_id = c.conhecimento_id
             inner join fiscal.v$intc_crt_embarque_divisao iced
                     on iced.embarque_id = ice.embarque_id
             inner join fiscal.v$intc_crt_embarque_div_comp icomp
                     on icomp.divisao_id = iced.divisao_id
                    and icomp.ordem = 0
             inner join oper.v$veiculo v
                     on v.veiculo_id = icomp.veiculo_id
             inner join kss.v$pessoa pfi
                     on pfi.cod_pessoa = c.cod_pessoa_filial
              left join fiscal.v$intc_crt_embarque_div_comp icomp2
                     on icomp2.divisao_id = iced.divisao_id
                    and icomp2.ordem = 1
              left join oper.v$veiculo v2
                     on v2.veiculo_id = icomp2.veiculo_id
              left join fiscal.v$intc_manifesto_crt imc
                     on imc.conhecimento_id = c.conhecimento_id
              left join fiscal.v$intc_manifesto m
                     on m.manifesto_id = imc.manifesto_id
			 where 1 = 1
			<cfif Len(Trim(arguments.cod_pais))>
				<cfif arguments.cod_pais eq 'EX'>
				    and c.numero_cod_pais <> 'BR'
                <cfelse>
                    and c.numero_cod_pais = '#arguments.cod_pais#'
                </cfif>
			</cfif>
			   and trunc(c.emissao_data) between '#arguments.data_inicial#' and '#arguments.data_final#'
			 order by c.num_crt_completo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Relao de CRTs para Importao e Exportao (Resumo)
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 06/07/2009
	--->
	<cffunction name="get_crt_por_modalidade" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_pais" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select to_char(c.emissao_data,'mm/yyyy') as mes_ano,
                   to_char(c.emissao_data,'yyyymm') ordem,
                   decode(oper.pkg_veiculo.fnc_veiculo_proprietario(v.placa), 1, 'Frota', 2, 'Agregado', 'Terceiro') as proprietario,
                   sum(c.total_custo_origem + c.total_custo_destino) as valor_frete
              from fiscal.v$intc_conhecimento c
             inner join fiscal.v$intc_conhecimento_fronteira cf
                     on cf.conhecimento_id = c.conhecimento_id
             inner join fiscal.v$fronteira f
                     on f.fronteira_id = cf.fronteira_id
             inner join fiscal.v$intc_crt_embarque ice
                     on ice.conhecimento_id = c.conhecimento_id
             inner join fiscal.v$intc_crt_embarque_divisao iced
                     on iced.embarque_id = ice.embarque_id
             inner join fiscal.v$intc_crt_embarque_div_comp icomp
                     on icomp.divisao_id = iced.divisao_id
                    and icomp.ordem = 0
             inner join oper.v$veiculo v
                     on v.veiculo_id = icomp.veiculo_id
             where 1 = 1
               and trunc(c.emissao_data) >= trunc(last_day(sysdate - 180) + 1)
			<cfif Len(Trim(arguments.cod_pais))>
				<cfif arguments.cod_pais eq 'EX'>
					and c.numero_cod_pais <> 'BR'
                <cfelse>
                    and c.numero_cod_pais = '#arguments.cod_pais#'
                </cfif>
			</cfif>
             group by to_char(c.emissao_data,'mm/yyyy'), to_char(c.emissao_data,'yyyymm'), decode(oper.pkg_veiculo.fnc_veiculo_proprietario(v.placa), 1, 'Frota', 2, 'Agregado', 'Terceiro')
             order by to_char(c.emissao_data,'yyyymm')
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna todos os pases cadastrados
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->	
	<cffunction name="get_pais" displayname="Retorna todos os pases cadastrados" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select pais_id, initcap(descricao) as descricao, id_2, id_3, id_iso, verifica_documentos , 
				   user_insert, date_insert, user_update, date_update 
			  from cep.pais
			order by descricao  
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os pagamentos do periodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 28/03/2006
	--->		
	<cffunction name="get_intc_rem_dest" access="remote" returntype="query" output="true">
        <cfargument name="NUMERO_CRT" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.conhecimento_id,c.rem_cidade, c.dest_cidade, to_char(c.data_entrega, 'dd/mm/yyyy hh24:mi') as data_entrega
			  from fiscal.v$intc_conhecimento c
			 where 1=1
			<cfif Len(Trim(arguments.numero_crt))>
			   and upper(replace(c.num_crt_completo,'.','')) = upper(replace('#arguments.numero_crt#','.',''))
			</cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Lista os conhecimentos internacionais
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_intc_conhecimento" displayname="Lista os conhecimentos internacionais" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="data_inicio_primeiro_embarque" required="no" default="">
		<cfargument name="data_fim_primeiro_embarque" required="no" default="">
		<cfargument name="faturar" required="no" default="">
		<cfargument name="cancelado" required="no" default="">
		<cfargument name="lib_fatura" required="no" default="">
		<cfargument name="nao_embarcado" required="no" default="">
		<cfargument name="quitado" required="no" default="">
		<cfargument name="pre_conhecimento" required="no" default="">
		<cfargument name="cod_pessoa_pagador" required="no" default="">
		<cfargument name="numero" required="no" default="">
        <cfargument name="num_crt_completo" required="no" default="">
		<cfargument name="conferido" required="no" default="">
		<cfargument name="data_inicio_lib_fatura" required="no" default="">
		<cfargument name="data_fim_lib_fatura" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select c.conhecimento_id,
                   versao,
                   numero_cod_pais,
                   numero_certificado,
                   numero_sequencial,
                   upper(numero_cod_pais || '.' || numero_certificado || '.' ||
                         replace(to_char(numero_sequencial, '000000'), ' ', '')) as numero,
                   cod_pessoa_filial,
                   emissao_local,
                   emissao_municipio_id,
                   emissao_data,
                   case
                     when pago_por = 1 then
                      'CRT de amostra'
                     when pago_por = 2 then
                      rem_nome
                     when pago_por = 3 then
                      dest_nome
                     when pago_por = 4 then
                      rem_nome || '/' || dest_nome
                   end pagador,
                   resp_local,
                   resp_municipio_id,
                   resp_data,
                   entrega_local,
                   entrega_municipio_id,
                   entrega_data,
                   transp_sucessivos,
                   cod_remetente,
                   rem_nome,
                   rem_endereco,
                   rem_cidade,
                   rem_uf,
                   rem_pais,
                   rem_cnpj_cpf,
                   cod_destinatario,
                   dest_nome,
                   dest_endereco,
                   dest_cidade,
                   dest_uf,
                   dest_pais,
                   dest_cnpj_cpf,
                   cod_consignatario,
                   cons_nome,
                   cons_endereco,
                   cons_cidade,
                   cons_uf,
                   cons_pais,
                   cons_cnpj_cpf,
                   cod_notificar,
                   not_endereco,
                   not_cidade,
                   not_uf,
                   not_pais,
                   not_cnpj_cpf,
                   mercadorias,
                   num_especie,
                   quantidade_total,
                   peso_bruto,
                   peso_liquido,
                   unidade_id,
                   m3,
                   valor_total,
                   (select moeda
                      from finan.v$moeda_bacen
                     where cod_moeda = valor_total_cod_moeda) as valor_total_cod_moeda,
                   valor_total_incoterm_id,
                   total_custo_origem,
                   (select moeda
                      from finan.v$moeda_bacen
                     where cod_moeda = total_custo_origem_cod_moeda) as total_custo_origem_cod_moeda,
                   total_custo_destino,
                   (select moeda
                      from finan.v$moeda_bacen
                     where cod_moeda = total_custo_destino_cod_moeda) as total_custo_destino_cod_moeda,
                   valor_frt_externo,
                   valor_frt_externo_cod_moeda,
                   valor_reembolso,
                   valor_reembolso_cod_moeda,
                   valor_mercadorias,
                   valor_mercadorias_cod_moeda,
                   alfandega_origem_id,
                   alfandega_destino_id,
                   pago_por,
                   declaracao_observacao,
                   impresso,
                   cancelado,
                   liberado_fatura,
                   case
                      when exists (select 1
                                     from fiscal.v$intc_conhecimento_receber cr
                                    where cr.conhecimento_id = c.conhecimento_id) then 1
                      else 0
                   end as faturado,
                   quitado,
                   (select fcr.num_docto
                      from fiscal.v$intc_conhecimento_receber cr
                     inner join finan.v$finan_contas_receber fcr
                             on fcr.contas_receber_id = cr.contas_receber_id
                     where cr.conhecimento_id = c.conhecimento_id) as num_fatura,
                   qtde_veiculos,
                   c.obs_pago_por,
                   seguro_pago_empresa,
                   nvl(c.cotacao, 0) as cotacao,
                   c.cod_organograma,
                   o.cod_centro_custo,
                   cce.centro_custo,
                   c.conferido as conferido,
                   (select min(im.data_emissao)
                      from fiscal.v$intc_manifesto im
                     inner join fiscal.v$intc_manifesto_crt imc on imc.manifesto_id =
                                                                   im.manifesto_id
                     where imc.conhecimento_id = c.conhecimento_id) as primeiro_embarque,
                   c.data_lib_fatura,
                   c.data_entrega,
                   (select max(r.descricao_rota) keep(dense_rank first order by r.origem_cod_pessoa nulls last, r.destino_cod_pessoa nulls last)
                      from fiscal.v$intc_conhecimento c2
                     inner join cep.municipio mo
                             on mo.municipio_id = c2.resp_municipio_id
                     inner join cep.municipio md
                             on md.municipio_id = c2.entrega_municipio_id
                     inner join oper.v$rota r
                             on r.referencia_origem_id = mo.referencia_id
                            and r.referencia_destino_id = md.referencia_id
                            and (r.origem_cod_pessoa = c2.cod_remetente or r.origem_cod_pessoa is null)
                            and (r.destino_cod_pessoa = c2.cod_destinatario or r.destino_cod_pessoa is null)
                     where c2.conhecimento_id = c.conhecimento_id
                   ) as descricao_rota,
                   (select max(r.abreviatura) keep(dense_rank first order by r.origem_cod_pessoa nulls last, r.destino_cod_pessoa nulls last)
                      from fiscal.v$intc_conhecimento c2
                     inner join cep.municipio mo
                             on mo.municipio_id = c2.resp_municipio_id
                     inner join cep.municipio md
                             on md.municipio_id = c2.entrega_municipio_id
                     inner join oper.v$rota r
                             on r.referencia_origem_id = mo.referencia_id
                            and r.referencia_destino_id = md.referencia_id
                            and (r.origem_cod_pessoa = c2.cod_remetente or r.origem_cod_pessoa is null)
                            and (r.destino_cod_pessoa = c2.cod_destinatario or r.destino_cod_pessoa is null)
                     where c2.conhecimento_id = c.conhecimento_id
                   ) as abreviatura_rota,
                   (select max(r.distancia_padrao) keep(dense_rank first order by r.origem_cod_pessoa nulls last, r.destino_cod_pessoa nulls last)
                      from fiscal.v$intc_conhecimento c2
                     inner join cep.municipio mo
                             on mo.municipio_id = c2.resp_municipio_id
                     inner join cep.municipio md
                             on md.municipio_id = c2.entrega_municipio_id
                     inner join oper.v$rota r
                             on r.referencia_origem_id = mo.referencia_id
                            and r.referencia_destino_id = md.referencia_id
                            and (r.origem_cod_pessoa = c2.cod_remetente or r.origem_cod_pessoa is null)
                            and (r.destino_cod_pessoa = c2.cod_destinatario or r.destino_cod_pessoa is null)
                     where c2.conhecimento_id = c.conhecimento_id
                   ) as distancia_padrao,
                   c.cod_pagador_origem,
                   c.pag_origem_nome,
                   c.pag_origem_endereco,
                   c.pag_origem_cidade,
                   c.pag_origem_uf,
                   c.pag_origem_pais,
                   c.pag_origem_cnpj_cpf,
                   c.cod_pagador_destino,
                   c.pag_destino_nome,
                   c.pag_destino_endereco,
                   c.pag_destino_cidade,
                   c.pag_destino_uf,
                   c.pag_destino_pais,
                   c.pag_destino_cnpj_cpf,
                   c.embarcado,
                   decode(c.embarcado,
                          0,
                          null,
                          to_char(c.data_ult_embarque, 'dd/mm/yyyy')) as data_embarque,
                   c.pre_conhecimento,
                   (select sign(count(1))
                      from fiscal.v$intc_crt_comercial_versao ccv
                     where ccv.conhecimento_id = c.conhecimento_id) as possui_tabela_frete
              from fiscal.v$intc_conhecimento c
              left join kss.v$organograma o
              		 on o.cod_organograma = c.cod_organograma
              left join kss.v$centro_custo cce
              		 on cce.cod_centro_custo = o.cod_centro_custo
			 <cfif Len(Trim(arguments.cod_pessoa_pagador))>
			 inner join fiscal.v$intc_conhecimento_custo cc
					 on cc.conhecimento_id = c.conhecimento_id 
			 </cfif>			 
			 where 1=1
			 <cfif Len(Trim(arguments.DATA_INICIO_PRIMEIRO_EMBARQUE)) and Len(Trim(arguments.DATA_FIM_PRIMEIRO_EMBARQUE))>
				and c.data_ult_embarque between '#arguments.DATA_INICIO_PRIMEIRO_EMBARQUE#' and '#arguments.DATA_FIM_PRIMEIRO_EMBARQUE#'
			 </cfif>
			 <cfif Len(Trim(arguments.NAO_EMBARCADO))>
				and (c.embarcado = 0 or c.data_ult_embarque > to_date('#arguments.data_fim#','dd/mm/yyyy'))
			 </cfif>
			 <cfif Len(Trim(arguments.cod_centro_custo))>
			   and kss.to_organograma(c.cod_organograma).cod_centro_custo = #arguments.cod_centro_custo#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_pagador))>
			   and case
					 when pago_por = 2 then cod_remetente
					 when pago_por = 3 then cod_destinatario
					 when pago_por = 4 and nvl(cc.valor_origem,0) > 0 then c.cod_remetente
					 when pago_por = 4 and nvl(cc.valor_destino,0) > 0 then c.cod_destinatario
				   end = #arguments.cod_pessoa_pagador#
			 </cfif>
			 <cfif Len(Trim(arguments.num_crt_completo))>
			   and upper(replace(c.num_crt_completo,'.','')) like upper(replace('%#arguments.num_crt_completo#%','.',''))
			 </cfif>
             <cfif Len(Trim(arguments.numero))>
			   and upper(replace(c.num_crt_completo,'.','')) like upper(replace('%#arguments.numero#%','.',''))
			 </cfif>
			 <cfif Len(Trim(arguments.conhecimento_id))>
			   and c.conhecimento_id in (#arguments.conhecimento_id#)
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif Len(Trim(arguments.faturar))>
			   and c.faturado = 0
			   and c.cancelado = 0
			 </cfif>
			 <cfif Len(Trim(arguments.cancelado))>
			   and c.cancelado = #arguments.cancelado#
    		 <cfelse>
			   and c.cancelado = 0
			 </cfif>
			 <cfif Len(Trim(arguments.lib_fatura))>
			   and c.liberado_fatura in (#arguments.lib_fatura#)
			 </cfif>
			 <cfif Len(Trim(arguments.quitado))>
			   and c.quitado = #arguments.quitado#
			 </cfif>
			 <cfif Len(Trim(arguments.conferido))>
			   and c.conferido = #arguments.conferido#
			 </cfif>
			 <cfif Len(Trim(arguments.pre_conhecimento))>
			   and c.pre_conhecimento = #arguments.pre_conhecimento#
    		 <cfelse>
			   and c.pre_conhecimento = 0
			 </cfif>
    
			 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
			   and to_date(to_char(c.emissao_data,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments.data_inicio#','dd/mm/yyyy') and to_date('#arguments.data_fim#','dd/mm/yyyy')
			 </cfif>
			 <cfif Len(Trim(arguments.data_inicio_lib_fatura)) and Len(Trim(arguments.data_fim_lib_fatura))>
			   and to_date(to_char(c.data_lib_fatura,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments.data_inicio_lib_fatura#','dd/mm/yyyy') and to_date('#arguments.data_fim_lib_fatura#','dd/mm/yyyy')
			 </cfif>
			 order by c.numero_cod_pais, c.numero_certificado, c.numero_sequencial  
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca de CRTs por Romaneio, CRT e MIC
	-- NOTAS EXPLICATIVAS
	-- WAGNER  02/02/2007
	--->		
	<cffunction name="get_crts_por_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="numero_crt" required="no" default="">
		<cfargument name="numero_mic" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select replace(c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(to_char(c.numero_sequencial,'000,000'), ',','.'),' ','') as numero_crt, 
			       c.emissao_data,
				   replace(m.numero_cod_pais || '.' || m.numero_certificado || '.' || replace(to_char(m.numero_sequencial,'000,000'), ',','.'),' ','') as numero_mic,
				   '' as data_embarque,
				   m.veic_orig_placa_controle || ' / ' || m.veic_orig_placa_referencia as placas,
					decode(oper.pkg_veiculo.fnc_veiculo_proprietario(m.veic_orig_placa_controle),1,'Frota',2,'Agregado','Terceiro') as proprietario,
				   (select sum(mci.peso_bruto)
					  from fiscal.v$intc_manifesto_crt_item mci
					 where mci.manifesto_id = mc.manifesto_id
					   and mci.conhecimento_id = mc.conhecimento_id) as peso_bruto,
				   (select sum(mci.valor_fot)
					  from fiscal.v$intc_manifesto_crt_item mci
					 where mci.manifesto_id = mc.manifesto_id
					   and mci.conhecimento_id = mc.conhecimento_id) as valor_mercadoria,
				   (select sum(mci.valor_total)
					  from fiscal.v$intc_manifesto_crt_item mci
					 where mci.manifesto_id = mc.manifesto_id
					   and mci.conhecimento_id = mc.conhecimento_id) as valor_frete,
					mc.rem_nome, mc.dest_nome, c.resp_local as origem_local, m.destino_local,
					decode(c.PAGO_POR,1,c.REM_NOME, c.DEST_NOME) as pagador,
					cep.fnc_cidade_completa(f.municipio_id_1) as fronteira,
					f.descricao as filial,
					m.num_romaneio as num_romaneio
			  from fiscal.v$intc_manifesto m
	    inner join fiscal.v$intc_manifesto_crt mc
		    	on mc.manifesto_id = m.manifesto_id
		inner join fiscal.v$intc_conhecimento c
				on c.conhecimento_id = mc.conhecimento_id
		 /* left join oper.v$filial f
			    on f.cod_pessoa = c.cod_pessoa_filial */
		 inner join fiscal.v$intc_conhecimento_fronteira cf
                 on cf.conhecimento_id = c.conhecimento_id
         inner join fiscal.v$fronteira f
				on f.fronteira_id = cf.FRONTEIRA_ID
			where 1=1
			<cfif Len(Trim(arguments.numero_mic))>
			  and upper(replace(m.num_mic_completo,'.','')) like upper(replace('%#arguments.numero_mic#%','.',''))
			</cfif>
			<cfif Len(Trim(arguments.num_romaneio))>
			  and m.num_romaneio 	= #arguments.num_romaneio#
         	</cfif>
			<cfif Len(Trim(arguments.numero_crt)) and ( not( Len(Trim(arguments.num_romaneio)) ) )>
			  and m.manifesto_id in (select mc.manifesto_id
                           			   from fiscal.v$intc_manifesto_crt mc
                           		 inner join fiscal.v$intc_conhecimento c
                           				 on c.conhecimento_id 	 = mc.conhecimento_id
                           			  where 1=1
                                        and upper(replace(c.num_crt_completo,'.','')) like upper(replace('%#arguments.numero_crt#%','.',''))
                                      )
			<cfelse>
					<cfif Len(Trim(arguments.numero_crt))>
                    	and upper(replace(c.num_crt_completo,'.','')) like upper(replace('%#arguments.numero_crt#%','.',''))
					</cfif>
			</cfif>
		  order by numero_crt, numero_mic, num_romaneio 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os permissos
	-- RAFAEL   29/11/2007
	--->		
	<cffunction name="get_permisso" access="remote" returntype="query" output="true">
    	<cfargument name="tipo_documento" required="no" default="">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.permisso_id
            	  ,t.cod_pais
                  ,t.num_permisso
                  ,t.num_sequencial_inicial
                  ,t.tipo_documento
                  ,t.serie
                  ,decode(t.tipo_documento, 0 , 'CRT', 1, 'MIC', 'Outros') as tipo_descricao
            from fiscal.v$intc_permisso t
        <cfif Len(Trim(#arguments.tipo_documento#))>
           where t.tipo_documento = #arguments.tipo_documento# 
        </cfif>
            order by t.cod_pais
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>