<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!---
    -- PROPSITO
    -- Retorna o status de validao das integraes com a Pamcard
    -- FABIOG 18/03/2014 - CRIADO
    --->
    <cffunction name="get_validacao_romaneio" access="remote" returntype="Struct" output="true">
        <cfargument name="num_romaneio" required="yes" />
        <cfargument name="cartao_numero" required="yes" />
        <cfargument name="rota_id" required="yes" />
        <cfargument name="cod_contratado" required="yes" />
        <cfargument name="cod_motorista" required="yes" />
        <cfargument name="placa_cavalo" required="yes" />
        <cfargument name="placa_carreta" required="yes" />
        <cftry>
           <cftransaction action='begin'>
              <cfif arguments.placa_carreta eq arguments.placa_cavalo>
                 <cfset arguments.placa_carreta = '' />
              </cfif>

              <!--- Faz a validao dos dados da ANTT--->
              <cfscript>
                 conn = CreateComponent("modulos.pamcard._componentes.manipulacao.cfc_pamcard");
                 ret_antt = conn.retorno_antt(placa_cavalo   = arguments.placa_cavalo
                                             ,placa_carreta  = arguments.placa_carreta
                                             ,cod_contratado = arguments.cod_contratado
                                             );

              </cfscript>
              <cfif ret_antt.erro>
                 <cfthrow object="#ret_antt.mensagem#">
              </cfif>

              <cfset retorno.veiculo_validado_antt = ret_antt.veiculo_validado_antt>
              <cfset retorno.veiculo_erro = ret_antt.veiculo_erro>
              <cfset retorno.carreta_validado_antt = ret_antt.carreta_validado_antt>
              <cfset retorno.carreta_erro = ret_antt.carreta_erro>
              <cfset retorno.contratado_validado_antt = ret_antt.contratado_validado_antt>
              <cfset retorno.contratado_erro = ret_antt.contratado_erro>

              <!--- Faz a validao das pessoas fiscais --->
              <cfscript>
                 ret_pf = conn.retorno_pessoa_fiscal(cod_pessoa	   = session.cod_pessoa
					                                     ,num_romaneio = arguments.num_romaneio);
              </cfscript>
              <cfif ret_pf.erro>
                 <cfthrow object="#ret_pf.mensagem#">
              </cfif>

              <cfset retorno.remetente_ok = ret_pf.remetente_ok>
              <cfset retorno.destinatario_ok = ret_pf.destinatario_ok>
              <cfset retorno.consignatario_ok = ret_pf.consignatario_ok>

              <cfif Len(Trim(arguments.num_romaneio))>
                 <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select case
                             when '#arguments.cartao_numero#' is not null then
                                 pamcard.pkg_integracao.fnc_cartao_ok(#session.cod_pessoa#, '#arguments.cartao_numero#', '#arguments.cod_motorista#', '#arguments.favorecido_cartao_cod_pessoa#')
                             else
                                'Carto no informado'
                           end as cartao_ok
                         , case
                              when '#arguments.rota_id#' is not null then
                                 pamcard.pkg_integracao.fnc_rota_ok(#session.cod_pessoa#, '#arguments.placa_cavalo#', null, v.viagem_id, '#arguments.rota_id#')
                              else ''
                           end as rota_ok
                         , case
                              when '#arguments.cod_contratado#' is not null then
                                 pamcard.pkg_integracao.fnc_contratado_ok(#session.cod_pessoa#, null, v.viagem_id, '#arguments.cod_contratado#')
                              else ''
                           end as contratado_ok
                         , case
                              when '#arguments.cod_motorista#' is not null then
                                 pamcard.pkg_integracao.fnc_motorista_ok(#session.cod_pessoa#, null, v.viagem_id, '#arguments.cod_motorista#')
                              else ''
                           end as motorista_ok
                         , case
                              when '#arguments.placa_cavalo#' is not null then
                                 pamcard.pkg_integracao.fnc_veiculo_ok(#session.cod_pessoa#, '#arguments.placa_cavalo#', '#arguments.placa_carreta#')
                              else ''
                           end as veiculo_ok
                         , case
                              when '#arguments.placa_cavalo#' is not null then
                                 oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
                              else 0
                           end as numero_eixos
                      from logistica.v$viagem v
                     where v.num_romaneio = #arguments.num_romaneio#
                    </cfquery>
               <cfelse>
                  <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                     select case
                               when '#arguments.cartao_numero#' is not null then
                                  pamcard.pkg_integracao.fnc_cartao_ok(#session.cod_pessoa#, '#arguments.cartao_numero#', '#arguments.cod_motorista#', '#arguments.favorecido_cartao_cod_pessoa#')
                               else 'Carto no informado'
                            end as cartao_ok
                          , case
                               when '#arguments.rota_id#' is not null then
                                  pamcard.pkg_integracao.fnc_rota_ok(#session.cod_pessoa#, '#arguments.placa_cavalo#', null, null, '#arguments.rota_id#')
                               else ''
                            end as rota_ok
                          , case
                               when '#arguments.cod_contratado#' is not null then
                                  pamcard.pkg_integracao.fnc_contratado_ok(#session.cod_pessoa#, null, null, '#arguments.cod_contratado#')
                            else ''
                            end as contratado_ok
                          , case
                               when '#arguments.cod_motorista#' is not null then
                                  pamcard.pkg_integracao.fnc_motorista_ok(#session.cod_pessoa#, null, null, '#arguments.cod_motorista#')
                               else ''
                            end as motorista_ok
                          , case
                               when '#arguments.placa_cavalo#' is not null then
                                  pamcard.pkg_integracao.fnc_veiculo_ok(#session.cod_pessoa#, '#arguments.placa_cavalo#', '#arguments.placa_carreta#')
                               else ''
                            end as veiculo_ok
                          , case
                               when '#arguments.placa_cavalo#' is not null then
                                  oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
                               else 0
                            end as numero_eixos
                         from dual
                 </cfquery>
              </cfif>
                <cfset retorno.query = qr_result>
                <cfset retorno.erro = false>
            </cftransaction>
         <cfcatch>
            <cftransaction action='rollback'/>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
         </cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>

   <!---
	-- PROPSITO
	-- Retorna os dados de vale pedgio, depois que  chamado o mtodo roteirizar
	-- FABIOG 19/03/2014
	--->
	<cffunction name="get_pedagio_rota" access="remote" returntype="query" output="true">
    	<cfargument name="rota_id" required="no" default="">
      <cfargument name="numero_eixos" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.roteirizacao_id
                 , r.rota_id
                 , r.valor_pedagio
                 , r.numero_eixos
              from pamcard.v$roteirizacao r
             where 1 = 1

         <cfif Len(Trim(arguments.rota_id))>
            and r.rota_id = #arguments.rota_id#
         </cfif>
         <cfif Len(Trim(arguments.numero_eixos))>
            and r.rota_id = #arguments.numero_eixos#
         </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

   <!---
    -- PROPSITO
    -- Retorna os contratos
    -- ANDERSONC 01/11/2011 - CRIADO
    --->
    <cffunction name="get_contrato" access="remote" returntype="query" output="true">
       <cfargument name="contrato_id" required="no" default="" />
       <cfargument name="solicitacao_carga_id" required="no" default="" />
       <cfargument name="viagem_id" required="no" default="" />
       <cfargument name="num_romaneio" required="no" default="" />
       <cfargument name="processo_transporte_codigo" required="no" default="" />
       <cfargument name="lancto_id" required="no" default="" />
       <cfargument name="cod_pessoa_filial" required="no" default="" />
       <cfargument name="cod_centro_custo" required="no" default="" />
       <cfargument name="placa_cavalo" required="no" default="" />
       <cfargument name="placa_carreta" required="no" default="" />
       <cfargument name="cod_motorista" required="no" default="" />
       <cfargument name="tipo_contrato" required="no" default="" />
       <cfargument name="internacional" required="no" default="" />
       <cfargument name="data_inicio" required="no" default="" />
       <cfargument name="data_termino" required="no" default="" />
    	 <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cd.contrato_id
                 , cd.tipo_contrato
                 , cd.numero_contrato
                 , cd.lancto_id
                 , cd.num_formulario
                 , cd.serie_formulario
                 , case
                      when cd.viagem_id is null then ''
                      else cd.viagem_id ||'-'||cd.viagem_digito
                   end as viagem_id_viagem_digito
                 , cd.numero_cartao_frete
                 , cd.numero_cartao_pedagio
                 , cd.num_romaneio
                 , cd.cod_unidade_negocio
                 , cd.filial
                 , cd.unidade_negocio
                 , cd.cod_centro_custo
                 , cd.centro_custo
                 , cd.cod_organizacional
                 , cd.organizacional_desc
                 , to_char(cd.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , cd.integracao_status
                 , cd.status_integracao_descricao
                 , cd.status_viagem
                 , cd.status_pedagio
                 , cd.status_aprovacao
                 , cd.status_aprovacao_descricao
                 , cd.cnpj_cpf_proprietario
                 , cd.proprietario
                 , cd.cpf_motorista
                 , cd.motorista
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(cd.placa_cavalo) as cod_veiculo_cavalo
                 , cd.placa_cavalo
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(cd.placa_carreta) as cod_veiculo_carreta
                 , cd.placa_carreta
                 , cd.rota_id
                 , cd.rota
                 , cd.valor_inicial_adiantamento
                 , cd.valor_inicial_frete
                 , cd.valor_frete_bruto
                 , cd.valor_pedagio
                 , cd.percentual_receita
                 , cd.usuario_cancelamento
                 , to_char(cd.cancelamento_data, 'dd/mm/yyyy hh:mm:ss') as cancelamento_data
                 , cd.cancelamento_motivo
                 , cd.permite_cancelar
                 , to_char(cd.encerramento_data, 'dd/mm/yyyy hh:mm:ss') as encerramento_data
                 , cd.encerramento_protocolo
                 , cd.data_pagamento
                 , cd.user_insert
                 , to_char(cd.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , cd.operacao_id
                 , cd.operacao_descricao
                 , pamcard.pkg_integracao.fnc_liberada_adiantamento(cd.contrato_id) as liberada_adiantamento
                 , pamcard.pkg_integracao.fnc_liberada_saldo(cd.contrato_id) as liberada_saldo
                 , pamcard.pkg_integracao.fnc_liberado_encerramento(cd.contrato_id) as encerramento_liberado
                 , cd.ciot
                 , cd.parcela_pendente
                 , cd.status_aprovacao
                 , cd.usuario_aprovacao
                 , to_char(cd.data_aprovacao, 'dd/mm/yyyy hh:mm:ss') as data_aprovacao
                 , cd.usuario_reprovacao
                 , to_char(cd.data_reprovacao, 'dd/mm/yyyy hh:mm:ss') as data_reprovacao
                 , cd.motivo_reprovacao
				 , cd.observacao_aprovacao
				 , cd.diaria_ctrc_id
                 , cd.diaria_crt_id
                 , cd.divisao_id
				 , ct.valor_frete_liquido +
                 	nvl((select sum(cti.valor * decode(cti.desconto,0,1,-1))
	                       from oper.v$contrato_transp_item cti
	                      where cti.lancto_id = ct.lancto_id
	                        and cti.compoe_frete = 1
							and cti.desconto = 0
	                        and cti.data_cancelamento is null),0) as valor_frete_bruto_atual
                 , nvl(ct.valor_maximo_tabela_frete, 0) + nvl(ct.valor_maximo_pedagio, 0) as valor_maximo_gravado
              from pamcard.v$contrato_dados cd
			  left join oper.v$contrato_transp ct
			    on ct.lancto_id = cd.lancto_id
             where 1 = 1
            <cfif Len(Trim(arguments.contrato_id))>
              and cd.contrato_id = #arguments.contrato_id#
            <cfelseif Len(Trim(arguments.solicitacao_carga_id))>
               and exists (select 1
                             from logistica.v$viagem v
                            inner join logistica.v$viagem_carga vc
                                    on vc.viagem_id = v.viagem_id
                            where v.num_romaneio = cd.num_romaneio
                              and vc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
                          )
            <cfelseif Len(Trim(arguments.viagem_id))>
               and exists (select 1
                             from logistica.v$viagem v
                            where v.num_romaneio = cd.num_romaneio
                              and v.viagem_id = #arguments.viagem_id#
                          )
            <cfelseif Len(Trim(arguments.num_romaneio))>
               and cd.num_romaneio = #arguments.num_romaneio#
            <cfelseif Len(Trim(arguments.lancto_id))>
               and cd.lancto_id = #arguments.lancto_id#
            <cfelse>
				<cfif Len(Trim(arguments.cod_pessoa_filial))>
                   and cd.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                </cfif>
                <cfif Len(Trim(arguments.cod_centro_custo))>
                   and cd.cod_centro_custo = #arguments.cod_centro_custo#
                </cfif>
                <cfif Len(Trim(arguments.placa_cavalo))>
                   and cd.placa_cavalo = '#arguments.placa_cavalo#'
                </cfif>
                <cfif Len(Trim(arguments.placa_carreta))>
                   and cd.placa_carreta = '#arguments.placa_carreta#'
                </cfif>
                <cfif Len(Trim(arguments.cod_motorista))>
                   and cd.cod_motorista = #arguments.cod_motorista#
                </cfif>
                <cfif Len(Trim(arguments.cod_proprietario))>
                   and cd.cod_proprietario = #arguments.cod_proprietario#
                </cfif>
                <cfif Len(Trim(arguments.tipo_contrato))>
                   and cd.tipo_contrato = #arguments.tipo_contrato#
                </cfif>
                <cfif Len(Trim(arguments.parcela_pendente))>
                   <cfif arguments.parcela_pendente eq 'N'>
                      and cd.parcela_pendente = 'No'
                   <cfelseif arguments.parcela_pendente eq 'S'>
				      and cd.parcela_pendente = 'Sim'
                   <cfelse>
				      and '#arguments.parcela_pendente#' = 'A'
                   </cfif>
                </cfif>

                <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                   and cd.date_insert between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                <cfelseif Len(Trim(arguments.data_inicio))>
                   and cd.date_insert >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
                <cfelseif Len(Trim(arguments.data_termino))>
                   and cd.date_insert <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                </cfif>
			</cfif>
             order by cd.contrato_id desc
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os parcelas
    -- LEANDRO 01/11/2011 - CRIADO
    --->
    <cffunction name="get_parcela" access="remote" returntype="query" output="true">
       <cfargument name="contrato_id" required="no" default="" />
    	 <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cp.contrato_parcela_id
                 , cp.parcela_numero
                 , cp.parcela_tipo
                 , (select cg.rv_high_value from pamcard.v$cg_ref_codes cg where cg.rv_domain = 'CONTRATO_PARCELA.PARCELA_TIPO' and cg.rv_low_value = cp.parcela_tipo) as parcela_tipo_desc
                 , cp.valor
				 , case when cp.parcela_tipo = 3
                      then
                         (select to_char(nvl(sum(cti.valor), 0), 'FM9G9999G990D00', 'nls_numeric_characters=,.')
                            from oper.v$contrato_transp_item cti
                           inner join pamcard.v$contrato cont
                              on cont.lancto_id = cti.lancto_id
                           where cont.contrato_id = cp.contrato_id
                             and cti.item_id in (6,9)
                             and cti.data_cancelamento is null  )
                      else
                         'No possui'
                   end as valor_quebra
                 , cp.parcela_status
                 , (select cg.rv_high_value from pamcard.v$cg_ref_codes cg where cg.rv_domain = 'CONTRATO_PARCELA.PARCELA_STATUS' and cg.rv_low_value = cp.parcela_status) as parcela_status_desc
                 , cp.usuario_liberacao
                 , to_char(cp.data_liberacao, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao
                 , cp.contrato_id
                 , cp.cancelamento_motivo
			     , cp.cancelamento_usuario
                 , to_char(cp.cancelamento_data, 'dd/mm/yyyy hh24:mi:ss') as cancelamento_data
                 , case
                      when cp.solic_liberacao in (1, 2) then 'Sim'
                      else 'No'
                   end as solic_liberacao
                 , cp.usuario_solic_liberacao
                 , to_char(cp.data_solic_liberacao, 'dd/mm/yyyy hh24:mi:ss') as data_solic_liberacao
                 , cp.log_solic_liberacao
                 , case
                      when cp.gerou_prejuizo = 1 then 'Sim'
                      else 'No'
                   end as gerou_prejuizo
                 , case when cp.parcela_status in (1,2,7) and nvl(kss.pkg_parametro.fnc_valor_numerico(p_identificador => 'M320-P0162'), 0) = 0 then 1 else 0 end as permite_pagar
			     , case when cp.parcela_status in (1,2,7) and cp.solic_liberacao in (0, 2) then 1 else 0 end as permite_cancelar
                 , case when cp.parcela_status in (1,2,7) and nvl(kss.pkg_parametro.fnc_valor_numerico(p_identificador => 'M320-P0162'), 0) = 1 and cp.solic_liberacao = 0 then 1 else 0 end as permite_solic_liberacao
			     , case when cp.parcela_status in (1,2,7) and nvl(kss.pkg_parametro.fnc_valor_numerico(p_identificador => 'M320-P0162'), 0) = 1 and cp.solic_liberacao = 1 then 1 else 0 end  as permite_can_solic_liberacao
                 , case when cp.parcela_status in (5) and cp.gerou_prejuizo = 0 then 1 else 0 end as permite_marcar_gerou_prejuizo
				 , nvl(kss.pkg_parametro.fnc_valor_numerico(p_identificador => 'M320-P0162'), 0) as utiliza_solic_liberacao
                 , cp.adiantamento
              from pamcard.v$contrato_parcela cp
             where 1=1
            <cfif Len(Trim(arguments.contrato_id))>
              and cp.contrato_id = #arguments.contrato_id#
            </cfif>
            order by cp.parcela_numero
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Retorna os dados dos movimentos do contrato
	-- FABIOG 19/03/2014
	--->
	<cffunction name="get_contrato_movimento" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select x.descricao
              , x.valor
              , x.data
              , x.tipo
           from (
                 select ctis.descricao as descricao
                      , to_char(cti.valor, 'FM9G9999G990D00', 'nls_numeric_characters=,.') as valor
                      , to_char(cti.data_item, 'dd/mm/yyyy hh24:mi') as data
                      , decode(ctis.desconto, 1, 'Desconto', 'Acrscimo') as tipo
                   from pamcard.v$contrato c
                  inner join oper.v$contrato_transp ct
                          on ct.lancto_id = c.lancto_id
                  inner join oper.v$contrato_transp_item cti
                          on cti.lancto_id = ct.lancto_id
					     and cti.data_cancelamento is null
                  inner join oper.v$contrato_transp_item_setup ctis
                          on ctis.item_id = cti.item_id
                         and ctis.compoe_frete = 1
                  where c.contrato_id = #arguments.contrato_id#
                ) x
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna os mtodos disponiveis
	-- FABIOG 19/03/2014
	--->
    <cffunction name="get_metodo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.metodo_ws_id 
                 , m.descricao
              from pamcard.v$metodo_ws m
             order by m.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <cffunction name="get_requisicao" access="remote" returntype="query" output="true">
    	<cfargument name="metodo_ws_id" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.requisicao_id
                 , r.metodo
                 , kss.to_tempo(r.tempo_execucao, 5).retorno as tempo_execucao
                 , case
                      when r.erro is not null then 1
                      else 0
                   end as possui_erro
                 , r.user_insert
                 , to_char(r.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , r.user_update
                 , to_char(r.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from pamcard.v$requisicao r
             where 1 = 1
			<cfif Len(Trim(arguments.metodo_ws_id))>
               and upper(r.metodo_ws_id) = upper('#arguments.metodo_ws_id#')
			</cfif>
            
            <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
               and r.date_insert between to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
			<cfelseif Len(Trim(arguments.data_inicio))>
               and r.date_insert >= to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss')
			<cfelseif Len(Trim(arguments.data_termino))>
               and r.date_insert <= to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
			</cfif>
             order by r.date_insert desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
    <cffunction name="get_requisicao_xml_envio" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select convert((r.xml_envio), 'WE8ISO8859P1', 'AL32UTF8') as xml_envio
              from pamcard.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    		
    <cffunction name="get_requisicao_xml_retorno" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select convert((r.xml_retorno), 'WE8ISO8859P1', 'AL32UTF8') as xml_retorno
              from pamcard.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    		
    <cffunction name="get_requisicao_erro" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select convert((r.erro), 'WE8ISO8859P1', 'AL32UTF8') as erro
              from pamcard.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_contrato_transp_item_setup" access="remote" returntype="query" output="true">
    	<cfargument name="debito_credito" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ctis.item_id
                 , ctis.descricao
              from oper.v$contrato_transp_item_setup ctis
             where ctis.compoe_frete = 1
			   and exists (select 1
                             from oper.v$contrato_transp_it_stp_finan cf
                            where cf.item_id = ctis.item_id
                              and cf.tipo_pagto_id = 4
                          )
        	<cfif arguments.debito_credito eq 1>
               and ctis.desconto = 1
			   and ctis.gera_cpg = 1
               and ctis.item_id not in (oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'INSS')
                                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'IRRF')
                                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'SEST')
                                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'SENAT')
                                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'INSS'))
            <cfelseif arguments.debito_credito eq 2>
               and ctis.desconto = 0
            </cfif>
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
	
</cfcomponent>
