<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
	-- PROPSITO 
	-- Busca histrico de transferencias
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_log_transferencias" access="remote" returntype="query" output="true">
	    <cfargument name="LANCTO_ID" required="yes">    
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select l.log
                 , l.user_insert
                 , to_char(l.date_insert, 'dd/MM/yyyy hh24:mi:ss') as date_insert
              from oper.v$transferencia_impressao_log l
             where l.lancto_id = #arguments.LANCTO_ID#
             order by date_insert desc
		</cfquery>
	<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca centros de custo
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_centros_custo" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select cc.cod_centro_custo
                 , cc.centro_custo 
              from kss.v$centro_custo cc
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca centros de custo liberado
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_centro_custo_liberado" access="remote" returntype="query" output="true">
	    <cfargument name="LANCTO_ID" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select cc.centro_custo
              from oper.v$contrato_transp ct
             inner join kss.v$centro_custo cc
                on cc.cod_centro_custo = ct.centro_custo_liberado_impr
             where ct.lancto_id = #arguments.LANCTO_ID#
		</cfquery>
	<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca tipos de frete
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_tipo_frete" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select produto_id, descricao 
              from fiscal.v$produto t
	 		 where t.conhecimento = 1
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Regras fiscais do Cliente
	-- Wagner //2006
	--->	
	<cffunction name="get_lote_regra_fiscal" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select distinct lr.regra_fiscal_id, lr.descricao
		      from fiscal.v$regra_fiscal lr
			where ativa = 1
		</cfquery>
	<cfreturn qr_lote>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados da operacao
	-- CRISTOFER  24/11/2006
	--->		
	<cffunction name="get_solicitacao_carga_dados" access="remote" returntype="query" output="true">	
		<cfargument name="viagem_carga_id" required="no" default="">
                <cfargument name="solicitacao_carga_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.operacao_id, o.descricao as operacao,
                   sc.valor_em as frete_em,
                   o.fracionado,
                   sc.cod_remetente cod_pessoa_remetente,
                   sc.cod_organograma,
                   (select nvl(min(scd.valor_pedagio_rota) keep(dense_rank first order by sc.data_carregamento_inicio), 0)
                      from repom.v$solicitacao_carga_dados scd
                     where scd.solicitacao_carga_id = sc.solicitacao_carga_id
                   ) as valor_pedagio_rota,
                   (select max(c.cartao_numero) keep(dense_rank last order by scd.date_insert)
                      from repom.v$solicitacao_carga_dados scd
                      left join repom.v$cartao c
                        on c.cartao_id = scd.cartao_id
                     where scd.solicitacao_carga_id = sc.solicitacao_carga_id
                   ) as cartao_numero,
                   ro.rota_id,
                   ro.descricao_rota,
                   o.pagto_vale_pedagio
                from logistica.v$operacao o
                inner join logistica.v$solicitacao_carga sc
                        on sc.operacao_id = o.operacao_id
                inner join logistica.v$viagem_carga vc
                        on vc.solicitacao_carga_id = sc.solicitacao_carga_id
                 left join oper.v$rota ro
                   on ro.origem_municipio_id = sc.origem_municipio_id
                  and ro.destino_municipio_id = sc.destino_municipio_id
                  and (ro.origem_cod_pessoa  is null or ro.origem_cod_pessoa  = nvl(sc.cod_consignatario,sc.cod_remetente))
                  and (ro.destino_cod_pessoa is null or ro.destino_cod_pessoa = nvl(sc.cod_redespacho,sc.cod_destinatario))
				  and ro.data_cancelamento is null
               where 1=1
             <cfif len(trim(arguments.viagem_carga_id))>
                 and vc.viagem_carga_id = #arguments.viagem_carga_id#
	     </cfif>
             <cfif len(trim(arguments.solicitacao_carga_id))>
		 and sc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados do manifesto para 
	-- CRISTOFER  24/11/2006
	--->		
	<cffunction name="get_manifesto_ct" access="remote" returntype="query" output="true">
		<cfargument name="num_manifesto" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.manifesto_id,
				   m.num_manifesto,
				   sum(c.peso) peso,
				   fiscal.pkg_fiscal.fnc_converte_peso(sum(c.peso),min(cod_unidade),'Ton') peso_ton,
				   sum(c.m3) m3,
				   sum(c.volume) volume,
				   min(cod_unidade) cod_unidade,
				   m.placa_tracao,
				   m.placa_reboque,
				   oper.pkg_veiculo.fnc_veiculo_proprietario(m.placa_tracao) as veiculo_proprietario, /*1 - Frota, 2 - Agregado, 3 - Terceiro*/
				   case when exists (select 0
                                        from oper.v$contrato_transp_manifesto ct
                                       where ct.manifesto_id = m.manifesto_id) then 1
					    else 0
				   end vinculado_ct,
				   case when exists (select 0
				                       from oper.v$romaneio roo
	                                  inner join oper.v$contrato_transp ct
    	                                      on ct.num_romaneio = roo.num_romaneio
									  where roo.num_romaneio = c.num_romaneio
									    and ct.data_cancelamento is null) and m.roo_item_id is not null then 1
					    else 0
				   end vinculado_roo,
				   m.num_lote
			  from oper.v$manifesto m
			 inner join oper.v$manifesto_conhecimento mc
					 on mc.manifesto_id = m.manifesto_id
			 inner join fiscal.v$conhecimento c
					 on c.conhecimento_id = mc.conhecimento_id
			 where 1=1
			 <cfif len(trim(arguments.num_manifesto))>
			   and m.num_manifesto = #arguments.num_manifesto#
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_filial))>
	           and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 group by m.manifesto_id, 
					  m.num_manifesto,
					  m.placa_tracao,
					  m.placa_reboque,
					  m.num_lote,
					  c.num_romaneio,
                      m.roo_item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os contratos de transporte
	-- ANDERSON - 14/07/2009 - ALTERADO
	--->		
	<cffunction name="get_contrato_transp" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="placa_controle" required="no" default="">
        <cfargument name="proprietario_cod_pessoa" required="no" default="">
        <cfargument name="num_formulario" required="no" default="">
        <cfargument name="lancto_id" required="no" default="">
        <cfargument name="cancelada" required="no" default="">
    	<cfargument name="tipo_contrato" required="no" default="">
        <cfargument name="organizacional_id_gerencial" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="tipo_pagto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ FIRST_ROWS */
                   c.lancto_id,
                   c.num_romaneio,
                   c.num_formulario,
                   c.serie_formulario,
                   c.cod_modelo,
                   c.cod_pessoa_filial,
                   c.cod_departamento,
                   c.cod_setor,
                   c.cod_centro_custo,
                   to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao,
                   c.peso,
                   c.volume,
                   c.m3,
                   c.frete_em,
                   c.cod_unidade,
                   c.tolerancia_falta,
                   c.valor_unitario,
                   c.valor_frete_bruto,
                   c.valor_frete_liquido,
                   to_number(replace(replace(cf.cf_pedagio, '.', ''), ',', '.')) as valor_pedagio,
                   to_number(replace(replace(cf.cf_adiant, '.', ''), ',', '.')) as valor_adiant,
                   cf_total_impostos as valor_total_impostos,
                   to_number(replace(replace(cf.cf_saldo_frete, '.', ''), ',', '.')) as valor_saldo_frete,
                   c.motorista_cod_pessoa,
                   cf.cf_motorista as motorista,
                   c.placa_controle,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_controle) as cod_veiculo_controle,
                   c.placa_referencia,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_referencia) as cod_veiculo_referencia,
                   c.proprietario_cod_pessoa,
                   cf.cf_proprietario as proprietario,
                   c.proprietario_endereco,
                   c.proprietario_municipio_id,
                   c.proprietario_nit,
                   cf.cf_origem as origem,
       			   cf.cf_destino as destino,
                   nvl((select least(nvl(min(c1.impresso), 1), c.impresso)
                          from oper.v$contrato_transp c1
                         where c1.lancto_id_pai = c.lancto_id), 1) as impresso,
                   c.observacao,
                   c.proprietario_municipio_id,
                   c.num_rpa,
                   to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento,
                   c.usuario_cancelamento,
                   c.motivo_cancelamento,
                   c.tipo_contrato,
                   case
                       when oper.pkg_veiculo.fnc_veiculo_modalidade(c.placa_controle, c.data_emissao) = 'AGREGADO' then
                          'AGREGADO'
                       else
                          'TERCEIRO'
                   end as tipo_contrato_desc,
                   c.parcela,
                   c.total_parcela,
                   c.valor_parcelamento,
                   c.lancto_id_pai,
                   c.user_insert,
                   c.date_insert,
                   c.user_update,
                   c.date_update,
                   c.site,
                   av.viagem_id,
                   c.cod_organizacional,
                   c.organizacional_id,
                   (select descricao
                      from kss.v$organizacional o
                     where o.organizacional_id = c.organizacional_id) as organizacional,
                   c.status_aprovacao,
                   c.centro_custo_liberado_impr,
                   oper.pkg_contrato_transp.fnc_centro_custo_liberado_impr(c.lancto_id) as is_centro_custo_liberado,
                   (select sign(count(1))
                      from table (select acesso.pkg_controle_acesso.fnc_get_acao_web(p_web_url => '/modulos/contratotransp/relacao/principal.cfm', p_usuario => user)
                      from dual)
                     where column_value = 'TRANSFERENCIA_IMPRESSAO_CF') as ACAO_TRANSFERENCIA
              from oper.v$contrato_transp c
             inner join oper.v$contrato_transp_form cf
                     on cf.documento_id = c.lancto_id
              left join oper.v$agreg_viagem av
                     on av.lancto_id = c.lancto_id
             where 1 = 1
               and c.lancto_id_pai is null
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
               and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and c.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.placa_controle))>
               and (c.placa_controle = '#arguments.placa_controle#' 
                    or oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_controle) = '#arguments.placa_controle#')
            </cfif>
            <cfif Len(Trim(arguments.proprietario_cod_pessoa))>
               and c.proprietario_cod_pessoa = #arguments.proprietario_cod_pessoa#
            </cfif>
			<cfif Len(Trim(arguments.num_formulario))>
               and c.num_formulario = #arguments.num_formulario#
            </cfif>
            <cfif Len(Trim(arguments.lancto_id))>
               and c.lancto_id = #arguments.lancto_id#
            </cfif>
            <cfif Len(Trim(arguments.cancelada))>
				<cfif arguments.cancelada eq 1>
                	and c.data_cancelamento is not null
                <cfelse>
                	and c.data_cancelamento is null
                </cfif>
            </cfif>
            <cfif Len(Trim(arguments.tipo_contrato))>
               and c.tipo_contrato = #arguments.tipo_contrato#
            </cfif>
            <cfif Len(Trim(arguments.organizacional_id_gerencial))>
               and c.organizacional_id = #arguments.organizacional_id_gerencial#
            </cfif>
			<cfif Len(Trim(arguments.data_inicial))>
               and trunc(c.data_emissao) >= '#arguments.data_inicial#'
            </cfif>
            <cfif Len(Trim(arguments.data_final))>
               and trunc(c.data_emissao) <= '#arguments.data_final#'
            </cfif>
            <cfif Len(Trim(arguments.tipo_pagto_id))>
               and c.tipo_pagto_id = #arguments.tipo_pagto_id#
            </cfif>
             order by c.data_emissao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados da Carta Frete a serem impressos
    -- ANDERSON 13/11/2009 - CRIADO
    --->		
    <cffunction name="get_contrato_transp_form" access="remote" returntype="query" output="true">
        <cfargument name="documento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctf.documento_id
                 , ctf.cf_numero
                 , ctf.cf_num_romaneio
                 , ctf.cf_origem
                 , ctf.cf_destino
                 , ctf.cf_data_emissao
                 , ctf.cf_emissao_data
                 , ctf.cf_filial_dados
                 , ctf.cf_documentos_origem
                 , ctf.cf_proprietario
                 , ctf.cf_prop_endereco
                 , ctf.cf_prop_cep
                 , ctf.cf_prop_municipio
                 , ctf.cf_prop_uf
                 , ctf.cf_prop_cnpj_cpf
                 , ctf.cf_prop_inscricao_estadual
                 , ctf.cf_prop_pis
                 , ctf.cf_motorista
                 , ctf.cf_mot_endereco
                 , ctf.cf_mot_municipio
                 , ctf.cf_mot_uf
                 , ctf.cf_mot_cpf
                 , ctf.cf_mot_rg_uf
                 , ctf.cf_mot_cnh
                 , ctf.cf_mot_cnh_validade
                 , ctf.cf_mot_cnh_completa
                 , ctf.cf_placa_tracao
                 , ctf.cf_placa_carreta
                 , ctf.cf_uf_tracao
                 , ctf.cf_uf_carreta
                 , ctf.cf_veiculo_marca
                 , ctf.cf_quantidade
                 , ctf.cf_valor_unitario
                 , ctf.cf_valor_servico
                 , ctf.cf_irrf
                 , ctf.cf_pedagio
                 , ctf.cf_outros_cred
                 , ctf.cf_sest_senat
                 , ctf.cf_total_impostos
                 , ctf.cf_outros_deb
                 , ctf.cf_valor_liquido
                 , ctf.cf_inss
                 , ctf.cf_adiant_extenso
                 , ctf.cf_adiant
                 , ctf.cf_adiant_pedagio
                 , ctf.cf_adiant_frete                 
                 , ctf.cf_saldo_frete_ext
                 , ctf.cf_saldo_frete
                 , ctf.cf_observacao
                 , ctf.cf_data_cancelamento
                 , ctf.cf_descarga_motorista
				 , ctf.cf_saldo_menos_adiant_frete
              from oper.v$contrato_transp_form ctf
             where ctf.documento_id = #arguments.documento_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o prximo nmero de formulrio para o organograma definido
    -- ANDERSON 27/11/2009 - CRIADO
    --->		
    <cffunction name="get_prox_num_formulario" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="yes">
        <cfargument name="cod_departamento" required="yes">
        <cfargument name="cod_setor" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select nvl(max(ct.num_formulario) + 1, 1) as prox_num_formulario
              from oper.v$contrato_transp ct
             where ct.cod_pessoa_filial = #arguments.cod_pessoa_filial#
               and ct.cod_departamento = #arguments.cod_departamento#
               and ct.cod_setor = #arguments.cod_setor#
               and ct.cod_centro_custo = #arguments.cod_centro_custo#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o prximo nmero de formulrio para o organograma definido dentro dos limites configurados
    -- ANDERSON 27/11/2009 - CRIADO
    --->		
    <cffunction name="get_prox_num_formulario_limite" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="yes">
        <cfargument name="cod_departamento" required="yes">
        <cfargument name="cod_setor" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfargument name="serie" required="no" default="">
        <cfargument name="cod_modelo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select to_char(nvl(max(ct.num_formulario) + 1, 1)) as prox_num_formulario
              from oper.v$contrato_transp ct
             where ct.cod_pessoa_filial = #arguments.cod_pessoa_filial#
               and ct.cod_departamento = #arguments.cod_departamento#
               and ct.cod_setor = #arguments.cod_setor#
               and ct.cod_centro_custo = #arguments.cod_centro_custo#
               and ct.num_formulario > (select ms.num_inicial
                                         from fiscal.v$modelo_serie ms
                                        where ms.cod_pessoa = #arguments.cod_pessoa_filial#
                                          and ms.cod_departamento = #arguments.cod_departamento#
                                          and ms.cod_setor = #arguments.cod_setor#
                                          and ms.cod_centro_custo = #arguments.cod_centro_custo#
                                       <cfif Len(Trim(arguments.serie))>
                                          and ms.serie = '#arguments.serie#'
                                       </cfif>
                                       <cfif Len(Trim(arguments.serie))>
                                          and ms.cod_modelo = '#arguments.cod_modelo#'
                                       </cfif>
                                       )
               and ct.num_formulario < (select ms.num_final
                                         from fiscal.v$modelo_serie ms
                                        where ms.cod_pessoa = #arguments.cod_pessoa_filial#
                                          and ms.cod_departamento = #arguments.cod_departamento#
                                          and ms.cod_setor = #arguments.cod_setor#
                                          and ms.cod_centro_custo = #arguments.cod_centro_custo#
                                       <cfif Len(Trim(arguments.serie))>
                                          and ms.serie = '#arguments.serie#'
                                       </cfif>
                                       <cfif Len(Trim(arguments.cod_modelo))>
                                          and ms.cod_modelo = '#arguments.cod_modelo#'
                                       </cfif>
                                       )
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca usurios que possuem alada para liberao
	--->
	<cffunction name="get_alcada_liberacao_controle" access="remote" returntype="query" output="true">
		<cfargument name="OPERACAO" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct al.operacao, al.usuario, u.nome
              from oper.v$alcada_liberacao_controle al
             inner join kss.v$kss_usuarios u
                     on u.usuario = al.usuario 
            where al.valor_alcada > 0
            <cfif Len(Trim(arguments.OPERACAO)) >
              and al.operacao in (#ListQualify(arguments.operacao, "'", ",")#)
            </cfif>
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os veculos de um romaneio
    -- ANDERSON 14/09/2011 - CRIADO
    --->		
    <cffunction name="get_veiculos_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes">
		  <cfargument name="repom" required="no" default="0">
		  <cfargument name="pagbem" required="no" default="0">
		  <cfargument name="target" required="no" default="0">
      <cfargument name="valecard" required="no" default="0">
      <cfargument name="pamcard" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rhv.placa_controle
                 , rhv.placa_referencia
                 , to_char(rhv.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio
              <cfif arguments.repom eq 1>
                 , (select max(c.cartao_numero) keep(dense_rank last order by ct.date_insert)
                      from repom.v$contrato ct
                     inner join repom.v$cartao c
                             on c.cartao_id = ct.cartao_id
                     where ct.cod_motorista = rhv.cod_pessoa
                       and ct.data_cancelamento is null
                   ) as cartao_numero_historico
		      <cfelseif arguments.pagbem eq 1>
		         , (select max(c.cartao_numero) keep(dense_rank last order by ct.date_insert)
                      from pagbem.v$contrato ct
                     inner join pagbem.v$cartao c
                             on c.cartao_id = ct.cartao_id
                     where ct.cod_motorista = rhv.cod_pessoa
                       and ct.data_cancelamento is null
                   ) as cartao_numero_historico
		      <cfelseif arguments.target eq 1>
		         , (select max(c.cartao_numero) keep(dense_rank last order by c.tipo desc, ct.date_insert)
                      from target.v$contrato ct
					 inner join target.v$contrato_parcela cp
						on cp.contrato_id = ct.contrato_id
                     inner join target.v$cartao c
						on c.cartao_id = cp.cartao_id
                     where ct.cod_motorista = rhv.cod_pessoa
                       and ct.data_cancelamento is null
                   ) as cartao_numero_historico
			  <cfelseif arguments.valecard eq 1>
		         , (select max(c.num_cartao) keep(dense_rank last order by ct.date_insert)
                      from pagfrete.v$contrato ct
                     inner join pagfrete.v$motorista_cartao c
                        on c.motorista_cartao_id = ct.motorista_cartao_id
                     where ct.cod_motorista = rhv.cod_pessoa
                       and ct.cancelamento_data is null
                   ) as cartao_numero_historico
			  <cfelseif arguments.pamcard eq 1>
             , (select max(c2.numero) keep(dense_rank last order by ct2.date_insert)
                      from pamcard.v$contrato ct2
                     inner join pamcard.v$cartao c2
                        on c2.cartao_id = ct2.cartao_frete_id
                     where ct2.cod_motorista = rhv.cod_pessoa
                       and ct2.cancelamento_data is null
                   ) as cartao_numero_historico
        <cfelse>
		         , null as cartao_numero_historico
			  </cfif>
              from oper.v$romaneio_hist_veiculo rhv
             where rhv.num_romaneio = #arguments.num_romaneio#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os veculos de um romaneio
    -- ANDERSON 14/09/2011 - CRIADO
    --->		
    <cffunction name="get_contrato_parcelamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_emissao" required="yes">
        <cfargument name="placa_controle" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.parcelamento_id
                 , x.item_id
                 , x.descricao
                 , x.valor
                 , x.parcela
                 , x.total_parcelas
              from table (select agreg.pkg_agreg.fnc_contrato_parcelamento(oper.pkg_veiculo.fnc_veiculo_id('#arguments.placa_controle#'),nvl('#arguments.data_emissao#', sysdate) )
                            from dual ) x                            
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os valores disponveis para uma carta frete
	-- ANDERSONC 24/06/2011 09:54:00 - CRIADO
	--->
	<cffunction name='valores_contrato' displayname='Retorna os valores disponveis para uma carta frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='CRT_ID_DIARIA' required='yes'>
		<cfargument name='DIVISAO_ID' required='yes'>
		<cfargument name='LANCTO_ID' required='no' default="">
		<cfargument name='MOVIMENTO_AVULSO' required='no' default="0">
		<cftry>
            <cfstoredproc procedure='oper.pkg_contrato_transp.prc_valores_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CRT_ID_DIARIA#'  null='#iif(len(trim(arguments.CRT_ID_DIARIA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DIVISAO_ID#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_RECEITA' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_CF_ACUMULADO' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_MAXIMO' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOVIMENTO_AVULSO#'  null='#iif(len(trim(arguments.MOVIMENTO_AVULSO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna se est sendo utilizado controle de alada na emisso do contrato Pamcard
    -- FELIPE BUENO 06/01/2015 - CRIADO
    --->		
    <cffunction name="get_utiliza_alcada" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cttp.utiliza_alcada
              from oper.v$contrato_transp_tipo_pagto cttp
             where cttp.nome = 'PAMCARD'
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
	
	<!---
    -- PROPSITO
    -- Dados para a impresso do contrato
    -- GUTO 19/10/2012 - CRIADO
    --->
    <cffunction name="get_contrato_transp_impressao_formulario" access="remote" returntype="query" output="true">
        <cfargument name="documento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select ct.num_formulario as doc_contrato, ct.observacao, ct.lancto_id,
                   (select pe.municipio
                      from kss.v$pessoa_endereco pe
                     where pe.cod_pessoa = ct.cod_pessoa_filial
                       and pe.endereco_padrao = 1) as municipio_emissao,
                   to_char(ct.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao,
                   to_char(ct.data_emissao, 'dd')||' de '||to_char(ct.data_emissao, 'month')||' de '||to_char(ct.data_emissao, 'yyyy') as data_emissao_extenso,
                   (select p.razao_social from kss.v$pessoa p
                     where p.cod_pessoa = ct.cod_pessoa_filial) as emitente_razao_social,
                   (select p.endereco_completo
                      from kss.v$pessoa_endereco_padrao p
                     where p.cod_pessoa = ct.cod_pessoa_filial) as emitente_endereco,
                   kss.pkg_pessoa.fnc_get_identificador(ct.cod_pessoa_filial) as emitente_cnpj,
                   (select 'CNPJ: '||p.identificador
                      from kss.v$pessoa p
                     where p.cod_pessoa = ct.cod_pessoa_filial) as filial_cnpj_cpf,

                   ctf.cf_proprietario as transportador_nome,
                   ctf.cf_prop_endereco transportador_endereco,
                   ctf.cf_prop_municipio as transportador_municipio,
                   ctf.cf_prop_uf as transportador_uf,
                   ctf.cf_prop_telefone as transportador_telefone,
                   ctf.cf_prop_cnpj_cpf as transportador_cnpj,

                   ctf.cf_motorista as motorista_nome,
                   ctf.cf_mot_endereco as motorista_endereco,
                   ctf.cf_mot_municipio as motorista_municipio,
                   ctf.cf_mot_uf as motorista_uf,
                   (select telefone from kss.v$pessoa_telefone_padrao mt
                     where mt.cod_pessoa = ct.motorista_cod_pessoa) as motorista_telefone,
                   ctf.cf_mot_cpf as motorista_cnpj,
                   ctf.cf_mot_cnh as motorista_cnh,

                   ctf.cf_placa_tracao as placa_tracao,
                   (select cor_predominante from oper.v$veiculo v
                     where v.placa = ct.placa_controle) as tracao_cor,
                   (select ano from oper.v$veiculo v
                     where v.placa = ct.placa_controle) as tracao_ano,
                   (select chassis from oper.v$veiculo v
                   where v.placa = ct.placa_controle) as tracao_chassis,
                   (select renavan from oper.v$veiculo v
                     where v.placa = ct.placa_controle) as tracao_renavam,
                   (select vm2.marca|| ' ' || vm.modelo from oper.v$veiculo v
                         inner join oper.v$veiculo_modelo vm
                                 on vm.modelo_id = v.modelo_id
                         inner join oper.v$veiculo_marca vm2
                                 on vm2.marca_id = v.marca_id
                              where v.placa = ct.placa_controle) as tracao_modelo,

                   case
                       when ct.placa_controle <> ct.placa_referencia then ct.placa_referencia
                   end  as tracionado_placa,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.cor_predominante from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_cor,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.ano from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_ano,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.chassis from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_chassis,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.renavan from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_renavam,

                   ctf.cf_origem  as coleta_municipio,
                   ctf.cf_destino as entrega_municipio,

                   nvl2(ct.valor_frete_liquido, to_char(ct.valor_frete_liquido,'FM9G9999G990D00','nls_numeric_characters=,.'), '0,00')as frete_bruto,
                   nvl2(ctf.cf_pedagio,ctf.cf_pedagio,'0,00')as frete_pedagio,
                   nvl2(ctf.CF_IRRF,ctf.CF_IRRF,'0,00') as frete_irrf,
                   nvl2(ctf.CF_INSS,ctf.CF_INSS,'0,00') as frete_inss,
                   ctf.cf_liquido_a_pagar,
                   nvl(ctf.cf_adiant_pedagio,'0,00')as adto_pedagio,
                   nvl2(ctf.CF_SEST_SENAT,ctf.CF_SEST_SENAT,'0,00') as frete_sest_senat,
                   nvl2(ctf.CF_SALDO_FRETE ,ctf.CF_SALDO_FRETE,'0,00') as frete_liquido,
                   nvl2(ctf.CF_ADIANT,ctf.CF_ADIANT,'0,00') as frete_adiantamento,
                   nvl2(ctf.CF_SALDO_MENOS_ADIANT,ctf.CF_SALDO_MENOS_ADIANT,'0,00') as frete_saldo,
                   nvl(ctf.cf_valor_liquido,'0,00') as valor_liquido,
                   fiscal.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as notas_fiscais
                  , (select pl.logotipo
                      from kss.v$pessoa_logotipo pl
                     where pl.cod_pessoa = ct.cod_pessoa_filial
                    ) as logo
                  , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = ct.cod_pessoa_filial
                     ) as razao_social_filial
                  , (select pep.logradouro || ', ' || pep.numero
                       from kss.v$pessoa_endereco_padrao pep
                      where pep.cod_pessoa = ct.cod_pessoa_filial) logradouro_numero
                  , (select pep.bairro || ' - CEP: ' || pep.cep
                       from kss.v$pessoa_endereco_padrao pep
                      where pep.cod_pessoa = ct.cod_pessoa_filial) bairro_cep
                  , (select pep.municipio || ' ' || pep.uf
                       from kss.v$pessoa_endereco_padrao pep
                      where pep.cod_pessoa = ct.cod_pessoa_filial) || ' - Telefone ' || (select '+'||ptp.fone_cod_pais || ' ' || ptp.telefone
                                                                                           from kss.v$pessoa_telefone_padrao ptp
                                                                                          where ptp.cod_pessoa = ct.cod_pessoa_filial) cidade_uf_telefone
                  ,'Pelo presente instrumento particular, de um lado ' || (select e.razao_social from kss.v$empresa e) || ', pessoa jurdica de direito privado, com sede e foro em ' || (select pep.municipio || ' - ' || pep.uf || '  rua ' || pep.logradouro || ', ' || pep.numero || ', CNPJ ' || kss.fnc_get_identificador(p_cod_pessoa => pep.cod_pessoa)
  from kss.v$pessoa_endereco_padrao pep
 where pep.cod_pessoa = (select e.cod_pessoa from kss.v$empresa e)) || ', por seu representante legal, doravante denominada TOMADORA DE SERVIOS e o transportador supra citado, denominado de PRESTADOR DE SERVIOS, tm entre si, justo o seguinte:

CLUSULA PRIMEIRA:
DO OBJETO DO CONTRATO: O PRESTADOR DE SERVIOS realizar servios de transporte rodovirio de carga para a TOMADORA DE SERVIOS conforme agendamento e nmero de carregamento recebidos no presente momento, inclusive as instrues e regras para carga e descarga, acomodao das mercadorias transportadas, prazos de incio, fim dos servios de transporte e horrio de apresentao para entrega dos documentos transportados.
Pargrafo primeiro: Os veculos utilizados no transporte de carga sero de propriedade do PRESTADOR DE SERVIOS, o qual assume todos os riscos de avaria da caga, sinistro, roubos/furtos, manuteno e multas de trnsito, excluindo a TOMADORA DE SERVIOS quanto a qualquer responsabilidade relativa ao veculo transportador.
Pargrafo segundo: O PRESTADOR DE SERVIOS est obrigado a, antes de sair do local de embarque, entrar em contato com o setor responsvel da TOMADORA DE SERVIOS para solicitar autorizao de incio de viagem, bem como para saber da necessidade de recolhimento de ICMS.
Pargrafo terceiro: Caso haja avaria na carga transportada pelo PRESTADOR DE SERVIOS e havendo recusa de recebimento do destinatrio est obrigado o PRESTADOR DE SERVIOS a trazer a carga recusada, total ou parcialmente e sem frete de retorno at p local originrio de embarque ou contratar s suas expensas algum que o faa em seu nome (em nome do PRESTADOR DE SERVIOS).' as clausula_1
,
'CLUSULA SEGUNDA:
O PRESTADOR DE SERVIOS reconhece que a prestao de servio ora efetuada  de maneira eventual, com o seu veculo e de acordo com as necessidades da TOMADORA DE SERVIOS.

CLUSULA TERCEIRA:
A responsabilidade pelo pagamento de quaisquer verbas trabalhistas decorrentes de aes impetradas por ex-funcionrios da PRESTADORA DE SERVIOS que atinjam a TOMADORA DE SERVIOS ser exclusiva da PRESTADORA DE SERVIOS, podendo a TOMADORA DE SERVIOS propor AO REAGRESSIVA contra a PRESTADORA DE SERVIOS caso tenha que efetuar algum pagamento de referidas verbas trabalhistas.' as clausula_2
,
'CLUSULA QUARTA:
DA REMUNERAO: A TOMADORA DE SERVIOS pagar  PRESTADORA DE SERVIOS a quantia total de acordo com detalhamento acima, pagos no ato da assinatura do presente e o restante sendo pago contra a prestao do comprovante de entrega regular (pontualidade e ausncia de avarias) das mercadorias transportadas.
Pargrafo primeiro: No caso de pessoa fsica, valor constante da presente clusula sofrer o desconto de INSS, SEST/SENAT e IRRF incidente sobre o frete e ser recolhido em favor do proprietrio do cavalo mecnico.

CLUSULA QUINTA:
 de responsabilidade do PRESTADOR DE SERVIOS verificar a acomodao da carga e recusar o carregamento de carga avariada ou com defeitos de embalagem.
Presume-se que ao iniciar a viagem toda a carga saiu do embarcador sem avarias de produto ou embalagem.' as clausula_3
,'
CLUSULA SEXTA:
Qualquer litgio originado do presente contrato ser definitivamente resolvido por arbitragem, de acordo com a Lei 9.307/96 e com o Regulamento de Arbitragem  Cmara de Mediao e Arbitragem da Associao Comercial do Paran  ARBITAC, por um rbitro nomeado de conformidade com tal Regulamento sendo a arbitragem realizada no endereo da matriz da ' || (select e.razao_social from kss.v$empresa e) || '.

CLUSULA STIMA:
Fica convencionado que na hiptese de ser efetuado o carregamento em local onde a ' || (select e.razao_social from kss.v$empresa e) || ' no disponha de escritrio e/ou ponto de apoio, ser efetuado adiantamento do vale pedgio mediante depsito em conta corrente bancria e/ou remessa de valores at o posto de combustvel mais prximo com o qual a ' || (select e.razao_social from kss.v$empresa e) || ' mantenha convnio para este fim.

E por estarem s partes TOMADORA DE SERVIOS e PRESTADORA DE SERVIOS em pleno acordo em tudo quanto se encontra disposto neste instrumento particular, assinam-no na presena das testemunhas abaixo, em 02 (duas) via de igual teor e forma, destinando-se 01 (uma) via para cada uma das partes interessadas.' as clausula_4
                 , (select kss.fnc_concat_all(kss.to_concat_expr(decode(ctis.desconto,1,'(-) ','(+) ') || ctis.descricao || decode(ctis.adiantamento,1,'(A)','(S)') || '  R$ ' || to_char(sum(cti.valor),'FM999G990D00','nls_numeric_characters=,.'),chr(10)))
                       from oper.v$contrato_transp_item cti
                      inner join oper.v$contrato_transp_item_setup ctis
                         on ctis.item_id = cti.item_id
                      where cti.lancto_id = ct.lancto_id
                        and cti.data_cancelamento is null
                        and ctis.imprime_tarifa = 1
                      group by ctis.descricao,ctis.adiantamento,ctis.desconto) as itens_contrato
                 , nvl(to_char((select sum(cti.valor)
                                  from oper.v$contrato_transp_item cti
                                 inner join oper.v$contrato_transp_item_setup ctis
                                    on ctis.item_id = cti.item_id
                                 where cti.data_cancelamento is null
                                   and cti.lancto_id = ct.lancto_id
                                   and ctis.compoe_frete = 1
                                   and ctis.cod_evento_rpa is null
                                   and ctis.desconto = 1),'FM999G990D00','nls_numeric_characters=,.'),'0,00') as outros_descontos
                 , nvl(to_char((select sum(cti.valor)
                                  from oper.v$contrato_transp_item cti
                                 inner join oper.v$contrato_transp_item_setup ctis
                                    on ctis.item_id = cti.item_id
                                 where cti.data_cancelamento is null
                                   and cti.lancto_id = ct.lancto_id
                                   and ctis.cod_evento_rpa is null
                                   and ctis.compoe_frete = 1
                                   and ctis.item_id not in (1) /*Tira o PEDAGIO*/
                                   and ctis.desconto = 0),'FM999G990D00','nls_numeric_characters=,.'),'0,00') as outros_acrescimos
                 , (select ' ( ' || kss.fnc_concat_all(kss.to_concat_expr(f.documento, ',')) || ') '
                      from logistica.v$operacao_documento od
                     inner join oper.v$documento_frete f
                        on f.documento_id = od.documento_id
                     where od.motorista = 1
                       and od.operacao_id = ct.operacao_id
                     group by od.operacao_id
                    ) as doctos_obs
			  from oper.v$contrato_transp ct
             inner join oper.v$contrato_transp_form ctf
                     on ctf.documento_id = ct.lancto_id
             inner join kss.v$unidade_negocio un
                     on un.cod_pessoa = ct.cod_pessoa_filial
              left join fiscal.v$unidade_medida und
                     on und.cod_unidade = ct.cod_unidade
              left join fiscal.v$conhecimento c
                     on ct.num_romaneio = c.num_romaneio
                    and c.cancelado is null
              left join cep.municipio mcol
                     on mcol.municipio_id = c.coleta_municipio_id
              left join cep.municipio ment
                     on ment.municipio_id = c.entrega_municipio_id
              where 1 = 1
                and ctf.documento_id = #arguments.documento_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca o valor mximo do contrato com base nas divises do CRT e margem
    -- JAQUELINEF 21/08/2014 11:18:00
    --->
    <cffunction name="get_valor_max_divisao" access="remote" returntype="query" output="true">
        <cfargument name="num_romaneio" required="yes">
        <cfargument name="valor_receita" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select round(nvl(case
                              when oper.pkg_veiculo.fnc_veiculo_modalidade(rhv.placa_controle, rhv.data_inicio) = 'TERCEIRO' then min(o.margem_terceiro)
                              else min(o.margem_agregado)
                           end,
                           kss.pkg_global.fnc_parametro_num(11, 'OPERACIONAL', 15, 8)
                          ) * #arguments.valor_receita# / 100, 2) as valor_maximo
            from oper.v$romaneio_item ri
           inner join logistica.v$operacao o
                   on o.operacao_id = ri.operacao_id
           inner join oper.v$romaneio_hist_veiculo rhv
                   on rhv.num_romaneio = ri.num_romaneio
                  and rhv.data_inicio = (select max(rhv2.data_inicio)
                                           from oper.v$romaneio_hist_veiculo rhv2
                                          where rhv2.num_romaneio = rhv.num_romaneio
                                        )
           where ri.num_romaneio = #arguments.num_romaneio#
           group by oper.pkg_veiculo.fnc_veiculo_modalidade(rhv.placa_controle, rhv.data_inicio)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca tipos de frete
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_tipo_pagto" access="remote" returntype="query" output="true">
	   <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select tp.tipo_pagto_id
                 , tp.nome
              from oper.v$contrato_transp_tipo_pagto tp
             where exists (select 1
                             from oper.v$contrato_transp t
                            where t.tipo_pagto_id = tp.tipo_pagto_id
                           )
	   </cfquery>
	   <cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as cartas frete pendentes de aprovao
    -- RAFAELPENCZKOSKI 13/01/2016 - ADICIONADO
    --->	
    <cffunction name="get_contrato_transp_pendente_aprovacao" access="remote" returntype="query" output="true">
    	<cfargument name="pendente" required="no" default="" />
        <cfargument name="aprovada" required="no" default="" />
        <cfargument name="aprovada_data_inicial" required="no" default="" />
        <cfargument name="aprovada_data_final" required="no" default="" />
        <cfargument name="reprovada" required="no" default="" />
        <cfargument name="reprovada_data_inicial" required="no" default="" />
        <cfargument name="reprovada_data_final" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.lancto_id
                 , case
                      when t.num_formulario < 0 then ''
                      else to_char(t.num_formulario)
                   end as num_formulario
                 , case
                      when oper.pkg_veiculo.fnc_veiculo_modalidade(t.placa_controle, t.data_emissao) = 'AGREGADO' then
                         'AGREGADO'
                      else
                         'TERCEIRO'
                   end as tipo_contrato
                 , (select cg.rv_abbreviation
                      from oper.v$agreg_viagem av
                     inner join oper.cg_ref_codes cg
                        on cg.rv_domain = 'AGREG_VIAGEM.TIPO_SERVICO'
                       and cg.rv_low_value = av.tipo_servico
                     where av.lancto_id = t.lancto_id
                   ) as tipo_servico
                 , (select cg.rv_abbreviation
                      from oper.cg_ref_codes cg
             		 where cg.rv_domain = 'CONTRATO_TRANSP.TIPO_CARGA'
                       and cg.rv_low_value = t.tipo_carga
                   ) as tipo_carga
                 , t.num_romaneio
                 , (select r.carregamento
                      from oper.v$romaneio r
                     where r.num_romaneio = t.num_romaneio 
                   ) as carregamento
                 , (select r.destino
                      from oper.v$romaneio r
                     where r.num_romaneio = t.num_romaneio 
                   ) as destino
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = t.cod_pessoa_filial
                   ) as unidade_negocio
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = t.cod_departamento
                   ) as departamento
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = t.cod_setor
                   ) as setor
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = t.cod_centro_custo
                   ) as centro_custo
                 , to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , t.peso
                 , t.cod_unidade
                 , t.volume
                 , t.m3
                 , t.frete_em
     			 , nvl(t.total_parcela, 1) as total_parcela
                 , t.valor_unitario
                 , t.valor_frete_bruto
                 , t.valor_frete_liquido
                 , oper.pkg_contrato_transp.fnc_valor_frete_bruto_acum(p_num_romaneio => t.num_romaneio) as valor_frete_bruto_acum
                 , t.total_conhecimento
                 , t.ganho_bruto
                 , round((t.ganho_bruto / nvl(nullif(oper.pkg_contrato_transp.fnc_total_receita(p_num_romaneio => t.num_romaneio),0),1)) * 100, 2) as percentual_ganho_bruto
                 , oper.pkg_contrato_transp.fnc_total_nf_es_frete(p_num_romaneio => t.num_romaneio) as total_nf_es_frete
                 , oper.pkg_contrato_transp.fnc_total_crt(p_num_romaneio => t.num_romaneio) as total_crt
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_controle) as cod_veiculo_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_referencia) as cod_veiculo_referencia
                 , kss.pkg_pessoa.fnc_get_cliente(t.proprietario_cod_pessoa) as proprietario
                 , kss.pkg_pessoa.fnc_get_cliente(t.motorista_cod_pessoa) as motorista
                 , t.rpa_id
                 , t.impresso
                 , decode(t.impresso, 1, 'Sim', 'No') as impresso_desc
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , t.usuario_cancelamento
                 , to_char(t.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
                 , t.usuario_aprovacao
                 , to_char(t.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao
                 , t.usuario_reprovacao
                 , to_char(t.data_reprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_reprovacao
                 , t.motivo_reprovacao
                 , (select nvl(sum(cti.valor),0) from oper.v$contrato_transp_item cti where cti.lancto_id = t.lancto_id and cti.item_id = oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'ADTO_FRETE_VIAGEM')) as valor_adiantamento
                 , (select nvl(sum(cti.valor),0) from oper.v$contrato_transp_item cti where cti.lancto_id = t.lancto_id and cti.item_id = oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'ADTO_PEDAGIO')) as valor_adiantamento_pedagio
                 , (select nvl(sum(cti.valor),0) from oper.v$contrato_transp_item cti where cti.lancto_id = t.lancto_id and cti.item_id = oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'ADTO_CARGA_DESCARGA')) as valor_adto_carga_descarga
                 , (select nvl(sum(cti.valor),0) from oper.v$contrato_transp_item cti where cti.lancto_id = t.lancto_id and cti.item_id in (oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'ADTO_FRETE_VIAGEM')
				                                                                                                                           ,oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'ADTO_PEDAGIO')
																																		   ,oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'ADTO_CARGA_DESCARGA'))) as valor_total_adto 
				 
				 , t.usuario_aprovacao_adiant
                 , to_char(t.data_aprovacao_adiant, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao_adiant
                 , t.usuario_reprovacao_adiant
                 , to_char(t.data_reprovacao_adiant, 'dd/mm/yyyy hh24:mi:ss') as data_reprovacao_adiant
                 , t.motivo_reprovacao_adiant
				 , (select o.exige_aprovacao_adiantamento
					  from logistica.v$operacao o
					 where o.operacao_id = t.operacao_id) as exige_aprovacao_adiantamento
              from (
				<cfif Len(Trim(arguments.pendente)) and arguments.pendente eq 1>
                    select ct.lancto_id
                         , ct.num_formulario
                         , ct.tipo_contrato
                         , ct.tipo_carga
                         , ct.num_romaneio
                         , ct.cod_pessoa_filial
                         , ct.cod_departamento
                         , ct.cod_setor
                         , ct.cod_centro_custo
                         , ct.data_emissao
                         , ct.peso
                         , ct.cod_unidade
                         , ct.volume
                         , ct.m3
                         , ct.frete_em
     					 , ct.total_parcela
                         , ct.valor_unitario
                         , ct.valor_frete_bruto
                         , ct.valor_frete_liquido
                         , oper.pkg_contrato_transp.fnc_total_conhecimento(p_num_romaneio => ct.num_romaneio) as total_conhecimento
                         , oper.pkg_contrato_transp.fnc_ganho_bruto_conhecimento(p_num_romaneio => ct.num_romaneio) 
                         + oper.pkg_contrato_transp.fnc_ganho_bruto_nfst(p_num_romaneio => ct.num_romaneio) as ganho_bruto
                         , ct.placa_controle
                         , ct.placa_referencia
                         , ct.proprietario_cod_pessoa
                         , ct.motorista_cod_pessoa
                         , ct.rpa_id
                         , ct.impresso
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento
                         , ct.usuario_aprovacao
                         , ct.data_aprovacao
                         , ct.usuario_reprovacao
                         , ct.data_reprovacao
                         , ct.motivo_reprovacao
						 
						 , ct.usuario_aprovacao_adiant
                         , ct.data_aprovacao_adiant
                         , ct.usuario_reprovacao_adiant
                         , ct.data_reprovacao_adiant
                         , ct.motivo_reprovacao_adiant
						 , ct.operacao_id
                      from oper.v$contrato_transp_todos ct
                     where /*ct.num_formulario < 0
                       and*/ ct.lancto_id_pai is null
                       and ct.data_cancelamento is null
                       and ct.data_aprovacao is null
                       and ct.data_reprovacao is null
                       and (exists (select 1
                                      from oper.v$contrato_transp_liberacao ctl
                                     where ctl.cod_pessoa_filial = ct.cod_pessoa_filial
                                       and ctl.usuario = user
                                   ) or
                            exists (select 1
                                      from oper.v$contrato_transp_liberacao ctl
                                     where ctl.cod_pessoa_filial is null
                                       and ctl.usuario = user
                                   )
                           )
                       and ct.data_emissao > '01/01/2016'    
				</cfif>
				<cfif (Len(Trim(arguments.pendente)) and arguments.pendente eq 1) and (Len(Trim(arguments.aprovada)) and arguments.aprovada eq 1)>
                     union all
				</cfif>
                <cfif Len(Trim(arguments.aprovada)) and arguments.aprovada eq 1>
                    select ct.lancto_id
                         , ct.num_formulario
                         , ct.tipo_contrato
                         , ct.tipo_carga
                         , ct.num_romaneio
                         , ct.cod_pessoa_filial
                         , ct.cod_departamento
                         , ct.cod_setor
                         , ct.cod_centro_custo
                         , ct.data_emissao
                         , ct.peso
                         , ct.cod_unidade
                         , ct.volume
                         , ct.m3
                         , ct.frete_em
     					 , ct.total_parcela
                         , ct.valor_unitario
                         , ct.valor_frete_bruto
                         , ct.valor_frete_liquido
                         , oper.pkg_contrato_transp.fnc_total_conhecimento(p_num_romaneio => ct.num_romaneio) as total_conhecimento
                         , oper.pkg_contrato_transp.fnc_ganho_bruto_conhecimento(p_num_romaneio => ct.num_romaneio) 
                         + oper.pkg_contrato_transp.fnc_ganho_bruto_nfst(p_num_romaneio => ct.num_romaneio) as ganho_bruto
                         , ct.placa_controle
                         , ct.placa_referencia
                         , ct.proprietario_cod_pessoa
                         , ct.motorista_cod_pessoa
                         , ct.rpa_id
                         , ct.impresso
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento
                         , ct.usuario_aprovacao
                         , ct.data_aprovacao
                         , ct.usuario_reprovacao
                         , ct.data_reprovacao
                         , ct.motivo_reprovacao
				
						 , ct.usuario_aprovacao_adiant
                         , ct.data_aprovacao_adiant
                         , ct.usuario_reprovacao_adiant
                         , ct.data_reprovacao_adiant
                         , ct.motivo_reprovacao_adiant
						 , ct.operacao_id
                      from oper.v$contrato_transp_todos ct
                     where ct.lancto_id_pai is null
                       and (ct.usuario_aprovacao = user
                            or (ct.usuario_aprovacao in (select ctl.usuario
                                                           from oper.v$contrato_transp_liberacao ctl
                                                          where ctl.cod_pessoa_filial in (select distinct ctl2.cod_pessoa_filial
                                                                                            from oper.v$contrato_transp_liberacao ctl2  
                                                                                           where ctl2.usuario = user
                                                                                         )
                                                        )
                                and exists (select 1
                                              from acesso.v$modulo_usuario t 
                                             where t.modulo_id = 45
                                               and t.nivel_acesso = 5
                                               and t.usuario = user)
                                and ct.cod_pessoa_filial in  (select distinct ctl2.cod_pessoa_filial
                                                               from oper.v$contrato_transp_liberacao ctl2  
                                                              where ctl2.usuario = user)
                               )                            
                            or (ct.usuario_aprovacao is not null
                                and exists (select 1
                                              from oper.v$contrato_transp_liberacao ctl
                                             where ctl.cod_pessoa_filial is null
                                               and ctl.usuario = user
                                           )
                               )
                           )
					<cfif Len(Trim(arguments.aprovada_data_inicial)) and Len(Trim(arguments.aprovada_data_final))>
                       and ct.data_aprovacao between to_date('#arguments.aprovada_data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.aprovada_data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                    <cfelseif Len(Trim(arguments.aprovada_data_inicial))>
                       and ct.data_aprovacao >= to_date('#arguments.aprovada_data_inicial#', 'dd/mm/yyyy')
                    <cfelseif Len(Trim(arguments.aprovada_data_final))>
                       and ct.data_aprovacao <= to_date('#arguments.aprovada_data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
					</cfif>
				</cfif>
                <cfif ((Len(Trim(arguments.pendente)) and arguments.pendente eq 1) or (Len(Trim(arguments.aprovada)) and arguments.aprovada eq 1)) and (Len(Trim(arguments.reprovada)) and arguments.reprovada eq 1)>
                     union all
				</cfif>
                <cfif Len(Trim(arguments.reprovada)) and arguments.reprovada eq 1>
                    select ct.lancto_id
                         , ct.num_formulario
                         , ct.tipo_contrato
                         , ct.tipo_carga
                         , ct.num_romaneio
                         , ct.cod_pessoa_filial
                         , ct.cod_departamento
                         , ct.cod_setor
                         , ct.cod_centro_custo
                         , ct.data_emissao
                         , ct.peso
                         , ct.cod_unidade
                         , ct.volume
                         , ct.m3
                         , ct.frete_em
     					 , ct.total_parcela
                         , ct.valor_unitario
                         , ct.valor_frete_bruto
                         , ct.valor_frete_liquido
                         , oper.pkg_contrato_transp.fnc_total_conhecimento(p_num_romaneio => ct.num_romaneio) as total_conhecimento
                         , oper.pkg_contrato_transp.fnc_ganho_bruto_conhecimento(p_num_romaneio => ct.num_romaneio) 
                         + oper.pkg_contrato_transp.fnc_ganho_bruto_nfst(p_num_romaneio => ct.num_romaneio) as ganho_bruto
                         , ct.placa_controle
                         , ct.placa_referencia
                         , ct.proprietario_cod_pessoa
                         , ct.motorista_cod_pessoa
                         , ct.rpa_id
                         , ct.impresso
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento
                         , ct.usuario_aprovacao
                         , ct.data_aprovacao
                         , ct.usuario_reprovacao
                         , ct.data_reprovacao
                         , ct.motivo_reprovacao
						 
						 , ct.usuario_aprovacao_adiant
                         , ct.data_aprovacao_adiant
                         , ct.usuario_reprovacao_adiant
                         , ct.data_reprovacao_adiant
                         , ct.motivo_reprovacao_adiant
						 , ct.operacao_id
                      from oper.v$contrato_transp_todos ct
                     where ct.lancto_id_pai is null
                       and (ct.usuario_reprovacao = user
                            or (ct.usuario_reprovacao in (select ctl.usuario
                                                           from oper.v$contrato_transp_liberacao ctl
                                                          where ctl.cod_pessoa_filial in (select distinct ctl2.cod_pessoa_filial
                                                                                            from oper.v$contrato_transp_liberacao ctl2  
                                                                                           where ctl2.usuario = user
                                                                                         )
                                                        )
                                and exists (select 1
                                              from acesso.v$modulo_usuario t 
                                             where t.modulo_id = 45
                                               and t.nivel_acesso = 5
                                               and t.usuario = user)
                                and ct.cod_pessoa_filial in  (select distinct ctl2.cod_pessoa_filial
                                                               from oper.v$contrato_transp_liberacao ctl2  
                                                              where ctl2.usuario = user)
                               )
                            or (ct.usuario_reprovacao is not null
                                and exists (select 1
                                              from oper.v$contrato_transp_liberacao ctl
                                             where ctl.cod_pessoa_filial is null
                                               and ctl.usuario = user
                                           )
                               )
                           )
					<cfif Len(Trim(arguments.reprovada_data_inicial)) and Len(Trim(arguments.reprovada_data_final))>
                       and ct.data_reprovacao between to_date('#arguments.reprovada_data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.reprovada_data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                    <cfelseif Len(Trim(arguments.reprovada_data_inicial))>
                       and ct.data_reprovacao >= to_date('#arguments.reprovada_data_inicial#', 'dd/mm/yyyy')
                    <cfelseif Len(Trim(arguments.reprovada_data_final))>
                       and ct.data_reprovacao <= to_date('#arguments.reprovada_data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
					</cfif>
				</cfif>
                   ) t
             order by t.data_emissao, t.lancto_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Verifica se usurio possui alada para liberao
	-- RAFAELPENCZKOSKI 13/01/2016 - ADICIONADO
	--->
	<cffunction name="get_alcada_liberacao_controle_usuario" access="remote" returntype="query" output="true">
		<cfargument name="OPERACAO" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct al.operacao, al.usuario, u.nome
              from oper.v$alcada_liberacao_controle al
             inner join kss.v$kss_usuarios u
                     on u.usuario = al.usuario 
            where al.valor_alcada > 0
              and al.usuario = user
            <cfif Len(Trim(arguments.OPERACAO)) >
              and al.operacao = '#arguments.OPERACAO#'
            </cfif>
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os itinerrios a terem taxas cobradas
    -- RAFAEL COSTA 30/10/2015 - CRIADO
    --->		
    <cffunction name="get_agregado_itinerarios" access="remote" returntype="query" output="true">
    	<cfargument name="placa_controle" required="yes">
        <cfargument name="placa_referencia" required="yes">
        <cfargument name="cod_pessoa_agregado" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ri.num_romaneio
                 , ri.rota_id
                 , ri.km_rota
                 , ro.descricao_rota
                 , ri.vazio_carregado
                 , decode(ri.vazio_carregado, 0 , 'Vazio', 1, 'Carregado') as vazio_carregado_descricao
                 , x.descricao_item
                 , x.valor as valor_km
                 , x.valor * ri.km_rota as valor
                 , x.tipo_cobranca
              from oper.v$romaneio r
             inner join oper.v$romaneio_itinerario ri
                on ri.num_romaneio = r.num_romaneio
             inner join oper.v$rota ro
                on ro.rota_id = ri.rota_id
		     inner join oper.v$romaneio_hist_veiculo rhv
                on rhv.num_romaneio = r.num_romaneio
               and rhv.placa_controle  = '#arguments.placa_controle#'
             inner join (select y.veiculo_id
                              , y.item_id
                              , nvl(nullif(y.valor, 0), (select atvp.valor
                                                           from oper.v$agreg_taxa_valor_padrao atvp
                                                          where atvp.agreg_taxa_valor_padrao_id = y.agreg_taxa_valor_padrao_id )
                                    ) as valor
                              , y.descricao_item
                              , y.itinerario_cobranca_tipo
                              , kss.fnc_ref_code('OPER', 'AGREG_TAXA_VALOR_PADRAO.ITINERARIO_COBRANCA_TIPO', y.itinerario_cobranca_tipo, 0) as tipo_cobranca
                                       , y.data_inicio_vigencia
                           from (select t.veiculo_id
                                      , t.item_id
                                      , max(t.valor) keep(dense_rank last order by t.data) as valor
                                      , (select max(atvp.itinerario_cobranca_tipo) keep(dense_rank last order by atvp.data_vigencia)
                                          from oper.v$agreg_taxa_valor_padrao atvp
                                         where atvp.item_id = t.item_id
                                           and atvp.data_cancelamento is null
                                           and atvp.data_vigencia <= sysdate
                                           ) as itinerario_cobranca_tipo
                                      , (select max(atvp.agreg_taxa_valor_padrao_id) keep(dense_rank last order by atvp.data_vigencia)
                                                          from oper.v$agreg_taxa_valor_padrao atvp
                                                         where atvp.item_id = t.item_id
                                                           and atvp.data_cancelamento is null
                                                           and atvp.data_vigencia <= sysdate) as agreg_taxa_valor_padrao_id
                                      , (select ctis.descricao
                                           from oper.v$contrato_transp_item_setup ctis
                                           where ctis.item_id = t.item_id ) as descricao_item
                                               , t.data as data_inicio_vigencia
                                   from oper.v$agreg_taxa_manut_carreta t
                                  inner join oper.v$veiculo v
                                     on v.veiculo_id = t.veiculo_id
                                  where v.placa = '#arguments.placa_referencia#'
                                    and t.data_cancelamento is null
                                    and t.data <= sysdate
                                           group by t.veiculo_id, t.item_id, t.data
                                  ) y ) x
                                         on( ( x.itinerario_cobranca_tipo in (1,2) and ri.vazio_carregado = 0)
                                or (x.itinerario_cobranca_tipo in (1,3) and ri.vazio_carregado = 1)
                                             )
                                         and x.data_inicio_vigencia <= r.data_inicio
             where 1 = 1
               and exists (select distinct vp.cod_pessoa
							 from oper.v$romaneio_hist_veiculo rhv
							inner join oper.v$veiculo_proprietario vp
							   on vp.placa = rhv.placa_controle
						    where rhv.num_romaneio = r.num_romaneio
							  and rhv.placa_controle = '#arguments.placa_controle#'
							  and rhv.data_inicio between vp.data_inicio and nvl(vp.data_fim, sysdate)
							  and vp.cod_pessoa = '#arguments.cod_pessoa_agregado#'
						      and exists (select 1
											from oper.v$veiculo_proprietario_atual vpa
										   inner join kss.v$unidade_negocio un 
										      on un.cod_pessoa = vpa.cod_pessoa
										   where vpa.placa = rhv.placa_referencia)
							 )
			   and r.data_inicio > kss.pkg_parametro.fnc_valor_data('M217-P0174')
               and (((select t.termo_id
						from agreg.v$termo t
				       where t.veiculo_id = oper.pkg_veiculo.fnc_veiculo_id('#arguments.placa_controle#')
						 and t.data_desagregacao is null) is null and ri.contrato_item_id is null)
                            or
                            (ri.contrato_item_id is null and not exists (select 1
                                                                           from agreg.v$taxa_config tc
                                                                          where tc.itinerario_id = ri.itinerario_id))
                            )
             order by r.data_inicio, ri.itinerario_id, x.descricao_item
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
    <!---
    -- PROPSITO
    -- Retorna os motivos de Cancelamento de Contrato
    -- WELLINGTONPEREIRA 04/07/2018 - CRIADO
    --->
    <cffunction name="get_motivo_cancelamento" access="remote" returntype="query" output="true">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mc.motivo_cancelamento_id
				 , mc.motivo
				 , mc.exige_detalhamento
				 , mc.numero_minimo_caracteres
				 , tpm.tipo_pagto_id
			  from pagfrete.v$motivo_cancelamento mc
			 inner join pagfrete.v$tipo_pagto_mapeamento tpm
				on tpm.id_registro_origem = mc.motivo_cancelamento_id
			   and tpm.id_tabela = 1
			 where 1 = 1
			 <cfif Len(Trim(arguments.TIPO_PAGTO_ID)) >
               and tpm.tipo_pagto_id = '#arguments.TIPO_PAGTO_ID#'
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca a quantidade de cpg em aberto do mesmo motorista
	-- RAFAEL 27/06/2018 - ADICIONADO
	--->
	<cffunction name="get_cpg_aberto" access="remote" returntype="query" output="true">
		<cfargument name="MOTORISTA_COD_PESSOA" required="no" default=""/>
		<cfargument name="PLACA_CONTROLE" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select sign(count(1)) as possui_cpg_aberto
			  from oper.v$contrato_transp ct
			 inner join oper.v$contrato_transp_pagar ctp
				on ctp.lancto_id = ct.lancto_id
			 where 1 = 1
			   and (1 = 2
				   <cfif Len(Trim(arguments.MOTORISTA_COD_PESSOA)) >
					or ct.motorista_cod_pessoa = #arguments.MOTORISTA_COD_PESSOA#
				   </cfif>
				   <cfif Len(Trim(arguments.PLACA_CONTROLE)) >
					or ct.placa_controle = '#arguments.PLACA_CONTROLE#'
				   </cfif>			   
				    )
			<cfif !Len(Trim(arguments.MOTORISTA_COD_PESSOA)) and !Len(Trim(arguments.PLACA_CONTROLE)) >
			   and 1 = 2
			</cfif> 
			   and ct.data_cancelamento is null 
			   and exists (select 1
							 from finan.v$finan_contas_pagar fcp
							where fcp.contas_pagar_id = ctp.contas_pagar_id 
							  and fcp.situacao <> 1
						   )
			   and not exists (select 1
                                 from oper.v$contrato_transp_cpg_aberto ctca
                                where ctca.lancto_id_anterior = ct.lancto_id
                                  and ctca.data_cancelamento is null )		   
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados dos cpg em aberto do mesmo motorista
	-- RAFAEL 05/07/2018 - ADICIONADO
	--->
	<cffunction name="get_cpg_aberto_dados" access="remote" returntype="query" output="true">
		<cfargument name="MOTORISTA_COD_PESSOA" required="no" default=""/>
		<cfargument name="PLACA_CONTROLE" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct ct.lancto_id
				 , ct.num_formulario
				 , ct.serie_formulario
				 , to_char(ct.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
				 , ct.num_romaneio
				 , ct.placa_controle
				 , ct.placa_referencia
				 , (select r.descricao_rota
					  from oper.v$rota r
					  where r.rota_id = ct.rota_id ) as rota
				 , (select p.razao_social
					  from kss.v$pessoa p
					 where p.cod_pessoa = ct.motorista_cod_pessoa ) as motorista
				 , (select p.cliente
					  from kss.v$pessoa p
					 where p.cod_pessoa = ct.cod_destinatario ) as destinatario
			  from oper.v$contrato_transp ct
			 inner join oper.v$contrato_transp_pagar ctp
				on ctp.lancto_id = ct.lancto_id
			 where 1 = 1
			   and (1 = 2
				   <cfif Len(Trim(arguments.MOTORISTA_COD_PESSOA)) >
					or ct.motorista_cod_pessoa = #arguments.MOTORISTA_COD_PESSOA#
				   </cfif>
				   <cfif Len(Trim(arguments.PLACA_CONTROLE)) >
					or ct.placa_controle = '#arguments.PLACA_CONTROLE#'
				   </cfif>			   
				    )
			<cfif !Len(Trim(arguments.MOTORISTA_COD_PESSOA)) and !Len(Trim(arguments.PLACA_CONTROLE)) >
			   and 1 = 2
			</cfif> 
			   and ct.data_cancelamento is null 
			   and exists (select 1
							 from finan.v$finan_contas_pagar fcp
							where fcp.contas_pagar_id = ctp.contas_pagar_id 
							  and fcp.situacao <> 1
						   )
			   and not exists (select 1
                                 from oper.v$contrato_transp_cpg_aberto ctca
                                where ctca.lancto_id_anterior = ct.lancto_id
                                  and ctca.data_cancelamento is null )
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados para a impressao da CFA
	-- CRISTOFER  28/04/2008
	--->		
	<cffunction name="get_cfa_print" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctf.cf_terceiro, 
                   ctf.cf_agregado, 
                   ctf.lancto_id, 
                   ctf.num_formulario, 
                   ctf.serie_formulario,
                   ctf.num_romaneio, 
                   ctf.previsao_chegada_dia, 
                   ctf.num_manifesto_ctrc_first, 
                   ctf.remetente, 
                   ctf.destinatario, 
                   ctf.origem, 
                   ctf.destino, 
                   ctf.proprietario_veiculo, 
                   ctf.proprietario_cnpj_cpf, 
                   ctf.placa_frota, 
                   ctf.proprietario_nit, 
                   ctf.proprietario_rg, 
                   ctf.motorista, 
                   ctf.cod_pessoa_filial, 
                   ctf.filial, 
                   ctf.cnpj_filial, 
                   ctf.data_emissao, 
                   ctf.descarga_por_conta, 
                   ctf.valor_total_servico, 
                   ctf.valor_carga_descarga, 
				   (select nvl(sum(cti.valor),0)
					  from oper.v$contrato_transp_item cti
					 where cti.lancto_id = ctf.lancto_id
					   and cti.item_id = oper.pkg_contrato_transp.fnc_get_tipo_taxa('ADTO_PEDAGIO')
					   and cti.compoe_frete = 1
					   and cti.data_cancelamento is null) as valor_pedagio, 
                   ctf.valor_servico_prestado,
				  (select nvl(sum(cti.valor),0)
                     from oper.v$contrato_transp_item cti
                    where cti.lancto_id = ctf.lancto_id
                      and cti.item_id <> oper.pkg_contrato_transp.fnc_get_tipo_taxa('ADTO_PEDAGIO')
                      and cti.adiantamento = 1
					  and cti.data_cancelamento is null) as valor_adiantamento,
				   (select nvl(sum(cti.valor),0)
					  from oper.v$contrato_transp_item cti
					 where cti.lancto_id = ctf.lancto_id
					   and cti.item_id in (oper.pkg_contrato_transp.fnc_get_tipo_taxa('PEDAGIO_NO_FRETE')
										  ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('ADTO_PEDAGIO'))
					   and cti.adiantamento = 1
					   and cti.data_cancelamento is null) as valor_adiantamento_pedagio, 
                   ctf.valor_adto_carga_descarga, 
                   ctf.valor_total_adto, 
                   ctf.valor_irrf, 
                   ctf.valor_inss, 
                   ctf.valor_sest_senat, 
                   ctf.valor_consulta_cadastro, 
                   ctf.valor_transf_acerto, 
                   ctf.saldo_pagar, 
                   ctf.valor_falta_avaria, 
                   ctf.saldo_liquido_pagar, 
                   ctf.valor_novo_saldo_pagar, 
                   ctf.observacao, 
                   ctf.observacao2, 
                   ctf.observacao_final, 
                   ctf.cfi,
                   ctf.tipo_contrato,
                   ctf.impresso,
                   to_char(ctf.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') data_cancelamento,
                   to_char(ctf.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao,
				   (select nvl(sum(it.valor),0)
			          from oper.v$contrato_transp_item it
					 where it.lancto_id = ctf.lancto_id
					   and it.data_cancelamento is null
					   and it.compoe_frete = 1
					   and it.desconto = 1
					   and it.adiantamento <> 1
					   and it.item_id not in (oper.pkg_contrato_transp.fnc_get_tipo_taxa('IRRF')
											 ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('SEST')
											 ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('SENAT')
											 ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('INSS'))) as total_descontos
              from oper.v$contrato_transp_form ctf
             where 1=1
             <cfif len(trim(arguments.lancto_id))>
               and ctf.lancto_id = #arguments.lancto_id#
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>
